import{s as Ut,o as $t,n as _e}from"../chunks/scheduler.182ea377.js";import{S as xt,i as jt,g as c,s as r,r as d,A as Wt,h as u,f as t,c as p,j as _t,u as M,x as h,k as yt,y as Ct,a as s,v as w,d as g,t as T,w as _}from"../chunks/index.abf12888.js";import{T as bt}from"../chunks/Tip.230e2334.js";import{C as F}from"../chunks/CodeBlock.57fe6e13.js";import{F as Jt,M as Ke}from"../chunks/Markdown.7a59e0fd.js";import{H as G}from"../chunks/Heading.16916d63.js";function vt(W){let n,m="The text-to-image fine-tuning script is experimental. It’s easy to overfit and run into issues like catastrophic forgetting. We recommend you explore different hyperparameters to get the best results on your dataset.";return{c(){n=c("p"),n.textContent=m},l(l){n=u(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-1r7jme8"&&(n.textContent=m)},m(l,f){s(l,n,f)},p:_e,d(l){l&&t(n)}}}function Rt(W){let n,m='Launch the <a href="https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image.py" rel="nofollow">PyTorch training script</a> for a fine-tuning run on the <a href="https://huggingface.co/datasets/lambdalabs/pokemon-blip-captions" rel="nofollow">Pokémon BLIP captions</a> dataset like this.',l,f,y='Specify the <code>MODEL_NAME</code> environment variable (either a Hub model repository id or a path to the directory containing the model weights) and pass it to the <a href="https://huggingface.co/docs/diffusers/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path" rel="nofollow"><code>pretrained_model_name_or_path</code></a> argument.',Z,b,I,J,E='To finetune on your own dataset, prepare the dataset according to the format required by 🤗 <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a>. You can <a href="https://huggingface.co/docs/datasets/image_dataset#upload-dataset-to-the-hub" rel="nofollow">upload your dataset to the Hub</a>, or you can <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow">prepare a local folder with your files</a>.',k,U,S="Modify the script if you want to use custom loading logic. We left pointers in the code in the appropriate places to help you. 🤗 The example script below shows how to finetune on a local dataset in <code>TRAIN_DIR</code> and where to save the model to in <code>OUTPUT_DIR</code>:",B,$,N,x,V,R,v=`<code>accelerate</code> allows for seamless multi-GPU training. Follow the instructions <a href="https://huggingface.co/docs/accelerate/basic_tutorials/launch" rel="nofollow">here</a>
for running distributed training with <code>accelerate</code>. Here is an example command:`,L,C,X;return b=new F({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBkYXRhc2V0X25hbWUlM0QlMjJsYW1iZGFsYWJzJTJGcG9rZW1vbi1ibGlwLWNhcHRpb25zJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMCUyMHRyYWluX3RleHRfdG9faW1hZ2UucHklMjAlNUMlMEElMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0ZGF0YXNldF9uYW1lJTIwJTVDJTBBJTIwJTIwLS11c2VfZW1hJTIwJTVDJTBBJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwLS1jZW50ZXJfY3JvcCUyMC0tcmFuZG9tX2ZsaXAlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxJTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0Q0JTIwJTVDJTBBJTIwJTIwLS1ncmFkaWVudF9jaGVja3BvaW50aW5nJTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QxNTAwMCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTA1JTIwJTVDJTBBJTIwJTIwLS1tYXhfZ3JhZF9ub3JtJTNEMSUyMCU1QyUwQSUyMCUyMC0tbHJfc2NoZWR1bGVyJTNEJTIyY29uc3RhbnQlMjIlMjAtLWxyX3dhcm11cF9zdGVwcyUzRDAlMjAlNUMlMEElMjAlMjAtLW91dHB1dF9kaXIlM0QlMjJzZC1wb2tlbW9uLW1vZGVsJTIyJTIwJTVDJTBBJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> dataset_name=<span class="hljs-string">&quot;lambdalabs/pokemon-blip-captions&quot;</span>

accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>  train_text_to_image.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --dataset_name=<span class="hljs-variable">$dataset_name</span> \\
  --use_ema \\
  --resolution=512 --center_crop --random_flip \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-string">&quot;sd-pokemon-model&quot;</span> \\
  --push_to_hub`,wrap:!1}}),$=new F({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBUUkFJTl9ESVIlM0QlMjJwYXRoX3RvX3lvdXJfZGF0YXNldCUyMiUwQWV4cG9ydCUyME9VVFBVVF9ESVIlM0QlMjJwYXRoX3RvX3NhdmVfbW9kZWwlMjIlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwdHJhaW5fdGV4dF90b19pbWFnZS5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9kYXRhX2RpciUzRCUyNFRSQUlOX0RJUiUyMCU1QyUwQSUyMCUyMC0tdXNlX2VtYSUyMCU1QyUwQSUyMCUyMC0tcmVzb2x1dGlvbiUzRDUxMiUyMC0tY2VudGVyX2Nyb3AlMjAtLXJhbmRvbV9mbGlwJTIwJTVDJTBBJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMSUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNENCUyMCU1QyUwQSUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMCU1QyUwQSUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMCU1QyUwQSUyMCUyMC0tbWF4X3RyYWluX3N0ZXBzJTNEMTUwMDAlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS0wNSUyMCU1QyUwQSUyMCUyMC0tbWF4X2dyYWRfbm9ybSUzRDElMjAlNUMlMEElMjAlMjAtLWxyX3NjaGVkdWxlciUzRCUyMmNvbnN0YW50JTIyJTIwJTBBJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTI0JTdCT1VUUFVUX0RJUiU3RCUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> TRAIN_DIR=<span class="hljs-string">&quot;path_to_your_dataset&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path_to_save_model&quot;</span>

accelerate launch train_text_to_image.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$TRAIN_DIR</span> \\
  --use_ema \\
  --resolution=512 --center_crop --random_flip \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> 
  --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-variable">\${OUTPUT_DIR}</span> \\
  --push_to_hub`,wrap:!1}}),x=new G({props:{title:"Training with multiple GPUs",local:"training-with-multiple-gpus",headingTag:"h4"}}),C=new F({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMkNvbXBWaXMlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQlMjIlMEFleHBvcnQlMjBkYXRhc2V0X25hbWUlM0QlMjJsYW1iZGFsYWJzJTJGcG9rZW1vbi1ibGlwLWNhcHRpb25zJTIyJTBBJTBBYWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMC0tbXVsdGlfZ3B1JTIwJTIwdHJhaW5fdGV4dF90b19pbWFnZS5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0X25hbWUlM0QlMjRkYXRhc2V0X25hbWUlMjAlNUMlMEElMjAlMjAtLXVzZV9lbWElMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAtLWNlbnRlcl9jcm9wJTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTIwJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtMDUlMjAlNUMlMEElMjAlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwJTVDJTBBJTIwJTIwLS1scl9zY2hlZHVsZXIlM0QlMjJjb25zdGFudCUyMiUyMCU1QyUwQSUyMCUyMC0tbHJfd2FybXVwX3N0ZXBzJTNEMCUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyMnNkLXBva2Vtb24tbW9kZWwlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
<span class="hljs-built_in">export</span> dataset_name=<span class="hljs-string">&quot;lambdalabs/pokemon-blip-captions&quot;</span>

accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> --multi_gpu  train_text_to_image.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --dataset_name=<span class="hljs-variable">$dataset_name</span> \\
  --use_ema \\
  --resolution=512 --center_crop --random_flip \\
  --train_batch_size=1 \\
  --gradient_accumulation_steps=4 \\
  --gradient_checkpointing \\
  --max_train_steps=15000 \\ 
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --lr_scheduler=<span class="hljs-string">&quot;constant&quot;</span> \\
  --lr_warmup_steps=0 \\
  --output_dir=<span class="hljs-string">&quot;sd-pokemon-model&quot;</span> \\
  --push_to_hub`,wrap:!1}}),{c(){n=c("p"),n.innerHTML=m,l=r(),f=c("p"),f.innerHTML=y,Z=r(),d(b.$$.fragment),I=r(),J=c("p"),J.innerHTML=E,k=r(),U=c("p"),U.innerHTML=S,B=r(),d($.$$.fragment),N=r(),d(x.$$.fragment),V=r(),R=c("p"),R.innerHTML=v,L=r(),d(C.$$.fragment)},l(o){n=u(o,"P",{"data-svelte-h":!0}),h(n)!=="svelte-1c8dc3y"&&(n.innerHTML=m),l=p(o),f=u(o,"P",{"data-svelte-h":!0}),h(f)!=="svelte-sj32mn"&&(f.innerHTML=y),Z=p(o),M(b.$$.fragment,o),I=p(o),J=u(o,"P",{"data-svelte-h":!0}),h(J)!=="svelte-lnytxb"&&(J.innerHTML=E),k=p(o),U=u(o,"P",{"data-svelte-h":!0}),h(U)!=="svelte-2w7isb"&&(U.innerHTML=S),B=p(o),M($.$$.fragment,o),N=p(o),M(x.$$.fragment,o),V=p(o),R=u(o,"P",{"data-svelte-h":!0}),h(R)!=="svelte-1tkye3l"&&(R.innerHTML=v),L=p(o),M(C.$$.fragment,o)},m(o,i){s(o,n,i),s(o,l,i),s(o,f,i),s(o,Z,i),w(b,o,i),s(o,I,i),s(o,J,i),s(o,k,i),s(o,U,i),s(o,B,i),w($,o,i),s(o,N,i),w(x,o,i),s(o,V,i),s(o,R,i),s(o,L,i),w(C,o,i),X=!0},p:_e,i(o){X||(g(b.$$.fragment,o),g($.$$.fragment,o),g(x.$$.fragment,o),g(C.$$.fragment,o),X=!0)},o(o){T(b.$$.fragment,o),T($.$$.fragment,o),T(x.$$.fragment,o),T(C.$$.fragment,o),X=!1},d(o){o&&(t(n),t(l),t(f),t(Z),t(I),t(J),t(k),t(U),t(B),t(N),t(V),t(R),t(L)),_(b,o),_($,o),_(x,o),_(C,o)}}}function Xt(W){let n,m;return n=new Ke({props:{$$slots:{default:[Rt]},$$scope:{ctx:W}}}),{c(){d(n.$$.fragment)},l(l){M(n.$$.fragment,l)},m(l,f){w(n,l,f),m=!0},p(l,f){const y={};f&2&&(y.$$scope={dirty:f,ctx:l}),n.$set(y)},i(l){m||(g(n.$$.fragment,l),m=!0)},o(l){T(n.$$.fragment,l),m=!1},d(l){_(n,l)}}}function Zt(W){let n,m='With Flax, it’s possible to train a Stable Diffusion model faster on TPUs and GPUs thanks to <a href="https://github.com/duongna21" rel="nofollow">@duongna211</a>. This is very efficient on TPU hardware but works great on GPUs too. The Flax training script doesn’t support features like gradient checkpointing or gradient accumulation yet, so you’ll need a GPU with at least 30GB of memory or a TPU v3.',l,f,y="Before running the script, make sure you have the requirements installed:",Z,b,I,J,E='Specify the <code>MODEL_NAME</code> environment variable (either a Hub model repository id or a path to the directory containing the model weights) and pass it to the <a href="https://huggingface.co/docs/diffusers/en/api/diffusion_pipeline#diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path" rel="nofollow"><code>pretrained_model_name_or_path</code></a> argument.',k,U,S='Now you can launch the <a href="https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image_flax.py" rel="nofollow">Flax training script</a> like this:',B,$,N,x,V='To finetune on your own dataset, prepare the dataset according to the format required by 🤗 <a href="https://huggingface.co/docs/datasets/index" rel="nofollow">Datasets</a>. You can <a href="https://huggingface.co/docs/datasets/image_dataset#upload-dataset-to-the-hub" rel="nofollow">upload your dataset to the Hub</a>, or you can <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow">prepare a local folder with your files</a>.',R,v,L="Modify the script if you want to use custom loading logic. We left pointers in the code in the appropriate places to help you. 🤗 The example script below shows how to finetune on a local dataset in <code>TRAIN_DIR</code>:",C,X,o;return b=new F({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwLXIlMjByZXF1aXJlbWVudHNfZmxheC50eHQ=",highlighted:"pip install -U -r requirements_flax.txt",wrap:!1}}),$=new F({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwZGF0YXNldF9uYW1lJTNEJTIybGFtYmRhbGFicyUyRnBva2Vtb24tYmxpcC1jYXB0aW9ucyUyMiUwQSUwQXB5dGhvbiUyMHRyYWluX3RleHRfdG9faW1hZ2VfZmxheC5weSUyMCU1QyUwQSUyMCUyMC0tcHJldHJhaW5lZF9tb2RlbF9uYW1lX29yX3BhdGglM0QlMjRNT0RFTF9OQU1FJTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0X25hbWUlM0QlMjRkYXRhc2V0X25hbWUlMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAtLWNlbnRlcl9jcm9wJTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDElMjAlNUMlMEElMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtMDUlMjAlNUMlMEElMjAlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEJTIyc2QtcG9rZW1vbi1tb2RlbCUyMiUyMCU1QyUwQSUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> dataset_name=<span class="hljs-string">&quot;lambdalabs/pokemon-blip-captions&quot;</span>

python train_text_to_image_flax.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --dataset_name=<span class="hljs-variable">$dataset_name</span> \\
  --resolution=512 --center_crop --random_flip \\
  --train_batch_size=1 \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --output_dir=<span class="hljs-string">&quot;sd-pokemon-model&quot;</span> \\
  --push_to_hub`,wrap:!1}}),X=new F({props:{code:"ZXhwb3J0JTIwTU9ERUxfTkFNRSUzRCUyMmR1b25nbmElMkZzdGFibGUtZGlmZnVzaW9uLXYxLTQtZmxheCUyMiUwQWV4cG9ydCUyMFRSQUlOX0RJUiUzRCUyMnBhdGhfdG9feW91cl9kYXRhc2V0JTIyJTBBJTBBcHl0aG9uJTIwdHJhaW5fdGV4dF90b19pbWFnZV9mbGF4LnB5JTIwJTVDJTBBJTIwJTIwLS1wcmV0cmFpbmVkX21vZGVsX25hbWVfb3JfcGF0aCUzRCUyNE1PREVMX05BTUUlMjAlNUMlMEElMjAlMjAtLXRyYWluX2RhdGFfZGlyJTNEJTI0VFJBSU5fRElSJTIwJTVDJTBBJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwLS1jZW50ZXJfY3JvcCUyMC0tcmFuZG9tX2ZsaXAlMjAlNUMlMEElMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxJTIwJTVDJTBBJTIwJTIwLS1taXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTIwJTVDJTBBJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QxNTAwMCUyMCU1QyUwQSUyMCUyMC0tbGVhcm5pbmdfcmF0ZSUzRDFlLTA1JTIwJTVDJTBBJTIwJTIwLS1tYXhfZ3JhZF9ub3JtJTNEMSUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUzRCUyMnNkLXBva2Vtb24tbW9kZWwlMjIlMjAlNUMlMEElMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_NAME=<span class="hljs-string">&quot;duongna/stable-diffusion-v1-4-flax&quot;</span>
<span class="hljs-built_in">export</span> TRAIN_DIR=<span class="hljs-string">&quot;path_to_your_dataset&quot;</span>

python train_text_to_image_flax.py \\
  --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
  --train_data_dir=<span class="hljs-variable">$TRAIN_DIR</span> \\
  --resolution=512 --center_crop --random_flip \\
  --train_batch_size=1 \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> \\
  --max_train_steps=15000 \\
  --learning_rate=1e-05 \\
  --max_grad_norm=1 \\
  --output_dir=<span class="hljs-string">&quot;sd-pokemon-model&quot;</span> \\
  --push_to_hub`,wrap:!1}}),{c(){n=c("p"),n.innerHTML=m,l=r(),f=c("p"),f.textContent=y,Z=r(),d(b.$$.fragment),I=r(),J=c("p"),J.innerHTML=E,k=r(),U=c("p"),U.innerHTML=S,B=r(),d($.$$.fragment),N=r(),x=c("p"),x.innerHTML=V,R=r(),v=c("p"),v.innerHTML=L,C=r(),d(X.$$.fragment)},l(i){n=u(i,"P",{"data-svelte-h":!0}),h(n)!=="svelte-1pqr8vw"&&(n.innerHTML=m),l=p(i),f=u(i,"P",{"data-svelte-h":!0}),h(f)!=="svelte-4s2veb"&&(f.textContent=y),Z=p(i),M(b.$$.fragment,i),I=p(i),J=u(i,"P",{"data-svelte-h":!0}),h(J)!=="svelte-sj32mn"&&(J.innerHTML=E),k=p(i),U=u(i,"P",{"data-svelte-h":!0}),h(U)!=="svelte-88nuiv"&&(U.innerHTML=S),B=p(i),M($.$$.fragment,i),N=p(i),x=u(i,"P",{"data-svelte-h":!0}),h(x)!=="svelte-lnytxb"&&(x.innerHTML=V),R=p(i),v=u(i,"P",{"data-svelte-h":!0}),h(v)!=="svelte-icdnzn"&&(v.innerHTML=L),C=p(i),M(X.$$.fragment,i)},m(i,j){s(i,n,j),s(i,l,j),s(i,f,j),s(i,Z,j),w(b,i,j),s(i,I,j),s(i,J,j),s(i,k,j),s(i,U,j),s(i,B,j),w($,i,j),s(i,N,j),s(i,x,j),s(i,R,j),s(i,v,j),s(i,C,j),w(X,i,j),o=!0},p:_e,i(i){o||(g(b.$$.fragment,i),g($.$$.fragment,i),g(X.$$.fragment,i),o=!0)},o(i){T(b.$$.fragment,i),T($.$$.fragment,i),T(X.$$.fragment,i),o=!1},d(i){i&&(t(n),t(l),t(f),t(Z),t(I),t(J),t(k),t(U),t(B),t(N),t(x),t(R),t(v),t(C)),_(b,i),_($,i),_(X,i)}}}function It(W){let n,m;return n=new Ke({props:{$$slots:{default:[Zt]},$$scope:{ctx:W}}}),{c(){d(n.$$.fragment)},l(l){M(n.$$.fragment,l)},m(l,f){w(n,l,f),m=!0},p(l,f){const y={};f&2&&(y.$$scope={dirty:f,ctx:l}),n.$set(y)},i(l){m||(g(n.$$.fragment,l),m=!0)},o(l){T(n.$$.fragment,l),m=!1},d(l){_(n,l)}}}function kt(W){let n,m="Training with Min-SNR weighting strategy is only supported in PyTorch.";return{c(){n=c("p"),n.textContent=m},l(l){n=u(l,"P",{"data-svelte-h":!0}),h(n)!=="svelte-7vj2or"&&(n.textContent=m)},m(l,f){s(l,n,f)},p:_e,d(l){l&&t(n)}}}function Bt(W){let n,m;return n=new F({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnBhdGhfdG9fc2F2ZWRfbW9kZWwlMjIlMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEJTIyeW9kYSUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyeW9kYS1wb2tlbW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

model_path = <span class="hljs-string">&quot;path_to_saved_model&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_path, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(prompt=<span class="hljs-string">&quot;yoda&quot;</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;yoda-pokemon.png&quot;</span>)`,wrap:!1}}),{c(){d(n.$$.fragment)},l(l){M(n.$$.fragment,l)},m(l,f){w(n,l,f),m=!0},p:_e,i(l){m||(g(n.$$.fragment,l),m=!0)},o(l){T(n.$$.fragment,l),m=!1},d(l){_(n,l)}}}function Nt(W){let n,m;return n=new Ke({props:{$$slots:{default:[Bt]},$$scope:{ctx:W}}}),{c(){d(n.$$.fragment)},l(l){M(n.$$.fragment,l)},m(l,f){w(n,l,f),m=!0},p(l,f){const y={};f&2&&(y.$$scope={dirty:f,ctx:l}),n.$set(y)},i(l){m||(g(n.$$.fragment,l),m=!0)},o(l){T(n.$$.fragment,l),m=!1},d(l){_(n,l)}}}function Ft(W){let n,m;return n=new F({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfcGF0aCUyMCUzRCUyMCUyMnBhdGhfdG9fc2F2ZWRfbW9kZWwlMjIlMEFwaXBlJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9wYXRoJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyeW9kYSUyMHBva2Vtb24lMjIlMEFwcm5nX3NlZWQlMjAlM0QlMjBqYXgucmFuZG9tLlBSTkdLZXkoMCklMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwNTAlMEElMEFudW1fc2FtcGxlcyUyMCUzRCUyMGpheC5kZXZpY2VfY291bnQoKSUwQXByb21wdCUyMCUzRCUyMG51bV9zYW1wbGVzJTIwKiUyMCU1QnByb21wdCU1RCUwQXByb21wdF9pZHMlMjAlM0QlMjBwaXBlbGluZS5wcmVwYXJlX2lucHV0cyhwcm9tcHQpJTBBJTBBJTIzJTIwc2hhcmQlMjBpbnB1dHMlMjBhbmQlMjBybmclMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkpJTBBaW1hZ2Uuc2F2ZSglMjJ5b2RhLXBva2Vtb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

model_path = <span class="hljs-string">&quot;path_to_saved_model&quot;</span>
pipe, params = FlaxStableDiffusionPipeline.from_pretrained(model_path, dtype=jax.numpy.bfloat16)

prompt = <span class="hljs-string">&quot;yoda pokemon&quot;</span>
prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">50</span>

num_samples = jax.device_count()
prompt = num_samples * [prompt]
prompt_ids = pipeline.prepare_inputs(prompt)

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))
image.save(<span class="hljs-string">&quot;yoda-pokemon.png&quot;</span>)`,wrap:!1}}),{c(){d(n.$$.fragment)},l(l){M(n.$$.fragment,l)},m(l,f){w(n,l,f),m=!0},p:_e,i(l){m||(g(n.$$.fragment,l),m=!0)},o(l){T(n.$$.fragment,l),m=!1},d(l){_(n,l)}}}function Lt(W){let n,m;return n=new Ke({props:{$$slots:{default:[Ft]},$$scope:{ctx:W}}}),{c(){d(n.$$.fragment)},l(l){M(n.$$.fragment,l)},m(l,f){w(n,l,f),m=!0},p(l,f){const y={};f&2&&(y.$$scope={dirty:f,ctx:l}),n.$set(y)},i(l){m||(g(n.$$.fragment,l),m=!0)},o(l){T(n.$$.fragment,l),m=!1},d(l){_(n,l)}}}function Gt(W){let n,m,l,f,y,Z,b,I,J,E='Text-to-image models like Stable Diffusion generate an image from a text prompt. This guide will show you how to finetune the <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow"><code>CompVis/stable-diffusion-v1-4</code></a> model on your own dataset with PyTorch and Flax. All the training scripts for text-to-image finetuning used in this guide can be found in this <a href="https://github.com/huggingface/diffusers/tree/main/examples/text_to_image" rel="nofollow">repository</a> if you’re interested in taking a closer look.',k,U,S="Before running the scripts, make sure to install the library’s training dependencies:",B,$,N,x,V='And initialize an <a href="https://github.com/huggingface/accelerate/" rel="nofollow">🤗 Accelerate</a> environment with:',R,v,L,C,X="If you have already cloned the repo, then you won’t need to go through these steps. Instead, you can pass the path to your local checkout to the training script and it will be loaded from there.",o,i,j,Q,et='Using <code>gradient_checkpointing</code> and <code>mixed_precision</code>, it should be possible to finetune the model on a single 24GB GPU. For higher <code>batch_size</code>’s and faster training, it’s better to use GPUs with more than 30GB of GPU memory. You can also use JAX/Flax for fine-tuning on TPUs or GPUs, which will be covered <a href="#flax-jax-finetuning">below</a>.',be,z,tt='You can reduce your memory footprint even more by enabling memory efficient attention with xFormers. Make sure you have <a href="./optimization/xformers">xFormers installed</a> and pass the <code>--enable_xformers_memory_efficient_attention</code> flag to the training script.',Je,D,lt="xFormers is not available for Flax.",Ue,q,$e,P,at="Store your model on the Hub by adding the following argument to the training script:",xe,O,je,K,We,ee,nt="It is a good idea to regularly save checkpoints in case anything happens during training. To save a checkpoint, pass the following argument to the training script:",Ce,te,ve,le,st="Every 500 steps, the full training state is saved in a subfolder in the <code>output_dir</code>. The checkpoint has the format <code>checkpoint-</code> followed by the number of steps trained so far. For example, <code>checkpoint-1500</code> is a checkpoint saved after 1500 training steps.",Re,ae,it="To load a checkpoint to resume training, pass the argument <code>--resume_from_checkpoint</code> to the training script and specify the checkpoint you want to resume from. For example, the following argument resumes training from the checkpoint saved after 1500 training steps:",Xe,ne,Ze,se,Ie,H,ke,ie,Be,oe,ot=`We support training with the Min-SNR weighting strategy proposed in <a href="https://arxiv.org/abs/2303.09556" rel="nofollow">Efficient Diffusion Training via Min-SNR Weighting Strategy</a> which helps to achieve faster convergence
by rebalancing the loss. In order to use it, one needs to set the <code>--snr_gamma</code> argument. The recommended
value when using it is 5.0.`,Ne,re,rt='You can find <a href="https://wandb.ai/sayakpaul/text2image-finetune-minsnr" rel="nofollow">this project on Weights and Biases</a> that compares the loss surfaces of the following setups:',Fe,pe,pt="<li>Training without the Min-SNR weighting strategy</li> <li>Training with the Min-SNR weighting strategy (<code>snr_gamma</code> set to 5.0)</li> <li>Training with the Min-SNR weighting strategy (<code>snr_gamma</code> set to 1.0)</li>",Le,fe,ft="For our small Pokemons dataset, the effects of Min-SNR weighting strategy might not appear to be pronounced, but for larger datasets, we believe the effects will be more pronounced.",Ge,me,mt="Also, note that in this example, we either predict <code>epsilon</code> (i.e., the noise) or the <code>v_prediction</code>. For both of these cases, the formulation of the Min-SNR weighting strategy that we have used holds.",Ve,Y,Ee,ce,Se,ue,ct='You can also use Low-Rank Adaptation of Large Language Models (LoRA), a fine-tuning technique for accelerating training large models, for fine-tuning text-to-image models. For more details, take a look at the <a href="lora#text-to-image">LoRA training</a> guide.',He,he,Ye,de,ut='Now you can load the fine-tuned model for inference by passing the model path or model name on the Hub to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>:',Ae,A,Qe,Me,ze,we,ht='<li>We support fine-tuning the UNet shipped in <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> via the <code>train_text_to_image_sdxl.py</code> script. Please refer to the docs <a href="https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/README_sdxl.md" rel="nofollow">here</a>.</li> <li>We also support fine-tuning of the UNet and Text Encoder shipped in <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> with LoRA via the <code>train_text_to_image_lora_sdxl.py</code> script. Please refer to the docs <a href="https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/README_sdxl.md" rel="nofollow">here</a>.</li>',De,ge,qe,Te,dt='<li>We support fine-tuning both the decoder and prior in Kandinsky2.2 with the <code>train_text_to_image_prior.py</code> and <code>train_text_to_image_decoder.py</code> scripts. LoRA support is also included. Please refer to the docs <a href="https://github.com/huggingface/diffusers/blob/main/examples/kandinsky2_2/text_to_image/README_sdxl.md" rel="nofollow">here</a>.</li>',Pe,ye,Oe;return y=new G({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),b=new bt({props:{warning:!0,$$slots:{default:[vt]},$$scope:{ctx:W}}}),$=new F({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGZGlmZnVzZXJzLmdpdCUwQXBpcCUyMGluc3RhbGwlMjAtVSUyMC1yJTIwcmVxdWlyZW1lbnRzLnR4dA==",highlighted:`pip install git+https://github.com/huggingface/diffusers.git
pip install -U -r requirements.txt`,wrap:!1}}),v=new F({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),i=new G({props:{title:"Hardware requirements",local:"hardware-requirements",headingTag:"h2"}}),q=new G({props:{title:"Upload model to Hub",local:"upload-model-to-hub",headingTag:"h2"}}),O=new F({props:{code:"JTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:"  --push_to_hub",wrap:!1}}),K=new G({props:{title:"Save and load checkpoints",local:"save-and-load-checkpoints",headingTag:"h2"}}),te=new F({props:{code:"JTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAw",highlighted:"  --checkpointing_steps=500",wrap:!1}}),ne=new F({props:{code:"JTIwJTIwLS1yZXN1bWVfZnJvbV9jaGVja3BvaW50JTNEJTIyY2hlY2twb2ludC0xNTAwJTIy",highlighted:'  --resume_from_checkpoint=<span class="hljs-string">&quot;checkpoint-1500&quot;</span>',wrap:!1}}),se=new G({props:{title:"Fine-tuning",local:"fine-tuning",headingTag:"h2"}}),H=new Jt({props:{pytorch:!0,tensorflow:!1,jax:!0,$$slots:{jax:[It],pytorch:[Xt]},$$scope:{ctx:W}}}),ie=new G({props:{title:"Training with Min-SNR weighting",local:"training-with-min-snr-weighting",headingTag:"h2"}}),Y=new bt({props:{warning:!0,$$slots:{default:[kt]},$$scope:{ctx:W}}}),ce=new G({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),he=new G({props:{title:"Inference",local:"inference",headingTag:"h2"}}),A=new Jt({props:{pytorch:!0,tensorflow:!1,jax:!0,$$slots:{jax:[Lt],pytorch:[Nt]},$$scope:{ctx:W}}}),Me=new G({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),ge=new G({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h2"}}),{c(){n=c("meta"),m=r(),l=c("p"),f=r(),d(y.$$.fragment),Z=r(),d(b.$$.fragment),I=r(),J=c("p"),J.innerHTML=E,k=r(),U=c("p"),U.textContent=S,B=r(),d($.$$.fragment),N=r(),x=c("p"),x.innerHTML=V,R=r(),d(v.$$.fragment),L=r(),C=c("p"),C.textContent=X,o=r(),d(i.$$.fragment),j=r(),Q=c("p"),Q.innerHTML=et,be=r(),z=c("p"),z.innerHTML=tt,Je=r(),D=c("p"),D.textContent=lt,Ue=r(),d(q.$$.fragment),$e=r(),P=c("p"),P.textContent=at,xe=r(),d(O.$$.fragment),je=r(),d(K.$$.fragment),We=r(),ee=c("p"),ee.textContent=nt,Ce=r(),d(te.$$.fragment),ve=r(),le=c("p"),le.innerHTML=st,Re=r(),ae=c("p"),ae.innerHTML=it,Xe=r(),d(ne.$$.fragment),Ze=r(),d(se.$$.fragment),Ie=r(),d(H.$$.fragment),ke=r(),d(ie.$$.fragment),Be=r(),oe=c("p"),oe.innerHTML=ot,Ne=r(),re=c("p"),re.innerHTML=rt,Fe=r(),pe=c("ul"),pe.innerHTML=pt,Le=r(),fe=c("p"),fe.textContent=ft,Ge=r(),me=c("p"),me.innerHTML=mt,Ve=r(),d(Y.$$.fragment),Ee=r(),d(ce.$$.fragment),Se=r(),ue=c("p"),ue.innerHTML=ct,He=r(),d(he.$$.fragment),Ye=r(),de=c("p"),de.innerHTML=ut,Ae=r(),d(A.$$.fragment),Qe=r(),d(Me.$$.fragment),ze=r(),we=c("ul"),we.innerHTML=ht,De=r(),d(ge.$$.fragment),qe=r(),Te=c("ul"),Te.innerHTML=dt,Pe=r(),ye=c("p"),this.h()},l(e){const a=Wt("svelte-u9bgzb",document.head);n=u(a,"META",{name:!0,content:!0}),a.forEach(t),m=p(e),l=u(e,"P",{}),_t(l).forEach(t),f=p(e),M(y.$$.fragment,e),Z=p(e),M(b.$$.fragment,e),I=p(e),J=u(e,"P",{"data-svelte-h":!0}),h(J)!=="svelte-qwaawa"&&(J.innerHTML=E),k=p(e),U=u(e,"P",{"data-svelte-h":!0}),h(U)!=="svelte-19lpyev"&&(U.textContent=S),B=p(e),M($.$$.fragment,e),N=p(e),x=u(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1ag5t4d"&&(x.innerHTML=V),R=p(e),M(v.$$.fragment,e),L=p(e),C=u(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-30co6v"&&(C.textContent=X),o=p(e),M(i.$$.fragment,e),j=p(e),Q=u(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-bads23"&&(Q.innerHTML=et),be=p(e),z=u(e,"P",{"data-svelte-h":!0}),h(z)!=="svelte-878dfi"&&(z.innerHTML=tt),Je=p(e),D=u(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-14kw3cg"&&(D.textContent=lt),Ue=p(e),M(q.$$.fragment,e),$e=p(e),P=u(e,"P",{"data-svelte-h":!0}),h(P)!=="svelte-wjrlv4"&&(P.textContent=at),xe=p(e),M(O.$$.fragment,e),je=p(e),M(K.$$.fragment,e),We=p(e),ee=u(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-1p6not5"&&(ee.textContent=nt),Ce=p(e),M(te.$$.fragment,e),ve=p(e),le=u(e,"P",{"data-svelte-h":!0}),h(le)!=="svelte-cxrko5"&&(le.innerHTML=st),Re=p(e),ae=u(e,"P",{"data-svelte-h":!0}),h(ae)!=="svelte-1e68bol"&&(ae.innerHTML=it),Xe=p(e),M(ne.$$.fragment,e),Ze=p(e),M(se.$$.fragment,e),Ie=p(e),M(H.$$.fragment,e),ke=p(e),M(ie.$$.fragment,e),Be=p(e),oe=u(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-w60ll"&&(oe.innerHTML=ot),Ne=p(e),re=u(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-17gi90z"&&(re.innerHTML=rt),Fe=p(e),pe=u(e,"UL",{"data-svelte-h":!0}),h(pe)!=="svelte-m3k44n"&&(pe.innerHTML=pt),Le=p(e),fe=u(e,"P",{"data-svelte-h":!0}),h(fe)!=="svelte-e4zved"&&(fe.textContent=ft),Ge=p(e),me=u(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-1irr876"&&(me.innerHTML=mt),Ve=p(e),M(Y.$$.fragment,e),Ee=p(e),M(ce.$$.fragment,e),Se=p(e),ue=u(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-1hd7rfl"&&(ue.innerHTML=ct),He=p(e),M(he.$$.fragment,e),Ye=p(e),de=u(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-1afmd8k"&&(de.innerHTML=ut),Ae=p(e),M(A.$$.fragment,e),Qe=p(e),M(Me.$$.fragment,e),ze=p(e),we=u(e,"UL",{"data-svelte-h":!0}),h(we)!=="svelte-1etdt5b"&&(we.innerHTML=ht),De=p(e),M(ge.$$.fragment,e),qe=p(e),Te=u(e,"UL",{"data-svelte-h":!0}),h(Te)!=="svelte-vbtspk"&&(Te.innerHTML=dt),Pe=p(e),ye=u(e,"P",{}),_t(ye).forEach(t),this.h()},h(){yt(n,"name","hf:doc:metadata"),yt(n,"content",Vt)},m(e,a){Ct(document.head,n),s(e,m,a),s(e,l,a),s(e,f,a),w(y,e,a),s(e,Z,a),w(b,e,a),s(e,I,a),s(e,J,a),s(e,k,a),s(e,U,a),s(e,B,a),w($,e,a),s(e,N,a),s(e,x,a),s(e,R,a),w(v,e,a),s(e,L,a),s(e,C,a),s(e,o,a),w(i,e,a),s(e,j,a),s(e,Q,a),s(e,be,a),s(e,z,a),s(e,Je,a),s(e,D,a),s(e,Ue,a),w(q,e,a),s(e,$e,a),s(e,P,a),s(e,xe,a),w(O,e,a),s(e,je,a),w(K,e,a),s(e,We,a),s(e,ee,a),s(e,Ce,a),w(te,e,a),s(e,ve,a),s(e,le,a),s(e,Re,a),s(e,ae,a),s(e,Xe,a),w(ne,e,a),s(e,Ze,a),w(se,e,a),s(e,Ie,a),w(H,e,a),s(e,ke,a),w(ie,e,a),s(e,Be,a),s(e,oe,a),s(e,Ne,a),s(e,re,a),s(e,Fe,a),s(e,pe,a),s(e,Le,a),s(e,fe,a),s(e,Ge,a),s(e,me,a),s(e,Ve,a),w(Y,e,a),s(e,Ee,a),w(ce,e,a),s(e,Se,a),s(e,ue,a),s(e,He,a),w(he,e,a),s(e,Ye,a),s(e,de,a),s(e,Ae,a),w(A,e,a),s(e,Qe,a),w(Me,e,a),s(e,ze,a),s(e,we,a),s(e,De,a),w(ge,e,a),s(e,qe,a),s(e,Te,a),s(e,Pe,a),s(e,ye,a),Oe=!0},p(e,[a]){const Mt={};a&2&&(Mt.$$scope={dirty:a,ctx:e}),b.$set(Mt);const wt={};a&2&&(wt.$$scope={dirty:a,ctx:e}),H.$set(wt);const gt={};a&2&&(gt.$$scope={dirty:a,ctx:e}),Y.$set(gt);const Tt={};a&2&&(Tt.$$scope={dirty:a,ctx:e}),A.$set(Tt)},i(e){Oe||(g(y.$$.fragment,e),g(b.$$.fragment,e),g($.$$.fragment,e),g(v.$$.fragment,e),g(i.$$.fragment,e),g(q.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(H.$$.fragment,e),g(ie.$$.fragment,e),g(Y.$$.fragment,e),g(ce.$$.fragment,e),g(he.$$.fragment,e),g(A.$$.fragment,e),g(Me.$$.fragment,e),g(ge.$$.fragment,e),Oe=!0)},o(e){T(y.$$.fragment,e),T(b.$$.fragment,e),T($.$$.fragment,e),T(v.$$.fragment,e),T(i.$$.fragment,e),T(q.$$.fragment,e),T(O.$$.fragment,e),T(K.$$.fragment,e),T(te.$$.fragment,e),T(ne.$$.fragment,e),T(se.$$.fragment,e),T(H.$$.fragment,e),T(ie.$$.fragment,e),T(Y.$$.fragment,e),T(ce.$$.fragment,e),T(he.$$.fragment,e),T(A.$$.fragment,e),T(Me.$$.fragment,e),T(ge.$$.fragment,e),Oe=!1},d(e){e&&(t(m),t(l),t(f),t(Z),t(I),t(J),t(k),t(U),t(B),t(N),t(x),t(R),t(L),t(C),t(o),t(j),t(Q),t(be),t(z),t(Je),t(D),t(Ue),t($e),t(P),t(xe),t(je),t(We),t(ee),t(Ce),t(ve),t(le),t(Re),t(ae),t(Xe),t(Ze),t(Ie),t(ke),t(Be),t(oe),t(Ne),t(re),t(Fe),t(pe),t(Le),t(fe),t(Ge),t(me),t(Ve),t(Ee),t(Se),t(ue),t(He),t(Ye),t(de),t(Ae),t(Qe),t(ze),t(we),t(De),t(qe),t(Te),t(Pe),t(ye)),t(n),_(y,e),_(b,e),_($,e),_(v,e),_(i,e),_(q,e),_(O,e),_(K,e),_(te,e),_(ne,e),_(se,e),_(H,e),_(ie,e),_(Y,e),_(ce,e),_(he,e),_(A,e),_(Me,e),_(ge,e)}}}const Vt='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"Hardware requirements","local":"hardware-requirements","sections":[],"depth":2},{"title":"Upload model to Hub","local":"upload-model-to-hub","sections":[],"depth":2},{"title":"Save and load checkpoints","local":"save-and-load-checkpoints","sections":[],"depth":2},{"title":"Fine-tuning","local":"fine-tuning","sections":[{"title":"Training with multiple GPUs","local":"training-with-multiple-gpus","sections":[],"depth":4}],"depth":2},{"title":"Training with Min-SNR weighting","local":"training-with-min-snr-weighting","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[],"depth":2}],"depth":1}';function Et(W){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends xt{constructor(n){super(),jt(this,n,Et,Gt,Ut,{})}}export{Dt as component};
