import{s as ht,o as _t,n as et}from"../chunks/scheduler.8c3d61f6.js";import{S as yt,i as Mt,g as d,s as a,r as g,A as bt,h as p,f as n,c as o,j as x,u,x as b,k as V,y as r,a as s,v as f,d as h,t as _,w as y}from"../chunks/index.da70eac4.js";import{T as Tt}from"../chunks/Tip.1d9b8c37.js";import{D as se}from"../chunks/Docstring.6b390b9a.js";import{C as Xe}from"../chunks/CodeBlock.00a903b3.js";import{E as ft}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as he,E as wt}from"../chunks/EditOnGithub.1e64e623.js";function Jt(G){let l,W='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=d("p"),l.innerHTML=W},l(m){l=p(m,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1qn15hi"&&(l.innerHTML=W)},m(m,c){s(m,l,c)},p:et,d(m){m&&n(l)}}}function Wt(G){let l,W="Examples:",m,c,M;return c=new Xe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, WanPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.schedulers.scheduling_unipc_multistep <span class="hljs-keyword">import</span> UniPCMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models: Wan-AI/Wan2.1-T2V-14B-Diffusers, Wan-AI/Wan2.1-T2V-1.3B-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WanPipeline.from_pretrained(model_id, vae=vae, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>flow_shift = <span class="hljs-number">5.0</span>  <span class="hljs-comment"># 5.0 for 720P, 3.0 for 480P</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config, flow_shift=flow_shift)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat and a dog baking a cake together in a kitchen. The cat is carefully measuring flour, while the dog is stirring the batter with a wooden spoon. The kitchen is cozy, with sunlight streaming through the window.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">720</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">1280</span>,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">81</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){l=d("p"),l.textContent=W,m=a(),g(c.$$.fragment)},l(i){l=p(i,"P",{"data-svelte-h":!0}),b(l)!=="svelte-kvfsh7"&&(l.textContent=W),m=o(i),u(c.$$.fragment,i)},m(i,T){s(i,l,T),s(i,m,T),f(c,i,T),M=!0},p:et,i(i){M||(h(c.$$.fragment,i),M=!0)},o(i){_(c.$$.fragment,i),M=!1},d(i){i&&(n(l),n(m)),y(c,i)}}}function vt(G){let l,W="Examples:",m,c,M;return c=new Xe({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKLWan, WanImageToVideoPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video, load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Available models: Wan-AI/Wan2.1-I2V-14B-480P-Diffusers, Wan-AI/Wan2.1-I2V-14B-720P-Diffusers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;Wan-AI/Wan2.1-I2V-14B-480P-Diffusers&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_encoder = CLIPVisionModel.from_pretrained(
<span class="hljs-meta">... </span>    model_id, subfolder=<span class="hljs-string">&quot;image_encoder&quot;</span>, torch_dtype=torch.float32
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKLWan.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = WanImageToVideoPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, vae=vae, image_encoder=image_encoder, torch_dtype=torch.bfloat16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/astronaut.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>max_area = <span class="hljs-number">480</span> * <span class="hljs-number">832</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>aspect_ratio = image.height / image.width
<span class="hljs-meta">&gt;&gt;&gt; </span>mod_value = pipe.vae_scale_factor_spatial * pipe.transformer.config.patch_size[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-built_in">round</span>(np.sqrt(max_area * aspect_ratio)) // mod_value * mod_value
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-built_in">round</span>(np.sqrt(max_area / aspect_ratio)) // mod_value * mod_value
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image.resize((width, height))
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;An astronaut hatching from an egg, on the surface of the moon, the darkness and depth of space realised in &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;the background. High quality, ultrarealistic detail and breath-taking movie-like camera shot.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>output = pipe(
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    height=height,
<span class="hljs-meta">... </span>    width=width,
<span class="hljs-meta">... </span>    num_frames=<span class="hljs-number">81</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">5.0</span>,
<span class="hljs-meta">... </span>).frames[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){l=d("p"),l.textContent=W,m=a(),g(c.$$.fragment)},l(i){l=p(i,"P",{"data-svelte-h":!0}),b(l)!=="svelte-kvfsh7"&&(l.textContent=W),m=o(i),u(c.$$.fragment,i)},m(i,T){s(i,l,T),s(i,m,T),f(c,i,T),M=!0},p:et,i(i){M||(h(c.$$.fragment,i),M=!0)},o(i){_(c.$$.fragment,i),M=!1},d(i){i&&(n(l),n(m)),y(c,i)}}}function jt(G){let l,W,m,c,M,i,T,tt='<a href="https://github.com/Wan-Video/Wan2.1" rel="nofollow">Wan 2.1</a> by the Alibaba Wan Team.',ye,B,Me,N,nt="Recommendations for inference:",be,R,at='<li>VAE in <code>torch.float32</code> for better decoding quality.</li> <li><code>num_frames</code> should be of the form <code>4 * k + 1</code>, for example <code>49</code> or <code>81</code>.</li> <li>For smaller resolution videos, try lower values of <code>shift</code> (between <code>2.0</code> to <code>5.0</code>) in the <a href="https://huggingface.co/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler.shift" rel="nofollow">Scheduler</a>. For larger resolution videos, try higher values (between <code>7.0</code> and <code>12.0</code>). The default value is <code>3.0</code> for Wan.</li>',Te,E,we,Q,ot="Wan can be used with many different schedulers, each with their own benefits regarding speed and generation quality. By default, Wan uses the <code>UniPCMultistepScheduler(prediction_type=&quot;flow_prediction&quot;, use_flow_sigmas=True, flow_shift=3.0)</code> scheduler. You can use a different scheduler as follows:",Je,F,We,H,ve,L,st=`The <code>WanTransformer3DModel</code> and <code>AutoencoderKLWan</code> models support loading checkpoints in their original format via the <code>from_single_file</code> loading
method.`,je,z,Ue,A,Ze,w,Y,Ne,ie,it="Pipeline for text-to-video generation using Wan.",Re,le,lt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ee,j,D,Qe,re,rt="The call function to the pipeline for generation.",Fe,C,He,$,S,Le,de,dt="Encodes the prompt into text encoder hidden states.",ke,q,Ie,J,O,ze,pe,pt="Pipeline for image-to-video generation using Wan.",Ae,ce,ct=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Ye,U,K,De,me,mt="The call function to the pipeline for generation.",Se,P,qe,X,ee,Oe,ge,gt="Encodes the prompt into text encoder hidden states.",xe,te,Ve,k,ne,Ke,ue,ut="Output class for Wan pipelines.",Ge,ae,Be,_e,Ce;return M=new he({props:{title:"Wan",local:"wan",headingTag:"h1"}}),B=new Tt({props:{$$slots:{default:[Jt]},$$scope:{ctx:G}}}),E=new he({props:{title:"Using a custom scheduler",local:"using-a-custom-scheduler",headingTag:"h3"}}),F=new Xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsb3dNYXRjaEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUyQyUyMFdhblBpcGVsaW5lJTBBJTBBc2NoZWR1bGVyX2ElMjAlM0QlMjBGbG93TWF0Y2hFdWxlckRpc2NyZXRlU2NoZWR1bGVyKHNoaWZ0JTNENS4wKSUwQXNjaGVkdWxlcl9iJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIocHJlZGljdGlvbl90eXBlJTNEJTIyZmxvd19wcmVkaWN0aW9uJTIyJTJDJTIwdXNlX2Zsb3dfc2lnbWFzJTNEVHJ1ZSUyQyUyMGZsb3dfc2hpZnQlM0Q0LjApJTBBJTBBcGlwZSUyMCUzRCUyMFdhblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJXYW4tQUklMkZXYW4yLjEtVDJWLTEuM0ItRGlmZnVzZXJzJTIyJTJDJTIwc2NoZWR1bGVyJTNEJTNDQ1VTVE9NX1NDSEVEVUxFUl9IRVJFJTNFKSUwQSUwQSUyMyUyMG9yJTJDJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjAlM0NDVVNUT01fU0NIRURVTEVSX0hFUkUlM0U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlowMatchEulerDiscreteScheduler, UniPCMultistepScheduler, WanPipeline

scheduler_a = FlowMatchEulerDiscreteScheduler(shift=<span class="hljs-number">5.0</span>)
scheduler_b = UniPCMultistepScheduler(prediction_type=<span class="hljs-string">&quot;flow_prediction&quot;</span>, use_flow_sigmas=<span class="hljs-literal">True</span>, flow_shift=<span class="hljs-number">4.0</span>)

pipe = WanPipeline.from_pretrained(<span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-1.3B-Diffusers&quot;</span>, scheduler=&lt;CUSTOM_SCHEDULER_HERE&gt;)

<span class="hljs-comment"># or,</span>
pipe.scheduler = &lt;CUSTOM_SCHEDULER_HERE&gt;`,wrap:!1}}),H=new he({props:{title:"Using single file loading with Wan",local:"using-single-file-loading-with-wan",headingTag:"h3"}}),z=new Xe({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwV2FuUGlwZWxpbmUlMkMlMjBXYW5UcmFuc2Zvcm1lcjNETW9kZWwlMEElMEFja3B0X3BhdGglMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGQ29tZnktT3JnJTJGV2FuXzIuMV9Db21meVVJX3JlcGFja2FnZWQlMkZibG9iJTJGbWFpbiUyRnNwbGl0X2ZpbGVzJTJGZGlmZnVzaW9uX21vZGVscyUyRndhbjIuMV90MnZfMS4zQl9iZjE2LnNhZmV0ZW5zb3JzJTIyJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBXYW5UcmFuc2Zvcm1lcjNETW9kZWwuZnJvbV9zaW5nbGVfZmlsZShja3B0X3BhdGglMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQSUwQXBpcGUlMjAlM0QlMjBXYW5QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyV2FuLUFJJTJGV2FuMi4xLVQyVi0xLjNCLURpZmZ1c2VycyUyMiUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> WanPipeline, WanTransformer3DModel

ckpt_path = <span class="hljs-string">&quot;https://huggingface.co/Comfy-Org/Wan_2.1_ComfyUI_repackaged/blob/main/split_files/diffusion_models/wan2.1_t2v_1.3B_bf16.safetensors&quot;</span>
transformer = WanTransformer3DModel.from_single_file(ckpt_path, torch_dtype=torch.bfloat16)

pipe = WanPipeline.from_pretrained(<span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-1.3B-Diffusers&quot;</span>, transformer=transformer)`,wrap:!1}}),A=new he({props:{title:"WanPipeline",local:"diffusers.WanPipeline",headingTag:"h2"}}),Y=new se({props:{name:"class diffusers.WanPipeline",anchor:"diffusers.WanPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"transformer",val:": WanTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.WanPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.WanPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.WanPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/wan_transformer_3d#diffusers.WanTransformer3DModel">WanTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.WanPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.WanPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L93"}}),D=new se({props:{name:"__call__",anchor:"diffusers.WanPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 832"},{name:"num_frames",val:": int = 81"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.WanPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.WanPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>480</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.WanPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>832</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.WanPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>81</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.WanPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WanPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WanPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.WanPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WanPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.WanPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WanPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.WanPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WanPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WanPipeline.__call__.autocast_dtype",description:`<strong>autocast_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.bfloat16</code>) &#x2014;
The dtype to use for the torch.amp.autocast.`,name:"autocast_dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L359",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>WanPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~WanPipelineOutput</code> or <code>tuple</code></p>
`}}),C=new ft({props:{anchor:"diffusers.WanPipeline.__call__.example",$$slots:{default:[Wt]},$$scope:{ctx:G}}}),S=new se({props:{name:"encode_prompt",anchor:"diffusers.WanPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.WanPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.WanPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WanPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.WanPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan.py#L181"}}),q=new he({props:{title:"WanImageToVideoPipeline",local:"diffusers.WanImageToVideoPipeline",headingTag:"h2"}}),O=new se({props:{name:"class diffusers.WanImageToVideoPipeline",anchor:"diffusers.WanImageToVideoPipeline",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"text_encoder",val:": UMT5EncoderModel"},{name:"image_encoder",val:": CLIPVisionModel"},{name:"image_processor",val:": CLIPImageProcessor"},{name:"transformer",val:": WanTransformer3DModel"},{name:"vae",val:": AutoencoderKLWan"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
Tokenizer from <a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5</a>,
specifically the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"tokenizer"},{anchor:"diffusers.WanImageToVideoPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>T5EncoderModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically
the <a href="https://huggingface.co/google/umt5-xxl" rel="nofollow">google/umt5-xxl</a> variant.`,name:"text_encoder"},{anchor:"diffusers.WanImageToVideoPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModel</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPVisionModel" rel="nofollow">CLIP</a>, specifically
the
<a href="https://github.com/mlfoundations/open_clip/blob/main/docs/PRETRAINED.md#vit-h14-xlm-roberta-large" rel="nofollow">clip-vit-huge-patch14</a>
variant.`,name:"image_encoder"},{anchor:"diffusers.WanImageToVideoPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/wan_transformer_3d#diffusers.WanTransformer3DModel">WanTransformer3DModel</a>) &#x2014;
Conditional Transformer to denoise the input latents.`,name:"transformer"},{anchor:"diffusers.WanImageToVideoPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.WanImageToVideoPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoder_kl_wan#diffusers.AutoencoderKLWan">AutoencoderKLWan</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode videos to and from latent representations.`,name:"vae"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L124"}}),K=new se({props:{name:"__call__",anchor:"diffusers.WanImageToVideoPipeline.__call__",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": int = 480"},{name:"width",val:": int = 832"},{name:"num_frames",val:": int = 81"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"num_videos_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'np'"},{name:"return_dict",val:": bool = True"},{name:"attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 512"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
The input image to condition the generation on. Must be an image, a list of images or a <code>torch.Tensor</code>.`,name:"image"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, defaults to <code>480</code>) &#x2014;
The height of the generated video.`,name:"height"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, defaults to <code>832</code>) &#x2014;
The width of the generated video.`,name:"width"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, defaults to <code>81</code>) &#x2014;
The number of frames in the generated video.`,name:"num_frames"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to <code>50</code>) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to <code>5.0</code>) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>WanPipelineOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.attention_kwargs",description:`<strong>attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"attention_kwargs"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.max_sequence_length",description:`<strong>max_sequence_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
The maximum sequence length of the prompt.`,name:"max_sequence_length"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.shift",description:`<strong>shift</strong> (<code>float</code>, <em>optional</em>, defaults to <code>5.0</code>) &#x2014;
The shift of the flow.`,name:"shift"},{anchor:"diffusers.WanImageToVideoPipeline.__call__.autocast_dtype",description:`<strong>autocast_dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.bfloat16</code>) &#x2014;
The dtype to use for the torch.amp.autocast.`,name:"autocast_dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L441",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>WanPipelineOutput</code> is returned, otherwise a <code>tuple</code> is returned where
the first element is a list with the generated images and the second element is a list of <code>bool</code>s
indicating whether the corresponding generated image contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~WanPipelineOutput</code> or <code>tuple</code></p>
`}}),P=new ft({props:{anchor:"diffusers.WanImageToVideoPipeline.__call__.example",$$slots:{default:[vt]},$$scope:{ctx:G}}}),ee=new se({props:{name:"encode_prompt",anchor:"diffusers.WanImageToVideoPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"num_videos_per_prompt",val:": int = 1"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"max_sequence_length",val:": int = 226"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"dtype",val:": typing.Optional[torch.dtype] = None"}],parametersDescription:[{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.num_videos_per_prompt",description:`<strong>num_videos_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of videos that should be generated per prompt. torch device to place the resulting embeddings on`,name:"num_videos_per_prompt"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
torch device`,name:"device"},{anchor:"diffusers.WanImageToVideoPipeline.encode_prompt.dtype",description:`<strong>dtype</strong> &#x2014; (<code>torch.dtype</code>, <em>optional</em>):
torch dtype`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_wan_i2v.py#L228"}}),te=new he({props:{title:"WanPipelineOutput",local:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",headingTag:"h2"}}),ne=new se({props:{name:"class diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",anchor:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput",parameters:[{name:"frames",val:": Tensor"}],parametersDescription:[{anchor:"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput.frames",description:`<strong>frames</strong> (<code>torch.Tensor</code>, <code>np.ndarray</code>, or List[List[PIL.Image.Image]]) &#x2014;
List of video outputs - It can be a nested list of length <code>batch_size,</code> with each sub-list containing
denoised PIL image sequences of length <code>num_frames.</code> It can also be a NumPy array or Torch tensor of shape
<code>(batch_size, num_frames, channels, height, width)</code>.`,name:"frames"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/wan/pipeline_output.py#L8"}}),ae=new wt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/wan.md"}}),{c(){l=d("meta"),W=a(),m=d("p"),c=a(),g(M.$$.fragment),i=a(),T=d("p"),T.innerHTML=tt,ye=a(),g(B.$$.fragment),Me=a(),N=d("p"),N.textContent=nt,be=a(),R=d("ul"),R.innerHTML=at,Te=a(),g(E.$$.fragment),we=a(),Q=d("p"),Q.innerHTML=ot,Je=a(),g(F.$$.fragment),We=a(),g(H.$$.fragment),ve=a(),L=d("p"),L.innerHTML=st,je=a(),g(z.$$.fragment),Ue=a(),g(A.$$.fragment),Ze=a(),w=d("div"),g(Y.$$.fragment),Ne=a(),ie=d("p"),ie.textContent=it,Re=a(),le=d("p"),le.innerHTML=lt,Ee=a(),j=d("div"),g(D.$$.fragment),Qe=a(),re=d("p"),re.textContent=rt,Fe=a(),g(C.$$.fragment),He=a(),$=d("div"),g(S.$$.fragment),Le=a(),de=d("p"),de.textContent=dt,ke=a(),g(q.$$.fragment),Ie=a(),J=d("div"),g(O.$$.fragment),ze=a(),pe=d("p"),pe.textContent=pt,Ae=a(),ce=d("p"),ce.innerHTML=ct,Ye=a(),U=d("div"),g(K.$$.fragment),De=a(),me=d("p"),me.textContent=mt,Se=a(),g(P.$$.fragment),qe=a(),X=d("div"),g(ee.$$.fragment),Oe=a(),ge=d("p"),ge.textContent=gt,xe=a(),g(te.$$.fragment),Ve=a(),k=d("div"),g(ne.$$.fragment),Ke=a(),ue=d("p"),ue.textContent=ut,Ge=a(),g(ae.$$.fragment),Be=a(),_e=d("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);l=p(t,"META",{name:!0,content:!0}),t.forEach(n),W=o(e),m=p(e,"P",{}),x(m).forEach(n),c=o(e),u(M.$$.fragment,e),i=o(e),T=p(e,"P",{"data-svelte-h":!0}),b(T)!=="svelte-16y8q1j"&&(T.innerHTML=tt),ye=o(e),u(B.$$.fragment,e),Me=o(e),N=p(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-1bbhycm"&&(N.textContent=nt),be=o(e),R=p(e,"UL",{"data-svelte-h":!0}),b(R)!=="svelte-1dpydlh"&&(R.innerHTML=at),Te=o(e),u(E.$$.fragment,e),we=o(e),Q=p(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-c0om1t"&&(Q.innerHTML=ot),Je=o(e),u(F.$$.fragment,e),We=o(e),u(H.$$.fragment,e),ve=o(e),L=p(e,"P",{"data-svelte-h":!0}),b(L)!=="svelte-19w1gpb"&&(L.innerHTML=st),je=o(e),u(z.$$.fragment,e),Ue=o(e),u(A.$$.fragment,e),Ze=o(e),w=p(e,"DIV",{class:!0});var v=x(w);u(Y.$$.fragment,v),Ne=o(v),ie=p(v,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-cppop6"&&(ie.textContent=it),Re=o(v),le=p(v,"P",{"data-svelte-h":!0}),b(le)!=="svelte-496sm0"&&(le.innerHTML=lt),Ee=o(v),j=p(v,"DIV",{class:!0});var I=x(j);u(D.$$.fragment,I),Qe=o(I),re=p(I,"P",{"data-svelte-h":!0}),b(re)!=="svelte-50j04k"&&(re.textContent=rt),Fe=o(I),u(C.$$.fragment,I),I.forEach(n),He=o(v),$=p(v,"DIV",{class:!0});var oe=x($);u(S.$$.fragment,oe),Le=o(oe),de=p(oe,"P",{"data-svelte-h":!0}),b(de)!=="svelte-16q0ax1"&&(de.textContent=dt),oe.forEach(n),v.forEach(n),ke=o(e),u(q.$$.fragment,e),Ie=o(e),J=p(e,"DIV",{class:!0});var Z=x(J);u(O.$$.fragment,Z),ze=o(Z),pe=p(Z,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-1u5shki"&&(pe.textContent=pt),Ae=o(Z),ce=p(Z,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-496sm0"&&(ce.innerHTML=ct),Ye=o(Z),U=p(Z,"DIV",{class:!0});var fe=x(U);u(K.$$.fragment,fe),De=o(fe),me=p(fe,"P",{"data-svelte-h":!0}),b(me)!=="svelte-50j04k"&&(me.textContent=mt),Se=o(fe),u(P.$$.fragment,fe),fe.forEach(n),qe=o(Z),X=p(Z,"DIV",{class:!0});var $e=x(X);u(ee.$$.fragment,$e),Oe=o($e),ge=p($e,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-16q0ax1"&&(ge.textContent=gt),$e.forEach(n),Z.forEach(n),xe=o(e),u(te.$$.fragment,e),Ve=o(e),k=p(e,"DIV",{class:!0});var Pe=x(k);u(ne.$$.fragment,Pe),Ke=o(Pe),ue=p(Pe,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-fkhkmf"&&(ue.textContent=ut),Pe.forEach(n),Ge=o(e),u(ae.$$.fragment,e),Be=o(e),_e=p(e,"P",{}),x(_e).forEach(n),this.h()},h(){V(l,"name","hf:doc:metadata"),V(l,"content",Ut),V(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),V(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,l),s(e,W,t),s(e,m,t),s(e,c,t),f(M,e,t),s(e,i,t),s(e,T,t),s(e,ye,t),f(B,e,t),s(e,Me,t),s(e,N,t),s(e,be,t),s(e,R,t),s(e,Te,t),f(E,e,t),s(e,we,t),s(e,Q,t),s(e,Je,t),f(F,e,t),s(e,We,t),f(H,e,t),s(e,ve,t),s(e,L,t),s(e,je,t),f(z,e,t),s(e,Ue,t),f(A,e,t),s(e,Ze,t),s(e,w,t),f(Y,w,null),r(w,Ne),r(w,ie),r(w,Re),r(w,le),r(w,Ee),r(w,j),f(D,j,null),r(j,Qe),r(j,re),r(j,Fe),f(C,j,null),r(w,He),r(w,$),f(S,$,null),r($,Le),r($,de),s(e,ke,t),f(q,e,t),s(e,Ie,t),s(e,J,t),f(O,J,null),r(J,ze),r(J,pe),r(J,Ae),r(J,ce),r(J,Ye),r(J,U),f(K,U,null),r(U,De),r(U,me),r(U,Se),f(P,U,null),r(J,qe),r(J,X),f(ee,X,null),r(X,Oe),r(X,ge),s(e,xe,t),f(te,e,t),s(e,Ve,t),s(e,k,t),f(ne,k,null),r(k,Ke),r(k,ue),s(e,Ge,t),f(ae,e,t),s(e,Be,t),s(e,_e,t),Ce=!0},p(e,[t]){const v={};t&2&&(v.$$scope={dirty:t,ctx:e}),B.$set(v);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),C.$set(I);const oe={};t&2&&(oe.$$scope={dirty:t,ctx:e}),P.$set(oe)},i(e){Ce||(h(M.$$.fragment,e),h(B.$$.fragment,e),h(E.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(A.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),h(C.$$.fragment,e),h(S.$$.fragment,e),h(q.$$.fragment,e),h(O.$$.fragment,e),h(K.$$.fragment,e),h(P.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),Ce=!0)},o(e){_(M.$$.fragment,e),_(B.$$.fragment,e),_(E.$$.fragment,e),_(F.$$.fragment,e),_(H.$$.fragment,e),_(z.$$.fragment,e),_(A.$$.fragment,e),_(Y.$$.fragment,e),_(D.$$.fragment,e),_(C.$$.fragment,e),_(S.$$.fragment,e),_(q.$$.fragment,e),_(O.$$.fragment,e),_(K.$$.fragment,e),_(P.$$.fragment,e),_(ee.$$.fragment,e),_(te.$$.fragment,e),_(ne.$$.fragment,e),_(ae.$$.fragment,e),Ce=!1},d(e){e&&(n(W),n(m),n(c),n(i),n(T),n(ye),n(Me),n(N),n(be),n(R),n(Te),n(we),n(Q),n(Je),n(We),n(ve),n(L),n(je),n(Ue),n(Ze),n(w),n(ke),n(Ie),n(J),n(xe),n(Ve),n(k),n(Ge),n(Be),n(_e)),n(l),y(M,e),y(B,e),y(E,e),y(F,e),y(H,e),y(z,e),y(A,e),y(Y),y(D),y(C),y(S),y(q,e),y(O),y(K),y(P),y(ee),y(te,e),y(ne),y(ae,e)}}}const Ut='{"title":"Wan","local":"wan","sections":[{"title":"Using a custom scheduler","local":"using-a-custom-scheduler","sections":[],"depth":3},{"title":"Using single file loading with Wan","local":"using-single-file-loading-with-wan","sections":[],"depth":3},{"title":"WanPipeline","local":"diffusers.WanPipeline","sections":[],"depth":2},{"title":"WanImageToVideoPipeline","local":"diffusers.WanImageToVideoPipeline","sections":[],"depth":2},{"title":"WanPipelineOutput","local":"diffusers.pipelines.wan.pipeline_output.WanPipelineOutput","sections":[],"depth":2}],"depth":1}';function Zt(G){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $t extends yt{constructor(l){super(),Mt(this,l,Zt,jt,ht,{})}}export{$t as component};
