import{s as nl,o as rl,n as il}from"../chunks/scheduler.182ea377.js";import{S as ol,i as pl,g as n,s,r as c,A as cl,h as r,f as l,c as i,j as ll,u as d,x as o,k as al,y as dl,a,v as m,d as M,t as f,w as u}from"../chunks/index.abf12888.js";import{T as sl}from"../chunks/Tip.230e2334.js";import{C as h}from"../chunks/CodeBlock.57fe6e13.js";import{H as Ue}from"../chunks/Heading.16916d63.js";function ml(_e){let p,b='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){p=n("p"),p.innerHTML=b},l(y){p=r(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1qbiqsn"&&(p.innerHTML=b)},m(y,w){a(y,p,w)},p:il,d(y){y&&l(p)}}}function Ml(_e){let p,b='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){p=n("p"),p.innerHTML=b},l(y){p=r(y,"P",{"data-svelte-h":!0}),o(p)!=="svelte-zx7n4c"&&(p.innerHTML=b)},m(y,w){a(y,p,w)},p:il,d(y){y&&l(p)}}}function fl(_e){let p,b,y,w,g,Je,J,Tt='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> are able to generate high-quality images in just a few steps, representing a big leap forward because many pipelines require at least 25+ steps. LCMs are produced by applying the latent consistency distillation method to any Stable Diffusion model. This method works by applying <em>one-stage guided distillation</em> to the latent space, and incorporating a <em>skipping-step</em> method to consistently skip timesteps to accelerate the distillation process (refer to section 4.1, 4.2, and 4.3 of the paper for more details).',Te,T,jt='If you’re training on a GPU with limited vRAM, try enabling <code>gradient_checkpointing</code>, <code>gradient_accumulation_steps</code>, and <code>mixed_precision</code> to reduce memory-usage and speedup training. You can reduce your memory-usage even more by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a> and <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes’</a> 8-bit optimizer.',je,j,Ct='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">train_lcm_distill_sd_wds.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',Ce,C,Zt="Before running the script, make sure you install the library from source:",Ze,Z,$e,$,$t="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",Re,R,xe,U,Xe,x,Rt="Initialize an 🤗 Accelerate environment (try enabling <code>torch.compile</code> to significantly speedup training):",We,X,Ie,W,xt="To setup a default 🤗 Accelerate environment without choosing any configurations:",ve,I,Ge,v,Xt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Ve,G,Le,V,Wt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',He,L,Ne,_,ke,H,It='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L419" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',Ae,N,vt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Ye,k,Be,A,Gt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so you’ll focus on the parameters that are relevant to latent consistency distillation in this guide.',Qe,Y,Vt='<li><code>--pretrained_teacher_model</code>: the path to a pretrained latent diffusion model to use as the teacher model</li> <li><code>--pretrained_vae_model_name_or_path</code>: path to a pretrained VAE; the SDXL VAE is known to suffer from numerical instability, so this parameter allows you to specify an alternative VAE (like this <a href="(https://huggingface.co/madebyollin/sdxl-vae-fp16-fix)">VAE</a> by madebyollin which works in fp16)</li> <li><code>--w_min</code> and <code>--w_max</code>: the minimum and maximum guidance scale values for guidance scale sampling</li> <li><code>--num_ddim_timesteps</code>: the number of timesteps for DDIM sampling</li> <li><code>--loss_type</code>: the type of loss (L2 or Huber) to calculate for latent consistency distillation; Huber loss is generally preferred because it’s more robust to outliers</li> <li><code>--huber_c</code>: the Huber loss parameter</li>',Fe,B,Ee,Q,Lt='The training script starts by creating a dataset class - <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L141" rel="nofollow"><code>Text2ImageDataset</code></a> - for preprocessing the images and creating a training dataset.',ze,F,Se,E,Ht='For improved performance on reading and writing large datasets stored in the cloud, this script uses the <a href="https://github.com/webdataset/webdataset" rel="nofollow">WebDataset</a> format to create a preprocessing pipeline to apply transforms and create a dataset and dataloader for training. Images are processed and fed to the training loop without having to download the full dataset first.',qe,z,De,S,Nt='In the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L768" rel="nofollow"><code>main()</code></a> function, all the necessary components like the noise scheduler, tokenizers, text encoders, and VAE are loaded. The teacher UNet is also loaded here and then you can create a student UNet from the teacher UNet. The student UNet is updated by the optimizer during training.',Pe,q,Ke,D,kt='Now you can create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L979" rel="nofollow">optimizer</a> to update the UNet parameters:',Oe,P,et,K,At='Create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L994" rel="nofollow">dataset</a>:',tt,O,lt,ee,Yt='Next, you’re ready to setup the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1049" rel="nofollow">training loop</a> and implement the latent consistency distillation method (see Algorithm 1 in the paper for more details). This section of the script takes care of adding noise to the latents, sampling and creating a guidance scale embedding, and predicting the original image from the noise.',at,te,st,le,Bt='It gets the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1172" rel="nofollow">teacher model predictions</a> and the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1209" rel="nofollow">LCM predictions</a> next, calculates the loss, and then backpropagates it to the LCM.',it,ae,nt,se,Qt='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers tutorial</a> which breaks down the basic pattern of the denoising process.',rt,ie,ot,ne,Ft="Now you’re ready to launch the training script and start distilling!",pt,re,Et='For this guide, you’ll use the <code>--train_shards_path_or_url</code> to specify the path to the <a href="https://github.com/google-research-datasets/conceptual-12m" rel="nofollow">Conceptual Captions 12M</a> dataset stored on the Hub <a href="https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset" rel="nofollow">here</a>. Set the <code>MODEL_DIR</code> environment variable to the name of the teacher model and <code>OUTPUT_DIR</code> to where you want to save the model.',ct,oe,dt,pe,zt="Once training is complete, you can use your new LCM for inference.",mt,ce,Mt,de,ft,me,St='LoRA is a training technique for significantly reducing the number of trainable parameters. As a result, training is faster and it is easier to store the resulting weights because they are a lot smaller (~100MBs). Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sd_wds.py" rel="nofollow">train_lcm_distill_lora_sd_wds.py</a> or <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sdxl_wds.py" rel="nofollow">train_lcm_distill_lora_sdxl.wds.py</a> script to train with LoRA.',ut,Me,qt='The LoRA training script is discussed in more detail in the <a href="lora">LoRA training</a> guide.',yt,fe,ht,ue,Dt='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sdxl_wds.py" rel="nofollow">train_lcm_distill_sdxl_wds.py</a> script to train a SDXL model with LoRA.',bt,ye,Pt='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',wt,he,Ut,be,Kt="Congratulations on distilling a LCM model! To learn more about LCM, the following may be helpful:",_t,we,Ot='<li>Learn how to use <a href="../using-diffusers/lcm">LCMs for inference</a> for text-to-image, image-to-image, and with LoRA checkpoints.</li> <li>Read the <a href="https://huggingface.co/blog/lcm_lora" rel="nofollow">SDXL in 4 steps with Latent Consistency LoRAs</a> blog post to learn more about SDXL LCM-LoRA’s for super fast inference, quality comparisons, benchmarks, and more.</li>',gt,ge,Jt;return g=new Ue({props:{title:"Latent Consistency Distillation",local:"latent-consistency-distillation",headingTag:"h1"}}),Z=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),R=new h({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnNpc3RlbmN5X2Rpc3RpbGxhdGlvbiUwQXBpcCUyMGluc3RhbGwlMjAtciUyMHJlcXVpcmVtZW50cy50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/consistency_distillation
pip install -r requirements.txt`,wrap:!1}}),U=new sl({props:{$$slots:{default:[ml]},$$scope:{ctx:_e}}}),X=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),I=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),G=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`from accelerate.utils import write_basic_config

write_basic_config()`,wrap:!1}}),L=new Ue({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),_=new sl({props:{$$slots:{default:[Ml]},$$scope:{ctx:_e}}}),k=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2xjbV9kaXN0aWxsX3NkX3dkcy5weSUyMCU1QyUwQSUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMg==",highlighted:`accelerate launch train_lcm_distill_sd_wds.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),B=new Ue({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),F=new h({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnJlc2l6ZShpbWFnZSUyQyUyMHJlc29sdXRpb24lMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUxJTkVBUiklMEElMEElMjAlMjAlMjAlMjBjX3RvcCUyQyUyMGNfbGVmdCUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwdHJhbnNmb3Jtcy5SYW5kb21Dcm9wLmdldF9wYXJhbXMoaW1hZ2UlMkMlMjBvdXRwdXRfc2l6ZSUzRChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBURi5jcm9wKGltYWdlJTJDJTIwY190b3AlMkMlMjBjX2xlZnQlMkMlMjByZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnRvX3RlbnNvcihpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLm5vcm1hbGl6ZShpbWFnZSUyQyUyMCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">example</span>):
    image = example[<span class="hljs-string">&quot;image&quot;</span>]
    image = TF.resize(image, resolution, interpolation=transforms.InterpolationMode.BILINEAR)

    c_top, c_left, _, _ = transforms.RandomCrop.get_params(image, output_size=(resolution, resolution))
    image = TF.crop(image, c_top, c_left, resolution, resolution)
    image = TF.to_tensor(image)
    image = TF.normalize(image, [<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>])

    example[<span class="hljs-string">&quot;image&quot;</span>] = image
    <span class="hljs-keyword">return</span> example`,wrap:!1}}),z=new h({props:{code:"cHJvY2Vzc2luZ19waXBlbGluZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMHdkcy5kZWNvZGUoJTIycGlsJTIyJTJDJTIwaGFuZGxlciUzRHdkcy5pZ25vcmVfYW5kX2NvbnRpbnVlKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5yZW5hbWUoaW1hZ2UlM0QlMjJqcGclM0JwbmclM0JqcGVnJTNCd2VicCUyMiUyQyUyMHRleHQlM0QlMjJ0ZXh0JTNCdHh0JTNCY2FwdGlvbiUyMiUyQyUyMGhhbmRsZXIlM0R3ZHMud2Fybl9hbmRfY29udGludWUpJTJDJTBBJTIwJTIwJTIwJTIwd2RzLm1hcChmaWx0ZXJfa2V5cyglN0IlMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIlN0QpKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5tYXAodHJhbnNmb3JtKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy50b190dXBsZSglMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIpJTJDJTBBJTVE",highlighted:`processing_pipeline = [
    wds.decode(<span class="hljs-string">&quot;pil&quot;</span>, handler=wds.ignore_and_continue),
    wds.rename(image=<span class="hljs-string">&quot;jpg;png;jpeg;webp&quot;</span>, text=<span class="hljs-string">&quot;text;txt;caption&quot;</span>, handler=wds.warn_and_continue),
    wds.<span class="hljs-built_in">map</span>(filter_keys({<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>})),
    wds.<span class="hljs-built_in">map</span>(transform),
    wds.to_tuple(<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>),
]`,wrap:!1}}),q=new h({props:{code:"dGVhY2hlcl91bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF90ZWFjaGVyX21vZGVsJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy50ZWFjaGVyX3JldmlzaW9uJTBBKSUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCgqKnRlYWNoZXJfdW5ldC5jb25maWcpJTBBdW5ldC5sb2FkX3N0YXRlX2RpY3QodGVhY2hlcl91bmV0LnN0YXRlX2RpY3QoKSUyQyUyMHN0cmljdCUzREZhbHNlKSUwQXVuZXQudHJhaW4oKQ==",highlighted:`teacher_unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_teacher_model, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.teacher_revision
)

unet = UNet2DConditionModel(**teacher_unet.config)
unet.load_state_dict(teacher_unet.state_dict(), strict=<span class="hljs-literal">False</span>)
unet.train()`,wrap:!1}}),P=new h({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NsYXNzKCUwQSUyMCUyMCUyMCUyMHVuZXQucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`optimizer = optimizer_class(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),O=new h({props:{code:"ZGF0YXNldCUyMCUzRCUyMFRleHQySW1hZ2VEYXRhc2V0KCUwQSUyMCUyMCUyMCUyMHRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRGFyZ3MudHJhaW5fc2hhcmRzX3BhdGhfb3JfdXJsJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2V4YW1wbGVzJTNEYXJncy5tYXhfdHJhaW5fc2FtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9ncHVfYmF0Y2hfc2l6ZSUzRGFyZ3MudHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbF9iYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTIwKiUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUyQyUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0RhcmdzLnJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlX2J1ZmZlcl9zaXplJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMHBpbl9tZW1vcnklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyc2lzdGVudF93b3JrZXJzJTNEVHJ1ZSUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwZGF0YXNldC50cmFpbl9kYXRhbG9hZGVy",highlighted:`dataset = Text2ImageDataset(
    train_shards_path_or_url=args.train_shards_path_or_url,
    num_train_examples=args.max_train_samples,
    per_gpu_batch_size=args.train_batch_size,
    global_batch_size=args.train_batch_size * accelerator.num_processes,
    num_workers=args.dataloader_num_workers,
    resolution=args.resolution,
    shuffle_buffer_size=<span class="hljs-number">1000</span>,
    pin_memory=<span class="hljs-literal">True</span>,
    persistent_workers=<span class="hljs-literal">True</span>,
)
train_dataloader = dataset.train_dataloader`,wrap:!1}}),te=new h({props:{code:"cHJlZF94XzAlMjAlM0QlMjBwcmVkaWN0ZWRfb3JpZ2luKCUwQSUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMkMlMEElMjAlMjAlMjAlMjBzdGFydF90aW1lc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBub2lzeV9tb2RlbF9pbnB1dCUyQyUwQSUyMCUyMCUyMCUyMG5vaXNlX3NjaGVkdWxlci5jb25maWcucHJlZGljdGlvbl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYWxwaGFfc2NoZWR1bGUlMkMlMEElMjAlMjAlMjAlMjBzaWdtYV9zY2hlZHVsZSUyQyUwQSklMEElMEFtb2RlbF9wcmVkJTIwJTNEJTIwY19za2lwX3N0YXJ0JTIwKiUyMG5vaXN5X21vZGVsX2lucHV0JTIwJTJCJTIwY19vdXRfc3RhcnQlMjAqJTIwcHJlZF94XzA=",highlighted:`pred_x_0 = predicted_origin(
    noise_pred,
    start_timesteps,
    noisy_model_input,
    noise_scheduler.config.prediction_type,
    alpha_schedule,
    sigma_schedule,
)

model_pred = c_skip_start * noisy_model_input + c_out_start * pred_x_0`,wrap:!1}}),ae=new h({props:{code:"aWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmwyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMEYubXNlX2xvc3MobW9kZWxfcHJlZC5mbG9hdCgpJTJDJTIwdGFyZ2V0LmZsb2F0KCklMkMlMjByZWR1Y3Rpb24lM0QlMjJtZWFuJTIyKSUwQWVsaWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmh1YmVyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMHRvcmNoLm1lYW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc3FydCgobW9kZWxfcHJlZC5mbG9hdCgpJTIwLSUyMHRhcmdldC5mbG9hdCgpKSUyMCoqJTIwMiUyMCUyQiUyMGFyZ3MuaHViZXJfYyoqMiklMjAtJTIwYXJncy5odWJlcl9jJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.loss_type == <span class="hljs-string">&quot;l2&quot;</span>:
    loss = F.mse_loss(model_pred.<span class="hljs-built_in">float</span>(), target.<span class="hljs-built_in">float</span>(), reduction=<span class="hljs-string">&quot;mean&quot;</span>)
<span class="hljs-keyword">elif</span> args.loss_type == <span class="hljs-string">&quot;huber&quot;</span>:
    loss = torch.mean(
        torch.sqrt((model_pred.<span class="hljs-built_in">float</span>() - target.<span class="hljs-built_in">float</span>()) ** <span class="hljs-number">2</span> + args.huber_c**<span class="hljs-number">2</span>) - args.huber_c
    )`,wrap:!1}}),ie=new Ue({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),oe=new h({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFleHBvcnQlMjBPVVRQVVRfRElSJTNEJTIycGF0aCUyRnRvJTJGc2F2ZWQlMkZtb2RlbCUyMiUwQSUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjB0cmFpbl9sY21fZGlzdGlsbF9zZF93ZHMucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfdGVhY2hlcl9tb2RlbCUzRCUyNE1PREVMX0RJUiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tb3V0cHV0X2RpciUzRCUyNE9VVFBVVF9ESVIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1peGVkX3ByZWNpc2lvbiUzRGZwMTYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxlYXJuaW5nX3JhdGUlM0QxZS02JTIwLS1sb3NzX3R5cGUlM0QlMjJodWJlciUyMiUyMC0tZW1hX2RlY2F5JTNEMC45NSUyMC0tYWRhbV93ZWlnaHRfZGVjYXklM0QwLjAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDEwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zYW1wbGVzJTNENDAwMDAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YWxvYWRlcl9udW1fd29ya2VycyUzRDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRCUyMnBpcGUlM0FjdXJsJTIwLUwlMjAtcyUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmxhaW9uJTJGY29uY2VwdHVhbC1jYXB0aW9ucy0xMm0td2ViZGF0YXNldCUyRnJlc29sdmUlMkZtYWluJTJGZGF0YSUyRiU3QjAwMDAwLi4wMTA5OSU3RC50YXIlM0Zkb3dubG9hZCUzRHRydWUlMjIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXZhbGlkYXRpb25fc3RlcHMlM0QyMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNoZWNrcG9pbnRpbmdfc3RlcHMlM0QyMDAlMjAtLWNoZWNrcG9pbnRzX3RvdGFsX2xpbWl0JTNEMTAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXRyYWluX2JhdGNoX3NpemUlM0QxMiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfY2hlY2twb2ludGluZyUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS11c2VfOGJpdF9hZGFtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXN1bWVfZnJvbV9jaGVja3BvaW50JTNEbGF0ZXN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXBvcnRfdG8lM0R3YW5kYiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQ1MzY0NTYzNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaF90b19odWI=",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path/to/saved/model&quot;</span>

accelerate launch train_lcm_distill_sd_wds.py \\
    --pretrained_teacher_model=<span class="hljs-variable">$MODEL_DIR</span> \\
    --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
    --mixed_precision=fp16 \\
    --resolution=512 \\
    --learning_rate=1e-6 --loss_type=<span class="hljs-string">&quot;huber&quot;</span> --ema_decay=0.95 --adam_weight_decay=0.0 \\
    --max_train_steps=1000 \\
    --max_train_samples=4000000 \\
    --dataloader_num_workers=8 \\
    --train_shards_path_or_url=<span class="hljs-string">&quot;pipe:curl -L -s https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset/resolve/main/data/{00000..01099}.tar?download=true&quot;</span> \\
    --validation_steps=200 \\
    --checkpointing_steps=200 --checkpoints_total_limit=10 \\
    --train_batch_size=12 \\
    --gradient_checkpointing --enable_xformers_memory_efficient_attention \\
    --gradient_accumulation_steps=1 \\
    --use_8bit_adam \\
    --resume_from_checkpoint=latest \\
    --report_to=wandb \\
    --seed=453645634 \\
    --push_to_hub`,wrap:!1}}),ce=new h({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci11c2VybmFtZSUyRnlvdXItbW9kZWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHVuZXQlM0R1bmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlbGluZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnN1c2hpJTIwcm9sbHMlMjBpbiUyMHRoZSUyMGZvcm0lMjBvZiUyMHBhbmRhJTIwaGVhZHMlMkMlMjBzdXNoaSUyMHBsYXR0ZXIlMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel, DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;your-username/your-model&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipeline.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;sushi rolls in the form of panda heads, sushi platter&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1.0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new Ue({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),fe=new Ue({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),he=new Ue({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){p=n("meta"),b=s(),y=n("p"),w=s(),c(g.$$.fragment),Je=s(),J=n("p"),J.innerHTML=Tt,Te=s(),T=n("p"),T.innerHTML=jt,je=s(),j=n("p"),j.innerHTML=Ct,Ce=s(),C=n("p"),C.textContent=Zt,Ze=s(),c(Z.$$.fragment),$e=s(),$=n("p"),$.textContent=$t,Re=s(),c(R.$$.fragment),xe=s(),c(U.$$.fragment),Xe=s(),x=n("p"),x.innerHTML=Rt,We=s(),c(X.$$.fragment),Ie=s(),W=n("p"),W.textContent=xt,ve=s(),c(I.$$.fragment),Ge=s(),v=n("p"),v.textContent=Xt,Ve=s(),c(G.$$.fragment),Le=s(),V=n("p"),V.innerHTML=Wt,He=s(),c(L.$$.fragment),Ne=s(),c(_.$$.fragment),ke=s(),H=n("p"),H.innerHTML=It,Ae=s(),N=n("p"),N.innerHTML=vt,Ye=s(),c(k.$$.fragment),Be=s(),A=n("p"),A.innerHTML=Gt,Qe=s(),Y=n("ul"),Y.innerHTML=Vt,Fe=s(),c(B.$$.fragment),Ee=s(),Q=n("p"),Q.innerHTML=Lt,ze=s(),c(F.$$.fragment),Se=s(),E=n("p"),E.innerHTML=Ht,qe=s(),c(z.$$.fragment),De=s(),S=n("p"),S.innerHTML=Nt,Pe=s(),c(q.$$.fragment),Ke=s(),D=n("p"),D.innerHTML=kt,Oe=s(),c(P.$$.fragment),et=s(),K=n("p"),K.innerHTML=At,tt=s(),c(O.$$.fragment),lt=s(),ee=n("p"),ee.innerHTML=Yt,at=s(),c(te.$$.fragment),st=s(),le=n("p"),le.innerHTML=Bt,it=s(),c(ae.$$.fragment),nt=s(),se=n("p"),se.innerHTML=Qt,rt=s(),c(ie.$$.fragment),ot=s(),ne=n("p"),ne.textContent=Ft,pt=s(),re=n("p"),re.innerHTML=Et,ct=s(),c(oe.$$.fragment),dt=s(),pe=n("p"),pe.textContent=zt,mt=s(),c(ce.$$.fragment),Mt=s(),c(de.$$.fragment),ft=s(),me=n("p"),me.innerHTML=St,ut=s(),Me=n("p"),Me.innerHTML=qt,yt=s(),c(fe.$$.fragment),ht=s(),ue=n("p"),ue.innerHTML=Dt,bt=s(),ye=n("p"),ye.innerHTML=Pt,wt=s(),c(he.$$.fragment),Ut=s(),be=n("p"),be.textContent=Kt,_t=s(),we=n("ul"),we.innerHTML=Ot,gt=s(),ge=n("p"),this.h()},l(e){const t=cl("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(l),b=i(e),y=r(e,"P",{}),ll(y).forEach(l),w=i(e),d(g.$$.fragment,e),Je=i(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1oefohu"&&(J.innerHTML=Tt),Te=i(e),T=r(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-w1dbtu"&&(T.innerHTML=jt),je=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1izwzxl"&&(j.innerHTML=Ct),Ce=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-l7dm2q"&&(C.textContent=Zt),Ze=i(e),d(Z.$$.fragment,e),$e=i(e),$=r(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-z4z0b9"&&($.textContent=$t),Re=i(e),d(R.$$.fragment,e),xe=i(e),d(U.$$.fragment,e),Xe=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-h7f7kz"&&(x.innerHTML=Rt),We=i(e),d(X.$$.fragment,e),Ie=i(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-di6juu"&&(W.textContent=xt),ve=i(e),d(I.$$.fragment,e),Ge=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-tsz4qp"&&(v.textContent=Xt),Ve=i(e),d(G.$$.fragment,e),Le=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1fkfdql"&&(V.innerHTML=Wt),He=i(e),d(L.$$.fragment,e),Ne=i(e),d(_.$$.fragment,e),ke=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-z8r4ny"&&(H.innerHTML=It),Ae=i(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1r0bv1x"&&(N.innerHTML=vt),Ye=i(e),d(k.$$.fragment,e),Be=i(e),A=r(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-opb00x"&&(A.innerHTML=Gt),Qe=i(e),Y=r(e,"UL",{"data-svelte-h":!0}),o(Y)!=="svelte-q5d022"&&(Y.innerHTML=Vt),Fe=i(e),d(B.$$.fragment,e),Ee=i(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-xygc62"&&(Q.innerHTML=Lt),ze=i(e),d(F.$$.fragment,e),Se=i(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1fe8qlp"&&(E.innerHTML=Ht),qe=i(e),d(z.$$.fragment,e),De=i(e),S=r(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-184frii"&&(S.innerHTML=Nt),Pe=i(e),d(q.$$.fragment,e),Ke=i(e),D=r(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-he12t1"&&(D.innerHTML=kt),Oe=i(e),d(P.$$.fragment,e),et=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1c3frfx"&&(K.innerHTML=At),tt=i(e),d(O.$$.fragment,e),lt=i(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-4kbgth"&&(ee.innerHTML=Yt),at=i(e),d(te.$$.fragment,e),st=i(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1g18b9r"&&(le.innerHTML=Bt),it=i(e),d(ae.$$.fragment,e),nt=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1pefyrm"&&(se.innerHTML=Qt),rt=i(e),d(ie.$$.fragment,e),ot=i(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-5c8ldp"&&(ne.textContent=Ft),pt=i(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-14rdptq"&&(re.innerHTML=Et),ct=i(e),d(oe.$$.fragment,e),dt=i(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-2n690z"&&(pe.textContent=zt),mt=i(e),d(ce.$$.fragment,e),Mt=i(e),d(de.$$.fragment,e),ft=i(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-21u499"&&(me.innerHTML=St),ut=i(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1sxi0tl"&&(Me.innerHTML=qt),yt=i(e),d(fe.$$.fragment,e),ht=i(e),ue=r(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-swritx"&&(ue.innerHTML=Dt),bt=i(e),ye=r(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-6dxtva"&&(ye.innerHTML=Pt),wt=i(e),d(he.$$.fragment,e),Ut=i(e),be=r(e,"P",{"data-svelte-h":!0}),o(be)!=="svelte-1bflftn"&&(be.textContent=Kt),_t=i(e),we=r(e,"UL",{"data-svelte-h":!0}),o(we)!=="svelte-e624yw"&&(we.innerHTML=Ot),gt=i(e),ge=r(e,"P",{}),ll(ge).forEach(l),this.h()},h(){al(p,"name","hf:doc:metadata"),al(p,"content",ul)},m(e,t){dl(document.head,p),a(e,b,t),a(e,y,t),a(e,w,t),m(g,e,t),a(e,Je,t),a(e,J,t),a(e,Te,t),a(e,T,t),a(e,je,t),a(e,j,t),a(e,Ce,t),a(e,C,t),a(e,Ze,t),m(Z,e,t),a(e,$e,t),a(e,$,t),a(e,Re,t),m(R,e,t),a(e,xe,t),m(U,e,t),a(e,Xe,t),a(e,x,t),a(e,We,t),m(X,e,t),a(e,Ie,t),a(e,W,t),a(e,ve,t),m(I,e,t),a(e,Ge,t),a(e,v,t),a(e,Ve,t),m(G,e,t),a(e,Le,t),a(e,V,t),a(e,He,t),m(L,e,t),a(e,Ne,t),m(_,e,t),a(e,ke,t),a(e,H,t),a(e,Ae,t),a(e,N,t),a(e,Ye,t),m(k,e,t),a(e,Be,t),a(e,A,t),a(e,Qe,t),a(e,Y,t),a(e,Fe,t),m(B,e,t),a(e,Ee,t),a(e,Q,t),a(e,ze,t),m(F,e,t),a(e,Se,t),a(e,E,t),a(e,qe,t),m(z,e,t),a(e,De,t),a(e,S,t),a(e,Pe,t),m(q,e,t),a(e,Ke,t),a(e,D,t),a(e,Oe,t),m(P,e,t),a(e,et,t),a(e,K,t),a(e,tt,t),m(O,e,t),a(e,lt,t),a(e,ee,t),a(e,at,t),m(te,e,t),a(e,st,t),a(e,le,t),a(e,it,t),m(ae,e,t),a(e,nt,t),a(e,se,t),a(e,rt,t),m(ie,e,t),a(e,ot,t),a(e,ne,t),a(e,pt,t),a(e,re,t),a(e,ct,t),m(oe,e,t),a(e,dt,t),a(e,pe,t),a(e,mt,t),m(ce,e,t),a(e,Mt,t),m(de,e,t),a(e,ft,t),a(e,me,t),a(e,ut,t),a(e,Me,t),a(e,yt,t),m(fe,e,t),a(e,ht,t),a(e,ue,t),a(e,bt,t),a(e,ye,t),a(e,wt,t),m(he,e,t),a(e,Ut,t),a(e,be,t),a(e,_t,t),a(e,we,t),a(e,gt,t),a(e,ge,t),Jt=!0},p(e,[t]){const el={};t&2&&(el.$$scope={dirty:t,ctx:e}),U.$set(el);const tl={};t&2&&(tl.$$scope={dirty:t,ctx:e}),_.$set(tl)},i(e){Jt||(M(g.$$.fragment,e),M(Z.$$.fragment,e),M(R.$$.fragment,e),M(U.$$.fragment,e),M(X.$$.fragment,e),M(I.$$.fragment,e),M(G.$$.fragment,e),M(L.$$.fragment,e),M(_.$$.fragment,e),M(k.$$.fragment,e),M(B.$$.fragment,e),M(F.$$.fragment,e),M(z.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(ae.$$.fragment,e),M(ie.$$.fragment,e),M(oe.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(fe.$$.fragment,e),M(he.$$.fragment,e),Jt=!0)},o(e){f(g.$$.fragment,e),f(Z.$$.fragment,e),f(R.$$.fragment,e),f(U.$$.fragment,e),f(X.$$.fragment,e),f(I.$$.fragment,e),f(G.$$.fragment,e),f(L.$$.fragment,e),f(_.$$.fragment,e),f(k.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(z.$$.fragment,e),f(q.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),Jt=!1},d(e){e&&(l(b),l(y),l(w),l(Je),l(J),l(Te),l(T),l(je),l(j),l(Ce),l(C),l(Ze),l($e),l($),l(Re),l(xe),l(Xe),l(x),l(We),l(Ie),l(W),l(ve),l(Ge),l(v),l(Ve),l(Le),l(V),l(He),l(Ne),l(ke),l(H),l(Ae),l(N),l(Ye),l(Be),l(A),l(Qe),l(Y),l(Fe),l(Ee),l(Q),l(ze),l(Se),l(E),l(qe),l(De),l(S),l(Pe),l(Ke),l(D),l(Oe),l(et),l(K),l(tt),l(lt),l(ee),l(at),l(st),l(le),l(it),l(nt),l(se),l(rt),l(ot),l(ne),l(pt),l(re),l(ct),l(dt),l(pe),l(mt),l(Mt),l(ft),l(me),l(ut),l(Me),l(yt),l(ht),l(ue),l(bt),l(ye),l(wt),l(Ut),l(be),l(_t),l(we),l(gt),l(ge)),l(p),u(g,e),u(Z,e),u(R,e),u(U,e),u(X,e),u(I,e),u(G,e),u(L,e),u(_,e),u(k,e),u(B,e),u(F,e),u(z,e),u(q,e),u(P,e),u(O,e),u(te,e),u(ae,e),u(ie,e),u(oe,e),u(ce,e),u(de,e),u(fe,e),u(he,e)}}}const ul='{"title":"Latent Consistency Distillation","local":"latent-consistency-distillation","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function yl(_e){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gl extends ol{constructor(p){super(),pl(this,p,yl,fl,nl,{})}}export{gl as component};
