import{s as ct,n as dt,o as ut}from"../chunks/scheduler.9bc65507.js";import{S as ft,i as ht,g as o,s,r as p,A as Mt,h as i,f as l,c as a,j as pt,u as m,x as r,k as mt,y as wt,a as n,v as c,d,t as u,w as f}from"../chunks/index.707bf1b6.js";import{H as te,g as yt}from"../chunks/Heading.98cce615.js";import{C as M}from"../chunks/CodeBlock.54a9f38d.js";import{D as bt}from"../chunks/DocNotebookDropdown.3e6b3817.js";function gt(Le){let h,le,O,ne,w,se,y,ae,b,Ee='Accelerated Linear Algebra, dubbed XLA, is a compiler for accelerating the runtime of TensorFlow Models. From the <a href="https://www.tensorflow.org/xla" rel="nofollow">official documentation</a>:',oe,g,He="XLA (Accelerated Linear Algebra) is a domain-specific compiler for linear algebra that can accelerate TensorFlow models with potentially no source code changes.",ie,T,Ae='Using XLA in TensorFlow is simple – it comes packaged inside the <code>tensorflow</code> library, and it can be triggered with the <code>jit_compile</code> argument in any graph-creating function such as <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>. When using Keras methods like <code>fit()</code> and <code>predict()</code>, you can enable XLA simply by passing the <code>jit_compile</code> argument to <code>model.compile()</code>. However, XLA is not limited to these methods - it can also be used to accelerate any arbitrary <code>tf.function</code>.',re,J,Qe='Several TensorFlow methods in 🤗 Transformers have been rewritten to be XLA-compatible, including text generation for models such as <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a> and <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>, as well as speech processing for models such as <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.',pe,j,Ne="While the exact amount of speed-up is very much model-dependent, for TensorFlow text generation models inside 🤗 Transformers, we noticed a speed-up of ~100x. This document will explain how you can use XLA for these models to get the maximum amount of performance. We’ll also provide links to additional resources if you’re interested to learn more about the benchmarks and our design philosophy behind the XLA integration.",me,U,ce,Z,Ye="Let us consider the following model in TensorFlow:",de,k,ue,_,qe="The above model accepts inputs having a dimension of <code>(10, )</code>. We can use the model for running a forward pass like so:",fe,X,he,G,Se="In order to run the forward pass with an XLA-compiled function, we’d need to do:",Me,v,we,R,Pe="The default <code>call()</code> function of the <code>model</code> is used for compiling the XLA graph. But if there’s any other model function you want to compile into XLA that’s also possible with:",ye,W,be,x,ge,I,Ke="To enable XLA-accelerated generation within 🤗 Transformers, you need to have a recent version of <code>transformers</code> installed. You can install it by running:",Te,B,Je,$,De="And then you can run the following code:",je,C,Ue,F,Oe="As you can notice, enabling XLA on <code>generate()</code> is just a single line of code. The rest of the code remains unchanged. However, there are a couple of gotchas in the above code snippet that are specific to XLA. You need to be aware of those to realize the speed-ups that XLA can bring in. We discuss these in the following section.",Ze,V,ke,z,et='When you are executing an XLA-enabled function (like <code>xla_generate()</code> above) for the first time, it will internally try to infer the computation graph, which is time-consuming.  This process is known as <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“tracing”</a>.',_e,L,tt="You might notice that the generation time is not fast. Successive calls of <code>xla_generate()</code> (or any other XLA-enabled function) won’t have to infer the computation graph, given the inputs to the function follow the same shape with which the computation graph was initially built. While this is not a problem for modalities with fixed input shapes (e.g., images), you must pay attention if you are working with variable input shape modalities (e.g., text).",Xe,E,lt="To ensure <code>xla_generate()</code> always operates with the same input shapes, you can specify the <code>padding</code> arguments when calling the tokenizer.",Ge,H,ve,A,nt="This way, you can ensure that the inputs to <code>xla_generate()</code> will always receive inputs with the shape it was traced with and thus leading to speed-ups in the generation time. You can verify this with the code below:",Re,Q,We,N,st="On a Tesla T4 GPU, you can expect the outputs like so:",xe,Y,Ie,q,at="The first call to <code>xla_generate()</code> is time-consuming because of tracing, but the successive calls are orders of magnitude faster. Keep in mind that any change in the generation options at any point with trigger re-tracing and thus leading to slow-downs in the generation time.",Be,S,ot="We didn’t cover all the text generation options 🤗 Transformers provides in this document. We encourage you to read the documentation for advanced use cases.",$e,P,Ce,K,it="Here, we leave you with some additional resources if you want to delve deeper into XLA in 🤗 Transformers and in general.",Fe,D,rt='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">This Colab Notebook</a> provides an interactive demonstration if you want to fiddle with the XLA-compatible encoder-decoder (like <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>) and decoder-only (like <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>) text generation models.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">This blog post</a> provides an overview of the comparison benchmarks for XLA-compatible models along with a friendly introduction to XLA in TensorFlow.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">This blog post</a> discusses our design philosophy behind adding XLA support to the TensorFlow models in 🤗 Transformers.</li> <li>Recommended posts for learning more about XLA and TensorFlow graphs in general:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: Optimizing Compiler for Machine Learning</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">Introduction to graphs and tf.function</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">Better performance with tf.function</a></li></ul></li>',Ve,ee,ze;return w=new te({props:{title:"XLA Integration for TensorFlow Models",local:"xla-integration-for-tensorflow-models",headingTag:"h1"}}),y=new bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"}]}}),U=new te({props:{title:"Running TF functions with XLA",local:"running-tf-functions-with-xla",headingTag:"h2"}}),k=new M({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`,wrap:!1}}),X=new M({props:{code:"JTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEFfJTIwJTNEJTIwbW9kZWwocmFuZG9tX2lucHV0cyk=",highlighted:`<span class="hljs-comment"># Generate random inputs for the model.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># Run a forward pass.</span>
_ = model(random_inputs)`,wrap:!1}}),v=new M({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`,wrap:!1}}),W=new M({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),x=new te({props:{title:"Running a TF text generation model with XLA from 🤗 Transformers",local:"running-a-tf-text-generation-model-with-xla-from--transformers",headingTag:"h2"}}),B=new M({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade",wrap:!1}}),C=new M({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dF9zdHJpbmclMjAlM0QlMjAlNUIlMjJUZW5zb3JGbG93JTIwaXMlMjIlNUQlMEElMEElMjMlMjBPbmUlMjBsaW5lJTIwdG8lMjBjcmVhdGUlMjBhbiUyMFhMQSUyMGdlbmVyYXRpb24lMjBmdW5jdGlvbiUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQXRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWdlbmVyYXRlZF90b2tlbnMlMjAlM0QlMjB4bGFfZ2VuZXJhdGUoKip0b2tlbml6ZWRfaW5wdXQlMkMlMjBudW1fYmVhbXMlM0QyKSUwQSUwQWRlY29kZWRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChmJTIyR2VuZXJhdGVkJTIwLS0lMjAlN0JkZWNvZGVkX3RleHQlN0QlMjIpJTBBJTIzJTIwR2VuZXJhdGVkJTIwLS0lMjBUZW5zb3JGbG93JTIwaXMlMjBhbiUyMG9wZW4tc291cmNlJTJDJTIwb3Blbi1zb3VyY2UlMkMlMjBkaXN0cmlidXRlZC1zb3VyY2UlMjBhcHBsaWNhdGlvbiUyMCUyMyUyMGZyYW1ld29yayUyMGZvciUyMHRoZQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># One line to create an XLA generation function</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`,wrap:!1}}),V=new te({props:{title:"Gotchas to be aware of",local:"gotchas-to-be-aware-of",headingTag:"h2"}}),H=new M({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQSUyMyUyMEhlcmUlMkMlMjB3ZSUyMGNhbGwlMjB0aGUlMjB0b2tlbml6ZXIlMjB3aXRoJTIwcGFkZGluZyUyMG9wdGlvbnMuJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHBhZF90b19tdWx0aXBsZV9vZiUzRDglMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Here, we call the tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),Q=new M({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEElMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEFmb3IlMjBpbnB1dF9zdHJpbmclMjBpbiUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiUyQyUyMCUyMlRlbnNvckZsb3clMjBpcyUyMGElMjIlMkMlMjAlMjJURkxpdGUlMjBpcyUyMGElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMjAlMjAlMjAlMjBzdGFydCUyMCUzRCUyMHRpbWUudGltZV9ucygpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwJTdCKGVuZCUyMC0lMjBzdGFydCklMjAlMkYlMjAxZTYlM0EuMWYlN0QlMjBtcyU1Q24lMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`,wrap:!1}}),Y=new M({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`,wrap:!1}}),P=new te({props:{title:"Additional Resources",local:"additional-resources",headingTag:"h2"}}),{c(){h=o("meta"),le=s(),O=o("p"),ne=s(),p(w.$$.fragment),se=s(),p(y.$$.fragment),ae=s(),b=o("p"),b.innerHTML=Ee,oe=s(),g=o("p"),g.textContent=He,ie=s(),T=o("p"),T.innerHTML=Ae,re=s(),J=o("p"),J.innerHTML=Qe,pe=s(),j=o("p"),j.textContent=Ne,me=s(),p(U.$$.fragment),ce=s(),Z=o("p"),Z.textContent=Ye,de=s(),p(k.$$.fragment),ue=s(),_=o("p"),_.innerHTML=qe,fe=s(),p(X.$$.fragment),he=s(),G=o("p"),G.textContent=Se,Me=s(),p(v.$$.fragment),we=s(),R=o("p"),R.innerHTML=Pe,ye=s(),p(W.$$.fragment),be=s(),p(x.$$.fragment),ge=s(),I=o("p"),I.innerHTML=Ke,Te=s(),p(B.$$.fragment),Je=s(),$=o("p"),$.textContent=De,je=s(),p(C.$$.fragment),Ue=s(),F=o("p"),F.innerHTML=Oe,Ze=s(),p(V.$$.fragment),ke=s(),z=o("p"),z.innerHTML=et,_e=s(),L=o("p"),L.innerHTML=tt,Xe=s(),E=o("p"),E.innerHTML=lt,Ge=s(),p(H.$$.fragment),ve=s(),A=o("p"),A.innerHTML=nt,Re=s(),p(Q.$$.fragment),We=s(),N=o("p"),N.textContent=st,xe=s(),p(Y.$$.fragment),Ie=s(),q=o("p"),q.innerHTML=at,Be=s(),S=o("p"),S.textContent=ot,$e=s(),p(P.$$.fragment),Ce=s(),K=o("p"),K.textContent=it,Fe=s(),D=o("ul"),D.innerHTML=rt,Ve=s(),ee=o("p"),this.h()},l(e){const t=Mt("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),le=a(e),O=i(e,"P",{}),pt(O).forEach(l),ne=a(e),m(w.$$.fragment,e),se=a(e),m(y.$$.fragment,e),ae=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-afit4t"&&(b.innerHTML=Ee),oe=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1rjg69l"&&(g.textContent=He),ie=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-8rwpb7"&&(T.innerHTML=Ae),re=a(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1sup5o3"&&(J.innerHTML=Qe),pe=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-v22hyz"&&(j.textContent=Ne),me=a(e),m(U.$$.fragment,e),ce=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1n8d5xl"&&(Z.textContent=Ye),de=a(e),m(k.$$.fragment,e),ue=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-137qaqi"&&(_.innerHTML=qe),fe=a(e),m(X.$$.fragment,e),he=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1xkaplb"&&(G.textContent=Se),Me=a(e),m(v.$$.fragment,e),we=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-3tnenm"&&(R.innerHTML=Pe),ye=a(e),m(W.$$.fragment,e),be=a(e),m(x.$$.fragment,e),ge=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1tqra4o"&&(I.innerHTML=Ke),Te=a(e),m(B.$$.fragment,e),Je=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-5mrt6v"&&($.textContent=De),je=a(e),m(C.$$.fragment,e),Ue=a(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-xz55ih"&&(F.innerHTML=Oe),Ze=a(e),m(V.$$.fragment,e),ke=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1tw7ufk"&&(z.innerHTML=et),_e=a(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1v603pg"&&(L.innerHTML=tt),Xe=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1s9agvy"&&(E.innerHTML=lt),Ge=a(e),m(H.$$.fragment,e),ve=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1nbul0x"&&(A.innerHTML=nt),Re=a(e),m(Q.$$.fragment,e),We=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-zm3wt3"&&(N.textContent=st),xe=a(e),m(Y.$$.fragment,e),Ie=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-18ijq7m"&&(q.innerHTML=at),Be=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-149gqik"&&(S.textContent=ot),$e=a(e),m(P.$$.fragment,e),Ce=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-k2oxa5"&&(K.textContent=it),Fe=a(e),D=i(e,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-19xtsh9"&&(D.innerHTML=rt),Ve=a(e),ee=i(e,"P",{}),pt(ee).forEach(l),this.h()},h(){mt(h,"name","hf:doc:metadata"),mt(h,"content",Tt)},m(e,t){wt(document.head,h),n(e,le,t),n(e,O,t),n(e,ne,t),c(w,e,t),n(e,se,t),c(y,e,t),n(e,ae,t),n(e,b,t),n(e,oe,t),n(e,g,t),n(e,ie,t),n(e,T,t),n(e,re,t),n(e,J,t),n(e,pe,t),n(e,j,t),n(e,me,t),c(U,e,t),n(e,ce,t),n(e,Z,t),n(e,de,t),c(k,e,t),n(e,ue,t),n(e,_,t),n(e,fe,t),c(X,e,t),n(e,he,t),n(e,G,t),n(e,Me,t),c(v,e,t),n(e,we,t),n(e,R,t),n(e,ye,t),c(W,e,t),n(e,be,t),c(x,e,t),n(e,ge,t),n(e,I,t),n(e,Te,t),c(B,e,t),n(e,Je,t),n(e,$,t),n(e,je,t),c(C,e,t),n(e,Ue,t),n(e,F,t),n(e,Ze,t),c(V,e,t),n(e,ke,t),n(e,z,t),n(e,_e,t),n(e,L,t),n(e,Xe,t),n(e,E,t),n(e,Ge,t),c(H,e,t),n(e,ve,t),n(e,A,t),n(e,Re,t),c(Q,e,t),n(e,We,t),n(e,N,t),n(e,xe,t),c(Y,e,t),n(e,Ie,t),n(e,q,t),n(e,Be,t),n(e,S,t),n(e,$e,t),c(P,e,t),n(e,Ce,t),n(e,K,t),n(e,Fe,t),n(e,D,t),n(e,Ve,t),n(e,ee,t),ze=!0},p:dt,i(e){ze||(d(w.$$.fragment,e),d(y.$$.fragment,e),d(U.$$.fragment,e),d(k.$$.fragment,e),d(X.$$.fragment,e),d(v.$$.fragment,e),d(W.$$.fragment,e),d(x.$$.fragment,e),d(B.$$.fragment,e),d(C.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),ze=!0)},o(e){u(w.$$.fragment,e),u(y.$$.fragment,e),u(U.$$.fragment,e),u(k.$$.fragment,e),u(X.$$.fragment,e),u(v.$$.fragment,e),u(W.$$.fragment,e),u(x.$$.fragment,e),u(B.$$.fragment,e),u(C.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),u(Q.$$.fragment,e),u(Y.$$.fragment,e),u(P.$$.fragment,e),ze=!1},d(e){e&&(l(le),l(O),l(ne),l(se),l(ae),l(b),l(oe),l(g),l(ie),l(T),l(re),l(J),l(pe),l(j),l(me),l(ce),l(Z),l(de),l(ue),l(_),l(fe),l(he),l(G),l(Me),l(we),l(R),l(ye),l(be),l(ge),l(I),l(Te),l(Je),l($),l(je),l(Ue),l(F),l(Ze),l(ke),l(z),l(_e),l(L),l(Xe),l(E),l(Ge),l(ve),l(A),l(Re),l(We),l(N),l(xe),l(Ie),l(q),l(Be),l(S),l($e),l(Ce),l(K),l(Fe),l(D),l(Ve),l(ee)),l(h),f(w,e),f(y,e),f(U,e),f(k,e),f(X,e),f(v,e),f(W,e),f(x,e),f(B,e),f(C,e),f(V,e),f(H,e),f(Q,e),f(Y,e),f(P,e)}}}const Tt='{"title":"XLA Integration for TensorFlow Models","local":"xla-integration-for-tensorflow-models","sections":[{"title":"Running TF functions with XLA","local":"running-tf-functions-with-xla","sections":[],"depth":2},{"title":"Running a TF text generation model with XLA from 🤗 Transformers","local":"running-a-tf-text-generation-model-with-xla-from--transformers","sections":[],"depth":2},{"title":"Gotchas to be aware of","local":"gotchas-to-be-aware-of","sections":[],"depth":2},{"title":"Additional Resources","local":"additional-resources","sections":[],"depth":2}],"depth":1}';function Jt(Le){return ut(()=>{new URLSearchParams(window.location.search).get("fw"),window.hfDocGoto=yt}),[]}class Xt extends ft{constructor(h){super(),ht(this,h,Jt,gt,ct,{})}}export{Xt as component};
