import{s as tn,n as ln,o as an}from"../chunks/scheduler.0219f8bd.js";import{S as en,i as nn,g as h,s as e,r as i,A as pn,h as j,f as l,c as n,j as Oe,u as p,x as m,k as sn,y as Mn,a,v as M,d as o,t as r,w as c}from"../chunks/index.f61edf3b.js";import{C as y}from"../chunks/CodeBlock.38e566ae.js";import{H as J,E as on}from"../chunks/EditOnGithub.48fa589f.js";function rn(ne){let u,Xt,vt,At,g,Yt,T,ie=`A Typescript powered wrapper for the Hugging Face Inference Endpoints API. Learn more about Inference Endpoints at <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Hugging Face</a>.
It works with both <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API (serverless)</a> and <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints (dedicated)</a>.`,St,f,pe='You can also try out a live <a href="https://observablehq.com/@huggingface/hello-huggingface-js-inference" rel="nofollow">interactive notebook</a>, see some demos on <a href="https://huggingface.co/huggingfacejs" rel="nofollow">hf.co/huggingfacejs</a>, or watch a <a href="https://scrimba.com/scrim/cod8248f5adfd6e129582c523" rel="nofollow">Scrimba tutorial that explains how Inference Endpoints works</a>.',Vt,w,Rt,d,qt,U,zt,$,Ft,I,_t,b,Ht,C,Lt,x,Dt,B,Me='❗<strong>Important note:</strong> Using an access token is optional to get started, however you will be rate limited eventually. Join <a href="https://huggingface.co/join" rel="nofollow">Hugging Face</a> and then visit <a href="https://huggingface.co/settings/tokens" rel="nofollow">access tokens</a> to generate your access token for <strong>free</strong>.',Pt,Z,oe="Your access token should be kept private. If you need to protect it in front-end applications, we suggest setting up a proxy server that stores the access token.",Kt,k,Ot,Q,re="You can import the functions you need directly from the module instead of using the <code>HfInference</code> class.",sl,G,tl,N,ce="This will enable tree-shaking by your bundler.",ll,E,al,v,el,W,he="Tries to fill in a hole with a missing word (token to be precise).",nl,X,il,A,pl,Y,je="Summarizes longer text into shorter text. Be careful, some models have a maximum length of input.",Ml,S,ol,V,rl,R,me="Answers questions based on the context you provide.",cl,q,hl,z,jl,F,ml,_,Jl,H,Je="Often used for sentiment analysis, this method will assign labels to the given text along with a probability score of that label.",yl,L,ul,D,gl,P,ye="Generates text from an input prompt.",Tl,K,ue='<a href="https://huggingface.co/spaces/huggingfacejs/streaming-text-generation" rel="nofollow">Demo</a>',fl,O,wl,ss,dl,ts,ge="Used for sentence parsing, either grammatical, or Named Entity Recognition (NER) to understand keywords contained within text.",Ul,ls,$l,as,Il,es,Te="Converts text from one language to another.",bl,ns,Cl,is,xl,ps,fe="Checks how well an input text fits into a set of labels you provide.",Bl,Ms,Zl,os,kl,rs,we="This task corresponds to any chatbot-like structure. Models tend to have shorter max_length, so please check with caution when using a given model if you need long-range dependency or not.",Ql,cs,Gl,hs,Nl,js,de="Calculate the semantic similarity between one text and a list of other sentences.",El,ms,vl,Js,Wl,ys,Xl,us,Ue="Transcribes speech from an audio file.",Al,gs,$e='<a href="https://huggingface.co/spaces/huggingfacejs/speech-recognition-vue" rel="nofollow">Demo</a>',Yl,Ts,Sl,fs,Vl,ws,Ie="Assigns labels to the given audio along with a probability score of that label.",Rl,ds,be='<a href="https://huggingface.co/spaces/huggingfacejs/audio-classification-vue" rel="nofollow">Demo</a>',ql,Us,zl,$s,Fl,Is,Ce="Generates natural-sounding speech from text input.",_l,bs,xe='<a href="https://scrimba.com/scrim/co8da4d23b49b648f77f4848a?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',Hl,Cs,Ll,xs,Dl,Bs,Be="Outputs one or multiple generated audios from an input audio, commonly used for speech enhancement and source separation.",Pl,Zs,Kl,ks,Ol,Qs,sa,Gs,Ze="Assigns labels to a given image along with a probability score of that label.",ta,Ns,ke='<a href="https://huggingface.co/spaces/huggingfacejs/image-classification-vue" rel="nofollow">Demo</a>',la,Es,aa,vs,ea,Ws,Qe="Detects objects within an image and returns labels with corresponding bounding boxes and probability scores.",na,Xs,Ge='<a href="https://huggingface.co/spaces/huggingfacejs/object-detection-vue" rel="nofollow">Demo</a>',ia,As,pa,Ys,Ma,Ss,Ne="Detects segments within an image and returns labels with corresponding bounding boxes and probability scores.",oa,Vs,ra,Rs,ca,qs,Ee="Outputs text from a given image, commonly used for captioning or optical character recognition.",ha,zs,ja,Fs,ma,_s,ve="Creates an image from a text prompt.",Ja,Hs,We='<a href="https://huggingface.co/spaces/huggingfacejs/image-to-text" rel="nofollow">Demo</a>',ya,Ls,ua,Ds,ga,Ps,Xe="Image-to-image is the task of transforming a source image to match the characteristics of a target image or a target image domain.",Ta,Ks,Ae='<a href="https://scrimba.com/scrim/co4834bf9a91cc81cfab07969?pl=pkVnrP7uP" rel="nofollow">Interactive tutorial</a>',fa,Os,wa,st,da,tt,Ye="Checks how well an input image fits into a set of labels you provide.",Ua,lt,$a,at,Ia,et,ba,nt,Se="This task reads some text and outputs raw float values, that are usually consumed as part of a semantic database/semantic search.",Ca,it,xa,pt,Ba,Mt,Ve="Visual Question Answering is the task of answering open-ended questions based on an image. They output natural language responses to natural language questions.",Za,ot,Re='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',ka,rt,Qa,ct,Ga,ht,qe="Document question answering models take a (document, question) pair as input and return an answer in natural language.",Na,jt,ze='<a href="https://huggingface.co/spaces/huggingfacejs/doc-vis-qa" rel="nofollow">Demo</a>',Ea,mt,va,Jt,Wa,yt,Xa,ut,Fe="Tabular regression is the task of predicting a numerical value given a set of attributes.",Aa,gt,Ya,Tt,Sa,ft,_e="Tabular classification is the task of classifying a target category (a group) based on set of attributes.",Va,wt,Ra,dt,qa,Ut,He="For models with custom parameters / outputs.",za,$t,Fa,It,_a,bt,Le='Learn more about using your own inference endpoints <a href="https://hf.co/docs/inference-endpoints/" rel="nofollow">here</a>',Ha,Ct,La,xt,De=`By default, all calls to the inference endpoint will wait until the model is
loaded. When <a href="https://huggingface.co/docs/inference-endpoints/en/autoscaling#scaling-to-0" rel="nofollow">scaling to
0</a>
is enabled on the endpoint, this can result in non-trivial waiting time. If
you’d rather disable this behavior and handle the endpoint’s returned 500 HTTP
errors yourself, you can do so like so:`,Da,Bt,Pa,Zt,Ka,kt,Oa,Qt,se,Gt,Pe='We have an informative documentation project called <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> to list available models for each task and explain how each task works in detail.',te,Nt,Ke="It also contains demos, example outputs, and other resources should you want to dig deeper into the ML side of things.",le,Et,ae,Wt,ee;return g=new J({props:{title:"🤗 Hugging Face Inference Endpoints",local:"-hugging-face-inference-endpoints",headingTag:"h1"}}),w=new J({props:{title:"Getting Started",local:"getting-started",headingTag:"h2"}}),d=new J({props:{title:"Install",local:"install",headingTag:"h3"}}),U=new J({props:{title:"Node",local:"node",headingTag:"h4"}}),$=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBcG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBJTBBeWFybiUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:`npm install @huggingface/inference

pnpm add @huggingface/inference

yarn add @huggingface/inference`,wrap:!1}}),I=new J({props:{title:"Deno",local:"deno",headingTag:"h4"}}),b=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>`,wrap:!1}}),C=new J({props:{title:"Initialize",local:"initialize",headingTag:"h3"}}),x=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJyUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZSgneW91ciUyMGFjY2VzcyUyMHRva2VuJyk=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/inference&#x27;</span>

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-string">&#x27;your access token&#x27;</span>)`,wrap:!1}}),k=new J({props:{title:"Tree-shaking",local:"tree-shaking",headingTag:"h4"}}),G=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwdGV4dEdlbmVyYXRpb24lMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFhd2FpdCUyMHRleHRHZW5lcmF0aW9uKCU3QiUwQSUyMCUyMGFjY2Vzc1Rva2VuJTNBJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJtb2RlbF9vcl9lbmRwb2ludCUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMC4uLiUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAuLi4lMEElN0Qp",highlighted:`<span class="hljs-keyword">import</span> { textGeneration } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;model_or_endpoint&quot;</span>,
  <span class="hljs-attr">inputs</span>: ...,
  <span class="hljs-attr">parameters</span>: ...
})`,wrap:!1}}),E=new J({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),v=new J({props:{title:"Fill Mask",local:"fill-mask",headingTag:"h3"}}),X=new y({props:{code:"YXdhaXQlMjBoZi5maWxsTWFzayglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdiZXJ0LWJhc2UtdW5jYXNlZCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnJTVCTUFTSyU1RCUyMHdvcmxkISclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">fillMask</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;bert-base-uncased&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;[MASK] world!&#x27;</span>
})`,wrap:!1}}),A=new J({props:{title:"Summarization",local:"summarization",headingTag:"h3"}}),S=new y({props:{code:"YXdhaXQlMjBoZi5zdW1tYXJpemF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1jbm4nJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwJ1RoZSUyMHRvd2VyJTIwaXMlMjAzMjQlMjBtZXRyZXMlMjAoMSUyQzA2MyUyMGZ0KSUyMHRhbGwlMkMlMjBhYm91dCUyMHRoZSUyMHNhbWUlMjBoZWlnaHQlMjBhcyUyMGFuJTIwODEtc3RvcmV5JTIwYnVpbGRpbmclMkMlMjBhbmQlMjB0aGUlMjB0YWxsZXN0JTIwc3RydWN0dXJlJTIwaW4lMjBQYXJpcy4lMjBJdHMlMjBiYXNlJTIwaXMlMjBzcXVhcmUlMkMlMjBtZWFzdXJpbmclMjAxMjUlMjBtZXRyZXMlMjAoNDEwJTIwZnQpJTIwb24lMjBlYWNoJTIwc2lkZS4lMjBEdXJpbmclMjBpdHMlMjBjb25zdHJ1Y3Rpb24lMkMlMjB0aGUlMjBFaWZmZWwlMjBUb3dlciUyMHN1cnBhc3NlZCUyMHRoZSUyMFdhc2hpbmd0b24lMjBNb251bWVudCUyMHRvJTIwYmVjb21lJTIwdGhlJTIwdGFsbGVzdCUyMG1hbi1tYWRlJTIwc3RydWN0dXJlJTIwaW4lMjB0aGUlMjB3b3JsZCUyQyUyMGElMjB0aXRsZSUyMGl0JTIwaGVsZCUyMGZvciUyMDQxJTIweWVhcnMlMjB1bnRpbCUyMHRoZSUyMENocnlzbGVyJTIwQnVpbGRpbmclMjBpbiUyME5ldyUyMFlvcmslMjBDaXR5JTIwd2FzJTIwZmluaXNoZWQlMjBpbiUyMDE5MzAuJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBtYXhfbGVuZ3RoJTNBJTIwMTAwJTBBJTIwJTIwJTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">summarization</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-cnn&#x27;</span>,
  <span class="hljs-attr">inputs</span>:
    <span class="hljs-string">&#x27;The tower is 324 metres (1,063 ft) tall, about the same height as an 81-storey building, and the tallest structure in Paris. Its base is square, measuring 125 metres (410 ft) on each side. During its construction, the Eiffel Tower surpassed the Washington Monument to become the tallest man-made structure in the world, a title it held for 41 years until the Chrysler Building in New York City was finished in 1930.&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">max_length</span>: <span class="hljs-number">100</span>
  }
})`,wrap:!1}}),V=new J({props:{title:"Question Answering",local:"question-answering",headingTag:"h3"}}),q=new y({props:{code:"YXdhaXQlMjBoZi5xdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkZWVwc2V0JTJGcm9iZXJ0YS1iYXNlLXNxdWFkMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVzdGlvbiUzQSUyMCdXaGF0JTIwaXMlMjB0aGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlM0YnJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzQSUyMCdUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMFBhcmlzLiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">questionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;deepset/roberta-base-squad2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;What is the capital of France?&#x27;</span>,
    <span class="hljs-attr">context</span>: <span class="hljs-string">&#x27;The capital of France is Paris.&#x27;</span>
  }
})`,wrap:!1}}),z=new J({props:{title:"Table Question Answering",local:"table-question-answering",headingTag:"h3"}}),F=new y({props:{code:"YXdhaXQlMjBoZi50YWJsZVF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2dvb2dsZSUyRnRhcGFzLWJhc2UtZmluZXR1bmVkLXd0cSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBxdWVyeSUzQSUyMCdIb3clMjBtYW55JTIwc3RhcnMlMjBkb2VzJTIwdGhlJTIwdHJhbnNmb3JtZXJzJTIwcmVwb3NpdG9yeSUyMGhhdmUlM0YnJTJDJTBBJTIwJTIwJTIwJTIwdGFibGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjBSZXBvc2l0b3J5JTNBJTIwJTVCJ1RyYW5zZm9ybWVycyclMkMlMjAnRGF0YXNldHMnJTJDJTIwJ1Rva2VuaXplcnMnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwU3RhcnMlM0ElMjAlNUInMzY1NDInJTJDJTIwJzQ1MTInJTJDJTIwJzM5MzQnJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwQ29udHJpYnV0b3JzJTNBJTIwJTVCJzY1MSclMkMlMjAnNzcnJTJDJTIwJzM0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdQcm9ncmFtbWluZyUyMGxhbmd1YWdlJyUzQSUyMCU1QidQeXRob24nJTJDJTIwJ1B5dGhvbiclMkMlMjAnUnVzdCUyQyUyMFB5dGhvbiUyMGFuZCUyME5vZGVKUyclNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tableQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/tapas-base-finetuned-wtq&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">query</span>: <span class="hljs-string">&#x27;How many stars does the transformers repository have?&#x27;</span>,
    <span class="hljs-attr">table</span>: {
      <span class="hljs-title class_">Repository</span>: [<span class="hljs-string">&#x27;Transformers&#x27;</span>, <span class="hljs-string">&#x27;Datasets&#x27;</span>, <span class="hljs-string">&#x27;Tokenizers&#x27;</span>],
      <span class="hljs-title class_">Stars</span>: [<span class="hljs-string">&#x27;36542&#x27;</span>, <span class="hljs-string">&#x27;4512&#x27;</span>, <span class="hljs-string">&#x27;3934&#x27;</span>],
      <span class="hljs-title class_">Contributors</span>: [<span class="hljs-string">&#x27;651&#x27;</span>, <span class="hljs-string">&#x27;77&#x27;</span>, <span class="hljs-string">&#x27;34&#x27;</span>],
      <span class="hljs-string">&#x27;Programming language&#x27;</span>: [<span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Python&#x27;</span>, <span class="hljs-string">&#x27;Rust, Python and NodeJS&#x27;</span>]
    }
  }
})`,wrap:!1}}),_=new J({props:{title:"Text Classification",local:"text-classification",headingTag:"h3"}}),L=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0Q2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ0klMjBsaWtlJTIweW91LiUyMEklMjBsb3ZlJTIweW91LiclMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;distilbert-base-uncased-finetuned-sst-2-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;I like you. I love you.&#x27;</span>
})`,wrap:!1}}),D=new J({props:{title:"Text Generation",local:"text-generation",headingTag:"h3"}}),O=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0R2VuZXJhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdncHQyJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdUaGUlMjBhbnN3ZXIlMjB0byUyMHRoZSUyMHVuaXZlcnNlJTIwaXMnJTBBJTdEKSUwQSUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi50ZXh0R2VuZXJhdGlvblN0cmVhbSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMmdvb2dsZSUyRmZsYW4tdDUteHhsJTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ3JlcGVhdCUyMCUyMm9uZSUyMHR3byUyMHRocmVlJTIwZm91ciUyMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTIwbWF4X25ld190b2tlbnMlM0ElMjAyNTAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMGNvbnNvbGUubG9nKG91dHB1dC50b2tlbi50ZXh0JTJDJTIwb3V0cHV0LmdlbmVyYXRlZF90ZXh0KSUzQiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textGeneration</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;gpt2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>
})

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;google/flan-t5-xxl&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;repeat &quot;one two three four&quot;&#x27;</span>,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">250</span> }
})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(output.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>, output.<span class="hljs-property">generated_text</span>);
}`,wrap:!1}}),ss=new J({props:{title:"Token Classification",local:"token-classification",headingTag:"h3"}}),ls=new y({props:{code:"YXdhaXQlMjBoZi50b2tlbkNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2RibWR6JTJGYmVydC1sYXJnZS1jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFNhcmFoJTIwSmVzc2ljYSUyMFBhcmtlciUyMGJ1dCUyMHlvdSUyMGNhbiUyMGNhbGwlMjBtZSUyMEplc3NpY2EnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tokenClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dbmdz/bert-large-cased-finetuned-conll03-english&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Sarah Jessica Parker but you can call me Jessica&#x27;</span>
})`,wrap:!1}}),as=new J({props:{title:"Translation",local:"translation",headingTag:"h3"}}),ns=new y({props:{code:"YXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCd0NS1iYXNlJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdNeSUyMG5hbWUlMjBpcyUyMFdvbGZnYW5nJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMEJlcmxpbiclMEElN0QpJTBBJTBBYXdhaXQlMjBoZi50cmFuc2xhdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRm1iYXJ0LWxhcmdlLTUwLW1hbnktdG8tbWFueS1tbXQnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwdGV4dFRvVHJhbnNsYXRlJTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUwQSUwOSUwOSUyMnNyY19sYW5nJTIyJTNBJTIwJTIyZW5fWFglMjIlMkMlMEElMDklMDklMjJ0Z3RfbGFuZyUyMiUzQSUyMCUyMmZyX1hYJTIyJTBBJTA5JTdEJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/mbart-large-50-many-to-many-mmt&#x27;</span>,
  <span class="hljs-attr">inputs</span>: textToTranslate,
  <span class="hljs-attr">parameters</span>: {
		<span class="hljs-string">&quot;src_lang&quot;</span>: <span class="hljs-string">&quot;en_XX&quot;</span>,
		<span class="hljs-string">&quot;tgt_lang&quot;</span>: <span class="hljs-string">&quot;fr_XX&quot;</span>
	}
})`,wrap:!1}}),is=new J({props:{title:"Zero-Shot Classification",local:"zero-shot-classification",headingTag:"h3"}}),Ms=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdENsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGYmFydC1sYXJnZS1tbmxpJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCdIaSUyQyUyMEklMjByZWNlbnRseSUyMGJvdWdodCUyMGElMjBkZXZpY2UlMjBmcm9tJTIweW91ciUyMGNvbXBhbnklMjBidXQlMjBpdCUyMGlzJTIwbm90JTIwd29ya2luZyUyMGFzJTIwYWR2ZXJ0aXNlZCUyMGFuZCUyMEklMjB3b3VsZCUyMGxpa2UlMjB0byUyMGdldCUyMHJlaW1idXJzZWQhJyUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMjBjYW5kaWRhdGVfbGFiZWxzJTNBJTIwJTVCJ3JlZnVuZCclMkMlMjAnbGVnYWwnJTJDJTIwJ2ZhcSclNUQlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/bart-large-mnli&#x27;</span>,
  <span class="hljs-attr">inputs</span>: [
    <span class="hljs-string">&#x27;Hi, I recently bought a device from your company but it is not working as advertised and I would like to get reimbursed!&#x27;</span>
  ],
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;refund&#x27;</span>, <span class="hljs-string">&#x27;legal&#x27;</span>, <span class="hljs-string">&#x27;faq&#x27;</span>] }
})`,wrap:!1}}),os=new J({props:{title:"Conversational",local:"conversational",headingTag:"h3"}}),cs=new y({props:{code:"YXdhaXQlMjBoZi5jb252ZXJzYXRpb25hbCglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdtaWNyb3NvZnQlMkZEaWFsb0dQVC1sYXJnZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXN0X3VzZXJfaW5wdXRzJTNBJTIwJTVCJ1doaWNoJTIwbW92aWUlMjBpcyUyMHRoZSUyMGJlc3QlMjAlM0YnJTVEJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Jlc3BvbnNlcyUzQSUyMCU1QidJdCUyMGlzJTIwRGllJTIwSGFyZCUyMGZvciUyMHN1cmUuJyU1RCUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0ElMjAnQ2FuJTIweW91JTIwZXhwbGFpbiUyMHdoeSUyMCUzRiclMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">conversational</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;microsoft/DialoGPT-large&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">past_user_inputs</span>: [<span class="hljs-string">&#x27;Which movie is the best ?&#x27;</span>],
    <span class="hljs-attr">generated_responses</span>: [<span class="hljs-string">&#x27;It is Die Hard for sure.&#x27;</span>],
    <span class="hljs-attr">text</span>: <span class="hljs-string">&#x27;Can you explain why ?&#x27;</span>
  }
})`,wrap:!1}}),hs=new J({props:{title:"Sentence Similarity",local:"sentence-similarity",headingTag:"h3"}}),ms=new y({props:{code:"YXdhaXQlMjBoZi5zZW50ZW5jZVNpbWlsYXJpdHkoJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGcGFyYXBocmFzZS14bG0tci1tdWx0aWxpbmd1YWwtdjEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwc291cmNlX3NlbnRlbmNlJTNBJTIwJ1RoYXQlMjBpcyUyMGElMjBoYXBweSUyMHBlcnNvbiclMkMlMEElMjAlMjAlMjAlMjBzZW50ZW5jZXMlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAnVGhhdCUyMGlzJTIwYSUyMGhhcHB5JTIwZG9nJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUaGF0JTIwaXMlMjBhJTIwdmVyeSUyMGhhcHB5JTIwcGVyc29uJyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCdUb2RheSUyMGlzJTIwYSUyMHN1bm55JTIwZGF5JyUwQSUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">sentenceSimilarity</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;sentence-transformers/paraphrase-xlm-r-multilingual-v1&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">source_sentence</span>: <span class="hljs-string">&#x27;That is a happy person&#x27;</span>,
    <span class="hljs-attr">sentences</span>: [
      <span class="hljs-string">&#x27;That is a happy dog&#x27;</span>,
      <span class="hljs-string">&#x27;That is a very happy person&#x27;</span>,
      <span class="hljs-string">&#x27;Today is a sunny day&#x27;</span>
    ]
  }
})`,wrap:!1}}),Js=new J({props:{title:"Audio",local:"audio",headingTag:"h2"}}),ys=new J({props:{title:"Automatic Speech Recognition",local:"automatic-speech-recognition",headingTag:"h3"}}),Ts=new y({props:{code:"YXdhaXQlMjBoZi5hdXRvbWF0aWNTcGVlY2hSZWNvZ25pdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmJyUyQyUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZzYW1wbGUxLmZsYWMnKSUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">automaticSpeechRecognition</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/wav2vec2-large-960h-lv60-self&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),fs=new J({props:{title:"Audio Classification",local:"audio-classification",headingTag:"h3"}}),Us=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb0NsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N1cGVyYiUyRmh1YmVydC1sYXJnZS1zdXBlcmItZXInJTJDJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRnNhbXBsZTEuZmxhYycpJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;superb/hubert-large-superb-er&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),$s=new J({props:{title:"Text To Speech",local:"text-to-speech",headingTag:"h3"}}),Cs=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9TcGVlY2goJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnZXNwbmV0JTJGa2FuLWJheWFzaGlfbGpzcGVlY2hfdml0cyclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnSGVsbG8lMjB3b3JsZCEnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToSpeech</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;espnet/kan-bayashi_ljspeech_vits&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;Hello world!&#x27;</span>
})`,wrap:!1}}),xs=new J({props:{title:"Audio To Audio",local:"audio-to-audio",headingTag:"h3"}}),Zs=new y({props:{code:"YXdhaXQlMjBoZi5hdWRpb1RvQXVkaW8oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnc3BlZWNoYnJhaW4lMkZzZXBmb3JtZXItd2hhbSclMkMlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGc2FtcGxlMS5mbGFjJyklMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">audioToAudio</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;speechbrain/sepformer-wham&#x27;</span>,
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/sample1.flac&#x27;</span>)
})`,wrap:!1}}),ks=new J({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),Qs=new J({props:{title:"Image Classification",local:"image-classification",headingTag:"h3"}}),Es=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZUNsYXNzaWZpY2F0aW9uKCU3QiUwQSUyMCUyMGRhdGElM0ElMjByZWFkRmlsZVN5bmMoJ3Rlc3QlMkZjaGVldGFoLnBuZycpJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAnZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageClassification</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cheetah.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;google/vit-base-patch16-224&#x27;</span>
})`,wrap:!1}}),vs=new J({props:{title:"Object Detection",local:"object-detection",headingTag:"h3"}}),As=new y({props:{code:"YXdhaXQlMjBoZi5vYmplY3REZXRlY3Rpb24oJTdCJTBBJTIwJTIwZGF0YSUzQSUyMHJlYWRGaWxlU3luYygndGVzdCUyRmNhdHMucG5nJyklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdmYWNlYm9vayUyRmRldHItcmVzbmV0LTUwJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">objectDetection</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50&#x27;</span>
})`,wrap:!1}}),Ys=new J({props:{title:"Image Segmentation",local:"image-segmentation",headingTag:"h3"}}),Vs=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVNlZ21lbnRhdGlvbiglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ZhY2Vib29rJTJGZGV0ci1yZXNuZXQtNTAtcGFub3B0aWMnJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageSegmentation</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;facebook/detr-resnet-50-panoptic&#x27;</span>
})`,wrap:!1}}),Rs=new J({props:{title:"Image To Text",local:"image-to-text",headingTag:"h3"}}),zs=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvVGV4dCglN0IlMEElMjAlMjBkYXRhJTNBJTIwcmVhZEZpbGVTeW5jKCd0ZXN0JTJGY2F0cy5wbmcnKSUyQyUwQSUyMCUyMG1vZGVsJTNBJTIwJ25scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJyUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&#x27;test/cats.png&#x27;</span>),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>
})`,wrap:!1}}),Fs=new J({props:{title:"Text To Image",local:"text-to-image",headingTag:"h3"}}),Ls=new y({props:{code:"YXdhaXQlMjBoZi50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBpbnB1dHMlM0ElMjAnYXdhcmQlMjB3aW5uaW5nJTIwaGlnaCUyMHJlc29sdXRpb24lMjBwaG90byUyMG9mJTIwYSUyMGdpYW50JTIwdG9ydG9pc2UlMkYoKGxhZHliaXJkKSklMjBoeWJyaWQlMkMlMjAlNUJ0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiU1RCclMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNBJTIwJ2JsdXJyeSclMkMlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})`,wrap:!1}}),Ds=new J({props:{title:"Image To Image",local:"image-to-image",headingTag:"h3"}}),Os=new y({props:{code:"YXdhaXQlMjBoZi5pbWFnZVRvSW1hZ2UoJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwbmV3JTIwQmxvYiglNUJyZWFkRmlsZVN5bmMoJTIydGVzdCUyRnN0b3JtdHJvb3Blcl9kZXB0aC5wbmclMjIpJTVEKSUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0ElMjAlMjJlbG1vJ3MlMjBsZWN0dXJlJTIyJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1kZXB0aCUyMiUyQyUwQSU3RCklM0I=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">imageToImage</span>({
  <span class="hljs-attr">inputs</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-title function_">readFileSync</span>(<span class="hljs-string">&quot;test/stormtrooper_depth.png&quot;</span>)]),
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;elmo&#x27;s lecture&quot;</span>,
  },
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;lllyasviel/sd-controlnet-depth&quot;</span>,
});`,wrap:!1}}),st=new J({props:{title:"Zero Shot Image Classification",local:"zero-shot-image-classification",headingTag:"h3"}}),lt=new y({props:{code:"YXdhaXQlMjBoZi56ZXJvU2hvdEltYWdlQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAnb3BlbmFpJTJGY2xpcC12aXQtbGFyZ2UtcGF0Y2gxNC0zMzYnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMkMlMjAlMjAlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY2FuZGlkYXRlX2xhYmVscyUzQSUyMCU1QidjYXQnJTJDJTIwJ2RvZyclNUQlMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">zeroShotImageClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;openai/clip-vit-large-patch14-336&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  },  
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">candidate_labels</span>: [<span class="hljs-string">&#x27;cat&#x27;</span>, <span class="hljs-string">&#x27;dog&#x27;</span>]
  }
})`,wrap:!1}}),at=new J({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),et=new J({props:{title:"Feature Extraction",local:"feature-extraction",headingTag:"h3"}}),it=new y({props:{code:"YXdhaXQlMjBoZi5mZWF0dXJlRXh0cmFjdGlvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNlbnRlbmNlLXRyYW5zZm9ybWVycyUyRmRpc3RpbGJlcnQtYmFzZS1ubGktbWVhbi10b2tlbnMlMjIlMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAlMjJUaGF0JTIwaXMlMjBhJTIwaGFwcHklMjBwZXJzb24lMjIlMkMlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">featureExtraction</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;sentence-transformers/distilbert-base-nli-mean-tokens&quot;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&quot;That is a happy person&quot;</span>,
});`,wrap:!1}}),pt=new J({props:{title:"Visual Question Answering",local:"visual-question-answering",headingTag:"h3"}}),rt=new y({props:{code:"YXdhaXQlMjBoZi52aXN1YWxRdWVzdGlvbkFuc3dlcmluZyglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdkYW5kZWxpbiUyRnZpbHQtYjMyLWZpbmV0dW5lZC12cWEnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0ElMjAnSG93JTIwbWFueSUyMGNhdHMlMjBhcmUlMjBseWluZyUyMGRvd24lM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRnBsYWNla2l0dGVuLmNvbSUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMEElMjAlMjAlN0QlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">visualQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;dandelin/vilt-b32-finetuned-vqa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;How many cats are lying down?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://placekitten.com/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>()
  }
})`,wrap:!1}}),ct=new J({props:{title:"Document Question Answering",local:"document-question-answering",headingTag:"h3"}}),mt=new y({props:{code:"YXdhaXQlMjBoZi5kb2N1bWVudFF1ZXN0aW9uQW5zd2VyaW5nKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ2ltcGlyYSUyRmxheW91dGxtLWRvY3VtZW50LXFhJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNBJTIwJ0ludm9pY2UlMjBudW1iZXIlM0YnJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjBhd2FpdCUyMChhd2FpdCUyMGZldGNoKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJykpLmJsb2IoKSUyQyUwQSUyMCUyMCU3RCUwQSU3RCk=",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">documentQuestionAnswering</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;impira/layoutlm-document-qa&#x27;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">question</span>: <span class="hljs-string">&#x27;Invoice number?&#x27;</span>,
    <span class="hljs-attr">image</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  }
})`,wrap:!1}}),Jt=new J({props:{title:"Tabular",local:"tabular",headingTag:"h2"}}),yt=new J({props:{title:"Tabular Regression",local:"tabular-regression",headingTag:"h3"}}),gt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyUmVncmVzc2lvbiglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCUyMnNjaWtpdC1sZWFybiUyRkZpc2gtV2VpZ2h0JTIyJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwZGF0YSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlaWdodCUyMiUzQSUyMCU1QiUyMjExLjUyJTIyJTJDJTIwJTIyMTIuNDglMjIlMkMlMjAlMjIxMi4zNzc4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMSUyMiUzQSUyMCU1QiUyMjIzLjIlMjIlMkMlMjAlMjIyNCUyMiUyQyUyMCUyMjIzLjklMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJMZW5ndGgyJTIyJTNBJTIwJTVCJTIyMjUuNCUyMiUyQyUyMCUyMjI2LjMlMjIlMkMlMjAlMjIyNi41JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyTGVuZ3RoMyUyMiUzQSUyMCU1QiUyMjMwJTIyJTJDJTIwJTIyMzEuMiUyMiUyQyUyMCUyMjMxLjElMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJTcGVjaWVzJTIyJTNBJTIwJTVCJTIyQnJlYW0lMjIlMkMlMjAlMjJCcmVhbSUyMiUyQyUyMCUyMkJyZWFtJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2lkdGglMjIlM0ElMjAlNUIlMjI0LjAyJTIyJTJDJTIwJTIyNC4zMDU2JTIyJTJDJTIwJTIyNC42OTYxJTIyJTVEJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTdEJTJDJTBBJTdEKQ==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularRegression</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;scikit-learn/Fish-Weight&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;Height&quot;</span>: [<span class="hljs-string">&quot;11.52&quot;</span>, <span class="hljs-string">&quot;12.48&quot;</span>, <span class="hljs-string">&quot;12.3778&quot;</span>],
      <span class="hljs-string">&quot;Length1&quot;</span>: [<span class="hljs-string">&quot;23.2&quot;</span>, <span class="hljs-string">&quot;24&quot;</span>, <span class="hljs-string">&quot;23.9&quot;</span>],
      <span class="hljs-string">&quot;Length2&quot;</span>: [<span class="hljs-string">&quot;25.4&quot;</span>, <span class="hljs-string">&quot;26.3&quot;</span>, <span class="hljs-string">&quot;26.5&quot;</span>],
      <span class="hljs-string">&quot;Length3&quot;</span>: [<span class="hljs-string">&quot;30&quot;</span>, <span class="hljs-string">&quot;31.2&quot;</span>, <span class="hljs-string">&quot;31.1&quot;</span>],
      <span class="hljs-string">&quot;Species&quot;</span>: [<span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>, <span class="hljs-string">&quot;Bream&quot;</span>],
      <span class="hljs-string">&quot;Width&quot;</span>: [<span class="hljs-string">&quot;4.02&quot;</span>, <span class="hljs-string">&quot;4.3056&quot;</span>, <span class="hljs-string">&quot;4.6961&quot;</span>]
    },
  },
})`,wrap:!1}}),Tt=new J({props:{title:"Tabular Classification",local:"tabular-classification",headingTag:"h3"}}),wt=new y({props:{code:"YXdhaXQlMjBoZi50YWJ1bGFyQ2xhc3NpZmljYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAlMjJ2dm1ubm5rdiUyRndpbmUtcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMGRhdGElM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmaXhlZF9hY2lkaXR5JTIyJTNBJTIwJTVCJTIyNy40JTIyJTJDJTIwJTIyNy44JTIyJTJDJTIwJTIyMTAuMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnZvbGF0aWxlX2FjaWRpdHklMjIlM0ElMjAlNUIlMjIwLjclMjIlMkMlMjAlMjIwLjg4JTIyJTJDJTIwJTIyMC4zMiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmNpdHJpY19hY2lkJTIyJTNBJTIwJTVCJTIyMCUyMiUyQyUyMCUyMjAlMjIlMkMlMjAlMjIwLjQ1JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycmVzaWR1YWxfc3VnYXIlMjIlM0ElMjAlNUIlMjIxLjklMjIlMkMlMjAlMjIyLjYlMjIlMkMlMjAlMjI2LjQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJjaGxvcmlkZXMlMjIlM0ElMjAlNUIlMjIwLjA3NiUyMiUyQyUyMCUyMjAuMDk4JTIyJTJDJTIwJTIyMC4wNzMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmcmVlX3N1bGZ1cl9kaW94aWRlJTIyJTNBJTIwJTVCJTIyMTElMjIlMkMlMjAlMjIyNSUyMiUyQyUyMCUyMjUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b3RhbF9zdWxmdXJfZGlveGlkZSUyMiUzQSUyMCU1QiUyMjM0JTIyJTJDJTIwJTIyNjclMjIlMkMlMjAlMjIxMyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlbnNpdHklMjIlM0ElMjAlNUIlMjIwLjk5NzglMjIlMkMlMjAlMjIwLjk5NjglMjIlMkMlMjAlMjIwLjk5NzYlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJwSCUyMiUzQSUyMCU1QiUyMjMuNTElMjIlMkMlMjAlMjIzLjIlMjIlMkMlMjAlMjIzLjIzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3VscGhhdGVzJTIyJTNBJTIwJTVCJTIyMC41NiUyMiUyQyUyMCUyMjAuNjglMjIlMkMlMjAlMjIwLjgyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyYWxjb2hvbCUyMiUzQSUyMCU1QiUyMjkuNCUyMiUyQyUyMCUyMjkuOCUyMiUyQyUyMCUyMjEyLjYlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlN0QlMkMlMEElN0Qp",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">tabularClassification</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;vvmnnnkv/wine-quality&quot;</span>,
  <span class="hljs-attr">inputs</span>: {
    <span class="hljs-attr">data</span>: {
      <span class="hljs-string">&quot;fixed_acidity&quot;</span>: [<span class="hljs-string">&quot;7.4&quot;</span>, <span class="hljs-string">&quot;7.8&quot;</span>, <span class="hljs-string">&quot;10.3&quot;</span>],
      <span class="hljs-string">&quot;volatile_acidity&quot;</span>: [<span class="hljs-string">&quot;0.7&quot;</span>, <span class="hljs-string">&quot;0.88&quot;</span>, <span class="hljs-string">&quot;0.32&quot;</span>],
      <span class="hljs-string">&quot;citric_acid&quot;</span>: [<span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0&quot;</span>, <span class="hljs-string">&quot;0.45&quot;</span>],
      <span class="hljs-string">&quot;residual_sugar&quot;</span>: [<span class="hljs-string">&quot;1.9&quot;</span>, <span class="hljs-string">&quot;2.6&quot;</span>, <span class="hljs-string">&quot;6.4&quot;</span>],
      <span class="hljs-string">&quot;chlorides&quot;</span>: [<span class="hljs-string">&quot;0.076&quot;</span>, <span class="hljs-string">&quot;0.098&quot;</span>, <span class="hljs-string">&quot;0.073&quot;</span>],
      <span class="hljs-string">&quot;free_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;11&quot;</span>, <span class="hljs-string">&quot;25&quot;</span>, <span class="hljs-string">&quot;5&quot;</span>],
      <span class="hljs-string">&quot;total_sulfur_dioxide&quot;</span>: [<span class="hljs-string">&quot;34&quot;</span>, <span class="hljs-string">&quot;67&quot;</span>, <span class="hljs-string">&quot;13&quot;</span>],
      <span class="hljs-string">&quot;density&quot;</span>: [<span class="hljs-string">&quot;0.9978&quot;</span>, <span class="hljs-string">&quot;0.9968&quot;</span>, <span class="hljs-string">&quot;0.9976&quot;</span>],
      <span class="hljs-string">&quot;pH&quot;</span>: [<span class="hljs-string">&quot;3.51&quot;</span>, <span class="hljs-string">&quot;3.2&quot;</span>, <span class="hljs-string">&quot;3.23&quot;</span>],
      <span class="hljs-string">&quot;sulphates&quot;</span>: [<span class="hljs-string">&quot;0.56&quot;</span>, <span class="hljs-string">&quot;0.68&quot;</span>, <span class="hljs-string">&quot;0.82&quot;</span>],
      <span class="hljs-string">&quot;alcohol&quot;</span>: [<span class="hljs-string">&quot;9.4&quot;</span>, <span class="hljs-string">&quot;9.8&quot;</span>, <span class="hljs-string">&quot;12.6&quot;</span>]
    },
  },
})`,wrap:!1}}),dt=new J({props:{title:"Custom Calls",local:"custom-calls",headingTag:"h2"}}),$t=new y({props:{code:"YXdhaXQlMjBoZi5yZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBJTJGJTJGJTIwQ3VzdG9tJTIwc3RyZWFtaW5nJTIwY2FsbCUyQyUyMGZvciUyMG1vZGVscyUyMHdpdGglMjBjdXN0b20lMjBwYXJhbWV0ZXJzJTIwJTJGJTIwb3V0cHV0cyUwQWZvciUyMGF3YWl0JTIwKGNvbnN0JTIwb3V0cHV0JTIwb2YlMjBoZi5zdHJlYW1pbmdSZXF1ZXN0KCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ215LWN1c3RvbS1tb2RlbCclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnaGVsbG8lMjB3b3JsZCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BhcmFtJTNBJTIwJ3NvbWUlMjBtYWdpYyclMkMlMEElMjAlMjAlN0QlMEElN0QpKSUyMCU3QiUwQSUyMCUyMC4uLiUwQSU3RA==",highlighted:`<span class="hljs-keyword">await</span> hf.<span class="hljs-title function_">request</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})

<span class="hljs-comment">// Custom streaming call, for models with custom parameters / outputs</span>
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> output <span class="hljs-keyword">of</span> hf.<span class="hljs-title function_">streamingRequest</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;my-custom-model&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;hello world&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">custom_param</span>: <span class="hljs-string">&#x27;some magic&#x27;</span>,
  }
})) {
  ...
}`,wrap:!1}}),It=new J({props:{title:"Custom Inference Endpoints",local:"custom-inference-endpoints",headingTag:"h2"}}),Ct=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0I=",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});`,wrap:!1}}),Bt=new y({props:{code:"Y29uc3QlMjBncHQyJTIwJTNEJTIwaGYuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglMEElMjAlMjAlN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCUyQyUwQSUyMCUyMCU3QnJldHJ5X29uX2Vycm9yJTNBJTIwZmFsc2UlN0QlMkMlMEEpJTNC",highlighted:`<span class="hljs-keyword">const</span> gpt2 = hf.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>(
  {<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>},
  {<span class="hljs-attr">retry_on_error</span>: <span class="hljs-literal">false</span>},
);`,wrap:!1}}),Zt=new J({props:{title:"Running tests",local:"running-tests",headingTag:"h2"}}),kt=new y({props:{code:"SEZfVE9LRU4lM0QlMjJ5b3VyJTIwYWNjZXNzJTIwdG9rZW4lMjIlMjBwbnBtJTIwcnVuJTIwdGVzdA==",highlighted:"HF_TOKEN=&quot;your access token&quot; pnpm run test",wrap:!1}}),Qt=new J({props:{title:"Finding appropriate models",local:"finding-appropriate-models",headingTag:"h2"}}),Et=new on({props:{source:"https://github.com/huggingface/huggingface.js/blob/main/docs/inference/README.md"}}),{c(){u=h("meta"),Xt=e(),vt=h("p"),At=e(),i(g.$$.fragment),Yt=e(),T=h("p"),T.innerHTML=ie,St=e(),f=h("p"),f.innerHTML=pe,Vt=e(),i(w.$$.fragment),Rt=e(),i(d.$$.fragment),qt=e(),i(U.$$.fragment),zt=e(),i($.$$.fragment),Ft=e(),i(I.$$.fragment),_t=e(),i(b.$$.fragment),Ht=e(),i(C.$$.fragment),Lt=e(),i(x.$$.fragment),Dt=e(),B=h("p"),B.innerHTML=Me,Pt=e(),Z=h("p"),Z.textContent=oe,Kt=e(),i(k.$$.fragment),Ot=e(),Q=h("p"),Q.innerHTML=re,sl=e(),i(G.$$.fragment),tl=e(),N=h("p"),N.textContent=ce,ll=e(),i(E.$$.fragment),al=e(),i(v.$$.fragment),el=e(),W=h("p"),W.textContent=he,nl=e(),i(X.$$.fragment),il=e(),i(A.$$.fragment),pl=e(),Y=h("p"),Y.textContent=je,Ml=e(),i(S.$$.fragment),ol=e(),i(V.$$.fragment),rl=e(),R=h("p"),R.textContent=me,cl=e(),i(q.$$.fragment),hl=e(),i(z.$$.fragment),jl=e(),i(F.$$.fragment),ml=e(),i(_.$$.fragment),Jl=e(),H=h("p"),H.textContent=Je,yl=e(),i(L.$$.fragment),ul=e(),i(D.$$.fragment),gl=e(),P=h("p"),P.textContent=ye,Tl=e(),K=h("p"),K.innerHTML=ue,fl=e(),i(O.$$.fragment),wl=e(),i(ss.$$.fragment),dl=e(),ts=h("p"),ts.textContent=ge,Ul=e(),i(ls.$$.fragment),$l=e(),i(as.$$.fragment),Il=e(),es=h("p"),es.textContent=Te,bl=e(),i(ns.$$.fragment),Cl=e(),i(is.$$.fragment),xl=e(),ps=h("p"),ps.textContent=fe,Bl=e(),i(Ms.$$.fragment),Zl=e(),i(os.$$.fragment),kl=e(),rs=h("p"),rs.textContent=we,Ql=e(),i(cs.$$.fragment),Gl=e(),i(hs.$$.fragment),Nl=e(),js=h("p"),js.textContent=de,El=e(),i(ms.$$.fragment),vl=e(),i(Js.$$.fragment),Wl=e(),i(ys.$$.fragment),Xl=e(),us=h("p"),us.textContent=Ue,Al=e(),gs=h("p"),gs.innerHTML=$e,Yl=e(),i(Ts.$$.fragment),Sl=e(),i(fs.$$.fragment),Vl=e(),ws=h("p"),ws.textContent=Ie,Rl=e(),ds=h("p"),ds.innerHTML=be,ql=e(),i(Us.$$.fragment),zl=e(),i($s.$$.fragment),Fl=e(),Is=h("p"),Is.textContent=Ce,_l=e(),bs=h("p"),bs.innerHTML=xe,Hl=e(),i(Cs.$$.fragment),Ll=e(),i(xs.$$.fragment),Dl=e(),Bs=h("p"),Bs.textContent=Be,Pl=e(),i(Zs.$$.fragment),Kl=e(),i(ks.$$.fragment),Ol=e(),i(Qs.$$.fragment),sa=e(),Gs=h("p"),Gs.textContent=Ze,ta=e(),Ns=h("p"),Ns.innerHTML=ke,la=e(),i(Es.$$.fragment),aa=e(),i(vs.$$.fragment),ea=e(),Ws=h("p"),Ws.textContent=Qe,na=e(),Xs=h("p"),Xs.innerHTML=Ge,ia=e(),i(As.$$.fragment),pa=e(),i(Ys.$$.fragment),Ma=e(),Ss=h("p"),Ss.textContent=Ne,oa=e(),i(Vs.$$.fragment),ra=e(),i(Rs.$$.fragment),ca=e(),qs=h("p"),qs.textContent=Ee,ha=e(),i(zs.$$.fragment),ja=e(),i(Fs.$$.fragment),ma=e(),_s=h("p"),_s.textContent=ve,Ja=e(),Hs=h("p"),Hs.innerHTML=We,ya=e(),i(Ls.$$.fragment),ua=e(),i(Ds.$$.fragment),ga=e(),Ps=h("p"),Ps.textContent=Xe,Ta=e(),Ks=h("p"),Ks.innerHTML=Ae,fa=e(),i(Os.$$.fragment),wa=e(),i(st.$$.fragment),da=e(),tt=h("p"),tt.textContent=Ye,Ua=e(),i(lt.$$.fragment),$a=e(),i(at.$$.fragment),Ia=e(),i(et.$$.fragment),ba=e(),nt=h("p"),nt.textContent=Se,Ca=e(),i(it.$$.fragment),xa=e(),i(pt.$$.fragment),Ba=e(),Mt=h("p"),Mt.textContent=Ve,Za=e(),ot=h("p"),ot.innerHTML=Re,ka=e(),i(rt.$$.fragment),Qa=e(),i(ct.$$.fragment),Ga=e(),ht=h("p"),ht.textContent=qe,Na=e(),jt=h("p"),jt.innerHTML=ze,Ea=e(),i(mt.$$.fragment),va=e(),i(Jt.$$.fragment),Wa=e(),i(yt.$$.fragment),Xa=e(),ut=h("p"),ut.textContent=Fe,Aa=e(),i(gt.$$.fragment),Ya=e(),i(Tt.$$.fragment),Sa=e(),ft=h("p"),ft.textContent=_e,Va=e(),i(wt.$$.fragment),Ra=e(),i(dt.$$.fragment),qa=e(),Ut=h("p"),Ut.textContent=He,za=e(),i($t.$$.fragment),Fa=e(),i(It.$$.fragment),_a=e(),bt=h("p"),bt.innerHTML=Le,Ha=e(),i(Ct.$$.fragment),La=e(),xt=h("p"),xt.innerHTML=De,Da=e(),i(Bt.$$.fragment),Pa=e(),i(Zt.$$.fragment),Ka=e(),i(kt.$$.fragment),Oa=e(),i(Qt.$$.fragment),se=e(),Gt=h("p"),Gt.innerHTML=Pe,te=e(),Nt=h("p"),Nt.textContent=Ke,le=e(),i(Et.$$.fragment),ae=e(),Wt=h("p"),this.h()},l(s){const t=pn("svelte-u9bgzb",document.head);u=j(t,"META",{name:!0,content:!0}),t.forEach(l),Xt=n(s),vt=j(s,"P",{}),Oe(vt).forEach(l),At=n(s),p(g.$$.fragment,s),Yt=n(s),T=j(s,"P",{"data-svelte-h":!0}),m(T)!=="svelte-6gwev"&&(T.innerHTML=ie),St=n(s),f=j(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1pkj38e"&&(f.innerHTML=pe),Vt=n(s),p(w.$$.fragment,s),Rt=n(s),p(d.$$.fragment,s),qt=n(s),p(U.$$.fragment,s),zt=n(s),p($.$$.fragment,s),Ft=n(s),p(I.$$.fragment,s),_t=n(s),p(b.$$.fragment,s),Ht=n(s),p(C.$$.fragment,s),Lt=n(s),p(x.$$.fragment,s),Dt=n(s),B=j(s,"P",{"data-svelte-h":!0}),m(B)!=="svelte-ys53zo"&&(B.innerHTML=Me),Pt=n(s),Z=j(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-2l8ybr"&&(Z.textContent=oe),Kt=n(s),p(k.$$.fragment,s),Ot=n(s),Q=j(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-62skcu"&&(Q.innerHTML=re),sl=n(s),p(G.$$.fragment,s),tl=n(s),N=j(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-88xj6h"&&(N.textContent=ce),ll=n(s),p(E.$$.fragment,s),al=n(s),p(v.$$.fragment,s),el=n(s),W=j(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1mnrr3b"&&(W.textContent=he),nl=n(s),p(X.$$.fragment,s),il=n(s),p(A.$$.fragment,s),pl=n(s),Y=j(s,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-4s1xv3"&&(Y.textContent=je),Ml=n(s),p(S.$$.fragment,s),ol=n(s),p(V.$$.fragment,s),rl=n(s),R=j(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-vnhv92"&&(R.textContent=me),cl=n(s),p(q.$$.fragment,s),hl=n(s),p(z.$$.fragment,s),jl=n(s),p(F.$$.fragment,s),ml=n(s),p(_.$$.fragment,s),Jl=n(s),H=j(s,"P",{"data-svelte-h":!0}),m(H)!=="svelte-vlz10z"&&(H.textContent=Je),yl=n(s),p(L.$$.fragment,s),ul=n(s),p(D.$$.fragment,s),gl=n(s),P=j(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-18cimv4"&&(P.textContent=ye),Tl=n(s),K=j(s,"P",{"data-svelte-h":!0}),m(K)!=="svelte-kjz90x"&&(K.innerHTML=ue),fl=n(s),p(O.$$.fragment,s),wl=n(s),p(ss.$$.fragment,s),dl=n(s),ts=j(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-qln4hq"&&(ts.textContent=ge),Ul=n(s),p(ls.$$.fragment,s),$l=n(s),p(as.$$.fragment,s),Il=n(s),es=j(s,"P",{"data-svelte-h":!0}),m(es)!=="svelte-yinzpl"&&(es.textContent=Te),bl=n(s),p(ns.$$.fragment,s),Cl=n(s),p(is.$$.fragment,s),xl=n(s),ps=j(s,"P",{"data-svelte-h":!0}),m(ps)!=="svelte-mqluby"&&(ps.textContent=fe),Bl=n(s),p(Ms.$$.fragment,s),Zl=n(s),p(os.$$.fragment,s),kl=n(s),rs=j(s,"P",{"data-svelte-h":!0}),m(rs)!=="svelte-1wq8md5"&&(rs.textContent=we),Ql=n(s),p(cs.$$.fragment,s),Gl=n(s),p(hs.$$.fragment,s),Nl=n(s),js=j(s,"P",{"data-svelte-h":!0}),m(js)!=="svelte-tf7teq"&&(js.textContent=de),El=n(s),p(ms.$$.fragment,s),vl=n(s),p(Js.$$.fragment,s),Wl=n(s),p(ys.$$.fragment,s),Xl=n(s),us=j(s,"P",{"data-svelte-h":!0}),m(us)!=="svelte-1in7idl"&&(us.textContent=Ue),Al=n(s),gs=j(s,"P",{"data-svelte-h":!0}),m(gs)!=="svelte-18afluh"&&(gs.innerHTML=$e),Yl=n(s),p(Ts.$$.fragment,s),Sl=n(s),p(fs.$$.fragment,s),Vl=n(s),ws=j(s,"P",{"data-svelte-h":!0}),m(ws)!=="svelte-12s1din"&&(ws.textContent=Ie),Rl=n(s),ds=j(s,"P",{"data-svelte-h":!0}),m(ds)!=="svelte-1jpdfy8"&&(ds.innerHTML=be),ql=n(s),p(Us.$$.fragment,s),zl=n(s),p($s.$$.fragment,s),Fl=n(s),Is=j(s,"P",{"data-svelte-h":!0}),m(Is)!=="svelte-1h8ubig"&&(Is.textContent=Ce),_l=n(s),bs=j(s,"P",{"data-svelte-h":!0}),m(bs)!=="svelte-1edrfzt"&&(bs.innerHTML=xe),Hl=n(s),p(Cs.$$.fragment,s),Ll=n(s),p(xs.$$.fragment,s),Dl=n(s),Bs=j(s,"P",{"data-svelte-h":!0}),m(Bs)!=="svelte-zj5o06"&&(Bs.textContent=Be),Pl=n(s),p(Zs.$$.fragment,s),Kl=n(s),p(ks.$$.fragment,s),Ol=n(s),p(Qs.$$.fragment,s),sa=n(s),Gs=j(s,"P",{"data-svelte-h":!0}),m(Gs)!=="svelte-1nlp89w"&&(Gs.textContent=Ze),ta=n(s),Ns=j(s,"P",{"data-svelte-h":!0}),m(Ns)!=="svelte-10vvvxx"&&(Ns.innerHTML=ke),la=n(s),p(Es.$$.fragment,s),aa=n(s),p(vs.$$.fragment,s),ea=n(s),Ws=j(s,"P",{"data-svelte-h":!0}),m(Ws)!=="svelte-d15mev"&&(Ws.textContent=Qe),na=n(s),Xs=j(s,"P",{"data-svelte-h":!0}),m(Xs)!=="svelte-pxrbuw"&&(Xs.innerHTML=Ge),ia=n(s),p(As.$$.fragment,s),pa=n(s),p(Ys.$$.fragment,s),Ma=n(s),Ss=j(s,"P",{"data-svelte-h":!0}),m(Ss)!=="svelte-1oenl8f"&&(Ss.textContent=Ne),oa=n(s),p(Vs.$$.fragment,s),ra=n(s),p(Rs.$$.fragment,s),ca=n(s),qs=j(s,"P",{"data-svelte-h":!0}),m(qs)!=="svelte-66badz"&&(qs.textContent=Ee),ha=n(s),p(zs.$$.fragment,s),ja=n(s),p(Fs.$$.fragment,s),ma=n(s),_s=j(s,"P",{"data-svelte-h":!0}),m(_s)!=="svelte-13iv3hh"&&(_s.textContent=ve),Ja=n(s),Hs=j(s,"P",{"data-svelte-h":!0}),m(Hs)!=="svelte-1mgyz4r"&&(Hs.innerHTML=We),ya=n(s),p(Ls.$$.fragment,s),ua=n(s),p(Ds.$$.fragment,s),ga=n(s),Ps=j(s,"P",{"data-svelte-h":!0}),m(Ps)!=="svelte-1y7kqaa"&&(Ps.textContent=Xe),Ta=n(s),Ks=j(s,"P",{"data-svelte-h":!0}),m(Ks)!=="svelte-m8xmew"&&(Ks.innerHTML=Ae),fa=n(s),p(Os.$$.fragment,s),wa=n(s),p(st.$$.fragment,s),da=n(s),tt=j(s,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-m7q2yg"&&(tt.textContent=Ye),Ua=n(s),p(lt.$$.fragment,s),$a=n(s),p(at.$$.fragment,s),Ia=n(s),p(et.$$.fragment,s),ba=n(s),nt=j(s,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-174b8m1"&&(nt.textContent=Se),Ca=n(s),p(it.$$.fragment,s),xa=n(s),p(pt.$$.fragment,s),Ba=n(s),Mt=j(s,"P",{"data-svelte-h":!0}),m(Mt)!=="svelte-cnruui"&&(Mt.textContent=Ve),Za=n(s),ot=j(s,"P",{"data-svelte-h":!0}),m(ot)!=="svelte-hwgezm"&&(ot.innerHTML=Re),ka=n(s),p(rt.$$.fragment,s),Qa=n(s),p(ct.$$.fragment,s),Ga=n(s),ht=j(s,"P",{"data-svelte-h":!0}),m(ht)!=="svelte-1tpexz3"&&(ht.textContent=qe),Na=n(s),jt=j(s,"P",{"data-svelte-h":!0}),m(jt)!=="svelte-hwgezm"&&(jt.innerHTML=ze),Ea=n(s),p(mt.$$.fragment,s),va=n(s),p(Jt.$$.fragment,s),Wa=n(s),p(yt.$$.fragment,s),Xa=n(s),ut=j(s,"P",{"data-svelte-h":!0}),m(ut)!=="svelte-1js246c"&&(ut.textContent=Fe),Aa=n(s),p(gt.$$.fragment,s),Ya=n(s),p(Tt.$$.fragment,s),Sa=n(s),ft=j(s,"P",{"data-svelte-h":!0}),m(ft)!=="svelte-7l7zu1"&&(ft.textContent=_e),Va=n(s),p(wt.$$.fragment,s),Ra=n(s),p(dt.$$.fragment,s),qa=n(s),Ut=j(s,"P",{"data-svelte-h":!0}),m(Ut)!=="svelte-1uv5lul"&&(Ut.textContent=He),za=n(s),p($t.$$.fragment,s),Fa=n(s),p(It.$$.fragment,s),_a=n(s),bt=j(s,"P",{"data-svelte-h":!0}),m(bt)!=="svelte-14q869u"&&(bt.innerHTML=Le),Ha=n(s),p(Ct.$$.fragment,s),La=n(s),xt=j(s,"P",{"data-svelte-h":!0}),m(xt)!=="svelte-16znzc1"&&(xt.innerHTML=De),Da=n(s),p(Bt.$$.fragment,s),Pa=n(s),p(Zt.$$.fragment,s),Ka=n(s),p(kt.$$.fragment,s),Oa=n(s),p(Qt.$$.fragment,s),se=n(s),Gt=j(s,"P",{"data-svelte-h":!0}),m(Gt)!=="svelte-62a9et"&&(Gt.innerHTML=Pe),te=n(s),Nt=j(s,"P",{"data-svelte-h":!0}),m(Nt)!=="svelte-1yyf4wc"&&(Nt.textContent=Ke),le=n(s),p(Et.$$.fragment,s),ae=n(s),Wt=j(s,"P",{}),Oe(Wt).forEach(l),this.h()},h(){sn(u,"name","hf:doc:metadata"),sn(u,"content",cn)},m(s,t){Mn(document.head,u),a(s,Xt,t),a(s,vt,t),a(s,At,t),M(g,s,t),a(s,Yt,t),a(s,T,t),a(s,St,t),a(s,f,t),a(s,Vt,t),M(w,s,t),a(s,Rt,t),M(d,s,t),a(s,qt,t),M(U,s,t),a(s,zt,t),M($,s,t),a(s,Ft,t),M(I,s,t),a(s,_t,t),M(b,s,t),a(s,Ht,t),M(C,s,t),a(s,Lt,t),M(x,s,t),a(s,Dt,t),a(s,B,t),a(s,Pt,t),a(s,Z,t),a(s,Kt,t),M(k,s,t),a(s,Ot,t),a(s,Q,t),a(s,sl,t),M(G,s,t),a(s,tl,t),a(s,N,t),a(s,ll,t),M(E,s,t),a(s,al,t),M(v,s,t),a(s,el,t),a(s,W,t),a(s,nl,t),M(X,s,t),a(s,il,t),M(A,s,t),a(s,pl,t),a(s,Y,t),a(s,Ml,t),M(S,s,t),a(s,ol,t),M(V,s,t),a(s,rl,t),a(s,R,t),a(s,cl,t),M(q,s,t),a(s,hl,t),M(z,s,t),a(s,jl,t),M(F,s,t),a(s,ml,t),M(_,s,t),a(s,Jl,t),a(s,H,t),a(s,yl,t),M(L,s,t),a(s,ul,t),M(D,s,t),a(s,gl,t),a(s,P,t),a(s,Tl,t),a(s,K,t),a(s,fl,t),M(O,s,t),a(s,wl,t),M(ss,s,t),a(s,dl,t),a(s,ts,t),a(s,Ul,t),M(ls,s,t),a(s,$l,t),M(as,s,t),a(s,Il,t),a(s,es,t),a(s,bl,t),M(ns,s,t),a(s,Cl,t),M(is,s,t),a(s,xl,t),a(s,ps,t),a(s,Bl,t),M(Ms,s,t),a(s,Zl,t),M(os,s,t),a(s,kl,t),a(s,rs,t),a(s,Ql,t),M(cs,s,t),a(s,Gl,t),M(hs,s,t),a(s,Nl,t),a(s,js,t),a(s,El,t),M(ms,s,t),a(s,vl,t),M(Js,s,t),a(s,Wl,t),M(ys,s,t),a(s,Xl,t),a(s,us,t),a(s,Al,t),a(s,gs,t),a(s,Yl,t),M(Ts,s,t),a(s,Sl,t),M(fs,s,t),a(s,Vl,t),a(s,ws,t),a(s,Rl,t),a(s,ds,t),a(s,ql,t),M(Us,s,t),a(s,zl,t),M($s,s,t),a(s,Fl,t),a(s,Is,t),a(s,_l,t),a(s,bs,t),a(s,Hl,t),M(Cs,s,t),a(s,Ll,t),M(xs,s,t),a(s,Dl,t),a(s,Bs,t),a(s,Pl,t),M(Zs,s,t),a(s,Kl,t),M(ks,s,t),a(s,Ol,t),M(Qs,s,t),a(s,sa,t),a(s,Gs,t),a(s,ta,t),a(s,Ns,t),a(s,la,t),M(Es,s,t),a(s,aa,t),M(vs,s,t),a(s,ea,t),a(s,Ws,t),a(s,na,t),a(s,Xs,t),a(s,ia,t),M(As,s,t),a(s,pa,t),M(Ys,s,t),a(s,Ma,t),a(s,Ss,t),a(s,oa,t),M(Vs,s,t),a(s,ra,t),M(Rs,s,t),a(s,ca,t),a(s,qs,t),a(s,ha,t),M(zs,s,t),a(s,ja,t),M(Fs,s,t),a(s,ma,t),a(s,_s,t),a(s,Ja,t),a(s,Hs,t),a(s,ya,t),M(Ls,s,t),a(s,ua,t),M(Ds,s,t),a(s,ga,t),a(s,Ps,t),a(s,Ta,t),a(s,Ks,t),a(s,fa,t),M(Os,s,t),a(s,wa,t),M(st,s,t),a(s,da,t),a(s,tt,t),a(s,Ua,t),M(lt,s,t),a(s,$a,t),M(at,s,t),a(s,Ia,t),M(et,s,t),a(s,ba,t),a(s,nt,t),a(s,Ca,t),M(it,s,t),a(s,xa,t),M(pt,s,t),a(s,Ba,t),a(s,Mt,t),a(s,Za,t),a(s,ot,t),a(s,ka,t),M(rt,s,t),a(s,Qa,t),M(ct,s,t),a(s,Ga,t),a(s,ht,t),a(s,Na,t),a(s,jt,t),a(s,Ea,t),M(mt,s,t),a(s,va,t),M(Jt,s,t),a(s,Wa,t),M(yt,s,t),a(s,Xa,t),a(s,ut,t),a(s,Aa,t),M(gt,s,t),a(s,Ya,t),M(Tt,s,t),a(s,Sa,t),a(s,ft,t),a(s,Va,t),M(wt,s,t),a(s,Ra,t),M(dt,s,t),a(s,qa,t),a(s,Ut,t),a(s,za,t),M($t,s,t),a(s,Fa,t),M(It,s,t),a(s,_a,t),a(s,bt,t),a(s,Ha,t),M(Ct,s,t),a(s,La,t),a(s,xt,t),a(s,Da,t),M(Bt,s,t),a(s,Pa,t),M(Zt,s,t),a(s,Ka,t),M(kt,s,t),a(s,Oa,t),M(Qt,s,t),a(s,se,t),a(s,Gt,t),a(s,te,t),a(s,Nt,t),a(s,le,t),M(Et,s,t),a(s,ae,t),a(s,Wt,t),ee=!0},p:ln,i(s){ee||(o(g.$$.fragment,s),o(w.$$.fragment,s),o(d.$$.fragment,s),o(U.$$.fragment,s),o($.$$.fragment,s),o(I.$$.fragment,s),o(b.$$.fragment,s),o(C.$$.fragment,s),o(x.$$.fragment,s),o(k.$$.fragment,s),o(G.$$.fragment,s),o(E.$$.fragment,s),o(v.$$.fragment,s),o(X.$$.fragment,s),o(A.$$.fragment,s),o(S.$$.fragment,s),o(V.$$.fragment,s),o(q.$$.fragment,s),o(z.$$.fragment,s),o(F.$$.fragment,s),o(_.$$.fragment,s),o(L.$$.fragment,s),o(D.$$.fragment,s),o(O.$$.fragment,s),o(ss.$$.fragment,s),o(ls.$$.fragment,s),o(as.$$.fragment,s),o(ns.$$.fragment,s),o(is.$$.fragment,s),o(Ms.$$.fragment,s),o(os.$$.fragment,s),o(cs.$$.fragment,s),o(hs.$$.fragment,s),o(ms.$$.fragment,s),o(Js.$$.fragment,s),o(ys.$$.fragment,s),o(Ts.$$.fragment,s),o(fs.$$.fragment,s),o(Us.$$.fragment,s),o($s.$$.fragment,s),o(Cs.$$.fragment,s),o(xs.$$.fragment,s),o(Zs.$$.fragment,s),o(ks.$$.fragment,s),o(Qs.$$.fragment,s),o(Es.$$.fragment,s),o(vs.$$.fragment,s),o(As.$$.fragment,s),o(Ys.$$.fragment,s),o(Vs.$$.fragment,s),o(Rs.$$.fragment,s),o(zs.$$.fragment,s),o(Fs.$$.fragment,s),o(Ls.$$.fragment,s),o(Ds.$$.fragment,s),o(Os.$$.fragment,s),o(st.$$.fragment,s),o(lt.$$.fragment,s),o(at.$$.fragment,s),o(et.$$.fragment,s),o(it.$$.fragment,s),o(pt.$$.fragment,s),o(rt.$$.fragment,s),o(ct.$$.fragment,s),o(mt.$$.fragment,s),o(Jt.$$.fragment,s),o(yt.$$.fragment,s),o(gt.$$.fragment,s),o(Tt.$$.fragment,s),o(wt.$$.fragment,s),o(dt.$$.fragment,s),o($t.$$.fragment,s),o(It.$$.fragment,s),o(Ct.$$.fragment,s),o(Bt.$$.fragment,s),o(Zt.$$.fragment,s),o(kt.$$.fragment,s),o(Qt.$$.fragment,s),o(Et.$$.fragment,s),ee=!0)},o(s){r(g.$$.fragment,s),r(w.$$.fragment,s),r(d.$$.fragment,s),r(U.$$.fragment,s),r($.$$.fragment,s),r(I.$$.fragment,s),r(b.$$.fragment,s),r(C.$$.fragment,s),r(x.$$.fragment,s),r(k.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(v.$$.fragment,s),r(X.$$.fragment,s),r(A.$$.fragment,s),r(S.$$.fragment,s),r(V.$$.fragment,s),r(q.$$.fragment,s),r(z.$$.fragment,s),r(F.$$.fragment,s),r(_.$$.fragment,s),r(L.$$.fragment,s),r(D.$$.fragment,s),r(O.$$.fragment,s),r(ss.$$.fragment,s),r(ls.$$.fragment,s),r(as.$$.fragment,s),r(ns.$$.fragment,s),r(is.$$.fragment,s),r(Ms.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(hs.$$.fragment,s),r(ms.$$.fragment,s),r(Js.$$.fragment,s),r(ys.$$.fragment,s),r(Ts.$$.fragment,s),r(fs.$$.fragment,s),r(Us.$$.fragment,s),r($s.$$.fragment,s),r(Cs.$$.fragment,s),r(xs.$$.fragment,s),r(Zs.$$.fragment,s),r(ks.$$.fragment,s),r(Qs.$$.fragment,s),r(Es.$$.fragment,s),r(vs.$$.fragment,s),r(As.$$.fragment,s),r(Ys.$$.fragment,s),r(Vs.$$.fragment,s),r(Rs.$$.fragment,s),r(zs.$$.fragment,s),r(Fs.$$.fragment,s),r(Ls.$$.fragment,s),r(Ds.$$.fragment,s),r(Os.$$.fragment,s),r(st.$$.fragment,s),r(lt.$$.fragment,s),r(at.$$.fragment,s),r(et.$$.fragment,s),r(it.$$.fragment,s),r(pt.$$.fragment,s),r(rt.$$.fragment,s),r(ct.$$.fragment,s),r(mt.$$.fragment,s),r(Jt.$$.fragment,s),r(yt.$$.fragment,s),r(gt.$$.fragment,s),r(Tt.$$.fragment,s),r(wt.$$.fragment,s),r(dt.$$.fragment,s),r($t.$$.fragment,s),r(It.$$.fragment,s),r(Ct.$$.fragment,s),r(Bt.$$.fragment,s),r(Zt.$$.fragment,s),r(kt.$$.fragment,s),r(Qt.$$.fragment,s),r(Et.$$.fragment,s),ee=!1},d(s){s&&(l(Xt),l(vt),l(At),l(Yt),l(T),l(St),l(f),l(Vt),l(Rt),l(qt),l(zt),l(Ft),l(_t),l(Ht),l(Lt),l(Dt),l(B),l(Pt),l(Z),l(Kt),l(Ot),l(Q),l(sl),l(tl),l(N),l(ll),l(al),l(el),l(W),l(nl),l(il),l(pl),l(Y),l(Ml),l(ol),l(rl),l(R),l(cl),l(hl),l(jl),l(ml),l(Jl),l(H),l(yl),l(ul),l(gl),l(P),l(Tl),l(K),l(fl),l(wl),l(dl),l(ts),l(Ul),l($l),l(Il),l(es),l(bl),l(Cl),l(xl),l(ps),l(Bl),l(Zl),l(kl),l(rs),l(Ql),l(Gl),l(Nl),l(js),l(El),l(vl),l(Wl),l(Xl),l(us),l(Al),l(gs),l(Yl),l(Sl),l(Vl),l(ws),l(Rl),l(ds),l(ql),l(zl),l(Fl),l(Is),l(_l),l(bs),l(Hl),l(Ll),l(Dl),l(Bs),l(Pl),l(Kl),l(Ol),l(sa),l(Gs),l(ta),l(Ns),l(la),l(aa),l(ea),l(Ws),l(na),l(Xs),l(ia),l(pa),l(Ma),l(Ss),l(oa),l(ra),l(ca),l(qs),l(ha),l(ja),l(ma),l(_s),l(Ja),l(Hs),l(ya),l(ua),l(ga),l(Ps),l(Ta),l(Ks),l(fa),l(wa),l(da),l(tt),l(Ua),l($a),l(Ia),l(ba),l(nt),l(Ca),l(xa),l(Ba),l(Mt),l(Za),l(ot),l(ka),l(Qa),l(Ga),l(ht),l(Na),l(jt),l(Ea),l(va),l(Wa),l(Xa),l(ut),l(Aa),l(Ya),l(Sa),l(ft),l(Va),l(Ra),l(qa),l(Ut),l(za),l(Fa),l(_a),l(bt),l(Ha),l(La),l(xt),l(Da),l(Pa),l(Ka),l(Oa),l(se),l(Gt),l(te),l(Nt),l(le),l(ae),l(Wt)),l(u),c(g,s),c(w,s),c(d,s),c(U,s),c($,s),c(I,s),c(b,s),c(C,s),c(x,s),c(k,s),c(G,s),c(E,s),c(v,s),c(X,s),c(A,s),c(S,s),c(V,s),c(q,s),c(z,s),c(F,s),c(_,s),c(L,s),c(D,s),c(O,s),c(ss,s),c(ls,s),c(as,s),c(ns,s),c(is,s),c(Ms,s),c(os,s),c(cs,s),c(hs,s),c(ms,s),c(Js,s),c(ys,s),c(Ts,s),c(fs,s),c(Us,s),c($s,s),c(Cs,s),c(xs,s),c(Zs,s),c(ks,s),c(Qs,s),c(Es,s),c(vs,s),c(As,s),c(Ys,s),c(Vs,s),c(Rs,s),c(zs,s),c(Fs,s),c(Ls,s),c(Ds,s),c(Os,s),c(st,s),c(lt,s),c(at,s),c(et,s),c(it,s),c(pt,s),c(rt,s),c(ct,s),c(mt,s),c(Jt,s),c(yt,s),c(gt,s),c(Tt,s),c(wt,s),c(dt,s),c($t,s),c(It,s),c(Ct,s),c(Bt,s),c(Zt,s),c(kt,s),c(Qt,s),c(Et,s)}}}const cn='{"title":"🤗 Hugging Face Inference Endpoints","local":"-hugging-face-inference-endpoints","sections":[{"title":"Getting Started","local":"getting-started","sections":[{"title":"Install","local":"install","sections":[{"title":"Node","local":"node","sections":[],"depth":4},{"title":"Deno","local":"deno","sections":[],"depth":4}],"depth":3},{"title":"Initialize","local":"initialize","sections":[{"title":"Tree-shaking","local":"tree-shaking","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"Fill Mask","local":"fill-mask","sections":[],"depth":3},{"title":"Summarization","local":"summarization","sections":[],"depth":3},{"title":"Question Answering","local":"question-answering","sections":[],"depth":3},{"title":"Table Question Answering","local":"table-question-answering","sections":[],"depth":3},{"title":"Text Classification","local":"text-classification","sections":[],"depth":3},{"title":"Text Generation","local":"text-generation","sections":[],"depth":3},{"title":"Token Classification","local":"token-classification","sections":[],"depth":3},{"title":"Translation","local":"translation","sections":[],"depth":3},{"title":"Zero-Shot Classification","local":"zero-shot-classification","sections":[],"depth":3},{"title":"Conversational","local":"conversational","sections":[],"depth":3},{"title":"Sentence Similarity","local":"sentence-similarity","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"Automatic Speech Recognition","local":"automatic-speech-recognition","sections":[],"depth":3},{"title":"Audio Classification","local":"audio-classification","sections":[],"depth":3},{"title":"Text To Speech","local":"text-to-speech","sections":[],"depth":3},{"title":"Audio To Audio","local":"audio-to-audio","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"Image Classification","local":"image-classification","sections":[],"depth":3},{"title":"Object Detection","local":"object-detection","sections":[],"depth":3},{"title":"Image Segmentation","local":"image-segmentation","sections":[],"depth":3},{"title":"Image To Text","local":"image-to-text","sections":[],"depth":3},{"title":"Text To Image","local":"text-to-image","sections":[],"depth":3},{"title":"Image To Image","local":"image-to-image","sections":[],"depth":3},{"title":"Zero Shot Image Classification","local":"zero-shot-image-classification","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"Feature Extraction","local":"feature-extraction","sections":[],"depth":3},{"title":"Visual Question Answering","local":"visual-question-answering","sections":[],"depth":3},{"title":"Document Question Answering","local":"document-question-answering","sections":[],"depth":3}],"depth":2},{"title":"Tabular","local":"tabular","sections":[{"title":"Tabular Regression","local":"tabular-regression","sections":[],"depth":3},{"title":"Tabular Classification","local":"tabular-classification","sections":[],"depth":3}],"depth":2},{"title":"Custom Calls","local":"custom-calls","sections":[],"depth":2},{"title":"Custom Inference Endpoints","local":"custom-inference-endpoints","sections":[],"depth":2},{"title":"Running tests","local":"running-tests","sections":[],"depth":2},{"title":"Finding appropriate models","local":"finding-appropriate-models","sections":[],"depth":2}],"depth":1}';function hn(ne){return an(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class un extends en{constructor(u){super(),nn(this,u,hn,rn,tn,{})}}export{un as component};
