import{s as Ee,f as he,n as We,o as Ae}from"../chunks/scheduler.37c15a92.js";import{S as xe,i as qe,g as o,s as a,r as d,m as ze,A as Se,h as r,f as t,c as n,j as R,u as y,x as m,n as Xe,k as i,y as Re,a as l,v as h,d as j,t as w,w as J}from"../chunks/index.2bf4358c.js";import{C as je}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ye}from"../chunks/CourseFloatingBanner.5dff5e20.js";import{H as ye}from"../chunks/Heading.8ada512a.js";function $e(we){let M,Y,S,$,f,_,b,F,U,Je="Maintenant que nous pouvons construire et partager une interface de base, explorons quelques fonctionnalités plus avancées comme l’état, l’interprétation et l’authentification.",V,T,H,g,fe="<em>Gradio</em> supporte <em>l’état de session</em> où les données persistent à travers plusieurs soumissions dans un chargement de page. L’état de session est utile pour construire des démos où vous souhaitez faire persister les données au fur et à mesure que l’utilisateur interagit avec le modèle (par exemple des chatbots). Notez que l’état de session ne partage pas les données entre les différents utilisateurs de votre modèle.",L,I,be="Pour stocker des données dans un état de session, vous devez faire trois choses :",K,G,Ue="<li>Passez un <em>paramètre supplémentaire</em> dans votre fonction, qui représente l’état de l’interface.</li> <li>A la fin de la fonction, renvoyer la valeur mise à jour de l’état comme une <em>valeur de retour supplémentaire</em>.</li> <li>Ajoutez les composants “state” input et “state” output lors de la création de votre <code>Interface</code>.</li>",P,C,Te="Voir l’exemple de chatbot ci-dessous :",D,v,O,p,ge,ee,k,se,B,Ie="La plupart des modèles d’apprentissage automatique sont des boîtes noires et la logique interne de la fonction est cachée à l’utilisateur final. Pour encourager la transparence, nous avons fait en sorte qu’il soit très facile d’ajouter l’interprétation à votre modèle en définissant simplement le mot-clé interprétation dans la classe Interface par défaut. Cela permet à vos utilisateurs de comprendre quelles parties de l’entrée sont responsables de la sortie. Jetez un coup d’œil à l’interface simple ci-dessous qui montre un classifieur d’images incluant l’interprétation :",te,Z,le,N,Ge="Testez la fonction d’interprétation en soumettant une entrée puis en cliquant sur « Interpréter » sous le composant de sortie.",ae,c,Ce,ne,Q,ve=`En plus de la méthode d’interprétation par défaut fournie par <em>Gradio</em>, vous pouvez également spécifier <code>shap</code> pour le paramètre <code>interpretation</code> et définir le paramètre <code>num_shap</code>. Ceci utilise l’interprétation basée sur Shapley, dont vous pouvez lire plus sur <a href="https://christophm.github.io/interpretable-ml-book/shap.html" rel="nofollow">ici</a>.
Enfin, vous pouvez aussi passer votre propre fonction d’interprétation dans le paramètre <code>interpretation</code>. Vous trouverez un exemple dans la page de démarrage de <em>Gradio</em> <a href="https://gradio.app/getting_started/" rel="nofollow">ici</a>.`,ie,E,oe,W,ke="Vous pouvez vouloir ajouter une authentification à votre interface <em>Gradio</em> afin de contrôler qui peut accéder et utiliser votre démo.",re,A,Be="L’authentification peut être ajoutée en fournissant une liste de tuples de nom d’utilisateur/mot de passe au paramètre <code>auth</code> de la méthode <code>launch()</code>. Pour une gestion plus complexe de l’authentification, vous pouvez passer une fonction qui prend un nom d’utilisateur et un mot de passe comme arguments, et retourne <code>True</code> pour permettre l’authentification, <code>False</code> sinon.",pe,x,Ze="Prenons la démo de classification d’images ci-dessus et ajoutons l’authentification :",ce,q,ue,u,Ne,me,z,Qe="Ceci conclut notre plongée dans la classe <code>Interface</code> de <em>Gradio</em>. Comme nous l’avons vu, cette classe permet de créer facilement des démos d’apprentissage automatique en quelques lignes de code Python. Cependant, vous voudrez parfois personnaliser votre démo en changeant la mise en page ou en enchaînant plusieurs fonctions de prédiction. Ne serait-il pas agréable de pouvoir diviser l’interface en blocs personnalisables ? Heureusement, c’est possible ! C’est le sujet de la dernière section.",Me,X,de;return f=new ye({props:{title:"Fonctionnalités avancées de l’interface",local:"fonctionnalités-avancées-de-linterface",headingTag:"h1"}}),b=new Ye({props:{chapter:9,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"English",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"},{label:"Français",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/fr/chapter9/section6.ipynb"},{label:"English",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter9/section6.ipynb"},{label:"Français",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/fr/chapter9/section6.ipynb"}]}}),T=new ye({props:{title:"Utilisation de l’état pour faire persister les données",local:"utilisation-de-létat-pour-faire-persister-les-données",headingTag:"h3"}}),v=new je({props:{code:"aW1wb3J0JTIwcmFuZG9tJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQSUwQSUwQWRlZiUyMGNoYXQobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwaGlzdG9yeSUyMCUzRCUyMGhpc3RvcnklMjBvciUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZS5zdGFydHN3aXRoKCUyMkhvdyUyMG1hbnklMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20ucmFuZGludCgxJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJIb3clMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByYW5kb20uY2hvaWNlKCU1QiUyMkdyZWF0JTIyJTJDJTIwJTIyR29vZCUyMiUyQyUyMCUyMk9rYXklMjIlMkMlMjAlMjJCYWQlMjIlNUQpJTBBJTIwJTIwJTIwJTIwZWxpZiUyMG1lc3NhZ2Uuc3RhcnRzd2l0aCglMjJXaGVyZSUyMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMHJhbmRvbS5jaG9pY2UoJTVCJTIySGVyZSUyMiUyQyUyMCUyMlRoZXJlJTIyJTJDJTIwJTIyU29tZXdoZXJlJTIyJTVEKSUwQSUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNwb25zZSUyMCUzRCUyMCUyMkklMjBkb24ndCUyMGtub3clMjIlMEElMjAlMjAlMjAlMjBoaXN0b3J5LmFwcGVuZCgobWVzc2FnZSUyQyUyMHJlc3BvbnNlKSklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBoaXN0b3J5JTJDJTIwaGlzdG9yeSUwQSUwQSUwQWlmYWNlJTIwJTNEJTIwZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGNoYXQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJ0ZXh0JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlNUIlMjJjaGF0Ym90JTIyJTJDJTIwJTIyc3RhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19zY3JlZW5zaG90JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBhbGxvd19mbGFnZ2luZyUzRCUyMm5ldmVyJTIyJTJDJTBBKSUwQWlmYWNlLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> random

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr


<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history</span>):
    history = history <span class="hljs-keyword">or</span> []
    <span class="hljs-keyword">if</span> message.startswith(<span class="hljs-string">&quot;How many&quot;</span>):
        response = random.randint(<span class="hljs-number">1</span>, <span class="hljs-number">10</span>)
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;How&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Great&quot;</span>, <span class="hljs-string">&quot;Good&quot;</span>, <span class="hljs-string">&quot;Okay&quot;</span>, <span class="hljs-string">&quot;Bad&quot;</span>])
    <span class="hljs-keyword">elif</span> message.startswith(<span class="hljs-string">&quot;Where&quot;</span>):
        response = random.choice([<span class="hljs-string">&quot;Here&quot;</span>, <span class="hljs-string">&quot;There&quot;</span>, <span class="hljs-string">&quot;Somewhere&quot;</span>])
    <span class="hljs-keyword">else</span>:
        response = <span class="hljs-string">&quot;I don&#x27;t know&quot;</span>
    history.append((message, response))
    <span class="hljs-keyword">return</span> history, history


iface = gr.Interface(
    chat,
    [<span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    [<span class="hljs-string">&quot;chatbot&quot;</span>, <span class="hljs-string">&quot;state&quot;</span>],
    allow_screenshot=<span class="hljs-literal">False</span>,
    allow_flagging=<span class="hljs-string">&quot;never&quot;</span>,
)
iface.launch()`,wrap:!1}}),k=new ye({props:{title:"Utilisation de l’interprétation pour comprendre les prédictions",local:"utilisation-de-linterprétation-pour-comprendre-les-prédictions",headingTag:"h3"}}),Z=new je({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3IlMEElMEFpbmNlcHRpb25fbmV0JTIwJTNEJTIwdGYua2VyYXMuYXBwbGljYXRpb25zLk1vYmlsZU5ldFYyKCklMjAlMjAlMjMlMjBjaGFyZ2VyJTIwbGUlMjBtb2QlQzMlQThsZSUwQSUwQSUyMyUyMFQlQzMlQTlsJUMzJUE5Y2hhcmdlciUyMGRlcyUyMCVDMyVBOXRpcXVldHRlcyUyMGxpc2libGVzJTIwcGFyJTIwbCdob21tZSUyMHBvdXIlMjBJbWFnZU5ldCUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KCUyMmh0dHBzJTNBJTJGJTJGZ2l0LmlvJTJGSkprWU4lMjIpJTBBbGFiZWxzJTIwJTNEJTIwcmVzcG9uc2UudGV4dC5zcGxpdCglMjIlNUNuJTIyKSUwQSUwQSUwQWRlZiUyMGNsYXNzaWZ5X2ltYWdlKGlucCklM0ElMEElMjAlMjAlMjAlMjBpbnAlMjAlM0QlMjBpbnAucmVzaGFwZSgoLTElMkMlMjAyMjQlMkMlMjAyMjQlMkMlMjAzKSklMEElMjAlMjAlMjAlMjBpbnAlMjAlM0QlMjB0Zi5rZXJhcy5hcHBsaWNhdGlvbnMubW9iaWxlbmV0X3YyLnByZXByb2Nlc3NfaW5wdXQoaW5wKSUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb24lMjAlM0QlMjBpbmNlcHRpb25fbmV0LnByZWRpY3QoaW5wKS5mbGF0dGVuKCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0JsYWJlbHMlNUJpJTVEJTNBJTIwZmxvYXQocHJlZGljdGlvbiU1QmklNUQpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklN0QlMEElMEElMEFpbWFnZSUyMCUzRCUyMGdyLkltYWdlKHNoYXBlJTNEKDIyNCUyQyUyMDIyNCkpJTBBbGFiZWwlMjAlM0QlMjBnci5MYWJlbChudW1fdG9wX2NsYXNzZXMlM0QzKSUwQSUwQXRpdGxlJTIwJTNEJTIwJTIyR3JhZGlvJTIwSW1hZ2UlMjBDbGFzc2lmaWN0aW9uJTIwJTJCJTIwSW50ZXJwcmV0YXRpb24lMjBFeGFtcGxlJTIyJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEY2xhc3NpZnlfaW1hZ2UlMkMlMjBpbnB1dHMlM0RpbWFnZSUyQyUyMG91dHB1dHMlM0RsYWJlbCUyQyUyMGludGVycHJldGF0aW9uJTNEJTIyZGVmYXVsdCUyMiUyQyUyMHRpdGxlJTNEdGl0bGUlMEEpLmxhdW5jaCgp",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

inception_net = tf.keras.applications.MobileNetV2()  <span class="hljs-comment"># charger le modèle</span>

<span class="hljs-comment"># Télécharger des étiquettes lisibles par l&#x27;homme pour ImageNet</span>
response = requests.get(<span class="hljs-string">&quot;https://git.io/JJkYN&quot;</span>)
labels = response.text.split(<span class="hljs-string">&quot;\\n&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_image</span>(<span class="hljs-params">inp</span>):
    inp = inp.reshape((-<span class="hljs-number">1</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>, <span class="hljs-number">3</span>))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    <span class="hljs-keyword">return</span> {labels[i]: <span class="hljs-built_in">float</span>(prediction[i]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)}


image = gr.Image(shape=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
label = gr.Label(num_top_classes=<span class="hljs-number">3</span>)

title = <span class="hljs-string">&quot;Gradio Image Classifiction + Interpretation Example&quot;</span>
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation=<span class="hljs-string">&quot;default&quot;</span>, title=title
).launch()`,wrap:!1}}),E=new ye({props:{title:"Ajouter l’authentification",local:"ajouter-lauthentification",headingTag:"h3"}}),q=new je({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQSUwQWltcG9ydCUyMGdyYWRpbyUyMGFzJTIwZ3IlMEElMEFpbmNlcHRpb25fbmV0JTIwJTNEJTIwdGYua2VyYXMuYXBwbGljYXRpb25zLk1vYmlsZU5ldFYyKCklMjAlMjAlMjMlMjBjaGFyZ2VyJTIwbGUlMjBtb2QlQzMlQThsZSUwQSUwQSUyMyUyMFQlQzMlQTlsJUMzJUE5Y2hhcmdlciUyMGRlcyUyMCVDMyVBOXRpcXVldHRlcyUyMGxpc2libGVzJTIwcGFyJTIwbCdob21tZSUyMHBvdXIlMjBJbWFnZU5ldCUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KCUyMmh0dHBzJTNBJTJGJTJGZ2l0LmlvJTJGSkprWU4lMjIpJTBBbGFiZWxzJTIwJTNEJTIwcmVzcG9uc2UudGV4dC5zcGxpdCglMjIlNUNuJTIyKSUwQSUwQSUwQWRlZiUyMGNsYXNzaWZ5X2ltYWdlKGlucCklM0ElMEElMjAlMjAlMjAlMjBpbnAlMjAlM0QlMjBpbnAucmVzaGFwZSgoLTElMkMlMjAyMjQlMkMlMjAyMjQlMkMlMjAzKSklMEElMjAlMjAlMjAlMjBpbnAlMjAlM0QlMjB0Zi5rZXJhcy5hcHBsaWNhdGlvbnMubW9iaWxlbmV0X3YyLnByZXByb2Nlc3NfaW5wdXQoaW5wKSUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb24lMjAlM0QlMjBpbmNlcHRpb25fbmV0LnByZWRpY3QoaW5wKS5mbGF0dGVuKCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjAlN0JsYWJlbHMlNUJpJTVEJTNBJTIwZmxvYXQocHJlZGljdGlvbiU1QmklNUQpJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklN0QlMEElMEElMEFpbWFnZSUyMCUzRCUyMGdyLkltYWdlKHNoYXBlJTNEKDIyNCUyQyUyMDIyNCkpJTBBbGFiZWwlMjAlM0QlMjBnci5MYWJlbChudW1fdG9wX2NsYXNzZXMlM0QzKSUwQSUwQXRpdGxlJTIwJTNEJTIwJTIyR3JhZGlvJTIwSW1hZ2UlMjBDbGFzc2lmaWN0aW9uJTIwJTJCJTIwSW50ZXJwcmV0YXRpb24lMjBFeGFtcGxlJTIyJTBBZ3IuSW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGZuJTNEY2xhc3NpZnlfaW1hZ2UlMkMlMjBpbnB1dHMlM0RpbWFnZSUyQyUyMG91dHB1dHMlM0RsYWJlbCUyQyUyMGludGVycHJldGF0aW9uJTNEJTIyZGVmYXVsdCUyMiUyQyUyMHRpdGxlJTNEdGl0bGUlMEEpLmxhdW5jaChhdXRoJTNEKCUyMmFkbWluJTIyJTJDJTIwJTIycGFzczEyMzQlMjIpKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr

inception_net = tf.keras.applications.MobileNetV2()  <span class="hljs-comment"># charger le modèle</span>

<span class="hljs-comment"># Télécharger des étiquettes lisibles par l&#x27;homme pour ImageNet</span>
response = requests.get(<span class="hljs-string">&quot;https://git.io/JJkYN&quot;</span>)
labels = response.text.split(<span class="hljs-string">&quot;\\n&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">classify_image</span>(<span class="hljs-params">inp</span>):
    inp = inp.reshape((-<span class="hljs-number">1</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>, <span class="hljs-number">3</span>))
    inp = tf.keras.applications.mobilenet_v2.preprocess_input(inp)
    prediction = inception_net.predict(inp).flatten()
    <span class="hljs-keyword">return</span> {labels[i]: <span class="hljs-built_in">float</span>(prediction[i]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>)}


image = gr.Image(shape=(<span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
label = gr.Label(num_top_classes=<span class="hljs-number">3</span>)

title = <span class="hljs-string">&quot;Gradio Image Classifiction + Interpretation Example&quot;</span>
gr.Interface(
    fn=classify_image, inputs=image, outputs=label, interpretation=<span class="hljs-string">&quot;default&quot;</span>, title=title
).launch(auth=(<span class="hljs-string">&quot;admin&quot;</span>, <span class="hljs-string">&quot;pass1234&quot;</span>))`,wrap:!1}}),{c(){M=o("meta"),Y=a(),S=o("p"),$=a(),d(f.$$.fragment),_=a(),d(b.$$.fragment),F=a(),U=o("p"),U.textContent=Je,V=a(),d(T.$$.fragment),H=a(),g=o("p"),g.innerHTML=fe,L=a(),I=o("p"),I.textContent=be,K=a(),G=o("ul"),G.innerHTML=Ue,P=a(),C=o("p"),C.textContent=Te,D=a(),d(v.$$.fragment),O=a(),p=o("iframe"),ee=ze(`
Remarquez comment l'état du composant de sortie persiste entre les soumissions. 
Remarque : vous pouvez transmettre une valeur par défaut au paramètre state, qui est utilisée comme valeur initiale de l'état.
`),d(k.$$.fragment),se=a(),B=o("p"),B.textContent=Ie,te=a(),d(Z.$$.fragment),le=a(),N=o("p"),N.textContent=Ge,ae=a(),c=o("iframe"),ne=a(),Q=o("p"),Q.innerHTML=ve,ie=a(),d(E.$$.fragment),oe=a(),W=o("p"),W.innerHTML=ke,re=a(),A=o("p"),A.innerHTML=Be,pe=a(),x=o("p"),x.textContent=Ze,ce=a(),d(q.$$.fragment),ue=a(),u=o("iframe"),me=a(),z=o("p"),z.innerHTML=Qe,Me=a(),X=o("p"),this.h()},l(e){const s=Se("svelte-u9bgzb",document.head);M=r(s,"META",{name:!0,content:!0}),s.forEach(t),Y=n(e),S=r(e,"P",{}),R(S).forEach(t),$=n(e),y(f.$$.fragment,e),_=n(e),y(b.$$.fragment,e),F=n(e),U=r(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-zqxtni"&&(U.textContent=Je),V=n(e),y(T.$$.fragment,e),H=n(e),g=r(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-n0aljj"&&(g.innerHTML=fe),L=n(e),I=r(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-qw2g3t"&&(I.textContent=be),K=n(e),G=r(e,"UL",{"data-svelte-h":!0}),m(G)!=="svelte-na9fa2"&&(G.innerHTML=Ue),P=n(e),C=r(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1o5953u"&&(C.textContent=Te),D=n(e),y(v.$$.fragment,e),O=n(e),p=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),R(p).forEach(t),ee=Xe(e,`
Remarquez comment l'état du composant de sortie persiste entre les soumissions. 
Remarque : vous pouvez transmettre une valeur par défaut au paramètre state, qui est utilisée comme valeur initiale de l'état.
`),y(k.$$.fragment,e),se=n(e),B=r(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-1yno0pv"&&(B.textContent=Ie),te=n(e),y(Z.$$.fragment,e),le=n(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-187nyfe"&&(N.textContent=Ge),ae=n(e),c=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),R(c).forEach(t),ne=n(e),Q=r(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-sqkay3"&&(Q.innerHTML=ve),ie=n(e),y(E.$$.fragment,e),oe=n(e),W=r(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-ilc63s"&&(W.innerHTML=ke),re=n(e),A=r(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-3v0gyq"&&(A.innerHTML=Be),pe=n(e),x=r(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-gt112h"&&(x.textContent=Ze),ce=n(e),y(q.$$.fragment,e),ue=n(e),u=r(e,"IFRAME",{src:!0,frameborder:!0,height:!0,title:!0,class:!0,allow:!0,sandbox:!0}),R(u).forEach(t),me=n(e),z=r(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-vb0n92"&&(z.innerHTML=Qe),Me=n(e),X=r(e,"P",{}),R(X).forEach(t),this.h()},h(){i(M,"name","hf:doc:metadata"),i(M,"content",_e),he(p.src,ge="https://course-demos-Chatbot-Demo.hf.space")||i(p,"src",ge),i(p,"frameborder","0"),i(p,"height","350"),i(p,"title","Gradio app"),i(p,"class","container p-0 flex-grow space-iframe"),i(p,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),i(p,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),he(c.src,Ce="https://hf.space/gradioiframe/akhaliq/gradio-image-interpretation/+")||i(c,"src",Ce),i(c,"frameborder","0"),i(c,"height","570"),i(c,"title","Gradio app"),i(c,"class","container p-0 flex-grow space-iframe"),i(c,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),i(c,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads"),he(u.src,Ne="https://course-demos-gradio-image-interpretation.hf.space")||i(u,"src",Ne),i(u,"frameborder","0"),i(u,"height","570"),i(u,"title","Gradio app"),i(u,"class","container p-0 flex-grow space-iframe"),i(u,"allow","accelerometer; ambient-light-sensor; autoplay; battery; camera; document-domain; encrypted-media; fullscreen; geolocation; gyroscope; layout-animations; legacy-image-formats; magnetometer; microphone; midi; oversized-images; payment; picture-in-picture; publickey-credentials-get; sync-xhr; usb; vr ; wake-lock; xr-spatial-tracking"),i(u,"sandbox","allow-forms allow-modals allow-popups allow-popups-to-escape-sandbox allow-same-origin allow-scripts allow-downloads")},m(e,s){Re(document.head,M),l(e,Y,s),l(e,S,s),l(e,$,s),h(f,e,s),l(e,_,s),h(b,e,s),l(e,F,s),l(e,U,s),l(e,V,s),h(T,e,s),l(e,H,s),l(e,g,s),l(e,L,s),l(e,I,s),l(e,K,s),l(e,G,s),l(e,P,s),l(e,C,s),l(e,D,s),h(v,e,s),l(e,O,s),l(e,p,s),l(e,ee,s),h(k,e,s),l(e,se,s),l(e,B,s),l(e,te,s),h(Z,e,s),l(e,le,s),l(e,N,s),l(e,ae,s),l(e,c,s),l(e,ne,s),l(e,Q,s),l(e,ie,s),h(E,e,s),l(e,oe,s),l(e,W,s),l(e,re,s),l(e,A,s),l(e,pe,s),l(e,x,s),l(e,ce,s),h(q,e,s),l(e,ue,s),l(e,u,s),l(e,me,s),l(e,z,s),l(e,Me,s),l(e,X,s),de=!0},p:We,i(e){de||(j(f.$$.fragment,e),j(b.$$.fragment,e),j(T.$$.fragment,e),j(v.$$.fragment,e),j(k.$$.fragment,e),j(Z.$$.fragment,e),j(E.$$.fragment,e),j(q.$$.fragment,e),de=!0)},o(e){w(f.$$.fragment,e),w(b.$$.fragment,e),w(T.$$.fragment,e),w(v.$$.fragment,e),w(k.$$.fragment,e),w(Z.$$.fragment,e),w(E.$$.fragment,e),w(q.$$.fragment,e),de=!1},d(e){e&&(t(Y),t(S),t($),t(_),t(F),t(U),t(V),t(H),t(g),t(L),t(I),t(K),t(G),t(P),t(C),t(D),t(O),t(p),t(ee),t(se),t(B),t(te),t(le),t(N),t(ae),t(c),t(ne),t(Q),t(ie),t(oe),t(W),t(re),t(A),t(pe),t(x),t(ce),t(ue),t(u),t(me),t(z),t(Me),t(X)),t(M),J(f,e),J(b,e),J(T,e),J(v,e),J(k,e),J(Z,e),J(E,e),J(q,e)}}}const _e='{"title":"Fonctionnalités avancées de l’interface","local":"fonctionnalités-avancées-de-linterface","sections":[{"title":"Utilisation de l’état pour faire persister les données","local":"utilisation-de-létat-pour-faire-persister-les-données","sections":[],"depth":3},{"title":"Utilisation de l’interprétation pour comprendre les prédictions","local":"utilisation-de-linterprétation-pour-comprendre-les-prédictions","sections":[],"depth":3},{"title":"Ajouter l’authentification","local":"ajouter-lauthentification","sections":[],"depth":3}],"depth":1}';function Fe(we){return Ae(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class De extends xe{constructor(M){super(),qe(this,M,Fe,$e,Ee,{})}}export{De as component};
