import{s as Gt,o as Zt,n as _t}from"../chunks/scheduler.37c15a92.js";import{S as vt,i as Rt,g as i,s as n,r as c,A as Ct,h as p,f as l,c as a,j as gt,u as d,x as o,k as kt,y as Wt,a as s,v as m,d as M,t as u,w as f}from"../chunks/index.2bf4358c.js";import{T as Ut}from"../chunks/Tip.363c041f.js";import{Y as Ht}from"../chunks/Youtube.1e50a667.js";import{C as T}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Ft}from"../chunks/CourseFloatingBanner.33a4139d.js";import{F as It}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as Oe}from"../chunks/Heading.8ada512a.js";function Xt(w){let r,$='💡 Если вы хотите автоматически загружать модель на Hub во время обучения, передайте аргумент <code>push_to_hub=True</code> в <code>TrainingArguments</code>. Мы больше узнаем об этом в главе <a href="/course/chapter4/3">Chapter 4</a>.';return{c(){r=i("p"),r.innerHTML=$},l(b){r=p(b,"P",{"data-svelte-h":!0}),o(r)!=="svelte-qaxi55"&&(r.innerHTML=$)},m(b,y){s(b,r,y)},p:_t,d(b){b&&l(r)}}}function Et(w){let r,$="✏️ <strong>Попробуйте!</strong> Произведите fine-tuning модели на датасете GLUE SST-2 с использованием препроцессинга из раздела 2.";return{c(){r=i("p"),r.innerHTML=$},l(b){r=p(b,"P",{"data-svelte-h":!0}),o(r)!=="svelte-c1qr45"&&(r.innerHTML=$)},m(b,y){s(b,r,y)},p:_t,d(b){b&&l(r)}}}function zt(w){let r,$,b,y,j,ce,g,de,k,me,U,Me,_,et='Библиотека 🤗 Transformers предоставляет класс <code>Trainer</code>, который помогает произвести fine-tuning любой предобученной модели на вашем датасете. После предобработки данных, сделанных в прошлом разделе, вам останется сделать несколько шагов для определения <code>Trainer</code>. Самая сложная часть – подготовить окружение для запуска <code>Trainer.train()</code>, т.к. она медленно работает на центральном процессоре. Если у вас нет видеокарты, вы можете бесплатно воспользоваться сервисом <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>, который предоставляет доступ к вычислениям с использованием GPU и TPU.',ue,G,tt="Фрагменты кода ниже предполагают, что вы выполнили код из предыдущего раздела. Ниже приведено краткое резюме того, что вам нужно:",fe,Z,be,v,Te,R,lt="Первый шаг перед определением <code>Trainer</code>, задание класса <code>TrainingArguments</code>, который будет содержать все гиперпараметры для <code>Trainer</code> (для процессов обучения и валидации). Единственный аргумент, который вы должны задать — это каталог, в котором будет сохранена обученная модель, а также контрольные точки. Для всего остального вы можете оставить значения по умолчанию, которые должны подойти для базового fine-tuning.",$e,C,ye,J,je,W,st='Второй шаг – задание модели. Так же, как и в <a href="/course/chapter2">предыдущей главе</a>, мы будем использовать класс <code>AutoModelForSequenceClassification</code> с двумя лейблами:',Je,H,he,F,nt='После создания экземпляра предобученной модели будет распечатано предупреждение (в <a href="/course/chapter2">главе 2</a> мы с таким не сталкивались). Это происходит потому, что BERT не был предобучен для задачи классификации пар предложений, его последний слой не будет использован, вместо него будет добавлен слой, позволяющий работать с такой задачей. Предупреждения сообщают, что некоторые веса не будут использованы (как раз тех слоев, которые не будут использоваться) и для новых будут инициализированы случайные веса. В заключении предлагается обучить модель, что мы и сделаем прямо сейчас.',we,I,at="После того, как мы загрузили модель, мы можем определить <code>Trainer</code> и передать туда нужные объекты: <code>model</code>, <code>training_args</code>, обучающую и валидационную выборки, <code>data_collator</code> и <code>tokenizer</code>",ge,X,ke,E,it="Заметьте, когда вы передали <code>tokenizer</code> как в примере выше, значение по умолчанию для <code>data_collator</code> в <code>Trainer</code> будет <code>DataCollatorWithPadding</code> таким, как определено выше, так что эту строку (<code>data_collator=data_collator</code>) можно пропустить в этом вызове.",Ue,z,pt="Для fine-tuning модели на нашем датасете мы просто должны вызвать метод <code>train()</code> у <code>Trainer</code>:",_e,V,Ge,B,rt="Это запустит процесс дообучения (который должен занять несколько минут на GPU) и будет распечатывать значение лосса каждые 500 итераций. Однако эти значения не скажут нам, насколько хорошо или плохо модель работает. И вот почему:",Ze,Y,ot="<li>Мы не сообщили <code>Trainer</code>, что необходимо проводить валидацию: для этого нужно присвоить аргументу <code>evaluation_strategy</code> значение <code>&quot;steps&quot;</code> (валидировать каждые <code>eval_steps</code>) или <code>&quot;epoch&quot;</code> (валидировать по окончании каждой эпохи).</li> <li>Мы не указали <code>Trainer</code> аргумент <code>compute_metrics()</code> – функцию для вычисления метрики на валидационной части (в таком случае в процессе валидации будет только распечатываться значение лосса, что не очень информативно).</li>",ve,x,Re,A,ct="Давайте посмотрим как мы можем создать и использовать в процессе обучения полезную функцию <code>compute_metrics()</code>. Функция должна принимать на вход объект <code>EvalPrediction</code> (именованный кортеж с полями <code>predictions</code> и  <code>label_ids</code>) и возвращать словарь, где ключи - названия метрик, а значения - оценки этих метрик. Чтобы получить предсказания, мы можем использовать функцию <code>Trainer.predict()</code>:",Ce,N,We,Q,He,L,dt="Результат функции <code>predict()</code> - другой именованный кортеж с полями <code>predictions</code>, <code>label_ids</code> и <code>metrics</code>. Поле <code>metrics</code> будет содержать значение лосса на нашем датасете и значения метрик. После реализации функции <code>compute_metrics()</code> и передачи ее в <code>Trainer</code> поле <code>metrics</code> также будет содержать результат функции <code>compute_metrics()</code>.",Fe,q,mt='Как можно заметить, <code>predictions</code> - массив 408 х 2 (408 - число элементов в датасете, который мы использовали). Это логиты для каждого элемента нашего датасета, переданного в <code>predict()</code> (как вы видели в <a href="/course/chapter2">предыдущей главе</a> все модели Трансформеров возвращают логиты). Чтобы превратить их в предсказания и сравнить с нашими лейблами, нам необходимо узнать индекс максимального элемента второй оси:',Ie,P,Xe,S,Mt='Теперь мы можем сравнить эти предсказания с лейблами. Для создания функции <code>compute_metric()</code> мы воспользуемся метриками из библиотеки 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a>. Мы можем загрузить подходящие для датасета MRPC метрики так же просто, как мы загрузили датасет, но на этот раз с помощью функции <code>evaluate.load()</code>. Возвращаемый объект имеет метод <code>compute()</code>, который мы можем использовать для вычисления метрики:',Ee,K,ze,D,Ve,O,ut='У вас эти результаты могут отличаться ввиду случайной инициализации параметров модели. Тут мы можем увидеть точность 85.78% и F1 89.97% на валидационной части выборки. Эти метрики используются для валидации результатов на MRPC датасете на бенчмарке GLUE. В таблице в статье о <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT</a> указано значение F1 оценки в 88.9 для базовой модели. Это была оценка для варианта модели <code>uncased</code>, а мы использовали <code>cased</code>, этим и объясняется более хороший результат.',Be,ee,ft="Собирая вместе все фрагменты выше, мы получим нашу функцию <code>compute_metrics()</code>:",Ye,te,xe,le,bt="Чтобы увидеть эту функцию в действии после каждой эпохи ниже мы определим еще один <code>Trainer</code> с функцией <code>compute_metrics()</code>:",Ae,se,Ne,ne,Tt="Обратите внимание, что мы создали новый объект <code>TrainingArguments</code> с собственным <code>evaluation_strategy</code> равным <code>&quot;epoch&quot;</code> и новой моделью - иначе мы бы продолжили обучать модель, которая уже является обученной. Чтобы запустить обучение заново, надо выполнить:",Qe,ae,Le,ie,$t="На этот раз будет распечатываться валидационный лосс и метрики по окончанию каждой эпохи обучения. Напомним, что полученные значения точности и F1 могут не полностью совпадать с приведенными в примере из-за случайной инициализации слоев модели, но порядок должен быть примерно таким же.",qe,pe,yt="<code>Trainer</code> может работать с несколькими GPU или TPU и предоставляет множество опций, например применение техники mixed-precision (установите <code>fp16 = True</code> в аргументах). Подробно об опциях мы поговорим чуть в Главе 10.",Pe,re,jt="На этом введение в fine-tuning с использованием API <code>Trainer</code> подошло к концу. Пример того, как сделать это же для наиболее распространенных задач  NLP мы рассмотрим в Главе 7, а сейчас взглянем на то, как реализовать то же самое на чистом PyTorch.",Se,h,Ke,oe,De;return j=new It({props:{fw:w[0]}}),g=new Oe({props:{title:"Fine-tuning модели с использованием Trainer API",local:"fine-tuning-модели-с-использованием-trainer-api",headingTag:"h1"}}),k=new Ft({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ru/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ru/chapter3/section3.ipynb"}]}}),U=new Ht({props:{id:"nvBXf7s7vTI"}}),Z=new T({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),v=new Oe({props:{title:"Обучение",local:"обучение",headingTag:"h3"}}),C=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),J=new Ut({props:{$$slots:{default:[Xt]},$$scope:{ctx:w}}}),H=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),X=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),V=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),x=new Oe({props:{title:"Валидация",local:"валидация",headingTag:"h3"}}),N=new T({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),Q=new T({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new T({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),K=new T({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),D=new T({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),te=new T({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),se=new T({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),ae=new T({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'trainer.trai<span class="hljs-meta">n</span>()',wrap:!1}}),h=new Ut({props:{$$slots:{default:[Et]},$$scope:{ctx:w}}}),{c(){r=i("meta"),$=n(),b=i("p"),y=n(),c(j.$$.fragment),ce=n(),c(g.$$.fragment),de=n(),c(k.$$.fragment),me=n(),c(U.$$.fragment),Me=n(),_=i("p"),_.innerHTML=et,ue=n(),G=i("p"),G.textContent=tt,fe=n(),c(Z.$$.fragment),be=n(),c(v.$$.fragment),Te=n(),R=i("p"),R.innerHTML=lt,$e=n(),c(C.$$.fragment),ye=n(),c(J.$$.fragment),je=n(),W=i("p"),W.innerHTML=st,Je=n(),c(H.$$.fragment),he=n(),F=i("p"),F.innerHTML=nt,we=n(),I=i("p"),I.innerHTML=at,ge=n(),c(X.$$.fragment),ke=n(),E=i("p"),E.innerHTML=it,Ue=n(),z=i("p"),z.innerHTML=pt,_e=n(),c(V.$$.fragment),Ge=n(),B=i("p"),B.textContent=rt,Ze=n(),Y=i("ol"),Y.innerHTML=ot,ve=n(),c(x.$$.fragment),Re=n(),A=i("p"),A.innerHTML=ct,Ce=n(),c(N.$$.fragment),We=n(),c(Q.$$.fragment),He=n(),L=i("p"),L.innerHTML=dt,Fe=n(),q=i("p"),q.innerHTML=mt,Ie=n(),c(P.$$.fragment),Xe=n(),S=i("p"),S.innerHTML=Mt,Ee=n(),c(K.$$.fragment),ze=n(),c(D.$$.fragment),Ve=n(),O=i("p"),O.innerHTML=ut,Be=n(),ee=i("p"),ee.innerHTML=ft,Ye=n(),c(te.$$.fragment),xe=n(),le=i("p"),le.innerHTML=bt,Ae=n(),c(se.$$.fragment),Ne=n(),ne=i("p"),ne.innerHTML=Tt,Qe=n(),c(ae.$$.fragment),Le=n(),ie=i("p"),ie.textContent=$t,qe=n(),pe=i("p"),pe.innerHTML=yt,Pe=n(),re=i("p"),re.innerHTML=jt,Se=n(),c(h.$$.fragment),Ke=n(),oe=i("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);r=p(t,"META",{name:!0,content:!0}),t.forEach(l),$=a(e),b=p(e,"P",{}),gt(b).forEach(l),y=a(e),d(j.$$.fragment,e),ce=a(e),d(g.$$.fragment,e),de=a(e),d(k.$$.fragment,e),me=a(e),d(U.$$.fragment,e),Me=a(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1ydyfc5"&&(_.innerHTML=et),ue=a(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-zddvdi"&&(G.textContent=tt),fe=a(e),d(Z.$$.fragment,e),be=a(e),d(v.$$.fragment,e),Te=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-189hckl"&&(R.innerHTML=lt),$e=a(e),d(C.$$.fragment,e),ye=a(e),d(J.$$.fragment,e),je=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-jcazq"&&(W.innerHTML=st),Je=a(e),d(H.$$.fragment,e),he=a(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-emuxb7"&&(F.innerHTML=nt),we=a(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1s3gapf"&&(I.innerHTML=at),ge=a(e),d(X.$$.fragment,e),ke=a(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-1jzisoh"&&(E.innerHTML=it),Ue=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-159l1wi"&&(z.innerHTML=pt),_e=a(e),d(V.$$.fragment,e),Ge=a(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9n8hhe"&&(B.textContent=rt),Ze=a(e),Y=p(e,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-1l6i09g"&&(Y.innerHTML=ot),ve=a(e),d(x.$$.fragment,e),Re=a(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-w4t8m7"&&(A.innerHTML=ct),Ce=a(e),d(N.$$.fragment,e),We=a(e),d(Q.$$.fragment,e),He=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-185f6i7"&&(L.innerHTML=dt),Fe=a(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-19r7vuh"&&(q.innerHTML=mt),Ie=a(e),d(P.$$.fragment,e),Xe=a(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-n04ftp"&&(S.innerHTML=Mt),Ee=a(e),d(K.$$.fragment,e),ze=a(e),d(D.$$.fragment,e),Ve=a(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1j9axbb"&&(O.innerHTML=ut),Be=a(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-ap2krs"&&(ee.innerHTML=ft),Ye=a(e),d(te.$$.fragment,e),xe=a(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-ll5fb5"&&(le.innerHTML=bt),Ae=a(e),d(se.$$.fragment,e),Ne=a(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1l8jjkk"&&(ne.innerHTML=Tt),Qe=a(e),d(ae.$$.fragment,e),Le=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1yj6bqb"&&(ie.textContent=$t),qe=a(e),pe=p(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-6ncnfr"&&(pe.innerHTML=yt),Pe=a(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-ozav2a"&&(re.innerHTML=jt),Se=a(e),d(h.$$.fragment,e),Ke=a(e),oe=p(e,"P",{}),gt(oe).forEach(l),this.h()},h(){kt(r,"name","hf:doc:metadata"),kt(r,"content",Vt)},m(e,t){Wt(document.head,r),s(e,$,t),s(e,b,t),s(e,y,t),m(j,e,t),s(e,ce,t),m(g,e,t),s(e,de,t),m(k,e,t),s(e,me,t),m(U,e,t),s(e,Me,t),s(e,_,t),s(e,ue,t),s(e,G,t),s(e,fe,t),m(Z,e,t),s(e,be,t),m(v,e,t),s(e,Te,t),s(e,R,t),s(e,$e,t),m(C,e,t),s(e,ye,t),m(J,e,t),s(e,je,t),s(e,W,t),s(e,Je,t),m(H,e,t),s(e,he,t),s(e,F,t),s(e,we,t),s(e,I,t),s(e,ge,t),m(X,e,t),s(e,ke,t),s(e,E,t),s(e,Ue,t),s(e,z,t),s(e,_e,t),m(V,e,t),s(e,Ge,t),s(e,B,t),s(e,Ze,t),s(e,Y,t),s(e,ve,t),m(x,e,t),s(e,Re,t),s(e,A,t),s(e,Ce,t),m(N,e,t),s(e,We,t),m(Q,e,t),s(e,He,t),s(e,L,t),s(e,Fe,t),s(e,q,t),s(e,Ie,t),m(P,e,t),s(e,Xe,t),s(e,S,t),s(e,Ee,t),m(K,e,t),s(e,ze,t),m(D,e,t),s(e,Ve,t),s(e,O,t),s(e,Be,t),s(e,ee,t),s(e,Ye,t),m(te,e,t),s(e,xe,t),s(e,le,t),s(e,Ae,t),m(se,e,t),s(e,Ne,t),s(e,ne,t),s(e,Qe,t),m(ae,e,t),s(e,Le,t),s(e,ie,t),s(e,qe,t),s(e,pe,t),s(e,Pe,t),s(e,re,t),s(e,Se,t),m(h,e,t),s(e,Ke,t),s(e,oe,t),De=!0},p(e,[t]){const Jt={};t&1&&(Jt.fw=e[0]),j.$set(Jt);const ht={};t&2&&(ht.$$scope={dirty:t,ctx:e}),J.$set(ht);const wt={};t&2&&(wt.$$scope={dirty:t,ctx:e}),h.$set(wt)},i(e){De||(M(j.$$.fragment,e),M(g.$$.fragment,e),M(k.$$.fragment,e),M(U.$$.fragment,e),M(Z.$$.fragment,e),M(v.$$.fragment,e),M(C.$$.fragment,e),M(J.$$.fragment,e),M(H.$$.fragment,e),M(X.$$.fragment,e),M(V.$$.fragment,e),M(x.$$.fragment,e),M(N.$$.fragment,e),M(Q.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(D.$$.fragment,e),M(te.$$.fragment,e),M(se.$$.fragment,e),M(ae.$$.fragment,e),M(h.$$.fragment,e),De=!0)},o(e){u(j.$$.fragment,e),u(g.$$.fragment,e),u(k.$$.fragment,e),u(U.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(C.$$.fragment,e),u(J.$$.fragment,e),u(H.$$.fragment,e),u(X.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(N.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(h.$$.fragment,e),De=!1},d(e){e&&(l($),l(b),l(y),l(ce),l(de),l(me),l(Me),l(_),l(ue),l(G),l(fe),l(be),l(Te),l(R),l($e),l(ye),l(je),l(W),l(Je),l(he),l(F),l(we),l(I),l(ge),l(ke),l(E),l(Ue),l(z),l(_e),l(Ge),l(B),l(Ze),l(Y),l(ve),l(Re),l(A),l(Ce),l(We),l(He),l(L),l(Fe),l(q),l(Ie),l(Xe),l(S),l(Ee),l(ze),l(Ve),l(O),l(Be),l(ee),l(Ye),l(xe),l(le),l(Ae),l(Ne),l(ne),l(Qe),l(Le),l(ie),l(qe),l(pe),l(Pe),l(re),l(Se),l(Ke),l(oe)),l(r),f(j,e),f(g,e),f(k,e),f(U,e),f(Z,e),f(v,e),f(C,e),f(J,e),f(H,e),f(X,e),f(V,e),f(x,e),f(N,e),f(Q,e),f(P,e),f(K,e),f(D,e),f(te,e),f(se,e),f(ae,e),f(h,e)}}}const Vt='{"title":"Fine-tuning модели с использованием Trainer API","local":"fine-tuning-модели-с-использованием-trainer-api","sections":[{"title":"Обучение","local":"обучение","sections":[],"depth":3},{"title":"Валидация","local":"валидация","sections":[],"depth":3}],"depth":1}';function Bt(w,r,$){let b="pt";return Zt(()=>{const y=new URLSearchParams(window.location.search);$(0,b=y.get("fw")||"pt")}),[b]}class St extends vt{constructor(r){super(),Rt(this,r,Bt,zt,Gt,{})}}export{St as component};
