import{s as be,o as ge,n as Ca}from"../chunks/scheduler.182ea377.js";import{S as Ie,i as fe,g as p,s as t,p as r,A as Ce,h as M,f as a,c as n,q as j,j as u,m as o,k as c,v as J,a as e,r as h,d as m,t as y,u as w}from"../chunks/index.008d68e4.js";import{T as fa}from"../chunks/Tip.4f096367.js";import{I as Fs}from"../chunks/IconCopyLink.96bbb92b.js";import{C as d}from"../chunks/CodeBlock.5ed6eb7b.js";import{D as Ae}from"../chunks/DocNotebookDropdown.bb388256.js";function Be(G){let i,U='💡 This training tutorial is based on the <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers/training_example.ipynb" rel="nofollow">Training with 🧨 Diffusers</a> notebook. For additional details and context about diffusion models like how they work, check out the notebook!';return{c(){i=p("p"),i.innerHTML=U},l(T){i=M(T,"P",{"data-svelte-h":!0}),o(i)!=="svelte-mrih6e"&&(i.innerHTML=U)},m(T,b){e(T,i,b)},p:Ca,d(T){T&&a(i)}}}function Ze(G){let i,U='💡 You can find additional datasets from the <a href="https://huggingface.co/huggan" rel="nofollow">HugGan Community Event</a> or you can use your own dataset by creating a local <a href="https://huggingface.co/docs/datasets/image_dataset#imagefolder" rel="nofollow"><code>ImageFolder</code></a>. Set <code>config.dataset_name</code> to the repository id of the dataset if it is from the HugGan Community Event, or <code>imagefolder</code> if you’re using your own images.';return{c(){i=p("p"),i.innerHTML=U},l(T){i=M(T,"P",{"data-svelte-h":!0}),o(i)!=="svelte-1617s30"&&(i.innerHTML=U)},m(T,b){e(T,i,b)},p:Ca,d(T){T&&a(i)}}}function Ge(G){let i,U="💡 The training loop below may look intimidating and long, but it’ll be worth it later when you launch your training in just one line of code! If you can’t wait and want to start generating images, feel free to copy and run the code below. You can always come back and examine the training loop more closely later, like when you’re waiting for your model to finish training. 🤗";return{c(){i=p("p"),i.textContent=U},l(T){i=M(T,"P",{"data-svelte-h":!0}),o(i)!=="svelte-dstut0"&&(i.textContent=U)},m(T,b){e(T,i,b)},p:Ca,d(T){T&&a(i)}}}function ve(G){let i,U,T,b,g,v,Ps,F,Ta,Ss,Aa="Train a diffusion model",Ml,S,Ba='Unconditional image generation is a popular application of diffusion models that generates images that look like those in the dataset used for training. Typically, the best results are obtained from finetuning a pretrained model on a specific dataset. You can find many of these checkpoints on the <a href="https://huggingface.co/search/full-text?q=unconditional-image-generation&amp;type=model" rel="nofollow">Hub</a>, but if you can’t find one you like, you can always train your own!',ol,x,Za='This tutorial will teach you how to train a <a href="/docs/diffusers/v0.25.0/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> from scratch on a subset of the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset to generate your own 🦋 butterflies 🦋.',il,k,cl,H,Ga='Before you begin, make sure you have 🤗 Datasets installed to load and preprocess image datasets, and 🤗 Accelerate, to simplify training on any number of GPUs. The following command will also install <a href="https://www.tensorflow.org/tensorboard" rel="nofollow">TensorBoard</a> to visualize training metrics (you can also use <a href="https://docs.wandb.ai/" rel="nofollow">Weights &amp; Biases</a> to track your training).',rl,D,jl,q,va='We encourage you to share your model with the community, and in order to do that, you’ll need to login to your Hugging Face account (create one <a href="https://hf.co/join" rel="nofollow">here</a> if you don’t already have one!). You can login from a notebook and enter your token when prompted. Make sure your token has the write role.',hl,L,ml,K,ka="Or login in from the terminal:",yl,P,wl,O,_a='Since the model checkpoints are quite large, install <a href="https://git-lfs.com/" rel="nofollow">Git-LFS</a> to version these large files:',Jl,ss,Tl,I,_,Os,ls,ua,xs,Xa="Training configuration",ul,as,Wa="For convenience, create a <code>TrainingConfig</code> class containing the training hyperparameters (feel free to adjust them):",dl,es,Ul,f,X,sl,ts,da,Hs,Na="Load the dataset",bl,ns,Va='You can easily load the <a href="https://huggingface.co/datasets/huggan/smithsonian_butterflies_subset" rel="nofollow">Smithsonian Butterflies</a> dataset with the 🤗 Datasets library:',gl,ps,Il,W,fl,Ms,Ra='🤗 Datasets uses the <code>Image</code> feature to automatically decode the image data and load it as a <a href="https://pillow.readthedocs.io/en/stable/reference/Image.html" rel="nofollow"><code>PIL.Image</code></a> which we can visualize:',Cl,os,Al,N,$a='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_ds.png"/>',Bl,is,Ya="The images are all different sizes though, so you’ll need to preprocess them first:",Zl,cs,Ea="<li><code>Resize</code> changes the image size to the one defined in <code>config.image_size</code>.</li> <li><code>RandomHorizontalFlip</code> augments the dataset by randomly mirroring the images.</li> <li><code>Normalize</code> is important to rescale the pixel values into a [-1, 1] range, which is what the model expects.</li>",Gl,rs,vl,js,za="Use 🤗 Datasets’ <code>set_transform</code> method to apply the <code>preprocess</code> function on the fly during training:",kl,hs,_l,ms,Qa='Feel free to visualize the images again to confirm that they’ve been resized. Now you’re ready to wrap the dataset in a <a href="https://pytorch.org/docs/stable/data#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> for training!',Xl,ys,Wl,C,V,ll,ws,Ua,Ds,Fa="Create a UNet2DModel",Nl,Js,Sa='Pretrained models in 🧨 Diffusers are easily created from their model class with the parameters you want. For example, to create a <a href="/docs/diffusers/v0.25.0/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a>:',Vl,Ts,Rl,us,xa="It is often a good idea to quickly check the sample image shape matches the model output shape:",$l,ds,Yl,Us,Ha="Great! Next, you’ll need a scheduler to add some noise to the image.",El,A,R,al,bs,ba,qs,Da="Create a scheduler",zl,gs,qa="The scheduler behaves differently depending on whether you’re using the model for training or inference. During inference, the scheduler generates image from the noise. During training, the scheduler takes a model output - or a sample - from a specific point in the diffusion process and applies noise to the image according to a <em>noise schedule</em> and an <em>update rule</em>.",Ql,Is,La='Let’s take a look at the <a href="/docs/diffusers/v0.25.0/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a> and use the <code>add_noise</code> method to add some random noise to the <code>sample_image</code> from before:',Fl,fs,Sl,$,Ka='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/noisy_butterfly.png"/>',xl,Cs,Pa="The training objective of the model is to predict the noise added to the image. The loss at this step can be calculated by:",Hl,As,Dl,B,Y,el,Bs,ga,Ls,Oa="Train the model",ql,Zs,se="By now, you have most of the pieces to start training the model and all that’s left is putting everything together.",Ll,Gs,le="First, you’ll need an optimizer and a learning rate scheduler:",Kl,vs,Pl,ks,ae='Then, you’ll need a way to evaluate the model. For evaluation, you can use the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/ddpm#diffusers.DDPMPipeline">DDPMPipeline</a> to generate a batch of sample images and save it as a grid:',Ol,_s,sa,Xs,ee="Now you can wrap all these components together in a training loop with 🤗 Accelerate for easy TensorBoard logging, gradient accumulation, and mixed precision training. To upload the model to the Hub, write a function to get your repository name and information and then push it to the Hub.",la,E,aa,Ws,ea,Ns,te='Phew, that was quite a bit of code! But you’re finally ready to launch the training with 🤗 Accelerate’s <a href="https://huggingface.co/docs/accelerate/v0.25.0/en/package_reference/launchers#accelerate.notebook_launcher" rel="nofollow">notebook_launcher</a> function. Pass the function the training loop, all the training arguments, and the number of processes (you can change this value to the number of GPUs available to you) to use for training:',ta,Vs,na,Rs,ne="Once training is complete, take a look at the final 🦋 images 🦋 generated by your diffusion model!",pa,$s,Ma,z,pe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/butterflies_final.png"/>',oa,Z,Q,tl,Ys,Ia,Ks,Me="Next steps",ia,Es,oe='Unconditional image generation is one example of a task that can be trained. You can explore other tasks and training techniques by visiting the <a href="../training/overview">🧨 Diffusers Training Examples</a> page. Here are some examples of what you can learn:',ca,zs,ie='<li><a href="../training/text_inversion">Textual Inversion</a>, an algorithm that teaches a model a specific visual concept and integrates it into the generated image.</li> <li><a href="../training/dreambooth">DreamBooth</a>, a technique for generating personalized images of a subject given several input images of the subject.</li> <li><a href="../training/text2image">Guide</a> to finetuning a Stable Diffusion model on your own dataset.</li> <li><a href="../training/lora">Guide</a> to using LoRA, a memory-efficient technique for finetuning really large models faster.</li>',ra;return T=new Ae({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/basic_training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/basic_training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/basic_training.ipynb"}]}}),F=new Fs({}),k=new fa({props:{$$slots:{default:[Be]},$$scope:{ctx:G}}}),D=new d({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwZGlmZnVzZXJzJTVCdHJhaW5pbmclNUQ=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install diffusers[training]</span>`}}),L=new d({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`}}),P=new d({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login"}}),ss=new d({props:{code:"IXN1ZG8lMjBhcHQlMjAtcXElMjBpbnN0YWxsJTIwZ2l0LWxmcyUwQSFnaXQlMjBjb25maWclMjAtLWdsb2JhbCUyMGNyZWRlbnRpYWwuaGVscGVyJTIwc3RvcmU=",highlighted:`!sudo apt -qq install git-lfs
!git config --global credential.helper store`}}),ls=new Fs({}),es=new d({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBUcmFpbmluZ0NvbmZpZyUzQSUwQSUyMCUyMCUyMCUyMGltYWdlX3NpemUlMjAlM0QlMjAxMjglMjAlMjAlMjMlMjB0aGUlMjBnZW5lcmF0ZWQlMjBpbWFnZSUyMHJlc29sdXRpb24lMEElMjAlMjAlMjAlMjB0cmFpbl9iYXRjaF9zaXplJTIwJTNEJTIwMTYlMEElMjAlMjAlMjAlMjBldmFsX2JhdGNoX3NpemUlMjAlM0QlMjAxNiUyMCUyMCUyMyUyMGhvdyUyMG1hbnklMjBpbWFnZXMlMjB0byUyMHNhbXBsZSUyMGR1cmluZyUyMGV2YWx1YXRpb24lMEElMjAlMjAlMjAlMjBudW1fZXBvY2hzJTIwJTNEJTIwNTAlMEElMjAlMjAlMjAlMjBncmFkaWVudF9hY2N1bXVsYXRpb25fc3RlcHMlMjAlM0QlMjAxJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUyMCUzRCUyMDFlLTQlMEElMjAlMjAlMjAlMjBscl93YXJtdXBfc3RlcHMlMjAlM0QlMjA1MDAlMEElMjAlMjAlMjAlMjBzYXZlX2ltYWdlX2Vwb2NocyUyMCUzRCUyMDEwJTBBJTIwJTIwJTIwJTIwc2F2ZV9tb2RlbF9lcG9jaHMlMjAlM0QlMjAzMCUwQSUyMCUyMCUyMCUyMG1peGVkX3ByZWNpc2lvbiUyMCUzRCUyMCUyMmZwMTYlMjIlMjAlMjAlMjMlMjAlNjBubyU2MCUyMGZvciUyMGZsb2F0MzIlMkMlMjAlNjBmcDE2JTYwJTIwZm9yJTIwYXV0b21hdGljJTIwbWl4ZWQlMjBwcmVjaXNpb24lMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTIwJTNEJTIwJTIyZGRwbS1idXR0ZXJmbGllcy0xMjglMjIlMjAlMjAlMjMlMjB0aGUlMjBtb2RlbCUyMG5hbWUlMjBsb2NhbGx5JTIwYW5kJTIwb24lMjB0aGUlMjBIRiUyMEh1YiUwQSUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTIwJTNEJTIwVHJ1ZSUyMCUyMCUyMyUyMHdoZXRoZXIlMjB0byUyMHVwbG9hZCUyMHRoZSUyMHNhdmVkJTIwbW9kZWwlMjB0byUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX21vZGVsX2lkJTIwJTNEJTIwJTIyJTNDeW91ci11c2VybmFtZSUzRSUyRiUzQ215LWF3ZXNvbWUtbW9kZWwlM0UlMjIlMjAlMjAlMjMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTIwdG8lMjBjcmVhdGUlMjBvbiUyMHRoZSUyMEhGJTIwSHViJTBBJTIwJTIwJTIwJTIwaHViX3ByaXZhdGVfcmVwbyUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwb3ZlcndyaXRlX291dHB1dF9kaXIlMjAlM0QlMjBUcnVlJTIwJTIwJTIzJTIwb3ZlcndyaXRlJTIwdGhlJTIwb2xkJTIwbW9kZWwlMjB3aGVuJTIwcmUtcnVubmluZyUyMHRoZSUyMG5vdGVib29rJTBBJTIwJTIwJTIwJTIwc2VlZCUyMCUzRCUyMDAlMEElMEElMEFjb25maWclMjAlM0QlMjBUcmFpbmluZ0NvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-meta">&gt;&gt;&gt; </span>@dataclass
<span class="hljs-meta">... </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">TrainingConfig</span>:
<span class="hljs-meta">... </span>    image_size = <span class="hljs-number">128</span>  <span class="hljs-comment"># the generated image resolution</span>
<span class="hljs-meta">... </span>    train_batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">... </span>    eval_batch_size = <span class="hljs-number">16</span>  <span class="hljs-comment"># how many images to sample during evaluation</span>
<span class="hljs-meta">... </span>    num_epochs = <span class="hljs-number">50</span>
<span class="hljs-meta">... </span>    gradient_accumulation_steps = <span class="hljs-number">1</span>
<span class="hljs-meta">... </span>    learning_rate = <span class="hljs-number">1e-4</span>
<span class="hljs-meta">... </span>    lr_warmup_steps = <span class="hljs-number">500</span>
<span class="hljs-meta">... </span>    save_image_epochs = <span class="hljs-number">10</span>
<span class="hljs-meta">... </span>    save_model_epochs = <span class="hljs-number">30</span>
<span class="hljs-meta">... </span>    mixed_precision = <span class="hljs-string">&quot;fp16&quot;</span>  <span class="hljs-comment"># \`no\` for float32, \`fp16\` for automatic mixed precision</span>
<span class="hljs-meta">... </span>    output_dir = <span class="hljs-string">&quot;ddpm-butterflies-128&quot;</span>  <span class="hljs-comment"># the model name locally and on the HF Hub</span>

<span class="hljs-meta">... </span>    push_to_hub = <span class="hljs-literal">True</span>  <span class="hljs-comment"># whether to upload the saved model to the HF Hub</span>
<span class="hljs-meta">... </span>    hub_model_id = <span class="hljs-string">&quot;&lt;your-username&gt;/&lt;my-awesome-model&gt;&quot;</span>  <span class="hljs-comment"># the name of the repository to create on the HF Hub</span>
<span class="hljs-meta">... </span>    hub_private_repo = <span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>    overwrite_output_dir = <span class="hljs-literal">True</span>  <span class="hljs-comment"># overwrite the old model when re-running the notebook</span>
<span class="hljs-meta">... </span>    seed = <span class="hljs-number">0</span>


<span class="hljs-meta">&gt;&gt;&gt; </span>config = TrainingConfig()`}}),ts=new Fs({}),ps=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBY29uZmlnLmRhdGFzZXRfbmFtZSUyMCUzRCUyMCUyMmh1Z2dhbiUyRnNtaXRoc29uaWFuX2J1dHRlcmZsaWVzX3N1YnNldCUyMiUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoY29uZmlnLmRhdGFzZXRfbmFtZSUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>config.dataset_name = <span class="hljs-string">&quot;huggan/smithsonian_butterflies_subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(config.dataset_name, split=<span class="hljs-string">&quot;train&quot;</span>)`}}),W=new fa({props:{$$slots:{default:[Ze]},$$scope:{ctx:G}}}),os=new d({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQWZpZyUyQyUyMGF4cyUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwNCUyQyUyMGZpZ3NpemUlM0QoMTYlMkMlMjA0KSklMEFmb3IlMjBpJTJDJTIwaW1hZ2UlMjBpbiUyMGVudW1lcmF0ZShkYXRhc2V0JTVCJTNBNCU1RCU1QiUyMmltYWdlJTIyJTVEKSUzQSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuaW1zaG93KGltYWdlKSUwQSUyMCUyMCUyMCUyMGF4cyU1QmklNUQuc2V0X2F4aXNfb2ZmKCklMEFmaWcuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

<span class="hljs-meta">&gt;&gt;&gt; </span>fig, axs = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, figsize=(<span class="hljs-number">16</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, image <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(dataset[:<span class="hljs-number">4</span>][<span class="hljs-string">&quot;image&quot;</span>]):
<span class="hljs-meta">... </span>    axs[i].imshow(image)
<span class="hljs-meta">... </span>    axs[i].set_axis_off()
<span class="hljs-meta">&gt;&gt;&gt; </span>fig.show()`}}),rs=new d({props:{code:"ZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXByZXByb2Nlc3MlMjAlM0QlMjB0cmFuc2Zvcm1zLkNvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3Jtcy5SZXNpemUoKGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwY29uZmlnLmltYWdlX3NpemUpKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuUmFuZG9tSG9yaXpvbnRhbEZsaXAoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuVG9UZW5zb3IoKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybXMuTm9ybWFsaXplKCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocess = transforms.Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        transforms.Resize((config.image_size, config.image_size)),
<span class="hljs-meta">... </span>        transforms.RandomHorizontalFlip(),
<span class="hljs-meta">... </span>        transforms.ToTensor(),
<span class="hljs-meta">... </span>        transforms.Normalize([<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>]),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)`}}),hs=new d({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGVzKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnByZXByb2Nlc3MoaW1hZ2UuY29udmVydCglMjJSR0IlMjIpKSUyMGZvciUyMGltYWdlJTIwaW4lMjBleGFtcGxlcyU1QiUyMmltYWdlJTIyJTVEJTVEJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2VzJTIyJTNBJTIwaW1hZ2VzJTdEJTBBJTBBJTBBZGF0YXNldC5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    images = [preprocess(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;image&quot;</span>]]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;images&quot;</span>: images}


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset.set_transform(transform)`}}),ys=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEY29uZmlnLnRyYWluX2JhdGNoX3NpemUlMkMlMjBzaHVmZmxlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = torch.utils.data.DataLoader(dataset, batch_size=config.train_batch_size, shuffle=<span class="hljs-literal">True</span>)`}}),ws=new Fs({}),Ts=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRNb2RlbCglMEElMjAlMjAlMjAlMjBzYW1wbGVfc2l6ZSUzRGNvbmZpZy5pbWFnZV9zaXplJTJDJTIwJTIwJTIzJTIwdGhlJTIwdGFyZ2V0JTIwaW1hZ2UlMjByZXNvbHV0aW9uJTBBJTIwJTIwJTIwJTIwaW5fY2hhbm5lbHMlM0QzJTJDJTIwJTIwJTIzJTIwdGhlJTIwbnVtYmVyJTIwb2YlMjBpbnB1dCUyMGNoYW5uZWxzJTJDJTIwMyUyMGZvciUyMFJHQiUyMGltYWdlcyUwQSUyMCUyMCUyMCUyMG91dF9jaGFubmVscyUzRDMlMkMlMjAlMjAlMjMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMG91dHB1dCUyMGNoYW5uZWxzJTBBJTIwJTIwJTIwJTIwbGF5ZXJzX3Blcl9ibG9jayUzRDIlMkMlMjAlMjAlMjMlMjBob3clMjBtYW55JTIwUmVzTmV0JTIwbGF5ZXJzJTIwdG8lMjB1c2UlMjBwZXIlMjBVTmV0JTIwYmxvY2slMEElMjAlMjAlMjAlMjBibG9ja19vdXRfY2hhbm5lbHMlM0QoMTI4JTJDJTIwMTI4JTJDJTIwMjU2JTJDJTIwMjU2JTJDJTIwNTEyJTJDJTIwNTEyKSUyQyUyMCUyMCUyMyUyMHRoZSUyMG51bWJlciUyMG9mJTIwb3V0cHV0JTIwY2hhbm5lbHMlMjBmb3IlMjBlYWNoJTIwVU5ldCUyMGJsb2NrJTBBJTIwJTIwJTIwJTIwZG93bl9ibG9ja190eXBlcyUzRCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEb3duQmxvY2syRCUyMiUyQyUyMCUyMCUyMyUyMGElMjByZWd1bGFyJTIwUmVzTmV0JTIwZG93bnNhbXBsaW5nJTIwYmxvY2slMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJEb3duQmxvY2syRCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkRvd25CbG9jazJEJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRG93bkJsb2NrMkQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBdHRuRG93bkJsb2NrMkQlMjIlMkMlMjAlMjAlMjMlMjBhJTIwUmVzTmV0JTIwZG93bnNhbXBsaW5nJTIwYmxvY2slMjB3aXRoJTIwc3BhdGlhbCUyMHNlbGYtYXR0ZW50aW9uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyRG93bkJsb2NrMkQlMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwdXBfYmxvY2tfdHlwZXMlM0QoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyVXBCbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMHJlZ3VsYXIlMjBSZXNOZXQlMjB1cHNhbXBsaW5nJTIwYmxvY2slMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJBdHRuVXBCbG9jazJEJTIyJTJDJTIwJTIwJTIzJTIwYSUyMFJlc05ldCUyMHVwc2FtcGxpbmclMjBibG9jayUyMHdpdGglMjBzcGF0aWFsJTIwc2VsZi1hdHRlbnRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVcEJsb2NrMkQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVcEJsb2NrMkQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVcEJsb2NrMkQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJVcEJsb2NrMkQlMjIlMkMlMEElMjAlMjAlMjAlMjApJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DModel(
<span class="hljs-meta">... </span>    sample_size=config.image_size,  <span class="hljs-comment"># the target image resolution</span>
<span class="hljs-meta">... </span>    in_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of input channels, 3 for RGB images</span>
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">3</span>,  <span class="hljs-comment"># the number of output channels</span>
<span class="hljs-meta">... </span>    layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
<span class="hljs-meta">... </span>    block_out_channels=(<span class="hljs-number">128</span>, <span class="hljs-number">128</span>, <span class="hljs-number">256</span>, <span class="hljs-number">256</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>),  <span class="hljs-comment"># the number of output channels for each UNet block</span>
<span class="hljs-meta">... </span>    down_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;DownBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>    up_block_types=(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;UpBlock2D&quot;</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)`}}),ds=new d({props:{code:"c2FtcGxlX2ltYWdlJTIwJTNEJTIwZGF0YXNldCU1QjAlNUQlNUIlMjJpbWFnZXMlMjIlNUQudW5zcXVlZXplKDApJTBBcHJpbnQoJTIySW5wdXQlMjBzaGFwZSUzQSUyMiUyQyUyMHNhbXBsZV9pbWFnZS5zaGFwZSklMEElMEFwcmludCglMjJPdXRwdXQlMjBzaGFwZSUzQSUyMiUyQyUyMG1vZGVsKHNhbXBsZV9pbWFnZSUyQyUyMHRpbWVzdGVwJTNEMCkuc2FtcGxlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sample_image = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;images&quot;</span>].unsqueeze(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, sample_image.shape)
Input shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Output shape:&quot;</span>, model(sample_image, timestep=<span class="hljs-number">0</span>).sample.shape)
Output shape: torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">128</span>, <span class="hljs-number">128</span>])`}}),bs=new Fs({}),fs=new d({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERQTVNjaGVkdWxlciUwQSUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDApJTBBbm9pc2UlMjAlM0QlMjB0b3JjaC5yYW5kbihzYW1wbGVfaW1hZ2Uuc2hhcGUpJTBBdGltZXN0ZXBzJTIwJTNEJTIwdG9yY2guTG9uZ1RlbnNvciglNUI1MCU1RCklMEFub2lzeV9pbWFnZSUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5hZGRfbm9pc2Uoc2FtcGxlX2ltYWdlJTJDJTIwbm9pc2UlMkMlMjB0aW1lc3RlcHMpJTBBJTBBSW1hZ2UuZnJvbWFycmF5KCgobm9pc3lfaW1hZ2UucGVybXV0ZSgwJTJDJTIwMiUyQyUyMDMlMkMlMjAxKSUyMCUyQiUyMDEuMCklMjAqJTIwMTI3LjUpLnR5cGUodG9yY2gudWludDgpLm51bXB5KCklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>noise = torch.randn(sample_image.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span>timesteps = torch.LongTensor([<span class="hljs-number">50</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>noisy_image = noise_scheduler.add_noise(sample_image, noise, timesteps)

<span class="hljs-meta">&gt;&gt;&gt; </span>Image.fromarray(((noisy_image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>) + <span class="hljs-number">1.0</span>) * <span class="hljs-number">127.5</span>).<span class="hljs-built_in">type</span>(torch.uint8).numpy()[<span class="hljs-number">0</span>])`}}),As=new d({props:{code:"aW1wb3J0JTIwdG9yY2gubm4uZnVuY3Rpb25hbCUyMGFzJTIwRiUwQSUwQW5vaXNlX3ByZWQlMjAlM0QlMjBtb2RlbChub2lzeV9pbWFnZSUyQyUyMHRpbWVzdGVwcykuc2FtcGxlJTBBbG9zcyUyMCUzRCUyMEYubXNlX2xvc3Mobm9pc2VfcHJlZCUyQyUyMG5vaXNlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn.functional <span class="hljs-keyword">as</span> F

<span class="hljs-meta">&gt;&gt;&gt; </span>noise_pred = model(noisy_image, timesteps).sample
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = F.mse_loss(noise_pred, noise)`}}),Bs=new Fs({}),vs=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5vcHRpbWl6YXRpb24lMjBpbXBvcnQlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Rjb25maWcubGVhcm5pbmdfcmF0ZSklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfY29zaW5lX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0Rjb25maWcubHJfd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBjb25maWcubnVtX2Vwb2NocyklMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.optimization <span class="hljs-keyword">import</span> get_cosine_schedule_with_warmup

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.AdamW(model.parameters(), lr=config.learning_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_cosine_schedule_with_warmup(
<span class="hljs-meta">... </span>    optimizer=optimizer,
<span class="hljs-meta">... </span>    num_warmup_steps=config.lr_warmup_steps,
<span class="hljs-meta">... </span>    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * config.num_epochs),
<span class="hljs-meta">... </span>)`}}),_s=new d({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1QaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBtYWtlX2ltYWdlX2dyaWQlMEFpbXBvcnQlMjBvcyUwQSUwQWRlZiUyMGV2YWx1YXRlKGNvbmZpZyUyQyUyMGVwb2NoJTJDJTIwcGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2FtcGxlJTIwc29tZSUyMGltYWdlcyUyMGZyb20lMjByYW5kb20lMjBub2lzZSUyMCh0aGlzJTIwaXMlMjB0aGUlMjBiYWNrd2FyZCUyMGRpZmZ1c2lvbiUyMHByb2Nlc3MpLiUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZSUyMGRlZmF1bHQlMjBwaXBlbGluZSUyMG91dHB1dCUyMHR5cGUlMjBpcyUyMCU2MExpc3QlNUJQSUwuSW1hZ2UlNUQlNjAlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEY29uZmlnLmV2YWxfYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKGNvbmZpZy5zZWVkKSUyQyUwQSUyMCUyMCUyMCUyMCkuaW1hZ2VzJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwTWFrZSUyMGElMjBncmlkJTIwb3V0JTIwb2YlMjB0aGUlMjBpbWFnZXMlMEElMjAlMjAlMjAlMjBpbWFnZV9ncmlkJTIwJTNEJTIwbWFrZV9pbWFnZV9ncmlkKGltYWdlcyUyQyUyMHJvd3MlM0Q0JTJDJTIwY29scyUzRDQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2F2ZSUyMHRoZSUyMGltYWdlcyUwQSUyMCUyMCUyMCUyMHRlc3RfZGlyJTIwJTNEJTIwb3MucGF0aC5qb2luKGNvbmZpZy5vdXRwdXRfZGlyJTJDJTIwJTIyc2FtcGxlcyUyMiklMEElMjAlMjAlMjAlMjBvcy5tYWtlZGlycyh0ZXN0X2RpciUyQyUyMGV4aXN0X29rJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBpbWFnZV9ncmlkLnNhdmUoZiUyMiU3QnRlc3RfZGlyJTdEJTJGJTdCZXBvY2glM0EwNGQlN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">evaluate</span>(<span class="hljs-params">config, epoch, pipeline</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Sample some images from random noise (this is the backward diffusion process).</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># The default pipeline output type is \`List[PIL.Image]\`</span>
<span class="hljs-meta">... </span>    images = pipeline(
<span class="hljs-meta">... </span>        batch_size=config.eval_batch_size,
<span class="hljs-meta">... </span>        generator=torch.manual_seed(config.seed),
<span class="hljs-meta">... </span>    ).images

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Make a grid out of the images</span>
<span class="hljs-meta">... </span>    image_grid = make_image_grid(images, rows=<span class="hljs-number">4</span>, cols=<span class="hljs-number">4</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Save the images</span>
<span class="hljs-meta">... </span>    test_dir = os.path.join(config.output_dir, <span class="hljs-string">&quot;samples&quot;</span>)
<span class="hljs-meta">... </span>    os.makedirs(test_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    image_grid.save(<span class="hljs-string">f&quot;<span class="hljs-subst">{test_dir}</span>/<span class="hljs-subst">{epoch:04d}</span>.png&quot;</span>)`}}),E=new fa({props:{$$slots:{default:[Ge]},$$scope:{ctx:G}}}),Ws=new d({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo, upload_folder
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">train_loop</span>(<span class="hljs-params">config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># Initialize accelerator and tensorboard logging</span>
<span class="hljs-meta">... </span>    accelerator = Accelerator(
<span class="hljs-meta">... </span>        mixed_precision=config.mixed_precision,
<span class="hljs-meta">... </span>        gradient_accumulation_steps=config.gradient_accumulation_steps,
<span class="hljs-meta">... </span>        log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>,
<span class="hljs-meta">... </span>        project_dir=os.path.join(config.output_dir, <span class="hljs-string">&quot;logs&quot;</span>),
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.output_dir <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
<span class="hljs-meta">... </span>            os.makedirs(config.output_dir, exist_ok=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>            repo_id = create_repo(
<span class="hljs-meta">... </span>                repo_id=config.hub_model_id <span class="hljs-keyword">or</span> Path(config.output_dir).name, exist_ok=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            ).repo_id
<span class="hljs-meta">... </span>        accelerator.init_trackers(<span class="hljs-string">&quot;train_example&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Prepare everything</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># objects in the same order you gave them to the prepare method.</span>
<span class="hljs-meta">... </span>    model, optimizer, train_dataloader, lr_scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>        model, optimizer, train_dataloader, lr_scheduler
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    global_step = <span class="hljs-number">0</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Now you train the model</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(config.num_epochs):
<span class="hljs-meta">... </span>        progress_bar = tqdm(total=<span class="hljs-built_in">len</span>(train_dataloader), disable=<span class="hljs-keyword">not</span> accelerator.is_local_main_process)
<span class="hljs-meta">... </span>        progress_bar.set_description(<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>)

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(train_dataloader):
<span class="hljs-meta">... </span>            clean_images = batch[<span class="hljs-string">&quot;images&quot;</span>]
<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample noise to add to the images</span>
<span class="hljs-meta">... </span>            noise = torch.randn(clean_images.shape, device=clean_images.device)
<span class="hljs-meta">... </span>            bs = clean_images.shape[<span class="hljs-number">0</span>]

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Sample a random timestep for each image</span>
<span class="hljs-meta">... </span>            timesteps = torch.randint(
<span class="hljs-meta">... </span>                <span class="hljs-number">0</span>, noise_scheduler.config.num_train_timesteps, (bs,), device=clean_images.device,
<span class="hljs-meta">... </span>                dtype=torch.int64
<span class="hljs-meta">... </span>            )

<span class="hljs-meta">... </span>            <span class="hljs-comment"># Add noise to the clean images according to the noise magnitude at each timestep</span>
<span class="hljs-meta">... </span>            <span class="hljs-comment"># (this is the forward diffusion process)</span>
<span class="hljs-meta">... </span>            noisy_images = noise_scheduler.add_noise(clean_images, noise, timesteps)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>                <span class="hljs-comment"># Predict the noise residual</span>
<span class="hljs-meta">... </span>                noise_pred = model(noisy_images, timesteps, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>                loss = F.mse_loss(noise_pred, noise)
<span class="hljs-meta">... </span>                accelerator.backward(loss)

<span class="hljs-meta">... </span>                accelerator.clip_grad_norm_(model.parameters(), <span class="hljs-number">1.0</span>)
<span class="hljs-meta">... </span>                optimizer.step()
<span class="hljs-meta">... </span>                lr_scheduler.step()
<span class="hljs-meta">... </span>                optimizer.zero_grad()

<span class="hljs-meta">... </span>            progress_bar.update(<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>            logs = {<span class="hljs-string">&quot;loss&quot;</span>: loss.detach().item(), <span class="hljs-string">&quot;lr&quot;</span>: lr_scheduler.get_last_lr()[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;step&quot;</span>: global_step}
<span class="hljs-meta">... </span>            progress_bar.set_postfix(**logs)
<span class="hljs-meta">... </span>            accelerator.log(logs, step=global_step)
<span class="hljs-meta">... </span>            global_step += <span class="hljs-number">1</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># After each epoch you optionally sample some demo images with evaluate() and save the model</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>            pipeline = DDPMPipeline(unet=accelerator.unwrap_model(model), scheduler=noise_scheduler)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_image_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                evaluate(config, epoch, pipeline)

<span class="hljs-meta">... </span>            <span class="hljs-keyword">if</span> (epoch + <span class="hljs-number">1</span>) % config.save_model_epochs == <span class="hljs-number">0</span> <span class="hljs-keyword">or</span> epoch == config.num_epochs - <span class="hljs-number">1</span>:
<span class="hljs-meta">... </span>                <span class="hljs-keyword">if</span> config.push_to_hub:
<span class="hljs-meta">... </span>                    upload_folder(
<span class="hljs-meta">... </span>                        repo_id=repo_id,
<span class="hljs-meta">... </span>                        folder_path=config.output_dir,
<span class="hljs-meta">... </span>                        commit_message=<span class="hljs-string">f&quot;Epoch <span class="hljs-subst">{epoch}</span>&quot;</span>,
<span class="hljs-meta">... </span>                        ignore_patterns=[<span class="hljs-string">&quot;step_*&quot;</span>, <span class="hljs-string">&quot;epoch_*&quot;</span>],
<span class="hljs-meta">... </span>                    )
<span class="hljs-meta">... </span>                <span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>                    pipeline.save_pretrained(config.output_dir)`}}),Vs=new d({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQWFyZ3MlMjAlM0QlMjAoY29uZmlnJTJDJTIwbW9kZWwlMkMlMjBub2lzZV9zY2hlZHVsZXIlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>args = (config, model, noise_scheduler, optimizer, train_dataloader, lr_scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(train_loop, args, num_processes=<span class="hljs-number">1</span>)`}}),$s=new d({props:{code:"aW1wb3J0JTIwZ2xvYiUwQSUwQXNhbXBsZV9pbWFnZXMlMjAlM0QlMjBzb3J0ZWQoZ2xvYi5nbG9iKGYlMjIlN0Jjb25maWcub3V0cHV0X2RpciU3RCUyRnNhbXBsZXMlMkYqLnBuZyUyMikpJTBBSW1hZ2Uub3BlbihzYW1wbGVfaW1hZ2VzJTVCLTElNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> glob

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_images = <span class="hljs-built_in">sorted</span>(glob.glob(<span class="hljs-string">f&quot;<span class="hljs-subst">{config.output_dir}</span>/samples/*.png&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>Image.<span class="hljs-built_in">open</span>(sample_images[-<span class="hljs-number">1</span>])`}}),Ys=new Fs({}),{c(){i=p("meta"),U=t(),r(T.$$.fragment),b=t(),g=p("h1"),v=p("a"),Ps=p("span"),r(F.$$.fragment),Ta=t(),Ss=p("span"),Ss.textContent=Aa,Ml=t(),S=p("p"),S.innerHTML=Ba,ol=t(),x=p("p"),x.innerHTML=Za,il=t(),r(k.$$.fragment),cl=t(),H=p("p"),H.innerHTML=Ga,rl=t(),r(D.$$.fragment),jl=t(),q=p("p"),q.innerHTML=va,hl=t(),r(L.$$.fragment),ml=t(),K=p("p"),K.textContent=ka,yl=t(),r(P.$$.fragment),wl=t(),O=p("p"),O.innerHTML=_a,Jl=t(),r(ss.$$.fragment),Tl=t(),I=p("h2"),_=p("a"),Os=p("span"),r(ls.$$.fragment),ua=t(),xs=p("span"),xs.textContent=Xa,ul=t(),as=p("p"),as.innerHTML=Wa,dl=t(),r(es.$$.fragment),Ul=t(),f=p("h2"),X=p("a"),sl=p("span"),r(ts.$$.fragment),da=t(),Hs=p("span"),Hs.textContent=Na,bl=t(),ns=p("p"),ns.innerHTML=Va,gl=t(),r(ps.$$.fragment),Il=t(),r(W.$$.fragment),fl=t(),Ms=p("p"),Ms.innerHTML=Ra,Cl=t(),r(os.$$.fragment),Al=t(),N=p("div"),N.innerHTML=$a,Bl=t(),is=p("p"),is.textContent=Ya,Zl=t(),cs=p("ul"),cs.innerHTML=Ea,Gl=t(),r(rs.$$.fragment),vl=t(),js=p("p"),js.innerHTML=za,kl=t(),r(hs.$$.fragment),_l=t(),ms=p("p"),ms.innerHTML=Qa,Xl=t(),r(ys.$$.fragment),Wl=t(),C=p("h2"),V=p("a"),ll=p("span"),r(ws.$$.fragment),Ua=t(),Ds=p("span"),Ds.textContent=Fa,Nl=t(),Js=p("p"),Js.innerHTML=Sa,Vl=t(),r(Ts.$$.fragment),Rl=t(),us=p("p"),us.textContent=xa,$l=t(),r(ds.$$.fragment),Yl=t(),Us=p("p"),Us.textContent=Ha,El=t(),A=p("h2"),R=p("a"),al=p("span"),r(bs.$$.fragment),ba=t(),qs=p("span"),qs.textContent=Da,zl=t(),gs=p("p"),gs.innerHTML=qa,Ql=t(),Is=p("p"),Is.innerHTML=La,Fl=t(),r(fs.$$.fragment),Sl=t(),$=p("div"),$.innerHTML=Ka,xl=t(),Cs=p("p"),Cs.textContent=Pa,Hl=t(),r(As.$$.fragment),Dl=t(),B=p("h2"),Y=p("a"),el=p("span"),r(Bs.$$.fragment),ga=t(),Ls=p("span"),Ls.textContent=Oa,ql=t(),Zs=p("p"),Zs.textContent=se,Ll=t(),Gs=p("p"),Gs.textContent=le,Kl=t(),r(vs.$$.fragment),Pl=t(),ks=p("p"),ks.innerHTML=ae,Ol=t(),r(_s.$$.fragment),sa=t(),Xs=p("p"),Xs.textContent=ee,la=t(),r(E.$$.fragment),aa=t(),r(Ws.$$.fragment),ea=t(),Ns=p("p"),Ns.innerHTML=te,ta=t(),r(Vs.$$.fragment),na=t(),Rs=p("p"),Rs.textContent=ne,pa=t(),r($s.$$.fragment),Ma=t(),z=p("div"),z.innerHTML=pe,oa=t(),Z=p("h2"),Q=p("a"),tl=p("span"),r(Ys.$$.fragment),Ia=t(),Ks=p("span"),Ks.textContent=Me,ia=t(),Es=p("p"),Es.innerHTML=oe,ca=t(),zs=p("ul"),zs.innerHTML=ie,this.h()},l(s){const l=Ce("svelte-1phssyn",document.head);i=M(l,"META",{name:!0,content:!0}),l.forEach(a),U=n(s),j(T.$$.fragment,s),b=n(s),g=M(s,"H1",{class:!0});var Qs=u(g);v=M(Qs,"A",{id:!0,class:!0,href:!0});var nl=u(v);Ps=M(nl,"SPAN",{});var pl=u(Ps);j(F.$$.fragment,pl),pl.forEach(a),nl.forEach(a),Ta=n(Qs),Ss=M(Qs,"SPAN",{"data-svelte-h":!0}),o(Ss)!=="svelte-1rg311g"&&(Ss.textContent=Aa),Qs.forEach(a),Ml=n(s),S=M(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-tdss46"&&(S.innerHTML=Ba),ol=n(s),x=M(s,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1xri6do"&&(x.innerHTML=Za),il=n(s),j(k.$$.fragment,s),cl=n(s),H=M(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-x3q6hl"&&(H.innerHTML=Ga),rl=n(s),j(D.$$.fragment,s),jl=n(s),q=M(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1c8cv44"&&(q.innerHTML=va),hl=n(s),j(L.$$.fragment,s),ml=n(s),K=M(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-17henro"&&(K.textContent=ka),yl=n(s),j(P.$$.fragment,s),wl=n(s),O=M(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-sz5qnh"&&(O.innerHTML=_a),Jl=n(s),j(ss.$$.fragment,s),Tl=n(s),I=M(s,"H2",{class:!0});var ja=u(I);_=M(ja,"A",{id:!0,class:!0,href:!0});var ce=u(_);Os=M(ce,"SPAN",{});var re=u(Os);j(ls.$$.fragment,re),re.forEach(a),ce.forEach(a),ua=n(ja),xs=M(ja,"SPAN",{"data-svelte-h":!0}),o(xs)!=="svelte-1xhdjy5"&&(xs.textContent=Xa),ja.forEach(a),ul=n(s),as=M(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-1otxl74"&&(as.innerHTML=Wa),dl=n(s),j(es.$$.fragment,s),Ul=n(s),f=M(s,"H2",{class:!0});var ha=u(f);X=M(ha,"A",{id:!0,class:!0,href:!0});var je=u(X);sl=M(je,"SPAN",{});var he=u(sl);j(ts.$$.fragment,he),he.forEach(a),je.forEach(a),da=n(ha),Hs=M(ha,"SPAN",{"data-svelte-h":!0}),o(Hs)!=="svelte-6t1nik"&&(Hs.textContent=Na),ha.forEach(a),bl=n(s),ns=M(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1wj8hyv"&&(ns.innerHTML=Va),gl=n(s),j(ps.$$.fragment,s),Il=n(s),j(W.$$.fragment,s),fl=n(s),Ms=M(s,"P",{"data-svelte-h":!0}),o(Ms)!=="svelte-1u6ctic"&&(Ms.innerHTML=Ra),Cl=n(s),j(os.$$.fragment,s),Al=n(s),N=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(N)!=="svelte-1wjbouq"&&(N.innerHTML=$a),Bl=n(s),is=M(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-19lli6v"&&(is.textContent=Ya),Zl=n(s),cs=M(s,"UL",{"data-svelte-h":!0}),o(cs)!=="svelte-8oirkq"&&(cs.innerHTML=Ea),Gl=n(s),j(rs.$$.fragment,s),vl=n(s),js=M(s,"P",{"data-svelte-h":!0}),o(js)!=="svelte-vqrdxq"&&(js.innerHTML=za),kl=n(s),j(hs.$$.fragment,s),_l=n(s),ms=M(s,"P",{"data-svelte-h":!0}),o(ms)!=="svelte-1abv18u"&&(ms.innerHTML=Qa),Xl=n(s),j(ys.$$.fragment,s),Wl=n(s),C=M(s,"H2",{class:!0});var ma=u(C);V=M(ma,"A",{id:!0,class:!0,href:!0});var me=u(V);ll=M(me,"SPAN",{});var ye=u(ll);j(ws.$$.fragment,ye),ye.forEach(a),me.forEach(a),Ua=n(ma),Ds=M(ma,"SPAN",{"data-svelte-h":!0}),o(Ds)!=="svelte-10hvjxr"&&(Ds.textContent=Fa),ma.forEach(a),Nl=n(s),Js=M(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-u0qful"&&(Js.innerHTML=Sa),Vl=n(s),j(Ts.$$.fragment,s),Rl=n(s),us=M(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-ahjyed"&&(us.textContent=xa),$l=n(s),j(ds.$$.fragment,s),Yl=n(s),Us=M(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-1hkhok8"&&(Us.textContent=Ha),El=n(s),A=M(s,"H2",{class:!0});var ya=u(A);R=M(ya,"A",{id:!0,class:!0,href:!0});var we=u(R);al=M(we,"SPAN",{});var Je=u(al);j(bs.$$.fragment,Je),Je.forEach(a),we.forEach(a),ba=n(ya),qs=M(ya,"SPAN",{"data-svelte-h":!0}),o(qs)!=="svelte-i532ej"&&(qs.textContent=Da),ya.forEach(a),zl=n(s),gs=M(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-31qoa1"&&(gs.innerHTML=qa),Ql=n(s),Is=M(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-vuf5b1"&&(Is.innerHTML=La),Fl=n(s),j(fs.$$.fragment,s),Sl=n(s),$=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-qcxk5"&&($.innerHTML=Ka),xl=n(s),Cs=M(s,"P",{"data-svelte-h":!0}),o(Cs)!=="svelte-1pekxga"&&(Cs.textContent=Pa),Hl=n(s),j(As.$$.fragment,s),Dl=n(s),B=M(s,"H2",{class:!0});var wa=u(B);Y=M(wa,"A",{id:!0,class:!0,href:!0});var Te=u(Y);el=M(Te,"SPAN",{});var ue=u(el);j(Bs.$$.fragment,ue),ue.forEach(a),Te.forEach(a),ga=n(wa),Ls=M(wa,"SPAN",{"data-svelte-h":!0}),o(Ls)!=="svelte-n13n3f"&&(Ls.textContent=Oa),wa.forEach(a),ql=n(s),Zs=M(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-rpu9md"&&(Zs.textContent=se),Ll=n(s),Gs=M(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-11y5cd5"&&(Gs.textContent=le),Kl=n(s),j(vs.$$.fragment,s),Pl=n(s),ks=M(s,"P",{"data-svelte-h":!0}),o(ks)!=="svelte-10sg1b7"&&(ks.innerHTML=ae),Ol=n(s),j(_s.$$.fragment,s),sa=n(s),Xs=M(s,"P",{"data-svelte-h":!0}),o(Xs)!=="svelte-13pvon6"&&(Xs.textContent=ee),la=n(s),j(E.$$.fragment,s),aa=n(s),j(Ws.$$.fragment,s),ea=n(s),Ns=M(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-1r1vqlt"&&(Ns.innerHTML=te),ta=n(s),j(Vs.$$.fragment,s),na=n(s),Rs=M(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-nz3dg5"&&(Rs.textContent=ne),pa=n(s),j($s.$$.fragment,s),Ma=n(s),z=M(s,"DIV",{class:!0,"data-svelte-h":!0}),o(z)!=="svelte-tzqtub"&&(z.innerHTML=pe),oa=n(s),Z=M(s,"H2",{class:!0});var Ja=u(Z);Q=M(Ja,"A",{id:!0,class:!0,href:!0});var de=u(Q);tl=M(de,"SPAN",{});var Ue=u(tl);j(Ys.$$.fragment,Ue),Ue.forEach(a),de.forEach(a),Ia=n(Ja),Ks=M(Ja,"SPAN",{"data-svelte-h":!0}),o(Ks)!=="svelte-pr7lub"&&(Ks.textContent=Me),Ja.forEach(a),ia=n(s),Es=M(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-zg9981"&&(Es.innerHTML=oe),ca=n(s),zs=M(s,"UL",{"data-svelte-h":!0}),o(zs)!=="svelte-cndhdw"&&(zs.innerHTML=ie),this.h()},h(){c(i,"name","hf:doc:metadata"),c(i,"content",JSON.stringify(ke)),c(v,"id","train-a-diffusion-model"),c(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(v,"href","#train-a-diffusion-model"),c(g,"class","relative group"),c(_,"id","training-configuration"),c(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(_,"href","#training-configuration"),c(I,"class","relative group"),c(X,"id","load-the-dataset"),c(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(X,"href","#load-the-dataset"),c(f,"class","relative group"),c(N,"class","flex justify-center"),c(V,"id","create-a-unet2dmodel"),c(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(V,"href","#create-a-unet2dmodel"),c(C,"class","relative group"),c(R,"id","create-a-scheduler"),c(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(R,"href","#create-a-scheduler"),c(A,"class","relative group"),c($,"class","flex justify-center"),c(Y,"id","train-the-model"),c(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Y,"href","#train-the-model"),c(B,"class","relative group"),c(z,"class","flex justify-center"),c(Q,"id","next-steps"),c(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Q,"href","#next-steps"),c(Z,"class","relative group")},m(s,l){J(document.head,i),e(s,U,l),h(T,s,l),e(s,b,l),e(s,g,l),J(g,v),J(v,Ps),h(F,Ps,null),J(g,Ta),J(g,Ss),e(s,Ml,l),e(s,S,l),e(s,ol,l),e(s,x,l),e(s,il,l),h(k,s,l),e(s,cl,l),e(s,H,l),e(s,rl,l),h(D,s,l),e(s,jl,l),e(s,q,l),e(s,hl,l),h(L,s,l),e(s,ml,l),e(s,K,l),e(s,yl,l),h(P,s,l),e(s,wl,l),e(s,O,l),e(s,Jl,l),h(ss,s,l),e(s,Tl,l),e(s,I,l),J(I,_),J(_,Os),h(ls,Os,null),J(I,ua),J(I,xs),e(s,ul,l),e(s,as,l),e(s,dl,l),h(es,s,l),e(s,Ul,l),e(s,f,l),J(f,X),J(X,sl),h(ts,sl,null),J(f,da),J(f,Hs),e(s,bl,l),e(s,ns,l),e(s,gl,l),h(ps,s,l),e(s,Il,l),h(W,s,l),e(s,fl,l),e(s,Ms,l),e(s,Cl,l),h(os,s,l),e(s,Al,l),e(s,N,l),e(s,Bl,l),e(s,is,l),e(s,Zl,l),e(s,cs,l),e(s,Gl,l),h(rs,s,l),e(s,vl,l),e(s,js,l),e(s,kl,l),h(hs,s,l),e(s,_l,l),e(s,ms,l),e(s,Xl,l),h(ys,s,l),e(s,Wl,l),e(s,C,l),J(C,V),J(V,ll),h(ws,ll,null),J(C,Ua),J(C,Ds),e(s,Nl,l),e(s,Js,l),e(s,Vl,l),h(Ts,s,l),e(s,Rl,l),e(s,us,l),e(s,$l,l),h(ds,s,l),e(s,Yl,l),e(s,Us,l),e(s,El,l),e(s,A,l),J(A,R),J(R,al),h(bs,al,null),J(A,ba),J(A,qs),e(s,zl,l),e(s,gs,l),e(s,Ql,l),e(s,Is,l),e(s,Fl,l),h(fs,s,l),e(s,Sl,l),e(s,$,l),e(s,xl,l),e(s,Cs,l),e(s,Hl,l),h(As,s,l),e(s,Dl,l),e(s,B,l),J(B,Y),J(Y,el),h(Bs,el,null),J(B,ga),J(B,Ls),e(s,ql,l),e(s,Zs,l),e(s,Ll,l),e(s,Gs,l),e(s,Kl,l),h(vs,s,l),e(s,Pl,l),e(s,ks,l),e(s,Ol,l),h(_s,s,l),e(s,sa,l),e(s,Xs,l),e(s,la,l),h(E,s,l),e(s,aa,l),h(Ws,s,l),e(s,ea,l),e(s,Ns,l),e(s,ta,l),h(Vs,s,l),e(s,na,l),e(s,Rs,l),e(s,pa,l),h($s,s,l),e(s,Ma,l),e(s,z,l),e(s,oa,l),e(s,Z,l),J(Z,Q),J(Q,tl),h(Ys,tl,null),J(Z,Ia),J(Z,Ks),e(s,ia,l),e(s,Es,l),e(s,ca,l),e(s,zs,l),ra=!0},p(s,[l]){const Qs={};l&2&&(Qs.$$scope={dirty:l,ctx:s}),k.$set(Qs);const nl={};l&2&&(nl.$$scope={dirty:l,ctx:s}),W.$set(nl);const pl={};l&2&&(pl.$$scope={dirty:l,ctx:s}),E.$set(pl)},i(s){ra||(m(T.$$.fragment,s),m(F.$$.fragment,s),m(k.$$.fragment,s),m(D.$$.fragment,s),m(L.$$.fragment,s),m(P.$$.fragment,s),m(ss.$$.fragment,s),m(ls.$$.fragment,s),m(es.$$.fragment,s),m(ts.$$.fragment,s),m(ps.$$.fragment,s),m(W.$$.fragment,s),m(os.$$.fragment,s),m(rs.$$.fragment,s),m(hs.$$.fragment,s),m(ys.$$.fragment,s),m(ws.$$.fragment,s),m(Ts.$$.fragment,s),m(ds.$$.fragment,s),m(bs.$$.fragment,s),m(fs.$$.fragment,s),m(As.$$.fragment,s),m(Bs.$$.fragment,s),m(vs.$$.fragment,s),m(_s.$$.fragment,s),m(E.$$.fragment,s),m(Ws.$$.fragment,s),m(Vs.$$.fragment,s),m($s.$$.fragment,s),m(Ys.$$.fragment,s),ra=!0)},o(s){y(T.$$.fragment,s),y(F.$$.fragment,s),y(k.$$.fragment,s),y(D.$$.fragment,s),y(L.$$.fragment,s),y(P.$$.fragment,s),y(ss.$$.fragment,s),y(ls.$$.fragment,s),y(es.$$.fragment,s),y(ts.$$.fragment,s),y(ps.$$.fragment,s),y(W.$$.fragment,s),y(os.$$.fragment,s),y(rs.$$.fragment,s),y(hs.$$.fragment,s),y(ys.$$.fragment,s),y(ws.$$.fragment,s),y(Ts.$$.fragment,s),y(ds.$$.fragment,s),y(bs.$$.fragment,s),y(fs.$$.fragment,s),y(As.$$.fragment,s),y(Bs.$$.fragment,s),y(vs.$$.fragment,s),y(_s.$$.fragment,s),y(E.$$.fragment,s),y(Ws.$$.fragment,s),y(Vs.$$.fragment,s),y($s.$$.fragment,s),y(Ys.$$.fragment,s),ra=!1},d(s){s&&(a(U),a(b),a(g),a(Ml),a(S),a(ol),a(x),a(il),a(cl),a(H),a(rl),a(jl),a(q),a(hl),a(ml),a(K),a(yl),a(wl),a(O),a(Jl),a(Tl),a(I),a(ul),a(as),a(dl),a(Ul),a(f),a(bl),a(ns),a(gl),a(Il),a(fl),a(Ms),a(Cl),a(Al),a(N),a(Bl),a(is),a(Zl),a(cs),a(Gl),a(vl),a(js),a(kl),a(_l),a(ms),a(Xl),a(Wl),a(C),a(Nl),a(Js),a(Vl),a(Rl),a(us),a($l),a(Yl),a(Us),a(El),a(A),a(zl),a(gs),a(Ql),a(Is),a(Fl),a(Sl),a($),a(xl),a(Cs),a(Hl),a(Dl),a(B),a(ql),a(Zs),a(Ll),a(Gs),a(Kl),a(Pl),a(ks),a(Ol),a(sa),a(Xs),a(la),a(aa),a(ea),a(Ns),a(ta),a(na),a(Rs),a(pa),a(Ma),a(z),a(oa),a(Z),a(ia),a(Es),a(ca),a(zs)),a(i),w(T,s),w(F),w(k,s),w(D,s),w(L,s),w(P,s),w(ss,s),w(ls),w(es,s),w(ts),w(ps,s),w(W,s),w(os,s),w(rs,s),w(hs,s),w(ys,s),w(ws),w(Ts,s),w(ds,s),w(bs),w(fs,s),w(As,s),w(Bs),w(vs,s),w(_s,s),w(E,s),w(Ws,s),w(Vs,s),w($s,s),w(Ys)}}}const ke={local:"train-a-diffusion-model",sections:[{local:"training-configuration",title:"Training configuration"},{local:"load-the-dataset",title:"Load the dataset"},{local:"create-a-unet2dmodel",title:"Create a UNet2DModel"},{local:"create-a-scheduler",title:"Create a scheduler"},{local:"train-the-model",title:"Train the model"},{local:"next-steps",title:"Next steps"}],title:"Train a diffusion model"};function _e(G){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends Ie{constructor(i){super(),fe(this,i,_e,ve,be,{})}}export{Ye as component};
