import{s as Wt,o as Gt,n as tt}from"../chunks/scheduler.182ea377.js";import{S as Ct,i as Bt,g as c,s as n,r as u,A as It,h as f,f as l,c as o,j as jt,u as y,x as d,k as ce,y as kt,a as i,v as M,d as h,t as b,w}from"../chunks/index.abf12888.js";import{T as Vt}from"../chunks/Tip.230e2334.js";import{C as U}from"../chunks/CodeBlock.57fe6e13.js";import{D as xt}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as de}from"../chunks/Heading.16916d63.js";import{H as Rt,a as vt}from"../chunks/HfOption.fc88c804.js";function Xt(Z){let s,T="🔒 By loading a community pipeline from the Hugging Face Hub, you are trusting that the code you are loading is safe. Make sure to inspect the code online before loading and running it automatically!";return{c(){s=c("p"),s.textContent=T},l(r){s=f(r,"P",{"data-svelte-h":!0}),d(s)!=="svelte-154jbq5"&&(s.textContent=T)},m(r,m){i(r,s,m)},p:tt,d(r){r&&l(s)}}}function Ht(Z){let s,T="For example, to load from the <code>main</code> branch:",r,m,p;return m=new U({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIybWFpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;main&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=T,r=n(),u(m.$$.fragment)},l(a){s=f(a,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1kgdpxr"&&(s.innerHTML=T),r=o(a),y(m.$$.fragment,a)},m(a,J){i(a,s,J),i(a,r,J),M(m,a,J),p=!0},p:tt,i(a){p||(h(m.$$.fragment,a),p=!0)},o(a){b(m.$$.fragment,a),p=!1},d(a){a&&(l(s),l(r)),w(m,a)}}}function Et(Z){let s,T="For example, to load from a previous version of Diffusers like <code>v0.25.0</code>:",r,m,p;return m=new U({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJjbGlwX2d1aWRlZF9zdGFibGVfZGlmZnVzaW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3JldmlzaW9uJTNEJTIydjAuMjUuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    custom_revision=<span class="hljs-string">&quot;v0.25.0&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),{c(){s=c("p"),s.innerHTML=T,r=n(),u(m.$$.fragment)},l(a){s=f(a,"P",{"data-svelte-h":!0}),d(s)!=="svelte-15bkibl"&&(s.innerHTML=T),r=o(a),y(m.$$.fragment,a)},m(a,J){i(a,s,J),i(a,r,J),M(m,a,J),p=!0},p:tt,i(a){p||(h(m.$$.fragment,a),p=!0)},o(a){b(m.$$.fragment,a),p=!1},d(a){a&&(l(s),l(r)),w(m,a)}}}function Nt(Z){let s,T,r,m;return s=new vt({props:{id:"version",option:"main",$$slots:{default:[Ht]},$$scope:{ctx:Z}}}),r=new vt({props:{id:"version",option:"older version",$$slots:{default:[Et]},$$scope:{ctx:Z}}}),{c(){u(s.$$.fragment),T=n(),u(r.$$.fragment)},l(p){y(s.$$.fragment,p),T=o(p),y(r.$$.fragment,p)},m(p,a){M(s,p,a),i(p,T,a),M(r,p,a),m=!0},p(p,a){const J={};a&2&&(J.$$scope={dirty:a,ctx:p}),s.$set(J);const G={};a&2&&(G.$$scope={dirty:a,ctx:p}),r.$set(G)},i(p){m||(h(s.$$.fragment,p),h(r.$$.fragment,p),m=!0)},o(p){b(s.$$.fragment,p),b(r.$$.fragment,p),m=!1},d(p){p&&l(T),w(s,p),w(r,p)}}}function Qt(Z){let s,T='In steps 4 and 5, the custom <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">UNet</a> and <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">pipeline</a> implementation must match the format shown in their files for this example to work.';return{c(){s=c("p"),s.innerHTML=T},l(r){s=f(r,"P",{"data-svelte-h":!0}),d(s)!=="svelte-ptu9pr"&&(s.innerHTML=T)},m(r,m){i(r,s,m)},p:tt,d(r){r&&l(s)}}}function Ft(Z){let s,T,r,m,p,a,J,G,C,ue,B,lt='Community pipelines are any <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class that are different from the original implementation as specified in their paper (for example, the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> corresponds to the <a href="https://arxiv.org/abs/2302.05543" rel="nofollow">Text-to-Image Generation with ControlNet Conditioning</a> paper). They provide additional functionality or extend the original implementation of a pipeline.',ye,I,it='There are many cool community pipelines like <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#speech-to-image" rel="nofollow">Speech to Image</a> or <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#composable-stable-diffusion" rel="nofollow">Composable Stable Diffusion</a>, and you can find all the official community pipelines <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">here</a>.',Me,k,st='To load any community pipeline on the Hub, pass the repository id of the community pipeline to the <code>custom_pipeline</code> argument and the model repository where you’d like to load the pipeline weights and components from. For example, the example below loads a dummy pipeline from <a href="https://huggingface.co/hf-internal-testing/diffusers-dummy-pipeline/blob/main/pipeline.py" rel="nofollow"><code>hf-internal-testing/diffusers-dummy-pipeline</code></a> and the pipeline weights and components from <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a>:',he,_,be,x,we,R,nt='Loading an official community pipeline is similar, but you can mix loading weights from an official repository id and pass pipeline components directly. The example below loads the community <a href="https://github.com/huggingface/diffusers/tree/main/examples/community#clip-guided-stable-diffusion" rel="nofollow">CLIP Guided Stable Diffusion</a> pipeline, and you can pass the CLIP model components directly to it:',Te,X,Je,H,Ue,E,ot="Community pipelines can also be loaded from a local file if you pass a file path instead. The path to the passed directory must contain a <code>pipeline.py</code> file that contains the pipeline class in order to successfully load it.",Ze,N,_e,Q,$e,F,at="By default, community pipelines are loaded from the latest stable version of Diffusers. To load a community pipeline from another version, use the <code>custom_revision</code> parameter.",ge,$,je,z,pt='For more information about community pipelines, take a look at the <a href="custom_pipeline_examples">Community pipelines</a> guide for how to use them and if you’re interested in adding a community pipeline check out the <a href="contribute_pipeline">How to contribute a community pipeline</a> guide!',Ve,S,ve,L,rt="Community components allow users to build pipelines that may have customized components that are not a part of Diffusers. If your pipeline has custom components that Diffusers doesn’t already support, you need to provide their implementations as Python modules. These customized components could be a VAE, UNet, and scheduler. In most cases, the text encoder is imported from the Transformers library. The pipeline code itself can also be customized.",We,Y,mt="This section shows how users should use community components to build a community pipeline.",Ge,q,ct='You’ll use the <a href="https://huggingface.co/showlab/show-1-base" rel="nofollow">showlab/show-1-base</a> pipeline checkpoint as an example. So, let’s start loading the components:',Ce,P,ft="<li>Import and load the text encoder from Transformers:</li>",Be,D,Ie,g,dt="<li>Load a scheduler:</li>",ke,A,xe,j,ut="<li>Load an image processor:</li>",Re,O,Xe,V,He,v,yt='<li>Now you’ll load a <a href="https://github.com/showlab/Show-1/blob/main/showone/models/unet_3d_condition.py" rel="nofollow">custom UNet</a>, which in this example, has already been implemented in the <code>showone_unet_3d_condition.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">script</a> for your convenience. You’ll notice the <code>UNet3DConditionModel</code> class name is changed to <code>ShowOneUNet3DConditionModel</code> because <a href="/docs/diffusers/v0.27.1/en/api/models/unet3d-cond#diffusers.UNet3DConditionModel">UNet3DConditionModel</a> already exists in Diffusers. Any components needed for the <code>ShowOneUNet3DConditionModel</code> class should be placed in the <code>showone_unet_3d_condition.py</code> script.</li>',Ee,K,Mt="Once this is done, you can initialize the UNet:",Ne,ee,Qe,W,ht='<li>Finally, you’ll load the custom pipeline code. For this example, it has already been created for you in the <code>pipeline_t2v_base_pixel.py</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/pipeline_t2v_base_pixel.py" rel="nofollow">script</a>. This script contains a custom <code>TextToVideoIFPipeline</code> class for generating videos from text. Just like the custom UNet, any code needed for the custom pipeline to work should go in the <code>pipeline_t2v_base_pixel.py</code> script.</li>',Fe,te,bt="Once everything is in place, you can initialize the <code>TextToVideoIFPipeline</code> with the <code>ShowOneUNet3DConditionModel</code>:",ze,le,Se,ie,wt="Push the pipeline to the Hub to share with the community!",Le,se,Ye,ne,Tt="After the pipeline is successfully pushed, you need a couple of changes:",qe,oe,Jt='<li>Change the <code>_class_name</code> attribute in <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/model_index.json#L2" rel="nofollow"><code>model_index.json</code></a> to <code>&quot;pipeline_t2v_base_pixel&quot;</code> and <code>&quot;TextToVideoIFPipeline&quot;</code>.</li> <li>Upload <code>showone_unet_3d_condition.py</code> to the <code>unet</code> <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li> <li>Upload <code>pipeline_t2v_base_pixel.py</code> to the pipeline base <a href="https://huggingface.co/sayakpaul/show-1-base-with-code/blob/main/unet/showone_unet_3d_condition.py" rel="nofollow">directory</a>.</li>',Pe,ae,Ut="To run inference, simply add the <code>trust_remote_code</code> argument while initializing the pipeline to handle all the “magic” behind the scenes.",De,pe,Ae,re,Zt='As an additional reference example, you can refer to the repository structure of <a href="https://huggingface.co/stabilityai/japanese-stable-diffusion-xl/" rel="nofollow">stabilityai/japanese-stable-diffusion-xl</a>, that makes use of the <code>trust_remote_code</code> feature:',Oe,me,Ke,fe,et;return p=new de({props:{title:"Load community pipelines and components",local:"load-community-pipelines-and-components",headingTag:"h1"}}),J=new xt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/custom_pipeline_overview.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/custom_pipeline_overview.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/custom_pipeline_overview.ipynb"}]}}),C=new de({props:{title:"Community pipelines",local:"community-pipelines",headingTag:"h2"}}),_=new Vt({props:{warning:!0,$$slots:{default:[Xt]},$$scope:{ctx:Z}}}),x=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1kdW1teS1waXBlbGluZSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;hf-internal-testing/diffusers-dummy-pipeline&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),X=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),H=new de({props:{title:"Load from a local file",local:"load-from-a-local-file",headingTag:"h3"}}),N=new U({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjIuJTJGcGF0aCUyRnRvJTJGcGlwZWxpbmVfZGlyZWN0b3J5JTJGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9tb2RlbCUzRGNsaXBfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yJTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSk=",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;./path/to/pipeline_directory/&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    use_safetensors=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Q=new de({props:{title:"Load from a specific version",local:"load-from-a-specific-version",headingTag:"h3"}}),$=new Rt({props:{id:"version",options:["main","older version"],$$slots:{default:[Nt]},$$scope:{ctx:Z}}}),S=new de({props:{title:"Community components",local:"community-components",headingTag:"h2"}}),D=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFQ1VG9rZW5pemVyJTJDJTIwVDVFbmNvZGVyTW9kZWwlMEElMEFwaXBlX2lkJTIwJTNEJTIwJTIyc2hvd2xhYiUyRnNob3ctMS1iYXNlJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwVDVUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0b2tlbml6ZXIlMjIpJTBBdGV4dF9lbmNvZGVyJTIwJTNEJTIwVDVFbmNvZGVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKHBpcGVfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ0ZXh0X2VuY29kZXIlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> T5Tokenizer, T5EncoderModel

pipe_id = <span class="hljs-string">&quot;showlab/show-1-base&quot;</span>
tokenizer = T5Tokenizer.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;tokenizer&quot;</span>)
text_encoder = T5EncoderModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)`,wrap:!1}}),A=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

scheduler = DPMSolverMultistepScheduler.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)`,wrap:!1}}),O=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBGZWF0dXJlRXh0cmFjdG9yJTBBJTBBZmVhdHVyZV9leHRyYWN0b3IlMjAlM0QlMjBDTElQRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQocGlwZV9pZCUyQyUyMHN1YmZvbGRlciUzRCUyMmZlYXR1cmVfZXh0cmFjdG9yJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPFeatureExtractor

feature_extractor = CLIPFeatureExtractor.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;feature_extractor&quot;</span>)`,wrap:!1}}),V=new Vt({props:{warning:!0,$$slots:{default:[Qt]},$$scope:{ctx:Z}}}),ee=new U({props:{code:"ZnJvbSUyMHNob3dvbmVfdW5ldF8zZF9jb25kaXRpb24lMjBpbXBvcnQlMjBTaG93T25lVU5ldDNEQ29uZGl0aW9uTW9kZWwlMEElMEF1bmV0JTIwJTNEJTIwU2hvd09uZVVOZXQzRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZChwaXBlX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMik=",highlighted:`<span class="hljs-keyword">from</span> showone_unet_3d_condition <span class="hljs-keyword">import</span> ShowOneUNet3DConditionModel

unet = ShowOneUNet3DConditionModel.from_pretrained(pipe_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),le=new U({props:{code:"ZnJvbSUyMHBpcGVsaW5lX3Qydl9iYXNlX3BpeGVsJTIwaW1wb3J0JTIwVGV4dFRvVmlkZW9JRlBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFRleHRUb1ZpZGVvSUZQaXBlbGluZSglMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRHRleHRfZW5jb2RlciUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEZmVhdHVyZV9leHRyYWN0b3IlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byhkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnRvcmNoX2R0eXBlJTIwJTNEJTIwdG9yY2guZmxvYXQxNg==",highlighted:`<span class="hljs-keyword">from</span> pipeline_t2v_base_pixel <span class="hljs-keyword">import</span> TextToVideoIFPipeline
<span class="hljs-keyword">import</span> torch

pipeline = TextToVideoIFPipeline(
    unet=unet,
    text_encoder=text_encoder,
    tokenizer=tokenizer,
    scheduler=scheduler,
    feature_extractor=feature_extractor
)
pipeline = pipeline.to(device=<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.torch_dtype = torch.float16`,wrap:!1}}),se=new U({props:{code:"cGlwZWxpbmUucHVzaF90b19odWIoJTIyY3VzdG9tLXQydi1waXBlbGluZSUyMik=",highlighted:'pipeline.push_to_hub(<span class="hljs-string">&quot;custom-t2v-pipeline&quot;</span>)',wrap:!1}}),pe=new U({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIlM0NjaGFuZ2UtdXNlcm5hbWUlM0UlMkYlM0NjaGFuZ2UtaWQlM0UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyaGVsbG8lMjIlMEElMEElMjMlMjBUZXh0JTIwZW1iZWRzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMG5lZ2F0aXZlX2VtYmVkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQocHJvbXB0KSUwQSUwQSUyMyUyMEtleWZyYW1lcyUyMGdlbmVyYXRpb24lMjAoOHg2NHg0MCUyQyUyMDJmcHMpJTBBdmlkZW9fZnJhbWVzJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEbmVnYXRpdmVfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDglMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q0MCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENjQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEOS4wJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0X3R5cGUlM0QlMjJwdCUyMiUwQSkuZnJhbWVz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;&lt;change-username&gt;/&lt;change-id&gt;&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;hello&quot;</span>

<span class="hljs-comment"># Text embeds</span>
prompt_embeds, negative_embeds = pipeline.encode_prompt(prompt)

<span class="hljs-comment"># Keyframes generation (8x64x40, 2fps)</span>
video_frames = pipeline(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=negative_embeds,
    num_frames=<span class="hljs-number">8</span>,
    height=<span class="hljs-number">40</span>,
    width=<span class="hljs-number">64</span>,
    num_inference_steps=<span class="hljs-number">2</span>,
    guidance_scale=<span class="hljs-number">9.0</span>,
    output_type=<span class="hljs-string">&quot;pt&quot;</span>
).frames`,wrap:!1}}),me=new U({props:{code:"JTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRmphcGFuZXNlLXN0YWJsZS1kaWZmdXNpb24teGwlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUlMEEpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBpZiUyMHVzaW5nJTIwdG9yY2glMjAlM0MlMjAyLjAlMEElMjMlMjBwaXBlbGluZS5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiVFNiU5RiVCNCVFNyU4QSVBQyVFMyU4MCU4MSVFMyU4MiVBQiVFMyU4MyVBOSVFMyU4MyU5NSVFMyU4MyVBQiVFMyU4MiVBMiVFMyU4MyVCQyVFMyU4MyU4OCUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBB",highlighted:`
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/japanese-stable-diffusion-xl&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>
)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># if using torch &lt; 2.0</span>
<span class="hljs-comment"># pipeline.enable_xformers_memory_efficient_attention()</span>

prompt = <span class="hljs-string">&quot;柴犬、カラフルアート&quot;</span>

image = pipeline(prompt=prompt).images[<span class="hljs-number">0</span>]
`,wrap:!1}}),{c(){s=c("meta"),T=n(),r=c("p"),m=n(),u(p.$$.fragment),a=n(),u(J.$$.fragment),G=n(),u(C.$$.fragment),ue=n(),B=c("p"),B.innerHTML=lt,ye=n(),I=c("p"),I.innerHTML=it,Me=n(),k=c("p"),k.innerHTML=st,he=n(),u(_.$$.fragment),be=n(),u(x.$$.fragment),we=n(),R=c("p"),R.innerHTML=nt,Te=n(),u(X.$$.fragment),Je=n(),u(H.$$.fragment),Ue=n(),E=c("p"),E.innerHTML=ot,Ze=n(),u(N.$$.fragment),_e=n(),u(Q.$$.fragment),$e=n(),F=c("p"),F.innerHTML=at,ge=n(),u($.$$.fragment),je=n(),z=c("p"),z.innerHTML=pt,Ve=n(),u(S.$$.fragment),ve=n(),L=c("p"),L.textContent=rt,We=n(),Y=c("p"),Y.textContent=mt,Ge=n(),q=c("p"),q.innerHTML=ct,Ce=n(),P=c("ol"),P.innerHTML=ft,Be=n(),u(D.$$.fragment),Ie=n(),g=c("ol"),g.innerHTML=dt,ke=n(),u(A.$$.fragment),xe=n(),j=c("ol"),j.innerHTML=ut,Re=n(),u(O.$$.fragment),Xe=n(),u(V.$$.fragment),He=n(),v=c("ol"),v.innerHTML=yt,Ee=n(),K=c("p"),K.textContent=Mt,Ne=n(),u(ee.$$.fragment),Qe=n(),W=c("ol"),W.innerHTML=ht,Fe=n(),te=c("p"),te.innerHTML=bt,ze=n(),u(le.$$.fragment),Se=n(),ie=c("p"),ie.textContent=wt,Le=n(),u(se.$$.fragment),Ye=n(),ne=c("p"),ne.textContent=Tt,qe=n(),oe=c("ol"),oe.innerHTML=Jt,Pe=n(),ae=c("p"),ae.innerHTML=Ut,De=n(),u(pe.$$.fragment),Ae=n(),re=c("p"),re.innerHTML=Zt,Oe=n(),u(me.$$.fragment),Ke=n(),fe=c("p"),this.h()},l(e){const t=It("svelte-u9bgzb",document.head);s=f(t,"META",{name:!0,content:!0}),t.forEach(l),T=o(e),r=f(e,"P",{}),jt(r).forEach(l),m=o(e),y(p.$$.fragment,e),a=o(e),y(J.$$.fragment,e),G=o(e),y(C.$$.fragment,e),ue=o(e),B=f(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-1kmr1vf"&&(B.innerHTML=lt),ye=o(e),I=f(e,"P",{"data-svelte-h":!0}),d(I)!=="svelte-10en0rk"&&(I.innerHTML=it),Me=o(e),k=f(e,"P",{"data-svelte-h":!0}),d(k)!=="svelte-1mmnk2f"&&(k.innerHTML=st),he=o(e),y(_.$$.fragment,e),be=o(e),y(x.$$.fragment,e),we=o(e),R=f(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1yyre8w"&&(R.innerHTML=nt),Te=o(e),y(X.$$.fragment,e),Je=o(e),y(H.$$.fragment,e),Ue=o(e),E=f(e,"P",{"data-svelte-h":!0}),d(E)!=="svelte-1e8nso6"&&(E.innerHTML=ot),Ze=o(e),y(N.$$.fragment,e),_e=o(e),y(Q.$$.fragment,e),$e=o(e),F=f(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-17rlizh"&&(F.innerHTML=at),ge=o(e),y($.$$.fragment,e),je=o(e),z=f(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-1ho2g1z"&&(z.innerHTML=pt),Ve=o(e),y(S.$$.fragment,e),ve=o(e),L=f(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1vh7uou"&&(L.textContent=rt),We=o(e),Y=f(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-phpvnj"&&(Y.textContent=mt),Ge=o(e),q=f(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-7sknw0"&&(q.innerHTML=ct),Ce=o(e),P=f(e,"OL",{"data-svelte-h":!0}),d(P)!=="svelte-8ccbl9"&&(P.innerHTML=ft),Be=o(e),y(D.$$.fragment,e),Ie=o(e),g=f(e,"OL",{start:!0,"data-svelte-h":!0}),d(g)!=="svelte-1rtkhjg"&&(g.innerHTML=dt),ke=o(e),y(A.$$.fragment,e),xe=o(e),j=f(e,"OL",{start:!0,"data-svelte-h":!0}),d(j)!=="svelte-o9t4x9"&&(j.innerHTML=ut),Re=o(e),y(O.$$.fragment,e),Xe=o(e),y(V.$$.fragment,e),He=o(e),v=f(e,"OL",{start:!0,"data-svelte-h":!0}),d(v)!=="svelte-dqlcer"&&(v.innerHTML=yt),Ee=o(e),K=f(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-4yol19"&&(K.textContent=Mt),Ne=o(e),y(ee.$$.fragment,e),Qe=o(e),W=f(e,"OL",{start:!0,"data-svelte-h":!0}),d(W)!=="svelte-1m9qhhm"&&(W.innerHTML=ht),Fe=o(e),te=f(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1jpprmd"&&(te.innerHTML=bt),ze=o(e),y(le.$$.fragment,e),Se=o(e),ie=f(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-14lz5yb"&&(ie.textContent=wt),Le=o(e),y(se.$$.fragment,e),Ye=o(e),ne=f(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-azdq2p"&&(ne.textContent=Tt),qe=o(e),oe=f(e,"OL",{"data-svelte-h":!0}),d(oe)!=="svelte-7wsjmh"&&(oe.innerHTML=Jt),Pe=o(e),ae=f(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-xpz58c"&&(ae.innerHTML=Ut),De=o(e),y(pe.$$.fragment,e),Ae=o(e),re=f(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1cmjoh5"&&(re.innerHTML=Zt),Oe=o(e),y(me.$$.fragment,e),Ke=o(e),fe=f(e,"P",{}),jt(fe).forEach(l),this.h()},h(){ce(s,"name","hf:doc:metadata"),ce(s,"content",zt),ce(g,"start","2"),ce(j,"start","3"),ce(v,"start","4"),ce(W,"start","5")},m(e,t){kt(document.head,s),i(e,T,t),i(e,r,t),i(e,m,t),M(p,e,t),i(e,a,t),M(J,e,t),i(e,G,t),M(C,e,t),i(e,ue,t),i(e,B,t),i(e,ye,t),i(e,I,t),i(e,Me,t),i(e,k,t),i(e,he,t),M(_,e,t),i(e,be,t),M(x,e,t),i(e,we,t),i(e,R,t),i(e,Te,t),M(X,e,t),i(e,Je,t),M(H,e,t),i(e,Ue,t),i(e,E,t),i(e,Ze,t),M(N,e,t),i(e,_e,t),M(Q,e,t),i(e,$e,t),i(e,F,t),i(e,ge,t),M($,e,t),i(e,je,t),i(e,z,t),i(e,Ve,t),M(S,e,t),i(e,ve,t),i(e,L,t),i(e,We,t),i(e,Y,t),i(e,Ge,t),i(e,q,t),i(e,Ce,t),i(e,P,t),i(e,Be,t),M(D,e,t),i(e,Ie,t),i(e,g,t),i(e,ke,t),M(A,e,t),i(e,xe,t),i(e,j,t),i(e,Re,t),M(O,e,t),i(e,Xe,t),M(V,e,t),i(e,He,t),i(e,v,t),i(e,Ee,t),i(e,K,t),i(e,Ne,t),M(ee,e,t),i(e,Qe,t),i(e,W,t),i(e,Fe,t),i(e,te,t),i(e,ze,t),M(le,e,t),i(e,Se,t),i(e,ie,t),i(e,Le,t),M(se,e,t),i(e,Ye,t),i(e,ne,t),i(e,qe,t),i(e,oe,t),i(e,Pe,t),i(e,ae,t),i(e,De,t),M(pe,e,t),i(e,Ae,t),i(e,re,t),i(e,Oe,t),M(me,e,t),i(e,Ke,t),i(e,fe,t),et=!0},p(e,[t]){const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),_.$set(_t);const $t={};t&2&&($t.$$scope={dirty:t,ctx:e}),$.$set($t);const gt={};t&2&&(gt.$$scope={dirty:t,ctx:e}),V.$set(gt)},i(e){et||(h(p.$$.fragment,e),h(J.$$.fragment,e),h(C.$$.fragment,e),h(_.$$.fragment,e),h(x.$$.fragment,e),h(X.$$.fragment,e),h(H.$$.fragment,e),h(N.$$.fragment,e),h(Q.$$.fragment,e),h($.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(A.$$.fragment,e),h(O.$$.fragment,e),h(V.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),et=!0)},o(e){b(p.$$.fragment,e),b(J.$$.fragment,e),b(C.$$.fragment,e),b(_.$$.fragment,e),b(x.$$.fragment,e),b(X.$$.fragment,e),b(H.$$.fragment,e),b(N.$$.fragment,e),b(Q.$$.fragment,e),b($.$$.fragment,e),b(S.$$.fragment,e),b(D.$$.fragment,e),b(A.$$.fragment,e),b(O.$$.fragment,e),b(V.$$.fragment,e),b(ee.$$.fragment,e),b(le.$$.fragment,e),b(se.$$.fragment,e),b(pe.$$.fragment,e),b(me.$$.fragment,e),et=!1},d(e){e&&(l(T),l(r),l(m),l(a),l(G),l(ue),l(B),l(ye),l(I),l(Me),l(k),l(he),l(be),l(we),l(R),l(Te),l(Je),l(Ue),l(E),l(Ze),l(_e),l($e),l(F),l(ge),l(je),l(z),l(Ve),l(ve),l(L),l(We),l(Y),l(Ge),l(q),l(Ce),l(P),l(Be),l(Ie),l(g),l(ke),l(xe),l(j),l(Re),l(Xe),l(He),l(v),l(Ee),l(K),l(Ne),l(Qe),l(W),l(Fe),l(te),l(ze),l(Se),l(ie),l(Le),l(Ye),l(ne),l(qe),l(oe),l(Pe),l(ae),l(De),l(Ae),l(re),l(Oe),l(Ke),l(fe)),l(s),w(p,e),w(J,e),w(C,e),w(_,e),w(x,e),w(X,e),w(H,e),w(N,e),w(Q,e),w($,e),w(S,e),w(D,e),w(A,e),w(O,e),w(V,e),w(ee,e),w(le,e),w(se,e),w(pe,e),w(me,e)}}}const zt='{"title":"Load community pipelines and components","local":"load-community-pipelines-and-components","sections":[{"title":"Community pipelines","local":"community-pipelines","sections":[{"title":"Load from a local file","local":"load-from-a-local-file","sections":[],"depth":3},{"title":"Load from a specific version","local":"load-from-a-specific-version","sections":[],"depth":3}],"depth":2},{"title":"Community components","local":"community-components","sections":[],"depth":2}],"depth":1}';function St(Z){return Gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Ct{constructor(s){super(),Bt(this,s,St,Ft,Wt,{})}}export{Kt as component};
