import{s as gt,n as Jt,o as Ut}from"../chunks/scheduler.85c25b89.js";import{S as bt,i as jt,g as i,s as a,r as p,A as Ct,h as o,f as l,c as s,j as ft,u as d,x as r,k as Tt,y as It,a as n,v as c,d as m,t as h,w as u}from"../chunks/index.c9837788.js";import{C as ee}from"../chunks/CodeBlock.52fa569e.js";import{H as ne,E as _t}from"../chunks/EditOnGithub.b65eee75.js";function vt(Ne){let w,ae,te,se,M,ie,y,Se='We’ve begun rolling out examples to use Meta’s LLaMA models in <code>trl</code> (see <a href="https://ai.facebook.com/blog/large-language-model-llama-meta-ai/" rel="nofollow">Meta’s LLaMA release</a> for the original LLaMA model).',oe,f,re,T,Ee='Even training the smallest LLaMA model requires an enormous amount of memory. Some quick math: in bf16, every parameter uses 2 bytes (in fp32 4 bytes) in addition to 8 bytes used, e.g., in the Adam optimizer (see the <a href="https://huggingface.co/docs/transformers/perf_train_gpu_one#optimizer" rel="nofollow">performance docs</a> in Transformers for more info). So a 7B parameter model would use <code>(2+8)*7B=70GB</code> just to fit in memory and would likely need more when you compute intermediate values such as attention scores. So you couldn’t train the model even on a single 80GB A100 like that. You can use some tricks, like more efficient optimizers of half-precision training, to squeeze a bit more into memory, but you’ll run out sooner or later.',pe,g,Ye=`Another option is to use Parameter-Efficient Fine-Tuning (PEFT) techniques, such as the <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library, which can perform low-rank adaptation (LoRA) on a model loaded in 8-bit.
For more on <code>peft</code> + <code>trl</code>, see the <a href="https://huggingface.co/docs/trl/sentiment_tuning_peft" rel="nofollow">docs</a>.`,de,J,qe=`Loading the model in 8bit reduces the memory footprint drastically since you only need one byte per parameter for the weights (e.g. 7B LlaMa is 7GB in memory).
Instead of training the original weights directly, LoRA adds small adapter layers on top of some specific layers (usually the attention layers); thus, the number of trainable parameters is drastically reduced.`,ce,U,Pe=`In this scenario, a rule of thumb is to allocate ~1.2-1.4GB per billion parameters (depending on the batch size and sequence length) to fit the entire fine-tuning setup.
This enables fine-tuning larger models (up to 50-60B scale models on a NVIDIA A100 80GB) at low cost.`,me,b,Ke=`Now we can fit very large models into a single GPU, but the training might still be very slow.
The simplest strategy in this scenario is data parallelism: we replicate the same training setup into separate GPUs and pass different batches to each GPU.
With this, you can parallelize the forward/backward passes of the model and scale with the number of GPUs.`,he,j,De='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/blog/stackllama/chapter10_ddp.png" alt="chapter10_ddp.png"/>',ue,C,Oe="We use either the <code>transformers.Trainer</code> or <code>accelerate</code>, which both support data parallelism without any code changes, by simply passing arguments when calling the scripts with <code>torchrun</code> or <code>accelerate launch</code>. The following runs a training script with 8 GPUs on a single machine with <code>accelerate</code> and <code>torchrun</code>, respectively.",we,I,Me,_,ye,v,et=`Before we start training reward models and tuning our model with RL, it helps if the model is already good in the domain we are interested in.
In our case, we want it to answer questions, while for other use cases, we might want it to follow instructions, in which case instruction tuning is a great idea.
The easiest way to achieve this is by continuing to train the language model with the language modeling objective on texts from the domain or task.
The <a href="https://huggingface.co/datasets/HuggingFaceH4/stack-exchange-preferences" rel="nofollow">StackExchange dataset</a> is enormous (over 10 million instructions), so we can easily train the language model on a subset of it.`,fe,k,tt=`There is nothing special about fine-tuning the model before doing RLHF - it’s just the causal language modeling objective from pretraining that we apply here.
To use the data efficiently, we use a technique called packing: instead of having one text per sample in the batch and then padding to either the longest text or the maximal context of the model, we concatenate a lot of texts with a EOS token in between and cut chunks of the context size to fill the batch without any padding.`,Te,R,lt='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/blog/stackllama/chapter10_preprocessing-clm.png" alt="chapter10_preprocessing-clm.png"/>',ge,B,nt=`With this approach the training is much more efficient as each token that is passed through the model is also trained in contrast to padding tokens which are usually masked from the loss.
If you don’t have much data and are more concerned about occasionally cutting off some tokens that are overflowing the context you can also use a classical data loader.`,Je,x,at="The packing is handled by the <code>ConstantLengthDataset</code> and we can then use the <code>Trainer</code> after loading the model with <code>peft</code>. First, we load the model in int8, prepare it for training, and then add the LoRA adapters.",Ue,H,be,$,st=`We train the model for a few thousand steps with the causal language modeling objective and save the model.
Since we will tune the model again with different objectives, we merge the adapter weights with the original model weights.`,je,A,it=`<strong>Disclaimer:</strong> due to LLaMA’s license, we release only the adapter weights for this and the model checkpoints in the following sections.
You can apply for access to the base model’s weights by filling out Meta AI’s <a href="https://docs.google.com/forms/d/e/1FAIpQLSfqNECQnMkycAp2jP4Z9TFX0cGR4uf7b_fBxjY_OjhJILlKGA/viewform" rel="nofollow">form</a> and then converting them to the 🤗 Transformers format by running this <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama/convert_llama_weights_to_hf.py" rel="nofollow">script</a>.
Note that you’ll also need to install 🤗 Transformers from source until the <code>v4.28</code> is released.`,Ce,G,ot="Now that we have fine-tuned the model for the task, we are ready to train a reward model.",Ie,L,_e,Z,rt=`In principle, we could fine-tune the model using RLHF directly with the human annotations.
However, this would require us to send some samples to humans for rating after each optimization iteration.
This is expensive and slow due to the number of training samples needed for convergence and the inherent latency of human reading and annotator speed.`,ve,V,pt=`A trick that works well instead of direct feedback is training a reward model on human annotations collected before the RL loop.
The goal of the reward model is to imitate how a human would rate a text. There are several possible strategies to build a reward model: the most straightforward way would be to predict the annotation (e.g. a rating score or a binary value for “good”/”bad”).
In practice, what works better is to predict the ranking of two examples, where the reward model is presented with two candidates <code>(y_k, y_j)</code> for a given prompt <code>x</code> and has to predict which one would be rated higher by a human annotator.`,ke,X,dt=`With the StackExchange dataset, we can infer which of the two answers was preferred by the users based on the score.
With that information and the loss defined above, we can then modify the <code>transformers.Trainer</code> by adding a custom loss function.`,Re,z,Be,W,ct="We utilize a subset of a 100,000 pair of candidates and evaluate on a held-out set of 50,000. With a modest training batch size of 4, we train the Llama model using the LoRA <code>peft</code> adapter for a single epoch using the Adam optimizer with BF16 precision. Our LoRA configuration is:",xe,Q,He,F,mt="As detailed in the next section, the resulting adapter can be merged into the frozen model and saved for further downstream use.",$e,N,Ae,S,ht="With the fine-tuned language model and the reward model at hand, we are now ready to run the RL loop. It follows roughly three steps:",Ge,E,ut="<li>Generate responses from prompts,</li> <li>Rate the responses with the reward model,</li> <li>Run a reinforcement learning policy-optimization step with the ratings.</li>",Le,Y,wt="The Query and Response prompts are templated as follows before being tokenized and passed to the model:",Ze,q,Ve,P,Mt=`The same template was used for SFT, RM and RLHF stages.
Once more, we utilize <code>peft</code> for memory-efficient training, which offers an extra advantage in the RLHF context.
Here, the reference model and policy share the same base, the SFT model, which we load in 8-bit and freeze during training.
We exclusively optimize the policy’s LoRA weights using PPO while sharing the base model’s weights.`,Xe,K,ze,D,yt='For the rest of the details and evaluation, please refer to our <a href="https://huggingface.co/blog/stackllama" rel="nofollow">blog post on StackLLaMA</a>.',We,O,Qe,le,Fe;return M=new ne({props:{title:"Using LLaMA models with TRL",local:"using-llama-models-with-trl",headingTag:"h1"}}),f=new ne({props:{title:"Efficient training strategies",local:"efficient-training-strategies",headingTag:"h2"}}),I=new ee({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbXVsdGlfZ3B1JTIwLS1udW1fbWFjaGluZXMlMjAxJTIwJTIwLS1udW1fcHJvY2Vzc2VzJTIwOCUyMG15X2FjY2VsZXJhdGVfc2NyaXB0LnB5JTBBdG9yY2hydW4lMjAtLW5ub2RlcyUyMDElMjAlMjAtLW5wcm9jX3Blcl9ub2RlJTIwOCUyMG15X3RvcmNoX3NjcmlwdC5weQ==",highlighted:`accelerate launch --multi_gpu --num_machines 1  --num_processes 8 my_accelerate_script.py
torchrun --nnodes 1  --nproc_per_node 8 my_torch_script.py`,wrap:!1}}),_=new ne({props:{title:"Supervised fine-tuning",local:"supervised-fine-tuning",headingTag:"h2"}}),H=new ee({props:{code:"JTIzJTIwbG9hZCUyMG1vZGVsJTIwaW4lMjA4Yml0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncy5tb2RlbF9wYXRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlN0IlMjIlMjIlM0ElMjBBY2NlbGVyYXRvcigpLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMEElMjAlMjAlMjAlMjApJTBBbW9kZWwlMjAlM0QlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nKG1vZGVsKSUwQSUwQSUyMyUyMGFkZCUyMExvUkElMjB0byUyMG1vZGVsJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHIlM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMkMlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwY29uZmlnKQ==",highlighted:`<span class="hljs-comment"># load model in 8bit</span>
model = AutoModelForCausalLM.from_pretrained(
        args.model_path,
        load_in_8bit=<span class="hljs-literal">True</span>,
        device_map={<span class="hljs-string">&quot;&quot;</span>: Accelerator().local_process_index}
    )
model = prepare_model_for_kbit_training(model)

<span class="hljs-comment"># add LoRA to model</span>
lora_config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.05</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>,
)

model = get_peft_model(model, config)`,wrap:!1}}),L=new ne({props:{title:"Reward modeling and human preferences",local:"reward-modeling-and-human-preferences",headingTag:"h2"}}),z=new ee({props:{code:"Y2xhc3MlMjBSZXdhcmRUcmFpbmVyKFRyYWluZXIpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwY29tcHV0ZV9sb3NzKHNlbGYlMkMlMjBtb2RlbCUyQyUyMGlucHV0cyUyQyUyMHJldHVybl9vdXRwdXRzJTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV3YXJkc19qJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzX2olMjIlNUQlMkMlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrX2olMjIlNUQpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJld2FyZHNfayUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0cyU1QiUyMmlucHV0X2lkc19rJTIyJTVEJTJDJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFza19rJTIyJTVEKSU1QjAlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwLW5uLmZ1bmN0aW9uYWwubG9nc2lnbW9pZChyZXdhcmRzX2olMjAtJTIwcmV3YXJkc19rKS5tZWFuKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHJldHVybl9vdXRwdXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zcyUyQyUyMCU3QiUyMnJld2FyZHNfaiUyMiUzQSUyMHJld2FyZHNfaiUyQyUyMCUyMnJld2FyZHNfayUyMiUzQSUyMHJld2FyZHNfayU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGxvc3M=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">RewardTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        rewards_j = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids_j&quot;</span>],  attention_mask=inputs[<span class="hljs-string">&quot;attention_mask_j&quot;</span>])[<span class="hljs-number">0</span>]
        rewards_k = model(input_ids=inputs[<span class="hljs-string">&quot;input_ids_k&quot;</span>], attention_mask=inputs[<span class="hljs-string">&quot;attention_mask_k&quot;</span>])[<span class="hljs-number">0</span>]
        loss = -nn.functional.logsigmoid(rewards_j - rewards_k).mean()
        <span class="hljs-keyword">if</span> return_outputs:
            <span class="hljs-keyword">return</span> loss, {<span class="hljs-string">&quot;rewards_j&quot;</span>: rewards_j, <span class="hljs-string">&quot;rewards_k&quot;</span>: rewards_k}
        <span class="hljs-keyword">return</span> loss`,wrap:!1}}),Q=new ee({props:{code:"cGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLlNFUV9DTFMlMkMlMEElMjAlMjAlMjAlMjBpbmZlcmVuY2VfbW9kZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwciUzRDglMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEMzIlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2Ryb3BvdXQlM0QwLjElMkMlMEEp",highlighted:`peft_config = LoraConfig(
    task_type=TaskType.SEQ_CLS,
    inference_mode=<span class="hljs-literal">False</span>,
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
)`,wrap:!1}}),N=new ne({props:{title:"Reinforcement Learning from Human Feedback",local:"reinforcement-learning-from-human-feedback",headingTag:"h2"}}),q=new ee({props:{code:"UXVlc3Rpb24lM0ElMjAlM0NRdWVyeSUzRSUwQSUwQUFuc3dlciUzQSUyMCUzQ1Jlc3BvbnNlJTNF",highlighted:`Question: &lt;Query&gt;

Answer: &lt;Response&gt;`,wrap:!1}}),K=new ee({props:{code:"Zm9yJTIwZXBvY2glMkMlMjBiYXRjaCUyMGluJTIwdHFkbShlbnVtZXJhdGUocHBvX3RyYWluZXIuZGF0YWxvYWRlcikpJTNBJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb25fdGVuc29ycyUyMCUzRCUyMGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTBBJTBBJTA5JTIzJTIwc2FtcGxlJTIwZnJvbSUyMHRoZSUyMHBvbGljeSUyMGFuZCUyMHRvJTIwZ2VuZXJhdGUlMjByZXNwb25zZXMlMEElMjAlMjAlMjAlMjByZXNwb25zZV90ZW5zb3JzJTIwJTNEJTIwcHBvX3RyYWluZXIuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlc3Rpb25fdGVuc29ycyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybl9wcm9tcHQlM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxlbmd0aF9zYW1wbGVyJTNEb3V0cHV0X2xlbmd0aF9zYW1wbGVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKipnZW5lcmF0aW9uX2t3YXJncyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBiYXRjaCU1QiUyMnJlc3BvbnNlJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShyZXNwb25zZV90ZW5zb3JzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQ29tcHV0ZSUyMHNlbnRpbWVudCUyMHNjb3JlJTBBJTIwJTIwJTIwJTIwdGV4dHMlMjAlM0QlMjAlNUJxJTIwJTJCJTIwciUyMGZvciUyMHElMkMlMjByJTIwaW4lMjB6aXAoYmF0Y2glNUIlMjJxdWVyeSUyMiU1RCUyQyUyMGJhdGNoJTVCJTIycmVzcG9uc2UlMjIlNUQpJTVEJTBBJTIwJTIwJTIwJTIwcGlwZV9vdXRwdXRzJTIwJTNEJTIwc2VudGltZW50X3BpcGUodGV4dHMlMkMlMjAqKnNlbnRfa3dhcmdzKSUwQSUyMCUyMCUyMCUyMHJld2FyZHMlMjAlM0QlMjAlNUJ0b3JjaC50ZW5zb3Iob3V0cHV0JTVCMCU1RCU1QiUyMnNjb3JlJTIyJTVEJTIwLSUyMHNjcmlwdF9hcmdzLnJld2FyZF9iYXNlbGluZSklMjBmb3IlMjBvdXRwdXQlMjBpbiUyMHBpcGVfb3V0cHV0cyU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFJ1biUyMFBQTyUyMHN0ZXAlMEElMjAlMjAlMjAlMjBzdGF0cyUyMCUzRCUyMHBwb190cmFpbmVyLnN0ZXAocXVlc3Rpb25fdGVuc29ycyUyQyUyMHJlc3BvbnNlX3RlbnNvcnMlMkMlMjByZXdhcmRzKSUwQSUwOSUyMyUyMExvZyUyMHN0YXRzJTIwdG8lMjBXYW5kYiUwQSUyMCUyMCUyMCUyMHBwb190cmFpbmVyLmxvZ19zdGF0cyhzdGF0cyUyQyUyMGJhdGNoJTJDJTIwcmV3YXJkcyk=",highlighted:`<span class="hljs-keyword">for</span> epoch, batch <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(ppo_trainer.dataloader)):
    question_tensors = batch[<span class="hljs-string">&quot;input_ids&quot;</span>]

	<span class="hljs-comment"># sample from the policy and to generate responses</span>
    response_tensors = ppo_trainer.generate(
        question_tensors,
        return_prompt=<span class="hljs-literal">False</span>,
        length_sampler=output_length_sampler,
        **generation_kwargs,
    )
    batch[<span class="hljs-string">&quot;response&quot;</span>] = tokenizer.batch_decode(response_tensors, skip_special_tokens=<span class="hljs-literal">True</span>)

    <span class="hljs-comment"># Compute sentiment score</span>
    texts = [q + r <span class="hljs-keyword">for</span> q, r <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(batch[<span class="hljs-string">&quot;query&quot;</span>], batch[<span class="hljs-string">&quot;response&quot;</span>])]
    pipe_outputs = sentiment_pipe(texts, **sent_kwargs)
    rewards = [torch.tensor(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;score&quot;</span>] - script_args.reward_baseline) <span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> pipe_outputs]

    <span class="hljs-comment"># Run PPO step</span>
    stats = ppo_trainer.step(question_tensors, response_tensors, rewards)
	<span class="hljs-comment"># Log stats to Wandb</span>
    ppo_trainer.log_stats(stats, batch, rewards)`,wrap:!1}}),O=new _t({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/using_llama_models.mdx"}}),{c(){w=i("meta"),ae=a(),te=i("p"),se=a(),p(M.$$.fragment),ie=a(),y=i("p"),y.innerHTML=Se,oe=a(),p(f.$$.fragment),re=a(),T=i("p"),T.innerHTML=Ee,pe=a(),g=i("p"),g.innerHTML=Ye,de=a(),J=i("p"),J.textContent=qe,ce=a(),U=i("p"),U.textContent=Pe,me=a(),b=i("p"),b.textContent=Ke,he=a(),j=i("p"),j.innerHTML=De,ue=a(),C=i("p"),C.innerHTML=Oe,we=a(),p(I.$$.fragment),Me=a(),p(_.$$.fragment),ye=a(),v=i("p"),v.innerHTML=et,fe=a(),k=i("p"),k.textContent=tt,Te=a(),R=i("p"),R.innerHTML=lt,ge=a(),B=i("p"),B.textContent=nt,Je=a(),x=i("p"),x.innerHTML=at,Ue=a(),p(H.$$.fragment),be=a(),$=i("p"),$.textContent=st,je=a(),A=i("p"),A.innerHTML=it,Ce=a(),G=i("p"),G.textContent=ot,Ie=a(),p(L.$$.fragment),_e=a(),Z=i("p"),Z.textContent=rt,ve=a(),V=i("p"),V.innerHTML=pt,ke=a(),X=i("p"),X.innerHTML=dt,Re=a(),p(z.$$.fragment),Be=a(),W=i("p"),W.innerHTML=ct,xe=a(),p(Q.$$.fragment),He=a(),F=i("p"),F.textContent=mt,$e=a(),p(N.$$.fragment),Ae=a(),S=i("p"),S.textContent=ht,Ge=a(),E=i("ol"),E.innerHTML=ut,Le=a(),Y=i("p"),Y.textContent=wt,Ze=a(),p(q.$$.fragment),Ve=a(),P=i("p"),P.innerHTML=Mt,Xe=a(),p(K.$$.fragment),ze=a(),D=i("p"),D.innerHTML=yt,We=a(),p(O.$$.fragment),Qe=a(),le=i("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(l),ae=s(e),te=o(e,"P",{}),ft(te).forEach(l),se=s(e),d(M.$$.fragment,e),ie=s(e),y=o(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-e13aq4"&&(y.innerHTML=Se),oe=s(e),d(f.$$.fragment,e),re=s(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-16n3a3d"&&(T.innerHTML=Ee),pe=s(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-15jce6t"&&(g.innerHTML=Ye),de=s(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-13fiyhv"&&(J.textContent=qe),ce=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14acoww"&&(U.textContent=Pe),me=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-4ezqnt"&&(b.textContent=Ke),he=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-n90oj8"&&(j.innerHTML=De),ue=s(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-iudduc"&&(C.innerHTML=Oe),we=s(e),d(I.$$.fragment,e),Me=s(e),d(_.$$.fragment,e),ye=s(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-lj6rat"&&(v.innerHTML=et),fe=s(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-qefjfd"&&(k.textContent=tt),Te=s(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-gam3e8"&&(R.innerHTML=lt),ge=s(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1gv8jsw"&&(B.textContent=nt),Je=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1dk2p5m"&&(x.innerHTML=at),Ue=s(e),d(H.$$.fragment,e),be=s(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-n2utf9"&&($.textContent=st),je=s(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1rx67l9"&&(A.innerHTML=it),Ce=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-exsorg"&&(G.textContent=ot),Ie=s(e),d(L.$$.fragment,e),_e=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-yra23x"&&(Z.textContent=rt),ve=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14koobd"&&(V.innerHTML=pt),ke=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-15d99ek"&&(X.innerHTML=dt),Re=s(e),d(z.$$.fragment,e),Be=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-14vojqw"&&(W.innerHTML=ct),xe=s(e),d(Q.$$.fragment,e),He=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-103ifl4"&&(F.textContent=mt),$e=s(e),d(N.$$.fragment,e),Ae=s(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1hyr34n"&&(S.textContent=ht),Ge=s(e),E=o(e,"OL",{"data-svelte-h":!0}),r(E)!=="svelte-oi045r"&&(E.innerHTML=ut),Le=s(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-ffg2nl"&&(Y.textContent=wt),Ze=s(e),d(q.$$.fragment,e),Ve=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-unvala"&&(P.innerHTML=Mt),Xe=s(e),d(K.$$.fragment,e),ze=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-hi9qdh"&&(D.innerHTML=yt),We=s(e),d(O.$$.fragment,e),Qe=s(e),le=o(e,"P",{}),ft(le).forEach(l),this.h()},h(){Tt(w,"name","hf:doc:metadata"),Tt(w,"content",kt)},m(e,t){It(document.head,w),n(e,ae,t),n(e,te,t),n(e,se,t),c(M,e,t),n(e,ie,t),n(e,y,t),n(e,oe,t),c(f,e,t),n(e,re,t),n(e,T,t),n(e,pe,t),n(e,g,t),n(e,de,t),n(e,J,t),n(e,ce,t),n(e,U,t),n(e,me,t),n(e,b,t),n(e,he,t),n(e,j,t),n(e,ue,t),n(e,C,t),n(e,we,t),c(I,e,t),n(e,Me,t),c(_,e,t),n(e,ye,t),n(e,v,t),n(e,fe,t),n(e,k,t),n(e,Te,t),n(e,R,t),n(e,ge,t),n(e,B,t),n(e,Je,t),n(e,x,t),n(e,Ue,t),c(H,e,t),n(e,be,t),n(e,$,t),n(e,je,t),n(e,A,t),n(e,Ce,t),n(e,G,t),n(e,Ie,t),c(L,e,t),n(e,_e,t),n(e,Z,t),n(e,ve,t),n(e,V,t),n(e,ke,t),n(e,X,t),n(e,Re,t),c(z,e,t),n(e,Be,t),n(e,W,t),n(e,xe,t),c(Q,e,t),n(e,He,t),n(e,F,t),n(e,$e,t),c(N,e,t),n(e,Ae,t),n(e,S,t),n(e,Ge,t),n(e,E,t),n(e,Le,t),n(e,Y,t),n(e,Ze,t),c(q,e,t),n(e,Ve,t),n(e,P,t),n(e,Xe,t),c(K,e,t),n(e,ze,t),n(e,D,t),n(e,We,t),c(O,e,t),n(e,Qe,t),n(e,le,t),Fe=!0},p:Jt,i(e){Fe||(m(M.$$.fragment,e),m(f.$$.fragment,e),m(I.$$.fragment,e),m(_.$$.fragment,e),m(H.$$.fragment,e),m(L.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(N.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(O.$$.fragment,e),Fe=!0)},o(e){h(M.$$.fragment,e),h(f.$$.fragment,e),h(I.$$.fragment,e),h(_.$$.fragment,e),h(H.$$.fragment,e),h(L.$$.fragment,e),h(z.$$.fragment,e),h(Q.$$.fragment,e),h(N.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(O.$$.fragment,e),Fe=!1},d(e){e&&(l(ae),l(te),l(se),l(ie),l(y),l(oe),l(re),l(T),l(pe),l(g),l(de),l(J),l(ce),l(U),l(me),l(b),l(he),l(j),l(ue),l(C),l(we),l(Me),l(ye),l(v),l(fe),l(k),l(Te),l(R),l(ge),l(B),l(Je),l(x),l(Ue),l(be),l($),l(je),l(A),l(Ce),l(G),l(Ie),l(_e),l(Z),l(ve),l(V),l(ke),l(X),l(Re),l(Be),l(W),l(xe),l(He),l(F),l($e),l(Ae),l(S),l(Ge),l(E),l(Le),l(Y),l(Ze),l(Ve),l(P),l(Xe),l(ze),l(D),l(We),l(Qe),l(le)),l(w),u(M,e),u(f,e),u(I,e),u(_,e),u(H,e),u(L,e),u(z,e),u(Q,e),u(N,e),u(q,e),u(K,e),u(O,e)}}}const kt='{"title":"Using LLaMA models with TRL","local":"using-llama-models-with-trl","sections":[{"title":"Efficient training strategies","local":"efficient-training-strategies","sections":[],"depth":2},{"title":"Supervised fine-tuning","local":"supervised-fine-tuning","sections":[],"depth":2},{"title":"Reward modeling and human preferences","local":"reward-modeling-and-human-preferences","sections":[],"depth":2},{"title":"Reinforcement Learning from Human Feedback","local":"reinforcement-learning-from-human-feedback","sections":[],"depth":2}],"depth":1}';function Rt(Ne){return Ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends bt{constructor(w){super(),jt(this,w,Rt,vt,gt,{})}}export{At as component};
