import{s as pt,o as rt,n as ke}from"../chunks/scheduler.d6170356.js";import{S as ct,i as ut,g as o,s,r as h,A as ht,h as p,f as a,c as n,j as nt,u as d,x as r,k as it,y as dt,a as l,v as f,d as m,t as g,w}from"../chunks/index.fcd4cc08.js";import{T as xe}from"../chunks/Tip.b09c67cf.js";import{C as ot}from"../chunks/CodeBlock.7b16bdef.js";import{H as D}from"../chunks/Heading.8660bd0e.js";function ft(b){let i,u='This guide will take you through the process of integrating a <em>Sign-In with HF</em> button into any Space. If you’re seeking a fast and simple method to implement this in a <strong>Gradio</strong> Space, take a look at its <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">built-in integration</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1nqltc0"&&(i.innerHTML=u)},m(c,T){l(c,i,T)},p:ke,d(c){c&&a(i)}}}function mt(b){let i,u='You can also use the HF OAuth flow to create a “Sign in with HF” flow in any website or App, outside of Spaces. <a href="./oauth">Read our general OAuth page</a>.';return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-138wjpm"&&(i.innerHTML=u)},m(c,T){l(c,i,T)},p:ke,d(c){c&&a(i)}}}function gt(b){let i,u="You should use <code>target=_blank</code> on the button to open the sign-in page in a new tab, unless you run the space outside its <code>iframe</code>. Otherwise, you might encounter issues with cookies on some browsers.";return{c(){i=o("p"),i.innerHTML=u},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-9c51kn"&&(i.innerHTML=u)},m(c,T){l(c,i,T)},p:ke,d(c){c&&a(i)}}}function wt(b){let i,u,c,T,v,ee,j,Ge='You can enable a built-in sign-in flow in your Space by seamlessly creating and associating an <a href="https://developer.okta.com/blog/2019/10/21/illustrated-guide-to-oauth-and-oidc" rel="nofollow">OAuth/OpenID connect</a> app so users can log in with their HF account.',te,_,Ee='This enables new use cases for your Space. For instance, when combined with <a href="https://huggingface.co/docs/hub/spaces-storage" rel="nofollow">Persistent Storage</a>, a generative AI Space could allow users to log in to access their previous generations, only accessible to them.',ae,y,le,$,se,J,ne,H,Re="All you need to do is add <code>hf_oauth: true</code> to your Space’s metadata inside your <code>README.md</code> file.",ie,I,Be="Here’s an example of metadata for a Gradio Space:",oe,S,pe,C,Pe='You can check out the <a href="./spaces-config-reference">configuration reference docs</a> for more information.',re,U,Ae='This will add the following <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">environment variables</a> to your space:',ce,L,Ze='<li><code>OAUTH_CLIENT_ID</code>: the client ID of your OAuth app (public)</li> <li><code>OAUTH_CLIENT_SECRET</code>: the client secret of your OAuth app</li> <li><code>OAUTH_SCOPES</code>: scopes accessible by your OAuth app.</li> <li><code>OPENID_PROVIDER_URL</code>: The URL of the OpenID provider. The OpenID metadata will be available at <a href="https://huggingface.co/.well-known/openid-configuration" rel="nofollow"><code>{OPENID_PROVIDER_URL}/.well-known/openid-configuration</code></a>.</li>',ue,x,Fe="As for any other environment variable, you can use them in your code by using <code>os.getenv(&quot;OAUTH_CLIENT_ID&quot;)</code>, for example.",he,k,de,G,Ne="You can use any redirect URL you want, as long as it targets your Space.",fe,E,We='Note that <code>SPACE_HOST</code> is <a href="https://huggingface.co/docs/hub/spaces-overview#helper-environment-variables" rel="nofollow">available</a> as an environment variable.',me,R,Oe="For example, you can use <code>https://{SPACE_HOST}/login/callback</code> as a redirect URI.",ge,B,we,P,Ve="The following scopes are always included for Spaces:",Te,A,Ye="<li><code>openid</code>: Get the ID token in addition to the access token.</li> <li><code>profile</code>: Get the user’s profile information (username, avatar, etc.)</li>",be,Z,ze="Those scopes are optional and can be added by setting <code>hf_oauth_scopes</code> in your Space’s metadata:",ye,F,Xe='<li><code>email</code>: Get the user’s email address.</li> <li><code>read-repos</code>: Get read access to the user’s personal repos.</li> <li><code>write-repos</code>: Get write/read access to the user’s personal repos.</li> <li><code>manage-repos</code>: Get full access to the user’s personal repos. Also grants repo creation and deletion.</li> <li><code>inference-api</code>: Get access to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>, you will be able to make inference requests on behalf of the user.</li>',$e,N,Me,W,Qe='You now have all the information to add a “Sign-in with HF” button to your Space. Some libraries (<a href="https://github.com/lepture/authlib" rel="nofollow">Python</a>, <a href="https://github.com/panva/node-openid-client" rel="nofollow">NodeJS</a>) can help you implement the OpenID/OAuth protocol.',ve,O,qe='Gradio and hugginface.js also provide <strong>built-in support</strong>, making implementing the Sign-in with HF button a breeze; you can check out the associated guides with <a href="https://www.gradio.app/guides/sharing-your-app#o-auth-login-via-hugging-face" rel="nofollow">gradio</a> and with <a href="https://huggingface.co/docs/huggingface.js/hub/README#oauth-login" rel="nofollow">hugginface.js</a>.',je,V,De="Basically, you need to:",_e,Y,Ke="<li>Redirect the user to <code>https://huggingface.co/oauth/authorize?redirect_uri={REDIRECT_URI}&amp;scope=openid%20profile&amp;client_id={CLIENT_ID}&amp;state={STATE}</code>, where <code>STATE</code> is a random string that you will need to verify later.</li> <li>Handle the callback on <code>/auth/callback</code> or <code>/login/callback</code> (or your own custom callback URL) and verify the <code>state</code> parameter.</li> <li>Use the <code>code</code> query parameter to get an access token and id token from <code>https://huggingface.co/oauth/token</code> (POST request with <code>client_id</code>, <code>code</code>, <code>grant_type=authorization_code</code> and <code>redirect_uri</code> as form data, and with <code>Authorization: Basic {base64(client_id:client_secret)}</code> as a header).</li>",Je,M,He,z,Ie,X,et='<li><a href="https://huggingface.co/spaces/Wauplin/gradio-oauth-test" rel="nofollow">Gradio test app</a></li> <li><a href="https://huggingface.co/spaces/huggingchat/chat-ui" rel="nofollow">Hugging Chat (NodeJS/SvelteKit)</a></li> <li><a href="https://huggingface.co/spaces/huggingfacejs/inference-widgets" rel="nofollow">Inference Widgets (Auth.js/SvelteKit)</a>, uses the <code>inference-api</code> scope to make inference requests on behalf of the user.</li> <li><a href="https://huggingface.co/spaces/huggingfacejs/client-side-oauth" rel="nofollow">Client-Side in a Static Space (huggingface.js)</a> - very simple JavaScript example.</li>',Se,Q,tt="JS Code example:",Ce,q,Ue,K,Le;return v=new D({props:{title:"Adding a Sign-In with HF button to your Space",local:"adding-a-sign-in-with-hf-button-to-your-space",headingTag:"h1"}}),y=new xe({props:{$$slots:{default:[ft]},$$scope:{ctx:b}}}),$=new xe({props:{$$slots:{default:[mt]},$$scope:{ctx:b}}}),J=new D({props:{title:"Create an OAuth app",local:"create-an-oauth-app",headingTag:"h2"}}),S=new ot({props:{code:"dGl0bGUlM0ElMjBHcmFkaW8lMjBPYXV0aCUyMFRlc3QlMEFlbW9qaSUzQSUyMCVGMCU5RiU4RiU4NiUwQWNvbG9yRnJvbSUzQSUyMHBpbmslMEFjb2xvclRvJTNBJTIwcGluayUwQXNkayUzQSUyMGdyYWRpbyUwQXNka192ZXJzaW9uJTNBJTIwMy40MC4wJTBBcHl0aG9uX3ZlcnNpb24lM0ElMjAzLjEwLjYlMEFhcHBfZmlsZSUzQSUyMGFwcC5weSUwQSUwQWhmX29hdXRoJTNBJTIwdHJ1ZSUwQSUyMyUyMG9wdGlvbmFsJTJDJTIwc2VlJTIwJTIyU2NvcGVzJTIyJTIwYmVsb3cuJTIwJTIyb3BlbmlkJTIwcHJvZmlsZSUyMiUyMGlzJTIwYWx3YXlzJTIwaW5jbHVkZWQuJTBBaGZfb2F1dGhfc2NvcGVzJTNBJTBBJTIwLSUyMHJlYWQtcmVwb3MlMEElMjAtJTIwd3JpdGUtcmVwb3MlMEElMjAtJTIwbWFuYWdlLXJlcG9zJTBBJTIwLSUyMGluZmVyZW5jZS1hcGk=",highlighted:`<span class="hljs-attr">title:</span> <span class="hljs-string">Gradio</span> <span class="hljs-string">Oauth</span> <span class="hljs-string">Test</span>
<span class="hljs-attr">emoji:</span> <span class="hljs-string">🏆</span>
<span class="hljs-attr">colorFrom:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">colorTo:</span> <span class="hljs-string">pink</span>
<span class="hljs-attr">sdk:</span> <span class="hljs-string">gradio</span>
<span class="hljs-attr">sdk_version:</span> <span class="hljs-number">3.40</span><span class="hljs-number">.0</span>
<span class="hljs-attr">python_version:</span> <span class="hljs-number">3.10</span><span class="hljs-number">.6</span>
<span class="hljs-attr">app_file:</span> <span class="hljs-string">app.py</span>

<span class="hljs-attr">hf_oauth:</span> <span class="hljs-literal">true</span>
<span class="hljs-comment"># optional, see &quot;Scopes&quot; below. &quot;openid profile&quot; is always included.</span>
<span class="hljs-attr">hf_oauth_scopes:</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">read-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">write-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">manage-repos</span>
 <span class="hljs-bullet">-</span> <span class="hljs-string">inference-api</span>`,wrap:!1}}),k=new D({props:{title:"Redirect URLs",local:"redirect-urls",headingTag:"h2"}}),B=new D({props:{title:"Scopes",local:"scopes",headingTag:"h2"}}),N=new D({props:{title:"Adding the button to your Space",local:"adding-the-button-to-your-space",headingTag:"h2"}}),M=new xe({props:{warning:!0,$$slots:{default:[gt]},$$scope:{ctx:b}}}),z=new D({props:{title:"Examples:",local:"examples",headingTag:"h2"}}),q=new ot({props:{code:"aW1wb3J0JTIwJTdCJTIwb2F1dGhMb2dpblVybCUyQyUyMG9hdXRoSGFuZGxlUmVkaXJlY3RJZlByZXNlbnQlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEElMEFjb25zdCUyMG9hdXRoUmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBvYXV0aEhhbmRsZVJlZGlyZWN0SWZQcmVzZW50KCklM0IlMEElMEFpZiUyMCghb2F1dGhSZXN1bHQpJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIwSWYlMjB0aGUlMjB1c2VyJTIwaXMlMjBub3QlMjBsb2dnZWQlMjBpbiUyQyUyMHJlZGlyZWN0JTIwdG8lMjB0aGUlMjBsb2dpbiUyMHBhZ2UlMEElMjAlMjB3aW5kb3cubG9jYXRpb24uaHJlZiUyMCUzRCUyMGF3YWl0JTIwb2F1dGhMb2dpblVybCgpJTNCJTBBJTdEJTBBJTBBJTJGJTJGJTIwWW91JTIwY2FuJTIwdXNlJTIwb2F1dGhSZXN1bHQuYWNjZXNzVG9rZW4lMkMlMjBvYXV0aFJlc3VsdC51c2VySW5mbyUyMGFtb25nJTIwb3RoZXIlMjB0aGluZ3MlMEFjb25zb2xlLmxvZyhvYXV0aFJlc3VsdCklM0I=",highlighted:`<span class="hljs-keyword">import</span> { oauthLoginUrl, oauthHandleRedirectIfPresent } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> oauthResult = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthHandleRedirectIfPresent</span>();

<span class="hljs-keyword">if</span> (!oauthResult) {
  <span class="hljs-comment">// If the user is not logged in, redirect to the login page</span>
  <span class="hljs-variable language_">window</span>.<span class="hljs-property">location</span>.<span class="hljs-property">href</span> = <span class="hljs-keyword">await</span> <span class="hljs-title function_">oauthLoginUrl</span>();
}

<span class="hljs-comment">// You can use oauthResult.accessToken, oauthResult.userInfo among other things</span>
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(oauthResult);`,wrap:!1}}),{c(){i=o("meta"),u=s(),c=o("p"),T=s(),h(v.$$.fragment),ee=s(),j=o("p"),j.innerHTML=Ge,te=s(),_=o("p"),_.innerHTML=Ee,ae=s(),h(y.$$.fragment),le=s(),h($.$$.fragment),se=s(),h(J.$$.fragment),ne=s(),H=o("p"),H.innerHTML=Re,ie=s(),I=o("p"),I.textContent=Be,oe=s(),h(S.$$.fragment),pe=s(),C=o("p"),C.innerHTML=Pe,re=s(),U=o("p"),U.innerHTML=Ae,ce=s(),L=o("ul"),L.innerHTML=Ze,ue=s(),x=o("p"),x.innerHTML=Fe,he=s(),h(k.$$.fragment),de=s(),G=o("p"),G.textContent=Ne,fe=s(),E=o("p"),E.innerHTML=We,me=s(),R=o("p"),R.innerHTML=Oe,ge=s(),h(B.$$.fragment),we=s(),P=o("p"),P.textContent=Ve,Te=s(),A=o("ul"),A.innerHTML=Ye,be=s(),Z=o("p"),Z.innerHTML=ze,ye=s(),F=o("ul"),F.innerHTML=Xe,$e=s(),h(N.$$.fragment),Me=s(),W=o("p"),W.innerHTML=Qe,ve=s(),O=o("p"),O.innerHTML=qe,je=s(),V=o("p"),V.textContent=De,_e=s(),Y=o("ul"),Y.innerHTML=Ke,Je=s(),h(M.$$.fragment),He=s(),h(z.$$.fragment),Ie=s(),X=o("ul"),X.innerHTML=et,Se=s(),Q=o("p"),Q.textContent=tt,Ce=s(),h(q.$$.fragment),Ue=s(),K=o("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(a),u=n(e),c=p(e,"P",{}),nt(c).forEach(a),T=n(e),d(v.$$.fragment,e),ee=n(e),j=p(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1nfjaew"&&(j.innerHTML=Ge),te=n(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1t83yje"&&(_.innerHTML=Ee),ae=n(e),d(y.$$.fragment,e),le=n(e),d($.$$.fragment,e),se=n(e),d(J.$$.fragment,e),ne=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1u00faw"&&(H.innerHTML=Re),ie=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-vlpqut"&&(I.textContent=Be),oe=n(e),d(S.$$.fragment,e),pe=n(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-ml9rcy"&&(C.innerHTML=Pe),re=n(e),U=p(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-12m1u10"&&(U.innerHTML=Ae),ce=n(e),L=p(e,"UL",{"data-svelte-h":!0}),r(L)!=="svelte-k73zcv"&&(L.innerHTML=Ze),ue=n(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-qqxlx3"&&(x.innerHTML=Fe),he=n(e),d(k.$$.fragment,e),de=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-eoih5g"&&(G.textContent=Ne),fe=n(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1a014a5"&&(E.innerHTML=We),me=n(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-4fyftp"&&(R.innerHTML=Oe),ge=n(e),d(B.$$.fragment,e),we=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-sd96qs"&&(P.textContent=Ve),Te=n(e),A=p(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-3wn6r0"&&(A.innerHTML=Ye),be=n(e),Z=p(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-181zoj"&&(Z.innerHTML=ze),ye=n(e),F=p(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-icfyf6"&&(F.innerHTML=Xe),$e=n(e),d(N.$$.fragment,e),Me=n(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1a3vuj4"&&(W.innerHTML=Qe),ve=n(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1ox841a"&&(O.innerHTML=qe),je=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-g0kxak"&&(V.textContent=De),_e=n(e),Y=p(e,"UL",{"data-svelte-h":!0}),r(Y)!=="svelte-159xo4d"&&(Y.innerHTML=Ke),Je=n(e),d(M.$$.fragment,e),He=n(e),d(z.$$.fragment,e),Ie=n(e),X=p(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-lipo2y"&&(X.innerHTML=et),Se=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1g8zr10"&&(Q.textContent=tt),Ce=n(e),d(q.$$.fragment,e),Ue=n(e),K=p(e,"P",{}),nt(K).forEach(a),this.h()},h(){it(i,"name","hf:doc:metadata"),it(i,"content",Tt)},m(e,t){dt(document.head,i),l(e,u,t),l(e,c,t),l(e,T,t),f(v,e,t),l(e,ee,t),l(e,j,t),l(e,te,t),l(e,_,t),l(e,ae,t),f(y,e,t),l(e,le,t),f($,e,t),l(e,se,t),f(J,e,t),l(e,ne,t),l(e,H,t),l(e,ie,t),l(e,I,t),l(e,oe,t),f(S,e,t),l(e,pe,t),l(e,C,t),l(e,re,t),l(e,U,t),l(e,ce,t),l(e,L,t),l(e,ue,t),l(e,x,t),l(e,he,t),f(k,e,t),l(e,de,t),l(e,G,t),l(e,fe,t),l(e,E,t),l(e,me,t),l(e,R,t),l(e,ge,t),f(B,e,t),l(e,we,t),l(e,P,t),l(e,Te,t),l(e,A,t),l(e,be,t),l(e,Z,t),l(e,ye,t),l(e,F,t),l(e,$e,t),f(N,e,t),l(e,Me,t),l(e,W,t),l(e,ve,t),l(e,O,t),l(e,je,t),l(e,V,t),l(e,_e,t),l(e,Y,t),l(e,Je,t),f(M,e,t),l(e,He,t),f(z,e,t),l(e,Ie,t),l(e,X,t),l(e,Se,t),l(e,Q,t),l(e,Ce,t),f(q,e,t),l(e,Ue,t),l(e,K,t),Le=!0},p(e,[t]){const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),y.$set(at);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),$.$set(lt);const st={};t&2&&(st.$$scope={dirty:t,ctx:e}),M.$set(st)},i(e){Le||(m(v.$$.fragment,e),m(y.$$.fragment,e),m($.$$.fragment,e),m(J.$$.fragment,e),m(S.$$.fragment,e),m(k.$$.fragment,e),m(B.$$.fragment,e),m(N.$$.fragment,e),m(M.$$.fragment,e),m(z.$$.fragment,e),m(q.$$.fragment,e),Le=!0)},o(e){g(v.$$.fragment,e),g(y.$$.fragment,e),g($.$$.fragment,e),g(J.$$.fragment,e),g(S.$$.fragment,e),g(k.$$.fragment,e),g(B.$$.fragment,e),g(N.$$.fragment,e),g(M.$$.fragment,e),g(z.$$.fragment,e),g(q.$$.fragment,e),Le=!1},d(e){e&&(a(u),a(c),a(T),a(ee),a(j),a(te),a(_),a(ae),a(le),a(se),a(ne),a(H),a(ie),a(I),a(oe),a(pe),a(C),a(re),a(U),a(ce),a(L),a(ue),a(x),a(he),a(de),a(G),a(fe),a(E),a(me),a(R),a(ge),a(we),a(P),a(Te),a(A),a(be),a(Z),a(ye),a(F),a($e),a(Me),a(W),a(ve),a(O),a(je),a(V),a(_e),a(Y),a(Je),a(He),a(Ie),a(X),a(Se),a(Q),a(Ce),a(Ue),a(K)),a(i),w(v,e),w(y,e),w($,e),w(J,e),w(S,e),w(k,e),w(B,e),w(N,e),w(M,e),w(z,e),w(q,e)}}}const Tt='{"title":"Adding a Sign-In with HF button to your Space","local":"adding-a-sign-in-with-hf-button-to-your-space","sections":[{"title":"Create an OAuth app","local":"create-an-oauth-app","sections":[],"depth":2},{"title":"Redirect URLs","local":"redirect-urls","sections":[],"depth":2},{"title":"Scopes","local":"scopes","sections":[],"depth":2},{"title":"Adding the button to your Space","local":"adding-the-button-to-your-space","sections":[],"depth":2},{"title":"Examples:","local":"examples","sections":[],"depth":2}],"depth":1}';function bt(b){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _t extends ct{constructor(i){super(),ut(this,i,bt,wt,pt,{})}}export{_t as component};
