import{s as es,o as ts,n as gt}from"../chunks/scheduler.182ea377.js";import{S as ss,i as ls,g as o,s as a,r as d,A as as,h as p,f as s,c as n,j as Ot,u,x as r,k as we,y as ns,a as l,v as m,d as h,t as c,w as f}from"../chunks/index.abf12888.js";import{T as Tt}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{H as be}from"../chunks/Heading.16916d63.js";function is(b){let i,J='This is an experimental method that adds PEFTs <code>~peft.LoraModel.add_weighted_adapter</code> method to Diffusers to enable more efficient merging methods. Check out this <a href="https://github.com/huggingface/diffusers/issues/6892" rel="nofollow">issue</a> if you’re interested in learning more about the motivation and design behind this integration.';return{c(){i=o("p"),i.innerHTML=J},l(M){i=p(M,"P",{"data-svelte-h":!0}),r(i)!=="svelte-g1xxcw"&&(i.innerHTML=J)},m(M,w){l(M,i,w)},p:gt,d(M){M&&s(i)}}}function os(b){let i,J="You can optionally push the ikea_peft_model to the Hub by calling <code>ikea_peft_model.push_to_hub(&quot;ikea_peft_model&quot;, token=TOKEN)</code>.";return{c(){i=o("p"),i.innerHTML=J},l(M){i=p(M,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1m0icqe"&&(i.innerHTML=J)},m(M,w){l(M,i,w)},p:gt,d(M){M&&s(i)}}}function ps(b){let i,J="Keep in mind the LoRAs need to have the same rank to be merged!";return{c(){i=o("p"),i.textContent=J},l(M){i=p(M,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1g1f7t1"&&(i.textContent=J)},m(M,w){l(M,i,w)},p:gt,d(M){M&&s(i)}}}function rs(b){let i,J,M,w,k,ge,I,Zt='It can be fun and creative to use multiple <a href="(https://huggingface.co/docs/peft/conceptual_guides/adapter#low-rank-adaptation-lora)">LoRAs</a> together to generate something entirely new and unique. This works by merging multiple LoRA weights together to produce images that are a blend of different styles. Diffusers provides a few methods to merge LoRAs depending on <em>how</em> you want to merge their weights, which can affect image quality.',Ze,G,Ut='This guide will show you how to merge LoRAs using the <a href="/docs/diffusers/v0.27.1/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> and <code>~peft.LoraModel.add_weighted_adapter</code> methods. To improve inference speed and reduce memory-usage of merged LoRAs, you’ll also see how to use the <a href="/docs/diffusers/v0.27.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.fuse_lora">fuse_lora()</a> method to fuse the LoRA weights with the original weights of the underlying model.',Ue,$,jt='For this guide, load a Stable Diffusion XL (SDXL) checkpoint and the <a href="">KappaNeuro/studio-ghibli-style</a> and <a href="">Norod78/sdxl-chalkboarddrawing-lora</a> LoRAs with the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/inpaint#diffusers.StableDiffusionInpaintPipeline.load_lora_weights">load_lora_weights()</a> method. You’ll need to assign each LoRA an <code>adapter_name</code> to combine them later.',je,v,_e,R,We,V,_t='The <a href="/docs/diffusers/v0.27.1/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> method merges LoRA adapters by concatenating their weighted matrices. Use the adapter name to specify which LoRAs to merge, and the <code>adapter_weights</code> parameter to control the scaling for each LoRA. For example, if <code>adapter_weights=[0.5, 0.5]</code>, then the merged LoRA output is an average of both LoRAs. Try adjusting the adapter weights to see how it affects the generated image!',ke,C,Ie,T,Wt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lora_merge_set_adapters.png"/>',Ge,L,$e,g,ve,B,kt='The <code>~peft.LoraModel.add_weighted_adapter</code> method provides access to more efficient merging method such as <a href="https://huggingface.co/docs/peft/developer_guides/model_merging" rel="nofollow">TIES and DARE</a>. To use these merging methods, make sure you have the latest stable version of Diffusers and PEFT installed.',Re,q,Ve,X,It="There are three steps to merge LoRAs with the <code>~peft.LoraModel.add_weighted_adapter</code> method:",Ce,F,Gt="<li>Create a <code>~peft.PeftModel</code> from the underlying model and LoRA checkpoint.</li> <li>Load a base UNet model and the LoRA adapters.</li> <li>Merge the adapters using the <code>~peft.LoraModel.add_weighted_adapter</code> method and the merging method of your choice.</li>",Le,Y,$t="Let’s dive deeper into what these steps entail.",Be,N,vt="<li>Load a UNet that corresponds to the UNet in the LoRA checkpoint. In this case, both LoRAs use the SDXL UNet as their base model.</li>",qe,x,Xe,Q,Rt='Load the SDXL pipeline and the LoRA checkpoints, starting with the <a href="https://huggingface.co/ostris/ikea-instructions-lora-sdxl" rel="nofollow">ostris/ikea-instructions-lora-sdxl</a> LoRA.',Fe,E,Ye,H,Vt="Now you’ll create a <code>~peft.PeftModel</code> from the loaded LoRA checkpoint by combining the SDXL UNet and the LoRA UNet from the pipeline.",Ne,S,xe,Z,Qe,z,Ct='Repeat this process to create a <code>~peft.PeftModel</code> from the <a href="https://huggingface.co/lordjia/by-feng-zikai" rel="nofollow">lordjia/by-feng-zikai</a> LoRA.',Ee,A,He,U,Lt="<li>Load a base UNet model and then load the adapters onto it.</li>",Se,D,ze,j,Bt='<li>Merge the adapters using the <code>~peft.LoraModel.add_weighted_adapter</code> method and the merging method of your choice (learn more about other merging methods in this <a href="https://huggingface.co/blog/peft_merging" rel="nofollow">blog post</a>). For this example, let’s use the <code>&quot;dare_linear&quot;</code> method to merge the LoRAs.</li>',Ae,_,De,P,Pe,K,qt="Now you can generate an image with the merged LoRA.",Ke,O,Oe,W,Xt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ikea-feng-dare-linear.png"/>',et,ee,tt,te,Ft='Both the <a href="/docs/diffusers/v0.27.1/en/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters">set_adapters()</a> and <code>~peft.LoraModel.add_weighted_adapter</code> methods require loading the base model and the LoRA adapters separately which incurs some overhead. The <a href="/docs/diffusers/v0.27.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.fuse_lora">fuse_lora()</a> method allows you to fuse the LoRA weights directly with the original weights of the underlying model. This way, you’re only loading the model once which can increase inference and lower memory-usage.',st,se,Yt='You can use PEFT to easily fuse/unfuse multiple adapters directly into the model weights (both UNet and text encoder) using the <a href="/docs/diffusers/v0.27.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.fuse_lora">fuse_lora()</a> method, which can lead to a speed-up in inference and lower VRAM usage.',lt,le,Nt="For example, if you have a base model and adapters loaded and set as active with the following adapter weights:",at,ae,nt,ne,xt='Fuse these LoRAs into the UNet with the <a href="/docs/diffusers/v0.27.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.fuse_lora">fuse_lora()</a> method. The <code>lora_scale</code> parameter controls how much to scale the output by with the LoRA weights. It is important to make the <code>lora_scale</code> adjustments in the <a href="/docs/diffusers/v0.27.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.fuse_lora">fuse_lora()</a> method because it won’t work if you try to pass <code>scale</code> to the <code>cross_attention_kwargs</code> in the pipeline.',it,ie,ot,oe,Qt='Then you should use <a href="/docs/diffusers/v0.27.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.unload_lora_weights">unload_lora_weights()</a> to unload the LoRA weights since they’ve already been fused with the underlying base model. Finally, call <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a> to save the fused pipeline locally or you could call <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to push the fused pipeline to the Hub.',pt,pe,rt,re,Et="Now you can quickly load the fused pipeline and use it for inference without needing to separately load the LoRA adapters.",dt,de,ut,ue,Ht='You can call <a href="/docs/diffusers/v0.27.1/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.unfuse_lora">unfuse_lora()</a> to restore the original model’s weights (for example, if you want to use a different <code>lora_scale</code> value). However, this only works if you’ve only fused one LoRA adapter to the original model. If you’ve fused multiple LoRAs, you’ll need to reload the model.',mt,me,ht,he,ct,ce,St='<a href="../optimization/torch2.0#torchcompile">torch.compile</a> can speed up your pipeline even more, but the LoRA weights must be fused first and then unloaded. Typically, the UNet is compiled because it is such a computationally intensive component of the pipeline.',ft,fe,Mt,Me,zt='Learn more about torch.compile in the <a href="../tutorials/fast_diffusion#torchcompile">Accelerate inference of text-to-image diffusion models</a> guide.',yt,ye,Jt,Je,At='For more conceptual details about how each merging method works, take a look at the <a href="https://huggingface.co/blog/peft_merging#concatenation-cat" rel="nofollow">🤗 PEFT welcomes new merging methods</a> blog post!',wt,Te,bt;return k=new be({props:{title:"Merge LoRAs",local:"merge-loras",headingTag:"h1"}}),v=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTIyb3N0cmlzJTJGaWtlYS1pbnN0cnVjdGlvbnMtbG9yYS1zZHhsJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpa2VhX2luc3RydWN0aW9uc194bF92MV81LnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyaWtlYSUyMiklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJsb3JkamlhJTJGYnktZmVuZy16aWthaSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyZmVuZ3ppa2FpX3YxLjBfWEwuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJmZW5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;ostris/ikea-instructions-lora-sdxl&quot;</span>, weight_name=<span class="hljs-string">&quot;ikea_instructions_xl_v1_5.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;ikea&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;lordjia/by-feng-zikai&quot;</span>, weight_name=<span class="hljs-string">&quot;fengzikai_v1.0_XL.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;feng&quot;</span>)`,wrap:!1}}),R=new be({props:{title:"set_adapters",local:"setadapters",headingTag:"h2"}}),C=new y({props:{code:"cGlwZWxpbmUuc2V0X2FkYXB0ZXJzKCU1QiUyMmlrZWElMjIlMkMlMjAlMjJmZW5nJTIyJTVEJTJDJTIwYWRhcHRlcl93ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC44JTVEKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGJvd2wlMjBvZiUyMHJhbWVuJTIwc2hhcGVkJTIwbGlrZSUyMGElMjBjdXRlJTIwa2F3YWlpJTIwYmVhciUyQyUyMGJ5JTIwRmVuZyUyMFppa2FpJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBjcm9zc19hdHRlbnRpb25fa3dhcmdzJTNEJTdCJTIyc2NhbGUlMjIlM0ElMjAxLjAlN0QpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`pipeline.set_adapters([<span class="hljs-string">&quot;ikea&quot;</span>, <span class="hljs-string">&quot;feng&quot;</span>], adapter_weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.8</span>])

generator = torch.manual_seed(<span class="hljs-number">0</span>)
prompt = <span class="hljs-string">&quot;A bowl of ramen shaped like a cute kawaii bear, by Feng Zikai&quot;</span>
image = pipeline(prompt, generator=generator, cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1.0</span>}).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),L=new be({props:{title:"add_weighted_adapter",local:"addweightedadapter",headingTag:"h2"}}),g=new Tt({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:b}}}),q=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZGlmZnVzZXJzJTIwcGVmdA==",highlighted:"pip install -U diffusers peft",wrap:!1}}),x=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF1bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMCUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16, 
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    subfolder=<span class="hljs-string">&quot;unet&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),E=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1bmV0JTNEdW5ldCUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJvc3RyaXMlMkZpa2VhLWluc3RydWN0aW9ucy1sb3JhLXNkeGwlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlrZWFfaW5zdHJ1Y3Rpb25zX3hsX3YxXzUuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJpa2VhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16,
    unet=unet
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;ostris/ikea-instructions-lora-sdxl&quot;</span>, weight_name=<span class="hljs-string">&quot;ikea_instructions_xl_v1_5.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;ikea&quot;</span>)`,wrap:!1}}),S=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUyQyUyMExvcmFDb25maWclMEFpbXBvcnQlMjBjb3B5JTBBJTBBc2R4bF91bmV0JTIwJTNEJTIwY29weS5kZWVwY29weSh1bmV0KSUwQWlrZWFfcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKCUwQSUyMCUyMCUyMCUyMHNkeGxfdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnVuZXQucGVmdF9jb25maWclNUIlMjJpa2VhJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIyaWtlYSUyMiUwQSklMEElMEFvcmlnaW5hbF9zdGF0ZV9kaWN0JTIwJTNEJTIwJTdCZiUyMmJhc2VfbW9kZWwubW9kZWwuJTdCayU3RCUyMiUzQSUyMHYlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwcGlwZWxpbmUudW5ldC5zdGF0ZV9kaWN0KCkuaXRlbXMoKSU3RCUwQWlrZWFfcGVmdF9tb2RlbC5sb2FkX3N0YXRlX2RpY3Qob3JpZ2luYWxfc3RhdGVfZGljdCUyQyUyMHN0cmljdCUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig
<span class="hljs-keyword">import</span> copy

sdxl_unet = copy.deepcopy(unet)
ikea_peft_model = get_peft_model(
    sdxl_unet,
    pipeline.unet.peft_config[<span class="hljs-string">&quot;ikea&quot;</span>],
    adapter_name=<span class="hljs-string">&quot;ikea&quot;</span>
)

original_state_dict = {<span class="hljs-string">f&quot;base_model.model.<span class="hljs-subst">{k}</span>&quot;</span>: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> pipeline.unet.state_dict().items()}
ikea_peft_model.load_state_dict(original_state_dict, strict=<span class="hljs-literal">True</span>)`,wrap:!1}}),Z=new Tt({props:{warning:!1,$$slots:{default:[os]},$$scope:{ctx:b}}}),A=new y({props:{code:"cGlwZWxpbmUuZGVsZXRlX2FkYXB0ZXJzKCUyMmlrZWElMjIpJTBBc2R4bF91bmV0LmRlbGV0ZV9hZGFwdGVycyglMjJpa2VhJTIyKSUwQSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxvcmRqaWElMkZieS1mZW5nLXppa2FpJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJmZW5nemlrYWlfdjEuMF9YTC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmZlbmclMjIpJTBBcGlwZWxpbmUuc2V0X2FkYXB0ZXJzKGFkYXB0ZXJfbmFtZXMlM0QlMjJmZW5nJTIyKSUwQSUwQWZlbmdfcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKCUwQSUyMCUyMCUyMCUyMHNkeGxfdW5ldCUyQyUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnVuZXQucGVmdF9jb25maWclNUIlMjJmZW5nJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIyZmVuZyUyMiUwQSklMEElMEFvcmlnaW5hbF9zdGF0ZV9kaWN0JTIwJTNEJTIwJTdCZiUyMmJhc2VfbW9kZWwubW9kZWwuJTdCayU3RCUyMiUzQSUyMHYlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwcGlwZS51bmV0LnN0YXRlX2RpY3QoKS5pdGVtcygpJTdEJTBBZmVuZ19wZWZ0X21vZGVsLmxvYWRfc3RhdGVfZGljdChvcmlnaW5hbF9zdGF0ZV9kaWN0JTJDJTIwc3RyaWN0JTNEVHJ1ZSk=",highlighted:`pipeline.delete_adapters(<span class="hljs-string">&quot;ikea&quot;</span>)
sdxl_unet.delete_adapters(<span class="hljs-string">&quot;ikea&quot;</span>)

pipeline.load_lora_weights(<span class="hljs-string">&quot;lordjia/by-feng-zikai&quot;</span>, weight_name=<span class="hljs-string">&quot;fengzikai_v1.0_XL.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;feng&quot;</span>)
pipeline.set_adapters(adapter_names=<span class="hljs-string">&quot;feng&quot;</span>)

feng_peft_model = get_peft_model(
    sdxl_unet,
    pipeline.unet.peft_config[<span class="hljs-string">&quot;feng&quot;</span>],
    adapter_name=<span class="hljs-string">&quot;feng&quot;</span>
)

original_state_dict = {<span class="hljs-string">f&quot;base_model.model.<span class="hljs-subst">{k}</span>&quot;</span>: v <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> pipe.unet.state_dict().items()}
feng_peft_model.load_state_dict(original_state_dict, strict=<span class="hljs-literal">True</span>)`,wrap:!1}}),D=new y({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX3VuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV91bmV0JTJDJTIwJTIyc3RldmhsaXUlMkZpa2VhX3BlZnRfbW9kZWwlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTIwc3ViZm9sZGVyJTNEJTIyaWtlYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmlrZWElMjIpJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMnN0ZXZobGl1JTJGZmVuZ19wZWZ0X21vZGVsJTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUyMHN1YmZvbGRlciUzRCUyMmZlbmclMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJmZW5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16, 
    use_safetensors=<span class="hljs-literal">True</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    subfolder=<span class="hljs-string">&quot;unet&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

model = PeftModel.from_pretrained(base_unet, <span class="hljs-string">&quot;stevhliu/ikea_peft_model&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>, subfolder=<span class="hljs-string">&quot;ikea&quot;</span>, adapter_name=<span class="hljs-string">&quot;ikea&quot;</span>)
model.load_adapter(<span class="hljs-string">&quot;stevhliu/feng_peft_model&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>, subfolder=<span class="hljs-string">&quot;feng&quot;</span>, adapter_name=<span class="hljs-string">&quot;feng&quot;</span>)`,wrap:!1}}),_=new Tt({props:{warning:!0,$$slots:{default:[ps]},$$scope:{ctx:b}}}),P=new y({props:{code:"bW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJpa2VhJTIyJTJDJTIwJTIyZmVuZyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodHMlM0QlNUIxLjAlMkMlMjAxLjAlNUQlMkMlMEElMjAlMjAlMjAlMjBjb21iaW5hdGlvbl90eXBlJTNEJTIyZGFyZV9saW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBhZGFwdGVyX25hbWUlM0QlMjJpa2VhLWZlbmclMjIlMEEpJTBBbW9kZWwuc2V0X2FkYXB0ZXJzKCUyMmlrZWEtZmVuZyUyMik=",highlighted:`model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;ikea&quot;</span>, <span class="hljs-string">&quot;feng&quot;</span>],
    weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">1.0</span>],
    combination_type=<span class="hljs-string">&quot;dare_linear&quot;</span>,
    adapter_name=<span class="hljs-string">&quot;ikea-feng&quot;</span>
)
model.set_adapters(<span class="hljs-string">&quot;ikea-feng&quot;</span>)`,wrap:!1}}),O=new y({props:{code:"bW9kZWwlMjAlM0QlMjBtb2RlbC50byhkdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHVuZXQlM0Rtb2RlbCUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTIyQSUyMGJvd2wlMjBvZiUyMHJhbWVuJTIwc2hhcGVkJTIwbGlrZSUyMGElMjBjdXRlJTIwa2F3YWlpJTIwYmVhciUyQyUyMGJ5JTIwRmVuZyUyMFppa2FpJTIyJTJDJTIwZ2VuZXJhdG9yJTNEdG9yY2gubWFudWFsX3NlZWQoMCkpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`model = model.to(dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=model, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(<span class="hljs-string">&quot;A bowl of ramen shaped like a cute kawaii bear, by Feng Zikai&quot;</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ee=new be({props:{title:"fuse_lora",local:"fuselora",headingTag:"h2"}}),ae=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTIyb3N0cmlzJTJGaWtlYS1pbnN0cnVjdGlvbnMtbG9yYS1zZHhsJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpa2VhX2luc3RydWN0aW9uc194bF92MV81LnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyaWtlYSUyMiklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJsb3JkamlhJTJGYnktZmVuZy16aWthaSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyZmVuZ3ppa2FpX3YxLjBfWEwuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJmZW5nJTIyKSUwQSUwQXBpcGVsaW5lLnNldF9hZGFwdGVycyglNUIlMjJpa2VhJTIyJTJDJTIwJTIyZmVuZyUyMiU1RCUyQyUyMGFkYXB0ZXJfd2VpZ2h0cyUzRCU1QjAuNyUyQyUyMDAuOCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;ostris/ikea-instructions-lora-sdxl&quot;</span>, weight_name=<span class="hljs-string">&quot;ikea_instructions_xl_v1_5.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;ikea&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;lordjia/by-feng-zikai&quot;</span>, weight_name=<span class="hljs-string">&quot;fengzikai_v1.0_XL.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;feng&quot;</span>)

pipeline.set_adapters([<span class="hljs-string">&quot;ikea&quot;</span>, <span class="hljs-string">&quot;feng&quot;</span>], adapter_weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.8</span>])`,wrap:!1}}),ie=new y({props:{code:"cGlwZWxpbmUuZnVzZV9sb3JhKGFkYXB0ZXJfbmFtZXMlM0QlNUIlMjJpa2VhJTIyJTJDJTIwJTIyZmVuZyUyMiU1RCUyQyUyMGxvcmFfc2NhbGUlM0QxLjAp",highlighted:'pipeline.fuse_lora(adapter_names=[<span class="hljs-string">&quot;ikea&quot;</span>, <span class="hljs-string">&quot;feng&quot;</span>], lora_scale=<span class="hljs-number">1.0</span>)',wrap:!1}}),pe=new y({props:{code:"cGlwZWxpbmUudW5sb2FkX2xvcmFfd2VpZ2h0cygpJTBBJTIzJTIwc2F2ZSUyMGxvY2FsbHklMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIycGF0aCUyRnRvJTJGZnVzZWQtcGlwZWxpbmUlMjIpJTBBJTIzJTIwc2F2ZSUyMHRvJTIwdGhlJTIwSHViJTBBcGlwZWxpbmUucHVzaF90b19odWIoJTIyZnVzZWQtaWtlYS1mZW5nJTIyKQ==",highlighted:`pipeline.unload_lora_weights()
<span class="hljs-comment"># save locally</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;path/to/fused-pipeline&quot;</span>)
<span class="hljs-comment"># save to the Hub</span>
pipeline.push_to_hub(<span class="hljs-string">&quot;fused-ikea-feng&quot;</span>)`,wrap:!1}}),de=new y({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIydXNlcm5hbWUlMkZmdXNlZC1pa2VhLWZlbmclMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJBJTIwYm93bCUyMG9mJTIwcmFtZW4lMjBzaGFwZWQlMjBsaWtlJTIwYSUyMGN1dGUlMjBrYXdhaWklMjBiZWFyJTJDJTIwYnklMjBGZW5nJTIwWmlrYWklMjIlMkMlMjBnZW5lcmF0b3IlM0R0b3JjaC5tYW51YWxfc2VlZCgwKSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;username/fused-ikea-feng&quot;</span>, torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipeline(<span class="hljs-string">&quot;A bowl of ramen shaped like a cute kawaii bear, by Feng Zikai&quot;</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),me=new y({props:{code:"cGlwZWxpbmUudW5mdXNlX2xvcmEoKQ==",highlighted:"pipeline.unfuse_lora()",wrap:!1}}),he=new be({props:{title:"torch.compile",local:"torchcompile",headingTag:"h3"}}),fe=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBsb2FkJTIwYmFzZSUyMG1vZGVsJTIwYW5kJTIwTG9SQXMlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTIyb3N0cmlzJTJGaWtlYS1pbnN0cnVjdGlvbnMtbG9yYS1zZHhsJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpa2VhX2luc3RydWN0aW9uc194bF92MV81LnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyaWtlYSUyMiklMEFwaXBlbGluZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJsb3JkamlhJTJGYnktZmVuZy16aWthaSUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIyZmVuZ3ppa2FpX3YxLjBfWEwuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJmZW5nJTIyKSUwQSUwQSUyMyUyMGFjdGl2YXRlJTIwYm90aCUyMExvUkFzJTIwYW5kJTIwc2V0JTIwYWRhcHRlciUyMHdlaWdodHMlMEFwaXBlbGluZS5zZXRfYWRhcHRlcnMoJTVCJTIyaWtlYSUyMiUyQyUyMCUyMmZlbmclMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjclMkMlMjAwLjglNUQpJTBBJTBBJTIzJTIwZnVzZSUyMExvUkFzJTIwYW5kJTIwdW5sb2FkJTIwd2VpZ2h0cyUwQXBpcGVsaW5lLmZ1c2VfbG9yYShhZGFwdGVyX25hbWVzJTNEJTVCJTIyaWtlYSUyMiUyQyUyMCUyMmZlbmclMjIlNUQlMkMlMjBsb3JhX3NjYWxlJTNEMS4wKSUwQXBpcGVsaW5lLnVubG9hZF9sb3JhX3dlaWdodHMoKSUwQSUwQSUyMyUyMHRvcmNoLmNvbXBpbGUlMEFwaXBlbGluZS51bmV0LnRvKG1lbW9yeV9mb3JtYXQlM0R0b3JjaC5jaGFubmVsc19sYXN0KSUwQXBpcGVsaW5lLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKHBpcGVsaW5lLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkElMjBib3dsJTIwb2YlMjByYW1lbiUyMHNoYXBlZCUyMGxpa2UlMjBhJTIwY3V0ZSUyMGthd2FpaSUyMGJlYXIlMkMlMjBieSUyMEZlbmclMjBaaWthaSUyMiUyQyUyMGdlbmVyYXRvciUzRHRvcmNoLm1hbnVhbF9zZWVkKDApKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load base model and LoRAs</span>
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;ostris/ikea-instructions-lora-sdxl&quot;</span>, weight_name=<span class="hljs-string">&quot;ikea_instructions_xl_v1_5.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;ikea&quot;</span>)
pipeline.load_lora_weights(<span class="hljs-string">&quot;lordjia/by-feng-zikai&quot;</span>, weight_name=<span class="hljs-string">&quot;fengzikai_v1.0_XL.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;feng&quot;</span>)

<span class="hljs-comment"># activate both LoRAs and set adapter weights</span>
pipeline.set_adapters([<span class="hljs-string">&quot;ikea&quot;</span>, <span class="hljs-string">&quot;feng&quot;</span>], adapter_weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.8</span>])

<span class="hljs-comment"># fuse LoRAs and unload weights</span>
pipeline.fuse_lora(adapter_names=[<span class="hljs-string">&quot;ikea&quot;</span>, <span class="hljs-string">&quot;feng&quot;</span>], lora_scale=<span class="hljs-number">1.0</span>)
pipeline.unload_lora_weights()

<span class="hljs-comment"># torch.compile</span>
pipeline.unet.to(memory_format=torch.channels_last)
pipeline.unet = torch.<span class="hljs-built_in">compile</span>(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)

image = pipeline(<span class="hljs-string">&quot;A bowl of ramen shaped like a cute kawaii bear, by Feng Zikai&quot;</span>, generator=torch.manual_seed(<span class="hljs-number">0</span>)).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ye=new be({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){i=o("meta"),J=a(),M=o("p"),w=a(),d(k.$$.fragment),ge=a(),I=o("p"),I.innerHTML=Zt,Ze=a(),G=o("p"),G.innerHTML=Ut,Ue=a(),$=o("p"),$.innerHTML=jt,je=a(),d(v.$$.fragment),_e=a(),d(R.$$.fragment),We=a(),V=o("p"),V.innerHTML=_t,ke=a(),d(C.$$.fragment),Ie=a(),T=o("div"),T.innerHTML=Wt,Ge=a(),d(L.$$.fragment),$e=a(),d(g.$$.fragment),ve=a(),B=o("p"),B.innerHTML=kt,Re=a(),d(q.$$.fragment),Ve=a(),X=o("p"),X.innerHTML=It,Ce=a(),F=o("ol"),F.innerHTML=Gt,Le=a(),Y=o("p"),Y.textContent=$t,Be=a(),N=o("ol"),N.innerHTML=vt,qe=a(),d(x.$$.fragment),Xe=a(),Q=o("p"),Q.innerHTML=Rt,Fe=a(),d(E.$$.fragment),Ye=a(),H=o("p"),H.innerHTML=Vt,Ne=a(),d(S.$$.fragment),xe=a(),d(Z.$$.fragment),Qe=a(),z=o("p"),z.innerHTML=Ct,Ee=a(),d(A.$$.fragment),He=a(),U=o("ol"),U.innerHTML=Lt,Se=a(),d(D.$$.fragment),ze=a(),j=o("ol"),j.innerHTML=Bt,Ae=a(),d(_.$$.fragment),De=a(),d(P.$$.fragment),Pe=a(),K=o("p"),K.textContent=qt,Ke=a(),d(O.$$.fragment),Oe=a(),W=o("div"),W.innerHTML=Xt,et=a(),d(ee.$$.fragment),tt=a(),te=o("p"),te.innerHTML=Ft,st=a(),se=o("p"),se.innerHTML=Yt,lt=a(),le=o("p"),le.textContent=Nt,at=a(),d(ae.$$.fragment),nt=a(),ne=o("p"),ne.innerHTML=xt,it=a(),d(ie.$$.fragment),ot=a(),oe=o("p"),oe.innerHTML=Qt,pt=a(),d(pe.$$.fragment),rt=a(),re=o("p"),re.textContent=Et,dt=a(),d(de.$$.fragment),ut=a(),ue=o("p"),ue.innerHTML=Ht,mt=a(),d(me.$$.fragment),ht=a(),d(he.$$.fragment),ct=a(),ce=o("p"),ce.innerHTML=St,ft=a(),d(fe.$$.fragment),Mt=a(),Me=o("p"),Me.innerHTML=zt,yt=a(),d(ye.$$.fragment),Jt=a(),Je=o("p"),Je.innerHTML=At,wt=a(),Te=o("p"),this.h()},l(e){const t=as("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(s),J=n(e),M=p(e,"P",{}),Ot(M).forEach(s),w=n(e),u(k.$$.fragment,e),ge=n(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-cyt3kz"&&(I.innerHTML=Zt),Ze=n(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-h5ugqk"&&(G.innerHTML=Ut),Ue=n(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-2fe58y"&&($.innerHTML=jt),je=n(e),u(v.$$.fragment,e),_e=n(e),u(R.$$.fragment,e),We=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-wknn7e"&&(V.innerHTML=_t),ke=n(e),u(C.$$.fragment,e),Ie=n(e),T=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-rp1f80"&&(T.innerHTML=Wt),Ge=n(e),u(L.$$.fragment,e),$e=n(e),u(g.$$.fragment,e),ve=n(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-uxirly"&&(B.innerHTML=kt),Re=n(e),u(q.$$.fragment,e),Ve=n(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-la9429"&&(X.innerHTML=It),Ce=n(e),F=p(e,"OL",{"data-svelte-h":!0}),r(F)!=="svelte-4ggjhv"&&(F.innerHTML=Gt),Le=n(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-qks3mn"&&(Y.textContent=$t),Be=n(e),N=p(e,"OL",{"data-svelte-h":!0}),r(N)!=="svelte-143mnwl"&&(N.innerHTML=vt),qe=n(e),u(x.$$.fragment,e),Xe=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-12jcnpd"&&(Q.innerHTML=Rt),Fe=n(e),u(E.$$.fragment,e),Ye=n(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-ptpxmb"&&(H.innerHTML=Vt),Ne=n(e),u(S.$$.fragment,e),xe=n(e),u(Z.$$.fragment,e),Qe=n(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-10g1mo0"&&(z.innerHTML=Ct),Ee=n(e),u(A.$$.fragment,e),He=n(e),U=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-1c06g8d"&&(U.innerHTML=Lt),Se=n(e),u(D.$$.fragment,e),ze=n(e),j=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-1bf4zue"&&(j.innerHTML=Bt),Ae=n(e),u(_.$$.fragment,e),De=n(e),u(P.$$.fragment,e),Pe=n(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-18i0m5d"&&(K.textContent=qt),Ke=n(e),u(O.$$.fragment,e),Oe=n(e),W=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(W)!=="svelte-o7lfk9"&&(W.innerHTML=Xt),et=n(e),u(ee.$$.fragment,e),tt=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-3480ti"&&(te.innerHTML=Ft),st=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-xq693r"&&(se.innerHTML=Yt),lt=n(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-clyzop"&&(le.textContent=Nt),at=n(e),u(ae.$$.fragment,e),nt=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10c8zfg"&&(ne.innerHTML=xt),it=n(e),u(ie.$$.fragment,e),ot=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-q8qhy8"&&(oe.innerHTML=Qt),pt=n(e),u(pe.$$.fragment,e),rt=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1nux4z4"&&(re.textContent=Et),dt=n(e),u(de.$$.fragment,e),ut=n(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1ppt22d"&&(ue.innerHTML=Ht),mt=n(e),u(me.$$.fragment,e),ht=n(e),u(he.$$.fragment,e),ct=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-h1d3ky"&&(ce.innerHTML=St),ft=n(e),u(fe.$$.fragment,e),Mt=n(e),Me=p(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-106h2ac"&&(Me.innerHTML=zt),yt=n(e),u(ye.$$.fragment,e),Jt=n(e),Je=p(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1j7n00j"&&(Je.innerHTML=At),wt=n(e),Te=p(e,"P",{}),Ot(Te).forEach(s),this.h()},h(){we(i,"name","hf:doc:metadata"),we(i,"content",ds),we(T,"class","flex justify-center"),we(U,"start","2"),we(j,"start","3"),we(W,"class","flex justify-center")},m(e,t){ns(document.head,i),l(e,J,t),l(e,M,t),l(e,w,t),m(k,e,t),l(e,ge,t),l(e,I,t),l(e,Ze,t),l(e,G,t),l(e,Ue,t),l(e,$,t),l(e,je,t),m(v,e,t),l(e,_e,t),m(R,e,t),l(e,We,t),l(e,V,t),l(e,ke,t),m(C,e,t),l(e,Ie,t),l(e,T,t),l(e,Ge,t),m(L,e,t),l(e,$e,t),m(g,e,t),l(e,ve,t),l(e,B,t),l(e,Re,t),m(q,e,t),l(e,Ve,t),l(e,X,t),l(e,Ce,t),l(e,F,t),l(e,Le,t),l(e,Y,t),l(e,Be,t),l(e,N,t),l(e,qe,t),m(x,e,t),l(e,Xe,t),l(e,Q,t),l(e,Fe,t),m(E,e,t),l(e,Ye,t),l(e,H,t),l(e,Ne,t),m(S,e,t),l(e,xe,t),m(Z,e,t),l(e,Qe,t),l(e,z,t),l(e,Ee,t),m(A,e,t),l(e,He,t),l(e,U,t),l(e,Se,t),m(D,e,t),l(e,ze,t),l(e,j,t),l(e,Ae,t),m(_,e,t),l(e,De,t),m(P,e,t),l(e,Pe,t),l(e,K,t),l(e,Ke,t),m(O,e,t),l(e,Oe,t),l(e,W,t),l(e,et,t),m(ee,e,t),l(e,tt,t),l(e,te,t),l(e,st,t),l(e,se,t),l(e,lt,t),l(e,le,t),l(e,at,t),m(ae,e,t),l(e,nt,t),l(e,ne,t),l(e,it,t),m(ie,e,t),l(e,ot,t),l(e,oe,t),l(e,pt,t),m(pe,e,t),l(e,rt,t),l(e,re,t),l(e,dt,t),m(de,e,t),l(e,ut,t),l(e,ue,t),l(e,mt,t),m(me,e,t),l(e,ht,t),m(he,e,t),l(e,ct,t),l(e,ce,t),l(e,ft,t),m(fe,e,t),l(e,Mt,t),l(e,Me,t),l(e,yt,t),m(ye,e,t),l(e,Jt,t),l(e,Je,t),l(e,wt,t),l(e,Te,t),bt=!0},p(e,[t]){const Dt={};t&2&&(Dt.$$scope={dirty:t,ctx:e}),g.$set(Dt);const Pt={};t&2&&(Pt.$$scope={dirty:t,ctx:e}),Z.$set(Pt);const Kt={};t&2&&(Kt.$$scope={dirty:t,ctx:e}),_.$set(Kt)},i(e){bt||(h(k.$$.fragment,e),h(v.$$.fragment,e),h(R.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(g.$$.fragment,e),h(q.$$.fragment,e),h(x.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(Z.$$.fragment,e),h(A.$$.fragment,e),h(D.$$.fragment,e),h(_.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(fe.$$.fragment,e),h(ye.$$.fragment,e),bt=!0)},o(e){c(k.$$.fragment,e),c(v.$$.fragment,e),c(R.$$.fragment,e),c(C.$$.fragment,e),c(L.$$.fragment,e),c(g.$$.fragment,e),c(q.$$.fragment,e),c(x.$$.fragment,e),c(E.$$.fragment,e),c(S.$$.fragment,e),c(Z.$$.fragment,e),c(A.$$.fragment,e),c(D.$$.fragment,e),c(_.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(de.$$.fragment,e),c(me.$$.fragment,e),c(he.$$.fragment,e),c(fe.$$.fragment,e),c(ye.$$.fragment,e),bt=!1},d(e){e&&(s(J),s(M),s(w),s(ge),s(I),s(Ze),s(G),s(Ue),s($),s(je),s(_e),s(We),s(V),s(ke),s(Ie),s(T),s(Ge),s($e),s(ve),s(B),s(Re),s(Ve),s(X),s(Ce),s(F),s(Le),s(Y),s(Be),s(N),s(qe),s(Xe),s(Q),s(Fe),s(Ye),s(H),s(Ne),s(xe),s(Qe),s(z),s(Ee),s(He),s(U),s(Se),s(ze),s(j),s(Ae),s(De),s(Pe),s(K),s(Ke),s(Oe),s(W),s(et),s(tt),s(te),s(st),s(se),s(lt),s(le),s(at),s(nt),s(ne),s(it),s(ot),s(oe),s(pt),s(rt),s(re),s(dt),s(ut),s(ue),s(mt),s(ht),s(ct),s(ce),s(ft),s(Mt),s(Me),s(yt),s(Jt),s(Je),s(wt),s(Te)),s(i),f(k,e),f(v,e),f(R,e),f(C,e),f(L,e),f(g,e),f(q,e),f(x,e),f(E,e),f(S,e),f(Z,e),f(A,e),f(D,e),f(_,e),f(P,e),f(O,e),f(ee,e),f(ae,e),f(ie,e),f(pe,e),f(de,e),f(me,e),f(he,e),f(fe,e),f(ye,e)}}}const ds='{"title":"Merge LoRAs","local":"merge-loras","sections":[{"title":"set_adapters","local":"setadapters","sections":[],"depth":2},{"title":"add_weighted_adapter","local":"addweightedadapter","sections":[],"depth":2},{"title":"fuse_lora","local":"fuselora","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":3}],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function us(b){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends ss{constructor(i){super(),ls(this,i,us,rs,es,{})}}export{ys as component};
