import{s as he,n as fe,o as Ue}from"../chunks/scheduler.ca8a8f1f.js";import{S as be,i as je,g as i,s,r as Z,A as Ce,h as o,f as l,c as n,j as Je,u as A,x as p,k as we,y as _e,a,v as B,d as W,t as k,w as g}from"../chunks/index.ace09054.js";import{C as se}from"../chunks/CodeBlock.da34cb7d.js";import{H as ae}from"../chunks/Heading.bda300ec.js";function Ie(ne){let d,x,G,$,M,R,m,ie=`Let’s cover in this section how you can leverage PEFT’s low level API to inject trainable adapters into any <code>torch</code> module.
The development of this API has been motivated by the need for super users to not rely on modeling classes that are exposed in PEFT library and still be able to use adapter methods such as LoRA, IA3 and AdaLoRA.`,v,r,Q,u,oe='Currently the supported adapter types are the ‘injectable’ adapters, meaning adapters where an inplace modification of the model is sufficient to correctly perform the fine tuning. As such, only <a href="../conceptual_guides/lora">LoRA</a>, AdaLoRA and <a href="../conceptual_guides/ia3">IA3</a> are currently supported in this API.',X,y,H,c,pe="To perform the adapter injection, simply use <code>inject_adapter_in_model</code> method that takes 3 arguments, the PEFT config and the model itself and an optional adapter name. You can also attach multiple adapters in the model if you call multiple times <code>inject_adapter_in_model</code> with different adapter names.",Y,T,de="Below is a basic example usage of how to inject LoRA adapters into the submodule <code>linear</code> of the module <code>DummyModel</code>.",F,J,S,w,Me="If you print the model, you will notice that the adapters have been correctly injected into the model",N,h,L,f,me=`Note that it should be up to users to properly take care of saving the adapters (in case they want to save adapters only), as <code>model.state_dict()</code> will return the full state dict of the model.
In case you want to extract the adapters state dict you can use the <code>get_peft_model_state_dict</code> method:`,z,U,D,b,P,j,re="When to use this API and when to not use it? Let’s discuss in this section the pros and cons",K,C,ue="Pros:",q,_,ye="<li>The model gets modified in-place, meaning the model will preserve all its original attributes and methods</li> <li>Works for any torch module, and any modality (vision, text, multi-modal)</li>",O,I,ce="Cons:",ee,E,Te="<li>You need to manually writing Hugging Face <code>from_pretrained</code> and <code>save_pretrained</code> utility methods if you want to easily save / load adapters from the Hugging Face Hub.</li> <li>You cannot use any of the utility method provided by <code>PeftModel</code> such as disabling adapters, merging adapters, etc.</li>",te,V,le;return M=new ae({props:{title:"PEFT as a utility library",local:"peft-as-a-utility-library",headingTag:"h1"}}),r=new ae({props:{title:"Supported tuner types",local:"supported-tuner-types",headingTag:"h2"}}),y=new ae({props:{title:"inject_adapter_in_model method",local:"injectadapterinmodel-method",headingTag:"h2"}}),J=new se({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMGluamVjdF9hZGFwdGVyX2luX21vZGVsJTJDJTIwTG9yYUNvbmZpZyUwQSUwQSUwQWNsYXNzJTIwRHVtbXlNb2RlbCh0b3JjaC5ubi5Nb2R1bGUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmVtYmVkZGluZyUyMCUzRCUyMHRvcmNoLm5uLkVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGluZWFyJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5sbV9oZWFkJTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDEwJTJDJTIwMTApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwaW5wdXRfaWRzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHglMjAlM0QlMjBzZWxmLmVtYmVkZGluZyhpbnB1dF9pZHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubGluZWFyKHgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweCUyMCUzRCUyMHNlbGYubG1faGVhZCh4KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHglMEElMEElMEFsb3JhX2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwciUzRDY0JTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMm5vbmUlMjIlMkMlMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCU1QiUyMmxpbmVhciUyMiU1RCUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMER1bW15TW9kZWwoKSUwQW1vZGVsJTIwJTNEJTIwaW5qZWN0X2FkYXB0ZXJfaW5fbW9kZWwobG9yYV9jb25maWclMkMlMjBtb2RlbCklMEElMEFkdW1teV9pbnB1dHMlMjAlM0QlMjB0b3JjaC5Mb25nVGVuc29yKCU1QiU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlMkMlMjA0JTJDJTIwNSUyQyUyMDYlMkMlMjA3JTVEJTVEKSUwQWR1bW15X291dHB1dHMlMjAlM0QlMjBtb2RlbChkdW1teV9pbnB1dHMp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> inject_adapter_in_model, LoraConfig


<span class="hljs-keyword">class</span> <span class="hljs-title class_">DummyModel</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.embedding = torch.nn.Embedding(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.linear = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.lm_head = torch.nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, input_ids</span>):
        x = self.embedding(input_ids)
        x = self.linear(x)
        x = self.lm_head(x)
        <span class="hljs-keyword">return</span> x


lora_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    target_modules=[<span class="hljs-string">&quot;linear&quot;</span>],
)

model = DummyModel()
model = inject_adapter_in_model(lora_config, model)

dummy_inputs = torch.LongTensor([[<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>]])
dummy_outputs = model(dummy_inputs)`,wrap:!1}}),h=new se({props:{code:"RHVtbXlNb2RlbCglMEElMjAlMjAoZW1iZWRkaW5nKSUzQSUyMEVtYmVkZGluZygxMCUyQyUyMDEwKSUwQSUyMCUyMChsaW5lYXIpJTNBJTIwTGluZWFyKCUwQSUyMCUyMCUyMCUyMGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlJTBBJTIwJTIwJTIwJTIwKGxvcmFfZHJvcG91dCklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMERyb3BvdXQocCUzRDAuMSUyQyUyMGlucGxhY2UlM0RGYWxzZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwKGxvcmFfQSklM0ElMjBNb2R1bGVEaWN0KCUwQSUyMCUyMCUyMCUyMCUyMCUyMChkZWZhdWx0KSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNENjQlMkMlMjBiaWFzJTNERmFsc2UpJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMChsb3JhX0IpJTNBJTIwTW9kdWxlRGljdCglMEElMjAlMjAlMjAlMjAlMjAlMjAoZGVmYXVsdCklM0ElMjBMaW5lYXIoaW5fZmVhdHVyZXMlM0Q2NCUyQyUyMG91dF9mZWF0dXJlcyUzRDEwJTJDJTIwYmlhcyUzREZhbHNlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQSklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjAlMjAlMjAobG9yYV9lbWJlZGRpbmdfQiklM0ElMjBQYXJhbWV0ZXJEaWN0KCklMEElMjAlMjApJTBBJTIwJTIwKGxtX2hlYWQpJTNBJTIwTGluZWFyKGluX2ZlYXR1cmVzJTNEMTAlMkMlMjBvdXRfZmVhdHVyZXMlM0QxMCUyQyUyMGJpYXMlM0RUcnVlKSUwQSk=",highlighted:`DummyModel(
  (embedding): Embedding(10, 10)
  (linear): Linear(
    in_features=10, out_features=10, bias=True
    (lora_dropout): ModuleDict(
      (default): Dropout(p=0.1, inplace=False)
    )
    (lora_A): ModuleDict(
      (default): Linear(in_features=10, out_features=64, bias=False)
    )
    (lora_B): ModuleDict(
      (default): Linear(in_features=64, out_features=10, bias=False)
    )
    (lora_embedding_A): ParameterDict()
    (lora_embedding_B): ParameterDict()
  )
  (lm_head): Linear(in_features=10, out_features=10, bias=True)
)`,wrap:!1}}),U=new se({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbF9zdGF0ZV9kaWN0JTBBJTBBcGVmdF9zdGF0ZV9kaWN0JTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWxfc3RhdGVfZGljdChtb2RlbCklMEFwcmludChwZWZ0X3N0YXRlX2RpY3Qp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model_state_dict

peft_state_dict = get_peft_model_state_dict(model)
<span class="hljs-built_in">print</span>(peft_state_dict)`,wrap:!1}}),b=new ae({props:{title:"Pros and cons",local:"pros-and-cons",headingTag:"h2"}}),{c(){d=i("meta"),x=s(),G=i("p"),$=s(),Z(M.$$.fragment),R=s(),m=i("p"),m.innerHTML=ie,v=s(),Z(r.$$.fragment),Q=s(),u=i("p"),u.innerHTML=oe,X=s(),Z(y.$$.fragment),H=s(),c=i("p"),c.innerHTML=pe,Y=s(),T=i("p"),T.innerHTML=de,F=s(),Z(J.$$.fragment),S=s(),w=i("p"),w.textContent=Me,N=s(),Z(h.$$.fragment),L=s(),f=i("p"),f.innerHTML=me,z=s(),Z(U.$$.fragment),D=s(),Z(b.$$.fragment),P=s(),j=i("p"),j.textContent=re,K=s(),C=i("p"),C.textContent=ue,q=s(),_=i("ul"),_.innerHTML=ye,O=s(),I=i("p"),I.textContent=ce,ee=s(),E=i("ul"),E.innerHTML=Te,te=s(),V=i("p"),this.h()},l(e){const t=Ce("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(l),x=n(e),G=o(e,"P",{}),Je(G).forEach(l),$=n(e),A(M.$$.fragment,e),R=n(e),m=o(e,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1yzqkjc"&&(m.innerHTML=ie),v=n(e),A(r.$$.fragment,e),Q=n(e),u=o(e,"P",{"data-svelte-h":!0}),p(u)!=="svelte-lhezic"&&(u.innerHTML=oe),X=n(e),A(y.$$.fragment,e),H=n(e),c=o(e,"P",{"data-svelte-h":!0}),p(c)!=="svelte-1r7k4xb"&&(c.innerHTML=pe),Y=n(e),T=o(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-1x7rohp"&&(T.innerHTML=de),F=n(e),A(J.$$.fragment,e),S=n(e),w=o(e,"P",{"data-svelte-h":!0}),p(w)!=="svelte-7eskz"&&(w.textContent=Me),N=n(e),A(h.$$.fragment,e),L=n(e),f=o(e,"P",{"data-svelte-h":!0}),p(f)!=="svelte-1wq28ej"&&(f.innerHTML=me),z=n(e),A(U.$$.fragment,e),D=n(e),A(b.$$.fragment,e),P=n(e),j=o(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-e83v3i"&&(j.textContent=re),K=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-nbbe2"&&(C.textContent=ue),q=n(e),_=o(e,"UL",{"data-svelte-h":!0}),p(_)!=="svelte-1d2920g"&&(_.innerHTML=ye),O=n(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-domxx"&&(I.textContent=ce),ee=n(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-2uvcyl"&&(E.innerHTML=Te),te=n(e),V=o(e,"P",{}),Je(V).forEach(l),this.h()},h(){we(d,"name","hf:doc:metadata"),we(d,"content",Ee)},m(e,t){_e(document.head,d),a(e,x,t),a(e,G,t),a(e,$,t),B(M,e,t),a(e,R,t),a(e,m,t),a(e,v,t),B(r,e,t),a(e,Q,t),a(e,u,t),a(e,X,t),B(y,e,t),a(e,H,t),a(e,c,t),a(e,Y,t),a(e,T,t),a(e,F,t),B(J,e,t),a(e,S,t),a(e,w,t),a(e,N,t),B(h,e,t),a(e,L,t),a(e,f,t),a(e,z,t),B(U,e,t),a(e,D,t),B(b,e,t),a(e,P,t),a(e,j,t),a(e,K,t),a(e,C,t),a(e,q,t),a(e,_,t),a(e,O,t),a(e,I,t),a(e,ee,t),a(e,E,t),a(e,te,t),a(e,V,t),le=!0},p:fe,i(e){le||(W(M.$$.fragment,e),W(r.$$.fragment,e),W(y.$$.fragment,e),W(J.$$.fragment,e),W(h.$$.fragment,e),W(U.$$.fragment,e),W(b.$$.fragment,e),le=!0)},o(e){k(M.$$.fragment,e),k(r.$$.fragment,e),k(y.$$.fragment,e),k(J.$$.fragment,e),k(h.$$.fragment,e),k(U.$$.fragment,e),k(b.$$.fragment,e),le=!1},d(e){e&&(l(x),l(G),l($),l(R),l(m),l(v),l(Q),l(u),l(X),l(H),l(c),l(Y),l(T),l(F),l(S),l(w),l(N),l(L),l(f),l(z),l(D),l(P),l(j),l(K),l(C),l(q),l(_),l(O),l(I),l(ee),l(E),l(te),l(V)),l(d),g(M,e),g(r,e),g(y,e),g(J,e),g(h,e),g(U,e),g(b,e)}}}const Ee='{"title":"PEFT as a utility library","local":"peft-as-a-utility-library","sections":[{"title":"Supported tuner types","local":"supported-tuner-types","sections":[],"depth":2},{"title":"inject_adapter_in_model method","local":"injectadapterinmodel-method","sections":[],"depth":2},{"title":"Pros and cons","local":"pros-and-cons","sections":[],"depth":2}],"depth":1}';function Ze(ne){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ge extends be{constructor(d){super(),je(this,d,Ze,Ie,he,{})}}export{ge as component};
