import{s as mt,n as yt,o as ft}from"../chunks/scheduler.9680c161.js";import{S as Tt,i as gt,g as i,s as a,r as c,A as wt,h as o,f as n,c as s,j as dt,u as p,x as r,k as ae,y as Ut,a as l,v as h,d as u,t as M,w as d}from"../chunks/index.38d74ee1.js";import{C as m}from"../chunks/CodeBlock.1371964c.js";import{H as te,E as Jt}from"../chunks/EditOnGithub.1c840068.js";function bt(Le){let y,se,ne,ie,w,oe,U,Fe="There are many ways you can consume Text Generation Inference server in your applications. After launching, you can use the <code>/generate</code> route and make a <code>POST</code> request to get results from the server. You can also use the <code>/generate_stream</code> route if you want TGI to return a stream of tokens. You can make the requests using the tool of your preference, such as curl, Python or TypeScrpt. For a final end-to-end experience, we also open-sourced ChatUI, a chat interface for open-source models.",re,J,ce,b,qe="After the launch, you can query the model using either the <code>/generate</code> or <code>/generate_stream</code> routes:",pe,I,he,C,ue,j,Pe=`<a href="https://huggingface.co/docs/huggingface_hub/main/en/index" rel="nofollow"><code>huggingface-hub</code></a> is a Python library to interact with the Hugging Face Hub, including its endpoints. It provides a nice high-level class, [<code>~huggingface_hub.InferenceClient</code>], which makes it easy to make calls to a TGI endpoint. <code>InferenceClient</code> also takes care of parameter validation and provides a simple to-use interface.
You can simply install <code>huggingface-hub</code> package with pip.`,Me,$,de,G,Ae="Once you start the TGI server, instantiate <code>InferenceClient()</code> with the URL to the endpoint serving the model. You can then call <code>text_generation()</code> to hit the endpoint through Python.",me,k,ye,Z,De="You can do streaming with <code>InferenceClient</code> by passing <code>stream=True</code>. Streaming will return tokens as they are being generated in the server. To use streaming, you can do as follows:",fe,v,Te,x,Ke="Another parameter you can use with TGI backend is <code>details</code>. You can get more details on generation (tokens, probabilities, etc.) by setting <code>details</code> to <code>True</code>. When it’s specified, TGI will return a <code>TextGenerationResponse</code> or <code>TextGenerationStreamResponse</code> rather than a string or stream.",ge,R,we,W,Oe="You can see how to stream below.",Ue,H,Je,_,et='You can check out the details of the function <a href="https://huggingface.co/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation" rel="nofollow">here</a>. There is also an async version of the client, <code>AsyncInferenceClient</code>, based on <code>asyncio</code> and <code>aiohttp</code>. You can find docs for it <a href="https://huggingface.co/docs/huggingface_hub/package_reference/inference_client#huggingface_hub.AsyncInferenceClient" rel="nofollow">here</a>',be,B,Ie,V,tt='ChatUI is an open-source interface built for LLM serving. It offers many customization options, such as web search with SERP API and more. ChatUI can automatically consume the TGI server and even provides an option to switch between different TGI endpoints. You can try it out at <a href="https://huggingface.co/chat/" rel="nofollow">Hugging Chat</a>, or use the <a href="https://huggingface.co/new-space?template=huggingchat/chat-ui-template" rel="nofollow">ChatUI Docker Space</a> to deploy your own Hugging Chat to Spaces.',Ce,Q,nt="To serve both ChatUI and TGI in same environment, simply add your own endpoints to the <code>MODELS</code> variable in <code>.env.local</code> file inside the <code>chat-ui</code> repository. Provide the endpoints pointing to where TGI is served.",je,Y,$e,N,lt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/chatui_screen.png" alt="ChatUI"/>',Ge,z,ke,X,at="Gradio is a Python library that helps you build web applications for your machine learning models with a few lines of code. It has a <code>ChatInterface</code> wrapper that helps create neat UIs for chatbots. Let’s take a look at how to create a chatbot with streaming mode using TGI and Gradio. Let’s install Gradio and Hub Python library first.",Ze,S,ve,E,st='Assume you are serving your model on port 8080, we will query through <a href="consuming_tgi#inference-client">InferenceClient</a>.',xe,L,Re,F,it="The UI looks like this 👇",We,f,ot='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/gradio-tgi.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/tgi/gradio-tgi-dark.png"/>',He,q,rt="You can try the demo directly here 👇",_e,T,ct='<iframe src="https://merve-gradio-tgi-2.hf.space?__theme=light" width="850" height="750"></iframe>',Be,g,pt='<iframe src="https://merve-gradio-tgi-2.hf.space?__theme=dark" width="850" height="750"></iframe>',Ve,P,ht="You can disable streaming mode using <code>return</code> instead of <code>yield</code> in your inference function, like below.",Qe,A,Ye,D,ut='You can read more about how to customize a <code>ChatInterface</code> <a href="https://www.gradio.app/guides/creating-a-chatbot-fast" rel="nofollow">here</a>.',Ne,K,ze,O,Mt='You can consult the OpenAPI documentation of the <code>text-generation-inference</code> REST API using the <code>/docs</code> route. The Swagger UI is also available <a href="https://huggingface.github.io/text-generation-inference" rel="nofollow">here</a>.',Xe,ee,Se,le,Ee;return w=new te({props:{title:"Consuming Text Generation Inference",local:"consuming-text-generation-inference",headingTag:"h1"}}),J=new te({props:{title:"curl",local:"curl",headingTag:"h2"}}),I=new m({props:{code:"Y3VybCUyMDEyNy4wLjAuMSUzQTgwODAlMkZnZW5lcmF0ZSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMldoYXQlMjBpcyUyMERlZXAlMjBMZWFybmluZyUzRiUyMiUyQyUyMnBhcmFtZXRlcnMlMjIlM0ElN0IlMjJtYXhfbmV3X3Rva2VucyUyMiUzQTIwJTdEJTdEJyUyMCU1QyUwQSUyMCUyMCUyMCUyMC1IJTIwJ0NvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbic=",highlighted:`curl 127.0.0.1:8080/generate \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{&quot;inputs&quot;:&quot;What is Deep Learning?&quot;,&quot;parameters&quot;:{&quot;max_new_tokens&quot;:20}}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>`,wrap:!1}}),C=new te({props:{title:"Inference Client",local:"inference-client",headingTag:"h2"}}),$=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlLWh1Yg==",highlighted:"pip install huggingface-hub",wrap:!1}}),k=new m({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0E4MDgwJTIyKSUwQWNsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTNEJTIyV3JpdGUlMjBhJTIwY29kZSUyMGZvciUyMHNuYWtlJTIwZ2FtZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(model=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)
client.text_generation(prompt=<span class="hljs-string">&quot;Write a code for snake game&quot;</span>)`,wrap:!1}}),v=new m({props:{code:"Zm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTIySG93JTIwZG8lMjB5b3UlMjBtYWtlJTIwY2hlZXNlJTNGJTIyJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMiUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(<span class="hljs-string">&quot;How do you make cheese?&quot;</span>, max_new_tokens=<span class="hljs-number">12</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)`,wrap:!1}}),R=new m({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihwcm9tcHQlM0QlMjJNZWFuaW5nJTIwb2YlMjBsaWZlJTIwaXMlMjIlMkMlMjBkZXRhaWxzJTNEVHJ1ZSklMEFwcmludChvdXRwdXQpJTBBJTBBJTIzJTIwVGV4dEdlbmVyYXRpb25SZXNwb25zZShnZW5lcmF0ZWRfdGV4dCUzRCclMjBhJTIwY29tcGxleCUyMGNvbmNlcHQlMjB0aGF0JTIwaXMlMjBub3QlMjBhbHdheXMlMjBjbGVhciUyMHRvJTIwdGhlJTIwaW5kaXZpZHVhbC4lMjBJdCUyMGlzJTIwYSUyMGNvbmNlcHQlMjB0aGF0JTIwaXMlMjBub3QlMjBhbHdheXMnJTJDJTIwZGV0YWlscyUzRERldGFpbHMoZmluaXNoX3JlYXNvbiUzRCUzQ0ZpbmlzaFJlYXNvbi5MZW5ndGglM0ElMjAnbGVuZ3RoJyUzRSUyQyUyMGdlbmVyYXRlZF90b2tlbnMlM0QyMCUyQyUyMHNlZWQlM0ROb25lJTJDJTIwcHJlZmlsbCUzRCU1QiU1RCUyQyUyMHRva2VucyUzRCU1QlRva2VuKGlkJTNEMjY3JTJDJTIwdGV4dCUzRCclMjBhJyUyQyUyMGxvZ3Byb2IlM0QtMi4wNzIzNDc0JTJDJTIwc3BlY2lhbCUzREZhbHNlKSUyQyUyMFRva2VuKGlkJTNEMTEyMzUlMkMlMjB0ZXh0JTNEJyUyMGNvbXBsZXgnJTJDJTIwbG9ncHJvYiUzRC0zLjEyNzI1NTIlMkMlMjBzcGVjaWFsJTNERmFsc2UpJTJDJTIwVG9rZW4oaWQlM0QxNzkwOCUyQyUyMHRleHQlM0QnJTIwY29uY2VwdCclMkMlMjBsb2dwcm9iJTNELTEuMzYzMjQ5NSUyQyUyMHNwZWNpYWwlM0RGYWxzZSklMkMuLikp",highlighted:`output = client.text_generation(prompt=<span class="hljs-string">&quot;Meaning of life is&quot;</span>, details=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(output)

<span class="hljs-comment"># TextGenerationResponse(generated_text=&#x27; a complex concept that is not always clear to the individual. It is a concept that is not always&#x27;, details=Details(finish_reason=&lt;FinishReason.Length: &#x27;length&#x27;&gt;, generated_tokens=20, seed=None, prefill=[], tokens=[Token(id=267, text=&#x27; a&#x27;, logprob=-2.0723474, special=False), Token(id=11235, text=&#x27; complex&#x27;, logprob=-3.1272552, special=False), Token(id=17908, text=&#x27; concept&#x27;, logprob=-1.3632495, special=False),..))</span>`,wrap:!1}}),H=new m({props:{code:"b3V0cHV0JTIwJTNEJTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbihwcm9tcHQlM0QlMjJNZWFuaW5nJTIwb2YlMjBsaWZlJTIwaXMlMjIlMkMlMjBzdHJlYW0lM0RUcnVlJTJDJTIwZGV0YWlscyUzRFRydWUpJTBBcHJpbnQobmV4dChpdGVyKG91dHB1dCkpKSUwQSUwQSUyMyUyMFRleHRHZW5lcmF0aW9uU3RyZWFtUmVzcG9uc2UodG9rZW4lM0RUb2tlbihpZCUzRDI2NyUyQyUyMHRleHQlM0QnJTIwYSclMkMlMjBsb2dwcm9iJTNELTIuMDcyMzQ3NCUyQyUyMHNwZWNpYWwlM0RGYWxzZSklMkMlMjBnZW5lcmF0ZWRfdGV4dCUzRE5vbmUlMkMlMjBkZXRhaWxzJTNETm9uZSk=",highlighted:`output = client.text_generation(prompt=<span class="hljs-string">&quot;Meaning of life is&quot;</span>, stream=<span class="hljs-literal">True</span>, details=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(output)))

<span class="hljs-comment"># TextGenerationStreamResponse(token=Token(id=267, text=&#x27; a&#x27;, logprob=-2.0723474, special=False), generated_text=None, details=None)</span>`,wrap:!1}}),B=new te({props:{title:"ChatUI",local:"chatui",headingTag:"h2"}}),Y=new m({props:{code:"JTdCJTBBJTJGJTJGJTIwcmVzdCUyMG9mJTIwdGhlJTIwbW9kZWwlMjBjb25maWclMjBoZXJlJTBBJTIyZW5kcG9pbnRzJTIyJTNBJTIwJTVCJTdCJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZIT1NUJTNBUE9SVCUyRmdlbmVyYXRlX3N0cmVhbSUyMiU3RCU1RCUwQSU3RA==",highlighted:`{
<span class="hljs-comment">// rest of the model config here</span>
<span class="hljs-string">&quot;endpoints&quot;</span>: <span class="hljs-selector-attr">[{<span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://HOST:PORT/generate_stream&quot;</span>}]</span>
}`,wrap:!1}}),z=new te({props:{title:"Gradio",local:"gradio",headingTag:"h2"}}),S=new m({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlLWh1YiUyMGdyYWRpbw==",highlighted:"pip install huggingface-hub gradio",wrap:!1}}),L=new m({props:{code:"aW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnQlMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQobW9kZWwlM0QlMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBODA4MCUyMiklMEElMEFkZWYlMjBpbmZlcmVuY2UobWVzc2FnZSUyQyUyMGhpc3RvcnkpJTNBJTBBJTIwJTIwJTIwJTIwcGFydGlhbF9tZXNzYWdlJTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24obWVzc2FnZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcnRpYWxfbWVzc2FnZSUyMCUyQiUzRCUyMHRva2VuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweWllbGQlMjBwYXJ0aWFsX21lc3NhZ2UlMEElMEFnci5DaGF0SW50ZXJmYWNlKCUwQSUyMCUyMCUyMCUyMGluZmVyZW5jZSUyQyUwQSUyMCUyMCUyMCUyMGNoYXRib3QlM0Rnci5DaGF0Ym90KGhlaWdodCUzRDMwMCklMkMlMEElMjAlMjAlMjAlMjB0ZXh0Ym94JTNEZ3IuVGV4dGJveChwbGFjZWhvbGRlciUzRCUyMkNoYXQlMjB3aXRoJTIwbWUhJTIyJTJDJTIwY29udGFpbmVyJTNERmFsc2UlMkMlMjBzY2FsZSUzRDcpJTJDJTBBJTIwJTIwJTIwJTIwZGVzY3JpcHRpb24lM0QlMjJUaGlzJTIwaXMlMjB0aGUlMjBkZW1vJTIwZm9yJTIwR3JhZGlvJTIwVUklMjBjb25zdW1pbmclMjBUR0klMjBlbmRwb2ludCUyMHdpdGglMjBMTGFNQSUyMDdCLUNoYXQlMjBtb2RlbC4lMjIlMkMlMEElMjAlMjAlMjAlMjB0aXRsZSUzRCUyMkdyYWRpbyUyMCVGMCU5RiVBNCU5RCUyMFRHSSUyMiUyQyUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEJTVCJTIyQXJlJTIwdG9tYXRvZXMlMjB2ZWdldGFibGVzJTNGJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0cnlfYnRuJTNEJTIyUmV0cnklMjIlMkMlMEElMjAlMjAlMjAlMjB1bmRvX2J0biUzRCUyMlVuZG8lMjIlMkMlMEElMjAlMjAlMjAlMjBjbGVhcl9idG4lM0QlMjJDbGVhciUyMiUyQyUwQSkucXVldWUoKS5sYXVuY2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(model=<span class="hljs-string">&quot;http://127.0.0.1:8080&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">inference</span>(<span class="hljs-params">message, history</span>):
    partial_message = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(message, max_new_tokens=<span class="hljs-number">20</span>, stream=<span class="hljs-literal">True</span>):
        partial_message += token
        <span class="hljs-keyword">yield</span> partial_message

gr.ChatInterface(
    inference,
    chatbot=gr.Chatbot(height=<span class="hljs-number">300</span>),
    textbox=gr.Textbox(placeholder=<span class="hljs-string">&quot;Chat with me!&quot;</span>, container=<span class="hljs-literal">False</span>, scale=<span class="hljs-number">7</span>),
    description=<span class="hljs-string">&quot;This is the demo for Gradio UI consuming TGI endpoint with LLaMA 7B-Chat model.&quot;</span>,
    title=<span class="hljs-string">&quot;Gradio 🤝 TGI&quot;</span>,
    examples=[<span class="hljs-string">&quot;Are tomatoes vegetables?&quot;</span>],
    retry_btn=<span class="hljs-string">&quot;Retry&quot;</span>,
    undo_btn=<span class="hljs-string">&quot;Undo&quot;</span>,
    clear_btn=<span class="hljs-string">&quot;Clear&quot;</span>,
).queue().launch()`,wrap:!1}}),A=new m({props:{code:"ZGVmJTIwaW5mZXJlbmNlKG1lc3NhZ2UlMkMlMjBoaXN0b3J5KSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24obWVzc2FnZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">inference</span>(<span class="hljs-params">message, history</span>):
    <span class="hljs-keyword">return</span> client.text_generation(message, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),K=new te({props:{title:"API documentation",local:"api-documentation",headingTag:"h2"}}),ee=new Jt({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/consuming_tgi.md"}}),{c(){y=i("meta"),se=a(),ne=i("p"),ie=a(),c(w.$$.fragment),oe=a(),U=i("p"),U.innerHTML=Fe,re=a(),c(J.$$.fragment),ce=a(),b=i("p"),b.innerHTML=qe,pe=a(),c(I.$$.fragment),he=a(),c(C.$$.fragment),ue=a(),j=i("p"),j.innerHTML=Pe,Me=a(),c($.$$.fragment),de=a(),G=i("p"),G.innerHTML=Ae,me=a(),c(k.$$.fragment),ye=a(),Z=i("p"),Z.innerHTML=De,fe=a(),c(v.$$.fragment),Te=a(),x=i("p"),x.innerHTML=Ke,ge=a(),c(R.$$.fragment),we=a(),W=i("p"),W.textContent=Oe,Ue=a(),c(H.$$.fragment),Je=a(),_=i("p"),_.innerHTML=et,be=a(),c(B.$$.fragment),Ie=a(),V=i("p"),V.innerHTML=tt,Ce=a(),Q=i("p"),Q.innerHTML=nt,je=a(),c(Y.$$.fragment),$e=a(),N=i("p"),N.innerHTML=lt,Ge=a(),c(z.$$.fragment),ke=a(),X=i("p"),X.innerHTML=at,Ze=a(),c(S.$$.fragment),ve=a(),E=i("p"),E.innerHTML=st,xe=a(),c(L.$$.fragment),Re=a(),F=i("p"),F.textContent=it,We=a(),f=i("div"),f.innerHTML=ot,He=a(),q=i("p"),q.textContent=rt,_e=a(),T=i("div"),T.innerHTML=ct,Be=a(),g=i("div"),g.innerHTML=pt,Ve=a(),P=i("p"),P.innerHTML=ht,Qe=a(),c(A.$$.fragment),Ye=a(),D=i("p"),D.innerHTML=ut,Ne=a(),c(K.$$.fragment),ze=a(),O=i("p"),O.innerHTML=Mt,Xe=a(),c(ee.$$.fragment),Se=a(),le=i("p"),this.h()},l(e){const t=wt("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(n),se=s(e),ne=o(e,"P",{}),dt(ne).forEach(n),ie=s(e),p(w.$$.fragment,e),oe=s(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-178rkma"&&(U.innerHTML=Fe),re=s(e),p(J.$$.fragment,e),ce=s(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1dlxhnz"&&(b.innerHTML=qe),pe=s(e),p(I.$$.fragment,e),he=s(e),p(C.$$.fragment,e),ue=s(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1w4ht1w"&&(j.innerHTML=Pe),Me=s(e),p($.$$.fragment,e),de=s(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-nvkyoi"&&(G.innerHTML=Ae),me=s(e),p(k.$$.fragment,e),ye=s(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-38ka24"&&(Z.innerHTML=De),fe=s(e),p(v.$$.fragment,e),Te=s(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-nm4ig7"&&(x.innerHTML=Ke),ge=s(e),p(R.$$.fragment,e),we=s(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1vj3swg"&&(W.textContent=Oe),Ue=s(e),p(H.$$.fragment,e),Je=s(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-fupzbv"&&(_.innerHTML=et),be=s(e),p(B.$$.fragment,e),Ie=s(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-9eaac9"&&(V.innerHTML=tt),Ce=s(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-ll7db"&&(Q.innerHTML=nt),je=s(e),p(Y.$$.fragment,e),$e=s(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-16nfqnk"&&(N.innerHTML=lt),Ge=s(e),p(z.$$.fragment,e),ke=s(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-24oiaj"&&(X.innerHTML=at),Ze=s(e),p(S.$$.fragment,e),ve=s(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-4m25xv"&&(E.innerHTML=st),xe=s(e),p(L.$$.fragment,e),Re=s(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-ysfgve"&&(F.textContent=it),We=s(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(f)!=="svelte-1navfwx"&&(f.innerHTML=ot),He=s(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-9o7oqq"&&(q.textContent=rt),_e=s(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-eisylj"&&(T.innerHTML=ct),Be=s(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-diccf8"&&(g.innerHTML=pt),Ve=s(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-ha9nch"&&(P.innerHTML=ht),Qe=s(e),p(A.$$.fragment,e),Ye=s(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-6b9edz"&&(D.innerHTML=ut),Ne=s(e),p(K.$$.fragment,e),ze=s(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-3jzlxn"&&(O.innerHTML=Mt),Xe=s(e),p(ee.$$.fragment,e),Se=s(e),le=o(e,"P",{}),dt(le).forEach(n),this.h()},h(){ae(y,"name","hf:doc:metadata"),ae(y,"content",It),ae(f,"class","flex justify-center"),ae(T,"class","block dark:hidden"),ae(g,"class","hidden dark:block")},m(e,t){Ut(document.head,y),l(e,se,t),l(e,ne,t),l(e,ie,t),h(w,e,t),l(e,oe,t),l(e,U,t),l(e,re,t),h(J,e,t),l(e,ce,t),l(e,b,t),l(e,pe,t),h(I,e,t),l(e,he,t),h(C,e,t),l(e,ue,t),l(e,j,t),l(e,Me,t),h($,e,t),l(e,de,t),l(e,G,t),l(e,me,t),h(k,e,t),l(e,ye,t),l(e,Z,t),l(e,fe,t),h(v,e,t),l(e,Te,t),l(e,x,t),l(e,ge,t),h(R,e,t),l(e,we,t),l(e,W,t),l(e,Ue,t),h(H,e,t),l(e,Je,t),l(e,_,t),l(e,be,t),h(B,e,t),l(e,Ie,t),l(e,V,t),l(e,Ce,t),l(e,Q,t),l(e,je,t),h(Y,e,t),l(e,$e,t),l(e,N,t),l(e,Ge,t),h(z,e,t),l(e,ke,t),l(e,X,t),l(e,Ze,t),h(S,e,t),l(e,ve,t),l(e,E,t),l(e,xe,t),h(L,e,t),l(e,Re,t),l(e,F,t),l(e,We,t),l(e,f,t),l(e,He,t),l(e,q,t),l(e,_e,t),l(e,T,t),l(e,Be,t),l(e,g,t),l(e,Ve,t),l(e,P,t),l(e,Qe,t),h(A,e,t),l(e,Ye,t),l(e,D,t),l(e,Ne,t),h(K,e,t),l(e,ze,t),l(e,O,t),l(e,Xe,t),h(ee,e,t),l(e,Se,t),l(e,le,t),Ee=!0},p:yt,i(e){Ee||(u(w.$$.fragment,e),u(J.$$.fragment,e),u(I.$$.fragment,e),u(C.$$.fragment,e),u($.$$.fragment,e),u(k.$$.fragment,e),u(v.$$.fragment,e),u(R.$$.fragment,e),u(H.$$.fragment,e),u(B.$$.fragment,e),u(Y.$$.fragment,e),u(z.$$.fragment,e),u(S.$$.fragment,e),u(L.$$.fragment,e),u(A.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),Ee=!0)},o(e){M(w.$$.fragment,e),M(J.$$.fragment,e),M(I.$$.fragment,e),M(C.$$.fragment,e),M($.$$.fragment,e),M(k.$$.fragment,e),M(v.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(B.$$.fragment,e),M(Y.$$.fragment,e),M(z.$$.fragment,e),M(S.$$.fragment,e),M(L.$$.fragment,e),M(A.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),Ee=!1},d(e){e&&(n(se),n(ne),n(ie),n(oe),n(U),n(re),n(ce),n(b),n(pe),n(he),n(ue),n(j),n(Me),n(de),n(G),n(me),n(ye),n(Z),n(fe),n(Te),n(x),n(ge),n(we),n(W),n(Ue),n(Je),n(_),n(be),n(Ie),n(V),n(Ce),n(Q),n(je),n($e),n(N),n(Ge),n(ke),n(X),n(Ze),n(ve),n(E),n(xe),n(Re),n(F),n(We),n(f),n(He),n(q),n(_e),n(T),n(Be),n(g),n(Ve),n(P),n(Qe),n(Ye),n(D),n(Ne),n(ze),n(O),n(Xe),n(Se),n(le)),n(y),d(w,e),d(J,e),d(I,e),d(C,e),d($,e),d(k,e),d(v,e),d(R,e),d(H,e),d(B,e),d(Y,e),d(z,e),d(S,e),d(L,e),d(A,e),d(K,e),d(ee,e)}}}const It='{"title":"Consuming Text Generation Inference","local":"consuming-text-generation-inference","sections":[{"title":"curl","local":"curl","sections":[],"depth":2},{"title":"Inference Client","local":"inference-client","sections":[],"depth":2},{"title":"ChatUI","local":"chatui","sections":[],"depth":2},{"title":"Gradio","local":"gradio","sections":[],"depth":2},{"title":"API documentation","local":"api-documentation","sections":[],"depth":2}],"depth":1}';function Ct(Le){return ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zt extends Tt{constructor(y){super(),gt(this,y,Ct,bt,mt,{})}}export{Zt as component};
