import{s as pe,n as ye,o as ce}from"../chunks/scheduler.65852ee5.js";import{S as re,i as Te,g as M,s as n,r as J,A as we,h as o,f as e,c as a,j as oe,u as p,x as i,k as ie,y as ue,a as t,v as y,d as c,t as r,w as T}from"../chunks/index.aa74147d.js";import{D as de,C as w}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as Je,E as Ue}from"../chunks/EditOnGithub.4eda6a96.js";function je(Zs){let u,ml,Ul,hl,d,Il,U,bl,j,Bs='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',Zl,m,fs='<p>This tutorial is advanced. You should have notions from <a href="advanced_rag">this other cookbook</a> first!</p>',Bl,h,gs="<p>Reminder: Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.</p>",fl,I,Cs="But vanilla RAG has limitations, most importantly these two:",gl,b,Gs="<li>It <strong>performs only one retrieval step</strong>: if the results are bad, the generation in turn will be bad.</li> <li><strong>Semantic similarity is computed with the <em>user query</em> as a reference</strong>, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",Cl,Z,Vs="But we can alleviate these problems by making a <strong>RAG agent: very simply, an agent armed with a retriever tool!</strong>",Gl,B,Ns="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",Vl,f,Ws="So it should naively recover some advanced RAG techniques!",Nl,g,Rs='<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a></li> <li>The agent can the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a></li>',Wl,C,vs="Let’s build this system. 🛠️",Rl,G,Qs="Run the line below to install required dependencies:",vl,V,Ql,N,Xs="Let’s login in order to call the HF Inference API:",Xl,W,kl,R,ks="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",El,v,ql,Q,Es="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",_l,X,qs=`We use <a href="https://python.langchain.com/" rel="nofollow">LangChain</a> for its excellent vector database utilities.
For the embedding model, we use <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a> since it performed well in our <code>RAG_evaluation</code> cookbook.`,Yl,k,Hl,E,_s="Now the database is ready: let’s build our agentic RAG system!",Sl,q,Ys="👉 We only need a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",Al,_,Hs='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',zl,Y,xl,H,Ss="Now it’s straightforward to create an agent that leverages this tool!",Fl,S,As="The agent will need these arguments upon initialization:",$l,A,zs="<li><em><code>tools</code></em>: a list of tools that the agent will be able to call.</li> <li><em><code>llm_engine</code></em>: the LLM that powers the agent.</li>",Ll,z,xs='Our <code>llm_engine</code> must be a callable that takes as input a list of <a href="https://huggingface.co/docs/transformers/main/chat_templating" rel="nofollow">messages</a> and returns text. It also needs to accept a <code>stop_sequences</code> argument that indicates when to stop its generation. For convenience, we directly use the <code>HfEngine</code> class provided in the package to get a LLM engine that calls our <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">Inference API</a>.',Dl,x,Fs='And we use <a href="https://huggingface.co/meta-llama/Llama-3.1-70B-Instruct" rel="nofollow">meta-llama/Llama-3.1-70B-Instruct</a> as the llm engine because:',Pl,F,$s="<li>It has a long 128k context, which is helpful for processing long source documents</li> <li>It is served for free at all times on HF’s Inference API!</li>",Kl,$,Ls='<em>Note:</em> The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.',Ol,L,ls,D,Ds="Since we initialized the agent as a <code>ReactJsonAgent</code>, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as JSON blobs (you could replace this prompt template with your own as needed).",ss,P,Ps="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, parsing the tool call JSON blobs and executing these tool calls, all in a loop that ends only when the final answer is provided.",es,K,ts,O,Ks="Final output:\nThere are several ways to push a model to the Hub:\n1. Using `trainer.push_to_hub()` method.\n2. Using `model.push_to_hub()` method, which is a once-off approach after training.\n3. Using `timm.models.hub.push_to_hf_hub` function for specific frameworks.\n4. Using `api.upload_folder` with `repo_id` and `folder_path` to upload the entire folder.\n5. Setting `--push_to_hub` flag in the training configuration.\nTo use these methods, ensure you have `git-lfs` installed and are logged into your Hugging Face account using `huggingface-cli login`.\n",ns,ll,as,sl,Os="Does the agent setup make a better RAG system? Well, let’s compare it to a standard RAG system using LLM Judge!",Ms,el,le='We will use <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-70B-Instruct</a> for evaluation since it’s one of the strongest OS models we tested for LLM judge use cases.',os,tl,is,nl,se="Before running the test let’s make the agent less verbose.",Js,al,ps,Ml,ys,ol,cs,il,ee='The evaluation prompt follows some of the best principles shown in <a href="llm_judge">our llm_judge cookbook</a>: it follows a small integer Likert scale, has clear criteria, and a description for each score.',rs,Jl,Ts,pl,ws,yl,us,cl,ds,rl,te=`Average score for agentic RAG: 86.9%
Average score for standard RAG: 73.1%
`,Us,Tl,ne="<strong>Let us recap: the Agent setup improves scores by 14% compared to a standard RAG!</strong> (from 73.1% to 86.9%)",js,wl,ae="This is a great improvement, with a very simple setup 🚀",ms,ul,Me="(For a baseline, using Llama-3-70B without the knowledge base got 36%)",hs,dl,Is,jl,bs;return d=new de({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_rag.ipynb"}]}}),U=new Je({props:{title:"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀",local:"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-",headingTag:"h1"}}),V=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZmFpc3MtY3B1JTIwJTIydHJhbnNmb3JtZXJzJTVCYWdlbnRzJTVEJTIyJTIwLS11cGdyYWRlJTIwLXE=",highlighted:'!pip install pandas langchain langchain-community sentence-transformers faiss-cpu <span class="hljs-string">&quot;transformers[agents]&quot;</span> --upgrade -q',wrap:!1}}),W=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),v=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),k=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
    AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>),
    chunk_size=<span class="hljs-number">200</span>,
    chunk_overlap=<span class="hljs-number">20</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)

<span class="hljs-comment"># Split docs and keep only unique ones</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Splitting documents...&quot;</span>)
docs_processed = []
unique_texts = {}
<span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(source_docs):
    new_docs = text_splitter.split_documents([doc])
    <span class="hljs-keyword">for</span> new_doc <span class="hljs-keyword">in</span> new_docs:
        <span class="hljs-keyword">if</span> new_doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
            unique_texts[new_doc.page_content] = <span class="hljs-literal">True</span>
            docs_processed.append(new_doc)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Embedding documents... This should take a few minutes (5 minutes on MacBook with M1 Pro)&quot;</span>)
embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(
    documents=docs_processed,
    embedding=embedding_model,
    distance_strategy=DistanceStrategy.COSINE,
)`,wrap:!1}}),Y=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBZnJvbSUyMGxhbmdjaGFpbl9jb3JlLnZlY3RvcnN0b3JlcyUyMGltcG9ydCUyMFZlY3RvclN0b3JlJTBBJTBBJTBBY2xhc3MlMjBSZXRyaWV2ZXJUb29sKFRvb2wpJTNBJTBBJTIwJTIwJTIwJTIwbmFtZSUyMCUzRCUyMCUyMnJldHJpZXZlciUyMiUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTIwJTNEJTIwJTIyVXNpbmclMjBzZW1hbnRpYyUyMHNpbWlsYXJpdHklMkMlMjByZXRyaWV2ZXMlMjBzb21lJTIwZG9jdW1lbnRzJTIwZnJvbSUyMHRoZSUyMGtub3dsZWRnZSUyMGJhc2UlMjB0aGF0JTIwaGF2ZSUyMHRoZSUyMGNsb3Nlc3QlMjBlbWJlZGRpbmdzJTIwdG8lMjB0aGUlMjBpbnB1dCUyMHF1ZXJ5LiUyMiUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnF1ZXJ5JTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwc2VtYW50aWNhbGx5JTIwY2xvc2UlMjB0byUyMHlvdXIlMjB0YXJnZXQlMjBkb2N1bWVudHMuJTIwVXNlJTIwdGhlJTIwYWZmaXJtYXRpdmUlMjBmb3JtJTIwcmF0aGVyJTIwdGhhbiUyMGElMjBxdWVzdGlvbi4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUyMCUzRCUyMCUyMnN0cmluZyUyMiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjB2ZWN0b3JkYiUzQSUyMFZlY3RvclN0b3JlJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygqKmt3YXJncyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnZlY3RvcmRiJTIwJTNEJTIwdmVjdG9yZGIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBxdWVyeSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXNzZXJ0JTIwaXNpbnN0YW5jZShxdWVyeSUyQyUyMHN0ciklMkMlMjAlMjJZb3VyJTIwc2VhcmNoJTIwcXVlcnklMjBtdXN0JTIwYmUlMjBhJTIwc3RyaW5nJTIyJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jcyUyMCUzRCUyMHNlbGYudmVjdG9yZGIuc2ltaWxhcml0eV9zZWFyY2goJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcXVlcnklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrJTNENyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjIlNUNuUmV0cmlldmVkJTIwZG9jdW1lbnRzJTNBJTVDbiUyMiUyMCUyQiUyMCUyMiUyMi5qb2luKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmYlMjIlM0QlM0QlM0QlM0QlM0QlMjBEb2N1bWVudCUyMCU3QnN0cihpKSU3RCUyMCUzRCUzRCUzRCUzRCUzRCU1Q24lMjIlMjAlMkIlMjBkb2MucGFnZV9jb250ZW50JTIwZm9yJTIwaSUyQyUyMGRvYyUyMGluJTIwZW51bWVyYXRlKGRvY3MpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Using semantic similarity, retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.vectordb.similarity_search(
            query,
            k=<span class="hljs-number">7</span>,
        )

        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [<span class="hljs-string">f&quot;===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)]
        )`,wrap:!1}}),L=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkFwaUVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmQXBpRW5naW5lKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIpJTBBYWdlbnQlMjAlM0QlMjBSZWFjdEpzb25BZ2VudCh0b29scyUzRCU1QnJldHJpZXZlcl90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUlMkMlMjBtYXhfaXRlcmF0aW9ucyUzRDQlMkMlMjB2ZXJib3NlJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfApiEngine, ReactJsonAgent

llm_engine = HfApiEngine(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb)
agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, max_iterations=<span class="hljs-number">4</span>, verbose=<span class="hljs-number">2</span>)`,wrap:!1}}),K=new w({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkhvdyUyMGNhbiUyMEklMjBwdXNoJTIwYSUyMG1vZGVsJTIwdG8lMjB0aGUlMjBIdWIlM0YlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;How can I push a model to the Hub?&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),ll=new Je({props:{title:"Agentic RAG vs. standard RAG",local:"agentic-rag-vs-standard-rag",headingTag:"h2"}}),tl=new w({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),al=new w({props:{code:"aW1wb3J0JTIwbG9nZ2luZyUwQSUwQWFnZW50LmxvZ2dlci5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcpJTIwJTIwJTIzJTIwTGV0J3MlMjByZWR1Y2UlMjB0aGUlMjBhZ2VudCdzJTIwdmVyYm9zaXR5JTIwbGV2ZWwlMEElMEFldmFsX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0cy5sb2FkX2RhdGFzZXQoJTIybS1yaWMlMkZodWdnaW5nZmFjZV9kb2NfcWFfZXZhbCUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> logging

agent.logger.setLevel(logging.WARNING)  <span class="hljs-comment"># Let&#x27;s reduce the agent&#x27;s verbosity level</span>

eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Ml=new w({props:{code:"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",highlighted:`outputs_agentic_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]

    enhanced_question = <span class="hljs-string">f&quot;&quot;&quot;Using the information contained in your knowledge base, which you can access with the &#x27;retriever&#x27; tool,
give a comprehensive answer to the question below.
Respond only to the question asked, response should be concise and relevant to the question.
If you cannot find information, do not give up and try calling your retriever again with different arguments!
Make sure to have covered the question completely by calling the retriever tool several times with semantically different queries.
Your queries should not be questions but affirmative form sentences: e.g. rather than &quot;How do I load a model from the Hub in bf16?&quot;, query should be &quot;load a model from the Hub bf16 weights&quot;.

Question:
<span class="hljs-subst">{question}</span>&quot;&quot;&quot;</span>
    answer = agent.run(enhanced_question)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_agentic_rag.append(results_agentic)`,wrap:!1}}),ol=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

reader_llm = InferenceClient(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

outputs_standard_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    context = retriever_tool(question)

    prompt = <span class="hljs-string">f&quot;&quot;&quot;Given the question and supporting documents below, give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If you cannot find information, do not give up and try calling your retriever again with different arguments!

Question:
<span class="hljs-subst">{question}</span>

<span class="hljs-subst">{context}</span>
&quot;&quot;&quot;</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    answer = reader_llm.chat_completion(messages).choices[<span class="hljs-number">0</span>].message.content

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_standard_rag.append(results_agentic)`,wrap:!1}}),Jl=new w({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;You are a fair evaluator language model.

You will be given an instruction, a response to evaluate, a reference answer that gets a score of 3, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 3. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 3}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.
5. Do not score conciseness: a correct answer that covers the question should receive max score, even if it contains additional useless information.

The instruction to evaluate:
{instruction}

Response to evaluate:
{response}

Reference Answer (Score 3):
{reference_answer}

Score Rubrics:
[Is the response complete, accurate, and factual based on the reference answer?]
Score 1: The response is completely incomplete, inaccurate, and/or not factual.
Score 2: The response is somewhat complete, accurate, and/or factual.
Score 3: The response is completely complete, accurate, and/or factual.

Feedback:&quot;&quot;&quot;</span>`,wrap:!1}}),pl=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWV2YWx1YXRpb25fY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

evaluation_client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Llama-3.1-70B-Instruct&quot;</span>)`,wrap:!1}}),yl=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

results = {}
<span class="hljs-keyword">for</span> system_type, outputs <span class="hljs-keyword">in</span> [
    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
]:
    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(outputs):
        eval_prompt = EVALUATION_PROMPT.<span class="hljs-built_in">format</span>(
            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
        )
        messages = [
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>},
            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: eval_prompt},
        ]

        eval_result = evaluation_client.text_generation(eval_prompt, max_new_tokens=<span class="hljs-number">1000</span>)
        <span class="hljs-keyword">try</span>:
            feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
            experiment[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>] = score
            experiment[<span class="hljs-string">&quot;eval_feedback_LLM_judge&quot;</span>] = feedback
        <span class="hljs-keyword">except</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Parsing failed - output was: <span class="hljs-subst">{eval_result}</span>&quot;</span>)

    results[system_type] = pd.DataFrame.from_dict(outputs)
    results[system_type] = results[system_type].loc[~results[system_type][<span class="hljs-string">&quot;generated_answer&quot;</span>].<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;Error&quot;</span>)]`,wrap:!1}}),cl=new w({props:{code:"REVGQVVMVF9TQ09SRSUyMCUzRCUyMDIlMjAlMjAlMjMlMjBHaXZlJTIwYXZlcmFnZSUyMHNjb3JlJTIwd2hlbmV2ZXIlMjBzY29yaW5nJTIwZmFpbHMlMEElMEElMEFkZWYlMjBmaWxsX3Njb3JlKHgpJTNBJTBBJTIwJTIwJTIwJTIwdHJ5JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW50KHgpJTBBJTIwJTIwJTIwJTIwZXhjZXB0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwREVGQVVMVF9TQ09SRSUwQSUwQSUwQWZvciUyMHN5c3RlbV90eXBlJTJDJTIwb3V0cHV0cyUyMGluJTIwJTVCJTBBJTIwJTIwJTIwJTIwKCUyMmFnZW50aWMlMjIlMkMlMjBvdXRwdXRzX2FnZW50aWNfcmFnKSUyQyUwQSUyMCUyMCUyMCUyMCglMjJzdGFuZGFyZCUyMiUyQyUyMG91dHB1dHNfc3RhbmRhcmRfcmFnKSUyQyUwQSU1RCUzQSUwQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RCU1QiUyMmV2YWxfc2NvcmVfTExNX2p1ZGdlX2ludCUyMiU1RCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHRzJTVCc3lzdGVtX3R5cGUlNUQlNUIlMjJldmFsX3Njb3JlX0xMTV9qdWRnZSUyMiU1RC5maWxsbmEoREVGQVVMVF9TQ09SRSkuYXBwbHkoZmlsbF9zY29yZSklMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmVzdWx0cyU1QnN5c3RlbV90eXBlJTVEJTVCJTIyZXZhbF9zY29yZV9MTE1fanVkZ2VfaW50JTIyJTVEJTIwJTNEJTIwKHJlc3VsdHMlNUJzeXN0ZW1fdHlwZSU1RCU1QiUyMmV2YWxfc2NvcmVfTExNX2p1ZGdlX2ludCUyMiU1RCUyMC0lMjAxKSUyMCUyRiUyMDIlMEElMEElMjAlMjAlMjAlMjBwcmludCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyQXZlcmFnZSUyMHNjb3JlJTIwZm9yJTIwJTdCc3lzdGVtX3R5cGUlN0QlMjBSQUclM0ElMjAlN0JyZXN1bHRzJTVCc3lzdGVtX3R5cGUlNUQlNUInZXZhbF9zY29yZV9MTE1fanVkZ2VfaW50JyU1RC5tZWFuKCkqMTAwJTNBLjFmJTdEJTI1JTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>DEFAULT_SCORE = <span class="hljs-number">2</span>  <span class="hljs-comment"># Give average score whenever scoring fails</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">fill_score</span>(<span class="hljs-params">x</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> <span class="hljs-built_in">int</span>(x)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">except</span>:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> DEFAULT_SCORE


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> system_type, outputs <span class="hljs-keyword">in</span> [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
<span class="hljs-meta">... </span>]:

<span class="hljs-meta">... </span>    results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (
<span class="hljs-meta">... </span>        results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>].fillna(DEFAULT_SCORE).apply(fill_score)
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (results[system_type][<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">2</span>

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Average score for <span class="hljs-subst">{system_type}</span> RAG: <span class="hljs-subst">{results[system_type][<span class="hljs-string">&#x27;eval_score_LLM_judge_int&#x27;</span>].mean()*<span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>%&quot;</span>
<span class="hljs-meta">... </span>    )`,wrap:!1}}),dl=new Ue({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_rag.md"}}),{c(){u=M("meta"),ml=n(),Ul=M("p"),hl=n(),J(d.$$.fragment),Il=n(),J(U.$$.fragment),bl=n(),j=M("p"),j.innerHTML=Bs,Zl=n(),m=M("blockquote"),m.innerHTML=fs,Bl=n(),h=M("blockquote"),h.innerHTML=gs,fl=n(),I=M("p"),I.textContent=Cs,gl=n(),b=M("ul"),b.innerHTML=Gs,Cl=n(),Z=M("p"),Z.innerHTML=Vs,Gl=n(),B=M("p"),B.textContent=Ns,Vl=n(),f=M("p"),f.textContent=Ws,Nl=n(),g=M("ul"),g.innerHTML=Rs,Wl=n(),C=M("p"),C.textContent=vs,Rl=n(),G=M("p"),G.textContent=Qs,vl=n(),J(V.$$.fragment),Ql=n(),N=M("p"),N.textContent=Xs,Xl=n(),J(W.$$.fragment),kl=n(),R=M("p"),R.innerHTML=ks,El=n(),J(v.$$.fragment),ql=n(),Q=M("p"),Q.textContent=Es,_l=n(),X=M("p"),X.innerHTML=qs,Yl=n(),J(k.$$.fragment),Hl=n(),E=M("p"),E.textContent=_s,Sl=n(),q=M("p"),q.innerHTML=Ys,Al=n(),_=M("p"),_.innerHTML=Hs,zl=n(),J(Y.$$.fragment),xl=n(),H=M("p"),H.textContent=Ss,Fl=n(),S=M("p"),S.textContent=As,$l=n(),A=M("ul"),A.innerHTML=zs,Ll=n(),z=M("p"),z.innerHTML=xs,Dl=n(),x=M("p"),x.innerHTML=Fs,Pl=n(),F=M("ul"),F.innerHTML=$s,Kl=n(),$=M("p"),$.innerHTML=Ls,Ol=n(),J(L.$$.fragment),ls=n(),D=M("p"),D.innerHTML=Ds,ss=n(),P=M("p"),P.innerHTML=Ps,es=n(),J(K.$$.fragment),ts=n(),O=M("pre"),O.textContent=Ks,ns=n(),J(ll.$$.fragment),as=n(),sl=M("p"),sl.textContent=Os,Ms=n(),el=M("p"),el.innerHTML=le,os=n(),J(tl.$$.fragment),is=n(),nl=M("p"),nl.textContent=se,Js=n(),J(al.$$.fragment),ps=n(),J(Ml.$$.fragment),ys=n(),J(ol.$$.fragment),cs=n(),il=M("p"),il.innerHTML=ee,rs=n(),J(Jl.$$.fragment),Ts=n(),J(pl.$$.fragment),ws=n(),J(yl.$$.fragment),us=n(),J(cl.$$.fragment),ds=n(),rl=M("pre"),rl.textContent=te,Us=n(),Tl=M("p"),Tl.innerHTML=ne,js=n(),wl=M("p"),wl.textContent=ae,ms=n(),ul=M("p"),ul.textContent=Me,hs=n(),J(dl.$$.fragment),Is=n(),jl=M("p"),this.h()},l(l){const s=we("svelte-u9bgzb",document.head);u=o(s,"META",{name:!0,content:!0}),s.forEach(e),ml=a(l),Ul=o(l,"P",{}),oe(Ul).forEach(e),hl=a(l),p(d.$$.fragment,l),Il=a(l),p(U.$$.fragment,l),bl=a(l),j=o(l,"P",{"data-svelte-h":!0}),i(j)!=="svelte-1xlqnsv"&&(j.innerHTML=Bs),Zl=a(l),m=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(m)!=="svelte-ut7thx"&&(m.innerHTML=fs),Bl=a(l),h=o(l,"BLOCKQUOTE",{"data-svelte-h":!0}),i(h)!=="svelte-1uj6u2q"&&(h.innerHTML=gs),fl=a(l),I=o(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-le6dse"&&(I.textContent=Cs),gl=a(l),b=o(l,"UL",{"data-svelte-h":!0}),i(b)!=="svelte-1tet28w"&&(b.innerHTML=Gs),Cl=a(l),Z=o(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-zgftoz"&&(Z.innerHTML=Vs),Gl=a(l),B=o(l,"P",{"data-svelte-h":!0}),i(B)!=="svelte-1oxrjf8"&&(B.textContent=Ns),Vl=a(l),f=o(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-i3m4dm"&&(f.textContent=Ws),Nl=a(l),g=o(l,"UL",{"data-svelte-h":!0}),i(g)!=="svelte-16julm3"&&(g.innerHTML=Rs),Wl=a(l),C=o(l,"P",{"data-svelte-h":!0}),i(C)!=="svelte-18mh92s"&&(C.textContent=vs),Rl=a(l),G=o(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-16cuoal"&&(G.textContent=Qs),vl=a(l),p(V.$$.fragment,l),Ql=a(l),N=o(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-64fox6"&&(N.textContent=Xs),Xl=a(l),p(W.$$.fragment,l),kl=a(l),R=o(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-zy8yuo"&&(R.innerHTML=ks),El=a(l),p(v.$$.fragment,l),ql=a(l),Q=o(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-11htfoc"&&(Q.textContent=Es),_l=a(l),X=o(l,"P",{"data-svelte-h":!0}),i(X)!=="svelte-pr8fqf"&&(X.innerHTML=qs),Yl=a(l),p(k.$$.fragment,l),Hl=a(l),E=o(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1tpog71"&&(E.textContent=_s),Sl=a(l),q=o(l,"P",{"data-svelte-h":!0}),i(q)!=="svelte-675szm"&&(q.innerHTML=Ys),Al=a(l),_=o(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-yb70ev"&&(_.innerHTML=Hs),zl=a(l),p(Y.$$.fragment,l),xl=a(l),H=o(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1ma3u1b"&&(H.textContent=Ss),Fl=a(l),S=o(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-14g5yev"&&(S.textContent=As),$l=a(l),A=o(l,"UL",{"data-svelte-h":!0}),i(A)!=="svelte-1pv35c6"&&(A.innerHTML=zs),Ll=a(l),z=o(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-kqzwq2"&&(z.innerHTML=xs),Dl=a(l),x=o(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-bbuqdh"&&(x.innerHTML=Fs),Pl=a(l),F=o(l,"UL",{"data-svelte-h":!0}),i(F)!=="svelte-38rh7n"&&(F.innerHTML=$s),Kl=a(l),$=o(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1faawbb"&&($.innerHTML=Ls),Ol=a(l),p(L.$$.fragment,l),ls=a(l),D=o(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1dmyh52"&&(D.innerHTML=Ds),ss=a(l),P=o(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-143bxk3"&&(P.innerHTML=Ps),es=a(l),p(K.$$.fragment,l),ts=a(l),O=o(l,"PRE",{"data-svelte-h":!0}),i(O)!=="svelte-1ecewas"&&(O.textContent=Ks),ns=a(l),p(ll.$$.fragment,l),as=a(l),sl=o(l,"P",{"data-svelte-h":!0}),i(sl)!=="svelte-to6drr"&&(sl.textContent=Os),Ms=a(l),el=o(l,"P",{"data-svelte-h":!0}),i(el)!=="svelte-yr66ap"&&(el.innerHTML=le),os=a(l),p(tl.$$.fragment,l),is=a(l),nl=o(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-708yv1"&&(nl.textContent=se),Js=a(l),p(al.$$.fragment,l),ps=a(l),p(Ml.$$.fragment,l),ys=a(l),p(ol.$$.fragment,l),cs=a(l),il=o(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-lt6qr6"&&(il.innerHTML=ee),rs=a(l),p(Jl.$$.fragment,l),Ts=a(l),p(pl.$$.fragment,l),ws=a(l),p(yl.$$.fragment,l),us=a(l),p(cl.$$.fragment,l),ds=a(l),rl=o(l,"PRE",{"data-svelte-h":!0}),i(rl)!=="svelte-1it3mki"&&(rl.textContent=te),Us=a(l),Tl=o(l,"P",{"data-svelte-h":!0}),i(Tl)!=="svelte-en509u"&&(Tl.innerHTML=ne),js=a(l),wl=o(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-1fi7cw9"&&(wl.textContent=ae),ms=a(l),ul=o(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-1y4e8t1"&&(ul.textContent=Me),hs=a(l),p(dl.$$.fragment,l),Is=a(l),jl=o(l,"P",{}),oe(jl).forEach(e),this.h()},h(){ie(u,"name","hf:doc:metadata"),ie(u,"content",me)},m(l,s){ue(document.head,u),t(l,ml,s),t(l,Ul,s),t(l,hl,s),y(d,l,s),t(l,Il,s),y(U,l,s),t(l,bl,s),t(l,j,s),t(l,Zl,s),t(l,m,s),t(l,Bl,s),t(l,h,s),t(l,fl,s),t(l,I,s),t(l,gl,s),t(l,b,s),t(l,Cl,s),t(l,Z,s),t(l,Gl,s),t(l,B,s),t(l,Vl,s),t(l,f,s),t(l,Nl,s),t(l,g,s),t(l,Wl,s),t(l,C,s),t(l,Rl,s),t(l,G,s),t(l,vl,s),y(V,l,s),t(l,Ql,s),t(l,N,s),t(l,Xl,s),y(W,l,s),t(l,kl,s),t(l,R,s),t(l,El,s),y(v,l,s),t(l,ql,s),t(l,Q,s),t(l,_l,s),t(l,X,s),t(l,Yl,s),y(k,l,s),t(l,Hl,s),t(l,E,s),t(l,Sl,s),t(l,q,s),t(l,Al,s),t(l,_,s),t(l,zl,s),y(Y,l,s),t(l,xl,s),t(l,H,s),t(l,Fl,s),t(l,S,s),t(l,$l,s),t(l,A,s),t(l,Ll,s),t(l,z,s),t(l,Dl,s),t(l,x,s),t(l,Pl,s),t(l,F,s),t(l,Kl,s),t(l,$,s),t(l,Ol,s),y(L,l,s),t(l,ls,s),t(l,D,s),t(l,ss,s),t(l,P,s),t(l,es,s),y(K,l,s),t(l,ts,s),t(l,O,s),t(l,ns,s),y(ll,l,s),t(l,as,s),t(l,sl,s),t(l,Ms,s),t(l,el,s),t(l,os,s),y(tl,l,s),t(l,is,s),t(l,nl,s),t(l,Js,s),y(al,l,s),t(l,ps,s),y(Ml,l,s),t(l,ys,s),y(ol,l,s),t(l,cs,s),t(l,il,s),t(l,rs,s),y(Jl,l,s),t(l,Ts,s),y(pl,l,s),t(l,ws,s),y(yl,l,s),t(l,us,s),y(cl,l,s),t(l,ds,s),t(l,rl,s),t(l,Us,s),t(l,Tl,s),t(l,js,s),t(l,wl,s),t(l,ms,s),t(l,ul,s),t(l,hs,s),y(dl,l,s),t(l,Is,s),t(l,jl,s),bs=!0},p:ye,i(l){bs||(c(d.$$.fragment,l),c(U.$$.fragment,l),c(V.$$.fragment,l),c(W.$$.fragment,l),c(v.$$.fragment,l),c(k.$$.fragment,l),c(Y.$$.fragment,l),c(L.$$.fragment,l),c(K.$$.fragment,l),c(ll.$$.fragment,l),c(tl.$$.fragment,l),c(al.$$.fragment,l),c(Ml.$$.fragment,l),c(ol.$$.fragment,l),c(Jl.$$.fragment,l),c(pl.$$.fragment,l),c(yl.$$.fragment,l),c(cl.$$.fragment,l),c(dl.$$.fragment,l),bs=!0)},o(l){r(d.$$.fragment,l),r(U.$$.fragment,l),r(V.$$.fragment,l),r(W.$$.fragment,l),r(v.$$.fragment,l),r(k.$$.fragment,l),r(Y.$$.fragment,l),r(L.$$.fragment,l),r(K.$$.fragment,l),r(ll.$$.fragment,l),r(tl.$$.fragment,l),r(al.$$.fragment,l),r(Ml.$$.fragment,l),r(ol.$$.fragment,l),r(Jl.$$.fragment,l),r(pl.$$.fragment,l),r(yl.$$.fragment,l),r(cl.$$.fragment,l),r(dl.$$.fragment,l),bs=!1},d(l){l&&(e(ml),e(Ul),e(hl),e(Il),e(bl),e(j),e(Zl),e(m),e(Bl),e(h),e(fl),e(I),e(gl),e(b),e(Cl),e(Z),e(Gl),e(B),e(Vl),e(f),e(Nl),e(g),e(Wl),e(C),e(Rl),e(G),e(vl),e(Ql),e(N),e(Xl),e(kl),e(R),e(El),e(ql),e(Q),e(_l),e(X),e(Yl),e(Hl),e(E),e(Sl),e(q),e(Al),e(_),e(zl),e(xl),e(H),e(Fl),e(S),e($l),e(A),e(Ll),e(z),e(Dl),e(x),e(Pl),e(F),e(Kl),e($),e(Ol),e(ls),e(D),e(ss),e(P),e(es),e(ts),e(O),e(ns),e(as),e(sl),e(Ms),e(el),e(os),e(is),e(nl),e(Js),e(ps),e(ys),e(cs),e(il),e(rs),e(Ts),e(ws),e(us),e(ds),e(rl),e(Us),e(Tl),e(js),e(wl),e(ms),e(ul),e(hs),e(Is),e(jl)),e(u),T(d,l),T(U,l),T(V,l),T(W,l),T(v,l),T(k,l),T(Y,l),T(L,l),T(K,l),T(ll,l),T(tl,l),T(al,l),T(Ml,l),T(ol,l),T(Jl,l),T(pl,l),T(yl,l),T(cl,l),T(dl,l)}}}const me='{"title":"Agentic RAG: turbocharge your RAG with query reformulation and self-query! 🚀","local":"agentic-rag-turbocharge-your-rag-with-query-reformulation-and-self-query-","sections":[{"title":"Agentic RAG vs. standard RAG","local":"agentic-rag-vs-standard-rag","sections":[],"depth":2}],"depth":1}';function he(Zs){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fe extends re{constructor(u){super(),Te(this,u,he,je,pe,{})}}export{fe as component};
