import{s as yn,o as un,n as Rs}from"../chunks/scheduler.37c15a92.js";import{S as jn,i as Jn,g as u,s as e,r as M,A as Un,h as j,f as a,c as t,j as rn,u as i,x as U,k as cn,y as mn,a as n,v as o,d as r,t as c,w as y}from"../chunks/index.2bf4358c.js";import{T as Ws}from"../chunks/Tip.363c041f.js";import{Y as Tn}from"../chunks/Youtube.1e50a667.js";import{C as m}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as hn}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{H as da}from"../chunks/Heading.8ada512a.js";function wn(w){let p,T="💡 Esta sección cubre BPE en produndidad, yendo tan lejos como para mostrar una implementación completa. Puedes saltarte hasta el final si sólo quieres una descripción general del algoritmo de tokenización.";return{c(){p=u("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1l9fmnz"&&(p.textContent=T)},m(J,h){n(J,p,h)},p:Rs,d(J){J&&a(p)}}}function dn(w){let p,T="Los tokenizadores de GPT-2 y RoBERTa (que son bastante similares) tienen una manera bien inteligente de lidiar con esto: ellos no miran a las palabras como si estuvieran escritas con caracteres Unicode, sino con bytes. De esa manera el vocabulario base tiene un tamaño pequeño (256), pero cada caracter que te puedas imaginar estará incluido y no terminará convertido en el token “desconocido”. Este truco se llama <em>byte-level BPE</em>.";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1vbdz5"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Rs,d(J){J&&a(p)}}}function gn(w){let p,T="✏️ <strong>Ahora es tu turno!</strong> Cuál crees que será la siguiente regla de fusión?";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1h3ygda"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Rs,d(J){J&&a(p)}}}function Cn(w){let p,T="✏️ <strong>Ahora es tu turno!</strong> ¿Cómo crees será tokenizada la palabra <code>&quot;unhug&quot;</code>?";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-iix713"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Rs,d(J){J&&a(p)}}}function xn(w){let p,T="💡 Usar <code>train_new_from_iterator()</code> en el mismo corpus no resultará en exactament el mismo vocabulario. Esto es porque cuando hay una elección del par más frecuente, seleccionamos el primero encontrado, mientras que la librería 🤗 Tokenizers selecciona el primero basado en sus IDs internos.";return{c(){p=u("p"),p.innerHTML=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-2i5pf2"&&(p.innerHTML=T)},m(J,h){n(J,p,h)},p:Rs,d(J){J&&a(p)}}}function In(w){let p,T="⚠️ Nuestra implementación arrojará un error si hay un caracter desconocido dado que no hicimos nada para manejarlos. GPT-2 en realidad no tiene un token desconocido (es imposible obtener un caracter desconocido cuando se usa byte-level BPE), pero esto podría ocurrir acá porque no incluímos todos los posibles bytes en el vocabulario inicial. Este aspectode BPE va más allá del alcance de está sección, por lo que dejaremos los detalles fuera.";return{c(){p=u("p"),p.textContent=T},l(J){p=j(J,"P",{"data-svelte-h":!0}),U(p)!=="svelte-1hld7v5"&&(p.textContent=T)},m(J,h){n(J,p,h)},p:Rs,d(J){J&&a(p)}}}function fn(w){let p,T,J,h,b,Ps,q,Ks,$,ga="La codificación por pares de byte (Byte-Pair Encoding (BPE)) fue inicialmente desarrollado como un algoritmo para comprimir textos, y luego fue usado por OpenAI para la tokenización al momento de pre-entrenar el modelo GPT. Es usado por un montón de modelos Transformers, incluyendo GPT, GPT-2, RoBERTa, BART, y DeBERTa.",Fs,k,Ls,d,Os,Q,sl,A,Ca="El entrenamiento de BPE comienza calculando el conjunto de palabras únicas usada en el corpus (después de completar las etapas de normalización y pre-tokenización), para luego contruir el vocabulario tomando todos los símbolos usados para escribir esas palabras. Como un ejemplo muy simple, digamos que nuestros corpus usa estas cinco palabras:",ll,B,al,z,xa="El vocabulario vase entonces será <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Para casos reales, el vocabulario base contendrá todos los caracteres ASCII, al menos, y probablemente algunos caracteres Unicode también. Si un ejemplo que estás tokenizando usa un caracter que no está en el corpus de entrenamiento, ese caracter será convertido al token “desconocido”. Esa es una razón por la cual muchos modelos de NLP son muy malos analizando contenido con emojis.",nl,g,el,E,Ia="Luego de obtener el vocabulario base, agregamos nuevos tokens hasta que el tamaño deseado del vocabulario se alcance por medio de aprender <em>fusiones</em> (merges), las cuales son reglas para fusionar dos elementos del vocabulario existente en uno nuevo. Por lo que al inicio de estas fusiones crearemos tokens con dos caracteres, y luego, a medida que el entrenamiento avance, subpalabras más largas.",tl,v,fa="En cualquier etapa durante el entrenamiento del tokenizador, el algoritmo BPE buscará pos los pares más frecuentes de los tokens existentes (por “par”, acá nos referimos a dos tokens consecutivos en una palabra). El par más frecuente es el que será fusionado, y enjuagamos y repetimos para la siguiente etapa.",pl,V,ba="Volviedo a nuestro ejemplo previo, asumamos que las palabras tenían las siguientes frecuencias:",Ml,Z,il,S,qa="lo que significa que <code>&quot;hug&quot;</code> estuvo presente 10 veces en el corpus, <code>&quot;pug&quot;</code> 5 veces, <code>&quot;pun&quot;</code> 12 veces, <code>&quot;bun&quot;</code> 4 veces, and <code>&quot;hugs&quot;</code> 5 veces. Empezamos el entrenamiento separando cada palabra en caracteres (los que formaron nuestro vocabulario inicial) para que podamos ver cada palabra como una lista de tokens:",ol,G,rl,_,$a="Luego miramos los pares. El par <code>(&quot;h&quot;, &quot;u&quot;)</code> está presente en las palabras <code>&quot;hug&quot;</code> y <code>&quot;hugs&quot;</code>, 15 veces en el total del corpus. No es el par más frecuente: ese honor le corresponde a <code>(&quot;u&quot;, &quot;g&quot;)</code>, el cual está presente en <code>&quot;hug&quot;</code>, <code>&quot;pug&quot;</code>, y <code>&quot;hugs&quot;</code>, para un gran total de 20 veces en el vocabulario.",cl,N,ka="Por lo tanto, la primera regla de fusión aprendida por el tokenizador es <code>(&quot;u&quot;, &quot;g&quot;) -&gt; &quot;ug&quot;</code>, lo que significa que <code>&quot;ug&quot;</code> será agregado al vocabulario, y el par debería ser fusionado en todas las palabras del corpus. Al final de esta etapa, el vocabulario se ve así:",yl,H,ul,D,Qa="Ahora tenemos algunos pares que resultan en un token más largo de dos caracteres: por ejemplo el par <code>(&quot;h&quot;, &quot;ug&quot;)</code> (presente 15 veces en el corpus). Sin embargo, el par más frecuente en este punto is <code>(&quot;u&quot;, &quot;n&quot;)</code>, presente 16 veces en el corpus, por lo que la segunda regla de fusión aprendida es <code>(&quot;u&quot;, &quot;n&quot;) -&gt; &quot;un&quot;</code>. Agregando esto y fusionando todas las ocurrencias existentes nos lleva a:",jl,X,Jl,W,Aa="Ahora el par más frecuente es <code>(&quot;h&quot;, &quot;ug&quot;)</code>, por lo que aprendemos que la regla de fusión es <code>(&quot;h&quot;, &quot;ug&quot;) -&gt; &quot;hug&quot;</code>, lo cual nos da tuestro primer token de tres letras. Luego de la fusión el corpus se ve así:",Ul,R,ml,Y,Ba="Y continuamos así hasta que alcancemos el tamaño deseado del vocabulario.",Tl,C,hl,P,wl,K,za="La tokenización sigue el proceso de entrenamiento de cerca, en el sentido que nuevos inputs son tokenizados aplicando los siguientes pasos:",dl,F,Ea="<li>Normalización</li> <li>Pre-tokenización</li> <li>Separar las palabras en caracteres individuales</li> <li>Aplicar las reglas de fusión aprendidas en orden en dichas separaciones.</li>",gl,L,va="Tomemos el ejemplo que usamos durante el entrenamiento, con las tres reglas de fusión aprendidas:",Cl,O,xl,ss,Va="La palabra <code>&quot;bug&quot;</code> será tokenizada como <code>[&quot;b&quot;, &quot;ug&quot;]</code>. En cambio, <code>&quot;mug&quot;</code>, será tokenizado como <code>[&quot;[UNK]&quot;, &quot;ug&quot;]</code> dado que la letra <code>&quot;m&quot;</code> no fue parte del vocabulario base. De la misma manera, la palabra <code>&quot;thug&quot;</code> será tokenizada como <code>[&quot;[UNK]&quot;, &quot;hug&quot;]</code>: la letra <code>&quot;t&quot;</code> no está en el vocabulario base, y aplicando las reglas de fusión resulta primero la fusión de <code>&quot;u&quot;</code> y <code>&quot;g&quot;</code> y luego de <code>&quot;hu&quot;</code> and <code>&quot;g&quot;</code>.",Il,x,fl,ls,bl,as,Za="Ahora echemos un vistazo a una implementación el algoritmo BPE. Esta no será una versión optimizada que puedes usar en corpus grande; sólo queremos mostrar el código para que puedas entender el algoritmo un poquito mejor.",ql,ns,Sa="Primero necesitamos un corpus, así que creemos uno simple con algunas oraciones:",$l,es,kl,ts,Ga="A continuación, necesitamos pre-tokenizar el corpus en palabras. Dado que estamos replicando un tokenizador BPE (como GPT-2), usaremos el tokenizdor <code>gpt2</code> para la pre-tokenización:",Ql,ps,Al,Ms,_a="Luego calculamos las frecuencias de cada palabra en el corpues mientras hacemos la pre-tokenización:",Bl,is,zl,os,El,rs,Na="El siguiente paso es calcualar el vocabulario base, formado por todos los caracteres usados en el corpus:",vl,cs,Vl,ys,Zl,us,Ha="También agregamos el token especial usado por el modelo al inicio de ese vocabulario. En el caso de GPT-2, el único token especial es <code>&quot;&lt;|endoftext|&gt;&quot;</code>:",Sl,js,Gl,Js,Da="Ahora necesitamos separar cada palabra en caracteres individuales, para poder comenzar el entrenamiento:",_l,Us,Nl,ms,Xa="Ahora estamos listos para el entrenamiento, escribamos una función que calcule la frecuencia de cada par. Necesitaremos usar esto en cada paso del entrenamiento:",Hl,Ts,Dl,hs,Wa="Ahora miremos una parte de ese diccionario después de las separaciones iniciales:",Xl,ws,Wl,ds,Rl,gs,Ra="Ahora, encontrar el par más frecuenta sólo toma un rápido ciclo:",Yl,Cs,Pl,xs,Kl,Is,Ya="Por lo que la primera fusión a aprender es <code>(&#39;Ġ&#39;, &#39;t&#39;) -&gt; &#39;Ġt&#39;</code>, y luego agregamos <code>&#39;Ġt&#39;</code> al vocabulario:",Fl,fs,Ll,bs,Pa="Para continuar, necesitamos aplicar la fusión en nuestro diccionario de divisiones (<code>splits</code> dictionary). Escribamos otra función para esto:",Ol,qs,sa,$s,Ka="Y podemos echar un vistazo al resultado de nuestra primera fusión:",la,ks,aa,Qs,na,As,Fa="Ahora tenemos todo lo que necesitamos para iterar hasta que aprendamos todas las fusiones que queramos. Apuntemos a un tamaño de vocabulario de 50:",ea,Bs,ta,zs,La="Como resultado, hemos aprendido 19 reglas de fusión (el vocabulario inicial tenía un tamaño de 31 — 30 caracteres del alfabeto, más el token especial):",pa,Es,Ma,vs,ia,Vs,Oa="And the vocabulary is composed of the special token, the initial alphabet, and all the results of the merges:",oa,Zs,ra,Ss,ca,I,ya,Gs,sn="Para tokenizar un nuevo texto lo pre-tokenizamos, lo separamos, luego aplicamos todas las reglas de fusión aprendidas:",ua,_s,ja,Ns,ln="Podemos intentar esto con cualquier texto compuesto de de caracteres del alfabeto:",Ja,Hs,Ua,Ds,ma,f,Ta,Xs,an="Eso es todo para el algoritmo BPE! A continuación echaremos un vistazo a WordPiece.",ha,Ys,wa;return b=new da({props:{title:"Tokenización por Codificación Byte-Pair",local:"byte-pair-encoding-tokenization",headingTag:"h1"}}),q=new hn({props:{chapter:6,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter6/section5.ipynb"}]}}),k=new Tn({props:{id:"HEikzVL-lZU"}}),d=new Ws({props:{$$slots:{default:[wn]},$$scope:{ctx:w}}}),Q=new da({props:{title:"Algoritmo de Entrenamiento",local:"training-algorithm",headingTag:"h2"}}),B=new m({props:{code:"JTIyaHVnJTIyJTJDJTIwJTIycHVnJTIyJTJDJTIwJTIycHVuJTIyJTJDJTIwJTIyYnVuJTIyJTJDJTIwJTIyaHVncyUyMg==",highlighted:'<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-string">&quot;pug&quot;</span>, <span class="hljs-string">&quot;pun&quot;</span>, <span class="hljs-string">&quot;bun&quot;</span>, <span class="hljs-string">&quot;hugs&quot;</span>',wrap:!1}}),g=new Ws({props:{$$slots:{default:[dn]},$$scope:{ctx:w}}}),Z=new m({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),G=new m({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),H=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiU1RCUwQUNvcnB1cyUzQSUyMCglMjJoJTIyJTIwJTIydWclMjIlMkMlMjAxMCklMkMlMjAoJTIycCUyMiUyMCUyMnVnJTIyJTJDJTIwNSklMkMlMjAoJTIycCUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwMTIpJTJDJTIwKCUyMmIlMjIlMjAlMjJ1JTIyJTIwJTIybiUyMiUyQyUyMDQpJTJDJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyMCUyMnMlMjIlMkMlMjA1KQ==",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),X=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),R=new m({props:{code:"Vm9jYWJ1bGFyeSUzQSUyMCU1QiUyMmIlMjIlMkMlMjAlMjJnJTIyJTJDJTIwJTIyaCUyMiUyQyUyMCUyMm4lMjIlMkMlMjAlMjJwJTIyJTJDJTIwJTIycyUyMiUyQyUyMCUyMnUlMjIlMkMlMjAlMjJ1ZyUyMiUyQyUyMCUyMnVuJTIyJTJDJTIwJTIyaHVnJTIyJTVEJTBBQ29ycHVzJTNBJTIwKCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:`<span class="hljs-symbol">Vocabulary:</span> [<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]
<span class="hljs-symbol">Corpus:</span> (<span class="hljs-string">&quot;hug&quot;</span>, <span class="hljs-number">10</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-number">5</span>), (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">12</span>), (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-number">4</span>), (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-number">5</span>)`,wrap:!1}}),C=new Ws({props:{$$slots:{default:[gn]},$$scope:{ctx:w}}}),P=new da({props:{title:"Algoritmo de Tokenización",local:"tokenization-algorithm",headingTag:"h2"}}),O=new m({props:{code:"KCUyMnUlMjIlMkMlMjAlMjJnJTIyKSUyMC0lM0UlMjAlMjJ1ZyUyMiUwQSglMjJ1JTIyJTJDJTIwJTIybiUyMiklMjAtJTNFJTIwJTIydW4lMjIlMEEoJTIyaCUyMiUyQyUyMCUyMnVnJTIyKSUyMC0lM0UlMjAlMjJodWclMjI=",highlighted:`<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;ug&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;un&quot;</span>
<span class="hljs-function"><span class="hljs-params">(<span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>)</span> -&gt;</span> <span class="hljs-string">&quot;hug&quot;</span>`,wrap:!1}}),x=new Ws({props:{$$slots:{default:[Cn]},$$scope:{ctx:w}}}),ls=new da({props:{title:"Implementando BPE",local:"implementing-bpe",headingTag:"h2"}}),es=new m({props:{code:"Y29ycHVzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGlzJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBDb3Vyc2UuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVGhpcyUyMGNoYXB0ZXIlMjBpcyUyMGFib3V0JTIwdG9rZW5pemF0aW9uLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlRoaXMlMjBzZWN0aW9uJTIwc2hvd3MlMjBzZXZlcmFsJTIwdG9rZW5pemVyJTIwYWxnb3JpdGhtcy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJIb3BlZnVsbHklMkMlMjB5b3UlMjB3aWxsJTIwYmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwaG93JTIwdGhleSUyMGFyZSUyMHRyYWluZWQlMjBhbmQlMjBnZW5lcmF0ZSUyMHRva2Vucy4lMjIlMkMlMEElNUQ=",highlighted:`corpus = [
    <span class="hljs-string">&quot;This is the Hugging Face Course.&quot;</span>,
    <span class="hljs-string">&quot;This chapter is about tokenization.&quot;</span>,
    <span class="hljs-string">&quot;This section shows several tokenizer algorithms.&quot;</span>,
    <span class="hljs-string">&quot;Hopefully, you will be able to understand how they are trained and generate tokens.&quot;</span>,
]`,wrap:!1}}),ps=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)`,wrap:!1}}),is=new m({props:{code:"ZnJvbSUyMGNvbGxlY3Rpb25zJTIwaW1wb3J0JTIwZGVmYXVsdGRpY3QlMEElMEF3b3JkX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUwQWZvciUyMHRleHQlMjBpbiUyMGNvcnB1cyUzQSUwQSUyMCUyMCUyMCUyMHdvcmRzX3dpdGhfb2Zmc2V0cyUyMCUzRCUyMHRva2VuaXplci5iYWNrZW5kX3Rva2VuaXplci5wcmVfdG9rZW5pemVyLnByZV90b2tlbml6ZV9zdHIodGV4dCklMEElMjAlMjAlMjAlMjBuZXdfd29yZHMlMjAlM0QlMjAlNUJ3b3JkJTIwZm9yJTIwd29yZCUyQyUyMG9mZnNldCUyMGluJTIwd29yZHNfd2l0aF9vZmZzZXRzJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwbmV3X3dvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZF9mcmVxcyU1QndvcmQlNUQlMjAlMkIlM0QlMjAxJTBBJTBBcHJpbnQod29yZF9mcmVxcyk=",highlighted:`<span class="hljs-keyword">from</span> collections <span class="hljs-keyword">import</span> defaultdict

word_freqs = defaultdict(<span class="hljs-built_in">int</span>)

<span class="hljs-keyword">for</span> text <span class="hljs-keyword">in</span> corpus:
    words_with_offsets = tokenizer.backend_tokenizer.pre_tokenizer.pre_tokenize_str(text)
    new_words = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> words_with_offsets]
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> new_words:
        word_freqs[word] += <span class="hljs-number">1</span>

<span class="hljs-built_in">print</span>(word_freqs)`,wrap:!1}}),os=new m({props:{code:"ZGVmYXVsdGRpY3QoaW50JTJDJTIwJTdCJ1RoaXMnJTNBJTIwMyUyQyUyMCclQzQlQTBpcyclM0ElMjAyJTJDJTIwJyVDNCVBMHRoZSclM0ElMjAxJTJDJTIwJyVDNCVBMEh1Z2dpbmcnJTNBJTIwMSUyQyUyMCclQzQlQTBGYWNlJyUzQSUyMDElMkMlMjAnJUM0JUEwQ291cnNlJyUzQSUyMDElMkMlMjAnLiclM0ElMjA0JTJDJTIwJyVDNCVBMGNoYXB0ZXInJTNBJTIwMSUyQyUwQSUyMCUyMCUyMCUyMCclQzQlQTBhYm91dCclM0ElMjAxJTJDJTIwJyVDNCVBMHRva2VuaXphdGlvbiclM0ElMjAxJTJDJTIwJyVDNCVBMHNlY3Rpb24nJTNBJTIwMSUyQyUyMCclQzQlQTBzaG93cyclM0ElMjAxJTJDJTIwJyVDNCVBMHNldmVyYWwnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbml6ZXInJTNBJTIwMSUyQyUyMCclQzQlQTBhbGdvcml0aG1zJyUzQSUyMDElMkMlMEElMjAlMjAlMjAlMjAnSG9wZWZ1bGx5JyUzQSUyMDElMkMlMjAnJTJDJyUzQSUyMDElMkMlMjAnJUM0JUEweW91JyUzQSUyMDElMkMlMjAnJUM0JUEwd2lsbCclM0ElMjAxJTJDJTIwJyVDNCVBMGJlJyUzQSUyMDElMkMlMjAnJUM0JUEwYWJsZSclM0ElMjAxJTJDJTIwJyVDNCVBMHRvJyUzQSUyMDElMkMlMjAnJUM0JUEwdW5kZXJzdGFuZCclM0ElMjAxJTJDJTIwJyVDNCVBMGhvdyclM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJyVDNCVBMHRoZXknJTNBJTIwMSUyQyUyMCclQzQlQTBhcmUnJTNBJTIwMSUyQyUyMCclQzQlQTB0cmFpbmVkJyUzQSUyMDElMkMlMjAnJUM0JUEwYW5kJyUzQSUyMDElMkMlMjAnJUM0JUEwZ2VuZXJhdGUnJTNBJTIwMSUyQyUyMCclQzQlQTB0b2tlbnMnJTNBJTIwMSU3RCk=",highlighted:`defaultdict(<span class="hljs-built_in">int</span>, {<span class="hljs-string">&#x27;This&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠHugging&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠFace&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;ĠCourse&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;.&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;Ġchapter&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġabout&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenization&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġsection&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġshows&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġseveral&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokenizer&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġalgorithms&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Hopefully&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;,&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġyou&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġwill&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġbe&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġable&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġunderstand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġhow&#x27;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&#x27;Ġthey&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġare&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtrained&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġand&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġgenerate&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;Ġtokens&#x27;</span>: <span class="hljs-number">1</span>})`,wrap:!1}}),cs=new m({props:{code:"YWxwaGFiZXQlMjAlM0QlMjAlNUIlNUQlMEElMEFmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzLmtleXMoKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGxldHRlciUyMGluJTIwd29yZCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGV0dGVyJTIwbm90JTIwaW4lMjBhbHBoYWJldCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFscGhhYmV0LmFwcGVuZChsZXR0ZXIpJTBBYWxwaGFiZXQuc29ydCgpJTBBJTBBcHJpbnQoYWxwaGFiZXQp",highlighted:`alphabet = []

<span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys():
    <span class="hljs-keyword">for</span> letter <span class="hljs-keyword">in</span> word:
        <span class="hljs-keyword">if</span> letter <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> alphabet:
            alphabet.append(letter)
alphabet.sort()

<span class="hljs-built_in">print</span>(alphabet)`,wrap:!1}}),ys=new m({props:{code:"JTVCJTIwJyUyQyclMkMlMjAnLiclMkMlMjAnQyclMkMlMjAnRiclMkMlMjAnSCclMkMlMjAnVCclMkMlMjAnYSclMkMlMjAnYiclMkMlMjAnYyclMkMlMjAnZCclMkMlMjAnZSclMkMlMjAnZiclMkMlMjAnZyclMkMlMjAnaCclMkMlMjAnaSclMkMlMjAnayclMkMlMjAnbCclMkMlMjAnbSclMkMlMjAnbiclMkMlMjAnbyclMkMlMjAncCclMkMlMjAnciclMkMlMjAncyclMkMlMEElMjAlMjAndCclMkMlMjAndSclMkMlMjAndiclMkMlMjAndyclMkMlMjAneSclMkMlMjAneiclMkMlMjAnJUM0JUEwJyU1RA==",highlighted:`[ <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>,
  <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>]`,wrap:!1}}),js=new m({props:{code:"dm9jYWIlMjAlM0QlMjAlNUIlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlNUQlMjAlMkIlMjBhbHBoYWJldC5jb3B5KCk=",highlighted:'vocab = [<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>] + alphabet.copy()',wrap:!1}}),Us=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwJTdCd29yZCUzQSUyMCU1QmMlMjBmb3IlMjBjJTIwaW4lMjB3b3JkJTVEJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9mcmVxcy5rZXlzKCklN0Q=",highlighted:'splits = {word: [c <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs.keys()}',wrap:!1}}),Ts=new m({props:{code:"ZGVmJTIwY29tcHV0ZV9wYWlyX2ZyZXFzKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBwYWlyX2ZyZXFzJTIwJTNEJTIwZGVmYXVsdGRpY3QoaW50KSUwQSUyMCUyMCUyMCUyMGZvciUyMHdvcmQlMkMlMjBmcmVxJTIwaW4lMjB3b3JkX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0cyU1QndvcmQlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGxlbihzcGxpdCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY29udGludWUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpJTIwaW4lMjByYW5nZShsZW4oc3BsaXQpJTIwLSUyMDEpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpciUyMCUzRCUyMChzcGxpdCU1QmklNUQlMkMlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlNUJwYWlyJTVEJTIwJTJCJTNEJTIwZnJlcSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHBhaXJfZnJlcXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_pair_freqs</span>(<span class="hljs-params">splits</span>):
    pair_freqs = defaultdict(<span class="hljs-built_in">int</span>)
    <span class="hljs-keyword">for</span> word, freq <span class="hljs-keyword">in</span> word_freqs.items():
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>):
            pair = (split[i], split[i + <span class="hljs-number">1</span>])
            pair_freqs[pair] += freq
    <span class="hljs-keyword">return</span> pair_freqs`,wrap:!1}}),ws=new m({props:{code:"cGFpcl9mcmVxcyUyMCUzRCUyMGNvbXB1dGVfcGFpcl9mcmVxcyhzcGxpdHMpJTBBJTBBZm9yJTIwaSUyQyUyMGtleSUyMGluJTIwZW51bWVyYXRlKHBhaXJfZnJlcXMua2V5cygpKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JrZXklN0QlM0ElMjAlN0JwYWlyX2ZyZXFzJTVCa2V5JTVEJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGlmJTIwaSUyMCUzRSUzRCUyMDUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhaw==",highlighted:`pair_freqs = compute_pair_freqs(splits)

<span class="hljs-keyword">for</span> i, key <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(pair_freqs.keys()):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: <span class="hljs-subst">{pair_freqs[key]}</span>&quot;</span>)
    <span class="hljs-keyword">if</span> i &gt;= <span class="hljs-number">5</span>:
        <span class="hljs-keyword">break</span>`,wrap:!1}}),ds=new m({props:{code:"KCdUJyUyQyUyMCdoJyklM0ElMjAzJTBBKCdoJyUyQyUyMCdpJyklM0ElMjAzJTBBKCdpJyUyQyUyMCdzJyklM0ElMjA1JTBBKCclQzQlQTAnJTJDJTIwJ2knKSUzQSUyMDIlMEEoJyVDNCVBMCclMkMlMjAndCcpJTNBJTIwNyUwQSgndCclMkMlMjAnaCcpJTNBJTIwMw==",highlighted:`(<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">3</span>
(<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-number">5</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-number">2</span>
(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-number">7</span>
(<span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-number">3</span>`,wrap:!1}}),Cs=new m({props:{code:"YmVzdF9wYWlyJTIwJTNEJTIwJTIyJTIyJTBBbWF4X2ZyZXElMjAlM0QlMjBOb25lJTBBJTBBZm9yJTIwcGFpciUyQyUyMGZyZXElMjBpbiUyMHBhaXJfZnJlcXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWF4X2ZyZXElMjBpcyUyME5vbmUlMjBvciUyMG1heF9mcmVxJTIwJTNDJTIwZnJlcSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMHBhaXIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfZnJlcSUyMCUzRCUyMGZyZXElMEElMEFwcmludChiZXN0X3BhaXIlMkMlMjBtYXhfZnJlcSk=",highlighted:`best_pair = <span class="hljs-string">&quot;&quot;</span>
max_freq = <span class="hljs-literal">None</span>

<span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
    <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
        best_pair = pair
        max_freq = freq

<span class="hljs-built_in">print</span>(best_pair, max_freq)`,wrap:!1}}),xs=new m({props:{code:"KCclQzQlQTAnJTJDJTIwJ3QnKSUyMDc=",highlighted:'(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>) <span class="hljs-number">7</span>',wrap:!1}}),fs=new m({props:{code:"bWVyZ2VzJTIwJTNEJTIwJTdCKCUyMiVDNCVBMCUyMiUyQyUyMCUyMnQlMjIpJTNBJTIwJTIyJUM0JUEwdCUyMiU3RCUwQXZvY2FiLmFwcGVuZCglMjIlQzQlQTB0JTIyKQ==",highlighted:`merges = {(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>): <span class="hljs-string">&quot;Ġt&quot;</span>}
vocab.append(<span class="hljs-string">&quot;Ġt&quot;</span>)`,wrap:!1}}),qs=new m({props:{code:"ZGVmJTIwbWVyZ2VfcGFpcihhJTJDJTIwYiUyQyUyMHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkX2ZyZXFzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXQlMjAlM0QlMjBzcGxpdHMlNUJ3b3JkJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oc3BsaXQpJTIwJTNEJTNEJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbnRpbnVlJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaSUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGklMjAlM0MlMjBsZW4oc3BsaXQpJTIwLSUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMHNwbGl0JTVCaSU1RCUyMCUzRCUzRCUyMGElMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwYiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0JTIwJTNEJTIwc3BsaXQlNUIlM0FpJTVEJTIwJTJCJTIwJTVCYSUyMCUyQiUyMGIlNUQlMjAlMkIlMjBzcGxpdCU1QmklMjAlMkIlMjAyJTIwJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGklMjAlMkIlM0QlMjAxJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3BsaXRzJTVCd29yZCU1RCUyMCUzRCUyMHNwbGl0JTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsaXRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">merge_pair</span>(<span class="hljs-params">a, b, splits</span>):
    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_freqs:
        split = splits[word]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(split) == <span class="hljs-number">1</span>:
            <span class="hljs-keyword">continue</span>

        i = <span class="hljs-number">0</span>
        <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
            <span class="hljs-keyword">if</span> split[i] == a <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == b:
                split = split[:i] + [a + b] + split[i + <span class="hljs-number">2</span> :]
            <span class="hljs-keyword">else</span>:
                i += <span class="hljs-number">1</span>
        splits[word] = split
    <span class="hljs-keyword">return</span> splits`,wrap:!1}}),ks=new m({props:{code:"c3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpciglMjIlQzQlQTAlMjIlMkMlMjAlMjJ0JTIyJTJDJTIwc3BsaXRzKSUwQXByaW50KHNwbGl0cyU1QiUyMiVDNCVBMHRyYWluZWQlMjIlNUQp",highlighted:`splits = merge_pair(<span class="hljs-string">&quot;Ġ&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, splits)
<span class="hljs-built_in">print</span>(splits[<span class="hljs-string">&quot;Ġtrained&quot;</span>])`,wrap:!1}}),Qs=new m({props:{code:"JTVCJyVDNCVBMHQnJTJDJTIwJ3InJTJDJTIwJ2EnJTJDJTIwJ2knJTJDJTIwJ24nJTJDJTIwJ2UnJTJDJTIwJ2QnJTVE",highlighted:'[<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>]',wrap:!1}}),Bs=new m({props:{code:"dm9jYWJfc2l6ZSUyMCUzRCUyMDUwJTBBJTBBd2hpbGUlMjBsZW4odm9jYWIpJTIwJTNDJTIwdm9jYWJfc2l6ZSUzQSUwQSUyMCUyMCUyMCUyMHBhaXJfZnJlcXMlMjAlM0QlMjBjb21wdXRlX3BhaXJfZnJlcXMoc3BsaXRzKSUwQSUyMCUyMCUyMCUyMGJlc3RfcGFpciUyMCUzRCUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMG1heF9mcmVxJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBmcmVxJTIwaW4lMjBwYWlyX2ZyZXFzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMG1heF9mcmVxJTIwaXMlMjBOb25lJTIwb3IlMjBtYXhfZnJlcSUyMCUzQyUyMGZyZXElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiZXN0X3BhaXIlMjAlM0QlMjBwYWlyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2ZyZXElMjAlM0QlMjBmcmVxJTBBJTIwJTIwJTIwJTIwc3BsaXRzJTIwJTNEJTIwbWVyZ2VfcGFpcigqYmVzdF9wYWlyJTJDJTIwc3BsaXRzKSUwQSUyMCUyMCUyMCUyMG1lcmdlcyU1QmJlc3RfcGFpciU1RCUyMCUzRCUyMGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEJTBBJTIwJTIwJTIwJTIwdm9jYWIuYXBwZW5kKGJlc3RfcGFpciU1QjAlNUQlMjAlMkIlMjBiZXN0X3BhaXIlNUIxJTVEKQ==",highlighted:`vocab_size = <span class="hljs-number">50</span>

<span class="hljs-keyword">while</span> <span class="hljs-built_in">len</span>(vocab) &lt; vocab_size:
    pair_freqs = compute_pair_freqs(splits)
    best_pair = <span class="hljs-string">&quot;&quot;</span>
    max_freq = <span class="hljs-literal">None</span>
    <span class="hljs-keyword">for</span> pair, freq <span class="hljs-keyword">in</span> pair_freqs.items():
        <span class="hljs-keyword">if</span> max_freq <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">or</span> max_freq &lt; freq:
            best_pair = pair
            max_freq = freq
    splits = merge_pair(*best_pair, splits)
    merges[best_pair] = best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>]
    vocab.append(best_pair[<span class="hljs-number">0</span>] + best_pair[<span class="hljs-number">1</span>])`,wrap:!1}}),Es=new m({props:{code:"cHJpbnQobWVyZ2VzKQ==",highlighted:'<span class="hljs-built_in">print</span>(merges)',wrap:!1}}),vs=new m({props:{code:"JTdCKCclQzQlQTAnJTJDJTIwJ3QnKSUzQSUyMCclQzQlQTB0JyUyQyUyMCgnaSclMkMlMjAncycpJTNBJTIwJ2lzJyUyQyUyMCgnZSclMkMlMjAncicpJTNBJTIwJ2VyJyUyQyUyMCgnJUM0JUEwJyUyQyUyMCdhJyklM0ElMjAnJUM0JUEwYSclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ28nKSUzQSUyMCclQzQlQTB0byclMkMlMjAoJ2UnJTJDJTIwJ24nKSUzQSUyMCdlbiclMkMlMEElMjAoJ1QnJTJDJTIwJ2gnKSUzQSUyMCdUaCclMkMlMjAoJ1RoJyUyQyUyMCdpcycpJTNBJTIwJ1RoaXMnJTJDJTIwKCdvJyUyQyUyMCd1JyklM0ElMjAnb3UnJTJDJTIwKCdzJyUyQyUyMCdlJyklM0ElMjAnc2UnJTJDJTIwKCclQzQlQTB0byclMkMlMjAnaycpJTNBJTIwJyVDNCVBMHRvayclMkMlMEElMjAoJyVDNCVBMHRvayclMkMlMjAnZW4nKSUzQSUyMCclQzQlQTB0b2tlbiclMkMlMjAoJ24nJTJDJTIwJ2QnKSUzQSUyMCduZCclMkMlMjAoJyVDNCVBMCclMkMlMjAnaXMnKSUzQSUyMCclQzQlQTBpcyclMkMlMjAoJyVDNCVBMHQnJTJDJTIwJ2gnKSUzQSUyMCclQzQlQTB0aCclMkMlMjAoJyVDNCVBMHRoJyUyQyUyMCdlJyklM0ElMjAnJUM0JUEwdGhlJyUyQyUwQSUyMCgnaSclMkMlMjAnbicpJTNBJTIwJ2luJyUyQyUyMCgnJUM0JUEwYSclMkMlMjAnYicpJTNBJTIwJyVDNCVBMGFiJyUyQyUyMCgnJUM0JUEwdG9rZW4nJTJDJTIwJ2knKSUzQSUyMCclQzQlQTB0b2tlbmknJTdE",highlighted:`{(<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>): <span class="hljs-string">&#x27;Ġt&#x27;</span>, (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>): <span class="hljs-string">&#x27;is&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>): <span class="hljs-string">&#x27;er&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>): <span class="hljs-string">&#x27;Ġa&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>): <span class="hljs-string">&#x27;Ġto&#x27;</span>, (<span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;en&#x27;</span>,
 (<span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Th&#x27;</span>, (<span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;This&#x27;</span>, (<span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>): <span class="hljs-string">&#x27;ou&#x27;</span>, (<span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;se&#x27;</span>, (<span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>): <span class="hljs-string">&#x27;Ġtok&#x27;</span>,
 (<span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>): <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, (<span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>): <span class="hljs-string">&#x27;nd&#x27;</span>, (<span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>): <span class="hljs-string">&#x27;Ġis&#x27;</span>, (<span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>): <span class="hljs-string">&#x27;Ġth&#x27;</span>, (<span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>): <span class="hljs-string">&#x27;Ġthe&#x27;</span>,
 (<span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>): <span class="hljs-string">&#x27;in&#x27;</span>, (<span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>): <span class="hljs-string">&#x27;Ġab&#x27;</span>, (<span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>): <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>}`,wrap:!1}}),Zs=new m({props:{code:"cHJpbnQodm9jYWIp",highlighted:'<span class="hljs-built_in">print</span>(vocab)',wrap:!1}}),Ss=new m({props:{code:"JTVCJyUzQyU3Q2VuZG9mdGV4dCU3QyUzRSclMkMlMjAnJTJDJyUyQyUyMCcuJyUyQyUyMCdDJyUyQyUyMCdGJyUyQyUyMCdIJyUyQyUyMCdUJyUyQyUyMCdhJyUyQyUyMCdiJyUyQyUyMCdjJyUyQyUyMCdkJyUyQyUyMCdlJyUyQyUyMCdmJyUyQyUyMCdnJyUyQyUyMCdoJyUyQyUyMCdpJyUyQyUyMCdrJyUyQyUyMCdsJyUyQyUyMCdtJyUyQyUyMCduJyUyQyUyMCdvJyUyQyUwQSUyMCdwJyUyQyUyMCdyJyUyQyUyMCdzJyUyQyUyMCd0JyUyQyUyMCd1JyUyQyUyMCd2JyUyQyUyMCd3JyUyQyUyMCd5JyUyQyUyMCd6JyUyQyUyMCclQzQlQTAnJTJDJTIwJyVDNCVBMHQnJTJDJTIwJ2lzJyUyQyUyMCdlciclMkMlMjAnJUM0JUEwYSclMkMlMjAnJUM0JUEwdG8nJTJDJTIwJ2VuJyUyQyUyMCdUaCclMkMlMjAnVGhpcyclMkMlMjAnb3UnJTJDJTIwJ3NlJyUyQyUwQSUyMCclQzQlQTB0b2snJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCduZCclMkMlMjAnJUM0JUEwaXMnJTJDJTIwJyVDNCVBMHRoJyUyQyUyMCclQzQlQTB0aGUnJTJDJTIwJ2luJyUyQyUyMCclQzQlQTBhYiclMkMlMjAnJUM0JUEwdG9rZW5pJyU1RA==",highlighted:`[<span class="hljs-string">&#x27;&lt;|endoftext|&gt;&#x27;</span>, <span class="hljs-string">&#x27;,&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>, <span class="hljs-string">&#x27;C&#x27;</span>, <span class="hljs-string">&#x27;F&#x27;</span>, <span class="hljs-string">&#x27;H&#x27;</span>, <span class="hljs-string">&#x27;T&#x27;</span>, <span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>, <span class="hljs-string">&#x27;c&#x27;</span>, <span class="hljs-string">&#x27;d&#x27;</span>, <span class="hljs-string">&#x27;e&#x27;</span>, <span class="hljs-string">&#x27;f&#x27;</span>, <span class="hljs-string">&#x27;g&#x27;</span>, <span class="hljs-string">&#x27;h&#x27;</span>, <span class="hljs-string">&#x27;i&#x27;</span>, <span class="hljs-string">&#x27;k&#x27;</span>, <span class="hljs-string">&#x27;l&#x27;</span>, <span class="hljs-string">&#x27;m&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>,
 <span class="hljs-string">&#x27;p&#x27;</span>, <span class="hljs-string">&#x27;r&#x27;</span>, <span class="hljs-string">&#x27;s&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;u&#x27;</span>, <span class="hljs-string">&#x27;v&#x27;</span>, <span class="hljs-string">&#x27;w&#x27;</span>, <span class="hljs-string">&#x27;y&#x27;</span>, <span class="hljs-string">&#x27;z&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;Ġt&#x27;</span>, <span class="hljs-string">&#x27;is&#x27;</span>, <span class="hljs-string">&#x27;er&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġto&#x27;</span>, <span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;Th&#x27;</span>, <span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;ou&#x27;</span>, <span class="hljs-string">&#x27;se&#x27;</span>,
 <span class="hljs-string">&#x27;Ġtok&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;nd&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġth&#x27;</span>, <span class="hljs-string">&#x27;Ġthe&#x27;</span>, <span class="hljs-string">&#x27;in&#x27;</span>, <span class="hljs-string">&#x27;Ġab&#x27;</span>, <span class="hljs-string">&#x27;Ġtokeni&#x27;</span>]`,wrap:!1}}),I=new Ws({props:{$$slots:{default:[xn]},$$scope:{ctx:w}}}),_s=new m({props:{code:"ZGVmJTIwdG9rZW5pemUodGV4dCklM0ElMEElMjAlMjAlMjAlMjBwcmVfdG9rZW5pemVfcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLl90b2tlbml6ZXIucHJlX3Rva2VuaXplci5wcmVfdG9rZW5pemVfc3RyKHRleHQpJTBBJTIwJTIwJTIwJTIwcHJlX3Rva2VuaXplZF90ZXh0JTIwJTNEJTIwJTVCd29yZCUyMGZvciUyMHdvcmQlMkMlMjBvZmZzZXQlMjBpbiUyMHByZV90b2tlbml6ZV9yZXN1bHQlNUQlMEElMjAlMjAlMjAlMjBzcGxpdHMlMjAlM0QlMjAlNUIlNUJsJTIwZm9yJTIwbCUyMGluJTIwd29yZCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHByZV90b2tlbml6ZWRfdGV4dCU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMkMlMjBtZXJnZSUyMGluJTIwbWVyZ2VzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBpZHglMkMlMjBzcGxpdCUyMGluJTIwZW51bWVyYXRlKHNwbGl0cyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdoaWxlJTIwaSUyMCUzQyUyMGxlbihzcGxpdCklMjAtJTIwMSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3BsaXQlNUJpJTVEJTIwJTNEJTNEJTIwcGFpciU1QjAlNUQlMjBhbmQlMjBzcGxpdCU1QmklMjAlMkIlMjAxJTVEJTIwJTNEJTNEJTIwcGFpciU1QjElNUQlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzcGxpdCUyMCUzRCUyMHNwbGl0JTVCJTNBaSU1RCUyMCUyQiUyMCU1Qm1lcmdlJTVEJTIwJTJCJTIwc3BsaXQlNUJpJTIwJTJCJTIwMiUyMCUzQSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVsc2UlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpJTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNwbGl0cyU1QmlkeCU1RCUyMCUzRCUyMHNwbGl0JTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3VtKHNwbGl0cyUyQyUyMCU1QiU1RCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">text</span>):
    pre_tokenize_result = tokenizer._tokenizer.pre_tokenizer.pre_tokenize_str(text)
    pre_tokenized_text = [word <span class="hljs-keyword">for</span> word, offset <span class="hljs-keyword">in</span> pre_tokenize_result]
    splits = [[l <span class="hljs-keyword">for</span> l <span class="hljs-keyword">in</span> word] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> pre_tokenized_text]
    <span class="hljs-keyword">for</span> pair, merge <span class="hljs-keyword">in</span> merges.items():
        <span class="hljs-keyword">for</span> idx, split <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(splits):
            i = <span class="hljs-number">0</span>
            <span class="hljs-keyword">while</span> i &lt; <span class="hljs-built_in">len</span>(split) - <span class="hljs-number">1</span>:
                <span class="hljs-keyword">if</span> split[i] == pair[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> split[i + <span class="hljs-number">1</span>] == pair[<span class="hljs-number">1</span>]:
                    split = split[:i] + [merge] + split[i + <span class="hljs-number">2</span> :]
                <span class="hljs-keyword">else</span>:
                    i += <span class="hljs-number">1</span>
            splits[idx] = split

    <span class="hljs-keyword">return</span> <span class="hljs-built_in">sum</span>(splits, [])`,wrap:!1}}),Hs=new m({props:{code:"dG9rZW5pemUoJTIyVGhpcyUyMGlzJTIwbm90JTIwYSUyMHRva2VuLiUyMik=",highlighted:'tokenize(<span class="hljs-string">&quot;This is not a token.&quot;</span>)',wrap:!1}}),Ds=new m({props:{code:"JTVCJ1RoaXMnJTJDJTIwJyVDNCVBMGlzJyUyQyUyMCclQzQlQTAnJTJDJTIwJ24nJTJDJTIwJ28nJTJDJTIwJ3QnJTJDJTIwJyVDNCVBMGEnJTJDJTIwJyVDNCVBMHRva2VuJyUyQyUyMCcuJyU1RA==",highlighted:'[<span class="hljs-string">&#x27;This&#x27;</span>, <span class="hljs-string">&#x27;Ġis&#x27;</span>, <span class="hljs-string">&#x27;Ġ&#x27;</span>, <span class="hljs-string">&#x27;n&#x27;</span>, <span class="hljs-string">&#x27;o&#x27;</span>, <span class="hljs-string">&#x27;t&#x27;</span>, <span class="hljs-string">&#x27;Ġa&#x27;</span>, <span class="hljs-string">&#x27;Ġtoken&#x27;</span>, <span class="hljs-string">&#x27;.&#x27;</span>]',wrap:!1}}),f=new Ws({props:{warning:!0,$$slots:{default:[In]},$$scope:{ctx:w}}}),{c(){p=u("meta"),T=e(),J=u("p"),h=e(),M(b.$$.fragment),Ps=e(),M(q.$$.fragment),Ks=e(),$=u("p"),$.textContent=ga,Fs=e(),M(k.$$.fragment),Ls=e(),M(d.$$.fragment),Os=e(),M(Q.$$.fragment),sl=e(),A=u("p"),A.textContent=Ca,ll=e(),M(B.$$.fragment),al=e(),z=u("p"),z.innerHTML=xa,nl=e(),M(g.$$.fragment),el=e(),E=u("p"),E.innerHTML=Ia,tl=e(),v=u("p"),v.textContent=fa,pl=e(),V=u("p"),V.textContent=ba,Ml=e(),M(Z.$$.fragment),il=e(),S=u("p"),S.innerHTML=qa,ol=e(),M(G.$$.fragment),rl=e(),_=u("p"),_.innerHTML=$a,cl=e(),N=u("p"),N.innerHTML=ka,yl=e(),M(H.$$.fragment),ul=e(),D=u("p"),D.innerHTML=Qa,jl=e(),M(X.$$.fragment),Jl=e(),W=u("p"),W.innerHTML=Aa,Ul=e(),M(R.$$.fragment),ml=e(),Y=u("p"),Y.textContent=Ba,Tl=e(),M(C.$$.fragment),hl=e(),M(P.$$.fragment),wl=e(),K=u("p"),K.textContent=za,dl=e(),F=u("ol"),F.innerHTML=Ea,gl=e(),L=u("p"),L.textContent=va,Cl=e(),M(O.$$.fragment),xl=e(),ss=u("p"),ss.innerHTML=Va,Il=e(),M(x.$$.fragment),fl=e(),M(ls.$$.fragment),bl=e(),as=u("p"),as.textContent=Za,ql=e(),ns=u("p"),ns.textContent=Sa,$l=e(),M(es.$$.fragment),kl=e(),ts=u("p"),ts.innerHTML=Ga,Ql=e(),M(ps.$$.fragment),Al=e(),Ms=u("p"),Ms.textContent=_a,Bl=e(),M(is.$$.fragment),zl=e(),M(os.$$.fragment),El=e(),rs=u("p"),rs.textContent=Na,vl=e(),M(cs.$$.fragment),Vl=e(),M(ys.$$.fragment),Zl=e(),us=u("p"),us.innerHTML=Ha,Sl=e(),M(js.$$.fragment),Gl=e(),Js=u("p"),Js.textContent=Da,_l=e(),M(Us.$$.fragment),Nl=e(),ms=u("p"),ms.textContent=Xa,Hl=e(),M(Ts.$$.fragment),Dl=e(),hs=u("p"),hs.textContent=Wa,Xl=e(),M(ws.$$.fragment),Wl=e(),M(ds.$$.fragment),Rl=e(),gs=u("p"),gs.textContent=Ra,Yl=e(),M(Cs.$$.fragment),Pl=e(),M(xs.$$.fragment),Kl=e(),Is=u("p"),Is.innerHTML=Ya,Fl=e(),M(fs.$$.fragment),Ll=e(),bs=u("p"),bs.innerHTML=Pa,Ol=e(),M(qs.$$.fragment),sa=e(),$s=u("p"),$s.textContent=Ka,la=e(),M(ks.$$.fragment),aa=e(),M(Qs.$$.fragment),na=e(),As=u("p"),As.textContent=Fa,ea=e(),M(Bs.$$.fragment),ta=e(),zs=u("p"),zs.textContent=La,pa=e(),M(Es.$$.fragment),Ma=e(),M(vs.$$.fragment),ia=e(),Vs=u("p"),Vs.textContent=Oa,oa=e(),M(Zs.$$.fragment),ra=e(),M(Ss.$$.fragment),ca=e(),M(I.$$.fragment),ya=e(),Gs=u("p"),Gs.textContent=sn,ua=e(),M(_s.$$.fragment),ja=e(),Ns=u("p"),Ns.textContent=ln,Ja=e(),M(Hs.$$.fragment),Ua=e(),M(Ds.$$.fragment),ma=e(),M(f.$$.fragment),Ta=e(),Xs=u("p"),Xs.textContent=an,ha=e(),Ys=u("p"),this.h()},l(s){const l=Un("svelte-u9bgzb",document.head);p=j(l,"META",{name:!0,content:!0}),l.forEach(a),T=t(s),J=j(s,"P",{}),rn(J).forEach(a),h=t(s),i(b.$$.fragment,s),Ps=t(s),i(q.$$.fragment,s),Ks=t(s),$=j(s,"P",{"data-svelte-h":!0}),U($)!=="svelte-nlw4yb"&&($.textContent=ga),Fs=t(s),i(k.$$.fragment,s),Ls=t(s),i(d.$$.fragment,s),Os=t(s),i(Q.$$.fragment,s),sl=t(s),A=j(s,"P",{"data-svelte-h":!0}),U(A)!=="svelte-1ge6ors"&&(A.textContent=Ca),ll=t(s),i(B.$$.fragment,s),al=t(s),z=j(s,"P",{"data-svelte-h":!0}),U(z)!=="svelte-12w7uzv"&&(z.innerHTML=xa),nl=t(s),i(g.$$.fragment,s),el=t(s),E=j(s,"P",{"data-svelte-h":!0}),U(E)!=="svelte-9h9iwk"&&(E.innerHTML=Ia),tl=t(s),v=j(s,"P",{"data-svelte-h":!0}),U(v)!=="svelte-1kei5ki"&&(v.textContent=fa),pl=t(s),V=j(s,"P",{"data-svelte-h":!0}),U(V)!=="svelte-w4nnp4"&&(V.textContent=ba),Ml=t(s),i(Z.$$.fragment,s),il=t(s),S=j(s,"P",{"data-svelte-h":!0}),U(S)!=="svelte-hu3c76"&&(S.innerHTML=qa),ol=t(s),i(G.$$.fragment,s),rl=t(s),_=j(s,"P",{"data-svelte-h":!0}),U(_)!=="svelte-2m2yo1"&&(_.innerHTML=$a),cl=t(s),N=j(s,"P",{"data-svelte-h":!0}),U(N)!=="svelte-ap5znc"&&(N.innerHTML=ka),yl=t(s),i(H.$$.fragment,s),ul=t(s),D=j(s,"P",{"data-svelte-h":!0}),U(D)!=="svelte-1i5m5fd"&&(D.innerHTML=Qa),jl=t(s),i(X.$$.fragment,s),Jl=t(s),W=j(s,"P",{"data-svelte-h":!0}),U(W)!=="svelte-17mrt8d"&&(W.innerHTML=Aa),Ul=t(s),i(R.$$.fragment,s),ml=t(s),Y=j(s,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-1683jdr"&&(Y.textContent=Ba),Tl=t(s),i(C.$$.fragment,s),hl=t(s),i(P.$$.fragment,s),wl=t(s),K=j(s,"P",{"data-svelte-h":!0}),U(K)!=="svelte-potlx5"&&(K.textContent=za),dl=t(s),F=j(s,"OL",{"data-svelte-h":!0}),U(F)!=="svelte-jpgiaq"&&(F.innerHTML=Ea),gl=t(s),L=j(s,"P",{"data-svelte-h":!0}),U(L)!=="svelte-8vvsjz"&&(L.textContent=va),Cl=t(s),i(O.$$.fragment,s),xl=t(s),ss=j(s,"P",{"data-svelte-h":!0}),U(ss)!=="svelte-1ukpsru"&&(ss.innerHTML=Va),Il=t(s),i(x.$$.fragment,s),fl=t(s),i(ls.$$.fragment,s),bl=t(s),as=j(s,"P",{"data-svelte-h":!0}),U(as)!=="svelte-1esepyc"&&(as.textContent=Za),ql=t(s),ns=j(s,"P",{"data-svelte-h":!0}),U(ns)!=="svelte-b2t54"&&(ns.textContent=Sa),$l=t(s),i(es.$$.fragment,s),kl=t(s),ts=j(s,"P",{"data-svelte-h":!0}),U(ts)!=="svelte-gkz8m0"&&(ts.innerHTML=Ga),Ql=t(s),i(ps.$$.fragment,s),Al=t(s),Ms=j(s,"P",{"data-svelte-h":!0}),U(Ms)!=="svelte-a1kxvi"&&(Ms.textContent=_a),Bl=t(s),i(is.$$.fragment,s),zl=t(s),i(os.$$.fragment,s),El=t(s),rs=j(s,"P",{"data-svelte-h":!0}),U(rs)!=="svelte-ohzu6i"&&(rs.textContent=Na),vl=t(s),i(cs.$$.fragment,s),Vl=t(s),i(ys.$$.fragment,s),Zl=t(s),us=j(s,"P",{"data-svelte-h":!0}),U(us)!=="svelte-aiji2y"&&(us.innerHTML=Ha),Sl=t(s),i(js.$$.fragment,s),Gl=t(s),Js=j(s,"P",{"data-svelte-h":!0}),U(Js)!=="svelte-pq7l32"&&(Js.textContent=Da),_l=t(s),i(Us.$$.fragment,s),Nl=t(s),ms=j(s,"P",{"data-svelte-h":!0}),U(ms)!=="svelte-19ak7xx"&&(ms.textContent=Xa),Hl=t(s),i(Ts.$$.fragment,s),Dl=t(s),hs=j(s,"P",{"data-svelte-h":!0}),U(hs)!=="svelte-ijk6v3"&&(hs.textContent=Wa),Xl=t(s),i(ws.$$.fragment,s),Wl=t(s),i(ds.$$.fragment,s),Rl=t(s),gs=j(s,"P",{"data-svelte-h":!0}),U(gs)!=="svelte-1a4me0z"&&(gs.textContent=Ra),Yl=t(s),i(Cs.$$.fragment,s),Pl=t(s),i(xs.$$.fragment,s),Kl=t(s),Is=j(s,"P",{"data-svelte-h":!0}),U(Is)!=="svelte-1fkmilf"&&(Is.innerHTML=Ya),Fl=t(s),i(fs.$$.fragment,s),Ll=t(s),bs=j(s,"P",{"data-svelte-h":!0}),U(bs)!=="svelte-1rczgta"&&(bs.innerHTML=Pa),Ol=t(s),i(qs.$$.fragment,s),sa=t(s),$s=j(s,"P",{"data-svelte-h":!0}),U($s)!=="svelte-139whv7"&&($s.textContent=Ka),la=t(s),i(ks.$$.fragment,s),aa=t(s),i(Qs.$$.fragment,s),na=t(s),As=j(s,"P",{"data-svelte-h":!0}),U(As)!=="svelte-16k7mbs"&&(As.textContent=Fa),ea=t(s),i(Bs.$$.fragment,s),ta=t(s),zs=j(s,"P",{"data-svelte-h":!0}),U(zs)!=="svelte-1d3hrno"&&(zs.textContent=La),pa=t(s),i(Es.$$.fragment,s),Ma=t(s),i(vs.$$.fragment,s),ia=t(s),Vs=j(s,"P",{"data-svelte-h":!0}),U(Vs)!=="svelte-okpg4u"&&(Vs.textContent=Oa),oa=t(s),i(Zs.$$.fragment,s),ra=t(s),i(Ss.$$.fragment,s),ca=t(s),i(I.$$.fragment,s),ya=t(s),Gs=j(s,"P",{"data-svelte-h":!0}),U(Gs)!=="svelte-ms7due"&&(Gs.textContent=sn),ua=t(s),i(_s.$$.fragment,s),ja=t(s),Ns=j(s,"P",{"data-svelte-h":!0}),U(Ns)!=="svelte-7dx30b"&&(Ns.textContent=ln),Ja=t(s),i(Hs.$$.fragment,s),Ua=t(s),i(Ds.$$.fragment,s),ma=t(s),i(f.$$.fragment,s),Ta=t(s),Xs=j(s,"P",{"data-svelte-h":!0}),U(Xs)!=="svelte-1jk90c"&&(Xs.textContent=an),ha=t(s),Ys=j(s,"P",{}),rn(Ys).forEach(a),this.h()},h(){cn(p,"name","hf:doc:metadata"),cn(p,"content",bn)},m(s,l){mn(document.head,p),n(s,T,l),n(s,J,l),n(s,h,l),o(b,s,l),n(s,Ps,l),o(q,s,l),n(s,Ks,l),n(s,$,l),n(s,Fs,l),o(k,s,l),n(s,Ls,l),o(d,s,l),n(s,Os,l),o(Q,s,l),n(s,sl,l),n(s,A,l),n(s,ll,l),o(B,s,l),n(s,al,l),n(s,z,l),n(s,nl,l),o(g,s,l),n(s,el,l),n(s,E,l),n(s,tl,l),n(s,v,l),n(s,pl,l),n(s,V,l),n(s,Ml,l),o(Z,s,l),n(s,il,l),n(s,S,l),n(s,ol,l),o(G,s,l),n(s,rl,l),n(s,_,l),n(s,cl,l),n(s,N,l),n(s,yl,l),o(H,s,l),n(s,ul,l),n(s,D,l),n(s,jl,l),o(X,s,l),n(s,Jl,l),n(s,W,l),n(s,Ul,l),o(R,s,l),n(s,ml,l),n(s,Y,l),n(s,Tl,l),o(C,s,l),n(s,hl,l),o(P,s,l),n(s,wl,l),n(s,K,l),n(s,dl,l),n(s,F,l),n(s,gl,l),n(s,L,l),n(s,Cl,l),o(O,s,l),n(s,xl,l),n(s,ss,l),n(s,Il,l),o(x,s,l),n(s,fl,l),o(ls,s,l),n(s,bl,l),n(s,as,l),n(s,ql,l),n(s,ns,l),n(s,$l,l),o(es,s,l),n(s,kl,l),n(s,ts,l),n(s,Ql,l),o(ps,s,l),n(s,Al,l),n(s,Ms,l),n(s,Bl,l),o(is,s,l),n(s,zl,l),o(os,s,l),n(s,El,l),n(s,rs,l),n(s,vl,l),o(cs,s,l),n(s,Vl,l),o(ys,s,l),n(s,Zl,l),n(s,us,l),n(s,Sl,l),o(js,s,l),n(s,Gl,l),n(s,Js,l),n(s,_l,l),o(Us,s,l),n(s,Nl,l),n(s,ms,l),n(s,Hl,l),o(Ts,s,l),n(s,Dl,l),n(s,hs,l),n(s,Xl,l),o(ws,s,l),n(s,Wl,l),o(ds,s,l),n(s,Rl,l),n(s,gs,l),n(s,Yl,l),o(Cs,s,l),n(s,Pl,l),o(xs,s,l),n(s,Kl,l),n(s,Is,l),n(s,Fl,l),o(fs,s,l),n(s,Ll,l),n(s,bs,l),n(s,Ol,l),o(qs,s,l),n(s,sa,l),n(s,$s,l),n(s,la,l),o(ks,s,l),n(s,aa,l),o(Qs,s,l),n(s,na,l),n(s,As,l),n(s,ea,l),o(Bs,s,l),n(s,ta,l),n(s,zs,l),n(s,pa,l),o(Es,s,l),n(s,Ma,l),o(vs,s,l),n(s,ia,l),n(s,Vs,l),n(s,oa,l),o(Zs,s,l),n(s,ra,l),o(Ss,s,l),n(s,ca,l),o(I,s,l),n(s,ya,l),n(s,Gs,l),n(s,ua,l),o(_s,s,l),n(s,ja,l),n(s,Ns,l),n(s,Ja,l),o(Hs,s,l),n(s,Ua,l),o(Ds,s,l),n(s,ma,l),o(f,s,l),n(s,Ta,l),n(s,Xs,l),n(s,ha,l),n(s,Ys,l),wa=!0},p(s,[l]){const nn={};l&2&&(nn.$$scope={dirty:l,ctx:s}),d.$set(nn);const en={};l&2&&(en.$$scope={dirty:l,ctx:s}),g.$set(en);const tn={};l&2&&(tn.$$scope={dirty:l,ctx:s}),C.$set(tn);const pn={};l&2&&(pn.$$scope={dirty:l,ctx:s}),x.$set(pn);const Mn={};l&2&&(Mn.$$scope={dirty:l,ctx:s}),I.$set(Mn);const on={};l&2&&(on.$$scope={dirty:l,ctx:s}),f.$set(on)},i(s){wa||(r(b.$$.fragment,s),r(q.$$.fragment,s),r(k.$$.fragment,s),r(d.$$.fragment,s),r(Q.$$.fragment,s),r(B.$$.fragment,s),r(g.$$.fragment,s),r(Z.$$.fragment,s),r(G.$$.fragment,s),r(H.$$.fragment,s),r(X.$$.fragment,s),r(R.$$.fragment,s),r(C.$$.fragment,s),r(P.$$.fragment,s),r(O.$$.fragment,s),r(x.$$.fragment,s),r(ls.$$.fragment,s),r(es.$$.fragment,s),r(ps.$$.fragment,s),r(is.$$.fragment,s),r(os.$$.fragment,s),r(cs.$$.fragment,s),r(ys.$$.fragment,s),r(js.$$.fragment,s),r(Us.$$.fragment,s),r(Ts.$$.fragment,s),r(ws.$$.fragment,s),r(ds.$$.fragment,s),r(Cs.$$.fragment,s),r(xs.$$.fragment,s),r(fs.$$.fragment,s),r(qs.$$.fragment,s),r(ks.$$.fragment,s),r(Qs.$$.fragment,s),r(Bs.$$.fragment,s),r(Es.$$.fragment,s),r(vs.$$.fragment,s),r(Zs.$$.fragment,s),r(Ss.$$.fragment,s),r(I.$$.fragment,s),r(_s.$$.fragment,s),r(Hs.$$.fragment,s),r(Ds.$$.fragment,s),r(f.$$.fragment,s),wa=!0)},o(s){c(b.$$.fragment,s),c(q.$$.fragment,s),c(k.$$.fragment,s),c(d.$$.fragment,s),c(Q.$$.fragment,s),c(B.$$.fragment,s),c(g.$$.fragment,s),c(Z.$$.fragment,s),c(G.$$.fragment,s),c(H.$$.fragment,s),c(X.$$.fragment,s),c(R.$$.fragment,s),c(C.$$.fragment,s),c(P.$$.fragment,s),c(O.$$.fragment,s),c(x.$$.fragment,s),c(ls.$$.fragment,s),c(es.$$.fragment,s),c(ps.$$.fragment,s),c(is.$$.fragment,s),c(os.$$.fragment,s),c(cs.$$.fragment,s),c(ys.$$.fragment,s),c(js.$$.fragment,s),c(Us.$$.fragment,s),c(Ts.$$.fragment,s),c(ws.$$.fragment,s),c(ds.$$.fragment,s),c(Cs.$$.fragment,s),c(xs.$$.fragment,s),c(fs.$$.fragment,s),c(qs.$$.fragment,s),c(ks.$$.fragment,s),c(Qs.$$.fragment,s),c(Bs.$$.fragment,s),c(Es.$$.fragment,s),c(vs.$$.fragment,s),c(Zs.$$.fragment,s),c(Ss.$$.fragment,s),c(I.$$.fragment,s),c(_s.$$.fragment,s),c(Hs.$$.fragment,s),c(Ds.$$.fragment,s),c(f.$$.fragment,s),wa=!1},d(s){s&&(a(T),a(J),a(h),a(Ps),a(Ks),a($),a(Fs),a(Ls),a(Os),a(sl),a(A),a(ll),a(al),a(z),a(nl),a(el),a(E),a(tl),a(v),a(pl),a(V),a(Ml),a(il),a(S),a(ol),a(rl),a(_),a(cl),a(N),a(yl),a(ul),a(D),a(jl),a(Jl),a(W),a(Ul),a(ml),a(Y),a(Tl),a(hl),a(wl),a(K),a(dl),a(F),a(gl),a(L),a(Cl),a(xl),a(ss),a(Il),a(fl),a(bl),a(as),a(ql),a(ns),a($l),a(kl),a(ts),a(Ql),a(Al),a(Ms),a(Bl),a(zl),a(El),a(rs),a(vl),a(Vl),a(Zl),a(us),a(Sl),a(Gl),a(Js),a(_l),a(Nl),a(ms),a(Hl),a(Dl),a(hs),a(Xl),a(Wl),a(Rl),a(gs),a(Yl),a(Pl),a(Kl),a(Is),a(Fl),a(Ll),a(bs),a(Ol),a(sa),a($s),a(la),a(aa),a(na),a(As),a(ea),a(ta),a(zs),a(pa),a(Ma),a(ia),a(Vs),a(oa),a(ra),a(ca),a(ya),a(Gs),a(ua),a(ja),a(Ns),a(Ja),a(Ua),a(ma),a(Ta),a(Xs),a(ha),a(Ys)),a(p),y(b,s),y(q,s),y(k,s),y(d,s),y(Q,s),y(B,s),y(g,s),y(Z,s),y(G,s),y(H,s),y(X,s),y(R,s),y(C,s),y(P,s),y(O,s),y(x,s),y(ls,s),y(es,s),y(ps,s),y(is,s),y(os,s),y(cs,s),y(ys,s),y(js,s),y(Us,s),y(Ts,s),y(ws,s),y(ds,s),y(Cs,s),y(xs,s),y(fs,s),y(qs,s),y(ks,s),y(Qs,s),y(Bs,s),y(Es,s),y(vs,s),y(Zs,s),y(Ss,s),y(I,s),y(_s,s),y(Hs,s),y(Ds,s),y(f,s)}}}const bn='{"title":"Tokenización por Codificación Byte-Pair","local":"byte-pair-encoding-tokenization","sections":[{"title":"Algoritmo de Entrenamiento","local":"training-algorithm","sections":[],"depth":2},{"title":"Algoritmo de Tokenización","local":"tokenization-algorithm","sections":[],"depth":2},{"title":"Implementando BPE","local":"implementing-bpe","sections":[],"depth":2}],"depth":1}';function qn(w){return un(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends jn{constructor(p){super(),Jn(this,p,qn,fn,yn,{})}}export{vn as component};
