import{s as As,n as qs,o as Ls}from"../chunks/scheduler.0219f8bd.js";import{S as Ds,i as Ks,g as r,s as t,r as p,A as Ps,h as J,f as a,c as e,j as _s,x as m,u as i,k as $s,y as Os,a as n,v as c,d as M,t as o,w as h}from"../chunks/index.f61edf3b.js";import{C as y}from"../chunks/CodeBlock.38e566ae.js";import{H as j}from"../chunks/Heading.d33122ca.js";function sl(Ns){let d,P,D,O,w,Es='<br/> <picture><source media="(prefers-color-scheme: dark)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-dark.svg"/> <source media="(prefers-color-scheme: light)" srcset="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg"/> <img alt="huggingface javascript library logo" src="https://huggingface.co/datasets/huggingface/documentation-images/raw/main/huggingfacejs-light.svg" width="376" height="59" style="max-width: 100%;"/></picture> <br/> <br/>',ss,T,ls,U,as,g,Ss="This is a collection of JS libraries to interact with the Hugging Face API, with TS types included.",ns,u,Rs='<li><a href="inference/README">@huggingface/inference</a>: Use Inference Endpoints (dedicated) and Inference API (serverless) to make calls to 100,000+ Machine Learning models</li> <li><a href="hub/README">@huggingface/hub</a>: Interact with huggingface.co to create or delete repos and commit / download files</li> <li><a href="agents/README">@huggingface/agents</a>: Interact with HF models through a natural language interface</li>',ts,b,Vs="We use modern features to avoid polyfills and dependencies, so the libraries will only work on modern browsers / Node.js >= 18 / Bun / Deno.",es,f,Ys="The libraries are still very young, please help us by opening issues!",ps,Z,is,G,cs,I,vs="To install via NPM, you can download the libraries as needed:",Ms,B,os,C,xs="Then import the libraries in your code:",hs,k,rs,W,Js,Q,Fs='You can run our packages with vanilla JS, without any bundler, by using a CDN or static hosting. Using <a href="https://hacks.mozilla.org/2018/03/es-modules-a-cartoon-deep-dive/" rel="nofollow">ES modules</a>, i.e. <code>&lt;script type=&quot;module&quot;&gt;</code>, you can import the libraries in your code:',ms,$,js,N,ys,E,ds,S,ws,R,Hs='Get your HF access token in your <a href="https://huggingface.co/settings/tokens" rel="nofollow">account settings</a>.',Ts,V,Us,Y,gs,v,us,x,bs,F,fs,H,Zs,X,Xs="There are more features of course, check each library’s README!",Gs,z,Is,_,Bs,A,Cs,q,ks,L,zs="This will generate ESM and CJS javascript files in <code>packages/*/dist</code>, eg <code>packages/inference/dist/index.mjs</code>.",Ws,K,Qs;return T=new y({props:{code:"JTJGJTJGJTIwUHJvZ3JhbWF0aWNhbGx5JTIwaW50ZXJhY3QlMjB3aXRoJTIwdGhlJTIwSHViJTBBJTBBYXdhaXQlMjBjcmVhdGVSZXBvKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlN0J0eXBlJTNBJTIwJTIybW9kZWwlMjIlMkMlMjBuYW1lJTNBJTIwJTIybXktdXNlciUyRm5scC1tb2RlbCUyMiU3RCUyQyUwQSUyMCUyMGNyZWRlbnRpYWxzJTNBJTIwJTdCYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiU3RCUwQSU3RCklM0IlMEElMEFhd2FpdCUyMHVwbG9hZEZpbGUoJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMEElMjAlMjBjcmVkZW50aWFscyUzQSUyMCU3QmFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lN0QlMkMlMEElMjAlMjAlMkYlMkYlMjBDYW4lMjB3b3JrJTIwd2l0aCUyMG5hdGl2ZSUyMEZpbGUlMjBpbiUyMGJyb3dzZXJzJTBBJTIwJTIwZmlsZSUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNvbnRlbnQlM0ElMjBuZXclMjBCbG9iKC4uLiklMjAlMEElMjAlMjAlN0QlMEElN0QpJTNCJTBBJTBBJTJGJTJGJTIwVXNlJTIwaG9zdGVkJTIwaW5mZXJlbmNlJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UudHJhbnNsYXRpb24oJTdCJTBBJTIwJTIwbW9kZWwlM0ElMjAndDUtYmFzZSclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnTXklMjBuYW1lJTIwaXMlMjBXb2xmZ2FuZyUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBCZXJsaW4nJTBBJTdEKSUwQSUwQWF3YWl0JTIwaW5mZXJlbmNlLnRleHRUb0ltYWdlKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3N0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yJyUyQyUwQSUyMCUyMGlucHV0cyUzQSUyMCdhd2FyZCUyMHdpbm5pbmclMjBoaWdoJTIwcmVzb2x1dGlvbiUyMHBob3RvJTIwb2YlMjBhJTIwZ2lhbnQlMjB0b3J0b2lzZSUyRigobGFkeWJpcmQpKSUyMGh5YnJpZCUyQyUyMCU1QnRyZW5kaW5nJTIwb24lMjBhcnRzdGF0aW9uJTVEJyUyQyUwQSUyMCUyMHBhcmFtZXRlcnMlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0ElMjAnYmx1cnJ5JyUyQyUwQSUyMCUyMCU3RCUwQSU3RCklMEElMEElMkYlMkYlMjBhbmQlMjBtdWNoJTIwbW9yZSVFMiU4MCVBNg==",highlighted:`<span class="hljs-comment">// Programatically interact with the Hub</span>

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>},
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>}
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>},
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-comment">// Use hosted inference</span>

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Berlin&#x27;</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})

<span class="hljs-comment">// and much more…</span>`,wrap:!1}}),U=new j({props:{title:"Hugging Face JS libraries",local:"hugging-face-js-libraries",headingTag:"h1"}}),Z=new j({props:{title:"Installation",local:"installation",headingTag:"h2"}}),G=new j({props:{title:"From NPM",local:"from-npm",headingTag:"h3"}}),B=new y({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBbnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRz",highlighted:`npm install @huggingface/inference
npm install @huggingface/hub
npm install @huggingface/agents`,wrap:!1}}),k=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEFpbXBvcnQlMjAlN0IlMjBIZkFnZW50JTIwJTdEJTIwZnJvbSUyMCUyMiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTIyJTNCJTBBaW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMGNvbW1pdCUyQyUyMGRlbGV0ZVJlcG8lMkMlMjBsaXN0RmlsZXMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0IlMEFpbXBvcnQlMjB0eXBlJTIwJTdCJTIwUmVwb0lkJTJDJTIwQ3JlZGVudGlhbHMlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlM0I=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoId</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;`,wrap:!1}}),W=new j({props:{title:"From CDN or Static hosting",local:"from-cdn-or-static-hosting",headingTag:"h3"}}),$=new y({props:{code:"JTNDc2NyaXB0JTIwdHlwZSUzRCUyMm1vZHVsZSUyMiUzRSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCdodHRwcyUzQSUyRiUyRmNkbi5qc2RlbGl2ci5uZXQlMkZucG0lMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSU0MDIuNi43JTJGJTJCZXNtJyUzQiUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGY2RuLmpzZGVsaXZyLm5ldCUyRm5wbSUyRiU0MGh1Z2dpbmdmYWNlJTJGaHViJTQwMC4xNC4xMCUyRiUyQmVzbSUyMiUzQiUwQSUzQyUyRnNjcmlwdCUzRQ==",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">script</span> <span class="hljs-attr">type</span>=<span class="hljs-string">&quot;module&quot;</span>&gt;</span><span class="language-javascript">
    <span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;https://cdn.jsdelivr.net/npm/@huggingface/inference@2.6.7/+esm&#x27;</span>;
    <span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://cdn.jsdelivr.net/npm/@huggingface/hub@0.14.10/+esm&quot;</span>;
</span><span class="hljs-tag">&lt;/<span class="hljs-name">script</span>&gt;</span>`,wrap:!1}}),N=new j({props:{title:"Deno",local:"deno",headingTag:"h3"}}),E=new y({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMmh0dHBzJTNBJTJGJTJGZXNtLnNoJTJGJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmSW5mZXJlbmNlJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNlJTIyJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJucG0lM0ElNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWltcG9ydCUyMCU3QiUyMGNyZWF0ZVJlcG8lMkMlMjBjb21taXQlMkMlMjBkZWxldGVSZXBvJTJDJTIwbGlzdEZpbGVzJTIwJTdEJTIwZnJvbSUyMCUyMm5wbSUzQSU0MGh1Z2dpbmdmYWNlJTJGaHViJTIy",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/inference&quot;</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agents&quot;</span>;

<span class="hljs-keyword">import</span> { createRepo, commit, deleteRepo, listFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),S=new j({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),V=new j({props:{title:"@huggingface/inference examples",local:"huggingfaceinference-examples",headingTag:"h3"}}),Y=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZpbmZlcmVuY2UlMjIlM0IlMEElMEFjb25zdCUyMEhGX1RPS0VOJTIwJTNEJTIwJTIyaGZfLi4uJTIyJTNCJTBBJTBBY29uc3QlMjBpbmZlcmVuY2UlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZShIRl9UT0tFTiklM0IlMEElMEElMkYlMkYlMjBZb3UlMjBjYW4lMjBhbHNvJTIwb21pdCUyMCUyMm1vZGVsJTIyJTIwdG8lMjB1c2UlMjB0aGUlMjByZWNvbW1lbmRlZCUyMG1vZGVsJTIwZm9yJTIwdGhlJTIwdGFzayUwQWF3YWl0JTIwaW5mZXJlbmNlLnRyYW5zbGF0aW9uKCU3QiUwQSUyMCUyMG1vZGVsJTNBJTIwJ3Q1LWJhc2UnJTJDJTBBJTIwJTIwaW5wdXRzJTNBJTIwJ015JTIwbmFtZSUyMGlzJTIwV29sZmdhbmclMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwQW1zdGVyZGFtJyUwQSU3RCklMEElMEFhd2FpdCUyMGluZmVyZW5jZS50ZXh0VG9JbWFnZSglN0IlMEElMjAlMjBtb2RlbCUzQSUyMCdzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiclMkMlMEElMjAlMjBpbnB1dHMlM0ElMjAnYXdhcmQlMjB3aW5uaW5nJTIwaGlnaCUyMHJlc29sdXRpb24lMjBwaG90byUyMG9mJTIwYSUyMGdpYW50JTIwdG9ydG9pc2UlMkYoKGxhZHliaXJkKSklMjBoeWJyaWQlMkMlMjAlNUJ0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiU1RCclMkMlMEElMjAlMjBwYXJhbWV0ZXJzJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNBJTIwJ2JsdXJyeSclMkMlMEElMjAlMjAlN0QlMEElN0QpJTBBJTBBYXdhaXQlMjBpbmZlcmVuY2UuaW1hZ2VUb1RleHQoJTdCJTBBJTIwJTIwZGF0YSUzQSUyMGF3YWl0JTIwKGF3YWl0JTIwZmV0Y2goJ2h0dHBzJTNBJTJGJTJGcGljc3VtLnBob3RvcyUyRjMwMCUyRjMwMCcpKS5ibG9iKCklMkMlMEElMjAlMjBtb2RlbCUzQSUyMCdubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyclMkMlMjAlMjAlMEElN0QpJTBBJTBBJTJGJTJGJTIwVXNpbmclMjB5b3VyJTIwb3duJTIwZGVkaWNhdGVkJTIwaW5mZXJlbmNlJTIwZW5kcG9pbnQlM0ElMjBodHRwcyUzQSUyRiUyRmhmLmNvJTJGZG9jcyUyRmluZmVyZW5jZS1lbmRwb2ludHMlMkYlMEFjb25zdCUyMGdwdDIlMjAlM0QlMjBpbmZlcmVuY2UuZW5kcG9pbnQoJ2h0dHBzJTNBJTJGJTJGeHl6LmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZ3B0MicpJTNCJTBBY29uc3QlMjAlN0IlMjBnZW5lcmF0ZWRfdGV4dCUyMCU3RCUyMCUzRCUyMGF3YWl0JTIwZ3B0Mi50ZXh0R2VuZXJhdGlvbiglN0JpbnB1dHMlM0ElMjAnVGhlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjB1bml2ZXJzZSUyMGlzJyU3RCklM0I=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> inference = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInference</span>(<span class="hljs-variable constant_">HF_TOKEN</span>);

<span class="hljs-comment">// You can also omit &quot;model&quot; to use the recommended model for the task</span>
<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">translation</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;t5-base&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;My name is Wolfgang and I live in Amsterdam&#x27;</span>
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">textToImage</span>({
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;stabilityai/stable-diffusion-2&#x27;</span>,
  <span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;award winning high resolution photo of a giant tortoise/((ladybird)) hybrid, [trending on artstation]&#x27;</span>,
  <span class="hljs-attr">parameters</span>: {
    <span class="hljs-attr">negative_prompt</span>: <span class="hljs-string">&#x27;blurry&#x27;</span>,
  }
})

<span class="hljs-keyword">await</span> inference.<span class="hljs-title function_">imageToText</span>({
  <span class="hljs-attr">data</span>: <span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">fetch</span>(<span class="hljs-string">&#x27;https://picsum.photos/300/300&#x27;</span>)).<span class="hljs-title function_">blob</span>(),
  <span class="hljs-attr">model</span>: <span class="hljs-string">&#x27;nlpconnect/vit-gpt2-image-captioning&#x27;</span>,  
})

<span class="hljs-comment">// Using your own dedicated inference endpoint: https://hf.co/docs/inference-endpoints/</span>
<span class="hljs-keyword">const</span> gpt2 = inference.<span class="hljs-title function_">endpoint</span>(<span class="hljs-string">&#x27;https://xyz.eu-west-1.aws.endpoints.huggingface.cloud/gpt2&#x27;</span>);
<span class="hljs-keyword">const</span> { generated_text } = <span class="hljs-keyword">await</span> gpt2.<span class="hljs-title function_">textGeneration</span>({<span class="hljs-attr">inputs</span>: <span class="hljs-string">&#x27;The answer to the universe is&#x27;</span>});`,wrap:!1}}),v=new j({props:{title:"@huggingface/hub examples",local:"huggingfacehub-examples",headingTag:"h3"}}),x=new y({props:{code:"aW1wb3J0JTIwJTdCJTIwY3JlYXRlUmVwbyUyQyUyMHVwbG9hZEZpbGUlMkMlMjBkZWxldGVGaWxlcyUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFhd2FpdCUyMGNyZWF0ZVJlcG8oJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCUyMm15LXVzZXIlMkZubHAtbW9kZWwlMjIlMkMlMjAlMkYlMkYlMjBvciUyMCU3QnR5cGUlM0ElMjAlMjJtb2RlbCUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbmxwLXRlc3QlMjIlN0QlMkMlMEElMjAlMjBjcmVkZW50aWFscyUzQSUyMCU3QmFjY2Vzc1Rva2VuJTNBJTIwSEZfVE9LRU4lN0QlMEElN0QpJTNCJTBBJTBBYXdhaXQlMjB1cGxvYWRGaWxlKCU3QiUwQSUyMCUyMHJlcG8lM0ElMjAlMjJteS11c2VyJTJGbmxwLW1vZGVsJTIyJTJDJTBBJTIwJTIwY3JlZGVudGlhbHMlM0ElMjAlN0JhY2Nlc3NUb2tlbiUzQSUyMEhGX1RPS0VOJTdEJTJDJTBBJTIwJTIwJTJGJTJGJTIwQ2FuJTIwd29yayUyMHdpdGglMjBuYXRpdmUlMjBGaWxlJTIwaW4lMjBicm93c2VycyUwQSUyMCUyMGZpbGUlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjBwYXRoJTNBJTIwJTIycHl0b3JjaF9tb2RlbC5iaW4lMjIlMkMlMEElMjAlMjAlMjAlMjBjb250ZW50JTNBJTIwbmV3JTIwQmxvYiguLi4pJTIwJTBBJTIwJTIwJTdEJTBBJTdEKSUzQiUwQSUwQWF3YWl0JTIwZGVsZXRlRmlsZXMoJTdCJTBBJTIwJTIwcmVwbyUzQSUyMCU3QnR5cGUlM0ElMjAlMjJzcGFjZSUyMiUyQyUyMG5hbWUlM0ElMjAlMjJteS11c2VyJTJGbXktc3BhY2UlMjIlN0QlMkMlMjAlMkYlMkYlMjBvciUyMCUyMnNwYWNlcyUyRm15LXVzZXIlMkZteS1zcGFjZSUyMiUwQSUyMCUyMGNyZWRlbnRpYWxzJTNBJTIwJTdCYWNjZXNzVG9rZW4lM0ElMjBIRl9UT0tFTiU3RCUyQyUwQSUyMCUyMHBhdGhzJTNBJTIwJTVCJTIyUkVBRE1FLm1kJTIyJTJDJTIwJTIyLmdpdGF0dHJpYnV0ZXMlMjIlNUQlMEElN0QpJTNC",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFile, deleteFiles } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>, <span class="hljs-comment">// or {type: &quot;model&quot;, name: &quot;my-user/nlp-test&quot;},</span>
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>}
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFile</span>({
  <span class="hljs-attr">repo</span>: <span class="hljs-string">&quot;my-user/nlp-model&quot;</span>,
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>},
  <span class="hljs-comment">// Can work with native File in browsers</span>
  <span class="hljs-attr">file</span>: {
    <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
    <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>(...) 
  }
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFiles</span>({
  <span class="hljs-attr">repo</span>: {<span class="hljs-attr">type</span>: <span class="hljs-string">&quot;space&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;my-user/my-space&quot;</span>}, <span class="hljs-comment">// or &quot;spaces/my-user/my-space&quot;</span>
  <span class="hljs-attr">credentials</span>: {<span class="hljs-attr">accessToken</span>: <span class="hljs-variable constant_">HF_TOKEN</span>},
  <span class="hljs-attr">paths</span>: [<span class="hljs-string">&quot;README.md&quot;</span>, <span class="hljs-string">&quot;.gitattributes&quot;</span>]
});`,wrap:!1}}),F=new j({props:{title:"@huggingface/agents example",local:"huggingfaceagents-example",headingTag:"h3"}}),H=new y({props:{code:"aW1wb3J0JTIwJTdCSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMkMlMjBkZWZhdWx0VG9vbHMlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJyUzQiUwQSUwQWNvbnN0JTIwSEZfVE9LRU4lMjAlM0QlMjAlMjJoZl8uLi4lMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjBIRl9UT0tFTiUyQyUwQSUyMCUyMExMTUZyb21IdWIoSEZfVE9LRU4pJTJDJTBBJTIwJTIwJTVCLi4uZGVmYXVsdFRvb2xzJTVEJTBBKSUzQiUwQSUwQSUwQSUyRiUyRiUyMHlvdSUyMGNhbiUyMGdlbmVyYXRlJTIwdGhlJTIwY29kZSUyQyUyMGluc3BlY3QlMjBpdCUyMGFuZCUyMHRoZW4lMjBydW4lMjBpdCUwQWNvbnN0JTIwY29kZSUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZ2VuZXJhdGVDb2RlKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUzQiUwQWNvbnNvbGUubG9nKGNvZGUpJTNCJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQuZXZhbHVhdGVDb2RlKGNvZGUpJTBBY29uc29sZS5sb2cobWVzc2FnZXMpJTNCJTIwJTJGJTJGJTIwY29udGFpbnMlMjB0aGUlMjBkYXRhJTBBJTBBJTJGJTJGJTIwb3IlMjB5b3UlMjBjYW4lMjBydW4lMjB0aGUlMjBjb2RlJTIwZGlyZWN0bHklMkMlMjBob3dldmVyJTIweW91JTIwY2FuJ3QlMjBjaGVjayUyMHRoYXQlMjB0aGUlMjBjb2RlJTIwaXMlMjBzYWZlJTIwdG8lMjBleGVjdXRlJTIwdGhpcyUyMHdheSUyQyUyMHVzZSUyMGF0JTIweW91ciUyMG93biUyMHJpc2suJTBBY29uc3QlMjBtZXNzYWdlcyUyMCUzRCUyMGF3YWl0JTIwYWdlbnQucnVuKCUyMkRyYXclMjBhJTIwcGljdHVyZSUyMG9mJTIwYSUyMGNhdCUyMHdlYXJpbmclMjBhJTIwdG9wJTIwaGF0LiUyMFRoZW4lMjBjYXB0aW9uJTIwdGhlJTIwcGljdHVyZSUyMGFuZCUyMHJlYWQlMjBpdCUyMG91dCUyMGxvdWQuJTIyKSUwQWNvbnNvbGUubG9nKG1lc3NhZ2VzKSUzQiUyMA==",highlighted:`<span class="hljs-keyword">import</span> {<span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span>, defaultTools} <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/agents&#x27;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-variable constant_">HF_TOKEN</span> = <span class="hljs-string">&quot;hf_...&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-variable constant_">HF_TOKEN</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-variable constant_">HF_TOKEN</span>),
  [...defaultTools]
);


<span class="hljs-comment">// you can generate the code, inspect it and then run it</span>
<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code);
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.evaluateCode(code)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); <span class="hljs-comment">// contains the data</span>

<span class="hljs-comment">// or you can run the code directly, however you can&#x27;t check that the code is safe to execute this way, use at your own risk.</span>
<span class="hljs-keyword">const</span> messages = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">run</span>(<span class="hljs-string">&quot;Draw a picture of a cat wearing a top hat. Then caption the picture and read it out loud.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(messages); `,wrap:!1}}),z=new j({props:{title:"Formatting & testing",local:"formatting--testing",headingTag:"h2"}}),_=new y({props:{code:"c3VkbyUyMGNvcmVwYWNrJTIwZW5hYmxlJTBBcG5wbSUyMGluc3RhbGwlMEElMEFwbnBtJTIwLXIlMjBmb3JtYXQlM0FjaGVjayUwQXBucG0lMjAtciUyMGxpbnQlM0FjaGVjayUwQXBucG0lMjAtciUyMHRlc3Q=",highlighted:`sudo corepack enable
pnpm install

pnpm -r format:check
pnpm -r lint:check
pnpm -r test`,wrap:!1}}),A=new j({props:{title:"Building",local:"building",headingTag:"h2"}}),q=new y({props:{code:"cG5wbSUyMC1yJTIwYnVpbGQ=",highlighted:'<span class="hljs-attribute">pnpm -r build</span>',wrap:!1}}),{c(){d=r("meta"),P=t(),D=r("p"),O=t(),w=r("p"),w.innerHTML=Es,ss=t(),p(T.$$.fragment),ls=t(),p(U.$$.fragment),as=t(),g=r("p"),g.textContent=Ss,ns=t(),u=r("ul"),u.innerHTML=Rs,ts=t(),b=r("p"),b.textContent=Vs,es=t(),f=r("p"),f.textContent=Ys,ps=t(),p(Z.$$.fragment),is=t(),p(G.$$.fragment),cs=t(),I=r("p"),I.textContent=vs,Ms=t(),p(B.$$.fragment),os=t(),C=r("p"),C.textContent=xs,hs=t(),p(k.$$.fragment),rs=t(),p(W.$$.fragment),Js=t(),Q=r("p"),Q.innerHTML=Fs,ms=t(),p($.$$.fragment),js=t(),p(N.$$.fragment),ys=t(),p(E.$$.fragment),ds=t(),p(S.$$.fragment),ws=t(),R=r("p"),R.innerHTML=Hs,Ts=t(),p(V.$$.fragment),Us=t(),p(Y.$$.fragment),gs=t(),p(v.$$.fragment),us=t(),p(x.$$.fragment),bs=t(),p(F.$$.fragment),fs=t(),p(H.$$.fragment),Zs=t(),X=r("p"),X.textContent=Xs,Gs=t(),p(z.$$.fragment),Is=t(),p(_.$$.fragment),Bs=t(),p(A.$$.fragment),Cs=t(),p(q.$$.fragment),ks=t(),L=r("p"),L.innerHTML=zs,Ws=t(),K=r("p"),this.h()},l(s){const l=Ps("svelte-u9bgzb",document.head);d=J(l,"META",{name:!0,content:!0}),l.forEach(a),P=e(s),D=J(s,"P",{}),_s(D).forEach(a),O=e(s),w=J(s,"P",{align:!0,"data-svelte-h":!0}),m(w)!=="svelte-8nbzva"&&(w.innerHTML=Es),ss=e(s),i(T.$$.fragment,s),ls=e(s),i(U.$$.fragment,s),as=e(s),g=J(s,"P",{"data-svelte-h":!0}),m(g)!=="svelte-1eufct4"&&(g.textContent=Ss),ns=e(s),u=J(s,"UL",{"data-svelte-h":!0}),m(u)!=="svelte-hdou3h"&&(u.innerHTML=Rs),ts=e(s),b=J(s,"P",{"data-svelte-h":!0}),m(b)!=="svelte-9ezgtg"&&(b.textContent=Vs),es=e(s),f=J(s,"P",{"data-svelte-h":!0}),m(f)!=="svelte-1vx14v7"&&(f.textContent=Ys),ps=e(s),i(Z.$$.fragment,s),is=e(s),i(G.$$.fragment,s),cs=e(s),I=J(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-18mxf19"&&(I.textContent=vs),Ms=e(s),i(B.$$.fragment,s),os=e(s),C=J(s,"P",{"data-svelte-h":!0}),m(C)!=="svelte-1fdwpsr"&&(C.textContent=xs),hs=e(s),i(k.$$.fragment,s),rs=e(s),i(W.$$.fragment,s),Js=e(s),Q=J(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1td2f08"&&(Q.innerHTML=Fs),ms=e(s),i($.$$.fragment,s),js=e(s),i(N.$$.fragment,s),ys=e(s),i(E.$$.fragment,s),ds=e(s),i(S.$$.fragment,s),ws=e(s),R=J(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-mx6w21"&&(R.innerHTML=Hs),Ts=e(s),i(V.$$.fragment,s),Us=e(s),i(Y.$$.fragment,s),gs=e(s),i(v.$$.fragment,s),us=e(s),i(x.$$.fragment,s),bs=e(s),i(F.$$.fragment,s),fs=e(s),i(H.$$.fragment,s),Zs=e(s),X=J(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-16qnxzd"&&(X.textContent=Xs),Gs=e(s),i(z.$$.fragment,s),Is=e(s),i(_.$$.fragment,s),Bs=e(s),i(A.$$.fragment,s),Cs=e(s),i(q.$$.fragment,s),ks=e(s),L=J(s,"P",{"data-svelte-h":!0}),m(L)!=="svelte-ymfi8c"&&(L.innerHTML=zs),Ws=e(s),K=J(s,"P",{}),_s(K).forEach(a),this.h()},h(){$s(d,"name","hf:doc:metadata"),$s(d,"content",ll),$s(w,"align","center")},m(s,l){Os(document.head,d),n(s,P,l),n(s,D,l),n(s,O,l),n(s,w,l),n(s,ss,l),c(T,s,l),n(s,ls,l),c(U,s,l),n(s,as,l),n(s,g,l),n(s,ns,l),n(s,u,l),n(s,ts,l),n(s,b,l),n(s,es,l),n(s,f,l),n(s,ps,l),c(Z,s,l),n(s,is,l),c(G,s,l),n(s,cs,l),n(s,I,l),n(s,Ms,l),c(B,s,l),n(s,os,l),n(s,C,l),n(s,hs,l),c(k,s,l),n(s,rs,l),c(W,s,l),n(s,Js,l),n(s,Q,l),n(s,ms,l),c($,s,l),n(s,js,l),c(N,s,l),n(s,ys,l),c(E,s,l),n(s,ds,l),c(S,s,l),n(s,ws,l),n(s,R,l),n(s,Ts,l),c(V,s,l),n(s,Us,l),c(Y,s,l),n(s,gs,l),c(v,s,l),n(s,us,l),c(x,s,l),n(s,bs,l),c(F,s,l),n(s,fs,l),c(H,s,l),n(s,Zs,l),n(s,X,l),n(s,Gs,l),c(z,s,l),n(s,Is,l),c(_,s,l),n(s,Bs,l),c(A,s,l),n(s,Cs,l),c(q,s,l),n(s,ks,l),n(s,L,l),n(s,Ws,l),n(s,K,l),Qs=!0},p:qs,i(s){Qs||(M(T.$$.fragment,s),M(U.$$.fragment,s),M(Z.$$.fragment,s),M(G.$$.fragment,s),M(B.$$.fragment,s),M(k.$$.fragment,s),M(W.$$.fragment,s),M($.$$.fragment,s),M(N.$$.fragment,s),M(E.$$.fragment,s),M(S.$$.fragment,s),M(V.$$.fragment,s),M(Y.$$.fragment,s),M(v.$$.fragment,s),M(x.$$.fragment,s),M(F.$$.fragment,s),M(H.$$.fragment,s),M(z.$$.fragment,s),M(_.$$.fragment,s),M(A.$$.fragment,s),M(q.$$.fragment,s),Qs=!0)},o(s){o(T.$$.fragment,s),o(U.$$.fragment,s),o(Z.$$.fragment,s),o(G.$$.fragment,s),o(B.$$.fragment,s),o(k.$$.fragment,s),o(W.$$.fragment,s),o($.$$.fragment,s),o(N.$$.fragment,s),o(E.$$.fragment,s),o(S.$$.fragment,s),o(V.$$.fragment,s),o(Y.$$.fragment,s),o(v.$$.fragment,s),o(x.$$.fragment,s),o(F.$$.fragment,s),o(H.$$.fragment,s),o(z.$$.fragment,s),o(_.$$.fragment,s),o(A.$$.fragment,s),o(q.$$.fragment,s),Qs=!1},d(s){s&&(a(P),a(D),a(O),a(w),a(ss),a(ls),a(as),a(g),a(ns),a(u),a(ts),a(b),a(es),a(f),a(ps),a(is),a(cs),a(I),a(Ms),a(os),a(C),a(hs),a(rs),a(Js),a(Q),a(ms),a(js),a(ys),a(ds),a(ws),a(R),a(Ts),a(Us),a(gs),a(us),a(bs),a(fs),a(Zs),a(X),a(Gs),a(Is),a(Bs),a(Cs),a(ks),a(L),a(Ws),a(K)),a(d),h(T,s),h(U,s),h(Z,s),h(G,s),h(B,s),h(k,s),h(W,s),h($,s),h(N,s),h(E,s),h(S,s),h(V,s),h(Y,s),h(v,s),h(x,s),h(F,s),h(H,s),h(z,s),h(_,s),h(A,s),h(q,s)}}}const ll='{"title":"Hugging Face JS libraries","local":"hugging-face-js-libraries","sections":[{"title":"Installation","local":"installation","sections":[{"title":"From NPM","local":"from-npm","sections":[],"depth":3},{"title":"From CDN or Static hosting","local":"from-cdn-or-static-hosting","sections":[],"depth":3},{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"@huggingface/inference examples","local":"huggingfaceinference-examples","sections":[],"depth":3},{"title":"@huggingface/hub examples","local":"huggingfacehub-examples","sections":[],"depth":3},{"title":"@huggingface/agents example","local":"huggingfaceagents-example","sections":[],"depth":3}],"depth":2},{"title":"Formatting & testing","local":"formatting--testing","sections":[],"depth":2},{"title":"Building","local":"building","sections":[],"depth":2}],"depth":1}';function al(Ns){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class il extends Ds{constructor(d){super(),Ks(this,d,al,sl,As,{})}}export{il as component};
