import{s as Ae,o as Ee,n as Ne}from"../chunks/scheduler.8c3d61f6.js";import{S as Ye,i as Re,g as r,s,r as b,A as He,h as l,f as o,c as a,j as K,u as v,x as u,k as ee,y as d,a as i,v as y,d as w,t as x,w as S}from"../chunks/index.da70eac4.js";import{T as Fe}from"../chunks/Tip.1d9b8c37.js";import{D as _e}from"../chunks/Docstring.567bc132.js";import{C as Ve}from"../chunks/CodeBlock.a9c4becf.js";import{E as Oe}from"../chunks/ExampleCodeBlock.15b54358.js";import{H as Me,E as Qe}from"../chunks/index.5d4ab994.js";function qe(M){let n,h='🧪 Many of the SDXL ControlNet checkpoints are experimental, and there is a lot of room for improvement. Feel free to open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">Issue</a> and leave us feedback on how we can improve!';return{c(){n=r("p"),n.innerHTML=h},l(p){n=l(p,"P",{"data-svelte-h":!0}),u(n)!=="svelte-1q1xjpk"&&(n.innerHTML=h)},m(p,g){i(p,n,g)},p:Ne,d(p){p&&o(n)}}}function Ke(M){let n,h='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){n=r("p"),n.innerHTML=h},l(p){n=l(p,"P",{"data-svelte-h":!0}),u(n)!=="svelte-1qn15hi"&&(n.innerHTML=h)},m(p,g){i(p,n,g)},p:Ne,d(p){p&&o(n)}}}function et(M){let n,h="Examples:",p,g,_;return g=new Ve({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBvcGVuY3YtcHl0aG9uJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRYU1BpcGVsaW5lJTJDJTIwQ29udHJvbE5ldFhTQWRhcHRlciUyQyUyMEF1dG9lbmNvZGVyS0wlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBaW1wb3J0JTIwY3YyJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYWVyaWFsJTIwdmlldyUyQyUyMGElMjBmdXR1cmlzdGljJTIwcmVzZWFyY2glMjBjb21wbGV4JTIwaW4lMjBhJTIwYnJpZ2h0JTIwZm9nZ3klMjBqdW5nbGUlMkMlMjBoYXJkJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJsb3clMjBxdWFsaXR5JTJDJTIwYmFkJTIwcXVhbGl0eSUyQyUyMHNrZXRjaGVzJTIyJTBBJTBBJTIzJTIwZG93bmxvYWQlMjBhbiUyMGltYWdlJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaGYuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZzZF9jb250cm9sbmV0JTJGaGYtbG9nby5wbmclMjIlMEEpJTBBJTBBJTIzJTIwaW5pdGlhbGl6ZSUyMHRoZSUyMG1vZGVscyUyMGFuZCUyMHBpcGVsaW5lJTBBY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlMjAlM0QlMjAwLjUlMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0WFNBZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJVbWVySEElMkZUZXN0aW5nLUNvbnJvbE5ldFhTLVNEWEwtY2FubnklMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFhTUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEElMjMlMjBnZXQlMjBjYW5ueSUyMGltYWdlJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShpbWFnZSklMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMDEwMCUyQyUyMDIwMCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2UpJTBBJTBBJTIzJTIwZ2VuZXJhdGUlMjBpbWFnZSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># !pip install opencv-python transformers accelerate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetXSPipeline, ControlNetXSAdapter, AutoencoderKL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> cv2
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download an image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># initialize the models and pipeline</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet_conditioning_scale = <span class="hljs-number">0.5</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = ControlNetXSAdapter.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;UmerHA/Testing-ConrolNetXS-SDXL-canny&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLControlNetXSPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_model_cpu_offload()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># get canny image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.array(image)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = image[:, :, <span class="hljs-literal">None</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>canny_image = Image.fromarray(image)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># generate image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt, controlnet_conditioning_scale=controlnet_conditioning_scale, image=canny_image
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=r("p"),n.textContent=h,p=s(),b(g.$$.fragment)},l(c){n=l(c,"P",{"data-svelte-h":!0}),u(n)!=="svelte-kvfsh7"&&(n.textContent=h),p=a(c),v(g.$$.fragment,c)},m(c,C){i(c,n,C),i(c,p,C),y(g,c,C),_=!0},p:Ne,i(c){_||(w(g.$$.fragment,c),_=!0)},o(c){x(g.$$.fragment,c),_=!1},d(c){c&&(o(n),o(p)),S(g,c)}}}function tt(M){let n,h,p,g,_,c,C,Pe='ControlNet-XS was introduced in <a href="https://vislearn.github.io/ControlNet-XS/" rel="nofollow">ControlNet-XS</a> by Denis Zavadski and Carsten Rother. It is based on the observation that the control model in the <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">original ControlNet</a> can be made much smaller and still produce good results.',oe,I,ke="Like the original ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",ne,j,De='ControlNet-XS generates images with comparable quality to a regular ControlNet, but it is 20-25% faster (<a href="https://github.com/UmerHA/controlnet-xs-benchmark/blob/main/Speed%20Benchmark.ipynb" rel="nofollow">see benchmark</a>) and uses ~45% less memory.',ie,J,Ie='Here’s the overview from the <a href="https://vislearn.github.io/ControlNet-XS/" rel="nofollow">project page</a>:',se,$,je="<em>With increasing computing capabilities, current model architectures appear to follow the trend of simply upscaling all components without validating the necessity for doing so. In this project we investigate the size and architectural design of ControlNet [Zhang et al., 2023] for controlling the image generation process with stable diffusion-based models. We show that a new architecture with as little as 1% of the parameters of the base model achieves state-of-the art results, considerably better than ControlNet in terms of FID score. Hence we call it ControlNet-XS. We provide the code for controlling StableDiffusion-XL [Podell et al., 2023] (Model B, 48M Parameters) and StableDiffusion 2.1 [Rombach et al. 2022] (Model B, 14M Parameters), all under openrail license.</em>",ae,U,Je='This model was contributed by <a href="https://twitter.com/UmerHAdil" rel="nofollow">UmerHA</a>. ❤️',re,N,le,P,pe,Z,de,m,W,be,Y,$e="Pipeline for text-to-image generation using Stable Diffusion XL with ControlNet-XS guidance.",ve,R,Ue=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,ye,H,Ze="The pipeline also inherits the following loading methods:",we,V,We='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">loaders.FromSingleFileMixin.from_single_file()</a> for loading <code>.ckpt</code> files</li>',xe,T,B,Se,O,Be="The call function to the pipeline for generation.",Ce,k,Te,D,z,Xe,Q,ze="Encodes the prompt into text encoder hidden states.",ce,G,me,X,F,Le,q,Ge="Output class for Stable Diffusion pipelines.",fe,A,ge,te,ue;return _=new Me({props:{title:"ControlNet-XS with Stable Diffusion XL",local:"controlnet-xs-with-stable-diffusion-xl",headingTag:"h1"}}),N=new Fe({props:{warning:!0,$$slots:{default:[qe]},$$scope:{ctx:M}}}),P=new Fe({props:{$$slots:{default:[Ke]},$$scope:{ctx:M}}}),Z=new Me({props:{title:"StableDiffusionXLControlNetXSPipeline",local:"diffusers.StableDiffusionXLControlNetXSPipeline",headingTag:"h2"}}),W=new _e({props:{name:"class diffusers.StableDiffusionXLControlNetXSPipeline",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": typing.Union[diffusers.models.unets.unet_2d_condition.UNet2DConditionModel, diffusers.models.controlnets.controlnet_xs.UNetControlNetXSModel]"},{name:"controlnet",val:": ControlNetXSAdapter"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"feature_extractor",val:": CLIPImageProcessor = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIPTextModelWithProjection</a>) &#x2014;
Second frozen text-encoder
(<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>).`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> used to create a UNetControlNetXSModel to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.controlnet",description:`<strong>controlnet</strong> (<code>ControlNetXSAdapter</code>) &#x2014;
A <code>ControlNetXSAdapter</code> to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"controlnet"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings should always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark</a> library to
watermark output images. If not defined, it defaults to <code>True</code> if the package is installed; otherwise no
watermarker is used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L116"}}),B=new _e({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_guidance_start",val:": float = 0.0"},{name:"control_guidance_end",val:": float = 1.0"},{name:"original_size",val:": typing.Tuple[int, int] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Tuple[int, int] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"image"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"height"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image. Anything below 512 pixels won&#x2019;t work well for
<a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>
and checkpoints that are not specifically fine-tuned on low resolutions.`,name:"width"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(width, height)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(width, height)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeine class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L727",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> is
returned, otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),k=new Oe({props:{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.__call__.example",$$slots:{default:[et]},$$scope:{ctx:M}}}),z=new _e({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": typing.Optional[str] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Optional[str] = None"},{name:"negative_prompt_2",val:": typing.Optional[str] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionXLControlNetXSPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_xs/pipeline_controlnet_xs_sd_xl.py#L224"}}),G=new Me({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),F=new _e({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),A=new Qe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/controlnetxs_sdxl.md"}}),{c(){n=r("meta"),h=s(),p=r("p"),g=s(),b(_.$$.fragment),c=s(),C=r("p"),C.innerHTML=Pe,oe=s(),I=r("p"),I.textContent=ke,ne=s(),j=r("p"),j.innerHTML=De,ie=s(),J=r("p"),J.innerHTML=Ie,se=s(),$=r("p"),$.innerHTML=je,ae=s(),U=r("p"),U.innerHTML=Je,re=s(),b(N.$$.fragment),le=s(),b(P.$$.fragment),pe=s(),b(Z.$$.fragment),de=s(),m=r("div"),b(W.$$.fragment),be=s(),Y=r("p"),Y.textContent=$e,ve=s(),R=r("p"),R.innerHTML=Ue,ye=s(),H=r("p"),H.textContent=Ze,we=s(),V=r("ul"),V.innerHTML=We,xe=s(),T=r("div"),b(B.$$.fragment),Se=s(),O=r("p"),O.textContent=Be,Ce=s(),b(k.$$.fragment),Te=s(),D=r("div"),b(z.$$.fragment),Xe=s(),Q=r("p"),Q.textContent=ze,ce=s(),b(G.$$.fragment),me=s(),X=r("div"),b(F.$$.fragment),Le=s(),q=r("p"),q.textContent=Ge,fe=s(),b(A.$$.fragment),ge=s(),te=r("p"),this.h()},l(e){const t=He("svelte-u9bgzb",document.head);n=l(t,"META",{name:!0,content:!0}),t.forEach(o),h=a(e),p=l(e,"P",{}),K(p).forEach(o),g=a(e),v(_.$$.fragment,e),c=a(e),C=l(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-p0mo4d"&&(C.innerHTML=Pe),oe=a(e),I=l(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-6nd4qa"&&(I.textContent=ke),ne=a(e),j=l(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-161jfc5"&&(j.innerHTML=De),ie=a(e),J=l(e,"P",{"data-svelte-h":!0}),u(J)!=="svelte-1dkixh6"&&(J.innerHTML=Ie),se=a(e),$=l(e,"P",{"data-svelte-h":!0}),u($)!=="svelte-1e1zrpk"&&($.innerHTML=je),ae=a(e),U=l(e,"P",{"data-svelte-h":!0}),u(U)!=="svelte-udfi85"&&(U.innerHTML=Je),re=a(e),v(N.$$.fragment,e),le=a(e),v(P.$$.fragment,e),pe=a(e),v(Z.$$.fragment,e),de=a(e),m=l(e,"DIV",{class:!0});var f=K(m);v(W.$$.fragment,f),be=a(f),Y=l(f,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-1lh3w5q"&&(Y.textContent=$e),ve=a(f),R=l(f,"P",{"data-svelte-h":!0}),u(R)!=="svelte-496sm0"&&(R.innerHTML=Ue),ye=a(f),H=l(f,"P",{"data-svelte-h":!0}),u(H)!=="svelte-14s6m4u"&&(H.textContent=Ze),we=a(f),V=l(f,"UL",{"data-svelte-h":!0}),u(V)!=="svelte-1ho9u84"&&(V.innerHTML=We),xe=a(f),T=l(f,"DIV",{class:!0});var L=K(T);v(B.$$.fragment,L),Se=a(L),O=l(L,"P",{"data-svelte-h":!0}),u(O)!=="svelte-50j04k"&&(O.textContent=Be),Ce=a(L),v(k.$$.fragment,L),L.forEach(o),Te=a(f),D=l(f,"DIV",{class:!0});var E=K(D);v(z.$$.fragment,E),Xe=a(E),Q=l(E,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-16q0ax1"&&(Q.textContent=ze),E.forEach(o),f.forEach(o),ce=a(e),v(G.$$.fragment,e),me=a(e),X=l(e,"DIV",{class:!0});var he=K(X);v(F.$$.fragment,he),Le=a(he),q=l(he,"P",{"data-svelte-h":!0}),u(q)!=="svelte-1qpjiuf"&&(q.textContent=Ge),he.forEach(o),fe=a(e),v(A.$$.fragment,e),ge=a(e),te=l(e,"P",{}),K(te).forEach(o),this.h()},h(){ee(n,"name","hf:doc:metadata"),ee(n,"content",ot),ee(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(m,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ee(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,n),i(e,h,t),i(e,p,t),i(e,g,t),y(_,e,t),i(e,c,t),i(e,C,t),i(e,oe,t),i(e,I,t),i(e,ne,t),i(e,j,t),i(e,ie,t),i(e,J,t),i(e,se,t),i(e,$,t),i(e,ae,t),i(e,U,t),i(e,re,t),y(N,e,t),i(e,le,t),y(P,e,t),i(e,pe,t),y(Z,e,t),i(e,de,t),i(e,m,t),y(W,m,null),d(m,be),d(m,Y),d(m,ve),d(m,R),d(m,ye),d(m,H),d(m,we),d(m,V),d(m,xe),d(m,T),y(B,T,null),d(T,Se),d(T,O),d(T,Ce),y(k,T,null),d(m,Te),d(m,D),y(z,D,null),d(D,Xe),d(D,Q),i(e,ce,t),y(G,e,t),i(e,me,t),i(e,X,t),y(F,X,null),d(X,Le),d(X,q),i(e,fe,t),y(A,e,t),i(e,ge,t),i(e,te,t),ue=!0},p(e,[t]){const f={};t&2&&(f.$$scope={dirty:t,ctx:e}),N.$set(f);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),P.$set(L);const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),k.$set(E)},i(e){ue||(w(_.$$.fragment,e),w(N.$$.fragment,e),w(P.$$.fragment,e),w(Z.$$.fragment,e),w(W.$$.fragment,e),w(B.$$.fragment,e),w(k.$$.fragment,e),w(z.$$.fragment,e),w(G.$$.fragment,e),w(F.$$.fragment,e),w(A.$$.fragment,e),ue=!0)},o(e){x(_.$$.fragment,e),x(N.$$.fragment,e),x(P.$$.fragment,e),x(Z.$$.fragment,e),x(W.$$.fragment,e),x(B.$$.fragment,e),x(k.$$.fragment,e),x(z.$$.fragment,e),x(G.$$.fragment,e),x(F.$$.fragment,e),x(A.$$.fragment,e),ue=!1},d(e){e&&(o(h),o(p),o(g),o(c),o(C),o(oe),o(I),o(ne),o(j),o(ie),o(J),o(se),o($),o(ae),o(U),o(re),o(le),o(pe),o(de),o(m),o(ce),o(me),o(X),o(fe),o(ge),o(te)),o(n),S(_,e),S(N,e),S(P,e),S(Z,e),S(W),S(B),S(k),S(z),S(G,e),S(F),S(A,e)}}}const ot='{"title":"ControlNet-XS with Stable Diffusion XL","local":"controlnet-xs-with-stable-diffusion-xl","sections":[{"title":"StableDiffusionXLControlNetXSPipeline","local":"diffusers.StableDiffusionXLControlNetXSPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function nt(M){return Ee(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ye{constructor(n){super(),Re(this,n,nt,tt,Ae,{})}}export{ct as component};
