import{s as El,n as Vl,o as Sl}from"../chunks/scheduler.b108d059.js";import{S as xl,i as $l,g as a,s,r as d,A as Rl,h as r,f as n,c as i,j as Hl,u as o,x as M,k as il,y as Fl,a as t,v as p,d as h,t as m,w as c}from"../chunks/index.008de539.js";import{C as Me}from"../chunks/CodeBlock.3968c746.js";import{H as u}from"../chunks/Heading.88bfeb84.js";function Ll(al){let y,pe,de,he,j,me,T,rl='Der Hugging Face Hub erleichtert das Hosten und Teilen von Modellen mit der Community. Er unterstützt <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">Dutzende von Bibliotheken</a> im Open Source-Ökosystem. Wir arbeiten ständig daran, diese Unterstützung zu erweitern, um kollaboratives Machine Learning voranzutreiben. Die <code>huggingface_hub</code>-Bibliothek spielt eine Schlüsselrolle in diesem Prozess und ermöglicht es jedem Python-Skript, Dateien einfach hochzuladen und zu laden.',ce,J,Ml="Es gibt vier Hauptwege, eine Bibliothek mit dem Hub zu integrieren:",ue,U,dl=`<li><strong>Push to Hub</strong>: Implementieren Sie eine Methode, um ein Modell auf den Hub hochzuladen.
Dies beinhaltet das Modellgewicht sowie <a href="https://huggingface.co/docs/huggingface_hub/how-to-model-cards" rel="nofollow">die Modellkarte</a> und alle anderen relevanten Informationen oder Daten, die für den Betrieb des Modells erforderlich sind (zum Beispiel Trainingsprotokolle). Diese Methode wird oft <code>push_to_hub()</code> genannt.</li> <li><strong>Download from Hub</strong>: Implementieren Sie eine Methode, um ein Modell vom Hub zu laden.
Die Methode sollte die Modellkonfiguration/-gewichte herunterladen und das Modell laden. Diese Methode wird oft <code>from_pretrained</code> oder <code>load_from_hub()</code> genannt.</li> <li><strong>Inference API</strong>: Nutzen Sie unsere Server, um Inferenz auf von Ihrer Bibliothek unterstützten Modellen kostenlos auszuführen.</li> <li><strong>Widgets</strong>: Zeigen Sie ein Widget auf der Landing Page Ihrer Modelle auf dem Hub an.
Dies ermöglicht es Benutzern, ein Modell schnell aus dem Browser heraus auszuprobieren.</li>`,ye,f,ol="In diesem Leitfaden konzentrieren wir uns auf die ersten beiden Themen. Wir werden die beiden Hauptansätze vorstellen, die Sie zur Integration einer Bibliothek verwenden können, mit ihren Vor- und Nachteilen. Am Ende des Leitfadens ist alles zusammengefasst, um Ihnen bei der Auswahl zwischen den beiden zu helfen. Bitte beachten Sie, dass dies nur Richtlinien sind, die Sie an Ihre Anforderungen anpassen können.",we,I,pl='Wenn Sie sich für Inferenz und Widgets interessieren, können Sie <a href="https://huggingface.co/docs/hub/models-adding-libraries#set-up-the-inference-api" rel="nofollow">diesem Leitfaden</a> folgen. In beiden Fällen können Sie sich an uns wenden, wenn Sie eine Bibliothek mit dem Hub integrieren und <a href="https://huggingface.co/docs/hub/models-libraries" rel="nofollow">in unserer Dokumentation</a> aufgeführt haben möchten.',be,g,je,C,hl=`Der erste Ansatz zur Integration einer Bibliothek in den Hub besteht tatsächlich darin, die <code>push_to_hub</code> und <code>from_pretrained</code> Methoden selbst zu implementieren. Dies gibt Ihnen volle Flexibilität hinsichtlich der Dateien, die Sie hoch-/herunterladen möchten, und wie Sie Eingaben, die speziell für Ihr Framework sind, behandeln. Sie können sich die beiden Leitfäden <a href="./upload">Dateien hochladen</a> und <a href="./download">Dateien herunterladen</a> ansehen, um mehr darüber zu erfahren, wie dies funktioniert. Dies ist zum Beispiel die Art und Weise, wie die FastAI-Integration implementiert ist (siehe <code>push_to_hub_fastai()</code>
und <code>from_pretrained_fastai()</code>).`,Te,k,ml="Die Implementierung kann zwischen den Bibliotheken variieren, aber der Workflow ist oft ähnlich.",Je,_,Ue,B,cl="So sieht eine <code>from_pretrained</code> Methode normalerweise aus:",fe,v,Ie,Z,ge,A,ul="Die <code>push_to_hub</code> Methode erfordert oft etwas mehr Komplexität, um die Repo-Erstellung, die Generierung der Modellkarte und das Speichern von Gewichten zu behandeln. Ein üblicher Ansatz besteht darin, all diese Dateien in einem temporären Ordner zu speichern, ihn hochzuladen und dann zu löschen.",Ce,W,ke,z,yl='Dies ist natürlich nur ein Beispiel. Wenn Sie an komplexeren Manipulationen interessiert sind (entfernen von entfernten Dateien, hochladen von Gewichten on-the-fly, lokales Speichern von Gewichten, usw.), beachten Sie bitte den <a href="./upload">Dateien hochladen</a> Leitfaden.',_e,G,Be,H,wl="Obwohl dieser Ansatz flexibel ist, hat er einige Nachteile, insbesondere in Bezug auf die Wartung. Hugging Face-Benutzer sind oft an zusätzliche Funktionen gewöhnt, wenn sie mit <code>huggingface_hub</code> arbeiten. Zum Beispiel ist es beim Laden von Dateien aus dem Hub üblich, Parameter wie folgt anzubieten:",ve,E,bl="<li><code>token</code>: zum Herunterladen aus einem privaten Repository</li> <li><code>revision</code>: zum Herunterladen von einem spezifischen Branch</li> <li><code>cache_dir</code>: um Dateien in einem spezifischen Verzeichnis zu cachen</li> <li><code>force_download</code>/<code>resume_download</code>/<code>local_files_only</code>: um den Cache wieder zu verwenden oder nicht</li> <li><code>api_endpoint</code>/<code>proxies</code>: HTTP-Session konfigurieren</li>",Ze,V,jl="Beim Pushen von Modellen werden ähnliche Parameter unterstützt:",Ae,S,Tl="<li><code>commit_message</code>: benutzerdefinierte Commit-Nachricht</li> <li><code>private</code>: ein privates Repository erstellen, falls nicht vorhanden</li> <li><code>create_pr</code>: erstellen Sie einen PR anstatt auf <code>main</code> zu pushen</li> <li><code>branch</code>: auf einen Branch pushen anstatt auf den <code>main</code> Branch</li> <li><code>allow_patterns</code>/<code>ignore_patterns</code>: filtern, welche Dateien hochgeladen werden sollen</li> <li><code>token</code></li> <li><code>api_endpoint</code></li> <li>…</li>",We,x,Jl=`Alle diese Parameter können den zuvor gesehenen Implementierungen hinzugefügt und an die <code>huggingface_hub</code>-Methoden übergeben werden.
Wenn sich jedoch ein Parameter ändert oder eine neue Funktion hinzugefügt wird, müssen Sie Ihr Paket aktualisieren.
Die Unterstützung dieser Parameter bedeutet auch mehr Dokumentation, die Sie auf Ihrer Seite pflegen müssen.
Um zu sehen, wie man diese Einschränkungen mildert, springen wir zu unserem nächsten Abschnitt <strong>Klassenvererbung</strong>.`,ze,$,Ge,R,Ul="Wie wir oben gesehen haben, gibt es zwei Hauptmethoden, um Ihre Bibliothek mit dem Hub zu integrieren: Dateien hochladen (<code>push_to_hub</code>) und Dateien herunterladen (<code>from_pretrained</code>). Sie können diese Methoden selbst implementieren, aber das hat seine Tücken. Um dies zu bewältigen, bietet <code>huggingface_hub</code> ein Werkzeug an, das Klassenvererbung verwendet. Schauen wir uns an, wie es funktioniert!",He,F,fl='In vielen Fällen implementiert eine Bibliothek ihr Modell bereits mit einer Python-Klasse. Die Klasse enthält die Eigenschaften des Modells und Methoden zum Laden, Ausführen, Trainieren und Evaluieren. Unser Ansatz besteht darin, diese Klasse zu erweitern, um Upload- und Download-Funktionen mit Mixins hinzuzufügen. Ein <a href="https://stackoverflow.com/a/547714" rel="nofollow">Mixin</a> ist eine Klasse, die dazu bestimmt ist, eine vorhandene Klasse mit einem Satz spezifischer Funktionen durch Mehrfachvererbung zu erweitern. <code>huggingface_hub</code> bietet sein eigenes Mixin, das <code>ModelHubMixin</code>. Der Schlüssel hier ist zu verstehen, wie es funktioniert und wie man es anpassen kann.',Ee,L,Il="Die Klasse [ModelHubMixin] implementiert 3 <em>öffentliche</em> Methoden (<code>push_to_hub</code>, <code>save_pretrained</code> und <code>from_pretrained</code>). Dies sind die Methoden, die Ihre Benutzer aufrufen werden, um Modelle mit Ihrer Bibliothek zu laden/speichern. <code>ModelHubMixin</code> definiert auch 2 private Methoden (<code>_save_pretrained</code> und <code>_from_pretrained</code>). Diese müssen Sie implementieren. Um Ihre Bibliothek zu integrieren, sollten Sie:",Ve,Q,gl=`<li>Lassen Sie Ihre Modell-Klasse von <code>ModelHubMixin</code> erben.</li> <li>Implementieren Sie die privaten Methoden:<ul><li><code>_save_pretrained()</code>: Methode, die als Eingabe einen Pfad zu einem Verzeichnis nimmt und das Modell dort speichert. Sie müssen die gesamte Logik zum Speichern Ihres Modells in dieser Methode schreiben: Modellkarte, Modellgewichte, Konfigurationsdateien, Trainingsprotokolle und Diagramme. Alle relevanten Informationen für dieses Modell müssen von dieser Methode behandelt werden.
<a href="https://huggingface.co/docs/hub/model-cards" rel="nofollow">Model Cards</a> sind besonders wichtig, um Ihr Modell zu beschreiben. Weitere Details finden Sie in <a href="./model-cards">unserem Implementierungsleitfaden</a>.</li> <li>[~ModelHubMixin._from_pretrained]: <strong>Klassenmethode</strong>, die als Eingabe eine <code>model_id</code> nimmt und ein instanziiertes Modell zurückgibt. Die Methode muss die relevanten Dateien herunterladen und laden.</li></ul></li> <li>Sie sind fertig!</li>`,Se,X,Cl="Der Vorteil der Verwendung von <code>ModelHubMixin</code> besteht darin, dass Sie, sobald Sie sich um die Serialisierung/das Laden der Dateien gekümmert haben, bereit sind los zu legen. Sie müssen sich keine Gedanken über Dinge wie Repository-Erstellung, Commits, PRs oder Revisionen machen. All dies wird von dem Mixin gehandhabt und steht Ihren Benutzern zur Verfügung. Das Mixin stellt auch sicher, dass öffentliche Methoden gut dokumentiert und typisiert sind.",xe,N,$e,Y,kl="Ein gutes Beispiel für das, was wir oben gesehen haben, ist <code>PyTorchModelHubMixin</code>, unsere Integration für das PyTorch-Framework. Dies ist eine einsatzbereite Integration.",Re,D,Fe,P,_l="Hier ist, wie jeder Benutzer ein PyTorch-Modell vom/auf den Hub laden/speichern kann:",Le,K,Qe,q,Xe,O,Bl='Die Implementierung ist tatsächlich sehr einfach, und die vollständige Implementierung finden Sie <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hub_mixin.py" rel="nofollow">hier</a>.',Ne,ee,vl="<li>Zuerst, erben Ihrer Klasse von <code>ModelHubMixin</code>:</li>",Ye,le,De,w,Zl="<li>Implementieren der <code>_save_pretrained</code> Methode:</li>",Pe,ne,Ke,b,Al="<li>Implementieren der <code>_from_pretrained</code> Methode:</li>",qe,te,Oe,se,Wl="Und das war’s! Ihre Bibliothek ermöglicht es Benutzern nun, Dateien vom und zum Hub hoch- und herunterzuladen.",el,ie,ll,ae,zl="Lassen Sie uns die beiden Ansätze, die wir gesehen haben, schnell mit ihren Vor- und Nachteilen zusammenfassen. Die untenstehende Tabelle ist nur indikativ. Ihr Framework könnte einige Besonderheiten haben, die Sie berücksichtigen müssen. Dieser Leitfaden soll nur Richtlinien und Ideen geben, wie Sie die Integration handhaben können. Kontaktieren Sie uns in jedem Fall, wenn Sie Fragen haben!",nl,re,Gl='<thead><tr><th align="center">Integration</th> <th align="center">Mit Helfern</th> <th align="center">Mit <code>ModelHubMixin</code></th></tr></thead> <tbody><tr><td align="center">Benutzererfahrung</td> <td align="center"><code>model = load_from_hub(...)</code><br/><code>push_to_hub(model, ...)</code></td> <td align="center"><code>model = MyModel.from_pretrained(...)</code><br/><code>model.push_to_hub(...)</code></td></tr> <tr><td align="center">Flexibilität</td> <td align="center">Sehr flexibel.<br/>Sie haben die volle Kontrolle über die Implementierung.</td> <td align="center">Weniger flexibel.<br/>Ihr Framework muss eine Modellklasse haben.</td></tr> <tr><td align="center">Wartung</td> <td align="center">Mehr Wartung, um Unterstützung für Konfiguration und neue Funktionen hinzuzufügen. Könnte auch das Beheben von Benutzerproblemen erfordern.</td> <td align="center">Weniger Wartung, da die meisten Interaktionen mit dem Hub in <code>huggingface_hub</code> implementiert sind.</td></tr> <tr><td align="center">Dokumentation/Typ-Annotation</td> <td align="center">Manuell zu schreiben.</td> <td align="center">Teilweise durch <code>huggingface_hub</code> behandelt.</td></tr></tbody>',tl,oe,sl;return j=new u({props:{title:"Integrieren Sie jedes ML-Framework mit dem Hub",local:"integrieren-sie-jedes-ml-framework-mit-dem-hub",headingTag:"h1"}}),g=new u({props:{title:"Ein flexibler Ansatz: Helfer",local:"ein-flexibler-ansatz-helfer",headingTag:"h2"}}),_=new u({props:{title:"from_pretrained",local:"frompretrained",headingTag:"h3"}}),v=new Me({props:{code:"ZGVmJTIwZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTNBJTIwc3RyKSUyMC0lM0UlMjBNeU1vZGVsQ2xhc3MlM0ElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjB2b20lMjBIdWIlMjBoZXJ1bnRlcmxhZGVuJTBBJTIwJTIwJTIwY2FjaGVkX21vZGVsJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMHJlcG9faWQlM0RyZXBvX2lkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZmlsZW5hbWUlM0QlMjJtb2RlbC5wa2wlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X25hbWUlM0QlMjJmYXN0YWklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBsaWJyYXJ5X3ZlcnNpb24lM0RnZXRfZmFzdGFpX3ZlcnNpb24oKSUyQyUwQSUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjBsYWRlbiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGxvYWRfbW9kZWwoY2FjaGVkX21vZGVsKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">from_pretrained</span>(<span class="hljs-params">model_id: <span class="hljs-built_in">str</span></span>) -&gt; MyModelClass:
   <span class="hljs-comment"># Modell vom Hub herunterladen</span>
   cached_model = hf_hub_download(
      repo_id=repo_id,
      filename=<span class="hljs-string">&quot;model.pkl&quot;</span>,
      library_name=<span class="hljs-string">&quot;fastai&quot;</span>,
      library_version=get_fastai_version(),
   )

   <span class="hljs-comment"># Modell laden</span>
    <span class="hljs-keyword">return</span> load_model(cached_model)`,wrap:!1}}),Z=new u({props:{title:"push_to_hub",local:"pushtohub",headingTag:"h3"}}),W=new Me({props:{code:"ZGVmJTIwcHVzaF90b19odWIobW9kZWwlM0ElMjBNeU1vZGVsQ2xhc3MlMkMlMjByZXBvX25hbWUlM0ElMjBzdHIpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjBhcGklMjAlM0QlMjBIZkFwaSgpJTBBJTBBJTIwJTIwJTIwJTIzJTIwUmVwbyUyMGVyc3RlbGxlbiUyQyUyMHdlbm4lMjBub2NoJTIwbmljaHQlMjB2b3JoYW5kZW4lMjB1bmQlMjBkaWUlMjB6dWdlaCVDMyVCNnJpZ2UlMjByZXBvX2lkJTIwZXJoYWx0ZW4lMEElMjAlMjAlMjByZXBvX2lkJTIwJTNEJTIwYXBpLmNyZWF0ZV9yZXBvKHJlcG9fbmFtZSUyQyUyMGV4aXN0X29rJTNEVHJ1ZSklMEElMEElMjAlMjAlMjAlMjMlMjBNb2RlbGwlMjBpbiUyMHRlbXBvciVDMyVBNHJlbSUyME9yZG5lciUyMHNwZWljaGVybiUyMHVuZCUyMGluJTIwZWluZW0lMjBlbnppZ2VuJTIwQ29tbWl0JTIwcHVzaGVuJTBBJTIwJTIwJTIwd2l0aCUyMFRlbXBvcmFyeURpcmVjdG9yeSgpJTIwYXMlMjB0bXBkaXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjB0bXBkaXIlMjAlM0QlMjBQYXRoKHRtcGRpciklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZXdpY2h0ZSUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMHNhdmVfbW9kZWwobW9kZWwlMkMlMjB0bXBkaXIlMjAlMkYlMjAlMjJtb2RlbC5zYWZldGVuc29ycyUyMiklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNb2RlbGxrYXJ0ZSUyMGdlbmVyaWVyZW4lMEElMjAlMjAlMjAlMjAlMjAlMjBjYXJkJTIwJTNEJTIwZ2VuZXJhdGVfbW9kZWxfY2FyZChtb2RlbCklMEElMjAlMjAlMjAlMjAlMjAlMjAodG1wZGlyJTIwJTJGJTIwJTIyUkVBRE1FLm1kJTIyKS53cml0ZV90ZXh0KGNhcmQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTG9ncyUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMERpYWdyYW1tZSUyMHNwZWljaGVybiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEV2YWx1YXRpb25zbWV0cmlrZW4lMjBzcGVpY2hlcm4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBdWYlMjBkZW4lMjBIdWIlMjBwdXNoZW4lMEElMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBhcGkudXBsb2FkX2ZvbGRlcihyZXBvX2lkJTNEcmVwb19pZCUyQyUyMGZvbGRlcl9wYXRoJTNEdG1wZGlyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">push_to_hub</span>(<span class="hljs-params">model: MyModelClass, repo_name: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-literal">None</span>:
   api = HfApi()

   <span class="hljs-comment"># Repo erstellen, wenn noch nicht vorhanden und die zugehörige repo_id erhalten</span>
   repo_id = api.create_repo(repo_name, exist_ok=<span class="hljs-literal">True</span>)

   <span class="hljs-comment"># Modell in temporärem Ordner speichern und in einem enzigen Commit pushen</span>
   <span class="hljs-keyword">with</span> TemporaryDirectory() <span class="hljs-keyword">as</span> tmpdir:
      tmpdir = Path(tmpdir)

      <span class="hljs-comment"># Gewichte speichern</span>
      save_model(model, tmpdir / <span class="hljs-string">&quot;model.safetensors&quot;</span>)

      <span class="hljs-comment"># Modellkarte generieren</span>
      card = generate_model_card(model)
      (tmpdir / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(card)

      <span class="hljs-comment"># Logs speichern</span>
      <span class="hljs-comment"># Diagramme speichern</span>
      <span class="hljs-comment"># Evaluationsmetriken speichern</span>
      <span class="hljs-comment"># ...</span>

      <span class="hljs-comment"># Auf den Hub pushen</span>
      <span class="hljs-keyword">return</span> api.upload_folder(repo_id=repo_id, folder_path=tmpdir)`,wrap:!1}}),G=new u({props:{title:"Einschränkungen",local:"einschränkungen",headingTag:"h3"}}),$=new u({props:{title:"Ein komplexerer Ansatz: Klassenvererbung",local:"ein-komplexerer-ansatz-klassenvererbung",headingTag:"h2"}}),N=new u({props:{title:"Ein konkretes Beispiel: PyTorch",local:"ein-konkretes-beispiel-pytorch",headingTag:"h3"}}),D=new u({props:{title:"Wie verwendet man es?",local:"wie-verwendet-man-es",headingTag:"h4"}}),K=new Me({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5ubiUyMGFzJTIwbm4lMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwUHlUb3JjaE1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyME15TW9kZWwobm4uTW9kdWxlJTJDJTIwUHlUb3JjaE1vZGVsSHViTWl4aW4pJTNBJTIwJTIzJTIwTWVocmZhY2h2ZXJlcmJ1bmclMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYucGFyYW0lMjAlM0QlMjBubi5QYXJhbWV0ZXIodG9yY2gucmFuZCgzJTJDJTIwNCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5saW5lYXIlMjAlM0QlMjBubi5MaW5lYXIoNCUyQyUyMDUpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIweCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmxpbmVhcih4JTIwJTJCJTIwc2VsZi5wYXJhbSklMEFtb2RlbCUyMCUzRCUyME15TW9kZWwoKSUwQSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteS1hd2Vzb21lLW1vZGVsJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMm15LWF3ZXNvbWUtbW9kZWwlMjIpJTBBJTBBbW9kZWwlMjAlM0QlMjBNeU1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15LWF3ZXNvbWUtbW9kZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch.nn <span class="hljs-keyword">as</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> PyTorchModelHubMixin

<span class="hljs-comment"># 1. Definieren Sie Ihr Pytorch-Modell genau so, wie Sie es gewohnt sind</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">class</span> <span class="hljs-title class_">MyModel</span>(nn.Module, PyTorchModelHubMixin): <span class="hljs-comment"># Mehrfachvererbung</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
<span class="hljs-meta">... </span>        <span class="hljs-built_in">super</span>().__init__() 
<span class="hljs-meta">... </span>        self.param = nn.Parameter(torch.rand(<span class="hljs-number">3</span>, <span class="hljs-number">4</span>))
<span class="hljs-meta">... </span>        self.linear = nn.Linear(<span class="hljs-number">4</span>, <span class="hljs-number">5</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x</span>):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> self.linear(x + self.param)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel()

<span class="hljs-comment"># 2. (optional) Modell in lokales Verzeichnis speichern</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;path/to/my-awesome-model&quot;</span>)

<span class="hljs-comment"># 3. Modellgewichte an den Hub übertragen</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(<span class="hljs-string">&quot;my-awesome-model&quot;</span>)

<span class="hljs-comment"># 4. Modell vom Hub initialisieren</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MyModel.from_pretrained(<span class="hljs-string">&quot;username/my-awesome-model&quot;</span>)`,wrap:!1}}),q=new u({props:{title:"Implementierung",local:"implementierung",headingTag:"h4"}}),le=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsSHViTWl4aW4lMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelHubMixin

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)`,wrap:!1}}),ne=new Me({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyME1vZGVsQ2FyZCUyQyUyME1vZGVsQ2FyZERhdGElMEElMEFjbGFzcyUyMFB5VG9yY2hNb2RlbEh1Yk1peGluKE1vZGVsSHViTWl4aW4pJTNBJTBBJTIwJTIwJTIwKC4uLiklMEElMEElMjAlMjAlMjBkZWYlMjBfc2F2ZV9wcmV0cmFpbmVkKHNlbGYlMkMlMjBzYXZlX2RpcmVjdG9yeSUzQSUyMFBhdGgpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyR2VuZXJpZXJlJTIwTW9kZWxsa2FydGUlMjB1bmQlMjBzcGVpY2hlcmUlMjBHZXdpY2h0ZSUyMHZvbiUyMGVpbmVtJTIwUHl0b3JjaC1Nb2RlbGwlMjBpbiUyMGVpbmVtJTIwbG9rYWxlbiUyMFZlcnplaWNobmlzLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX2NhcmQlMjAlM0QlMjBNb2RlbENhcmQuZnJvbV90ZW1wbGF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXJkX2RhdGElM0RNb2RlbENhcmREYXRhKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpY2Vuc2UlM0QnbWl0JyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxpYnJhcnlfbmFtZSUzRCUyMnB5dG9yY2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfc3VtbWFyeSUzRC4uLiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX3R5cGUlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwKHNhdmVfZGlyZWN0b3J5JTIwJTJGJTIwJTIyUkVBRE1FLm1kJTIyKS53cml0ZV90ZXh0KHN0cihtb2RlbCkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc2F2ZShvYmolM0RzZWxmLm1vZHVsZS5zdGF0ZV9kaWN0KCklMkMlMjBmJTNEc2F2ZV9kaXJlY3RvcnklMjAlMkYlMjAlMjJweXRvcmNoX21vZGVsLmJpbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> ModelCard, ModelCardData

<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_save_pretrained</span>(<span class="hljs-params">self, save_directory: Path</span>):
      <span class="hljs-string">&quot;&quot;&quot;Generiere Modellkarte und speichere Gewichte von einem Pytorch-Modell in einem lokalen Verzeichnis.&quot;&quot;&quot;</span>
      model_card = ModelCard.from_template(
         card_data=ModelCardData(
            license=<span class="hljs-string">&#x27;mit&#x27;</span>,
            library_name=<span class="hljs-string">&quot;pytorch&quot;</span>,
            ...
         ),
         model_summary=...,
         model_type=...,
         ...
      )
      (save_directory / <span class="hljs-string">&quot;README.md&quot;</span>).write_text(<span class="hljs-built_in">str</span>(model))
      torch.save(obj=self.module.state_dict(), f=save_directory / <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)`,wrap:!1}}),te=new Me({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PyTorchModelHubMixin</span>(<span class="hljs-title class_ inherited__">ModelHubMixin</span>):
   (...)

<span class="hljs-meta">   @classmethod </span><span class="hljs-comment"># Muss eine Klassenmethode sein!</span>
   <span class="hljs-keyword">def</span> <span class="hljs-title function_">_from_pretrained</span>(<span class="hljs-params">
      cls,
      *,
      model_id: <span class="hljs-built_in">str</span>,
      revision: <span class="hljs-built_in">str</span>,
      cache_dir: <span class="hljs-built_in">str</span>,
      force_download: <span class="hljs-built_in">bool</span>,
      proxies: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>],
      resume_download: <span class="hljs-built_in">bool</span>,
      local_files_only: <span class="hljs-built_in">bool</span>,
      token: <span class="hljs-type">Union</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>, <span class="hljs-literal">None</span>],
      map_location: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;cpu&quot;</span>, <span class="hljs-comment"># zusätzliches Argument</span>
      strict: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>, <span class="hljs-comment"># zusätzliches Argument</span>
      **model_kwargs,
   </span>):
      <span class="hljs-string">&quot;&quot;&quot;Load Pytorch pretrained weights and return the loaded model.&quot;&quot;&quot;</span>
      <span class="hljs-keyword">if</span> os.path.isdir(model_id): <span class="hljs-comment"># Kann entweder ein lokales Verzeichnis sein</span>
         <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loading weights from local directory&quot;</span>)
         model_file = os.path.join(model_id, <span class="hljs-string">&quot;pytorch_model.bin&quot;</span>)
      <span class="hljs-keyword">else</span>: <span class="hljs-comment"># Oder ein Modell am Hub</span>
         model_file = hf_hub_download( <span class="hljs-comment"># Herunterladen vom Hub, gleiche Eingabeargumente</span>
            repo_id=model_id,
            filename=<span class="hljs-string">&quot;pytorch_model.bin&quot;</span>,
            revision=revision,
            cache_dir=cache_dir,
            force_download=force_download,
            proxies=proxies,
            resume_download=resume_download,
            token=token,
            local_files_only=local_files_only,
         )

      <span class="hljs-comment"># Modell laden und zurückgeben - benutzerdefinierte Logik je nach Ihrem Framework</span>
      model = cls(**model_kwargs)
      state_dict = torch.load(model_file, map_location=torch.device(map_location))
      model.load_state_dict(state_dict, strict=strict)
      model.<span class="hljs-built_in">eval</span>()
      <span class="hljs-keyword">return</span> model`,wrap:!1}}),ie=new u({props:{title:"Kurzer Vergleich",local:"kurzer-vergleich",headingTag:"h2"}}),{c(){y=a("meta"),pe=s(),de=a("p"),he=s(),d(j.$$.fragment),me=s(),T=a("p"),T.innerHTML=rl,ce=s(),J=a("p"),J.textContent=Ml,ue=s(),U=a("ol"),U.innerHTML=dl,ye=s(),f=a("p"),f.textContent=ol,we=s(),I=a("p"),I.innerHTML=pl,be=s(),d(g.$$.fragment),je=s(),C=a("p"),C.innerHTML=hl,Te=s(),k=a("p"),k.textContent=ml,Je=s(),d(_.$$.fragment),Ue=s(),B=a("p"),B.innerHTML=cl,fe=s(),d(v.$$.fragment),Ie=s(),d(Z.$$.fragment),ge=s(),A=a("p"),A.innerHTML=ul,Ce=s(),d(W.$$.fragment),ke=s(),z=a("p"),z.innerHTML=yl,_e=s(),d(G.$$.fragment),Be=s(),H=a("p"),H.innerHTML=wl,ve=s(),E=a("ul"),E.innerHTML=bl,Ze=s(),V=a("p"),V.textContent=jl,Ae=s(),S=a("ul"),S.innerHTML=Tl,We=s(),x=a("p"),x.innerHTML=Jl,ze=s(),d($.$$.fragment),Ge=s(),R=a("p"),R.innerHTML=Ul,He=s(),F=a("p"),F.innerHTML=fl,Ee=s(),L=a("p"),L.innerHTML=Il,Ve=s(),Q=a("ol"),Q.innerHTML=gl,Se=s(),X=a("p"),X.innerHTML=Cl,xe=s(),d(N.$$.fragment),$e=s(),Y=a("p"),Y.innerHTML=kl,Re=s(),d(D.$$.fragment),Fe=s(),P=a("p"),P.textContent=_l,Le=s(),d(K.$$.fragment),Qe=s(),d(q.$$.fragment),Xe=s(),O=a("p"),O.innerHTML=Bl,Ne=s(),ee=a("ol"),ee.innerHTML=vl,Ye=s(),d(le.$$.fragment),De=s(),w=a("ol"),w.innerHTML=Zl,Pe=s(),d(ne.$$.fragment),Ke=s(),b=a("ol"),b.innerHTML=Al,qe=s(),d(te.$$.fragment),Oe=s(),se=a("p"),se.textContent=Wl,el=s(),d(ie.$$.fragment),ll=s(),ae=a("p"),ae.textContent=zl,nl=s(),re=a("table"),re.innerHTML=Gl,tl=s(),oe=a("p"),this.h()},l(e){const l=Rl("svelte-u9bgzb",document.head);y=r(l,"META",{name:!0,content:!0}),l.forEach(n),pe=i(e),de=r(e,"P",{}),Hl(de).forEach(n),he=i(e),o(j.$$.fragment,e),me=i(e),T=r(e,"P",{"data-svelte-h":!0}),M(T)!=="svelte-1uv5xno"&&(T.innerHTML=rl),ce=i(e),J=r(e,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1wuvm32"&&(J.textContent=Ml),ue=i(e),U=r(e,"OL",{"data-svelte-h":!0}),M(U)!=="svelte-j81ug"&&(U.innerHTML=dl),ye=i(e),f=r(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-18fkufj"&&(f.textContent=ol),we=i(e),I=r(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1iwhhmw"&&(I.innerHTML=pl),be=i(e),o(g.$$.fragment,e),je=i(e),C=r(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-d1foe8"&&(C.innerHTML=hl),Te=i(e),k=r(e,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1v7bx6l"&&(k.textContent=ml),Je=i(e),o(_.$$.fragment,e),Ue=i(e),B=r(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-1m7ctz2"&&(B.innerHTML=cl),fe=i(e),o(v.$$.fragment,e),Ie=i(e),o(Z.$$.fragment,e),ge=i(e),A=r(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-12y5xmc"&&(A.innerHTML=ul),Ce=i(e),o(W.$$.fragment,e),ke=i(e),z=r(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-calp58"&&(z.innerHTML=yl),_e=i(e),o(G.$$.fragment,e),Be=i(e),H=r(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-bl4t77"&&(H.innerHTML=wl),ve=i(e),E=r(e,"UL",{"data-svelte-h":!0}),M(E)!=="svelte-knqj8g"&&(E.innerHTML=bl),Ze=i(e),V=r(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1lnppi9"&&(V.textContent=jl),Ae=i(e),S=r(e,"UL",{"data-svelte-h":!0}),M(S)!=="svelte-q0zixo"&&(S.innerHTML=Tl),We=i(e),x=r(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-w69vgv"&&(x.innerHTML=Jl),ze=i(e),o($.$$.fragment,e),Ge=i(e),R=r(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1kz5ea2"&&(R.innerHTML=Ul),He=i(e),F=r(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-d3dywx"&&(F.innerHTML=fl),Ee=i(e),L=r(e,"P",{"data-svelte-h":!0}),M(L)!=="svelte-18mc3qm"&&(L.innerHTML=Il),Ve=i(e),Q=r(e,"OL",{"data-svelte-h":!0}),M(Q)!=="svelte-l8lpe8"&&(Q.innerHTML=gl),Se=i(e),X=r(e,"P",{"data-svelte-h":!0}),M(X)!=="svelte-116c8ma"&&(X.innerHTML=Cl),xe=i(e),o(N.$$.fragment,e),$e=i(e),Y=r(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1macysc"&&(Y.innerHTML=kl),Re=i(e),o(D.$$.fragment,e),Fe=i(e),P=r(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1el4w9u"&&(P.textContent=_l),Le=i(e),o(K.$$.fragment,e),Qe=i(e),o(q.$$.fragment,e),Xe=i(e),O=r(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-oavmpb"&&(O.innerHTML=Bl),Ne=i(e),ee=r(e,"OL",{"data-svelte-h":!0}),M(ee)!=="svelte-zz071o"&&(ee.innerHTML=vl),Ye=i(e),o(le.$$.fragment,e),De=i(e),w=r(e,"OL",{start:!0,"data-svelte-h":!0}),M(w)!=="svelte-8qqg6p"&&(w.innerHTML=Zl),Pe=i(e),o(ne.$$.fragment,e),Ke=i(e),b=r(e,"OL",{start:!0,"data-svelte-h":!0}),M(b)!=="svelte-1tllved"&&(b.innerHTML=Al),qe=i(e),o(te.$$.fragment,e),Oe=i(e),se=r(e,"P",{"data-svelte-h":!0}),M(se)!=="svelte-13k5c2u"&&(se.textContent=Wl),el=i(e),o(ie.$$.fragment,e),ll=i(e),ae=r(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1mc7cfl"&&(ae.textContent=zl),nl=i(e),re=r(e,"TABLE",{"data-svelte-h":!0}),M(re)!=="svelte-1or8grg"&&(re.innerHTML=Gl),tl=i(e),oe=r(e,"P",{}),Hl(oe).forEach(n),this.h()},h(){il(y,"name","hf:doc:metadata"),il(y,"content",Ql),il(w,"start","2"),il(b,"start","3")},m(e,l){Fl(document.head,y),t(e,pe,l),t(e,de,l),t(e,he,l),p(j,e,l),t(e,me,l),t(e,T,l),t(e,ce,l),t(e,J,l),t(e,ue,l),t(e,U,l),t(e,ye,l),t(e,f,l),t(e,we,l),t(e,I,l),t(e,be,l),p(g,e,l),t(e,je,l),t(e,C,l),t(e,Te,l),t(e,k,l),t(e,Je,l),p(_,e,l),t(e,Ue,l),t(e,B,l),t(e,fe,l),p(v,e,l),t(e,Ie,l),p(Z,e,l),t(e,ge,l),t(e,A,l),t(e,Ce,l),p(W,e,l),t(e,ke,l),t(e,z,l),t(e,_e,l),p(G,e,l),t(e,Be,l),t(e,H,l),t(e,ve,l),t(e,E,l),t(e,Ze,l),t(e,V,l),t(e,Ae,l),t(e,S,l),t(e,We,l),t(e,x,l),t(e,ze,l),p($,e,l),t(e,Ge,l),t(e,R,l),t(e,He,l),t(e,F,l),t(e,Ee,l),t(e,L,l),t(e,Ve,l),t(e,Q,l),t(e,Se,l),t(e,X,l),t(e,xe,l),p(N,e,l),t(e,$e,l),t(e,Y,l),t(e,Re,l),p(D,e,l),t(e,Fe,l),t(e,P,l),t(e,Le,l),p(K,e,l),t(e,Qe,l),p(q,e,l),t(e,Xe,l),t(e,O,l),t(e,Ne,l),t(e,ee,l),t(e,Ye,l),p(le,e,l),t(e,De,l),t(e,w,l),t(e,Pe,l),p(ne,e,l),t(e,Ke,l),t(e,b,l),t(e,qe,l),p(te,e,l),t(e,Oe,l),t(e,se,l),t(e,el,l),p(ie,e,l),t(e,ll,l),t(e,ae,l),t(e,nl,l),t(e,re,l),t(e,tl,l),t(e,oe,l),sl=!0},p:Vl,i(e){sl||(h(j.$$.fragment,e),h(g.$$.fragment,e),h(_.$$.fragment,e),h(v.$$.fragment,e),h(Z.$$.fragment,e),h(W.$$.fragment,e),h(G.$$.fragment,e),h($.$$.fragment,e),h(N.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(q.$$.fragment,e),h(le.$$.fragment,e),h(ne.$$.fragment,e),h(te.$$.fragment,e),h(ie.$$.fragment,e),sl=!0)},o(e){m(j.$$.fragment,e),m(g.$$.fragment,e),m(_.$$.fragment,e),m(v.$$.fragment,e),m(Z.$$.fragment,e),m(W.$$.fragment,e),m(G.$$.fragment,e),m($.$$.fragment,e),m(N.$$.fragment,e),m(D.$$.fragment,e),m(K.$$.fragment,e),m(q.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(ie.$$.fragment,e),sl=!1},d(e){e&&(n(pe),n(de),n(he),n(me),n(T),n(ce),n(J),n(ue),n(U),n(ye),n(f),n(we),n(I),n(be),n(je),n(C),n(Te),n(k),n(Je),n(Ue),n(B),n(fe),n(Ie),n(ge),n(A),n(Ce),n(ke),n(z),n(_e),n(Be),n(H),n(ve),n(E),n(Ze),n(V),n(Ae),n(S),n(We),n(x),n(ze),n(Ge),n(R),n(He),n(F),n(Ee),n(L),n(Ve),n(Q),n(Se),n(X),n(xe),n($e),n(Y),n(Re),n(Fe),n(P),n(Le),n(Qe),n(Xe),n(O),n(Ne),n(ee),n(Ye),n(De),n(w),n(Pe),n(Ke),n(b),n(qe),n(Oe),n(se),n(el),n(ll),n(ae),n(nl),n(re),n(tl),n(oe)),n(y),c(j,e),c(g,e),c(_,e),c(v,e),c(Z,e),c(W,e),c(G,e),c($,e),c(N,e),c(D,e),c(K,e),c(q,e),c(le,e),c(ne,e),c(te,e),c(ie,e)}}}const Ql='{"title":"Integrieren Sie jedes ML-Framework mit dem Hub","local":"integrieren-sie-jedes-ml-framework-mit-dem-hub","sections":[{"title":"Ein flexibler Ansatz: Helfer","local":"ein-flexibler-ansatz-helfer","sections":[{"title":"from_pretrained","local":"frompretrained","sections":[],"depth":3},{"title":"push_to_hub","local":"pushtohub","sections":[],"depth":3},{"title":"Einschränkungen","local":"einschränkungen","sections":[],"depth":3}],"depth":2},{"title":"Ein komplexerer Ansatz: Klassenvererbung","local":"ein-komplexerer-ansatz-klassenvererbung","sections":[{"title":"Ein konkretes Beispiel: PyTorch","local":"ein-konkretes-beispiel-pytorch","sections":[{"title":"Wie verwendet man es?","local":"wie-verwendet-man-es","sections":[],"depth":4},{"title":"Implementierung","local":"implementierung","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Kurzer Vergleich","local":"kurzer-vergleich","sections":[],"depth":2}],"depth":1}';function Xl(al){return Sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends xl{constructor(y){super(),$l(this,y,Xl,Ll,El,{})}}export{Kl as component};
