import{s as me,o as fe,n as At}from"../chunks/scheduler.852ec091.js";import{S as de,i as ce,g as r,s as l,r as f,A as be,h as p,f as n,c as s,j as re,u as d,x as m,k as pe,y as ye,a,v as c,d as b,t as y,w as g}from"../chunks/index.28275fd3.js";import{T as Ft}from"../chunks/Tip.9f398c59.js";import{C as nt}from"../chunks/CodeBlock.c866bcf2.js";import{H as U,E as ge}from"../chunks/getInferenceSnippets.e7882860.js";function ue(M){let i,u='Learn more in the bitsandbytes Transformers integration <a href="https://huggingface.co/docs/transformers/quantization#bitsandbytes" rel="nofollow">guide</a>.';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1w7limx"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:At,d(o){o&&n(i)}}}function he(M){let i,u='bfloat16 is the ideal <code>compute_dtype</code> if your hardware supports it. While the default <code>compute_dtype</code>, float32, ensures backward compatibility (due to wide-ranging hardware support) and numerical stability, it is large and slows down computations. In contrast, float16 is smaller and faster but can lead to numerical instabilities. bfloat16 combines the best aspects of both; it offers the numerical stability of float32 and the reduced memory footprint and speed of a 16-bit data type. Check if your hardware supports bfloat16 and configure it using the <code>bnb_4bit_compute_dtype</code> parameter in <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a>!';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-wrbsfd"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:At,d(o){o&&n(i)}}}function Me(M){let i,u='Learn more in the bitsandbytes PEFT integration <a href="https://huggingface.co/docs/peft/developer_guides/quantization#quantization" rel="nofollow">guide</a>.';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-fb2nbh"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:At,d(o){o&&n(i)}}}function $e(M){let i,u='Learn more in the bitsandbytes Accelerate integration <a href="https://huggingface.co/docs/accelerate/usage_guides/quantization" rel="nofollow">guide</a>.';return{c(){i=r("p"),i.innerHTML=u},l(o){i=p(o,"P",{"data-svelte-h":!0}),m(i)!=="svelte-d2bgce"&&(i.innerHTML=u)},m(o,h){a(o,i,h)},p:At,d(o){o&&n(i)}}}function we(M){let i,u,o,h,C,it,J,Qt="bitsandbytes is widely integrated with many of the libraries in the Hugging Face and wider PyTorch ecosystem. This guide provides a brief overview of the integrations and how to use bitsandbytes with them. For more details, you should refer to the linked documentation for each library.",lt,v,st,$,ot,Z,Et='With Transformers, it’s very easy to load any model in 4 or 8-bit and quantize them on the fly. To configure the quantization parameters, specify them in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">BitsAndBytesConfig</a> class.',rt,j,Vt="For example, to load and quantize a model to 4-bits and use the bfloat16 data type for compute:",pt,w,mt,B,ft,X,dt,G,Yt='You can use any of the 8-bit or paged optimizers with Transformers by passing them to the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class on initialization. All bitsandbytes optimizers are supported by passing the correct string in the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> <code>optim</code> parameter. For example, to load a <a href="/docs/bitsandbytes/main/en/reference/optim/adamw#bitsandbytes.optim.PagedAdamW32bit">PagedAdamW32bit</a> optimizer:',ct,W,bt,k,yt,T,gt,z,It="PEFT builds on the bitsandbytes Transformers integration, and extends it for training with a few more steps. Let’s prepare the 4-bit model from the section above for training.",ut,L,Nt="Call the <code>~peft.prepare_model_for_kbit_training</code> method to prepare the model for training. This only works for Transformers models!",ht,R,Mt,H,Pt="Setup a <code>~peft.LoraConfig</code> to use QLoRA:",$t,x,wt,F,qt="Now call the <code>~peft.get_peft_model</code> function on your model and config to create a trainable <code>PeftModel</code>.",Tt,A,_t,Q,Ut,_,Ct,E,St='bitsandbytes is also easily usable from Accelerate and you can quantize any PyTorch model by passing a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.BnbQuantizationConfig" rel="nofollow">BnbQuantizationConfig</a> with your desired settings, and then calling the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.load_and_quantize_model" rel="nofollow">load_and_quantize_model</a> function to quantize it.',Jt,V,vt,Y,Zt,I,Dt="bitsandbytes is available from:",jt,N,Kt='<li><a href="https://lightning.ai/docs/pytorch/stable/" rel="nofollow">PyTorch Lightning</a>, a deep learning framework for professional AI researchers and machine learning engineers who need maximal flexibility without sacrificing performance at scale.</li> <li><a href="https://lightning.ai/docs/fabric/stable/" rel="nofollow">Lightning Fabric</a>, a fast and lightweight way to scale PyTorch models without boilerplate.</li>',Bt,P,Ot='Learn more in the bitsandbytes PyTorch Lightning integration <a href="https://lightning.ai/docs/pytorch/stable/common/precision_intermediate.html#quantization-via-bitsandbytes" rel="nofollow">guide</a>.',Xt,q,Gt,S,te='bitsandbytes is integrated with <a href="https://github.com/Lightning-AI/lit-gpt" rel="nofollow">Lit-GPT</a>, a hackable implementation of state-of-the-art open-source large language models. Lit-GPT is based on Lightning Fabric, and it can be used for quantization during training, finetuning, and inference.',Wt,D,ee='Learn more in the bitsandbytes Lit-GPT integration <a href="https://github.com/Lightning-AI/lit-gpt/blob/main/tutorials/quantize.md" rel="nofollow">guide</a>.',kt,K,zt,O,ne="To learn in more detail about some of bitsandbytes integrations, take a look at the following blog posts:",Lt,tt,ae='<li><a href="https://huggingface.co/blog/4bit-transformers-bitsandbytes" rel="nofollow">Making LLMs even more accessible with bitsandbytes, 4-bit quantization and QLoRA</a></li> <li><a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">A Gentle Introduction to 8-bit Matrix Multiplication for transformers at scale using Hugging Face Transformers, Accelerate and bitsandbytes</a></li>',Rt,et,Ht,at,xt;return C=new U({props:{title:"Integrations",local:"integrations",headingTag:"h1"}}),v=new U({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),$=new Ft({props:{warning:!1,$$slots:{default:[ue]},$$scope:{ctx:M}}}),w=new Ft({props:{warning:!0,$$slots:{default:[he]},$$scope:{ctx:M}}}),B=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQW1vZGVsXzRiaXQlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)
model_4bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),X=new U({props:{title:"8-bit optimizers",local:"8-bit-optimizers",headingTag:"h3"}}),W=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjAuLi4lMkMlMEElMjAlMjAlMjAlMjBvcHRpbSUzRCUyMnBhZ2VkX2FkYW13XzMyYml0JTIyJTJDJTBBKSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKG1vZGVsJTJDJTIwdHJhaW5pbmdfYXJncyUyQyUyMC4uLiklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

training_args = TrainingArguments(
    ...,
    optim=<span class="hljs-string">&quot;paged_adamw_32bit&quot;</span>,
)
trainer = Trainer(model, training_args, ...)
trainer.train()`,wrap:!1}}),k=new U({props:{title:"PEFT",local:"peft",headingTag:"h2"}}),T=new Ft({props:{warning:!1,$$slots:{default:[Me]},$$scope:{ctx:M}}}),R=new nt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBwcmVwYXJlX21vZGVsX2Zvcl9rYml0X3RyYWluaW5nJTBBJTBBbW9kZWxfNGJpdCUyMCUzRCUyMHByZXBhcmVfbW9kZWxfZm9yX2tiaXRfdHJhaW5pbmcobW9kZWxfNGJpdCk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> prepare_model_for_kbit_training

model_4bit = prepare_model_for_kbit_training(model_4bit)`,wrap:!1}}),x=new nt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjByJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBsb3JhX2FscGhhJTNEOCUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTIyYWxsLWxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMDUlMEElMjAlMjAlMjAlMjBiaWFzJTNEJTIybm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRCUyMkNBVVNBTF9MTSUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(
    r=<span class="hljs-number">16</span>,
    lora_alpha=<span class="hljs-number">8</span>,
    target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>,
    lora_dropout=<span class="hljs-number">0.05</span>
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)`,wrap:!1}}),A=new nt({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWxfNGJpdCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model_4bit, config)`,wrap:!1}}),Q=new U({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),_=new Ft({props:{warning:!1,$$slots:{default:[$e]},$$scope:{ctx:M}}}),V=new nt({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBpbml0X2VtcHR5X3dlaWdodHMlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyUyQyUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsJTBBZnJvbSUyMG1pbmdwdC5tb2RlbCUyMGltcG9ydCUyMEdQVCUwQSUwQW1vZGVsX2NvbmZpZyUyMCUzRCUyMEdQVC5nZXRfZGVmYXVsdF9jb25maWcoKSUwQW1vZGVsX2NvbmZpZy5tb2RlbF90eXBlJTIwJTNEJTIwJ2dwdDIteGwnJTBBbW9kZWxfY29uZmlnLnZvY2FiX3NpemUlMjAlM0QlMjA1MDI1NyUwQW1vZGVsX2NvbmZpZy5ibG9ja19zaXplJTIwJTNEJTIwMTAyNCUwQSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMGVtcHR5X21vZGVsJTIwJTNEJTIwR1BUKG1vZGVsX2NvbmZpZyklMEElMEFibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJuYlF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwJTIwJTIzJTIwb3B0aW9uYWwlMEElMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG9wdGlvbmFsJTBBKSUwQSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMGxvYWRfYW5kX3F1YW50aXplX21vZGVsKCUwQSUyMCUyMGVtcHR5X21vZGVsJTJDJTBBJTIwJTIwd2VpZ2h0c19sb2NhdGlvbiUzRHdlaWdodHNfbG9jYXRpb24lMkMlMEElMjAlMjBibmJfcXVhbnRpemF0aW9uX2NvbmZpZyUzRGJuYl9xdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwZGV2aWNlX21hcCUyMCUzRCUyMCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> BnbQuantizationConfig, load_and_quantize_model
<span class="hljs-keyword">from</span> mingpt.model <span class="hljs-keyword">import</span> GPT

model_config = GPT.get_default_config()
model_config.model_type = <span class="hljs-string">&#x27;gpt2-xl&#x27;</span>
model_config.vocab_size = <span class="hljs-number">50257</span>
model_config.block_size = <span class="hljs-number">1024</span>

<span class="hljs-keyword">with</span> init_empty_weights():
    empty_model = GPT(model_config)

bnb_quantization_config = BnbQuantizationConfig(
  load_in_4bit=<span class="hljs-literal">True</span>,
  bnb_4bit_compute_dtype=torch.bfloat16,  <span class="hljs-comment"># optional</span>
  bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,         <span class="hljs-comment"># optional</span>
  bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>               <span class="hljs-comment"># optional</span>
)

quantized_model = load_and_quantize_model(
  empty_model,
  weights_location=weights_location,
  bnb_quantization_config=bnb_quantization_config,
  device_map = <span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Y=new U({props:{title:"PyTorch Lightning and Lightning Fabric",local:"pytorch-lightning-and-lightning-fabric",headingTag:"h2"}}),q=new U({props:{title:"Lit-GPT",local:"lit-gpt",headingTag:"h2"}}),K=new U({props:{title:"Blog posts",local:"blog-posts",headingTag:"h2"}}),et=new ge({props:{source:"https://github.com/bitsandbytes-foundation/bitsandbytes/blob/main/docs/source/integrations.mdx"}}),{c(){i=r("meta"),u=l(),o=r("p"),h=l(),f(C.$$.fragment),it=l(),J=r("p"),J.textContent=Qt,lt=l(),f(v.$$.fragment),st=l(),f($.$$.fragment),ot=l(),Z=r("p"),Z.innerHTML=Et,rt=l(),j=r("p"),j.textContent=Vt,pt=l(),f(w.$$.fragment),mt=l(),f(B.$$.fragment),ft=l(),f(X.$$.fragment),dt=l(),G=r("p"),G.innerHTML=Yt,ct=l(),f(W.$$.fragment),bt=l(),f(k.$$.fragment),yt=l(),f(T.$$.fragment),gt=l(),z=r("p"),z.textContent=It,ut=l(),L=r("p"),L.innerHTML=Nt,ht=l(),f(R.$$.fragment),Mt=l(),H=r("p"),H.innerHTML=Pt,$t=l(),f(x.$$.fragment),wt=l(),F=r("p"),F.innerHTML=qt,Tt=l(),f(A.$$.fragment),_t=l(),f(Q.$$.fragment),Ut=l(),f(_.$$.fragment),Ct=l(),E=r("p"),E.innerHTML=St,Jt=l(),f(V.$$.fragment),vt=l(),f(Y.$$.fragment),Zt=l(),I=r("p"),I.textContent=Dt,jt=l(),N=r("ul"),N.innerHTML=Kt,Bt=l(),P=r("p"),P.innerHTML=Ot,Xt=l(),f(q.$$.fragment),Gt=l(),S=r("p"),S.innerHTML=te,Wt=l(),D=r("p"),D.innerHTML=ee,kt=l(),f(K.$$.fragment),zt=l(),O=r("p"),O.textContent=ne,Lt=l(),tt=r("ul"),tt.innerHTML=ae,Rt=l(),f(et.$$.fragment),Ht=l(),at=r("p"),this.h()},l(t){const e=be("svelte-u9bgzb",document.head);i=p(e,"META",{name:!0,content:!0}),e.forEach(n),u=s(t),o=p(t,"P",{}),re(o).forEach(n),h=s(t),d(C.$$.fragment,t),it=s(t),J=p(t,"P",{"data-svelte-h":!0}),m(J)!=="svelte-17oloa0"&&(J.textContent=Qt),lt=s(t),d(v.$$.fragment,t),st=s(t),d($.$$.fragment,t),ot=s(t),Z=p(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-t09m1v"&&(Z.innerHTML=Et),rt=s(t),j=p(t,"P",{"data-svelte-h":!0}),m(j)!=="svelte-fugr8i"&&(j.textContent=Vt),pt=s(t),d(w.$$.fragment,t),mt=s(t),d(B.$$.fragment,t),ft=s(t),d(X.$$.fragment,t),dt=s(t),G=p(t,"P",{"data-svelte-h":!0}),m(G)!=="svelte-rupil2"&&(G.innerHTML=Yt),ct=s(t),d(W.$$.fragment,t),bt=s(t),d(k.$$.fragment,t),yt=s(t),d(T.$$.fragment,t),gt=s(t),z=p(t,"P",{"data-svelte-h":!0}),m(z)!=="svelte-945c4h"&&(z.textContent=It),ut=s(t),L=p(t,"P",{"data-svelte-h":!0}),m(L)!=="svelte-16xvigi"&&(L.innerHTML=Nt),ht=s(t),d(R.$$.fragment,t),Mt=s(t),H=p(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-xc51cl"&&(H.innerHTML=Pt),$t=s(t),d(x.$$.fragment,t),wt=s(t),F=p(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-x8ok68"&&(F.innerHTML=qt),Tt=s(t),d(A.$$.fragment,t),_t=s(t),d(Q.$$.fragment,t),Ut=s(t),d(_.$$.fragment,t),Ct=s(t),E=p(t,"P",{"data-svelte-h":!0}),m(E)!=="svelte-wlkf6t"&&(E.innerHTML=St),Jt=s(t),d(V.$$.fragment,t),vt=s(t),d(Y.$$.fragment,t),Zt=s(t),I=p(t,"P",{"data-svelte-h":!0}),m(I)!=="svelte-zm0jix"&&(I.textContent=Dt),jt=s(t),N=p(t,"UL",{"data-svelte-h":!0}),m(N)!=="svelte-c4dddp"&&(N.innerHTML=Kt),Bt=s(t),P=p(t,"P",{"data-svelte-h":!0}),m(P)!=="svelte-xrv468"&&(P.innerHTML=Ot),Xt=s(t),d(q.$$.fragment,t),Gt=s(t),S=p(t,"P",{"data-svelte-h":!0}),m(S)!=="svelte-jne5kj"&&(S.innerHTML=te),Wt=s(t),D=p(t,"P",{"data-svelte-h":!0}),m(D)!=="svelte-144d081"&&(D.innerHTML=ee),kt=s(t),d(K.$$.fragment,t),zt=s(t),O=p(t,"P",{"data-svelte-h":!0}),m(O)!=="svelte-hhb45g"&&(O.textContent=ne),Lt=s(t),tt=p(t,"UL",{"data-svelte-h":!0}),m(tt)!=="svelte-1opwyey"&&(tt.innerHTML=ae),Rt=s(t),d(et.$$.fragment,t),Ht=s(t),at=p(t,"P",{}),re(at).forEach(n),this.h()},h(){pe(i,"name","hf:doc:metadata"),pe(i,"content",Te)},m(t,e){ye(document.head,i),a(t,u,e),a(t,o,e),a(t,h,e),c(C,t,e),a(t,it,e),a(t,J,e),a(t,lt,e),c(v,t,e),a(t,st,e),c($,t,e),a(t,ot,e),a(t,Z,e),a(t,rt,e),a(t,j,e),a(t,pt,e),c(w,t,e),a(t,mt,e),c(B,t,e),a(t,ft,e),c(X,t,e),a(t,dt,e),a(t,G,e),a(t,ct,e),c(W,t,e),a(t,bt,e),c(k,t,e),a(t,yt,e),c(T,t,e),a(t,gt,e),a(t,z,e),a(t,ut,e),a(t,L,e),a(t,ht,e),c(R,t,e),a(t,Mt,e),a(t,H,e),a(t,$t,e),c(x,t,e),a(t,wt,e),a(t,F,e),a(t,Tt,e),c(A,t,e),a(t,_t,e),c(Q,t,e),a(t,Ut,e),c(_,t,e),a(t,Ct,e),a(t,E,e),a(t,Jt,e),c(V,t,e),a(t,vt,e),c(Y,t,e),a(t,Zt,e),a(t,I,e),a(t,jt,e),a(t,N,e),a(t,Bt,e),a(t,P,e),a(t,Xt,e),c(q,t,e),a(t,Gt,e),a(t,S,e),a(t,Wt,e),a(t,D,e),a(t,kt,e),c(K,t,e),a(t,zt,e),a(t,O,e),a(t,Lt,e),a(t,tt,e),a(t,Rt,e),c(et,t,e),a(t,Ht,e),a(t,at,e),xt=!0},p(t,[e]){const ie={};e&2&&(ie.$$scope={dirty:e,ctx:t}),$.$set(ie);const le={};e&2&&(le.$$scope={dirty:e,ctx:t}),w.$set(le);const se={};e&2&&(se.$$scope={dirty:e,ctx:t}),T.$set(se);const oe={};e&2&&(oe.$$scope={dirty:e,ctx:t}),_.$set(oe)},i(t){xt||(b(C.$$.fragment,t),b(v.$$.fragment,t),b($.$$.fragment,t),b(w.$$.fragment,t),b(B.$$.fragment,t),b(X.$$.fragment,t),b(W.$$.fragment,t),b(k.$$.fragment,t),b(T.$$.fragment,t),b(R.$$.fragment,t),b(x.$$.fragment,t),b(A.$$.fragment,t),b(Q.$$.fragment,t),b(_.$$.fragment,t),b(V.$$.fragment,t),b(Y.$$.fragment,t),b(q.$$.fragment,t),b(K.$$.fragment,t),b(et.$$.fragment,t),xt=!0)},o(t){y(C.$$.fragment,t),y(v.$$.fragment,t),y($.$$.fragment,t),y(w.$$.fragment,t),y(B.$$.fragment,t),y(X.$$.fragment,t),y(W.$$.fragment,t),y(k.$$.fragment,t),y(T.$$.fragment,t),y(R.$$.fragment,t),y(x.$$.fragment,t),y(A.$$.fragment,t),y(Q.$$.fragment,t),y(_.$$.fragment,t),y(V.$$.fragment,t),y(Y.$$.fragment,t),y(q.$$.fragment,t),y(K.$$.fragment,t),y(et.$$.fragment,t),xt=!1},d(t){t&&(n(u),n(o),n(h),n(it),n(J),n(lt),n(st),n(ot),n(Z),n(rt),n(j),n(pt),n(mt),n(ft),n(dt),n(G),n(ct),n(bt),n(yt),n(gt),n(z),n(ut),n(L),n(ht),n(Mt),n(H),n($t),n(wt),n(F),n(Tt),n(_t),n(Ut),n(Ct),n(E),n(Jt),n(vt),n(Zt),n(I),n(jt),n(N),n(Bt),n(P),n(Xt),n(Gt),n(S),n(Wt),n(D),n(kt),n(zt),n(O),n(Lt),n(tt),n(Rt),n(Ht),n(at)),n(i),g(C,t),g(v,t),g($,t),g(w,t),g(B,t),g(X,t),g(W,t),g(k,t),g(T,t),g(R,t),g(x,t),g(A,t),g(Q,t),g(_,t),g(V,t),g(Y,t),g(q,t),g(K,t),g(et,t)}}}const Te='{"title":"Integrations","local":"integrations","sections":[{"title":"Transformers","local":"transformers","sections":[{"title":"8-bit optimizers","local":"8-bit-optimizers","sections":[],"depth":3}],"depth":2},{"title":"PEFT","local":"peft","sections":[],"depth":2},{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Lightning and Lightning Fabric","local":"pytorch-lightning-and-lightning-fabric","sections":[],"depth":2},{"title":"Lit-GPT","local":"lit-gpt","sections":[],"depth":2},{"title":"Blog posts","local":"blog-posts","sections":[],"depth":2}],"depth":1}';function _e(M){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class je extends de{constructor(i){super(),ce(this,i,_e,we,me,{})}}export{je as component};
