import{s as oa,f as Nl,n as Aa,o as pa}from"../chunks/scheduler.65852ee5.js";import{S as ra,i as Ma,g as i,s as n,r as p,A as ca,h as o,f as s,c as a,j as ia,u as r,x as A,k as Jt,y as Ua,a as l,v as M,d as c,t as U,w as u}from"../chunks/index.65a1b999.js";import{D as ua,C as m}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as d,E as ma}from"../chunks/getInferenceSnippets.5a9e4eba.js";function da(Ql){let w,gt,bt,vt,f,Ft,y,Bt,h,Xl='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',It,j,xl="This notebook demonstrates how you can build an advanced RAG (Retrieval Augmented Generation) for answering a user’s question about a specific knowledge base (here, the HuggingFace documentation), using LangChain.",kt,T,ql='For an introduction to RAG, you can check <a href="rag_zephyr_langchain">this other cookbook</a>!',Et,J,Hl="RAG systems are complex, with many moving parts: here is a RAG diagram, where we noted in blue all possibilities for system enhancement:",Kt,R,Wl,Vt,b,Gl="<p>💡 As you can see, there are many steps to tune in this architecture: tuning the system properly will yield significant performance gains.</p>",Nt,C,Pl="In this notebook, we will take a look into many of these blue notes to see how to tune your RAG system and get the best performance.",Qt,g,zl="<strong>Let’s dig into the model building!</strong> First, we install the required model dependencies.",Xt,v,xt,F,qt,B,Ht,I,Wt,k,Gt,E,Pt,K,Zl="The <strong>retriever acts like an internal search engine</strong>: given the user query, it returns a few relevant snippets from your knowledge base.",zt,V,Ll="These snippets will then be fed to the Reader Model to help it generate its answer.",Zt,N,Sl="So <strong>our objective here is, given a user question, to find the most relevant snippets from our knowledge base to answer that question.</strong>",Lt,Q,Dl="This is a wide objective, it leaves open some questions. How many snippets should we retrieve? This parameter will be named <code>top_k</code>.",St,X,Yl="How long should these snippets be? This is called the <code>chunk size</code>. There’s no one-size-fits-all answers, but here are a few elements:",Dt,x,_l='<li>🔀 Your <code>chunk size</code> is allowed to vary from one snippet to the other.</li> <li>Since there will always be some noise in your retrieval, increasing the <code>top_k</code> increases the chance to get relevant elements in your retrieved snippets. 🎯 Shooting more arrows increases your probability of hitting your target.</li> <li>Meanwhile, the summed length of your retrieved documents should not be too high: for instance, for most current models 16k tokens will probably drown your Reader model in information due to <a href="https://huggingface.co/papers/2307.03172" rel="nofollow">Lost-in-the-middle phenomenon</a>. 🎯 Give your reader model only the most relevant insights, not a huge pile of books!</li>',Yt,q,Ol="<p>In this notebook, we use Langchain library since <strong>it offers a huge variety of options for vector databases and allows us to keep document metadata throughout the processing</strong>.</p>",_t,H,Ot,W,$l="<li>In this part, <strong>we split the documents from our knowledge base into smaller chunks</strong> which will be the snippets on which the reader LLM will base its answer.</li> <li>The goal is to prepare a collection of <strong>semantically relevant snippets</strong>. So their size should be adapted to precise ideas: too small will truncate ideas, and too large will dilute them.</li>",$t,G,en='💡 <em>Many options exist for text splitting: splitting on words, on sentence boundaries, recursive chunking that processes documents in a tree-like way to preserve structure information… To learn more about chunking, I recommend you read <a href="https://github.com/FullStackRetrieval-com/RetrievalTutorials/blob/main/tutorials/LevelsOfTextSplitting/5_Levels_Of_Text_Splitting.ipynb" rel="nofollow">this great notebook</a> by Greg Kamradt.</em>',es,P,tn="<li><p><strong>Recursive chunking</strong> breaks down the text into smaller parts step by step using a given list of separators sorted from the most important to the least important separator. If the first split doesn’t give the right size or shape of chunks, the method repeats itself on the new chunks using a different separator. For instance with the list of separators <code>[&quot;\\n\\n&quot;, &quot;\\n&quot;, &quot;.&quot;, &quot;&quot;]</code>:</p> <ul><li>The method will first break down the document wherever there is a double line break <code>&quot;\\n\\n&quot;</code>.</li> <li>Resulting documents will be split again on simple line breaks <code>&quot;\\n&quot;</code>, then on sentence ends <code>&quot;.&quot;</code>.</li> <li>Finally, if some chunks are still too big, they will be split whenever they overflow the maximum size.</li></ul></li> <li><p>With this method, the global structure is well preserved, at the expense of getting slight variations in chunk size.</p></li>",ts,z,sn='<p><a href="https://huggingface.co/spaces/A-Roucher/chunk_visualizer" rel="nofollow">This space</a> lets you visualize how different splitting options affect the chunks you get.</p>',ss,Z,ln="🔬 Let’s experiment a bit with chunk sizes, beginning with an arbitrary size, and see how splits work. We use Langchain’s implementation of recursive chunking with <code>RecursiveCharacterTextSplitter</code>.",ls,L,nn="<li>Parameter <code>chunk_size</code> controls the length of individual chunks: this length is counted by default as the number of characters in the chunk.</li> <li>Parameter <code>chunk_overlap</code> lets adjacent chunks get a bit of overlap on each other. This reduces the probability that an idea could be cut in half by the split between two adjacent chunks. We ~arbitrarily set this to 1/10th of the chunk size, you could try different values!</li>",ns,S,as,D,an="We also have to keep in mind that when embedding documents, we will use an embedding model that accepts a certain maximum sequence length <code>max_seq_length</code>.",is,Y,on="So we should make sure that our chunk sizes are below this limit because any longer chunk will be truncated before processing, thus losing relevancy.",os,_,As,O,An=`Model's maximum sequence length: 512
`,ps,$,pn="👀 As you can see, <strong>the chunk lengths are not aligned with our limit of 512 tokens</strong>, and some documents are above the limit, thus some part of them will be lost in truncation!",rs,ee,rn="<li>So we should change the <code>RecursiveCharacterTextSplitter</code> class to count length in number of tokens instead of number of characters.</li> <li>Then we can choose a specific chunk size, here we would choose a lower threshold than 512:<ul><li>Smaller documents could allow the split to focus more on specific ideas.</li> <li>But too small chunks would split sentences in half, thus losing meaning again: the proper tuning is a matter of balance.</li></ul></li>",Ms,te,cs,Rt,Mn,Us,se,cn="➡️ Now the chunk length distribution looks better!",us,le,ms,ne,Un='We want to compute the embeddings for all the chunks of our knowledge base: to learn more about sentence embeddings, we recommend reading <a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/" rel="nofollow">this guide</a>.',ds,ae,ws,ie,un="Once the chunks are all embedded, we store them in a vector database. When the user types in a query, it gets embedded by the same model previously used, and a similarity search returns the closest documents from the vector database.",fs,oe,mn="The technical challenge is thus, given a query vector, to quickly find the nearest neighbors of this vector in the vector database. To do this, we need to choose two things: a distance, and a search algorithm to find the nearest neighbors quickly within a database of thousands of records.",ys,Ae,hs,pe,dn='There are plentiful choices for the nearest neighbor search algorithm: we go with Facebook’s <a href="https://github.com/facebookresearch/faiss" rel="nofollow">FAISS</a> since FAISS is performant enough for most use cases, and it is well known and thus widely implemented.',js,re,Ts,Me,wn='Regarding distances, you can find a good guide <a href="https://osanseviero.github.io/hackerllama/blog/posts/sentence_embeddings/#distance-between-embeddings" rel="nofollow">here</a>. In short:',Js,ce,fn="<li><strong>Cosine similarity</strong> computes the similarity between two vectors as the cosinus of their relative angle: it allows us to compare vector directions regardless of their magnitude. Using it requires normalizing all vectors, to rescale them into unit norm.</li> <li><strong>Dot product</strong> takes into account magnitude, with the sometimes undesirable effect that increasing a vector’s length will make it more similar to all others.</li> <li><strong>Euclidean distance</strong> is the distance between the ends of vectors.</li>",Rs,Ue,yn='You can try <a href="https://developers.google.com/machine-learning/clustering/similarity/check-your-understanding" rel="nofollow">this small exercise</a> to check your understanding of these concepts. But once vectors are normalized, <a href="https://platform.openai.com/docs/guides/embeddings/which-distance-function-should-i-use" rel="nofollow">the choice of a specific distance does not matter much</a>.',bs,ue,hn="Our particular model works well with cosine similarity, so choose this distance, and we set it up both in the Embedding model, and in the <code>distance_strategy</code> argument of our FAISS index. With cosine similarity, we have to normalize our embeddings.",Cs,me,jn="🚨👇 The cell below takes a few minutes to run on A10G!",gs,de,vs,we,Tn="👀 To visualize the search for the closest documents, let’s project our embeddings from 384 dimensions down to 2 dimensions using PaCMAP.",Fs,fe,Jn='💡 <em>We chose PaCMAP rather than other techniques such as t-SNE or UMAP, since <a href="https://www.nature.com/articles/s42003-022-03628-x#Abs1" rel="nofollow">it is efficient (preserves local and global structure), robust to initialization parameters and fast</a>.</em>',Bs,ye,Is,he,ks,je,Es,Te,Rn,Ks,Je,bn="➡️ On the graph above, you can see a spatial representation of the knowledge base documents. As the vector embeddings represent the document’s meaning, their closeness in meaning should be reflected in their embedding’s closeness.",Vs,Re,Cn="The user query’s embedding is also shown: we want to find the <code>k</code> documents that have the closest meaning, thus we pick the <code>k</code> closest vectors.",Ns,be,gn="In the LangChain vector database implementation, this search operation is performed by the method <code>vector_database.similarity_search(query)</code>.",Qs,Ce,vn="Here is the result:",Xs,ge,xs,ve,Fn=`Starting retrieval for user_query='How to create a pipeline object?'...

==================================Top document==================================
\`\`\`

## Available Pipelines:
==================================Metadata==================================
&#123;'source': 'huggingface/diffusers/blob/main/docs/source/en/api/pipelines/deepfloyd_if.md', 'start_index': 16887}
`,qs,Fe,Hs,Be,Bn="In this part, the <strong>LLM Reader reads the retrieved context to formulate its answer.</strong>",Ws,Ie,In="There are substeps that can all be tuned:",Gs,ke,kn="<li>The content of the retrieved documents is aggregated together into the “context”, with many processing options like <em>prompt compression</em>.</li> <li>The context and the user query are aggregated into a prompt and then given to the LLM to generate its answer.</li>",Ps,Ee,zs,Ke,En="The choice of a reader model is important in a few aspects:",Zs,Ve,Kn="<li>the reader model’s <code>max_seq_length</code> must accommodate our prompt, which includes the context output by the retriever call: the context consists of 5 documents of 512 tokens each, so we aim for a context length of 4k tokens at least.</li> <li>the reader model</li>",Ls,Ne,Vn='For this example, we chose <a href="https://huggingface.co/HuggingFaceH4/zephyr-7b-beta" rel="nofollow"><code>HuggingFaceH4/zephyr-7b-beta</code></a>, a small but powerful model.',Ss,Qe,Nn='With many models being released every week, you may want to substitute this model to the latest and greatest. The best way to keep track of open source LLMs is to check the <a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open-source LLM leaderboard</a>.',Ds,Xe,Qn="To make inference faster, we will load the quantized version of the model:",Ys,xe,_s,qe,Os,He,$s,We,Xn="The RAG prompt template below is what we will feed to the Reader LLM: it is important to have it formatted in the Reader LLM’s chat template.",el,Ge,xn="We give it our context and the user’s question.",tl,Pe,sl,ze,qn=`<|system|>
Using the information contained in the context, 
give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If the answer cannot be deduced from the context, do not give an answer.
<|user|>
Context:
&#123;context}
---
Now here is the question you need to answer.

Question: &#123;question}
<|assistant|>
`,ll,Ze,Hn="Let’s test our Reader on our previously retrieved documents!",nl,Le,al,Se,Wn=`To create a pipeline object, follow these steps:

1. Define the inputs and outputs of your pipeline. These could be strings, dictionaries, or any other format that best suits your use case.

2. Inherit the \`Pipeline\` class from the \`transformers\` module and implement the following methods:

   - \`preprocess\`: This method takes the raw inputs and returns a preprocessed dictionary that can be passed to the model.

   - \`_forward\`: This method performs the actual inference using the model and returns the output tensor.

   - \`postprocess\`: This method takes the output tensor and returns the final output in the desired format.

   - \`_sanitize_parameters\`: This method is used to sanitize the input parameters before passing them to the model.

3. Load the necessary components, such as the model and scheduler, into the pipeline object.

4. Instantiate the pipeline object and return it.

Here's an example implementation based on the given context:

\`\`\`python
from transformers import Pipeline
import torch
from diffusers import StableDiffusionPipeline

class MyPipeline(Pipeline):
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.pipe = StableDiffusionPipeline.from_pretrained("my_model")

    def preprocess(self, inputs):
        # Preprocess the inputs as needed
        return &#123;"input_ids":...}

    def _forward(self, inputs):
        # Run the forward pass of the model
        return self.pipe(**inputs).images[0]

    def postprocess(self, outputs):
        # Postprocess the outputs as needed
        return outputs["sample"]

    def _sanitize_parameters(self, params):
        # Sanitize the input parameters
        return params

my_pipeline = MyPipeline()
result = my_pipeline("My input string")
print(result)
\`\`\`

Note that this implementation assumes that the model and scheduler are already loaded into memory. If they need to be loaded dynamically, you can modify the \`__init__\` method accordingly.
`,il,De,ol,Ye,Gn="A good option for RAG is to retrieve more documents than you want in the end, then rerank the results with a more powerful retrieval model before keeping only the <code>top_k</code>.",Al,_e,Pn='For this, <a href="https://arxiv.org/abs/2112.01488" rel="nofollow">Colbertv2</a> is a great choice: instead of a bi-encoder like our classical embedding models, it is a cross-encoder that computes more fine-grained interactions between the query tokens and each document’s tokens.',pl,Oe,zn='It is easily usable thanks to <a href="https://github.com/bclavie/RAGatouille" rel="nofollow">the RAGatouille library</a>.',rl,$e,Ml,et,cl,tt,Ul,st,Zn="Let’s see how our RAG pipeline answers a user query.",ul,lt,ml,nt,Ln=`=> Retrieving documents...
`,dl,at,wl,it,Sn=`==================================Answer==================================
To create a pipeline object, follow these steps:

1. Import the \`pipeline\` function from the \`transformers\` module:

   \`\`\`python
   from transformers import pipeline
   \`\`\`

2. Choose the task you want to perform, such as object detection, sentiment analysis, or image generation, and pass it as an argument to the \`pipeline\` function:

   - For object detection:

     \`\`\`python
     >>> object_detector = pipeline('object-detection')
     >>> object_detector(image)
     [&#123;'score': 0.9982201457023621,
       'label':'remote',
       'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
     ...]
     \`\`\`

   - For sentiment analysis:

     \`\`\`python
     >>> classifier = pipeline("sentiment-analysis")
     >>> classifier("This is a great product!")
     &#123;'labels': ['POSITIVE'],'scores': tensor([0.9999], device='cpu', dtype=torch.float32)}
     \`\`\`

   - For image generation:

     \`\`\`python
     >>> image = pipeline(
    ... "stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
    ... ).images[0]
     >>> image
     PILImage mode RGB size 7680x4320 at 0 DPI
     \`\`\`

Note that the exact syntax may vary depending on the specific pipeline being used. Refer to the documentation for more details on how to use each pipeline.

In general, the process involves importing the necessary modules, selecting the desired pipeline task, and passing it to the \`pipeline\` function along with any required arguments. The resulting pipeline object can then be used to perform the selected task on input data.
==================================Source docs==================================
Document 0------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object-detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 1------------------------------------------------------------
# Allocate a pipeline for object detection
>>> object_detector = pipeline('object_detection')
>>> object_detector(image)
[&#123;'score': 0.9982201457023621,
  'label': 'remote',
  'box': &#123;'xmin': 40, 'ymin': 70, 'xmax': 175, 'ymax': 117}},
 &#123;'score': 0.9960021376609802,
  'label': 'remote',
  'box': &#123;'xmin': 333, 'ymin': 72, 'xmax': 368, 'ymax': 187}},
 &#123;'score': 0.9954745173454285,
  'label': 'couch',
  'box': &#123;'xmin': 0, 'ymin': 1, 'xmax': 639, 'ymax': 473}},
 &#123;'score': 0.9988006353378296,
  'label': 'cat',
  'box': &#123;'xmin': 13, 'ymin': 52, 'xmax': 314, 'ymax': 470}},
 &#123;'score': 0.9986783862113953,
  'label': 'cat',
  'box': &#123;'xmin': 345, 'ymin': 23, 'xmax': 640, 'ymax': 368}}]
Document 2------------------------------------------------------------
Start by creating an instance of [\`pipeline\`] and specifying a task you want to use it for. In this guide, you'll use the [\`pipeline\`] for sentiment analysis as an example:

\`\`\`py
>>> from transformers import pipeline

>>> classifier = pipeline("sentiment-analysis")
Document 3------------------------------------------------------------
\`\`\`

## Add the pipeline to 🤗 Transformers

If you want to contribute your pipeline to 🤗 Transformers, you will need to add a new module in the \`pipelines\` submodule
with the code of your pipeline, then add it to the list of tasks defined in \`pipelines/__init__.py\`.

Then you will need to add tests. Create a new file \`tests/test_pipelines_MY_PIPELINE.py\` with examples of the other tests.

The \`run_pipeline_test\` function will be very generic and run on small random models on every possible
architecture as defined by \`model_mapping\` and \`tf_model_mapping\`.

This is very important to test future compatibility, meaning if someone adds a new model for
\`XXXForQuestionAnswering\` then the pipeline test will attempt to run on it. Because the models are random it's
impossible to check for actual values, that's why there is a helper \`ANY\` that will simply attempt to match the
output of the pipeline TYPE.

You also *need* to implement 2 (ideally 4) tests.

- \`test_small_model_pt\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_tf\`.
- \`test_small_model_tf\` : Define 1 small model for this pipeline (doesn't matter if the results don't make sense)
  and test the pipeline outputs. The results should be the same as \`test_small_model_pt\`.
- \`test_large_model_pt\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
- \`test_large_model_tf\` (\`optional\`): Tests the pipeline on a real pipeline where the results are supposed to
  make sense. These tests are slow and should be marked as such. Here the goal is to showcase the pipeline and to make
  sure there is no drift in future releases.
Document 4------------------------------------------------------------
\`\`\`

2. Pass a prompt to the pipeline to generate an image:

\`\`\`py
image = pipeline(
	"stained glass of darth vader, backlight, centered composition, masterpiece, photorealistic, 8k"
).images[0]
image
`,fl,ot,Dn="✅ We now have a fully functional, performant RAG system. That’s it for today! Congratulations for making it to the end 🥳",yl,At,hl,pt,Yn="This is not the end of the journey! You can try many steps to improve your RAG system. We recommend doing so in an iterative way: bring small changes to the system and see what improves performance.",jl,rt,Tl,Mt,_n="<li>💬 “You cannot improve the model performance that you do not measure”, said Gandhi… or at least Llama2 told me he said it. Anyway, you should absolutely start by measuring performance: this means building a small evaluation dataset, and then monitor the performance of your RAG system on this evaluation dataset.</li>",Jl,ct,Rl,Ut,On="🛠️ <strong>You can use these options to tune the results:</strong>",bl,ut,$n='<li>Tune the chunking method:<ul><li>Size of the chunks</li> <li>Method: split on different separators, use <a href="https://python.langchain.com/docs/modules/data_connection/document_transformers/semantic-chunker" rel="nofollow">semantic chunking</a>…</li></ul></li> <li>Change the embedding model</li>',Cl,mt,ea="👷‍♀️ <strong>More could be considered:</strong>",gl,dt,ta="<li>Try another chunking method, like semantic chunking</li> <li>Change the index used (here, FAISS)</li> <li>Query expansion: reformulate the user query in slightly different ways to retrieve more documents.</li>",vl,wt,Fl,ft,sa="🛠️ <strong>Here you can try the following options to improve results:</strong>",Bl,yt,la="<li>Tune the prompt</li> <li>Switch reranking on/off</li> <li>Choose a more powerful reader model</li>",Il,ht,na="💡 <strong>Many options could be considered here to further improve the results:</strong>",kl,jt,aa="<li>Compress the retrieved context to keep only the most relevant parts to answer the query.</li> <li>Extend the RAG system to make it more user-friendly:<ul><li>cite source</li> <li>make conversational</li></ul></li>",El,Tt,Kl,Ct,Vl;return f=new ua({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/advanced_rag.ipynb"}]}}),y=new d({props:{title:"Advanced RAG on Hugging Face documentation using LangChain",local:"advanced-rag-on-hugging-face-documentation-using-langchain",headingTag:"h1"}}),v=new m({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRvcmNoJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZSUyMGJpdHNhbmRieXRlcyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMG9wZW5weXhsJTIwcGFjbWFwJTIwZGF0YXNldHMlMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwcmFnYXRvdWlsbGU=",highlighted:"!pip install -q torch transformers accelerate bitsandbytes langchain sentence-transformers faiss-cpu openpyxl pacmap datasets langchain-community ragatouille",wrap:!1}}),F=new m({props:{code:"ZnJvbSUyMHRxZG0ubm90ZWJvb2slMjBpbXBvcnQlMjB0cWRtJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBPcHRpb25hbCUyQyUyMExpc3QlMkMlMjBUdXBsZSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMERhdGFzZXQlMEFpbXBvcnQlMjBtYXRwbG90bGliLnB5cGxvdCUyMGFzJTIwcGx0JTBBJTBBcGQuc2V0X29wdGlvbiglMjJkaXNwbGF5Lm1heF9jb2x3aWR0aCUyMiUyQyUyME5vbmUpJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBiZSUyMGhlbHBmdWwlMjB3aGVuJTIwdmlzdWFsaXppbmclMjByZXRyaWV2ZXIlMjBvdXRwdXRz",highlighted:`<span class="hljs-keyword">from</span> tqdm.notebook <span class="hljs-keyword">import</span> tqdm
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>, <span class="hljs-type">List</span>, <span class="hljs-type">Tuple</span>
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

pd.set_option(<span class="hljs-string">&quot;display.max_colwidth&quot;</span>, <span class="hljs-literal">None</span>)  <span class="hljs-comment"># This will be helpful when visualizing retriever outputs</span>`,wrap:!1}}),B=new d({props:{title:"Load your knowledge base",local:"load-your-knowledge-base",headingTag:"h3"}}),I=new m({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFkcyUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

ds = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),k=new m({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTIwYXMlMjBMYW5nY2hhaW5Eb2N1bWVudCUwQSUwQVJBV19LTk9XTEVER0VfQkFTRSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMExhbmdjaGFpbkRvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMHRxZG0oZHMpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document <span class="hljs-keyword">as</span> LangchainDocument

RAW_KNOWLEDGE_BASE = [
    LangchainDocument(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(ds)
]`,wrap:!1}}),E=new d({props:{title:"1. Retriever - embeddings 🗂️",local:"1-retriever---embeddings-",headingTag:"h1"}}),H=new d({props:{title:"1.1 Split the documents into chunks",local:"11-split-the-documents-into-chunks",headingTag:"h3"}}),S=new m({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBJTBBJTIzJTIwV2UlMjB1c2UlMjBhJTIwaGllcmFyY2hpY2FsJTIwbGlzdCUyMG9mJTIwc2VwYXJhdG9ycyUyMHNwZWNpZmljYWxseSUyMHRhaWxvcmVkJTIwZm9yJTIwc3BsaXR0aW5nJTIwTWFya2Rvd24lMjBkb2N1bWVudHMlMEElMjMlMjBUaGlzJTIwbGlzdCUyMGlzJTIwdGFrZW4lMjBmcm9tJTIwTGFuZ0NoYWluJ3MlMjBNYXJrZG93blRleHRTcGxpdHRlciUyMGNsYXNzJTBBTUFSS0RPV05fU0VQQVJBVE9SUyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMiU1Q24lMjMlN0IxJTJDNiU3RCUyMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMiU2MCU2MCU2MCU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTVDJTVDKiU1QyU1QyolNUMlNUMqJTJCJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMiU1Q24tLS0lMkIlNUNuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyJTVDbl9fXyUyQiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlNUNuJTVDbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMiU1Q24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlMjAlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjIlMjIlMkMlMEElNUQlMEElMEF0ZXh0X3NwbGl0dGVyJTIwJTNEJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyKCUwQSUyMCUyMCUyMCUyMGNodW5rX3NpemUlM0QxMDAwJTJDJTIwJTIwJTIzJTIwVGhlJTIwbWF4aW11bSUyMG51bWJlciUyMG9mJTIwY2hhcmFjdGVycyUyMGluJTIwYSUyMGNodW5rJTNBJTIwd2UlMjBzZWxlY3RlZCUyMHRoaXMlMjB2YWx1ZSUyMGFyYml0cmFyaWx5JTBBJTIwJTIwJTIwJTIwY2h1bmtfb3ZlcmxhcCUzRDEwMCUyQyUyMCUyMCUyMyUyMFRoZSUyMG51bWJlciUyMG9mJTIwY2hhcmFjdGVycyUyMHRvJTIwb3ZlcmxhcCUyMGJldHdlZW4lMjBjaHVua3MlMEElMjAlMjAlMjAlMjBhZGRfc3RhcnRfaW5kZXglM0RUcnVlJTJDJTIwJTIwJTIzJTIwSWYlMjAlNjBUcnVlJTYwJTJDJTIwaW5jbHVkZXMlMjBjaHVuaydzJTIwc3RhcnQlMjBpbmRleCUyMGluJTIwbWV0YWRhdGElMEElMjAlMjAlMjAlMjBzdHJpcF93aGl0ZXNwYWNlJTNEVHJ1ZSUyQyUyMCUyMCUyMyUyMElmJTIwJTYwVHJ1ZSU2MCUyQyUyMHN0cmlwcyUyMHdoaXRlc3BhY2UlMjBmcm9tJTIwdGhlJTIwc3RhcnQlMjBhbmQlMjBlbmQlMjBvZiUyMGV2ZXJ5JTIwZG9jdW1lbnQlMEElMjAlMjAlMjAlMjBzZXBhcmF0b3JzJTNETUFSS0RPV05fU0VQQVJBVE9SUyUyQyUwQSklMEElMEFkb2NzX3Byb2Nlc3NlZCUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMGRvYyUyMGluJTIwUkFXX0tOT1dMRURHRV9CQVNFJTNBJTBBJTIwJTIwJTIwJTIwZG9jc19wcm9jZXNzZWQlMjAlMkIlM0QlMjB0ZXh0X3NwbGl0dGVyLnNwbGl0X2RvY3VtZW50cyglNUJkb2MlNUQp",highlighted:`<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter

<span class="hljs-comment"># We use a hierarchical list of separators specifically tailored for splitting Markdown documents</span>
<span class="hljs-comment"># This list is taken from LangChain&#x27;s MarkdownTextSplitter class</span>
MARKDOWN_SEPARATORS = [
    <span class="hljs-string">&quot;\\n#{1,6} &quot;</span>,
    <span class="hljs-string">&quot;\`\`\`\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\\\*\\\\*\\\\*+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n---+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n___+\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n\\n&quot;</span>,
    <span class="hljs-string">&quot;\\n&quot;</span>,
    <span class="hljs-string">&quot; &quot;</span>,
    <span class="hljs-string">&quot;&quot;</span>,
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">1000</span>,  <span class="hljs-comment"># The maximum number of characters in a chunk: we selected this value arbitrarily</span>
    chunk_overlap=<span class="hljs-number">100</span>,  <span class="hljs-comment"># The number of characters to overlap between chunks</span>
    add_start_index=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, includes chunk&#x27;s start index in metadata</span>
    strip_whitespace=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># If \`True\`, strips whitespace from the start and end of every document</span>
    separators=MARKDOWN_SEPARATORS,
)

docs_processed = []
<span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> RAW_KNOWLEDGE_BASE:
    docs_processed += text_splitter.split_documents([doc])`,wrap:!1}}),_=new m({props:{code:"ZnJvbSUyMHNlbnRlbmNlX3RyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNlbnRlbmNlVHJhbnNmb3JtZXIlMEElMEElMjMlMjBUbyUyMGdldCUyMHRoZSUyMHZhbHVlJTIwb2YlMjB0aGUlMjBtYXglMjBzZXF1ZW5jZV9sZW5ndGglMkMlMjB3ZSUyMHdpbGwlMjBxdWVyeSUyMHRoZSUyMHVuZGVybHlpbmclMjAlNjBTZW50ZW5jZVRyYW5zZm9ybWVyJTYwJTIwb2JqZWN0JTIwdXNlZCUyMGluJTIwdGhlJTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBcHJpbnQoZiUyMk1vZGVsJ3MlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglM0ElMjAlN0JTZW50ZW5jZVRyYW5zZm9ybWVyKCd0aGVubHBlciUyRmd0ZS1zbWFsbCcpLm1heF9zZXFfbGVuZ3RoJTdEJTIyKSUwQSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIydGhlbmxwZXIlMkZndGUtc21hbGwlMjIpJTBBbGVuZ3RocyUyMCUzRCUyMCU1Qmxlbih0b2tlbml6ZXIuZW5jb2RlKGRvYy5wYWdlX2NvbnRlbnQpKSUyMGZvciUyMGRvYyUyMGluJTIwdHFkbShkb2NzX3Byb2Nlc3NlZCklNUQlMEElMEElMjMlMjBQbG90JTIwdGhlJTIwZGlzdHJpYnV0aW9uJTIwb2YlMjBkb2N1bWVudCUyMGxlbmd0aHMlMkMlMjBjb3VudGVkJTIwYXMlMjB0aGUlMjBudW1iZXIlMjBvZiUyMHRva2VucyUwQWZpZyUyMCUzRCUyMHBkLlNlcmllcyhsZW5ndGhzKS5oaXN0KCklMEFwbHQudGl0bGUoJTIyRGlzdHJpYnV0aW9uJTIwb2YlMjBkb2N1bWVudCUyMGxlbmd0aHMlMjBpbiUyMHRoZSUyMGtub3dsZWRnZSUyMGJhc2UlMjAoaW4lMjBjb3VudCUyMG9mJTIwdG9rZW5zKSUyMiklMEFwbHQuc2hvdygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To get the value of the max sequence_length, we will query the underlying \`SentenceTransformer\` object used in the RecursiveCharacterTextSplitter</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Model&#x27;s maximum sequence length: <span class="hljs-subst">{SentenceTransformer(<span class="hljs-string">&#x27;thenlper/gte-small&#x27;</span>).max_seq_length}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Plot the distribution of document lengths, counted as the number of tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig = pd.Series(lengths).hist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),te=new m({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>EMBEDDING_MODEL_NAME = <span class="hljs-string">&quot;thenlper/gte-small&quot;</span>


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">split_documents</span>(<span class="hljs-params">
<span class="hljs-meta">... </span>    chunk_size: <span class="hljs-built_in">int</span>,
<span class="hljs-meta">... </span>    knowledge_base: <span class="hljs-type">List</span>[LangchainDocument],
<span class="hljs-meta">... </span>    tokenizer_name: <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>] = EMBEDDING_MODEL_NAME,
<span class="hljs-meta">... </span></span>) -&gt; <span class="hljs-type">List</span>[LangchainDocument]:
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;
<span class="hljs-meta">... </span>    Split documents into chunks of maximum size \`chunk_size\` tokens and return a list of documents.
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
<span class="hljs-meta">... </span>        AutoTokenizer.from_pretrained(tokenizer_name),
<span class="hljs-meta">... </span>        chunk_size=chunk_size,
<span class="hljs-meta">... </span>        chunk_overlap=<span class="hljs-built_in">int</span>(chunk_size / <span class="hljs-number">10</span>),
<span class="hljs-meta">... </span>        add_start_index=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        strip_whitespace=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>        separators=MARKDOWN_SEPARATORS,
<span class="hljs-meta">... </span>    )

<span class="hljs-meta">... </span>    docs_processed = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base:
<span class="hljs-meta">... </span>        docs_processed += text_splitter.split_documents([doc])

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Remove duplicates</span>
<span class="hljs-meta">... </span>    unique_texts = {}
<span class="hljs-meta">... </span>    docs_processed_unique = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
<span class="hljs-meta">... </span>            unique_texts[doc.page_content] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            docs_processed_unique.append(doc)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> docs_processed_unique


<span class="hljs-meta">&gt;&gt;&gt; </span>docs_processed = split_documents(
<span class="hljs-meta">... </span>    <span class="hljs-number">512</span>,  <span class="hljs-comment"># We choose a chunk size adapted to our model</span>
<span class="hljs-meta">... </span>    RAW_KNOWLEDGE_BASE,
<span class="hljs-meta">... </span>    tokenizer_name=EMBEDDING_MODEL_NAME,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s visualize the chunk sizes we would have in tokens from a common model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(EMBEDDING_MODEL_NAME)
<span class="hljs-meta">&gt;&gt;&gt; </span>lengths = [<span class="hljs-built_in">len</span>(tokenizer.encode(doc.page_content)) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(docs_processed)]
<span class="hljs-meta">&gt;&gt;&gt; </span>fig = pd.Series(lengths).hist()
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.title(<span class="hljs-string">&quot;Distribution of document lengths in the knowledge base (in count of tokens)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.show()`,wrap:!1}}),le=new d({props:{title:"1.2 Building the vector database",local:"12-building-the-vector-database",headingTag:"h3"}}),ae=new d({props:{title:"How does retrieval work?",local:"how-does-retrieval-work",headingTag:"h4"}}),Ae=new d({props:{title:"Nearest Neighbor search algorithm",local:"nearest-neighbor-search-algorithm",headingTag:"h5"}}),re=new d({props:{title:"Distances",local:"distances",headingTag:"h5"}}),de=new m({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS52ZWN0b3JzdG9yZXMudXRpbHMlMjBpbXBvcnQlMjBEaXN0YW5jZVN0cmF0ZWd5JTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwSHVnZ2luZ0ZhY2VFbWJlZGRpbmdzKCUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlM0RFTUJFRERJTkdfTU9ERUxfTkFNRSUyQyUwQSUyMCUyMCUyMCUyMG11bHRpX3Byb2Nlc3MlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfa3dhcmdzJTNEJTdCJTIyZGV2aWNlJTIyJTNBJTIwJTIyY3VkYSUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMGVuY29kZV9rd2FyZ3MlM0QlN0IlMjJub3JtYWxpemVfZW1iZWRkaW5ncyUyMiUzQSUyMFRydWUlN0QlMkMlMjAlMjAlMjMlMjBTZXQlMjAlNjBUcnVlJTYwJTIwZm9yJTIwY29zaW5lJTIwc2ltaWxhcml0eSUwQSklMEElMEFLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoJTBBJTIwJTIwJTIwJTIwZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmdfbW9kZWwlMkMlMjBkaXN0YW5jZV9zdHJhdGVneSUzRERpc3RhbmNlU3RyYXRlZ3kuQ09TSU5FJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy

embedding_model = HuggingFaceEmbeddings(
    model_name=EMBEDDING_MODEL_NAME,
    multi_process=<span class="hljs-literal">True</span>,
    model_kwargs={<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda&quot;</span>},
    encode_kwargs={<span class="hljs-string">&quot;normalize_embeddings&quot;</span>: <span class="hljs-literal">True</span>},  <span class="hljs-comment"># Set \`True\` for cosine similarity</span>
)

KNOWLEDGE_VECTOR_DATABASE = FAISS.from_documents(
    docs_processed, embedding_model, distance_strategy=DistanceStrategy.COSINE
)`,wrap:!1}}),ye=new m({props:{code:"JTIzJTIwRW1iZWQlMjBhJTIwdXNlciUyMHF1ZXJ5JTIwaW4lMjB0aGUlMjBzYW1lJTIwc3BhY2UlMEF1c2VyX3F1ZXJ5JTIwJTNEJTIwJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMEFxdWVyeV92ZWN0b3IlMjAlM0QlMjBlbWJlZGRpbmdfbW9kZWwuZW1iZWRfcXVlcnkodXNlcl9xdWVyeSk=",highlighted:`<span class="hljs-comment"># Embed a user query in the same space</span>
user_query = <span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>
query_vector = embedding_model.embed_query(user_query)`,wrap:!1}}),he=new m({props:{code:"aW1wb3J0JTIwcGFjbWFwJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGxvdGx5LmV4cHJlc3MlMjBhcyUyMHB4JTBBJTBBZW1iZWRkaW5nX3Byb2plY3RvciUyMCUzRCUyMHBhY21hcC5QYUNNQVAobl9jb21wb25lbnRzJTNEMiUyQyUyMG5fbmVpZ2hib3JzJTNETm9uZSUyQyUyME1OX3JhdGlvJTNEMC41JTJDJTIwRlBfcmF0aW8lM0QyLjAlMkMlMjByYW5kb21fc3RhdGUlM0QxKSUwQSUwQWVtYmVkZGluZ3NfMmQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBsaXN0KEtOT1dMRURHRV9WRUNUT1JfREFUQUJBU0UuaW5kZXgucmVjb25zdHJ1Y3RfbihpZHglMkMlMjAxKSU1QjAlNUQpJTIwZm9yJTIwaWR4JTIwaW4lMjByYW5nZShsZW4oZG9jc19wcm9jZXNzZWQpKSUwQSU1RCUyMCUyQiUyMCU1QnF1ZXJ5X3ZlY3RvciU1RCUwQSUwQSUyMyUyMEZpdCUyMHRoZSUyMGRhdGElMjAodGhlJTIwaW5kZXglMjBvZiUyMHRyYW5zZm9ybWVkJTIwZGF0YSUyMGNvcnJlc3BvbmRzJTIwdG8lMjB0aGUlMjBpbmRleCUyMG9mJTIwdGhlJTIwb3JpZ2luYWwlMjBkYXRhKSUwQWRvY3VtZW50c19wcm9qZWN0ZWQlMjAlM0QlMjBlbWJlZGRpbmdfcHJvamVjdG9yLmZpdF90cmFuc2Zvcm0obnAuYXJyYXkoZW1iZWRkaW5nc18yZCklMkMlMjBpbml0JTNEJTIycGNhJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> pacmap
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> plotly.express <span class="hljs-keyword">as</span> px

embedding_projector = pacmap.PaCMAP(n_components=<span class="hljs-number">2</span>, n_neighbors=<span class="hljs-literal">None</span>, MN_ratio=<span class="hljs-number">0.5</span>, FP_ratio=<span class="hljs-number">2.0</span>, random_state=<span class="hljs-number">1</span>)

embeddings_2d = [
    <span class="hljs-built_in">list</span>(KNOWLEDGE_VECTOR_DATABASE.index.reconstruct_n(idx, <span class="hljs-number">1</span>)[<span class="hljs-number">0</span>]) <span class="hljs-keyword">for</span> idx <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
] + [query_vector]

<span class="hljs-comment"># Fit the data (the index of transformed data corresponds to the index of the original data)</span>
documents_projected = embedding_projector.fit_transform(np.array(embeddings_2d), init=<span class="hljs-string">&quot;pca&quot;</span>)`,wrap:!1}}),je=new m({props:{code:"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",highlighted:`df = pd.DataFrame.from_dict(
    [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[i, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[i, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: docs_processed[i].metadata[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;extract&quot;</span>: docs_processed[i].page_content[:<span class="hljs-number">100</span>] + <span class="hljs-string">&quot;...&quot;</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;circle&quot;</span>,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">4</span>,
        }
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(docs_processed))
    ]
    + [
        {
            <span class="hljs-string">&quot;x&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">0</span>],
            <span class="hljs-string">&quot;y&quot;</span>: documents_projected[-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
            <span class="hljs-string">&quot;source&quot;</span>: <span class="hljs-string">&quot;User query&quot;</span>,
            <span class="hljs-string">&quot;extract&quot;</span>: user_query,
            <span class="hljs-string">&quot;size_col&quot;</span>: <span class="hljs-number">100</span>,
            <span class="hljs-string">&quot;symbol&quot;</span>: <span class="hljs-string">&quot;star&quot;</span>,
        }
    ]
)

<span class="hljs-comment"># Visualize the embedding</span>
fig = px.scatter(
    df,
    x=<span class="hljs-string">&quot;x&quot;</span>,
    y=<span class="hljs-string">&quot;y&quot;</span>,
    color=<span class="hljs-string">&quot;source&quot;</span>,
    hover_data=<span class="hljs-string">&quot;extract&quot;</span>,
    size=<span class="hljs-string">&quot;size_col&quot;</span>,
    symbol=<span class="hljs-string">&quot;symbol&quot;</span>,
    color_discrete_map={<span class="hljs-string">&quot;User query&quot;</span>: <span class="hljs-string">&quot;black&quot;</span>},
    width=<span class="hljs-number">1000</span>,
    height=<span class="hljs-number">700</span>,
)
fig.update_traces(
    marker=<span class="hljs-built_in">dict</span>(opacity=<span class="hljs-number">1</span>, line=<span class="hljs-built_in">dict</span>(width=<span class="hljs-number">0</span>, color=<span class="hljs-string">&quot;DarkSlateGrey&quot;</span>)),
    selector=<span class="hljs-built_in">dict</span>(mode=<span class="hljs-string">&quot;markers&quot;</span>),
)
fig.update_layout(
    legend_title_text=<span class="hljs-string">&quot;&lt;b&gt;Chunk source&lt;/b&gt;&quot;</span>,
    title=<span class="hljs-string">&quot;&lt;b&gt;2D Projection of Chunk Embeddings via PaCMAP&lt;/b&gt;&quot;</span>,
)
fig.show()`,wrap:!1}}),ge=new m({props:{code:"cHJpbnQoZiUyMiU1Q25TdGFydGluZyUyMHJldHJpZXZhbCUyMGZvciUyMCU3QnVzZXJfcXVlcnklM0QlN0QuLi4lMjIpJTBBcmV0cmlldmVkX2RvY3MlMjAlM0QlMjBLTk9XTEVER0VfVkVDVE9SX0RBVEFCQVNFLnNpbWlsYXJpdHlfc2VhcmNoKHF1ZXJ5JTNEdXNlcl9xdWVyeSUyQyUyMGslM0Q1KSUwQXByaW50KCUyMiU1Q24lM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0RUb3AlMjBkb2N1bWVudCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFwcmludChyZXRyaWV2ZWRfZG9jcyU1QjAlNUQucGFnZV9jb250ZW50KSUwQXByaW50KCUyMiUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRE1ldGFkYXRhJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KHJldHJpZXZlZF9kb2NzJTVCMCU1RC5tZXRhZGF0YSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStarting retrieval for <span class="hljs-subst">{user_query=}</span>...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs = KNOWLEDGE_VECTOR_DATABASE.similarity_search(query=user_query, k=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n==================================Top document==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].page_content)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Metadata==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(retrieved_docs[<span class="hljs-number">0</span>].metadata)`,wrap:!1}}),Fe=new d({props:{title:"2. Reader - LLM 💬",local:"2-reader---llm-",headingTag:"h1"}}),Ee=new d({props:{title:"2.1. Reader model",local:"21-reader-model",headingTag:"h3"}}),xe=new m({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBUkVBREVSX01PREVMX05BTUUlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF91c2VfZG91YmxlX3F1YW50JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoUkVBREVSX01PREVMX05BTUUlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChSRUFERVJfTU9ERUxfTkFNRSklMEElMEFSRUFERVJfTExNJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjIlMkMlMEElMjAlMjAlMjAlMjByZXBldGl0aW9uX3BlbmFsdHklM0QxLjElMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDUwMCUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

READER_MODEL_NAME = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>

bnb_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)
model = AutoModelForCausalLM.from_pretrained(READER_MODEL_NAME, quantization_config=bnb_config)
tokenizer = AutoTokenizer.from_pretrained(READER_MODEL_NAME)

READER_LLM = pipeline(
    model=model,
    tokenizer=tokenizer,
    task=<span class="hljs-string">&quot;text-generation&quot;</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.2</span>,
    repetition_penalty=<span class="hljs-number">1.1</span>,
    return_full_text=<span class="hljs-literal">False</span>,
    max_new_tokens=<span class="hljs-number">500</span>,
)`,wrap:!1}}),qe=new m({props:{code:"UkVBREVSX0xMTSglMjJXaGF0JTIwaXMlMjA0JTJCNCUzRiUyMEFuc3dlciUzQSUyMik=",highlighted:'READER_LLM(<span class="hljs-string">&quot;What is 4+4? Answer:&quot;</span>)',wrap:!1}}),He=new d({props:{title:"2.2. Prompt",local:"22-prompt",headingTag:"h3"}}),Pe=new m({props:{code:"cHJvbXB0X2luX2NoYXRfZm9ybWF0JTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJVc2luZyUyMHRoZSUyMGluZm9ybWF0aW9uJTIwY29udGFpbmVkJTIwaW4lMjB0aGUlMjBjb250ZXh0JTJDJTBBZ2l2ZSUyMGElMjBjb21wcmVoZW5zaXZlJTIwYW5zd2VyJTIwdG8lMjB0aGUlMjBxdWVzdGlvbi4lMEFSZXNwb25kJTIwb25seSUyMHRvJTIwdGhlJTIwcXVlc3Rpb24lMjBhc2tlZCUyQyUyMHJlc3BvbnNlJTIwc2hvdWxkJTIwYmUlMjBjb25jaXNlJTIwYW5kJTIwcmVsZXZhbnQlMjB0byUyMHRoZSUyMHF1ZXN0aW9uLiUwQVByb3ZpZGUlMjB0aGUlMjBudW1iZXIlMjBvZiUyMHRoZSUyMHNvdXJjZSUyMGRvY3VtZW50JTIwd2hlbiUyMHJlbGV2YW50LiUwQUlmJTIwdGhlJTIwYW5zd2VyJTIwY2Fubm90JTIwYmUlMjBkZWR1Y2VkJTIwZnJvbSUyMHRoZSUyMGNvbnRleHQlMkMlMjBkbyUyMG5vdCUyMGdpdmUlMjBhbiUyMGFuc3dlci4lMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjIlMjIlMjJDb250ZXh0JTNBJTBBJTdCY29udGV4dCU3RCUwQS0tLSUwQU5vdyUyMGhlcmUlMjBpcyUyMHRoZSUyMHF1ZXN0aW9uJTIweW91JTIwbmVlZCUyMHRvJTIwYW5zd2VyLiUwQSUwQVF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjIlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFSQUdfUFJPTVBUX1RFTVBMQVRFJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2luX2NoYXRfZm9ybWF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMEEpJTBBcHJpbnQoUkFHX1BST01QVF9URU1QTEFURSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_in_chat_format = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Using the information contained in the context,
<span class="hljs-meta">... </span>give a comprehensive answer to the question.
<span class="hljs-meta">... </span>Respond only to the question asked, response should be concise and relevant to the question.
<span class="hljs-meta">... </span>Provide the number of the source document when relevant.
<span class="hljs-meta">... </span>If the answer cannot be deduced from the context, do not give an answer.&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;&quot;&quot;Context:
<span class="hljs-meta">... </span>{context}
<span class="hljs-meta">... </span>---
<span class="hljs-meta">... </span>Now here is the question you need to answer.

<span class="hljs-meta">... </span>Question: {question}&quot;&quot;&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>RAG_PROMPT_TEMPLATE = tokenizer.apply_chat_template(
<span class="hljs-meta">... </span>    prompt_in_chat_format, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(RAG_PROMPT_TEMPLATE)`,wrap:!1}}),Le=new m({props:{code:"cmV0cmlldmVkX2RvY3NfdGV4dCUyMCUzRCUyMCU1QmRvYy5wYWdlX2NvbnRlbnQlMjBmb3IlMjBkb2MlMjBpbiUyMHJldHJpZXZlZF9kb2NzJTVEJTIwJTIwJTIzJTIwV2UlMjBvbmx5JTIwbmVlZCUyMHRoZSUyMHRleHQlMjBvZiUyMHRoZSUyMGRvY3VtZW50cyUwQWNvbnRleHQlMjAlM0QlMjAlMjIlNUNuRXh0cmFjdGVkJTIwZG9jdW1lbnRzJTNBJTVDbiUyMiUwQWNvbnRleHQlMjAlMkIlM0QlMjAlMjIlMjIuam9pbiglNUJmJTIyRG9jdW1lbnQlMjAlN0JzdHIoaSklN0QlM0ElM0ElM0ElNUNuJTIyJTIwJTJCJTIwZG9jJTIwZm9yJTIwaSUyQyUyMGRvYyUyMGluJTIwZW51bWVyYXRlKHJldHJpZXZlZF9kb2NzX3RleHQpJTVEKSUwQSUwQWZpbmFsX3Byb21wdCUyMCUzRCUyMFJBR19QUk9NUFRfVEVNUExBVEUuZm9ybWF0KHF1ZXN0aW9uJTNEJTIySG93JTIwdG8lMjBjcmVhdGUlMjBhJTIwcGlwZWxpbmUlMjBvYmplY3QlM0YlMjIlMkMlMjBjb250ZXh0JTNEY29udGV4dCklMEElMEElMjMlMjBSZWRhY3QlMjBhbiUyMGFuc3dlciUwQWFuc3dlciUyMCUzRCUyMFJFQURFUl9MTE0oZmluYWxfcHJvbXB0KSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCUwQXByaW50KGFuc3dlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>retrieved_docs_text = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> retrieved_docs]  <span class="hljs-comment"># We only need the text of the documents</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(retrieved_docs_text)])

<span class="hljs-meta">&gt;&gt;&gt; </span>final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=<span class="hljs-string">&quot;How to create a pipeline object?&quot;</span>, context=context)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Redact an answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>answer = READER_LLM(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(answer)`,wrap:!1}}),De=new d({props:{title:"2.3. Reranking",local:"23-reranking",headingTag:"h3"}}),$e=new m({props:{code:"ZnJvbSUyMHJhZ2F0b3VpbGxlJTIwaW1wb3J0JTIwUkFHUHJldHJhaW5lZE1vZGVsJTBBJTBBUkVSQU5LRVIlMjAlM0QlMjBSQUdQcmV0cmFpbmVkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmNvbGJlcnQtaXIlMkZjb2xiZXJ0djIuMCUyMik=",highlighted:`<span class="hljs-keyword">from</span> ragatouille <span class="hljs-keyword">import</span> RAGPretrainedModel

RERANKER = RAGPretrainedModel.from_pretrained(<span class="hljs-string">&quot;colbert-ir/colbertv2.0&quot;</span>)`,wrap:!1}}),et=new d({props:{title:"3. Assembling it all!",local:"3-assembling-it-all",headingTag:"h1"}}),tt=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">answer_with_rag</span>(<span class="hljs-params">
    question: <span class="hljs-built_in">str</span>,
    llm: Pipeline,
    knowledge_index: FAISS,
    reranker: <span class="hljs-type">Optional</span>[RAGPretrainedModel] = <span class="hljs-literal">None</span>,
    num_retrieved_docs: <span class="hljs-built_in">int</span> = <span class="hljs-number">30</span>,
    num_docs_final: <span class="hljs-built_in">int</span> = <span class="hljs-number">5</span>,
</span>) -&gt; <span class="hljs-type">Tuple</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">List</span>[LangchainDocument]]:
    <span class="hljs-comment"># Gather documents with retriever</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Retrieving documents...&quot;</span>)
    relevant_docs = knowledge_index.similarity_search(query=question, k=num_retrieved_docs)
    relevant_docs = [doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]  <span class="hljs-comment"># Keep only the text</span>

    <span class="hljs-comment"># Optionally rerank results</span>
    <span class="hljs-keyword">if</span> reranker:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Reranking documents...&quot;</span>)
        relevant_docs = reranker.rerank(question, relevant_docs, k=num_docs_final)
        relevant_docs = [doc[<span class="hljs-string">&quot;content&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> relevant_docs]

    relevant_docs = relevant_docs[:num_docs_final]

    <span class="hljs-comment"># Build the final prompt</span>
    context = <span class="hljs-string">&quot;\\nExtracted documents:\\n&quot;</span>
    context += <span class="hljs-string">&quot;&quot;</span>.join([<span class="hljs-string">f&quot;Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span>:::\\n&quot;</span> + doc <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs)])

    final_prompt = RAG_PROMPT_TEMPLATE.<span class="hljs-built_in">format</span>(question=question, context=context)

    <span class="hljs-comment"># Redact an answer</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=&gt; Generating answer...&quot;</span>)
    answer = llm(final_prompt)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>]

    <span class="hljs-keyword">return</span> answer, relevant_docs`,wrap:!1}}),lt=new m({props:{code:"cXVlc3Rpb24lMjAlM0QlMjAlMjJob3clMjB0byUyMGNyZWF0ZSUyMGElMjBwaXBlbGluZSUyMG9iamVjdCUzRiUyMiUwQSUwQWFuc3dlciUyQyUyMHJlbGV2YW50X2RvY3MlMjAlM0QlMjBhbnN3ZXJfd2l0aF9yYWcocXVlc3Rpb24lMkMlMjBSRUFERVJfTExNJTJDJTIwS05PV0xFREdFX1ZFQ1RPUl9EQVRBQkFTRSUyQyUyMHJlcmFua2VyJTNEUkVSQU5LRVIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;how to create a pipeline object?&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>answer, relevant_docs = answer_with_rag(question, READER_LLM, KNOWLEDGE_VECTOR_DATABASE, reranker=RERANKER)`,wrap:!1}}),at=new m({props:{code:"cHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEQW5zd2VyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTIyKSUwQXByaW50KGYlMjIlN0JhbnN3ZXIlN0QlMjIpJTBBcHJpbnQoJTIyJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEJTNEU291cmNlJTIwZG9jcyUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUyMiklMEFmb3IlMjBpJTJDJTIwZG9jJTIwaW4lMjBlbnVtZXJhdGUocmVsZXZhbnRfZG9jcyklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyRG9jdW1lbnQlMjAlN0JpJTdELS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGRvYyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Answer==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{answer}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;==================================Source docs==================================&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(relevant_docs):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Document <span class="hljs-subst">{i}</span>------------------------------------------------------------&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(doc)`,wrap:!1}}),At=new d({props:{title:"To go further 🗺️",local:"to-go-further-",headingTag:"h1"}}),rt=new d({props:{title:"Setting up an evaluation pipeline",local:"setting-up-an-evaluation-pipeline",headingTag:"h3"}}),ct=new d({props:{title:"Improving the retriever",local:"improving-the-retriever",headingTag:"h3"}}),wt=new d({props:{title:"Improving the reader",local:"improving-the-reader",headingTag:"h3"}}),Tt=new ma({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/advanced_rag.md"}}),{c(){w=i("meta"),gt=n(),bt=i("p"),vt=n(),p(f.$$.fragment),Ft=n(),p(y.$$.fragment),Bt=n(),h=i("p"),h.innerHTML=Xl,It=n(),j=i("p"),j.textContent=xl,kt=n(),T=i("p"),T.innerHTML=ql,Et=n(),J=i("p"),J.textContent=Hl,Kt=n(),R=i("img"),Vt=n(),b=i("blockquote"),b.innerHTML=Gl,Nt=n(),C=i("p"),C.textContent=Pl,Qt=n(),g=i("p"),g.innerHTML=zl,Xt=n(),p(v.$$.fragment),xt=n(),p(F.$$.fragment),qt=n(),p(B.$$.fragment),Ht=n(),p(I.$$.fragment),Wt=n(),p(k.$$.fragment),Gt=n(),p(E.$$.fragment),Pt=n(),K=i("p"),K.innerHTML=Zl,zt=n(),V=i("p"),V.textContent=Ll,Zt=n(),N=i("p"),N.innerHTML=Sl,Lt=n(),Q=i("p"),Q.innerHTML=Dl,St=n(),X=i("p"),X.innerHTML=Yl,Dt=n(),x=i("ul"),x.innerHTML=_l,Yt=n(),q=i("blockquote"),q.innerHTML=Ol,_t=n(),p(H.$$.fragment),Ot=n(),W=i("ul"),W.innerHTML=$l,$t=n(),G=i("p"),G.innerHTML=en,es=n(),P=i("ul"),P.innerHTML=tn,ts=n(),z=i("blockquote"),z.innerHTML=sn,ss=n(),Z=i("p"),Z.innerHTML=ln,ls=n(),L=i("ul"),L.innerHTML=nn,ns=n(),p(S.$$.fragment),as=n(),D=i("p"),D.innerHTML=an,is=n(),Y=i("p"),Y.textContent=on,os=n(),p(_.$$.fragment),As=n(),O=i("pre"),O.textContent=An,ps=n(),$=i("p"),$.innerHTML=pn,rs=n(),ee=i("ul"),ee.innerHTML=rn,Ms=n(),p(te.$$.fragment),cs=n(),Rt=i("img"),Us=n(),se=i("p"),se.textContent=cn,us=n(),p(le.$$.fragment),ms=n(),ne=i("p"),ne.innerHTML=Un,ds=n(),p(ae.$$.fragment),ws=n(),ie=i("p"),ie.textContent=un,fs=n(),oe=i("p"),oe.textContent=mn,ys=n(),p(Ae.$$.fragment),hs=n(),pe=i("p"),pe.innerHTML=dn,js=n(),p(re.$$.fragment),Ts=n(),Me=i("p"),Me.innerHTML=wn,Js=n(),ce=i("ul"),ce.innerHTML=fn,Rs=n(),Ue=i("p"),Ue.innerHTML=yn,bs=n(),ue=i("p"),ue.innerHTML=hn,Cs=n(),me=i("p"),me.textContent=jn,gs=n(),p(de.$$.fragment),vs=n(),we=i("p"),we.textContent=Tn,Fs=n(),fe=i("p"),fe.innerHTML=Jn,Bs=n(),p(ye.$$.fragment),Is=n(),p(he.$$.fragment),ks=n(),p(je.$$.fragment),Es=n(),Te=i("img"),Ks=n(),Je=i("p"),Je.textContent=bn,Vs=n(),Re=i("p"),Re.innerHTML=Cn,Ns=n(),be=i("p"),be.innerHTML=gn,Qs=n(),Ce=i("p"),Ce.textContent=vn,Xs=n(),p(ge.$$.fragment),xs=n(),ve=i("pre"),ve.textContent=Fn,qs=n(),p(Fe.$$.fragment),Hs=n(),Be=i("p"),Be.innerHTML=Bn,Ws=n(),Ie=i("p"),Ie.textContent=In,Gs=n(),ke=i("ol"),ke.innerHTML=kn,Ps=n(),p(Ee.$$.fragment),zs=n(),Ke=i("p"),Ke.textContent=En,Zs=n(),Ve=i("ul"),Ve.innerHTML=Kn,Ls=n(),Ne=i("p"),Ne.innerHTML=Vn,Ss=n(),Qe=i("p"),Qe.innerHTML=Nn,Ds=n(),Xe=i("p"),Xe.textContent=Qn,Ys=n(),p(xe.$$.fragment),_s=n(),p(qe.$$.fragment),Os=n(),p(He.$$.fragment),$s=n(),We=i("p"),We.textContent=Xn,el=n(),Ge=i("p"),Ge.textContent=xn,tl=n(),p(Pe.$$.fragment),sl=n(),ze=i("pre"),ze.textContent=qn,ll=n(),Ze=i("p"),Ze.textContent=Hn,nl=n(),p(Le.$$.fragment),al=n(),Se=i("pre"),Se.textContent=Wn,il=n(),p(De.$$.fragment),ol=n(),Ye=i("p"),Ye.innerHTML=Gn,Al=n(),_e=i("p"),_e.innerHTML=Pn,pl=n(),Oe=i("p"),Oe.innerHTML=zn,rl=n(),p($e.$$.fragment),Ml=n(),p(et.$$.fragment),cl=n(),p(tt.$$.fragment),Ul=n(),st=i("p"),st.textContent=Zn,ul=n(),p(lt.$$.fragment),ml=n(),nt=i("pre"),nt.textContent=Ln,dl=n(),p(at.$$.fragment),wl=n(),it=i("pre"),it.textContent=Sn,fl=n(),ot=i("p"),ot.textContent=Dn,yl=n(),p(At.$$.fragment),hl=n(),pt=i("p"),pt.textContent=Yn,jl=n(),p(rt.$$.fragment),Tl=n(),Mt=i("ul"),Mt.innerHTML=_n,Jl=n(),p(ct.$$.fragment),Rl=n(),Ut=i("p"),Ut.innerHTML=On,bl=n(),ut=i("ul"),ut.innerHTML=$n,Cl=n(),mt=i("p"),mt.innerHTML=ea,gl=n(),dt=i("ul"),dt.innerHTML=ta,vl=n(),p(wt.$$.fragment),Fl=n(),ft=i("p"),ft.innerHTML=sa,Bl=n(),yt=i("ul"),yt.innerHTML=la,Il=n(),ht=i("p"),ht.innerHTML=na,kl=n(),jt=i("ul"),jt.innerHTML=aa,El=n(),p(Tt.$$.fragment),Kl=n(),Ct=i("p"),this.h()},l(e){const t=ca("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),gt=a(e),bt=o(e,"P",{}),ia(bt).forEach(s),vt=a(e),r(f.$$.fragment,e),Ft=a(e),r(y.$$.fragment,e),Bt=a(e),h=o(e,"P",{"data-svelte-h":!0}),A(h)!=="svelte-1xlqnsv"&&(h.innerHTML=Xl),It=a(e),j=o(e,"P",{"data-svelte-h":!0}),A(j)!=="svelte-5vl97w"&&(j.textContent=xl),kt=a(e),T=o(e,"P",{"data-svelte-h":!0}),A(T)!=="svelte-1460hpm"&&(T.innerHTML=ql),Et=a(e),J=o(e,"P",{"data-svelte-h":!0}),A(J)!=="svelte-gh2esv"&&(J.textContent=Hl),Kt=a(e),R=o(e,"IMG",{src:!0,height:!0}),Vt=a(e),b=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),A(b)!=="svelte-1ypu0z8"&&(b.innerHTML=Gl),Nt=a(e),C=o(e,"P",{"data-svelte-h":!0}),A(C)!=="svelte-5upzaq"&&(C.textContent=Pl),Qt=a(e),g=o(e,"P",{"data-svelte-h":!0}),A(g)!=="svelte-49kee0"&&(g.innerHTML=zl),Xt=a(e),r(v.$$.fragment,e),xt=a(e),r(F.$$.fragment,e),qt=a(e),r(B.$$.fragment,e),Ht=a(e),r(I.$$.fragment,e),Wt=a(e),r(k.$$.fragment,e),Gt=a(e),r(E.$$.fragment,e),Pt=a(e),K=o(e,"P",{"data-svelte-h":!0}),A(K)!=="svelte-1cgegoz"&&(K.innerHTML=Zl),zt=a(e),V=o(e,"P",{"data-svelte-h":!0}),A(V)!=="svelte-de3wl4"&&(V.textContent=Ll),Zt=a(e),N=o(e,"P",{"data-svelte-h":!0}),A(N)!=="svelte-1wss6or"&&(N.innerHTML=Sl),Lt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),A(Q)!=="svelte-9pws45"&&(Q.innerHTML=Dl),St=a(e),X=o(e,"P",{"data-svelte-h":!0}),A(X)!=="svelte-s89bs3"&&(X.innerHTML=Yl),Dt=a(e),x=o(e,"UL",{"data-svelte-h":!0}),A(x)!=="svelte-1jrf5qm"&&(x.innerHTML=_l),Yt=a(e),q=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),A(q)!=="svelte-vilhzk"&&(q.innerHTML=Ol),_t=a(e),r(H.$$.fragment,e),Ot=a(e),W=o(e,"UL",{"data-svelte-h":!0}),A(W)!=="svelte-1ceog4w"&&(W.innerHTML=$l),$t=a(e),G=o(e,"P",{"data-svelte-h":!0}),A(G)!=="svelte-pmv7fi"&&(G.innerHTML=en),es=a(e),P=o(e,"UL",{"data-svelte-h":!0}),A(P)!=="svelte-5b0v59"&&(P.innerHTML=tn),ts=a(e),z=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),A(z)!=="svelte-jl40ww"&&(z.innerHTML=sn),ss=a(e),Z=o(e,"P",{"data-svelte-h":!0}),A(Z)!=="svelte-1a9w1td"&&(Z.innerHTML=ln),ls=a(e),L=o(e,"UL",{"data-svelte-h":!0}),A(L)!=="svelte-o9tjxj"&&(L.innerHTML=nn),ns=a(e),r(S.$$.fragment,e),as=a(e),D=o(e,"P",{"data-svelte-h":!0}),A(D)!=="svelte-ccikkw"&&(D.innerHTML=an),is=a(e),Y=o(e,"P",{"data-svelte-h":!0}),A(Y)!=="svelte-psdeym"&&(Y.textContent=on),os=a(e),r(_.$$.fragment,e),As=a(e),O=o(e,"PRE",{"data-svelte-h":!0}),A(O)!=="svelte-h6hpdk"&&(O.textContent=An),ps=a(e),$=o(e,"P",{"data-svelte-h":!0}),A($)!=="svelte-1u0zp66"&&($.innerHTML=pn),rs=a(e),ee=o(e,"UL",{"data-svelte-h":!0}),A(ee)!=="svelte-9iuool"&&(ee.innerHTML=rn),Ms=a(e),r(te.$$.fragment,e),cs=a(e),Rt=o(e,"IMG",{src:!0}),Us=a(e),se=o(e,"P",{"data-svelte-h":!0}),A(se)!=="svelte-1wkfpn7"&&(se.textContent=cn),us=a(e),r(le.$$.fragment,e),ms=a(e),ne=o(e,"P",{"data-svelte-h":!0}),A(ne)!=="svelte-33b5e0"&&(ne.innerHTML=Un),ds=a(e),r(ae.$$.fragment,e),ws=a(e),ie=o(e,"P",{"data-svelte-h":!0}),A(ie)!=="svelte-1ovxr4g"&&(ie.textContent=un),fs=a(e),oe=o(e,"P",{"data-svelte-h":!0}),A(oe)!=="svelte-snh332"&&(oe.textContent=mn),ys=a(e),r(Ae.$$.fragment,e),hs=a(e),pe=o(e,"P",{"data-svelte-h":!0}),A(pe)!=="svelte-qr07h"&&(pe.innerHTML=dn),js=a(e),r(re.$$.fragment,e),Ts=a(e),Me=o(e,"P",{"data-svelte-h":!0}),A(Me)!=="svelte-19o59c4"&&(Me.innerHTML=wn),Js=a(e),ce=o(e,"UL",{"data-svelte-h":!0}),A(ce)!=="svelte-himirq"&&(ce.innerHTML=fn),Rs=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),A(Ue)!=="svelte-9bv8uv"&&(Ue.innerHTML=yn),bs=a(e),ue=o(e,"P",{"data-svelte-h":!0}),A(ue)!=="svelte-1dn8cpx"&&(ue.innerHTML=hn),Cs=a(e),me=o(e,"P",{"data-svelte-h":!0}),A(me)!=="svelte-1a80c74"&&(me.textContent=jn),gs=a(e),r(de.$$.fragment,e),vs=a(e),we=o(e,"P",{"data-svelte-h":!0}),A(we)!=="svelte-1fnnff6"&&(we.textContent=Tn),Fs=a(e),fe=o(e,"P",{"data-svelte-h":!0}),A(fe)!=="svelte-18egjso"&&(fe.innerHTML=Jn),Bs=a(e),r(ye.$$.fragment,e),Is=a(e),r(he.$$.fragment,e),ks=a(e),r(je.$$.fragment,e),Es=a(e),Te=o(e,"IMG",{src:!0,height:!0}),Ks=a(e),Je=o(e,"P",{"data-svelte-h":!0}),A(Je)!=="svelte-xckjsj"&&(Je.textContent=bn),Vs=a(e),Re=o(e,"P",{"data-svelte-h":!0}),A(Re)!=="svelte-388k4r"&&(Re.innerHTML=Cn),Ns=a(e),be=o(e,"P",{"data-svelte-h":!0}),A(be)!=="svelte-1odqot8"&&(be.innerHTML=gn),Qs=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),A(Ce)!=="svelte-yo6uco"&&(Ce.textContent=vn),Xs=a(e),r(ge.$$.fragment,e),xs=a(e),ve=o(e,"PRE",{"data-svelte-h":!0}),A(ve)!=="svelte-1q4z1pg"&&(ve.textContent=Fn),qs=a(e),r(Fe.$$.fragment,e),Hs=a(e),Be=o(e,"P",{"data-svelte-h":!0}),A(Be)!=="svelte-1h9voqr"&&(Be.innerHTML=Bn),Ws=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),A(Ie)!=="svelte-skc8b0"&&(Ie.textContent=In),Gs=a(e),ke=o(e,"OL",{"data-svelte-h":!0}),A(ke)!=="svelte-1j51hbn"&&(ke.innerHTML=kn),Ps=a(e),r(Ee.$$.fragment,e),zs=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),A(Ke)!=="svelte-f3xdfv"&&(Ke.textContent=En),Zs=a(e),Ve=o(e,"UL",{"data-svelte-h":!0}),A(Ve)!=="svelte-czsdt5"&&(Ve.innerHTML=Kn),Ls=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),A(Ne)!=="svelte-1fynfov"&&(Ne.innerHTML=Vn),Ss=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),A(Qe)!=="svelte-gklra8"&&(Qe.innerHTML=Nn),Ds=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),A(Xe)!=="svelte-1bs26eu"&&(Xe.textContent=Qn),Ys=a(e),r(xe.$$.fragment,e),_s=a(e),r(qe.$$.fragment,e),Os=a(e),r(He.$$.fragment,e),$s=a(e),We=o(e,"P",{"data-svelte-h":!0}),A(We)!=="svelte-1wx4m3n"&&(We.textContent=Xn),el=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),A(Ge)!=="svelte-1qxfgga"&&(Ge.textContent=xn),tl=a(e),r(Pe.$$.fragment,e),sl=a(e),ze=o(e,"PRE",{"data-svelte-h":!0}),A(ze)!=="svelte-aa4a7a"&&(ze.textContent=qn),ll=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),A(Ze)!=="svelte-614ha4"&&(Ze.textContent=Hn),nl=a(e),r(Le.$$.fragment,e),al=a(e),Se=o(e,"PRE",{"data-svelte-h":!0}),A(Se)!=="svelte-lv1631"&&(Se.textContent=Wn),il=a(e),r(De.$$.fragment,e),ol=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),A(Ye)!=="svelte-1sru2hu"&&(Ye.innerHTML=Gn),Al=a(e),_e=o(e,"P",{"data-svelte-h":!0}),A(_e)!=="svelte-1cssdsg"&&(_e.innerHTML=Pn),pl=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),A(Oe)!=="svelte-1uj89yq"&&(Oe.innerHTML=zn),rl=a(e),r($e.$$.fragment,e),Ml=a(e),r(et.$$.fragment,e),cl=a(e),r(tt.$$.fragment,e),Ul=a(e),st=o(e,"P",{"data-svelte-h":!0}),A(st)!=="svelte-1g0apvv"&&(st.textContent=Zn),ul=a(e),r(lt.$$.fragment,e),ml=a(e),nt=o(e,"PRE",{"data-svelte-h":!0}),A(nt)!=="svelte-drvpbm"&&(nt.textContent=Ln),dl=a(e),r(at.$$.fragment,e),wl=a(e),it=o(e,"PRE",{"data-svelte-h":!0}),A(it)!=="svelte-8jp8ub"&&(it.textContent=Sn),fl=a(e),ot=o(e,"P",{"data-svelte-h":!0}),A(ot)!=="svelte-z1e64p"&&(ot.textContent=Dn),yl=a(e),r(At.$$.fragment,e),hl=a(e),pt=o(e,"P",{"data-svelte-h":!0}),A(pt)!=="svelte-lra2n0"&&(pt.textContent=Yn),jl=a(e),r(rt.$$.fragment,e),Tl=a(e),Mt=o(e,"UL",{"data-svelte-h":!0}),A(Mt)!=="svelte-zjy89v"&&(Mt.innerHTML=_n),Jl=a(e),r(ct.$$.fragment,e),Rl=a(e),Ut=o(e,"P",{"data-svelte-h":!0}),A(Ut)!=="svelte-127rp0u"&&(Ut.innerHTML=On),bl=a(e),ut=o(e,"UL",{"data-svelte-h":!0}),A(ut)!=="svelte-1w0jpt6"&&(ut.innerHTML=$n),Cl=a(e),mt=o(e,"P",{"data-svelte-h":!0}),A(mt)!=="svelte-1u0vmui"&&(mt.innerHTML=ea),gl=a(e),dt=o(e,"UL",{"data-svelte-h":!0}),A(dt)!=="svelte-9v8l4l"&&(dt.innerHTML=ta),vl=a(e),r(wt.$$.fragment,e),Fl=a(e),ft=o(e,"P",{"data-svelte-h":!0}),A(ft)!=="svelte-14us1de"&&(ft.innerHTML=sa),Bl=a(e),yt=o(e,"UL",{"data-svelte-h":!0}),A(yt)!=="svelte-7re88b"&&(yt.innerHTML=la),Il=a(e),ht=o(e,"P",{"data-svelte-h":!0}),A(ht)!=="svelte-ly5dt2"&&(ht.innerHTML=na),kl=a(e),jt=o(e,"UL",{"data-svelte-h":!0}),A(jt)!=="svelte-hrog46"&&(jt.innerHTML=aa),El=a(e),r(Tt.$$.fragment,e),Kl=a(e),Ct=o(e,"P",{}),ia(Ct).forEach(s),this.h()},h(){Jt(w,"name","hf:doc:metadata"),Jt(w,"content",wa),Nl(R.src,Wl="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/RAG_workflow.png")||Jt(R,"src",Wl),Jt(R,"height","700"),Nl(Rt.src,Mn="data:image/jpeg;base64,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")||Jt(Rt,"src",Mn),Nl(Te.src,Rn="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/PaCMAP_embeddings.png")||Jt(Te,"src",Rn),Jt(Te,"height","700")},m(e,t){Ua(document.head,w),l(e,gt,t),l(e,bt,t),l(e,vt,t),M(f,e,t),l(e,Ft,t),M(y,e,t),l(e,Bt,t),l(e,h,t),l(e,It,t),l(e,j,t),l(e,kt,t),l(e,T,t),l(e,Et,t),l(e,J,t),l(e,Kt,t),l(e,R,t),l(e,Vt,t),l(e,b,t),l(e,Nt,t),l(e,C,t),l(e,Qt,t),l(e,g,t),l(e,Xt,t),M(v,e,t),l(e,xt,t),M(F,e,t),l(e,qt,t),M(B,e,t),l(e,Ht,t),M(I,e,t),l(e,Wt,t),M(k,e,t),l(e,Gt,t),M(E,e,t),l(e,Pt,t),l(e,K,t),l(e,zt,t),l(e,V,t),l(e,Zt,t),l(e,N,t),l(e,Lt,t),l(e,Q,t),l(e,St,t),l(e,X,t),l(e,Dt,t),l(e,x,t),l(e,Yt,t),l(e,q,t),l(e,_t,t),M(H,e,t),l(e,Ot,t),l(e,W,t),l(e,$t,t),l(e,G,t),l(e,es,t),l(e,P,t),l(e,ts,t),l(e,z,t),l(e,ss,t),l(e,Z,t),l(e,ls,t),l(e,L,t),l(e,ns,t),M(S,e,t),l(e,as,t),l(e,D,t),l(e,is,t),l(e,Y,t),l(e,os,t),M(_,e,t),l(e,As,t),l(e,O,t),l(e,ps,t),l(e,$,t),l(e,rs,t),l(e,ee,t),l(e,Ms,t),M(te,e,t),l(e,cs,t),l(e,Rt,t),l(e,Us,t),l(e,se,t),l(e,us,t),M(le,e,t),l(e,ms,t),l(e,ne,t),l(e,ds,t),M(ae,e,t),l(e,ws,t),l(e,ie,t),l(e,fs,t),l(e,oe,t),l(e,ys,t),M(Ae,e,t),l(e,hs,t),l(e,pe,t),l(e,js,t),M(re,e,t),l(e,Ts,t),l(e,Me,t),l(e,Js,t),l(e,ce,t),l(e,Rs,t),l(e,Ue,t),l(e,bs,t),l(e,ue,t),l(e,Cs,t),l(e,me,t),l(e,gs,t),M(de,e,t),l(e,vs,t),l(e,we,t),l(e,Fs,t),l(e,fe,t),l(e,Bs,t),M(ye,e,t),l(e,Is,t),M(he,e,t),l(e,ks,t),M(je,e,t),l(e,Es,t),l(e,Te,t),l(e,Ks,t),l(e,Je,t),l(e,Vs,t),l(e,Re,t),l(e,Ns,t),l(e,be,t),l(e,Qs,t),l(e,Ce,t),l(e,Xs,t),M(ge,e,t),l(e,xs,t),l(e,ve,t),l(e,qs,t),M(Fe,e,t),l(e,Hs,t),l(e,Be,t),l(e,Ws,t),l(e,Ie,t),l(e,Gs,t),l(e,ke,t),l(e,Ps,t),M(Ee,e,t),l(e,zs,t),l(e,Ke,t),l(e,Zs,t),l(e,Ve,t),l(e,Ls,t),l(e,Ne,t),l(e,Ss,t),l(e,Qe,t),l(e,Ds,t),l(e,Xe,t),l(e,Ys,t),M(xe,e,t),l(e,_s,t),M(qe,e,t),l(e,Os,t),M(He,e,t),l(e,$s,t),l(e,We,t),l(e,el,t),l(e,Ge,t),l(e,tl,t),M(Pe,e,t),l(e,sl,t),l(e,ze,t),l(e,ll,t),l(e,Ze,t),l(e,nl,t),M(Le,e,t),l(e,al,t),l(e,Se,t),l(e,il,t),M(De,e,t),l(e,ol,t),l(e,Ye,t),l(e,Al,t),l(e,_e,t),l(e,pl,t),l(e,Oe,t),l(e,rl,t),M($e,e,t),l(e,Ml,t),M(et,e,t),l(e,cl,t),M(tt,e,t),l(e,Ul,t),l(e,st,t),l(e,ul,t),M(lt,e,t),l(e,ml,t),l(e,nt,t),l(e,dl,t),M(at,e,t),l(e,wl,t),l(e,it,t),l(e,fl,t),l(e,ot,t),l(e,yl,t),M(At,e,t),l(e,hl,t),l(e,pt,t),l(e,jl,t),M(rt,e,t),l(e,Tl,t),l(e,Mt,t),l(e,Jl,t),M(ct,e,t),l(e,Rl,t),l(e,Ut,t),l(e,bl,t),l(e,ut,t),l(e,Cl,t),l(e,mt,t),l(e,gl,t),l(e,dt,t),l(e,vl,t),M(wt,e,t),l(e,Fl,t),l(e,ft,t),l(e,Bl,t),l(e,yt,t),l(e,Il,t),l(e,ht,t),l(e,kl,t),l(e,jt,t),l(e,El,t),M(Tt,e,t),l(e,Kl,t),l(e,Ct,t),Vl=!0},p:Aa,i(e){Vl||(c(f.$$.fragment,e),c(y.$$.fragment,e),c(v.$$.fragment,e),c(F.$$.fragment,e),c(B.$$.fragment,e),c(I.$$.fragment,e),c(k.$$.fragment,e),c(E.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(_.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ae.$$.fragment,e),c(Ae.$$.fragment,e),c(re.$$.fragment,e),c(de.$$.fragment,e),c(ye.$$.fragment,e),c(he.$$.fragment,e),c(je.$$.fragment,e),c(ge.$$.fragment,e),c(Fe.$$.fragment,e),c(Ee.$$.fragment,e),c(xe.$$.fragment,e),c(qe.$$.fragment,e),c(He.$$.fragment,e),c(Pe.$$.fragment,e),c(Le.$$.fragment,e),c(De.$$.fragment,e),c($e.$$.fragment,e),c(et.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(at.$$.fragment,e),c(At.$$.fragment,e),c(rt.$$.fragment,e),c(ct.$$.fragment,e),c(wt.$$.fragment,e),c(Tt.$$.fragment,e),Vl=!0)},o(e){U(f.$$.fragment,e),U(y.$$.fragment,e),U(v.$$.fragment,e),U(F.$$.fragment,e),U(B.$$.fragment,e),U(I.$$.fragment,e),U(k.$$.fragment,e),U(E.$$.fragment,e),U(H.$$.fragment,e),U(S.$$.fragment,e),U(_.$$.fragment,e),U(te.$$.fragment,e),U(le.$$.fragment,e),U(ae.$$.fragment,e),U(Ae.$$.fragment,e),U(re.$$.fragment,e),U(de.$$.fragment,e),U(ye.$$.fragment,e),U(he.$$.fragment,e),U(je.$$.fragment,e),U(ge.$$.fragment,e),U(Fe.$$.fragment,e),U(Ee.$$.fragment,e),U(xe.$$.fragment,e),U(qe.$$.fragment,e),U(He.$$.fragment,e),U(Pe.$$.fragment,e),U(Le.$$.fragment,e),U(De.$$.fragment,e),U($e.$$.fragment,e),U(et.$$.fragment,e),U(tt.$$.fragment,e),U(lt.$$.fragment,e),U(at.$$.fragment,e),U(At.$$.fragment,e),U(rt.$$.fragment,e),U(ct.$$.fragment,e),U(wt.$$.fragment,e),U(Tt.$$.fragment,e),Vl=!1},d(e){e&&(s(gt),s(bt),s(vt),s(Ft),s(Bt),s(h),s(It),s(j),s(kt),s(T),s(Et),s(J),s(Kt),s(R),s(Vt),s(b),s(Nt),s(C),s(Qt),s(g),s(Xt),s(xt),s(qt),s(Ht),s(Wt),s(Gt),s(Pt),s(K),s(zt),s(V),s(Zt),s(N),s(Lt),s(Q),s(St),s(X),s(Dt),s(x),s(Yt),s(q),s(_t),s(Ot),s(W),s($t),s(G),s(es),s(P),s(ts),s(z),s(ss),s(Z),s(ls),s(L),s(ns),s(as),s(D),s(is),s(Y),s(os),s(As),s(O),s(ps),s($),s(rs),s(ee),s(Ms),s(cs),s(Rt),s(Us),s(se),s(us),s(ms),s(ne),s(ds),s(ws),s(ie),s(fs),s(oe),s(ys),s(hs),s(pe),s(js),s(Ts),s(Me),s(Js),s(ce),s(Rs),s(Ue),s(bs),s(ue),s(Cs),s(me),s(gs),s(vs),s(we),s(Fs),s(fe),s(Bs),s(Is),s(ks),s(Es),s(Te),s(Ks),s(Je),s(Vs),s(Re),s(Ns),s(be),s(Qs),s(Ce),s(Xs),s(xs),s(ve),s(qs),s(Hs),s(Be),s(Ws),s(Ie),s(Gs),s(ke),s(Ps),s(zs),s(Ke),s(Zs),s(Ve),s(Ls),s(Ne),s(Ss),s(Qe),s(Ds),s(Xe),s(Ys),s(_s),s(Os),s($s),s(We),s(el),s(Ge),s(tl),s(sl),s(ze),s(ll),s(Ze),s(nl),s(al),s(Se),s(il),s(ol),s(Ye),s(Al),s(_e),s(pl),s(Oe),s(rl),s(Ml),s(cl),s(Ul),s(st),s(ul),s(ml),s(nt),s(dl),s(wl),s(it),s(fl),s(ot),s(yl),s(hl),s(pt),s(jl),s(Tl),s(Mt),s(Jl),s(Rl),s(Ut),s(bl),s(ut),s(Cl),s(mt),s(gl),s(dt),s(vl),s(Fl),s(ft),s(Bl),s(yt),s(Il),s(ht),s(kl),s(jt),s(El),s(Kl),s(Ct)),s(w),u(f,e),u(y,e),u(v,e),u(F,e),u(B,e),u(I,e),u(k,e),u(E,e),u(H,e),u(S,e),u(_,e),u(te,e),u(le,e),u(ae,e),u(Ae,e),u(re,e),u(de,e),u(ye,e),u(he,e),u(je,e),u(ge,e),u(Fe,e),u(Ee,e),u(xe,e),u(qe,e),u(He,e),u(Pe,e),u(Le,e),u(De,e),u($e,e),u(et,e),u(tt,e),u(lt,e),u(at,e),u(At,e),u(rt,e),u(ct,e),u(wt,e),u(Tt,e)}}}const wa='{"title":"Advanced RAG on Hugging Face documentation using LangChain","local":"advanced-rag-on-hugging-face-documentation-using-langchain","sections":[{"title":"Load your knowledge base","local":"load-your-knowledge-base","sections":[],"depth":3}],"depth":1}';function fa(Ql){return pa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ja extends ra{constructor(w){super(),Ma(this,w,fa,da,oa,{})}}export{Ja as component};
