import{s as wl,n as dl,o as jl}from"../chunks/scheduler.65852ee5.js";import{S as Jl,i as hl,g as o,s as n,r as M,A as Tl,h as i,f as l,c as a,j as yl,u as p,x as r,k as ml,y as bl,a as s,v as c,d as u,t as y,w as m}from"../chunks/index.65a1b999.js";import{D as Ul,C as w}from"../chunks/DocNotebookDropdown.746a44a1.js";import{H as Te,E as gl}from"../chunks/getInferenceSnippets.5a9e4eba.js";function Il(Bt){let d,ge,be,Ie,j,fe,J,Ce,h,Gt='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',ve,T,kt='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/smolagents/index" rel="nofollow"><strong>smolagents</strong></a> to build awesome <strong>agents</strong>!',Ze,b,Rt="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",Be,U,Wt='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',Ge,g,At='What is <strong>smolagents</strong>? It’s an library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/smolagents/index" rel="nofollow">documentation</a>.',ke,I,Nt="Let’s see how to use it, and which use cases it can solve.",Re,f,Vt="Run the line below to install required dependencies:",We,C,Ae,v,_t="Let’s login in order to call the HF Inference API:",Ne,Z,Ve,B,_e,G,$t="For this use case, we want to show an agent that browses the web and is able to generate images.",$e,k,Xt="To build it, we simply need to have two tools ready: image generation and web search.",Xe,R,Qt="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we use a built-in tool.</li>",Qe,W,Se,A,St=`TOOLCODE:
 from smolagents import Tool
from huggingface_hub import InferenceClient


class TextToImageTool(Tool):
    description = "This tool creates an image according to a prompt, which is a text description."
    name = "image_generator"
    inputs = &#123;"prompt": &#123;"type": "string", "description": "The image generator prompt. Don't hesitate to add details in the prompt to make the image look better, like 'high-res, photorealistic', etc."}}
    output_type = "image"
    model_sdxl = "black-forest-labs/FLUX.1-schnell"
    client = InferenceClient(model_sdxl)


    def forward(self, prompt):
        return self.client.text_to_image(prompt)
`,xe,N,xt='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',qe,V,Ee,_,qt="Quick definition: Retrieval-Augmented-Generation (RAG) is <strong><em>“using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”.</em></strong>",He,$,Et="This method has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",Ye,X,Ht="<li><p>Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong></p></li> <li><p>A frequent failure case of RAG is when the retrieval based on the user query does not return any relevant supporting documents. <strong>Is there a way to iterate by re-calling the retriever with a modified query in case the previous results were not relevant?</strong></p></li>",ze,Q,Yt="🔧 Well, we can solve the points above in a simple way: we will <strong>give our agent control over the retriever’s parameters!</strong>",Fe,S,zt="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",Le,x,Pe,q,Ft="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",De,E,Ke,H,Lt="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",Oe,Y,Pt="We want our system to select only from the most relevant sources of information, depending on the query.",et,z,Dt="Our documentation pages come from the following sources:",tt,F,lt,L,Kt=`['datasets-server', 'datasets', 'optimum', 'gradio', 'blog', 'course', 'hub-docs', 'pytorch-image-models', 'peft', 'evaluate', 'diffusers', 'hf-endpoints-documentation', 'deep-rl-class', 'transformers']
`,st,P,Ot="👉 Now let’s build a <code>RetrieverTool</code> that our agent can leverage to retrieve information from the knowledge base.",nt,D,el='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the <a href="https://huggingface.co/docs/transformers/main/en/agents#create-a-new-tool" rel="nofollow">simple tool constructor</a> with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="https://huggingface.co/docs/transformers/main/en/agents_advanced#directly-define-a-tool-by-subclassing-tool-and-share-it-to-the-hub" rel="nofollow">advanced agents documentation</a>.',at,K,ot,O,it,ee,tl="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",rt,te,ll="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",Mt,le,pt,se,ct,ne,ut,ae,sl="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",yt,oe,nl=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,mt,ie,al="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",wt,re,dt,Me,ol="Since the CodeAgent has a built-in Python code interpreter, we can use it to debug our faulty Python script!",jt,pe,Jt,ce,il="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",ht,ue,rl="And the final code is the corrected code:",Tt,ye,bt,me,Ml=`numbers=[0, 1, 2]

for i in range(len(numbers)):
    print(numbers[i])
`,Ut,we,gt,de,pl="The use cases above should give you a glimpse into the possibilities of our Agents framework!",It,je,cl='For more advanced usage, read the <a href="https://huggingface.co/docs/smolagents/index" rel="nofollow">documentation</a>.',ft,Je,ul="All feedback is welcome, it will help us improve the framework! 🚀",Ct,he,vt,Ue,Zt;return j=new Ul({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb"}]}}),J=new Te({props:{title:"Build an agent with tool-calling superpowers 🦸 using smolagents",local:"build-an-agent-with-tool-calling-superpowers--using-smolagents",headingTag:"h1"}}),C=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwZGF0YXNldHMlMjBsYW5nY2hhaW4lMjBzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMjBmYWlzcy1jcHUlMjBkdWNrZHVja2dvLXNlYXJjaCUyMG9wZW5haSUyMGxhbmdjaGFpbi1jb21tdW5pdHklMjAtLXVwZ3JhZGUlMjAtcQ==",highlighted:"!pip install smolagents datasets langchain sentence-transformers faiss-cpu duckduckgo-search openai langchain-community --upgrade -q",wrap:!1}}),Z=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),B=new Te({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),W=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2wlMkMlMjBDb2RlQWdlbnQlMkMlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMER1Y2tEdWNrR29TZWFyY2hUb29sJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQSUwQSUwQXNlYXJjaF90b29sJTIwJTNEJTIwRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUwQSUwQW1vZGVsJTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBhZ2VudCUyMHdpdGglMjBib3RoJTIwdG9vbHMlMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCklMEElMEElMjMlMjBSdW4lMjBpdCElMEFyZXN1bHQlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIyR2VuZXJhdGUlMjBtZSUyMGElMjBwaG90byUyMG9mJTIwdGhlJTIwY2FyJTIwdGhhdCUyMEphbWVzJTIwYm9uZCUyMGRyb3ZlJTIwaW4lMjB0aGUlMjBsYXRlc3QlMjBtb3ZpZS4lMjIlMkMlMEEpJTBBcmVzdWx0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool, CodeAgent, InferenceClientModel, DuckDuckGoSearchTool

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Import tool from Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>search_tool = DuckDuckGoSearchTool()

<span class="hljs-meta">&gt;&gt;&gt; </span>model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the agent with both tools</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = CodeAgent(tools=[image_generation_tool, search_tool], model=model)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run it!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = agent.run(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result`,wrap:!1}}),V=new Te({props:{title:"2. 📚💬 RAG with Iterative query refinement & Source selection",local:"2--rag-with-iterative-query-refinement--source-selection",headingTag:"h2"}}),x=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),E=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),F=new w({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),K=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][<span class="hljs-string">&quot;description&quot;</span>] = (
            <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>.replace(
                <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;\`&quot;</span>
            )
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),O=new Te({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),le=new w({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwVHJ1ZSUwQSUwQWlmJTIwc2hhcmVfdG9faHViJTNBJTBBJTIwJTIwJTIwJTIwZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBJTIwJTIwJTIwJTIwZnJvbSUyMHJldHJpZXZlciUyMGltcG9ydCUyMFJldHJpZXZlclRvb2wlMEElMEElMjAlMjAlMjAlMjBsb2dpbiglMjJ5b3VyX3Rva2VuJTIyKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMpJTBBJTBBJTIwJTIwJTIwJTIwdG9vbC5wdXNoX3RvX2h1YihyZXBvX2lkJTNEJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBMb2FkaW5nJTIwdGhlJTIwdG9vbCUwQSUyMCUyMCUyMCUyMGZyb20lMjBzbW9sYWdlbnRzJTIwaW1wb3J0JTIwbG9hZF90b29sJTBBJTBBJTIwJTIwJTIwJTIwcmV0cmlldmVyX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZyZXRyaWV2ZXItdG9vbCUyMiUyQyUyMHZlY3RvcmRiJTNEdmVjdG9yZGIlMkMlMjBhbGxfc291cmNlcyUzRGFsbF9zb3VyY2VzKQ==",highlighted:`share_to_hub = <span class="hljs-literal">True</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)

    <span class="hljs-comment"># Loading the tool</span>
    <span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> load_tool

    retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)`,wrap:!1}}),se=new Te({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),ne=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMFRvb2xDYWxsaW5nQWdlbnQlMEElMEFtb2RlbCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudE1vZGVsKCUyMlF3ZW4lMkZRd2VuMi41LTcyQi1JbnN0cnVjdCUyMiklMEElMEFyZXRyaWV2ZXJfdG9vbCUyMCUzRCUyMFJldHJpZXZlclRvb2wodmVjdG9yZGIlM0R2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzJTNEYWxsX3NvdXJjZXMpJTBBYWdlbnQlMjAlM0QlMjBUb29sQ2FsbGluZ0FnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdmVyYm9zZSUzRDApJTBBJTBBYWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMlBsZWFzZSUyMHNob3clMjBtZSUyMGElMjBMT1JBJTIwZmluZXR1bmluZyUyMHNjcmlwdCUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, ToolCallingAgent

model = InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>)

retriever_tool = RetrieverTool(vectordb=vectordb, all_sources=all_sources)
agent = ToolCallingAgent(tools=[retriever_tool], model=model, verbose=<span class="hljs-number">0</span>)

agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),re=new Te({props:{title:"3. 💻 Debug Python code",local:"3--debug-python-code",headingTag:"h2"}}),pe=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBDb2RlQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCUyQyUyMG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoJTIyUXdlbiUyRlF3ZW4yLjUtNzJCLUluc3RydWN0JTIyKSklMEElMEFjb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBbnVtYmVycyUzRCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobnVtYmVycyhpKSklMEElMjIlMjIlMjIlMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBzb21lJTIwY29kZSUyMHRoYXQlMjBjcmVhdGVzJTIwYSUyMGJ1ZyUzQSUyMHBsZWFzZSUyMGRlYnVnJTIwaXQlMkMlMjB0aGVuJTIwcnVuJTIwaXQlMjB0byUyMG1ha2UlMjBzdXJlJTIwaXQlMjB3b3JrcyUyMGFuZCUyMHJldHVybiUyMHRoZSUyMGZpbmFsJTIwY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGFkZGl0aW9uYWxfYXJncyUzRGRpY3QoY29kZSUzRGNvZGUpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent

agent = CodeAgent(tools=[], model=InferenceClientModel(<span class="hljs-string">&quot;Qwen/Qwen2.5-72B-Instruct&quot;</span>))

code = <span class="hljs-string">&quot;&quot;&quot;
numbers=[0, 1, 2]

for i in range(4):
    print(numbers(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it, then run it to make sure it works and return the final code&quot;</span>,
    additional_args=<span class="hljs-built_in">dict</span>(code=code),
)`,wrap:!1}}),ye=new w({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),we=new Te({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),he=new gl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){d=o("meta"),ge=n(),be=o("p"),Ie=n(),M(j.$$.fragment),fe=n(),M(J.$$.fragment),Ce=n(),h=o("p"),h.innerHTML=Gt,ve=n(),T=o("p"),T.innerHTML=kt,Ze=n(),b=o("p"),b.innerHTML=Rt,Be=n(),U=o("p"),U.innerHTML=Wt,Ge=n(),g=o("p"),g.innerHTML=At,ke=n(),I=o("p"),I.textContent=Nt,Re=n(),f=o("p"),f.textContent=Vt,We=n(),M(C.$$.fragment),Ae=n(),v=o("p"),v.textContent=_t,Ne=n(),M(Z.$$.fragment),Ve=n(),M(B.$$.fragment),_e=n(),G=o("p"),G.textContent=$t,$e=n(),k=o("p"),k.textContent=Xt,Xe=n(),R=o("ul"),R.innerHTML=Qt,Qe=n(),M(W.$$.fragment),Se=n(),A=o("pre"),A.textContent=St,xe=n(),N=o("p"),N.innerHTML=xt,qe=n(),M(V.$$.fragment),Ee=n(),_=o("p"),_.innerHTML=qt,He=n(),$=o("p"),$.textContent=Et,Ye=n(),X=o("ul"),X.innerHTML=Ht,ze=n(),Q=o("p"),Q.innerHTML=Yt,Fe=n(),S=o("p"),S.innerHTML=zt,Le=n(),M(x.$$.fragment),Pe=n(),q=o("p"),q.textContent=Ft,De=n(),M(E.$$.fragment),Ke=n(),H=o("p"),H.textContent=Lt,Oe=n(),Y=o("p"),Y.textContent=Pt,et=n(),z=o("p"),z.textContent=Dt,tt=n(),M(F.$$.fragment),lt=n(),L=o("pre"),L.textContent=Kt,st=n(),P=o("p"),P.innerHTML=Ot,nt=n(),D=o("p"),D.innerHTML=el,at=n(),M(K.$$.fragment),ot=n(),M(O.$$.fragment),it=n(),ee=o("p"),ee.innerHTML=tl,rt=n(),te=o("p"),te.innerHTML=ll,Mt=n(),M(le.$$.fragment),pt=n(),M(se.$$.fragment),ct=n(),M(ne.$$.fragment),ut=n(),ae=o("p"),ae.innerHTML=sl,yt=n(),oe=o("p"),oe.textContent=nl,mt=n(),ie=o("p"),ie.innerHTML=al,wt=n(),M(re.$$.fragment),dt=n(),Me=o("p"),Me.textContent=ol,jt=n(),M(pe.$$.fragment),Jt=n(),ce=o("p"),ce.textContent=il,ht=n(),ue=o("p"),ue.textContent=rl,Tt=n(),M(ye.$$.fragment),bt=n(),me=o("pre"),me.textContent=Ml,Ut=n(),M(we.$$.fragment),gt=n(),de=o("p"),de.textContent=pl,It=n(),je=o("p"),je.innerHTML=cl,ft=n(),Je=o("p"),Je.textContent=ul,Ct=n(),M(he.$$.fragment),vt=n(),Ue=o("p"),this.h()},l(e){const t=Tl("svelte-u9bgzb",document.head);d=i(t,"META",{name:!0,content:!0}),t.forEach(l),ge=a(e),be=i(e,"P",{}),yl(be).forEach(l),Ie=a(e),p(j.$$.fragment,e),fe=a(e),p(J.$$.fragment,e),Ce=a(e),h=i(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1xlqnsv"&&(h.innerHTML=Gt),ve=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-16ind9j"&&(T.innerHTML=kt),Ze=a(e),b=i(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1mh34dv"&&(b.innerHTML=Rt),Be=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-mmy9qo"&&(U.innerHTML=Wt),Ge=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1u6j2au"&&(g.innerHTML=At),ke=a(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-fc6q9b"&&(I.textContent=Nt),Re=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-16cuoal"&&(f.textContent=Vt),We=a(e),p(C.$$.fragment,e),Ae=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-64fox6"&&(v.textContent=_t),Ne=a(e),p(Z.$$.fragment,e),Ve=a(e),p(B.$$.fragment,e),_e=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-1bnny6u"&&(G.textContent=$t),$e=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1yb5yrl"&&(k.textContent=Xt),Xe=a(e),R=i(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-3qoj8n"&&(R.innerHTML=Qt),Qe=a(e),p(W.$$.fragment,e),Se=a(e),A=i(e,"PRE",{"data-svelte-h":!0}),r(A)!=="svelte-u5o6zi"&&(A.textContent=St),xe=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1hg95q8"&&(N.innerHTML=xt),qe=a(e),p(V.$$.fragment,e),Ee=a(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1wknlb6"&&(_.innerHTML=qt),He=a(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-19h5931"&&($.textContent=Et),Ye=a(e),X=i(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-5uub6"&&(X.innerHTML=Ht),ze=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1kfx2et"&&(Q.innerHTML=Yt),Fe=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1qw64fs"&&(S.innerHTML=zt),Le=a(e),p(x.$$.fragment,e),Pe=a(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-jy4i2f"&&(q.textContent=Ft),De=a(e),p(E.$$.fragment,e),Ke=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-5pp8py"&&(H.textContent=Lt),Oe=a(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1cx88lu"&&(Y.textContent=Pt),et=a(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1vgfwws"&&(z.textContent=Dt),tt=a(e),p(F.$$.fragment,e),lt=a(e),L=i(e,"PRE",{"data-svelte-h":!0}),r(L)!=="svelte-crsp42"&&(L.textContent=Kt),st=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1dsjmqj"&&(P.innerHTML=Ot),nt=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-yb70ev"&&(D.innerHTML=el),at=a(e),p(K.$$.fragment,e),ot=a(e),p(O.$$.fragment,e),it=a(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-19hckuz"&&(ee.innerHTML=tl),rt=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1wpkyax"&&(te.innerHTML=ll),Mt=a(e),p(le.$$.fragment,e),pt=a(e),p(se.$$.fragment,e),ct=a(e),p(ne.$$.fragment,e),ut=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-6d9ubm"&&(ae.innerHTML=sl),yt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-ud3g55"&&(oe.textContent=nl),mt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-3qqlok"&&(ie.innerHTML=al),wt=a(e),p(re.$$.fragment,e),dt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1s1hpee"&&(Me.textContent=ol),jt=a(e),p(pe.$$.fragment,e),Jt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-168ebuv"&&(ce.textContent=il),ht=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-vscncs"&&(ue.textContent=rl),Tt=a(e),p(ye.$$.fragment,e),bt=a(e),me=i(e,"PRE",{"data-svelte-h":!0}),r(me)!=="svelte-1xg5a44"&&(me.textContent=Ml),Ut=a(e),p(we.$$.fragment,e),gt=a(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-hpfue3"&&(de.textContent=pl),It=a(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1v6mkvd"&&(je.innerHTML=cl),ft=a(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1ctcozl"&&(Je.textContent=ul),Ct=a(e),p(he.$$.fragment,e),vt=a(e),Ue=i(e,"P",{}),yl(Ue).forEach(l),this.h()},h(){ml(d,"name","hf:doc:metadata"),ml(d,"content",fl)},m(e,t){bl(document.head,d),s(e,ge,t),s(e,be,t),s(e,Ie,t),c(j,e,t),s(e,fe,t),c(J,e,t),s(e,Ce,t),s(e,h,t),s(e,ve,t),s(e,T,t),s(e,Ze,t),s(e,b,t),s(e,Be,t),s(e,U,t),s(e,Ge,t),s(e,g,t),s(e,ke,t),s(e,I,t),s(e,Re,t),s(e,f,t),s(e,We,t),c(C,e,t),s(e,Ae,t),s(e,v,t),s(e,Ne,t),c(Z,e,t),s(e,Ve,t),c(B,e,t),s(e,_e,t),s(e,G,t),s(e,$e,t),s(e,k,t),s(e,Xe,t),s(e,R,t),s(e,Qe,t),c(W,e,t),s(e,Se,t),s(e,A,t),s(e,xe,t),s(e,N,t),s(e,qe,t),c(V,e,t),s(e,Ee,t),s(e,_,t),s(e,He,t),s(e,$,t),s(e,Ye,t),s(e,X,t),s(e,ze,t),s(e,Q,t),s(e,Fe,t),s(e,S,t),s(e,Le,t),c(x,e,t),s(e,Pe,t),s(e,q,t),s(e,De,t),c(E,e,t),s(e,Ke,t),s(e,H,t),s(e,Oe,t),s(e,Y,t),s(e,et,t),s(e,z,t),s(e,tt,t),c(F,e,t),s(e,lt,t),s(e,L,t),s(e,st,t),s(e,P,t),s(e,nt,t),s(e,D,t),s(e,at,t),c(K,e,t),s(e,ot,t),c(O,e,t),s(e,it,t),s(e,ee,t),s(e,rt,t),s(e,te,t),s(e,Mt,t),c(le,e,t),s(e,pt,t),c(se,e,t),s(e,ct,t),c(ne,e,t),s(e,ut,t),s(e,ae,t),s(e,yt,t),s(e,oe,t),s(e,mt,t),s(e,ie,t),s(e,wt,t),c(re,e,t),s(e,dt,t),s(e,Me,t),s(e,jt,t),c(pe,e,t),s(e,Jt,t),s(e,ce,t),s(e,ht,t),s(e,ue,t),s(e,Tt,t),c(ye,e,t),s(e,bt,t),s(e,me,t),s(e,Ut,t),c(we,e,t),s(e,gt,t),s(e,de,t),s(e,It,t),s(e,je,t),s(e,ft,t),s(e,Je,t),s(e,Ct,t),c(he,e,t),s(e,vt,t),s(e,Ue,t),Zt=!0},p:dl,i(e){Zt||(u(j.$$.fragment,e),u(J.$$.fragment,e),u(C.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(W.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(K.$$.fragment,e),u(O.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(re.$$.fragment,e),u(pe.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),u(he.$$.fragment,e),Zt=!0)},o(e){y(j.$$.fragment,e),y(J.$$.fragment,e),y(C.$$.fragment,e),y(Z.$$.fragment,e),y(B.$$.fragment,e),y(W.$$.fragment,e),y(V.$$.fragment,e),y(x.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(K.$$.fragment,e),y(O.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(pe.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(he.$$.fragment,e),Zt=!1},d(e){e&&(l(ge),l(be),l(Ie),l(fe),l(Ce),l(h),l(ve),l(T),l(Ze),l(b),l(Be),l(U),l(Ge),l(g),l(ke),l(I),l(Re),l(f),l(We),l(Ae),l(v),l(Ne),l(Ve),l(_e),l(G),l($e),l(k),l(Xe),l(R),l(Qe),l(Se),l(A),l(xe),l(N),l(qe),l(Ee),l(_),l(He),l($),l(Ye),l(X),l(ze),l(Q),l(Fe),l(S),l(Le),l(Pe),l(q),l(De),l(Ke),l(H),l(Oe),l(Y),l(et),l(z),l(tt),l(lt),l(L),l(st),l(P),l(nt),l(D),l(at),l(ot),l(it),l(ee),l(rt),l(te),l(Mt),l(pt),l(ct),l(ut),l(ae),l(yt),l(oe),l(mt),l(ie),l(wt),l(dt),l(Me),l(jt),l(Jt),l(ce),l(ht),l(ue),l(Tt),l(bt),l(me),l(Ut),l(gt),l(de),l(It),l(je),l(ft),l(Je),l(Ct),l(vt),l(Ue)),l(d),m(j,e),m(J,e),m(C,e),m(Z,e),m(B,e),m(W,e),m(V,e),m(x,e),m(E,e),m(F,e),m(K,e),m(O,e),m(le,e),m(se,e),m(ne,e),m(re,e),m(pe,e),m(ye,e),m(we,e),m(he,e)}}}const fl='{"title":"Build an agent with tool-calling superpowers 🦸 using smolagents","local":"build-an-agent-with-tool-calling-superpowers--using-smolagents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 RAG with Iterative query refinement & Source selection","local":"2--rag-with-iterative-query-refinement--source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debug Python code","local":"3--debug-python-code","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function Cl(Bt){return jl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends Jl{constructor(d){super(),hl(this,d,Cl,Il,wl,{})}}export{kl as component};
