import{s as tn,n as en,o as ln}from"../chunks/scheduler.65852ee5.js";import{S as sn,i as nn,g as p,s as n,r as i,A as an,h as m,f as l,c as a,j as Ds,u as o,x as M,k as Os,y as pn,a as s,v as y,d as r,t as u,w as f}from"../chunks/index.aa74147d.js";import{D as mn,C as d}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as b,E as Mn}from"../chunks/getInferenceSnippets.a1cbc7e2.js";function on(Ol){let w,Me,pe,ie,c,oe,j,ye,J,ts='<em>作者: <a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',re,T,es="在这个 notebook 中，我们将介绍如何使用 PEFT 库对预训练模型进行提示微调。",ue,h,ls='要查看与 PEFT 兼容的完整模型列表，请参考他们的<a href="https://huggingface.co/docs/peft/main/en/index#supported-methods" rel="nofollow">文档</a>。',fe,U,ss="可以使用 PEFT 进行训练的模型示例包括 Bloom、Llama、GPT-J、GPT-2、BERT 等等。Hugging Face 正在努力将更多模型添加到库中。",de,$,be,_,ns="这是一种用于模型的附加微调技术。这意味着我们不会修改原始模型的任何权重。你可能会想，那么我们将如何进行微调呢？好吧，我们将训练添加到模型中的额外层。这就是为什么它被称为附加技术。",we,C,as="考虑到它是一种附加技术，并且它的名字是提示调整，似乎很明显我们将要添加和训练的层与提示有关。",ce,Z,ps='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/Martra_Figure_5_Prompt_Tuning.jpg" alt="Prompt_Tuning_Diagram"/>',je,g,ms="我们通过使模型能够用其获取的知识增强提示的一部分来创建一种超提示。然而，提示的这部分不能翻译成自然语言。<strong>这就好像我们已经掌握了用嵌入表达自己并生成高效提示的能力。</strong>",Je,G,Ms="在每次训练周期中，唯一可以修改以最小化损失函数的权重是集成到提示中的权重。",Te,X,is="这种技术的主要结果是，要训练的参数数量确实很少。然而，我们遇到了第二个，也许更重要的结果，即<strong>由于我们不修改预训练模型的权重，它不会改变其行为或忘记它以前学到的任何信息。</strong>",he,W,os="训练更快，更具成本效益。此外，我们可以训练各种模型，在推理时，我们只需要加载一个基础模型以及新的较小的训练模型，因为原始模型的权重没有被修改。",Ue,B,$e,k,ys="我们将使用两个数据集训练两个不同的模型，每个数据集只使用 Bloom 家族的一个预训练模型。一个模型将使用提示数据集进行训练，而另一个模型将使用激励句子数据集进行训练。我们将比较两个模型在训练前后对同一问题的结果。",_e,R,rs="此外，我们还将探讨如何只加载基础模型的一个副本到内存中，同时加载两个模型。",Ce,V,Ze,v,us="这个库包含了各种微调技术的 Hugging Face 实现，包括提示调整。",ge,I,Ge,x,Xe,F,fs="从 transformers 库中，我们导入必要的类来实例化模型和分词器。",We,H,Be,Y,ke,Q,ds="Bloom 是使用 PEFT 库进行提示调整训练的可用模型中最小最智能的模型之一。你可以从 Bloom 家族中选择任何模型，我鼓励你至少尝试其中两个以观察它们之间的差异。",Re,A,bs="我选择最小的模型以最小化训练时间并避免在 Colab 中出现内存问题。",Ve,N,ve,z,Ie,E,xe,S,ws="如果你想要实现更多样化和原创的生成，取消注释下面的 <em>model.generate</em> 中的参数：temperature、top_p 和 do_sample。",Fe,P,cs="在默认配置下，模型的响应在多次调用中保持一致。",He,q,Ye,L,js="由于我们希望有两个不同的训练模型，我将创建两个不同的提示。",Qe,K,Js="第一个模型将使用包含提示的数据集进行训练，第二个模型将使用激励句子的数据集进行训练。",Ae,D,Ts="第一个模型将收到提示 “我希望你扮演一个励志教练。“，第二个模型将收到提示 “有两件对你来说很重要的事情：”",Ne,O,hs="但首先，我要收集一些未经微调的模型的结果。",ze,tt,Ee,et,Us=`["I want you to act as a motivational coach.  Don't be afraid of being challenged."]
`,Se,lt,Pe,st,$s=`['There are two nice things that should matter to you: the price and quality of your product.']
`,qe,nt,_s="两个答案或多或少都是正确的。任何 Bloom 模型都是预先训练的，能够准确和合理地生成句子。让我们看看，在训练之后，响应是否相等或者生成得更加准确。",Le,at,Ke,pt,Cs="使用的数据集包括：",De,mt,Zs='<li><a href="https://huggingface.co/datasets/fka/awesome-chatgpt-prompts" rel="nofollow">https://huggingface.co/datasets/fka/awesome-chatgpt-prompts</a></li> <li><a href="https://huggingface.co/datasets/Abirate/english_quotes" rel="nofollow">https://huggingface.co/datasets/Abirate/english_quotes</a></li>',Oe,Mt,tl,it,el,ot,ll,yt,sl,rt,gs=`&#123;'act': ['Linux Terminal'], 'prompt': ['I want you to act as a linux terminal. I will type commands and you will reply with what the terminal should show. I want you to only reply with the terminal output inside one unique code block, and nothing else. do not write explanations. do not type commands unless I instruct you to do so. when i need to tell you something in english, i will do so by putting text inside curly brackets &#123;like this}. my first command is pwd'], 'input_ids': [[44, 4026, 1152, 427, 1769, 661, 267, 104105, 28434, 17, 473, 2152, 4105, 49123, 530, 1152, 2152, 57502, 1002, 3595, 368, 28434, 3403, 6460, 17, 473, 4026, 1152, 427, 3804, 57502, 1002, 368, 28434, 10014, 14652, 2592, 19826, 4400, 10973, 15, 530, 16915, 4384, 17, 727, 1130, 11602, 184637, 17, 727, 1130, 4105, 49123, 35262, 473, 32247, 1152, 427, 727, 1427, 17, 3262, 707, 3423, 427, 13485, 1152, 7747, 361, 170205, 15, 707, 2152, 727, 1427, 1331, 55385, 5484, 14652, 6291, 999, 117805, 731, 29726, 1119, 96, 17, 2670, 3968, 9361, 632, 269, 42512]], 'attention_mask': [[1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]]}
`,nl,ut,al,ft,pl,dt,ml,bt,Ml,wt,Gs=`API 文档：
<a href="https://huggingface.co/docs/peft/main/en/package_reference/tuners#peft.PromptTuningConfig" rel="nofollow">https://huggingface.co/docs/peft/main/en/package_reference/tuners#peft.PromptTuningConfig</a>`,il,ct,Xs="我们可以对两个要训练的模型使用相同的配置。",ol,jt,yl,Jt,rl,Tt,Ws="我们将使用相同的预训练模型和相同的配置来创建两个相同的提示调整模型。",ul,ht,fl,Ut,Bs=`trainable params: 4,096 || all params: 559,218,688 || trainable%: 0.0007324504863471229
None
`,dl,$t,bl,_t,ks=`trainable params: 4,096 || all params: 559,218,688 || trainable%: 0.0007324504863471229
None
`,wl,Ct,Rs="<strong>太神奇了：你看到可训练参数的减少了吗？我们将要训练可用参数的 0.001%。</strong>",cl,Zt,Vs="现在我们要创建训练参数，并且在这两次训练中我们将使用相同的配置。",jl,gt,Jl,Gt,Tl,Xt,vs="在创建 TrainingArguments 时，我们需要指明包含模型的目录。",hl,Wt,Ul,Bt,$l,kt,Is="我们将为每个要训练的模型创建一个 trainer 对象。",_l,Rt,Cl,Vt,Zl,vt,gl,It,xs="在不到 10 分钟的时间内（在 M1 Pro上的 CPU 时间），我们使用同一个基础模型训练了两个不同任务的模型。",Gl,xt,Xl,Ft,Fs="我们将要保存模型。只要我们有创建它们的预训练模型在内存中，这些模型就可以使用了。",Wl,Ht,Bl,Yt,kl,Qt,Hs="你可以从之前保存的路径加载模型，并根据我们的输入要求模型生成文本！",Rl,At,Vl,Nt,vl,zt,Ys=`['I want you to act as a motivational coach.  You will be helping students learn how they can improve their performance in the classroom and at school.']
`,Il,Et,Qs="如果我们比较两个答案，有些东西改变了。",xl,St,As="<li><strong><em>预训练模型：</em></strong> <em>我希望你扮演一个激励教练。不要害怕被挑战。</em></li> <li><strong><em>微调模型：</em></strong> <em>我希望你扮演一个激励教练。如果你感到焦虑，你可以使用这个方法。</em></li>",Fl,Pt,Ns="我们必须记住，我们只训练了模型几分钟，但它们已经足够让我们得到更接近我们想要的结果的响应。",Hl,qt,Yl,Lt,Ql,Kt,zs=`['There are two nice things that should matter to you: the weather and your health.']
`,Al,Dt,Es="对于第二个模型，我们得到了类似的结果。",Nl,Ot,Ss="<li><strong>预训练模型：</strong> <em>有两件对你来说很重要的事情：你的产品的价格和质量。</em></li> <li><strong>微调模型：</strong> <em>有两件对你来说很重要的事情：天气和你的健康。</em></li>",zl,te,El,ee,Ps="提示微调是一种惊人的技术，可以节省我们数小时的训练时间和大量的金钱。在这个 notebook 中，我们只用了几分钟就训练了两个模型，并且我们可以将两个模型都保存在内存中，为不同的客户提供服务。",Sl,le,qs="如果你想要尝试不同的组合和模型，这个 notebook 已经准备好使用 Bloom 家族中的另一个模型。",Pl,se,Ls="你可以更改训练的轮数、虚拟 token 的数量和第三个单元格中的模型。然而，有许多配置需要更改。如果你正在寻找一个很好的练习，你可以用固定值替换虚拟 token 的随机初始化。",ql,ne,Ks="<em>微调模型的响应可能在每次我们训练它们时都会有所不同。我粘贴了我的一次训练的结果，但实际结果可能会有所不同。</em>",Ll,ae,Kl,me,Dl;return c=new mn({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/prompt_tuning_peft.ipynb"}]}}),j=new b({props:{title:"使用 PEFT 进行提示微调",local:"使用-peft-进行提示微调",headingTag:"h1"}}),$=new b({props:{title:"提示微调简要介绍",local:"提示微调简要介绍",headingTag:"h2"}}),B=new b({props:{title:"我们将在 notebook 中做什么？",local:"我们将在-notebook-中做什么",headingTag:"h2"}}),V=new b({props:{title:"加载 PEFT 库",local:"加载-peft-库",headingTag:"h2"}}),I=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHBlZnQlM0QlM0QwLjguMg==",highlighted:'!pip install -q peft==<span class="hljs-number">0.8</span><span class="hljs-number">.2</span>',wrap:!1}}),x=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNC41",highlighted:'!pip install -q datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.5</span>',wrap:!1}}),H=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplcg==",highlighted:'<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer',wrap:!1}}),Y=new b({props:{title:"加载模型和分词器。",local:"加载模型和分词器",headingTag:"h3"}}),N=new d({props:{code:"bW9kZWxfbmFtZSUyMCUzRCUyMCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiUwQSUyMyUyMG1vZGVsX25hbWUlM0QlMjJiaWdzY2llbmNlJTJGYmxvb20tMWIxJTIyJTBBTlVNX1ZJUlRVQUxfVE9LRU5TJTIwJTNEJTIwNCUwQU5VTV9FUE9DSFMlMjAlM0QlMjA2",highlighted:`model_name = <span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>
<span class="hljs-comment"># model_name=&quot;bigscience/bloom-1b1&quot;</span>
NUM_VIRTUAL_TOKENS = <span class="hljs-number">4</span>
NUM_EPOCHS = <span class="hljs-number">6</span>`,wrap:!1}}),z=new d({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSklMEFmb3VuZGF0aW9uYWxfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`tokenizer = AutoTokenizer.from_pretrained(model_name)
foundational_model = AutoModelForCausalLM.from_pretrained(model_name, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),E=new b({props:{title:"使用预训练的 bloom 模型进行推理",local:"使用预训练的-bloom-模型进行推理",headingTag:"h2"}}),q=new d({props:{code:"JTIzJTIwdGhpcyUyMGZ1bmN0aW9uJTIwcmV0dXJucyUyMHRoZSUyMG91dHB1dHMlMjBmcm9tJTIwdGhlJTIwbW9kZWwlMjByZWNlaXZlZCUyQyUyMGFuZCUyMGlucHV0cy4lMEFkZWYlMjBnZXRfb3V0cHV0cyhtb2RlbCUyQyUyMGlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dF9pZHMlM0RpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdHRlbnRpb25fbWFzayUzRGlucHV0cyU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0RtYXhfbmV3X3Rva2VucyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHRlbXBlcmF0dXJlJTNEMC4yJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdG9wX3AlM0QwLjk1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJlcGV0aXRpb25fcGVuYWx0eSUzRDEuNSUyQyUyMCUyMCUyMyUyMEF2b2lkJTIwcmVwZXRpdGlvbi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlYXJseV9zdG9wcGluZyUzRFRydWUlMkMlMjAlMjAlMjMlMjBUaGUlMjBtb2RlbCUyMGNhbiUyMHN0b3AlMjBiZWZvcmUlMjByZWFjaCUyMHRoZSUyMG1heF9sZW5ndGglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dHM=",highlighted:`<span class="hljs-comment"># this function returns the outputs from the model received, and inputs.</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_outputs</span>(<span class="hljs-params">model, inputs, max_new_tokens=<span class="hljs-number">100</span></span>):
    outputs = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
        attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
        max_new_tokens=max_new_tokens,
        <span class="hljs-comment"># temperature=0.2,</span>
        <span class="hljs-comment"># top_p=0.95,</span>
        <span class="hljs-comment"># do_sample=True,</span>
        repetition_penalty=<span class="hljs-number">1.5</span>,  <span class="hljs-comment"># Avoid repetition.</span>
        early_stopping=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># The model can stop before reach the max_length</span>
        eos_token_id=tokenizer.eos_token_id,
    )
    <span class="hljs-keyword">return</span> outputs`,wrap:!1}}),tt=new d({props:{code:"aW5wdXRfcHJvbXB0JTIwJTNEJTIwdG9rZW5pemVyKCUyMkklMjB3YW50JTIweW91JTIwdG8lMjBhY3QlMjBhcyUyMGElMjBtb3RpdmF0aW9uYWwlMjBjb2FjaC4lMjAlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWZvdW5kYXRpb25hbF9vdXRwdXRzX3Byb21wdCUyMCUzRCUyMGdldF9vdXRwdXRzKGZvdW5kYXRpb25hbF9tb2RlbCUyQyUyMGlucHV0X3Byb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENTApJTBBJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShmb3VuZGF0aW9uYWxfb3V0cHV0c19wcm9tcHQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = tokenizer(<span class="hljs-string">&quot;I want you to act as a motivational coach. &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>foundational_outputs_prompt = get_outputs(foundational_model, input_prompt, max_new_tokens=<span class="hljs-number">50</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(foundational_outputs_prompt, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),lt=new d({props:{code:"aW5wdXRfc2VudGVuY2VzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZXJlJTIwYXJlJTIwdHdvJTIwbmljZSUyMHRoaW5ncyUyMHRoYXQlMjBzaG91bGQlMjBtYXR0ZXIlMjB0byUyMHlvdSUzQSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBZm91bmRhdGlvbmFsX291dHB1dHNfc2VudGVuY2UlMjAlM0QlMjBnZXRfb3V0cHV0cyhmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBpbnB1dF9zZW50ZW5jZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUwKSUwQSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZm91bmRhdGlvbmFsX291dHB1dHNfc2VudGVuY2UlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>input_sentences = tokenizer(<span class="hljs-string">&quot;There are two nice things that should matter to you:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>foundational_outputs_sentence = get_outputs(foundational_model, input_sentences, max_new_tokens=<span class="hljs-number">50</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(foundational_outputs_sentence, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),at=new b({props:{title:"准备数据集",local:"准备数据集",headingTag:"h2"}}),Mt=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEElMjMlMjBvcy5lbnZpcm9uJTVCJTIyVE9LRU5JWkVSU19QQVJBTExFTElTTSUyMiU1RCUyMCUzRCUyMCUyMmZhbHNlJTIy",highlighted:`<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># os.environ[&quot;TOKENIZERS_PARALLELISM&quot;] = &quot;false&quot;</span>`,wrap:!1}}),it=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldF9wcm9tcHQlMjAlM0QlMjAlMjJma2ElMkZhd2Vzb21lLWNoYXRncHQtcHJvbXB0cyUyMiUwQSUwQSUyMyUyMENyZWF0ZSUyMHRoZSUyMERhdGFzZXQlMjB0byUyMGNyZWF0ZSUyMHByb21wdHMuJTBBZGF0YV9wcm9tcHQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoZGF0YXNldF9wcm9tcHQpJTBBZGF0YV9wcm9tcHQlMjAlM0QlMjBkYXRhX3Byb21wdC5tYXAobGFtYmRhJTIwc2FtcGxlcyUzQSUyMHRva2VuaXplcihzYW1wbGVzJTVCJTIycHJvbXB0JTIyJTVEKSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQXRyYWluX3NhbXBsZV9wcm9tcHQlMjAlM0QlMjBkYXRhX3Byb21wdCU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChyYW5nZSg1MCkp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

dataset_prompt = <span class="hljs-string">&quot;fka/awesome-chatgpt-prompts&quot;</span>

<span class="hljs-comment"># Create the Dataset to create prompts.</span>
data_prompt = load_dataset(dataset_prompt)
data_prompt = data_prompt.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> samples: tokenizer(samples[<span class="hljs-string">&quot;prompt&quot;</span>]), batched=<span class="hljs-literal">True</span>)
train_sample_prompt = data_prompt[<span class="hljs-string">&quot;train&quot;</span>].select(<span class="hljs-built_in">range</span>(<span class="hljs-number">50</span>))`,wrap:!1}}),ot=new d({props:{code:"ZGlzcGxheSh0cmFpbl9zYW1wbGVfcHJvbXB0KQ==",highlighted:"display(train_sample_prompt)",wrap:!1}}),yt=new d({props:{code:"cHJpbnQodHJhaW5fc2FtcGxlX3Byb21wdCU1QiUzQTElNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_sample_prompt[:<span class="hljs-number">1</span>])',wrap:!1}}),ut=new d({props:{code:"ZGF0YXNldF9zZW50ZW5jZXMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyQWJpcmF0ZSUyRmVuZ2xpc2hfcXVvdGVzJTIyKSUwQSUwQWRhdGFfc2VudGVuY2VzJTIwJTNEJTIwZGF0YXNldF9zZW50ZW5jZXMubWFwKGxhbWJkYSUyMHNhbXBsZXMlM0ElMjB0b2tlbml6ZXIoc2FtcGxlcyU1QiUyMnF1b3RlJTIyJTVEKSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQXRyYWluX3NhbXBsZV9zZW50ZW5jZXMlMjAlM0QlMjBkYXRhX3NlbnRlbmNlcyU1QiUyMnRyYWluJTIyJTVELnNlbGVjdChyYW5nZSgyNSkpJTBBdHJhaW5fc2FtcGxlX3NlbnRlbmNlcyUyMCUzRCUyMHRyYWluX3NhbXBsZV9zZW50ZW5jZXMucmVtb3ZlX2NvbHVtbnMoJTVCJTIyYXV0aG9yJTIyJTJDJTIwJTIydGFncyUyMiU1RCk=",highlighted:`dataset_sentences = load_dataset(<span class="hljs-string">&quot;Abirate/english_quotes&quot;</span>)

data_sentences = dataset_sentences.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> samples: tokenizer(samples[<span class="hljs-string">&quot;quote&quot;</span>]), batched=<span class="hljs-literal">True</span>)
train_sample_sentences = data_sentences[<span class="hljs-string">&quot;train&quot;</span>].select(<span class="hljs-built_in">range</span>(<span class="hljs-number">25</span>))
train_sample_sentences = train_sample_sentences.remove_columns([<span class="hljs-string">&quot;author&quot;</span>, <span class="hljs-string">&quot;tags&quot;</span>])`,wrap:!1}}),ft=new d({props:{code:"ZGlzcGxheSh0cmFpbl9zYW1wbGVfc2VudGVuY2VzKQ==",highlighted:"display(train_sample_sentences)",wrap:!1}}),dt=new b({props:{title:"微调",local:"微调",headingTag:"h2"}}),bt=new b({props:{title:"PEFT 配置",local:"peft-配置",headingTag:"h3"}}),jt=new d({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUyQyUyMFByb21wdFR1bmluZ0NvbmZpZyUyQyUyMFRhc2tUeXBlJTJDJTIwUHJvbXB0VHVuaW5nSW5pdCUwQSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwUHJvbXB0VHVuaW5nQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHRhc2tfdHlwZSUzRFRhc2tUeXBlLkNBVVNBTF9MTSUyQyUyMCUyMCUyMyUyMFRoaXMlMjB0eXBlJTIwaW5kaWNhdGVzJTIwdGhlJTIwbW9kZWwlMjB3aWxsJTIwZ2VuZXJhdGUlMjB0ZXh0LiUwQSUyMCUyMCUyMCUyMHByb21wdF90dW5pbmdfaW5pdCUzRFByb21wdFR1bmluZ0luaXQuUkFORE9NJTJDJTIwJTIwJTIzJTIwVGhlJTIwYWRkZWQlMjB2aXJ0dWFsJTIwdG9rZW5zJTIwYXJlJTIwaW5pdGlhbGl6YWQlMjB3aXRoJTIwcmFuZG9tJTIwbnVtYmVycyUwQSUyMCUyMCUyMCUyMG51bV92aXJ0dWFsX3Rva2VucyUzRE5VTV9WSVJUVUFMX1RPS0VOUyUyQyUyMCUyMCUyMyUyME51bWJlciUyMG9mJTIwdmlydHVhbCUyMHRva2VucyUyMHRvJTIwYmUlMjBhZGRlZCUyMGFuZCUyMHRyYWluZWQuJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyX25hbWVfb3JfcGF0aCUzRG1vZGVsX25hbWUlMkMlMjAlMjAlMjMlMjBUaGUlMjBwcmUtdHJhaW5lZCUyMG1vZGVsLiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, PromptTuningConfig, TaskType, PromptTuningInit

generation_config = PromptTuningConfig(
    task_type=TaskType.CAUSAL_LM,  <span class="hljs-comment"># This type indicates the model will generate text.</span>
    prompt_tuning_init=PromptTuningInit.RANDOM,  <span class="hljs-comment"># The added virtual tokens are initializad with random numbers</span>
    num_virtual_tokens=NUM_VIRTUAL_TOKENS,  <span class="hljs-comment"># Number of virtual tokens to be added and trained.</span>
    tokenizer_name_or_path=model_name,  <span class="hljs-comment"># The pre-trained model.</span>
)`,wrap:!1}}),Jt=new b({props:{title:"创建两个提示调整模型。",local:"创建两个提示调整模型",headingTag:"h3"}}),ht=new d({props:{code:"cGVmdF9tb2RlbF9wcm9tcHQlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyklMEFwcmludChwZWZ0X21vZGVsX3Byb21wdC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>peft_model_prompt = get_peft_model(foundational_model, generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(peft_model_prompt.print_trainable_parameters())`,wrap:!1}}),$t=new d({props:{code:"cGVmdF9tb2RlbF9zZW50ZW5jZXMlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMjBnZW5lcmF0aW9uX2NvbmZpZyklMEFwcmludChwZWZ0X21vZGVsX3NlbnRlbmNlcy5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>peft_model_sentences = get_peft_model(foundational_model, generation_config)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(peft_model_sentences.print_trainable_parameters())`,wrap:!1}}),gt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBJTBBZGVmJTIwY3JlYXRlX3RyYWluaW5nX2FyZ3VtZW50cyhwYXRoJTJDJTIwbGVhcm5pbmdfcmF0ZSUzRDAuMDAzNSUyQyUyMGVwb2NocyUzRDYpJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RwYXRoJTJDJTIwJTIwJTIzJTIwV2hlcmUlMjB0aGUlMjBtb2RlbCUyMHByZWRpY3Rpb25zJTIwYW5kJTIwY2hlY2twb2ludHMlMjB3aWxsJTIwYmUlMjB3cml0dGVuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdXNlX2NwdSUzRFRydWUlMkMlMjAlMjAlMjMlMjBUaGlzJTIwaXMlMjBuZWNlc3NhcnklMjBmb3IlMjBDUFUlMjBjbHVzdGVycy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhdXRvX2ZpbmRfYmF0Y2hfc2l6ZSUzRFRydWUlMkMlMjAlMjAlMjMlMjBGaW5kJTIwYSUyMHN1aXRhYmxlJTIwYmF0Y2glMjBzaXplJTIwdGhhdCUyMHdpbGwlMjBmaXQlMjBpbnRvJTIwbWVtb3J5JTIwYXV0b21hdGljYWxseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0RsZWFybmluZ19yYXRlJTJDJTIwJTIwJTIzJTIwSGlnaGVyJTIwbGVhcm5pbmclMjByYXRlJTIwdGhhbiUyMGZ1bGwlMjBGaW5lLVR1bmluZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0RlcG9jaHMlMkMlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhaW5pbmdfYXJncw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_training_arguments</span>(<span class="hljs-params">path, learning_rate=<span class="hljs-number">0.0035</span>, epochs=<span class="hljs-number">6</span></span>):
    training_args = TrainingArguments(
        output_dir=path,  <span class="hljs-comment"># Where the model predictions and checkpoints will be written</span>
        use_cpu=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># This is necessary for CPU clusters.</span>
        auto_find_batch_size=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Find a suitable batch size that will fit into memory automatically</span>
        learning_rate=learning_rate,  <span class="hljs-comment"># Higher learning rate than full Fine-Tuning</span>
        num_train_epochs=epochs,
    )
    <span class="hljs-keyword">return</span> training_args`,wrap:!1}}),Gt=new d({props:{code:"aW1wb3J0JTIwb3MlMEElMEF3b3JraW5nX2RpciUyMCUzRCUyMCUyMi4lMkYlMjIlMEElMEElMjMlMjBJcyUyMGJlc3QlMjB0byUyMHN0b3JlJTIwdGhlJTIwbW9kZWxzJTIwaW4lMjBzZXBhcmF0ZSUyMGZvbGRlcnMuJTBBJTIzJTIwQ3JlYXRlJTIwdGhlJTIwbmFtZSUyMG9mJTIwdGhlJTIwZGlyZWN0b3JpZXMlMjB3aGVyZSUyMHRvJTIwc3RvcmUlMjB0aGUlMjBtb2RlbHMuJTBBb3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQlMjAlM0QlMjBvcy5wYXRoLmpvaW4od29ya2luZ19kaXIlMkMlMjAlMjJwZWZ0X291dHB1dHNfcHJvbXB0JTIyKSUwQW91dHB1dF9kaXJlY3Rvcnlfc2VudGVuY2VzJTIwJTNEJTIwb3MucGF0aC5qb2luKHdvcmtpbmdfZGlyJTJDJTIwJTIycGVmdF9vdXRwdXRzX3NlbnRlbmNlcyUyMiklMEElMEElMjMlMjBKdXN0JTIwY3JlYXRpbmclMjB0aGUlMjBkaXJlY3RvcmlzJTIwaWYlMjBub3QlMjBleGlzdC4lMEFpZiUyMG5vdCUyMG9zLnBhdGguZXhpc3RzKHdvcmtpbmdfZGlyKSUzQSUwQSUyMCUyMCUyMCUyMG9zLm1rZGlyKHdvcmtpbmdfZGlyKSUwQWlmJTIwbm90JTIwb3MucGF0aC5leGlzdHMob3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQpJTNBJTBBJTIwJTIwJTIwJTIwb3MubWtkaXIob3V0cHV0X2RpcmVjdG9yeV9wcm9tcHQpJTBBaWYlMjBub3QlMjBvcy5wYXRoLmV4aXN0cyhvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyklM0ElMEElMjAlMjAlMjAlMjBvcy5ta2RpcihvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyk=",highlighted:`<span class="hljs-keyword">import</span> os

working_dir = <span class="hljs-string">&quot;./&quot;</span>

<span class="hljs-comment"># Is best to store the models in separate folders.</span>
<span class="hljs-comment"># Create the name of the directories where to store the models.</span>
output_directory_prompt = os.path.join(working_dir, <span class="hljs-string">&quot;peft_outputs_prompt&quot;</span>)
output_directory_sentences = os.path.join(working_dir, <span class="hljs-string">&quot;peft_outputs_sentences&quot;</span>)

<span class="hljs-comment"># Just creating the directoris if not exist.</span>
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(working_dir):
    os.mkdir(working_dir)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(output_directory_prompt):
    os.mkdir(output_directory_prompt)
<span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> os.path.exists(output_directory_sentences):
    os.mkdir(output_directory_sentences)`,wrap:!1}}),Wt=new d({props:{code:"dHJhaW5pbmdfYXJnc19wcm9tcHQlMjAlM0QlMjBjcmVhdGVfdHJhaW5pbmdfYXJndW1lbnRzKG91dHB1dF9kaXJlY3RvcnlfcHJvbXB0JTJDJTIwMC4wMDMlMkMlMjBOVU1fRVBPQ0hTKSUwQXRyYWluaW5nX2FyZ3Nfc2VudGVuY2VzJTIwJTNEJTIwY3JlYXRlX3RyYWluaW5nX2FyZ3VtZW50cyhvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyUyQyUyMDAuMDAzJTJDJTIwTlVNX0VQT0NIUyk=",highlighted:`training_args_prompt = create_training_arguments(output_directory_prompt, <span class="hljs-number">0.003</span>, NUM_EPOCHS)
training_args_sentences = create_training_arguments(output_directory_sentences, <span class="hljs-number">0.003</span>, NUM_EPOCHS)`,wrap:!1}}),Bt=new b({props:{title:"训练",local:"训练",headingTag:"h2"}}),Rt=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMkMlMjBEYXRhQ29sbGF0b3JGb3JMYW5ndWFnZU1vZGVsaW5nJTBBJTBBJTBBZGVmJTIwY3JlYXRlX3RyYWluZXIobW9kZWwlMkMlMjB0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCklM0ElMEElMjAlMjAlMjAlMjB0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTIwJTIwJTIzJTIwV2UlMjBwYXNzJTIwaW4lMjB0aGUlMjBQRUZUJTIwdmVyc2lvbiUyMG9mJTIwdGhlJTIwZm91bmRhdGlvbiUyMG1vZGVsJTJDJTIwYmxvb216LTU2ME0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUyMCUyMCUyMyUyMFRoZSUyMGFyZ3MlMjBmb3IlMjB0aGUlMjB0cmFpbmluZy4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdHJhaW5fZGF0YXNldCUyQyUyMCUyMCUyMyUyMFRoZSUyMGRhdGFzZXQlMjB1c2VkJTIwdG8lMjB0eXJhaW4lMjB0aGUlMjBtb2RlbC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNERGF0YUNvbGxhdG9yRm9yTGFuZ3VhZ2VNb2RlbGluZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbml6ZXIlMkMlMjBtbG0lM0RGYWxzZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMjAlMjAlMjMlMjBtbG0lM0RGYWxzZSUyMGluZGljYXRlcyUyMG5vdCUyMHRvJTIwdXNlJTIwbWFza2VkJTIwbGFuZ3VhZ2UlMjBtb2RlbGluZyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0cmFpbmVy",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, DataCollatorForLanguageModeling


<span class="hljs-keyword">def</span> <span class="hljs-title function_">create_trainer</span>(<span class="hljs-params">model, training_args, train_dataset</span>):
    trainer = Trainer(
        model=model,  <span class="hljs-comment"># We pass in the PEFT version of the foundation model, bloomz-560M</span>
        args=training_args,  <span class="hljs-comment"># The args for the training.</span>
        train_dataset=train_dataset,  <span class="hljs-comment"># The dataset used to tyrain the model.</span>
        data_collator=DataCollatorForLanguageModeling(
            tokenizer, mlm=<span class="hljs-literal">False</span>
        ),  <span class="hljs-comment"># mlm=False indicates not to use masked language modeling</span>
    )
    <span class="hljs-keyword">return</span> trainer`,wrap:!1}}),Vt=new d({props:{code:"JTIzJTIwVHJhaW5pbmclMjBmaXJzdCUyMG1vZGVsLiUwQXRyYWluZXJfcHJvbXB0JTIwJTNEJTIwY3JlYXRlX3RyYWluZXIocGVmdF9tb2RlbF9wcm9tcHQlMkMlMjB0cmFpbmluZ19hcmdzX3Byb21wdCUyQyUyMHRyYWluX3NhbXBsZV9wcm9tcHQpJTBBdHJhaW5lcl9wcm9tcHQudHJhaW4oKQ==",highlighted:`<span class="hljs-comment"># Training first model.</span>
trainer_prompt = create_trainer(peft_model_prompt, training_args_prompt, train_sample_prompt)
trainer_prompt.train()`,wrap:!1}}),vt=new d({props:{code:"JTIzJTIwVHJhaW5pbmclMjBzZWNvbmQlMjBtb2RlbC4lMEF0cmFpbmVyX3NlbnRlbmNlcyUyMCUzRCUyMGNyZWF0ZV90cmFpbmVyKHBlZnRfbW9kZWxfc2VudGVuY2VzJTJDJTIwdHJhaW5pbmdfYXJnc19zZW50ZW5jZXMlMkMlMjB0cmFpbl9zYW1wbGVfc2VudGVuY2VzKSUwQXRyYWluZXJfc2VudGVuY2VzLnRyYWluKCk=",highlighted:`<span class="hljs-comment"># Training second model.</span>
trainer_sentences = create_trainer(peft_model_sentences, training_args_sentences, train_sample_sentences)
trainer_sentences.train()`,wrap:!1}}),xt=new b({props:{title:"保存模型",local:"保存模型",headingTag:"h2"}}),Ht=new d({props:{code:"dHJhaW5lcl9wcm9tcHQubW9kZWwuc2F2ZV9wcmV0cmFpbmVkKG91dHB1dF9kaXJlY3RvcnlfcHJvbXB0KSUwQXRyYWluZXJfc2VudGVuY2VzLm1vZGVsLnNhdmVfcHJldHJhaW5lZChvdXRwdXRfZGlyZWN0b3J5X3NlbnRlbmNlcyk=",highlighted:`trainer_prompt.model.save_pretrained(output_directory_prompt)
trainer_sentences.model.save_pretrained(output_directory_sentences)`,wrap:!1}}),Yt=new b({props:{title:"推理",local:"推理",headingTag:"h2"}}),At=new d({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFsb2FkZWRfbW9kZWxfcHJvbXB0JTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBmb3VuZGF0aW9uYWxfbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyZWN0b3J5X3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMGRldmljZV9tYXAlM0QnYXV0byclMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmFibGUlM0RGYWxzZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

loaded_model_prompt = PeftModel.from_pretrained(
    foundational_model,
    output_directory_prompt,
    <span class="hljs-comment"># device_map=&#x27;auto&#x27;,</span>
    is_trainable=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),Nt=new d({props:{code:"bG9hZGVkX21vZGVsX3Byb21wdF9vdXRwdXRzJTIwJTNEJTIwZ2V0X291dHB1dHMobG9hZGVkX21vZGVsX3Byb21wdCUyQyUyMGlucHV0X3Byb21wdCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGxvYWRlZF9tb2RlbF9wcm9tcHRfb3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>loaded_model_prompt_outputs = get_outputs(loaded_model_prompt, input_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(loaded_model_prompt_outputs, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),qt=new d({props:{code:"bG9hZGVkX21vZGVsX3Byb21wdC5sb2FkX2FkYXB0ZXIob3V0cHV0X2RpcmVjdG9yeV9zZW50ZW5jZXMlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJxdW90ZXMlMjIpJTBBbG9hZGVkX21vZGVsX3Byb21wdC5zZXRfYWRhcHRlciglMjJxdW90ZXMlMjIp",highlighted:`loaded_model_prompt.load_adapter(output_directory_sentences, adapter_name=<span class="hljs-string">&quot;quotes&quot;</span>)
loaded_model_prompt.set_adapter(<span class="hljs-string">&quot;quotes&quot;</span>)`,wrap:!1}}),Lt=new d({props:{code:"bG9hZGVkX21vZGVsX3NlbnRlbmNlc19vdXRwdXRzJTIwJTNEJTIwZ2V0X291dHB1dHMobG9hZGVkX21vZGVsX3Byb21wdCUyQyUyMGlucHV0X3NlbnRlbmNlcyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGxvYWRlZF9tb2RlbF9zZW50ZW5jZXNfb3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>loaded_model_sentences_outputs = get_outputs(loaded_model_prompt, input_sentences)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(loaded_model_sentences_outputs, skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),te=new b({props:{title:"结论",local:"结论",headingTag:"h1"}}),ae=new Mn({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/prompt_tuning_peft.md"}}),{c(){w=p("meta"),Me=n(),pe=p("p"),ie=n(),i(c.$$.fragment),oe=n(),i(j.$$.fragment),ye=n(),J=p("p"),J.innerHTML=ts,re=n(),T=p("p"),T.textContent=es,ue=n(),h=p("p"),h.innerHTML=ls,fe=n(),U=p("p"),U.textContent=ss,de=n(),i($.$$.fragment),be=n(),_=p("p"),_.textContent=ns,we=n(),C=p("p"),C.textContent=as,ce=n(),Z=p("p"),Z.innerHTML=ps,je=n(),g=p("p"),g.innerHTML=ms,Je=n(),G=p("p"),G.textContent=Ms,Te=n(),X=p("p"),X.innerHTML=is,he=n(),W=p("p"),W.textContent=os,Ue=n(),i(B.$$.fragment),$e=n(),k=p("p"),k.textContent=ys,_e=n(),R=p("p"),R.textContent=rs,Ce=n(),i(V.$$.fragment),Ze=n(),v=p("p"),v.textContent=us,ge=n(),i(I.$$.fragment),Ge=n(),i(x.$$.fragment),Xe=n(),F=p("p"),F.textContent=fs,We=n(),i(H.$$.fragment),Be=n(),i(Y.$$.fragment),ke=n(),Q=p("p"),Q.textContent=ds,Re=n(),A=p("p"),A.textContent=bs,Ve=n(),i(N.$$.fragment),ve=n(),i(z.$$.fragment),Ie=n(),i(E.$$.fragment),xe=n(),S=p("p"),S.innerHTML=ws,Fe=n(),P=p("p"),P.textContent=cs,He=n(),i(q.$$.fragment),Ye=n(),L=p("p"),L.textContent=js,Qe=n(),K=p("p"),K.textContent=Js,Ae=n(),D=p("p"),D.textContent=Ts,Ne=n(),O=p("p"),O.textContent=hs,ze=n(),i(tt.$$.fragment),Ee=n(),et=p("pre"),et.textContent=Us,Se=n(),i(lt.$$.fragment),Pe=n(),st=p("pre"),st.textContent=$s,qe=n(),nt=p("p"),nt.textContent=_s,Le=n(),i(at.$$.fragment),Ke=n(),pt=p("p"),pt.textContent=Cs,De=n(),mt=p("ul"),mt.innerHTML=Zs,Oe=n(),i(Mt.$$.fragment),tl=n(),i(it.$$.fragment),el=n(),i(ot.$$.fragment),ll=n(),i(yt.$$.fragment),sl=n(),rt=p("pre"),rt.textContent=gs,nl=n(),i(ut.$$.fragment),al=n(),i(ft.$$.fragment),pl=n(),i(dt.$$.fragment),ml=n(),i(bt.$$.fragment),Ml=n(),wt=p("p"),wt.innerHTML=Gs,il=n(),ct=p("p"),ct.textContent=Xs,ol=n(),i(jt.$$.fragment),yl=n(),i(Jt.$$.fragment),rl=n(),Tt=p("p"),Tt.textContent=Ws,ul=n(),i(ht.$$.fragment),fl=n(),Ut=p("pre"),Ut.textContent=Bs,dl=n(),i($t.$$.fragment),bl=n(),_t=p("pre"),_t.textContent=ks,wl=n(),Ct=p("p"),Ct.innerHTML=Rs,cl=n(),Zt=p("p"),Zt.textContent=Vs,jl=n(),i(gt.$$.fragment),Jl=n(),i(Gt.$$.fragment),Tl=n(),Xt=p("p"),Xt.textContent=vs,hl=n(),i(Wt.$$.fragment),Ul=n(),i(Bt.$$.fragment),$l=n(),kt=p("p"),kt.textContent=Is,_l=n(),i(Rt.$$.fragment),Cl=n(),i(Vt.$$.fragment),Zl=n(),i(vt.$$.fragment),gl=n(),It=p("p"),It.textContent=xs,Gl=n(),i(xt.$$.fragment),Xl=n(),Ft=p("p"),Ft.textContent=Fs,Wl=n(),i(Ht.$$.fragment),Bl=n(),i(Yt.$$.fragment),kl=n(),Qt=p("p"),Qt.textContent=Hs,Rl=n(),i(At.$$.fragment),Vl=n(),i(Nt.$$.fragment),vl=n(),zt=p("pre"),zt.textContent=Ys,Il=n(),Et=p("p"),Et.textContent=Qs,xl=n(),St=p("ul"),St.innerHTML=As,Fl=n(),Pt=p("p"),Pt.textContent=Ns,Hl=n(),i(qt.$$.fragment),Yl=n(),i(Lt.$$.fragment),Ql=n(),Kt=p("pre"),Kt.textContent=zs,Al=n(),Dt=p("p"),Dt.textContent=Es,Nl=n(),Ot=p("ul"),Ot.innerHTML=Ss,zl=n(),i(te.$$.fragment),El=n(),ee=p("p"),ee.textContent=Ps,Sl=n(),le=p("p"),le.textContent=qs,Pl=n(),se=p("p"),se.textContent=Ls,ql=n(),ne=p("p"),ne.innerHTML=Ks,Ll=n(),i(ae.$$.fragment),Kl=n(),me=p("p"),this.h()},l(t){const e=an("svelte-u9bgzb",document.head);w=m(e,"META",{name:!0,content:!0}),e.forEach(l),Me=a(t),pe=m(t,"P",{}),Ds(pe).forEach(l),ie=a(t),o(c.$$.fragment,t),oe=a(t),o(j.$$.fragment,t),ye=a(t),J=m(t,"P",{"data-svelte-h":!0}),M(J)!=="svelte-1hm5fnd"&&(J.innerHTML=ts),re=a(t),T=m(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-k8apnd"&&(T.textContent=es),ue=a(t),h=m(t,"P",{"data-svelte-h":!0}),M(h)!=="svelte-183v4i5"&&(h.innerHTML=ls),fe=a(t),U=m(t,"P",{"data-svelte-h":!0}),M(U)!=="svelte-llxnoz"&&(U.textContent=ss),de=a(t),o($.$$.fragment,t),be=a(t),_=m(t,"P",{"data-svelte-h":!0}),M(_)!=="svelte-6e31nm"&&(_.textContent=ns),we=a(t),C=m(t,"P",{"data-svelte-h":!0}),M(C)!=="svelte-18dp60q"&&(C.textContent=as),ce=a(t),Z=m(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-18z3ipt"&&(Z.innerHTML=ps),je=a(t),g=m(t,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1nkffqs"&&(g.innerHTML=ms),Je=a(t),G=m(t,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1tegg1n"&&(G.textContent=Ms),Te=a(t),X=m(t,"P",{"data-svelte-h":!0}),M(X)!=="svelte-13ojr0e"&&(X.innerHTML=is),he=a(t),W=m(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1mmvk7i"&&(W.textContent=os),Ue=a(t),o(B.$$.fragment,t),$e=a(t),k=m(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-qll3ym"&&(k.textContent=ys),_e=a(t),R=m(t,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1f9e5y5"&&(R.textContent=rs),Ce=a(t),o(V.$$.fragment,t),Ze=a(t),v=m(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1jqtkfh"&&(v.textContent=us),ge=a(t),o(I.$$.fragment,t),Ge=a(t),o(x.$$.fragment,t),Xe=a(t),F=m(t,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1wz4900"&&(F.textContent=fs),We=a(t),o(H.$$.fragment,t),Be=a(t),o(Y.$$.fragment,t),ke=a(t),Q=m(t,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-tyj5lb"&&(Q.textContent=ds),Re=a(t),A=m(t,"P",{"data-svelte-h":!0}),M(A)!=="svelte-hv45u7"&&(A.textContent=bs),Ve=a(t),o(N.$$.fragment,t),ve=a(t),o(z.$$.fragment,t),Ie=a(t),o(E.$$.fragment,t),xe=a(t),S=m(t,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1fujawk"&&(S.innerHTML=ws),Fe=a(t),P=m(t,"P",{"data-svelte-h":!0}),M(P)!=="svelte-1t9fxk8"&&(P.textContent=cs),He=a(t),o(q.$$.fragment,t),Ye=a(t),L=m(t,"P",{"data-svelte-h":!0}),M(L)!=="svelte-qzii9o"&&(L.textContent=js),Qe=a(t),K=m(t,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1jz4d16"&&(K.textContent=Js),Ae=a(t),D=m(t,"P",{"data-svelte-h":!0}),M(D)!=="svelte-x816ca"&&(D.textContent=Ts),Ne=a(t),O=m(t,"P",{"data-svelte-h":!0}),M(O)!=="svelte-gaknpy"&&(O.textContent=hs),ze=a(t),o(tt.$$.fragment,t),Ee=a(t),et=m(t,"PRE",{"data-svelte-h":!0}),M(et)!=="svelte-j0gwzs"&&(et.textContent=Us),Se=a(t),o(lt.$$.fragment,t),Pe=a(t),st=m(t,"PRE",{"data-svelte-h":!0}),M(st)!=="svelte-156di1e"&&(st.textContent=$s),qe=a(t),nt=m(t,"P",{"data-svelte-h":!0}),M(nt)!=="svelte-1drfwsu"&&(nt.textContent=_s),Le=a(t),o(at.$$.fragment,t),Ke=a(t),pt=m(t,"P",{"data-svelte-h":!0}),M(pt)!=="svelte-1rf18xk"&&(pt.textContent=Cs),De=a(t),mt=m(t,"UL",{"data-svelte-h":!0}),M(mt)!=="svelte-q7foik"&&(mt.innerHTML=Zs),Oe=a(t),o(Mt.$$.fragment,t),tl=a(t),o(it.$$.fragment,t),el=a(t),o(ot.$$.fragment,t),ll=a(t),o(yt.$$.fragment,t),sl=a(t),rt=m(t,"PRE",{"data-svelte-h":!0}),M(rt)!=="svelte-19qaqk6"&&(rt.textContent=gs),nl=a(t),o(ut.$$.fragment,t),al=a(t),o(ft.$$.fragment,t),pl=a(t),o(dt.$$.fragment,t),ml=a(t),o(bt.$$.fragment,t),Ml=a(t),wt=m(t,"P",{"data-svelte-h":!0}),M(wt)!=="svelte-ga822j"&&(wt.innerHTML=Gs),il=a(t),ct=m(t,"P",{"data-svelte-h":!0}),M(ct)!=="svelte-1ba2eyz"&&(ct.textContent=Xs),ol=a(t),o(jt.$$.fragment,t),yl=a(t),o(Jt.$$.fragment,t),rl=a(t),Tt=m(t,"P",{"data-svelte-h":!0}),M(Tt)!=="svelte-1659lue"&&(Tt.textContent=Ws),ul=a(t),o(ht.$$.fragment,t),fl=a(t),Ut=m(t,"PRE",{"data-svelte-h":!0}),M(Ut)!=="svelte-1j4ogfu"&&(Ut.textContent=Bs),dl=a(t),o($t.$$.fragment,t),bl=a(t),_t=m(t,"PRE",{"data-svelte-h":!0}),M(_t)!=="svelte-1j4ogfu"&&(_t.textContent=ks),wl=a(t),Ct=m(t,"P",{"data-svelte-h":!0}),M(Ct)!=="svelte-qd5vw9"&&(Ct.innerHTML=Rs),cl=a(t),Zt=m(t,"P",{"data-svelte-h":!0}),M(Zt)!=="svelte-yat80l"&&(Zt.textContent=Vs),jl=a(t),o(gt.$$.fragment,t),Jl=a(t),o(Gt.$$.fragment,t),Tl=a(t),Xt=m(t,"P",{"data-svelte-h":!0}),M(Xt)!=="svelte-1kvnpq3"&&(Xt.textContent=vs),hl=a(t),o(Wt.$$.fragment,t),Ul=a(t),o(Bt.$$.fragment,t),$l=a(t),kt=m(t,"P",{"data-svelte-h":!0}),M(kt)!=="svelte-ukow41"&&(kt.textContent=Is),_l=a(t),o(Rt.$$.fragment,t),Cl=a(t),o(Vt.$$.fragment,t),Zl=a(t),o(vt.$$.fragment,t),gl=a(t),It=m(t,"P",{"data-svelte-h":!0}),M(It)!=="svelte-uayr8h"&&(It.textContent=xs),Gl=a(t),o(xt.$$.fragment,t),Xl=a(t),Ft=m(t,"P",{"data-svelte-h":!0}),M(Ft)!=="svelte-1m4fky2"&&(Ft.textContent=Fs),Wl=a(t),o(Ht.$$.fragment,t),Bl=a(t),o(Yt.$$.fragment,t),kl=a(t),Qt=m(t,"P",{"data-svelte-h":!0}),M(Qt)!=="svelte-2ugde3"&&(Qt.textContent=Hs),Rl=a(t),o(At.$$.fragment,t),Vl=a(t),o(Nt.$$.fragment,t),vl=a(t),zt=m(t,"PRE",{"data-svelte-h":!0}),M(zt)!=="svelte-17c65rx"&&(zt.textContent=Ys),Il=a(t),Et=m(t,"P",{"data-svelte-h":!0}),M(Et)!=="svelte-qho7gg"&&(Et.textContent=Qs),xl=a(t),St=m(t,"UL",{"data-svelte-h":!0}),M(St)!=="svelte-xewazx"&&(St.innerHTML=As),Fl=a(t),Pt=m(t,"P",{"data-svelte-h":!0}),M(Pt)!=="svelte-vanqym"&&(Pt.textContent=Ns),Hl=a(t),o(qt.$$.fragment,t),Yl=a(t),o(Lt.$$.fragment,t),Ql=a(t),Kt=m(t,"PRE",{"data-svelte-h":!0}),M(Kt)!=="svelte-1h21gmq"&&(Kt.textContent=zs),Al=a(t),Dt=m(t,"P",{"data-svelte-h":!0}),M(Dt)!=="svelte-8rd4fj"&&(Dt.textContent=Es),Nl=a(t),Ot=m(t,"UL",{"data-svelte-h":!0}),M(Ot)!=="svelte-yccex6"&&(Ot.innerHTML=Ss),zl=a(t),o(te.$$.fragment,t),El=a(t),ee=m(t,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-1nhoviv"&&(ee.textContent=Ps),Sl=a(t),le=m(t,"P",{"data-svelte-h":!0}),M(le)!=="svelte-13xfee6"&&(le.textContent=qs),Pl=a(t),se=m(t,"P",{"data-svelte-h":!0}),M(se)!=="svelte-lhgy67"&&(se.textContent=Ls),ql=a(t),ne=m(t,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-k1fwp0"&&(ne.innerHTML=Ks),Ll=a(t),o(ae.$$.fragment,t),Kl=a(t),me=m(t,"P",{}),Ds(me).forEach(l),this.h()},h(){Os(w,"name","hf:doc:metadata"),Os(w,"content",yn)},m(t,e){pn(document.head,w),s(t,Me,e),s(t,pe,e),s(t,ie,e),y(c,t,e),s(t,oe,e),y(j,t,e),s(t,ye,e),s(t,J,e),s(t,re,e),s(t,T,e),s(t,ue,e),s(t,h,e),s(t,fe,e),s(t,U,e),s(t,de,e),y($,t,e),s(t,be,e),s(t,_,e),s(t,we,e),s(t,C,e),s(t,ce,e),s(t,Z,e),s(t,je,e),s(t,g,e),s(t,Je,e),s(t,G,e),s(t,Te,e),s(t,X,e),s(t,he,e),s(t,W,e),s(t,Ue,e),y(B,t,e),s(t,$e,e),s(t,k,e),s(t,_e,e),s(t,R,e),s(t,Ce,e),y(V,t,e),s(t,Ze,e),s(t,v,e),s(t,ge,e),y(I,t,e),s(t,Ge,e),y(x,t,e),s(t,Xe,e),s(t,F,e),s(t,We,e),y(H,t,e),s(t,Be,e),y(Y,t,e),s(t,ke,e),s(t,Q,e),s(t,Re,e),s(t,A,e),s(t,Ve,e),y(N,t,e),s(t,ve,e),y(z,t,e),s(t,Ie,e),y(E,t,e),s(t,xe,e),s(t,S,e),s(t,Fe,e),s(t,P,e),s(t,He,e),y(q,t,e),s(t,Ye,e),s(t,L,e),s(t,Qe,e),s(t,K,e),s(t,Ae,e),s(t,D,e),s(t,Ne,e),s(t,O,e),s(t,ze,e),y(tt,t,e),s(t,Ee,e),s(t,et,e),s(t,Se,e),y(lt,t,e),s(t,Pe,e),s(t,st,e),s(t,qe,e),s(t,nt,e),s(t,Le,e),y(at,t,e),s(t,Ke,e),s(t,pt,e),s(t,De,e),s(t,mt,e),s(t,Oe,e),y(Mt,t,e),s(t,tl,e),y(it,t,e),s(t,el,e),y(ot,t,e),s(t,ll,e),y(yt,t,e),s(t,sl,e),s(t,rt,e),s(t,nl,e),y(ut,t,e),s(t,al,e),y(ft,t,e),s(t,pl,e),y(dt,t,e),s(t,ml,e),y(bt,t,e),s(t,Ml,e),s(t,wt,e),s(t,il,e),s(t,ct,e),s(t,ol,e),y(jt,t,e),s(t,yl,e),y(Jt,t,e),s(t,rl,e),s(t,Tt,e),s(t,ul,e),y(ht,t,e),s(t,fl,e),s(t,Ut,e),s(t,dl,e),y($t,t,e),s(t,bl,e),s(t,_t,e),s(t,wl,e),s(t,Ct,e),s(t,cl,e),s(t,Zt,e),s(t,jl,e),y(gt,t,e),s(t,Jl,e),y(Gt,t,e),s(t,Tl,e),s(t,Xt,e),s(t,hl,e),y(Wt,t,e),s(t,Ul,e),y(Bt,t,e),s(t,$l,e),s(t,kt,e),s(t,_l,e),y(Rt,t,e),s(t,Cl,e),y(Vt,t,e),s(t,Zl,e),y(vt,t,e),s(t,gl,e),s(t,It,e),s(t,Gl,e),y(xt,t,e),s(t,Xl,e),s(t,Ft,e),s(t,Wl,e),y(Ht,t,e),s(t,Bl,e),y(Yt,t,e),s(t,kl,e),s(t,Qt,e),s(t,Rl,e),y(At,t,e),s(t,Vl,e),y(Nt,t,e),s(t,vl,e),s(t,zt,e),s(t,Il,e),s(t,Et,e),s(t,xl,e),s(t,St,e),s(t,Fl,e),s(t,Pt,e),s(t,Hl,e),y(qt,t,e),s(t,Yl,e),y(Lt,t,e),s(t,Ql,e),s(t,Kt,e),s(t,Al,e),s(t,Dt,e),s(t,Nl,e),s(t,Ot,e),s(t,zl,e),y(te,t,e),s(t,El,e),s(t,ee,e),s(t,Sl,e),s(t,le,e),s(t,Pl,e),s(t,se,e),s(t,ql,e),s(t,ne,e),s(t,Ll,e),y(ae,t,e),s(t,Kl,e),s(t,me,e),Dl=!0},p:en,i(t){Dl||(r(c.$$.fragment,t),r(j.$$.fragment,t),r($.$$.fragment,t),r(B.$$.fragment,t),r(V.$$.fragment,t),r(I.$$.fragment,t),r(x.$$.fragment,t),r(H.$$.fragment,t),r(Y.$$.fragment,t),r(N.$$.fragment,t),r(z.$$.fragment,t),r(E.$$.fragment,t),r(q.$$.fragment,t),r(tt.$$.fragment,t),r(lt.$$.fragment,t),r(at.$$.fragment,t),r(Mt.$$.fragment,t),r(it.$$.fragment,t),r(ot.$$.fragment,t),r(yt.$$.fragment,t),r(ut.$$.fragment,t),r(ft.$$.fragment,t),r(dt.$$.fragment,t),r(bt.$$.fragment,t),r(jt.$$.fragment,t),r(Jt.$$.fragment,t),r(ht.$$.fragment,t),r($t.$$.fragment,t),r(gt.$$.fragment,t),r(Gt.$$.fragment,t),r(Wt.$$.fragment,t),r(Bt.$$.fragment,t),r(Rt.$$.fragment,t),r(Vt.$$.fragment,t),r(vt.$$.fragment,t),r(xt.$$.fragment,t),r(Ht.$$.fragment,t),r(Yt.$$.fragment,t),r(At.$$.fragment,t),r(Nt.$$.fragment,t),r(qt.$$.fragment,t),r(Lt.$$.fragment,t),r(te.$$.fragment,t),r(ae.$$.fragment,t),Dl=!0)},o(t){u(c.$$.fragment,t),u(j.$$.fragment,t),u($.$$.fragment,t),u(B.$$.fragment,t),u(V.$$.fragment,t),u(I.$$.fragment,t),u(x.$$.fragment,t),u(H.$$.fragment,t),u(Y.$$.fragment,t),u(N.$$.fragment,t),u(z.$$.fragment,t),u(E.$$.fragment,t),u(q.$$.fragment,t),u(tt.$$.fragment,t),u(lt.$$.fragment,t),u(at.$$.fragment,t),u(Mt.$$.fragment,t),u(it.$$.fragment,t),u(ot.$$.fragment,t),u(yt.$$.fragment,t),u(ut.$$.fragment,t),u(ft.$$.fragment,t),u(dt.$$.fragment,t),u(bt.$$.fragment,t),u(jt.$$.fragment,t),u(Jt.$$.fragment,t),u(ht.$$.fragment,t),u($t.$$.fragment,t),u(gt.$$.fragment,t),u(Gt.$$.fragment,t),u(Wt.$$.fragment,t),u(Bt.$$.fragment,t),u(Rt.$$.fragment,t),u(Vt.$$.fragment,t),u(vt.$$.fragment,t),u(xt.$$.fragment,t),u(Ht.$$.fragment,t),u(Yt.$$.fragment,t),u(At.$$.fragment,t),u(Nt.$$.fragment,t),u(qt.$$.fragment,t),u(Lt.$$.fragment,t),u(te.$$.fragment,t),u(ae.$$.fragment,t),Dl=!1},d(t){t&&(l(Me),l(pe),l(ie),l(oe),l(ye),l(J),l(re),l(T),l(ue),l(h),l(fe),l(U),l(de),l(be),l(_),l(we),l(C),l(ce),l(Z),l(je),l(g),l(Je),l(G),l(Te),l(X),l(he),l(W),l(Ue),l($e),l(k),l(_e),l(R),l(Ce),l(Ze),l(v),l(ge),l(Ge),l(Xe),l(F),l(We),l(Be),l(ke),l(Q),l(Re),l(A),l(Ve),l(ve),l(Ie),l(xe),l(S),l(Fe),l(P),l(He),l(Ye),l(L),l(Qe),l(K),l(Ae),l(D),l(Ne),l(O),l(ze),l(Ee),l(et),l(Se),l(Pe),l(st),l(qe),l(nt),l(Le),l(Ke),l(pt),l(De),l(mt),l(Oe),l(tl),l(el),l(ll),l(sl),l(rt),l(nl),l(al),l(pl),l(ml),l(Ml),l(wt),l(il),l(ct),l(ol),l(yl),l(rl),l(Tt),l(ul),l(fl),l(Ut),l(dl),l(bl),l(_t),l(wl),l(Ct),l(cl),l(Zt),l(jl),l(Jl),l(Tl),l(Xt),l(hl),l(Ul),l($l),l(kt),l(_l),l(Cl),l(Zl),l(gl),l(It),l(Gl),l(Xl),l(Ft),l(Wl),l(Bl),l(kl),l(Qt),l(Rl),l(Vl),l(vl),l(zt),l(Il),l(Et),l(xl),l(St),l(Fl),l(Pt),l(Hl),l(Yl),l(Ql),l(Kt),l(Al),l(Dt),l(Nl),l(Ot),l(zl),l(El),l(ee),l(Sl),l(le),l(Pl),l(se),l(ql),l(ne),l(Ll),l(Kl),l(me)),l(w),f(c,t),f(j,t),f($,t),f(B,t),f(V,t),f(I,t),f(x,t),f(H,t),f(Y,t),f(N,t),f(z,t),f(E,t),f(q,t),f(tt,t),f(lt,t),f(at,t),f(Mt,t),f(it,t),f(ot,t),f(yt,t),f(ut,t),f(ft,t),f(dt,t),f(bt,t),f(jt,t),f(Jt,t),f(ht,t),f($t,t),f(gt,t),f(Gt,t),f(Wt,t),f(Bt,t),f(Rt,t),f(Vt,t),f(vt,t),f(xt,t),f(Ht,t),f(Yt,t),f(At,t),f(Nt,t),f(qt,t),f(Lt,t),f(te,t),f(ae,t)}}}const yn='{"title":"使用 PEFT 进行提示微调","local":"使用-peft-进行提示微调","sections":[{"title":"提示微调简要介绍","local":"提示微调简要介绍","sections":[],"depth":2},{"title":"我们将在 notebook 中做什么？","local":"我们将在-notebook-中做什么","sections":[],"depth":2},{"title":"加载 PEFT 库","local":"加载-peft-库","sections":[{"title":"加载模型和分词器。","local":"加载模型和分词器","sections":[],"depth":3}],"depth":2},{"title":"使用预训练的 bloom 模型进行推理","local":"使用预训练的-bloom-模型进行推理","sections":[],"depth":2},{"title":"准备数据集","local":"准备数据集","sections":[],"depth":2},{"title":"微调","local":"微调","sections":[{"title":"PEFT 配置","local":"peft-配置","sections":[],"depth":3},{"title":"创建两个提示调整模型。","local":"创建两个提示调整模型","sections":[],"depth":3}],"depth":2},{"title":"训练","local":"训练","sections":[],"depth":2},{"title":"保存模型","local":"保存模型","sections":[],"depth":2},{"title":"推理","local":"推理","sections":[],"depth":2}],"depth":1}';function rn(Ol){return ln(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wn extends sn{constructor(w){super(),nn(this,w,rn,on,tn,{})}}export{wn as component};
