import{s as $s,n as Ls,o as Ds}from"../chunks/scheduler.65852ee5.js";import{S as Ks,i as Ps,g as M,s as n,r as y,A as Os,h as p,f as t,c as a,j as xs,u as c,x as J,k as Fs,y as lt,a as e,v as o,d as i,t as T,w as U}from"../chunks/index.aa74147d.js";import{D as st,C as j}from"../chunks/DocNotebookDropdown.1a7e6a42.js";import{H as zs,E as tt}from"../chunks/getInferenceSnippets.a1cbc7e2.js";function et(is){let u,Ul,il,jl,r,ul,w,rl,d,Ts='<em>作者: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',wl,m,Us='<p>这个教程比较高级，建议你先看看另一个<a href="advanced_rag">更基础的教程</a>。</p>',dl,h,js="<p>检索增强生成（RAG）是一种用大型语言模型（LLM）来回答问题的方法，但它会先从知识库中查找相关信息。这种方法比只用大型语言模型有很多好处，比如可以基于真实的事实来回答问题，减少虚构内容，还可以让模型获取特定领域的知识，并且可以精确控制模型从知识库中获取信息。</p>",ml,I,us="不过，普通的RAG方法有两个主要问题：",hl,b,rs="<li>它只进行<strong>一次信息检索</strong>，如果检索的结果不好，那么回答也会差。</li> <li>它计算<strong>语义相似性时是以用户的提问为参照</strong>，这可能不太理想。比如，用户提出的问题通常是用疑问句，而包含答案的文档通常是陈述句，这样就会导致真正含有答案的文档和用户提问的相似性得分不高，可能会错过重要的信息。</li>",Il,Z,ws="为了解决这些问题，我们可以创建<strong>一个带有检索功能的 RAG 智能体。</strong>",bl,C,ds="这个智能体可以 ✅ 自己构建查询，并且 ✅ 在需要的时候重新检索信息。",Zl,B,ms="所以，我们得用点高级的 RAG 技术！",Cl,G,hs='<li>不直接使用用户的提问去搜索，而是智能体自行制定一个更接近目标文档的参考句子，就像 <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a> 那样</li> <li>智能体能生成片段并在需要时重新检索，就像 <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a> 那样</li>',Bl,g,Is="让我们开始做这个系统吧。🛠️",Gl,f,bs="运行下面的命令来安装所需的软件包：",gl,N,fl,V,Zs="我们首先加载一个知识库，以便在其上执行 RAG：这个数据集是许多 <code>huggingface</code> 软件包的文档页面的汇总，以 markdown 格式存储。",Nl,W,Vl,R,Cs='现在我们通过处理数据集并将其存储到向量数据库中，为检索器准备知识库。我们使用 <a href="https://python.langchain.com/" rel="nofollow">LangChain</a>，因为它具有出色的向量数据库工具。对于嵌入模型，我们使用 <a href="https://huggingface.co/thenlper/gte-small" rel="nofollow">thenlper/gte-small</a>，因为它在我们的 <code>RAG_evaluation</code> 指南中表现良好。',Wl,Q,Rl,v,Bs=`Splitting documents...
`,Ql,E,Gs="现在数据库已经准备好了：让我们构建我们的智能体 RAG 系统吧！",vl,X,gs="👉 我们只需要一个 <code>RetrieverTool</code>，我们的智能体可以利用它从知识库中检索信息。",El,k,Xl,_,fs="现在创建一个利用这个工具的智能体就简单了！",kl,q,Ns="智能体在初始化时需要以下参数：",_l,Y,Vs="<li><em><code>tools</code></em>：智能体能够调用的工具列表。</li> <li><em><code>llm_engine</code></em>：为智能体提供动力的LLM。</li>",ql,A,Ws=`我们的 <code>llm_engine</code> 必须是一个可调用的对象，它接受一个 <a href="https://huggingface.co/docs/transformers/main/chat_templating" rel="nofollow">messages</a> 列表作为输入并返回文本。它还需要接受一个 <code>stop_sequences</code> 参数，该参数指示何时停止生成。为了方便起见，我们直接使用包中提供的 <code>HfModel</code> 类来获取一个调用我们的 <a href="https://huggingface.co/docs/api-inference/en/index" rel="nofollow">Inference API</a> 的 LLM 引擎。
我们使用 <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus" rel="nofollow">CohereForAI/c4ai-command-r-plus</a> 作为 llm 引擎，因为：`,Yl,H,Rs="<li>它有一个长达 128k 的上下文，这对于处理长源文档很有帮助</li> <li>它在 HF 的 Inference API 上始终免费提供！</li>",Al,S,Hl,x,Qs="既然我们已经将智能体初始化为 <code>ToolCallingAgent</code>，它就已经自动赋予了一个默认的系统提示，告诉 LLM 引擎要逐步处理并生成工具调用作为 JSON 块（你可以根据需要用你自己的提示模板替换这个）。",Sl,F,vs="然后，当它的 <code>.run()</code> 方法被启动时，智能体负责调用 LLM 引擎，解析工具调用的 JSON 块并执行这些工具调用，所有这些都在一个循环中进行，只有当提供最终答案时才会结束。",xl,z,Fl,$,Es=`Final output:
There are multiple ways to push a model to the Hub. Here are a few examples using different libraries and functions:

Using the \`api\`:
python
api.upload_folder(
    repo_id=repo_id,
    folder_path=repo_local_path,
    path_in_repo='.',
)

print('Your model is pushed to the Hub. You can view your model here:', repo_url)


With Transformers:
python
from transformers import PushToHubCallback

# Initialize the callback with the output directory,
tokenizer, and your Hub username and model name
push_to_hub_callback = PushToHubCallback(
    output_dir='./your_model_save_path',
    tokenizer=tokenizer,
    hub_model_id='your-username/my-awesome-model'
)

# Assuming \`trainer\` is your Trainer object
trainer.add_callback(push_to_hub_callback)


Using \`timm\`:
python
from timm.models.hub import push_to_hf_hub

# Assuming \`model\` is your fine-tuned model
model_cfg = &#123;'labels': ['a', 'b', 'c', 'd']}
push_to_hf_hub(model, 'resnet18-random', model_config=model_cfg)


For computer vision models, you can also use \`push_to_hub\`:
python
processor.push_to_hub(hub_model_id)
trainer.push_to_hub(**kwargs)


You can also manually push a model with \`model.push_to_hub()\`:
python
model.push_to_hub()


Additionally, you can opt to push your model to the Hub at the end of training by specifying \`push_to_hub=True\` in the training configuration. Don't forget to have git-lfs installed and be logged into your Hugging Face account.
`,zl,L,$l,D,Xs="智能体 RAG 和标准 RAG，哪个更好？我们用 LLM Judge 来比一比。",Ll,K,ks='我们会用一个非常强的模型 <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">meta-llama/Meta-Llama-3-70B-Instruct</a> 来做这个评估。',Dl,P,Kl,O,_s="在运行测试之前，让我们让智能体输出更简洁一些。",Pl,ll,Ol,sl,ls,tl,ss,el,qs='评估提示遵循了<a href="llm_judge">我们的 llm_judge cookbook</a> 中展示的一些最佳原则：它遵循一个小的整数李克特量表，有明确的评分标准和每个分数的描述。',ts,nl,es,al,ns,Ml,as,pl,Ys=`Average score for agentic RAG: 78.5%
`,Ms,Jl,As="<strong>让我们回顾一下：与标准的 RAG 相比，智能体设置提高了 8.5% 的得分！</strong>（从 70.0% 提高到 78.5%）",ps,yl,Hs="这是一个巨大的改进，而且设置非常简单🚀",Js,cl,Ss="（作为基准，不使用知识库的 Llama-3-70B 得分为 36%）",ys,ol,cs,Tl,os;return r=new st({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_rag.ipynb"}]}}),w=new zs({props:{title:"智能体 RAG：通过查询重构和自查询来增强你的 RAG ！🚀",local:"智能体-rag通过查询重构和自查询来增强你的-rag-",headingTag:"h1"}}),N=new j({props:{code:"IXBpcCUyMGluc3RhbGwlMjBwYW5kYXMlMjBsYW5nY2hhaW4lMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwc2VudGVuY2UtdHJhbnNmb3JtZXJzJTIwZmFpc3MtY3B1JTIwc21vbGFnZW50cw==",highlighted:"!pip install pandas langchain langchain-community sentence-transformers faiss-cpu smolagents",wrap:!1}}),W=new j({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Q=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> langchain_community.vectorstores.utils <span class="hljs-keyword">import</span> DistanceStrategy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>source_docs = [
<span class="hljs-meta">... </span>    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>text_splitter = RecursiveCharacterTextSplitter.from_huggingface_tokenizer(
<span class="hljs-meta">... </span>    AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>),
<span class="hljs-meta">... </span>    chunk_size=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    chunk_overlap=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    add_start_index=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    strip_whitespace=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Split docs and keep only unique ones</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Splitting documents...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>docs_processed = []
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_texts = {}
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> tqdm(source_docs):
<span class="hljs-meta">... </span>    new_docs = text_splitter.split_documents([doc])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> new_doc <span class="hljs-keyword">in</span> new_docs:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> new_doc.page_content <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> unique_texts:
<span class="hljs-meta">... </span>            unique_texts[doc.page_content] = <span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>            docs_processed.append(new_doc)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Embedding documents... This should take a few minutes (5 minutes on MacBook with M1 Pro)&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vectordb = FAISS.from_documents(
<span class="hljs-meta">... </span>    documents=docs_processed,
<span class="hljs-meta">... </span>    embedding=embedding_model,
<span class="hljs-meta">... </span>    distance_strategy=DistanceStrategy.COSINE,
<span class="hljs-meta">... </span>)`,wrap:!1}}),k=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Using semantic similarity, retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.vectordb.similarity_search(
            query,
            k=<span class="hljs-number">7</span>,
        )

        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [<span class="hljs-string">f&quot;===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)]
        )`,wrap:!1}}),S=new j({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZk1vZGVsJTJDJTIwVG9vbENhbGxpbmdBZ2VudCUwQSUwQW1vZGVsJTIwJTNEJTIwSGZNb2RlbCglMjJDb2hlcmVGb3JBSSUyRmM0YWktY29tbWFuZC1yLXBsdXMlMjIpJTBBJTBBcmV0cmlldmVyX3Rvb2wlMjAlM0QlMjBSZXRyaWV2ZXJUb29sKHZlY3RvcmRiKSUwQWFnZW50JTIwJTNEJTIwVG9vbENhbGxpbmdBZ2VudCh0b29scyUzRCU1QnJldHJpZXZlcl90b29sJTVEJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMG1heF9pdGVyYXRpb25zJTNENCUyQyUyMHZlcmJvc2UlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfModel, ToolCallingAgent

model = HfModel(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-plus&quot;</span>)

retriever_tool = RetrieverTool(vectordb)
agent = ToolCallingAgent(tools=[retriever_tool], model=model, max_iterations=<span class="hljs-number">4</span>, verbose=<span class="hljs-number">2</span>)`,wrap:!1}}),z=new j({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkhvdyUyMGNhbiUyMEklMjBwdXNoJTIwYSUyMG1vZGVsJTIwdG8lMjB0aGUlMjBIdWIlM0YlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;How can I push a model to the Hub?&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),L=new zs({props:{title:"智能体RAG与标准RAG的比较",local:"智能体rag与标准rag的比较",headingTag:"h2"}}),P=new j({props:{code:"ZXZhbF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jX3FhX2V2YWwlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:'eval_dataset = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc_qa_eval&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)',wrap:!1}}),ll=new j({props:{code:"aW1wb3J0JTIwbG9nZ2luZyUwQSUwQWFnZW50LmxvZ2dlci5zZXRMZXZlbChsb2dnaW5nLldBUk5JTkcp",highlighted:`<span class="hljs-keyword">import</span> logging

agent.logger.setLevel(logging.WARNING)`,wrap:!1}}),sl=new j({props:{code:"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",highlighted:`outputs_agentic_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]

    enhanced_question = <span class="hljs-string">f&quot;&quot;&quot;Using the information contained in your knowledge base, which you can access with the &#x27;retriever&#x27; tool,
give a comprehensive answer to the question below.
Respond only to the question asked, response should be concise and relevant to the question.
If you cannot find information, do not give up and try calling your retriever again with different arguments!
Make sure to have covered the question completely by calling the retriever tool several times with semantically different queries.
Your queries should not be questions but affirmative form sentences: e.g. rather than &quot;How do I load a model from the Hub in bf16?&quot;, query should be &quot;load a model from the Hub bf16 weights&quot;.

Question:
<span class="hljs-subst">{question}</span>&quot;&quot;&quot;</span>
    answer = agent.run(enhanced_question)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_agentic_rag.append(results_agentic)`,wrap:!1}}),tl=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

reader_llm = InferenceClient(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-plus&quot;</span>)

outputs_standard_rag = []

<span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> tqdm(eval_dataset):
    question = example[<span class="hljs-string">&quot;question&quot;</span>]
    context = retriever_tool(question)

    prompt = <span class="hljs-string">f&quot;&quot;&quot;Given the question and supporting documents below, give a comprehensive answer to the question.
Respond only to the question asked, response should be concise and relevant to the question.
Provide the number of the source document when relevant.
If you cannot find information, do not give up and try calling your retriever again with different arguments!

Question:
<span class="hljs-subst">{question}</span>

<span class="hljs-subst">{context}</span>
&quot;&quot;&quot;</span>
    messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: prompt}]
    answer = reader_llm.chat_completion(messages).choices[<span class="hljs-number">0</span>].message.content

    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;=======================================================&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Answer: <span class="hljs-subst">{answer}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;True answer: <span class="hljs-subst">{example[<span class="hljs-string">&quot;answer&quot;</span>]}</span>&#x27;</span>)

    results_agentic = {
        <span class="hljs-string">&quot;question&quot;</span>: question,
        <span class="hljs-string">&quot;true_answer&quot;</span>: example[<span class="hljs-string">&quot;answer&quot;</span>],
        <span class="hljs-string">&quot;source_doc&quot;</span>: example[<span class="hljs-string">&quot;source_doc&quot;</span>],
        <span class="hljs-string">&quot;generated_answer&quot;</span>: answer,
    }
    outputs_standard_rag.append(results_agentic)`,wrap:!1}}),nl=new j({props:{code:"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",highlighted:`EVALUATION_PROMPT = <span class="hljs-string">&quot;&quot;&quot;You are a fair evaluator language model.

You will be given an instruction, a response to evaluate, a reference answer that gets a score of 3, and a score rubric representing a evaluation criteria are given.
1. Write a detailed feedback that assess the quality of the response strictly based on the given score rubric, not evaluating in general.
2. After writing a feedback, write a score that is an integer between 1 and 3. You should refer to the score rubric.
3. The output format should look as follows: \\&quot;Feedback: {{write a feedback for criteria}} [RESULT] {{an integer number between 1 and 3}}\\&quot;
4. Please do not generate any other opening, closing, and explanations. Be sure to include [RESULT] in your output.
5. Do not score conciseness: a correct answer that covers the question should receive max score, even if it contains additional useless information.

The instruction to evaluate:
{instruction}

Response to evaluate:
{response}

Reference Answer (Score 3):
{reference_answer}

Score Rubrics:
[Is the response complete, accurate, and factual based on the reference answer?]
Score 1: The response is completely incomplete, inaccurate, and/or not factual.
Score 2: The response is somewhat complete, accurate, and/or factual.
Score 3: The response is completely complete, accurate, and/or factual.

Feedback:&quot;&quot;&quot;</span>`,wrap:!1}}),al=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWV2YWx1YXRpb25fY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

evaluation_client = InferenceClient(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)`,wrap:!1}}),Ml=new j({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">type</span>, outputs <span class="hljs-keyword">in</span> [
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;agentic&quot;</span>, outputs_agentic_rag),
<span class="hljs-meta">... </span>    (<span class="hljs-string">&quot;standard&quot;</span>, outputs_standard_rag),
<span class="hljs-meta">... </span>]:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> experiment <span class="hljs-keyword">in</span> tqdm(outputs):
<span class="hljs-meta">... </span>        eval_prompt = EVALUATION_PROMPT.<span class="hljs-built_in">format</span>(
<span class="hljs-meta">... </span>            instruction=experiment[<span class="hljs-string">&quot;question&quot;</span>],
<span class="hljs-meta">... </span>            response=experiment[<span class="hljs-string">&quot;generated_answer&quot;</span>],
<span class="hljs-meta">... </span>            reference_answer=experiment[<span class="hljs-string">&quot;true_answer&quot;</span>],
<span class="hljs-meta">... </span>        )
<span class="hljs-meta">... </span>        messages = [
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a fair evaluator language model.&quot;</span>},
<span class="hljs-meta">... </span>            {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: eval_prompt},
<span class="hljs-meta">... </span>        ]

<span class="hljs-meta">... </span>        eval_result = evaluation_client.text_generation(eval_prompt, max_new_tokens=<span class="hljs-number">1000</span>)
<span class="hljs-meta">... </span>        <span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>            feedback, score = [item.strip() <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> eval_result.split(<span class="hljs-string">&quot;[RESULT]&quot;</span>)]
<span class="hljs-meta">... </span>            experiment[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>] = score
<span class="hljs-meta">... </span>            experiment[<span class="hljs-string">&quot;eval_feedback_LLM_judge&quot;</span>] = feedback
<span class="hljs-meta">... </span>        <span class="hljs-keyword">except</span>:
<span class="hljs-meta">... </span>            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Parsing failed - output was: <span class="hljs-subst">{eval_result}</span>&quot;</span>)

<span class="hljs-meta">... </span>    results = pd.DataFrame.from_dict(outputs)
<span class="hljs-meta">... </span>    results = results.loc[~results[<span class="hljs-string">&quot;generated_answer&quot;</span>].<span class="hljs-built_in">str</span>.contains(<span class="hljs-string">&quot;Error&quot;</span>)]
<span class="hljs-meta">... </span>    results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = results[<span class="hljs-string">&quot;eval_score_LLM_judge&quot;</span>].fillna(<span class="hljs-number">1</span>).apply(<span class="hljs-keyword">lambda</span> x: <span class="hljs-built_in">int</span>(x))
<span class="hljs-meta">... </span>    results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] = (results[<span class="hljs-string">&quot;eval_score_LLM_judge_int&quot;</span>] - <span class="hljs-number">1</span>) / <span class="hljs-number">2</span>

<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Average score for <span class="hljs-subst">{<span class="hljs-built_in">type</span>}</span> RAG: <span class="hljs-subst">{results[<span class="hljs-string">&#x27;eval_score_LLM_judge_int&#x27;</span>].mean()*<span class="hljs-number">100</span>:<span class="hljs-number">.1</span>f}</span>%&quot;</span>)`,wrap:!1}}),ol=new tt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/zh-CN/agent_rag.md"}}),{c(){u=M("meta"),Ul=n(),il=M("p"),jl=n(),y(r.$$.fragment),ul=n(),y(w.$$.fragment),rl=n(),d=M("p"),d.innerHTML=Ts,wl=n(),m=M("blockquote"),m.innerHTML=Us,dl=n(),h=M("blockquote"),h.innerHTML=js,ml=n(),I=M("p"),I.textContent=us,hl=n(),b=M("ul"),b.innerHTML=rs,Il=n(),Z=M("p"),Z.innerHTML=ws,bl=n(),C=M("p"),C.textContent=ds,Zl=n(),B=M("p"),B.textContent=ms,Cl=n(),G=M("ul"),G.innerHTML=hs,Bl=n(),g=M("p"),g.textContent=Is,Gl=n(),f=M("p"),f.textContent=bs,gl=n(),y(N.$$.fragment),fl=n(),V=M("p"),V.innerHTML=Zs,Nl=n(),y(W.$$.fragment),Vl=n(),R=M("p"),R.innerHTML=Cs,Wl=n(),y(Q.$$.fragment),Rl=n(),v=M("pre"),v.textContent=Bs,Ql=n(),E=M("p"),E.textContent=Gs,vl=n(),X=M("p"),X.innerHTML=gs,El=n(),y(k.$$.fragment),Xl=n(),_=M("p"),_.textContent=fs,kl=n(),q=M("p"),q.textContent=Ns,_l=n(),Y=M("ul"),Y.innerHTML=Vs,ql=n(),A=M("p"),A.innerHTML=Ws,Yl=n(),H=M("ul"),H.innerHTML=Rs,Al=n(),y(S.$$.fragment),Hl=n(),x=M("p"),x.innerHTML=Qs,Sl=n(),F=M("p"),F.innerHTML=vs,xl=n(),y(z.$$.fragment),Fl=n(),$=M("pre"),$.textContent=Es,zl=n(),y(L.$$.fragment),$l=n(),D=M("p"),D.textContent=Xs,Ll=n(),K=M("p"),K.innerHTML=ks,Dl=n(),y(P.$$.fragment),Kl=n(),O=M("p"),O.textContent=_s,Pl=n(),y(ll.$$.fragment),Ol=n(),y(sl.$$.fragment),ls=n(),y(tl.$$.fragment),ss=n(),el=M("p"),el.innerHTML=qs,ts=n(),y(nl.$$.fragment),es=n(),y(al.$$.fragment),ns=n(),y(Ml.$$.fragment),as=n(),pl=M("pre"),pl.textContent=Ys,Ms=n(),Jl=M("p"),Jl.innerHTML=As,ps=n(),yl=M("p"),yl.textContent=Hs,Js=n(),cl=M("p"),cl.textContent=Ss,ys=n(),y(ol.$$.fragment),cs=n(),Tl=M("p"),this.h()},l(l){const s=Os("svelte-u9bgzb",document.head);u=p(s,"META",{name:!0,content:!0}),s.forEach(t),Ul=a(l),il=p(l,"P",{}),xs(il).forEach(t),jl=a(l),c(r.$$.fragment,l),ul=a(l),c(w.$$.fragment,l),rl=a(l),d=p(l,"P",{"data-svelte-h":!0}),J(d)!=="svelte-1ouqjzx"&&(d.innerHTML=Ts),wl=a(l),m=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(m)!=="svelte-1xmu9r8"&&(m.innerHTML=Us),dl=a(l),h=p(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(h)!=="svelte-1y8hxsx"&&(h.innerHTML=js),ml=a(l),I=p(l,"P",{"data-svelte-h":!0}),J(I)!=="svelte-1afhnhb"&&(I.textContent=us),hl=a(l),b=p(l,"UL",{"data-svelte-h":!0}),J(b)!=="svelte-1i498ry"&&(b.innerHTML=rs),Il=a(l),Z=p(l,"P",{"data-svelte-h":!0}),J(Z)!=="svelte-1sugc90"&&(Z.innerHTML=ws),bl=a(l),C=p(l,"P",{"data-svelte-h":!0}),J(C)!=="svelte-1s3av12"&&(C.textContent=ds),Zl=a(l),B=p(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-hsbkwv"&&(B.textContent=ms),Cl=a(l),G=p(l,"UL",{"data-svelte-h":!0}),J(G)!=="svelte-d9fs7l"&&(G.innerHTML=hs),Bl=a(l),g=p(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-1mltr0r"&&(g.textContent=Is),Gl=a(l),f=p(l,"P",{"data-svelte-h":!0}),J(f)!=="svelte-afhoxn"&&(f.textContent=bs),gl=a(l),c(N.$$.fragment,l),fl=a(l),V=p(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-8zwf1q"&&(V.innerHTML=Zs),Nl=a(l),c(W.$$.fragment,l),Vl=a(l),R=p(l,"P",{"data-svelte-h":!0}),J(R)!=="svelte-4pfla7"&&(R.innerHTML=Cs),Wl=a(l),c(Q.$$.fragment,l),Rl=a(l),v=p(l,"PRE",{"data-svelte-h":!0}),J(v)!=="svelte-bkjqrc"&&(v.textContent=Bs),Ql=a(l),E=p(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-1cl11lp"&&(E.textContent=Gs),vl=a(l),X=p(l,"P",{"data-svelte-h":!0}),J(X)!=="svelte-qho14t"&&(X.innerHTML=gs),El=a(l),c(k.$$.fragment,l),Xl=a(l),_=p(l,"P",{"data-svelte-h":!0}),J(_)!=="svelte-11vwtv8"&&(_.textContent=fs),kl=a(l),q=p(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-t64l43"&&(q.textContent=Ns),_l=a(l),Y=p(l,"UL",{"data-svelte-h":!0}),J(Y)!=="svelte-1vtw5qe"&&(Y.innerHTML=Vs),ql=a(l),A=p(l,"P",{"data-svelte-h":!0}),J(A)!=="svelte-37rnrr"&&(A.innerHTML=Ws),Yl=a(l),H=p(l,"UL",{"data-svelte-h":!0}),J(H)!=="svelte-168kz1b"&&(H.innerHTML=Rs),Al=a(l),c(S.$$.fragment,l),Hl=a(l),x=p(l,"P",{"data-svelte-h":!0}),J(x)!=="svelte-1unxj4q"&&(x.innerHTML=Qs),Sl=a(l),F=p(l,"P",{"data-svelte-h":!0}),J(F)!=="svelte-1wjg1a8"&&(F.innerHTML=vs),xl=a(l),c(z.$$.fragment,l),Fl=a(l),$=p(l,"PRE",{"data-svelte-h":!0}),J($)!=="svelte-aexpmm"&&($.textContent=Es),zl=a(l),c(L.$$.fragment,l),$l=a(l),D=p(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-no7fth"&&(D.textContent=Xs),Ll=a(l),K=p(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-ihebqy"&&(K.innerHTML=ks),Dl=a(l),c(P.$$.fragment,l),Kl=a(l),O=p(l,"P",{"data-svelte-h":!0}),J(O)!=="svelte-vjko4c"&&(O.textContent=_s),Pl=a(l),c(ll.$$.fragment,l),Ol=a(l),c(sl.$$.fragment,l),ls=a(l),c(tl.$$.fragment,l),ss=a(l),el=p(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-16k51po"&&(el.innerHTML=qs),ts=a(l),c(nl.$$.fragment,l),es=a(l),c(al.$$.fragment,l),ns=a(l),c(Ml.$$.fragment,l),as=a(l),pl=p(l,"PRE",{"data-svelte-h":!0}),J(pl)!=="svelte-mnmczc"&&(pl.textContent=Ys),Ms=a(l),Jl=p(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-1kcm2on"&&(Jl.innerHTML=As),ps=a(l),yl=p(l,"P",{"data-svelte-h":!0}),J(yl)!=="svelte-9aqdr1"&&(yl.textContent=Hs),Js=a(l),cl=p(l,"P",{"data-svelte-h":!0}),J(cl)!=="svelte-1t0xi8t"&&(cl.textContent=Ss),ys=a(l),c(ol.$$.fragment,l),cs=a(l),Tl=p(l,"P",{}),xs(Tl).forEach(t),this.h()},h(){Fs(u,"name","hf:doc:metadata"),Fs(u,"content",nt)},m(l,s){lt(document.head,u),e(l,Ul,s),e(l,il,s),e(l,jl,s),o(r,l,s),e(l,ul,s),o(w,l,s),e(l,rl,s),e(l,d,s),e(l,wl,s),e(l,m,s),e(l,dl,s),e(l,h,s),e(l,ml,s),e(l,I,s),e(l,hl,s),e(l,b,s),e(l,Il,s),e(l,Z,s),e(l,bl,s),e(l,C,s),e(l,Zl,s),e(l,B,s),e(l,Cl,s),e(l,G,s),e(l,Bl,s),e(l,g,s),e(l,Gl,s),e(l,f,s),e(l,gl,s),o(N,l,s),e(l,fl,s),e(l,V,s),e(l,Nl,s),o(W,l,s),e(l,Vl,s),e(l,R,s),e(l,Wl,s),o(Q,l,s),e(l,Rl,s),e(l,v,s),e(l,Ql,s),e(l,E,s),e(l,vl,s),e(l,X,s),e(l,El,s),o(k,l,s),e(l,Xl,s),e(l,_,s),e(l,kl,s),e(l,q,s),e(l,_l,s),e(l,Y,s),e(l,ql,s),e(l,A,s),e(l,Yl,s),e(l,H,s),e(l,Al,s),o(S,l,s),e(l,Hl,s),e(l,x,s),e(l,Sl,s),e(l,F,s),e(l,xl,s),o(z,l,s),e(l,Fl,s),e(l,$,s),e(l,zl,s),o(L,l,s),e(l,$l,s),e(l,D,s),e(l,Ll,s),e(l,K,s),e(l,Dl,s),o(P,l,s),e(l,Kl,s),e(l,O,s),e(l,Pl,s),o(ll,l,s),e(l,Ol,s),o(sl,l,s),e(l,ls,s),o(tl,l,s),e(l,ss,s),e(l,el,s),e(l,ts,s),o(nl,l,s),e(l,es,s),o(al,l,s),e(l,ns,s),o(Ml,l,s),e(l,as,s),e(l,pl,s),e(l,Ms,s),e(l,Jl,s),e(l,ps,s),e(l,yl,s),e(l,Js,s),e(l,cl,s),e(l,ys,s),o(ol,l,s),e(l,cs,s),e(l,Tl,s),os=!0},p:Ls,i(l){os||(i(r.$$.fragment,l),i(w.$$.fragment,l),i(N.$$.fragment,l),i(W.$$.fragment,l),i(Q.$$.fragment,l),i(k.$$.fragment,l),i(S.$$.fragment,l),i(z.$$.fragment,l),i(L.$$.fragment,l),i(P.$$.fragment,l),i(ll.$$.fragment,l),i(sl.$$.fragment,l),i(tl.$$.fragment,l),i(nl.$$.fragment,l),i(al.$$.fragment,l),i(Ml.$$.fragment,l),i(ol.$$.fragment,l),os=!0)},o(l){T(r.$$.fragment,l),T(w.$$.fragment,l),T(N.$$.fragment,l),T(W.$$.fragment,l),T(Q.$$.fragment,l),T(k.$$.fragment,l),T(S.$$.fragment,l),T(z.$$.fragment,l),T(L.$$.fragment,l),T(P.$$.fragment,l),T(ll.$$.fragment,l),T(sl.$$.fragment,l),T(tl.$$.fragment,l),T(nl.$$.fragment,l),T(al.$$.fragment,l),T(Ml.$$.fragment,l),T(ol.$$.fragment,l),os=!1},d(l){l&&(t(Ul),t(il),t(jl),t(ul),t(rl),t(d),t(wl),t(m),t(dl),t(h),t(ml),t(I),t(hl),t(b),t(Il),t(Z),t(bl),t(C),t(Zl),t(B),t(Cl),t(G),t(Bl),t(g),t(Gl),t(f),t(gl),t(fl),t(V),t(Nl),t(Vl),t(R),t(Wl),t(Rl),t(v),t(Ql),t(E),t(vl),t(X),t(El),t(Xl),t(_),t(kl),t(q),t(_l),t(Y),t(ql),t(A),t(Yl),t(H),t(Al),t(Hl),t(x),t(Sl),t(F),t(xl),t(Fl),t($),t(zl),t($l),t(D),t(Ll),t(K),t(Dl),t(Kl),t(O),t(Pl),t(Ol),t(ls),t(ss),t(el),t(ts),t(es),t(ns),t(as),t(pl),t(Ms),t(Jl),t(ps),t(yl),t(Js),t(cl),t(ys),t(cs),t(Tl)),t(u),U(r,l),U(w,l),U(N,l),U(W,l),U(Q,l),U(k,l),U(S,l),U(z,l),U(L,l),U(P,l),U(ll,l),U(sl,l),U(tl,l),U(nl,l),U(al,l),U(Ml,l),U(ol,l)}}}const nt='{"title":"智能体 RAG：通过查询重构和自查询来增强你的 RAG ！🚀","local":"智能体-rag通过查询重构和自查询来增强你的-rag-","sections":[{"title":"智能体RAG与标准RAG的比较","local":"智能体rag与标准rag的比较","sections":[],"depth":2}],"depth":1}';function at(is){return Ds(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ct extends Ks{constructor(u){super(),Ps(this,u,at,et,$s,{})}}export{ct as component};
