import{s as ka,o as Ga,n as Za}from"../chunks/scheduler.6062bdaf.js";import{S as Ca,i as Ha,g as h,s as l,r as i,A as xa,h as m,f as a,c as n,j as Ja,u as r,x as f,k as Ua,y as Xa,a as s,v as o,d as p,t as c,w as g}from"../chunks/index.4bca734e.js";import{T as Ya}from"../chunks/Tip.b9ac1f03.js";import{C as y}from"../chunks/CodeBlock.fa01571c.js";import{H as d}from"../chunks/Heading.723dceba.js";function Ra(Xe){let u,w=`If you are used to working with platforms such as GitLab/GitHub/Bitbucket, your first instinct
might be to use <code>git</code> CLI to clone your repo (<code>git clone</code>), commit changes (<code>git add, git commit</code>) and push them
(<code>git push</code>). This is valid when using the Hugging Face Hub. However, software engineering and machine learning do
not share the same requirements and workflows. Model repositories might maintain large model weight files for different
frameworks and tools, so cloning the repository can lead to you maintaining large local folders with massive sizes. As
a result, it may be more efficient to use our custom HTTP methods. You can read our <a href="../concepts/git_vs_http">Git vs HTTP paradigm</a>
explanation page for more details.`;return{c(){u=h("p"),u.innerHTML=w},l($){u=m($,"P",{"data-svelte-h":!0}),f(u)!=="svelte-7thk71"&&(u.innerHTML=w)},m($,He){s($,u,He)},p:Za,d($){$&&a(u)}}}function qa(Xe){let u,w,$,He,M,Ye,_,Qt=`The Hugging Face Hub is a collection of git repositories. <a href="https://git-scm.com/" rel="nofollow">Git</a> is a widely used tool in software
development to easily version projects when working collaboratively. This guide will show you how to interact with the
repositories on the Hub, especially:`,Re,v,Et="<li>Create and delete a repository.</li> <li>Manage branches and tags.</li> <li>Rename your repository.</li> <li>Update your repository visibility.</li> <li>Manage a local copy of your repository.</li>",qe,b,Ie,T,At=`If you want to create and manage a repository on the Hub, your machine must be logged in. If you are not, please refer to
<a href="../quick-start#login">this section</a>. In the rest of this guide, we will assume that your machine is logged in.`,Le,j,Ne,J,Dt=`The first step is to know how to create and delete repositories. You can only manage repositories that you own (under
your username namespace) or from organizations in which you have write permissions.`,Fe,U,Be,k,Kt='Create an empty repository with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> and give it a name with the <code>repo_id</code> parameter. The <code>repo_id</code> is your namespace followed by the repository name: <code>username_or_org/repo_name</code>.',We,G,Ve,Z,Ot='By default, <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> creates a model repository. But you can use the <code>repo_type</code> parameter to specify another repository type. For example, if you want to create a dataset repository:',Se,C,ze,H,ea="When you create a repository, you can set your repository visibility with the <code>private</code> parameter.",Pe,x,Qe,X,ta='If you want to change the repository visibility at a later time, you can use the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.update_repo_visibility">update_repo_visibility()</a> function.',Ee,Y,Ae,R,aa='Delete a repository with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_repo">delete_repo()</a>. Make sure you want to delete a repository because this is an irreversible process!',De,q,sa="Specify the <code>repo_id</code> of the repository you want to delete:",Ke,I,Oe,L,et,N,la=`In some cases, you want to copy someone else’s repo to adapt it to your use case.
This is possible for Spaces using the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.duplicate_space">duplicate_space()</a> method. It will duplicate the whole repository.
You will still need to configure your own settings (hardware, sleep-time, storage, variables and secrets). Check out our <a href="./manage-spaces">Manage your Space</a> guide for more details.`,tt,F,at,B,st,W,na="Now that you have created your repository, you are interested in pushing changes to it and downloading files from it.",lt,V,ia=`These 2 topics deserve their own guides. Please refer to the <a href="./upload">upload</a> and the <a href="./download">download</a> guides
to learn how to use your repository.`,nt,S,it,z,ra=`Git repositories often make use of branches to store different versions of a same repository.
Tags can also be used to flag a specific state of your repository, for example, when releasing a version.
More generally, branches and tags are referred as <a href="https://git-scm.com/book/en/v2/Git-Internals-Git-References" rel="nofollow">git references</a>.`,rt,P,ot,Q,oa='You can create new branch and tags using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_branch">create_branch()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_tag">create_tag()</a>:',pt,E,ct,A,pa='You can use the <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_branch">delete_branch()</a> and <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.delete_tag">delete_tag()</a> functions in the same way to delete a branch or a tag.',gt,D,ht,K,ca='You can also list the existing git refs from a repository using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.list_repo_refs">list_repo_refs()</a>:',mt,O,ft,ee,ut,te,ga=`Repositories come with some settings that you can configure. Most of the time, you will want to do that manually in the
repo settings page in your browser. You must have write access to a repo to configure it (either own it or being part of
an organization). In this section, we will see the settings that you can also configure programmatically using <code>huggingface_hub</code>.`,yt,ae,ha='Some settings are specific to Spaces (hardware, environment variables,…). To configure those, please refer to our <a href="../guides/manage-spaces">Manage your Spaces</a> guide.',dt,se,$t,le,ma="A repository can be public or private. A private repository is only visible to you or members of the organization in which the repository is located. Change a repository to private as shown in the following:",bt,ne,wt,ie,Mt,re,fa=`You can rename your repository on the Hub using <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.move_repo">move_repo()</a>. Using this method, you can also move the repo from a user to
an organization. When doing so, there are a <a href="https://hf.co/docs/hub/repositories-settings#renaming-or-transferring-a-repo" rel="nofollow">few limitations</a>
that you should be aware of. For example, you can’t transfer your repo to another user.`,_t,oe,vt,pe,Tt,ce,ua=`All the actions described above can be done using HTTP requests. However, in some cases you might be interested in having
a local copy of your repository and interact with it using the Git commands you are familiar with.`,jt,ge,ya=`The <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> class allows you to interact with files and repositories on the Hub with functions similar to Git commands.
It is a wrapper over Git and Git-LFS methods to use the Git commands you already know and love. Before starting, please make
sure you have Git-LFS installed (see <a href="https://git-lfs.github.com/" rel="nofollow">here</a> for installation instructions).`,Jt,he,Ut,me,da='Instantiate a <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository">Repository</a> object with a path to a local repository:',kt,fe,Gt,ue,Zt,ye,$a="The <code>clone_from</code> parameter clones a repository from a Hugging Face repository ID to a local directory specified by the <code>local_dir</code> argument:",Ct,de,Ht,$e,ba="<code>clone_from</code> can also clone a repository using a URL:",xt,be,Xt,we,wa='You can combine the <code>clone_from</code> parameter with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a> to create and clone a repository:',Yt,Me,Rt,_e,Ma="You can also configure a Git username and email to a cloned repository by specifying the <code>git_user</code> and <code>git_email</code> parameters when you clone a repository. When users commit to that repository, Git will be aware of the commit author.",qt,ve,It,Te,Lt,je,_a='Branches are important for collaboration and experimentation without impacting your current files and code. Switch between branches with <a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.git_checkout">git_checkout()</a>. For example, if you want to switch from <code>branch1</code> to <code>branch2</code>:',Nt,Je,Ft,Ue,Bt,ke,va='<a href="/docs/huggingface_hub/v0.18.0.rc0/en/package_reference/repository#huggingface_hub.Repository.git_pull">git_pull()</a> allows you to update a current local branch with changes from a remote repository:',Wt,Ge,Vt,Ze,Ta="Set <code>rebase=True</code> if you want your local commits to occur after your branch is updated with the new commits from the remote:",St,Ce,zt,xe,Pt;return M=new d({props:{title:"Create and manage a repository",local:"create-and-manage-a-repository",headingTag:"h1"}}),b=new Ya({props:{warning:!0,$$slots:{default:[Ra]},$$scope:{ctx:Xe}}}),j=new d({props:{title:"Repo creation and deletion",local:"repo-creation-and-deletion",headingTag:"h2"}}),U=new d({props:{title:"Create a repository",local:"create-a-repository",headingTag:"h3"}}),G=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LW1vZGVsJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),C=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/datasets/lysandre/test-dataset&#x27;</span>`,wrap:!1}}),x=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8oJTIybHlzYW5kcmUlMkZ0ZXN0LXByaXZhdGUlMjIlMkMlMjBwcml2YXRlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(<span class="hljs-string">&quot;lysandre/test-private&quot;</span>, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),Y=new d({props:{title:"Delete a repository",local:"delete-a-repository",headingTag:"h3"}}),I=new y({props:{code:"ZGVsZXRlX3JlcG8ocmVwb19pZCUzRCUyMmx5c2FuZHJlJTJGbXktY29ycnVwdGVkLWRhdGFzZXQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>delete_repo(repo_id=<span class="hljs-string">&quot;lysandre/my-corrupted-dataset&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)',wrap:!1}}),L=new d({props:{title:"Duplicate a repository (only for Spaces)",local:"duplicate-a-repository-only-for-spaces",headingTag:"h3"}}),F=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGR1cGxpY2F0ZV9zcGFjZSUwQWR1cGxpY2F0ZV9zcGFjZSglMjJtdWx0aW1vZGFsYXJ0JTJGZHJlYW1ib290aC10cmFpbmluZyUyMiUyQyUyMHByaXZhdGUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> duplicate_space
<span class="hljs-meta">&gt;&gt;&gt; </span>duplicate_space(<span class="hljs-string">&quot;multimodalart/dreambooth-training&quot;</span>, private=<span class="hljs-literal">False</span>)
RepoUrl(<span class="hljs-string">&#x27;https://huggingface.co/spaces/nateraw/dreambooth-training&#x27;</span>,...)`,wrap:!1}}),B=new d({props:{title:"Upload and download files",local:"upload-and-download-files",headingTag:"h2"}}),S=new d({props:{title:"Branches and tags",local:"branches-and-tags",headingTag:"h2"}}),P=new d({props:{title:"Create branches and tags",local:"create-branches-and-tags",headingTag:"h3"}}),E=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9icmFuY2glMkMlMjBjcmVhdGVfdGFnJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJNYXR0aGlqcyUyRnNwZWVjaHQ1LXR0cy1kZW1vJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyc3BhY2UlMjIlMkMlMjBicmFuY2glM0QlMjJoYW5kbGUtZG9nLXNwZWFrZXIlMjIpJTBBJTBBY3JlYXRlX2JyYW5jaCglMjJiaWdjb2RlJTJGdGhlLXN0YWNrJTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUyQyUyMHJldmlzaW9uJTNEJTIydjAuMS1yZWxlYXNlJTIyJTJDJTIwdGFnJTNEJTIydjAuMS4xJTIyJTJDJTIwdGFnX21lc3NhZ2UlM0QlMjJCdW1wJTIwcmVsZWFzZSUyMHZlcnNpb24uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_branch, create_tag

<span class="hljs-comment"># Create a branch on a Space repo from \`main\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;Matthijs/speecht5-tts-demo&quot;</span>, repo_type=<span class="hljs-string">&quot;space&quot;</span>, branch=<span class="hljs-string">&quot;handle-dog-speaker&quot;</span>)

<span class="hljs-comment"># Create a tag on a Dataset repo from \`v0.1-release\` branch</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>create_branch(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>, revision=<span class="hljs-string">&quot;v0.1-release&quot;</span>, tag=<span class="hljs-string">&quot;v0.1.1&quot;</span>, tag_message=<span class="hljs-string">&quot;Bump release version.&quot;</span>)`,wrap:!1}}),D=new d({props:{title:"List all branches and tags",local:"list-all-branches-and-tags",headingTag:"h3"}}),O=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxpc3RfcmVwb19yZWZzJTBBYXBpLmxpc3RfcmVwb19yZWZzKCUyMmJpZ2NvZGUlMkZ0aGUtc3RhY2slMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> list_repo_refs
<span class="hljs-meta">&gt;&gt;&gt; </span>api.list_repo_refs(<span class="hljs-string">&quot;bigcode/the-stack&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
GitRefs(
   branches=[
         GitRefInfo(name=<span class="hljs-string">&#x27;main&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/main&#x27;</span>, target_commit=<span class="hljs-string">&#x27;18edc1591d9ce72aa82f56c4431b3c969b210ae3&#x27;</span>),
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.1.a1&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/heads/v1.1.a1&#x27;</span>, target_commit=<span class="hljs-string">&#x27;f9826b862d1567f3822d3d25649b0d6d22ace714&#x27;</span>)
   ],
   converts=[],
   tags=[
         GitRefInfo(name=<span class="hljs-string">&#x27;v1.0&#x27;</span>, ref=<span class="hljs-string">&#x27;refs/tags/v1.0&#x27;</span>, target_commit=<span class="hljs-string">&#x27;c37a8cd1e382064d8aced5e05543c5f7753834da&#x27;</span>)
   ]
)`,wrap:!1}}),ee=new d({props:{title:"Change repository settings",local:"change-repository-settings",headingTag:"h2"}}),se=new d({props:{title:"Update visibility",local:"update-visibility",headingTag:"h3"}}),ne=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwZGF0ZV9yZXBvX3Zpc2liaWxpdHklMEF1cGRhdGVfcmVwb192aXNpYmlsaXR5KHJlcG9faWQlM0RyZXBvX2lkJTJDJTIwcHJpdmF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> update_repo_visibility
<span class="hljs-meta">&gt;&gt;&gt; </span>update_repo_visibility(repo_id=repo_id, private=<span class="hljs-literal">True</span>)`,wrap:!1}}),ie=new d({props:{title:"Rename your repository",local:"rename-your-repository",headingTag:"h3"}}),oe=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG1vdmVfcmVwbyUwQW1vdmVfcmVwbyhmcm9tX2lkJTNEJTIyV2F1cGxpbiUyRmNvb2wtbW9kZWwlMjIlMkMlMjB0b19pZCUzRCUyMmh1Z2dpbmdmYWNlJTJGY29vbC1tb2RlbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> move_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>move_repo(from_id=<span class="hljs-string">&quot;Wauplin/cool-model&quot;</span>, to_id=<span class="hljs-string">&quot;huggingface/cool-model&quot;</span>)`,wrap:!1}}),pe=new d({props:{title:"Manage a local copy of your repository",local:"manage-a-local-copy-of-your-repository",headingTag:"h2"}}),he=new d({props:{title:"Use a local repository",local:"use-a-local-repository",headingTag:"h3"}}),fe=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjIlM0NwYXRoJTNFJTJGJTNDdG8lM0UlMkYlM0Nmb2xkZXIlM0UlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;&lt;path&gt;/&lt;to&gt;/&lt;folder&gt;&quot;</span>)`,wrap:!1}}),ue=new d({props:{title:"Clone",local:"clone",headingTag:"h3"}}),de=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJ3MnYyJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmZhY2Vib29rJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;w2v2&quot;</span>, clone_from=<span class="hljs-string">&quot;facebook/wav2vec2-large-960h-lv60&quot;</span>)`,wrap:!1}}),be=new y({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkobG9jYWxfZGlyJTNEJTIyaHVnZ2luZ2ZhY2UtaHViJTIyJTJDJTIwY2xvbmVfZnJvbSUzRCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZmYWNlYm9vayUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;https://huggingface.co/facebook/wav2vec2-large-960h-lv60&quot;</span>)',wrap:!1}}),Me=new y({props:{code:"cmVwb191cmwlMjAlM0QlMjBjcmVhdGVfcmVwbyhyZXBvX2lkJTNEJTIycmVwb19uYW1lJTIyKSUwQXJlcG8lMjAlM0QlMjBSZXBvc2l0b3J5KGxvY2FsX2RpciUzRCUyMnJlcG9fbG9jYWxfcGF0aCUyMiUyQyUyMGNsb25lX2Zyb20lM0RyZXBvX3VybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo_url = create_repo(repo_id=<span class="hljs-string">&quot;repo_name&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;repo_local_path&quot;</span>, clone_from=repo_url)`,wrap:!1}}),ve=new y({props:{code:"cmVwbyUyMCUzRCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIybXktZGF0YXNldCUyMiUyQyUwQSUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGJTNDZGF0YXNldF9pZCUzRSUyMiUyQyUwQSUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSUyMCUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMkMlMEElMjAlMjBnaXRfdXNlciUzRCUyMk15TmFtZSUyMiUyQyUwQSUyMCUyMGdpdF9lbWFpbCUzRCUyMm1lJTQwY29vbC5tYWlsJTIyJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(
<span class="hljs-meta">... </span>  <span class="hljs-string">&quot;my-dataset&quot;</span>,
<span class="hljs-meta">... </span>  clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>,
<span class="hljs-meta">... </span>  token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>  repo_type=<span class="hljs-string">&quot;dataset&quot;</span>,
<span class="hljs-meta">... </span>  git_user=<span class="hljs-string">&quot;MyName&quot;</span>,
<span class="hljs-meta">... </span>  git_email=<span class="hljs-string">&quot;me@cool.mail&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Te=new d({props:{title:"Branch",local:"branch",headingTag:"h3"}}),Je=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvJTIwJTNEJTIwUmVwb3NpdG9yeShsb2NhbF9kaXIlM0QlMjJodWdnaW5nZmFjZS1odWIlMjIlMkMlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRiUzQ2RhdGFzZXRfaWQlM0UlMjIlMkMlMjByZXZpc2lvbiUzRCdicmFuY2gxJyklMEFyZXBvLmdpdF9jaGVja291dCglMjJicmFuY2gyJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo = Repository(local_dir=<span class="hljs-string">&quot;huggingface-hub&quot;</span>, clone_from=<span class="hljs-string">&quot;&lt;user&gt;/&lt;dataset_id&gt;&quot;</span>, revision=<span class="hljs-string">&#x27;branch1&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_checkout(<span class="hljs-string">&quot;branch2&quot;</span>)`,wrap:!1}}),Ue=new d({props:{title:"Pull",local:"pull",headingTag:"h3"}}),Ge=new y({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMFJlcG9zaXRvcnklMEFyZXBvLmdpdF9wdWxsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> Repository
<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull()`,wrap:!1}}),Ce=new y({props:{code:"cmVwby5naXRfcHVsbChyZWJhc2UlM0RUcnVlKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>repo.git_pull(rebase=<span class="hljs-literal">True</span>)',wrap:!1}}),{c(){u=h("meta"),w=l(),$=h("p"),He=l(),i(M.$$.fragment),Ye=l(),_=h("p"),_.innerHTML=Qt,Re=l(),v=h("ul"),v.innerHTML=Et,qe=l(),i(b.$$.fragment),Ie=l(),T=h("p"),T.innerHTML=At,Le=l(),i(j.$$.fragment),Ne=l(),J=h("p"),J.textContent=Dt,Fe=l(),i(U.$$.fragment),Be=l(),k=h("p"),k.innerHTML=Kt,We=l(),i(G.$$.fragment),Ve=l(),Z=h("p"),Z.innerHTML=Ot,Se=l(),i(C.$$.fragment),ze=l(),H=h("p"),H.innerHTML=ea,Pe=l(),i(x.$$.fragment),Qe=l(),X=h("p"),X.innerHTML=ta,Ee=l(),i(Y.$$.fragment),Ae=l(),R=h("p"),R.innerHTML=aa,De=l(),q=h("p"),q.innerHTML=sa,Ke=l(),i(I.$$.fragment),Oe=l(),i(L.$$.fragment),et=l(),N=h("p"),N.innerHTML=la,tt=l(),i(F.$$.fragment),at=l(),i(B.$$.fragment),st=l(),W=h("p"),W.textContent=na,lt=l(),V=h("p"),V.innerHTML=ia,nt=l(),i(S.$$.fragment),it=l(),z=h("p"),z.innerHTML=ra,rt=l(),i(P.$$.fragment),ot=l(),Q=h("p"),Q.innerHTML=oa,pt=l(),i(E.$$.fragment),ct=l(),A=h("p"),A.innerHTML=pa,gt=l(),i(D.$$.fragment),ht=l(),K=h("p"),K.innerHTML=ca,mt=l(),i(O.$$.fragment),ft=l(),i(ee.$$.fragment),ut=l(),te=h("p"),te.innerHTML=ga,yt=l(),ae=h("p"),ae.innerHTML=ha,dt=l(),i(se.$$.fragment),$t=l(),le=h("p"),le.textContent=ma,bt=l(),i(ne.$$.fragment),wt=l(),i(ie.$$.fragment),Mt=l(),re=h("p"),re.innerHTML=fa,_t=l(),i(oe.$$.fragment),vt=l(),i(pe.$$.fragment),Tt=l(),ce=h("p"),ce.textContent=ua,jt=l(),ge=h("p"),ge.innerHTML=ya,Jt=l(),i(he.$$.fragment),Ut=l(),me=h("p"),me.innerHTML=da,kt=l(),i(fe.$$.fragment),Gt=l(),i(ue.$$.fragment),Zt=l(),ye=h("p"),ye.innerHTML=$a,Ct=l(),i(de.$$.fragment),Ht=l(),$e=h("p"),$e.innerHTML=ba,xt=l(),i(be.$$.fragment),Xt=l(),we=h("p"),we.innerHTML=wa,Yt=l(),i(Me.$$.fragment),Rt=l(),_e=h("p"),_e.innerHTML=Ma,qt=l(),i(ve.$$.fragment),It=l(),i(Te.$$.fragment),Lt=l(),je=h("p"),je.innerHTML=_a,Nt=l(),i(Je.$$.fragment),Ft=l(),i(Ue.$$.fragment),Bt=l(),ke=h("p"),ke.innerHTML=va,Wt=l(),i(Ge.$$.fragment),Vt=l(),Ze=h("p"),Ze.innerHTML=Ta,St=l(),i(Ce.$$.fragment),zt=l(),xe=h("p"),this.h()},l(e){const t=xa("svelte-u9bgzb",document.head);u=m(t,"META",{name:!0,content:!0}),t.forEach(a),w=n(e),$=m(e,"P",{}),Ja($).forEach(a),He=n(e),r(M.$$.fragment,e),Ye=n(e),_=m(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-15r6soe"&&(_.innerHTML=Qt),Re=n(e),v=m(e,"UL",{"data-svelte-h":!0}),f(v)!=="svelte-zmlzlm"&&(v.innerHTML=Et),qe=n(e),r(b.$$.fragment,e),Ie=n(e),T=m(e,"P",{"data-svelte-h":!0}),f(T)!=="svelte-ybftem"&&(T.innerHTML=At),Le=n(e),r(j.$$.fragment,e),Ne=n(e),J=m(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-1yl5xsc"&&(J.textContent=Dt),Fe=n(e),r(U.$$.fragment,e),Be=n(e),k=m(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1s27m44"&&(k.innerHTML=Kt),We=n(e),r(G.$$.fragment,e),Ve=n(e),Z=m(e,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-3imn28"&&(Z.innerHTML=Ot),Se=n(e),r(C.$$.fragment,e),ze=n(e),H=m(e,"P",{"data-svelte-h":!0}),f(H)!=="svelte-1lhlim8"&&(H.innerHTML=ea),Pe=n(e),r(x.$$.fragment,e),Qe=n(e),X=m(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-zfcz4e"&&(X.innerHTML=ta),Ee=n(e),r(Y.$$.fragment,e),Ae=n(e),R=m(e,"P",{"data-svelte-h":!0}),f(R)!=="svelte-pcuuoy"&&(R.innerHTML=aa),De=n(e),q=m(e,"P",{"data-svelte-h":!0}),f(q)!=="svelte-130g6n6"&&(q.innerHTML=sa),Ke=n(e),r(I.$$.fragment,e),Oe=n(e),r(L.$$.fragment,e),et=n(e),N=m(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-6h7j23"&&(N.innerHTML=la),tt=n(e),r(F.$$.fragment,e),at=n(e),r(B.$$.fragment,e),st=n(e),W=m(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1sdwkqa"&&(W.textContent=na),lt=n(e),V=m(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1sqatlx"&&(V.innerHTML=ia),nt=n(e),r(S.$$.fragment,e),it=n(e),z=m(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1rc0mjs"&&(z.innerHTML=ra),rt=n(e),r(P.$$.fragment,e),ot=n(e),Q=m(e,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-1f3l8bc"&&(Q.innerHTML=oa),pt=n(e),r(E.$$.fragment,e),ct=n(e),A=m(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-1qaqvk1"&&(A.innerHTML=pa),gt=n(e),r(D.$$.fragment,e),ht=n(e),K=m(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1ksz8bz"&&(K.innerHTML=ca),mt=n(e),r(O.$$.fragment,e),ft=n(e),r(ee.$$.fragment,e),ut=n(e),te=m(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-1nx84sp"&&(te.innerHTML=ga),yt=n(e),ae=m(e,"P",{"data-svelte-h":!0}),f(ae)!=="svelte-16vpsz9"&&(ae.innerHTML=ha),dt=n(e),r(se.$$.fragment,e),$t=n(e),le=m(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-17yd1o0"&&(le.textContent=ma),bt=n(e),r(ne.$$.fragment,e),wt=n(e),r(ie.$$.fragment,e),Mt=n(e),re=m(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-ylbq0t"&&(re.innerHTML=fa),_t=n(e),r(oe.$$.fragment,e),vt=n(e),r(pe.$$.fragment,e),Tt=n(e),ce=m(e,"P",{"data-svelte-h":!0}),f(ce)!=="svelte-y0ecwu"&&(ce.textContent=ua),jt=n(e),ge=m(e,"P",{"data-svelte-h":!0}),f(ge)!=="svelte-l38x"&&(ge.innerHTML=ya),Jt=n(e),r(he.$$.fragment,e),Ut=n(e),me=m(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-pup6r3"&&(me.innerHTML=da),kt=n(e),r(fe.$$.fragment,e),Gt=n(e),r(ue.$$.fragment,e),Zt=n(e),ye=m(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-1efx20p"&&(ye.innerHTML=$a),Ct=n(e),r(de.$$.fragment,e),Ht=n(e),$e=m(e,"P",{"data-svelte-h":!0}),f($e)!=="svelte-1kdxyrq"&&($e.innerHTML=ba),xt=n(e),r(be.$$.fragment,e),Xt=n(e),we=m(e,"P",{"data-svelte-h":!0}),f(we)!=="svelte-fcrlrr"&&(we.innerHTML=wa),Yt=n(e),r(Me.$$.fragment,e),Rt=n(e),_e=m(e,"P",{"data-svelte-h":!0}),f(_e)!=="svelte-2rn2fx"&&(_e.innerHTML=Ma),qt=n(e),r(ve.$$.fragment,e),It=n(e),r(Te.$$.fragment,e),Lt=n(e),je=m(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-14kg8md"&&(je.innerHTML=_a),Nt=n(e),r(Je.$$.fragment,e),Ft=n(e),r(Ue.$$.fragment,e),Bt=n(e),ke=m(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-13l0ltf"&&(ke.innerHTML=va),Wt=n(e),r(Ge.$$.fragment,e),Vt=n(e),Ze=m(e,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-199y79p"&&(Ze.innerHTML=Ta),St=n(e),r(Ce.$$.fragment,e),zt=n(e),xe=m(e,"P",{}),Ja(xe).forEach(a),this.h()},h(){Ua(u,"name","hf:doc:metadata"),Ua(u,"content",Ia)},m(e,t){Xa(document.head,u),s(e,w,t),s(e,$,t),s(e,He,t),o(M,e,t),s(e,Ye,t),s(e,_,t),s(e,Re,t),s(e,v,t),s(e,qe,t),o(b,e,t),s(e,Ie,t),s(e,T,t),s(e,Le,t),o(j,e,t),s(e,Ne,t),s(e,J,t),s(e,Fe,t),o(U,e,t),s(e,Be,t),s(e,k,t),s(e,We,t),o(G,e,t),s(e,Ve,t),s(e,Z,t),s(e,Se,t),o(C,e,t),s(e,ze,t),s(e,H,t),s(e,Pe,t),o(x,e,t),s(e,Qe,t),s(e,X,t),s(e,Ee,t),o(Y,e,t),s(e,Ae,t),s(e,R,t),s(e,De,t),s(e,q,t),s(e,Ke,t),o(I,e,t),s(e,Oe,t),o(L,e,t),s(e,et,t),s(e,N,t),s(e,tt,t),o(F,e,t),s(e,at,t),o(B,e,t),s(e,st,t),s(e,W,t),s(e,lt,t),s(e,V,t),s(e,nt,t),o(S,e,t),s(e,it,t),s(e,z,t),s(e,rt,t),o(P,e,t),s(e,ot,t),s(e,Q,t),s(e,pt,t),o(E,e,t),s(e,ct,t),s(e,A,t),s(e,gt,t),o(D,e,t),s(e,ht,t),s(e,K,t),s(e,mt,t),o(O,e,t),s(e,ft,t),o(ee,e,t),s(e,ut,t),s(e,te,t),s(e,yt,t),s(e,ae,t),s(e,dt,t),o(se,e,t),s(e,$t,t),s(e,le,t),s(e,bt,t),o(ne,e,t),s(e,wt,t),o(ie,e,t),s(e,Mt,t),s(e,re,t),s(e,_t,t),o(oe,e,t),s(e,vt,t),o(pe,e,t),s(e,Tt,t),s(e,ce,t),s(e,jt,t),s(e,ge,t),s(e,Jt,t),o(he,e,t),s(e,Ut,t),s(e,me,t),s(e,kt,t),o(fe,e,t),s(e,Gt,t),o(ue,e,t),s(e,Zt,t),s(e,ye,t),s(e,Ct,t),o(de,e,t),s(e,Ht,t),s(e,$e,t),s(e,xt,t),o(be,e,t),s(e,Xt,t),s(e,we,t),s(e,Yt,t),o(Me,e,t),s(e,Rt,t),s(e,_e,t),s(e,qt,t),o(ve,e,t),s(e,It,t),o(Te,e,t),s(e,Lt,t),s(e,je,t),s(e,Nt,t),o(Je,e,t),s(e,Ft,t),o(Ue,e,t),s(e,Bt,t),s(e,ke,t),s(e,Wt,t),o(Ge,e,t),s(e,Vt,t),s(e,Ze,t),s(e,St,t),o(Ce,e,t),s(e,zt,t),s(e,xe,t),Pt=!0},p(e,[t]){const ja={};t&2&&(ja.$$scope={dirty:t,ctx:e}),b.$set(ja)},i(e){Pt||(p(M.$$.fragment,e),p(b.$$.fragment,e),p(j.$$.fragment,e),p(U.$$.fragment,e),p(G.$$.fragment,e),p(C.$$.fragment,e),p(x.$$.fragment,e),p(Y.$$.fragment,e),p(I.$$.fragment,e),p(L.$$.fragment,e),p(F.$$.fragment,e),p(B.$$.fragment,e),p(S.$$.fragment,e),p(P.$$.fragment,e),p(E.$$.fragment,e),p(D.$$.fragment,e),p(O.$$.fragment,e),p(ee.$$.fragment,e),p(se.$$.fragment,e),p(ne.$$.fragment,e),p(ie.$$.fragment,e),p(oe.$$.fragment,e),p(pe.$$.fragment,e),p(he.$$.fragment,e),p(fe.$$.fragment,e),p(ue.$$.fragment,e),p(de.$$.fragment,e),p(be.$$.fragment,e),p(Me.$$.fragment,e),p(ve.$$.fragment,e),p(Te.$$.fragment,e),p(Je.$$.fragment,e),p(Ue.$$.fragment,e),p(Ge.$$.fragment,e),p(Ce.$$.fragment,e),Pt=!0)},o(e){c(M.$$.fragment,e),c(b.$$.fragment,e),c(j.$$.fragment,e),c(U.$$.fragment,e),c(G.$$.fragment,e),c(C.$$.fragment,e),c(x.$$.fragment,e),c(Y.$$.fragment,e),c(I.$$.fragment,e),c(L.$$.fragment,e),c(F.$$.fragment,e),c(B.$$.fragment,e),c(S.$$.fragment,e),c(P.$$.fragment,e),c(E.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(he.$$.fragment,e),c(fe.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(be.$$.fragment,e),c(Me.$$.fragment,e),c(ve.$$.fragment,e),c(Te.$$.fragment,e),c(Je.$$.fragment,e),c(Ue.$$.fragment,e),c(Ge.$$.fragment,e),c(Ce.$$.fragment,e),Pt=!1},d(e){e&&(a(w),a($),a(He),a(Ye),a(_),a(Re),a(v),a(qe),a(Ie),a(T),a(Le),a(Ne),a(J),a(Fe),a(Be),a(k),a(We),a(Ve),a(Z),a(Se),a(ze),a(H),a(Pe),a(Qe),a(X),a(Ee),a(Ae),a(R),a(De),a(q),a(Ke),a(Oe),a(et),a(N),a(tt),a(at),a(st),a(W),a(lt),a(V),a(nt),a(it),a(z),a(rt),a(ot),a(Q),a(pt),a(ct),a(A),a(gt),a(ht),a(K),a(mt),a(ft),a(ut),a(te),a(yt),a(ae),a(dt),a($t),a(le),a(bt),a(wt),a(Mt),a(re),a(_t),a(vt),a(Tt),a(ce),a(jt),a(ge),a(Jt),a(Ut),a(me),a(kt),a(Gt),a(Zt),a(ye),a(Ct),a(Ht),a($e),a(xt),a(Xt),a(we),a(Yt),a(Rt),a(_e),a(qt),a(It),a(Lt),a(je),a(Nt),a(Ft),a(Bt),a(ke),a(Wt),a(Vt),a(Ze),a(St),a(zt),a(xe)),a(u),g(M,e),g(b,e),g(j,e),g(U,e),g(G,e),g(C,e),g(x,e),g(Y,e),g(I,e),g(L,e),g(F,e),g(B,e),g(S,e),g(P,e),g(E,e),g(D,e),g(O,e),g(ee,e),g(se,e),g(ne,e),g(ie,e),g(oe,e),g(pe,e),g(he,e),g(fe,e),g(ue,e),g(de,e),g(be,e),g(Me,e),g(ve,e),g(Te,e),g(Je,e),g(Ue,e),g(Ge,e),g(Ce,e)}}}const Ia='{"title":"Create and manage a repository","local":"create-and-manage-a-repository","sections":[{"title":"Repo creation and deletion","local":"repo-creation-and-deletion","sections":[{"title":"Create a repository","local":"create-a-repository","sections":[],"depth":3},{"title":"Delete a repository","local":"delete-a-repository","sections":[],"depth":3},{"title":"Duplicate a repository (only for Spaces)","local":"duplicate-a-repository-only-for-spaces","sections":[],"depth":3}],"depth":2},{"title":"Upload and download files","local":"upload-and-download-files","sections":[],"depth":2},{"title":"Branches and tags","local":"branches-and-tags","sections":[{"title":"Create branches and tags","local":"create-branches-and-tags","sections":[],"depth":3},{"title":"List all branches and tags","local":"list-all-branches-and-tags","sections":[],"depth":3}],"depth":2},{"title":"Change repository settings","local":"change-repository-settings","sections":[{"title":"Update visibility","local":"update-visibility","sections":[],"depth":3},{"title":"Rename your repository","local":"rename-your-repository","sections":[],"depth":3}],"depth":2},{"title":"Manage a local copy of your repository","local":"manage-a-local-copy-of-your-repository","sections":[{"title":"Use a local repository","local":"use-a-local-repository","sections":[],"depth":3},{"title":"Clone","local":"clone","sections":[],"depth":3},{"title":"Branch","local":"branch","sections":[],"depth":3},{"title":"Pull","local":"pull","sections":[],"depth":3}],"depth":2}],"depth":1}';function La(Xe){return Ga(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends Ca{constructor(u){super(),Ha(this,u,La,qa,ka,{})}}export{Sa as component};
