import{s as qs,n as Ns,o as Cs}from"../chunks/scheduler.6062bdaf.js";import{S as zs,i as Vs,g as p,s as l,r as m,A as Qs,h as i,f as e,c as n,j as x,u as r,x as o,k as xs,y as c,a,v as h,d,t as g,w as y}from"../chunks/index.4bca734e.js";import{C as V}from"../chunks/CodeBlock.fa01571c.js";import{H as js}from"../chunks/Heading.723dceba.js";function Ls(ks){let u,A,Q,P,M,D,J,Is='In addition to the <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, the <code>huggingface_hub</code> library provides <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>, a pythonic <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> file interface to the Hugging Face Hub. The <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> builds of top of the <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> and offers typical filesystem style operations like <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, and <code>put_file</code>.',K,w,O,j,ss,T,Gs="The optional <code>revision</code> argument can be passed to run an operation from a specific commit such as a branch, tag name, or a commit hash.",ts,b,_s="Unlike Python’s built-in <code>open</code>, <code>fsspec</code>’s <code>open</code> defaults to binary mode, <code>&quot;rb&quot;</code>. This means you must explicitly set mode as <code>&quot;r&quot;</code> for reading and <code>&quot;w&quot;</code> for writing in text mode. Appending to a file (modes <code>&quot;a&quot;</code> and <code>&quot;ab&quot;</code>) is not supported yet.",es,U,as,Z,Rs='The <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> can be used with any library that integrates <code>fsspec</code>, provided the URL follows the scheme:',ls,k,ns,I,vs="The <code>repo_type_prefix</code> is <code>datasets/</code> for datasets, <code>spaces/</code> for spaces, and models don’t need a prefix in the URL.",ps,G,Xs='Some interesting integrations where <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> simplifies interacting with the Hub are listed below:',is,q,_,N,Bs='Reading/writing a <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame from/to a Hub repository:',Ts,R,os,v,Ss='The same workflow can also be used for <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> and <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',cs,f,X,C,$s='Querying (remote) Hub files with <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',bs,B,Us,S,z,Fs='Using the Hub as an array store with <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Zs,$,ms,F,rs,W,Ws='In many cases, you must be logged in with a Hugging Face account to interact with the Hub. Refer to the <a href="../quick-start#authentication">Authentication</a> section of the documentation to learn more about authentication methods on the Hub.',hs,H,Hs='It is also possible to login programmatically by passing your <code>token</code> as an argument to <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>:',ds,Y,gs,E,Ys="If you login this way, be careful not to accidentally leak the token when sharing your source code!",ys,L,us;return M=new js({props:{title:"Interact with the Hub through the Filesystem API",local:"interact-with-the-hub-through-the-filesystem-api",headingTag:"h1"}}),w=new js({props:{title:"Usage",local:"usage",headingTag:"h2"}}),j=new V({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwYWxsJTIwZmlsZXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMExpc3QlMjBhbGwlMjAlMjIuY3N2JTIyJTIwZmlsZXMlMjBpbiUyMGElMjByZXBvJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiouY3N2JTIyKSUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwZmlsZSUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGYlM0ElMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhJTIwJTNEJTIwZi5yZWFkbGluZXMoKSUwQSUwQSUyMyUyMFJlYWQlMjB0aGUlMjBjb250ZW50JTIwb2YlMjBhJTIwcmVtb3RlJTIwZmlsZSUyMGFzJTIwYSUyMHN0cmluZyUwQXRyYWluX2RhdGElMjAlM0QlMjBmcy5yZWFkX3RleHQoJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ0cmFpbi5jc3YlMjIlMkMlMjByZXZpc2lvbiUzRCUyMmRldiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGElMjByZW1vdGUlMjBmaWxlJTBBd2l0aCUyMGZzLm9wZW4oJTIyZGF0YXNldHMlMkZteS11c2VybmFtZSUyRm15LWRhdGFzZXQtcmVwbyUyRmRhdGElMkZ2YWxpZGF0aW9uLmNzdiUyMiUyQyUyMCUyMnclMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJ0ZXh0JTJDbGFiZWwlMjIpJTBBJTIwJTIwJTIwJTIwZi53cml0ZSglMjJGYW50YXN0aWMlMjBtb3ZpZSElMkNnb29kJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all files in a directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all &quot;.csv&quot; files in a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read the content of a remote file as a string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),U=new js({props:{title:"Integrations",local:"integrations",headingTag:"h2"}}),k=new V({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),R=new V({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUyMGludG8lMjBhJTIwZGF0YWZyYW1lJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0cmFpbi5jc3YlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwZGF0YWZyYW1lJTIwdG8lMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote CSV file into a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a dataframe to a remote CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),B=new V({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBRdWVyeSUyMGElMjByZW1vdGUlMjBmaWxlJTIwYW5kJTIwZ2V0JTIwdGhlJTIwcmVzdWx0JTIwYmFjayUyMGFzJTIwYSUyMGRhdGFmcmFtZSUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Query a remote file and get the result back as a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),$=new V({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGFuJTIwYXJyYXklMjB0byUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnclMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZm9vJTIwJTNEJTIwcm9vdC5jcmVhdGVfZ3JvdXAoJTIyZW1iZWRkaW5ncyUyMiklMEElMjAlMjAlMjBmb29iYXIlMjAlM0QlMjBmb28uemVyb3MoJ2V4cGVyaW1lbnRfMCclMkMlMjBzaGFwZSUzRCg1MDAwMCUyQyUyMDEwMDApJTJDJTIwY2h1bmtzJTNEKDEwMDAwJTJDJTIwMTAwMCklMkMlMjBkdHlwZSUzRCdmNCcpJTBBJTIwJTIwJTIwZm9vYmFyJTVCJTNBJTVEJTIwJTNEJTIwZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFJlYWQlMjBhbiUyMGFycmF5JTIwZnJvbSUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write an array to a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read an array from a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),F=new js({props:{title:"Authentication",local:"authentication",headingTag:"h2"}}),Y=new V({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),{c(){u=p("meta"),A=l(),Q=p("p"),P=l(),m(M.$$.fragment),D=l(),J=p("p"),J.innerHTML=Is,K=l(),m(w.$$.fragment),O=l(),m(j.$$.fragment),ss=l(),T=p("p"),T.innerHTML=Gs,ts=l(),b=p("p"),b.innerHTML=_s,es=l(),m(U.$$.fragment),as=l(),Z=p("p"),Z.innerHTML=Rs,ls=l(),m(k.$$.fragment),ns=l(),I=p("p"),I.innerHTML=vs,ps=l(),G=p("p"),G.innerHTML=Xs,is=l(),q=p("ul"),_=p("li"),N=p("p"),N.innerHTML=Bs,Ts=l(),m(R.$$.fragment),os=l(),v=p("p"),v.innerHTML=Ss,cs=l(),f=p("ul"),X=p("li"),C=p("p"),C.innerHTML=$s,bs=l(),m(B.$$.fragment),Us=l(),S=p("li"),z=p("p"),z.innerHTML=Fs,Zs=l(),m($.$$.fragment),ms=l(),m(F.$$.fragment),rs=l(),W=p("p"),W.innerHTML=Ws,hs=l(),H=p("p"),H.innerHTML=Hs,ds=l(),m(Y.$$.fragment),gs=l(),E=p("p"),E.textContent=Ys,ys=l(),L=p("p"),this.h()},l(s){const t=Qs("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(e),A=n(s),Q=i(s,"P",{}),x(Q).forEach(e),P=n(s),r(M.$$.fragment,s),D=n(s),J=i(s,"P",{"data-svelte-h":!0}),o(J)!=="svelte-17svles"&&(J.innerHTML=Is),K=n(s),r(w.$$.fragment,s),O=n(s),r(j.$$.fragment,s),ss=n(s),T=i(s,"P",{"data-svelte-h":!0}),o(T)!=="svelte-fkc5g9"&&(T.innerHTML=Gs),ts=n(s),b=i(s,"P",{"data-svelte-h":!0}),o(b)!=="svelte-2xrojz"&&(b.innerHTML=_s),es=n(s),r(U.$$.fragment,s),as=n(s),Z=i(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-185japa"&&(Z.innerHTML=Rs),ls=n(s),r(k.$$.fragment,s),ns=n(s),I=i(s,"P",{"data-svelte-h":!0}),o(I)!=="svelte-1x0g0bv"&&(I.innerHTML=vs),ps=n(s),G=i(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-hvsa8e"&&(G.innerHTML=Xs),is=n(s),q=i(s,"UL",{});var Es=x(q);_=i(Es,"LI",{});var fs=x(_);N=i(fs,"P",{"data-svelte-h":!0}),o(N)!=="svelte-8bmxp4"&&(N.innerHTML=Bs),Ts=n(fs),r(R.$$.fragment,fs),fs.forEach(e),Es.forEach(e),os=n(s),v=i(s,"P",{"data-svelte-h":!0}),o(v)!=="svelte-evo4u9"&&(v.innerHTML=Ss),cs=n(s),f=i(s,"UL",{});var Ms=x(f);X=i(Ms,"LI",{});var Js=x(X);C=i(Js,"P",{"data-svelte-h":!0}),o(C)!=="svelte-14x5nlf"&&(C.innerHTML=$s),bs=n(Js),r(B.$$.fragment,Js),Js.forEach(e),Us=n(Ms),S=i(Ms,"LI",{});var ws=x(S);z=i(ws,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1abwu1e"&&(z.innerHTML=Fs),Zs=n(ws),r($.$$.fragment,ws),ws.forEach(e),Ms.forEach(e),ms=n(s),r(F.$$.fragment,s),rs=n(s),W=i(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-kwqcxw"&&(W.innerHTML=Ws),hs=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1ef15rs"&&(H.innerHTML=Hs),ds=n(s),r(Y.$$.fragment,s),gs=n(s),E=i(s,"P",{"data-svelte-h":!0}),o(E)!=="svelte-y88ov3"&&(E.textContent=Ys),ys=n(s),L=i(s,"P",{}),x(L).forEach(e),this.h()},h(){xs(u,"name","hf:doc:metadata"),xs(u,"content",As)},m(s,t){c(document.head,u),a(s,A,t),a(s,Q,t),a(s,P,t),h(M,s,t),a(s,D,t),a(s,J,t),a(s,K,t),h(w,s,t),a(s,O,t),h(j,s,t),a(s,ss,t),a(s,T,t),a(s,ts,t),a(s,b,t),a(s,es,t),h(U,s,t),a(s,as,t),a(s,Z,t),a(s,ls,t),h(k,s,t),a(s,ns,t),a(s,I,t),a(s,ps,t),a(s,G,t),a(s,is,t),a(s,q,t),c(q,_),c(_,N),c(_,Ts),h(R,_,null),a(s,os,t),a(s,v,t),a(s,cs,t),a(s,f,t),c(f,X),c(X,C),c(X,bs),h(B,X,null),c(f,Us),c(f,S),c(S,z),c(S,Zs),h($,S,null),a(s,ms,t),h(F,s,t),a(s,rs,t),a(s,W,t),a(s,hs,t),a(s,H,t),a(s,ds,t),h(Y,s,t),a(s,gs,t),a(s,E,t),a(s,ys,t),a(s,L,t),us=!0},p:Ns,i(s){us||(d(M.$$.fragment,s),d(w.$$.fragment,s),d(j.$$.fragment,s),d(U.$$.fragment,s),d(k.$$.fragment,s),d(R.$$.fragment,s),d(B.$$.fragment,s),d($.$$.fragment,s),d(F.$$.fragment,s),d(Y.$$.fragment,s),us=!0)},o(s){g(M.$$.fragment,s),g(w.$$.fragment,s),g(j.$$.fragment,s),g(U.$$.fragment,s),g(k.$$.fragment,s),g(R.$$.fragment,s),g(B.$$.fragment,s),g($.$$.fragment,s),g(F.$$.fragment,s),g(Y.$$.fragment,s),us=!1},d(s){s&&(e(A),e(Q),e(P),e(D),e(J),e(K),e(O),e(ss),e(T),e(ts),e(b),e(es),e(as),e(Z),e(ls),e(ns),e(I),e(ps),e(G),e(is),e(q),e(os),e(v),e(cs),e(f),e(ms),e(rs),e(W),e(hs),e(H),e(ds),e(gs),e(E),e(ys),e(L)),e(u),y(M,s),y(w,s),y(j,s),y(U,s),y(k,s),y(R),y(B),y($),y(F,s),y(Y,s)}}}const As='{"title":"Interact with the Hub through the Filesystem API","local":"interact-with-the-hub-through-the-filesystem-api","sections":[{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Integrations","local":"integrations","sections":[],"depth":2},{"title":"Authentication","local":"authentication","sections":[],"depth":2}],"depth":1}';function Ps(ks){return Cs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends zs{constructor(u){super(),Vs(this,u,Ps,Ls,qs,{})}}export{tt as component};
