import{s as qn,o as Wn,n as oe}from"../chunks/scheduler.6062bdaf.js";import{S as zn,i as Xn,g as r,s,r as d,A as On,h as o,f as p,c as a,j as w,u as g,x as f,k as H,y as t,a as v,v as h,d as u,t as b,w as $}from"../chunks/index.4bca734e.js";import{T as Ce}from"../chunks/Tip.b9ac1f03.js";import{D as S}from"../chunks/Docstring.81ba5e3c.js";import{C as Qn}from"../chunks/CodeBlock.fa01571c.js";import{E as Yn}from"../chunks/ExampleCodeBlock.30e7542f.js";import{H as Rn,E as Bn}from"../chunks/EditOnGithub.74ab2baa.js";function Kn(F){let n,_=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> provides fsspec compatibility, which is useful for libraries that require it (e.g., reading
Hugging Face datasets directly with <code>pandas</code>). However, it introduces additional overhead due to this compatibility
layer. For better performance and reliability, it’s recommended to use <code>HfApi</code> methods when possible.`;return{c(){n=r("p"),n.innerHTML=_},l(i){n=o(i,"P",{"data-svelte-h":!0}),f(n)!=="svelte-11nznpk"&&(n.innerHTML=_)},m(i,y){v(i,n,y)},p:oe,d(i){i&&p(n)}}}function es(F){let n,_="Usage:",i,y,C;return y=new Qn({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwZmlsZXMlMEFmcy5nbG9iKCUyMm15LXVzZXJuYW1lJTJGbXktbW9kZWwlMkYqLmJpbiUyMiklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldCUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMFJlYWQlMkZ3cml0ZSUyMGZpbGVzJTBBd2l0aCUyMGZzLm9wZW4oJTIybXktdXNlcm5hbWUlMkZteS1tb2RlbCUyRnB5dG9yY2hfbW9kZWwuYmluJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGRhdGElMjAlM0QlMjBmLnJlYWQoKSUwQXdpdGglMjBmcy5vcGVuKCUyMm15LXVzZXJuYW1lJTJGbXktbW9kZWwlMkZweXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMCUyMndiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoZGF0YSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;my-username/my-model/*.bin&quot;</span>)
[<span class="hljs-string">&#x27;my-username/my-model/pytorch_model.bin&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset/.gitattributes&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset/README.md&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset/data.json&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read/write files</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;my-username/my-model/pytorch_model.bin&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    data = f.read()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;my-username/my-model/pytorch_model.bin&quot;</span>, <span class="hljs-string">&quot;wb&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(data)`,wrap:!1}}),{c(){n=r("p"),n.textContent=_,i=s(),d(y.$$.fragment)},l(x){n=o(x,"P",{"data-svelte-h":!0}),f(n)!=="svelte-5wyjqd"&&(n.textContent=_),i=a(x),g(y.$$.fragment,x)},m(x,D){v(x,n,D),v(x,i,D),h(y,x,D),C=!0},p:oe,i(x){C||(u(y.$$.fragment,x),C=!0)},o(x){b(y.$$.fragment,x),C=!1},d(x){x&&(p(n),p(i)),$(y,x)}}}function ts(F){let n,_="Note: When possible, use <code>HfApi.upload_file()</code> for better performance.";return{c(){n=r("p"),n.innerHTML=_},l(i){n=o(i,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1br2jzn"&&(n.innerHTML=_)},m(i,y){v(i,n,y)},p:oe,d(i){i&&p(n)}}}function ns(F){let n,_="Note: When possible, use <code>HfApi.file_exists()</code> for better performance.";return{c(){n=r("p"),n.innerHTML=_},l(i){n=o(i,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1ficor6"&&(n.innerHTML=_)},m(i,y){v(i,n,y)},p:oe,d(i){i&&p(n)}}}function ss(F){let n,_="Note: When possible, use <code>HfApi.hf_hub_download()</code> for better performance.";return{c(){n=r("p"),n.innerHTML=_},l(i){n=o(i,"P",{"data-svelte-h":!0}),f(n)!=="svelte-17e6slu"&&(n.innerHTML=_)},m(i,y){v(i,n,y)},p:oe,d(i){i&&p(n)}}}function as(F){let n,_="Note: When possible, use <code>HfApi.get_paths_info()</code> or <code>HfApi.repo_info()</code>  for better performance.";return{c(){n=r("p"),n.innerHTML=_},l(i){n=o(i,"P",{"data-svelte-h":!0}),f(n)!=="svelte-1clxglf"&&(n.innerHTML=_)},m(i,y){v(i,n,y)},p:oe,d(i){i&&p(n)}}}function rs(F){let n,_="Note: When possible, use <code>HfApi.list_repo_tree()</code> for better performance.";return{c(){n=r("p"),n.innerHTML=_},l(i){n=o(i,"P",{"data-svelte-h":!0}),f(n)!=="svelte-se5rid"&&(n.innerHTML=_)},m(i,y){v(i,n,y)},p:oe,d(i){i&&p(n)}}}function os(F){let n,_="Note: When possible, use <code>HfApi.delete_file()</code> for better performance.";return{c(){n=r("p"),n.innerHTML=_},l(i){n=o(i,"P",{"data-svelte-h":!0}),f(n)!=="svelte-10wheh"&&(n.innerHTML=_)},m(i,y){v(i,n,y)},p:oe,d(i){i&&p(n)}}}function is(F){let n,_,i,y,C,x,D,hn='The <code>HfFileSystem</code> class provides a pythonic file interface to the Hugging Face Hub based on <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow"><code>fsspec</code></a>.',ct,ie,pt,le,un='<code>HfFileSystem</code> is based on <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec</a>, so it is compatible with most of the APIs that it offers. For more details, check out <a href="../guides/hf_file_system">our guide</a> and fsspec’s <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem" rel="nofollow">API Reference</a>.',ft,l,ce,bt,Te,bn="Access a remote Hugging Face Hub repository as if were a local file system.",$t,X,_t,O,yt,Me,pe,vt,j,fe,xt,Le,$n="Copy a file within or between repositories.",wt,Q,Ht,T,me,Ft,ke,_n="Check if a file exists.",St,De,yn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.exists" rel="nofollow">fsspec documentation</a>.',Ct,Y,Tt,I,de,Mt,Pe,vn="List all files below path.",Lt,Ue,xn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.find" rel="nofollow">fsspec documentation</a>.',kt,E,ge,Dt,je,wn="Copy single remote file to local.",Pt,B,Ut,A,he,jt,Ie,Hn="Find files by glob-matching.",It,Ee,Fn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.glob" rel="nofollow">fsspec documentation</a>.',Et,M,ue,At,Ae,Sn="Get information about a file or directory.",Gt,Ge,Cn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.info" rel="nofollow">fsspec documentation</a>.',Nt,K,Vt,G,be,Jt,Ne,Tn="Clear the cache for a given path.",Zt,Ve,Mn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.invalidate_cache" rel="nofollow">fsspec documentation</a>.',Rt,N,$e,qt,Je,Ln="Check if a path is a directory.",Wt,Ze,kn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.isdir" rel="nofollow">fsspec documentation</a>.',zt,V,_e,Xt,Re,Dn="Check if a path is a file.",Ot,qe,Pn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.isfile" rel="nofollow">fsspec documentation</a>.',Qt,L,ye,Yt,We,Un="List the contents of a directory.",Bt,ze,jn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.ls" rel="nofollow">fsspec documentation</a>.',Kt,ee,en,J,ve,tn,Xe,In="Get the last modified time of a file.",nn,Oe,En='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.modified" rel="nofollow">fsspec documentation</a>.',sn,te,xe,an,Qe,An="Resolve a Hugging Face file system path into its components.",rn,k,we,on,Ye,Gn="Delete files from a repository.",ln,Be,Nn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.rm" rel="nofollow">fsspec documentation</a>.',cn,ne,pn,se,He,fn,Ke,Vn="Get the HTTP URL of the given path.",mn,Z,Fe,dn,et,Jn="Return all files below the given path.",gn,tt,Zn='For more details, refer to <a href="https://filesystem-spec.readthedocs.io/en/latest/api.html#fsspec.spec.AbstractFileSystem.walk" rel="nofollow">fsspec documentation</a>.',mt,Se,dt,it,gt;return C=new Rn({props:{title:"Filesystem API",local:"filesystem-api",headingTag:"h1"}}),ie=new Rn({props:{title:"HfFileSystem",local:"huggingface_hub.HfFileSystem",headingTag:"h2"}}),ce=new S({props:{name:"class huggingface_hub.HfFileSystem",anchor:"huggingface_hub.HfFileSystem",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
A valid user access token (string). Defaults to the locally saved
token, which is the recommended method for authentication (see
<a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">https://huggingface.co/docs/huggingface_hub/quick-start#authentication</a>).
To disable authentication, pass <code>False</code>.`,name:"token"},{anchor:"huggingface_hub.HfFileSystem.endpoint",description:`<strong>endpoint</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Endpoint of the Hub. Defaults to <a href="https://huggingface.co" rel="nofollow">https://huggingface.co</a>.`,name:"endpoint"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L58"}}),X=new Ce({props:{warning:!0,$$slots:{default:[Kn]},$$scope:{ctx:F}}}),O=new Yn({props:{anchor:"huggingface_hub.HfFileSystem.example",$$slots:{default:[es]},$$scope:{ctx:F}}}),pe=new S({props:{name:"__init__",anchor:"huggingface_hub.HfFileSystem.__init__",parameters:[{name:"*args",val:""},{name:"endpoint",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"**storage_options",val:""}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L102"}}),fe=new S({props:{name:"cp_file",anchor:"huggingface_hub.HfFileSystem.cp_file",parameters:[{name:"path1",val:": str"},{name:"path2",val:": str"},{name:"revision",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.cp_file.path1",description:`<strong>path1</strong> (<code>str</code>) &#x2014;
Source path to copy from.`,name:"path1"},{anchor:"huggingface_hub.HfFileSystem.cp_file.path2",description:`<strong>path2</strong> (<code>str</code>) &#x2014;
Destination path to copy to.`,name:"path2"},{anchor:"huggingface_hub.HfFileSystem.cp_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to copy from.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L584"}}),Q=new Ce({props:{warning:!0,$$slots:{default:[ts]},$$scope:{ctx:F}}}),me=new S({props:{name:"exists",anchor:"huggingface_hub.HfFileSystem.exists",parameters:[{name:"path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.exists.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to check.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L759",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if file exists, False otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),Y=new Ce({props:{warning:!0,$$slots:{default:[ns]},$$scope:{ctx:F}}}),de=new S({props:{name:"find",anchor:"huggingface_hub.HfFileSystem.find",parameters:[{name:"path",val:": str"},{name:"maxdepth",val:": typing.Optional[int] = None"},{name:"withdirs",val:": bool = False"},{name:"detail",val:": bool = False"},{name:"refresh",val:": bool = False"},{name:"revision",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.find.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Root path to list files from.`,name:"path"},{anchor:"huggingface_hub.HfFileSystem.find.maxdepth",description:`<strong>maxdepth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum depth to descend into subdirectories.`,name:"maxdepth"},{anchor:"huggingface_hub.HfFileSystem.find.withdirs",description:`<strong>withdirs</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Include directory paths in the output. Defaults to False.`,name:"withdirs"},{anchor:"huggingface_hub.HfFileSystem.find.detail",description:`<strong>detail</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, returns a dict mapping paths to file information. Defaults to False.`,name:"detail"},{anchor:"huggingface_hub.HfFileSystem.find.refresh",description:`<strong>refresh</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, bypass the cache and fetch the latest data. Defaults to False.`,name:"refresh"},{anchor:"huggingface_hub.HfFileSystem.find.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to list from.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L523",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of paths or dict of file information.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[List[str], Dict[str, Dict[str, Any]]]</code></p>
`}}),ge=new S({props:{name:"get_file",anchor:"huggingface_hub.HfFileSystem.get_file",parameters:[{name:"rpath",val:""},{name:"lpath",val:""},{name:"callback",val:" = <fsspec.callbacks.NoOpCallback object at 0x7ffa431ff8e0>"},{name:"outfile",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.get_file.rpath",description:`<strong>rpath</strong> (<code>str</code>) &#x2014;
Remote path to download from.`,name:"rpath"},{anchor:"huggingface_hub.HfFileSystem.get_file.lpath",description:`<strong>lpath</strong> (<code>str</code>) &#x2014;
Local path to download to.`,name:"lpath"},{anchor:"huggingface_hub.HfFileSystem.get_file.callback",description:`<strong>callback</strong> (<code>Callback</code>, <em>optional</em>) &#x2014;
Optional callback to track download progress. Defaults to no callback.`,name:"callback"},{anchor:"huggingface_hub.HfFileSystem.get_file.outfile",description:`<strong>outfile</strong> (<code>IO</code>, <em>optional</em>) &#x2014;
Optional file-like object to write to. If provided, <code>lpath</code> is ignored.`,name:"outfile"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L846"}}),B=new Ce({props:{warning:!0,$$slots:{default:[ss]},$$scope:{ctx:F}}}),he=new S({props:{name:"glob",anchor:"huggingface_hub.HfFileSystem.glob",parameters:[{name:"path",val:": str"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.glob.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path pattern to match.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L505",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of paths matching the pattern.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),ue=new S({props:{name:"info",anchor:"huggingface_hub.HfFileSystem.info",parameters:[{name:"path",val:": str"},{name:"refresh",val:": bool = False"},{name:"revision",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.info.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to get info for.`,name:"path"},{anchor:"huggingface_hub.HfFileSystem.info.refresh",description:`<strong>refresh</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, bypass the cache and fetch the latest data. Defaults to False.`,name:"refresh"},{anchor:"huggingface_hub.HfFileSystem.info.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to get info from.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L659",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary containing file information (type, size, commit info, etc.).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),K=new Ce({props:{warning:!0,$$slots:{default:[as]},$$scope:{ctx:F}}}),be=new S({props:{name:"invalidate_cache",anchor:"huggingface_hub.HfFileSystem.invalidate_cache",parameters:[{name:"path",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.invalidate_cache.path",description:`<strong>path</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to clear from cache. If not provided, clear the entire cache.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L234"}}),$e=new S({props:{name:"isdir",anchor:"huggingface_hub.HfFileSystem.isdir",parameters:[{name:"path",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.isdir.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to check.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L787",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if path is a directory, False otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),_e=new S({props:{name:"isfile",anchor:"huggingface_hub.HfFileSystem.isfile",parameters:[{name:"path",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.isfile.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to check.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L805",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>True if path is a file, False otherwise.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code></p>
`}}),ye=new S({props:{name:"ls",anchor:"huggingface_hub.HfFileSystem.ls",parameters:[{name:"path",val:": str"},{name:"detail",val:": bool = True"},{name:"refresh",val:": bool = False"},{name:"revision",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.ls.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to the directory.`,name:"path"},{anchor:"huggingface_hub.HfFileSystem.ls.detail",description:`<strong>detail</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, returns a list of dictionaries containing file information. If False,
returns a list of file paths. Defaults to True.`,name:"detail"},{anchor:"huggingface_hub.HfFileSystem.ls.refresh",description:`<strong>refresh</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, bypass the cache and fetch the latest data. Defaults to False.`,name:"refresh"},{anchor:"huggingface_hub.HfFileSystem.ls.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to list from.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L339",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of file paths (if detail=False) or list of file information
dictionaries (if detail=True).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Union[str, Dict[str, Any]]]</code></p>
`}}),ee=new Ce({props:{warning:!0,$$slots:{default:[rs]},$$scope:{ctx:F}}}),ve=new S({props:{name:"modified",anchor:"huggingface_hub.HfFileSystem.modified",parameters:[{name:"path",val:": str"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.modified.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to the file.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L643",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Last commit date of the file.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>datetime</code></p>
`}}),xe=new S({props:{name:"resolve_path",anchor:"huggingface_hub.HfFileSystem.resolve_path",parameters:[{name:"path",val:": str"},{name:"revision",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.resolve_path.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to resolve.`,name:"path"},{anchor:"huggingface_hub.HfFileSystem.resolve_path.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The revision of the repo to resolve. Defaults to the revision specified in the path.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L139",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Resolved path information containing <code>repo_type</code>, <code>repo_id</code>, <code>revision</code> and <code>path_in_repo</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>HfFileSystemResolvedPath</code></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><code>ValueError</code> —
If path contains conflicting revision information.</li>
<li><code>NotImplementedError</code> —
If trying to list repositories.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ValueError</code> or <code>NotImplementedError</code></p>
`}}),we=new S({props:{name:"rm",anchor:"huggingface_hub.HfFileSystem.rm",parameters:[{name:"path",val:": str"},{name:"recursive",val:": bool = False"},{name:"maxdepth",val:": typing.Optional[int] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.rm.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to delete.`,name:"path"},{anchor:"huggingface_hub.HfFileSystem.rm.recursive",description:`<strong>recursive</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If True, delete directory and all its contents. Defaults to False.`,name:"recursive"},{anchor:"huggingface_hub.HfFileSystem.rm.maxdepth",description:`<strong>maxdepth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Maximum number of subdirectories to visit when deleting recursively.`,name:"maxdepth"},{anchor:"huggingface_hub.HfFileSystem.rm.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The git revision to delete from.`,name:"revision"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L290"}}),ne=new Ce({props:{warning:!0,$$slots:{default:[os]},$$scope:{ctx:F}}}),He=new S({props:{name:"url",anchor:"huggingface_hub.HfFileSystem.url",parameters:[{name:"path",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.url.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Path to get URL for.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L823",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>HTTP URL to access the file or directory on the Hub.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Fe=new S({props:{name:"walk",anchor:"huggingface_hub.HfFileSystem.walk",parameters:[{name:"path",val:": str"},{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"huggingface_hub.HfFileSystem.walk.path",description:`<strong>path</strong> (<code>str</code>) &#x2014;
Root path to list files from.`,name:"path"}],source:"https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/hf_file_system.py#L487",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An iterator of (path, list of directory names, list of file names) tuples.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Iterator[Tuple[str, List[str], List[str]]]</code></p>
`}}),Se=new Bn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/package_reference/hf_file_system.md"}}),{c(){n=r("meta"),_=s(),i=r("p"),y=s(),d(C.$$.fragment),x=s(),D=r("p"),D.innerHTML=hn,ct=s(),d(ie.$$.fragment),pt=s(),le=r("p"),le.innerHTML=un,ft=s(),l=r("div"),d(ce.$$.fragment),bt=s(),Te=r("p"),Te.textContent=bn,$t=s(),d(X.$$.fragment),_t=s(),d(O.$$.fragment),yt=s(),Me=r("div"),d(pe.$$.fragment),vt=s(),j=r("div"),d(fe.$$.fragment),xt=s(),Le=r("p"),Le.textContent=$n,wt=s(),d(Q.$$.fragment),Ht=s(),T=r("div"),d(me.$$.fragment),Ft=s(),ke=r("p"),ke.textContent=_n,St=s(),De=r("p"),De.innerHTML=yn,Ct=s(),d(Y.$$.fragment),Tt=s(),I=r("div"),d(de.$$.fragment),Mt=s(),Pe=r("p"),Pe.textContent=vn,Lt=s(),Ue=r("p"),Ue.innerHTML=xn,kt=s(),E=r("div"),d(ge.$$.fragment),Dt=s(),je=r("p"),je.textContent=wn,Pt=s(),d(B.$$.fragment),Ut=s(),A=r("div"),d(he.$$.fragment),jt=s(),Ie=r("p"),Ie.textContent=Hn,It=s(),Ee=r("p"),Ee.innerHTML=Fn,Et=s(),M=r("div"),d(ue.$$.fragment),At=s(),Ae=r("p"),Ae.textContent=Sn,Gt=s(),Ge=r("p"),Ge.innerHTML=Cn,Nt=s(),d(K.$$.fragment),Vt=s(),G=r("div"),d(be.$$.fragment),Jt=s(),Ne=r("p"),Ne.textContent=Tn,Zt=s(),Ve=r("p"),Ve.innerHTML=Mn,Rt=s(),N=r("div"),d($e.$$.fragment),qt=s(),Je=r("p"),Je.textContent=Ln,Wt=s(),Ze=r("p"),Ze.innerHTML=kn,zt=s(),V=r("div"),d(_e.$$.fragment),Xt=s(),Re=r("p"),Re.textContent=Dn,Ot=s(),qe=r("p"),qe.innerHTML=Pn,Qt=s(),L=r("div"),d(ye.$$.fragment),Yt=s(),We=r("p"),We.textContent=Un,Bt=s(),ze=r("p"),ze.innerHTML=jn,Kt=s(),d(ee.$$.fragment),en=s(),J=r("div"),d(ve.$$.fragment),tn=s(),Xe=r("p"),Xe.textContent=In,nn=s(),Oe=r("p"),Oe.innerHTML=En,sn=s(),te=r("div"),d(xe.$$.fragment),an=s(),Qe=r("p"),Qe.textContent=An,rn=s(),k=r("div"),d(we.$$.fragment),on=s(),Ye=r("p"),Ye.textContent=Gn,ln=s(),Be=r("p"),Be.innerHTML=Nn,cn=s(),d(ne.$$.fragment),pn=s(),se=r("div"),d(He.$$.fragment),fn=s(),Ke=r("p"),Ke.textContent=Vn,mn=s(),Z=r("div"),d(Fe.$$.fragment),dn=s(),et=r("p"),et.textContent=Jn,gn=s(),tt=r("p"),tt.innerHTML=Zn,mt=s(),d(Se.$$.fragment),dt=s(),it=r("p"),this.h()},l(e){const m=On("svelte-u9bgzb",document.head);n=o(m,"META",{name:!0,content:!0}),m.forEach(p),_=a(e),i=o(e,"P",{}),w(i).forEach(p),y=a(e),g(C.$$.fragment,e),x=a(e),D=o(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-em1lpf"&&(D.innerHTML=hn),ct=a(e),g(ie.$$.fragment,e),pt=a(e),le=o(e,"P",{"data-svelte-h":!0}),f(le)!=="svelte-1c4o3of"&&(le.innerHTML=un),ft=a(e),l=o(e,"DIV",{class:!0});var c=w(l);g(ce.$$.fragment,c),bt=a(c),Te=o(c,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-xq4u8v"&&(Te.textContent=bn),$t=a(c),g(X.$$.fragment,c),_t=a(c),g(O.$$.fragment,c),yt=a(c),Me=o(c,"DIV",{class:!0});var lt=w(Me);g(pe.$$.fragment,lt),lt.forEach(p),vt=a(c),j=o(c,"DIV",{class:!0});var R=w(j);g(fe.$$.fragment,R),xt=a(R),Le=o(R,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-ygus26"&&(Le.textContent=$n),wt=a(R),g(Q.$$.fragment,R),R.forEach(p),Ht=a(c),T=o(c,"DIV",{class:!0});var P=w(T);g(me.$$.fragment,P),Ft=a(P),ke=o(P,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-sh8nuo"&&(ke.textContent=_n),St=a(P),De=o(P,"P",{"data-svelte-h":!0}),f(De)!=="svelte-a15egh"&&(De.innerHTML=yn),Ct=a(P),g(Y.$$.fragment,P),P.forEach(p),Tt=a(c),I=o(c,"DIV",{class:!0});var q=w(I);g(de.$$.fragment,q),Mt=a(q),Pe=o(q,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-1ensbyu"&&(Pe.textContent=vn),Lt=a(q),Ue=o(q,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1ic7msa"&&(Ue.innerHTML=xn),q.forEach(p),kt=a(c),E=o(c,"DIV",{class:!0});var W=w(E);g(ge.$$.fragment,W),Dt=a(W),je=o(W,"P",{"data-svelte-h":!0}),f(je)!=="svelte-14g8wm7"&&(je.textContent=wn),Pt=a(W),g(B.$$.fragment,W),W.forEach(p),Ut=a(c),A=o(c,"DIV",{class:!0});var z=w(A);g(he.$$.fragment,z),jt=a(z),Ie=o(z,"P",{"data-svelte-h":!0}),f(Ie)!=="svelte-mro2r1"&&(Ie.textContent=Hn),It=a(z),Ee=o(z,"P",{"data-svelte-h":!0}),f(Ee)!=="svelte-kgqd2r"&&(Ee.innerHTML=Fn),z.forEach(p),Et=a(c),M=o(c,"DIV",{class:!0});var U=w(M);g(ue.$$.fragment,U),At=a(U),Ae=o(U,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-vgg72e"&&(Ae.textContent=Sn),Gt=a(U),Ge=o(U,"P",{"data-svelte-h":!0}),f(Ge)!=="svelte-izommx"&&(Ge.innerHTML=Cn),Nt=a(U),g(K.$$.fragment,U),U.forEach(p),Vt=a(c),G=o(c,"DIV",{class:!0});var nt=w(G);g(be.$$.fragment,nt),Jt=a(nt),Ne=o(nt,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-16j3ncy"&&(Ne.textContent=Tn),Zt=a(nt),Ve=o(nt,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-fqhl9"&&(Ve.innerHTML=Mn),nt.forEach(p),Rt=a(c),N=o(c,"DIV",{class:!0});var st=w(N);g($e.$$.fragment,st),qt=a(st),Je=o(st,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-foylj9"&&(Je.textContent=Ln),Wt=a(st),Ze=o(st,"P",{"data-svelte-h":!0}),f(Ze)!=="svelte-fz5g8s"&&(Ze.innerHTML=kn),st.forEach(p),zt=a(c),V=o(c,"DIV",{class:!0});var at=w(V);g(_e.$$.fragment,at),Xt=a(at),Re=o(at,"P",{"data-svelte-h":!0}),f(Re)!=="svelte-15gohlq"&&(Re.textContent=Dn),Ot=a(at),qe=o(at,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-1nd73z"&&(qe.innerHTML=Pn),at.forEach(p),Qt=a(c),L=o(c,"DIV",{class:!0});var ae=w(L);g(ye.$$.fragment,ae),Yt=a(ae),We=o(ae,"P",{"data-svelte-h":!0}),f(We)!=="svelte-f8hcny"&&(We.textContent=Un),Bt=a(ae),ze=o(ae,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-17yp07o"&&(ze.innerHTML=jn),Kt=a(ae),g(ee.$$.fragment,ae),ae.forEach(p),en=a(c),J=o(c,"DIV",{class:!0});var rt=w(J);g(ve.$$.fragment,rt),tn=a(rt),Xe=o(rt,"P",{"data-svelte-h":!0}),f(Xe)!=="svelte-qb251l"&&(Xe.textContent=In),nn=a(rt),Oe=o(rt,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-14xy55m"&&(Oe.innerHTML=En),rt.forEach(p),sn=a(c),te=o(c,"DIV",{class:!0});var ht=w(te);g(xe.$$.fragment,ht),an=a(ht),Qe=o(ht,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-vfdh7r"&&(Qe.textContent=An),ht.forEach(p),rn=a(c),k=o(c,"DIV",{class:!0});var re=w(k);g(we.$$.fragment,re),on=a(re),Ye=o(re,"P",{"data-svelte-h":!0}),f(Ye)!=="svelte-1b1nt2h"&&(Ye.textContent=Gn),ln=a(re),Be=o(re,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-1m6txqs"&&(Be.innerHTML=Nn),cn=a(re),g(ne.$$.fragment,re),re.forEach(p),pn=a(c),se=o(c,"DIV",{class:!0});var ut=w(se);g(He.$$.fragment,ut),fn=a(ut),Ke=o(ut,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-150c7l4"&&(Ke.textContent=Vn),ut.forEach(p),mn=a(c),Z=o(c,"DIV",{class:!0});var ot=w(Z);g(Fe.$$.fragment,ot),dn=a(ot),et=o(ot,"P",{"data-svelte-h":!0}),f(et)!=="svelte-jn2zhy"&&(et.textContent=Jn),gn=a(ot),tt=o(ot,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-1bmm4rs"&&(tt.innerHTML=Zn),ot.forEach(p),c.forEach(p),mt=a(e),g(Se.$$.fragment,e),dt=a(e),it=o(e,"P",{}),w(it).forEach(p),this.h()},h(){H(n,"name","hf:doc:metadata"),H(n,"content",ls),H(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),H(l,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,m){t(document.head,n),v(e,_,m),v(e,i,m),v(e,y,m),h(C,e,m),v(e,x,m),v(e,D,m),v(e,ct,m),h(ie,e,m),v(e,pt,m),v(e,le,m),v(e,ft,m),v(e,l,m),h(ce,l,null),t(l,bt),t(l,Te),t(l,$t),h(X,l,null),t(l,_t),h(O,l,null),t(l,yt),t(l,Me),h(pe,Me,null),t(l,vt),t(l,j),h(fe,j,null),t(j,xt),t(j,Le),t(j,wt),h(Q,j,null),t(l,Ht),t(l,T),h(me,T,null),t(T,Ft),t(T,ke),t(T,St),t(T,De),t(T,Ct),h(Y,T,null),t(l,Tt),t(l,I),h(de,I,null),t(I,Mt),t(I,Pe),t(I,Lt),t(I,Ue),t(l,kt),t(l,E),h(ge,E,null),t(E,Dt),t(E,je),t(E,Pt),h(B,E,null),t(l,Ut),t(l,A),h(he,A,null),t(A,jt),t(A,Ie),t(A,It),t(A,Ee),t(l,Et),t(l,M),h(ue,M,null),t(M,At),t(M,Ae),t(M,Gt),t(M,Ge),t(M,Nt),h(K,M,null),t(l,Vt),t(l,G),h(be,G,null),t(G,Jt),t(G,Ne),t(G,Zt),t(G,Ve),t(l,Rt),t(l,N),h($e,N,null),t(N,qt),t(N,Je),t(N,Wt),t(N,Ze),t(l,zt),t(l,V),h(_e,V,null),t(V,Xt),t(V,Re),t(V,Ot),t(V,qe),t(l,Qt),t(l,L),h(ye,L,null),t(L,Yt),t(L,We),t(L,Bt),t(L,ze),t(L,Kt),h(ee,L,null),t(l,en),t(l,J),h(ve,J,null),t(J,tn),t(J,Xe),t(J,nn),t(J,Oe),t(l,sn),t(l,te),h(xe,te,null),t(te,an),t(te,Qe),t(l,rn),t(l,k),h(we,k,null),t(k,on),t(k,Ye),t(k,ln),t(k,Be),t(k,cn),h(ne,k,null),t(l,pn),t(l,se),h(He,se,null),t(se,fn),t(se,Ke),t(l,mn),t(l,Z),h(Fe,Z,null),t(Z,dn),t(Z,et),t(Z,gn),t(Z,tt),v(e,mt,m),h(Se,e,m),v(e,dt,m),v(e,it,m),gt=!0},p(e,[m]){const c={};m&2&&(c.$$scope={dirty:m,ctx:e}),X.$set(c);const lt={};m&2&&(lt.$$scope={dirty:m,ctx:e}),O.$set(lt);const R={};m&2&&(R.$$scope={dirty:m,ctx:e}),Q.$set(R);const P={};m&2&&(P.$$scope={dirty:m,ctx:e}),Y.$set(P);const q={};m&2&&(q.$$scope={dirty:m,ctx:e}),B.$set(q);const W={};m&2&&(W.$$scope={dirty:m,ctx:e}),K.$set(W);const z={};m&2&&(z.$$scope={dirty:m,ctx:e}),ee.$set(z);const U={};m&2&&(U.$$scope={dirty:m,ctx:e}),ne.$set(U)},i(e){gt||(u(C.$$.fragment,e),u(ie.$$.fragment,e),u(ce.$$.fragment,e),u(X.$$.fragment,e),u(O.$$.fragment,e),u(pe.$$.fragment,e),u(fe.$$.fragment,e),u(Q.$$.fragment,e),u(me.$$.fragment,e),u(Y.$$.fragment,e),u(de.$$.fragment,e),u(ge.$$.fragment,e),u(B.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(K.$$.fragment,e),u(be.$$.fragment,e),u($e.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(ee.$$.fragment,e),u(ve.$$.fragment,e),u(xe.$$.fragment,e),u(we.$$.fragment,e),u(ne.$$.fragment,e),u(He.$$.fragment,e),u(Fe.$$.fragment,e),u(Se.$$.fragment,e),gt=!0)},o(e){b(C.$$.fragment,e),b(ie.$$.fragment,e),b(ce.$$.fragment,e),b(X.$$.fragment,e),b(O.$$.fragment,e),b(pe.$$.fragment,e),b(fe.$$.fragment,e),b(Q.$$.fragment,e),b(me.$$.fragment,e),b(Y.$$.fragment,e),b(de.$$.fragment,e),b(ge.$$.fragment,e),b(B.$$.fragment,e),b(he.$$.fragment,e),b(ue.$$.fragment,e),b(K.$$.fragment,e),b(be.$$.fragment,e),b($e.$$.fragment,e),b(_e.$$.fragment,e),b(ye.$$.fragment,e),b(ee.$$.fragment,e),b(ve.$$.fragment,e),b(xe.$$.fragment,e),b(we.$$.fragment,e),b(ne.$$.fragment,e),b(He.$$.fragment,e),b(Fe.$$.fragment,e),b(Se.$$.fragment,e),gt=!1},d(e){e&&(p(_),p(i),p(y),p(x),p(D),p(ct),p(pt),p(le),p(ft),p(l),p(mt),p(dt),p(it)),p(n),$(C,e),$(ie,e),$(ce),$(X),$(O),$(pe),$(fe),$(Q),$(me),$(Y),$(de),$(ge),$(B),$(he),$(ue),$(K),$(be),$($e),$(_e),$(ye),$(ee),$(ve),$(xe),$(we),$(ne),$(He),$(Fe),$(Se,e)}}}const ls='{"title":"Filesystem API","local":"filesystem-api","sections":[{"title":"HfFileSystem","local":"huggingface_hub.HfFileSystem","sections":[],"depth":2}],"depth":1}';function cs(F){return Wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bs extends zn{constructor(n){super(),Xn(this,n,cs,is,qn,{})}}export{bs as component};
