import{s as ce,n as he,o as me}from"../chunks/scheduler.8c3d61f6.js";import{S as pe,i as ue,g as l,s as a,r as U,A as fe,h as o,f as s,c as n,j as oe,u as G,x as r,k as de,y as ge,a as i,v as j,d as I,t as _,w as W}from"../chunks/index.da70eac4.js";import{C as re}from"../chunks/CodeBlock.a9c4becf.js";import{H as A,E as ye}from"../chunks/index.ef90fe87.js";function we(K){let d,X,k,Y,c,R,h,O='<a href="https://github.com/PKU-YuanGroup/ConsisID" rel="nofollow">ConsisID</a> is an identity-preserving text-to-video generation model that keeps the face consistent in the generated video by frequency decomposition. The main features of ConsisID are:',x,m,ee="<li>Frequency decomposition: The characteristics of the DiT architecture are analyzed from the frequency domain perspective, and based on these characteristics, a reasonable control information injection method is designed.</li> <li>Consistency training strategy: A coarse-to-fine training strategy, dynamic masking loss, and dynamic cross-face loss further enhance the model’s generalization ability and identity preservation performance.</li> <li>Inference without finetuning: Previous methods required case-by-case finetuning of the input ID before inference, leading to significant time and computational costs. In contrast, ConsisID is tuning-free.</li>",V,p,te="This guide will walk you through using ConsisID for use cases.",C,u,N,f,se='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',H,g,Q,y,$,w,ie="For identity-preserving text-to-video, pass a text prompt and an image contain clear face (e.g., preferably half-body or full-body). By default, ConsisID generates a 720x480 video for the best results.",F,M,z,b,ae='<tbody><tr><th style="text-align: center;">Face Image</th> <th style="text-align: center;">Video</th> <th style="text-align: center;">Description</th> </tr><tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_0.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_0.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video, in a beautifully crafted animated style, features a confident woman riding a horse through a lush forest clearing. Her expression is focused yet serene as she adjusts her wide-brimmed hat with a practiced hand. She wears a flowy bohemian dress, which moves gracefully with the rhythm of the horse, the fabric flowing fluidly in the animated motion. The dappled sunlight filters through the trees, casting soft, painterly patterns on the forest floor. Her posture is poised, showing both control and elegance as she guides the horse with ease. The animation&#39;s gentle, fluid style adds a dreamlike quality to the scene, with the woman’s calm demeanor and the peaceful surroundings evoking a sense of freedom and harmony.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_1.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_1.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video, in a captivating animated style, shows a woman standing in the center of a snowy forest, her eyes narrowed in concentration as she extends her hand forward. She is dressed in a deep blue cloak, her breath visible in the cold air, which is rendered with soft, ethereal strokes. A faint smile plays on her lips as she summons a wisp of ice magic, watching with focus as the surrounding trees and ground begin to shimmer and freeze, covered in delicate ice crystals. The animation’s fluid motion brings the magic to life, with the frost spreading outward in intricate, sparkling patterns. The environment is painted with soft, watercolor-like hues, enhancing the magical, dreamlike atmosphere. The overall mood is serene yet powerful, with the quiet winter air amplifying the delicate beauty of the frozen scene.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_2.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_2.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The animation features a whimsical portrait of a balloon seller standing in a gentle breeze, captured with soft, hazy brushstrokes that evoke the feel of a serene spring day. His face is framed by a gentle smile, his eyes squinting slightly against the sun, while a few wisps of hair flutter in the wind. He is dressed in a light, pastel-colored shirt, and the balloons around him sway with the wind, adding a sense of playfulness to the scene. The background blurs softly, with hints of a vibrant market or park, enhancing the light-hearted, yet tender mood of the moment.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_3.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_3.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#39;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#39;s path, adding depth to the scene. The lighting highlights the boy&#39;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.</td></tr> <tr><td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_image_4.png?download=true" style="height: auto; width: 600px;"/></td> <td><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_output_4.gif?download=true" style="height: auto; width: 2000px;"/></td> <td>The video features a baby wearing a bright superhero cape, standing confidently with arms raised in a powerful pose. The baby has a determined look on their face, with eyes wide and lips pursed in concentration, as if ready to take on a challenge. The setting appears playful, with colorful toys scattered around and a soft rug underfoot, while sunlight streams through a nearby window, highlighting the fluttering cape and adding to the impression of heroism. The overall atmosphere is lighthearted and fun, with the baby&#39;s expressions capturing a mix of innocence and an adorable attempt at bravery, as if truly ready to save the day.</td></tr></tbody>',E,J,D,T,ne="Learn more about ConsisID with the following resources.",q,Z,le='<li>A <a href="https://www.youtube.com/watch?v=PhlgC-bI5SQ" rel="nofollow">video</a> demonstrating ConsisID’s main features.</li> <li>The research paper, <a href="https://hf.co/papers/2411.17440" rel="nofollow">Identity-Preserving Text-to-Video Generation by Frequency Decomposition</a> for more details.</li>',S,v,L,B,P;return c=new A({props:{title:"ConsisID",local:"consisid",headingTag:"h1"}}),u=new A({props:{title:"Load Model Checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),g=new re({props:{code:"JTIzJTIwIXBpcCUyMGluc3RhbGwlMjBjb25zaXNpZF9ldmFfY2xpcCUyMGluc2lnaHRmYWNlJTIwZmFjZXhsaWIlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBDb25zaXNJRFBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy5waXBlbGluZXMuY29uc2lzaWQuY29uc2lzaWRfdXRpbHMlMjBpbXBvcnQlMjBwcmVwYXJlX2ZhY2VfbW9kZWxzJTJDJTIwcHJvY2Vzc19mYWNlX2VtYmVkZGluZ3NfaW5mZXIlMEFmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwc25hcHNob3RfZG93bmxvYWQlMEElMEElMjMlMjBEb3dubG9hZCUyMGNrcHRzJTBBc25hcHNob3RfZG93bmxvYWQocmVwb19pZCUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiUyQyUyMGxvY2FsX2RpciUzRCUyMkJlc3RXaXNoWXNoJTJGQ29uc2lzSUQtcHJldmlldyUyMiklMEElMEElMjMlMjBMb2FkJTIwZmFjZSUyMGhlbHBlciUyMG1vZGVsJTIwdG8lMjBwcmVwcm9jZXNzJTIwaW5wdXQlMjBmYWNlJTIwaW1hZ2UlMEFmYWNlX2hlbHBlcl8xJTJDJTIwZmFjZV9oZWxwZXJfMiUyQyUyMGZhY2VfY2xpcF9tb2RlbCUyQyUyMGZhY2VfbWFpbl9tb2RlbCUyQyUyMGV2YV90cmFuc2Zvcm1fbWVhbiUyQyUyMGV2YV90cmFuc2Zvcm1fc3RkJTIwJTNEJTIwcHJlcGFyZV9mYWNlX21vZGVscyglMjJCZXN0V2lzaFlzaCUyRkNvbnNpc0lELXByZXZpZXclMjIlMkMlMjBkZXZpY2UlM0QlMjJjdWRhJTIyJTJDJTIwZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEElMEElMjMlMjBMb2FkJTIwY29uc2lzaWQlMjBiYXNlJTIwbW9kZWwlMEFwaXBlJTIwJTNEJTIwQ29uc2lzSURQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyQmVzdFdpc2hZc2glMkZDb25zaXNJRC1wcmV2aWV3JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFwaXBlLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-comment"># !pip install consisid_eva_clip insightface facexlib</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ConsisIDPipeline
<span class="hljs-keyword">from</span> diffusers.pipelines.consisid.consisid_utils <span class="hljs-keyword">import</span> prepare_face_models, process_face_embeddings_infer
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> snapshot_download

<span class="hljs-comment"># Download ckpts</span>
snapshot_download(repo_id=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, local_dir=<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>)

<span class="hljs-comment"># Load face helper model to preprocess input face image</span>
face_helper_1, face_helper_2, face_clip_model, face_main_model, eva_transform_mean, eva_transform_std = prepare_face_models(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-comment"># Load consisid base model</span>
pipe = ConsisIDPipeline.from_pretrained(<span class="hljs-string">&quot;BestWishYsh/ConsisID-preview&quot;</span>, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),y=new A({props:{title:"Identity-Preserving Text-to-Video",local:"identity-preserving-text-to-video",headingTag:"h2"}}),M=new re({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video

prompt = <span class="hljs-string">&quot;The video captures a boy walking along a city street, filmed in black and white on a classic 35mm camera. His expression is thoughtful, his brow slightly furrowed as if he&#x27;s lost in contemplation. The film grain adds a textured, timeless quality to the image, evoking a sense of nostalgia. Around him, the cityscape is filled with vintage buildings, cobblestone sidewalks, and softly blurred figures passing by, their outlines faint and indistinct. Streetlights cast a gentle glow, while shadows play across the boy&#x27;s path, adding depth to the scene. The lighting highlights the boy&#x27;s subtle smile, hinting at a fleeting moment of curiosity. The overall cinematic atmosphere, complete with classic film still aesthetics and dramatic contrasts, gives the scene an evocative and introspective feel.&quot;</span>
image = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/consisid/consisid_input.png?download=true&quot;</span>

id_cond, id_vit_hidden, image, face_kps = process_face_embeddings_infer(face_helper_1, face_clip_model, face_helper_2, eva_transform_mean, eva_transform_std, face_main_model, <span class="hljs-string">&quot;cuda&quot;</span>, torch.bfloat16, image, is_align_face=<span class="hljs-literal">True</span>)

video = pipe(image=image, prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">6.0</span>, use_dynamic_cfg=<span class="hljs-literal">False</span>, id_vit_hidden=id_vit_hidden, id_cond=id_cond, kps_cond=face_kps, generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">42</span>))
export_to_video(video.frames[<span class="hljs-number">0</span>], <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">8</span>)`,wrap:!1}}),J=new A({props:{title:"Resources",local:"resources",headingTag:"h2"}}),v=new ye({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/consisid.md"}}),{c(){d=l("meta"),X=a(),k=l("p"),Y=a(),U(c.$$.fragment),R=a(),h=l("p"),h.innerHTML=O,x=a(),m=l("ul"),m.innerHTML=ee,V=a(),p=l("p"),p.textContent=te,C=a(),U(u.$$.fragment),N=a(),f=l("p"),f.innerHTML=se,H=a(),U(g.$$.fragment),Q=a(),U(y.$$.fragment),$=a(),w=l("p"),w.textContent=ie,F=a(),U(M.$$.fragment),z=a(),b=l("table"),b.innerHTML=ae,E=a(),U(J.$$.fragment),D=a(),T=l("p"),T.textContent=ne,q=a(),Z=l("ul"),Z.innerHTML=le,S=a(),U(v.$$.fragment),L=a(),B=l("p"),this.h()},l(e){const t=fe("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(s),X=n(e),k=o(e,"P",{}),oe(k).forEach(s),Y=n(e),G(c.$$.fragment,e),R=n(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-436irt"&&(h.innerHTML=O),x=n(e),m=o(e,"UL",{"data-svelte-h":!0}),r(m)!=="svelte-14veasm"&&(m.innerHTML=ee),V=n(e),p=o(e,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1msmrce"&&(p.textContent=te),C=n(e),G(u.$$.fragment,e),N=n(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1ia8sef"&&(f.innerHTML=se),H=n(e),G(g.$$.fragment,e),Q=n(e),G(y.$$.fragment,e),$=n(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1bshl1z"&&(w.textContent=ie),F=n(e),G(M.$$.fragment,e),z=n(e),b=o(e,"TABLE",{"data-svelte-h":!0}),r(b)!=="svelte-1lt1e5d"&&(b.innerHTML=ae),E=n(e),G(J.$$.fragment,e),D=n(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1qlvco3"&&(T.textContent=ne),q=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),r(Z)!=="svelte-169u4r5"&&(Z.innerHTML=le),S=n(e),G(v.$$.fragment,e),L=n(e),B=o(e,"P",{}),oe(B).forEach(s),this.h()},h(){de(d,"name","hf:doc:metadata"),de(d,"content",Me)},m(e,t){ge(document.head,d),i(e,X,t),i(e,k,t),i(e,Y,t),j(c,e,t),i(e,R,t),i(e,h,t),i(e,x,t),i(e,m,t),i(e,V,t),i(e,p,t),i(e,C,t),j(u,e,t),i(e,N,t),i(e,f,t),i(e,H,t),j(g,e,t),i(e,Q,t),j(y,e,t),i(e,$,t),i(e,w,t),i(e,F,t),j(M,e,t),i(e,z,t),i(e,b,t),i(e,E,t),j(J,e,t),i(e,D,t),i(e,T,t),i(e,q,t),i(e,Z,t),i(e,S,t),j(v,e,t),i(e,L,t),i(e,B,t),P=!0},p:he,i(e){P||(I(c.$$.fragment,e),I(u.$$.fragment,e),I(g.$$.fragment,e),I(y.$$.fragment,e),I(M.$$.fragment,e),I(J.$$.fragment,e),I(v.$$.fragment,e),P=!0)},o(e){_(c.$$.fragment,e),_(u.$$.fragment,e),_(g.$$.fragment,e),_(y.$$.fragment,e),_(M.$$.fragment,e),_(J.$$.fragment,e),_(v.$$.fragment,e),P=!1},d(e){e&&(s(X),s(k),s(Y),s(R),s(h),s(x),s(m),s(V),s(p),s(C),s(N),s(f),s(H),s(Q),s($),s(w),s(F),s(z),s(b),s(E),s(D),s(T),s(q),s(Z),s(S),s(L),s(B)),s(d),W(c,e),W(u,e),W(g,e),W(y,e),W(M,e),W(J,e),W(v,e)}}}const Me='{"title":"ConsisID","local":"consisid","sections":[{"title":"Load Model Checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Identity-Preserving Text-to-Video","local":"identity-preserving-text-to-video","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function be(K){return me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ue extends pe{constructor(d){super(),ue(this,d,be,we,ce,{})}}export{Ue as component};
