import{s as na,o as pa,n as C}from"../chunks/scheduler.8c3d61f6.js";import{S as oa,i as ma,g as u,s as p,r as f,A as ra,h as y,f as t,c as o,j as sa,u as h,x as g,k as ia,l as T,y as da,a,v as J,d as w,t as Z,w as b}from"../chunks/index.da70eac4.js";import{T as Mt}from"../chunks/Tip.1d9b8c37.js";import{C as I}from"../chunks/CodeBlock.a9c4becf.js";import{H as $,E as ca}from"../chunks/index.ef90fe87.js";import{H as ut,a as ze}from"../chunks/HfOption.6ab18950.js";function Ma(W){let s,d='IP-Adapters are available to many models such as <a href="../api/pipelines/flux#ip-adapter">Flux</a> and <a href="../api/pipelines/stable_diffusion/stable_diffusion_3">Stable Diffusion 3</a>, and more. The examples in this guide use Stable Diffusion and Stable Diffusion XL.';return{c(){s=u("p"),s.innerHTML=d},l(i){s=y(i,"P",{"data-svelte-h":!0}),g(s)!=="svelte-1s8spky"&&(s.innerHTML=d)},m(i,c){a(i,s,c)},p:C,d(i){i&&t(s)}}}function ua(W){let s,d,i,c='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png" width="300" alt="input image"/> <figcaption style="text-align: center;">input image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png" width="300" alt="IP-Adapter image"/> <figcaption style="text-align: center;">IP-Adapter image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_3.png" width="300" alt="generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',m;return s=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTBBJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTBBJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuOCklMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfYWRhcHRlcl9iZWFyXzEucG5nJTIyKSUwQWlwX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2d1bW15LnBuZyUyMiklMEFwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpcF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC41JTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>
)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.8</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)
pipeline(
    prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
    image=image,
    ip_adapter_image=ip_image,
    strength=<span class="hljs-number">0.5</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){f(s.$$.fragment),d=p(),i=u("div"),i.innerHTML=c,this.h()},l(n){h(s.$$.fragment,n),d=o(n),i=y(n,"DIV",{style:!0,"data-svelte-h":!0}),g(i)!=="svelte-143vd3e"&&(i.innerHTML=c),this.h()},h(){T(i,"display","flex"),T(i,"gap","10px"),T(i,"justify-content","space-around"),T(i,"align-items","flex-end")},m(n,r){J(s,n,r),a(n,d,r),a(n,i,r),m=!0},p:C,i(n){m||(w(s.$$.fragment,n),m=!0)},o(n){Z(s.$$.fragment,n),m=!1},d(n){n&&(t(d),t(i)),b(s,n)}}}function ya(W){let s,d,i,c='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png" width="300" alt="input image"/> <figcaption style="text-align: center;">input image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png" width="300" alt="IP-Adapter image"/> <figcaption style="text-align: center;">IP-Adapter image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png" width="300" alt="generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',m;return s=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTBBJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTBBJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkeGwuYmluJTIyJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKDAuNiklMEElMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX21hc2sucG5nJTIyKSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9hZGFwdGVyX2JlYXJfMS5wbmclMjIpJTBBaXBfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZ3VtbXkucG5nJTIyKSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBjdXRlJTIwZ3VtbXklMjBiZWFyJTIwd2F2aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>
)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)

mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_mask.png&quot;</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_bear_1.png&quot;</span>)
ip_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_gummy.png&quot;</span>)
pipeline(
    prompt=<span class="hljs-string">&quot;a cute gummy bear waving&quot;</span>,
    image=image,
    mask_image=mask_image,
    ip_adapter_image=ip_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){f(s.$$.fragment),d=p(),i=u("div"),i.innerHTML=c,this.h()},l(n){h(s.$$.fragment,n),d=o(n),i=y(n,"DIV",{style:!0,"data-svelte-h":!0}),g(i)!=="svelte-1hqj44d"&&(i.innerHTML=c),this.h()},h(){T(i,"display","flex"),T(i,"gap","10px"),T(i,"justify-content","space-around"),T(i,"align-items","flex-end")},m(n,r){J(s,n,r),a(n,d,r),a(n,i,r),m=!0},p:C,i(n){m||(w(s.$$.fragment,n),m=!0)},o(n){Z(s.$$.fragment,n),m=!1},d(n){n&&(t(d),t(i)),b(s,n)}}}function ga(W){let s,d='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> method is useful for reducing memory and it should be enabled <strong>after</strong> the IP-Adapter is loaded. Otherwise, the IP-Adapter’s image encoder is also offloaded to the CPU and returns an error.',i,c,m,n,r='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png" width="400" alt="IP-Adapter image"/> <figcaption style="text-align: center;">IP-Adapter image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/gummy_bear.gif" width="400" alt="generated video"/> <figcaption style="text-align: center;">generated video</figcaption></figure>',M;return c=new I({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, DDIMScheduler, MotionAdapter
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

adapter = MotionAdapter.from_pretrained(
  <span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>,
  torch_dtype=torch.float16
)
pipeline = AnimateDiffPipeline.from_pretrained(
  <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
  motion_adapter=adapter,
  torch_dtype=torch.float16
)
scheduler = DDIMScheduler.from_pretrained(
    <span class="hljs-string">&quot;emilianJR/epiCRealism&quot;</span>,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
    clip_sample=<span class="hljs-literal">False</span>,
    timestep_spacing=<span class="hljs-string">&quot;linspace&quot;</span>,
    beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>,
    steps_offset=<span class="hljs-number">1</span>,
)
pipeline.scheduler = scheduler
pipeline.enable_vae_slicing()
pipeline.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipeline.enable_model_cpu_offload()

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_inpaint.png&quot;</span>)
pipeline(
    prompt=<span class="hljs-string">&quot;A cute gummy bear waving&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;bad quality, worse quality, low resolution&quot;</span>,
    ip_adapter_image=ip_adapter_image,
    num_frames=<span class="hljs-number">16</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
).frames[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=u("p"),s.innerHTML=d,i=p(),f(c.$$.fragment),m=p(),n=u("div"),n.innerHTML=r,this.h()},l(U){s=y(U,"P",{"data-svelte-h":!0}),g(s)!=="svelte-1wmzkcn"&&(s.innerHTML=d),i=o(U),h(c.$$.fragment,U),m=o(U),n=y(U,"DIV",{style:!0,"data-svelte-h":!0}),g(n)!=="svelte-nx5uxl"&&(n.innerHTML=r),this.h()},h(){T(n,"display","flex"),T(n,"gap","10px"),T(n,"justify-content","space-around"),T(n,"align-items","flex-end")},m(U,G){a(U,s,G),a(U,i,G),J(c,U,G),a(U,m,G),a(U,n,G),M=!0},p:C,i(U){M||(w(c.$$.fragment,U),M=!0)},o(U){Z(c.$$.fragment,U),M=!1},d(U){U&&(t(s),t(i),t(m),t(n)),b(c,U)}}}function fa(W){let s,d,i,c,m,n;return s=new ze({props:{id:"usage",option:"image-to-image",$$slots:{default:[ua]},$$scope:{ctx:W}}}),i=new ze({props:{id:"usage",option:"inpainting",$$slots:{default:[ya]},$$scope:{ctx:W}}}),m=new ze({props:{id:"usage",option:"video",$$slots:{default:[ga]},$$scope:{ctx:W}}}),{c(){f(s.$$.fragment),d=p(),f(i.$$.fragment),c=p(),f(m.$$.fragment)},l(r){h(s.$$.fragment,r),d=o(r),h(i.$$.fragment,r),c=o(r),h(m.$$.fragment,r)},m(r,M){J(s,r,M),a(r,d,M),J(i,r,M),a(r,c,M),J(m,r,M),n=!0},p(r,M){const U={};M&2&&(U.$$scope={dirty:M,ctx:r}),s.$set(U);const G={};M&2&&(G.$$scope={dirty:M,ctx:r}),i.$set(G);const j={};M&2&&(j.$$scope={dirty:M,ctx:r}),m.$set(j)},i(r){n||(w(s.$$.fragment,r),w(i.$$.fragment,r),w(m.$$.fragment,r),n=!0)},o(r){Z(s.$$.fragment,r),Z(i.$$.fragment,r),Z(m.$$.fragment,r),n=!1},d(r){r&&(t(d),t(c)),b(s,r),b(i,r),b(m,r)}}}function ha(W){let s,d;return s=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMkMlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlJTBBJTBBaW1hZ2VfZW5jb2RlciUyMCUzRCUyMENMSVBWaXNpb25Nb2RlbFdpdGhQcm9qZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTJGaW1hZ2VfZW5jb2RlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2VuY29kZXIlM0RpbWFnZV9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMEElMjAlMjAlMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTBBJTIwJTIwc3ViZm9sZGVyJTNEJTIyc2R4bF9tb2RlbHMlMjIlMkMlMEElMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItcGx1c19zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection, AutoPipelineForText2Image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    image_encoder=image_encoder,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>
)`,wrap:!1}}),{c(){f(s.$$.fragment)},l(i){h(s.$$.fragment,i)},m(i,c){J(s,i,c),d=!0},p:C,i(i){d||(w(s.$$.fragment,i),d=!0)},o(i){Z(s.$$.fragment,i),d=!1},d(i){b(s,i)}}}function Ja(W){let s,d,i,c='To use a IP-Adapter FaceID Plus model, load the CLIP image encoder as well as <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',m,n,r;return s=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMEElMjAlMjAlMjJoOTQlMkZJUC1BZGFwdGVyLUZhY2VJRCUyMiUyQyUwQSUyMCUyMHN1YmZvbGRlciUzRE5vbmUlMkMlMEElMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXItZmFjZWlkX3NkeGwuYmluJTIyJTJDJTBBJTIwJTIwaW1hZ2VfZW5jb2Rlcl9mb2xkZXIlM0ROb25lJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter-FaceID&quot;</span>,
  subfolder=<span class="hljs-literal">None</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter-faceid_sdxl.bin&quot;</span>,
  image_encoder_folder=<span class="hljs-literal">None</span>
)`,wrap:!1}}),n=new I({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMkMlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbiUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybGFpb24lMkZDTElQLVZpVC1ILTE0LWxhaW9uMkItczMyQi1iNzlLJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW5jb2RlciUzRGltYWdlX2VuY29kZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXItRmFjZUlEJTIyJTJDJTBBJTIwJTIwc3ViZm9sZGVyJTNETm9uZSUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlci1mYWNlaWQtcGx1c19zZDE1LmJpbiUyMiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, CLIPVisionModelWithProjection

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;laion/CLIP-ViT-H-14-laion2B-s32B-b79K&quot;</span>,
    torch_dtype=torch.float16,
)

pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    image_encoder=image_encoder,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter-FaceID&quot;</span>,
  subfolder=<span class="hljs-literal">None</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter-faceid-plus_sd15.bin&quot;</span>
)`,wrap:!1}}),{c(){f(s.$$.fragment),d=p(),i=u("p"),i.innerHTML=c,m=p(),f(n.$$.fragment)},l(M){h(s.$$.fragment,M),d=o(M),i=y(M,"P",{"data-svelte-h":!0}),g(i)!=="svelte-g1sk9v"&&(i.innerHTML=c),m=o(M),h(n.$$.fragment,M)},m(M,U){J(s,M,U),a(M,d,U),a(M,i,U),a(M,m,U),J(n,M,U),r=!0},p:C,i(M){r||(w(s.$$.fragment,M),w(n.$$.fragment,M),r=!0)},o(M){Z(s.$$.fragment,M),Z(n.$$.fragment,M),r=!1},d(M){M&&(t(d),t(i),t(m)),b(s,M),b(n,M)}}}function wa(W){let s,d,i,c;return s=new ze({props:{id:"ipadapter-variants",option:"IP-Adapter Plus",$$slots:{default:[ha]},$$scope:{ctx:W}}}),i=new ze({props:{id:"ipadapter-variants",option:"IP-Adapter FaceID",$$slots:{default:[Ja]},$$scope:{ctx:W}}}),{c(){f(s.$$.fragment),d=p(),f(i.$$.fragment)},l(m){h(s.$$.fragment,m),d=o(m),h(i.$$.fragment,m)},m(m,n){J(s,m,n),a(m,d,n),J(i,m,n),c=!0},p(m,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:m}),s.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:m}),i.$set(M)},i(m){c||(w(s.$$.fragment,m),w(i.$$.fragment,m),c=!0)},o(m){Z(s.$$.fragment,m),Z(i.$$.fragment,m),c=!1},d(m){m&&t(d),b(s,m),b(i,m)}}}function Za(W){let s,d="You can also load image embeddings from other sources such as ComfyUI.";return{c(){s=u("p"),s.textContent=d},l(i){s=y(i,"P",{"data-svelte-h":!0}),g(s)!=="svelte-15eph5s"&&(s.textContent=d)},m(i,c){a(i,s,c)},p:C,d(i){i&&t(s)}}}function ba(W){let s,d,i,c='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png" width="400" alt="IP-Adapter image"/> <figcaption style="text-align: center;">IP-Adapter image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein.png" width="400" alt="generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',m;return s=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMEElMjAlMjAlMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTBBJTIwJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwJTBBJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyLWZ1bGwtZmFjZV9zZDE1LmJpbiUyMiUwQSklMEElMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjUpJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZWluc3RlaW5fYmFzZS5wbmclMjIpJTBBJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyQSUyMHBob3RvJTIwb2YlMjBFaW5zdGVpbiUyMGFzJTIwYSUyMGNoZWYlMkMlMjB3ZWFyaW5nJTIwYW4lMjBhcHJvbiUyQyUyMGNvb2tpbmclMjBpbiUyMGElMjBGcmVuY2glMjByZXN0YXVyYW50JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
  torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;models&quot;</span>, 
  weight_name=<span class="hljs-string">&quot;ip-adapter-full-face_sd15.bin&quot;</span>
)

pipeline.set_ip_adapter_scale(<span class="hljs-number">0.5</span>)
image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_einstein_base.png&quot;</span>)

pipeline(
    prompt=<span class="hljs-string">&quot;A photo of Einstein as a chef, wearing an apron, cooking in a French restaurant&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){f(s.$$.fragment),d=p(),i=u("div"),i.innerHTML=c,this.h()},l(n){h(s.$$.fragment,n),d=o(n),i=y(n,"DIV",{style:!0,"data-svelte-h":!0}),g(i)!=="svelte-1sqhdfz"&&(i.innerHTML=c),this.h()},h(){T(i,"display","flex"),T(i,"gap","10px"),T(i,"justify-content","space-around"),T(i,"align-items","flex-end")},m(n,r){J(s,n,r),a(n,d,r),a(n,i,r),m=!0},p:C,i(n){m||(w(s.$$.fragment,n),m=!0)},o(n){Z(s.$$.fragment,n),m=!1},d(n){n&&(t(d),t(i)),b(s,n)}}}function Ta(W){let s,d="For FaceID models, extract the face embeddings and pass them as a list of tensors to <code>ip_adapter_image_embeds</code>.",i,c,m,n,r="The IP-Adapter FaceID Plus and Plus v2 models require CLIP image embeddings. Prepare the face embeddings and then extract and pass the CLIP embeddings to the hidden image projection layers.",M,U,G;return c=new I({props:{code:"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",highlighted:`<span class="hljs-comment"># pip install insightface</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> insightface.app <span class="hljs-keyword">import</span> FaceAnalysis

pipeline = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter-FaceID&quot;</span>,
  subfolder=<span class="hljs-literal">None</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter-faceid_sd15.bin&quot;</span>,
  image_encoder_folder=<span class="hljs-literal">None</span>
)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)

ref_images_embeds = []
app = FaceAnalysis(name=<span class="hljs-string">&quot;buffalo_l&quot;</span>, providers=[<span class="hljs-string">&#x27;CUDAExecutionProvider&#x27;</span>, <span class="hljs-string">&#x27;CPUExecutionProvider&#x27;</span>])
app.prepare(ctx_id=<span class="hljs-number">0</span>, det_size=(<span class="hljs-number">640</span>, <span class="hljs-number">640</span>))
image = cv2.cvtColor(np.asarray(image), cv2.COLOR_BGR2RGB)
faces = app.get(image)
image = torch.from_numpy(faces[<span class="hljs-number">0</span>].normed_embedding)
ref_images_embeds.append(image.unsqueeze(<span class="hljs-number">0</span>))
ref_images_embeds = torch.stack(ref_images_embeds, dim=<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)
neg_ref_images_embeds = torch.zeros_like(ref_images_embeds)
id_embeds = torch.cat([neg_ref_images_embeds, ref_images_embeds]).to(dtype=torch.float16, device=<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline(
    prompt=<span class="hljs-string">&quot;A photo of a girl&quot;</span>,
    ip_adapter_image_embeds=[id_embeds],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),U=new I({props:{code:"Y2xpcF9lbWJlZHMlMjAlM0QlMjBwaXBlbGluZS5wcmVwYXJlX2lwX2FkYXB0ZXJfaW1hZ2VfZW1iZWRzKCUwQSUyMCUyMCU1QmlwX2FkYXB0ZXJfaW1hZ2VzJTVEJTJDJTIwTm9uZSUyQyUyMHRvcmNoLmRldmljZSglMjJjdWRhJTIyKSUyQyUyMG51bV9pbWFnZXMlMkMlMjBUcnVlKSU1QjAlNUQlMEElMEFwaXBlbGluZS51bmV0LmVuY29kZXJfaGlkX3Byb2ouaW1hZ2VfcHJvamVjdGlvbl9sYXllcnMlNUIwJTVELmNsaXBfZW1iZWRzJTIwJTNEJTIwY2xpcF9lbWJlZHMudG8oZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUyMyUyMHNldCUyMHRvJTIwVHJ1ZSUyMGlmJTIwdXNpbmclMjBJUC1BZGFwdGVyJTIwRmFjZUlEJTIwUGx1cyUyMHYyJTBBcGlwZWxpbmUudW5ldC5lbmNvZGVyX2hpZF9wcm9qLmltYWdlX3Byb2plY3Rpb25fbGF5ZXJzJTVCMCU1RC5zaG9ydGN1dCUyMCUzRCUyMEZhbHNl",highlighted:`clip_embeds = pipeline.prepare_ip_adapter_image_embeds(
  [ip_adapter_images], <span class="hljs-literal">None</span>, torch.device(<span class="hljs-string">&quot;cuda&quot;</span>), num_images, <span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]

pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].clip_embeds = clip_embeds.to(dtype=torch.float16)
<span class="hljs-comment"># set to True if using IP-Adapter FaceID Plus v2</span>
pipeline.unet.encoder_hid_proj.image_projection_layers[<span class="hljs-number">0</span>].shortcut = <span class="hljs-literal">False</span>`,wrap:!1}}),{c(){s=u("p"),s.innerHTML=d,i=p(),f(c.$$.fragment),m=p(),n=u("p"),n.textContent=r,M=p(),f(U.$$.fragment)},l(j){s=y(j,"P",{"data-svelte-h":!0}),g(s)!=="svelte-136q08"&&(s.innerHTML=d),i=o(j),h(c.$$.fragment,j),m=o(j),n=y(j,"P",{"data-svelte-h":!0}),g(n)!=="svelte-iaigew"&&(n.textContent=r),M=o(j),h(U.$$.fragment,j)},m(j,_){a(j,s,_),a(j,i,_),J(c,j,_),a(j,m,_),a(j,n,_),a(j,M,_),J(U,j,_),G=!0},p:C,i(j){G||(w(c.$$.fragment,j),w(U.$$.fragment,j),G=!0)},o(j){Z(c.$$.fragment,j),Z(U.$$.fragment,j),G=!1},d(j){j&&(t(s),t(i),t(m),t(n),t(M)),b(c,j),b(U,j)}}}function Ua(W){let s,d,i,c;return s=new ze({props:{id:"usage",option:"h94/IP-Adapter",$$slots:{default:[ba]},$$scope:{ctx:W}}}),i=new ze({props:{id:"usage",option:"h94/IP-Adapter-FaceID",$$slots:{default:[Ta]},$$scope:{ctx:W}}}),{c(){f(s.$$.fragment),d=p(),f(i.$$.fragment)},l(m){h(s.$$.fragment,m),d=o(m),h(i.$$.fragment,m)},m(m,n){J(s,m,n),a(m,d,n),J(i,m,n),c=!0},p(m,n){const r={};n&2&&(r.$$scope={dirty:n,ctx:m}),s.$set(r);const M={};n&2&&(M.$$scope={dirty:n,ctx:m}),i.$set(M)},i(m){c||(w(s.$$.fragment,m),w(i.$$.fragment,m),c=!0)},o(m){Z(s.$$.fragment,m),Z(i.$$.fragment,m),c=!1},d(m){m&&t(d),b(s,m),b(i,m)}}}function ja(W){let s,d="You don’t need to specify all the layers in the <code>scale</code> dictionary. Layers not included are set to 0, which means the IP-Adapter is disabled.";return{c(){s=u("p"),s.innerHTML=d},l(i){s=y(i,"P",{"data-svelte-h":!0}),g(s)!=="svelte-1wnfs9b"&&(s.innerHTML=d)},m(i,c){a(i,s,c)},p:C,d(i){i&&t(s)}}}function Wa(W){let s,d,i,c,m,n,r,M='<a href="https://huggingface.co/papers/2308.06721" rel="nofollow">IP-Adapter</a> is a lightweight adapter designed to integrate image-based guidance with text-to-image diffusion models. The adapter uses an image encoder to extract image features that are passed to the newly added cross-attention layers in the UNet and fine-tuned. The original UNet model and the existing cross-attention layers corresponding to text features is frozen. Decoupling the cross-attention for image and text features enables more fine-grained and controllable generation.',U,G,j='IP-Adapter files are typically ~100MBs because they only contain the image embeddings. This means you need to load a model first, and then load the IP-Adapter with <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a>.',_,x,Pe,q,yt='Use the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> parameter to scale the influence of the IP-Adapter during generation. A value of <code>1.0</code> means the model is only conditioned on the image prompt, and <code>0.5</code> typically produces balanced results between the text and image prompt.',De,z,Ke,L,gt="Pass an image to <code>ip_adapter_image</code> along with a text prompt to generate an image.",Oe,P,el,B,ft='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png" width="400" alt="IP-Adapter image"/> <figcaption style="text-align: center;">IP-Adapter image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner_2.png" width="400" alt="generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',ll,D,ht="Take a look at the examples below to learn how to use IP-Adapter for other tasks.",tl,S,al,K,sl,O,Jt="There are two variants of IP-Adapter, Plus and FaceID. The Plus variant uses patch embeddings and the ViT-H image encoder. FaceID variant uses face embeddings generated from InsightFace.",il,N,nl,ee,pl,le,wt="The <code>prepare_ip_adapter_image_embeds</code> generates image embeddings you can reuse if you’re running the pipeline multiple times because you have more than one image. Loading and encoding multiple images each time you use the pipeline can be inefficient. Precomputing the image embeddings ahead of time, saving them to disk, and loading them when you need them is more efficient.",ol,te,ml,ae,Zt="Reload the image embeddings by passing them to the <code>ip_adapter_image_embeds</code> parameter. Set <code>image_encoder_folder</code> to <code>None</code> because you don’t need the image encoder anymore to generate the image embeddings.",rl,E,dl,se,cl,ie,Ml,ne,bt="Binary masking enables assigning an IP-Adapter image to a specific area of the output image, making it useful for composing multiple IP-Adapter images. Each IP-Adapter image requires a binary mask.",ul,pe,Tt='Load the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.image_processor.IPAdapterMaskProcessor">IPAdapterMaskProcessor</a> to preprocess the image masks. For the best results, provide the output <code>height</code> and <code>width</code> to ensure masks with different aspect ratios are appropriately sized. If the input masks already match the aspect ratio of the generated image, you don’t need to set the <code>height</code> and <code>width</code>.',yl,oe,gl,X,Ut='<figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask1.png" width="200" alt="mask 1"/> <figcaption style="text-align: center;">mask 1</figcaption></figure> <figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_mask2.png" width="200" alt="mask 2"/> <figcaption style="text-align: center;">mask 2</figcaption></figure>',fl,me,jt="Provide both the IP-Adapter images and their scales as a list. Pass the preprocessed masks to <code>cross_attention_kwargs</code> in the pipeline.",hl,re,Jl,Y,Wt='<div style="display: flex; gap: 10px; justify-content: space-around; align-items: flex-end;"><figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl1.png" width="400" alt="IP-Adapter image 1"/> <figcaption style="text-align: center;">IP-Adapter image 1</figcaption></figure> <figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_mask_girl2.png" width="400" alt="IP-Adapter image 2"/> <figcaption style="text-align: center;">IP-Adapter image 2</figcaption></figure></div> <div style="display: flex; gap: 10px; justify-content: space-around; align-items: flex-end;"><figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_attention_mask_result_seed_0.png" width="400" alt="Generated image with mask"/> <figcaption style="text-align: center;">generated with mask</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_no_attention_mask_result_seed_0.png" width="400" alt="Generated image without mask"/> <figcaption style="text-align: center;">generated without mask</figcaption></figure></div>',wl,de,Zl,ce,It="The section below covers some popular applications of IP-Adapter.",bl,Me,Tl,ue,Gt='Face generation and preserving its details can be challenging. To help generate more accurate faces, there are checkpoints specifically conditioned on images of cropped faces. You can find the face models in the <a href="https://huggingface.co/h94/IP-Adapter" rel="nofollow">h94/IP-Adapter</a> repository or the <a href="https://huggingface.co/h94/IP-Adapter-FaceID" rel="nofollow">h94/IP-Adapter-FaceID</a> repository. The FaceID checkpoints use the FaceID embeddings from <a href="https://github.com/deepinsight/insightface" rel="nofollow">InsightFace</a> instead of CLIP image embeddings.',Ul,ye,_t='We recommend using the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> for face models.',jl,H,Wl,ge,Il,fe,Bt="Combine multiple IP-Adapters to generate images in more diverse styles. For example, you can use IP-Adapter Face to generate consistent faces and characters and IP-Adapter Plus to generate those faces in specific styles.",Gl,he,Xt='Load an image encoder with <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPVisionModelWithProjection" rel="nofollow">CLIPVisionModelWithProjection</a>.',_l,Je,Bl,we,kt="Load a base model, scheduler and the following IP-Adapters.",Xl,Ze,Vt='<li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder</li> <li><a href="https://huggingface.co/h94/IP-Adapter#ip-adapter-for-sdxl-10" rel="nofollow">ip-adapter-plus-face_sdxl_vit-h</a> uses patch embeddings and a ViT-H image encoder but it is conditioned on images of cropped faces</li>',kl,be,Vl,Te,Rt="Load an image and a folder containing images of a certain style to apply.",Rl,Ue,Fl,k,Ft='<figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png" width="400" alt="Face image"/> <figcaption style="text-align: center;">face image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_style_grid.png" width="400" alt="Style images"/> <figcaption style="text-align: center;">style images</figcaption></figure>',Yl,je,Yt="Pass style and face images as a list to <code>ip_adapter_image</code>.",$l,We,Cl,v,$t='<figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ip_multi_out.png" width="400" alt="Generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',vl,Ie,Ql,Ge,Ct='<a href="../api/pipelines/latent_consistency_models">Latent Consistency Models (LCM)</a> can generate images 4 steps or less, unlike other diffusion models which require a lot more steps, making it feel “instantaneous”. IP-Adapters are compatible with LCM models to instantly generate images.',xl,_e,vt='Load the IP-Adapter weights and load the LoRA weights with <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a>.',Sl,Be,Nl,Xe,Qt="Try using a lower IP-Adapter scale to condition generation more on the style you want to apply and remember to use the special token in your prompt to trigger its generation.",El,ke,Hl,Q,xt='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_herge.png" width="400" alt="Generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',Al,Ve,ql,Re,St='For structural control, combine IP-Adapter with <a href="../api/pipelines/controlnet">ControlNet</a> conditioned on depth maps, edge maps, pose estimations, and more.',zl,Fe,Nt='The example below loads a <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a> checkpoint conditioned on depth maps and combines it with a IP-Adapter.',Ll,Ye,Pl,$e,Et="Pass the depth map and IP-Adapter image to the pipeline.",Dl,Ce,Kl,V,Ht='<figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/statue.png" width="300" alt="IP-Adapter image"/> <figcaption style="text-align: center;">IP-Adapter image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/depth.png" width="300" alt="Depth map"/> <figcaption style="text-align: center;">depth map</figcaption></figure> <figure><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ipa-controlnet-out.png" width="300" alt="Generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',Ol,ve,et,Qe,At='For style and layout control, combine IP-Adapter with <a href="https://huggingface.co/papers/2404.02733" rel="nofollow">InstantStyle</a>. InstantStyle separates <em>style</em> (color, texture, overall feel) and <em>content</em> from each other. It only applies the style in style-specific blocks of the model to prevent it from distorting other areas of an image. This generates images with stronger and more consistent styles and better control over the layout.',lt,xe,qt='The IP-Adapter is only activated for specific parts of the model. Use the <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.set_ip_adapter_scale">set_ip_adapter_scale()</a> method to scale the influence of the IP-Adapter in different layers. The example below activates the IP-Adapter in the second layer of the models down <code>block_2</code> and up <code>block_0</code>. Down <code>block_2</code> is where the IP-Adapter injects layout information and up <code>block_0</code> is where style is injected.',tt,Se,at,Ne,zt="Load the style image and generate an image.",st,Ee,it,R,Lt='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg" width="400" alt="Style image"/> <figcaption style="text-align: center;">style image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_style_layout.png" width="400" alt="Generated image"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',nt,He,Pt="You can also insert the IP-Adapter in all the model layers. This tends to generate images that focus more on the image prompt and may reduce the diversity of generated images. Only activate the IP-Adapter in up <code>block_0</code> or the style layer.",pt,A,ot,Ae,mt,F,Dt='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_style_only.png" width="400" alt="Generated image (style only)"/> <figcaption style="text-align: center;">style-layer generated image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_ip_adapter.png" width="400" alt="Generated image (IP-Adapter only)"/> <figcaption style="text-align: center;">all layers generated image</figcaption></figure>',rt,qe,dt,Le,ct;return m=new $({props:{title:"IP-Adapter",local:"ip-adapter",headingTag:"h1"}}),x=new Mt({props:{warning:!1,$$slots:{default:[Ma]},$$scope:{ctx:W}}}),z=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiUwQSklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjgp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForText2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>
)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.8</span>)`,wrap:!1}}),P=new I({props:{code:"aW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX2FkYXB0ZXJfZGluZXIucG5nJTIyKSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwb2xhciUyMGJlYXIlMjBzaXR0aW5nJTIwaW4lMjBhJTIwY2hhaXIlMjBkcmlua2luZyUyMGElMjBtaWxrc2hha2UlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJkZWZvcm1lZCUyQyUyMHVnbHklMkMlMjB3cm9uZyUyMHByb3BvcnRpb24lMkMlMjBsb3clMjByZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_adapter_diner.png&quot;</span>)
pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image=image,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),S=new ut({props:{id:"usage",options:["image-to-image","inpainting","video"],$$slots:{default:[fa]},$$scope:{ctx:W}}}),K=new $({props:{title:"Model variants",local:"model-variants",headingTag:"h2"}}),N=new ut({props:{id:"ipadapter-variants",options:["IP-Adapter Plus","IP-Adapter FaceID"],$$slots:{default:[wa]},$$scope:{ctx:W}}}),ee=new $({props:{title:"Image embeddings",local:"image-embeddings",headingTag:"h2"}}),te=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZV9lbWJlZHMlMjAlM0QlMjBwaXBlbGluZS5wcmVwYXJlX2lwX2FkYXB0ZXJfaW1hZ2VfZW1iZWRzKCUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2VfZW1iZWRzJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QxJTJDJTBBJTIwJTIwJTIwJTIwZG9fY2xhc3NpZmllcl9mcmVlX2d1aWRhbmNlJTNEVHJ1ZSUyQyUwQSklMEElMEF0b3JjaC5zYXZlKGltYWdlX2VtYmVkcyUyQyUyMCUyMmltYWdlX2VtYmVkcy5pcGFkcHQlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image

pipeline = AutoPipelineForImage2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image_embeds = pipeline.prepare_ip_adapter_image_embeds(
    ip_adapter_image=image,
    ip_adapter_image_embeds=<span class="hljs-literal">None</span>,
    device=<span class="hljs-string">&quot;cuda&quot;</span>,
    num_images_per_prompt=<span class="hljs-number">1</span>,
    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
)

torch.save(image_embeds, <span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)`,wrap:!1}}),E=new Mt({props:{warning:!1,$$slots:{default:[Za]},$$scope:{ctx:W}}}),se=new I({props:{code:"cGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMGltYWdlX2VuY29kZXJfZm9sZGVyJTNETm9uZSUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiUwQSklMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjgpJTBBaW1hZ2VfZW1iZWRzJTIwJTNEJTIwdG9yY2gubG9hZCglMjJpbWFnZV9lbWJlZHMuaXBhZHB0JTIyKSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRCUyMmElMjBwb2xhciUyMGJlYXIlMjBzaXR0aW5nJTIwaW4lMjBhJTIwY2hhaXIlMjBkcmlua2luZyUyMGElMjBtaWxrc2hha2UlMjIlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlX2VtYmVkcyUzRGltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMmRlZm9ybWVkJTJDJTIwdWdseSUyQyUyMHdyb25nJTIwcHJvcG9ydGlvbiUyQyUyMGxvdyUyMHJlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  image_encoder_folder=<span class="hljs-literal">None</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>
)
pipeline.set_ip_adapter_scale(<span class="hljs-number">0.8</span>)
image_embeds = torch.load(<span class="hljs-string">&quot;image_embeds.ipadpt&quot;</span>)
pipeline(
    prompt=<span class="hljs-string">&quot;a polar bear sitting in a chair drinking a milkshake&quot;</span>,
    ip_adapter_image_embeds=image_embeds,
    negative_prompt=<span class="hljs-string">&quot;deformed, ugly, wrong proportion, low res, bad anatomy, worst quality, low quality&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ie=new $({props:{title:"Masking",local:"masking",headingTag:"h2"}}),oe=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMuaW1hZ2VfcHJvY2Vzc29yJTIwaW1wb3J0JTIwSVBBZGFwdGVyTWFza1Byb2Nlc3NvciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQW1hc2sxJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX21hc2sxLnBuZyUyMiklMEFtYXNrMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaXBfbWFza19tYXNrMi5wbmclMjIpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwSVBBZGFwdGVyTWFza1Byb2Nlc3NvcigpJTBBbWFza3MlMjAlM0QlMjBwcm9jZXNzb3IucHJlcHJvY2VzcyglNUJtYXNrMSUyQyUyMG1hc2syJTVEJTJDJTIwaGVpZ2h0JTNEMTAyNCUyQyUyMHdpZHRoJTNEMTAyNCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> IPAdapterMaskProcessor
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForImage2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

mask1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask1.png&quot;</span>)
mask2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_mask2.png&quot;</span>)

processor = IPAdapterMaskProcessor()
masks = processor.preprocess([mask1, mask2], height=<span class="hljs-number">1024</span>, width=<span class="hljs-number">1024</span>)`,wrap:!1}}),re=new I({props:{code:"ZmFjZV9pbWFnZTElMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlwX21hc2tfZ2lybDEucG5nJTIyKSUwQWZhY2VfaW1hZ2UyJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpcF9tYXNrX2dpcmwyLnBuZyUyMiklMEElMEFwaXBlbGluZS5sb2FkX2lwX2FkYXB0ZXIoJTBBJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMHN1YmZvbGRlciUzRCUyMnNkeGxfbW9kZWxzJTIyJTJDJTBBJTIwJTIwd2VpZ2h0X25hbWUlM0QlNUIlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QiU1QjAuNyUyQyUyMDAuNyU1RCU1RCklMEElMEFpcF9pbWFnZXMlMjAlM0QlMjAlNUIlNUJmYWNlX2ltYWdlMSUyQyUyMGZhY2VfaW1hZ2UyJTVEJTVEJTBBbWFza3MlMjAlM0QlMjAlNUJtYXNrcy5yZXNoYXBlKDElMkMlMjBtYXNrcy5zaGFwZSU1QjAlNUQlMkMlMjBtYXNrcy5zaGFwZSU1QjIlNUQlMkMlMjBtYXNrcy5zaGFwZSU1QjMlNUQpJTVEJTBBJTBBcGlwZWxpbmUoJTBBJTIwJTIwcHJvbXB0JTNEJTIyMiUyMGdpcmxzJTIyJTJDJTBBJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2ltYWdlcyUyQyUwQSUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMm1vbm9jaHJvbWUlMkMlMjBsb3dyZXMlMkMlMjBiYWQlMjBhbmF0b215JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGNyb3NzX2F0dGVudGlvbl9rd2FyZ3MlM0QlN0IlMjJpcF9hZGFwdGVyX21hc2tzJTIyJTNBJTIwbWFza3MlN0QlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`face_image1 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl1.png&quot;</span>)
face_image2 = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/ip_mask_girl2.png&quot;</span>)

pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.7</span>]])

ip_images = [[face_image1, face_image2]]
masks = [masks.reshape(<span class="hljs-number">1</span>, masks.shape[<span class="hljs-number">0</span>], masks.shape[<span class="hljs-number">2</span>], masks.shape[<span class="hljs-number">3</span>])]

pipeline(
  prompt=<span class="hljs-string">&quot;2 girls&quot;</span>,
  ip_adapter_image=ip_images,
  negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
  cross_attention_kwargs={<span class="hljs-string">&quot;ip_adapter_masks&quot;</span>: masks}
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new $({props:{title:"Applications",local:"applications",headingTag:"h2"}}),Me=new $({props:{title:"Face models",local:"face-models",headingTag:"h3"}}),H=new ut({props:{id:"usage",options:["h94/IP-Adapter","h94/IP-Adapter-FaceID"],$$slots:{default:[Ua]},$$scope:{ctx:W}}}),ge=new $({props:{title:"Multiple IP-Adapters",local:"multiple-ip-adapters",headingTag:"h3"}}),Je=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUyQyUyMERESU1TY2hlZHVsZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQ0xJUFZpc2lvbk1vZGVsV2l0aFByb2plY3Rpb24lMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWltYWdlX2VuY29kZXIlMjAlM0QlMjBDTElQVmlzaW9uTW9kZWxXaXRoUHJvamVjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyaDk0JTJGSVAtQWRhcHRlciUyMiUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMm1vZGVscyUyRmltYWdlX2VuY29kZXIlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image, DDIMScheduler
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPVisionModelWithProjection
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image_encoder = CLIPVisionModelWithProjection.from_pretrained(
    <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
    subfolder=<span class="hljs-string">&quot;models/image_encoder&quot;</span>,
    torch_dtype=torch.float16,
)`,wrap:!1}}),be=new I({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBpbWFnZV9lbmNvZGVyJTNEaW1hZ2VfZW5jb2RlciUyQyUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTVCJTIyaXAtYWRhcHRlci1wbHVzX3NkeGxfdml0LWguc2FmZXRlbnNvcnMlMjIlMkMlMjAlMjJpcC1hZGFwdGVyLXBsdXMtZmFjZV9zZHhsX3ZpdC1oLnNhZmV0ZW5zb3JzJTIyJTVEJTBBKSUwQXBpcGVsaW5lLnNldF9pcF9hZGFwdGVyX3NjYWxlKCU1QjAuNyUyQyUyMDAuMyU1RCklMEElMjMlMjBlbmFibGVfbW9kZWxfY3B1X29mZmxvYWQlMjB0byUyMHJlZHVjZSUyMG1lbW9yeSUyMHVzYWdlJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCk=",highlighted:`pipeline = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
    image_encoder=image_encoder,
)
pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=[<span class="hljs-string">&quot;ip-adapter-plus_sdxl_vit-h.safetensors&quot;</span>, <span class="hljs-string">&quot;ip-adapter-plus-face_sdxl_vit-h.safetensors&quot;</span>]
)
pipeline.set_ip_adapter_scale([<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>])
<span class="hljs-comment"># enable_model_cpu_offload to reduce memory usage</span>
pipeline.enable_model_cpu_offload()`,wrap:!1}}),Ue=new I({props:{code:"ZmFjZV9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWWlZaVh1JTJGdGVzdGluZy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRndvbWVuX2lucHV0LnBuZyUyMiklMEFzdHlsZV9mb2xkZXIlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZZaVlpWHUlMkZ0ZXN0aW5nLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGc3R5bGVfemlnZ3klMjIlMEFzdHlsZV9pbWFnZXMlMjAlM0QlMjAlNUJsb2FkX2ltYWdlKGYlMjIlN0JzdHlsZV9mb2xkZXIlN0QlMkZpbWclN0JpJTdELnBuZyUyMiklMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQ=",highlighted:`face_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/women_input.png&quot;</span>)
style_folder = <span class="hljs-string">&quot;https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/style_ziggy&quot;</span>
style_images = [load_image(<span class="hljs-string">f&quot;<span class="hljs-subst">{style_folder}</span>/img<span class="hljs-subst">{i}</span>.png&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]`,wrap:!1}}),We=new I({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmNwdSUyMikubWFudWFsX3NlZWQoMCklMEElMEFwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJ3b25kZXJ3b21hbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0QlNUJzdHlsZV9pbWFnZXMlMkMlMjBmYWNlX2ltYWdlJTVEJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIybW9ub2Nocm9tZSUyQyUyMGxvd3JlcyUyQyUyMGJhZCUyMGFuYXRvbXklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBsb3clMjBxdWFsaXR5JTIyJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

pipeline(
    prompt=<span class="hljs-string">&quot;wonderwoman&quot;</span>,
    ip_adapter_image=[style_images, face_image],
    negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ie=new $({props:{title:"Instant generation",local:"instant-generation",headingTag:"h3"}}),Be=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnNkLWRyZWFtYm9vdGgtbGlicmFyeSUyRmhlcmdlLXN0eWxlJTIyJTJDJTBBJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQSUwQXBpcGVsaW5lLmxvYWRfaXBfYWRhcHRlciglMEElMjAlMjAlMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTBBJTIwJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTBBJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyJTBBKSUwQXBpcGVsaW5lLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEElMjMlMjBlbmFibGVfbW9kZWxfY3B1X29mZmxvYWQlMjB0byUyMHJlZHVjZSUyMG1lbW9yeSUyMHVzYWdlJTBBcGlwZWxpbmUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = DiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;sd-dreambooth-library/herge-style&quot;</span>,
  torch_dtype=torch.float16
)

pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>
)
pipeline.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)
pipeline.scheduler = LCMScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-comment"># enable_model_cpu_offload to reduce memory usage</span>
pipeline.enable_model_cpu_offload()`,wrap:!1}}),ke=new I({props:{code:"cGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoMC40KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmhlcmdlX3N0eWxlJTIwd29tYW4lMjBpbiUyMGFybW9yJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUwQSUwQWlwX2FkYXB0ZXJfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGdXNlci1pbWFnZXMuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGMjQ3MzQxNDIlMkYyNjY0OTI4NzUtMmQ1MGQyMjMtODQ3NS00NGYwLWE3YzYtMDhiNTFjYjUzNTcyLnBuZyUyMiklMEFwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpcF9hZGFwdGVyX2ltYWdlJTNEaXBfYWRhcHRlcl9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline.set_ip_adapter_scale(<span class="hljs-number">0.4</span>)

prompt = <span class="hljs-string">&quot;herge_style woman in armor, best quality, high quality&quot;</span>

ip_adapter_image = load_image(<span class="hljs-string">&quot;https://user-images.githubusercontent.com/24734142/266492875-2d50d223-8475-44f0-a7c6-08b51cb53572.png&quot;</span>)
pipeline(
    prompt=prompt,
    ip_adapter_image=ip_adapter_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Ve=new $({props:{title:"Structural control",local:"structural-control",headingTag:"h3"}}),Ye=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJsbGx5YXN2aWVsJTJGY29udHJvbF92MTFmMXBfc2QxNV9kZXB0aCUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMEElMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXJfc2QxNS5iaW4lMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel

controlnet = ControlNetModel.from_pretrained(
  <span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>,
  torch_dtype=torch.float16
)

pipeline = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    controlnet=controlnet,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>
)`,wrap:!1}}),Ce=new I({props:{code:"cGlwZWxpbmUoJTBBJTIwJTIwcHJvbXB0JTNEJTIyYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMGltYWdlJTNEZGVwdGhfbWFwJTJDJTBBJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGlwX2FkYXB0ZXJfaW1hZ2UlMkMlMEElMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`pipeline(
  prompt=<span class="hljs-string">&quot;best quality, high quality&quot;</span>,
  image=depth_map,
  ip_adapter_image=ip_adapter_image,
  negative_prompt=<span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ve=new $({props:{title:"Style and layout control",local:"style-and-layout-control",headingTag:"h3"}}),Se=new I({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9pcF9hZGFwdGVyKCUwQSUyMCUyMCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMEElMjAlMjBzdWJmb2xkZXIlM0QlMjJzZHhsX21vZGVscyUyMiUyQyUwQSUyMCUyMHdlaWdodF9uYW1lJTNEJTIyaXAtYWRhcHRlcl9zZHhsLmJpbiUyMiUwQSklMEElMEFzY2FsZSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmRvd24lMjIlM0ElMjAlN0IlMjJibG9ja18yJTIyJTNBJTIwJTVCMC4wJTJDJTIwMS4wJTVEJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIydXAlMjIlM0ElMjAlN0IlMjJibG9ja18wJTIyJTNBJTIwJTVCMC4wJTJDJTIwMS4wJTJDJTIwMC4wJTVEJTdEJTJDJTBBJTdEJTBBcGlwZWxpbmUuc2V0X2lwX2FkYXB0ZXJfc2NhbGUoc2NhbGUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = AutoPipelineForText2Image.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_ip_adapter(
  <span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>,
  subfolder=<span class="hljs-string">&quot;sdxl_models&quot;</span>,
  weight_name=<span class="hljs-string">&quot;ip-adapter_sdxl.bin&quot;</span>
)

scale = {
    <span class="hljs-string">&quot;down&quot;</span>: {<span class="hljs-string">&quot;block_2&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>]},
    <span class="hljs-string">&quot;up&quot;</span>: {<span class="hljs-string">&quot;block_0&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>]},
}
pipeline.set_ip_adapter_scale(scale)`,wrap:!1}}),Ee=new I({props:{code:"c3R5bGVfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGMDA1MmE3MGJlZWQ1YmY3MWI5MjYxMGE0M2E1MmRmNmQyODZjZDVmMyUyRmRpZmZ1c2VycyUyRnJhYmJpdC5qcGclMjIpJTBBJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYSUyMGNhdCUyQyUyMG1hc3RlcnBpZWNlJTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBoaWdoJTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RzdHlsZV9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMnRleHQlMkMlMjB3YXRlcm1hcmslMkMlMjBsb3dyZXMlMkMlMjBsb3clMjBxdWFsaXR5JTJDJTIwd29yc3QlMjBxdWFsaXR5JTJDJTIwZGVmb3JtZWQlMkMlMjBnbGl0Y2glMkMlMjBsb3clMjBjb250cmFzdCUyQyUyMG5vaXN5JTJDJTIwc2F0dXJhdGlvbiUyQyUyMGJsdXJyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNENSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`style_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg&quot;</span>)

pipeline(
    prompt=<span class="hljs-string">&quot;a cat, masterpiece, best quality, high quality&quot;</span>,
    ip_adapter_image=style_image,
    negative_prompt=<span class="hljs-string">&quot;text, watermark, lowres, low quality, worst quality, deformed, glitch, low contrast, noisy, saturation, blurry&quot;</span>,
    guidance_scale=<span class="hljs-number">5</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),A=new Mt({props:{warning:!1,$$slots:{default:[ja]},$$scope:{ctx:W}}}),Ae=new I({props:{code:"c2NhbGUlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ1cCUyMiUzQSUyMCU3QiUyMmJsb2NrXzAlMjIlM0ElMjAlNUIwLjAlMkMlMjAxLjAlMkMlMjAwLjAlNUQlN0QlMkMlMEElN0QlMEFwaXBlbGluZS5zZXRfaXBfYWRhcHRlcl9zY2FsZShzY2FsZSklMEElMEFwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJhJTIwY2F0JTJDJTIwbWFzdGVycGllY2UlMkMlMjBiZXN0JTIwcXVhbGl0eSUyQyUyMGhpZ2glMjBxdWFsaXR5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRHN0eWxlX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIydGV4dCUyQyUyMHdhdGVybWFyayUyQyUyMGxvd3JlcyUyQyUyMGxvdyUyMHF1YWxpdHklMkMlMjB3b3JzdCUyMHF1YWxpdHklMkMlMjBkZWZvcm1lZCUyQyUyMGdsaXRjaCUyQyUyMGxvdyUyMGNvbnRyYXN0JTJDJTIwbm9pc3klMkMlMjBzYXR1cmF0aW9uJTJDJTIwYmx1cnJ5JTIyJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q1JTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`scale = {
    <span class="hljs-string">&quot;up&quot;</span>: {<span class="hljs-string">&quot;block_0&quot;</span>: [<span class="hljs-number">0.0</span>, <span class="hljs-number">1.0</span>, <span class="hljs-number">0.0</span>]},
}
pipeline.set_ip_adapter_scale(scale)

pipeline(
    prompt=<span class="hljs-string">&quot;a cat, masterpiece, best quality, high quality&quot;</span>,
    ip_adapter_image=style_image,
    negative_prompt=<span class="hljs-string">&quot;text, watermark, lowres, low quality, worst quality, deformed, glitch, low contrast, noisy, saturation, blurry&quot;</span>,
    guidance_scale=<span class="hljs-number">5</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),qe=new ca({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/ip_adapter.md"}}),{c(){s=u("meta"),d=p(),i=u("p"),c=p(),f(m.$$.fragment),n=p(),r=u("p"),r.innerHTML=M,U=p(),G=u("p"),G.innerHTML=j,_=p(),f(x.$$.fragment),Pe=p(),q=u("p"),q.innerHTML=yt,De=p(),f(z.$$.fragment),Ke=p(),L=u("p"),L.innerHTML=gt,Oe=p(),f(P.$$.fragment),el=p(),B=u("div"),B.innerHTML=ft,ll=p(),D=u("p"),D.textContent=ht,tl=p(),f(S.$$.fragment),al=p(),f(K.$$.fragment),sl=p(),O=u("p"),O.textContent=Jt,il=p(),f(N.$$.fragment),nl=p(),f(ee.$$.fragment),pl=p(),le=u("p"),le.innerHTML=wt,ol=p(),f(te.$$.fragment),ml=p(),ae=u("p"),ae.innerHTML=Zt,rl=p(),f(E.$$.fragment),dl=p(),f(se.$$.fragment),cl=p(),f(ie.$$.fragment),Ml=p(),ne=u("p"),ne.textContent=bt,ul=p(),pe=u("p"),pe.innerHTML=Tt,yl=p(),f(oe.$$.fragment),gl=p(),X=u("div"),X.innerHTML=Ut,fl=p(),me=u("p"),me.innerHTML=jt,hl=p(),f(re.$$.fragment),Jl=p(),Y=u("div"),Y.innerHTML=Wt,wl=p(),f(de.$$.fragment),Zl=p(),ce=u("p"),ce.textContent=It,bl=p(),f(Me.$$.fragment),Tl=p(),ue=u("p"),ue.innerHTML=Gt,Ul=p(),ye=u("p"),ye.innerHTML=_t,jl=p(),f(H.$$.fragment),Wl=p(),f(ge.$$.fragment),Il=p(),fe=u("p"),fe.textContent=Bt,Gl=p(),he=u("p"),he.innerHTML=Xt,_l=p(),f(Je.$$.fragment),Bl=p(),we=u("p"),we.textContent=kt,Xl=p(),Ze=u("ul"),Ze.innerHTML=Vt,kl=p(),f(be.$$.fragment),Vl=p(),Te=u("p"),Te.textContent=Rt,Rl=p(),f(Ue.$$.fragment),Fl=p(),k=u("div"),k.innerHTML=Ft,Yl=p(),je=u("p"),je.innerHTML=Yt,$l=p(),f(We.$$.fragment),Cl=p(),v=u("div"),v.innerHTML=$t,vl=p(),f(Ie.$$.fragment),Ql=p(),Ge=u("p"),Ge.innerHTML=Ct,xl=p(),_e=u("p"),_e.innerHTML=vt,Sl=p(),f(Be.$$.fragment),Nl=p(),Xe=u("p"),Xe.textContent=Qt,El=p(),f(ke.$$.fragment),Hl=p(),Q=u("div"),Q.innerHTML=xt,Al=p(),f(Ve.$$.fragment),ql=p(),Re=u("p"),Re.innerHTML=St,zl=p(),Fe=u("p"),Fe.innerHTML=Nt,Ll=p(),f(Ye.$$.fragment),Pl=p(),$e=u("p"),$e.textContent=Et,Dl=p(),f(Ce.$$.fragment),Kl=p(),V=u("div"),V.innerHTML=Ht,Ol=p(),f(ve.$$.fragment),et=p(),Qe=u("p"),Qe.innerHTML=At,lt=p(),xe=u("p"),xe.innerHTML=qt,tt=p(),f(Se.$$.fragment),at=p(),Ne=u("p"),Ne.textContent=zt,st=p(),f(Ee.$$.fragment),it=p(),R=u("div"),R.innerHTML=Lt,nt=p(),He=u("p"),He.innerHTML=Pt,pt=p(),f(A.$$.fragment),ot=p(),f(Ae.$$.fragment),mt=p(),F=u("div"),F.innerHTML=Dt,rt=p(),f(qe.$$.fragment),dt=p(),Le=u("p"),this.h()},l(e){const l=ra("svelte-u9bgzb",document.head);s=y(l,"META",{name:!0,content:!0}),l.forEach(t),d=o(e),i=y(e,"P",{}),sa(i).forEach(t),c=o(e),h(m.$$.fragment,e),n=o(e),r=y(e,"P",{"data-svelte-h":!0}),g(r)!=="svelte-lv4dxu"&&(r.innerHTML=M),U=o(e),G=y(e,"P",{"data-svelte-h":!0}),g(G)!=="svelte-145huch"&&(G.innerHTML=j),_=o(e),h(x.$$.fragment,e),Pe=o(e),q=y(e,"P",{"data-svelte-h":!0}),g(q)!=="svelte-iwas5e"&&(q.innerHTML=yt),De=o(e),h(z.$$.fragment,e),Ke=o(e),L=y(e,"P",{"data-svelte-h":!0}),g(L)!=="svelte-1wker05"&&(L.innerHTML=gt),Oe=o(e),h(P.$$.fragment,e),el=o(e),B=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(B)!=="svelte-295lls"&&(B.innerHTML=ft),ll=o(e),D=y(e,"P",{"data-svelte-h":!0}),g(D)!=="svelte-12n8oag"&&(D.textContent=ht),tl=o(e),h(S.$$.fragment,e),al=o(e),h(K.$$.fragment,e),sl=o(e),O=y(e,"P",{"data-svelte-h":!0}),g(O)!=="svelte-9uieuk"&&(O.textContent=Jt),il=o(e),h(N.$$.fragment,e),nl=o(e),h(ee.$$.fragment,e),pl=o(e),le=y(e,"P",{"data-svelte-h":!0}),g(le)!=="svelte-hpizde"&&(le.innerHTML=wt),ol=o(e),h(te.$$.fragment,e),ml=o(e),ae=y(e,"P",{"data-svelte-h":!0}),g(ae)!=="svelte-17yemw9"&&(ae.innerHTML=Zt),rl=o(e),h(E.$$.fragment,e),dl=o(e),h(se.$$.fragment,e),cl=o(e),h(ie.$$.fragment,e),Ml=o(e),ne=y(e,"P",{"data-svelte-h":!0}),g(ne)!=="svelte-1btur7m"&&(ne.textContent=bt),ul=o(e),pe=y(e,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-1rivkhw"&&(pe.innerHTML=Tt),yl=o(e),h(oe.$$.fragment,e),gl=o(e),X=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(X)!=="svelte-8iu0me"&&(X.innerHTML=Ut),fl=o(e),me=y(e,"P",{"data-svelte-h":!0}),g(me)!=="svelte-bmwit0"&&(me.innerHTML=jt),hl=o(e),h(re.$$.fragment,e),Jl=o(e),Y=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(Y)!=="svelte-1cx2gkd"&&(Y.innerHTML=Wt),wl=o(e),h(de.$$.fragment,e),Zl=o(e),ce=y(e,"P",{"data-svelte-h":!0}),g(ce)!=="svelte-1j6fwoj"&&(ce.textContent=It),bl=o(e),h(Me.$$.fragment,e),Tl=o(e),ue=y(e,"P",{"data-svelte-h":!0}),g(ue)!=="svelte-jdscb4"&&(ue.innerHTML=Gt),Ul=o(e),ye=y(e,"P",{"data-svelte-h":!0}),g(ye)!=="svelte-nblulr"&&(ye.innerHTML=_t),jl=o(e),h(H.$$.fragment,e),Wl=o(e),h(ge.$$.fragment,e),Il=o(e),fe=y(e,"P",{"data-svelte-h":!0}),g(fe)!=="svelte-8t9z4d"&&(fe.textContent=Bt),Gl=o(e),he=y(e,"P",{"data-svelte-h":!0}),g(he)!=="svelte-1rlgp6a"&&(he.innerHTML=Xt),_l=o(e),h(Je.$$.fragment,e),Bl=o(e),we=y(e,"P",{"data-svelte-h":!0}),g(we)!=="svelte-12sbcxj"&&(we.textContent=kt),Xl=o(e),Ze=y(e,"UL",{"data-svelte-h":!0}),g(Ze)!=="svelte-14lybvh"&&(Ze.innerHTML=Vt),kl=o(e),h(be.$$.fragment,e),Vl=o(e),Te=y(e,"P",{"data-svelte-h":!0}),g(Te)!=="svelte-1lm8xpa"&&(Te.textContent=Rt),Rl=o(e),h(Ue.$$.fragment,e),Fl=o(e),k=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(k)!=="svelte-1fqw2fw"&&(k.innerHTML=Ft),Yl=o(e),je=y(e,"P",{"data-svelte-h":!0}),g(je)!=="svelte-1f9ayt4"&&(je.innerHTML=Yt),$l=o(e),h(We.$$.fragment,e),Cl=o(e),v=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(v)!=="svelte-1vyi3xu"&&(v.innerHTML=$t),vl=o(e),h(Ie.$$.fragment,e),Ql=o(e),Ge=y(e,"P",{"data-svelte-h":!0}),g(Ge)!=="svelte-gtun4"&&(Ge.innerHTML=Ct),xl=o(e),_e=y(e,"P",{"data-svelte-h":!0}),g(_e)!=="svelte-1329zmn"&&(_e.innerHTML=vt),Sl=o(e),h(Be.$$.fragment,e),Nl=o(e),Xe=y(e,"P",{"data-svelte-h":!0}),g(Xe)!=="svelte-9f9j6q"&&(Xe.textContent=Qt),El=o(e),h(ke.$$.fragment,e),Hl=o(e),Q=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(Q)!=="svelte-uhx8ym"&&(Q.innerHTML=xt),Al=o(e),h(Ve.$$.fragment,e),ql=o(e),Re=y(e,"P",{"data-svelte-h":!0}),g(Re)!=="svelte-f8td34"&&(Re.innerHTML=St),zl=o(e),Fe=y(e,"P",{"data-svelte-h":!0}),g(Fe)!=="svelte-1c3mmhb"&&(Fe.innerHTML=Nt),Ll=o(e),h(Ye.$$.fragment,e),Pl=o(e),$e=y(e,"P",{"data-svelte-h":!0}),g($e)!=="svelte-1grcvlc"&&($e.textContent=Et),Dl=o(e),h(Ce.$$.fragment,e),Kl=o(e),V=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(V)!=="svelte-11joxfd"&&(V.innerHTML=Ht),Ol=o(e),h(ve.$$.fragment,e),et=o(e),Qe=y(e,"P",{"data-svelte-h":!0}),g(Qe)!=="svelte-znjjtu"&&(Qe.innerHTML=At),lt=o(e),xe=y(e,"P",{"data-svelte-h":!0}),g(xe)!=="svelte-1n7mj5h"&&(xe.innerHTML=qt),tt=o(e),h(Se.$$.fragment,e),at=o(e),Ne=y(e,"P",{"data-svelte-h":!0}),g(Ne)!=="svelte-a2xkl9"&&(Ne.textContent=zt),st=o(e),h(Ee.$$.fragment,e),it=o(e),R=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(R)!=="svelte-1i6rw5e"&&(R.innerHTML=Lt),nt=o(e),He=y(e,"P",{"data-svelte-h":!0}),g(He)!=="svelte-1z0qe12"&&(He.innerHTML=Pt),pt=o(e),h(A.$$.fragment,e),ot=o(e),h(Ae.$$.fragment,e),mt=o(e),F=y(e,"DIV",{style:!0,"data-svelte-h":!0}),g(F)!=="svelte-sniway"&&(F.innerHTML=Dt),rt=o(e),h(qe.$$.fragment,e),dt=o(e),Le=y(e,"P",{}),sa(Le).forEach(t),this.h()},h(){ia(s,"name","hf:doc:metadata"),ia(s,"content",Ia),T(B,"display","flex"),T(B,"gap","10px"),T(B,"justify-content","space-around"),T(B,"align-items","flex-end"),T(X,"display","flex"),T(X,"gap","10px"),T(X,"justify-content","space-around"),T(X,"align-items","flex-end"),T(Y,"display","flex"),T(Y,"flex-direction","column"),T(Y,"gap","10px"),T(k,"display","flex"),T(k,"gap","10px"),T(k,"justify-content","space-around"),T(k,"align-items","flex-end"),T(v,"display","flex"),T(v,"justify-content","center"),T(Q,"display","flex"),T(Q,"justify-content","center"),T(V,"display","flex"),T(V,"gap","10px"),T(V,"justify-content","space-around"),T(V,"align-items","flex-end"),T(R,"display","flex"),T(R,"gap","10px"),T(R,"justify-content","space-around"),T(R,"align-items","flex-end"),T(F,"display","flex"),T(F,"gap","10px"),T(F,"justify-content","space-around"),T(F,"align-items","flex-end")},m(e,l){da(document.head,s),a(e,d,l),a(e,i,l),a(e,c,l),J(m,e,l),a(e,n,l),a(e,r,l),a(e,U,l),a(e,G,l),a(e,_,l),J(x,e,l),a(e,Pe,l),a(e,q,l),a(e,De,l),J(z,e,l),a(e,Ke,l),a(e,L,l),a(e,Oe,l),J(P,e,l),a(e,el,l),a(e,B,l),a(e,ll,l),a(e,D,l),a(e,tl,l),J(S,e,l),a(e,al,l),J(K,e,l),a(e,sl,l),a(e,O,l),a(e,il,l),J(N,e,l),a(e,nl,l),J(ee,e,l),a(e,pl,l),a(e,le,l),a(e,ol,l),J(te,e,l),a(e,ml,l),a(e,ae,l),a(e,rl,l),J(E,e,l),a(e,dl,l),J(se,e,l),a(e,cl,l),J(ie,e,l),a(e,Ml,l),a(e,ne,l),a(e,ul,l),a(e,pe,l),a(e,yl,l),J(oe,e,l),a(e,gl,l),a(e,X,l),a(e,fl,l),a(e,me,l),a(e,hl,l),J(re,e,l),a(e,Jl,l),a(e,Y,l),a(e,wl,l),J(de,e,l),a(e,Zl,l),a(e,ce,l),a(e,bl,l),J(Me,e,l),a(e,Tl,l),a(e,ue,l),a(e,Ul,l),a(e,ye,l),a(e,jl,l),J(H,e,l),a(e,Wl,l),J(ge,e,l),a(e,Il,l),a(e,fe,l),a(e,Gl,l),a(e,he,l),a(e,_l,l),J(Je,e,l),a(e,Bl,l),a(e,we,l),a(e,Xl,l),a(e,Ze,l),a(e,kl,l),J(be,e,l),a(e,Vl,l),a(e,Te,l),a(e,Rl,l),J(Ue,e,l),a(e,Fl,l),a(e,k,l),a(e,Yl,l),a(e,je,l),a(e,$l,l),J(We,e,l),a(e,Cl,l),a(e,v,l),a(e,vl,l),J(Ie,e,l),a(e,Ql,l),a(e,Ge,l),a(e,xl,l),a(e,_e,l),a(e,Sl,l),J(Be,e,l),a(e,Nl,l),a(e,Xe,l),a(e,El,l),J(ke,e,l),a(e,Hl,l),a(e,Q,l),a(e,Al,l),J(Ve,e,l),a(e,ql,l),a(e,Re,l),a(e,zl,l),a(e,Fe,l),a(e,Ll,l),J(Ye,e,l),a(e,Pl,l),a(e,$e,l),a(e,Dl,l),J(Ce,e,l),a(e,Kl,l),a(e,V,l),a(e,Ol,l),J(ve,e,l),a(e,et,l),a(e,Qe,l),a(e,lt,l),a(e,xe,l),a(e,tt,l),J(Se,e,l),a(e,at,l),a(e,Ne,l),a(e,st,l),J(Ee,e,l),a(e,it,l),a(e,R,l),a(e,nt,l),a(e,He,l),a(e,pt,l),J(A,e,l),a(e,ot,l),J(Ae,e,l),a(e,mt,l),a(e,F,l),a(e,rt,l),J(qe,e,l),a(e,dt,l),a(e,Le,l),ct=!0},p(e,[l]){const Kt={};l&2&&(Kt.$$scope={dirty:l,ctx:e}),x.$set(Kt);const Ot={};l&2&&(Ot.$$scope={dirty:l,ctx:e}),S.$set(Ot);const ea={};l&2&&(ea.$$scope={dirty:l,ctx:e}),N.$set(ea);const la={};l&2&&(la.$$scope={dirty:l,ctx:e}),E.$set(la);const ta={};l&2&&(ta.$$scope={dirty:l,ctx:e}),H.$set(ta);const aa={};l&2&&(aa.$$scope={dirty:l,ctx:e}),A.$set(aa)},i(e){ct||(w(m.$$.fragment,e),w(x.$$.fragment,e),w(z.$$.fragment,e),w(P.$$.fragment,e),w(S.$$.fragment,e),w(K.$$.fragment,e),w(N.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(E.$$.fragment,e),w(se.$$.fragment,e),w(ie.$$.fragment,e),w(oe.$$.fragment,e),w(re.$$.fragment,e),w(de.$$.fragment,e),w(Me.$$.fragment,e),w(H.$$.fragment,e),w(ge.$$.fragment,e),w(Je.$$.fragment,e),w(be.$$.fragment,e),w(Ue.$$.fragment,e),w(We.$$.fragment,e),w(Ie.$$.fragment,e),w(Be.$$.fragment,e),w(ke.$$.fragment,e),w(Ve.$$.fragment,e),w(Ye.$$.fragment,e),w(Ce.$$.fragment,e),w(ve.$$.fragment,e),w(Se.$$.fragment,e),w(Ee.$$.fragment,e),w(A.$$.fragment,e),w(Ae.$$.fragment,e),w(qe.$$.fragment,e),ct=!0)},o(e){Z(m.$$.fragment,e),Z(x.$$.fragment,e),Z(z.$$.fragment,e),Z(P.$$.fragment,e),Z(S.$$.fragment,e),Z(K.$$.fragment,e),Z(N.$$.fragment,e),Z(ee.$$.fragment,e),Z(te.$$.fragment,e),Z(E.$$.fragment,e),Z(se.$$.fragment,e),Z(ie.$$.fragment,e),Z(oe.$$.fragment,e),Z(re.$$.fragment,e),Z(de.$$.fragment,e),Z(Me.$$.fragment,e),Z(H.$$.fragment,e),Z(ge.$$.fragment,e),Z(Je.$$.fragment,e),Z(be.$$.fragment,e),Z(Ue.$$.fragment,e),Z(We.$$.fragment,e),Z(Ie.$$.fragment,e),Z(Be.$$.fragment,e),Z(ke.$$.fragment,e),Z(Ve.$$.fragment,e),Z(Ye.$$.fragment,e),Z(Ce.$$.fragment,e),Z(ve.$$.fragment,e),Z(Se.$$.fragment,e),Z(Ee.$$.fragment,e),Z(A.$$.fragment,e),Z(Ae.$$.fragment,e),Z(qe.$$.fragment,e),ct=!1},d(e){e&&(t(d),t(i),t(c),t(n),t(r),t(U),t(G),t(_),t(Pe),t(q),t(De),t(Ke),t(L),t(Oe),t(el),t(B),t(ll),t(D),t(tl),t(al),t(sl),t(O),t(il),t(nl),t(pl),t(le),t(ol),t(ml),t(ae),t(rl),t(dl),t(cl),t(Ml),t(ne),t(ul),t(pe),t(yl),t(gl),t(X),t(fl),t(me),t(hl),t(Jl),t(Y),t(wl),t(Zl),t(ce),t(bl),t(Tl),t(ue),t(Ul),t(ye),t(jl),t(Wl),t(Il),t(fe),t(Gl),t(he),t(_l),t(Bl),t(we),t(Xl),t(Ze),t(kl),t(Vl),t(Te),t(Rl),t(Fl),t(k),t(Yl),t(je),t($l),t(Cl),t(v),t(vl),t(Ql),t(Ge),t(xl),t(_e),t(Sl),t(Nl),t(Xe),t(El),t(Hl),t(Q),t(Al),t(ql),t(Re),t(zl),t(Fe),t(Ll),t(Pl),t($e),t(Dl),t(Kl),t(V),t(Ol),t(et),t(Qe),t(lt),t(xe),t(tt),t(at),t(Ne),t(st),t(it),t(R),t(nt),t(He),t(pt),t(ot),t(mt),t(F),t(rt),t(dt),t(Le)),t(s),b(m,e),b(x,e),b(z,e),b(P,e),b(S,e),b(K,e),b(N,e),b(ee,e),b(te,e),b(E,e),b(se,e),b(ie,e),b(oe,e),b(re,e),b(de,e),b(Me,e),b(H,e),b(ge,e),b(Je,e),b(be,e),b(Ue,e),b(We,e),b(Ie,e),b(Be,e),b(ke,e),b(Ve,e),b(Ye,e),b(Ce,e),b(ve,e),b(Se,e),b(Ee,e),b(A,e),b(Ae,e),b(qe,e)}}}const Ia='{"title":"IP-Adapter","local":"ip-adapter","sections":[{"title":"Model variants","local":"model-variants","sections":[],"depth":2},{"title":"Image embeddings","local":"image-embeddings","sections":[],"depth":2},{"title":"Masking","local":"masking","sections":[],"depth":2},{"title":"Applications","local":"applications","sections":[{"title":"Face models","local":"face-models","sections":[],"depth":3},{"title":"Multiple IP-Adapters","local":"multiple-ip-adapters","sections":[],"depth":3},{"title":"Instant generation","local":"instant-generation","sections":[],"depth":3},{"title":"Structural control","local":"structural-control","sections":[],"depth":3},{"title":"Style and layout control","local":"style-and-layout-control","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ga(W){return pa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends oa{constructor(s){super(),ma(this,s,Ga,Wa,na,{})}}export{Fa as component};
