import{s as ut,o as gt,n as yt}from"../chunks/scheduler.18a86fab.js";import{S as vt,i as ft,g as p,s as n,r as M,m as u,H as ms,A as Mt,h as i,f as t,c as l,j as Ms,u as w,x as m,n as g,B as cs,k as ja,y as c,a as e,v as b,d as x,t as _,w as T}from"../chunks/index.98837b22.js";import{T as wt}from"../chunks/Tip.77304350.js";import{C as fa}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as ws}from"../chunks/Heading.7e7e0c5b.js";import{E as bt}from"../chunks/index.92f616ba.js";function xt(bs){let r,J="Caching should only be used for <strong>inference</strong>. It may cause unexpected errors if it’s enabled during training.";return{c(){r=p("p"),r.innerHTML=J},l(y){r=i(y,"P",{"data-svelte-h":!0}),m(r)!=="svelte-16dnkl8"&&(r.innerHTML=J)},m(y,rs){e(y,r,rs)},p:yt,d(y){y&&t(r)}}}function _t(bs){let r,J,y,rs,C,xs,j,za="Imagine you’re having a conversation with someone, and instead of remembering what they previously said, they have to start from scratch every time you respond. This would be slow and inefficient, right?",_s,z,Za="You can extend this analogy to transformer models. Autoregressive model generation can be slow because it makes a prediction one token at a time. Each new prediction is dependent on all the previous context.",Ts,Z,Xa="To predict the 1000th token, the model requires information from the previous 999 tokens. The information is represented as matrix multiplications across the token representations.",ks,X,Va="To predict the 1001th token, you need the same information from the previous 999 tokens in addition to any information from the 1000th token. This is a lot of matrix multiplications a model has to compute over and over for each token!",Us,V,Ra="A key-value (KV) cache eliminates this inefficiency by storing kv pairs derived from the attention layers of previously processed tokens. The stored kv pairs are retrieved from the cache and reused for subsequent tokens, avoiding the need to recompute.",Js,k,Cs,R,Ba="To better understand how and why caching works, let’s take a closer look at the structure of the attention matrices.",js,B,zs,o,Ma,os,Ga="scaled dot-product attention",wa,hs,Wa="b",ba,ds,Ia="h",xa,us,Ha="T",_a,gs,Ya="d_head",Ta,Zs,it=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext>Attention</mtext><mo stretchy="false">(</mo><mi>Q</mi><mo separator="true">,</mo><mi>K</mi><mo separator="true">,</mo><mi>V</mi><mo stretchy="false">)</mo><mo>=</mo><mtext>softmax</mtext><mrow><mo fence="true">(</mo><mfrac><mrow><mi>Q</mi><msup><mi>K</mi><mi mathvariant="normal">⊤</mi></msup></mrow><msqrt><msub><mi>d</mi><mtext>head</mtext></msub></msqrt></mfrac><mo>×</mo><mtext>mask</mtext><mo fence="true">)</mo></mrow><mi>V</mi></mrow><annotation encoding="application/x-tex">
\\text{Attention}(Q, K, V) = \\text{softmax}\\left( \\frac{Q K^\\top}{\\sqrt{d_{\\text{head}}}} \\times \\text{mask} \\right) V
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Attention</span></span><span class="mopen">(</span><span class="mord mathnormal">Q</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">V</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.4761em;vertical-align:-0.95em;"></span><span class="mord text"><span class="mord">softmax</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size3">(</span></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.5261em;"><span style="top:-2.2528em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord sqrt"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8572em;"><span class="svg-align" style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord" style="padding-left:0.833em;"><span class="mord"><span class="mord mathnormal">d</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">head</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-2.8172em;"><span class="pstrut" style="height:3em;"></span><span class="hide-tail" style="min-width:0.853em;height:1.08em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='1.08em' viewBox='0 0 400000 1080' preserveAspectRatio='xMinYMin slice'><path d='M95,702
c-2.7,0,-7.17,-2.7,-13.5,-8c-5.8,-5.3,-9.5,-10,-9.5,-14
c0,-2,0.3,-3.3,1,-4c1.3,-2.7,23.83,-20.7,67.5,-54
c44.2,-33.3,65.8,-50.3,66.5,-51c1.3,-1.3,3,-2,5,-2c4.7,0,8.7,3.3,12,10
s173,378,173,378c0.7,0,35.3,-71,104,-213c68.7,-142,137.5,-285,206.5,-429
c69,-144,104.5,-217.7,106.5,-221
l0 -0
c5.3,-9.3,12,-14,20,-14
H400000v40H845.2724
s-225.272,467,-225.272,467s-235,486,-235,486c-2.7,4.7,-9,7,-19,7
c-6,0,-10,-1,-12,-3s-194,-422,-194,-422s-65,47,-65,47z
M834 80h400000v40h-400000z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1828em;"><span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">⊤</span></span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.93em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord text"><span class="mord">mask</span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size3">)</span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">V</span></span></span></span></span>`,Xs,G,Na="The query (<code>Q</code>), key (<code>K</code>), and value (<code>V</code>) matrices are projections from the input embeddings of shape <code>(b, h, T, d_head)</code>.",Vs,v,ka,Rs,mt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>K</mi><mtext>past</mtext></msub></mrow><annotation encoding="application/x-tex"> K_{\\text{past}} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9694em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0715em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">past</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Bs,Gs,ct='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>V</mi><mtext>past</mtext></msub></mrow><annotation encoding="application/x-tex"> V_{\\text{past}} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9694em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.22222em;">V</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.2222em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">past</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Ws,Is,rt=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext>Attention</mtext><mo stretchy="false">(</mo><msub><mi>q</mi><mi>t</mi></msub><mo separator="true">,</mo><mo stretchy="false">[</mo><munder><munder><mrow><msub><mi>k</mi><mn>1</mn></msub><mo separator="true">,</mo><msub><mi>k</mi><mn>2</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>k</mi><mrow><mi>t</mi><mo>−</mo><mn>1</mn></mrow></msub></mrow><mo stretchy="true">⏟</mo></munder><mtext>cached</mtext></munder><mo separator="true">,</mo><msub><mi>k</mi><mi>t</mi></msub><mo stretchy="false">]</mo><mo separator="true">,</mo><mo stretchy="false">[</mo><munder><munder><mrow><msub><mi>v</mi><mn>1</mn></msub><mo separator="true">,</mo><msub><mi>v</mi><mn>2</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>v</mi><mrow><mi>t</mi><mo>−</mo><mn>1</mn></mrow></msub></mrow><mo stretchy="true">⏟</mo></munder><mtext>cached</mtext></munder><mo separator="true">,</mo><msub><mi>v</mi><mi>t</mi></msub><mo stretchy="false">]</mo><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">
\\text{Attention}(q_t, [\\underbrace{k_1, k_2, \\dots, k_{t-1}}_{\\text{cached}}, k_{t}], [\\underbrace{v_1, v_2, \\dots, v_{t-1}}_{\\text{cached}}, v_{t}])
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:2.2924em;vertical-align:-1.5424em;"></span><span class="mord text"><span class="mord">Attention</span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mopen">[</span><span class="mord munder"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span style="top:-1.4576em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">cached</span></span></span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord munder"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6944em;"><span class="svg-align" style="top:-2.1437em;"><span class="pstrut" style="height:3em;"></span><span class="stretchy" style="height:0.548em;min-width:1.6em;"><span class="brace-left" style="height:0.548em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='0.548em' viewBox='0 0 400000 548' preserveAspectRatio='xMinYMin slice'><path d='M0 6l6-6h17c12.688 0 19.313.3 20 1 4 4 7.313 8.3 10 13
 35.313 51.3 80.813 93.8 136.5 127.5 55.688 33.7 117.188 55.8 184.5 66.5.688
 0 2 .3 4 1 18.688 2.7 76 4.3 172 5h399450v120H429l-6-1c-124.688-8-235-61.7
-331-161C60.687 138.7 32.312 99.3 7 54L0 41V6z'/></svg></span><span class="brace-center" style="height:0.548em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='0.548em' viewBox='0 0 400000 548' preserveAspectRatio='xMidYMin slice'><path d='M199572 214
c100.7 8.3 195.3 44 280 108 55.3 42 101.7 93 139 153l9 14c2.7-4 5.7-8.7 9-14
 53.3-86.7 123.7-153 211-199 66.7-36 137.3-56.3 212-62h199568v120H200432c-178.3
 11.7-311.7 78.3-403 201-6 8-9.7 12-11 12-.7.7-6.7 1-18 1s-17.3-.3-18-1c-1.3 0
-5-4-11-12-44.7-59.3-101.3-106.3-170-141s-145.3-54.3-229-60H0V214z'/></svg></span><span class="brace-right" style="height:0.548em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='0.548em' viewBox='0 0 400000 548' preserveAspectRatio='xMaxYMin slice'><path d='M399994 0l6 6v35l-6 11c-56 104-135.3 181.3-238 232-57.3
 28.7-117 45-179 50H-300V214h399897c43.3-7 81-15 113-26 100.7-33 179.7-91 237
-174 2.7-5 6-9 10-13 .7-1 7.3-1 20-1h17z'/></svg></span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0315em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0315em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0315em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.8563em;"><span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.5424em;"><span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0315em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">]</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mopen">[</span><span class="mord munder"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.4306em;"><span style="top:-1.4576em;"><span class="pstrut" style="height:3em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">cached</span></span></span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord munder"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.4306em;"><span class="svg-align" style="top:-2.1437em;"><span class="pstrut" style="height:3em;"></span><span class="stretchy" style="height:0.548em;min-width:1.6em;"><span class="brace-left" style="height:0.548em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='0.548em' viewBox='0 0 400000 548' preserveAspectRatio='xMinYMin slice'><path d='M0 6l6-6h17c12.688 0 19.313.3 20 1 4 4 7.313 8.3 10 13
 35.313 51.3 80.813 93.8 136.5 127.5 55.688 33.7 117.188 55.8 184.5 66.5.688
 0 2 .3 4 1 18.688 2.7 76 4.3 172 5h399450v120H429l-6-1c-124.688-8-235-61.7
-331-161C60.687 138.7 32.312 99.3 7 54L0 41V6z'/></svg></span><span class="brace-center" style="height:0.548em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='0.548em' viewBox='0 0 400000 548' preserveAspectRatio='xMidYMin slice'><path d='M199572 214
c100.7 8.3 195.3 44 280 108 55.3 42 101.7 93 139 153l9 14c2.7-4 5.7-8.7 9-14
 53.3-86.7 123.7-153 211-199 66.7-36 137.3-56.3 212-62h199568v120H200432c-178.3
 11.7-311.7 78.3-403 201-6 8-9.7 12-11 12-.7.7-6.7 1-18 1s-17.3-.3-18-1c-1.3 0
-5-4-11-12-44.7-59.3-101.3-106.3-170-141s-145.3-54.3-229-60H0V214z'/></svg></span><span class="brace-right" style="height:0.548em;"><svg xmlns="http://www.w3.org/2000/svg" width='400em' height='0.548em' viewBox='0 0 400000 548' preserveAspectRatio='xMaxYMin slice'><path d='M399994 0l6 6v35l-6 11c-56 104-135.3 181.3-238 232-57.3
 28.7-117 45-179 50H-300V214h399897c43.3-7 81-15 113-26 100.7-33 179.7-91 237
-174 2.7-5 6-9 10-13 .7-1 7.3-1 20-1h17z'/></svg></span></span></span><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.8563em;"><span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.5424em;"><span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">])</span></span></span></span></span>`,Hs,d,Ua,Ys,ot='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>t</mi></msub></mrow><annotation encoding="application/x-tex"> x_t </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Ns,$s,ht='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>t</mi><mo>+</mo><mn>1</mn></mrow><annotation encoding="application/x-tex"> t+1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6984em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">t</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Qs,ys,$a="stored",Ja,vs,Qa="appended",Ca,Fs,dt=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mi>K</mi><mtext>cache</mtext></msub><mo>←</mo><mtext>concat</mtext><mo stretchy="false">(</mo><msub><mi>K</mi><mtext>past</mtext></msub><mo separator="true">,</mo><msub><mi>k</mi><mi>t</mi></msub><mo stretchy="false">)</mo><mo separator="true">,</mo><mspace width="1em"/><msub><mi>V</mi><mtext>cache</mtext></msub><mo>←</mo><mtext>concat</mtext><mo stretchy="false">(</mo><msub><mi>V</mi><mtext>past</mtext></msub><mo separator="true">,</mo><msub><mi>v</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">
K_{\\text{cache}} \\leftarrow \\text{concat}(K_{\\text{past}}, k_t), \\quad V_{\\text{cache}} \\leftarrow \\text{concat}(V_{\\text{past}}, v_t)
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.0715em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">cache</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">←</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0361em;vertical-align:-0.2861em;"></span><span class="mord text"><span class="mord">concat</span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0715em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">past</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0315em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mpunct">,</span><span class="mspace" style="margin-right:1em;"></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.22222em;">V</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.2222em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">cache</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">←</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0361em;vertical-align:-0.2861em;"></span><span class="mord text"><span class="mord">concat</span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.22222em;">V</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.2222em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord text mtight"><span class="mord mtight">past</span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span></span>`,Ls,W,Fa="Attention is calculated independently in each layer of the model, and caching is done on a per-layer basis.",Es,I,La="Refer to the table below to compare how caching improves efficiency.",qs,H,Ea="<thead><tr><th>without caching</th> <th>with caching</th> <th></th> <th></th> <th></th></tr></thead> <tbody><tr><td>for each step, recompute all previous <code>K</code> and <code>V</code></td> <td>for each step, only compute current <code>K</code> and <code>V</code></td> <td></td> <td></td> <td></td></tr> <tr><td>attention cost per step is <strong>quadratic</strong> with sequence length</td> <td>attention cost per step is <strong>linear</strong> with sequence length (memory grows linearly, but compute/token remains low)</td> <td></td> <td></td> <td></td></tr></tbody>",Ss,Y,As,N,qa="A basic KV cache interface takes a key and value tensor for the current token and returns the updated <code>K</code> and <code>V</code> tensors. This is internally managed by a model’s <code>forward</code> method.",Ks,$,Ds,Q,Sa='When you use Transformers’ <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> class, the self-attention module performs several critical steps to integrate past and present information.',Ps,F,Aa='<li><p>The attention module concatenates current kv pairs with past kv pairs stored in the cache. This creates attentions weights with the shape <code>(new_tokens_length, past_kv_length + new_tokens_length)</code>. The current and past kv pairs are essentially combined to compute the attention scores, ensuring a model is aware of previous context and the current input.</p></li> <li><p>When the <code>forward</code> method is called iteratively, it’s crucial that the attention mask shape matches the combined length of the past and current kv pairs. The attention mask should have the shape <code>(batch_size, past_kv_length + new_tokens_length)</code>. This is typically handled internally in <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, but if you want to implement your own generation loop with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a>, keep this in mind! The attention mask should hold the past and current token values.</p></li> <li><p>It is also important to be aware of the <code>cache_position</code>. This is important if you want to reuse a prefilled <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> with the <code>forward</code> method because you have to pass a valid <code>cache_position</code> value. This indicates the input positions in a sequence. <code>cache_position</code> is unaffected by padding, and it always adds one more position for each token. For example, if a kv cache contains 10 tokens - regardless of pad tokens - the cache position for the next token should be <code>torch.tensor([10])</code>.</p></li>',Os,L,sa,E,Ka='The actual storage of key-value pairs varies between cache implementations. As an example, consider the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a>.',aa,q,Da='In <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a>, the key-value pairs are stored as two lists of tensors. Each tensor in the lists have the shape <code>[batch_size, num_heads, seq_len, head_dim]</code>.',ta,S,Pa="<li><code>key_cache</code>: A list of tensors, one for each layer.</li> <li><code>value_cache</code>: A list of tensors, one for each layer.</li>",ea,A,Oa="When new tokens are processed:",na,K,st="<li>For each layer, the new key and value states are concatenated with the existing cache.</li>",la,D,pa,U,at="<li><p>The cache grows dynamically as more tokens are processed. The sequence length dimension (<code>seq_len</code>) increases with each new token.</p></li> <li><p>The cache maintains a count of seen tokens through <code>self._seen_tokens</code>. This is updated when the first layer processes a new token.</p></li>",ia,P,tt='The example below demonstrates how to create a generation loop with <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a>. As discussed, the attention mask is a concatenation of past and current token values and <code>1</code> is added to the cache position for the next token.',ma,O,ca,ss,ra,as,et='Before the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> class, the cache used to be stored as a tuple of tuples of tensors. This format is dynamic because it grows as text is generated, similar to <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a>.',oa,ts,nt="The legacy format is essentially the same data structure but organized differently.",ha,es,lt="<li>It’s a tuple of tuples, where each inner tuple contains the key and value tensors for a layer.</li> <li>The tensors have the same shape <code>[batch_size, num_heads, seq_len, head_dim]</code>.</li> <li>The format is less flexible and doesn’t support features like quantization or offloading.</li>",da,ns,pt='If your project depends on this legacy format, you can convert between <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache">DynamicCache</a> and a tuple of tuples as shown below with the <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache.from_legacy_cache">from_legacy_cache()</a> and <a href="/docs/transformers/main/en/internal/generation_utils#transformers.DynamicCache.to_legacy_cache">DynamicCache.to_legacy_cache()</a> functions. This is helpful if you have custom logic for manipulating a cache in a specific format.',ua,ls,ga,ps,ya,fs,va;return C=new ws({props:{title:"Caching",local:"caching",headingTag:"h1"}}),k=new wt({props:{warning:!0,$$slots:{default:[xt]},$$scope:{ctx:bs}}}),B=new ws({props:{title:"Attention matrices",local:"attention-matrices",headingTag:"h2"}}),Y=new ws({props:{title:"Cache class",local:"cache-class",headingTag:"h2"}}),$=new fa({props:{code:"bmV3X0slMkMlMjBuZXdfViUyMCUzRCUyMGNhY2hlLnVwZGF0ZShrX3QlMkMlMjB2X3QlMkMlMjBsYXllcl9pZHgpJTBBYXR0bl9vdXRwdXQlMjAlM0QlMjBhdHRuX2xheWVyX2lkeF9mbihxX3QlMkMlMjBuZXdfSyUyQyUyMG5ld19WKQ==",highlighted:`new_K, new_V = cache.update(k_t, v_t, layer_idx)
attn_output = attn_layer_idx_fn(q_t, new_K, new_V)`,wrap:!1}}),L=new ws({props:{title:"Cache storage implementation",local:"cache-storage-implementation",headingTag:"h2"}}),D=new fa({props:{code:"c2VsZi5rZXlfY2FjaGUlNUJsYXllcl9pZHglNUQlMjAlM0QlMjB0b3JjaC5jYXQoJTVCc2VsZi5rZXlfY2FjaGUlNUJsYXllcl9pZHglNUQlMkMlMjBrZXlfc3RhdGVzJTVEJTJDJTIwZGltJTNELTIpJTBBc2VsZi52YWx1ZV9jYWNoZSU1QmxheWVyX2lkeCU1RCUyMCUzRCUyMHRvcmNoLmNhdCglNUJzZWxmLnZhbHVlX2NhY2hlJTVCbGF5ZXJfaWR4JTVEJTJDJTIwdmFsdWVfc3RhdGVzJTVEJTJDJTIwZGltJTNELTIp",highlighted:`self.key_cache[layer_idx] = torch.cat([self.key_cache[layer_idx], key_states], dim=-<span class="hljs-number">2</span>)
self.value_cache[layer_idx] = torch.cat([self.value_cache[layer_idx], value_states], dim=-<span class="hljs-number">2</span>)`,wrap:!1}}),O=new fa({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

model_id = <span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>
model = AutoModelForCausalLM.from_pretrained(model_id, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(model_id)

past_key_values = DynamicCache()
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, what&#x27;s your name.&quot;</span>}]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

generated_ids = inputs.input_ids
cache_position = torch.arange(inputs.input_ids.shape[<span class="hljs-number">1</span>], dtype=torch.int64, device=<span class="hljs-string">&quot;cuda:0&quot;</span>)
max_new_tokens = <span class="hljs-number">10</span>

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(max_new_tokens):
    outputs = model(**inputs, cache_position=cache_position, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>)
    <span class="hljs-comment"># Greedily sample one next token</span>
    next_token_ids = outputs.logits[:, -<span class="hljs-number">1</span>:].argmax(-<span class="hljs-number">1</span>)
    generated_ids = torch.cat([generated_ids, next_token_ids], dim=-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Prepare inputs for the next generation step by leaving unprocessed tokens, in our case we have only one new token</span>
    <span class="hljs-comment"># and expanding attn mask for the new token, as explained above</span>
    attention_mask = inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>]
    attention_mask = torch.cat([attention_mask, attention_mask.new_ones((attention_mask.shape[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>))], dim=-<span class="hljs-number">1</span>)
    inputs = {<span class="hljs-string">&quot;input_ids&quot;</span>: next_token_ids, <span class="hljs-string">&quot;attention_mask&quot;</span>: attention_mask}
    cache_position = cache_position[-<span class="hljs-number">1</span>:] + <span class="hljs-number">1</span> <span class="hljs-comment"># add one more position for the next token</span>

<span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;[INST] Hello, what&#x27;s your name. [/INST]  Hello! My name is LLaMA,&quot;</span>`,wrap:!1}}),ss=new ws({props:{title:"Legacy cache format",local:"legacy-cache-format",headingTag:"h2"}}),ls=new fa({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwRHluYW1pY0NhY2hlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTItN2ItY2hhdC1oZiUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTGxhbWEtMi03Yi1jaGF0LWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBuYW1lJTIwaXMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBJTBBJTIzJTIwJTYwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTYwJTIwaXMlMjByZXF1aXJlZCUyMHRvJTIwcmV0dXJuJTIwdGhlJTIwY2FjaGUlMjBhbmQlMjAlNjByZXR1cm5fbGVnYWN5X2NhY2hlJTYwJTIwZm9yY2VzJTIwdGhlJTIwcmV0dXJuZWQlMjBjYWNoZSUwQSUyMyUyMGluJTIwdGhlJTIwbGVnYWN5JTIwZm9ybWF0JTBBZ2VuZXJhdGlvbl9vdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjByZXR1cm5fbGVnYWN5X2NhY2hlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNENSklMEElMEFjYWNoZSUyMCUzRCUyMER5bmFtaWNDYWNoZS5mcm9tX2xlZ2FjeV9jYWNoZShnZW5lcmF0aW9uX291dHB1dHMucGFzdF9rZXlfdmFsdWVzKSUwQWxlZ2FjeV9mb3JtYXRfY2FjaGUlMjAlM0QlMjBjYWNoZS50b19sZWdhY3lfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, DynamicCache

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-2-7b-chat-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;Hello, my name is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># \`return_dict_in_generate=True\` is required to return the cache and \`return_legacy_cache\` forces the returned cache</span>
<span class="hljs-comment"># in the legacy format</span>
generation_outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, return_legacy_cache=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">5</span>)

cache = DynamicCache.from_legacy_cache(generation_outputs.past_key_values)
legacy_format_cache = cache.to_legacy_cache()`,wrap:!1}}),ps=new bt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/cache_explanation.md"}}),{c(){r=p("meta"),J=n(),y=p("p"),rs=n(),M(C.$$.fragment),xs=n(),j=p("p"),j.textContent=za,_s=n(),z=p("p"),z.textContent=Za,Ts=n(),Z=p("p"),Z.textContent=Xa,ks=n(),X=p("p"),X.textContent=Va,Us=n(),V=p("p"),V.textContent=Ra,Js=n(),M(k.$$.fragment),Cs=n(),R=p("p"),R.textContent=Ba,js=n(),M(B.$$.fragment),zs=n(),o=p("p"),Ma=u("The "),os=p("strong"),os.textContent=Ga,wa=u(" is calculated as shown below for a batch of size "),hs=p("code"),hs.textContent=Wa,ba=u(", number of attention heads "),ds=p("code"),ds.textContent=Ia,xa=u(", sequence length so far "),us=p("code"),us.textContent=Ha,_a=u(", and dimension per attention head "),gs=p("code"),gs.textContent=Ya,Ta=u(`.
`),Zs=new ms(!1),Xs=n(),G=p("p"),G.innerHTML=Na,Vs=n(),v=p("p"),ka=u("For causal attention, the mask prevents the model from attending to future tokens. Once a token is processed, its representation never changes with respect to future tokens, which means"),Rs=new ms(!1),Bs=u(" and"),Gs=new ms(!1),Ws=u(` can be cached and reused to compute the last token’s representation.
`),Is=new ms(!1),Hs=n(),d=p("p"),Ua=u("At inference time, you only need the last token’s query to compute the representation"),Ys=new ms(!1),Ns=u(" that predicts the next token"),$s=new ms(!1),Qs=u(". At each step, the new key and value vectors are "),ys=p("strong"),ys.textContent=$a,Ja=u(" in the cache and "),vs=p("strong"),vs.textContent=Qa,Ca=u(` to the past keys and values.
`),Fs=new ms(!1),Ls=n(),W=p("p"),W.textContent=Fa,Es=n(),I=p("p"),I.textContent=La,qs=n(),H=p("table"),H.innerHTML=Ea,Ss=n(),M(Y.$$.fragment),As=n(),N=p("p"),N.innerHTML=qa,Ks=n(),M($.$$.fragment),Ds=n(),Q=p("p"),Q.innerHTML=Sa,Ps=n(),F=p("ol"),F.innerHTML=Aa,Os=n(),M(L.$$.fragment),sa=n(),E=p("p"),E.innerHTML=Ka,aa=n(),q=p("p"),q.innerHTML=Da,ta=n(),S=p("ul"),S.innerHTML=Pa,ea=n(),A=p("p"),A.textContent=Oa,na=n(),K=p("ol"),K.innerHTML=st,la=n(),M(D.$$.fragment),pa=n(),U=p("ol"),U.innerHTML=at,ia=n(),P=p("p"),P.innerHTML=tt,ma=n(),M(O.$$.fragment),ca=n(),M(ss.$$.fragment),ra=n(),as=p("p"),as.innerHTML=et,oa=n(),ts=p("p"),ts.textContent=nt,ha=n(),es=p("ul"),es.innerHTML=lt,da=n(),ns=p("p"),ns.innerHTML=pt,ua=n(),M(ls.$$.fragment),ga=n(),M(ps.$$.fragment),ya=n(),fs=p("p"),this.h()},l(s){const a=Mt("svelte-u9bgzb",document.head);r=i(a,"META",{name:!0,content:!0}),a.forEach(t),J=l(s),y=i(s,"P",{}),Ms(y).forEach(t),rs=l(s),w(C.$$.fragment,s),xs=l(s),j=i(s,"P",{"data-svelte-h":!0}),m(j)!=="svelte-1vgfrh0"&&(j.textContent=za),_s=l(s),z=i(s,"P",{"data-svelte-h":!0}),m(z)!=="svelte-110unin"&&(z.textContent=Za),Ts=l(s),Z=i(s,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1sc0ng3"&&(Z.textContent=Xa),ks=l(s),X=i(s,"P",{"data-svelte-h":!0}),m(X)!=="svelte-stwnf4"&&(X.textContent=Va),Us=l(s),V=i(s,"P",{"data-svelte-h":!0}),m(V)!=="svelte-k1lwaa"&&(V.textContent=Ra),Js=l(s),w(k.$$.fragment,s),Cs=l(s),R=i(s,"P",{"data-svelte-h":!0}),m(R)!=="svelte-aj1f1y"&&(R.textContent=Ba),js=l(s),w(B.$$.fragment,s),zs=l(s),o=i(s,"P",{});var h=Ms(o);Ma=g(h,"The "),os=i(h,"STRONG",{"data-svelte-h":!0}),m(os)!=="svelte-1et3y0d"&&(os.textContent=Ga),wa=g(h," is calculated as shown below for a batch of size "),hs=i(h,"CODE",{"data-svelte-h":!0}),m(hs)!=="svelte-1y90nls"&&(hs.textContent=Wa),ba=g(h,", number of attention heads "),ds=i(h,"CODE",{"data-svelte-h":!0}),m(ds)!=="svelte-1blmdqe"&&(ds.textContent=Ia),xa=g(h,", sequence length so far "),us=i(h,"CODE",{"data-svelte-h":!0}),m(us)!=="svelte-18tc35m"&&(us.textContent=Ha),_a=g(h,", and dimension per attention head "),gs=i(h,"CODE",{"data-svelte-h":!0}),m(gs)!=="svelte-krx0ij"&&(gs.textContent=Ya),Ta=g(h,`.
`),Zs=cs(h,!1),h.forEach(t),Xs=l(s),G=i(s,"P",{"data-svelte-h":!0}),m(G)!=="svelte-11ldl4s"&&(G.innerHTML=Na),Vs=l(s),v=i(s,"P",{});var is=Ms(v);ka=g(is,"For causal attention, the mask prevents the model from attending to future tokens. Once a token is processed, its representation never changes with respect to future tokens, which means"),Rs=cs(is,!1),Bs=g(is," and"),Gs=cs(is,!1),Ws=g(is,` can be cached and reused to compute the last token’s representation.
`),Is=cs(is,!1),is.forEach(t),Hs=l(s),d=i(s,"P",{});var f=Ms(d);Ua=g(f,"At inference time, you only need the last token’s query to compute the representation"),Ys=cs(f,!1),Ns=g(f," that predicts the next token"),$s=cs(f,!1),Qs=g(f,". At each step, the new key and value vectors are "),ys=i(f,"STRONG",{"data-svelte-h":!0}),m(ys)!=="svelte-ho7h3"&&(ys.textContent=$a),Ja=g(f," in the cache and "),vs=i(f,"STRONG",{"data-svelte-h":!0}),m(vs)!=="svelte-ygjkh1"&&(vs.textContent=Qa),Ca=g(f,` to the past keys and values.
`),Fs=cs(f,!1),f.forEach(t),Ls=l(s),W=i(s,"P",{"data-svelte-h":!0}),m(W)!=="svelte-fo5dj4"&&(W.textContent=Fa),Es=l(s),I=i(s,"P",{"data-svelte-h":!0}),m(I)!=="svelte-ebwicu"&&(I.textContent=La),qs=l(s),H=i(s,"TABLE",{"data-svelte-h":!0}),m(H)!=="svelte-1kuj06y"&&(H.innerHTML=Ea),Ss=l(s),w(Y.$$.fragment,s),As=l(s),N=i(s,"P",{"data-svelte-h":!0}),m(N)!=="svelte-ranj33"&&(N.innerHTML=qa),Ks=l(s),w($.$$.fragment,s),Ds=l(s),Q=i(s,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1lou13p"&&(Q.innerHTML=Sa),Ps=l(s),F=i(s,"OL",{"data-svelte-h":!0}),m(F)!=="svelte-n5r1rw"&&(F.innerHTML=Aa),Os=l(s),w(L.$$.fragment,s),sa=l(s),E=i(s,"P",{"data-svelte-h":!0}),m(E)!=="svelte-gwkc81"&&(E.innerHTML=Ka),aa=l(s),q=i(s,"P",{"data-svelte-h":!0}),m(q)!=="svelte-bdrohr"&&(q.innerHTML=Da),ta=l(s),S=i(s,"UL",{"data-svelte-h":!0}),m(S)!=="svelte-1f0sw1i"&&(S.innerHTML=Pa),ea=l(s),A=i(s,"P",{"data-svelte-h":!0}),m(A)!=="svelte-40oqxk"&&(A.textContent=Oa),na=l(s),K=i(s,"OL",{"data-svelte-h":!0}),m(K)!=="svelte-j39f25"&&(K.innerHTML=st),la=l(s),w(D.$$.fragment,s),pa=l(s),U=i(s,"OL",{start:!0,"data-svelte-h":!0}),m(U)!=="svelte-1v6s7dy"&&(U.innerHTML=at),ia=l(s),P=i(s,"P",{"data-svelte-h":!0}),m(P)!=="svelte-1iezevk"&&(P.innerHTML=tt),ma=l(s),w(O.$$.fragment,s),ca=l(s),w(ss.$$.fragment,s),ra=l(s),as=i(s,"P",{"data-svelte-h":!0}),m(as)!=="svelte-1qvbiaw"&&(as.innerHTML=et),oa=l(s),ts=i(s,"P",{"data-svelte-h":!0}),m(ts)!=="svelte-t0zkvk"&&(ts.textContent=nt),ha=l(s),es=i(s,"UL",{"data-svelte-h":!0}),m(es)!=="svelte-tticje"&&(es.innerHTML=lt),da=l(s),ns=i(s,"P",{"data-svelte-h":!0}),m(ns)!=="svelte-ybkw46"&&(ns.innerHTML=pt),ua=l(s),w(ls.$$.fragment,s),ga=l(s),w(ps.$$.fragment,s),ya=l(s),fs=i(s,"P",{}),Ms(fs).forEach(t),this.h()},h(){ja(r,"name","hf:doc:metadata"),ja(r,"content",Tt),Zs.a=null,Rs.a=Bs,Gs.a=Ws,Is.a=null,Ys.a=Ns,$s.a=Qs,Fs.a=null,ja(U,"start","2")},m(s,a){c(document.head,r),e(s,J,a),e(s,y,a),e(s,rs,a),b(C,s,a),e(s,xs,a),e(s,j,a),e(s,_s,a),e(s,z,a),e(s,Ts,a),e(s,Z,a),e(s,ks,a),e(s,X,a),e(s,Us,a),e(s,V,a),e(s,Js,a),b(k,s,a),e(s,Cs,a),e(s,R,a),e(s,js,a),b(B,s,a),e(s,zs,a),e(s,o,a),c(o,Ma),c(o,os),c(o,wa),c(o,hs),c(o,ba),c(o,ds),c(o,xa),c(o,us),c(o,_a),c(o,gs),c(o,Ta),Zs.m(it,o),e(s,Xs,a),e(s,G,a),e(s,Vs,a),e(s,v,a),c(v,ka),Rs.m(mt,v),c(v,Bs),Gs.m(ct,v),c(v,Ws),Is.m(rt,v),e(s,Hs,a),e(s,d,a),c(d,Ua),Ys.m(ot,d),c(d,Ns),$s.m(ht,d),c(d,Qs),c(d,ys),c(d,Ja),c(d,vs),c(d,Ca),Fs.m(dt,d),e(s,Ls,a),e(s,W,a),e(s,Es,a),e(s,I,a),e(s,qs,a),e(s,H,a),e(s,Ss,a),b(Y,s,a),e(s,As,a),e(s,N,a),e(s,Ks,a),b($,s,a),e(s,Ds,a),e(s,Q,a),e(s,Ps,a),e(s,F,a),e(s,Os,a),b(L,s,a),e(s,sa,a),e(s,E,a),e(s,aa,a),e(s,q,a),e(s,ta,a),e(s,S,a),e(s,ea,a),e(s,A,a),e(s,na,a),e(s,K,a),e(s,la,a),b(D,s,a),e(s,pa,a),e(s,U,a),e(s,ia,a),e(s,P,a),e(s,ma,a),b(O,s,a),e(s,ca,a),b(ss,s,a),e(s,ra,a),e(s,as,a),e(s,oa,a),e(s,ts,a),e(s,ha,a),e(s,es,a),e(s,da,a),e(s,ns,a),e(s,ua,a),b(ls,s,a),e(s,ga,a),b(ps,s,a),e(s,ya,a),e(s,fs,a),va=!0},p(s,[a]){const h={};a&2&&(h.$$scope={dirty:a,ctx:s}),k.$set(h)},i(s){va||(x(C.$$.fragment,s),x(k.$$.fragment,s),x(B.$$.fragment,s),x(Y.$$.fragment,s),x($.$$.fragment,s),x(L.$$.fragment,s),x(D.$$.fragment,s),x(O.$$.fragment,s),x(ss.$$.fragment,s),x(ls.$$.fragment,s),x(ps.$$.fragment,s),va=!0)},o(s){_(C.$$.fragment,s),_(k.$$.fragment,s),_(B.$$.fragment,s),_(Y.$$.fragment,s),_($.$$.fragment,s),_(L.$$.fragment,s),_(D.$$.fragment,s),_(O.$$.fragment,s),_(ss.$$.fragment,s),_(ls.$$.fragment,s),_(ps.$$.fragment,s),va=!1},d(s){s&&(t(J),t(y),t(rs),t(xs),t(j),t(_s),t(z),t(Ts),t(Z),t(ks),t(X),t(Us),t(V),t(Js),t(Cs),t(R),t(js),t(zs),t(o),t(Xs),t(G),t(Vs),t(v),t(Hs),t(d),t(Ls),t(W),t(Es),t(I),t(qs),t(H),t(Ss),t(As),t(N),t(Ks),t(Ds),t(Q),t(Ps),t(F),t(Os),t(sa),t(E),t(aa),t(q),t(ta),t(S),t(ea),t(A),t(na),t(K),t(la),t(pa),t(U),t(ia),t(P),t(ma),t(ca),t(ra),t(as),t(oa),t(ts),t(ha),t(es),t(da),t(ns),t(ua),t(ga),t(ya),t(fs)),t(r),T(C,s),T(k,s),T(B,s),T(Y,s),T($,s),T(L,s),T(D,s),T(O,s),T(ss,s),T(ls,s),T(ps,s)}}}const Tt='{"title":"Caching","local":"caching","sections":[{"title":"Attention matrices","local":"attention-matrices","sections":[],"depth":2},{"title":"Cache class","local":"cache-class","sections":[],"depth":2},{"title":"Cache storage implementation","local":"cache-storage-implementation","sections":[],"depth":2},{"title":"Legacy cache format","local":"legacy-cache-format","sections":[],"depth":2}],"depth":1}';function kt(bs){return gt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends vt{constructor(r){super(),ft(this,r,kt,_t,ut,{})}}export{Xt as component};
