import{s as Un,z as jn,o as Wn,n as vo}from"../chunks/scheduler.18a86fab.js";import{S as Gn,i as Zn,g as i,s as n,r as m,A as Vn,h as l,f as t,c as a,j as I,u as h,x as _,k as v,y as r,a as s,v as p,d as g,t as f,w as u}from"../chunks/index.98837b22.js";import{T as pt}from"../chunks/Tip.77304350.js";import{D as W}from"../chunks/Docstring.6758ea23.js";import{C as To}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as zn}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as C}from"../chunks/Heading.7e7e0c5b.js";import{E as Bn}from"../chunks/index.92f616ba.js";function Fn(z){let d,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',c,y,M='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){d=i("p"),d.innerHTML=T,c=n(),y=i("p"),y.innerHTML=M},l(b){d=l(b,"P",{"data-svelte-h":!0}),_(d)!=="svelte-nz63kd"&&(d.innerHTML=T),c=a(b),y=l(b,"P",{"data-svelte-h":!0}),_(y)!=="svelte-aze40l"&&(y.innerHTML=M)},m(b,w){s(b,d,w),s(b,c,w),s(b,y,w)},p:vo,d(b){b&&(t(d),t(c),t(y))}}}function Nn(z){let d,T;return d=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbk1vZGVsJTJDJTIwQ2hhbWVsZW9uQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMGNoYW1lbGVvbiUyMGNoYW1lbGVvbi03YiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDaGFtZWxlb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjaGFtZWxlb24tN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbk1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonModel, ChameleonConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a chameleon chameleon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = ChameleonConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the chameleon-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(d.$$.fragment)},l(c){h(d.$$.fragment,c)},m(c,y){p(d,c,y),T=!0},p:vo,i(c){T||(g(d.$$.fragment,c),T=!0)},o(c){f(d.$$.fragment,c),T=!1},d(c){u(d,c)}}}function Rn(z){let d,T=`Although the recipe for forward pass needs to be defined within
this function, one should call the <code>Module</code> instance afterwards
instead of this since the former takes care of running the
registered hooks while the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=T},l(c){d=l(c,"P",{"data-svelte-h":!0}),_(d)!=="svelte-rqqap8"&&(d.innerHTML=T)},m(c,y){s(c,d,y)},p:vo,d(c){c&&t(d)}}}function Pn(z){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=T},l(c){d=l(c,"P",{"data-svelte-h":!0}),_(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(c,y){s(c,d,y)},p:vo,d(c){c&&t(d)}}}function Hn(z){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=i("p"),d.innerHTML=T},l(c){d=l(c,"P",{"data-svelte-h":!0}),_(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(c,y){s(c,d,y)},p:vo,d(c){c&&t(d)}}}function qn(z){let d,T="Example:",c,y,M;return y=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvblByb2Nlc3NvciUyQyUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEElMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXByb2Nlc3NvciUyMCUzRCUyMENoYW1lbGVvblByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySSUyMHVzZWQlMjB0byUyMGtub3clMjBhJTIwbG90JTIwYWJvdXQlMjBjb25zdGVsbGF0aW9ucyUyMHdoZW4lMjBJJTIwd2FzJTIweW91bmdlciUyQyUyMGJ1dCUyMGFzJTIwSSUyMGdyZXclMjBvbGRlciUyQyUyMEklMjBmb3Jnb3QlMjBtb3N0JTIwb2YlMjB3aGF0JTIwSSUyMGtuZXcuJTIwVGhlc2UlMjBhcmUlMjB0aGUlMjBvbmx5JTIwdHdvJTIwY29uc3RlbGxhdGlvbnMlMjB0aGF0JTIwSSUyMHJlYWxseSUyMHJlbWVtYmVyJTIwbm93LiUzQ2ltYWdlJTNFJTNDaW1hZ2UlM0VJJTIwd291bGQlMjBsaWtlJTIwZm9yJTIweW91JTIwdG8lMjB0ZWxsJTIwbWUlMjBhYm91dCUyMDMlMjBtb3JlJTIwY29uc3RlbGxhdGlvbnMlMjBhbmQlMjBnaXZlJTIwbWUlMjBhJTIwbGl0dGxlJTIwYml0JTIwb2YlMjBoaXN0b3J5JTIwYWJvdXQlMjB0aGUlMjBjb25zdGVsbGF0aW9uLiUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoJTIyaHR0cHMlM0ElMkYlMkZuaW5lcGxhbmV0cy5vcmclMkZ3cC1jb250ZW50JTJGdXBsb2FkcyUyRjIwMjAlMkYxMiUyRnRoZS1iaWctZGlwcGVyLTEuanBnJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCglMjJodHRwcyUzQSUyRiUyRnd3dy5reGFuLmNvbSUyRndwLWNvbnRlbnQlMkZ1cGxvYWRzJTJGc2l0ZXMlMkY0MCUyRjIwMjAlMkYxMCUyRk9SSU9OLmpwZyUyMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEJTVCaW1hZ2UlMkMlMjBpbWFnZV8yJTVEJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKG1vZGVsLmRldmljZSUyQyUyMHRvcmNoLmJmbG9hdDE2KSUwQSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;I used to know a lot about constellations when I was younger, but as I grew older, I forgot most of what I knew. These are the only two constellations that I really remember now.&lt;image&gt;&lt;image&gt;I would like for you to tell me about 3 more constellations and give me a little bit of history about the constellation.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;https://nineplanets.org/wp-content/uploads/2020/12/the-big-dipper-1.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(<span class="hljs-string">&quot;https://www.kxan.com/wp-content/uploads/sites/40/2020/10/ORION.jpg&quot;</span>, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=[image, image_2], text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){d=i("p"),d.textContent=T,c=n(),m(y.$$.fragment)},l(b){d=l(b,"P",{"data-svelte-h":!0}),_(d)!=="svelte-11lpom8"&&(d.textContent=T),c=a(b),h(y.$$.fragment,b)},m(b,w){s(b,d,w),s(b,c,w),p(y,b,w),M=!0},p:vo,i(b){M||(g(y.$$.fragment,b),M=!0)},o(b){f(y.$$.fragment,b),M=!1},d(b){b&&(t(d),t(c)),u(y,b)}}}function Ln(z){let d,T,c,y,M,b,w,Qt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Co,te,Mo,ne,St='The Chameleon model was proposed in <a href="https://arxiv.org/abs/2405.09818v1" rel="nofollow">Chameleon: Mixed-Modal Early-Fusion Foundation Models</a> by META AI Chameleon Team. Chameleon is a Vision-Language Model that use vector quantization to tokenize images which enables the model to generate multimodal output. The model takes images and texts as input, including an interleaved format, and generates textual response. Image generation module is not released yet.',Jo,ae,Xt="The abstract from the paper is the following:",ko,se,At=`<em>We present Chameleon, a family of early-fusion token-based mixed-modal models capable of understanding and generating images and text in any arbitrary sequence. We outline a stable training
approach from inception, an alignment recipe, and an architectural parameterization tailored for the
early-fusion, token-based, mixed-modal setting. The models are evaluated on a comprehensive range
of tasks, including visual question answering, image captioning, text generation, image generation, and
long-form mixed modal generation. Chameleon demonstrates broad and general capabilities, including
state-of-the-art performance in image captioning tasks, outperforms Llama-2 in text-only tasks while
being competitive with models such as Mixtral 8x7B and Gemini-Pro, and performs non-trivial image
generation, all in a single model. It also matches or exceeds the performance of much larger models,
including Gemini Pro and GPT-4V, according to human judgments on a new long-form mixed-modal
generation evaluation, where either the prompt or outputs contain mixed sequences of both images and
text. Chameleon marks a significant step forward in unified modeling of full multimodal documents</em>`,$o,L,Dt,xo,re,Ot='Chameleon incorporates a vector quantizer module to transform images into discrete tokens. That also enables image generation using an auto-regressive transformer. Taken from the <a href="https://arxiv.org/abs/2405.09818v1">original paper.</a>',Io,ie,Kt=`This model was contributed by <a href="https://huggingface.co/joaogante" rel="nofollow">joaogante</a> and <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/facebookresearch/chameleon" rel="nofollow">here</a>.`,zo,le,Uo,de,en="<li><p>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to set <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</p></li> <li><p>Note that Chameleon was tuned for safety alignment. If the model is refusing to answer, consider asking a more concrete question, instead of an open question.</p></li> <li><p>Chameleon generates in chat format which means that the generated text will always be the “assistant’s turn”. You can enable a text completion generation by passing <code>return_for_text_completion=True</code> when calling the processor.</p></li>",jo,ce,on=`<p>[!NOTE]
Chameleon implementation in Transformers uses a special image token to indicate where to merge image embeddings. For special image token we didn’t add a new one but used one of the reserved tokens: <code>&lt;reserved08707&gt;</code>. You have to add <code>&lt;image&gt;</code> to your prompt in the place where the image should be embedded for correct generation.</p>`,Wo,me,Go,he,Zo,pe,tn=`Chameleon is a gated model so make sure to have access and login to Hugging Face Hub using a token.
Here’s how to load the model and perform inference in half-precision (<code>torch.bfloat16</code>):`,Vo,ge,Bo,fe,Fo,ue,nn="Chameleon can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). Here is how you can do it:",No,_e,Ro,be,Po,ye,Ho,Te,an="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",qo,E,Lo,ve,sn="Simply change the snippet above with:",Eo,we,Yo,Ce,Qo,Me,rn='The models supports both, Flash-Attention 2 and PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow"><code>torch.nn.functional.scaled_dot_product_attention</code></a> which can be enables for optimization. SDPA is the default options when you load the model, If you want to switch for Flash Attention 2, first make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository</a> regarding that package installation. Simply change the snippet above with:',So,Je,Xo,ke,Ao,U,$e,gt,Ae,ln=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a>. It is used to instantiate a
chameleon model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/meta/chameleon-7B" rel="nofollow">meta/chameleon-7B</a>.`,ft,De,dn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ut,Y,Do,xe,Oo,H,Ie,_t,Oe,cn=`This is the configuration class to store the configuration of a <code>ChameleonVQModel</code>. It is used to instantiate a
<code>ChameleonVQModel</code> according to the specified arguments, defining the model architecture.
Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a
configuration with the defaults will yield a similar configuration to the VQModel of the
<a href="https://huggingface.co/meta/chameleon-7B" rel="nofollow">meta/chameleon-7B</a>.`,Ko,ze,et,J,Ue,bt,Ke,mn=`Constructs a Chameleon processor which wraps a Chameleon image processor and a Chameleon tokenizer into a single
processor.`,yt,eo,hn=`<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonProcessor">ChameleonProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonImageProcessor">ChameleonImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>.
See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonProcessor.decode">decode()</a> for more information.`,Tt,Q,je,vt,oo,pn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,wt,S,We,Ct,to,gn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,ot,Ge,tt,V,Ze,Mt,no,fn="Constructs a Chameleon image processor.",Jt,X,Ve,kt,ao,un="Preprocess an image or batch of images.",nt,Be,at,k,Fe,$t,so,_n=`The VQ-VAE model used in Chameleon for encoding/decoding images into discrete tokens.
This model follows the “Make-a-scene: Scene-based text-to-image generation with human priors” paper from
<a href="https://arxiv.org/abs/2203.13131" rel="nofollow">Oran Gafni, Adam Polyak, Oron Ashual, Shelly Sheynin, Devi Parikh, and Yaniv Taigman</a>.`,xt,ro,bn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,It,io,yn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,zt,G,Ne,Ut,lo,Tn="Define the computation performed at every call.",jt,co,vn="Should be overridden by all subclasses.",Wt,A,st,Re,rt,$,Pe,Gt,mo,wn="The bare Chameleon Model outputting raw hidden-states without any specific head on top.",Zt,ho,Cn=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vt,po,Mn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Bt,F,He,Ft,go,Jn='The <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a> forward method, overrides the <code>__call__</code> special method.',Nt,D,it,qe,lt,x,Le,Rt,fo,kn="Chameleon Model with a head on top used for outputting logits for next token prediction.",Pt,uo,$n=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ht,_o,xn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,qt,Z,Ee,Lt,bo,In='The <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonForConditionalGeneration">ChameleonForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Et,O,Yt,K,dt,Ye,ct,wo,mt;return M=new C({props:{title:"Chameleon",local:"chameleon",headingTag:"h1"}}),te=new C({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new C({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),me=new C({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),he=new C({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),ge=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvblByb2Nlc3NvciUyQyUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBDaGFtZWxlb25Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGY2hhbWVsZW9uLTdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQ2hhbWVsZW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmNoYW1lbGVvbi03YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiklMEElMEElMjMlMjBwcmVwYXJlJTIwaW1hZ2UlMjBhbmQlMjB0ZXh0JTIwcHJvbXB0JTBBdXJsJTIwJTNEJTIwJ2h0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGcnJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyV2hhdCUyMGRvJTIweW91JTIwc2VlJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlM0NpbWFnZSUzRSUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHRleHQlM0Rwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UlMkMlMjBkdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQSUwQSUyMyUyMGF1dG9yZWdyZXNzaXZlbHklMjBjb21wbGV0ZSUyMHByb21wdCUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEFwcmludChwcm9jZXNzb3IuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)
model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt</span>
url = <span class="hljs-string">&#x27;http://images.cocodataset.org/val2017/000000039769.jpg&#x27;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;What do you see in this image?&lt;image&gt;&quot;</span>

inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device, dtype=torch.bfloat16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),fe=new C({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),_e=new To({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonProcessor, ChameleonForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = ChameleonProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>)

model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batched prompt, where the first one is a multi-image prompt and the second is not</span>
prompts = [
    <span class="hljs-string">&quot;What do these images have in common?&lt;image&gt;&lt;image&gt;&quot;</span>,
    <span class="hljs-string">&quot;&lt;image&gt;What is shown in this image?&quot;</span>
]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
<span class="hljs-comment"># Each &quot;&lt;image&gt;&quot; token uses one image leaving the next for the subsequent &quot;&lt;image&gt;&quot; tokens</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device=<span class="hljs-string">&quot;cuda&quot;</span>, dtype=torch.bfloat16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)`,wrap:!1}}),be=new C({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),ye=new C({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),E=new pt({props:{$$slots:{default:[Fn]},$$scope:{ctx:z}}}),we=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyMyUyMHNwZWNpZnklMjBob3clMjB0byUyMHF1YW50aXplJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQ2hhbWVsZW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmNoYW1lbGVvbi03YiUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.bfloat16,
)

model = ChameleonForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),Ce=new C({props:{title:"Use Flash-Attention 2 and SDPA to further speed-up generation",local:"use-flash-attention-2-and-sdpa-to-further-speed-up-generation",headingTag:"h3"}}),Je=new To({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZmFjZWJvb2slMkZjaGFtZWxlb24tN2IlMjIlMEFtb2RlbCUyMCUzRCUyMENoYW1lbGVvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwbG93X2NwdV9tZW1fdXNhZ2UlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ChameleonForConditionalGeneration

model_id = <span class="hljs-string">&quot;facebook/chameleon-7b&quot;</span>
model = ChameleonForConditionalGeneration.from_pretrained(
    model_id,
    torch_dtype=torch.bfloat16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),ke=new C({props:{title:"ChameleonConfig",local:"transformers.ChameleonConfig",headingTag:"h2"}}),$e=new W({props:{name:"class transformers.ChameleonConfig",anchor:"transformers.ChameleonConfig",parameters:[{name:"vocab_size",val:" = 65536"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 11008"},{name:"num_hidden_layers",val:" = 32"},{name:"num_attention_heads",val:" = 32"},{name:"num_key_value_heads",val:" = 32"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 4096"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"model_parallel_size",val:" = 1"},{name:"swin_norm",val:" = False"},{name:"vq_config",val:" = None"},{name:"vocabulary_map",val:" = None"},{name:"mlp_bias",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 65536) &#x2014;
Vocabulary size of the chameleon model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonModel">ChameleonModel</a>; this includes text and image tokens.`,name:"vocab_size"},{anchor:"transformers.ChameleonConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.ChameleonConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11008) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.ChameleonConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.ChameleonConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.ChameleonConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.ChameleonConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.ChameleonConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
The maximum sequence length that this model might ever be used with. Chameleon supports up to 4096 tokens.`,name:"max_position_embeddings"},{anchor:"transformers.ChameleonConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.ChameleonConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.ChameleonConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.ChameleonConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.ChameleonConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.ChameleonConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.ChameleonConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.ChameleonConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.ChameleonConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/Localchameleon/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/Localchameleon/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.ChameleonConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.ChameleonConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.ChameleonConfig.model_parallel_size",description:`<strong>model_parallel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of shards used when training the model. This will be used in qk layernorm because the original Chameleon inference
doesn&#x2019;t do reduction in those layers and each rank has its own biases.`,name:"model_parallel_size"},{anchor:"transformers.ChameleonConfig.swin_norm",description:`<strong>swin_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Use Swin Transformer normalization.`,name:"swin_norm"},{anchor:"transformers.ChameleonConfig.vq_config",description:`<strong>vq_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
ChameleonVQConfig instance containing the configuration for the VQ-VAE model.`,name:"vq_config"},{anchor:"transformers.ChameleonConfig.vocabulary_map",description:`<strong>vocabulary_map</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A dictionary containing the vocabulary map from the tokenizer. Used to obtain tokens from the image inputs.`,name:"vocabulary_map"},{anchor:"transformers.ChameleonConfig.mlp_bias",description:`<strong>mlp_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in up_proj, down_proj and gate_proj layers in the MLP layers.`,name:"mlp_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/configuration_chameleon.py#L100"}}),Y=new zn({props:{anchor:"transformers.ChameleonConfig.example",$$slots:{default:[Nn]},$$scope:{ctx:z}}}),xe=new C({props:{title:"ChameleonVQVAEConfig",local:"transformers.ChameleonVQVAEConfig",headingTag:"h2"}}),Ie=new W({props:{name:"class transformers.ChameleonVQVAEConfig",anchor:"transformers.ChameleonVQVAEConfig",parameters:[{name:"embed_dim",val:": int = 256"},{name:"num_embeddings",val:": int = 8192"},{name:"double_latent",val:": bool = False"},{name:"latent_channels",val:": int = 256"},{name:"resolution",val:": int = 512"},{name:"in_channels",val:": int = 3"},{name:"base_channels",val:": int = 128"},{name:"channel_multiplier",val:": typing.List[int] = [1, 1, 2, 2, 4]"},{name:"num_res_blocks",val:": int = 2"},{name:"attn_resolutions",val:": typing.Optional[typing.List[int]] = None"},{name:"dropout",val:": float = 0.0"},{name:"attn_type",val:": str = 'vanilla'"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonVQVAEConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of each embedding vector.`,name:"embed_dim"},{anchor:"transformers.ChameleonVQVAEConfig.num_embeddings",description:`<strong>num_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Number of codebook embeddings.`,name:"num_embeddings"},{anchor:"transformers.ChameleonVQVAEConfig.double_latent",description:`<strong>double_latent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use double z channels.`,name:"double_latent"},{anchor:"transformers.ChameleonVQVAEConfig.latent_channels",description:`<strong>latent_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels for the latent space.`,name:"latent_channels"},{anchor:"transformers.ChameleonVQVAEConfig.resolution",description:`<strong>resolution</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Resolution of the input images.`,name:"resolution"},{anchor:"transformers.ChameleonVQVAEConfig.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of input channels.`,name:"in_channels"},{anchor:"transformers.ChameleonVQVAEConfig.base_channels",description:`<strong>base_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Base channel count.`,name:"base_channels"},{anchor:"transformers.ChameleonVQVAEConfig.channel_multiplier",description:`<strong>channel_multiplier</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 1, 2, 2, 4]</code>) &#x2014;
Channel multipliers for each resolution.`,name:"channel_multiplier"},{anchor:"transformers.ChameleonVQVAEConfig.num_res_blocks",description:`<strong>num_res_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of residual blocks.`,name:"num_res_blocks"},{anchor:"transformers.ChameleonVQVAEConfig.attn_resolutions",description:`<strong>attn_resolutions</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Resolutions to apply attention.`,name:"attn_resolutions"},{anchor:"transformers.ChameleonVQVAEConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout rate.`,name:"dropout"},{anchor:"transformers.ChameleonVQVAEConfig.attn_type",description:`<strong>attn_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;vanilla&quot;</code>) &#x2014;
Attention type used in VQ-GAN encoder. Can be &#x201C;vanilla&#x201D; or None.`,name:"attn_type"},{anchor:"transformers.ChameleonVQVAEConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/configuration_chameleon.py#L26"}}),ze=new C({props:{title:"ChameleonProcessor",local:"transformers.ChameleonProcessor",headingTag:"h2"}}),Ue=new W({props:{name:"class transformers.ChameleonProcessor",anchor:"transformers.ChameleonProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"image_seq_length",val:": int = 1024"},{name:"image_token",val:": str = '<image>'"}],parametersDescription:[{anchor:"transformers.ChameleonProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonImageProcessor">ChameleonImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.ChameleonProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.ChameleonProcessor.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.ChameleonProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
The special token used to indicate image in the text.`,name:"image_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/processing_chameleon.py#L44"}}),je=new W({props:{name:"batch_decode",anchor:"transformers.ChameleonProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/processing_chameleon.py#L154"}}),We=new W({props:{name:"decode",anchor:"transformers.ChameleonProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/processing_chameleon.py#L162"}}),Ge=new C({props:{title:"ChameleonImageProcessor",local:"transformers.ChameleonImageProcessor",headingTag:"h2"}}),Ze=new W({props:{name:"class transformers.ChameleonImageProcessor",anchor:"transformers.ChameleonImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = 1"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.0078"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ChameleonImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.ChameleonImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 512}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.ChameleonImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to 1) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.ChameleonImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.ChameleonImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to {&#x201C;height&#x201D; &#x2014; 512, &#x201C;width&#x201D;: 512}):
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.ChameleonImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.ChameleonImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to 0.0078) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.ChameleonImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.ChameleonImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[1.0, 1.0, 1.0]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.ChameleonImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[1.0, 1.0, 1.0]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.ChameleonImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/image_processing_chameleon.py#L47"}}),Ve=new W({props:{name:"preprocess",anchor:"transformers.ChameleonImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.ChameleonImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.ChameleonImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.ChameleonImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.ChameleonImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.ChameleonImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.ChameleonImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.ChameleonImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.ChameleonImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.ChameleonImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.ChameleonImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.ChameleonImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/image_processing_chameleon.py#L171"}}),Be=new C({props:{title:"ChameleonVQVAE",local:"transformers.ChameleonVQVAE",headingTag:"h2"}}),Fe=new W({props:{name:"class transformers.ChameleonVQVAE",anchor:"transformers.ChameleonVQVAE",parameters:[{name:"config",val:": ChameleonVQVAEConfig"}],parametersDescription:[{anchor:"transformers.ChameleonVQVAE.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonVQVAEConfig">ChameleonVQVAEConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L853"}}),Ne=new W({props:{name:"_forward_unimplemented",anchor:"transformers.ChameleonVQVAE.forward",parameters:[{name:"*input",val:": typing.Any"}],source:"https://github.com/huggingface/transformers/blob/main/src/torch/nn/modules/module.py#L386"}}),A=new pt({props:{$$slots:{default:[Rn]},$$scope:{ctx:z}}}),Re=new C({props:{title:"ChameleonModel",local:"transformers.ChameleonModel",headingTag:"h2"}}),Pe=new W({props:{name:"class transformers.ChameleonModel",anchor:"transformers.ChameleonModel",parameters:[{name:"config",val:": ChameleonConfig"}],parametersDescription:[{anchor:"transformers.ChameleonModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonConfig">ChameleonConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L880"}}),He=new W({props:{name:"forward",anchor:"transformers.ChameleonModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.ChameleonModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ChameleonModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.ChameleonModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ChameleonModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ChameleonModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ChameleonModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ChameleonModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ChameleonModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ChameleonModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ChameleonModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ChameleonModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L928",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonConfig"
>ChameleonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new pt({props:{$$slots:{default:[Pn]},$$scope:{ctx:z}}}),qe=new C({props:{title:"ChameleonForConditionalGeneration",local:"transformers.ChameleonForConditionalGeneration",headingTag:"h2"}}),Le=new W({props:{name:"class transformers.ChameleonForConditionalGeneration",anchor:"transformers.ChameleonForConditionalGeneration",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ChameleonForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonForConditionalGeneration">ChameleonForConditionalGeneration</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L1189"}}),Ee=new W({props:{name:"forward",anchor:"transformers.ChameleonForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.chameleon.modeling_chameleon.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.ChameleonForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ChameleonForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/chameleon/modeling_chameleon.py#L1224",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/chameleon#transformers.ChameleonConfig"
>ChameleonConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new pt({props:{$$slots:{default:[Hn]},$$scope:{ctx:z}}}),K=new zn({props:{anchor:"transformers.ChameleonForConditionalGeneration.forward.example",$$slots:{default:[qn]},$$scope:{ctx:z}}}),Ye=new Bn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/chameleon.md"}}),{c(){d=i("meta"),T=n(),c=i("p"),y=n(),m(M.$$.fragment),b=n(),w=i("div"),w.innerHTML=Qt,Co=n(),m(te.$$.fragment),Mo=n(),ne=i("p"),ne.innerHTML=St,Jo=n(),ae=i("p"),ae.textContent=Xt,ko=n(),se=i("p"),se.innerHTML=At,$o=n(),L=i("img"),xo=n(),re=i("small"),re.innerHTML=Ot,Io=n(),ie=i("p"),ie.innerHTML=Kt,zo=n(),m(le.$$.fragment),Uo=n(),de=i("ul"),de.innerHTML=en,jo=n(),ce=i("blockquote"),ce.innerHTML=on,Wo=n(),m(me.$$.fragment),Go=n(),m(he.$$.fragment),Zo=n(),pe=i("p"),pe.innerHTML=tn,Vo=n(),m(ge.$$.fragment),Bo=n(),m(fe.$$.fragment),Fo=n(),ue=i("p"),ue.textContent=nn,No=n(),m(_e.$$.fragment),Ro=n(),m(be.$$.fragment),Po=n(),m(ye.$$.fragment),Ho=n(),Te=i("p"),Te.innerHTML=an,qo=n(),m(E.$$.fragment),Lo=n(),ve=i("p"),ve.textContent=sn,Eo=n(),m(we.$$.fragment),Yo=n(),m(Ce.$$.fragment),Qo=n(),Me=i("p"),Me.innerHTML=rn,So=n(),m(Je.$$.fragment),Xo=n(),m(ke.$$.fragment),Ao=n(),U=i("div"),m($e.$$.fragment),gt=n(),Ae=i("p"),Ae.innerHTML=ln,ft=n(),De=i("p"),De.innerHTML=dn,ut=n(),m(Y.$$.fragment),Do=n(),m(xe.$$.fragment),Oo=n(),H=i("div"),m(Ie.$$.fragment),_t=n(),Oe=i("p"),Oe.innerHTML=cn,Ko=n(),m(ze.$$.fragment),et=n(),J=i("div"),m(Ue.$$.fragment),bt=n(),Ke=i("p"),Ke.textContent=mn,yt=n(),eo=i("p"),eo.innerHTML=hn,Tt=n(),Q=i("div"),m(je.$$.fragment),vt=n(),oo=i("p"),oo.innerHTML=pn,wt=n(),S=i("div"),m(We.$$.fragment),Ct=n(),to=i("p"),to.innerHTML=gn,ot=n(),m(Ge.$$.fragment),tt=n(),V=i("div"),m(Ze.$$.fragment),Mt=n(),no=i("p"),no.textContent=fn,Jt=n(),X=i("div"),m(Ve.$$.fragment),kt=n(),ao=i("p"),ao.textContent=un,nt=n(),m(Be.$$.fragment),at=n(),k=i("div"),m(Fe.$$.fragment),$t=n(),so=i("p"),so.innerHTML=_n,xt=n(),ro=i("p"),ro.innerHTML=bn,It=n(),io=i("p"),io.innerHTML=yn,zt=n(),G=i("div"),m(Ne.$$.fragment),Ut=n(),lo=i("p"),lo.textContent=Tn,jt=n(),co=i("p"),co.textContent=vn,Wt=n(),m(A.$$.fragment),st=n(),m(Re.$$.fragment),rt=n(),$=i("div"),m(Pe.$$.fragment),Gt=n(),mo=i("p"),mo.textContent=wn,Zt=n(),ho=i("p"),ho.innerHTML=Cn,Vt=n(),po=i("p"),po.innerHTML=Mn,Bt=n(),F=i("div"),m(He.$$.fragment),Ft=n(),go=i("p"),go.innerHTML=Jn,Nt=n(),m(D.$$.fragment),it=n(),m(qe.$$.fragment),lt=n(),x=i("div"),m(Le.$$.fragment),Rt=n(),fo=i("p"),fo.textContent=kn,Pt=n(),uo=i("p"),uo.innerHTML=$n,Ht=n(),_o=i("p"),_o.innerHTML=xn,qt=n(),Z=i("div"),m(Ee.$$.fragment),Lt=n(),bo=i("p"),bo.innerHTML=In,Et=n(),m(O.$$.fragment),Yt=n(),m(K.$$.fragment),dt=n(),m(Ye.$$.fragment),ct=n(),wo=i("p"),this.h()},l(e){const o=Vn("svelte-u9bgzb",document.head);d=l(o,"META",{name:!0,content:!0}),o.forEach(t),T=a(e),c=l(e,"P",{}),I(c).forEach(t),y=a(e),h(M.$$.fragment,e),b=a(e),w=l(e,"DIV",{class:!0,"data-svelte-h":!0}),_(w)!=="svelte-b95w5j"&&(w.innerHTML=Qt),Co=a(e),h(te.$$.fragment,e),Mo=a(e),ne=l(e,"P",{"data-svelte-h":!0}),_(ne)!=="svelte-1pzfvxv"&&(ne.innerHTML=St),Jo=a(e),ae=l(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-vfdo9a"&&(ae.textContent=Xt),ko=a(e),se=l(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-b403ub"&&(se.innerHTML=At),$o=a(e),L=l(e,"IMG",{src:!0,alt:!0,width:!0}),xo=a(e),re=l(e,"SMALL",{"data-svelte-h":!0}),_(re)!=="svelte-tuggwl"&&(re.innerHTML=Ot),Io=a(e),ie=l(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-18is37e"&&(ie.innerHTML=Kt),zo=a(e),h(le.$$.fragment,e),Uo=a(e),de=l(e,"UL",{"data-svelte-h":!0}),_(de)!=="svelte-1xww0u5"&&(de.innerHTML=en),jo=a(e),ce=l(e,"BLOCKQUOTE",{"data-svelte-h":!0}),_(ce)!=="svelte-1buypb9"&&(ce.innerHTML=on),Wo=a(e),h(me.$$.fragment,e),Go=a(e),h(he.$$.fragment,e),Zo=a(e),pe=l(e,"P",{"data-svelte-h":!0}),_(pe)!=="svelte-1mp252t"&&(pe.innerHTML=tn),Vo=a(e),h(ge.$$.fragment,e),Bo=a(e),h(fe.$$.fragment,e),Fo=a(e),ue=l(e,"P",{"data-svelte-h":!0}),_(ue)!=="svelte-55qtep"&&(ue.textContent=nn),No=a(e),h(_e.$$.fragment,e),Ro=a(e),h(be.$$.fragment,e),Po=a(e),h(ye.$$.fragment,e),Ho=a(e),Te=l(e,"P",{"data-svelte-h":!0}),_(Te)!=="svelte-1y3bqqy"&&(Te.innerHTML=an),qo=a(e),h(E.$$.fragment,e),Lo=a(e),ve=l(e,"P",{"data-svelte-h":!0}),_(ve)!=="svelte-gwf9h7"&&(ve.textContent=sn),Eo=a(e),h(we.$$.fragment,e),Yo=a(e),h(Ce.$$.fragment,e),Qo=a(e),Me=l(e,"P",{"data-svelte-h":!0}),_(Me)!=="svelte-131jlth"&&(Me.innerHTML=rn),So=a(e),h(Je.$$.fragment,e),Xo=a(e),h(ke.$$.fragment,e),Ao=a(e),U=l(e,"DIV",{class:!0});var B=I(U);h($e.$$.fragment,B),gt=a(B),Ae=l(B,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-1u2yjdc"&&(Ae.innerHTML=ln),ft=a(B),De=l(B,"P",{"data-svelte-h":!0}),_(De)!=="svelte-o55m63"&&(De.innerHTML=dn),ut=a(B),h(Y.$$.fragment,B),B.forEach(t),Do=a(e),h(xe.$$.fragment,e),Oo=a(e),H=l(e,"DIV",{class:!0});var Qe=I(H);h(Ie.$$.fragment,Qe),_t=a(Qe),Oe=l(Qe,"P",{"data-svelte-h":!0}),_(Oe)!=="svelte-a6ih2f"&&(Oe.innerHTML=cn),Qe.forEach(t),Ko=a(e),h(ze.$$.fragment,e),et=a(e),J=l(e,"DIV",{class:!0});var j=I(J);h(Ue.$$.fragment,j),bt=a(j),Ke=l(j,"P",{"data-svelte-h":!0}),_(Ke)!=="svelte-8u0vzv"&&(Ke.textContent=mn),yt=a(j),eo=l(j,"P",{"data-svelte-h":!0}),_(eo)!=="svelte-12nqtpn"&&(eo.innerHTML=hn),Tt=a(j),Q=l(j,"DIV",{class:!0});var Se=I(Q);h(je.$$.fragment,Se),vt=a(Se),oo=l(Se,"P",{"data-svelte-h":!0}),_(oo)!=="svelte-1o9eza"&&(oo.innerHTML=pn),Se.forEach(t),wt=a(j),S=l(j,"DIV",{class:!0});var Xe=I(S);h(We.$$.fragment,Xe),Ct=a(Xe),to=l(Xe,"P",{"data-svelte-h":!0}),_(to)!=="svelte-kk16qw"&&(to.innerHTML=gn),Xe.forEach(t),j.forEach(t),ot=a(e),h(Ge.$$.fragment,e),tt=a(e),V=l(e,"DIV",{class:!0});var q=I(V);h(Ze.$$.fragment,q),Mt=a(q),no=l(q,"P",{"data-svelte-h":!0}),_(no)!=="svelte-p2ya4c"&&(no.textContent=fn),Jt=a(q),X=l(q,"DIV",{class:!0});var ht=I(X);h(Ve.$$.fragment,ht),kt=a(ht),ao=l(ht,"P",{"data-svelte-h":!0}),_(ao)!=="svelte-1x3yxsa"&&(ao.textContent=un),ht.forEach(t),q.forEach(t),nt=a(e),h(Be.$$.fragment,e),at=a(e),k=l(e,"DIV",{class:!0});var N=I(k);h(Fe.$$.fragment,N),$t=a(N),so=l(N,"P",{"data-svelte-h":!0}),_(so)!=="svelte-1yzmrhf"&&(so.innerHTML=_n),xt=a(N),ro=l(N,"P",{"data-svelte-h":!0}),_(ro)!=="svelte-6pahdo"&&(ro.innerHTML=bn),It=a(N),io=l(N,"P",{"data-svelte-h":!0}),_(io)!=="svelte-hswkmf"&&(io.innerHTML=yn),zt=a(N),G=l(N,"DIV",{class:!0});var ee=I(G);h(Ne.$$.fragment,ee),Ut=a(ee),lo=l(ee,"P",{"data-svelte-h":!0}),_(lo)!=="svelte-1q5ym45"&&(lo.textContent=Tn),jt=a(ee),co=l(ee,"P",{"data-svelte-h":!0}),_(co)!=="svelte-w8wo9i"&&(co.textContent=vn),Wt=a(ee),h(A.$$.fragment,ee),ee.forEach(t),N.forEach(t),st=a(e),h(Re.$$.fragment,e),rt=a(e),$=l(e,"DIV",{class:!0});var R=I($);h(Pe.$$.fragment,R),Gt=a(R),mo=l(R,"P",{"data-svelte-h":!0}),_(mo)!=="svelte-1l8bpto"&&(mo.textContent=wn),Zt=a(R),ho=l(R,"P",{"data-svelte-h":!0}),_(ho)!=="svelte-6pahdo"&&(ho.innerHTML=Cn),Vt=a(R),po=l(R,"P",{"data-svelte-h":!0}),_(po)!=="svelte-hswkmf"&&(po.innerHTML=Mn),Bt=a(R),F=l(R,"DIV",{class:!0});var yo=I(F);h(He.$$.fragment,yo),Ft=a(yo),go=l(yo,"P",{"data-svelte-h":!0}),_(go)!=="svelte-1ytkjtr"&&(go.innerHTML=Jn),Nt=a(yo),h(D.$$.fragment,yo),yo.forEach(t),R.forEach(t),it=a(e),h(qe.$$.fragment,e),lt=a(e),x=l(e,"DIV",{class:!0});var P=I(x);h(Le.$$.fragment,P),Rt=a(P),fo=l(P,"P",{"data-svelte-h":!0}),_(fo)!=="svelte-1t17c8v"&&(fo.textContent=kn),Pt=a(P),uo=l(P,"P",{"data-svelte-h":!0}),_(uo)!=="svelte-6pahdo"&&(uo.innerHTML=$n),Ht=a(P),_o=l(P,"P",{"data-svelte-h":!0}),_(_o)!=="svelte-hswkmf"&&(_o.innerHTML=xn),qt=a(P),Z=l(P,"DIV",{class:!0});var oe=I(Z);h(Ee.$$.fragment,oe),Lt=a(oe),bo=l(oe,"P",{"data-svelte-h":!0}),_(bo)!=="svelte-vjqkx9"&&(bo.innerHTML=In),Et=a(oe),h(O.$$.fragment,oe),Yt=a(oe),h(K.$$.fragment,oe),oe.forEach(t),P.forEach(t),dt=a(e),h(Ye.$$.fragment,e),ct=a(e),wo=l(e,"P",{}),I(wo).forEach(t),this.h()},h(){v(d,"name","hf:doc:metadata"),v(d,"content",En),v(w,"class","flex flex-wrap space-x-1"),jn(L.src,Dt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/chameleon_arch.png")||v(L,"src",Dt),v(L,"alt","drawing"),v(L,"width","600"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){r(document.head,d),s(e,T,o),s(e,c,o),s(e,y,o),p(M,e,o),s(e,b,o),s(e,w,o),s(e,Co,o),p(te,e,o),s(e,Mo,o),s(e,ne,o),s(e,Jo,o),s(e,ae,o),s(e,ko,o),s(e,se,o),s(e,$o,o),s(e,L,o),s(e,xo,o),s(e,re,o),s(e,Io,o),s(e,ie,o),s(e,zo,o),p(le,e,o),s(e,Uo,o),s(e,de,o),s(e,jo,o),s(e,ce,o),s(e,Wo,o),p(me,e,o),s(e,Go,o),p(he,e,o),s(e,Zo,o),s(e,pe,o),s(e,Vo,o),p(ge,e,o),s(e,Bo,o),p(fe,e,o),s(e,Fo,o),s(e,ue,o),s(e,No,o),p(_e,e,o),s(e,Ro,o),p(be,e,o),s(e,Po,o),p(ye,e,o),s(e,Ho,o),s(e,Te,o),s(e,qo,o),p(E,e,o),s(e,Lo,o),s(e,ve,o),s(e,Eo,o),p(we,e,o),s(e,Yo,o),p(Ce,e,o),s(e,Qo,o),s(e,Me,o),s(e,So,o),p(Je,e,o),s(e,Xo,o),p(ke,e,o),s(e,Ao,o),s(e,U,o),p($e,U,null),r(U,gt),r(U,Ae),r(U,ft),r(U,De),r(U,ut),p(Y,U,null),s(e,Do,o),p(xe,e,o),s(e,Oo,o),s(e,H,o),p(Ie,H,null),r(H,_t),r(H,Oe),s(e,Ko,o),p(ze,e,o),s(e,et,o),s(e,J,o),p(Ue,J,null),r(J,bt),r(J,Ke),r(J,yt),r(J,eo),r(J,Tt),r(J,Q),p(je,Q,null),r(Q,vt),r(Q,oo),r(J,wt),r(J,S),p(We,S,null),r(S,Ct),r(S,to),s(e,ot,o),p(Ge,e,o),s(e,tt,o),s(e,V,o),p(Ze,V,null),r(V,Mt),r(V,no),r(V,Jt),r(V,X),p(Ve,X,null),r(X,kt),r(X,ao),s(e,nt,o),p(Be,e,o),s(e,at,o),s(e,k,o),p(Fe,k,null),r(k,$t),r(k,so),r(k,xt),r(k,ro),r(k,It),r(k,io),r(k,zt),r(k,G),p(Ne,G,null),r(G,Ut),r(G,lo),r(G,jt),r(G,co),r(G,Wt),p(A,G,null),s(e,st,o),p(Re,e,o),s(e,rt,o),s(e,$,o),p(Pe,$,null),r($,Gt),r($,mo),r($,Zt),r($,ho),r($,Vt),r($,po),r($,Bt),r($,F),p(He,F,null),r(F,Ft),r(F,go),r(F,Nt),p(D,F,null),s(e,it,o),p(qe,e,o),s(e,lt,o),s(e,x,o),p(Le,x,null),r(x,Rt),r(x,fo),r(x,Pt),r(x,uo),r(x,Ht),r(x,_o),r(x,qt),r(x,Z),p(Ee,Z,null),r(Z,Lt),r(Z,bo),r(Z,Et),p(O,Z,null),r(Z,Yt),p(K,Z,null),s(e,dt,o),p(Ye,e,o),s(e,ct,o),s(e,wo,o),mt=!0},p(e,[o]){const B={};o&2&&(B.$$scope={dirty:o,ctx:e}),E.$set(B);const Qe={};o&2&&(Qe.$$scope={dirty:o,ctx:e}),Y.$set(Qe);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),A.$set(j);const Se={};o&2&&(Se.$$scope={dirty:o,ctx:e}),D.$set(Se);const Xe={};o&2&&(Xe.$$scope={dirty:o,ctx:e}),O.$set(Xe);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),K.$set(q)},i(e){mt||(g(M.$$.fragment,e),g(te.$$.fragment,e),g(le.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(E.$$.fragment,e),g(we.$$.fragment,e),g(Ce.$$.fragment,e),g(Je.$$.fragment,e),g(ke.$$.fragment,e),g($e.$$.fragment,e),g(Y.$$.fragment,e),g(xe.$$.fragment,e),g(Ie.$$.fragment,e),g(ze.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(We.$$.fragment,e),g(Ge.$$.fragment,e),g(Ze.$$.fragment,e),g(Ve.$$.fragment,e),g(Be.$$.fragment,e),g(Fe.$$.fragment,e),g(Ne.$$.fragment,e),g(A.$$.fragment,e),g(Re.$$.fragment,e),g(Pe.$$.fragment,e),g(He.$$.fragment,e),g(D.$$.fragment,e),g(qe.$$.fragment,e),g(Le.$$.fragment,e),g(Ee.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(Ye.$$.fragment,e),mt=!0)},o(e){f(M.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(E.$$.fragment,e),f(we.$$.fragment,e),f(Ce.$$.fragment,e),f(Je.$$.fragment,e),f(ke.$$.fragment,e),f($e.$$.fragment,e),f(Y.$$.fragment,e),f(xe.$$.fragment,e),f(Ie.$$.fragment,e),f(ze.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(Ze.$$.fragment,e),f(Ve.$$.fragment,e),f(Be.$$.fragment,e),f(Fe.$$.fragment,e),f(Ne.$$.fragment,e),f(A.$$.fragment,e),f(Re.$$.fragment,e),f(Pe.$$.fragment,e),f(He.$$.fragment,e),f(D.$$.fragment,e),f(qe.$$.fragment,e),f(Le.$$.fragment,e),f(Ee.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(Ye.$$.fragment,e),mt=!1},d(e){e&&(t(T),t(c),t(y),t(b),t(w),t(Co),t(Mo),t(ne),t(Jo),t(ae),t(ko),t(se),t($o),t(L),t(xo),t(re),t(Io),t(ie),t(zo),t(Uo),t(de),t(jo),t(ce),t(Wo),t(Go),t(Zo),t(pe),t(Vo),t(Bo),t(Fo),t(ue),t(No),t(Ro),t(Po),t(Ho),t(Te),t(qo),t(Lo),t(ve),t(Eo),t(Yo),t(Qo),t(Me),t(So),t(Xo),t(Ao),t(U),t(Do),t(Oo),t(H),t(Ko),t(et),t(J),t(ot),t(tt),t(V),t(nt),t(at),t(k),t(st),t(rt),t($),t(it),t(lt),t(x),t(dt),t(ct),t(wo)),t(d),u(M,e),u(te,e),u(le,e),u(me,e),u(he,e),u(ge,e),u(fe,e),u(_e,e),u(be,e),u(ye,e),u(E,e),u(we,e),u(Ce,e),u(Je,e),u(ke,e),u($e),u(Y),u(xe,e),u(Ie),u(ze,e),u(Ue),u(je),u(We),u(Ge,e),u(Ze),u(Ve),u(Be,e),u(Fe),u(Ne),u(A),u(Re,e),u(Pe),u(He),u(D),u(qe,e),u(Le),u(Ee),u(O),u(K),u(Ye,e)}}}const En='{"title":"Chameleon","local":"chameleon","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 and SDPA to further speed-up generation","local":"use-flash-attention-2-and-sdpa-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"ChameleonConfig","local":"transformers.ChameleonConfig","sections":[],"depth":2},{"title":"ChameleonVQVAEConfig","local":"transformers.ChameleonVQVAEConfig","sections":[],"depth":2},{"title":"ChameleonProcessor","local":"transformers.ChameleonProcessor","sections":[],"depth":2},{"title":"ChameleonImageProcessor","local":"transformers.ChameleonImageProcessor","sections":[],"depth":2},{"title":"ChameleonVQVAE","local":"transformers.ChameleonVQVAE","sections":[],"depth":2},{"title":"ChameleonModel","local":"transformers.ChameleonModel","sections":[],"depth":2},{"title":"ChameleonForConditionalGeneration","local":"transformers.ChameleonForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Yn(z){return Wn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Gn{constructor(d){super(),Zn(this,d,Yn,Ln,Un,{})}}export{oa as component};
