import{s as ts,o as ns,n as V}from"../chunks/scheduler.18a86fab.js";import{S as os,i as ss,g as d,s as r,r as u,A as rs,h as c,f as i,c as a,j as $,u as f,x as h,k as v,y as n,a as m,v as g,d as _,t as M,w as b}from"../chunks/index.98837b22.js";import{T as nt}from"../chunks/Tip.77304350.js";import{D as E}from"../chunks/Docstring.6758ea23.js";import{C as Nt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as qt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as P}from"../chunks/Heading.7e7e0c5b.js";import{E as as}from"../chunks/index.92f616ba.js";function is(w){let t,y=`This model is in maintenance mode only, we don’t accept any new PRs changing its code.
If you run into any issues running this model, please reinstall the last version that supported this model: v4.40.2.
You can do so by running the following command: <code>pip install -U transformers==4.40.2</code>.`;return{c(){t=d("p"),t.innerHTML=y},l(l){t=c(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1sq0hrb"&&(t.innerHTML=y)},m(l,p){m(l,t,p)},p:V,d(l){l&&i(t)}}}function ls(w){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=y},l(l){t=c(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,p){m(l,t,p)},p:V,d(l){l&&i(t)}}}function ds(w){let t,y="Example:",l,p,T;return p=new Nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMModel.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=d("p"),t.textContent=y,l=r(),u(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),l=a(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,l,k),g(p,o,k),T=!0},p:V,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(i(t),i(l)),b(p,o)}}}function cs(w){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=y},l(l){t=c(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,p){m(l,t,p)},p:V,d(l){l&&i(t)}}}function ps(w){let t,y="Example of single-label classification:",l,p,T;return p=new Nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzKSUwQSUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxJTVEKSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_id = logits.argmax().item()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, num_labels=num_labels)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=d("p"),t.textContent=y,l=r(),u(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-ykxpe4"&&(t.textContent=y),l=a(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,l,k),g(p,o,k),T=!0},p:V,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(i(t),i(l)),b(p,o)}}}function ms(w){let t,y="Example of multi-label classification:",l,p,T;return p=new Nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIlMkMlMjBwcm9ibGVtX3R5cGUlM0QlMjJtdWx0aV9sYWJlbF9jbGFzc2lmaWNhdGlvbiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfY2xhc3NfaWRzJTIwJTNEJTIwdG9yY2guYXJhbmdlKDAlMkMlMjBsb2dpdHMuc2hhcGUlNUItMSU1RCklNUJ0b3JjaC5zaWdtb2lkKGxvZ2l0cykuc3F1ZWV6ZShkaW0lM0QwKSUyMCUzRSUyMDAuNSU1RCUwQSUwQSUyMyUyMFRvJTIwdHJhaW4lMjBhJTIwbW9kZWwlMjBvbiUyMCU2MG51bV9sYWJlbHMlNjAlMjBjbGFzc2VzJTJDJTIweW91JTIwY2FuJTIwcGFzcyUyMCU2MG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTYwJTIwdG8lMjAlNjAuZnJvbV9wcmV0cmFpbmVkKC4uLiklNjAlMEFudW1fbGFiZWxzJTIwJTNEJTIwbGVuKG1vZGVsLmNvbmZpZy5pZDJsYWJlbCklMEFtb2RlbCUyMCUzRCUyMEVybmllTUZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiUyQyUyMG51bV9sYWJlbHMlM0RudW1fbGFiZWxzJTJDJTIwcHJvYmxlbV90eXBlJTNEJTIybXVsdGlfbGFiZWxfY2xhc3NpZmljYXRpb24lMjIlMEEpJTBBJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2guc3VtKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwub25lX2hvdChwcmVkaWN0ZWRfY2xhc3NfaWRzJTVCTm9uZSUyQyUyMCUzQSU1RC5jbG9uZSgpJTJDJTIwbnVtX2NsYXNzZXMlM0RudW1fbGFiZWxzKSUyQyUyMGRpbSUzRDElMEEpLnRvKHRvcmNoLmZsb2F0KSUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.arange(<span class="hljs-number">0</span>, logits.shape[-<span class="hljs-number">1</span>])[torch.sigmoid(logits).squeeze(dim=<span class="hljs-number">0</span>) &gt; <span class="hljs-number">0.5</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To train a model on \`num_labels\` classes, you can pass \`num_labels=num_labels\` to \`.from_pretrained(...)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_labels = <span class="hljs-built_in">len</span>(model.config.id2label)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForSequenceClassification.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>, num_labels=num_labels, problem_type=<span class="hljs-string">&quot;multi_label_classification&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.<span class="hljs-built_in">sum</span>(
<span class="hljs-meta">... </span>    torch.nn.functional.one_hot(predicted_class_ids[<span class="hljs-literal">None</span>, :].clone(), num_classes=num_labels), dim=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>).to(torch.<span class="hljs-built_in">float</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=d("p"),t.textContent=y,l=r(),u(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1l8e32d"&&(t.textContent=y),l=a(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,l,k),g(p,o,k),T=!0},p:V,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(i(t),i(l)),b(p,o)}}}function hs(w){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=y},l(l){t=c(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,p){m(l,t,p)},p:V,d(l){l&&i(t)}}}function us(w){let t,y="Example:",l,p,T;return p=new Nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JNdWx0aXBsZUNob2ljZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJJbiUyMEl0YWx5JTJDJTIwcGl6emElMjBzZXJ2ZWQlMjBpbiUyMGZvcm1hbCUyMHNldHRpbmdzJTJDJTIwc3VjaCUyMGFzJTIwYXQlMjBhJTIwcmVzdGF1cmFudCUyQyUyMGlzJTIwcHJlc2VudGVkJTIwdW5zbGljZWQuJTIyJTBBY2hvaWNlMCUyMCUzRCUyMCUyMkl0JTIwaXMlMjBlYXRlbiUyMHdpdGglMjBhJTIwZm9yayUyMGFuZCUyMGElMjBrbmlmZS4lMjIlMEFjaG9pY2UxJTIwJTNEJTIwJTIySXQlMjBpcyUyMGVhdGVuJTIwd2hpbGUlMjBoZWxkJTIwaW4lMjB0aGUlMjBoYW5kLiUyMiUwQWxhYmVscyUyMCUzRCUyMHRvcmNoLnRlbnNvcigwKS51bnNxdWVlemUoMCklMjAlMjAlMjMlMjBjaG9pY2UwJTIwaXMlMjBjb3JyZWN0JTIwKGFjY29yZGluZyUyMHRvJTIwV2lraXBlZGlhJTIwJTNCKSklMkMlMjBiYXRjaCUyMHNpemUlMjAxJTBBJTBBZW5jb2RpbmclMjAlM0QlMjB0b2tlbml6ZXIoJTVCcHJvbXB0JTJDJTIwcHJvbXB0JTVEJTJDJTIwJTVCY2hvaWNlMCUyQyUyMGNob2ljZTElNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQSUyMHYudW5zcXVlZXplKDApJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklN0QlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTIwJTIwJTIzJTIwYmF0Y2glMjBzaXplJTIwaXMlMjAxJTBBJTBBJTIzJTIwdGhlJTIwbGluZWFyJTIwY2xhc3NpZmllciUyMHN0aWxsJTIwbmVlZHMlMjB0byUyMGJlJTIwdHJhaW5lZCUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;In Italy, pizza served in formal settings, such as at a restaurant, is presented unsliced.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice0 = <span class="hljs-string">&quot;It is eaten with a fork and a knife.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>choice1 = <span class="hljs-string">&quot;It is eaten while held in the hand.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)  <span class="hljs-comment"># choice0 is correct (according to Wikipedia ;)), batch size 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer([prompt, prompt], [choice0, choice1], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items()}, labels=labels)  <span class="hljs-comment"># batch size is 1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the linear classifier still needs to be trained</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=d("p"),t.textContent=y,l=r(),u(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),l=a(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,l,k),g(p,o,k),T=!0},p:V,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(i(t),i(l)),b(p,o)}}}function fs(w){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=y},l(l){t=c(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,p){m(l,t,p)},p:V,d(l){l&&i(t)}}}function gs(w){let t,y="Example:",l,p,T;return p=new Nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBbW9kZWwlMjAlM0QlMjBFcm5pZU1Gb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGZXJuaWUtbS1iYXNlX3B5dG9yY2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCUyMkh1Z2dpbmdGYWNlJTIwaXMlMjBhJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBQYXJpcyUyMGFuZCUyME5ldyUyMFlvcmslMjIlMkMlMjBhZGRfc3BlY2lhbF90b2tlbnMlM0RGYWxzZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMEEpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEFwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSklMEElMEElMjMlMjBOb3RlJTIwdGhhdCUyMHRva2VucyUyMGFyZSUyMGNsYXNzaWZpZWQlMjByYXRoZXIlMjB0aGVuJTIwaW5wdXQlMjB3b3JkcyUyMHdoaWNoJTIwbWVhbnMlMjB0aGF0JTBBJTIzJTIwdGhlcmUlMjBtaWdodCUyMGJlJTIwbW9yZSUyMHByZWRpY3RlZCUyMHRva2VuJTIwY2xhc3NlcyUyMHRoYW4lMjB3b3Jkcy4lMEElMjMlMjBNdWx0aXBsZSUyMHRva2VuJTIwY2xhc3NlcyUyMG1pZ2h0JTIwYWNjb3VudCUyMGZvciUyMHRoZSUyMHNhbWUlMjB3b3JkJTBBcHJlZGljdGVkX3Rva2Vuc19jbGFzc2VzJTIwJTNEJTIwJTVCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCdC5pdGVtKCklNUQlMjBmb3IlMjB0JTIwaW4lMjBwcmVkaWN0ZWRfdG9rZW5fY2xhc3NfaWRzJTVCMCU1RCU1RCUwQSUwQWxhYmVscyUyMCUzRCUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMEFsb3NzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForTokenClassification.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=d("p"),t.textContent=y,l=r(),u(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),l=a(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,l,k),g(p,o,k),T=!0},p:V,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(i(t),i(l)),b(p,o)}}}function _s(w){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=y},l(l){t=c(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,p){m(l,t,p)},p:V,d(l){l&&i(t)}}}function Ms(w){let t,y="Example:",l,p,T;return p=new Nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBFcm5pZU1Gb3JRdWVzdGlvbkFuc3dlcmluZyUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRmVybmllLW0tYmFzZV9weXRvcmNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwRXJuaWVNRm9yUXVlc3Rpb25BbnN3ZXJpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZlcm5pZS1tLWJhc2VfcHl0b3JjaCUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, ErnieMForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ErnieMForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;susnato/ernie-m-base_pytorch&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){t=d("p"),t.textContent=y,l=r(),u(p.$$.fragment)},l(o){t=c(o,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=y),l=a(o),f(p.$$.fragment,o)},m(o,k){m(o,t,k),m(o,l,k),g(p,o,k),T=!0},p:V,i(o){T||(_(p.$$.fragment,o),T=!0)},o(o){M(p.$$.fragment,o),T=!1},d(o){o&&(i(t),i(l)),b(p,o)}}}function bs(w){let t,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=y},l(l){t=c(l,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=y)},m(l,p){m(l,t,p)},p:V,d(l){l&&i(t)}}}function ys(w){let t,y,l,p,T,o,k,_o='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Gt,ne,Vt,be,Lt,ye,Mo=`The ErnieM model was proposed in <a href="https://arxiv.org/abs/2012.15674" rel="nofollow">ERNIE-M: Enhanced Multilingual Representation by Aligning
Cross-lingual Semantics with Monolingual Corpora</a>  by Xuan Ouyang, Shuohuan Wang, Chao Pang, Yu Sun,
Hao Tian, Hua Wu, Haifeng Wang.`,Rt,Te,bo="The abstract from the paper is the following:",Xt,ke,yo=`<em>Recent studies have demonstrated that pre-trained cross-lingual models achieve impressive performance in downstream cross-lingual tasks. This improvement benefits from learning a large amount of monolingual and parallel corpora. Although it is generally acknowledged that parallel corpora are critical for improving the model performance, existing methods are often constrained by the size of parallel corpora, especially for lowresource languages. In this paper, we propose ERNIE-M, a new training method that encourages the model to align the representation of multiple languages with monolingual corpora, to overcome the constraint that the parallel corpus size places on the model performance. Our key insight is to integrate back-translation into the pre-training process. We generate pseudo-parallel sentence pairs on a monolingual corpus to enable the learning of semantic alignments between different languages, thereby enhancing the semantic modeling of cross-lingual models. Experimental results show that ERNIE-M outperforms existing cross-lingual models and delivers new state-of-the-art results in various cross-lingual downstream tasks.</em>
This model was contributed by <a href="https://huggingface.co/susnato" rel="nofollow">Susnato Dhar</a>. The original code can be found <a href="https://github.com/PaddlePaddle/PaddleNLP/tree/develop/paddlenlp/transformers/ernie_m" rel="nofollow">here</a>.`,St,we,Pt,ve,To="<li>Ernie-M is a BERT-like model so it is a stacked Transformer Encoder.</li> <li>Instead of using MaskedLM for pretraining (like BERT) the authors used two novel techniques: <code>Cross-attention Masked Language Modeling</code> and <code>Back-translation Masked Language Modeling</code>. For now these two LMHead objectives are not implemented here.</li> <li>It is a multilingual language model.</li> <li>Next Sentence Prediction was not used in pretraining process.</li>",Qt,$e,At,Ee,ko='<li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/token_classification">Token classification task guide</a></li> <li><a href="../tasks/question_answering">Question answering task guide</a></li> <li><a href="../tasks/multiple_choice">Multiple choice task guide</a></li>',Yt,Ce,Ot,Z,xe,gn,ot,wo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>. It is used to instantiate a
Ernie-M model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <code>Ernie-M</code> <a href="https://huggingface.co/susnato/ernie-m-base_pytorch" rel="nofollow">susnato/ernie-m-base_pytorch</a> architecture.`,_n,st,vo=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Mn,rt,$o=`A normal_initializer initializes weight matrices as normal distributions. See
<code>ErnieMPretrainedModel._init_weights()</code> for how weights are initialized in <code>ErnieMModel</code>.`,Dt,je,Kt,C,Je,bn,at,Eo="Constructs a Ernie-M tokenizer. It uses the <code>sentencepiece</code> tools to cut the words to sub-words.",yn,O,ze,Tn,it,Co=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An ErnieM sequence has the following format:`,kn,lt,xo="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences: <code>[CLS] A [SEP] [SEP] B [SEP]</code></li>",wn,oe,Ue,vn,dt,jo=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>encode</code> method.`,$n,se,Fe,En,ct,Jo=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a> Should be overridden in a subclass if the model has a special way of
building: those.`,Cn,pt,Ie,en,We,tn,x,Ze,xn,mt,zo="The bare ErnieM Model transformer outputting raw hidden-states without any specific head on top.",jn,ht,Uo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Jn,ut,Fo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,zn,L,qe,Un,ft,Io='The <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a> forward method, overrides the <code>__call__</code> special method.',Fn,re,In,ae,nn,Ne,on,j,He,Wn,gt,Wo=`ErnieM Model transformer with a sequence classification/regression head on top (a linear layer on top of
the pooled output) e.g. for GLUE tasks.`,Zn,_t,Zo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,qn,Mt,qo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Nn,W,Be,Hn,bt,No='The <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForSequenceClassification">ErnieMForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',Bn,ie,Gn,le,Vn,de,sn,Ge,rn,J,Ve,Ln,yt,Ho=`ErnieM Model with a multiple choice classification head on top (a linear layer on top of
the pooled output and a softmax) e.g. for RocStories/SWAG tasks.`,Rn,Tt,Bo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xn,kt,Go=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Sn,R,Le,Pn,wt,Vo='The <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForMultipleChoice">ErnieMForMultipleChoice</a> forward method, overrides the <code>__call__</code> special method.',Qn,ce,An,pe,an,Re,ln,z,Xe,Yn,vt,Lo=`ErnieM Model with a token classification head on top (a linear layer on top of
the hidden-states output) e.g. for Named-Entity-Recognition (NER) tasks.`,On,$t,Ro=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Dn,Et,Xo=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Kn,X,Se,eo,Ct,So='The <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForTokenClassification">ErnieMForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',to,me,no,he,dn,Pe,cn,U,Qe,oo,xt,Po=`ErnieM Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,so,jt,Qo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ro,Jt,Ao=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ao,S,Ae,io,zt,Yo='The <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForQuestionAnswering">ErnieMForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',lo,ue,co,fe,pn,Ye,mn,F,Oe,po,Ut,Oo=`ErnieMForInformationExtraction is a Ernie-M Model with two linear layer on top of the hidden-states output to
compute <code>start_prob</code> and <code>end_prob</code>, designed for Universal Information Extraction.`,mo,Ft,Do=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ho,It,Ko=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,uo,D,De,fo,Wt,es='The <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMForInformationExtraction">ErnieMForInformationExtraction</a> forward method, overrides the <code>__call__</code> special method.',go,ge,hn,Ke,un,Ht,fn;return T=new P({props:{title:"ErnieM",local:"erniem",headingTag:"h1"}}),ne=new nt({props:{warning:!0,$$slots:{default:[is]},$$scope:{ctx:w}}}),be=new P({props:{title:"Overview",local:"overview",headingTag:"h2"}}),we=new P({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),$e=new P({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ce=new P({props:{title:"ErnieMConfig",local:"transformers.ErnieMConfig",headingTag:"h2"}}),xe=new E({props:{name:"class transformers.ErnieMConfig",anchor:"transformers.ErnieMConfig",parameters:[{name:"vocab_size",val:": int = 250002"},{name:"hidden_size",val:": int = 768"},{name:"num_hidden_layers",val:": int = 12"},{name:"num_attention_heads",val:": int = 12"},{name:"intermediate_size",val:": int = 3072"},{name:"hidden_act",val:": str = 'gelu'"},{name:"hidden_dropout_prob",val:": float = 0.1"},{name:"attention_probs_dropout_prob",val:": float = 0.1"},{name:"max_position_embeddings",val:": int = 514"},{name:"initializer_range",val:": float = 0.02"},{name:"pad_token_id",val:": int = 1"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"classifier_dropout",val:" = None"},{name:"act_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieMConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 250002) &#x2014;
Vocabulary size of <code>inputs_ids</code> in <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>. Also is the vocab size of token embedding matrix.
Defines the number of different tokens that can be represented by the <code>inputs_ids</code> passed when calling
<a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMModel">ErnieMModel</a>.`,name:"vocab_size"},{anchor:"transformers.ErnieMConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the embedding layer, encoder layers and pooler layer.`,name:"hidden_size"},{anchor:"transformers.ErnieMConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.ErnieMConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.ErnieMConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the feed-forward (ff) layer in the encoder. Input tensors to feed-forward layers are
firstly projected from hidden_size to intermediate_size, and then projected back to hidden_size. Typically
intermediate_size is larger than hidden_size.`,name:"intermediate_size"},{anchor:"transformers.ErnieMConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function in the feed-forward layer. <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code> and any other torch
supported activation functions are supported.`,name:"hidden_act"},{anchor:"transformers.ErnieMConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.ErnieMConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability used in <code>MultiHeadAttention</code> in all encoder layers to drop some attention target.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.ErnieMConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 514) &#x2014;
The maximum value of the dimensionality of position encoding, which dictates the maximum supported length
of an input sequence.`,name:"max_position_embeddings"},{anchor:"transformers.ErnieMConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the normal initializer for initializing all weight matrices. The index of padding
token in the token vocabulary.`,name:"initializer_range"},{anchor:"transformers.ErnieMConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.ErnieMConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.ErnieMConfig.classifier_dropout",description:`<strong>classifier_dropout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The dropout ratio for the classification head.`,name:"classifier_dropout"},{anchor:"transformers.ErnieMConfig.act_dropout",description:`<strong>act_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This dropout probability is used in <code>ErnieMEncoderLayer</code> after activation.`,name:"act_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/configuration_ernie_m.py#L25"}}),je=new P({props:{title:"ErnieMTokenizer",local:"transformers.ErnieMTokenizer",headingTag:"h2"}}),Je=new E({props:{name:"class transformers.ErnieMTokenizer",anchor:"transformers.ErnieMTokenizer",parameters:[{name:"sentencepiece_model_ckpt",val:""},{name:"vocab_file",val:" = None"},{name:"do_lower_case",val:" = False"},{name:"encoding",val:" = 'utf8'"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"sp_model_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.sentencepiece_model_file",description:`<strong>sentencepiece_model_file</strong> (<code>str</code>) &#x2014;
The file path of sentencepiece model.`,name:"sentencepiece_model_file"},{anchor:"transformers.ErnieMTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The file path of the vocabulary.`,name:"vocab_file"},{anchor:"transformers.ErnieMTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>str</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.ErnieMTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
A special token representing the <code>unknown (out-of-vocabulary)</code> token. An unknown token is set to be
<code>unk_token</code> inorder to be converted to an ID.`,name:"unk_token"},{anchor:"transformers.ErnieMTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
A special token separating two different sentences in the same input.`,name:"sep_token"},{anchor:"transformers.ErnieMTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
A special token used to make arrays of tokens the same size for batching purposes.`,name:"pad_token"},{anchor:"transformers.ErnieMTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
A special token used for sequence classification. It is the last token of the sequence when built with
special tokens.`,name:"cls_token"},{anchor:"transformers.ErnieMTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
A special token representing a masked token. This is the token used in the masked language modeling task
which the model tries to predict the original unmasked ones.`,name:"mask_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/tokenization_ernie_m.py#L42"}}),ze=new E({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/tokenization_ernie_m.py#L242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of input_id with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ue=new E({props:{name:"get_special_tokens_mask",anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"},{name:"already_has_special_tokens",val:" = False"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.ErnieMTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/tokenization_ernie_m.py#L285",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Fe=new E({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The first tokenized sequence.`,name:"token_ids_0"},{anchor:"transformers.ErnieMTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The second tokenized sequence.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/tokenization_ernie_m.py#L314",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),Ie=new E({props:{name:"save_vocabulary",anchor:"transformers.ErnieMTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/tokenization_ernie_m.py#L383"}}),We=new P({props:{title:"ErnieMModel",local:"transformers.ErnieMModel",headingTag:"h2"}}),Ze=new E({props:{name:"class transformers.ErnieMModel",anchor:"transformers.ErnieMModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"}],parametersDescription:[{anchor:"transformers.ErnieMModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L481"}}),qe=new E({props:{name:"forward",anchor:"transformers.ErnieMModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[<built-in method tensor of type object at 0x7f3d4da1fec0>] = None"},{name:"position_ids",val:": typing.Optional[<built-in method tensor of type object at 0x7f3d4da1fec0>] = None"},{name:"attention_mask",val:": typing.Optional[<built-in method tensor of type object at 0x7f3d4da1fec0>] = None"},{name:"head_mask",val:": typing.Optional[<built-in method tensor of type object at 0x7f3d4da1fec0>] = None"},{name:"inputs_embeds",val:": typing.Optional[<built-in method tensor of type object at 0x7f3d4da1fec0>] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[<built-in method tensor of type object at 0x7f3d4da1fec0>]]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.ErnieMModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L508",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),re=new nt({props:{$$slots:{default:[ls]},$$scope:{ctx:w}}}),ae=new qt({props:{anchor:"transformers.ErnieMModel.forward.example",$$slots:{default:[ds]},$$scope:{ctx:w}}}),Ne=new P({props:{title:"ErnieMForSequenceClassification",local:"transformers.ErnieMForSequenceClassification",headingTag:"h2"}}),He=new E({props:{name:"class transformers.ErnieMForSequenceClassification",anchor:"transformers.ErnieMForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L594"}}),Be=new E({props:{name:"forward",anchor:"transformers.ErnieMForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.ErnieMForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L615",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SequenceClassifierOutput"
>transformers.modeling_outputs.SequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ie=new nt({props:{$$slots:{default:[cs]},$$scope:{ctx:w}}}),le=new qt({props:{anchor:"transformers.ErnieMForSequenceClassification.forward.example",$$slots:{default:[ps]},$$scope:{ctx:w}}}),de=new qt({props:{anchor:"transformers.ErnieMForSequenceClassification.forward.example-2",$$slots:{default:[ms]},$$scope:{ctx:w}}}),Ge=new P({props:{title:"ErnieMForMultipleChoice",local:"transformers.ErnieMForMultipleChoice",headingTag:"h2"}}),Ve=new E({props:{name:"class transformers.ErnieMForMultipleChoice",anchor:"transformers.ErnieMForMultipleChoice",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForMultipleChoice.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L695"}}),Le=new E({props:{name:"forward",anchor:"transformers.ErnieMForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForMultipleChoice.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForMultipleChoice.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForMultipleChoice.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForMultipleChoice.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForMultipleChoice.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForMultipleChoice.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForMultipleChoice.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the multiple choice classification loss. Indices should be in <code>[0, ..., num_choices-1]</code> where <code>num_choices</code> is the size of the second dimension of the input tensors. (See
<code>input_ids</code> above)`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L714",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <em>(1,)</em>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices)</code>) — <em>num_choices</em> is the second dimension of the input tensors. (see <em>input_ids</em> above).</p>
<p>Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MultipleChoiceModelOutput"
>transformers.modeling_outputs.MultipleChoiceModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ce=new nt({props:{$$slots:{default:[hs]},$$scope:{ctx:w}}}),pe=new qt({props:{anchor:"transformers.ErnieMForMultipleChoice.forward.example",$$slots:{default:[us]},$$scope:{ctx:w}}}),Re=new P({props:{title:"ErnieMForTokenClassification",local:"transformers.ErnieMForTokenClassification",headingTag:"h2"}}),Xe=new E({props:{name:"class transformers.ErnieMForTokenClassification",anchor:"transformers.ErnieMForTokenClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L784"}}),Se=new E({props:{name:"forward",anchor:"transformers.ErnieMForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.ErnieMForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForTokenClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the token classification loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L804",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),me=new nt({props:{$$slots:{default:[fs]},$$scope:{ctx:w}}}),he=new qt({props:{anchor:"transformers.ErnieMForTokenClassification.forward.example",$$slots:{default:[gs]},$$scope:{ctx:w}}}),Pe=new P({props:{title:"ErnieMForQuestionAnswering",local:"transformers.ErnieMForQuestionAnswering",headingTag:"h2"}}),Qe=new E({props:{name:"class transformers.ErnieMForQuestionAnswering",anchor:"transformers.ErnieMForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L864"}}),Ae=new E({props:{name:"forward",anchor:"transformers.ErnieMForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ErnieMForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L880",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig"
>ErnieMConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new nt({props:{$$slots:{default:[_s]},$$scope:{ctx:w}}}),fe=new qt({props:{anchor:"transformers.ErnieMForQuestionAnswering.forward.example",$$slots:{default:[Ms]},$$scope:{ctx:w}}}),Ye=new P({props:{title:"ErnieMForInformationExtraction",local:"transformers.ErnieMForInformationExtraction",headingTag:"h2"}}),Oe=new E({props:{name:"class transformers.ErnieMForInformationExtraction",anchor:"transformers.ErnieMForInformationExtraction",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.ErnieMForInformationExtraction.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMConfig">ErnieMConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L960"}}),De=new E({props:{name:"forward",anchor:"transformers.ErnieMForInformationExtraction.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"end_positions",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = True"}],parametersDescription:[{anchor:"transformers.ErnieMForInformationExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/ernie_m#transformers.ErnieMTokenizer">ErnieMTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ErnieMForInformationExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.ErnieMForInformationExtraction.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.ErnieMForInformationExtraction.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.ErnieMForInformationExtraction.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_choices, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.ErnieMForInformationExtraction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.ErnieMForInformationExtraction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.ErnieMForInformationExtraction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.ErnieMForInformationExtraction.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for position (index) for computing the start_positions loss. Position outside of the sequence are
not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.ErnieMForInformationExtraction.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) for computing the end_positions loss. Position outside of the sequence are not
taken into account for computing the loss.`,name:"end_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/deprecated/ernie_m/modeling_ernie_m.py#L974"}}),ge=new nt({props:{$$slots:{default:[bs]},$$scope:{ctx:w}}}),Ke=new as({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/ernie_m.md"}}),{c(){t=d("meta"),y=r(),l=d("p"),p=r(),u(T.$$.fragment),o=r(),k=d("div"),k.innerHTML=_o,Gt=r(),u(ne.$$.fragment),Vt=r(),u(be.$$.fragment),Lt=r(),ye=d("p"),ye.innerHTML=Mo,Rt=r(),Te=d("p"),Te.textContent=bo,Xt=r(),ke=d("p"),ke.innerHTML=yo,St=r(),u(we.$$.fragment),Pt=r(),ve=d("ul"),ve.innerHTML=To,Qt=r(),u($e.$$.fragment),At=r(),Ee=d("ul"),Ee.innerHTML=ko,Yt=r(),u(Ce.$$.fragment),Ot=r(),Z=d("div"),u(xe.$$.fragment),gn=r(),ot=d("p"),ot.innerHTML=wo,_n=r(),st=d("p"),st.innerHTML=vo,Mn=r(),rt=d("p"),rt.innerHTML=$o,Dt=r(),u(je.$$.fragment),Kt=r(),C=d("div"),u(Je.$$.fragment),bn=r(),at=d("p"),at.innerHTML=Eo,yn=r(),O=d("div"),u(ze.$$.fragment),Tn=r(),it=d("p"),it.textContent=Co,kn=r(),lt=d("ul"),lt.innerHTML=xo,wn=r(),oe=d("div"),u(Ue.$$.fragment),vn=r(),dt=d("p"),dt.innerHTML=jo,$n=r(),se=d("div"),u(Fe.$$.fragment),En=r(),ct=d("p"),ct.innerHTML=Jo,Cn=r(),pt=d("div"),u(Ie.$$.fragment),en=r(),u(We.$$.fragment),tn=r(),x=d("div"),u(Ze.$$.fragment),xn=r(),mt=d("p"),mt.textContent=zo,jn=r(),ht=d("p"),ht.innerHTML=Uo,Jn=r(),ut=d("p"),ut.innerHTML=Fo,zn=r(),L=d("div"),u(qe.$$.fragment),Un=r(),ft=d("p"),ft.innerHTML=Io,Fn=r(),u(re.$$.fragment),In=r(),u(ae.$$.fragment),nn=r(),u(Ne.$$.fragment),on=r(),j=d("div"),u(He.$$.fragment),Wn=r(),gt=d("p"),gt.textContent=Wo,Zn=r(),_t=d("p"),_t.innerHTML=Zo,qn=r(),Mt=d("p"),Mt.innerHTML=qo,Nn=r(),W=d("div"),u(Be.$$.fragment),Hn=r(),bt=d("p"),bt.innerHTML=No,Bn=r(),u(ie.$$.fragment),Gn=r(),u(le.$$.fragment),Vn=r(),u(de.$$.fragment),sn=r(),u(Ge.$$.fragment),rn=r(),J=d("div"),u(Ve.$$.fragment),Ln=r(),yt=d("p"),yt.textContent=Ho,Rn=r(),Tt=d("p"),Tt.innerHTML=Bo,Xn=r(),kt=d("p"),kt.innerHTML=Go,Sn=r(),R=d("div"),u(Le.$$.fragment),Pn=r(),wt=d("p"),wt.innerHTML=Vo,Qn=r(),u(ce.$$.fragment),An=r(),u(pe.$$.fragment),an=r(),u(Re.$$.fragment),ln=r(),z=d("div"),u(Xe.$$.fragment),Yn=r(),vt=d("p"),vt.textContent=Lo,On=r(),$t=d("p"),$t.innerHTML=Ro,Dn=r(),Et=d("p"),Et.innerHTML=Xo,Kn=r(),X=d("div"),u(Se.$$.fragment),eo=r(),Ct=d("p"),Ct.innerHTML=So,to=r(),u(me.$$.fragment),no=r(),u(he.$$.fragment),dn=r(),u(Pe.$$.fragment),cn=r(),U=d("div"),u(Qe.$$.fragment),oo=r(),xt=d("p"),xt.innerHTML=Po,so=r(),jt=d("p"),jt.innerHTML=Qo,ro=r(),Jt=d("p"),Jt.innerHTML=Ao,ao=r(),S=d("div"),u(Ae.$$.fragment),io=r(),zt=d("p"),zt.innerHTML=Yo,lo=r(),u(ue.$$.fragment),co=r(),u(fe.$$.fragment),pn=r(),u(Ye.$$.fragment),mn=r(),F=d("div"),u(Oe.$$.fragment),po=r(),Ut=d("p"),Ut.innerHTML=Oo,mo=r(),Ft=d("p"),Ft.innerHTML=Do,ho=r(),It=d("p"),It.innerHTML=Ko,uo=r(),D=d("div"),u(De.$$.fragment),fo=r(),Wt=d("p"),Wt.innerHTML=es,go=r(),u(ge.$$.fragment),hn=r(),u(Ke.$$.fragment),un=r(),Ht=d("p"),this.h()},l(e){const s=rs("svelte-u9bgzb",document.head);t=c(s,"META",{name:!0,content:!0}),s.forEach(i),y=a(e),l=c(e,"P",{}),$(l).forEach(i),p=a(e),f(T.$$.fragment,e),o=a(e),k=c(e,"DIV",{class:!0,"data-svelte-h":!0}),h(k)!=="svelte-13t8s2t"&&(k.innerHTML=_o),Gt=a(e),f(ne.$$.fragment,e),Vt=a(e),f(be.$$.fragment,e),Lt=a(e),ye=c(e,"P",{"data-svelte-h":!0}),h(ye)!=="svelte-1leh8xw"&&(ye.innerHTML=Mo),Rt=a(e),Te=c(e,"P",{"data-svelte-h":!0}),h(Te)!=="svelte-vfdo9a"&&(Te.textContent=bo),Xt=a(e),ke=c(e,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-15v2r9b"&&(ke.innerHTML=yo),St=a(e),f(we.$$.fragment,e),Pt=a(e),ve=c(e,"UL",{"data-svelte-h":!0}),h(ve)!=="svelte-ipjuel"&&(ve.innerHTML=To),Qt=a(e),f($e.$$.fragment,e),At=a(e),Ee=c(e,"UL",{"data-svelte-h":!0}),h(Ee)!=="svelte-1521k64"&&(Ee.innerHTML=ko),Yt=a(e),f(Ce.$$.fragment,e),Ot=a(e),Z=c(e,"DIV",{class:!0});var Q=$(Z);f(xe.$$.fragment,Q),gn=a(Q),ot=c(Q,"P",{"data-svelte-h":!0}),h(ot)!=="svelte-1jx0izf"&&(ot.innerHTML=wo),_n=a(Q),st=c(Q,"P",{"data-svelte-h":!0}),h(st)!=="svelte-o55m63"&&(st.innerHTML=vo),Mn=a(Q),rt=c(Q,"P",{"data-svelte-h":!0}),h(rt)!=="svelte-199crak"&&(rt.innerHTML=$o),Q.forEach(i),Dt=a(e),f(je.$$.fragment,e),Kt=a(e),C=c(e,"DIV",{class:!0});var I=$(C);f(Je.$$.fragment,I),bn=a(I),at=c(I,"P",{"data-svelte-h":!0}),h(at)!=="svelte-16hpk2a"&&(at.innerHTML=Eo),yn=a(I),O=c(I,"DIV",{class:!0});var te=$(O);f(ze.$$.fragment,te),Tn=a(te),it=c(te,"P",{"data-svelte-h":!0}),h(it)!=="svelte-ld95nz"&&(it.textContent=Co),kn=a(te),lt=c(te,"UL",{"data-svelte-h":!0}),h(lt)!=="svelte-fnydu1"&&(lt.innerHTML=xo),te.forEach(i),wn=a(I),oe=c(I,"DIV",{class:!0});var et=$(oe);f(Ue.$$.fragment,et),vn=a(et),dt=c(et,"P",{"data-svelte-h":!0}),h(dt)!=="svelte-9bhc6n"&&(dt.innerHTML=jo),et.forEach(i),$n=a(I),se=c(I,"DIV",{class:!0});var tt=$(se);f(Fe.$$.fragment,tt),En=a(tt),ct=c(tt,"P",{"data-svelte-h":!0}),h(ct)!=="svelte-sahzwn"&&(ct.innerHTML=Jo),tt.forEach(i),Cn=a(I),pt=c(I,"DIV",{class:!0});var Bt=$(pt);f(Ie.$$.fragment,Bt),Bt.forEach(i),I.forEach(i),en=a(e),f(We.$$.fragment,e),tn=a(e),x=c(e,"DIV",{class:!0});var q=$(x);f(Ze.$$.fragment,q),xn=a(q),mt=c(q,"P",{"data-svelte-h":!0}),h(mt)!=="svelte-x3zjez"&&(mt.textContent=zo),jn=a(q),ht=c(q,"P",{"data-svelte-h":!0}),h(ht)!=="svelte-6pahdo"&&(ht.innerHTML=Uo),Jn=a(q),ut=c(q,"P",{"data-svelte-h":!0}),h(ut)!=="svelte-68lg8f"&&(ut.innerHTML=Fo),zn=a(q),L=c(q,"DIV",{class:!0});var A=$(L);f(qe.$$.fragment,A),Un=a(A),ft=c(A,"P",{"data-svelte-h":!0}),h(ft)!=="svelte-19qxv8a"&&(ft.innerHTML=Io),Fn=a(A),f(re.$$.fragment,A),In=a(A),f(ae.$$.fragment,A),A.forEach(i),q.forEach(i),nn=a(e),f(Ne.$$.fragment,e),on=a(e),j=c(e,"DIV",{class:!0});var N=$(j);f(He.$$.fragment,N),Wn=a(N),gt=c(N,"P",{"data-svelte-h":!0}),h(gt)!=="svelte-jluzg6"&&(gt.textContent=Wo),Zn=a(N),_t=c(N,"P",{"data-svelte-h":!0}),h(_t)!=="svelte-6pahdo"&&(_t.innerHTML=Zo),qn=a(N),Mt=c(N,"P",{"data-svelte-h":!0}),h(Mt)!=="svelte-68lg8f"&&(Mt.innerHTML=qo),Nn=a(N),W=c(N,"DIV",{class:!0});var H=$(W);f(Be.$$.fragment,H),Hn=a(H),bt=c(H,"P",{"data-svelte-h":!0}),h(bt)!=="svelte-1jsdpju"&&(bt.innerHTML=No),Bn=a(H),f(ie.$$.fragment,H),Gn=a(H),f(le.$$.fragment,H),Vn=a(H),f(de.$$.fragment,H),H.forEach(i),N.forEach(i),sn=a(e),f(Ge.$$.fragment,e),rn=a(e),J=c(e,"DIV",{class:!0});var B=$(J);f(Ve.$$.fragment,B),Ln=a(B),yt=c(B,"P",{"data-svelte-h":!0}),h(yt)!=="svelte-d30d0y"&&(yt.textContent=Ho),Rn=a(B),Tt=c(B,"P",{"data-svelte-h":!0}),h(Tt)!=="svelte-6pahdo"&&(Tt.innerHTML=Bo),Xn=a(B),kt=c(B,"P",{"data-svelte-h":!0}),h(kt)!=="svelte-68lg8f"&&(kt.innerHTML=Go),Sn=a(B),R=c(B,"DIV",{class:!0});var Y=$(R);f(Le.$$.fragment,Y),Pn=a(Y),wt=c(Y,"P",{"data-svelte-h":!0}),h(wt)!=="svelte-14akmq"&&(wt.innerHTML=Vo),Qn=a(Y),f(ce.$$.fragment,Y),An=a(Y),f(pe.$$.fragment,Y),Y.forEach(i),B.forEach(i),an=a(e),f(Re.$$.fragment,e),ln=a(e),z=c(e,"DIV",{class:!0});var G=$(z);f(Xe.$$.fragment,G),Yn=a(G),vt=c(G,"P",{"data-svelte-h":!0}),h(vt)!=="svelte-pdhuup"&&(vt.textContent=Lo),On=a(G),$t=c(G,"P",{"data-svelte-h":!0}),h($t)!=="svelte-6pahdo"&&($t.innerHTML=Ro),Dn=a(G),Et=c(G,"P",{"data-svelte-h":!0}),h(Et)!=="svelte-68lg8f"&&(Et.innerHTML=Xo),Kn=a(G),X=c(G,"DIV",{class:!0});var _e=$(X);f(Se.$$.fragment,_e),eo=a(_e),Ct=c(_e,"P",{"data-svelte-h":!0}),h(Ct)!=="svelte-11c66ey"&&(Ct.innerHTML=So),to=a(_e),f(me.$$.fragment,_e),no=a(_e),f(he.$$.fragment,_e),_e.forEach(i),G.forEach(i),dn=a(e),f(Pe.$$.fragment,e),cn=a(e),U=c(e,"DIV",{class:!0});var K=$(U);f(Qe.$$.fragment,K),oo=a(K),xt=c(K,"P",{"data-svelte-h":!0}),h(xt)!=="svelte-cu4xzn"&&(xt.innerHTML=Po),so=a(K),jt=c(K,"P",{"data-svelte-h":!0}),h(jt)!=="svelte-6pahdo"&&(jt.innerHTML=Qo),ro=a(K),Jt=c(K,"P",{"data-svelte-h":!0}),h(Jt)!=="svelte-68lg8f"&&(Jt.innerHTML=Ao),ao=a(K),S=c(K,"DIV",{class:!0});var Me=$(S);f(Ae.$$.fragment,Me),io=a(Me),zt=c(Me,"P",{"data-svelte-h":!0}),h(zt)!=="svelte-1hz8zoc"&&(zt.innerHTML=Yo),lo=a(Me),f(ue.$$.fragment,Me),co=a(Me),f(fe.$$.fragment,Me),Me.forEach(i),K.forEach(i),pn=a(e),f(Ye.$$.fragment,e),mn=a(e),F=c(e,"DIV",{class:!0});var ee=$(F);f(Oe.$$.fragment,ee),po=a(ee),Ut=c(ee,"P",{"data-svelte-h":!0}),h(Ut)!=="svelte-192fs6z"&&(Ut.innerHTML=Oo),mo=a(ee),Ft=c(ee,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-6pahdo"&&(Ft.innerHTML=Do),ho=a(ee),It=c(ee,"P",{"data-svelte-h":!0}),h(It)!=="svelte-68lg8f"&&(It.innerHTML=Ko),uo=a(ee),D=c(ee,"DIV",{class:!0});var Zt=$(D);f(De.$$.fragment,Zt),fo=a(Zt),Wt=c(Zt,"P",{"data-svelte-h":!0}),h(Wt)!=="svelte-yxm2c2"&&(Wt.innerHTML=es),go=a(Zt),f(ge.$$.fragment,Zt),Zt.forEach(i),ee.forEach(i),hn=a(e),f(Ke.$$.fragment,e),un=a(e),Ht=c(e,"P",{}),$(Ht).forEach(i),this.h()},h(){v(t,"name","hf:doc:metadata"),v(t,"content",Ts),v(k,"class","flex flex-wrap space-x-1"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){n(document.head,t),m(e,y,s),m(e,l,s),m(e,p,s),g(T,e,s),m(e,o,s),m(e,k,s),m(e,Gt,s),g(ne,e,s),m(e,Vt,s),g(be,e,s),m(e,Lt,s),m(e,ye,s),m(e,Rt,s),m(e,Te,s),m(e,Xt,s),m(e,ke,s),m(e,St,s),g(we,e,s),m(e,Pt,s),m(e,ve,s),m(e,Qt,s),g($e,e,s),m(e,At,s),m(e,Ee,s),m(e,Yt,s),g(Ce,e,s),m(e,Ot,s),m(e,Z,s),g(xe,Z,null),n(Z,gn),n(Z,ot),n(Z,_n),n(Z,st),n(Z,Mn),n(Z,rt),m(e,Dt,s),g(je,e,s),m(e,Kt,s),m(e,C,s),g(Je,C,null),n(C,bn),n(C,at),n(C,yn),n(C,O),g(ze,O,null),n(O,Tn),n(O,it),n(O,kn),n(O,lt),n(C,wn),n(C,oe),g(Ue,oe,null),n(oe,vn),n(oe,dt),n(C,$n),n(C,se),g(Fe,se,null),n(se,En),n(se,ct),n(C,Cn),n(C,pt),g(Ie,pt,null),m(e,en,s),g(We,e,s),m(e,tn,s),m(e,x,s),g(Ze,x,null),n(x,xn),n(x,mt),n(x,jn),n(x,ht),n(x,Jn),n(x,ut),n(x,zn),n(x,L),g(qe,L,null),n(L,Un),n(L,ft),n(L,Fn),g(re,L,null),n(L,In),g(ae,L,null),m(e,nn,s),g(Ne,e,s),m(e,on,s),m(e,j,s),g(He,j,null),n(j,Wn),n(j,gt),n(j,Zn),n(j,_t),n(j,qn),n(j,Mt),n(j,Nn),n(j,W),g(Be,W,null),n(W,Hn),n(W,bt),n(W,Bn),g(ie,W,null),n(W,Gn),g(le,W,null),n(W,Vn),g(de,W,null),m(e,sn,s),g(Ge,e,s),m(e,rn,s),m(e,J,s),g(Ve,J,null),n(J,Ln),n(J,yt),n(J,Rn),n(J,Tt),n(J,Xn),n(J,kt),n(J,Sn),n(J,R),g(Le,R,null),n(R,Pn),n(R,wt),n(R,Qn),g(ce,R,null),n(R,An),g(pe,R,null),m(e,an,s),g(Re,e,s),m(e,ln,s),m(e,z,s),g(Xe,z,null),n(z,Yn),n(z,vt),n(z,On),n(z,$t),n(z,Dn),n(z,Et),n(z,Kn),n(z,X),g(Se,X,null),n(X,eo),n(X,Ct),n(X,to),g(me,X,null),n(X,no),g(he,X,null),m(e,dn,s),g(Pe,e,s),m(e,cn,s),m(e,U,s),g(Qe,U,null),n(U,oo),n(U,xt),n(U,so),n(U,jt),n(U,ro),n(U,Jt),n(U,ao),n(U,S),g(Ae,S,null),n(S,io),n(S,zt),n(S,lo),g(ue,S,null),n(S,co),g(fe,S,null),m(e,pn,s),g(Ye,e,s),m(e,mn,s),m(e,F,s),g(Oe,F,null),n(F,po),n(F,Ut),n(F,mo),n(F,Ft),n(F,ho),n(F,It),n(F,uo),n(F,D),g(De,D,null),n(D,fo),n(D,Wt),n(D,go),g(ge,D,null),m(e,hn,s),g(Ke,e,s),m(e,un,s),m(e,Ht,s),fn=!0},p(e,[s]){const Q={};s&2&&(Q.$$scope={dirty:s,ctx:e}),ne.$set(Q);const I={};s&2&&(I.$$scope={dirty:s,ctx:e}),re.$set(I);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),ae.$set(te);const et={};s&2&&(et.$$scope={dirty:s,ctx:e}),ie.$set(et);const tt={};s&2&&(tt.$$scope={dirty:s,ctx:e}),le.$set(tt);const Bt={};s&2&&(Bt.$$scope={dirty:s,ctx:e}),de.$set(Bt);const q={};s&2&&(q.$$scope={dirty:s,ctx:e}),ce.$set(q);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),pe.$set(A);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),me.$set(N);const H={};s&2&&(H.$$scope={dirty:s,ctx:e}),he.$set(H);const B={};s&2&&(B.$$scope={dirty:s,ctx:e}),ue.$set(B);const Y={};s&2&&(Y.$$scope={dirty:s,ctx:e}),fe.$set(Y);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),ge.$set(G)},i(e){fn||(_(T.$$.fragment,e),_(ne.$$.fragment,e),_(be.$$.fragment,e),_(we.$$.fragment,e),_($e.$$.fragment,e),_(Ce.$$.fragment,e),_(xe.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_(ze.$$.fragment,e),_(Ue.$$.fragment,e),_(Fe.$$.fragment,e),_(Ie.$$.fragment,e),_(We.$$.fragment,e),_(Ze.$$.fragment,e),_(qe.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(Ne.$$.fragment,e),_(He.$$.fragment,e),_(Be.$$.fragment,e),_(ie.$$.fragment,e),_(le.$$.fragment,e),_(de.$$.fragment,e),_(Ge.$$.fragment,e),_(Ve.$$.fragment,e),_(Le.$$.fragment,e),_(ce.$$.fragment,e),_(pe.$$.fragment,e),_(Re.$$.fragment,e),_(Xe.$$.fragment,e),_(Se.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(Pe.$$.fragment,e),_(Qe.$$.fragment,e),_(Ae.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(Ye.$$.fragment,e),_(Oe.$$.fragment,e),_(De.$$.fragment,e),_(ge.$$.fragment,e),_(Ke.$$.fragment,e),fn=!0)},o(e){M(T.$$.fragment,e),M(ne.$$.fragment,e),M(be.$$.fragment,e),M(we.$$.fragment,e),M($e.$$.fragment,e),M(Ce.$$.fragment,e),M(xe.$$.fragment,e),M(je.$$.fragment,e),M(Je.$$.fragment,e),M(ze.$$.fragment,e),M(Ue.$$.fragment,e),M(Fe.$$.fragment,e),M(Ie.$$.fragment,e),M(We.$$.fragment,e),M(Ze.$$.fragment,e),M(qe.$$.fragment,e),M(re.$$.fragment,e),M(ae.$$.fragment,e),M(Ne.$$.fragment,e),M(He.$$.fragment,e),M(Be.$$.fragment,e),M(ie.$$.fragment,e),M(le.$$.fragment,e),M(de.$$.fragment,e),M(Ge.$$.fragment,e),M(Ve.$$.fragment,e),M(Le.$$.fragment,e),M(ce.$$.fragment,e),M(pe.$$.fragment,e),M(Re.$$.fragment,e),M(Xe.$$.fragment,e),M(Se.$$.fragment,e),M(me.$$.fragment,e),M(he.$$.fragment,e),M(Pe.$$.fragment,e),M(Qe.$$.fragment,e),M(Ae.$$.fragment,e),M(ue.$$.fragment,e),M(fe.$$.fragment,e),M(Ye.$$.fragment,e),M(Oe.$$.fragment,e),M(De.$$.fragment,e),M(ge.$$.fragment,e),M(Ke.$$.fragment,e),fn=!1},d(e){e&&(i(y),i(l),i(p),i(o),i(k),i(Gt),i(Vt),i(Lt),i(ye),i(Rt),i(Te),i(Xt),i(ke),i(St),i(Pt),i(ve),i(Qt),i(At),i(Ee),i(Yt),i(Ot),i(Z),i(Dt),i(Kt),i(C),i(en),i(tn),i(x),i(nn),i(on),i(j),i(sn),i(rn),i(J),i(an),i(ln),i(z),i(dn),i(cn),i(U),i(pn),i(mn),i(F),i(hn),i(un),i(Ht)),i(t),b(T,e),b(ne,e),b(be,e),b(we,e),b($e,e),b(Ce,e),b(xe),b(je,e),b(Je),b(ze),b(Ue),b(Fe),b(Ie),b(We,e),b(Ze),b(qe),b(re),b(ae),b(Ne,e),b(He),b(Be),b(ie),b(le),b(de),b(Ge,e),b(Ve),b(Le),b(ce),b(pe),b(Re,e),b(Xe),b(Se),b(me),b(he),b(Pe,e),b(Qe),b(Ae),b(ue),b(fe),b(Ye,e),b(Oe),b(De),b(ge),b(Ke,e)}}}const Ts='{"title":"ErnieM","local":"erniem","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"ErnieMConfig","local":"transformers.ErnieMConfig","sections":[],"depth":2},{"title":"ErnieMTokenizer","local":"transformers.ErnieMTokenizer","sections":[],"depth":2},{"title":"ErnieMModel","local":"transformers.ErnieMModel","sections":[],"depth":2},{"title":"ErnieMForSequenceClassification","local":"transformers.ErnieMForSequenceClassification","sections":[],"depth":2},{"title":"ErnieMForMultipleChoice","local":"transformers.ErnieMForMultipleChoice","sections":[],"depth":2},{"title":"ErnieMForTokenClassification","local":"transformers.ErnieMForTokenClassification","sections":[],"depth":2},{"title":"ErnieMForQuestionAnswering","local":"transformers.ErnieMForQuestionAnswering","sections":[],"depth":2},{"title":"ErnieMForInformationExtraction","local":"transformers.ErnieMForInformationExtraction","sections":[],"depth":2}],"depth":1}';function ks(w){return ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zs extends os{constructor(t){super(),ss(this,t,ks,ys,ts,{})}}export{zs as component};
