import{s as io,z as lo,o as co,n as B}from"../chunks/scheduler.18a86fab.js";import{S as mo,i as po,g as m,s as r,r as g,A as ho,h as p,f as n,c as i,j as N,u,x as h,k as W,y as c,a as l,v as _,d as b,t as y,w as $}from"../chunks/index.98837b22.js";import{T as Je}from"../chunks/Tip.77304350.js";import{D as $e}from"../chunks/Docstring.6758ea23.js";import{C as lt}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as it}from"../chunks/ExampleCodeBlock.0c42463f.js";import{P as fo}from"../chunks/PipelineTag.7749150e.js";import{H as Te}from"../chunks/Heading.7e7e0c5b.js";import{E as go}from"../chunks/index.92f616ba.js";function uo(w){let t,f="Example:",s,d,T;return d=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhpZXJhQ29uZmlnJTJDJTIwSGllcmFNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBIaWVyYSUyMGhpZXJhLWJhc2UtcGF0Y2gxNi0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwSGllcmFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaGllcmEtYmFzZS1wYXRjaDE2LTIyNCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwSGllcmFNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HieraConfig, HieraModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Hiera hiera-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = HieraConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hiera-base-patch16-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HieraModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,s=r(),g(d.$$.fragment)},l(a){t=p(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=f),s=i(a),u(d.$$.fragment,a)},m(a,v){l(a,t,v),l(a,s,v),_(d,a,v),T=!0},p:B,i(a){T||(b(d.$$.fragment,a),T=!0)},o(a){y(d.$$.fragment,a),T=!1},d(a){a&&(n(t),n(s)),$(d,a)}}}function _o(w){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(s,d){l(s,t,d)},p:B,d(s){s&&n(t)}}}function bo(w){let t,f="Example:",s,d,T;return d=new lt({props:{code:"",highlighted:"",wrap:!1}}),{c(){t=m("p"),t.textContent=f,s=r(),g(d.$$.fragment)},l(a){t=p(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=f),s=i(a),u(d.$$.fragment,a)},m(a,v){l(a,t,v),l(a,s,v),_(d,a,v),T=!0},p:B,i(a){T||(b(d.$$.fragment,a),T=!0)},o(a){y(d.$$.fragment,a),T=!1},d(a){a&&(n(t),n(s)),$(d,a)}}}function yo(w){let t,f=`Note that we provide a script to pre-train this model on custom data in our <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">examples
directory</a>.`;return{c(){t=m("p"),t.innerHTML=f},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-7i3y9o"&&(t.innerHTML=f)},m(s,d){l(s,t,d)},p:B,d(s){s&&n(t)}}}function $o(w){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(s,d){l(s,t,d)},p:B,d(s){s&&n(t)}}}function To(w){let t,f="Examples:",s,d,T;return d=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEhpZXJhRm9yUHJlVHJhaW5pbmclMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZoaWVyYS10aW55LTIyNC1tYWUtaGYlMjIpJTBBbW9kZWwlMjAlM0QlMjBIaWVyYUZvclByZVRyYWluaW5nLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmhpZXJhLXRpbnktMjI0LW1hZS1oZiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFwcmludChsaXN0KGxvZ2l0cy5zaGFwZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, HieraForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/hiera-tiny-224-mae-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HieraForPreTraining.from_pretrained(<span class="hljs-string">&quot;facebook/hiera-tiny-224-mae-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-built_in">list</span>(logits.shape))
[<span class="hljs-number">1</span>, <span class="hljs-number">196</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,s=r(),g(d.$$.fragment)},l(a){t=p(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=f),s=i(a),u(d.$$.fragment,a)},m(a,v){l(a,t,v),l(a,s,v),_(d,a,v),T=!0},p:B,i(a){T||(b(d.$$.fragment,a),T=!0)},o(a){y(d.$$.fragment,a),T=!1},d(a){a&&(n(t),n(s)),$(d,a)}}}function vo(w){let t,f=`Note that it’s possible to fine-tune Hiera on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){t=m("p"),t.innerHTML=f},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-15d8aix"&&(t.innerHTML=f)},m(s,d){l(s,t,d)},p:B,d(s){s&&n(t)}}}function wo(w){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=f},l(s){t=p(s,"P",{"data-svelte-h":!0}),h(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(s,d){l(s,t,d)},p:B,d(s){s&&n(t)}}}function Mo(w){let t,f="Example:",s,d,T;return d=new lt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEhpZXJhRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZoaWVyYS1iYXNlLTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMEhpZXJhRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZoaWVyYS1iYXNlLTIyNCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9sYWJlbCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, HieraForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/hiera-base-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = HieraForImageClassification.from_pretrained(<span class="hljs-string">&quot;facebook/hiera-base-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
...`,wrap:!1}}),{c(){t=m("p"),t.textContent=f,s=r(),g(d.$$.fragment)},l(a){t=p(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-11lpom8"&&(t.textContent=f),s=i(a),u(d.$$.fragment,a)},m(a,v){l(a,t,v),l(a,s,v),_(d,a,v),T=!0},p:B,i(a){T||(b(d.$$.fragment,a),T=!0)},o(a){y(d.$$.fragment,a),T=!1},d(a){a&&(n(t),n(s)),$(d,a)}}}function Ho(w){let t,f,s,d,T,a,v,Pt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Le,O,Ne,D,Zt='Hiera was proposed in <a href="https://arxiv.org/abs/2306.00989" rel="nofollow">Hiera: A Hierarchical Vision Transformer without the Bells-and-Whistles</a> by Chaitanya Ryali, Yuan-Ting Hu, Daniel Bolya, Chen Wei, Haoqi Fan, Po-Yao Huang, Vaibhav Aggarwal, Arkabandhu Chowdhury, Omid Poursaeed, Judy Hoffman, Jitendra Malik, Yanghao Li, Christoph Feichtenhofer',Be,K,Jt="The paper introduces “Hiera,” a hierarchical Vision Transformer that simplifies the architecture of modern hierarchical vision transformers by removing unnecessary components without compromising on accuracy or efficiency. Unlike traditional transformers that add complex vision-specific components to improve supervised classification performance, Hiera demonstrates that such additions, often termed “bells-and-whistles,” are not essential for high accuracy. By leveraging a strong visual pretext task (MAE) for pretraining, Hiera retains simplicity and achieves superior accuracy and speed both in inference and training across various image and video recognition tasks. The approach suggests that spatial biases required for vision tasks can be effectively learned through proper pretraining, eliminating the need for added architectural complexity.",qe,ee,Lt="The abstract from the paper is the following:",Ee,te,Nt='<em>Modern hierarchical vision transformers have added several vision-specific components in the pursuit of supervised classification performance. While these components lead to effective accuracies and attractive FLOP counts, the added complexity actually makes these transformers slower than their vanilla ViT counterparts. In this paper, we argue that this additional bulk is unnecessary. By pretraining with a strong visual pretext task (MAE), we can strip out all the bells-and-whistles from a state-of-the-art multi-stage vision transformer without losing accuracy. In the process, we create Hiera, an extremely simple hierarchical vision transformer that is more accurate than previous models while being significantly faster both at inference and during training. We evaluate Hiera on a variety of tasks for image and video recognition. Our code and models are available at <a href="https://github.com/facebookresearch/hiera" rel="nofollow">https://github.com/facebookresearch/hiera</a>.</em>',Re,q,Bt,Se,oe,qt='Hiera architecture. Taken from the <a href="https://arxiv.org/abs/2306.00989">original paper.</a>',Ge,ne,Et='This model was a joint contribution by <a href="https://huggingface.co/EduardoPacheco" rel="nofollow">EduardoPacheco</a> and <a href="https://huggingface.co/namangarg110" rel="nofollow">namangarg110</a>. The original code can be found [here] (<a href="https://github.com/facebookresearch/hiera" rel="nofollow">https://github.com/facebookresearch/hiera</a>).',Ve,ae,Xe,se,Rt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Hiera. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Ye,re,Qe,ie,St='<li><a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraForImageClassification">HieraForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Ae,le,Oe,F,de,dt,ve,Gt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraModel">HieraModel</a>. It is used to instantiate a Hiera
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Hiera
<a href="https://huggingface.co/facebook/hiera-base-224" rel="nofollow">facebook/hiera-base-224</a> architecture.`,ct,we,Vt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,mt,E,De,ce,Ke,C,me,pt,Me,Xt="The bare Hiera Model outputting raw hidden-states without any specific head on top.",ht,He,Yt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ft,Ce,Qt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,gt,z,pe,ut,xe,At='The <a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraModel">HieraModel</a> forward method, overrides the <code>__call__</code> special method.',_t,R,bt,S,et,he,tt,M,fe,yt,ke,Ot="The Hiera Model transformer with the decoder on top for self-supervised pre-training.",$t,G,Tt,Fe,Dt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vt,je,Kt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,wt,U,ge,Mt,We,eo='The <a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraForPreTraining">HieraForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',Ht,V,Ct,X,ot,ue,nt,H,_e,xt,ze,to=`Hiera Model transformer with an image classification head on top (a linear layer on top of the final hidden state with
average pooling) e.g. for ImageNet.`,kt,Y,Ft,Ue,oo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,jt,Ie,no=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wt,I,be,zt,Pe,ao='The <a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraForImageClassification">HieraForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Ut,Q,It,A,at,ye,st,Ze,rt;return T=new Te({props:{title:"Hiera",local:"hiera",headingTag:"h1"}}),O=new Te({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ae=new Te({props:{title:"Resources",local:"resources",headingTag:"h2"}}),re=new fo({props:{pipeline:"image-classification"}}),le=new Te({props:{title:"HieraConfig",local:"transformers.HieraConfig",headingTag:"h2"}}),de=new $e({props:{name:"class transformers.HieraConfig",anchor:"transformers.HieraConfig",parameters:[{name:"embed_dim",val:" = 96"},{name:"image_size",val:" = [224, 224]"},{name:"patch_size",val:" = [7, 7]"},{name:"patch_stride",val:" = [4, 4]"},{name:"patch_padding",val:" = [3, 3]"},{name:"mlp_ratio",val:" = 4.0"},{name:"depths",val:" = [2, 3, 16, 3]"},{name:"num_heads",val:" = [1, 2, 4, 8]"},{name:"embed_dim_multiplier",val:" = 2.0"},{name:"num_query_pool",val:" = 3"},{name:"query_stride",val:" = [2, 2]"},{name:"masked_unit_size",val:" = [8, 8]"},{name:"masked_unit_attention",val:" = [True, True, False, False]"},{name:"drop_path_rate",val:" = 0.0"},{name:"num_channels",val:" = 3"},{name:"hidden_act",val:" = 'gelu'"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_init",val:" = 1.0"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"decoder_hidden_size",val:" = None"},{name:"decoder_depth",val:" = None"},{name:"decoder_num_heads",val:" = None"},{name:"normalize_pixel_loss",val:" = True"},{name:"mask_ratio",val:" = 0.6"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.HieraConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.HieraConfig.image_size",description:`<strong>image_size</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[224, 224]</code>) &#x2014;
The size (resolution) of input in the format (height, width) for images
and (frames, height, width) for videos.`,name:"image_size"},{anchor:"transformers.HieraConfig.patch_size",description:`<strong>patch_size</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[7, 7]</code>) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.HieraConfig.patch_stride",description:`<strong>patch_stride</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[4, 4]</code>) &#x2014;
The stride of the patch.`,name:"patch_stride"},{anchor:"transformers.HieraConfig.patch_padding",description:`<strong>patch_padding</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[3, 3]</code>) &#x2014;
The padding of the patch.`,name:"patch_padding"},{anchor:"transformers.HieraConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
The ratio of mlp hidden dim to embedding dim.`,name:"mlp_ratio"},{anchor:"transformers.HieraConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[2, 3, 16, 3]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.HieraConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[1, 2, 4, 8]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.HieraConfig.embed_dim_multiplier",description:`<strong>embed_dim_multiplier</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The multiplier to the dimensionality of patch embedding in each layer of the Transformer encoder.`,name:"embed_dim_multiplier"},{anchor:"transformers.HieraConfig.num_query_pool",description:`<strong>num_query_pool</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of query pool stages.`,name:"num_query_pool"},{anchor:"transformers.HieraConfig.query_stride",description:`<strong>query_stride</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[2, 2]</code>) &#x2014;
The stride of the query pool.`,name:"query_stride"},{anchor:"transformers.HieraConfig.masked_unit_size",description:`<strong>masked_unit_size</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[8, 8]</code>) &#x2014;
The size of the masked unit.`,name:"masked_unit_size"},{anchor:"transformers.HieraConfig.masked_unit_attention",description:`<strong>masked_unit_attention</strong> (<code>list(bool)</code>, <em>optional</em>, defaults to <code>[True, True, False, False]</code>) &#x2014;
Whether to use masked unit attention in each layer of the Transformer encoder.`,name:"masked_unit_attention"},{anchor:"transformers.HieraConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The drop path rate.`,name:"drop_path_rate"},{anchor:"transformers.HieraConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.HieraConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.HieraConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices and
the zero_initializer for initializing all bias vectors.`,name:"initializer_range"},{anchor:"transformers.HieraConfig.layer_norm_init",description:`<strong>layer_norm_init</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The initial weight value for layer normalization layers.`,name:"layer_norm_init"},{anchor:"transformers.HieraConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-06) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.HieraConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimensionality of decoder embeddings for MAE pretraining.`,name:"decoder_hidden_size"},{anchor:"transformers.HieraConfig.decoder_depth",description:`<strong>decoder_depth</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Depth of the decoder for MAE pretraining.`,name:"decoder_depth"},{anchor:"transformers.HieraConfig.decoder_num_heads",description:`<strong>decoder_num_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of attention heads in each layer of the decoder for MAE pretraining.`,name:"decoder_num_heads"},{anchor:"transformers.HieraConfig.normalize_pixel_loss",description:`<strong>normalize_pixel_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the pixel loss by the number of pixels.`,name:"normalize_pixel_loss"},{anchor:"transformers.HieraConfig.mask_ratio",description:`<strong>mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.6) &#x2014;
The ratio of masked tokens in the input.`,name:"mask_ratio"},{anchor:"transformers.HieraConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_features"},{anchor:"transformers.HieraConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hiera/configuration_hiera.py#L25"}}),E=new it({props:{anchor:"transformers.HieraConfig.example",$$slots:{default:[uo]},$$scope:{ctx:w}}}),ce=new Te({props:{title:"HieraModel",local:"transformers.HieraModel",headingTag:"h2"}}),me=new $e({props:{name:"class transformers.HieraModel",anchor:"transformers.HieraModel",parameters:[{name:"config",val:": HieraConfig"},{name:"add_pooling_layer",val:": bool = True"},{name:"is_mae",val:": bool = False"}],parametersDescription:[{anchor:"transformers.HieraModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraConfig">HieraConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.HieraModel.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply pooling layer.`,name:"add_pooling_layer"},{anchor:"transformers.HieraModel.is_mae",description:`<strong>is_mae</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to run the model on MAE mode.`,name:"is_mae"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hiera/modeling_hiera.py#L865"}}),pe=new $e({props:{name:"forward",anchor:"transformers.HieraModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"noise",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.HieraModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.HieraModel.forward.noise",description:`<strong>noise</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_mask_units)</code>, <em>optional</em>) &#x2014;
Mainly used for testing purposes to control randomness and maintain the reproducibility`,name:"noise"},{anchor:"transformers.HieraModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.HieraModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.HieraModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.HieraModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.HieraModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hiera/modeling_hiera.py#L898",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraConfig"
>HieraConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new Je({props:{$$slots:{default:[_o]},$$scope:{ctx:w}}}),S=new it({props:{anchor:"transformers.HieraModel.forward.example",$$slots:{default:[bo]},$$scope:{ctx:w}}}),he=new Te({props:{title:"HieraForPreTraining",local:"transformers.HieraForPreTraining",headingTag:"h2"}}),fe=new $e({props:{name:"class transformers.HieraForPreTraining",anchor:"transformers.HieraForPreTraining",parameters:[{name:"config",val:": HieraConfig"}],parametersDescription:[{anchor:"transformers.HieraForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraConfig">HieraConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hiera/modeling_hiera.py#L1142"}}),G=new Je({props:{$$slots:{default:[yo]},$$scope:{ctx:w}}}),ge=new $e({props:{name:"forward",anchor:"transformers.HieraForPreTraining.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"noise",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.HieraForPreTraining.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.HieraForPreTraining.forward.noise",description:`<strong>noise</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_mask_units)</code>, <em>optional</em>) &#x2014;
Mainly used for testing purposes to control randomness and maintain the reproducibility`,name:"noise"},{anchor:"transformers.HieraForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.HieraForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.HieraForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.HieraForPreTraining.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.HieraForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hiera/modeling_hiera.py#L1195",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.hiera.modeling_hiera.HieraForPreTrainingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraConfig"
>HieraConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Pixel reconstruction loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, patch_size ** 2 * num_channels)</code>) — Pixel reconstruction logits.</li>
<li><strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Tensor indicating which patches are masked (0) and which are not (1).</li>
<li><strong>ids_restore</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Tensor containing the original index of the (shuffled) masked patches.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, height, width, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs reshaped to include the spatial dimensions.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.hiera.modeling_hiera.HieraForPreTrainingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new Je({props:{$$slots:{default:[$o]},$$scope:{ctx:w}}}),X=new it({props:{anchor:"transformers.HieraForPreTraining.forward.example",$$slots:{default:[To]},$$scope:{ctx:w}}}),ue=new Te({props:{title:"HieraForImageClassification",local:"transformers.HieraForImageClassification",headingTag:"h2"}}),_e=new $e({props:{name:"class transformers.HieraForImageClassification",anchor:"transformers.HieraForImageClassification",parameters:[{name:"config",val:": HieraConfig"}],parametersDescription:[{anchor:"transformers.HieraForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraConfig">HieraConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hiera/modeling_hiera.py#L1286"}}),Y=new Je({props:{$$slots:{default:[vo]},$$scope:{ctx:w}}}),be=new $e({props:{name:"forward",anchor:"transformers.HieraForImageClassification.forward",parameters:[{name:"pixel_values",val:""},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.HieraForImageClassification.forward.pixel_values",description:"<strong>pixel_values</strong> (`<code>of shape</code>(batch_size, num_channels, image_size, image_size)<code>) -- The tensors corresponding to the input images. Pixel values can be obtained using </code>{image_processor_class}<code>. See </code>{image_processor_class}.<strong>call</strong><code> for details (</code>{processor_class}<code>uses</code>{image_processor_class}` for processing images).",name:"pixel_values"},{anchor:"transformers.HieraForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.HieraForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.HieraForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.HieraForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.HieraForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.HieraForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/hiera/modeling_hiera.py#L1315",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.hiera.modeling_hiera.HieraForImageClassificationOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/hiera#transformers.HieraConfig"
>HieraConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <code>optional</code>) — Loss value for the training task.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) — Prediction scores of the classification head (logits of the output layer).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <code>optional</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. These are the unrolled hidden states of the model.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <code>optional</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <code>optional</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, height, width, hidden_size)</code>. These are the reshaped and re-rolled hidden states of the model.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.hiera.modeling_hiera.HieraForImageClassificationOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Je({props:{$$slots:{default:[wo]},$$scope:{ctx:w}}}),A=new it({props:{anchor:"transformers.HieraForImageClassification.forward.example",$$slots:{default:[Mo]},$$scope:{ctx:w}}}),ye=new go({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/hiera.md"}}),{c(){t=m("meta"),f=r(),s=m("p"),d=r(),g(T.$$.fragment),a=r(),v=m("div"),v.innerHTML=Pt,Le=r(),g(O.$$.fragment),Ne=r(),D=m("p"),D.innerHTML=Zt,Be=r(),K=m("p"),K.textContent=Jt,qe=r(),ee=m("p"),ee.textContent=Lt,Ee=r(),te=m("p"),te.innerHTML=Nt,Re=r(),q=m("img"),Se=r(),oe=m("small"),oe.innerHTML=qt,Ge=r(),ne=m("p"),ne.innerHTML=Et,Ve=r(),g(ae.$$.fragment),Xe=r(),se=m("p"),se.textContent=Rt,Ye=r(),g(re.$$.fragment),Qe=r(),ie=m("ul"),ie.innerHTML=St,Ae=r(),g(le.$$.fragment),Oe=r(),F=m("div"),g(de.$$.fragment),dt=r(),ve=m("p"),ve.innerHTML=Gt,ct=r(),we=m("p"),we.innerHTML=Vt,mt=r(),g(E.$$.fragment),De=r(),g(ce.$$.fragment),Ke=r(),C=m("div"),g(me.$$.fragment),pt=r(),Me=m("p"),Me.textContent=Xt,ht=r(),He=m("p"),He.innerHTML=Yt,ft=r(),Ce=m("p"),Ce.innerHTML=Qt,gt=r(),z=m("div"),g(pe.$$.fragment),ut=r(),xe=m("p"),xe.innerHTML=At,_t=r(),g(R.$$.fragment),bt=r(),g(S.$$.fragment),et=r(),g(he.$$.fragment),tt=r(),M=m("div"),g(fe.$$.fragment),yt=r(),ke=m("p"),ke.textContent=Ot,$t=r(),g(G.$$.fragment),Tt=r(),Fe=m("p"),Fe.innerHTML=Dt,vt=r(),je=m("p"),je.innerHTML=Kt,wt=r(),U=m("div"),g(ge.$$.fragment),Mt=r(),We=m("p"),We.innerHTML=eo,Ht=r(),g(V.$$.fragment),Ct=r(),g(X.$$.fragment),ot=r(),g(ue.$$.fragment),nt=r(),H=m("div"),g(_e.$$.fragment),xt=r(),ze=m("p"),ze.textContent=to,kt=r(),g(Y.$$.fragment),Ft=r(),Ue=m("p"),Ue.innerHTML=oo,jt=r(),Ie=m("p"),Ie.innerHTML=no,Wt=r(),I=m("div"),g(be.$$.fragment),zt=r(),Pe=m("p"),Pe.innerHTML=ao,Ut=r(),g(Q.$$.fragment),It=r(),g(A.$$.fragment),at=r(),g(ye.$$.fragment),st=r(),Ze=m("p"),this.h()},l(e){const o=ho("svelte-u9bgzb",document.head);t=p(o,"META",{name:!0,content:!0}),o.forEach(n),f=i(e),s=p(e,"P",{}),N(s).forEach(n),d=i(e),u(T.$$.fragment,e),a=i(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),h(v)!=="svelte-13t8s2t"&&(v.innerHTML=Pt),Le=i(e),u(O.$$.fragment,e),Ne=i(e),D=p(e,"P",{"data-svelte-h":!0}),h(D)!=="svelte-1hwvwes"&&(D.innerHTML=Zt),Be=i(e),K=p(e,"P",{"data-svelte-h":!0}),h(K)!=="svelte-13w2zfe"&&(K.textContent=Jt),qe=i(e),ee=p(e,"P",{"data-svelte-h":!0}),h(ee)!=="svelte-vfdo9a"&&(ee.textContent=Lt),Ee=i(e),te=p(e,"P",{"data-svelte-h":!0}),h(te)!=="svelte-1m8exf9"&&(te.innerHTML=Nt),Re=i(e),q=p(e,"IMG",{src:!0,alt:!0,width:!0}),Se=i(e),oe=p(e,"SMALL",{"data-svelte-h":!0}),h(oe)!=="svelte-1cs5p0g"&&(oe.innerHTML=qt),Ge=i(e),ne=p(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-mrs97l"&&(ne.innerHTML=Et),Ve=i(e),u(ae.$$.fragment,e),Xe=i(e),se=p(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-ahx11c"&&(se.textContent=Rt),Ye=i(e),u(re.$$.fragment,e),Qe=i(e),ie=p(e,"UL",{"data-svelte-h":!0}),h(ie)!=="svelte-w5a3ws"&&(ie.innerHTML=St),Ae=i(e),u(le.$$.fragment,e),Oe=i(e),F=p(e,"DIV",{class:!0});var P=N(F);u(de.$$.fragment,P),dt=i(P),ve=p(P,"P",{"data-svelte-h":!0}),h(ve)!=="svelte-1khk6ro"&&(ve.innerHTML=Gt),ct=i(P),we=p(P,"P",{"data-svelte-h":!0}),h(we)!=="svelte-o55m63"&&(we.innerHTML=Vt),mt=i(P),u(E.$$.fragment,P),P.forEach(n),De=i(e),u(ce.$$.fragment,e),Ke=i(e),C=p(e,"DIV",{class:!0});var j=N(C);u(me.$$.fragment,j),pt=i(j),Me=p(j,"P",{"data-svelte-h":!0}),h(Me)!=="svelte-toub5j"&&(Me.textContent=Xt),ht=i(j),He=p(j,"P",{"data-svelte-h":!0}),h(He)!=="svelte-6pahdo"&&(He.innerHTML=Yt),ft=i(j),Ce=p(j,"P",{"data-svelte-h":!0}),h(Ce)!=="svelte-hswkmf"&&(Ce.innerHTML=Qt),gt=i(j),z=p(j,"DIV",{class:!0});var Z=N(z);u(pe.$$.fragment,Z),ut=i(Z),xe=p(Z,"P",{"data-svelte-h":!0}),h(xe)!=="svelte-ihwlok"&&(xe.innerHTML=At),_t=i(Z),u(R.$$.fragment,Z),bt=i(Z),u(S.$$.fragment,Z),Z.forEach(n),j.forEach(n),et=i(e),u(he.$$.fragment,e),tt=i(e),M=p(e,"DIV",{class:!0});var x=N(M);u(fe.$$.fragment,x),yt=i(x),ke=p(x,"P",{"data-svelte-h":!0}),h(ke)!=="svelte-dq7c69"&&(ke.textContent=Ot),$t=i(x),u(G.$$.fragment,x),Tt=i(x),Fe=p(x,"P",{"data-svelte-h":!0}),h(Fe)!=="svelte-6pahdo"&&(Fe.innerHTML=Dt),vt=i(x),je=p(x,"P",{"data-svelte-h":!0}),h(je)!=="svelte-hswkmf"&&(je.innerHTML=Kt),wt=i(x),U=p(x,"DIV",{class:!0});var J=N(U);u(ge.$$.fragment,J),Mt=i(J),We=p(J,"P",{"data-svelte-h":!0}),h(We)!=="svelte-zi1yo4"&&(We.innerHTML=eo),Ht=i(J),u(V.$$.fragment,J),Ct=i(J),u(X.$$.fragment,J),J.forEach(n),x.forEach(n),ot=i(e),u(ue.$$.fragment,e),nt=i(e),H=p(e,"DIV",{class:!0});var k=N(H);u(_e.$$.fragment,k),xt=i(k),ze=p(k,"P",{"data-svelte-h":!0}),h(ze)!=="svelte-1pc0sj6"&&(ze.textContent=to),kt=i(k),u(Y.$$.fragment,k),Ft=i(k),Ue=p(k,"P",{"data-svelte-h":!0}),h(Ue)!=="svelte-6pahdo"&&(Ue.innerHTML=oo),jt=i(k),Ie=p(k,"P",{"data-svelte-h":!0}),h(Ie)!=="svelte-hswkmf"&&(Ie.innerHTML=no),Wt=i(k),I=p(k,"DIV",{class:!0});var L=N(I);u(be.$$.fragment,L),zt=i(L),Pe=p(L,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-u66wcw"&&(Pe.innerHTML=ao),Ut=i(L),u(Q.$$.fragment,L),It=i(L),u(A.$$.fragment,L),L.forEach(n),k.forEach(n),at=i(e),u(ye.$$.fragment,e),st=i(e),Ze=p(e,"P",{}),N(Ze).forEach(n),this.h()},h(){W(t,"name","hf:doc:metadata"),W(t,"content",Co),W(v,"class","flex flex-wrap space-x-1"),lo(q.src,Bt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/hiera_overview.png")||W(q,"src",Bt),W(q,"alt","drawing"),W(q,"width","600"),W(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),W(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){c(document.head,t),l(e,f,o),l(e,s,o),l(e,d,o),_(T,e,o),l(e,a,o),l(e,v,o),l(e,Le,o),_(O,e,o),l(e,Ne,o),l(e,D,o),l(e,Be,o),l(e,K,o),l(e,qe,o),l(e,ee,o),l(e,Ee,o),l(e,te,o),l(e,Re,o),l(e,q,o),l(e,Se,o),l(e,oe,o),l(e,Ge,o),l(e,ne,o),l(e,Ve,o),_(ae,e,o),l(e,Xe,o),l(e,se,o),l(e,Ye,o),_(re,e,o),l(e,Qe,o),l(e,ie,o),l(e,Ae,o),_(le,e,o),l(e,Oe,o),l(e,F,o),_(de,F,null),c(F,dt),c(F,ve),c(F,ct),c(F,we),c(F,mt),_(E,F,null),l(e,De,o),_(ce,e,o),l(e,Ke,o),l(e,C,o),_(me,C,null),c(C,pt),c(C,Me),c(C,ht),c(C,He),c(C,ft),c(C,Ce),c(C,gt),c(C,z),_(pe,z,null),c(z,ut),c(z,xe),c(z,_t),_(R,z,null),c(z,bt),_(S,z,null),l(e,et,o),_(he,e,o),l(e,tt,o),l(e,M,o),_(fe,M,null),c(M,yt),c(M,ke),c(M,$t),_(G,M,null),c(M,Tt),c(M,Fe),c(M,vt),c(M,je),c(M,wt),c(M,U),_(ge,U,null),c(U,Mt),c(U,We),c(U,Ht),_(V,U,null),c(U,Ct),_(X,U,null),l(e,ot,o),_(ue,e,o),l(e,nt,o),l(e,H,o),_(_e,H,null),c(H,xt),c(H,ze),c(H,kt),_(Y,H,null),c(H,Ft),c(H,Ue),c(H,jt),c(H,Ie),c(H,Wt),c(H,I),_(be,I,null),c(I,zt),c(I,Pe),c(I,Ut),_(Q,I,null),c(I,It),_(A,I,null),l(e,at,o),_(ye,e,o),l(e,st,o),l(e,Ze,o),rt=!0},p(e,[o]){const P={};o&2&&(P.$$scope={dirty:o,ctx:e}),E.$set(P);const j={};o&2&&(j.$$scope={dirty:o,ctx:e}),R.$set(j);const Z={};o&2&&(Z.$$scope={dirty:o,ctx:e}),S.$set(Z);const x={};o&2&&(x.$$scope={dirty:o,ctx:e}),G.$set(x);const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),V.$set(J);const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),X.$set(k);const L={};o&2&&(L.$$scope={dirty:o,ctx:e}),Y.$set(L);const so={};o&2&&(so.$$scope={dirty:o,ctx:e}),Q.$set(so);const ro={};o&2&&(ro.$$scope={dirty:o,ctx:e}),A.$set(ro)},i(e){rt||(b(T.$$.fragment,e),b(O.$$.fragment,e),b(ae.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(E.$$.fragment,e),b(ce.$$.fragment,e),b(me.$$.fragment,e),b(pe.$$.fragment,e),b(R.$$.fragment,e),b(S.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(G.$$.fragment,e),b(ge.$$.fragment,e),b(V.$$.fragment,e),b(X.$$.fragment,e),b(ue.$$.fragment,e),b(_e.$$.fragment,e),b(Y.$$.fragment,e),b(be.$$.fragment,e),b(Q.$$.fragment,e),b(A.$$.fragment,e),b(ye.$$.fragment,e),rt=!0)},o(e){y(T.$$.fragment,e),y(O.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(le.$$.fragment,e),y(de.$$.fragment,e),y(E.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(pe.$$.fragment,e),y(R.$$.fragment,e),y(S.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(G.$$.fragment,e),y(ge.$$.fragment,e),y(V.$$.fragment,e),y(X.$$.fragment,e),y(ue.$$.fragment,e),y(_e.$$.fragment,e),y(Y.$$.fragment,e),y(be.$$.fragment,e),y(Q.$$.fragment,e),y(A.$$.fragment,e),y(ye.$$.fragment,e),rt=!1},d(e){e&&(n(f),n(s),n(d),n(a),n(v),n(Le),n(Ne),n(D),n(Be),n(K),n(qe),n(ee),n(Ee),n(te),n(Re),n(q),n(Se),n(oe),n(Ge),n(ne),n(Ve),n(Xe),n(se),n(Ye),n(Qe),n(ie),n(Ae),n(Oe),n(F),n(De),n(Ke),n(C),n(et),n(tt),n(M),n(ot),n(nt),n(H),n(at),n(st),n(Ze)),n(t),$(T,e),$(O,e),$(ae,e),$(re,e),$(le,e),$(de),$(E),$(ce,e),$(me),$(pe),$(R),$(S),$(he,e),$(fe),$(G),$(ge),$(V),$(X),$(ue,e),$(_e),$(Y),$(be),$(Q),$(A),$(ye,e)}}}const Co='{"title":"Hiera","local":"hiera","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"HieraConfig","local":"transformers.HieraConfig","sections":[],"depth":2},{"title":"HieraModel","local":"transformers.HieraModel","sections":[],"depth":2},{"title":"HieraForPreTraining","local":"transformers.HieraForPreTraining","sections":[],"depth":2},{"title":"HieraForImageClassification","local":"transformers.HieraForImageClassification","sections":[],"depth":2}],"depth":1}';function xo(w){return co(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jo extends mo{constructor(t){super(),po(this,t,xo,Ho,io,{})}}export{Jo as component};
