import{s as Ga,o as Za,n as I}from"../chunks/scheduler.18a86fab.js";import{S as Wa,i as Va,g as u,s as i,r as g,A as Ba,h,f as a,c as d,j as x,u as _,x as w,k as j,l as Ra,y as f,a as l,v as y,d as T,t as b,w as M}from"../chunks/index.98837b22.js";import{T as no}from"../chunks/Tip.77304350.js";import{D as L}from"../chunks/Docstring.6758ea23.js";import{C as z}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as io}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as W}from"../chunks/Heading.7e7e0c5b.js";import{H as An,a as oe}from"../chunks/HfOption.6641485e.js";import{E as qa}from"../chunks/index.92f616ba.js";function Ea(J){let t,p=`The Llama 4 family of models comes in two flavors: 109B, and 402B parameters. Both of these flavors are extremely
large and won’t fit on your run-of-the-mill device. See below for some examples to reduce the memory usage of the
model.`,o,r,m=`For the download to be faster and more resilient, we recommend installing the <code>hf_xet</code> dependency as followed:
<code>pip install transformers[hf_xet]</code>`;return{c(){t=u("p"),t.textContent=p,o=i(),r=u("p"),r.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-59ca8l"&&(t.textContent=p),o=d(n),r=h(n,"P",{"data-svelte-h":!0}),w(r)!=="svelte-a4r835"&&(r.innerHTML=m)},m(n,c){l(n,t,c),l(n,o,c),l(n,r,c)},p:I,d(n){n&&(a(t),a(o),a(r))}}}function Na(J){let t,p;return t=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS00LVNjb3V0LTE3Qi0xNkUtSW5zdHJ1Y3QlMjIlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMndoYXQlMjBpcyUyMHRoZSUyMHJlY2lwZSUyMG9mJTIwbWF5b25uYWlzZSUzRiUyMiU3RCUyQyUwQSU1RCUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGUobWVzc2FnZXMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAwKSUwQXByaW50KG91dHB1dCU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qi0xJTVEJTVCJTIyY29udGVudCUyMiU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;what is the recipe of mayonnaise?&quot;</span>},
]

pipe = pipeline(
    <span class="hljs-string">&quot;text-generation&quot;</span>,
    model=model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)

output = pipe(messages, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">200</span>)
<span class="hljs-built_in">print</span>(output[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][-<span class="hljs-number">1</span>][<span class="hljs-string">&quot;content&quot;</span>])`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function Xa(J){let t,p;return t=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTQtU2NvdXQtMTdCLTE2RS1JbnN0cnVjdCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEElMEFtb2RlbCUyMCUzRCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzLnRvKG1vZGVsLmRldmljZSklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTVCJTNBJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlM0ElNUQpJTBBcHJpbnQob3V0cHV0cyU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Who are you?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>)

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)

outputs = model.generate(**inputs.to(model.device), max_new_tokens=<span class="hljs-number">100</span>)
outputs = tokenizer.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])
<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function Qa(J){let t,p;return t=new z({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

processor = AutoProcessor.from_pretrained(model_id)
model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)

img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg&quot;</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: img_url},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe this image in two sentences.&quot;</span>},
        ]
    },
]

inputs = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
).to(model.device)

outputs = model.generate(
    **inputs,
    max_new_tokens=<span class="hljs-number">256</span>,
)

response = processor.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function Ya(J){let t,p;return t=new z({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

processor = AutoProcessor.from_pretrained(model_id)
model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)

url1 = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg&quot;</span>
url2 = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/datasets/cat_style_layout.png&quot;</span>
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: url1},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: url2},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Can you describe how these two images are similar, and how they differ?&quot;</span>},
        ]
    },
]

inputs = processor.apply_chat_template(
    messages,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
).to(model.device)

outputs = model.generate(
    **inputs,
    max_new_tokens=<span class="hljs-number">256</span>,
)

response = processor.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(response)`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function Sa(J){let t,p=`Beware: the example below uses both <code>device_map=&quot;auto&quot;</code> and flex-attention.
Please use <code>torchrun</code> to run this example in tensor-parallel mode.`,o,r,m=`We will work to enable running with <code>device_map=&quot;auto&quot;</code> and flex-attention without
tensor-parallel in the future.`,n,c,v;return c=new z({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration, AutoTokenizer
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> time

file = <span class="hljs-string">&quot;very_long_context_prompt.txt&quot;</span>
model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
    very_long_text = <span class="hljs-string">&quot;\\n&quot;</span>.join(f.readlines())

tokenizer = AutoTokenizer.from_pretrained(model_id)
model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    attn_implementation=<span class="hljs-string">&quot;flex_attention&quot;</span>,
    torch_dtype=torch.bfloat16
)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">f&quot;Look at the following texts: [<span class="hljs-subst">{very_long_text}</span>]\\n\\n\\n\\nWhat are the books, and who wrote them? Make me a nice list.&quot;</span>},
]
input_ids = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

torch.cuda.synchronize()
start = time.time()
out = model.generate(
    input_ids.to(model.device),
    prefill_chunk_size=<span class="hljs-number">2048</span>*<span class="hljs-number">8</span>,
    max_new_tokens=<span class="hljs-number">300</span>,
    cache_implementation=<span class="hljs-string">&quot;hybrid&quot;</span>,
)
<span class="hljs-built_in">print</span>(time.time()-start)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(out[:, input_ids.shape[-<span class="hljs-number">1</span>]:]))
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{torch.cuda.max_memory_allocated(model.device) / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.2</span>f}</span> GiB&quot;</span>)`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=p,o=i(),r=u("p"),r.innerHTML=m,n=i(),g(c.$$.fragment)},l($){t=h($,"P",{"data-svelte-h":!0}),w(t)!=="svelte-ay5yv2"&&(t.innerHTML=p),o=d($),r=h($,"P",{"data-svelte-h":!0}),w(r)!=="svelte-18maour"&&(r.innerHTML=m),n=d($),_(c.$$.fragment,$)},m($,C){l($,t,C),l($,o,C),l($,r,C),l($,n,C),y(c,$,C),v=!0},p:I,i($){v||(T(c.$$.fragment,$),v=!0)},o($){b(c.$$.fragment,$),v=!1},d($){$&&(a(t),a(o),a(r),a(n)),M(c,$)}}}function Ha(J){let t,p,o,r,m,n,c,v,$,C;return t=new oe({props:{id:"usage",option:"Pipeline",$$slots:{default:[Na]},$$scope:{ctx:J}}}),o=new oe({props:{id:"usage",option:"AutoModel - Text only",$$slots:{default:[Xa]},$$scope:{ctx:J}}}),m=new oe({props:{id:"usage",option:"AutoModel - Multimodal",$$slots:{default:[Qa]},$$scope:{ctx:J}}}),c=new oe({props:{id:"usage",option:"AutoModel - Multimodal with multiple images",$$slots:{default:[Ya]},$$scope:{ctx:J}}}),$=new oe({props:{id:"usage",option:"AutoModel - Long context",$$slots:{default:[Sa]},$$scope:{ctx:J}}}),{c(){g(t.$$.fragment),p=i(),g(o.$$.fragment),r=i(),g(m.$$.fragment),n=i(),g(c.$$.fragment),v=i(),g($.$$.fragment)},l(U){_(t.$$.fragment,U),p=d(U),_(o.$$.fragment,U),r=d(U),_(m.$$.fragment,U),n=d(U),_(c.$$.fragment,U),v=d(U),_($.$$.fragment,U)},m(U,k){y(t,U,k),l(U,p,k),y(o,U,k),l(U,r,k),y(m,U,k),l(U,n,k),y(c,U,k),l(U,v,k),y($,U,k),C=!0},p(U,k){const O={};k&2&&(O.$$scope={dirty:k,ctx:U}),t.$set(O);const ao={};k&2&&(ao.$$scope={dirty:k,ctx:U}),o.$set(ao);const ke={};k&2&&(ke.$$scope={dirty:k,ctx:U}),m.$set(ke);const K={};k&2&&(K.$$scope={dirty:k,ctx:U}),c.$set(K);const so={};k&2&&(so.$$scope={dirty:k,ctx:U}),$.$set(so)},i(U){C||(T(t.$$.fragment,U),T(o.$$.fragment,U),T(m.$$.fragment,U),T(c.$$.fragment,U),T($.$$.fragment,U),C=!0)},o(U){b(t.$$.fragment,U),b(o.$$.fragment,U),b(m.$$.fragment,U),b(c.$$.fragment,U),b($.$$.fragment,U),C=!1},d(U){U&&(a(p),a(r),a(n),a(v)),M(t,U),M(o,U),M(m,U),M(c,U),M($,U)}}}function Pa(J){let t,p=`Beware: the example below uses both <code>device_map=&quot;auto&quot;</code> and flex-attention.
Please use <code>torchrun</code> to run this example in tensor-parallel mode.`,o,r,m=`We will work to enable running with <code>device_map=&quot;auto&quot;</code> and flex-attention without
tensor-parallel in the future.`;return{c(){t=u("p"),t.innerHTML=p,o=i(),r=u("p"),r.innerHTML=m},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-1jalrl2"&&(t.innerHTML=p),o=d(n),r=h(n,"P",{"data-svelte-h":!0}),w(r)!=="svelte-18maour"&&(r.innerHTML=m)},m(n,c){l(n,t,c),l(n,o,c),l(n,r,c)},p:I,d(n){n&&(a(t),a(o),a(r))}}}function Aa(J){let t,p="Setting Flex Attention ensures the best results with the very long context the model can handle.",o,r,m,n,c;return r=new no({props:{warning:!1,$$slots:{default:[Pa]},$$scope:{ctx:J}}}),n=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsZXhfYXR0ZW50aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    attn_implementation=<span class="hljs-string">&quot;flex_attention&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),{c(){t=u("p"),t.textContent=p,o=i(),g(r.$$.fragment),m=i(),g(n.$$.fragment)},l(v){t=h(v,"P",{"data-svelte-h":!0}),w(t)!=="svelte-heqywl"&&(t.textContent=p),o=d(v),_(r.$$.fragment,v),m=d(v),_(n.$$.fragment,v)},m(v,$){l(v,t,$),l(v,o,$),y(r,v,$),l(v,m,$),y(n,v,$),c=!0},p(v,$){const C={};$&2&&(C.$$scope={dirty:$,ctx:v}),r.$set(C)},i(v){c||(T(r.$$.fragment,v),T(n.$$.fragment,v),c=!0)},o(v){b(r.$$.fragment,v),b(n.$$.fragment,v),c=!1},d(v){v&&(a(t),a(o),a(m)),M(r,v),M(n,v)}}}function Da(J){let t,p="The <code>sdpa</code> attention method is generally more compute-efficient than the <code>eager</code> method.",o,r,m;return r=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    attn_implementation=<span class="hljs-string">&quot;sdpa&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=p,o=i(),g(r.$$.fragment)},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-9cvt94"&&(t.innerHTML=p),o=d(n),_(r.$$.fragment,n)},m(n,c){l(n,t,c),l(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function Oa(J){let t,p="The <code>eager</code> attention method is set by default, so no need for anything different when loading the model:",o,r,m;return r=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),{c(){t=u("p"),t.innerHTML=p,o=i(),g(r.$$.fragment)},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-wbfcsc"&&(t.innerHTML=p),o=d(n),_(r.$$.fragment,n)},m(n,c){l(n,t,c),l(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function Ka(J){let t,p,o,r,m,n;return t=new oe({props:{id:"Attention",option:"Flex Attention",$$slots:{default:[Aa]},$$scope:{ctx:J}}}),o=new oe({props:{id:"Attention",option:"SDPA",$$slots:{default:[Da]},$$scope:{ctx:J}}}),m=new oe({props:{id:"Attention",option:"Eager",$$slots:{default:[Oa]},$$scope:{ctx:J}}}),{c(){g(t.$$.fragment),p=i(),g(o.$$.fragment),r=i(),g(m.$$.fragment)},l(c){_(t.$$.fragment,c),p=d(c),_(o.$$.fragment,c),r=d(c),_(m.$$.fragment,c)},m(c,v){y(t,c,v),l(c,p,v),y(o,c,v),l(c,r,v),y(m,c,v),n=!0},p(c,v){const $={};v&2&&($.$$scope={dirty:v,ctx:c}),t.$set($);const C={};v&2&&(C.$$scope={dirty:v,ctx:c}),o.$set(C);const U={};v&2&&(U.$$scope={dirty:v,ctx:c}),m.$set(U)},i(c){n||(T(t.$$.fragment,c),T(o.$$.fragment,c),T(m.$$.fragment,c),n=!0)},o(c){b(t.$$.fragment,c),b(o.$$.fragment,c),b(m.$$.fragment,c),n=!1},d(c){c&&(a(p),a(r)),M(t,c),M(o,c),M(m,c)}}}function es(J){let t,p;return t=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBGYmdlbW1GcDhDb25maWclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTQtU2NvdXQtMTdCLTE2RS1JbnN0cnVjdCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hvJTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSklMEElMEFtb2RlbCUyMCUzRCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNERmJnZW1tRnA4Q29uZmlnKCklMEEpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzLnRvKG1vZGVsLmRldmljZSklMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTVCJTNBJTJDJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCLTElNUQlM0ElNUQpJTBBcHJpbnQob3V0cHV0cyU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForConditionalGeneration, FbgemmFp8Config
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Scout-17B-16E-Instruct&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Who are you?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>)

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
    quantization_config=FbgemmFp8Config()
)

outputs = model.generate(**inputs.to(model.device), max_new_tokens=<span class="hljs-number">100</span>)
outputs = tokenizer.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])
<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function ts(J){let t,p="To use the LLM-Compressor technique, we recommend leveraging the pre-quantized FP8 checkpoint available with the release:",o,r,m;return r=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTQtTWF2ZXJpY2stMTdCLTEyOEUtSW5zdHJ1Y3QtRlA4JTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaG8lMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlKSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhbWE0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRwX3BsYW4lM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMudG8obW9kZWwuZGV2aWNlKSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAwKSUwQW91dHB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlNUIlM0ElMkMlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQuc2hhcGUlNUItMSU1RCUzQSU1RCklMEFwcmludChvdXRwdXRzJTVCMCU1RCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;meta-llama/Llama-4-Maverick-17B-128E-Instruct-FP8&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)

messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Who are you?&quot;</span>},
]
inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_dict=<span class="hljs-literal">True</span>)

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    tp_plan=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)

outputs = model.generate(**inputs.to(model.device), max_new_tokens=<span class="hljs-number">100</span>)
outputs = tokenizer.batch_decode(outputs[:, inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[-<span class="hljs-number">1</span>]:])
<span class="hljs-built_in">print</span>(outputs[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){t=u("p"),t.textContent=p,o=i(),g(r.$$.fragment)},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-46ylbh"&&(t.textContent=p),o=d(n),_(r.$$.fragment,n)},m(n,c){l(n,t,c),l(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function os(J){let t,p,o,r;return t=new oe({props:{id:"Quantization",option:"FBGEMM",$$slots:{default:[es]},$$scope:{ctx:J}}}),o=new oe({props:{id:"Quantization",option:"LLM-Compressor",$$slots:{default:[ts]},$$scope:{ctx:J}}}),{c(){g(t.$$.fragment),p=i(),g(o.$$.fragment)},l(m){_(t.$$.fragment,m),p=d(m),_(o.$$.fragment,m)},m(m,n){y(t,m,n),l(m,p,n),y(o,m,n),r=!0},p(m,n){const c={};n&2&&(c.$$scope={dirty:n,ctx:m}),t.$set(c);const v={};n&2&&(v.$$scope={dirty:n,ctx:m}),o.$set(v)},i(m){r||(T(t.$$.fragment,m),T(o.$$.fragment,m),r=!0)},o(m){b(t.$$.fragment,m),b(o.$$.fragment,m),r=!1},d(m){m&&a(p),M(t,m),M(o,m)}}}function ns(J){let t,p;return t=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNE1vZGVsJTJDJTIwTGxhbWE0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMExsYW1hNCUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYW1hNENvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMExsYW1hNCUyMDdCJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4Model, Llama4Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama4 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Llama4Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Llama4 7B style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Llama4Model(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){g(t.$$.fragment)},l(o){_(t.$$.fragment,o)},m(o,r){y(t,o,r),p=!0},p:I,i(o){p||(T(t.$$.fragment,o),p=!0)},o(o){b(t.$$.fragment,o),p=!1},d(o){M(t,o)}}}function as(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=p},l(o){t=h(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){l(o,t,r)},p:I,d(o){o&&a(t)}}}function ss(J){let t,p="Example:",o,r,m;return r=new z({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbldoYXQncyUyMHRoZSUyMGNvbnRlbnQlMjBvZiUyMHRoZSUyMGltYWdlJTNGJTIwQVNTSVNUQU5UJTNBJTIyJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuaWxhbmtlbG1hbi5vcmclMkZzdG9wc2lnbnMlMkZhdXN0cmFsaWEuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTUpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;image&gt;\\nWhat&#x27;s the content of the image? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">15</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:  \\nWhat&#x27;s the content of the image? ASSISTANT: The image features a busy city street with a stop sign prominently displayed&quot;</span>`,wrap:!1}}),{c(){t=u("p"),t.textContent=p,o=i(),g(r.$$.fragment)},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=d(n),_(r.$$.fragment,n)},m(n,c){l(n,t,c),l(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function rs(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=p},l(o){t=h(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){l(o,t,r)},p:I,d(o){o&&a(t)}}}function ls(J){let t,p="Example:",o,r,m;return r=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhbWE0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWE0JTJGTGxhbWE0LTItN2ItaGYlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYTQlMkZMbGFtYTQtMi03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Llama4ForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){t=u("p"),t.textContent=p,o=i(),g(r.$$.fragment)},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=d(n),_(r.$$.fragment,n)},m(n,c){l(n,t,c),l(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function is(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=p},l(o){t=h(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){l(o,t,r)},p:I,d(o){o&&a(t)}}}function ds(J){let t,p=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=u("p"),t.innerHTML=p},l(o){t=h(o,"P",{"data-svelte-h":!0}),w(t)!=="svelte-fincs2"&&(t.innerHTML=p)},m(o,r){l(o,t,r)},p:I,d(o){o&&a(t)}}}function cs(J){let t,p="Example:",o,r,m;return r=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBMbGFtYTRGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhbWE0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWE0JTJGTGxhbWE0LTItN2ItaGYlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYTQlMkZMbGFtYTQtMi03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, Llama4ForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = Llama4ForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama4/Llama4-2-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){t=u("p"),t.textContent=p,o=i(),g(r.$$.fragment)},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=d(n),_(r.$$.fragment,n)},m(n,c){l(n,t,c),l(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function ms(J){let t,p="Example:",o,r,m;return r=new z({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1sbGFtYVZpc2lvbk1vZGVsJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItMTFCLVZpc2lvbiUyMiUwQW1vZGVsJTIwJTNEJTIwTWxsYW1hVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQXByaW50KG91dHB1dC5sYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MllamaVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaVisionModel.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output.last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1025</span>, <span class="hljs-number">7680</span>])`,wrap:!1}}),{c(){t=u("p"),t.textContent=p,o=i(),g(r.$$.fragment)},l(n){t=h(n,"P",{"data-svelte-h":!0}),w(t)!=="svelte-11lpom8"&&(t.textContent=p),o=d(n),_(r.$$.fragment,n)},m(n,c){l(n,t,c),l(n,o,c),y(r,n,c),m=!0},p:I,i(n){m||(T(r.$$.fragment,n),m=!0)},o(n){b(r.$$.fragment,n),m=!1},d(n){n&&(a(t),a(o)),M(r,n)}}}function ps(J){let t,p,o,r,m,n,c,v='<div class="flex flex-wrap space-x-1"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/></div>',$,C,U=`Llama 4, developed by Meta, introduces a new auto-regressive Mixture-of-Experts (MoE) architecture.
This generation includes two models:`,k,O,ao=`<li>The highly capable Llama 4 Maverick with 17B active parameters out of ~400B total, with 128 experts.</li> <li>The efficient Llama 4 Scout also  has 17B active parameters out of ~109B total, using just 16 experts.</li> <li>Both models leverage early fusion for native multimodality, enabling them to process text and image inputs.
Maverick and Scout are both trained on up to 40 trillion tokens on data encompassing 200 languages
(with specific fine-tuning support for 12 languages including Arabic, Spanish, German, and Hindi).</li>`,ke,K,so=`For deployment, Llama 4 Scout is designed for accessibility, fitting on a single server-grade GPU via
on-the-fly 4-bit or 8-bitint4 quantization, while Maverick is available in BF16 and FP8 formats.
These models are released under the custom Llama 4 Community License Agreement, available on the model repositories.`,co,Ce,Dn='You can find all the original Llama checkpoints under the <a href="https://huggingface.co/meta-llama" rel="nofollow">meta-llama</a> organization.',mo,re,po,xe,On=`The examples below demonstrates how to generate with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a>. We additionally add an example
showcasing how to toggle the right attributes to enable very long-context generations, as some flavors of Llama 4
have context lengths going up to 10 million tokens.`,uo,le,ho,je,fo,Le,go,Ie,Kn='Updating the default attention function can significantly improve compute performance as well as memory usage. Refer to the <a href="../attention_interface">Attention Interface</a> overview for an in-depth explanation of our interface.',_o,ze,ea=`As of release, the Llama 4 model supports the following attention methods: <code>eager</code>, <code>flex_attention</code>, <code>sdpa</code>. We recommend using <code>flex_attention</code> for best results.
Switching attention mechanism is done at the model initialization step:`,yo,ie,To,Fe,bo,Ge,ta=`Quantization reduces the memory burden of large models by representing the weights in a lower precision. Refer to the <a href="../quantization/overview">Quantization</a> overview for available quantization backends.
At time of release, both FBGEMM and LLM-Compressor are supported; more quantization methods will be supported in the days that follow the release.`,Mo,Ze,oa="See below for examples using both:",wo,We,na="Here is an example loading an BF16 model in FP8 using the FBGEMM approach:",vo,de,Jo,Ve,Uo,Be,aa=`Enabling CPU-offloading means that components of the model might be moved to CPU instead of GPU in case the GPU-memory available isn’t sufficient to load the entire model.
At inference, different components will be loaded/unloaded from/to the GPU on the fly. This ensures that the model can be loaded on smaller machines as long as the CPU-memory is sufficient.
However, this also slows down inference as it adds communication overhead.`,$o,Re,sa="In order to enable CPU-offloading, you simply need to specify the <code>device_map</code> to <code>auto</code> at model load:",ko,qe,Co,Ee,xo,F,Ne,sn,jt,ra=`This is the configuration class to store the configuration of a <code>Llama4Model</code>. It is used to instantiate an
Llama4 model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Llama4 109B.`,rn,Lt,la='e.g. <a href="https://huggingface.co/meta-llama/Llama-4-Scout-17B-16E" rel="nofollow">meta-llama/Llama-4-Scout-17B-16E</a>',ln,It,ia=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,dn,ce,jo,Xe,Lo,G,Qe,cn,zt,da=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextModel">Llama4TextModel</a>. It is used to instantiate a
Llama4 text model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Llama4 109B.`,mn,Ft,ca='e.g. <a href="https://huggingface.co/meta-llama/Llama-4-Scout-17B-16E" rel="nofollow">meta-llama/Llama-4-Scout-17B-16E</a>',pn,Gt,ma=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,un,Zt,pa="Example:",Io,Ye,zo,V,Se,hn,Wt,ua=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4VisionModel">Llama4VisionModel</a>. It is used to instantiate a
Llama4 vision model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Llama4 109B.`,fn,Vt,ha='e.g. <a href="https://huggingface.co/meta-llama/Llama-4-Scout-17B-16E" rel="nofollow">meta-llama/Llama-4-Scout-17B-16E</a>',gn,Bt,fa=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Fo,He,Go,B,Pe,_n,Rt,ga=`Constructs a Llama4 processor which wraps a <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> and
<code>PretrainedTokenizerFast</code> tokenizer into a single processor that inherits both the image processor and
tokenizer functionalities. See the <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Processor.decode">decode()</a> for more information.`,yn,me,Ae,Tn,qt,_a=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,bn,pe,De,Mn,Et,ya=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Zo,Oe,Wo,R,Ke,wn,Nt,Ta="Constructs a fast Llama4 image processor.",vn,Xt,et,Jn,ue,tt,Un,Qt,ba=`Rescale and normalize images.
Override to rescale and normalize the images in torch.bfloat16 as in the original implementation`,Vo,ot,Bo,Y,nt,$n,N,at,kn,Yt,Ma='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4ForConditionalGeneration">Llama4ForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Cn,he,xn,fe,jn,ge,st,Ln,St,wa="Obtains image last hidden states from the vision tower and apply al projection.",Ro,rt,va="<li>forward</li>",qo,lt,Eo,ne,it,In,X,dt,zn,Ht,Ja='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4ForCausalLM">Llama4ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Fn,_e,Gn,ye,No,ct,Ua="<li>forward</li>",Xo,mt,Qo,Z,pt,Zn,Pt,$a="The bare Llama4 Text Model outputting raw hidden-states without any specific head on to.",Wn,At,ka=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Vn,Dt,Ca=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Bn,ee,ut,Rn,Ot,xa='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextModel">Llama4TextModel</a> forward method, overrides the <code>__call__</code> special method.',qn,Te,Yo,ht,ja="<li>forward</li>",So,ft,Ho,ae,gt,En,Q,_t,Nn,Kt,La='The <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4ForCausalLM">Llama4ForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Xn,be,Qn,Me,Po,yt,Ia="<li>forward</li>",Ao,Tt,Do,S,bt,Yn,we,Mt,Sn,ve,Hn,Je,wt,Pn,eo,za="This function is used to fetch the first embedding layer to activate grads on inputs.",Oo,vt,Fa="<li>forward</li>",Ko,Jt,en,ro,tn;return m=new W({props:{title:"Llama4",local:"llama4",headingTag:"h1"}}),re=new no({props:{warning:!1,$$slots:{default:[Ea]},$$scope:{ctx:J}}}),le=new An({props:{id:"usage",options:["Pipeline","AutoModel - Text only","AutoModel - Multimodal","AutoModel - Multimodal with multiple images","AutoModel - Long context"],$$slots:{default:[Ha]},$$scope:{ctx:J}}}),je=new W({props:{title:"Efficiency; how to get the best out of llama 4",local:"efficiency-how-to-get-the-best-out-of-llama-4",headingTag:"h2"}}),Le=new W({props:{title:"The Attention methods",local:"the-attention-methods",headingTag:"h3"}}),ie=new An({props:{id:"Attention",options:["Flex Attention","SDPA","Eager"],$$slots:{default:[Ka]},$$scope:{ctx:J}}}),Fe=new W({props:{title:"Quantization",local:"quantization",headingTag:"h3"}}),de=new An({props:{id:"Quantization",options:["FBGEMM","LLM-Compressor"],$$slots:{default:[os]},$$scope:{ctx:J}}}),Ve=new W({props:{title:"Offloading",local:"offloading",headingTag:"h3"}}),qe=new z({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYW1hNEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGFtYTRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Llama4ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

model = Llama4ForConditionalGeneration.from_pretrained(
    model_id,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16,
)`,wrap:!1}}),Ee=new W({props:{title:"Llama4Config",local:"transformers.Llama4Config",headingTag:"h2"}}),Ne=new L({props:{name:"class transformers.Llama4Config",anchor:"transformers.Llama4Config",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"boi_token_index",val:" = 200080"},{name:"eoi_token_index",val:" = 200081"},{name:"image_token_index",val:" = 200092"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4Config.vision_config",description:`<strong>vision_config</strong> (<code>Llama4VisionConfig</code>, <em>optional</em>) &#x2014;
The Llama4 Vision config.`,name:"vision_config"},{anchor:"transformers.Llama4Config.text_config",description:`<strong>text_config</strong> (<code>Llama4TextConfig</code>, <em>optional</em>) &#x2014;
The Llama4 Text config.`,name:"text_config"},{anchor:"transformers.Llama4Config.boi_token_index",description:`<strong>boi_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 200080) &#x2014;
The begin-of-image token index to wrap the image prompt.`,name:"boi_token_index"},{anchor:"transformers.Llama4Config.eoi_token_index",description:`<strong>eoi_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 200081) &#x2014;
The end-of-image token index to wrap the image prompt.`,name:"eoi_token_index"},{anchor:"transformers.Llama4Config.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 200092) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.Llama4Config.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/configuration_llama4.py#L374"}}),ce=new io({props:{anchor:"transformers.Llama4Config.example",$$slots:{default:[ns]},$$scope:{ctx:J}}}),Xe=new W({props:{title:"Llama4TextConfig",local:"transformers.Llama4TextConfig",headingTag:"h2"}}),Qe=new L({props:{name:"class transformers.Llama4TextConfig",anchor:"transformers.Llama4TextConfig",parameters:[{name:"vocab_size",val:" = 202048"},{name:"hidden_size",val:" = 5120"},{name:"intermediate_size",val:" = 8192"},{name:"intermediate_size_mlp",val:" = 16384"},{name:"num_hidden_layers",val:" = 48"},{name:"num_attention_heads",val:" = 40"},{name:"num_key_value_heads",val:" = 8"},{name:"head_dim",val:" = 128"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 131072"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 500000"},{name:"attention_dropout",val:" = 0.0"},{name:"num_experts_per_tok",val:" = 1"},{name:"num_local_experts",val:" = 16"},{name:"moe_layers",val:" = None"},{name:"interleave_moe_layer_step",val:" = 1"},{name:"use_qk_norm",val:" = True"},{name:"output_router_logits",val:" = False"},{name:"router_aux_loss_coef",val:" = 0.001"},{name:"router_jitter_noise",val:" = 0.0"},{name:"rope_scaling",val:" = None"},{name:"no_rope_layers",val:" = None"},{name:"no_rope_layer_interval",val:" = 4"},{name:"attention_chunk_size",val:" = 8192"},{name:"layer_types",val:" = None"},{name:"attn_temperature_tuning",val:" = True"},{name:"floor_scale",val:" = 8192"},{name:"attn_scale",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4TextConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 202048) &#x2014;
Vocabulary size of the Llama4 text model. Defines the maximum number of different tokens that can be represented
by the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextModel">Llama4TextModel</a>.`,name:"vocab_size"},{anchor:"transformers.Llama4TextConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5120) &#x2014;
Dimensionality of the embeddings and hidden states.`,name:"hidden_size"},{anchor:"transformers.Llama4TextConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Llama4TextConfig.intermediate_size_mlp",description:"<strong>intermediate_size_mlp</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014; TODO",name:"intermediate_size_mlp"},{anchor:"transformers.Llama4TextConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 48) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Llama4TextConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 40) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Llama4TextConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If not
specified, will default to <code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.Llama4TextConfig.head_dim",description:"<strong>head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014; TODO",name:"head_dim"},{anchor:"transformers.Llama4TextConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>Callable</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler.`,name:"hidden_act"},{anchor:"transformers.Llama4TextConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 131072) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.Llama4TextConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Llama4TextConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.Llama4TextConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions.`,name:"use_cache"},{anchor:"transformers.Llama4TextConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 128004) &#x2014;
The id of the padding token.`,name:"pad_token_id"},{anchor:"transformers.Llama4TextConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the beginning of sentence token.`,name:"bos_token_id"},{anchor:"transformers.Llama4TextConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the end of sentence token.`,name:"eos_token_id"},{anchor:"transformers.Llama4TextConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.Llama4TextConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>500000.0</code>) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.Llama4TextConfig.attention_dropout",description:"<strong>attention_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"attention_dropout"},{anchor:"transformers.Llama4TextConfig.num_experts_per_tok",description:"<strong>num_experts_per_tok</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; TODO",name:"num_experts_per_tok"},{anchor:"transformers.Llama4TextConfig.num_local_experts",description:"<strong>num_local_experts</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014; TODO",name:"num_local_experts"},{anchor:"transformers.Llama4TextConfig.moe_layers",description:"<strong>moe_layers</strong> (<code>int</code>, <em>optional</em>) &#x2014; TODO",name:"moe_layers"},{anchor:"transformers.Llama4TextConfig.interleave_moe_layer_step",description:"<strong>interleave_moe_layer_step</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; TODO",name:"interleave_moe_layer_step"},{anchor:"transformers.Llama4TextConfig.use_qk_norm",description:"<strong>use_qk_norm</strong> (<code>int</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; TODO",name:"use_qk_norm"},{anchor:"transformers.Llama4TextConfig.output_router_logits",description:"<strong>output_router_logits</strong> (<code>int</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; TODO",name:"output_router_logits"},{anchor:"transformers.Llama4TextConfig.router_aux_loss_coef",description:"<strong>router_aux_loss_coef</strong> (<code>int</code>, <em>optional</em>, defaults to 0.001) &#x2014; TODO",name:"router_aux_loss_coef"},{anchor:"transformers.Llama4TextConfig.router_jitter_noise",description:"<strong>router_jitter_noise</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"router_jitter_noise"},{anchor:"transformers.Llama4TextConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE<todo>
<todo></todo></todo>`,name:"rope_scaling"},{anchor:"transformers.Llama4TextConfig.no_rope_layers",description:`<strong>no_rope_layers</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List with at least the same length as the number of layers in the model.
A <code>1</code> at an index position indicates that the corresponding layer will use RoPE,
while a <code>0</code> indicates that it&#x2019;s a NoPE layer.`,name:"no_rope_layers"},{anchor:"transformers.Llama4TextConfig.no_rope_layer_interval",description:`<strong>no_rope_layer_interval</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
If <code>no_rope_layers</code> is <code>None</code>, it will be created using a NoPE layer every
<code>no_rope_layer_interval</code> layers.`,name:"no_rope_layer_interval"},{anchor:"transformers.Llama4TextConfig.attention_chunk_size",description:"<strong>attention_chunk_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;<todo></todo>",name:"attention_chunk_size"},{anchor:"transformers.Llama4TextConfig.layer_types",description:`<strong>layer_types</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Attention pattern for each layer.`,name:"layer_types"},{anchor:"transformers.Llama4TextConfig.attn_temperature_tuning",description:`<strong>attn_temperature_tuning</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to dynamically scale the attention temperature for each query token based on sequence length.
Recommended for long sequences (e.g., &gt;32k tokens) to maintain stable output results.`,name:"attn_temperature_tuning"},{anchor:"transformers.Llama4TextConfig.floor_scale",description:"<strong>floor_scale</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014; TODO",name:"floor_scale"},{anchor:"transformers.Llama4TextConfig.attn_scale",description:"<strong>attn_scale</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014; TODO",name:"attn_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/configuration_llama4.py#L131"}}),Ye=new W({props:{title:"Llama4VisionConfig",local:"transformers.Llama4VisionConfig",headingTag:"h2"}}),Se=new L({props:{name:"class transformers.Llama4VisionConfig",anchor:"transformers.Llama4VisionConfig",parameters:[{name:"hidden_size",val:": int = 768"},{name:"hidden_act",val:": str = 'gelu'"},{name:"num_hidden_layers",val:": int = 34"},{name:"num_attention_heads",val:": int = 16"},{name:"num_channels",val:": int = 3"},{name:"intermediate_size",val:": int = 5632"},{name:"vision_output_dim",val:": int = 7680"},{name:"image_size",val:": int = 448"},{name:"patch_size",val:": int = 14"},{name:"norm_eps",val:": float = 1e-05"},{name:"vision_feature_layer",val:" = -1"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"initializer_range",val:": float = 0.02"},{name:"pixel_shuffle_ratio",val:" = 0.5"},{name:"projector_input_dim",val:" = 4096"},{name:"projector_output_dim",val:" = 4096"},{name:"multi_modal_projector_bias",val:" = False"},{name:"projector_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"rope_theta",val:" = 10000"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4VisionConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.Llama4VisionConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> <code>&quot;quick_gelu&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.Llama4VisionConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 34) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.Llama4VisionConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.Llama4VisionConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input image.`,name:"num_channels"},{anchor:"transformers.Llama4VisionConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 5632) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.Llama4VisionConfig.vision_output_dim",description:`<strong>vision_output_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 7680) &#x2014;
Dimensionality of the vision model output. Includes output of transformer
encoder with intermediate layers and global transformer encoder.`,name:"vision_output_dim"},{anchor:"transformers.Llama4VisionConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 448) &#x2014;
The size (resolution) of each image <em>tile</em>.`,name:"image_size"},{anchor:"transformers.Llama4VisionConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.Llama4VisionConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"norm_eps"},{anchor:"transformers.Llama4VisionConfig.vision_feature_layer",description:"<strong>vision_feature_layer</strong> (&#x201C;, <em>optional</em>, defaults to -1) &#x2014; TODO",name:"vision_feature_layer"},{anchor:"transformers.Llama4VisionConfig.vision_feature_select_strategy",description:"<strong>vision_feature_select_strategy</strong> (<code>int</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014; TODO",name:"vision_feature_select_strategy"},{anchor:"transformers.Llama4VisionConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.Llama4VisionConfig.pixel_shuffle_ratio",description:"<strong>pixel_shuffle_ratio</strong> (<code>int</code>, <em>optional</em>, defaults to 0.5) &#x2014; TODO",name:"pixel_shuffle_ratio"},{anchor:"transformers.Llama4VisionConfig.projector_input_dim",description:"<strong>projector_input_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014; TODO",name:"projector_input_dim"},{anchor:"transformers.Llama4VisionConfig.projector_output_dim",description:"<strong>projector_output_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014; TODO",name:"projector_output_dim"},{anchor:"transformers.Llama4VisionConfig.multi_modal_projector_bias",description:"<strong>multi_modal_projector_bias</strong> (<code>int</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; TODO",name:"multi_modal_projector_bias"},{anchor:"transformers.Llama4VisionConfig.projector_dropout",description:"<strong>projector_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"projector_dropout"},{anchor:"transformers.Llama4VisionConfig.attention_dropout",description:"<strong>attention_dropout</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014; TODO",name:"attention_dropout"},{anchor:"transformers.Llama4VisionConfig.rope_theta",description:"<strong>rope_theta</strong> (<code>int</code>, <em>optional</em>, defaults to 10000) &#x2014; TODO",name:"rope_theta"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/configuration_llama4.py#L25"}}),He=new W({props:{title:"Llama4Processor",local:"transformers.Llama4Processor",headingTag:"h2"}}),Pe=new L({props:{name:"class transformers.Llama4Processor",anchor:"transformers.Llama4Processor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:": int = 14"},{name:"pixel_shuffle_ratio",val:": float = 0.5"},{name:"fake_image_token",val:" = '<|image|>'"},{name:"image_token",val:" = '<|image|>'"},{name:"start_of_image_token",val:" = '<|image_start|>'"},{name:"end_of_image_token",val:" = '<|image_end|>'"},{name:"patch_token",val:" = '<|patch|>'"},{name:"tile_x_separator_token",val:" = '<|tile_x_separator|>'"},{name:"tile_y_separator_token",val:" = '<|tile_y_separator|>'"},{name:"chat_template",val:` = '{{- bos_token }}\\n{%- if custom_tools is defined %}\\n    {%- set tools = custom_tools %}\\n{%- endif %}\\n{%- if not tools_in_user_message is defined %}\\n    {%- set tools_in_user_message = true %}\\n{%- endif %}\\n{%- if not date_string is defined %}\\n    {%- if strftime_now is defined %}\\n        {%- set date_string = strftime_now("%d %b %Y") %}\\n    {%- else %}\\n        {%- set date_string = "26 Jul 2024" %}\\n    {%- endif %}\\n{%- endif %}\\n{%- if not tools is defined %}\\n    {%- set tools = none %}\\n{%- endif %}\\n\\n{#- This block extracts the system message, so we can slot it into the right place. #}\\n{%- if messages[0][\\'role\\'] == \\'system\\' %}    \\n    {%- if messages[0][\\'content\\'] is string %}\\n        {%- set system_message = messages[0][\\'content\\']|trim %}\\n    {%- else %}\\n        {#- FIXME: The processor requires an array, always. #}\\n        {%- set system_message = messages[0][\\'content\\'][0][\\'text\\']|trim %}\\n    {%- endif %}\\n    {%- set messages = messages[1:] %}\\n    {%- set user_supplied_system_message = true %}\\n{%- else %}\\n    {%- set system_message = "" %}\\n    {%- set user_supplied_system_message = false %}\\n{%- endif %}\\n\\n{#- System message if the user supplied one #}\\n{%- if user_supplied_system_message %}\\n    {{- "<|header_start|>system<|header_end|>\\n\\n" }}\\n    {%- if tools is not none %}\\n        {{- "Environment: ipython\\n" }}\\n    {%- endif %}\\n    {%- if tools is not none and not tools_in_user_message %}\\n        {{- "You have access to the following functions. To call a function, please respond with JSON for a function call." }}\\n        {{- \\'Respond in the format {"name": function name, "parameters": dictionary of argument name and its value}.\\' }}\\n        {{- "Do not use variables.\\n\\n" }}\\n        {%- for t in tools %}\\n            {{- t | tojson(indent=4) }}\\n            {{- "\\n\\n" }}\\n        {%- endfor %}\\n    {%- endif %}\\n    {{- system_message }}\\n    {{- "<|eot|>" }}\\n{%- endif %}\\n\\n{#- Custom tools are passed in a user message with some extra guidance #}\\n{%- if tools_in_user_message and not tools is none %}\\n    {#- Extract the first user message so we can plug it in here #}\\n    {%- if messages | length != 0 %}\\n        {%- set first_user_message = messages[0][\\'content\\']|trim %}\\n        {%- set messages = messages[1:] %}\\n    {%- else %}\\n        {{- raise_exception("Cannot put tools in the first user message when there\\'s no first user message!") }}\\n{%- endif %}\\n    {{- \\'<|header_start|>user<|header_end|>\\n\\n\\' -}}\\n    {{- "Given the following functions, please respond with a JSON for a function call " }}\\n    {{- "with its proper arguments that best answers the given prompt.\\n\\n" }}\\n    {{- \\'Respond in the format {"name": function name, "parameters": dictionary of argument name and its value}.\\' }}\\n    {{- "Do not use variables.\\n\\n" }}\\n    {%- for t in tools %}\\n        {{- t | tojson(indent=4) }}\\n        {{- "\\n\\n" }}\\n    {%- endfor %}\\n    {{- first_user_message + "<|eot|>"}}\\n{%- endif %}\\n\\n{%- for message in messages %}\\n    {%- if not (message.role == \\'ipython\\' or message.role == \\'tool\\' or \\'tool_calls\\' in message) %}\\n    {{- \\'<|header_start|>\\' + message[\\'role\\'] + \\'<|header_end|>\\n\\n\\' }}\\n        {%- if message[\\'content\\'] is string %}\\n            {{- message[\\'content\\'] }}\\n        {%- else %}\\n            {%- for content in message[\\'content\\'] %}\\n                {%- if content[\\'type\\'] == \\'image\\' %}\\n                    {{- \\'<|image|>\\' }}\\n                {%- elif content[\\'type\\'] == \\'text\\' %}\\n                    {{- content[\\'text\\'] }}\\n                {%- endif %}\\n            {%- endfor %}\\n        {%- endif %}\\n        {{- "<|eot|>" }}\\n    {%- elif \\'tool_calls\\' in message and message.tool_calls|length > 0 %}\\n       {{- \\'<|header_start|>assistant<|header_end|>\\n\\n\\' -}}\\n       {{- \\'<|python_start|>\\' }}\\n        {%- if message[\\'content\\'] is string %}\\n            {{- message[\\'content\\'] }}\\n        {%- else %}\\n            {%- for content in message[\\'content\\'] %}\\n                {%- if content[\\'type\\'] == \\'image\\' %}\\n                    {{- \\'<|image|>\\' }}\\n                {%- elif content[\\'type\\'] == \\'text\\' %}\\n                    {{- content[\\'text\\'] }}\\n                {%- endif %}\\n            {%- endfor %}\\n        {%- endif %}\\n       {{- \\'<|python_end|>\\' }}\\n        {%- for tool_call in message.tool_calls %}\\n           {{- \\'{"name": "\\' + tool_call.function.name + \\'", \\' }}\\n           {{- \\'"parameters": \\' }}\\n           {{- tool_call.function.arguments | tojson }}\\n           {{- "}" }}\\n        {%- endfor %}\\n       {{- "<|eot|>" }}\\n    {%- elif message.role == "tool" or message.role == "ipython" %}\\n        {{- "<|header_start|>ipython<|header_end|>\\n\\n" }}\\n        {%- if message.content is mapping or message.content is iterable %}\\n            {{- message.content | tojson }}\\n        {%- else %}\\n            {{- message.content }}\\n        {%- endif %}\\n        {{- "<|eot|>" }}\\n    {%- endif %}\\n{%- endfor %}\\n{%- if add_generation_prompt %}\\n    {{- \\'<|header_start|>assistant<|header_end|>\\n\\n\\' }}\\n{%- endif %}\\n'`},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4Processor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.Llama4Processor.tokenizer",description:`<strong>tokenizer</strong> ([<code>PreTrainedTokenizer</code>, <code>PreTrainedTokenizerFast</code>], <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.Llama4Processor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 28) &#x2014;
The size of image patches for tokenization.`,name:"patch_size"},{anchor:"transformers.Llama4Processor.img_size",description:`<strong>img_size</strong> (<code>int</code>, <em>optional</em>, defaults to 364) &#x2014;
The size of the image to be tokenized. This should correspond to the size given to the image processor.`,name:"img_size"},{anchor:"transformers.Llama4Processor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|image|&gt;&quot;</code>) &#x2014;
The token to be used to represent an image in the text.`,name:"image_token"},{anchor:"transformers.Llama4Processor.downsample_factor",description:`<strong>downsample_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The factor by which to scale the patch size.`,name:"downsample_factor"},{anchor:"transformers.Llama4Processor.start_of_img_token",description:`<strong>start_of_img_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|START_OF_IMG|&gt;&quot;</code>) &#x2014;
The token to be used to represent the start of an image in the text.`,name:"start_of_img_token"},{anchor:"transformers.Llama4Processor.end_of_img_token",description:`<strong>end_of_img_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|END_OF_IMG|&gt;&quot;</code>) &#x2014;
The token to be used to represent the end of an image in the text.`,name:"end_of_img_token"},{anchor:"transformers.Llama4Processor.img_patch_token",description:`<strong>img_patch_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|IMG_PATCH|&gt;&quot;</code>) &#x2014;
The token to be used to represent an image patch in the text.`,name:"img_patch_token"},{anchor:"transformers.Llama4Processor.img_line_break_token",description:`<strong>img_line_break_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;|IMG_LINE_BREAK|&gt;&quot;</code>) &#x2014;
The token to be used to represent a line break in the text.`,name:"img_line_break_token"},{anchor:"transformers.Llama4Processor.tile_token",description:`<strong>tile_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;TILE&quot;</code>) &#x2014;
The token to be used to represent an image patch in the text.`,name:"tile_token"},{anchor:"transformers.Llama4Processor.tile_global_token",description:`<strong>tile_global_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;TILE_GLOBAL&quot;</code>) &#x2014;
The token to be used to represent the cover image in the text.`,name:"tile_global_token"},{anchor:"transformers.Llama4Processor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/processing_llama4.py#L51"}}),Ae=new L({props:{name:"batch_decode",anchor:"transformers.Llama4Processor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/processing_llama4.py#L258"}}),De=new L({props:{name:"decode",anchor:"transformers.Llama4Processor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/processing_llama4.py#L265"}}),Oe=new W({props:{title:"Llama4ImageProcessorFast",local:"transformers.Llama4ImageProcessorFast",headingTag:"h2"}}),Ke=new L({props:{name:"class transformers.Llama4ImageProcessorFast",anchor:"transformers.Llama4ImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.image_processing_llama4_fast.Llama4ImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.Llama4ImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Llama4ImageProcessorFast.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>{&apos;height&apos; -- 336, &apos;width&apos;: 336}</code>):
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.Llama4ImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.Llama4ImageProcessorFast.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.Llama4ImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.Llama4ImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.Llama4ImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.Llama4ImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>, defaults to <code>0.00392156862745098</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Llama4ImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Llama4ImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.Llama4ImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>, defaults to <code>[0.5, 0.5, 0.5]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.Llama4ImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Llama4ImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>, defaults to <code>None</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.Llama4ImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.Llama4ImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>, defaults to <code>None</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.Llama4ImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.Llama4ImageProcessorFast.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum number of patches to be extracted from the image.
Can be overridden by the <code>max_patches</code> parameter in the <code>preprocess</code> method.`,name:"max_patches"},{anchor:"transformers.Llama4ImageProcessorFast.resize_to_max_canvas",description:`<strong>resize_to_max_canvas</strong> (<code>bool</code>, <em>optional</em>, defaults to False) &#x2014;
Whether to resize the image to the maximum canvas size.
If True, picks the canvas the allows the largest resizing without distortion.
If False, downsample as little as possible, including no resizing at all,
but never upsample, unless the image is smaller than the patch size.`,name:"resize_to_max_canvas"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/image_processing_llama4_fast.py#L338"}}),et=new L({props:{name:"preprocess",anchor:"transformers.Llama4ImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.image_processing_llama4_fast.Llama4ImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.Llama4ImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, list[&apos;PIL.Image.Image&apos;], list[numpy.ndarray], list[&apos;torch.Tensor&apos;]]</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>Union[PILImageResampling, F.InterpolationMode, NoneType]</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>dict[str, int]</code>, <em>optional</em>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>Union[int, float, NoneType]</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>Union[float, list[float], NoneType]</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>Union[str, ~utils.generic.TensorType, NoneType]</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>~image_utils.ChannelDimension</code>, <em>optional</em>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>Union[~image_utils.ChannelDimension, str, NoneType]</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.max_patches",description:`<strong>max_patches</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The maximum number of patches to be extracted from the image.
Can be overridden by the <code>max_patches</code> parameter in the <code>preprocess</code> method.`,name:"max_patches"},{anchor:"transformers.Llama4ImageProcessorFast.preprocess.resize_to_max_canvas",description:`<strong>resize_to_max_canvas</strong> (<code>bool</code>, <em>optional</em>, defaults to False) &#x2014;
Whether to resize the image to the maximum canvas size.
If True, picks the canvas the allows the largest resizing without distortion.
If False, downsample as little as possible, including no resizing at all,
but never upsample, unless the image is smaller than the patch size.`,name:"resize_to_max_canvas"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/image_processing_llama4_fast.py#L380",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>data</strong> (<code>dict</code>) — Dictionary of lists/arrays/tensors returned by the <strong>call</strong> method (‘pixel_values’, etc.).</li>
<li><strong>tensor_type</strong> (<code>Union[None, str, TensorType]</code>, <em>optional</em>) — You can give a tensor_type here to convert the lists of integers in PyTorch/TensorFlow/Numpy Tensors at
initialization.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>&lt;class 'transformers.image_processing_base.BatchFeature'&gt;</code></p>
`}}),tt=new L({props:{name:"rescale_and_normalize",anchor:"transformers.Llama4ImageProcessorFast.rescale_and_normalize",parameters:[{name:"images",val:": torch.Tensor"},{name:"do_rescale",val:": bool"},{name:"rescale_factor",val:": float"},{name:"do_normalize",val:": bool"},{name:"image_mean",val:": typing.Union[float, typing.List[float]]"},{name:"image_std",val:": typing.Union[float, typing.List[float]]"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/image_processing_llama4_fast.py#L356"}}),ot=new W({props:{title:"Llama4ForConditionalGeneration",local:"transformers.Llama4ForConditionalGeneration",headingTag:"h2"}}),nt=new L({props:{name:"class transformers.Llama4ForConditionalGeneration",anchor:"transformers.Llama4ForConditionalGeneration",parameters:[{name:"config",val:": Llama4Config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1256"}}),at=new L({props:{name:"forward",anchor:"transformers.Llama4ForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"image_sizes",val:": Tensor = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.modeling_llama4.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Llama4ForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int], NoneType]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"},{anchor:"transformers.Llama4ForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, 2)</code>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1321",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llama4.modeling_llama4.Llama4CausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llama4.modeling_llama4.Llama4CausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new no({props:{$$slots:{default:[as]},$$scope:{ctx:J}}}),fe=new io({props:{anchor:"transformers.Llama4ForConditionalGeneration.forward.example",$$slots:{default:[ss]},$$scope:{ctx:J}}}),st=new L({props:{name:"get_image_features",anchor:"transformers.Llama4ForConditionalGeneration.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"},{name:"vision_feature_select_strategy",val:": str"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Llama4ForConditionalGeneration.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"},{anchor:"transformers.Llama4ForConditionalGeneration.get_image_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.Llama4ForConditionalGeneration.get_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1291",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Image feature tensor of shape <code>(num_images, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code>)</p>
`}}),lt=new W({props:{title:"Llama4ForCausalLM",local:"transformers.Llama4ForCausalLM",headingTag:"h2"}}),it=new L({props:{name:"class transformers.Llama4ForCausalLM",anchor:"transformers.Llama4ForCausalLM",parameters:[{name:"config",val:": Llama4TextConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L635"}}),dt=new L({props:{name:"forward",anchor:"transformers.Llama4ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.modeling_llama4.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Llama4ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Llama4ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Llama4ForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L669",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),_e=new no({props:{$$slots:{default:[rs]},$$scope:{ctx:J}}}),ye=new io({props:{anchor:"transformers.Llama4ForCausalLM.forward.example",$$slots:{default:[ls]},$$scope:{ctx:J}}}),mt=new W({props:{title:"Llama4TextModel",local:"transformers.Llama4TextModel",headingTag:"h2"}}),pt=new L({props:{name:"class transformers.Llama4TextModel",anchor:"transformers.Llama4TextModel",parameters:[{name:"config",val:": Llama4TextConfig"}],parametersDescription:[{anchor:"transformers.Llama4TextModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4TextConfig">Llama4TextConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L483"}}),ut=new L({props:{name:"forward",anchor:"transformers.Llama4TextModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.Llama4TextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4TextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4TextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4TextModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4TextModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4TextModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4TextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4TextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4TextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4TextModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L511",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Te=new no({props:{$$slots:{default:[is]},$$scope:{ctx:J}}}),ft=new W({props:{title:"Llama4ForCausalLM",local:"transformers.Llama4ForCausalLM",headingTag:"h2"}}),gt=new L({props:{name:"class transformers.Llama4ForCausalLM",anchor:"transformers.Llama4ForCausalLM",parameters:[{name:"config",val:": Llama4TextConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L635"}}),_t=new L({props:{name:"forward",anchor:"transformers.Llama4ForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llama4.modeling_llama4.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.Llama4ForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.Llama4ForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.Llama4ForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.Llama4ForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.Llama4ForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.Llama4ForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.Llama4ForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.Llama4ForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Llama4ForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Llama4ForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.Llama4ForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L669",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llama4#transformers.Llama4Config"
>Llama4Config</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),be=new no({props:{$$slots:{default:[ds]},$$scope:{ctx:J}}}),Me=new io({props:{anchor:"transformers.Llama4ForCausalLM.forward.example",$$slots:{default:[cs]},$$scope:{ctx:J}}}),Tt=new W({props:{title:"Llama4VisionModel",local:"transformers.Llama4VisionModel",headingTag:"h2"}}),bt=new L({props:{name:"class transformers.Llama4VisionModel",anchor:"transformers.Llama4VisionModel",parameters:[{name:"config",val:": Llama4VisionConfig"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1122"}}),Mt=new L({props:{name:"forward",anchor:"transformers.Llama4VisionModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1158"}}),ve=new io({props:{anchor:"transformers.Llama4VisionModel.forward.example",$$slots:{default:[ms]},$$scope:{ctx:J}}}),wt=new L({props:{name:"get_input_embeddings",anchor:"transformers.Llama4VisionModel.get_input_embeddings",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llama4/modeling_llama4.py#L1152"}}),Jt=new qa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llama4.md"}}),{c(){t=u("meta"),p=i(),o=u("p"),r=i(),g(m.$$.fragment),n=i(),c=u("div"),c.innerHTML=v,$=i(),C=u("p"),C.textContent=U,k=i(),O=u("ul"),O.innerHTML=ao,ke=i(),K=u("p"),K.textContent=so,co=i(),Ce=u("p"),Ce.innerHTML=Dn,mo=i(),g(re.$$.fragment),po=i(),xe=u("p"),xe.innerHTML=On,uo=i(),g(le.$$.fragment),ho=i(),g(je.$$.fragment),fo=i(),g(Le.$$.fragment),go=i(),Ie=u("p"),Ie.innerHTML=Kn,_o=i(),ze=u("p"),ze.innerHTML=ea,yo=i(),g(ie.$$.fragment),To=i(),g(Fe.$$.fragment),bo=i(),Ge=u("p"),Ge.innerHTML=ta,Mo=i(),Ze=u("p"),Ze.textContent=oa,wo=i(),We=u("p"),We.textContent=na,vo=i(),g(de.$$.fragment),Jo=i(),g(Ve.$$.fragment),Uo=i(),Be=u("p"),Be.textContent=aa,$o=i(),Re=u("p"),Re.innerHTML=sa,ko=i(),g(qe.$$.fragment),Co=i(),g(Ee.$$.fragment),xo=i(),F=u("div"),g(Ne.$$.fragment),sn=i(),jt=u("p"),jt.innerHTML=ra,rn=i(),Lt=u("p"),Lt.innerHTML=la,ln=i(),It=u("p"),It.innerHTML=ia,dn=i(),g(ce.$$.fragment),jo=i(),g(Xe.$$.fragment),Lo=i(),G=u("div"),g(Qe.$$.fragment),cn=i(),zt=u("p"),zt.innerHTML=da,mn=i(),Ft=u("p"),Ft.innerHTML=ca,pn=i(),Gt=u("p"),Gt.innerHTML=ma,un=i(),Zt=u("p"),Zt.textContent=pa,Io=i(),g(Ye.$$.fragment),zo=i(),V=u("div"),g(Se.$$.fragment),hn=i(),Wt=u("p"),Wt.innerHTML=ua,fn=i(),Vt=u("p"),Vt.innerHTML=ha,gn=i(),Bt=u("p"),Bt.innerHTML=fa,Fo=i(),g(He.$$.fragment),Go=i(),B=u("div"),g(Pe.$$.fragment),_n=i(),Rt=u("p"),Rt.innerHTML=ga,yn=i(),me=u("div"),g(Ae.$$.fragment),Tn=i(),qt=u("p"),qt.innerHTML=_a,bn=i(),pe=u("div"),g(De.$$.fragment),Mn=i(),Et=u("p"),Et.innerHTML=ya,Zo=i(),g(Oe.$$.fragment),Wo=i(),R=u("div"),g(Ke.$$.fragment),wn=i(),Nt=u("p"),Nt.textContent=Ta,vn=i(),Xt=u("div"),g(et.$$.fragment),Jn=i(),ue=u("div"),g(tt.$$.fragment),Un=i(),Qt=u("p"),Qt.textContent=ba,Vo=i(),g(ot.$$.fragment),Bo=i(),Y=u("div"),g(nt.$$.fragment),$n=i(),N=u("div"),g(at.$$.fragment),kn=i(),Yt=u("p"),Yt.innerHTML=Ma,Cn=i(),g(he.$$.fragment),xn=i(),g(fe.$$.fragment),jn=i(),ge=u("div"),g(st.$$.fragment),Ln=i(),St=u("p"),St.textContent=wa,Ro=i(),rt=u("ul"),rt.innerHTML=va,qo=i(),g(lt.$$.fragment),Eo=i(),ne=u("div"),g(it.$$.fragment),In=i(),X=u("div"),g(dt.$$.fragment),zn=i(),Ht=u("p"),Ht.innerHTML=Ja,Fn=i(),g(_e.$$.fragment),Gn=i(),g(ye.$$.fragment),No=i(),ct=u("ul"),ct.innerHTML=Ua,Xo=i(),g(mt.$$.fragment),Qo=i(),Z=u("div"),g(pt.$$.fragment),Zn=i(),Pt=u("p"),Pt.textContent=$a,Wn=i(),At=u("p"),At.innerHTML=ka,Vn=i(),Dt=u("p"),Dt.innerHTML=Ca,Bn=i(),ee=u("div"),g(ut.$$.fragment),Rn=i(),Ot=u("p"),Ot.innerHTML=xa,qn=i(),g(Te.$$.fragment),Yo=i(),ht=u("ul"),ht.innerHTML=ja,So=i(),g(ft.$$.fragment),Ho=i(),ae=u("div"),g(gt.$$.fragment),En=i(),Q=u("div"),g(_t.$$.fragment),Nn=i(),Kt=u("p"),Kt.innerHTML=La,Xn=i(),g(be.$$.fragment),Qn=i(),g(Me.$$.fragment),Po=i(),yt=u("ul"),yt.innerHTML=Ia,Ao=i(),g(Tt.$$.fragment),Do=i(),S=u("div"),g(bt.$$.fragment),Yn=i(),we=u("div"),g(Mt.$$.fragment),Sn=i(),g(ve.$$.fragment),Hn=i(),Je=u("div"),g(wt.$$.fragment),Pn=i(),eo=u("p"),eo.textContent=za,Oo=i(),vt=u("ul"),vt.innerHTML=Fa,Ko=i(),g(Jt.$$.fragment),en=i(),ro=u("p"),this.h()},l(e){const s=Ba("svelte-u9bgzb",document.head);t=h(s,"META",{name:!0,content:!0}),s.forEach(a),p=d(e),o=h(e,"P",{}),x(o).forEach(a),r=d(e),_(m.$$.fragment,e),n=d(e),c=h(e,"DIV",{style:!0,"data-svelte-h":!0}),w(c)!=="svelte-1wvb92v"&&(c.innerHTML=v),$=d(e),C=h(e,"P",{"data-svelte-h":!0}),w(C)!=="svelte-1owo9yl"&&(C.textContent=U),k=d(e),O=h(e,"UL",{"data-svelte-h":!0}),w(O)!=="svelte-1y7yvda"&&(O.innerHTML=ao),ke=d(e),K=h(e,"P",{"data-svelte-h":!0}),w(K)!=="svelte-omzkf7"&&(K.textContent=so),co=d(e),Ce=h(e,"P",{"data-svelte-h":!0}),w(Ce)!=="svelte-1q2xgmk"&&(Ce.innerHTML=Dn),mo=d(e),_(re.$$.fragment,e),po=d(e),xe=h(e,"P",{"data-svelte-h":!0}),w(xe)!=="svelte-nzpejo"&&(xe.innerHTML=On),uo=d(e),_(le.$$.fragment,e),ho=d(e),_(je.$$.fragment,e),fo=d(e),_(Le.$$.fragment,e),go=d(e),Ie=h(e,"P",{"data-svelte-h":!0}),w(Ie)!=="svelte-x0ymgx"&&(Ie.innerHTML=Kn),_o=d(e),ze=h(e,"P",{"data-svelte-h":!0}),w(ze)!=="svelte-1mlq2xi"&&(ze.innerHTML=ea),yo=d(e),_(ie.$$.fragment,e),To=d(e),_(Fe.$$.fragment,e),bo=d(e),Ge=h(e,"P",{"data-svelte-h":!0}),w(Ge)!=="svelte-3fz0dv"&&(Ge.innerHTML=ta),Mo=d(e),Ze=h(e,"P",{"data-svelte-h":!0}),w(Ze)!=="svelte-ql9del"&&(Ze.textContent=oa),wo=d(e),We=h(e,"P",{"data-svelte-h":!0}),w(We)!=="svelte-1e6p2bq"&&(We.textContent=na),vo=d(e),_(de.$$.fragment,e),Jo=d(e),_(Ve.$$.fragment,e),Uo=d(e),Be=h(e,"P",{"data-svelte-h":!0}),w(Be)!=="svelte-1ey514g"&&(Be.textContent=aa),$o=d(e),Re=h(e,"P",{"data-svelte-h":!0}),w(Re)!=="svelte-1ezy410"&&(Re.innerHTML=sa),ko=d(e),_(qe.$$.fragment,e),Co=d(e),_(Ee.$$.fragment,e),xo=d(e),F=h(e,"DIV",{class:!0});var q=x(F);_(Ne.$$.fragment,q),sn=d(q),jt=h(q,"P",{"data-svelte-h":!0}),w(jt)!=="svelte-efaf7b"&&(jt.innerHTML=ra),rn=d(q),Lt=h(q,"P",{"data-svelte-h":!0}),w(Lt)!=="svelte-sh2hyl"&&(Lt.innerHTML=la),ln=d(q),It=h(q,"P",{"data-svelte-h":!0}),w(It)!=="svelte-o55m63"&&(It.innerHTML=ia),dn=d(q),_(ce.$$.fragment,q),q.forEach(a),jo=d(e),_(Xe.$$.fragment,e),Lo=d(e),G=h(e,"DIV",{class:!0});var E=x(G);_(Qe.$$.fragment,E),cn=d(E),zt=h(E,"P",{"data-svelte-h":!0}),w(zt)!=="svelte-zeurjx"&&(zt.innerHTML=da),mn=d(E),Ft=h(E,"P",{"data-svelte-h":!0}),w(Ft)!=="svelte-sh2hyl"&&(Ft.innerHTML=ca),pn=d(E),Gt=h(E,"P",{"data-svelte-h":!0}),w(Gt)!=="svelte-o55m63"&&(Gt.innerHTML=ma),un=d(E),Zt=h(E,"P",{"data-svelte-h":!0}),w(Zt)!=="svelte-11lpom8"&&(Zt.textContent=pa),E.forEach(a),Io=d(e),_(Ye.$$.fragment,e),zo=d(e),V=h(e,"DIV",{class:!0});var H=x(V);_(Se.$$.fragment,H),hn=d(H),Wt=h(H,"P",{"data-svelte-h":!0}),w(Wt)!=="svelte-115ln58"&&(Wt.innerHTML=ua),fn=d(H),Vt=h(H,"P",{"data-svelte-h":!0}),w(Vt)!=="svelte-sh2hyl"&&(Vt.innerHTML=ha),gn=d(H),Bt=h(H,"P",{"data-svelte-h":!0}),w(Bt)!=="svelte-o55m63"&&(Bt.innerHTML=fa),H.forEach(a),Fo=d(e),_(He.$$.fragment,e),Go=d(e),B=h(e,"DIV",{class:!0});var P=x(B);_(Pe.$$.fragment,P),_n=d(P),Rt=h(P,"P",{"data-svelte-h":!0}),w(Rt)!=="svelte-py0zio"&&(Rt.innerHTML=ga),yn=d(P),me=h(P,"DIV",{class:!0});var Ut=x(me);_(Ae.$$.fragment,Ut),Tn=d(Ut),qt=h(Ut,"P",{"data-svelte-h":!0}),w(qt)!=="svelte-1yrf9bj"&&(qt.innerHTML=_a),Ut.forEach(a),bn=d(P),pe=h(P,"DIV",{class:!0});var $t=x(pe);_(De.$$.fragment,$t),Mn=d($t),Et=h($t,"P",{"data-svelte-h":!0}),w(Et)!=="svelte-1jl7gd5"&&(Et.innerHTML=ya),$t.forEach(a),P.forEach(a),Zo=d(e),_(Oe.$$.fragment,e),Wo=d(e),R=h(e,"DIV",{class:!0});var A=x(R);_(Ke.$$.fragment,A),wn=d(A),Nt=h(A,"P",{"data-svelte-h":!0}),w(Nt)!=="svelte-1wru4bd"&&(Nt.textContent=Ta),vn=d(A),Xt=h(A,"DIV",{class:!0});var lo=x(Xt);_(et.$$.fragment,lo),lo.forEach(a),Jn=d(A),ue=h(A,"DIV",{class:!0});var kt=x(ue);_(tt.$$.fragment,kt),Un=d(kt),Qt=h(kt,"P",{"data-svelte-h":!0}),w(Qt)!=="svelte-15zn3yd"&&(Qt.textContent=ba),kt.forEach(a),A.forEach(a),Vo=d(e),_(ot.$$.fragment,e),Bo=d(e),Y=h(e,"DIV",{class:!0});var se=x(Y);_(nt.$$.fragment,se),$n=d(se),N=h(se,"DIV",{class:!0});var D=x(N);_(at.$$.fragment,D),kn=d(D),Yt=h(D,"P",{"data-svelte-h":!0}),w(Yt)!=="svelte-adacta"&&(Yt.innerHTML=Ma),Cn=d(D),_(he.$$.fragment,D),xn=d(D),_(fe.$$.fragment,D),D.forEach(a),jn=d(se),ge=h(se,"DIV",{class:!0});var Ct=x(ge);_(st.$$.fragment,Ct),Ln=d(Ct),St=h(Ct,"P",{"data-svelte-h":!0}),w(St)!=="svelte-s9i4hu"&&(St.textContent=wa),Ct.forEach(a),se.forEach(a),Ro=d(e),rt=h(e,"UL",{"data-svelte-h":!0}),w(rt)!=="svelte-n3ow4o"&&(rt.innerHTML=va),qo=d(e),_(lt.$$.fragment,e),Eo=d(e),ne=h(e,"DIV",{class:!0});var xt=x(ne);_(it.$$.fragment,xt),In=d(xt),X=h(xt,"DIV",{class:!0});var Ue=x(X);_(dt.$$.fragment,Ue),zn=d(Ue),Ht=h(Ue,"P",{"data-svelte-h":!0}),w(Ht)!=="svelte-xnjod6"&&(Ht.innerHTML=Ja),Fn=d(Ue),_(_e.$$.fragment,Ue),Gn=d(Ue),_(ye.$$.fragment,Ue),Ue.forEach(a),xt.forEach(a),No=d(e),ct=h(e,"UL",{"data-svelte-h":!0}),w(ct)!=="svelte-n3ow4o"&&(ct.innerHTML=Ua),Xo=d(e),_(mt.$$.fragment,e),Qo=d(e),Z=h(e,"DIV",{class:!0});var te=x(Z);_(pt.$$.fragment,te),Zn=d(te),Pt=h(te,"P",{"data-svelte-h":!0}),w(Pt)!=="svelte-h0upho"&&(Pt.textContent=$a),Wn=d(te),At=h(te,"P",{"data-svelte-h":!0}),w(At)!=="svelte-6pahdo"&&(At.innerHTML=ka),Vn=d(te),Dt=h(te,"P",{"data-svelte-h":!0}),w(Dt)!=="svelte-hswkmf"&&(Dt.innerHTML=Ca),Bn=d(te),ee=h(te,"DIV",{class:!0});var to=x(ee);_(ut.$$.fragment,to),Rn=d(to),Ot=h(to,"P",{"data-svelte-h":!0}),w(Ot)!=="svelte-1mo4gpu"&&(Ot.innerHTML=xa),qn=d(to),_(Te.$$.fragment,to),to.forEach(a),te.forEach(a),Yo=d(e),ht=h(e,"UL",{"data-svelte-h":!0}),w(ht)!=="svelte-n3ow4o"&&(ht.innerHTML=ja),So=d(e),_(ft.$$.fragment,e),Ho=d(e),ae=h(e,"DIV",{class:!0});var on=x(ae);_(gt.$$.fragment,on),En=d(on),Q=h(on,"DIV",{class:!0});var $e=x(Q);_(_t.$$.fragment,$e),Nn=d($e),Kt=h($e,"P",{"data-svelte-h":!0}),w(Kt)!=="svelte-xnjod6"&&(Kt.innerHTML=La),Xn=d($e),_(be.$$.fragment,$e),Qn=d($e),_(Me.$$.fragment,$e),$e.forEach(a),on.forEach(a),Po=d(e),yt=h(e,"UL",{"data-svelte-h":!0}),w(yt)!=="svelte-n3ow4o"&&(yt.innerHTML=Ia),Ao=d(e),_(Tt.$$.fragment,e),Do=d(e),S=h(e,"DIV",{class:!0});var oo=x(S);_(bt.$$.fragment,oo),Yn=d(oo),we=h(oo,"DIV",{class:!0});var nn=x(we);_(Mt.$$.fragment,nn),Sn=d(nn),_(ve.$$.fragment,nn),nn.forEach(a),Hn=d(oo),Je=h(oo,"DIV",{class:!0});var an=x(Je);_(wt.$$.fragment,an),Pn=d(an),eo=h(an,"P",{"data-svelte-h":!0}),w(eo)!=="svelte-1dcynhg"&&(eo.textContent=za),an.forEach(a),oo.forEach(a),Oo=d(e),vt=h(e,"UL",{"data-svelte-h":!0}),w(vt)!=="svelte-n3ow4o"&&(vt.innerHTML=Fa),Ko=d(e),_(Jt.$$.fragment,e),en=d(e),ro=h(e,"P",{}),x(ro).forEach(a),this.h()},h(){j(t,"name","hf:doc:metadata"),j(t,"content",us),Ra(c,"float","right"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){f(document.head,t),l(e,p,s),l(e,o,s),l(e,r,s),y(m,e,s),l(e,n,s),l(e,c,s),l(e,$,s),l(e,C,s),l(e,k,s),l(e,O,s),l(e,ke,s),l(e,K,s),l(e,co,s),l(e,Ce,s),l(e,mo,s),y(re,e,s),l(e,po,s),l(e,xe,s),l(e,uo,s),y(le,e,s),l(e,ho,s),y(je,e,s),l(e,fo,s),y(Le,e,s),l(e,go,s),l(e,Ie,s),l(e,_o,s),l(e,ze,s),l(e,yo,s),y(ie,e,s),l(e,To,s),y(Fe,e,s),l(e,bo,s),l(e,Ge,s),l(e,Mo,s),l(e,Ze,s),l(e,wo,s),l(e,We,s),l(e,vo,s),y(de,e,s),l(e,Jo,s),y(Ve,e,s),l(e,Uo,s),l(e,Be,s),l(e,$o,s),l(e,Re,s),l(e,ko,s),y(qe,e,s),l(e,Co,s),y(Ee,e,s),l(e,xo,s),l(e,F,s),y(Ne,F,null),f(F,sn),f(F,jt),f(F,rn),f(F,Lt),f(F,ln),f(F,It),f(F,dn),y(ce,F,null),l(e,jo,s),y(Xe,e,s),l(e,Lo,s),l(e,G,s),y(Qe,G,null),f(G,cn),f(G,zt),f(G,mn),f(G,Ft),f(G,pn),f(G,Gt),f(G,un),f(G,Zt),l(e,Io,s),y(Ye,e,s),l(e,zo,s),l(e,V,s),y(Se,V,null),f(V,hn),f(V,Wt),f(V,fn),f(V,Vt),f(V,gn),f(V,Bt),l(e,Fo,s),y(He,e,s),l(e,Go,s),l(e,B,s),y(Pe,B,null),f(B,_n),f(B,Rt),f(B,yn),f(B,me),y(Ae,me,null),f(me,Tn),f(me,qt),f(B,bn),f(B,pe),y(De,pe,null),f(pe,Mn),f(pe,Et),l(e,Zo,s),y(Oe,e,s),l(e,Wo,s),l(e,R,s),y(Ke,R,null),f(R,wn),f(R,Nt),f(R,vn),f(R,Xt),y(et,Xt,null),f(R,Jn),f(R,ue),y(tt,ue,null),f(ue,Un),f(ue,Qt),l(e,Vo,s),y(ot,e,s),l(e,Bo,s),l(e,Y,s),y(nt,Y,null),f(Y,$n),f(Y,N),y(at,N,null),f(N,kn),f(N,Yt),f(N,Cn),y(he,N,null),f(N,xn),y(fe,N,null),f(Y,jn),f(Y,ge),y(st,ge,null),f(ge,Ln),f(ge,St),l(e,Ro,s),l(e,rt,s),l(e,qo,s),y(lt,e,s),l(e,Eo,s),l(e,ne,s),y(it,ne,null),f(ne,In),f(ne,X),y(dt,X,null),f(X,zn),f(X,Ht),f(X,Fn),y(_e,X,null),f(X,Gn),y(ye,X,null),l(e,No,s),l(e,ct,s),l(e,Xo,s),y(mt,e,s),l(e,Qo,s),l(e,Z,s),y(pt,Z,null),f(Z,Zn),f(Z,Pt),f(Z,Wn),f(Z,At),f(Z,Vn),f(Z,Dt),f(Z,Bn),f(Z,ee),y(ut,ee,null),f(ee,Rn),f(ee,Ot),f(ee,qn),y(Te,ee,null),l(e,Yo,s),l(e,ht,s),l(e,So,s),y(ft,e,s),l(e,Ho,s),l(e,ae,s),y(gt,ae,null),f(ae,En),f(ae,Q),y(_t,Q,null),f(Q,Nn),f(Q,Kt),f(Q,Xn),y(be,Q,null),f(Q,Qn),y(Me,Q,null),l(e,Po,s),l(e,yt,s),l(e,Ao,s),y(Tt,e,s),l(e,Do,s),l(e,S,s),y(bt,S,null),f(S,Yn),f(S,we),y(Mt,we,null),f(we,Sn),y(ve,we,null),f(S,Hn),f(S,Je),y(wt,Je,null),f(Je,Pn),f(Je,eo),l(e,Oo,s),l(e,vt,s),l(e,Ko,s),y(Jt,e,s),l(e,en,s),l(e,ro,s),tn=!0},p(e,[s]){const q={};s&2&&(q.$$scope={dirty:s,ctx:e}),re.$set(q);const E={};s&2&&(E.$$scope={dirty:s,ctx:e}),le.$set(E);const H={};s&2&&(H.$$scope={dirty:s,ctx:e}),ie.$set(H);const P={};s&2&&(P.$$scope={dirty:s,ctx:e}),de.$set(P);const Ut={};s&2&&(Ut.$$scope={dirty:s,ctx:e}),ce.$set(Ut);const $t={};s&2&&($t.$$scope={dirty:s,ctx:e}),he.$set($t);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),fe.$set(A);const lo={};s&2&&(lo.$$scope={dirty:s,ctx:e}),_e.$set(lo);const kt={};s&2&&(kt.$$scope={dirty:s,ctx:e}),ye.$set(kt);const se={};s&2&&(se.$$scope={dirty:s,ctx:e}),Te.$set(se);const D={};s&2&&(D.$$scope={dirty:s,ctx:e}),be.$set(D);const Ct={};s&2&&(Ct.$$scope={dirty:s,ctx:e}),Me.$set(Ct);const xt={};s&2&&(xt.$$scope={dirty:s,ctx:e}),ve.$set(xt)},i(e){tn||(T(m.$$.fragment,e),T(re.$$.fragment,e),T(le.$$.fragment,e),T(je.$$.fragment,e),T(Le.$$.fragment,e),T(ie.$$.fragment,e),T(Fe.$$.fragment,e),T(de.$$.fragment,e),T(Ve.$$.fragment,e),T(qe.$$.fragment,e),T(Ee.$$.fragment,e),T(Ne.$$.fragment,e),T(ce.$$.fragment,e),T(Xe.$$.fragment,e),T(Qe.$$.fragment,e),T(Ye.$$.fragment,e),T(Se.$$.fragment,e),T(He.$$.fragment,e),T(Pe.$$.fragment,e),T(Ae.$$.fragment,e),T(De.$$.fragment,e),T(Oe.$$.fragment,e),T(Ke.$$.fragment,e),T(et.$$.fragment,e),T(tt.$$.fragment,e),T(ot.$$.fragment,e),T(nt.$$.fragment,e),T(at.$$.fragment,e),T(he.$$.fragment,e),T(fe.$$.fragment,e),T(st.$$.fragment,e),T(lt.$$.fragment,e),T(it.$$.fragment,e),T(dt.$$.fragment,e),T(_e.$$.fragment,e),T(ye.$$.fragment,e),T(mt.$$.fragment,e),T(pt.$$.fragment,e),T(ut.$$.fragment,e),T(Te.$$.fragment,e),T(ft.$$.fragment,e),T(gt.$$.fragment,e),T(_t.$$.fragment,e),T(be.$$.fragment,e),T(Me.$$.fragment,e),T(Tt.$$.fragment,e),T(bt.$$.fragment,e),T(Mt.$$.fragment,e),T(ve.$$.fragment,e),T(wt.$$.fragment,e),T(Jt.$$.fragment,e),tn=!0)},o(e){b(m.$$.fragment,e),b(re.$$.fragment,e),b(le.$$.fragment,e),b(je.$$.fragment,e),b(Le.$$.fragment,e),b(ie.$$.fragment,e),b(Fe.$$.fragment,e),b(de.$$.fragment,e),b(Ve.$$.fragment,e),b(qe.$$.fragment,e),b(Ee.$$.fragment,e),b(Ne.$$.fragment,e),b(ce.$$.fragment,e),b(Xe.$$.fragment,e),b(Qe.$$.fragment,e),b(Ye.$$.fragment,e),b(Se.$$.fragment,e),b(He.$$.fragment,e),b(Pe.$$.fragment,e),b(Ae.$$.fragment,e),b(De.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(ot.$$.fragment,e),b(nt.$$.fragment,e),b(at.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(st.$$.fragment,e),b(lt.$$.fragment,e),b(it.$$.fragment,e),b(dt.$$.fragment,e),b(_e.$$.fragment,e),b(ye.$$.fragment,e),b(mt.$$.fragment,e),b(pt.$$.fragment,e),b(ut.$$.fragment,e),b(Te.$$.fragment,e),b(ft.$$.fragment,e),b(gt.$$.fragment,e),b(_t.$$.fragment,e),b(be.$$.fragment,e),b(Me.$$.fragment,e),b(Tt.$$.fragment,e),b(bt.$$.fragment,e),b(Mt.$$.fragment,e),b(ve.$$.fragment,e),b(wt.$$.fragment,e),b(Jt.$$.fragment,e),tn=!1},d(e){e&&(a(p),a(o),a(r),a(n),a(c),a($),a(C),a(k),a(O),a(ke),a(K),a(co),a(Ce),a(mo),a(po),a(xe),a(uo),a(ho),a(fo),a(go),a(Ie),a(_o),a(ze),a(yo),a(To),a(bo),a(Ge),a(Mo),a(Ze),a(wo),a(We),a(vo),a(Jo),a(Uo),a(Be),a($o),a(Re),a(ko),a(Co),a(xo),a(F),a(jo),a(Lo),a(G),a(Io),a(zo),a(V),a(Fo),a(Go),a(B),a(Zo),a(Wo),a(R),a(Vo),a(Bo),a(Y),a(Ro),a(rt),a(qo),a(Eo),a(ne),a(No),a(ct),a(Xo),a(Qo),a(Z),a(Yo),a(ht),a(So),a(Ho),a(ae),a(Po),a(yt),a(Ao),a(Do),a(S),a(Oo),a(vt),a(Ko),a(en),a(ro)),a(t),M(m,e),M(re,e),M(le,e),M(je,e),M(Le,e),M(ie,e),M(Fe,e),M(de,e),M(Ve,e),M(qe,e),M(Ee,e),M(Ne),M(ce),M(Xe,e),M(Qe),M(Ye,e),M(Se),M(He,e),M(Pe),M(Ae),M(De),M(Oe,e),M(Ke),M(et),M(tt),M(ot,e),M(nt),M(at),M(he),M(fe),M(st),M(lt,e),M(it),M(dt),M(_e),M(ye),M(mt,e),M(pt),M(ut),M(Te),M(ft,e),M(gt),M(_t),M(be),M(Me),M(Tt,e),M(bt),M(Mt),M(ve),M(wt),M(Jt,e)}}}const us='{"title":"Llama4","local":"llama4","sections":[{"title":"Efficiency; how to get the best out of llama 4","local":"efficiency-how-to-get-the-best-out-of-llama-4","sections":[{"title":"The Attention methods","local":"the-attention-methods","sections":[],"depth":3},{"title":"Quantization","local":"quantization","sections":[],"depth":3},{"title":"Offloading","local":"offloading","sections":[],"depth":3}],"depth":2},{"title":"Llama4Config","local":"transformers.Llama4Config","sections":[],"depth":2},{"title":"Llama4TextConfig","local":"transformers.Llama4TextConfig","sections":[],"depth":2},{"title":"Llama4VisionConfig","local":"transformers.Llama4VisionConfig","sections":[],"depth":2},{"title":"Llama4Processor","local":"transformers.Llama4Processor","sections":[],"depth":2},{"title":"Llama4ImageProcessorFast","local":"transformers.Llama4ImageProcessorFast","sections":[],"depth":2},{"title":"Llama4ForConditionalGeneration","local":"transformers.Llama4ForConditionalGeneration","sections":[],"depth":2},{"title":"Llama4ForCausalLM","local":"transformers.Llama4ForCausalLM","sections":[],"depth":2},{"title":"Llama4TextModel","local":"transformers.Llama4TextModel","sections":[],"depth":2},{"title":"Llama4ForCausalLM","local":"transformers.Llama4ForCausalLM","sections":[],"depth":2},{"title":"Llama4VisionModel","local":"transformers.Llama4VisionModel","sections":[],"depth":2}],"depth":1}';function hs(J){return Za(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Js extends Wa{constructor(t){super(),Va(this,t,hs,ps,Ga,{})}}export{Js as component};
