import{s as Ua,o as ja,n as G}from"../chunks/scheduler.18a86fab.js";import{S as Fa,i as Wa,g as d,s as n,r as h,A as La,h as c,f as i,c as a,j as $,u,x as T,k,y as o,a as p,v as g,d as f,t as _,w as M}from"../chunks/index.98837b22.js";import{T as bt}from"../chunks/Tip.77304350.js";import{D as C}from"../chunks/Docstring.6758ea23.js";import{C as ae}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as yt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as N}from"../chunks/Heading.7e7e0c5b.js";import{E as Va}from"../chunks/index.92f616ba.js";function Za(v){let t,b="Mllama has an extra token used as a placeholder for image positions in the text. It means that input ids and an input embedding layer will have an extra token. But since the weights for input and output embeddings are not tied, the <code>lm_head</code> layer has one less token and will fail if you want to calculate loss on image tokens or apply some logit processors. In case you are training, make sure to mask out special <code>&quot;&lt;|image|&gt;&quot;</code> tokens in the <code>labels</code> as the model should not be trained on predicting them.",l,m,y="Otherwise if you see CUDA-side index erros when generating, use the below code to expand the <code>lm_head</code> by one more token.",r,w,Ie;return w=new ae({props:{code:"b2xkX2VtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbC5nZXRfb3V0cHV0X2VtYmVkZGluZ3MoKSUwQSUwQW51bV90b2tlbnMlMjAlM0QlMjBtb2RlbC52b2NhYl9zaXplJTIwJTJCJTIwMSUwQXJlc2l6ZWRfZW1iZWRkaW5ncyUyMCUzRCUyMG1vZGVsLl9nZXRfcmVzaXplZF9sbV9oZWFkKG9sZF9lbWJlZGRpbmdzJTJDJTIwbmV3X251bV90b2tlbnMlM0RudW1fdG9rZW5zJTJDJTIwbWVhbl9yZXNpemluZyUzRFRydWUpJTBBcmVzaXplZF9lbWJlZGRpbmdzLnJlcXVpcmVzX2dyYWRfKG9sZF9lbWJlZGRpbmdzLndlaWdodC5yZXF1aXJlc19ncmFkKSUwQW1vZGVsLnNldF9vdXRwdXRfZW1iZWRkaW5ncyhyZXNpemVkX2VtYmVkZGluZ3Mp",highlighted:`old_embeddings = model.get_output_embeddings()

num_tokens = model.vocab_size + <span class="hljs-number">1</span>
resized_embeddings = model._get_resized_lm_head(old_embeddings, new_num_tokens=num_tokens, mean_resizing=<span class="hljs-literal">True</span>)
resized_embeddings.requires_grad_(old_embeddings.weight.requires_grad)
model.set_output_embeddings(resized_embeddings)`,wrap:!1}}),{c(){t=d("p"),t.innerHTML=b,l=n(),m=d("p"),m.innerHTML=y,r=n(),h(w.$$.fragment)},l(x){t=c(x,"P",{"data-svelte-h":!0}),T(t)!=="svelte-k28zha"&&(t.innerHTML=b),l=a(x),m=c(x,"P",{"data-svelte-h":!0}),T(m)!=="svelte-fofx85"&&(m.innerHTML=y),r=a(x),u(w.$$.fragment,x)},m(x,B){p(x,t,B),p(x,l,B),p(x,m,B),p(x,r,B),g(w,x,B),Ie=!0},p:G,i(x){Ie||(f(w.$$.fragment,x),Ie=!0)},o(x){_(w.$$.fragment,x),Ie=!1},d(x){x&&(i(t),i(l),i(m),i(r)),M(w,x)}}}function Na(v){let t,b="Example:",l,m,y;return m=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1sbGFtYUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME1sbGFtYUNvbmZpZyUyQyUyME1sbGFtYVZpc2lvbkNvbmZpZyUyQyUyME1sbGFtYVRleHRDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUC12aXNpb24lMjBjb25maWclMEF2aXNpb25fY29uZmlnJTIwJTNEJTIwTWxsYW1hVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhbWElMjBjb25maWclMEF0ZXh0X2NvbmZpZyUyMCUzRCUyME1sbGFtYVRleHRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtbGxhbWEtMTFiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME1sbGFtYUNvbmZpZyh2aXNpb25fY29uZmlnJTJDJTIwdGV4dF9jb25maWcpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMG1sbGFtYS0xMWIlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyME1sbGFtYUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MllamaForConditionalGeneration, MllamaConfig, MllamaVisionConfig, MllamaTextConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = MllamaVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = MllamaTextConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a mllama-11b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MllamaConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the mllama-11b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=d("p"),t.textContent=b,l=n(),h(m.$$.fragment)},l(r){t=c(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=b),l=a(r),u(m.$$.fragment,r)},m(r,w){p(r,t,w),p(r,l,w),g(m,r,w),y=!0},p:G,i(r){y||(f(m.$$.fragment,r),y=!0)},o(r){_(m.$$.fragment,r),y=!1},d(r){r&&(i(t),i(l)),M(m,r)}}}function Ga(v){let t,b;return t=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1sbGFtYVByb2Nlc3NvciUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyME1sbGFtYVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0xMUItVmlzaW9uJTIyKSUwQSUwQXByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBpbWFnZXMlM0R5b3VyX3BpbF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMHRleHQlM0QlNUIlMjIlM0MlN0NpbWFnZSU3QyUzRUlmJTIwSSUyMGhhZCUyMHRvJTIwd3JpdGUlMjBhJTIwaGFpa3UlMjBmb3IlMjB0aGlzJTIwb25lJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2VzX2t3YXJncyUyMCUzRCUyMCU3QiUyMnNpemUlMjIlM0ElMjAlN0IlMjJoZWlnaHQlMjIlM0ElMjA0NDglMkMlMjAlMjJ3aWR0aCUyMiUzQSUyMDQ0OCU3RCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRleHRfa3dhcmdzJTIwJTNEJTIwJTdCJTIycGFkZGluZyUyMiUzQSUyMCUyMnJpZ2h0JTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwY29tbW9uX2t3YXJncyUyMCUzRCUyMCU3QiUyMnJldHVybl90ZW5zb3JzJTIyJTNBJTIwJTIycHQlMjIlN0QlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MllamaProcessor
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

processor = MllamaProcessor.from_pretrained(<span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision&quot;</span>)

processor(
    images=your_pil_image,
    text=[<span class="hljs-string">&quot;&lt;|image|&gt;If I had to write a haiku for this one&quot;</span>],
    images_kwargs = {<span class="hljs-string">&quot;size&quot;</span>: {<span class="hljs-string">&quot;height&quot;</span>: <span class="hljs-number">448</span>, <span class="hljs-string">&quot;width&quot;</span>: <span class="hljs-number">448</span>}},
    text_kwargs = {<span class="hljs-string">&quot;padding&quot;</span>: <span class="hljs-string">&quot;right&quot;</span>},
    common_kwargs = {<span class="hljs-string">&quot;return_tensors&quot;</span>: <span class="hljs-string">&quot;pt&quot;</span>},
)`,wrap:!1}}),{c(){h(t.$$.fragment)},l(l){u(t.$$.fragment,l)},m(l,m){g(t,l,m),b=!0},p:G,i(l){b||(f(t.$$.fragment,l),b=!0)},o(l){_(t.$$.fragment,l),b=!1},d(l){M(t,l)}}}function Ba(v){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(l){t=c(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(l,m){p(l,t,m)},p:G,d(l){l&&i(t)}}}function Pa(v){let t,b="Example:",l,m,y;return m=new ae({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1sbGFtYUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTExQi1WaXNpb24lMjIlMEFtb2RlbCUyMCUzRCUyME1sbGFtYUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUzQyU3Q2ltYWdlJTdDJTNFSWYlMjBJJTIwaGFkJTIwdG8lMjB3cml0ZSUyMGElMjBoYWlrdSUyMGZvciUyMHRoaXMlMjBvbmUlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHByb21wdCUyQyUyMGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxNSklMEElMEFwcm9tcHRfbGVuJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1Qi0xJTVEJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG91dHB1dCU1QiUzQSUyQyUyMHByb21wdF9sZW4lM0ElNUQlMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MllamaForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaForConditionalGeneration.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&lt;|image|&gt;If I had to write a haiku for this one&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">15</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_len = inputs.input_ids.shape[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = output[:, prompt_len:]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
[<span class="hljs-string">&#x27;, it would be:.\\\\nA stop sign in Chinatown.\\\\n&#x27;</span>]`,wrap:!1}}),{c(){t=d("p"),t.textContent=b,l=n(),h(m.$$.fragment)},l(r){t=c(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=b),l=a(r),u(m.$$.fragment,r)},m(r,w){p(r,t,w),p(r,l,w),g(m,r,w),y=!0},p:G,i(r){y||(f(m.$$.fragment,r),y=!0)},o(r){_(m.$$.fragment,r),y=!1},d(r){r&&(i(t),i(l)),M(m,r)}}}function qa(v){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(l){t=c(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(l,m){p(l,t,m)},p:G,d(l){l&&i(t)}}}function Ra(v){let t,b="Example:",l,m,y;return m=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNbGxhbWFGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwTWxsYW1hRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMkxsYW1hLTMuMi0xMUItVmlzaW9uJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkxsYW1hLTMuMi0xMUItVmlzaW9uJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMklmJTIwSSUyMGhhZCUyMHRvJTIwd3JpdGUlMjBhJTIwaGFpa3UlMkMlMjBpdCUyMHdvdWxkJTIwYmUlM0ElMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNENDAlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjYpJTBBcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVEJTBBcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MllamaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;Llama-3.2-11B-Vision&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Llama-3.2-11B-Vision&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;If I had to write a haiku, it would be:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">40</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)
If I had to write a haiku, it would be: <span class="hljs-string">&quot;Snowflakes gently fall&quot;</span> - simple, yet peaceful.
I love the idea of snowflakes gently falling, each one`,wrap:!1}}),{c(){t=d("p"),t.textContent=b,l=n(),h(m.$$.fragment)},l(r){t=c(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=b),l=a(r),u(m.$$.fragment,r)},m(r,w){p(r,t,w),p(r,l,w),g(m,r,w),y=!0},p:G,i(r){y||(f(m.$$.fragment,r),y=!0)},o(r){_(m.$$.fragment,r),y=!1},d(r){r&&(i(t),i(l)),M(m,r)}}}function Xa(v){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(l){t=c(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(l,m){p(l,t,m)},p:G,d(l){l&&i(t)}}}function Ea(v){let t,b="Example:",l,m,y;return m=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNbGxhbWFUZXh0TW9kZWwlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0xMUItVmlzaW9uJTIyJTBBbW9kZWwlMjAlM0QlMjBNbGxhbWFUZXh0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEF0ZXh0JTIwJTNEJTIwJTIyJTNDJTdDaW1hZ2UlN0MlM0VJZiUyMEklMjBoYWQlMjB0byUyMHdyaXRlJTIwYSUyMGhhaWt1JTIwZm9yJTIwdGhpcyUyMG9uZSUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvcih0ZXh0JTNEdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBcHJpbnQob3V0cHV0Lmxhc3RfaGlkZGVuX3N0YXRlLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MllamaTextModel

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaTextModel.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;&lt;|image|&gt;If I had to write a haiku for this one&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output.last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">4096</span>])`,wrap:!1}}),{c(){t=d("p"),t.textContent=b,l=n(),h(m.$$.fragment)},l(r){t=c(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=b),l=a(r),u(m.$$.fragment,r)},m(r,w){p(r,t,w),p(r,l,w),g(m,r,w),y=!0},p:G,i(r){y||(f(m.$$.fragment,r),y=!0)},o(r){_(m.$$.fragment,r),y=!1},d(r){r&&(i(t),i(l)),M(m,r)}}}function Ha(v){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(l){t=c(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(l,m){p(l,t,m)},p:G,d(l){l&&i(t)}}}function Qa(v){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(l){t=c(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(l,m){p(l,t,m)},p:G,d(l){l&&i(t)}}}function Sa(v){let t,b="Example:",l,m,y;return m=new ae({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBNbGxhbWFGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwTWxsYW1hRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMkxsYW1hLTMuMi0xMUItVmlzaW9uJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkxsYW1hLTMuMi0xMUItVmlzaW9uJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMklmJTIwSSUyMGhhZCUyMHRvJTIwd3JpdGUlMjBhJTIwaGFpa3UlMkMlMjBpdCUyMHdvdWxkJTIwYmUlM0ElMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cy5pbnB1dF9pZHMlMkMlMjBtYXhfbGVuZ3RoJTNENDAlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjYpJTBBcmVzdWx0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVEJTBBcHJpbnQocmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, MllamaForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaForCausalLM.from_pretrained(<span class="hljs-string">&quot;Llama-3.2-11B-Vision&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;Llama-3.2-11B-Vision&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;If I had to write a haiku, it would be:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">40</span>, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(result)
If I had to write a haiku, it would be: <span class="hljs-string">&quot;Snowflakes gently fall&quot;</span> - simple, yet peaceful.
I love the idea of snowflakes gently falling, each one`,wrap:!1}}),{c(){t=d("p"),t.textContent=b,l=n(),h(m.$$.fragment)},l(r){t=c(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=b),l=a(r),u(m.$$.fragment,r)},m(r,w){p(r,t,w),p(r,l,w),g(m,r,w),y=!0},p:G,i(r){y||(f(m.$$.fragment,r),y=!0)},o(r){_(m.$$.fragment,r),y=!1},d(r){r&&(i(t),i(l)),M(m,r)}}}function Ya(v){let t,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=d("p"),t.innerHTML=b},l(l){t=c(l,"P",{"data-svelte-h":!0}),T(t)!=="svelte-fincs2"&&(t.innerHTML=b)},m(l,m){p(l,t,m)},p:G,d(l){l&&i(t)}}}function Oa(v){let t,b="Example:",l,m,y;return m=new ae({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyME1sbGFtYVZpc2lvbk1vZGVsJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjItMTFCLVZpc2lvbiUyMiUwQW1vZGVsJTIwJTNEJTIwTWxsYW1hVmlzaW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQXByaW50KG91dHB1dC5sYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MllamaVisionModel

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MllamaVisionModel.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(checkpoint)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(output.last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1025</span>, <span class="hljs-number">7680</span>])`,wrap:!1}}),{c(){t=d("p"),t.textContent=b,l=n(),h(m.$$.fragment)},l(r){t=c(r,"P",{"data-svelte-h":!0}),T(t)!=="svelte-11lpom8"&&(t.textContent=b),l=a(r),u(m.$$.fragment,r)},m(r,w){p(r,t,w),p(r,l,w),g(m,r,w),y=!0},p:G,i(r){y||(f(m.$$.fragment,r),y=!0)},o(r){_(m.$$.fragment,r),y=!1},d(r){r&&(i(t),i(l)),M(m,r)}}}function Da(v){let t,b,l,m,y,r,w,Ie='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',x,B,ro,Je,Hn="The Llama 3.2-Vision collection of multimodal large language models (LLMs) is a collection of pretrained and instruction-tuned image reasoning generative models in 11B and 90B sizes (text + images in / text out). The Llama 3.2-Vision instruction-tuned models are optimized for visual recognition, image reasoning, captioning, and answering general questions about an image.",io,ze,Qn="<strong>Model Architecture:</strong> Llama 3.2-Vision is built on top of Llama 3.1 text-only model, which is an auto-regressive language model that uses an optimized transformer architecture. The tuned versions use supervised fine-tuning (SFT) and reinforcement learning with human feedback (RLHF) to align with human preferences for helpfulness and safety. To support image recognition tasks, the Llama 3.2-Vision model uses a separately trained vision adapter that integrates with the pre-trained Llama 3.1 language model. The adapter consists of a series of cross-attention layers that feed image encoder representations into the core LLM.",lo,Ue,co,je,Sn="<li>For image+text and text inputs use <code>MllamaForConditionalGeneration</code>.</li> <li>For text-only inputs use <code>MllamaForCausalLM</code> for generation to avoid loading vision tower.</li> <li>Each sample can contain multiple images, and the number of images can vary between samples. The processor will pad the inputs to the maximum number of images across samples and to a maximum number of tiles within each image.</li> <li>The text passed to the processor should have the <code>&quot;&lt;|image|&gt;&quot;</code> tokens where the images should be inserted.</li> <li>The processor has its own <code>apply_chat_template</code> method to convert chat messages to text that can then be passed as text to the processor. If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.</li>",mo,re,po,Fe,ho,We,uo,Le,go,Ve,fo,Ze,_o,Ne,Mo,J,Ge,No,wt,Yn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaForConditionalGeneration">MllamaForConditionalGeneration</a>. It is used to instantiate an
Mllama model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Mllama-9B.`,Go,vt,On='e.g. <a href="https://huggingface.co/meta-llama/Llama-3.2-11B-Vision" rel="nofollow">meta-llama/Llama-3.2-11B-Vision</a>',Bo,kt,Dn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Po,ie,To,Be,bo,I,Pe,qo,xt,An=`Constructs a Mllama processor which wraps <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaImageProcessor">MllamaImageProcessor</a> and
<code>PretrainedTokenizerFast</code> into a single processor that inherits both the image processor and
tokenizer functionalities. See the <code>__call__()</code> and <code>decode()</code> for more
information.
The preferred way of passing kwargs is as a dictionary per modality, see usage example below.`,Ro,le,Xo,de,qe,Eo,$t,Kn=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Ho,ce,Re,Qo,Ct,ea=`This method forwards all its arguments to PreTrainedTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,So,me,Xe,Yo,It,ta="Post-process the output of the model to decode the text.",yo,Ee,wo,z,He,Oo,Jt,oa="Constructs a Mllama image processor.",Do,pe,Qe,Ao,zt,na=`Pad an image to the <code>size</code> x <code>aspect_ratio</code>. For example, if size is {height: 224, width: 224} and aspect ratio is
(1, 2), the image will be padded to 224x448.`,Ko,he,Se,en,Ut,aa="Preprocess a batch of images.",tn,K,Ye,on,jt,sa=`Resizes an image to fit within a tiled canvas while maintaining its aspect ratio.
The optimal canvas size is calculated based on the maximum number of tiles and the tile size.`,nn,Ft,ra=`The function first determines the best tile arrangement for the image, then resizes the image
to fit within this canvas. The resized image and the number of tiles along the height and width
dimensions are returned.`,vo,Oe,ko,U,De,an,Wt,ia="The Mllama model which consists of a vision encoder and a language model.",sn,Lt,la=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,rn,Vt,da=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ln,H,Ae,dn,Zt,ca='The <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaForConditionalGeneration">MllamaForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',cn,ue,mn,ge,xo,Ke,$o,j,et,pn,Nt,ma="The Mllama Text Model with a language modeling head on top.",hn,Gt,pa=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,un,Bt,ha=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,gn,Q,tt,fn,Pt,ua='The <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaForCausalLM">MllamaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',_n,fe,Mn,_e,Co,ot,Io,F,nt,Tn,qt,ga="The Mllama Text Model which consists of transformer with self and cross attention layers.",bn,Rt,fa=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,yn,Xt,_a=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,wn,S,at,vn,Et,Ma='The <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaTextModel">MllamaTextModel</a> forward method, overrides the <code>__call__</code> special method.',kn,Me,xn,Te,Jo,st,zo,W,rt,$n,Ht,Ta="The Mllama model which consists of a vision encoder and a language model without language modeling head.",Cn,Qt,ba=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,In,St,ya=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Jn,ee,it,zn,Yt,wa='The <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaModel">MllamaModel</a> forward method, overrides the <code>__call__</code> special method.',Un,be,Uo,lt,jo,L,dt,jn,Ot,va="The Mllama Text Model with a language modeling head on top.",Fn,Dt,ka=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Wn,At,xa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ln,Y,ct,Vn,Kt,$a='The <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaForCausalLM">MllamaForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Zn,ye,Nn,we,Fo,mt,Wo,V,pt,Gn,eo,Ca="The Mllama Vision Model which consists of two vision encoders.",Bn,to,Ia=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Pn,oo,Ja=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,qn,O,ht,Rn,no,za='The <a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaVisionModel">MllamaVisionModel</a> forward method, overrides the <code>__call__</code> special method.',Xn,ve,En,ke,Lo,ut,Vo,so,Zo;return y=new N({props:{title:"Mllama",local:"mllama",headingTag:"h1"}}),B=new N({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Ue=new N({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h2"}}),re=new bt({props:{warning:!0,$$slots:{default:[Za]},$$scope:{ctx:v}}}),Fe=new N({props:{title:"Usage Example",local:"usage-example",headingTag:"h2"}}),We=new N({props:{title:"Instruct model",local:"instruct-model",headingTag:"h4"}}),Le=new ae({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwTWxsYW1hRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwQXV0b1Byb2Nlc3NvciUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0xMUItVmlzaW9uLUluc3RydWN0JTIyJTBBbW9kZWwlMjAlM0QlMjBNbGxhbWFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlJTIyJTJDJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZsbGF2YS12bC5naXRodWIuaW8lMkZzdGF0aWMlMkZpbWFnZXMlMkZ2aWV3LmpwZyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwaW1hZ2UlMjBzaG93JTNGJTIyJTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNSklMEFwcmludChwcm9jZXNzb3IuZGVjb2RlKG91dHB1dCU1QjAlNUQpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MllamaForConditionalGeneration, AutoProcessor

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision-Instruct&quot;</span>
model = MllamaForConditionalGeneration.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
processor = AutoProcessor.from_pretrained(model_id)

messages = [
    [
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, 
            <span class="hljs-string">&quot;content&quot;</span>: [
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://llava-vl.github.io/static/images/view.jpg&quot;</span>},
                {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What does the image show?&quot;</span>}
            ]
        }
    ],
]
inputs = processor.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">25</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>]))`,wrap:!1}}),Ve=new N({props:{title:"Base model",local:"base-model",headingTag:"h4"}}),Ze=new ae({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBNbGxhbWFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBBdXRvUHJvY2Vzc29yJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4yLTExQi1WaXNpb24lMjIlMEFtb2RlbCUyMCUzRCUyME1sbGFtYUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTNDJTdDaW1hZ2UlN0MlM0VJZiUyMEklMjBoYWQlMjB0byUyMHdyaXRlJTIwYSUyMGhhaWt1JTIwZm9yJTIwdGhpcyUyMG9uZSUyMiUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGbGxhdmEtdmwuZ2l0aHViLmlvJTJGc3RhdGljJTJGaW1hZ2VzJTJGdmlldy5qcGclMjIlMEFyYXdfaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0RyYXdfaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhtb2RlbC5kZXZpY2UpJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RGYWxzZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjUpJTBBcHJpbnQocHJvY2Vzc29yLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MllamaForConditionalGeneration, AutoProcessor

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.2-11B-Vision&quot;</span>
model = MllamaForConditionalGeneration.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
processor = AutoProcessor.from_pretrained(model_id)

prompt = <span class="hljs-string">&quot;&lt;|image|&gt;If I had to write a haiku for this one&quot;</span>
url = <span class="hljs-string">&quot;https://llava-vl.github.io/static/images/view.jpg&quot;</span>
raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

inputs = processor(text=prompt, images=raw_image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)
output = model.generate(**inputs, do_sample=<span class="hljs-literal">False</span>, max_new_tokens=<span class="hljs-number">25</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),Ne=new N({props:{title:"MllamaConfig",local:"transformers.MllamaConfig",headingTag:"h2"}}),Ge=new C({props:{name:"class transformers.MllamaConfig",anchor:"transformers.MllamaConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 128256"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MllamaConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>MllamaVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.MllamaConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>MllamaTextConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.MllamaConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 128256) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/configuration_mllama.py#L299"}}),ie=new yt({props:{anchor:"transformers.MllamaConfig.example",$$slots:{default:[Na]},$$scope:{ctx:v}}}),Be=new N({props:{title:"MllamaProcessor",local:"transformers.MllamaProcessor",headingTag:"h2"}}),Pe=new C({props:{name:"class transformers.MllamaProcessor",anchor:"transformers.MllamaProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"chat_template",val:" = None"}],parametersDescription:[{anchor:"transformers.MllamaProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaImageProcessor">MllamaImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.MllamaProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>PreTrainedTokenizer</code>, <code>PreTrainedTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.MllamaProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/processing_mllama.py#L178"}}),le=new yt({props:{anchor:"transformers.MllamaProcessor.example",$$slots:{default:[Ga]},$$scope:{ctx:v}}}),qe=new C({props:{name:"batch_decode",anchor:"transformers.MllamaProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/processing_mllama.py#L347"}}),Re=new C({props:{name:"decode",anchor:"transformers.MllamaProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/processing_mllama.py#L354"}}),Xe=new C({props:{name:"post_process_image_text_to_text",anchor:"transformers.MllamaProcessor.post_process_image_text_to_text",parameters:[{name:"generated_outputs",val:""},{name:"skip_special_tokens",val:" = True"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MllamaProcessor.post_process_image_text_to_text.generated_outputs",description:`<strong>generated_outputs</strong> (<code>torch.Tensor</code> or <code>np.ndarray</code>) &#x2014;
The output of the model <code>generate</code> function. The output is expected to be a tensor of shape <code>(batch_size, sequence_length)</code>
or <code>(sequence_length,)</code>.`,name:"generated_outputs"},{anchor:"transformers.MllamaProcessor.post_process_image_text_to_text.skip_special_tokens",description:`<strong>skip_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to remove special tokens in the output. Argument passed to the tokenizer&#x2019;s <code>batch_decode</code> method.`,name:"skip_special_tokens"},{anchor:"transformers.MllamaProcessor.post_process_image_text_to_text.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to clean up the tokenization spaces. Argument passed to the tokenizer&#x2019;s <code>batch_decode</code> method.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.MllamaProcessor.post_process_image_text_to_text.*kwargs",description:`*<strong>*kwargs</strong> &#x2014;
Additional arguments to be passed to the tokenizer&#x2019;s <code>batch_decode method</code>.`,name:"*kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/processing_mllama.py#L361",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The decoded text.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[str]</code></p>
`}}),Ee=new N({props:{title:"MllamaImageProcessor",local:"transformers.MllamaImageProcessor",headingTag:"h2"}}),He=new C({props:{name:"class transformers.MllamaImageProcessor",anchor:"transformers.MllamaImageProcessor",parameters:[{name:"do_convert_rgb",val:": bool = True"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": bool = True"},{name:"max_image_tiles",val:": int = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MllamaImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB. This is useful if the input image is of a different format e.g. RGBA.
Only has an effect if the input image is in the PIL format.`,name:"do_convert_rgb"},{anchor:"transformers.MllamaImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.MllamaImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image tile. Should be a dictionary containing &#x2018;height&#x2019; and &#x2018;width&#x2019; keys, both with integer values.
The height and width values should be equal.`,name:"size"},{anchor:"transformers.MllamaImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.MllamaImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.MllamaImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.MllamaImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.MllamaImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.MllamaImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.MllamaImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to pad the images to the largest height and width in the batch.`,name:"do_pad"},{anchor:"transformers.MllamaImageProcessor.max_image_tiles",description:`<strong>max_image_tiles</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The maximum number of tiles to split the image into.`,name:"max_image_tiles"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/image_processing_mllama.py#L536"}}),Qe=new C({props:{name:"pad",anchor:"transformers.MllamaImageProcessor.pad",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"aspect_ratio",val:": typing.Tuple[int, int]"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MllamaImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.MllamaImageProcessor.pad.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.MllamaImageProcessor.pad.aspect_ratio",description:`<strong>aspect_ratio</strong> (<code>Tuple[int, int]</code>) &#x2014;
The aspect ratio of the image.`,name:"aspect_ratio"},{anchor:"transformers.MllamaImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.MllamaImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/image_processing_mllama.py#L788",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The padded image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Se=new C({props:{name:"preprocess",anchor:"transformers.MllamaImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": typing.Optional[PIL.Image.Resampling] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"max_image_tiles",val:": typing.Optional[int] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MllamaImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
A list of images to preprocess.`,name:"images"},{anchor:"transformers.MllamaImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.MllamaImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.MllamaImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image tile. Should be a dictionary containing &#x2018;height&#x2019; and &#x2018;width&#x2019; keys, both with integer values.
The height and width values should be equal.`,name:"size"},{anchor:"transformers.MllamaImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.MllamaImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.MllamaImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.MllamaImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.MllamaImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.MllamaImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.MllamaImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether or not to pad the images to the largest height and width in the batch.`,name:"do_pad"},{anchor:"transformers.MllamaImageProcessor.preprocess.max_image_tiles",description:`<strong>max_image_tiles</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.max_image_tiles</code>) &#x2014;
The maximum number of tiles to split the image into.`,name:"max_image_tiles"},{anchor:"transformers.MllamaImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.MllamaImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/image_processing_mllama.py#L601",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><strong>pixel_values</strong> (<code>TensorType</code>): The preprocessed pixel values.</li>
<li><strong>aspect_ratio_ids</strong> (<code>TensorType</code>): The aspect ratio ids of the images.</li>
<li><strong>num_tiles</strong> (<code>List[List[int]]</code>): The number of tiles for each image in the batch.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>BatchFeature</code> of the following structure</p>
`}}),Ye=new C({props:{name:"resize",anchor:"transformers.MllamaImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"max_image_tiles",val:": int"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.MllamaImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.MllamaImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.MllamaImageProcessor.resize.max_image_tiles",description:`<strong>max_image_tiles</strong> (<code>int</code>) &#x2014;
The maximum number of tiles to split the image into.`,name:"max_image_tiles"},{anchor:"transformers.MllamaImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.MllamaImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.MllamaImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/image_processing_mllama.py#L835",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The resized image and a tuple containing the number of tiles
along the height and width dimensions.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Union[np.ndarray, Tuple[int, int]]</code></p>
`}}),Oe=new N({props:{title:"MllamaForConditionalGeneration",local:"transformers.MllamaForConditionalGeneration",headingTag:"h2"}}),De=new C({props:{name:"class transformers.MllamaForConditionalGeneration",anchor:"transformers.MllamaForConditionalGeneration",parameters:[{name:"config",val:": MllamaConfig"}],parametersDescription:[{anchor:"transformers.MllamaForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig">MllamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1765"}}),Ae=new C({props:{name:"forward",anchor:"transformers.MllamaForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"aspect_ratio_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"aspect_ratio_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attention_states",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.mllama.modeling_mllama.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.MllamaForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MllamaForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.MllamaForConditionalGeneration.forward.aspect_ratio_mask",description:`<strong>aspect_ratio_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding tiles. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tiles that are <strong>not masked</strong>,</li>
<li>0 for tiles that are <strong>masked</strong>.</li>
</ul>`,name:"aspect_ratio_mask"},{anchor:"transformers.MllamaForConditionalGeneration.forward.aspect_ratio_ids",description:`<strong>aspect_ratio_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, max_num_images)</code>, <em>optional</em>) &#x2014;
Aspect ratio ids used to select the appropriate precomputed tile embeddings based on the aspect ratio of each input image.
These ids correspond to indices in the model&#x2019;s list of supported aspect ratios, offset by 1.</p>
<p>For example, if the model supports aspect ratios [[1, 1], [1, 2], [2, 1]]:</p>
<ul>
<li>An image with aspect ratio [1, 1] would have ID 1</li>
<li>An image with aspect ratio [1, 2] would have ID 2</li>
<li>An image with aspect ratio [2, 1] would have ID 3</li>
</ul>
<p>The id 0 is reserved for padding (i.e., no image).</p>
<p>If an image has aspect ratio [1, 2], that means it was split into 2 tiles horizontally, and its <code>aspect_ratio_id</code> would be 2.`,name:"aspect_ratio_ids"},{anchor:"transformers.MllamaForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MllamaForConditionalGeneration.forward.cross_attention_mask",description:`<strong>cross_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_length, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Cross-attention mask to control the interaction between text tokens and image tiles.
This 4D tensor defines which image tiles each text token should attend to.</p>
<p>For each text token (in seq_length):</p>
<ul>
<li>1 indicates the token <strong>should attend</strong> to the corresponding image tile</li>
<li>0 indicates the token <strong>should not attend</strong> to the corresponding image tile</li>
</ul>`,name:"cross_attention_mask"},{anchor:"transformers.MllamaForConditionalGeneration.forward.cross_attention_states",description:`<strong>cross_attention_states</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Output of the vision model, used for cross-attention. This tensor contains the processed image features that
the language model will attend to.`,name:"cross_attention_states"},{anchor:"transformers.MllamaForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MllamaForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MllamaForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MllamaForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.MllamaForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MllamaForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MllamaForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MllamaForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MllamaForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MllamaForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1813",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig"
>MllamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ue=new bt({props:{$$slots:{default:[Ba]},$$scope:{ctx:v}}}),ge=new yt({props:{anchor:"transformers.MllamaForConditionalGeneration.forward.example",$$slots:{default:[Pa]},$$scope:{ctx:v}}}),Ke=new N({props:{title:"MllamaForCausalLM",local:"transformers.MllamaForCausalLM",headingTag:"h2"}}),et=new C({props:{name:"class transformers.MllamaForCausalLM",anchor:"transformers.MllamaForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MllamaForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaForCausalLM">MllamaForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1464"}}),tt=new C({props:{name:"forward",anchor:"transformers.MllamaForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"cross_attention_states",val:": typing.Optional[torch.LongTensor] = None"},{name:"cross_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"full_text_row_masked_out_mask",val:": typing.Optional[typing.Tuple[torch.Tensor, torch.Tensor]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.mllama.modeling_mllama.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.MllamaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MllamaForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MllamaForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MllamaForCausalLM.forward.cross_attention_states",description:`<strong>cross_attention_states</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Output of the vision model, used for cross-attention. This tensor contains the processed image features that
the language model will attend to.`,name:"cross_attention_states"},{anchor:"transformers.MllamaForCausalLM.forward.cross_attention_mask",description:`<strong>cross_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Cross-attention mask to control the interaction between text tokens and image tiles.
This 4D tensor defines which image tiles each text token should attend to.</p>
<p>For each text token (in seq_length):</p>
<ul>
<li>1 indicates the token <strong>should attend</strong> to the corresponding image tile</li>
<li>0 indicates the token <strong>should not attend</strong> to the corresponding image tile</li>
</ul>`,name:"cross_attention_mask"},{anchor:"transformers.MllamaForCausalLM.forward.full_text_row_masked_out_mask",description:`<strong>full_text_row_masked_out_mask</strong> (<code>Tuple[torch.Tensor, torch.Tensor]</code>, torch.Tensor]\`, <em>optional</em>) &#x2014;
A tuple containing two tensors that mask out rows in the cross-attention mechanism:</p>
<ul>
<li>The first tensor has shape <code>(batch_size, 1, seq_length, 1)</code> and contains values of 0 or 1.
A value of 0 indicates that the corresponding text token&#x2019;s entire row in the cross-attention
matrix should be masked out (all image tokens ignored).</li>
<li>The second tensor has the same shape and is used internally to apply the masking during
the forward pass of cross-attention layers.
This mask is derived from the cross_attention_mask and is used to handle cases where a text token
should not attend to any image token.</li>
</ul>`,name:"full_text_row_masked_out_mask"},{anchor:"transformers.MllamaForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MllamaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MllamaForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.MllamaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MllamaForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MllamaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MllamaForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MllamaForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MllamaForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig"
>MllamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new bt({props:{$$slots:{default:[qa]},$$scope:{ctx:v}}}),_e=new yt({props:{anchor:"transformers.MllamaForCausalLM.forward.example",$$slots:{default:[Ra]},$$scope:{ctx:v}}}),ot=new N({props:{title:"MllamaTextModel",local:"transformers.MllamaTextModel",headingTag:"h2"}}),nt=new C({props:{name:"class transformers.MllamaTextModel",anchor:"transformers.MllamaTextModel",parameters:[{name:"config",val:": MllamaTextConfig"}],parametersDescription:[{anchor:"transformers.MllamaTextModel.config",description:`<strong>config</strong> (<code>MllamaTextConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1253"}}),at=new C({props:{name:"forward",anchor:"transformers.MllamaTextModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"cross_attention_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"cross_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"full_text_row_masked_out_mask",val:": typing.Optional[typing.Tuple[torch.Tensor, torch.Tensor]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.MllamaTextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MllamaTextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MllamaTextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MllamaTextModel.forward.cross_attention_states",description:`<strong>cross_attention_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Output of the vision model, used for cross-attention. This tensor contains the processed image features that
the language model will attend to.`,name:"cross_attention_states"},{anchor:"transformers.MllamaTextModel.forward.cross_attention_mask",description:`<strong>cross_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_length, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Cross-attention mask to control the interaction between text tokens and image tiles.
This 4D tensor defines which image tiles each text token should attend to.</p>
<p>For each text token (in seq_length):</p>
<ul>
<li>1 indicates the token <strong>should attend</strong> to the corresponding image tile</li>
<li>0 indicates the token <strong>should not attend</strong> to the corresponding image tile</li>
</ul>`,name:"cross_attention_mask"},{anchor:"transformers.MllamaTextModel.forward.full_text_row_masked_out_mask",description:`<strong>full_text_row_masked_out_mask</strong> (<code>Tuple[torch.Tensor, torch.Tensor]</code>, torch.Tensor]\`, <em>optional</em>) &#x2014;
A tuple containing two tensors that mask out rows in the cross-attention mechanism:</p>
<ul>
<li>The first tensor has shape <code>(batch_size, 1, seq_length, 1)</code> and contains values of 0 or 1.
A value of 0 indicates that the corresponding text token&#x2019;s entire row in the cross-attention
matrix should be masked out (all image tokens ignored).</li>
<li>The second tensor has the same shape and is used internally to apply the masking during
the forward pass of cross-attention layers.
This mask is derived from the cross_attention_mask and is used to handle cases where a text token
should not attend to any image token.</li>
</ul>`,name:"full_text_row_masked_out_mask"},{anchor:"transformers.MllamaTextModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MllamaTextModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MllamaTextModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MllamaTextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MllamaTextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MllamaTextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MllamaTextModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1288",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig"
>MllamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Me=new bt({props:{$$slots:{default:[Xa]},$$scope:{ctx:v}}}),Te=new yt({props:{anchor:"transformers.MllamaTextModel.forward.example",$$slots:{default:[Ea]},$$scope:{ctx:v}}}),st=new N({props:{title:"MllamaModel",local:"transformers.MllamaModel",headingTag:"h2"}}),rt=new C({props:{name:"class transformers.MllamaModel",anchor:"transformers.MllamaModel",parameters:[{name:"config",val:": MllamaConfig"}],parametersDescription:[{anchor:"transformers.MllamaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig">MllamaConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1611"}}),it=new C({props:{name:"forward",anchor:"transformers.MllamaModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"aspect_ratio_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"aspect_ratio_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attention_states",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.MllamaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MllamaModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.MllamaModel.forward.aspect_ratio_mask",description:`<strong>aspect_ratio_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding tiles. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tiles that are <strong>not masked</strong>,</li>
<li>0 for tiles that are <strong>masked</strong>.</li>
</ul>`,name:"aspect_ratio_mask"},{anchor:"transformers.MllamaModel.forward.aspect_ratio_ids",description:`<strong>aspect_ratio_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, max_num_images)</code>, <em>optional</em>) &#x2014;
Aspect ratio ids used to select the appropriate precomputed tile embeddings based on the aspect ratio of each input image.
These ids correspond to indices in the model&#x2019;s list of supported aspect ratios, offset by 1.</p>
<p>For example, if the model supports aspect ratios [[1, 1], [1, 2], [2, 1]]:</p>
<ul>
<li>An image with aspect ratio [1, 1] would have ID 1</li>
<li>An image with aspect ratio [1, 2] would have ID 2</li>
<li>An image with aspect ratio [2, 1] would have ID 3</li>
</ul>
<p>The id 0 is reserved for padding (i.e., no image).</p>
<p>If an image has aspect ratio [1, 2], that means it was split into 2 tiles horizontally, and its <code>aspect_ratio_id</code> would be 2.`,name:"aspect_ratio_ids"},{anchor:"transformers.MllamaModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MllamaModel.forward.cross_attention_mask",description:`<strong>cross_attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, seq_length, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Cross-attention mask to control the interaction between text tokens and image tiles.
This 4D tensor defines which image tiles each text token should attend to.</p>
<p>For each text token (in seq_length):</p>
<ul>
<li>1 indicates the token <strong>should attend</strong> to the corresponding image tile</li>
<li>0 indicates the token <strong>should not attend</strong> to the corresponding image tile</li>
</ul>`,name:"cross_attention_mask"},{anchor:"transformers.MllamaModel.forward.cross_attention_states",description:`<strong>cross_attention_states</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Output of the vision model, used for cross-attention. This tensor contains the processed image features that
the language model will attend to.`,name:"cross_attention_states"},{anchor:"transformers.MllamaModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MllamaModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>List[torch.FloatTensor]</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MllamaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MllamaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MllamaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MllamaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MllamaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MllamaModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1643",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig"
>MllamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),be=new bt({props:{$$slots:{default:[Ha]},$$scope:{ctx:v}}}),lt=new N({props:{title:"MllamaForCausalLM",local:"transformers.MllamaForCausalLM",headingTag:"h2"}}),dt=new C({props:{name:"class transformers.MllamaForCausalLM",anchor:"transformers.MllamaForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.MllamaForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaForCausalLM">MllamaForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1464"}}),ct=new C({props:{name:"forward",anchor:"transformers.MllamaForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"cross_attention_states",val:": typing.Optional[torch.LongTensor] = None"},{name:"cross_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"full_text_row_masked_out_mask",val:": typing.Optional[typing.Tuple[torch.Tensor, torch.Tensor]] = None"},{name:"past_key_values",val:": typing.Union[transformers.cache_utils.Cache, typing.List[torch.FloatTensor], NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.mllama.modeling_mllama.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.MllamaForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MllamaForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MllamaForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.MllamaForCausalLM.forward.cross_attention_states",description:`<strong>cross_attention_states</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Output of the vision model, used for cross-attention. This tensor contains the processed image features that
the language model will attend to.`,name:"cross_attention_states"},{anchor:"transformers.MllamaForCausalLM.forward.cross_attention_mask",description:`<strong>cross_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, seq_length, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Cross-attention mask to control the interaction between text tokens and image tiles.
This 4D tensor defines which image tiles each text token should attend to.</p>
<p>For each text token (in seq_length):</p>
<ul>
<li>1 indicates the token <strong>should attend</strong> to the corresponding image tile</li>
<li>0 indicates the token <strong>should not attend</strong> to the corresponding image tile</li>
</ul>`,name:"cross_attention_mask"},{anchor:"transformers.MllamaForCausalLM.forward.full_text_row_masked_out_mask",description:`<strong>full_text_row_masked_out_mask</strong> (<code>Tuple[torch.Tensor, torch.Tensor]</code>, torch.Tensor]\`, <em>optional</em>) &#x2014;
A tuple containing two tensors that mask out rows in the cross-attention mechanism:</p>
<ul>
<li>The first tensor has shape <code>(batch_size, 1, seq_length, 1)</code> and contains values of 0 or 1.
A value of 0 indicates that the corresponding text token&#x2019;s entire row in the cross-attention
matrix should be masked out (all image tokens ignored).</li>
<li>The second tensor has the same shape and is used internally to apply the masking during
the forward pass of cross-attention layers.
This mask is derived from the cross_attention_mask and is used to handle cases where a text token
should not attend to any image token.</li>
</ul>`,name:"full_text_row_masked_out_mask"},{anchor:"transformers.MllamaForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[~cache_utils.Cache, List[torch.FloatTensor], NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MllamaForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MllamaForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.MllamaForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MllamaForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MllamaForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MllamaForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MllamaForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.MllamaForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1502",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig"
>MllamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ye=new bt({props:{$$slots:{default:[Qa]},$$scope:{ctx:v}}}),we=new yt({props:{anchor:"transformers.MllamaForCausalLM.forward.example",$$slots:{default:[Sa]},$$scope:{ctx:v}}}),mt=new N({props:{title:"MllamaVisionModel",local:"transformers.MllamaVisionModel",headingTag:"h2"}}),pt=new C({props:{name:"class transformers.MllamaVisionModel",anchor:"transformers.MllamaVisionModel",parameters:[{name:"config",val:": MllamaVisionConfig"}],parametersDescription:[{anchor:"transformers.MllamaVisionModel.config",description:`<strong>config</strong> (<code>MllamaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1022"}}),ht=new C({props:{name:"forward",anchor:"transformers.MllamaVisionModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"aspect_ratio_ids",val:": Tensor"},{name:"aspect_ratio_mask",val:": Tensor"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MllamaVisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.MllamaVisionModel.forward.aspect_ratio_ids",description:`<strong>aspect_ratio_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, max_num_images)</code>, <em>optional</em>) &#x2014;
Aspect ratio ids used to select the appropriate precomputed tile embeddings based on the aspect ratio of each input image.
These ids correspond to indices in the model&#x2019;s list of supported aspect ratios, offset by 1.</p>
<p>For example, if the model supports aspect ratios [[1, 1], [1, 2], [2, 1]]:</p>
<ul>
<li>An image with aspect ratio [1, 1] would have ID 1</li>
<li>An image with aspect ratio [1, 2] would have ID 2</li>
<li>An image with aspect ratio [2, 1] would have ID 3</li>
</ul>
<p>The id 0 is reserved for padding (i.e., no image).</p>
<p>If an image has aspect ratio [1, 2], that means it was split into 2 tiles horizontally, and its <code>aspect_ratio_id</code> would be 2.`,name:"aspect_ratio_ids"},{anchor:"transformers.MllamaVisionModel.forward.aspect_ratio_mask",description:`<strong>aspect_ratio_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, max_num_images, max_num_tiles)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding tiles. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tiles that are <strong>not masked</strong>,</li>
<li>0 for tiles that are <strong>masked</strong>.</li>
</ul>`,name:"aspect_ratio_mask"},{anchor:"transformers.MllamaVisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MllamaVisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MllamaVisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/mllama/modeling_mllama.py#L1080",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/mllama#transformers.MllamaConfig"
>MllamaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ve=new bt({props:{$$slots:{default:[Ya]},$$scope:{ctx:v}}}),ke=new yt({props:{anchor:"transformers.MllamaVisionModel.forward.example",$$slots:{default:[Oa]},$$scope:{ctx:v}}}),ut=new Va({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/mllama.md"}}),{c(){t=d("meta"),b=n(),l=d("p"),m=n(),h(y.$$.fragment),r=n(),w=d("div"),w.innerHTML=Ie,x=n(),h(B.$$.fragment),ro=n(),Je=d("p"),Je.textContent=Hn,io=n(),ze=d("p"),ze.innerHTML=Qn,lo=n(),h(Ue.$$.fragment),co=n(),je=d("ul"),je.innerHTML=Sn,mo=n(),h(re.$$.fragment),po=n(),h(Fe.$$.fragment),ho=n(),h(We.$$.fragment),uo=n(),h(Le.$$.fragment),go=n(),h(Ve.$$.fragment),fo=n(),h(Ze.$$.fragment),_o=n(),h(Ne.$$.fragment),Mo=n(),J=d("div"),h(Ge.$$.fragment),No=n(),wt=d("p"),wt.innerHTML=Yn,Go=n(),vt=d("p"),vt.innerHTML=On,Bo=n(),kt=d("p"),kt.innerHTML=Dn,Po=n(),h(ie.$$.fragment),To=n(),h(Be.$$.fragment),bo=n(),I=d("div"),h(Pe.$$.fragment),qo=n(),xt=d("p"),xt.innerHTML=An,Ro=n(),h(le.$$.fragment),Xo=n(),de=d("div"),h(qe.$$.fragment),Eo=n(),$t=d("p"),$t.innerHTML=Kn,Ho=n(),ce=d("div"),h(Re.$$.fragment),Qo=n(),Ct=d("p"),Ct.innerHTML=ea,So=n(),me=d("div"),h(Xe.$$.fragment),Yo=n(),It=d("p"),It.textContent=ta,yo=n(),h(Ee.$$.fragment),wo=n(),z=d("div"),h(He.$$.fragment),Oo=n(),Jt=d("p"),Jt.textContent=oa,Do=n(),pe=d("div"),h(Qe.$$.fragment),Ao=n(),zt=d("p"),zt.innerHTML=na,Ko=n(),he=d("div"),h(Se.$$.fragment),en=n(),Ut=d("p"),Ut.textContent=aa,tn=n(),K=d("div"),h(Ye.$$.fragment),on=n(),jt=d("p"),jt.textContent=sa,nn=n(),Ft=d("p"),Ft.textContent=ra,vo=n(),h(Oe.$$.fragment),ko=n(),U=d("div"),h(De.$$.fragment),an=n(),Wt=d("p"),Wt.textContent=ia,sn=n(),Lt=d("p"),Lt.innerHTML=la,rn=n(),Vt=d("p"),Vt.innerHTML=da,ln=n(),H=d("div"),h(Ae.$$.fragment),dn=n(),Zt=d("p"),Zt.innerHTML=ca,cn=n(),h(ue.$$.fragment),mn=n(),h(ge.$$.fragment),xo=n(),h(Ke.$$.fragment),$o=n(),j=d("div"),h(et.$$.fragment),pn=n(),Nt=d("p"),Nt.textContent=ma,hn=n(),Gt=d("p"),Gt.innerHTML=pa,un=n(),Bt=d("p"),Bt.innerHTML=ha,gn=n(),Q=d("div"),h(tt.$$.fragment),fn=n(),Pt=d("p"),Pt.innerHTML=ua,_n=n(),h(fe.$$.fragment),Mn=n(),h(_e.$$.fragment),Co=n(),h(ot.$$.fragment),Io=n(),F=d("div"),h(nt.$$.fragment),Tn=n(),qt=d("p"),qt.textContent=ga,bn=n(),Rt=d("p"),Rt.innerHTML=fa,yn=n(),Xt=d("p"),Xt.innerHTML=_a,wn=n(),S=d("div"),h(at.$$.fragment),vn=n(),Et=d("p"),Et.innerHTML=Ma,kn=n(),h(Me.$$.fragment),xn=n(),h(Te.$$.fragment),Jo=n(),h(st.$$.fragment),zo=n(),W=d("div"),h(rt.$$.fragment),$n=n(),Ht=d("p"),Ht.textContent=Ta,Cn=n(),Qt=d("p"),Qt.innerHTML=ba,In=n(),St=d("p"),St.innerHTML=ya,Jn=n(),ee=d("div"),h(it.$$.fragment),zn=n(),Yt=d("p"),Yt.innerHTML=wa,Un=n(),h(be.$$.fragment),Uo=n(),h(lt.$$.fragment),jo=n(),L=d("div"),h(dt.$$.fragment),jn=n(),Ot=d("p"),Ot.textContent=va,Fn=n(),Dt=d("p"),Dt.innerHTML=ka,Wn=n(),At=d("p"),At.innerHTML=xa,Ln=n(),Y=d("div"),h(ct.$$.fragment),Vn=n(),Kt=d("p"),Kt.innerHTML=$a,Zn=n(),h(ye.$$.fragment),Nn=n(),h(we.$$.fragment),Fo=n(),h(mt.$$.fragment),Wo=n(),V=d("div"),h(pt.$$.fragment),Gn=n(),eo=d("p"),eo.textContent=Ca,Bn=n(),to=d("p"),to.innerHTML=Ia,Pn=n(),oo=d("p"),oo.innerHTML=Ja,qn=n(),O=d("div"),h(ht.$$.fragment),Rn=n(),no=d("p"),no.innerHTML=za,Xn=n(),h(ve.$$.fragment),En=n(),h(ke.$$.fragment),Lo=n(),h(ut.$$.fragment),Vo=n(),so=d("p"),this.h()},l(e){const s=La("svelte-u9bgzb",document.head);t=c(s,"META",{name:!0,content:!0}),s.forEach(i),b=a(e),l=c(e,"P",{}),$(l).forEach(i),m=a(e),u(y.$$.fragment,e),r=a(e),w=c(e,"DIV",{class:!0,"data-svelte-h":!0}),T(w)!=="svelte-13t8s2t"&&(w.innerHTML=Ie),x=a(e),u(B.$$.fragment,e),ro=a(e),Je=c(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-1w50ejb"&&(Je.textContent=Hn),io=a(e),ze=c(e,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-1noqrap"&&(ze.innerHTML=Qn),lo=a(e),u(Ue.$$.fragment,e),co=a(e),je=c(e,"UL",{"data-svelte-h":!0}),T(je)!=="svelte-1dx74jo"&&(je.innerHTML=Sn),mo=a(e),u(re.$$.fragment,e),po=a(e),u(Fe.$$.fragment,e),ho=a(e),u(We.$$.fragment,e),uo=a(e),u(Le.$$.fragment,e),go=a(e),u(Ve.$$.fragment,e),fo=a(e),u(Ze.$$.fragment,e),_o=a(e),u(Ne.$$.fragment,e),Mo=a(e),J=c(e,"DIV",{class:!0});var P=$(J);u(Ge.$$.fragment,P),No=a(P),wt=c(P,"P",{"data-svelte-h":!0}),T(wt)!=="svelte-o7k62h"&&(wt.innerHTML=Yn),Go=a(P),vt=c(P,"P",{"data-svelte-h":!0}),T(vt)!=="svelte-8fyj87"&&(vt.innerHTML=On),Bo=a(P),kt=c(P,"P",{"data-svelte-h":!0}),T(kt)!=="svelte-o55m63"&&(kt.innerHTML=Dn),Po=a(P),u(ie.$$.fragment,P),P.forEach(i),To=a(e),u(Be.$$.fragment,e),bo=a(e),I=c(e,"DIV",{class:!0});var Z=$(I);u(Pe.$$.fragment,Z),qo=a(Z),xt=c(Z,"P",{"data-svelte-h":!0}),T(xt)!=="svelte-1pp61zu"&&(xt.innerHTML=An),Ro=a(Z),u(le.$$.fragment,Z),Xo=a(Z),de=c(Z,"DIV",{class:!0});var gt=$(de);u(qe.$$.fragment,gt),Eo=a(gt),$t=c(gt,"P",{"data-svelte-h":!0}),T($t)!=="svelte-1yrf9bj"&&($t.innerHTML=Kn),gt.forEach(i),Ho=a(Z),ce=c(Z,"DIV",{class:!0});var ft=$(ce);u(Re.$$.fragment,ft),Qo=a(ft),Ct=c(ft,"P",{"data-svelte-h":!0}),T(Ct)!=="svelte-1jl7gd5"&&(Ct.innerHTML=ea),ft.forEach(i),So=a(Z),me=c(Z,"DIV",{class:!0});var _t=$(me);u(Xe.$$.fragment,_t),Yo=a(_t),It=c(_t,"P",{"data-svelte-h":!0}),T(It)!=="svelte-z5vbkk"&&(It.textContent=ta),_t.forEach(i),Z.forEach(i),yo=a(e),u(Ee.$$.fragment,e),wo=a(e),z=c(e,"DIV",{class:!0});var q=$(z);u(He.$$.fragment,q),Oo=a(q),Jt=c(q,"P",{"data-svelte-h":!0}),T(Jt)!=="svelte-h03vcc"&&(Jt.textContent=oa),Do=a(q),pe=c(q,"DIV",{class:!0});var Mt=$(pe);u(Qe.$$.fragment,Mt),Ao=a(Mt),zt=c(Mt,"P",{"data-svelte-h":!0}),T(zt)!=="svelte-dymnub"&&(zt.innerHTML=na),Mt.forEach(i),Ko=a(q),he=c(q,"DIV",{class:!0});var Tt=$(he);u(Se.$$.fragment,Tt),en=a(Tt),Ut=c(Tt,"P",{"data-svelte-h":!0}),T(Ut)!=="svelte-1xds4wy"&&(Ut.textContent=aa),Tt.forEach(i),tn=a(q),K=c(q,"DIV",{class:!0});var se=$(K);u(Ye.$$.fragment,se),on=a(se),jt=c(se,"P",{"data-svelte-h":!0}),T(jt)!=="svelte-zg52p1"&&(jt.textContent=sa),nn=a(se),Ft=c(se,"P",{"data-svelte-h":!0}),T(Ft)!=="svelte-1tffesx"&&(Ft.textContent=ra),se.forEach(i),q.forEach(i),vo=a(e),u(Oe.$$.fragment,e),ko=a(e),U=c(e,"DIV",{class:!0});var R=$(U);u(De.$$.fragment,R),an=a(R),Wt=c(R,"P",{"data-svelte-h":!0}),T(Wt)!=="svelte-1nm8kx0"&&(Wt.textContent=ia),sn=a(R),Lt=c(R,"P",{"data-svelte-h":!0}),T(Lt)!=="svelte-6pahdo"&&(Lt.innerHTML=la),rn=a(R),Vt=c(R,"P",{"data-svelte-h":!0}),T(Vt)!=="svelte-hswkmf"&&(Vt.innerHTML=da),ln=a(R),H=c(R,"DIV",{class:!0});var D=$(H);u(Ae.$$.fragment,D),dn=a(D),Zt=c(D,"P",{"data-svelte-h":!0}),T(Zt)!=="svelte-t9lc3h"&&(Zt.innerHTML=ca),cn=a(D),u(ue.$$.fragment,D),mn=a(D),u(ge.$$.fragment,D),D.forEach(i),R.forEach(i),xo=a(e),u(Ke.$$.fragment,e),$o=a(e),j=c(e,"DIV",{class:!0});var X=$(j);u(et.$$.fragment,X),pn=a(X),Nt=c(X,"P",{"data-svelte-h":!0}),T(Nt)!=="svelte-vkcich"&&(Nt.textContent=ma),hn=a(X),Gt=c(X,"P",{"data-svelte-h":!0}),T(Gt)!=="svelte-6pahdo"&&(Gt.innerHTML=pa),un=a(X),Bt=c(X,"P",{"data-svelte-h":!0}),T(Bt)!=="svelte-hswkmf"&&(Bt.innerHTML=ha),gn=a(X),Q=c(X,"DIV",{class:!0});var A=$(Q);u(tt.$$.fragment,A),fn=a(A),Pt=c(A,"P",{"data-svelte-h":!0}),T(Pt)!=="svelte-1kjhslj"&&(Pt.innerHTML=ua),_n=a(A),u(fe.$$.fragment,A),Mn=a(A),u(_e.$$.fragment,A),A.forEach(i),X.forEach(i),Co=a(e),u(ot.$$.fragment,e),Io=a(e),F=c(e,"DIV",{class:!0});var E=$(F);u(nt.$$.fragment,E),Tn=a(E),qt=c(E,"P",{"data-svelte-h":!0}),T(qt)!=="svelte-20uxyn"&&(qt.textContent=ga),bn=a(E),Rt=c(E,"P",{"data-svelte-h":!0}),T(Rt)!=="svelte-6pahdo"&&(Rt.innerHTML=fa),yn=a(E),Xt=c(E,"P",{"data-svelte-h":!0}),T(Xt)!=="svelte-hswkmf"&&(Xt.innerHTML=_a),wn=a(E),S=c(E,"DIV",{class:!0});var xe=$(S);u(at.$$.fragment,xe),vn=a(xe),Et=c(xe,"P",{"data-svelte-h":!0}),T(Et)!=="svelte-hfsirv"&&(Et.innerHTML=Ma),kn=a(xe),u(Me.$$.fragment,xe),xn=a(xe),u(Te.$$.fragment,xe),xe.forEach(i),E.forEach(i),Jo=a(e),u(st.$$.fragment,e),zo=a(e),W=c(e,"DIV",{class:!0});var te=$(W);u(rt.$$.fragment,te),$n=a(te),Ht=c(te,"P",{"data-svelte-h":!0}),T(Ht)!=="svelte-wyv0kl"&&(Ht.textContent=Ta),Cn=a(te),Qt=c(te,"P",{"data-svelte-h":!0}),T(Qt)!=="svelte-6pahdo"&&(Qt.innerHTML=ba),In=a(te),St=c(te,"P",{"data-svelte-h":!0}),T(St)!=="svelte-hswkmf"&&(St.innerHTML=ya),Jn=a(te),ee=c(te,"DIV",{class:!0});var ao=$(ee);u(it.$$.fragment,ao),zn=a(ao),Yt=c(ao,"P",{"data-svelte-h":!0}),T(Yt)!=="svelte-1nrpnnf"&&(Yt.innerHTML=wa),Un=a(ao),u(be.$$.fragment,ao),ao.forEach(i),te.forEach(i),Uo=a(e),u(lt.$$.fragment,e),jo=a(e),L=c(e,"DIV",{class:!0});var oe=$(L);u(dt.$$.fragment,oe),jn=a(oe),Ot=c(oe,"P",{"data-svelte-h":!0}),T(Ot)!=="svelte-vkcich"&&(Ot.textContent=va),Fn=a(oe),Dt=c(oe,"P",{"data-svelte-h":!0}),T(Dt)!=="svelte-6pahdo"&&(Dt.innerHTML=ka),Wn=a(oe),At=c(oe,"P",{"data-svelte-h":!0}),T(At)!=="svelte-hswkmf"&&(At.innerHTML=xa),Ln=a(oe),Y=c(oe,"DIV",{class:!0});var $e=$(Y);u(ct.$$.fragment,$e),Vn=a($e),Kt=c($e,"P",{"data-svelte-h":!0}),T(Kt)!=="svelte-1kjhslj"&&(Kt.innerHTML=$a),Zn=a($e),u(ye.$$.fragment,$e),Nn=a($e),u(we.$$.fragment,$e),$e.forEach(i),oe.forEach(i),Fo=a(e),u(mt.$$.fragment,e),Wo=a(e),V=c(e,"DIV",{class:!0});var ne=$(V);u(pt.$$.fragment,ne),Gn=a(ne),eo=c(ne,"P",{"data-svelte-h":!0}),T(eo)!=="svelte-1knm5fr"&&(eo.textContent=Ca),Bn=a(ne),to=c(ne,"P",{"data-svelte-h":!0}),T(to)!=="svelte-6pahdo"&&(to.innerHTML=Ia),Pn=a(ne),oo=c(ne,"P",{"data-svelte-h":!0}),T(oo)!=="svelte-hswkmf"&&(oo.innerHTML=Ja),qn=a(ne),O=c(ne,"DIV",{class:!0});var Ce=$(O);u(ht.$$.fragment,Ce),Rn=a(Ce),no=c(Ce,"P",{"data-svelte-h":!0}),T(no)!=="svelte-dgx4dr"&&(no.innerHTML=za),Xn=a(Ce),u(ve.$$.fragment,Ce),En=a(Ce),u(ke.$$.fragment,Ce),Ce.forEach(i),ne.forEach(i),Lo=a(e),u(ut.$$.fragment,e),Vo=a(e),so=c(e,"P",{}),$(so).forEach(i),this.h()},h(){k(t,"name","hf:doc:metadata"),k(t,"content",Aa),k(w,"class","flex flex-wrap space-x-1"),k(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){o(document.head,t),p(e,b,s),p(e,l,s),p(e,m,s),g(y,e,s),p(e,r,s),p(e,w,s),p(e,x,s),g(B,e,s),p(e,ro,s),p(e,Je,s),p(e,io,s),p(e,ze,s),p(e,lo,s),g(Ue,e,s),p(e,co,s),p(e,je,s),p(e,mo,s),g(re,e,s),p(e,po,s),g(Fe,e,s),p(e,ho,s),g(We,e,s),p(e,uo,s),g(Le,e,s),p(e,go,s),g(Ve,e,s),p(e,fo,s),g(Ze,e,s),p(e,_o,s),g(Ne,e,s),p(e,Mo,s),p(e,J,s),g(Ge,J,null),o(J,No),o(J,wt),o(J,Go),o(J,vt),o(J,Bo),o(J,kt),o(J,Po),g(ie,J,null),p(e,To,s),g(Be,e,s),p(e,bo,s),p(e,I,s),g(Pe,I,null),o(I,qo),o(I,xt),o(I,Ro),g(le,I,null),o(I,Xo),o(I,de),g(qe,de,null),o(de,Eo),o(de,$t),o(I,Ho),o(I,ce),g(Re,ce,null),o(ce,Qo),o(ce,Ct),o(I,So),o(I,me),g(Xe,me,null),o(me,Yo),o(me,It),p(e,yo,s),g(Ee,e,s),p(e,wo,s),p(e,z,s),g(He,z,null),o(z,Oo),o(z,Jt),o(z,Do),o(z,pe),g(Qe,pe,null),o(pe,Ao),o(pe,zt),o(z,Ko),o(z,he),g(Se,he,null),o(he,en),o(he,Ut),o(z,tn),o(z,K),g(Ye,K,null),o(K,on),o(K,jt),o(K,nn),o(K,Ft),p(e,vo,s),g(Oe,e,s),p(e,ko,s),p(e,U,s),g(De,U,null),o(U,an),o(U,Wt),o(U,sn),o(U,Lt),o(U,rn),o(U,Vt),o(U,ln),o(U,H),g(Ae,H,null),o(H,dn),o(H,Zt),o(H,cn),g(ue,H,null),o(H,mn),g(ge,H,null),p(e,xo,s),g(Ke,e,s),p(e,$o,s),p(e,j,s),g(et,j,null),o(j,pn),o(j,Nt),o(j,hn),o(j,Gt),o(j,un),o(j,Bt),o(j,gn),o(j,Q),g(tt,Q,null),o(Q,fn),o(Q,Pt),o(Q,_n),g(fe,Q,null),o(Q,Mn),g(_e,Q,null),p(e,Co,s),g(ot,e,s),p(e,Io,s),p(e,F,s),g(nt,F,null),o(F,Tn),o(F,qt),o(F,bn),o(F,Rt),o(F,yn),o(F,Xt),o(F,wn),o(F,S),g(at,S,null),o(S,vn),o(S,Et),o(S,kn),g(Me,S,null),o(S,xn),g(Te,S,null),p(e,Jo,s),g(st,e,s),p(e,zo,s),p(e,W,s),g(rt,W,null),o(W,$n),o(W,Ht),o(W,Cn),o(W,Qt),o(W,In),o(W,St),o(W,Jn),o(W,ee),g(it,ee,null),o(ee,zn),o(ee,Yt),o(ee,Un),g(be,ee,null),p(e,Uo,s),g(lt,e,s),p(e,jo,s),p(e,L,s),g(dt,L,null),o(L,jn),o(L,Ot),o(L,Fn),o(L,Dt),o(L,Wn),o(L,At),o(L,Ln),o(L,Y),g(ct,Y,null),o(Y,Vn),o(Y,Kt),o(Y,Zn),g(ye,Y,null),o(Y,Nn),g(we,Y,null),p(e,Fo,s),g(mt,e,s),p(e,Wo,s),p(e,V,s),g(pt,V,null),o(V,Gn),o(V,eo),o(V,Bn),o(V,to),o(V,Pn),o(V,oo),o(V,qn),o(V,O),g(ht,O,null),o(O,Rn),o(O,no),o(O,Xn),g(ve,O,null),o(O,En),g(ke,O,null),p(e,Lo,s),g(ut,e,s),p(e,Vo,s),p(e,so,s),Zo=!0},p(e,[s]){const P={};s&2&&(P.$$scope={dirty:s,ctx:e}),re.$set(P);const Z={};s&2&&(Z.$$scope={dirty:s,ctx:e}),ie.$set(Z);const gt={};s&2&&(gt.$$scope={dirty:s,ctx:e}),le.$set(gt);const ft={};s&2&&(ft.$$scope={dirty:s,ctx:e}),ue.$set(ft);const _t={};s&2&&(_t.$$scope={dirty:s,ctx:e}),ge.$set(_t);const q={};s&2&&(q.$$scope={dirty:s,ctx:e}),fe.$set(q);const Mt={};s&2&&(Mt.$$scope={dirty:s,ctx:e}),_e.$set(Mt);const Tt={};s&2&&(Tt.$$scope={dirty:s,ctx:e}),Me.$set(Tt);const se={};s&2&&(se.$$scope={dirty:s,ctx:e}),Te.$set(se);const R={};s&2&&(R.$$scope={dirty:s,ctx:e}),be.$set(R);const D={};s&2&&(D.$$scope={dirty:s,ctx:e}),ye.$set(D);const X={};s&2&&(X.$$scope={dirty:s,ctx:e}),we.$set(X);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),ve.$set(A);const E={};s&2&&(E.$$scope={dirty:s,ctx:e}),ke.$set(E)},i(e){Zo||(f(y.$$.fragment,e),f(B.$$.fragment,e),f(Ue.$$.fragment,e),f(re.$$.fragment,e),f(Fe.$$.fragment,e),f(We.$$.fragment,e),f(Le.$$.fragment,e),f(Ve.$$.fragment,e),f(Ze.$$.fragment,e),f(Ne.$$.fragment,e),f(Ge.$$.fragment,e),f(ie.$$.fragment,e),f(Be.$$.fragment,e),f(Pe.$$.fragment,e),f(le.$$.fragment,e),f(qe.$$.fragment,e),f(Re.$$.fragment,e),f(Xe.$$.fragment,e),f(Ee.$$.fragment,e),f(He.$$.fragment,e),f(Qe.$$.fragment,e),f(Se.$$.fragment,e),f(Ye.$$.fragment,e),f(Oe.$$.fragment,e),f(De.$$.fragment,e),f(Ae.$$.fragment,e),f(ue.$$.fragment,e),f(ge.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(at.$$.fragment,e),f(Me.$$.fragment,e),f(Te.$$.fragment,e),f(st.$$.fragment,e),f(rt.$$.fragment,e),f(it.$$.fragment,e),f(be.$$.fragment,e),f(lt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(ye.$$.fragment,e),f(we.$$.fragment,e),f(mt.$$.fragment,e),f(pt.$$.fragment,e),f(ht.$$.fragment,e),f(ve.$$.fragment,e),f(ke.$$.fragment,e),f(ut.$$.fragment,e),Zo=!0)},o(e){_(y.$$.fragment,e),_(B.$$.fragment,e),_(Ue.$$.fragment,e),_(re.$$.fragment,e),_(Fe.$$.fragment,e),_(We.$$.fragment,e),_(Le.$$.fragment,e),_(Ve.$$.fragment,e),_(Ze.$$.fragment,e),_(Ne.$$.fragment,e),_(Ge.$$.fragment,e),_(ie.$$.fragment,e),_(Be.$$.fragment,e),_(Pe.$$.fragment,e),_(le.$$.fragment,e),_(qe.$$.fragment,e),_(Re.$$.fragment,e),_(Xe.$$.fragment,e),_(Ee.$$.fragment,e),_(He.$$.fragment,e),_(Qe.$$.fragment,e),_(Se.$$.fragment,e),_(Ye.$$.fragment,e),_(Oe.$$.fragment,e),_(De.$$.fragment,e),_(Ae.$$.fragment,e),_(ue.$$.fragment,e),_(ge.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(ot.$$.fragment,e),_(nt.$$.fragment,e),_(at.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(st.$$.fragment,e),_(rt.$$.fragment,e),_(it.$$.fragment,e),_(be.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(ct.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(mt.$$.fragment,e),_(pt.$$.fragment,e),_(ht.$$.fragment,e),_(ve.$$.fragment,e),_(ke.$$.fragment,e),_(ut.$$.fragment,e),Zo=!1},d(e){e&&(i(b),i(l),i(m),i(r),i(w),i(x),i(ro),i(Je),i(io),i(ze),i(lo),i(co),i(je),i(mo),i(po),i(ho),i(uo),i(go),i(fo),i(_o),i(Mo),i(J),i(To),i(bo),i(I),i(yo),i(wo),i(z),i(vo),i(ko),i(U),i(xo),i($o),i(j),i(Co),i(Io),i(F),i(Jo),i(zo),i(W),i(Uo),i(jo),i(L),i(Fo),i(Wo),i(V),i(Lo),i(Vo),i(so)),i(t),M(y,e),M(B,e),M(Ue,e),M(re,e),M(Fe,e),M(We,e),M(Le,e),M(Ve,e),M(Ze,e),M(Ne,e),M(Ge),M(ie),M(Be,e),M(Pe),M(le),M(qe),M(Re),M(Xe),M(Ee,e),M(He),M(Qe),M(Se),M(Ye),M(Oe,e),M(De),M(Ae),M(ue),M(ge),M(Ke,e),M(et),M(tt),M(fe),M(_e),M(ot,e),M(nt),M(at),M(Me),M(Te),M(st,e),M(rt),M(it),M(be),M(lt,e),M(dt),M(ct),M(ye),M(we),M(mt,e),M(pt),M(ht),M(ve),M(ke),M(ut,e)}}}const Aa='{"title":"Mllama","local":"mllama","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Tips","local":"usage-tips","sections":[],"depth":2},{"title":"Usage Example","local":"usage-example","sections":[{"title":"Instruct model","local":"instruct-model","sections":[],"depth":4},{"title":"Base model","local":"base-model","sections":[],"depth":4}],"depth":2},{"title":"MllamaConfig","local":"transformers.MllamaConfig","sections":[],"depth":2},{"title":"MllamaProcessor","local":"transformers.MllamaProcessor","sections":[],"depth":2},{"title":"MllamaImageProcessor","local":"transformers.MllamaImageProcessor","sections":[],"depth":2},{"title":"MllamaForConditionalGeneration","local":"transformers.MllamaForConditionalGeneration","sections":[],"depth":2},{"title":"MllamaForCausalLM","local":"transformers.MllamaForCausalLM","sections":[],"depth":2},{"title":"MllamaTextModel","local":"transformers.MllamaTextModel","sections":[],"depth":2},{"title":"MllamaModel","local":"transformers.MllamaModel","sections":[],"depth":2},{"title":"MllamaForCausalLM","local":"transformers.MllamaForCausalLM","sections":[],"depth":2},{"title":"MllamaVisionModel","local":"transformers.MllamaVisionModel","sections":[],"depth":2}],"depth":1}';function Ka(v){return ja(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ls extends Fa{constructor(t){super(),Wa(this,t,Ka,Da,Ua,{})}}export{ls as component};
