import{s as ro,z as ao,o as io,n as St}from"../chunks/scheduler.18a86fab.js";import{S as lo,i as co,g as a,s,r as m,A as po,h as i,f as o,c as r,j as I,u,x as d,k as j,y as p,a as n,v as h,d as g,t as f,w as y}from"../chunks/index.98837b22.js";import{T as mo}from"../chunks/Tip.77304350.js";import{D as Me}from"../chunks/Docstring.6758ea23.js";import{C as xe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as so}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Te}from"../chunks/Heading.7e7e0c5b.js";import{E as uo}from"../chunks/index.92f616ba.js";function ho(z){let c,J="Example:",b,_,M;return _=new xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN1cGVyUG9pbnRDb25maWclMkMlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3VwZXJQb2ludCUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3VwZXJQb2ludENvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMHN1cGVycG9pbnQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbihjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SuperPointConfig, SuperPointForKeypointDetection

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a SuperPoint superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SuperPointConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the superpoint style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperPointForKeypointDetection(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=a("p"),c.textContent=J,b=s(),m(_.$$.fragment)},l(l){c=i(l,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=J),b=r(l),u(_.$$.fragment,l)},m(l,T){n(l,c,T),n(l,b,T),h(_,l,T),M=!0},p:St,i(l){M||(g(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(o(c),o(b)),y(_,l)}}}function go(z){let c,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=a("p"),c.innerHTML=J},l(b){c=i(b,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=J)},m(b,_){n(b,c,_)},p:St,d(b){b&&o(c)}}}function fo(z){let c,J="Examples:",b,_,M;return _=new xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJwb2ludCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)`,wrap:!1}}),{c(){c=a("p"),c.textContent=J,b=s(),m(_.$$.fragment)},l(l){c=i(l,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=J),b=r(l),u(_.$$.fragment,l)},m(l,T){n(l,c,T),n(l,b,T),h(_,l,T),M=!0},p:St,i(l){M||(g(_.$$.fragment,l),M=!0)},o(l){f(_.$$.fragment,l),M=!1},d(l){l&&(o(c),o(b)),y(_,l)}}}function yo(z){let c,J,b,_,M,l,T,It='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ke,H,Ve,q,zt=`The SuperPoint model was proposed
in <a href="https://arxiv.org/abs/1712.07629" rel="nofollow">SuperPoint: Self-Supervised Interest Point Detection and Description</a> by Daniel
DeTone, Tomasz Malisiewicz and Andrew Rabinovich.`,We,N,xt=`This model is the result of a self-supervised training of a fully-convolutional network for interest point detection and
description. The model is able to detect interest points that are repeatable under homographic transformations and
provide a descriptor for each point. The use of the model in its own is limited, but it can be used as a feature
extractor for other tasks such as homography estimation, image matching, etc.`,Be,D,kt="The abstract from the paper is the following:",Re,F,Vt=`<em>This paper presents a self-supervised framework for training interest point detectors and descriptors suitable for a
large number of multiple-view geometry problems in computer vision. As opposed to patch-based neural networks, our
fully-convolutional model operates on full-sized images and jointly computes pixel-level interest point locations and
associated descriptors in one forward pass. We introduce Homographic Adaptation, a multi-scale, multi-homography
approach for boosting interest point detection repeatability and performing cross-domain adaptation (e.g.,
synthetic-to-real). Our model, when trained on the MS-COCO generic image dataset using Homographic Adaptation, is able
to repeatedly detect a much richer set of interest points than the initial pre-adapted deep model and any other
traditional corner detector. The final system gives rise to state-of-the-art homography estimation results on HPatches
when compared to LIFT, SIFT and ORB.</em>`,Ze,x,Wt,Ge,E,Bt='SuperPoint overview. Taken from the <a href="https://arxiv.org/abs/1712.07629v4">original paper.</a>',He,L,qe,X,Rt="Here is a quick example of using the model to detect interest points in an image:",Ne,Q,De,Y,Zt="The outputs contain the list of keypoint coordinates with their respective score and description (a 256-long vector).",Fe,A,Gt=`You can also feed multiple images to the model. Due to the nature of SuperPoint, to output a dynamic number of keypoints,
you will need to use the mask attribute to retrieve the respective information :`,Ee,K,Le,O,Ht="You can then print the keypoints on the image of your choice to visualize the result:",Xe,ee,Qe,te,qt='<img src="https://cdn-uploads.huggingface.co/production/uploads/632885ba1558dac67c440aa8/ZtFmphEhx8tcbEQqOolyE.png" alt="image/png"/>',Ye,oe,Nt=`This model was contributed by <a href="https://huggingface.co/stevenbucaille" rel="nofollow">stevenbucaille</a>.
The original code can be found <a href="https://github.com/magicleap/SuperPointPretrainedNetwork" rel="nofollow">here</a>.`,Ae,ne,Ke,se,Dt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with SuperPoint. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Oe,re,Ft='<li>A notebook showcasing inference and visualization with SuperPoint can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/SuperPoint/Inference_with_SuperPoint_to_detect_interest_points_in_an_image.ipynb" rel="nofollow">here</a>. 🌎</li>',et,ae,tt,C,ie,ut,we,Et=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a>. It is used to instantiate a
SuperPoint model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the SuperPoint
<a href="https://huggingface.co/magic-leap-community/superpoint" rel="nofollow">magic-leap-community/superpoint</a> architecture.`,ht,ve,Lt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,gt,k,ot,le,nt,w,ce,ft,Je,Xt="Constructs a SuperPoint image processor.",yt,V,pe,_t,Ce,Qt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> into lists of keypoints, scores and descriptors
with coordinates absolute to the original image sizes.`,bt,W,de,Mt,$e,Yt="Preprocess an image or batch of images.",Tt,B,me,wt,je,At="Resize an image.",st,ue,Kt="<li>preprocess</li> <li>post_process_keypoint_detection</li>",rt,he,at,v,ge,vt,Ue,Ot="SuperPoint model outputting keypoints and descriptors.",Jt,Pe,eo=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ct,Se,to=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,$t,U,fe,jt,Ie,oo='The <a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointForKeypointDetection">SuperPointForKeypointDetection</a> forward method, overrides the <code>__call__</code> special method.',Ut,R,Pt,Z,it,ye,no="<li>forward</li>",lt,_e,ct,ze,pt;return M=new Te({props:{title:"SuperPoint",local:"superpoint",headingTag:"h1"}}),H=new Te({props:{title:"Overview",local:"overview",headingTag:"h2"}}),L=new Te({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),Q=new xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBbW9kZWwlMjAlM0QlMjBTdXBlclBvaW50Rm9yS2V5cG9pbnREZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1hZ2ljLWxlYXAtY29tbXVuaXR5JTJGc3VwZXJwb2ludCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)`,wrap:!1}}),K=new xe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN1cGVyUG9pbnRGb3JLZXlwb2ludERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmxfaW1hZ2VfMSUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZV8xJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsX2ltYWdlXzElMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBdXJsX2ltYWdlXzIlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnRlc3Qtc3R1ZmYyMDE3JTJGMDAwMDAwMDAwNTY4LmpwZyUyMiUwQWltYWdlXzIlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmxfaW1hZ2VfMiUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZXMlMjAlM0QlMjAlNUJpbWFnZV8xJTJDJTIwaW1hZ2VfMiU1RCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWFnaWMtbGVhcC1jb21tdW5pdHklMkZzdXBlcnBvaW50JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3VwZXJQb2ludEZvcktleXBvaW50RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtYWdpYy1sZWFwLWNvbW11bml0eSUyRnN1cGVycG9pbnQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWltYWdlX3NpemVzJTIwJTNEJTIwJTVCKGltYWdlLmhlaWdodCUyQyUyMGltYWdlLndpZHRoKSUyMGZvciUyMGltYWdlJTIwaW4lMjBpbWFnZXMlNUQlMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19rZXlwb2ludF9kZXRlY3Rpb24ob3V0cHV0cyUyQyUyMGltYWdlX3NpemVzKSUwQSUwQWZvciUyMG91dHB1dCUyMGluJTIwb3V0cHV0cyUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGtleXBvaW50cyUyQyUyMHNjb3JlcyUyQyUyMGRlc2NyaXB0b3JzJTIwaW4lMjB6aXAob3V0cHV0JTVCJTIya2V5cG9pbnRzJTIyJTVEJTJDJTIwb3V0cHV0JTVCJTIyc2NvcmVzJTIyJTVEJTJDJTIwb3V0cHV0JTVCJTIyZGVzY3JpcHRvcnMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMktleXBvaW50cyUzQSUyMCU3QmtleXBvaW50cyU3RCUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyU2NvcmVzJTNBJTIwJTdCc2NvcmVzJTdEJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjJEZXNjcmlwdG9ycyUzQSUyMCU3QmRlc2NyaXB0b3JzJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SuperPointForKeypointDetection
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url_image_1 = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_1 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_1, stream=<span class="hljs-literal">True</span>).raw)
url_image_2 = <span class="hljs-string">&quot;http://images.cocodataset.org/test-stuff2017/000000000568.jpg&quot;</span>
image_2 = Image.<span class="hljs-built_in">open</span>(requests.get(url_image_2, stream=<span class="hljs-literal">True</span>).raw)

images = [image_1, image_2]

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)
model = SuperPointForKeypointDetection.from_pretrained(<span class="hljs-string">&quot;magic-leap-community/superpoint&quot;</span>)

inputs = processor(images, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model(**inputs)
image_sizes = [(image.height, image.width) <span class="hljs-keyword">for</span> image <span class="hljs-keyword">in</span> images]
outputs = processor.post_process_keypoint_detection(outputs, image_sizes)

<span class="hljs-keyword">for</span> output <span class="hljs-keyword">in</span> outputs:
    <span class="hljs-keyword">for</span> keypoints, scores, descriptors <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(output[<span class="hljs-string">&quot;keypoints&quot;</span>], output[<span class="hljs-string">&quot;scores&quot;</span>], output[<span class="hljs-string">&quot;descriptors&quot;</span>]):
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Keypoints: <span class="hljs-subst">{keypoints}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Scores: <span class="hljs-subst">{scores}</span>&quot;</span>)
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Descriptors: <span class="hljs-subst">{descriptors}</span>&quot;</span>)`,wrap:!1}}),ee=new xe({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQSUwQXBsdC5heGlzKCUyMm9mZiUyMiklMEFwbHQuaW1zaG93KGltYWdlXzEpJTBBcGx0LnNjYXR0ZXIoJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyU1QjAlNUQlNUIlMjJrZXlwb2ludHMlMjIlNUQlNUIlM0ElMkMlMjAwJTVEJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyU1QjAlNUQlNUIlMjJrZXlwb2ludHMlMjIlNUQlNUIlM0ElMkMlMjAxJTVEJTJDJTBBJTIwJTIwJTIwJTIwYyUzRG91dHB1dHMlNUIwJTVEJTVCJTIyc2NvcmVzJTIyJTVEJTIwKiUyMDEwMCUyQyUwQSUyMCUyMCUyMCUyMHMlM0RvdXRwdXRzJTVCMCU1RCU1QiUyMnNjb3JlcyUyMiU1RCUyMColMjA1MCUyQyUwQSUyMCUyMCUyMCUyMGFscGhhJTNEMC44JTBBKSUwQXBsdC5zYXZlZmlnKGYlMjJvdXRwdXRfaW1hZ2UucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt

plt.axis(<span class="hljs-string">&quot;off&quot;</span>)
plt.imshow(image_1)
plt.scatter(
    outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;keypoints&quot;</span>][:, <span class="hljs-number">0</span>],
    outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;keypoints&quot;</span>][:, <span class="hljs-number">1</span>],
    c=outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;scores&quot;</span>] * <span class="hljs-number">100</span>,
    s=outputs[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;scores&quot;</span>] * <span class="hljs-number">50</span>,
    alpha=<span class="hljs-number">0.8</span>
)
plt.savefig(<span class="hljs-string">f&quot;output_image.png&quot;</span>)`,wrap:!1}}),ne=new Te({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ae=new Te({props:{title:"SuperPointConfig",local:"transformers.SuperPointConfig",headingTag:"h2"}}),ie=new Me({props:{name:"class transformers.SuperPointConfig",anchor:"transformers.SuperPointConfig",parameters:[{name:"encoder_hidden_sizes",val:": typing.List[int] = [64, 64, 128, 128]"},{name:"decoder_hidden_size",val:": int = 256"},{name:"keypoint_decoder_dim",val:": int = 65"},{name:"descriptor_decoder_dim",val:": int = 256"},{name:"keypoint_threshold",val:": float = 0.005"},{name:"max_keypoints",val:": int = -1"},{name:"nms_radius",val:": int = 4"},{name:"border_removal_distance",val:": int = 4"},{name:"initializer_range",val:" = 0.02"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointConfig.encoder_hidden_sizes",description:`<strong>encoder_hidden_sizes</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[64, 64, 128, 128]</code>) &#x2014;
The number of channels in each convolutional layer in the encoder.`,name:"encoder_hidden_sizes"},{anchor:"transformers.SuperPointConfig.decoder_hidden_size",description:"<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The hidden size of the decoder.",name:"decoder_hidden_size"},{anchor:"transformers.SuperPointConfig.keypoint_decoder_dim",description:"<strong>keypoint_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 65) &#x2014; The output dimension of the keypoint decoder.",name:"keypoint_decoder_dim"},{anchor:"transformers.SuperPointConfig.descriptor_decoder_dim",description:"<strong>descriptor_decoder_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014; The output dimension of the descriptor decoder.",name:"descriptor_decoder_dim"},{anchor:"transformers.SuperPointConfig.keypoint_threshold",description:`<strong>keypoint_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.005) &#x2014;
The threshold to use for extracting keypoints.`,name:"keypoint_threshold"},{anchor:"transformers.SuperPointConfig.max_keypoints",description:`<strong>max_keypoints</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
The maximum number of keypoints to extract. If <code>-1</code>, will extract all keypoints.`,name:"max_keypoints"},{anchor:"transformers.SuperPointConfig.nms_radius",description:`<strong>nms_radius</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The radius for non-maximum suppression.`,name:"nms_radius"},{anchor:"transformers.SuperPointConfig.border_removal_distance",description:`<strong>border_removal_distance</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The distance from the border to remove keypoints.`,name:"border_removal_distance"},{anchor:"transformers.SuperPointConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/configuration_superpoint.py#L23"}}),k=new so({props:{anchor:"transformers.SuperPointConfig.example",$$slots:{default:[ho]},$$scope:{ctx:z}}}),le=new Te({props:{title:"SuperPointImageProcessor",local:"transformers.SuperPointImageProcessor",headingTag:"h2"}}),ce=new Me({props:{name:"class transformers.SuperPointImageProcessor",anchor:"transformers.SuperPointImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_grayscale",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden
by <code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 480, &quot;width&quot;: 640}</code>):
Resolution of the output image after <code>resize</code> is applied. Only has an effect if <code>do_resize</code> is set to
<code>True</code>. Can be overridden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to convert the image to grayscale. Can be overridden by <code>do_grayscale</code> in the <code>preprocess</code> method.`,name:"do_grayscale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L99"}}),pe=new Me({props:{name:"post_process_keypoint_detection",anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection",parameters:[{name:"outputs",val:": SuperPointKeypointDescriptionOutput"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]]"}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection.outputs",description:`<strong>outputs</strong> (<code>SuperPointKeypointDescriptionOutput</code>) &#x2014;
Raw outputs of the model containing keypoints in a relative (x, y) format, with scores and descriptors.`,name:"outputs"},{anchor:"transformers.SuperPointImageProcessor.post_process_keypoint_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. This must be the original
image size (before any processing).`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L292",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the keypoints in absolute format according
to target_sizes, scores and descriptors for an image in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),de=new Me({props:{name:"preprocess",anchor:"transformers.SuperPointImageProcessor.preprocess",parameters:[{name:"images",val:""},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_grayscale",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.SuperPointImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after <code>resize</code> has been applied. If <code>size[&quot;shortest_edge&quot;]</code> &gt;= 384, the image
is resized to <code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Otherwise, the smaller edge of the
image will be matched to <code>int(size[&quot;shortest_edge&quot;]/ crop_pct)</code>, after which the image is cropped to
<code>(size[&quot;shortest_edge&quot;], size[&quot;shortest_edge&quot;])</code>. Only has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.SuperPointImageProcessor.preprocess.do_grayscale",description:`<strong>do_grayscale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_grayscale</code>) &#x2014;
Whether to convert the image to grayscale.`,name:"do_grayscale"},{anchor:"transformers.SuperPointImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.SuperPointImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L180"}}),me=new Me({props:{name:"resize",anchor:"transformers.SuperPointImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SuperPointImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.SuperPointImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Dictionary of the form <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>, specifying the size of the output image.`,name:"size"},{anchor:"transformers.SuperPointImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the output image. If not provided, it will be inferred from the input
image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.SuperPointImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/image_processing_superpoint.py#L141"}}),he=new Te({props:{title:"SuperPointForKeypointDetection",local:"transformers.SuperPointForKeypointDetection",headingTag:"h2"}}),ge=new Me({props:{name:"class transformers.SuperPointForKeypointDetection",anchor:"transformers.SuperPointForKeypointDetection",parameters:[{name:"config",val:": SuperPointConfig"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointConfig">SuperPointConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L357"}}),fe=new Me({props:{name:"forward",anchor:"transformers.SuperPointForKeypointDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SuperPointForKeypointDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SuperPointForKeypointDetection.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.SuperPointForKeypointDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SuperPointForKeypointDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/superpoint/modeling_superpoint.py#L383",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.superpoint.modeling_superpoint.SuperPointKeypointDescriptionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/superpoint#transformers.SuperPointConfig"
>SuperPointConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>) — Loss computed during training.</li>
<li><strong>keypoints</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_keypoints, 2)</code>) — Relative (x, y) coordinates of predicted keypoints in a given image.</li>
<li><strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_keypoints)</code>) — Scores of predicted keypoints.</li>
<li><strong>descriptors</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_keypoints, descriptor_size)</code>) — Descriptors of predicted keypoints.</li>
<li><strong>mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_keypoints)</code>) — Mask indicating which values in keypoints, scores and descriptors are keypoint information.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or</li>
<li><strong>when</strong> <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.superpoint.modeling_superpoint.SuperPointKeypointDescriptionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new mo({props:{$$slots:{default:[go]},$$scope:{ctx:z}}}),Z=new so({props:{anchor:"transformers.SuperPointForKeypointDetection.forward.example",$$slots:{default:[fo]},$$scope:{ctx:z}}}),_e=new uo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/superpoint.md"}}),{c(){c=a("meta"),J=s(),b=a("p"),_=s(),m(M.$$.fragment),l=s(),T=a("div"),T.innerHTML=It,ke=s(),m(H.$$.fragment),Ve=s(),q=a("p"),q.innerHTML=zt,We=s(),N=a("p"),N.textContent=xt,Be=s(),D=a("p"),D.textContent=kt,Re=s(),F=a("p"),F.innerHTML=Vt,Ze=s(),x=a("img"),Ge=s(),E=a("small"),E.innerHTML=Bt,He=s(),m(L.$$.fragment),qe=s(),X=a("p"),X.textContent=Rt,Ne=s(),m(Q.$$.fragment),De=s(),Y=a("p"),Y.textContent=Zt,Fe=s(),A=a("p"),A.textContent=Gt,Ee=s(),m(K.$$.fragment),Le=s(),O=a("p"),O.textContent=Ht,Xe=s(),m(ee.$$.fragment),Qe=s(),te=a("p"),te.innerHTML=qt,Ye=s(),oe=a("p"),oe.innerHTML=Nt,Ae=s(),m(ne.$$.fragment),Ke=s(),se=a("p"),se.textContent=Dt,Oe=s(),re=a("ul"),re.innerHTML=Ft,et=s(),m(ae.$$.fragment),tt=s(),C=a("div"),m(ie.$$.fragment),ut=s(),we=a("p"),we.innerHTML=Et,ht=s(),ve=a("p"),ve.innerHTML=Lt,gt=s(),m(k.$$.fragment),ot=s(),m(le.$$.fragment),nt=s(),w=a("div"),m(ce.$$.fragment),ft=s(),Je=a("p"),Je.textContent=Xt,yt=s(),V=a("div"),m(pe.$$.fragment),_t=s(),Ce=a("p"),Ce.innerHTML=Qt,bt=s(),W=a("div"),m(de.$$.fragment),Mt=s(),$e=a("p"),$e.textContent=Yt,Tt=s(),B=a("div"),m(me.$$.fragment),wt=s(),je=a("p"),je.textContent=At,st=s(),ue=a("ul"),ue.innerHTML=Kt,rt=s(),m(he.$$.fragment),at=s(),v=a("div"),m(ge.$$.fragment),vt=s(),Ue=a("p"),Ue.textContent=Ot,Jt=s(),Pe=a("p"),Pe.innerHTML=eo,Ct=s(),Se=a("p"),Se.innerHTML=to,$t=s(),U=a("div"),m(fe.$$.fragment),jt=s(),Ie=a("p"),Ie.innerHTML=oo,Ut=s(),m(R.$$.fragment),Pt=s(),m(Z.$$.fragment),it=s(),ye=a("ul"),ye.innerHTML=no,lt=s(),m(_e.$$.fragment),ct=s(),ze=a("p"),this.h()},l(e){const t=po("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(o),J=r(e),b=i(e,"P",{}),I(b).forEach(o),_=r(e),u(M.$$.fragment,e),l=r(e),T=i(e,"DIV",{class:!0,"data-svelte-h":!0}),d(T)!=="svelte-13t8s2t"&&(T.innerHTML=It),ke=r(e),u(H.$$.fragment,e),Ve=r(e),q=i(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-3y1k2h"&&(q.innerHTML=zt),We=r(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-113tmz"&&(N.textContent=xt),Be=r(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-vfdo9a"&&(D.textContent=kt),Re=r(e),F=i(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-110fra1"&&(F.innerHTML=Vt),Ze=r(e),x=i(e,"IMG",{src:!0,alt:!0,width:!0}),Ge=r(e),E=i(e,"SMALL",{"data-svelte-h":!0}),d(E)!=="svelte-1md4ofy"&&(E.innerHTML=Bt),He=r(e),u(L.$$.fragment,e),qe=r(e),X=i(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-u2cob9"&&(X.textContent=Rt),Ne=r(e),u(Q.$$.fragment,e),De=r(e),Y=i(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-qs9qlh"&&(Y.textContent=Zt),Fe=r(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-g88i9e"&&(A.textContent=Gt),Ee=r(e),u(K.$$.fragment,e),Le=r(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1ak0l5f"&&(O.textContent=Ht),Xe=r(e),u(ee.$$.fragment,e),Qe=r(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-oxei2o"&&(te.innerHTML=qt),Ye=r(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1s32sqj"&&(oe.innerHTML=Nt),Ae=r(e),u(ne.$$.fragment,e),Ke=r(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1tjytfm"&&(se.textContent=Dt),Oe=r(e),re=i(e,"UL",{"data-svelte-h":!0}),d(re)!=="svelte-1w6ygh7"&&(re.innerHTML=Ft),et=r(e),u(ae.$$.fragment,e),tt=r(e),C=i(e,"DIV",{class:!0});var P=I(C);u(ie.$$.fragment,P),ut=r(P),we=i(P,"P",{"data-svelte-h":!0}),d(we)!=="svelte-rmywrk"&&(we.innerHTML=Et),ht=r(P),ve=i(P,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-o55m63"&&(ve.innerHTML=Lt),gt=r(P),u(k.$$.fragment,P),P.forEach(o),ot=r(e),u(le.$$.fragment,e),nt=r(e),w=i(e,"DIV",{class:!0});var $=I(w);u(ce.$$.fragment,$),ft=r($),Je=i($,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-bn94yj"&&(Je.textContent=Xt),yt=r($),V=i($,"DIV",{class:!0});var be=I(V);u(pe.$$.fragment,be),_t=r(be),Ce=i(be,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-14d1kg5"&&(Ce.innerHTML=Qt),be.forEach(o),bt=r($),W=i($,"DIV",{class:!0});var dt=I(W);u(de.$$.fragment,dt),Mt=r(dt),$e=i(dt,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1x3yxsa"&&($e.textContent=Yt),dt.forEach(o),Tt=r($),B=i($,"DIV",{class:!0});var mt=I(B);u(me.$$.fragment,mt),wt=r(mt),je=i(mt,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1eb2h1k"&&(je.textContent=At),mt.forEach(o),$.forEach(o),st=r(e),ue=i(e,"UL",{"data-svelte-h":!0}),d(ue)!=="svelte-166rkny"&&(ue.innerHTML=Kt),rt=r(e),u(he.$$.fragment,e),at=r(e),v=i(e,"DIV",{class:!0});var S=I(v);u(ge.$$.fragment,S),vt=r(S),Ue=i(S,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-i59ede"&&(Ue.textContent=Ot),Jt=r(S),Pe=i(S,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-6pahdo"&&(Pe.innerHTML=eo),Ct=r(S),Se=i(S,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-hswkmf"&&(Se.innerHTML=to),$t=r(S),U=i(S,"DIV",{class:!0});var G=I(U);u(fe.$$.fragment,G),jt=r(G),Ie=i(G,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1kya80i"&&(Ie.innerHTML=oo),Ut=r(G),u(R.$$.fragment,G),Pt=r(G),u(Z.$$.fragment,G),G.forEach(o),S.forEach(o),it=r(e),ye=i(e,"UL",{"data-svelte-h":!0}),d(ye)!=="svelte-n3ow4o"&&(ye.innerHTML=no),lt=r(e),u(_e.$$.fragment,e),ct=r(e),ze=i(e,"P",{}),I(ze).forEach(o),this.h()},h(){j(c,"name","hf:doc:metadata"),j(c,"content",_o),j(T,"class","flex flex-wrap space-x-1"),ao(x.src,Wt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/superpoint_architecture.png")||j(x,"src",Wt),j(x,"alt","drawing"),j(x,"width","500"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){p(document.head,c),n(e,J,t),n(e,b,t),n(e,_,t),h(M,e,t),n(e,l,t),n(e,T,t),n(e,ke,t),h(H,e,t),n(e,Ve,t),n(e,q,t),n(e,We,t),n(e,N,t),n(e,Be,t),n(e,D,t),n(e,Re,t),n(e,F,t),n(e,Ze,t),n(e,x,t),n(e,Ge,t),n(e,E,t),n(e,He,t),h(L,e,t),n(e,qe,t),n(e,X,t),n(e,Ne,t),h(Q,e,t),n(e,De,t),n(e,Y,t),n(e,Fe,t),n(e,A,t),n(e,Ee,t),h(K,e,t),n(e,Le,t),n(e,O,t),n(e,Xe,t),h(ee,e,t),n(e,Qe,t),n(e,te,t),n(e,Ye,t),n(e,oe,t),n(e,Ae,t),h(ne,e,t),n(e,Ke,t),n(e,se,t),n(e,Oe,t),n(e,re,t),n(e,et,t),h(ae,e,t),n(e,tt,t),n(e,C,t),h(ie,C,null),p(C,ut),p(C,we),p(C,ht),p(C,ve),p(C,gt),h(k,C,null),n(e,ot,t),h(le,e,t),n(e,nt,t),n(e,w,t),h(ce,w,null),p(w,ft),p(w,Je),p(w,yt),p(w,V),h(pe,V,null),p(V,_t),p(V,Ce),p(w,bt),p(w,W),h(de,W,null),p(W,Mt),p(W,$e),p(w,Tt),p(w,B),h(me,B,null),p(B,wt),p(B,je),n(e,st,t),n(e,ue,t),n(e,rt,t),h(he,e,t),n(e,at,t),n(e,v,t),h(ge,v,null),p(v,vt),p(v,Ue),p(v,Jt),p(v,Pe),p(v,Ct),p(v,Se),p(v,$t),p(v,U),h(fe,U,null),p(U,jt),p(U,Ie),p(U,Ut),h(R,U,null),p(U,Pt),h(Z,U,null),n(e,it,t),n(e,ye,t),n(e,lt,t),h(_e,e,t),n(e,ct,t),n(e,ze,t),pt=!0},p(e,[t]){const P={};t&2&&(P.$$scope={dirty:t,ctx:e}),k.$set(P);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),R.$set($);const be={};t&2&&(be.$$scope={dirty:t,ctx:e}),Z.$set(be)},i(e){pt||(g(M.$$.fragment,e),g(H.$$.fragment,e),g(L.$$.fragment,e),g(Q.$$.fragment,e),g(K.$$.fragment,e),g(ee.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(k.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(pe.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(he.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(R.$$.fragment,e),g(Z.$$.fragment,e),g(_e.$$.fragment,e),pt=!0)},o(e){f(M.$$.fragment,e),f(H.$$.fragment,e),f(L.$$.fragment,e),f(Q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(k.$$.fragment,e),f(le.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(fe.$$.fragment,e),f(R.$$.fragment,e),f(Z.$$.fragment,e),f(_e.$$.fragment,e),pt=!1},d(e){e&&(o(J),o(b),o(_),o(l),o(T),o(ke),o(Ve),o(q),o(We),o(N),o(Be),o(D),o(Re),o(F),o(Ze),o(x),o(Ge),o(E),o(He),o(qe),o(X),o(Ne),o(De),o(Y),o(Fe),o(A),o(Ee),o(Le),o(O),o(Xe),o(Qe),o(te),o(Ye),o(oe),o(Ae),o(Ke),o(se),o(Oe),o(re),o(et),o(tt),o(C),o(ot),o(nt),o(w),o(st),o(ue),o(rt),o(at),o(v),o(it),o(ye),o(lt),o(ct),o(ze)),o(c),y(M,e),y(H,e),y(L,e),y(Q,e),y(K,e),y(ee,e),y(ne,e),y(ae,e),y(ie),y(k),y(le,e),y(ce),y(pe),y(de),y(me),y(he,e),y(ge),y(fe),y(R),y(Z),y(_e,e)}}}const _o='{"title":"SuperPoint","local":"superpoint","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SuperPointConfig","local":"transformers.SuperPointConfig","sections":[],"depth":2},{"title":"SuperPointImageProcessor","local":"transformers.SuperPointImageProcessor","sections":[],"depth":2},{"title":"SuperPointForKeypointDetection","local":"transformers.SuperPointForKeypointDetection","sections":[],"depth":2}],"depth":1}';function bo(z){return io(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Uo extends lo{constructor(c){super(),co(this,c,bo,yo,ro,{})}}export{Uo as component};
