import{s as ot,o as st,n as P}from"../chunks/scheduler.18a86fab.js";import{S as at,i as rt,g as u,s as l,r as _,A as it,h as g,f as r,c as d,j as pe,x as v,u as w,k as me,l as lt,y as m,a as h,v as b,d as M,t as T,w as y}from"../chunks/index.98837b22.js";import{T as xe}from"../chunks/Tip.77304350.js";import{D as Te}from"../chunks/Docstring.6758ea23.js";import{C as ze}from"../chunks/CodeBlock.8d0c2e8a.js";import{F as dt,M as nt}from"../chunks/Markdown.ae01904b.js";import{E as Ye}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Ne}from"../chunks/Heading.7e7e0c5b.js";import{H as ct,a as tt}from"../chunks/HfOption.6641485e.js";import{E as pt}from"../chunks/index.92f616ba.js";function mt($){let e,a="Click on the Swin Transformer models in the right sidebar for more examples of how to apply Swin Transformer to different image tasks.";return{c(){e=u("p"),e.textContent=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-2zpy2i"&&(e.textContent=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function ht($){let e,a;return e=new ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRDAlMEEpJTBBcGlwZWxpbmUoaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipeline = pipeline(
    task=<span class="hljs-string">&quot;image-classification&quot;</span>,
    model=<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>,
    torch_dtype=torch.float16,
    device=<span class="hljs-number">0</span>
)
pipeline(images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>)`,wrap:!1}}),{c(){_(e.$$.fragment)},l(t){w(e.$$.fragment,t)},m(t,o){b(e,t,o),a=!0},p:P,i(t){a||(M(e.$$.fragment,t),a=!0)},o(t){T(e.$$.fragment,t),a=!1},d(t){y(e,t)}}}function ft($){let e,a;return e=new ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTJDJTIwQXV0b0ltYWdlUHJvY2Vzc29yJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2Zhc3QlM0RUcnVlJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oJTIyY3VkYSUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9jbGFzc19pZCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoZGltJTNELTEpLml0ZW0oKSUwQSUwQWNsYXNzX2xhYmVscyUyMCUzRCUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCUwQXByZWRpY3RlZF9jbGFzc19sYWJlbCUyMCUzRCUyMGNsYXNzX2xhYmVscyU1QnByZWRpY3RlZF9jbGFzc19pZCU1RCUwQXByaW50KGYlMjJUaGUlMjBwcmVkaWN0ZWQlMjBjbGFzcyUyMGxhYmVsJTIwaXMlM0ElMjAlN0JwcmVkaWN0ZWRfY2xhc3NfbGFiZWwlN0QlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification, AutoImageProcessor

image_processor = AutoImageProcessor.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>,
    use_fast=<span class="hljs-literal">True</span>,
)
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">with</span> torch.no_grad():
  logits = model(**inputs).logits
predicted_class_id = logits.argmax(dim=-<span class="hljs-number">1</span>).item()

class_labels = model.config.id2label
predicted_class_label = class_labels[predicted_class_id]
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The predicted class label is: <span class="hljs-subst">{predicted_class_label}</span>&quot;</span>)`,wrap:!1}}),{c(){_(e.$$.fragment)},l(t){w(e.$$.fragment,t)},m(t,o){b(e,t,o),a=!0},p:P,i(t){a||(M(e.$$.fragment,t),a=!0)},o(t){T(e.$$.fragment,t),a=!1},d(t){y(e,t)}}}function ut($){let e,a,t,o;return e=new tt({props:{id:"usage",option:"Pipeline",$$slots:{default:[ht]},$$scope:{ctx:$}}}),t=new tt({props:{id:"usage",option:"AutoModel",$$slots:{default:[ft]},$$scope:{ctx:$}}}),{c(){_(e.$$.fragment),a=l(),_(t.$$.fragment)},l(i){w(e.$$.fragment,i),a=d(i),w(t.$$.fragment,i)},m(i,n){b(e,i,n),h(i,a,n),b(t,i,n),o=!0},p(i,n){const F={};n&2&&(F.$$scope={dirty:n,ctx:i}),e.$set(F);const H={};n&2&&(H.$$scope={dirty:n,ctx:i}),t.$set(H)},i(i){o||(M(e.$$.fragment,i),M(t.$$.fragment,i),o=!0)},o(i){T(e.$$.fragment,i),T(t.$$.fragment,i),o=!1},d(i){i&&r(a),y(e,i),y(t,i)}}}function gt($){let e,a="Example:",t,o,i;return o=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW5Db25maWclMkMlMjBTd2luTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwU3dpbiUyMG1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3dpbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTd2luTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SwinConfig, SwinModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Swin microsoft/swin-tiny-patch4-window7-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SwinConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the microsoft/swin-tiny-patch4-window7-224 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){e=u("p"),e.textContent=a,t=l(),_(o.$$.fragment)},l(n){e=g(n,"P",{"data-svelte-h":!0}),v(e)!=="svelte-11lpom8"&&(e.textContent=a),t=d(n),w(o.$$.fragment,n)},m(n,F){h(n,e,F),h(n,t,F),b(o,n,F),i=!0},p:P,i(n){i||(M(o.$$.fragment,n),i=!0)},o(n){T(o.$$.fragment,n),i=!1},d(n){n&&(r(e),r(t)),y(o,n)}}}function _t($){let e,a=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-fincs2"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function wt($){let e,a="Example:",t,o,i;return o=new ze({props:{code:"",highlighted:"",wrap:!1}}),{c(){e=u("p"),e.textContent=a,t=l(),_(o.$$.fragment)},l(n){e=g(n,"P",{"data-svelte-h":!0}),v(e)!=="svelte-11lpom8"&&(e.textContent=a),t=d(n),w(o.$$.fragment,n)},m(n,F){h(n,e,F),h(n,t,F),b(o,n,F),i=!0},p:P,i(n){i||(M(o.$$.fragment,n),i=!0)},o(n){T(o.$$.fragment,n),i=!1},d(n){n&&(r(e),r(t)),y(o,n)}}}function bt($){let e,a=`Note that we provide a script to pre-train this model on custom data in our <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-pretraining" rel="nofollow">examples
directory</a>.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-7i3y9o"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function Mt($){let e,a=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-fincs2"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function Tt($){let e,a="Examples:",t,o,i;return o=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tYmFzZS1zaW1taW0td2luZG93Ni0xOTIlMjIpJTBBbW9kZWwlMjAlM0QlMjBTd2luRm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi1iYXNlLXNpbW1pbS13aW5kb3c2LTE5MiUyMiklMEElMEFudW1fcGF0Y2hlcyUyMCUzRCUyMChtb2RlbC5jb25maWcuaW1hZ2Vfc2l6ZSUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy5wYXRjaF9zaXplKSUyMCoqJTIwMiUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQSUyMyUyMGNyZWF0ZSUyMHJhbmRvbSUyMGJvb2xlYW4lMjBtYXNrJTIwb2YlMjBzaGFwZSUyMChiYXRjaF9zaXplJTJDJTIwbnVtX3BhdGNoZXMpJTBBYm9vbF9tYXNrZWRfcG9zJTIwJTNEJTIwdG9yY2gucmFuZGludChsb3clM0QwJTJDJTIwaGlnaCUzRDIlMkMlMjBzaXplJTNEKDElMkMlMjBudW1fcGF0Y2hlcykpLmJvb2woKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwaXhlbF92YWx1ZXMlMkMlMjBib29sX21hc2tlZF9wb3MlM0Rib29sX21hc2tlZF9wb3MpJTBBbG9zcyUyQyUyMHJlY29uc3RydWN0ZWRfcGl4ZWxfdmFsdWVzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5yZWNvbnN0cnVjdGlvbiUwQWxpc3QocmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-base-simmim-window6-192&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-base-simmim-window6-192&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">192</span>, <span class="hljs-number">192</span>]`,wrap:!1}}),{c(){e=u("p"),e.textContent=a,t=l(),_(o.$$.fragment)},l(n){e=g(n,"P",{"data-svelte-h":!0}),v(e)!=="svelte-kvfsh7"&&(e.textContent=a),t=d(n),w(o.$$.fragment,n)},m(n,F){h(n,e,F),h(n,t,F),b(o,n,F),i=!0},p:P,i(n){i||(M(o.$$.fragment,n),i=!0)},o(n){T(o.$$.fragment,n),i=!1},d(n){n&&(r(e),r(t)),y(o,n)}}}function yt($){let e,a=`Note that it’s possible to fine-tune Swin on higher resolution images than the ones it has been trained on, by
setting <code>interpolate_pos_encoding</code> to <code>True</code> in the forward of the model. This will interpolate the pre-trained
position embeddings to the higher resolution.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-1hy0g8b"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function $t($){let e,a=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-fincs2"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function vt($){let e,a="Example:",t,o,i;return o=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwU3dpbkZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, SwinForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SwinForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
...`,wrap:!1}}),{c(){e=u("p"),e.textContent=a,t=l(),_(o.$$.fragment)},l(n){e=g(n,"P",{"data-svelte-h":!0}),v(e)!=="svelte-11lpom8"&&(e.textContent=a),t=d(n),w(o.$$.fragment,n)},m(n,F){h(n,e,F),h(n,t,F),b(o,n,F),i=!0},p:P,i(n){i||(M(o.$$.fragment,n),i=!0)},o(n){T(o.$$.fragment,n),i=!1},d(n){n&&(r(e),r(t)),y(o,n)}}}function Ft($){let e,a,t,o,i,n,F="The bare Swin Model outputting raw hidden-states without any specific head on top.",H,x,Q=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ue,L,_e=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,We,W,B,A,X,we='The <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinModel">SwinModel</a> forward method, overrides the <code>__call__</code> special method.',be,S,O,R,K,E,ve,J,z,ye,U,Me='Swin Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.',Fe,N,Ze,V,he=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,fe,oe,Z=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ee,I,Y,ue,se,ae='The <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',je,s,f,C,ke,D,Ie,G,te,Re,re,Xe=`Swin Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,p,j,ie,ne,ge=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,le,q,Qe=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ee,$e,Ve,qe,He,De='The <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Pe,Ge,Ae,Be,Le;return e=new Ne({props:{title:"SwinModel",local:"transformers.SwinModel",headingTag:"h2"}}),o=new Te({props:{name:"class transformers.SwinModel",anchor:"transformers.SwinModel",parameters:[{name:"config",val:""},{name:"add_pooling_layer",val:" = True"},{name:"use_mask_token",val:" = False"}],parametersDescription:[{anchor:"transformers.SwinModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinModel">SwinModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.SwinModel.add_pooling_layer",description:`<strong>add_pooling_layer</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply pooling layer.`,name:"add_pooling_layer"},{anchor:"transformers.SwinModel.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create and apply mask tokens in the embedding layer.`,name:"use_mask_token"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_swin.py#L931"}}),B=new Te({props:{name:"forward",anchor:"transformers.SwinModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SwinModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.SwinModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.SwinModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_swin.py#L965",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_swin.SwinModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_swin.SwinModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),S=new xe({props:{$$slots:{default:[_t]},$$scope:{ctx:$}}}),R=new Ye({props:{anchor:"transformers.SwinModel.forward.example",$$slots:{default:[wt]},$$scope:{ctx:$}}}),E=new Ne({props:{title:"SwinForMaskedImageModeling",local:"transformers.SwinForMaskedImageModeling",headingTag:"h2"}}),z=new Te({props:{name:"class transformers.SwinForMaskedImageModeling",anchor:"transformers.SwinForMaskedImageModeling",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SwinForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinForMaskedImageModeling">SwinForMaskedImageModeling</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_swin.py#L1031"}}),N=new xe({props:{$$slots:{default:[bt]},$$scope:{ctx:$}}}),Y=new Te({props:{name:"forward",anchor:"transformers.SwinForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SwinForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.SwinForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinForMaskedImageModeling.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.SwinForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_swin.py#L1060",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_swin.SwinMaskedImageModelingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Masked image modeling (MLM) loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed pixel values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_swin.SwinMaskedImageModelingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),s=new xe({props:{$$slots:{default:[Mt]},$$scope:{ctx:$}}}),C=new Ye({props:{anchor:"transformers.SwinForMaskedImageModeling.forward.example",$$slots:{default:[Tt]},$$scope:{ctx:$}}}),D=new Ne({props:{title:"SwinForImageClassification",local:"transformers.SwinForImageClassification",headingTag:"h2"}}),te=new Te({props:{name:"class transformers.SwinForImageClassification",anchor:"transformers.SwinForImageClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SwinForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinForImageClassification">SwinForImageClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_swin.py#L1146"}}),j=new xe({props:{$$slots:{default:[yt]},$$scope:{ctx:$}}}),Ve=new Te({props:{name:"forward",anchor:"transformers.SwinForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SwinForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.SwinForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SwinForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.SwinForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SwinForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SwinForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.SwinForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_swin.py#L1175",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_swin.SwinImageClassifierOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_swin.SwinImageClassifierOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ge=new xe({props:{$$slots:{default:[$t]},$$scope:{ctx:$}}}),Be=new Ye({props:{anchor:"transformers.SwinForImageClassification.forward.example",$$slots:{default:[vt]},$$scope:{ctx:$}}}),{c(){_(e.$$.fragment),a=l(),t=u("div"),_(o.$$.fragment),i=l(),n=u("p"),n.textContent=F,H=l(),x=u("p"),x.innerHTML=Q,Ue=l(),L=u("p"),L.innerHTML=_e,We=l(),W=u("div"),_(B.$$.fragment),A=l(),X=u("p"),X.innerHTML=we,be=l(),_(S.$$.fragment),O=l(),_(R.$$.fragment),K=l(),_(E.$$.fragment),ve=l(),J=u("div"),_(z.$$.fragment),ye=l(),U=u("p"),U.innerHTML=Me,Fe=l(),_(N.$$.fragment),Ze=l(),V=u("p"),V.innerHTML=he,fe=l(),oe=u("p"),oe.innerHTML=Z,ee=l(),I=u("div"),_(Y.$$.fragment),ue=l(),se=u("p"),se.innerHTML=ae,je=l(),_(s.$$.fragment),f=l(),_(C.$$.fragment),ke=l(),_(D.$$.fragment),Ie=l(),G=u("div"),_(te.$$.fragment),Re=l(),re=u("p"),re.textContent=Xe,p=l(),_(j.$$.fragment),ie=l(),ne=u("p"),ne.innerHTML=ge,le=l(),q=u("p"),q.innerHTML=Qe,Ee=l(),$e=u("div"),_(Ve.$$.fragment),qe=l(),He=u("p"),He.innerHTML=De,Pe=l(),_(Ge.$$.fragment),Ae=l(),_(Be.$$.fragment),this.h()},l(c){w(e.$$.fragment,c),a=d(c),t=g(c,"DIV",{class:!0});var k=pe(t);w(o.$$.fragment,k),i=d(k),n=g(k,"P",{"data-svelte-h":!0}),v(n)!=="svelte-1avvk8t"&&(n.textContent=F),H=d(k),x=g(k,"P",{"data-svelte-h":!0}),v(x)!=="svelte-6pahdo"&&(x.innerHTML=Q),Ue=d(k),L=g(k,"P",{"data-svelte-h":!0}),v(L)!=="svelte-hswkmf"&&(L.innerHTML=_e),We=d(k),W=g(k,"DIV",{class:!0});var Je=pe(W);w(B.$$.fragment,Je),A=d(Je),X=g(Je,"P",{"data-svelte-h":!0}),v(X)!=="svelte-1bw2bgg"&&(X.innerHTML=we),be=d(Je),w(S.$$.fragment,Je),O=d(Je),w(R.$$.fragment,Je),Je.forEach(r),k.forEach(r),K=d(c),w(E.$$.fragment,c),ve=d(c),J=g(c,"DIV",{class:!0});var de=pe(J);w(z.$$.fragment,de),ye=d(de),U=g(de,"P",{"data-svelte-h":!0}),v(U)!=="svelte-12jqo2k"&&(U.innerHTML=Me),Fe=d(de),w(N.$$.fragment,de),Ze=d(de),V=g(de,"P",{"data-svelte-h":!0}),v(V)!=="svelte-6pahdo"&&(V.innerHTML=he),fe=d(de),oe=g(de,"P",{"data-svelte-h":!0}),v(oe)!=="svelte-hswkmf"&&(oe.innerHTML=Z),ee=d(de),I=g(de,"DIV",{class:!0});var Se=pe(I);w(Y.$$.fragment,Se),ue=d(Se),se=g(Se,"P",{"data-svelte-h":!0}),v(se)!=="svelte-ezmbs2"&&(se.innerHTML=ae),je=d(Se),w(s.$$.fragment,Se),f=d(Se),w(C.$$.fragment,Se),Se.forEach(r),de.forEach(r),ke=d(c),w(D.$$.fragment,c),Ie=d(c),G=g(c,"DIV",{class:!0});var ce=pe(G);w(te.$$.fragment,ce),Re=d(ce),re=g(ce,"P",{"data-svelte-h":!0}),v(re)!=="svelte-k64ai4"&&(re.textContent=Xe),p=d(ce),w(j.$$.fragment,ce),ie=d(ce),ne=g(ce,"P",{"data-svelte-h":!0}),v(ne)!=="svelte-6pahdo"&&(ne.innerHTML=ge),le=d(ce),q=g(ce,"P",{"data-svelte-h":!0}),v(q)!=="svelte-hswkmf"&&(q.innerHTML=Qe),Ee=d(ce),$e=g(ce,"DIV",{class:!0});var Ce=pe($e);w(Ve.$$.fragment,Ce),qe=d(Ce),He=g(Ce,"P",{"data-svelte-h":!0}),v(He)!=="svelte-1a1l9va"&&(He.innerHTML=De),Pe=d(Ce),w(Ge.$$.fragment,Ce),Ae=d(Ce),w(Be.$$.fragment,Ce),Ce.forEach(r),ce.forEach(r),this.h()},h(){me(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(c,k){b(e,c,k),h(c,a,k),h(c,t,k),b(o,t,null),m(t,i),m(t,n),m(t,H),m(t,x),m(t,Ue),m(t,L),m(t,We),m(t,W),b(B,W,null),m(W,A),m(W,X),m(W,be),b(S,W,null),m(W,O),b(R,W,null),h(c,K,k),b(E,c,k),h(c,ve,k),h(c,J,k),b(z,J,null),m(J,ye),m(J,U),m(J,Fe),b(N,J,null),m(J,Ze),m(J,V),m(J,fe),m(J,oe),m(J,ee),m(J,I),b(Y,I,null),m(I,ue),m(I,se),m(I,je),b(s,I,null),m(I,f),b(C,I,null),h(c,ke,k),b(D,c,k),h(c,Ie,k),h(c,G,k),b(te,G,null),m(G,Re),m(G,re),m(G,p),b(j,G,null),m(G,ie),m(G,ne),m(G,le),m(G,q),m(G,Ee),m(G,$e),b(Ve,$e,null),m($e,qe),m($e,He),m($e,Pe),b(Ge,$e,null),m($e,Ae),b(Be,$e,null),Le=!0},p(c,k){const Je={};k&2&&(Je.$$scope={dirty:k,ctx:c}),S.$set(Je);const de={};k&2&&(de.$$scope={dirty:k,ctx:c}),R.$set(de);const Se={};k&2&&(Se.$$scope={dirty:k,ctx:c}),N.$set(Se);const ce={};k&2&&(ce.$$scope={dirty:k,ctx:c}),s.$set(ce);const Ce={};k&2&&(Ce.$$scope={dirty:k,ctx:c}),C.$set(Ce);const Oe={};k&2&&(Oe.$$scope={dirty:k,ctx:c}),j.$set(Oe);const Ke={};k&2&&(Ke.$$scope={dirty:k,ctx:c}),Ge.$set(Ke);const et={};k&2&&(et.$$scope={dirty:k,ctx:c}),Be.$set(et)},i(c){Le||(M(e.$$.fragment,c),M(o.$$.fragment,c),M(B.$$.fragment,c),M(S.$$.fragment,c),M(R.$$.fragment,c),M(E.$$.fragment,c),M(z.$$.fragment,c),M(N.$$.fragment,c),M(Y.$$.fragment,c),M(s.$$.fragment,c),M(C.$$.fragment,c),M(D.$$.fragment,c),M(te.$$.fragment,c),M(j.$$.fragment,c),M(Ve.$$.fragment,c),M(Ge.$$.fragment,c),M(Be.$$.fragment,c),Le=!0)},o(c){T(e.$$.fragment,c),T(o.$$.fragment,c),T(B.$$.fragment,c),T(S.$$.fragment,c),T(R.$$.fragment,c),T(E.$$.fragment,c),T(z.$$.fragment,c),T(N.$$.fragment,c),T(Y.$$.fragment,c),T(s.$$.fragment,c),T(C.$$.fragment,c),T(D.$$.fragment,c),T(te.$$.fragment,c),T(j.$$.fragment,c),T(Ve.$$.fragment,c),T(Ge.$$.fragment,c),T(Be.$$.fragment,c),Le=!1},d(c){c&&(r(a),r(t),r(K),r(ve),r(J),r(ke),r(Ie),r(G)),y(e,c),y(o),y(B),y(S),y(R),y(E,c),y(z),y(N),y(Y),y(s),y(C),y(D,c),y(te),y(j),y(Ve),y(Ge),y(Be)}}}function jt($){let e,a;return e=new nt({props:{$$slots:{default:[Ft]},$$scope:{ctx:$}}}),{c(){_(e.$$.fragment)},l(t){w(e.$$.fragment,t)},m(t,o){b(e,t,o),a=!0},p(t,o){const i={};o&2&&(i.$$scope={dirty:o,ctx:t}),e.$set(i)},i(t){a||(M(e.$$.fragment,t),a=!0)},o(t){T(e.$$.fragment,t),a=!1},d(t){y(e,t)}}}function kt($){let e,a=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-fincs2"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function Jt($){let e,a="Example:",t,o,i;return o=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbk1vZGVsJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGU3dpbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinModel.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">49</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){e=u("p"),e.textContent=a,t=l(),_(o.$$.fragment)},l(n){e=g(n,"P",{"data-svelte-h":!0}),v(e)!=="svelte-11lpom8"&&(e.textContent=a),t=d(n),w(o.$$.fragment,n)},m(n,F){h(n,e,F),h(n,t,F),b(o,n,F),i=!0},p:P,i(n){i||(M(o.$$.fragment,n),i=!0)},o(n){T(o.$$.fragment,n),i=!1},d(n){n&&(r(e),r(t)),y(o,n)}}}function St($){let e,a=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-fincs2"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function Ct($){let e,a="Examples:",t,o,i;return o=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbkZvck1hc2tlZEltYWdlTW9kZWxpbmclMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGc3dpbi10aW55LXBhdGNoNC13aW5kb3c3LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFRGU3dpbkZvck1hc2tlZEltYWdlTW9kZWxpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRmLnJhbmRvbS51bmlmb3JtKCgxJTJDJTIwbnVtX3BhdGNoZXMpKSUyMCUzRSUzRCUyMDAuNSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwaXhlbF92YWx1ZXMlMkMlMjBib29sX21hc2tlZF9wb3MlM0Rib29sX21hc2tlZF9wb3MpJTBBbG9zcyUyQyUyMHJlY29uc3RydWN0ZWRfcGl4ZWxfdmFsdWVzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5yZWNvbnN0cnVjdGlvbiUwQWxpc3QocmVjb25zdHJ1Y3RlZF9waXhlbF92YWx1ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = tf.random.uniform((<span class="hljs-number">1</span>, num_patches)) &gt;= <span class="hljs-number">0.5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, reconstructed_pixel_values = outputs.loss, outputs.reconstruction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(reconstructed_pixel_values.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>]`,wrap:!1}}),{c(){e=u("p"),e.textContent=a,t=l(),_(o.$$.fragment)},l(n){e=g(n,"P",{"data-svelte-h":!0}),v(e)!=="svelte-kvfsh7"&&(e.textContent=a),t=d(n),w(o.$$.fragment,n)},m(n,F){h(n,e,F),h(n,t,F),b(o,n,F),i=!0},p:P,i(n){i||(M(o.$$.fragment,n),i=!0)},o(n){T(o.$$.fragment,n),i=!1},d(n){n&&(r(e),r(t)),y(o,n)}}}function Ut($){let e,a=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){e=u("p"),e.innerHTML=a},l(t){e=g(t,"P",{"data-svelte-h":!0}),v(e)!=="svelte-fincs2"&&(e.innerHTML=a)},m(t,o){h(t,e,o)},p:P,d(t){t&&r(e)}}}function Wt($){let e,a="Example:",t,o,i;return o=new ze({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFRGU3dpbkZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFpbXBvcnQlMjB0ZW5zb3JmbG93JTIwYXMlMjB0ZiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRnN3aW4tdGlueS1wYXRjaDQtd2luZG93Ny0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBURlN3aW5Gb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZzd2luLXRpbnktcGF0Y2g0LXdpbmRvdzctMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQSUyMyUyMG1vZGVsJTIwcHJlZGljdHMlMjBvbmUlMjBvZiUyMHRoZSUyMDEwMDAlMjBJbWFnZU5ldCUyMGNsYXNzZXMlMEFwcmVkaWN0ZWRfbGFiZWwlMjAlM0QlMjBpbnQodGYubWF0aC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSklMEFwcmludChtb2RlbC5jb25maWcuaWQybGFiZWwlNUJwcmVkaWN0ZWRfbGFiZWwlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TFSwinForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFSwinForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/swin-tiny-patch4-window7-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){e=u("p"),e.textContent=a,t=l(),_(o.$$.fragment)},l(n){e=g(n,"P",{"data-svelte-h":!0}),v(e)!=="svelte-11lpom8"&&(e.textContent=a),t=d(n),w(o.$$.fragment,n)},m(n,F){h(n,e,F),h(n,t,F),b(o,n,F),i=!0},p:P,i(n){i||(M(o.$$.fragment,n),i=!0)},o(n){T(o.$$.fragment,n),i=!1},d(n){n&&(r(e),r(t)),y(o,n)}}}function Zt($){let e,a,t,o,i,n,F=`The bare Swin Model transformer outputting raw hidden-states without any specific head on top.
This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,H,x,Q,Ue,L,_e='The <a href="/docs/transformers/main/en/model_doc/swin#transformers.TFSwinModel">TFSwinModel</a> forward method, overrides the <code>__call__</code> special method.',We,W,B,A,X,we,be,S,O,R,K,E=`Swin Model with a decoder on top for masked image modeling, as proposed in <a href="https://arxiv.org/abs/2111.09886" rel="nofollow">SimMIM</a>.
This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,ve,J,z,ye,U,Me='The <a href="/docs/transformers/main/en/model_doc/swin#transformers.TFSwinForMaskedImageModeling">TFSwinForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',Fe,N,Ze,V,he,fe,oe,Z,ee,I,Y,ue=`Swin Model transformer with an image classification head on top (a linear layer on top of the final hidden state of
the [CLS] token) e.g. for ImageNet.`,se,ae,je=`This model is a Tensorflow
<a href="https://www.tensorflow.org/api_docs/python/tf/keras/layers/Layer" rel="nofollow">keras.layers.Layer</a> sub-class. Use it as a
regular Tensorflow Module and refer to the Tensorflow documentation for all matter related to general usage and
behavior.`,s,f,C,ke,D,Ie='The <a href="/docs/transformers/main/en/model_doc/swin#transformers.TFSwinForImageClassification">TFSwinForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',G,te,Re,re,Xe;return e=new Ne({props:{title:"TFSwinModel",local:"transformers.TFSwinModel",headingTag:"h2"}}),o=new Te({props:{name:"class transformers.TFSwinModel",anchor:"transformers.TFSwinModel",parameters:[{name:"config",val:": SwinConfig"},{name:"add_pooling_layer",val:": bool = True"},{name:"use_mask_token",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFSwinModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_tf_swin.py#L1308"}}),Q=new Te({props:{name:"call",anchor:"transformers.TFSwinModel.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinModel.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinModel.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinModel.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinModel.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinModel.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinModel.call.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_tf_swin.py#L1320",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinModelOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, hidden_size)</code>, <em>optional</em>, returned when <code>add_pooling_layer=True</code> is passed) — Average pooling of the last layer hidden-state.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_tf_swin.TFSwinModelOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),W=new xe({props:{$$slots:{default:[kt]},$$scope:{ctx:$}}}),A=new Ye({props:{anchor:"transformers.TFSwinModel.call.example",$$slots:{default:[Jt]},$$scope:{ctx:$}}}),we=new Ne({props:{title:"TFSwinForMaskedImageModeling",local:"transformers.TFSwinForMaskedImageModeling",headingTag:"h2"}}),O=new Te({props:{name:"class transformers.TFSwinForMaskedImageModeling",anchor:"transformers.TFSwinForMaskedImageModeling",parameters:[{name:"config",val:": SwinConfig"}],parametersDescription:[{anchor:"transformers.TFSwinForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_tf_swin.py#L1430"}}),z=new Te({props:{name:"call",anchor:"transformers.TFSwinForMaskedImageModeling.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"bool_masked_pos",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinForMaskedImageModeling.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinForMaskedImageModeling.call.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_tf_swin.py#L1443",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinMaskedImageModelingOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>bool_masked_pos</code> is provided) — Masked image modeling (MLM) loss.</p>
</li>
<li>
<p><strong>reconstruction</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Reconstructed pixel values.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_tf_swin.TFSwinMaskedImageModelingOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),N=new xe({props:{$$slots:{default:[St]},$$scope:{ctx:$}}}),V=new Ye({props:{anchor:"transformers.TFSwinForMaskedImageModeling.call.example",$$slots:{default:[Ct]},$$scope:{ctx:$}}}),fe=new Ne({props:{title:"TFSwinForImageClassification",local:"transformers.TFSwinForImageClassification",headingTag:"h2"}}),ee=new Te({props:{name:"class transformers.TFSwinForImageClassification",anchor:"transformers.TFSwinForImageClassification",parameters:[{name:"config",val:": SwinConfig"}],parametersDescription:[{anchor:"transformers.TFSwinForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig">SwinConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_tf_swin.py#L1551"}}),C=new Te({props:{name:"call",anchor:"transformers.TFSwinForImageClassification.call",parameters:[{name:"pixel_values",val:": tf.Tensor | None = None"},{name:"head_mask",val:": tf.Tensor | None = None"},{name:"labels",val:": tf.Tensor | None = None"},{name:"output_attentions",val:": Optional[bool] = None"},{name:"output_hidden_states",val:": Optional[bool] = None"},{name:"return_dict",val:": Optional[bool] = None"},{name:"training",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFSwinForImageClassification.call.pixel_values",description:`<strong>pixel_values</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">ViTImageProcessor.<strong>call</strong>()</a>
for details.`,name:"pixel_values"},{anchor:"transformers.TFSwinForImageClassification.call.head_mask",description:`<strong>head_mask</strong> (<code>tf.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.TFSwinForImageClassification.call.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TFSwinForImageClassification.call.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TFSwinForImageClassification.call.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TFSwinForImageClassification.call.labels",description:`<strong>labels</strong> (<code>tf.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/modeling_tf_swin.py#L1572",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.swin.modeling_tf_swin.TFSwinImageClassifierOutput</code> or a tuple of <code>tf.Tensor</code> (if
<code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various elements depending on the
configuration (<a
  href="/docs/transformers/main/en/model_doc/swin#transformers.SwinConfig"
>SwinConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>tf.Tensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tf.Tensor</code> (one for each stage) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>reshaped_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each stage) of shape
<code>(batch_size, hidden_size, height, width)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs reshaped to
include the spatial dimensions.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.swin.modeling_tf_swin.TFSwinImageClassifierOutput</code> or <code>tuple(tf.Tensor)</code></p>
`}}),te=new xe({props:{$$slots:{default:[Ut]},$$scope:{ctx:$}}}),re=new Ye({props:{anchor:"transformers.TFSwinForImageClassification.call.example",$$slots:{default:[Wt]},$$scope:{ctx:$}}}),{c(){_(e.$$.fragment),a=l(),t=u("div"),_(o.$$.fragment),i=l(),n=u("p"),n.innerHTML=F,H=l(),x=u("div"),_(Q.$$.fragment),Ue=l(),L=u("p"),L.innerHTML=_e,We=l(),_(W.$$.fragment),B=l(),_(A.$$.fragment),X=l(),_(we.$$.fragment),be=l(),S=u("div"),_(O.$$.fragment),R=l(),K=u("p"),K.innerHTML=E,ve=l(),J=u("div"),_(z.$$.fragment),ye=l(),U=u("p"),U.innerHTML=Me,Fe=l(),_(N.$$.fragment),Ze=l(),_(V.$$.fragment),he=l(),_(fe.$$.fragment),oe=l(),Z=u("div"),_(ee.$$.fragment),I=l(),Y=u("p"),Y.textContent=ue,se=l(),ae=u("p"),ae.innerHTML=je,s=l(),f=u("div"),_(C.$$.fragment),ke=l(),D=u("p"),D.innerHTML=Ie,G=l(),_(te.$$.fragment),Re=l(),_(re.$$.fragment),this.h()},l(p){w(e.$$.fragment,p),a=d(p),t=g(p,"DIV",{class:!0});var j=pe(t);w(o.$$.fragment,j),i=d(j),n=g(j,"P",{"data-svelte-h":!0}),v(n)!=="svelte-3wgih9"&&(n.innerHTML=F),H=d(j),x=g(j,"DIV",{class:!0});var ie=pe(x);w(Q.$$.fragment,ie),Ue=d(ie),L=g(ie,"P",{"data-svelte-h":!0}),v(L)!=="svelte-1e0uqno"&&(L.innerHTML=_e),We=d(ie),w(W.$$.fragment,ie),B=d(ie),w(A.$$.fragment,ie),ie.forEach(r),j.forEach(r),X=d(p),w(we.$$.fragment,p),be=d(p),S=g(p,"DIV",{class:!0});var ne=pe(S);w(O.$$.fragment,ne),R=d(ne),K=g(ne,"P",{"data-svelte-h":!0}),v(K)!=="svelte-19lcs01"&&(K.innerHTML=E),ve=d(ne),J=g(ne,"DIV",{class:!0});var ge=pe(J);w(z.$$.fragment,ge),ye=d(ge),U=g(ge,"P",{"data-svelte-h":!0}),v(U)!=="svelte-vwb0oi"&&(U.innerHTML=Me),Fe=d(ge),w(N.$$.fragment,ge),Ze=d(ge),w(V.$$.fragment,ge),ge.forEach(r),ne.forEach(r),he=d(p),w(fe.$$.fragment,p),oe=d(p),Z=g(p,"DIV",{class:!0});var le=pe(Z);w(ee.$$.fragment,le),I=d(le),Y=g(le,"P",{"data-svelte-h":!0}),v(Y)!=="svelte-k64ai4"&&(Y.textContent=ue),se=d(le),ae=g(le,"P",{"data-svelte-h":!0}),v(ae)!=="svelte-1g64psv"&&(ae.innerHTML=je),s=d(le),f=g(le,"DIV",{class:!0});var q=pe(f);w(C.$$.fragment,q),ke=d(q),D=g(q,"P",{"data-svelte-h":!0}),v(D)!=="svelte-1j3krs6"&&(D.innerHTML=Ie),G=d(q),w(te.$$.fragment,q),Re=d(q),w(re.$$.fragment,q),q.forEach(r),le.forEach(r),this.h()},h(){me(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(f,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),me(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(p,j){b(e,p,j),h(p,a,j),h(p,t,j),b(o,t,null),m(t,i),m(t,n),m(t,H),m(t,x),b(Q,x,null),m(x,Ue),m(x,L),m(x,We),b(W,x,null),m(x,B),b(A,x,null),h(p,X,j),b(we,p,j),h(p,be,j),h(p,S,j),b(O,S,null),m(S,R),m(S,K),m(S,ve),m(S,J),b(z,J,null),m(J,ye),m(J,U),m(J,Fe),b(N,J,null),m(J,Ze),b(V,J,null),h(p,he,j),b(fe,p,j),h(p,oe,j),h(p,Z,j),b(ee,Z,null),m(Z,I),m(Z,Y),m(Z,se),m(Z,ae),m(Z,s),m(Z,f),b(C,f,null),m(f,ke),m(f,D),m(f,G),b(te,f,null),m(f,Re),b(re,f,null),Xe=!0},p(p,j){const ie={};j&2&&(ie.$$scope={dirty:j,ctx:p}),W.$set(ie);const ne={};j&2&&(ne.$$scope={dirty:j,ctx:p}),A.$set(ne);const ge={};j&2&&(ge.$$scope={dirty:j,ctx:p}),N.$set(ge);const le={};j&2&&(le.$$scope={dirty:j,ctx:p}),V.$set(le);const q={};j&2&&(q.$$scope={dirty:j,ctx:p}),te.$set(q);const Qe={};j&2&&(Qe.$$scope={dirty:j,ctx:p}),re.$set(Qe)},i(p){Xe||(M(e.$$.fragment,p),M(o.$$.fragment,p),M(Q.$$.fragment,p),M(W.$$.fragment,p),M(A.$$.fragment,p),M(we.$$.fragment,p),M(O.$$.fragment,p),M(z.$$.fragment,p),M(N.$$.fragment,p),M(V.$$.fragment,p),M(fe.$$.fragment,p),M(ee.$$.fragment,p),M(C.$$.fragment,p),M(te.$$.fragment,p),M(re.$$.fragment,p),Xe=!0)},o(p){T(e.$$.fragment,p),T(o.$$.fragment,p),T(Q.$$.fragment,p),T(W.$$.fragment,p),T(A.$$.fragment,p),T(we.$$.fragment,p),T(O.$$.fragment,p),T(z.$$.fragment,p),T(N.$$.fragment,p),T(V.$$.fragment,p),T(fe.$$.fragment,p),T(ee.$$.fragment,p),T(C.$$.fragment,p),T(te.$$.fragment,p),T(re.$$.fragment,p),Xe=!1},d(p){p&&(r(a),r(t),r(X),r(be),r(S),r(he),r(oe),r(Z)),y(e,p),y(o),y(Q),y(W),y(A),y(we,p),y(O),y(z),y(N),y(V),y(fe,p),y(ee),y(C),y(te),y(re)}}}function It($){let e,a;return e=new nt({props:{$$slots:{default:[Zt]},$$scope:{ctx:$}}}),{c(){_(e.$$.fragment)},l(t){w(e.$$.fragment,t)},m(t,o){b(e,t,o),a=!0},p(t,o){const i={};o&2&&(i.$$scope={dirty:o,ctx:t}),e.$set(i)},i(t){a||(M(e.$$.fragment,t),a=!0)},o(t){T(e.$$.fragment,t),a=!1},d(t){y(e,t)}}}function xt($){let e,a,t,o,i,n='<div class="flex flex-wrap space-x-1"><img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="TensorFlow" src="https://img.shields.io/badge/TensorFlow-FF6F00?style=flat&amp;logo=tensorflow&amp;logoColor=white"/></div>',F,H,x,Q,Ue='<a href="https://huggingface.co/papers/2103.14030" rel="nofollow">Swin Transformer</a> is a hierarchical vision transformer. Images are processed in patches and windowed self-attention is used to capture local information. These windows are shifted across the image to allow for cross-window connections, capturing global information more efficiently. This hierarchical approach with shifted windows allows the Swin Transformer to process images effectively at different scales and achieve linear computational complexity relative to image size, making it a versatile backbone for various vision tasks like image classification and object detection.',L,_e,We='You can find all official Swin Transformer checkpoints under the <a href="https://huggingface.co/microsoft?search_models=swin" rel="nofollow">Microsoft</a> organization.',W,B,A,X,we='The example below demonstrates how to classify an image with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.Pipeline">Pipeline</a> or the <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModel">AutoModel</a> class.',be,S,O,R,K,E,ve='<li>Swin can pad the inputs for any input height and width divisible by <code>32</code>.</li> <li>Swin can be used as a <a href="../backbones">backbone</a>. When <code>output_hidden_states = True</code>, it outputs both <code>hidden_states</code> and <code>reshaped_hidden_states</code>. The <code>reshaped_hidden_states</code> have a shape of <code>(batch, num_channels, height, width)</code> rather than <code>(batch_size, sequence_length, num_channels)</code>.</li>',J,z,ye,U,Me,Fe,N,Ze=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/swin#transformers.SwinModel">SwinModel</a>. It is used to instantiate a Swin
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Swin
<a href="https://huggingface.co/microsoft/swin-tiny-patch4-window7-224" rel="nofollow">microsoft/swin-tiny-patch4-window7-224</a>
architecture.`,V,he,fe=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,oe,Z,ee,I,Y,ue,se,ae,je;return H=new Ne({props:{title:"Swin Transformer",local:"swin-transformer",headingTag:"h1"}}),B=new xe({props:{warning:!1,$$slots:{default:[mt]},$$scope:{ctx:$}}}),S=new ct({props:{id:"usage",options:["Pipeline","AutoModel"],$$slots:{default:[ut]},$$scope:{ctx:$}}}),R=new Ne({props:{title:"Notes",local:"notes",headingTag:"h2"}}),z=new Ne({props:{title:"SwinConfig",local:"transformers.SwinConfig",headingTag:"h2"}}),Me=new Te({props:{name:"class transformers.SwinConfig",anchor:"transformers.SwinConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 4"},{name:"num_channels",val:" = 3"},{name:"embed_dim",val:" = 96"},{name:"depths",val:" = [2, 2, 6, 2]"},{name:"num_heads",val:" = [3, 6, 12, 24]"},{name:"window_size",val:" = 7"},{name:"mlp_ratio",val:" = 4.0"},{name:"qkv_bias",val:" = True"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"drop_path_rate",val:" = 0.1"},{name:"hidden_act",val:" = 'gelu'"},{name:"use_absolute_embeddings",val:" = False"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"encoder_stride",val:" = 32"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SwinConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.SwinConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.SwinConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.SwinConfig.embed_dim",description:`<strong>embed_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Dimensionality of patch embedding.`,name:"embed_dim"},{anchor:"transformers.SwinConfig.depths",description:`<strong>depths</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[2, 2, 6, 2]</code>) &#x2014;
Depth of each layer in the Transformer encoder.`,name:"depths"},{anchor:"transformers.SwinConfig.num_heads",description:`<strong>num_heads</strong> (<code>list(int)</code>, <em>optional</em>, defaults to <code>[3, 6, 12, 24]</code>) &#x2014;
Number of attention heads in each layer of the Transformer encoder.`,name:"num_heads"},{anchor:"transformers.SwinConfig.window_size",description:`<strong>window_size</strong> (<code>int</code>, <em>optional</em>, defaults to 7) &#x2014;
Size of windows.`,name:"window_size"},{anchor:"transformers.SwinConfig.mlp_ratio",description:`<strong>mlp_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Ratio of MLP hidden dimensionality to embedding dimensionality.`,name:"mlp_ratio"},{anchor:"transformers.SwinConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not a learnable bias should be added to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.SwinConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings and encoder.`,name:"hidden_dropout_prob"},{anchor:"transformers.SwinConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SwinConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate.`,name:"drop_path_rate"},{anchor:"transformers.SwinConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder. If string, <code>&quot;gelu&quot;</code>, <code>&quot;relu&quot;</code>,
<code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SwinConfig.use_absolute_embeddings",description:`<strong>use_absolute_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add absolute position embeddings to the patch embeddings.`,name:"use_absolute_embeddings"},{anchor:"transformers.SwinConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SwinConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SwinConfig.encoder_stride",description:`<strong>encoder_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Factor to increase the spatial resolution by in the decoder head for masked image modeling.`,name:"encoder_stride"},{anchor:"transformers.SwinConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_features"},{anchor:"transformers.SwinConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/swin/configuration_swin.py#L31"}}),Z=new Ye({props:{anchor:"transformers.SwinConfig.example",$$slots:{default:[gt]},$$scope:{ctx:$}}}),I=new dt({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[It],pytorch:[jt]},$$scope:{ctx:$}}}),ue=new pt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/swin.md"}}),{c(){e=u("meta"),a=l(),t=u("p"),o=l(),i=u("div"),i.innerHTML=n,F=l(),_(H.$$.fragment),x=l(),Q=u("p"),Q.innerHTML=Ue,L=l(),_e=u("p"),_e.innerHTML=We,W=l(),_(B.$$.fragment),A=l(),X=u("p"),X.innerHTML=we,be=l(),_(S.$$.fragment),O=l(),_(R.$$.fragment),K=l(),E=u("ul"),E.innerHTML=ve,J=l(),_(z.$$.fragment),ye=l(),U=u("div"),_(Me.$$.fragment),Fe=l(),N=u("p"),N.innerHTML=Ze,V=l(),he=u("p"),he.innerHTML=fe,oe=l(),_(Z.$$.fragment),ee=l(),_(I.$$.fragment),Y=l(),_(ue.$$.fragment),se=l(),ae=u("p"),this.h()},l(s){const f=it("svelte-u9bgzb",document.head);e=g(f,"META",{name:!0,content:!0}),f.forEach(r),a=d(s),t=g(s,"P",{}),pe(t).forEach(r),o=d(s),i=g(s,"DIV",{style:!0,"data-svelte-h":!0}),v(i)!=="svelte-fhlxbq"&&(i.innerHTML=n),F=d(s),w(H.$$.fragment,s),x=d(s),Q=g(s,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-wmv2iu"&&(Q.innerHTML=Ue),L=d(s),_e=g(s,"P",{"data-svelte-h":!0}),v(_e)!=="svelte-1igtsfg"&&(_e.innerHTML=We),W=d(s),w(B.$$.fragment,s),A=d(s),X=g(s,"P",{"data-svelte-h":!0}),v(X)!=="svelte-8m4k86"&&(X.innerHTML=we),be=d(s),w(S.$$.fragment,s),O=d(s),w(R.$$.fragment,s),K=d(s),E=g(s,"UL",{"data-svelte-h":!0}),v(E)!=="svelte-ivi34c"&&(E.innerHTML=ve),J=d(s),w(z.$$.fragment,s),ye=d(s),U=g(s,"DIV",{class:!0});var C=pe(U);w(Me.$$.fragment,C),Fe=d(C),N=g(C,"P",{"data-svelte-h":!0}),v(N)!=="svelte-r4izhk"&&(N.innerHTML=Ze),V=d(C),he=g(C,"P",{"data-svelte-h":!0}),v(he)!=="svelte-o55m63"&&(he.innerHTML=fe),oe=d(C),w(Z.$$.fragment,C),C.forEach(r),ee=d(s),w(I.$$.fragment,s),Y=d(s),w(ue.$$.fragment,s),se=d(s),ae=g(s,"P",{}),pe(ae).forEach(r),this.h()},h(){me(e,"name","hf:doc:metadata"),me(e,"content",Nt),lt(i,"float","right"),me(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(s,f){m(document.head,e),h(s,a,f),h(s,t,f),h(s,o,f),h(s,i,f),h(s,F,f),b(H,s,f),h(s,x,f),h(s,Q,f),h(s,L,f),h(s,_e,f),h(s,W,f),b(B,s,f),h(s,A,f),h(s,X,f),h(s,be,f),b(S,s,f),h(s,O,f),b(R,s,f),h(s,K,f),h(s,E,f),h(s,J,f),b(z,s,f),h(s,ye,f),h(s,U,f),b(Me,U,null),m(U,Fe),m(U,N),m(U,V),m(U,he),m(U,oe),b(Z,U,null),h(s,ee,f),b(I,s,f),h(s,Y,f),b(ue,s,f),h(s,se,f),h(s,ae,f),je=!0},p(s,[f]){const C={};f&2&&(C.$$scope={dirty:f,ctx:s}),B.$set(C);const ke={};f&2&&(ke.$$scope={dirty:f,ctx:s}),S.$set(ke);const D={};f&2&&(D.$$scope={dirty:f,ctx:s}),Z.$set(D);const Ie={};f&2&&(Ie.$$scope={dirty:f,ctx:s}),I.$set(Ie)},i(s){je||(M(H.$$.fragment,s),M(B.$$.fragment,s),M(S.$$.fragment,s),M(R.$$.fragment,s),M(z.$$.fragment,s),M(Me.$$.fragment,s),M(Z.$$.fragment,s),M(I.$$.fragment,s),M(ue.$$.fragment,s),je=!0)},o(s){T(H.$$.fragment,s),T(B.$$.fragment,s),T(S.$$.fragment,s),T(R.$$.fragment,s),T(z.$$.fragment,s),T(Me.$$.fragment,s),T(Z.$$.fragment,s),T(I.$$.fragment,s),T(ue.$$.fragment,s),je=!1},d(s){s&&(r(a),r(t),r(o),r(i),r(F),r(x),r(Q),r(L),r(_e),r(W),r(A),r(X),r(be),r(O),r(K),r(E),r(J),r(ye),r(U),r(ee),r(Y),r(se),r(ae)),r(e),y(H,s),y(B,s),y(S,s),y(R,s),y(z,s),y(Me),y(Z),y(I,s),y(ue,s)}}}const Nt='{"title":"Swin Transformer","local":"swin-transformer","sections":[{"title":"Notes","local":"notes","sections":[],"depth":2},{"title":"SwinConfig","local":"transformers.SwinConfig","sections":[],"depth":2},{"title":"SwinModel","local":"transformers.SwinModel","sections":[],"depth":2},{"title":"SwinForMaskedImageModeling","local":"transformers.SwinForMaskedImageModeling","sections":[],"depth":2},{"title":"SwinForImageClassification","local":"transformers.SwinForImageClassification","sections":[],"depth":2},{"title":"TFSwinModel","local":"transformers.TFSwinModel","sections":[],"depth":2},{"title":"TFSwinForMaskedImageModeling","local":"transformers.TFSwinForMaskedImageModeling","sections":[],"depth":2},{"title":"TFSwinForImageClassification","local":"transformers.TFSwinForImageClassification","sections":[],"depth":2}],"depth":1}';function zt($){return st(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends at{constructor(e){super(),rt(this,e,zt,xt,ot,{})}}export{qt as component};
