import{s as bt,n as _t,o as wt}from"../chunks/scheduler.18a86fab.js";import{S as Tt,i as xt,g as a,s as i,r as m,A as Ct,h as o,f as s,c as l,j as ze,u as f,x as r,k as Ue,y as c,a as n,v as u,d as h,t as g,w as v}from"../chunks/index.98837b22.js";import{D as $t}from"../chunks/Docstring.6758ea23.js";import{C as Ee}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as le}from"../chunks/Heading.7e7e0c5b.js";import{E as jt}from"../chunks/index.92f616ba.js";function Mt(We){let $,ae,ne,oe,b,re,_,Ye=`This page goes through the transformers utilities to enable lazy and fast object import.
While we strive for minimal dependencies, some models have specific dependencies requirements that cannot be
worked around. We don’t want for all users of <code>transformers</code> to have to install those dependencies to use other models,
we therefore mark those as soft dependencies rather than hard dependencies.`,pe,w,Qe=`The transformers toolkit is not made to error-out on import of a model that has a specific dependency; instead, an
object for which you are lacking a dependency will error-out when calling any method on it. As an example, if
<code>torchvision</code> isn’t installed, the fast image processors will not be available.`,ce,T,Ge="This object is still importable:",de,x,me,C,Oe="However, no method can be called on that object:",fe,j,ue,M,Ke="Let’s see how to specify specific object dependencies.",he,k,ge,P,ve,J,et="All objects under a given filename have an automatic dependency to the tool linked to the filename",ye,H,tt="<strong>TensorFlow</strong>: All files starting with <code>modeling_tf_</code> have an automatic TensorFlow dependency.",$e,L,st="<strong>Flax</strong>: All files starting with <code>modeling_flax_</code> have an automatic Flax dependency",be,I,nt=`<strong>PyTorch</strong>: All files starting with <code>modeling_</code> and not valid with the above (TensorFlow and Flax) have an automatic
PyTorch dependency`,_e,A,it="<strong>Tokenizers</strong>: All files starting with <code>tokenization_</code> and ending with <code>_fast</code> have an automatic <code>tokenizers</code> dependency",we,F,lt=`<strong>Vision</strong>: All files starting with <code>image_processing_</code> have an automatic dependency to the <code>vision</code> dependency group;
at the time of writing, this only contains the <code>pillow</code> dependency.`,Te,B,at=`<strong>Vision + Torch + Torchvision</strong>: All files starting with <code>image_processing_</code> and ending with <code>_fast</code> have an automatic
dependency to <code>vision</code>, <code>torch</code>, and <code>torchvision</code>.`,xe,q,ot="All of these automatic dependencies are added on top of the explicit dependencies that are detailed below.",Ce,z,je,U,rt=`We add a method called <code>requires</code> that is used to explicitly specify the dependencies of a given object. As an
example, the <code>Trainer</code> class has two hard dependencies: <code>torch</code> and <code>accelerate</code>. Here is how we specify these
required dependencies:`,Me,E,ke,V,pt="Backends that can be added here are all the backends that are available in the <code>import_utils.py</code> module.",Pe,X,ct=`Additionally, specific versions can be specified in each backend. For example, this is how you would specify
a requirement on torch&gt;=2.6 on the <code>Trainer</code> class:`,Je,Z,He,N,dt="You can specify the following operators: <code>==</code>, <code>&gt;</code>, <code>&gt;=</code>, <code>&lt;</code>, <code>&lt;=</code>, <code>!=</code>.",Le,D,Ie,p,R,Ve,Y,mt="This method takes a module_path as input and creates an import structure digestible by a _LazyModule.",Xe,Q,ft="Here’s an example of an output import structure at the src.transformers.models level:",Ze,G,ut=`{
frozenset({‘tokenizers’}): {
‘albert.tokenization_albert_fast’: {‘AlbertTokenizerFast’}
},
frozenset(): {
‘albert.configuration_albert’: {‘AlbertConfig’, ‘AlbertOnnxConfig’},
‘align.processing_align’: {‘AlignProcessor’},
‘align.configuration_align’: {‘AlignConfig’, ‘AlignTextConfig’, ‘AlignVisionConfig’},
‘altclip.configuration_altclip’: {‘AltCLIPConfig’, ‘AltCLIPTextConfig’, ‘AltCLIPVisionConfig’},
‘altclip.processing_altclip’: {‘AltCLIPProcessor’}
}
}`,Ne,O,ht="The import structure is a dict defined with frozensets as keys, and dicts of strings to sets of objects.",De,K,gt="If <code>prefix</code> is not None, it will add that prefix to all keys in the returned dict.",Ae,y,S,Re,ee,vt="This decorator enables two things:",Se,te,yt=`<li>Attaching a <code>__backends</code> tuple to an object to see what are the necessary backends for it
to execute correctly without instantiating it</li> <li>The ‘@requires’ string is used to dynamically import objects</li>`,Fe,W,Be,ie,qe;return b=new le({props:{title:"Import Utilities",local:"import-utilities",headingTag:"h1"}}),x=new Ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERldHJJbWFnZVByb2Nlc3NvckZhc3QlMEFwcmludChEZXRySW1hZ2VQcm9jZXNzb3JGYXN0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DetrImageProcessorFast
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(DetrImageProcessorFast)
&lt;<span class="hljs-keyword">class</span> <span class="hljs-string">&#x27;DetrImageProcessorFast&#x27;</span>&gt;`,wrap:!1}}),j=new Ee({props:{code:"RGV0ckltYWdlUHJvY2Vzc29yRmFzdC5mcm9tX3ByZXRyYWluZWQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>DetrImageProcessorFast.from_pretrained()
ImportError: 
DetrImageProcessorFast requires the Torchvision library but it was <span class="hljs-keyword">not</span> found <span class="hljs-keyword">in</span> your environment. Checkout the instructions on the
installation page: https://pytorch.org/get-started/locally/ <span class="hljs-keyword">and</span> follow the ones that <span class="hljs-keyword">match</span> your environment.
Please note that you may need to restart your runtime after installation.`,wrap:!1}}),k=new le({props:{title:"Specifying Object Dependencies",local:"specifying-object-dependencies",headingTag:"h2"}}),P=new le({props:{title:"Filename-based",local:"filename-based",headingTag:"h3"}}),z=new le({props:{title:"Explicit Object Dependencies",local:"explicit-object-dependencies",headingTag:"h3"}}),E=new Ee({props:{code:"ZnJvbSUyMC51dGlscy5pbXBvcnRfdXRpbHMlMjBpbXBvcnQlMjByZXF1aXJlcyUwQSUwQSU0MHJlcXVpcmVzKGJhY2tlbmRzJTNEKCUyMnRvcmNoJTIyJTJDJTIwJTIyYWNjZWxlcmF0ZSUyMikpJTBBY2xhc3MlMjBUcmFpbmVyJTNBJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">from</span> .utils.import_utils <span class="hljs-keyword">import</span> requires

<span class="hljs-meta">@requires(<span class="hljs-params">backends=(<span class="hljs-params"><span class="hljs-string">&quot;torch&quot;</span>, <span class="hljs-string">&quot;accelerate&quot;</span></span>)</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Trainer</span>:
    ...`,wrap:!1}}),Z=new Ee({props:{code:"ZnJvbSUyMC51dGlscy5pbXBvcnRfdXRpbHMlMjBpbXBvcnQlMjByZXF1aXJlcyUwQSUwQSU0MHJlcXVpcmVzKGJhY2tlbmRzJTNEKCUyMnRvcmNoJTNFJTNEMi42JTIyJTJDJTIwJTIyYWNjZWxlcmF0ZSUyMikpJTBBY2xhc3MlMjBUcmFpbmVyJTNBJTBBJTIwJTIwJTIwJTIwLi4u",highlighted:`<span class="hljs-keyword">from</span> .utils.import_utils <span class="hljs-keyword">import</span> requires

<span class="hljs-meta">@requires(<span class="hljs-params">backends=(<span class="hljs-params"><span class="hljs-string">&quot;torch&gt;=2.6&quot;</span>, <span class="hljs-string">&quot;accelerate&quot;</span></span>)</span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">Trainer</span>:
    ...`,wrap:!1}}),D=new le({props:{title:"Methods",local:"transformers.utils.import_utils.define_import_structure",headingTag:"h2"}}),R=new $t({props:{name:"transformers.utils.import_utils.define_import_structure",anchor:"transformers.utils.import_utils.define_import_structure",parameters:[{name:"module_path",val:": str"},{name:"prefix",val:": typing.Optional[str] = None"}]}}),S=new $t({props:{name:"transformers.utils.import_utils.requires",anchor:"transformers.utils.import_utils.requires",parameters:[{name:"backends",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/utils/import_utils.py#L2162"}}),W=new jt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/internal/import_utils.md"}}),{c(){$=a("meta"),ae=i(),ne=a("p"),oe=i(),m(b.$$.fragment),re=i(),_=a("p"),_.innerHTML=Ye,pe=i(),w=a("p"),w.innerHTML=Qe,ce=i(),T=a("p"),T.textContent=Ge,de=i(),m(x.$$.fragment),me=i(),C=a("p"),C.textContent=Oe,fe=i(),m(j.$$.fragment),ue=i(),M=a("p"),M.textContent=Ke,he=i(),m(k.$$.fragment),ge=i(),m(P.$$.fragment),ve=i(),J=a("p"),J.textContent=et,ye=i(),H=a("p"),H.innerHTML=tt,$e=i(),L=a("p"),L.innerHTML=st,be=i(),I=a("p"),I.innerHTML=nt,_e=i(),A=a("p"),A.innerHTML=it,we=i(),F=a("p"),F.innerHTML=lt,Te=i(),B=a("p"),B.innerHTML=at,xe=i(),q=a("p"),q.textContent=ot,Ce=i(),m(z.$$.fragment),je=i(),U=a("p"),U.innerHTML=rt,Me=i(),m(E.$$.fragment),ke=i(),V=a("p"),V.innerHTML=pt,Pe=i(),X=a("p"),X.innerHTML=ct,Je=i(),m(Z.$$.fragment),He=i(),N=a("p"),N.innerHTML=dt,Le=i(),m(D.$$.fragment),Ie=i(),p=a("div"),m(R.$$.fragment),Ve=i(),Y=a("p"),Y.textContent=mt,Xe=i(),Q=a("p"),Q.textContent=ft,Ze=i(),G=a("p"),G.textContent=ut,Ne=i(),O=a("p"),O.textContent=ht,De=i(),K=a("p"),K.innerHTML=gt,Ae=i(),y=a("div"),m(S.$$.fragment),Re=i(),ee=a("p"),ee.textContent=vt,Se=i(),te=a("ul"),te.innerHTML=yt,Fe=i(),m(W.$$.fragment),Be=i(),ie=a("p"),this.h()},l(e){const t=Ct("svelte-u9bgzb",document.head);$=o(t,"META",{name:!0,content:!0}),t.forEach(s),ae=l(e),ne=o(e,"P",{}),ze(ne).forEach(s),oe=l(e),f(b.$$.fragment,e),re=l(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1sq0d21"&&(_.innerHTML=Ye),pe=l(e),w=o(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-1h66sjo"&&(w.innerHTML=Qe),ce=l(e),T=o(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-ofaiyy"&&(T.textContent=Ge),de=l(e),f(x.$$.fragment,e),me=l(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1lv9355"&&(C.textContent=Oe),fe=l(e),f(j.$$.fragment,e),ue=l(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1urggpc"&&(M.textContent=Ke),he=l(e),f(k.$$.fragment,e),ge=l(e),f(P.$$.fragment,e),ve=l(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1fa77p5"&&(J.textContent=et),ye=l(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-jlavg6"&&(H.innerHTML=tt),$e=l(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-142jhdv"&&(L.innerHTML=st),be=l(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-e67hmr"&&(I.innerHTML=nt),_e=l(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-2ds1y"&&(A.innerHTML=it),we=l(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-12il0co"&&(F.innerHTML=lt),Te=l(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-9v6z5i"&&(B.innerHTML=at),xe=l(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-spzh9a"&&(q.textContent=ot),Ce=l(e),f(z.$$.fragment,e),je=l(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1tp2bu8"&&(U.innerHTML=rt),Me=l(e),f(E.$$.fragment,e),ke=l(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tt5tx3"&&(V.innerHTML=pt),Pe=l(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-akll5o"&&(X.innerHTML=ct),Je=l(e),f(Z.$$.fragment,e),He=l(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1veix6d"&&(N.innerHTML=dt),Le=l(e),f(D.$$.fragment,e),Ie=l(e),p=o(e,"DIV",{class:!0});var d=ze(p);f(R.$$.fragment,d),Ve=l(d),Y=o(d,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-95xerm"&&(Y.textContent=mt),Xe=l(d),Q=o(d,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-156ifki"&&(Q.textContent=ft),Ze=l(d),G=o(d,"P",{"data-svelte-h":!0}),r(G)!=="svelte-yg830s"&&(G.textContent=ut),Ne=l(d),O=o(d,"P",{"data-svelte-h":!0}),r(O)!=="svelte-5u4rti"&&(O.textContent=ht),De=l(d),K=o(d,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1bsr87l"&&(K.innerHTML=gt),d.forEach(s),Ae=l(e),y=o(e,"DIV",{class:!0});var se=ze(y);f(S.$$.fragment,se),Re=l(se),ee=o(se,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-m9yvj6"&&(ee.textContent=vt),Se=l(se),te=o(se,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-1a9rw40"&&(te.innerHTML=yt),se.forEach(s),Fe=l(e),f(W.$$.fragment,e),Be=l(e),ie=o(e,"P",{}),ze(ie).forEach(s),this.h()},h(){Ue($,"name","hf:doc:metadata"),Ue($,"content",kt),Ue(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Ue(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,$),n(e,ae,t),n(e,ne,t),n(e,oe,t),u(b,e,t),n(e,re,t),n(e,_,t),n(e,pe,t),n(e,w,t),n(e,ce,t),n(e,T,t),n(e,de,t),u(x,e,t),n(e,me,t),n(e,C,t),n(e,fe,t),u(j,e,t),n(e,ue,t),n(e,M,t),n(e,he,t),u(k,e,t),n(e,ge,t),u(P,e,t),n(e,ve,t),n(e,J,t),n(e,ye,t),n(e,H,t),n(e,$e,t),n(e,L,t),n(e,be,t),n(e,I,t),n(e,_e,t),n(e,A,t),n(e,we,t),n(e,F,t),n(e,Te,t),n(e,B,t),n(e,xe,t),n(e,q,t),n(e,Ce,t),u(z,e,t),n(e,je,t),n(e,U,t),n(e,Me,t),u(E,e,t),n(e,ke,t),n(e,V,t),n(e,Pe,t),n(e,X,t),n(e,Je,t),u(Z,e,t),n(e,He,t),n(e,N,t),n(e,Le,t),u(D,e,t),n(e,Ie,t),n(e,p,t),u(R,p,null),c(p,Ve),c(p,Y),c(p,Xe),c(p,Q),c(p,Ze),c(p,G),c(p,Ne),c(p,O),c(p,De),c(p,K),n(e,Ae,t),n(e,y,t),u(S,y,null),c(y,Re),c(y,ee),c(y,Se),c(y,te),n(e,Fe,t),u(W,e,t),n(e,Be,t),n(e,ie,t),qe=!0},p:_t,i(e){qe||(h(b.$$.fragment,e),h(x.$$.fragment,e),h(j.$$.fragment,e),h(k.$$.fragment,e),h(P.$$.fragment,e),h(z.$$.fragment,e),h(E.$$.fragment,e),h(Z.$$.fragment,e),h(D.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(W.$$.fragment,e),qe=!0)},o(e){g(b.$$.fragment,e),g(x.$$.fragment,e),g(j.$$.fragment,e),g(k.$$.fragment,e),g(P.$$.fragment,e),g(z.$$.fragment,e),g(E.$$.fragment,e),g(Z.$$.fragment,e),g(D.$$.fragment,e),g(R.$$.fragment,e),g(S.$$.fragment,e),g(W.$$.fragment,e),qe=!1},d(e){e&&(s(ae),s(ne),s(oe),s(re),s(_),s(pe),s(w),s(ce),s(T),s(de),s(me),s(C),s(fe),s(ue),s(M),s(he),s(ge),s(ve),s(J),s(ye),s(H),s($e),s(L),s(be),s(I),s(_e),s(A),s(we),s(F),s(Te),s(B),s(xe),s(q),s(Ce),s(je),s(U),s(Me),s(ke),s(V),s(Pe),s(X),s(Je),s(He),s(N),s(Le),s(Ie),s(p),s(Ae),s(y),s(Fe),s(Be),s(ie)),s($),v(b,e),v(x,e),v(j,e),v(k,e),v(P,e),v(z,e),v(E,e),v(Z,e),v(D,e),v(R),v(S),v(W,e)}}}const kt='{"title":"Import Utilities","local":"import-utilities","sections":[{"title":"Specifying Object Dependencies","local":"specifying-object-dependencies","sections":[{"title":"Filename-based","local":"filename-based","sections":[],"depth":3},{"title":"Explicit Object Dependencies","local":"explicit-object-dependencies","sections":[],"depth":3}],"depth":2},{"title":"Methods","local":"transformers.utils.import_utils.define_import_structure","sections":[],"depth":2}],"depth":1}';function Pt(We){return wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends Tt{constructor($){super(),xt(this,$,Pt,Mt,bt,{})}}export{Bt as component};
