import{s as Ds,z as qs,o as Ks,n as Fe}from"../chunks/scheduler.18a86fab.js";import{S as Os,i as en,g as i,s as o,r as f,A as tn,h as d,f as s,c as a,j as Z,u,x as h,k as j,y as c,a as n,v as g,d as M,t as _,w as y}from"../chunks/index.98837b22.js";import{T as gs}from"../chunks/Tip.77304350.js";import{D as B}from"../chunks/Docstring.6758ea23.js";import{C as at}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Ft}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as F}from"../chunks/Heading.7e7e0c5b.js";import{E as sn}from"../chunks/index.92f616ba.js";function nn(J){let r,T="Example:",m,p,b;return p=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFQ29uZmlnJTJDJTIwVmlkZW9NQUVNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb01BRSUyMHZpZGVvbWFlLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVmlkZW9NQUVDb25maWcoKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTUFFTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoMAEConfig, VideoMAEModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoMAE videomae-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoMAEConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=i("p"),r.textContent=T,m=o(),f(p.$$.fragment)},l(l){r=d(l,"P",{"data-svelte-h":!0}),h(r)!=="svelte-11lpom8"&&(r.textContent=T),m=a(l),u(p.$$.fragment,l)},m(l,w){n(l,r,w),n(l,m,w),g(p,l,w),b=!0},p:Fe,i(l){b||(M(p.$$.fragment,l),b=!0)},o(l){_(p.$$.fragment,l),b=!1},d(l){l&&(s(r),s(m)),y(p,l)}}}function on(J){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=T},l(m){r=d(m,"P",{"data-svelte-h":!0}),h(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(m,p){n(m,r,p)},p:Fe,d(m){m&&s(r)}}}function an(J){let r,T="Examples:",m,p,b;return p=new at({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 16 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">16</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEModel.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1568</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){r=i("p"),r.textContent=T,m=o(),f(p.$$.fragment)},l(l){r=d(l,"P",{"data-svelte-h":!0}),h(r)!=="svelte-kvfsh7"&&(r.textContent=T),m=a(l),u(p.$$.fragment,l)},m(l,w){n(l,r,w),n(l,m,w),g(p,l,w),b=!0},p:Fe,i(l){b||(M(p.$$.fragment,l),b=!0)},o(l){_(p.$$.fragment,l),b=!1},d(l){l&&(s(r),s(m)),y(p,l)}}}function rn(J){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=T},l(m){r=d(m,"P",{"data-svelte-h":!0}),h(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(m,p){n(m,r,p)},p:Fe,d(m){m&&s(r)}}}function ln(J){let r,T="Examples:",m,p,b;return p=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFZpZGVvTUFFRm9yUHJlVHJhaW5pbmclMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQW51bV9mcmFtZXMlMjAlM0QlMjAxNiUwQXZpZGVvJTIwJTNEJTIwbGlzdChucC5yYW5kb20ucmFuZGludCgwJTJDJTIwMjU2JTJDJTIwKG51bV9mcmFtZXMlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSkpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJNQ0ctTkpVJTJGdmlkZW9tYWUtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMFZpZGVvTUFFRm9yUHJlVHJhaW5pbmcuZnJvbV9wcmV0cmFpbmVkKCUyMk1DRy1OSlUlMkZ2aWRlb21hZS1iYXNlJTIyKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvcih2aWRlbyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQSUwQW51bV9wYXRjaGVzX3Blcl9mcmFtZSUyMCUzRCUyMChtb2RlbC5jb25maWcuaW1hZ2Vfc2l6ZSUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy5wYXRjaF9zaXplKSUyMCoqJTIwMiUwQXNlcV9sZW5ndGglMjAlM0QlMjAobnVtX2ZyYW1lcyUyMCUyRiUyRiUyMG1vZGVsLmNvbmZpZy50dWJlbGV0X3NpemUpJTIwKiUyMG51bV9wYXRjaGVzX3Blcl9mcmFtZSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQoMCUyQyUyMDIlMkMlMjAoMSUyQyUyMHNlcV9sZW5ndGgpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEForPreTraining
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames = <span class="hljs-number">16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video = <span class="hljs-built_in">list</span>(np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">256</span>, (num_frames, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForPreTraining.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches_per_frame = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>seq_length = (num_frames // model.config.tubelet_size) * num_patches_per_frame
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, (<span class="hljs-number">1</span>, seq_length)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){r=i("p"),r.textContent=T,m=o(),f(p.$$.fragment)},l(l){r=d(l,"P",{"data-svelte-h":!0}),h(r)!=="svelte-kvfsh7"&&(r.textContent=T),m=a(l),u(p.$$.fragment,l)},m(l,w){n(l,r,w),n(l,m,w),g(p,l,w),b=!0},p:Fe,i(l){b||(M(p.$$.fragment,l),b=!0)},o(l){_(p.$$.fragment,l),b=!1},d(l){l&&(s(r),s(m)),y(p,l)}}}function dn(J){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=i("p"),r.innerHTML=T},l(m){r=d(m,"P",{"data-svelte-h":!0}),h(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(m,p){n(m,r,p)},p:Fe,d(m){m&&s(r)}}}function cn(J){let r,T="Examples:",m,p,b;return p=new at({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VideoMAEForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 16 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">16</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForVideoClassification.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
eating spaghetti`,wrap:!1}}),{c(){r=i("p"),r.textContent=T,m=o(),f(p.$$.fragment)},l(l){r=d(l,"P",{"data-svelte-h":!0}),h(r)!=="svelte-kvfsh7"&&(r.textContent=T),m=a(l),u(p.$$.fragment,l)},m(l,w){n(l,r,w),n(l,m,w),g(p,l,w),b=!0},p:Fe,i(l){b||(M(p.$$.fragment,l),b=!0)},o(l){_(p.$$.fragment,l),b=!1},d(l){l&&(s(r),s(m)),y(p,l)}}}function mn(J){let r,T,m,p,b,l,w,Ms='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',rt,te,lt,se,_s=`The VideoMAE model was proposed in <a href="https://arxiv.org/abs/2203.12602" rel="nofollow">VideoMAE: Masked Autoencoders are Data-Efficient Learners for Self-Supervised Video Pre-Training</a> by Zhan Tong, Yibing Song, Jue Wang, Limin Wang.
VideoMAE extends masked auto encoders (<a href="vit_mae">MAE</a>) to video, claiming state-of-the-art performance on several video classification benchmarks.`,it,ne,ys="The abstract from the paper is the following:",dt,oe,bs="<em>Pre-training video transformers on extra large-scale datasets is generally required to achieve premier performance on relatively small datasets. In this paper, we show that video masked autoencoders (VideoMAE) are data-efficient learners for self-supervised video pre-training (SSVP). We are inspired by the recent ImageMAE and propose customized video tube masking and reconstruction. These simple designs turn out to be effective for overcoming information leakage caused by the temporal correlation during video reconstruction. We obtain three important findings on SSVP: (1) An extremely high proportion of masking ratio (i.e., 90% to 95%) still yields favorable performance of VideoMAE. The temporally redundant video content enables higher masking ratio than that of images. (2) VideoMAE achieves impressive results on very small datasets (i.e., around 3k-4k videos) without using any extra data. This is partially ascribed to the challenging task of video reconstruction to enforce high-level structure learning. (3) VideoMAE shows that data quality is more important than data quantity for SSVP. Domain shift between pre-training and target datasets are important issues in SSVP. Notably, our VideoMAE with the vanilla ViT backbone can achieve 83.9% on Kinects-400, 75.3% on Something-Something V2, 90.8% on UCF101, and 61.1% on HMDB51 without using any extra data.</em>",ct,S,Ts,mt,ae,ws='VideoMAE pre-training. Taken from the <a href="https://arxiv.org/abs/2203.12602">original paper</a>.',pt,re,js=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/MCG-NJU/VideoMAE" rel="nofollow">here</a>.`,ht,le,ft,ie,Js=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,ut,de,Us=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,gt,ce,Mt,me,vs="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",_t,pe,Cs="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>MCG-NJU/videomae-base-finetuned-kinetics</code> model, we saw the following speedups during inference.",yt,he,Vs="<thead><tr><th>Batch size</th> <th>Average inference time (ms), eager mode</th> <th>Average inference time (ms), sdpa model</th> <th>Speed up, Sdpa / Eager (x)</th></tr></thead> <tbody><tr><td>1</td> <td>37</td> <td>10</td> <td>3.7</td></tr> <tr><td>2</td> <td>24</td> <td>18</td> <td>1.33</td></tr> <tr><td>4</td> <td>43</td> <td>32</td> <td>1.34</td></tr> <tr><td>8</td> <td>84</td> <td>60</td> <td>1.4</td></tr></tbody>",bt,fe,Tt,ue,Is=`A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with VideoMAE. If
you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll
review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.`,wt,ge,Zs="<strong>Video classification</strong>",jt,Me,Es=`<li><a href="https://github.com/huggingface/notebooks/blob/main/examples/video_classification.ipynb" rel="nofollow">A notebook</a> that shows how
to fine-tune a VideoMAE model on a custom dataset.</li> <li><a href="../tasks/video_classification">Video classification task guide</a></li> <li><a href="https://huggingface.co/spaces/sayakpaul/video-classification-ucf101-subset" rel="nofollow">A 🤗 Space</a> showing how to perform inference with a video classification model.</li>`,Jt,_e,Ut,V,ye,Nt,Ne,As=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a>. It is used to instantiate a
VideoMAE model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the VideoMAE
<a href="https://huggingface.co/MCG-NJU/videomae-base" rel="nofollow">MCG-NJU/videomae-base</a> architecture.`,Rt,Re,xs=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,St,X,vt,be,Ct,N,Te,Xt,Y,we,Yt,Se,Ws="Preprocess an image or a batch of images.",Vt,je,It,W,Je,Qt,Xe,$s="Constructs a VideoMAE image processor.",Pt,Q,Ue,Ht,Ye,ks="Preprocess an image or batch of images.",Zt,ve,Et,U,Ce,Lt,Qe,Bs="The bare Videomae Model outputting raw hidden-states without any specific head on top.",Dt,Pe,Gs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,qt,He,zs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Kt,E,Ve,Ot,Le,Fs='The <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a> forward method, overrides the <code>__call__</code> special method.',es,P,ts,H,At,Ie,xt,Ze,Ns="<code>VideoMAEForPreTraining</code> includes the decoder on top for self-supervised pre-training.",Wt,v,Ee,ss,De,Rs="The VideoMAE Model transformer with the decoder on top for self-supervised pre-training.",ns,qe,Ss=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,os,Ke,Xs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,as,A,Ae,rs,Oe,Ys='The <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',ls,L,is,D,$t,xe,kt,C,We,ds,et,Qs=`VideoMAE Model transformer with a video classification head on top (a linear layer on top of the average pooled hidden
states of all tokens) e.g. for ImageNet.`,cs,tt,Ps=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ms,st,Hs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ps,x,$e,hs,nt,Ls='The <a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEForVideoClassification">VideoMAEForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',fs,q,us,K,Bt,ke,Gt,ot,zt;return b=new F({props:{title:"VideoMAE",local:"videomae",headingTag:"h1"}}),te=new F({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new F({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h2"}}),ce=new at({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFRm9yVmlkZW9DbGFzc2lmaWNhdGlvbiUwQW1vZGVsJTIwJTNEJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJNQ0ctTkpVJTJGdmlkZW9tYWUtYmFzZS1maW5ldHVuZWQta2luZXRpY3MlMjIlMkMlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNEJTIyc2RwYSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEEuLi4=",highlighted:`from transformers import VideoMAEForVideoClassification
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">VideoMAEForVideoClassification</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>
...`,wrap:!1}}),fe=new F({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new F({props:{title:"VideoMAEConfig",local:"transformers.VideoMAEConfig",headingTag:"h2"}}),ye=new B({props:{name:"class transformers.VideoMAEConfig",anchor:"transformers.VideoMAEConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"num_frames",val:" = 16"},{name:"tubelet_size",val:" = 2"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"qkv_bias",val:" = True"},{name:"use_mean_pooling",val:" = True"},{name:"decoder_num_attention_heads",val:" = 6"},{name:"decoder_hidden_size",val:" = 384"},{name:"decoder_num_hidden_layers",val:" = 4"},{name:"decoder_intermediate_size",val:" = 1536"},{name:"norm_pix_loss",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.VideoMAEConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.VideoMAEConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.VideoMAEConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.VideoMAEConfig.tubelet_size",description:`<strong>tubelet_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The number of tubelets.`,name:"tubelet_size"},{anchor:"transformers.VideoMAEConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.VideoMAEConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.VideoMAEConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.VideoMAEConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.VideoMAEConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.VideoMAEConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.VideoMAEConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.VideoMAEConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VideoMAEConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.VideoMAEConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.VideoMAEConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to mean pool the final hidden states instead of using the final hidden state of the [CLS] token.`,name:"use_mean_pooling"},{anchor:"transformers.VideoMAEConfig.decoder_num_attention_heads",description:`<strong>decoder_num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of attention heads for each attention layer in the decoder.`,name:"decoder_num_attention_heads"},{anchor:"transformers.VideoMAEConfig.decoder_hidden_size",description:`<strong>decoder_hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 384) &#x2014;
Dimensionality of the decoder.`,name:"decoder_hidden_size"},{anchor:"transformers.VideoMAEConfig.decoder_num_hidden_layers",description:`<strong>decoder_num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of hidden layers in the decoder.`,name:"decoder_num_hidden_layers"},{anchor:"transformers.VideoMAEConfig.decoder_intermediate_size",description:`<strong>decoder_intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1536) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the decoder.`,name:"decoder_intermediate_size"},{anchor:"transformers.VideoMAEConfig.norm_pix_loss",description:`<strong>norm_pix_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the target patch pixels.`,name:"norm_pix_loss"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/configuration_videomae.py#L24"}}),X=new Ft({props:{anchor:"transformers.VideoMAEConfig.example",$$slots:{default:[nn]},$$scope:{ctx:J}}}),be=new F({props:{title:"VideoMAEFeatureExtractor",local:"transformers.VideoMAEFeatureExtractor",headingTag:"h2"}}),Te=new B({props:{name:"class transformers.VideoMAEFeatureExtractor",anchor:"transformers.VideoMAEFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/feature_extraction_videomae.py#L27"}}),we=new B({props:{name:"__call__",anchor:"transformers.VideoMAEFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L42"}}),je=new F({props:{title:"VideoMAEImageProcessor",local:"transformers.VideoMAEImageProcessor",headingTag:"h2"}}),Je=new B({props:{name:"class transformers.VideoMAEImageProcessor",anchor:"transformers.VideoMAEImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoMAEImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the output image after resizing. The shortest edge of the image will be resized to
<code>size[&quot;shortest_edge&quot;]</code> while maintaining the aspect ratio of the original image. Can be overridden by
<code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VideoMAEImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoMAEImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoMAEImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after applying the center crop. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.VideoMAEImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoMAEImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.VideoMAEImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.VideoMAEImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoMAEImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/image_processing_videomae.py#L64"}}),Ue=new B({props:{name:"preprocess",anchor:"transformers.VideoMAEImageProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after applying resize.`,name:"size"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_centre_crop</code>) &#x2014;
Whether to centre crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after applying the centre crop.`,name:"crop_size"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the inferred channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoMAEImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/image_processing_videomae.py#L237"}}),ve=new F({props:{title:"VideoMAEModel",local:"transformers.VideoMAEModel",headingTag:"h2"}}),Ce=new B({props:{name:"class transformers.VideoMAEModel",anchor:"transformers.VideoMAEModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEModel">VideoMAEModel</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/modeling_videomae.py#L508"}}),Ve=new B({props:{name:"forward",anchor:"transformers.VideoMAEModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VideoMAEModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0). Each video in the
batch must have the same number of masked patches. If <code>None</code>, then all patches are considered. Sequence
length is <code>(num_frames // tubelet_size) * (image_size // patch_size) ** 2</code>.`,name:"bool_masked_pos"},{anchor:"transformers.VideoMAEModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/modeling_videomae.py#L536",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new gs({props:{$$slots:{default:[on]},$$scope:{ctx:J}}}),H=new Ft({props:{anchor:"transformers.VideoMAEModel.forward.example",$$slots:{default:[an]},$$scope:{ctx:J}}}),Ie=new F({props:{title:"VideoMAEForPreTraining",local:"transformers.VideoMAEForPreTraining",headingTag:"h2"}}),Ee=new B({props:{name:"class transformers.VideoMAEForPreTraining",anchor:"transformers.VideoMAEForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEForPreTraining">VideoMAEForPreTraining</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/modeling_videomae.py#L729"}}),Ae=new B({props:{name:"forward",anchor:"transformers.VideoMAEForPreTraining.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"bool_masked_pos",val:": BoolTensor"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEForPreTraining.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VideoMAEForPreTraining.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0). Each video in the
batch must have the same number of masked patches. Sequence length is <code>(num_frames // tubelet_size) * (image_size // patch_size) ** 2</code>.`,name:"bool_masked_pos"},{anchor:"transformers.VideoMAEForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/modeling_videomae.py#L752",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.videomae.modeling_videomae.VideoMAEForPreTrainingOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Pixel reconstruction loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, patch_size ** 2 * num_channels)</code>) — Pixel reconstruction logits.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.videomae.modeling_videomae.VideoMAEForPreTrainingOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),L=new gs({props:{$$slots:{default:[rn]},$$scope:{ctx:J}}}),D=new Ft({props:{anchor:"transformers.VideoMAEForPreTraining.forward.example",$$slots:{default:[ln]},$$scope:{ctx:J}}}),xe=new F({props:{title:"VideoMAEForVideoClassification",local:"transformers.VideoMAEForVideoClassification",headingTag:"h2"}}),We=new B({props:{name:"class transformers.VideoMAEForVideoClassification",anchor:"transformers.VideoMAEForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.VideoMAEForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEForVideoClassification">VideoMAEForVideoClassification</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/modeling_videomae.py#L911"}}),$e=new B({props:{name:"forward",anchor:"transformers.VideoMAEForVideoClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VideoMAEForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>, <em>optional</em>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VideoMAEForVideoClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.VideoMAEForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"},{anchor:"transformers.VideoMAEForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoMAEForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoMAEForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/videomae/modeling_videomae.py#L931",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/videomae#transformers.VideoMAEConfig"
>VideoMAEConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new gs({props:{$$slots:{default:[dn]},$$scope:{ctx:J}}}),K=new Ft({props:{anchor:"transformers.VideoMAEForVideoClassification.forward.example",$$slots:{default:[cn]},$$scope:{ctx:J}}}),ke=new sn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/videomae.md"}}),{c(){r=i("meta"),T=o(),m=i("p"),p=o(),f(b.$$.fragment),l=o(),w=i("div"),w.innerHTML=Ms,rt=o(),f(te.$$.fragment),lt=o(),se=i("p"),se.innerHTML=_s,it=o(),ne=i("p"),ne.textContent=ys,dt=o(),oe=i("p"),oe.innerHTML=bs,ct=o(),S=i("img"),mt=o(),ae=i("small"),ae.innerHTML=ws,pt=o(),re=i("p"),re.innerHTML=js,ht=o(),f(le.$$.fragment),ft=o(),ie=i("p"),ie.innerHTML=Js,ut=o(),de=i("p"),de.innerHTML=Us,gt=o(),f(ce.$$.fragment),Mt=o(),me=i("p"),me.innerHTML=vs,_t=o(),pe=i("p"),pe.innerHTML=Cs,yt=o(),he=i("table"),he.innerHTML=Vs,bt=o(),f(fe.$$.fragment),Tt=o(),ue=i("p"),ue.textContent=Is,wt=o(),ge=i("p"),ge.innerHTML=Zs,jt=o(),Me=i("ul"),Me.innerHTML=Es,Jt=o(),f(_e.$$.fragment),Ut=o(),V=i("div"),f(ye.$$.fragment),Nt=o(),Ne=i("p"),Ne.innerHTML=As,Rt=o(),Re=i("p"),Re.innerHTML=xs,St=o(),f(X.$$.fragment),vt=o(),f(be.$$.fragment),Ct=o(),N=i("div"),f(Te.$$.fragment),Xt=o(),Y=i("div"),f(we.$$.fragment),Yt=o(),Se=i("p"),Se.textContent=Ws,Vt=o(),f(je.$$.fragment),It=o(),W=i("div"),f(Je.$$.fragment),Qt=o(),Xe=i("p"),Xe.textContent=$s,Pt=o(),Q=i("div"),f(Ue.$$.fragment),Ht=o(),Ye=i("p"),Ye.textContent=ks,Zt=o(),f(ve.$$.fragment),Et=o(),U=i("div"),f(Ce.$$.fragment),Lt=o(),Qe=i("p"),Qe.textContent=Bs,Dt=o(),Pe=i("p"),Pe.innerHTML=Gs,qt=o(),He=i("p"),He.innerHTML=zs,Kt=o(),E=i("div"),f(Ve.$$.fragment),Ot=o(),Le=i("p"),Le.innerHTML=Fs,es=o(),f(P.$$.fragment),ts=o(),f(H.$$.fragment),At=o(),f(Ie.$$.fragment),xt=o(),Ze=i("p"),Ze.innerHTML=Ns,Wt=o(),v=i("div"),f(Ee.$$.fragment),ss=o(),De=i("p"),De.textContent=Rs,ns=o(),qe=i("p"),qe.innerHTML=Ss,os=o(),Ke=i("p"),Ke.innerHTML=Xs,as=o(),A=i("div"),f(Ae.$$.fragment),rs=o(),Oe=i("p"),Oe.innerHTML=Ys,ls=o(),f(L.$$.fragment),is=o(),f(D.$$.fragment),$t=o(),f(xe.$$.fragment),kt=o(),C=i("div"),f(We.$$.fragment),ds=o(),et=i("p"),et.textContent=Qs,cs=o(),tt=i("p"),tt.innerHTML=Ps,ms=o(),st=i("p"),st.innerHTML=Hs,ps=o(),x=i("div"),f($e.$$.fragment),hs=o(),nt=i("p"),nt.innerHTML=Ls,fs=o(),f(q.$$.fragment),us=o(),f(K.$$.fragment),Bt=o(),f(ke.$$.fragment),Gt=o(),ot=i("p"),this.h()},l(e){const t=tn("svelte-u9bgzb",document.head);r=d(t,"META",{name:!0,content:!0}),t.forEach(s),T=a(e),m=d(e,"P",{}),Z(m).forEach(s),p=a(e),u(b.$$.fragment,e),l=a(e),w=d(e,"DIV",{class:!0,"data-svelte-h":!0}),h(w)!=="svelte-b95w5j"&&(w.innerHTML=Ms),rt=a(e),u(te.$$.fragment,e),lt=a(e),se=d(e,"P",{"data-svelte-h":!0}),h(se)!=="svelte-hyjvdr"&&(se.innerHTML=_s),it=a(e),ne=d(e,"P",{"data-svelte-h":!0}),h(ne)!=="svelte-vfdo9a"&&(ne.textContent=ys),dt=a(e),oe=d(e,"P",{"data-svelte-h":!0}),h(oe)!=="svelte-1rhhtl3"&&(oe.innerHTML=bs),ct=a(e),S=d(e,"IMG",{src:!0,alt:!0,width:!0}),mt=a(e),ae=d(e,"SMALL",{"data-svelte-h":!0}),h(ae)!=="svelte-19gew7l"&&(ae.innerHTML=ws),pt=a(e),re=d(e,"P",{"data-svelte-h":!0}),h(re)!=="svelte-xbyn5w"&&(re.innerHTML=js),ht=a(e),u(le.$$.fragment,e),ft=a(e),ie=d(e,"P",{"data-svelte-h":!0}),h(ie)!=="svelte-1cid2pe"&&(ie.innerHTML=Js),ut=a(e),de=d(e,"P",{"data-svelte-h":!0}),h(de)!=="svelte-1x11lxg"&&(de.innerHTML=Us),gt=a(e),u(ce.$$.fragment,e),Mt=a(e),me=d(e,"P",{"data-svelte-h":!0}),h(me)!=="svelte-djb2w0"&&(me.innerHTML=vs),_t=a(e),pe=d(e,"P",{"data-svelte-h":!0}),h(pe)!=="svelte-4qwk99"&&(pe.innerHTML=Cs),yt=a(e),he=d(e,"TABLE",{"data-svelte-h":!0}),h(he)!=="svelte-fxnugv"&&(he.innerHTML=Vs),bt=a(e),u(fe.$$.fragment,e),Tt=a(e),ue=d(e,"P",{"data-svelte-h":!0}),h(ue)!=="svelte-1k7bn0h"&&(ue.textContent=Is),wt=a(e),ge=d(e,"P",{"data-svelte-h":!0}),h(ge)!=="svelte-yaiu72"&&(ge.innerHTML=Zs),jt=a(e),Me=d(e,"UL",{"data-svelte-h":!0}),h(Me)!=="svelte-19n7fq5"&&(Me.innerHTML=Es),Jt=a(e),u(_e.$$.fragment,e),Ut=a(e),V=d(e,"DIV",{class:!0});var $=Z(V);u(ye.$$.fragment,$),Nt=a($),Ne=d($,"P",{"data-svelte-h":!0}),h(Ne)!=="svelte-1803vkl"&&(Ne.innerHTML=As),Rt=a($),Re=d($,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-o55m63"&&(Re.innerHTML=xs),St=a($),u(X.$$.fragment,$),$.forEach(s),vt=a(e),u(be.$$.fragment,e),Ct=a(e),N=d(e,"DIV",{class:!0});var Be=Z(N);u(Te.$$.fragment,Be),Xt=a(Be),Y=d(Be,"DIV",{class:!0});var Ge=Z(Y);u(we.$$.fragment,Ge),Yt=a(Ge),Se=d(Ge,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-khengj"&&(Se.textContent=Ws),Ge.forEach(s),Be.forEach(s),Vt=a(e),u(je.$$.fragment,e),It=a(e),W=d(e,"DIV",{class:!0});var R=Z(W);u(Je.$$.fragment,R),Qt=a(R),Xe=d(R,"P",{"data-svelte-h":!0}),h(Xe)!=="svelte-uyvre4"&&(Xe.textContent=$s),Pt=a(R),Q=d(R,"DIV",{class:!0});var ze=Z(Q);u(Ue.$$.fragment,ze),Ht=a(ze),Ye=d(ze,"P",{"data-svelte-h":!0}),h(Ye)!=="svelte-1x3yxsa"&&(Ye.textContent=ks),ze.forEach(s),R.forEach(s),Zt=a(e),u(ve.$$.fragment,e),Et=a(e),U=d(e,"DIV",{class:!0});var I=Z(U);u(Ce.$$.fragment,I),Lt=a(I),Qe=d(I,"P",{"data-svelte-h":!0}),h(Qe)!=="svelte-165ggd0"&&(Qe.textContent=Bs),Dt=a(I),Pe=d(I,"P",{"data-svelte-h":!0}),h(Pe)!=="svelte-6pahdo"&&(Pe.innerHTML=Gs),qt=a(I),He=d(I,"P",{"data-svelte-h":!0}),h(He)!=="svelte-hswkmf"&&(He.innerHTML=zs),Kt=a(I),E=d(I,"DIV",{class:!0});var k=Z(E);u(Ve.$$.fragment,k),Ot=a(k),Le=d(k,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-vac3jf"&&(Le.innerHTML=Fs),es=a(k),u(P.$$.fragment,k),ts=a(k),u(H.$$.fragment,k),k.forEach(s),I.forEach(s),At=a(e),u(Ie.$$.fragment,e),xt=a(e),Ze=d(e,"P",{"data-svelte-h":!0}),h(Ze)!=="svelte-lskn4n"&&(Ze.innerHTML=Ns),Wt=a(e),v=d(e,"DIV",{class:!0});var G=Z(v);u(Ee.$$.fragment,G),ss=a(G),De=d(G,"P",{"data-svelte-h":!0}),h(De)!=="svelte-18nz2cc"&&(De.textContent=Rs),ns=a(G),qe=d(G,"P",{"data-svelte-h":!0}),h(qe)!=="svelte-6pahdo"&&(qe.innerHTML=Ss),os=a(G),Ke=d(G,"P",{"data-svelte-h":!0}),h(Ke)!=="svelte-hswkmf"&&(Ke.innerHTML=Xs),as=a(G),A=d(G,"DIV",{class:!0});var O=Z(A);u(Ae.$$.fragment,O),rs=a(O),Oe=d(O,"P",{"data-svelte-h":!0}),h(Oe)!=="svelte-1fondwb"&&(Oe.innerHTML=Ys),ls=a(O),u(L.$$.fragment,O),is=a(O),u(D.$$.fragment,O),O.forEach(s),G.forEach(s),$t=a(e),u(xe.$$.fragment,e),kt=a(e),C=d(e,"DIV",{class:!0});var z=Z(C);u(We.$$.fragment,z),ds=a(z),et=d(z,"P",{"data-svelte-h":!0}),h(et)!=="svelte-ywpsah"&&(et.textContent=Qs),cs=a(z),tt=d(z,"P",{"data-svelte-h":!0}),h(tt)!=="svelte-6pahdo"&&(tt.innerHTML=Ps),ms=a(z),st=d(z,"P",{"data-svelte-h":!0}),h(st)!=="svelte-hswkmf"&&(st.innerHTML=Hs),ps=a(z),x=d(z,"DIV",{class:!0});var ee=Z(x);u($e.$$.fragment,ee),hs=a(ee),nt=d(ee,"P",{"data-svelte-h":!0}),h(nt)!=="svelte-1nb9my3"&&(nt.innerHTML=Ls),fs=a(ee),u(q.$$.fragment,ee),us=a(ee),u(K.$$.fragment,ee),ee.forEach(s),z.forEach(s),Bt=a(e),u(ke.$$.fragment,e),Gt=a(e),ot=d(e,"P",{}),Z(ot).forEach(s),this.h()},h(){j(r,"name","hf:doc:metadata"),j(r,"content",pn),j(w,"class","flex flex-wrap space-x-1"),qs(S.src,Ts="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/videomae_architecture.jpeg")||j(S,"src",Ts),j(S,"alt","drawing"),j(S,"width","600"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){c(document.head,r),n(e,T,t),n(e,m,t),n(e,p,t),g(b,e,t),n(e,l,t),n(e,w,t),n(e,rt,t),g(te,e,t),n(e,lt,t),n(e,se,t),n(e,it,t),n(e,ne,t),n(e,dt,t),n(e,oe,t),n(e,ct,t),n(e,S,t),n(e,mt,t),n(e,ae,t),n(e,pt,t),n(e,re,t),n(e,ht,t),g(le,e,t),n(e,ft,t),n(e,ie,t),n(e,ut,t),n(e,de,t),n(e,gt,t),g(ce,e,t),n(e,Mt,t),n(e,me,t),n(e,_t,t),n(e,pe,t),n(e,yt,t),n(e,he,t),n(e,bt,t),g(fe,e,t),n(e,Tt,t),n(e,ue,t),n(e,wt,t),n(e,ge,t),n(e,jt,t),n(e,Me,t),n(e,Jt,t),g(_e,e,t),n(e,Ut,t),n(e,V,t),g(ye,V,null),c(V,Nt),c(V,Ne),c(V,Rt),c(V,Re),c(V,St),g(X,V,null),n(e,vt,t),g(be,e,t),n(e,Ct,t),n(e,N,t),g(Te,N,null),c(N,Xt),c(N,Y),g(we,Y,null),c(Y,Yt),c(Y,Se),n(e,Vt,t),g(je,e,t),n(e,It,t),n(e,W,t),g(Je,W,null),c(W,Qt),c(W,Xe),c(W,Pt),c(W,Q),g(Ue,Q,null),c(Q,Ht),c(Q,Ye),n(e,Zt,t),g(ve,e,t),n(e,Et,t),n(e,U,t),g(Ce,U,null),c(U,Lt),c(U,Qe),c(U,Dt),c(U,Pe),c(U,qt),c(U,He),c(U,Kt),c(U,E),g(Ve,E,null),c(E,Ot),c(E,Le),c(E,es),g(P,E,null),c(E,ts),g(H,E,null),n(e,At,t),g(Ie,e,t),n(e,xt,t),n(e,Ze,t),n(e,Wt,t),n(e,v,t),g(Ee,v,null),c(v,ss),c(v,De),c(v,ns),c(v,qe),c(v,os),c(v,Ke),c(v,as),c(v,A),g(Ae,A,null),c(A,rs),c(A,Oe),c(A,ls),g(L,A,null),c(A,is),g(D,A,null),n(e,$t,t),g(xe,e,t),n(e,kt,t),n(e,C,t),g(We,C,null),c(C,ds),c(C,et),c(C,cs),c(C,tt),c(C,ms),c(C,st),c(C,ps),c(C,x),g($e,x,null),c(x,hs),c(x,nt),c(x,fs),g(q,x,null),c(x,us),g(K,x,null),n(e,Bt,t),g(ke,e,t),n(e,Gt,t),n(e,ot,t),zt=!0},p(e,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:e}),X.$set($);const Be={};t&2&&(Be.$$scope={dirty:t,ctx:e}),P.$set(Be);const Ge={};t&2&&(Ge.$$scope={dirty:t,ctx:e}),H.$set(Ge);const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),L.$set(R);const ze={};t&2&&(ze.$$scope={dirty:t,ctx:e}),D.$set(ze);const I={};t&2&&(I.$$scope={dirty:t,ctx:e}),q.$set(I);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),K.$set(k)},i(e){zt||(M(b.$$.fragment,e),M(te.$$.fragment,e),M(le.$$.fragment,e),M(ce.$$.fragment,e),M(fe.$$.fragment,e),M(_e.$$.fragment,e),M(ye.$$.fragment,e),M(X.$$.fragment,e),M(be.$$.fragment,e),M(Te.$$.fragment,e),M(we.$$.fragment,e),M(je.$$.fragment,e),M(Je.$$.fragment,e),M(Ue.$$.fragment,e),M(ve.$$.fragment,e),M(Ce.$$.fragment,e),M(Ve.$$.fragment,e),M(P.$$.fragment,e),M(H.$$.fragment,e),M(Ie.$$.fragment,e),M(Ee.$$.fragment,e),M(Ae.$$.fragment,e),M(L.$$.fragment,e),M(D.$$.fragment,e),M(xe.$$.fragment,e),M(We.$$.fragment,e),M($e.$$.fragment,e),M(q.$$.fragment,e),M(K.$$.fragment,e),M(ke.$$.fragment,e),zt=!0)},o(e){_(b.$$.fragment,e),_(te.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(fe.$$.fragment,e),_(_e.$$.fragment,e),_(ye.$$.fragment,e),_(X.$$.fragment,e),_(be.$$.fragment,e),_(Te.$$.fragment,e),_(we.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_(Ue.$$.fragment,e),_(ve.$$.fragment,e),_(Ce.$$.fragment,e),_(Ve.$$.fragment,e),_(P.$$.fragment,e),_(H.$$.fragment,e),_(Ie.$$.fragment,e),_(Ee.$$.fragment,e),_(Ae.$$.fragment,e),_(L.$$.fragment,e),_(D.$$.fragment,e),_(xe.$$.fragment,e),_(We.$$.fragment,e),_($e.$$.fragment,e),_(q.$$.fragment,e),_(K.$$.fragment,e),_(ke.$$.fragment,e),zt=!1},d(e){e&&(s(T),s(m),s(p),s(l),s(w),s(rt),s(lt),s(se),s(it),s(ne),s(dt),s(oe),s(ct),s(S),s(mt),s(ae),s(pt),s(re),s(ht),s(ft),s(ie),s(ut),s(de),s(gt),s(Mt),s(me),s(_t),s(pe),s(yt),s(he),s(bt),s(Tt),s(ue),s(wt),s(ge),s(jt),s(Me),s(Jt),s(Ut),s(V),s(vt),s(Ct),s(N),s(Vt),s(It),s(W),s(Zt),s(Et),s(U),s(At),s(xt),s(Ze),s(Wt),s(v),s($t),s(kt),s(C),s(Bt),s(Gt),s(ot)),s(r),y(b,e),y(te,e),y(le,e),y(ce,e),y(fe,e),y(_e,e),y(ye),y(X),y(be,e),y(Te),y(we),y(je,e),y(Je),y(Ue),y(ve,e),y(Ce),y(Ve),y(P),y(H),y(Ie,e),y(Ee),y(Ae),y(L),y(D),y(xe,e),y(We),y($e),y(q),y(K),y(ke,e)}}}const pn='{"title":"VideoMAE","local":"videomae","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"VideoMAEConfig","local":"transformers.VideoMAEConfig","sections":[],"depth":2},{"title":"VideoMAEFeatureExtractor","local":"transformers.VideoMAEFeatureExtractor","sections":[],"depth":2},{"title":"VideoMAEImageProcessor","local":"transformers.VideoMAEImageProcessor","sections":[],"depth":2},{"title":"VideoMAEModel","local":"transformers.VideoMAEModel","sections":[],"depth":2},{"title":"VideoMAEForPreTraining","local":"transformers.VideoMAEForPreTraining","sections":[],"depth":2},{"title":"VideoMAEForVideoClassification","local":"transformers.VideoMAEForVideoClassification","sections":[],"depth":2}],"depth":1}';function hn(J){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wn extends Os{constructor(r){super(),en(this,r,hn,mn,Ds,{})}}export{wn as component};
