import{s as Mt,z as ct,o as mt,n as xs}from"../chunks/scheduler.18a86fab.js";import{S as dt,i as yt,g as o,s as a,r as m,A as ht,h as r,f as t,c as l,j as W,u as d,x as p,k as w,y as M,a as n,v as y,d as h,t as U,w as u}from"../chunks/index.98837b22.js";import{T as Ut}from"../chunks/Tip.77304350.js";import{D as xe}from"../chunks/Docstring.6758ea23.js";import{C as Qe}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as pt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as k}from"../chunks/Heading.7e7e0c5b.js";import{E as ut}from"../chunks/index.92f616ba.js";function jt(V){let c,J="Example:",f,j,b;return j=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpdFBvc2VDb25maWclMkMlMjBWaXRQb3NlRm9yUG9zZUVzdGltYXRpb24lMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwVml0UG9zZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVml0UG9zZUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBWaXRQb3NlRm9yUG9zZUVzdGltYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VitPoseConfig, VitPoseForPoseEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VitPose configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VitPoseConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitPoseForPoseEstimation(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=o("p"),c.textContent=J,f=a(),m(j.$$.fragment)},l(i){c=r(i,"P",{"data-svelte-h":!0}),p(c)!=="svelte-11lpom8"&&(c.textContent=J),f=l(i),d(j.$$.fragment,i)},m(i,g){n(i,c,g),n(i,f,g),y(j,i,g),b=!0},p:xs,i(i){b||(h(j.$$.fragment,i),b=!0)},o(i){U(j.$$.fragment,i),b=!1},d(i){i&&(t(c),t(f)),u(j,i)}}}function ft(V){let c,J=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=o("p"),c.innerHTML=J},l(f){c=r(f,"P",{"data-svelte-h":!0}),p(c)!=="svelte-fincs2"&&(c.innerHTML=J)},m(f,j){n(f,c,j)},p:xs,d(f){f&&t(c)}}}function bt(V){let c,J="Examples:",f,j,b;return j=new Qe({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFZpdFBvc2VGb3JQb3NlRXN0aW1hdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMnVzeWQtY29tbXVuaXR5JTJGdml0cG9zZS1iYXNlLXNpbXBsZSUyMiklMEFtb2RlbCUyMCUzRCUyMFZpdFBvc2VGb3JQb3NlRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydXN5ZC1jb21tdW5pdHklMkZ2aXRwb3NlLWJhc2Utc2ltcGxlJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFib3hlcyUyMCUzRCUyMCU1QiU1QiU1QjQxMi44JTJDJTIwMTU3LjYxJTJDJTIwNTMuMDUlMkMlMjAxMzguMDElNUQlMkMlMjAlNUIzODQuNDMlMkMlMjAxNzIuMjElMkMlMjAxNS4xMiUyQyUyMDM1Ljc0JTVEJTVEJTVEJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwYm94ZXMlM0Rib3hlcyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFoZWF0bWFwcyUyMCUzRCUyMG91dHB1dHMuaGVhdG1hcHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, VitPoseForPoseEstimation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;usyd-community/vitpose-base-simple&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VitPoseForPoseEstimation.from_pretrained(<span class="hljs-string">&quot;usyd-community/vitpose-base-simple&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>boxes = [[[<span class="hljs-number">412.8</span>, <span class="hljs-number">157.61</span>, <span class="hljs-number">53.05</span>, <span class="hljs-number">138.01</span>], [<span class="hljs-number">384.43</span>, <span class="hljs-number">172.21</span>, <span class="hljs-number">15.12</span>, <span class="hljs-number">35.74</span>]]]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, boxes=boxes, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>heatmaps = outputs.heatmaps`,wrap:!1}}),{c(){c=o("p"),c.textContent=J,f=a(),m(j.$$.fragment)},l(i){c=r(i,"P",{"data-svelte-h":!0}),p(c)!=="svelte-kvfsh7"&&(c.textContent=J),f=l(i),d(j.$$.fragment,i)},m(i,g){n(i,c,g),n(i,f,g),y(j,i,g),b=!0},p:xs,i(i){b||(h(j.$$.fragment,i),b=!0)},o(i){U(j.$$.fragment,i),b=!1},d(i){i&&(t(c),t(f)),u(j,i)}}}function gt(V){let c,J,f,j,b,i,g,Qs='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Ee,P,Ge,X,Zs=`The ViTPose model was proposed in <a href="https://arxiv.org/abs/2204.12484" rel="nofollow">ViTPose: Simple Vision Transformer Baselines for Human Pose Estimation</a> by Yufei Xu, Jing Zhang, Qiming Zhang, Dacheng Tao. ViTPose employs a standard, non-hierarchical <a href="vit">Vision Transformer</a> as backbone for the task of keypoint estimation. A simple decoder head is added on top to predict the heatmaps from a given image. Despite its simplicity, the model gets state-of-the-art results on the challenging MS COCO Keypoint Detection benchmark. The model was further improved in <a href="https://arxiv.org/abs/2212.04246" rel="nofollow">ViTPose++: Vision Transformer for Generic Body Pose Estimation</a> where the authors employ
a mixture-of-experts (MoE) module in the ViT backbone along with pre-training on more data, which further enhances the performance.`,Ne,R,Es="The abstract from the paper is the following:",ze,$,Gs="<em>Although no specific domain knowledge is considered in the design, plain vision transformers have shown excellent performance in visual recognition tasks. However, little effort has been made to reveal the potential of such simple structures for pose estimation tasks. In this paper, we show the surprisingly good capabilities of plain vision transformers for pose estimation from various aspects, namely simplicity in model structure, scalability in model size, flexibility in training paradigm, and transferability of knowledge between models, through a simple baseline model called ViTPose. Specifically, ViTPose employs plain and non-hierarchical vision transformers as backbones to extract features for a given person instance and a lightweight decoder for pose estimation. It can be scaled up from 100M to 1B parameters by taking the advantages of the scalable model capacity and high parallelism of transformers, setting a new Pareto front between throughput and performance. Besides, ViTPose is very flexible regarding the attention type, input resolution, pre-training and finetuning strategy, as well as dealing with multiple pose tasks. We also empirically demonstrate that the knowledge of large ViTPose models can be easily transferred to small ones via a simple knowledge token. Experimental results show that our basic ViTPose model outperforms representative methods on the challenging MS COCO Keypoint Detection benchmark, while the largest model sets a new state-of-the-art.</em>",We,B,Ns,Pe,F,zs='ViTPose architecture. Taken from the <a href="https://arxiv.org/abs/2204.12484">original paper.</a>',Xe,L,Ws=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a> and <a href="https://github.com/SangbumChoi" rel="nofollow">sangbumchoi</a>.
The original code can be found <a href="https://github.com/ViTAE-Transformer/ViTPose" rel="nofollow">here</a>.`,Re,D,$e,H,Ps='ViTPose is a so-called top-down keypoint detection model. This means that one first uses an object detector, like <a href="rt_detr.md">RT-DETR</a>, to detect people (or other instances) in an image. Next, ViTPose takes the cropped images as input and predicts the keypoints for each of them.',Fe,Y,Le,K,De,q,Xs='The best <a href="https://huggingface.co/collections/usyd-community/vitpose-677fcfd0a0b2b5c8f79c4335" rel="nofollow">checkpoints</a> are those of the <a href="https://arxiv.org/abs/2212.04246" rel="nofollow">ViTPose++ paper</a>. ViTPose++ models employ a so-called <a href="https://huggingface.co/blog/moe" rel="nofollow">Mixture-of-Experts (MoE)</a> architecture for the ViT backbone, resulting in better performance.',He,O,Rs=`The ViTPose+ checkpoints use 6 experts, hence 6 different dataset indices can be passed.
An overview of the various dataset indices is provided below:`,Ye,ee,$s='<li>0: <a href="https://cocodataset.org/#overview" rel="nofollow">COCO validation 2017</a> dataset, using an object detector that gets 56 AP on the “person” class</li> <li>1: <a href="https://github.com/fabbrimatteo/AiC-Dataset" rel="nofollow">AiC</a> dataset</li> <li>2: <a href="https://www.mpi-inf.mpg.de/departments/computer-vision-and-machine-learning/software-and-datasets/mpii-human-pose-dataset" rel="nofollow">MPII</a> dataset</li> <li>3: <a href="https://github.com/AlexTheBad/AP-10K" rel="nofollow">AP-10K</a> dataset</li> <li>4: <a href="https://github.com/pandorgan/APT-36K" rel="nofollow">APT-36K</a> dataset</li> <li>5: <a href="https://github.com/jin-s13/COCO-WholeBody" rel="nofollow">COCO-WholeBody</a> dataset</li>',Ke,se,Fs="Pass the <code>dataset_index</code> argument in the forward of the model to indicate which experts to use for each example in the batch. Example usage is shown below:",qe,te,Oe,ne,Ls=`The ViTPose+ checkpoints use 6 experts, hence 6 different dataset indices can be passed.
An overview of the various dataset indices is provided below:`,es,ae,Ds='<li>0: <a href="https://cocodataset.org/#overview" rel="nofollow">COCO validation 2017</a> dataset, using an object detector that gets 56 AP on the “person” class</li> <li>1: <a href="https://github.com/fabbrimatteo/AiC-Dataset" rel="nofollow">AiC</a> dataset</li> <li>2: <a href="https://www.mpi-inf.mpg.de/departments/computer-vision-and-machine-learning/software-and-datasets/mpii-human-pose-dataset" rel="nofollow">MPII</a> dataset</li> <li>3: <a href="https://github.com/AlexTheBad/AP-10K" rel="nofollow">AP-10K</a> dataset</li> <li>4: <a href="https://github.com/pandorgan/APT-36K" rel="nofollow">APT-36K</a> dataset</li> <li>5: <a href="https://github.com/jin-s13/COCO-WholeBody" rel="nofollow">COCO-WholeBody</a> dataset</li>',ss,le,ts,oe,Hs='To visualize the various keypoints, one can either leverage the <code>supervision</code> [library](<a href="https://github.com/roboflow/supervision" rel="nofollow">https://github.com/roboflow/supervision</a> (requires <code>pip install supervision</code>):',ns,re,as,ie,Ys='Alternatively, one can also visualize the keypoints using <a href="https://opencv.org/" rel="nofollow">OpenCV</a> (requires <code>pip install opencv-python</code>):',ls,ce,os,S,Ks,rs,pe,is,Me,qs="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with ViTPose. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",cs,me,Os='<li>A demo of ViTPose on images and video can be found <a href="https://huggingface.co/spaces/hysts/ViTPose-transformers" rel="nofollow">here</a>.</li> <li>A notebook illustrating inference and visualization can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/ViTPose/Inference_with_ViTPose_for_human_pose_estimation.ipynb" rel="nofollow">here</a>.</li>',ps,de,Ms,C,ye,fs,Ce,et="Constructs a VitPose image processor.",bs,x,he,gs,_e,st="Preprocess an image or batch of images.",Ts,Q,Ue,ws,Ie,tt="Transform the heatmaps into keypoint predictions and transform them back to the image.",ms,ue,ds,_,je,Js,Ae,nt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/vitpose#transformers.VitPoseForPoseEstimation">VitPoseForPoseEstimation</a>. It is used to instantiate a
VitPose model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the VitPose
<a href="https://huggingface.co/usyd-community/vitpose-base-simple" rel="nofollow">usyd-community/vitpose-base-simple</a> architecture.`,Cs,ve,at=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,_s,Z,ys,fe,hs,T,be,Is,ke,lt="The VitPose model with a pose estimation head on top.",As,Ve,ot=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,vs,Be,rt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ks,I,ge,Vs,Se,it='The <a href="/docs/transformers/main/en/model_doc/vitpose#transformers.VitPoseForPoseEstimation">VitPoseForPoseEstimation</a> forward method, overrides the <code>__call__</code> special method.',Bs,E,Ss,G,Us,Te,us,Ze,js;return b=new k({props:{title:"ViTPose",local:"vitpose",headingTag:"h1"}}),P=new k({props:{title:"Overview",local:"overview",headingTag:"h2"}}),D=new k({props:{title:"Usage Tips",local:"usage-tips",headingTag:"h2"}}),Y=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, RTDetrForObjectDetection, VitPoseForPoseEstimation

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000000139.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># ------------------------------------------------------------------------</span>
<span class="hljs-comment"># Stage 1. Detect humans on the image</span>
<span class="hljs-comment"># ------------------------------------------------------------------------</span>

<span class="hljs-comment"># You can choose any detector of your choice</span>
person_image_processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd_coco_o365&quot;</span>)
person_model = RTDetrForObjectDetection.from_pretrained(<span class="hljs-string">&quot;PekingU/rtdetr_r50vd_coco_o365&quot;</span>, device_map=device)

inputs = person_image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = person_model(**inputs)

results = person_image_processor.post_process_object_detection(
    outputs, target_sizes=torch.tensor([(image.height, image.width)]), threshold=<span class="hljs-number">0.3</span>
)
result = results[<span class="hljs-number">0</span>]  <span class="hljs-comment"># take first image results</span>

<span class="hljs-comment"># Human label refers 0 index in COCO dataset</span>
person_boxes = result[<span class="hljs-string">&quot;boxes&quot;</span>][result[<span class="hljs-string">&quot;labels&quot;</span>] == <span class="hljs-number">0</span>]
person_boxes = person_boxes.cpu().numpy()

<span class="hljs-comment"># Convert boxes from VOC (x1, y1, x2, y2) to COCO (x1, y1, w, h) format</span>
person_boxes[:, <span class="hljs-number">2</span>] = person_boxes[:, <span class="hljs-number">2</span>] - person_boxes[:, <span class="hljs-number">0</span>]
person_boxes[:, <span class="hljs-number">3</span>] = person_boxes[:, <span class="hljs-number">3</span>] - person_boxes[:, <span class="hljs-number">1</span>]

<span class="hljs-comment"># ------------------------------------------------------------------------</span>
<span class="hljs-comment"># Stage 2. Detect keypoints for each person found</span>
<span class="hljs-comment"># ------------------------------------------------------------------------</span>

image_processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;usyd-community/vitpose-base-simple&quot;</span>)
model = VitPoseForPoseEstimation.from_pretrained(<span class="hljs-string">&quot;usyd-community/vitpose-base-simple&quot;</span>, device_map=device)

inputs = image_processor(image, boxes=[person_boxes], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs)

pose_results = image_processor.post_process_pose_estimation(outputs, boxes=[person_boxes])
image_pose_result = pose_results[<span class="hljs-number">0</span>]  <span class="hljs-comment"># results for first image</span>`,wrap:!1}}),K=new k({props:{title:"ViTPose++ models",local:"vitpose-models",headingTag:"h3"}}),te=new Qe({props:{code:"aW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIydXN5ZC1jb21tdW5pdHklMkZ2aXRwb3NlLXBsdXMtYmFzZSUyMiklMEFtb2RlbCUyMCUzRCUyMFZpdFBvc2VGb3JQb3NlRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIydXN5ZC1jb21tdW5pdHklMkZ2aXRwb3NlLXBsdXMtYmFzZSUyMiUyQyUyMGRldmljZSUzRGRldmljZSklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjBib3hlcyUzRCU1QnBlcnNvbl9ib3hlcyU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSklMEElMEFkYXRhc2V0X2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjAlNUQlMkMlMjBkZXZpY2UlM0RkZXZpY2UpJTIwJTIzJTIwbXVzdCUyMGJlJTIwYSUyMHRlbnNvciUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwZGF0YXNldF9pbmRleCUzRGRhdGFzZXRfaW5kZXgp",highlighted:`image_processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;usyd-community/vitpose-plus-base&quot;</span>)
model = VitPoseForPoseEstimation.from_pretrained(<span class="hljs-string">&quot;usyd-community/vitpose-plus-base&quot;</span>, device=device)

inputs = image_processor(image, boxes=[person_boxes], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

dataset_index = torch.tensor([<span class="hljs-number">0</span>], device=device) <span class="hljs-comment"># must be a tensor of shape (batch_size,)</span>

<span class="hljs-keyword">with</span> torch.no_grad():
    outputs = model(**inputs, dataset_index=dataset_index)`,wrap:!1}}),le=new k({props:{title:"Visualization",local:"visualization",headingTag:"h3"}}),re=new Qe({props:{code:"aW1wb3J0JTIwc3VwZXJ2aXNpb24lMjBhcyUyMHN2JTBBJTBBeHklMjAlM0QlMjB0b3JjaC5zdGFjayglNUJwb3NlX3Jlc3VsdCU1QidrZXlwb2ludHMnJTVEJTIwZm9yJTIwcG9zZV9yZXN1bHQlMjBpbiUyMGltYWdlX3Bvc2VfcmVzdWx0JTVEKS5jcHUoKS5udW1weSgpJTBBc2NvcmVzJTIwJTNEJTIwdG9yY2guc3RhY2soJTVCcG9zZV9yZXN1bHQlNUInc2NvcmVzJyU1RCUyMGZvciUyMHBvc2VfcmVzdWx0JTIwaW4lMjBpbWFnZV9wb3NlX3Jlc3VsdCU1RCkuY3B1KCkubnVtcHkoKSUwQSUwQWtleV9wb2ludHMlMjAlM0QlMjBzdi5LZXlQb2ludHMoJTBBJTIwJTIwJTIwJTIweHklM0R4eSUyQyUyMGNvbmZpZGVuY2UlM0RzY29yZXMlMEEpJTBBJTBBZWRnZV9hbm5vdGF0b3IlMjAlM0QlMjBzdi5FZGdlQW5ub3RhdG9yKCUwQSUyMCUyMCUyMCUyMGNvbG9yJTNEc3YuQ29sb3IuR1JFRU4lMkMlMEElMjAlMjAlMjAlMjB0aGlja25lc3MlM0QxJTBBKSUwQXZlcnRleF9hbm5vdGF0b3IlMjAlM0QlMjBzdi5WZXJ0ZXhBbm5vdGF0b3IoJTBBJTIwJTIwJTIwJTIwY29sb3IlM0Rzdi5Db2xvci5SRUQlMkMlMEElMjAlMjAlMjAlMjByYWRpdXMlM0QyJTBBKSUwQWFubm90YXRlZF9mcmFtZSUyMCUzRCUyMGVkZ2VfYW5ub3RhdG9yLmFubm90YXRlKCUwQSUyMCUyMCUyMCUyMHNjZW5lJTNEaW1hZ2UuY29weSgpJTJDJTBBJTIwJTIwJTIwJTIwa2V5X3BvaW50cyUzRGtleV9wb2ludHMlMEEpJTBBYW5ub3RhdGVkX2ZyYW1lJTIwJTNEJTIwdmVydGV4X2Fubm90YXRvci5hbm5vdGF0ZSglMEElMjAlMjAlMjAlMjBzY2VuZSUzRGFubm90YXRlZF9mcmFtZSUyQyUwQSUyMCUyMCUyMCUyMGtleV9wb2ludHMlM0RrZXlfcG9pbnRzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> supervision <span class="hljs-keyword">as</span> sv

xy = torch.stack([pose_result[<span class="hljs-string">&#x27;keypoints&#x27;</span>] <span class="hljs-keyword">for</span> pose_result <span class="hljs-keyword">in</span> image_pose_result]).cpu().numpy()
scores = torch.stack([pose_result[<span class="hljs-string">&#x27;scores&#x27;</span>] <span class="hljs-keyword">for</span> pose_result <span class="hljs-keyword">in</span> image_pose_result]).cpu().numpy()

key_points = sv.KeyPoints(
    xy=xy, confidence=scores
)

edge_annotator = sv.EdgeAnnotator(
    color=sv.Color.GREEN,
    thickness=<span class="hljs-number">1</span>
)
vertex_annotator = sv.VertexAnnotator(
    color=sv.Color.RED,
    radius=<span class="hljs-number">2</span>
)
annotated_frame = edge_annotator.annotate(
    scene=image.copy(),
    key_points=key_points
)
annotated_frame = vertex_annotator.annotate(
    scene=annotated_frame,
    key_points=key_points
)`,wrap:!1}}),ce=new Qe({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> math
<span class="hljs-keyword">import</span> cv2

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_points</span>(<span class="hljs-params">image, keypoints, scores, pose_keypoint_color, keypoint_score_threshold, radius, show_keypoint_weight</span>):
    <span class="hljs-keyword">if</span> pose_keypoint_color <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">len</span>(pose_keypoint_color) == <span class="hljs-built_in">len</span>(keypoints)
    <span class="hljs-keyword">for</span> kid, (kpt, kpt_score) <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">zip</span>(keypoints, scores)):
        x_coord, y_coord = <span class="hljs-built_in">int</span>(kpt[<span class="hljs-number">0</span>]), <span class="hljs-built_in">int</span>(kpt[<span class="hljs-number">1</span>])
        <span class="hljs-keyword">if</span> kpt_score &gt; keypoint_score_threshold:
            color = <span class="hljs-built_in">tuple</span>(<span class="hljs-built_in">int</span>(c) <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> pose_keypoint_color[kid])
            <span class="hljs-keyword">if</span> show_keypoint_weight:
                cv2.circle(image, (<span class="hljs-built_in">int</span>(x_coord), <span class="hljs-built_in">int</span>(y_coord)), radius, color, -<span class="hljs-number">1</span>)
                transparency = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">min</span>(<span class="hljs-number">1</span>, kpt_score))
                cv2.addWeighted(image, transparency, image, <span class="hljs-number">1</span> - transparency, <span class="hljs-number">0</span>, dst=image)
            <span class="hljs-keyword">else</span>:
                cv2.circle(image, (<span class="hljs-built_in">int</span>(x_coord), <span class="hljs-built_in">int</span>(y_coord)), radius, color, -<span class="hljs-number">1</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">draw_links</span>(<span class="hljs-params">image, keypoints, scores, keypoint_edges, link_colors, keypoint_score_threshold, thickness, show_keypoint_weight, stick_width = <span class="hljs-number">2</span></span>):
    height, width, _ = image.shape
    <span class="hljs-keyword">if</span> keypoint_edges <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> link_colors <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">len</span>(link_colors) == <span class="hljs-built_in">len</span>(keypoint_edges)
        <span class="hljs-keyword">for</span> sk_id, sk <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(keypoint_edges):
            x1, y1, score1 = (<span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">0</span>], <span class="hljs-number">0</span>]), <span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">0</span>], <span class="hljs-number">1</span>]), scores[sk[<span class="hljs-number">0</span>]])
            x2, y2, score2 = (<span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">1</span>], <span class="hljs-number">0</span>]), <span class="hljs-built_in">int</span>(keypoints[sk[<span class="hljs-number">1</span>], <span class="hljs-number">1</span>]), scores[sk[<span class="hljs-number">1</span>]])
            <span class="hljs-keyword">if</span> (
                x1 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> x1 &lt; width
                <span class="hljs-keyword">and</span> y1 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> y1 &lt; height
                <span class="hljs-keyword">and</span> x2 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> x2 &lt; width
                <span class="hljs-keyword">and</span> y2 &gt; <span class="hljs-number">0</span>
                <span class="hljs-keyword">and</span> y2 &lt; height
                <span class="hljs-keyword">and</span> score1 &gt; keypoint_score_threshold
                <span class="hljs-keyword">and</span> score2 &gt; keypoint_score_threshold
            ):
                color = <span class="hljs-built_in">tuple</span>(<span class="hljs-built_in">int</span>(c) <span class="hljs-keyword">for</span> c <span class="hljs-keyword">in</span> link_colors[sk_id])
                <span class="hljs-keyword">if</span> show_keypoint_weight:
                    X = (x1, x2)
                    Y = (y1, y2)
                    mean_x = np.mean(X)
                    mean_y = np.mean(Y)
                    length = ((Y[<span class="hljs-number">0</span>] - Y[<span class="hljs-number">1</span>]) ** <span class="hljs-number">2</span> + (X[<span class="hljs-number">0</span>] - X[<span class="hljs-number">1</span>]) ** <span class="hljs-number">2</span>) ** <span class="hljs-number">0.5</span>
                    angle = math.degrees(math.atan2(Y[<span class="hljs-number">0</span>] - Y[<span class="hljs-number">1</span>], X[<span class="hljs-number">0</span>] - X[<span class="hljs-number">1</span>]))
                    polygon = cv2.ellipse2Poly(
                        (<span class="hljs-built_in">int</span>(mean_x), <span class="hljs-built_in">int</span>(mean_y)), (<span class="hljs-built_in">int</span>(length / <span class="hljs-number">2</span>), <span class="hljs-built_in">int</span>(stick_width)), <span class="hljs-built_in">int</span>(angle), <span class="hljs-number">0</span>, <span class="hljs-number">360</span>, <span class="hljs-number">1</span>
                    )
                    cv2.fillConvexPoly(image, polygon, color)
                    transparency = <span class="hljs-built_in">max</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">min</span>(<span class="hljs-number">1</span>, <span class="hljs-number">0.5</span> * (keypoints[sk[<span class="hljs-number">0</span>], <span class="hljs-number">2</span>] + keypoints[sk[<span class="hljs-number">1</span>], <span class="hljs-number">2</span>])))
                    cv2.addWeighted(image, transparency, image, <span class="hljs-number">1</span> - transparency, <span class="hljs-number">0</span>, dst=image)
                <span class="hljs-keyword">else</span>:
                    cv2.line(image, (x1, y1), (x2, y2), color, thickness=thickness)


<span class="hljs-comment"># Note: keypoint_edges and color palette are dataset-specific</span>
keypoint_edges = model.config.edges

palette = np.array(
    [
        [<span class="hljs-number">255</span>, <span class="hljs-number">128</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">153</span>, <span class="hljs-number">51</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">178</span>, <span class="hljs-number">102</span>],
        [<span class="hljs-number">230</span>, <span class="hljs-number">230</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">153</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">153</span>, <span class="hljs-number">204</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">102</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">51</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">102</span>, <span class="hljs-number">178</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">51</span>, <span class="hljs-number">153</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">153</span>, <span class="hljs-number">153</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">102</span>, <span class="hljs-number">102</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">51</span>, <span class="hljs-number">51</span>],
        [<span class="hljs-number">153</span>, <span class="hljs-number">255</span>, <span class="hljs-number">153</span>],
        [<span class="hljs-number">102</span>, <span class="hljs-number">255</span>, <span class="hljs-number">102</span>],
        [<span class="hljs-number">51</span>, <span class="hljs-number">255</span>, <span class="hljs-number">51</span>],
        [<span class="hljs-number">0</span>, <span class="hljs-number">255</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">255</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>],
        [<span class="hljs-number">255</span>, <span class="hljs-number">255</span>, <span class="hljs-number">255</span>],
    ]
)

link_colors = palette[[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>]]
keypoint_colors = palette[[<span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">16</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">9</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>]]

numpy_image = np.array(image)

<span class="hljs-keyword">for</span> pose_result <span class="hljs-keyword">in</span> image_pose_result:
    scores = np.array(pose_result[<span class="hljs-string">&quot;scores&quot;</span>])
    keypoints = np.array(pose_result[<span class="hljs-string">&quot;keypoints&quot;</span>])

    <span class="hljs-comment"># draw each point on image</span>
    draw_points(numpy_image, keypoints, scores, keypoint_colors, keypoint_score_threshold=<span class="hljs-number">0.3</span>, radius=<span class="hljs-number">4</span>, show_keypoint_weight=<span class="hljs-literal">False</span>)

    <span class="hljs-comment"># draw links</span>
    draw_links(numpy_image, keypoints, scores, keypoint_edges, link_colors, keypoint_score_threshold=<span class="hljs-number">0.3</span>, thickness=<span class="hljs-number">1</span>, show_keypoint_weight=<span class="hljs-literal">False</span>)

pose_image = Image.fromarray(numpy_image)
pose_image`,wrap:!1}}),pe=new k({props:{title:"Resources",local:"resources",headingTag:"h2"}}),de=new k({props:{title:"VitPoseImageProcessor",local:"transformers.VitPoseImageProcessor",headingTag:"h2"}}),ye=new xe({props:{name:"class transformers.VitPoseImageProcessor",anchor:"transformers.VitPoseImageProcessor",parameters:[{name:"do_affine_transform",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitPoseImageProcessor.do_affine_transform",description:`<strong>do_affine_transform</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply an affine transformation to the input images.`,name:"do_affine_transform"},{anchor:"transformers.VitPoseImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 192}</code>):
Resolution of the image after <code>affine_transform</code> is applied. Only has an effect if <code>do_affine_transform</code> is set to <code>True</code>. Can
be overridden by <code>size</code> in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.VitPoseImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to apply the scaling factor (to make pixel values floats between 0. and 1.).`,name:"do_rescale"},{anchor:"transformers.VitPoseImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.VitPoseImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.VitPoseImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>List[int]</code>, defaults to <code>[0.485, 0.456, 0.406]</code>, <em>optional</em>) &#x2014;
The sequence of means for each channel, to be used when normalizing images.`,name:"image_mean"},{anchor:"transformers.VitPoseImageProcessor.image_std",description:`<strong>image_std</strong> (<code>List[int]</code>, defaults to <code>[0.229, 0.224, 0.225]</code>, <em>optional</em>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitpose/image_processing_vitpose.py#L328"}}),he=new xe({props:{name:"preprocess",anchor:"transformers.VitPoseImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"boxes",val:": typing.Union[typing.List[typing.List[float]], numpy.ndarray]"},{name:"do_affine_transform",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VitPoseImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VitPoseImageProcessor.preprocess.boxes",description:`<strong>boxes</strong> (<code>List[List[List[float]]]</code> or <code>np.ndarray</code>) &#x2014;
List or array of bounding boxes for each image. Each box should be a list of 4 floats representing the bounding
box coordinates in COCO format (top_left_x, top_left_y, width, height).`,name:"boxes"},{anchor:"transformers.VitPoseImageProcessor.preprocess.do_affine_transform",description:`<strong>do_affine_transform</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_affine_transform</code>) &#x2014;
Whether to apply an affine transformation to the input images.`,name:"do_affine_transform"},{anchor:"transformers.VitPoseImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Dictionary in the format <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> specifying the size of the output image after
resizing.`,name:"size"},{anchor:"transformers.VitPoseImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.VitPoseImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VitPoseImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VitPoseImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VitPoseImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_std"},{anchor:"transformers.VitPoseImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>, defaults to <code>&apos;np&apos;</code>) &#x2014;
If set, will return tensors of a particular framework. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return NumPy <code>np.ndarray</code> objects.</li>
<li><code>&apos;jax&apos;</code>: Return JAX <code>jnp.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitpose/image_processing_vitpose.py#L423",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model, of shape (batch_size, num_channels, height,
width).</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Ue=new xe({props:{name:"post_process_pose_estimation",anchor:"transformers.VitPoseImageProcessor.post_process_pose_estimation",parameters:[{name:"outputs",val:": VitPoseEstimatorOutput"},{name:"boxes",val:": typing.Union[typing.List[typing.List[typing.List[float]]], numpy.ndarray]"},{name:"kernel_size",val:": int = 11"},{name:"threshold",val:": typing.Optional[float] = None"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.VitPoseImageProcessor.post_process_pose_estimation.outputs",description:`<strong>outputs</strong> (<code>VitPoseEstimatorOutput</code>) &#x2014;
VitPoseForPoseEstimation model outputs.`,name:"outputs"},{anchor:"transformers.VitPoseImageProcessor.post_process_pose_estimation.boxes",description:`<strong>boxes</strong> (<code>List[List[List[float]]]</code> or <code>np.ndarray</code>) &#x2014;
List or array of bounding boxes for each image. Each box should be a list of 4 floats representing the bounding
box coordinates in COCO format (top_left_x, top_left_y, width, height).`,name:"boxes"},{anchor:"transformers.VitPoseImageProcessor.post_process_pose_estimation.kernel_size",description:`<strong>kernel_size</strong> (<code>int</code>, <em>optional</em>, defaults to 11) &#x2014;
Gaussian kernel size (K) for modulation.`,name:"kernel_size"},{anchor:"transformers.VitPoseImageProcessor.post_process_pose_estimation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to None) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.VitPoseImageProcessor.post_process_pose_estimation.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will be resize with the default value.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitpose/image_processing_vitpose.py#L597",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the keypoints and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[List[Dict]]</code></p>
`}}),ue=new k({props:{title:"VitPoseConfig",local:"transformers.VitPoseConfig",headingTag:"h2"}}),je=new xe({props:{name:"class transformers.VitPoseConfig",anchor:"transformers.VitPoseConfig",parameters:[{name:"backbone_config",val:": typing.Optional[transformers.configuration_utils.PretrainedConfig] = None"},{name:"backbone",val:": typing.Optional[str] = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": typing.Optional[dict] = None"},{name:"initializer_range",val:": float = 0.02"},{name:"scale_factor",val:": int = 4"},{name:"use_simple_decoder",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VitPoseConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>VitPoseBackboneConfig()</code>) &#x2014;
The configuration of the backbone model. Currently, only <code>backbone_config</code> with <code>vitpose_backbone</code> as <code>model_type</code> is supported.`,name:"backbone_config"},{anchor:"transformers.VitPoseConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.VitPoseConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.VitPoseConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.VitPoseConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.VitPoseConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.VitPoseConfig.scale_factor",description:`<strong>scale_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Factor to upscale the feature maps coming from the ViT backbone.`,name:"scale_factor"},{anchor:"transformers.VitPoseConfig.use_simple_decoder",description:`<strong>use_simple_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use a <code>VitPoseSimpleDecoder</code> to decode the feature maps from the backbone into heatmaps. Otherwise it uses <code>VitPoseClassicDecoder</code>.`,name:"use_simple_decoder"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitpose/configuration_vitpose.py#L28"}}),Z=new pt({props:{anchor:"transformers.VitPoseConfig.example",$$slots:{default:[jt]},$$scope:{ctx:V}}}),fe=new k({props:{title:"VitPoseForPoseEstimation",local:"transformers.VitPoseForPoseEstimation",headingTag:"h2"}}),be=new xe({props:{name:"class transformers.VitPoseForPoseEstimation",anchor:"transformers.VitPoseForPoseEstimation",parameters:[{name:"config",val:": VitPoseConfig"}],parametersDescription:[{anchor:"transformers.VitPoseForPoseEstimation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/vitpose#transformers.VitPoseConfig">VitPoseConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitpose/modeling_vitpose.py#L194"}}),ge=new xe({props:{name:"forward",anchor:"transformers.VitPoseForPoseEstimation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"dataset_index",val:": typing.Optional[torch.Tensor] = None"},{name:"flip_pairs",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.VitPoseForPoseEstimation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)</code>) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<code>{image_processor_class}</code>. See <code>{image_processor_class}.__call__</code> for details (<code>{processor_class}</code> uses
<code>{image_processor_class}</code> for processing images).`,name:"pixel_values"},{anchor:"transformers.VitPoseForPoseEstimation.forward.dataset_index",description:`<strong>dataset_index</strong> (<code>torch.Tensor</code> of shape <code>(batch_size,)</code>) &#x2014;
Index to use in the Mixture-of-Experts (MoE) blocks of the backbone.</p>
<p>This corresponds to the dataset index used during training, e.g. For the single dataset index 0 refers to the corresponding dataset. For the multiple datasets index 0 refers to dataset A (e.g. MPII) and index 1 refers to dataset B (e.g. CrowdPose).`,name:"dataset_index"},{anchor:"transformers.VitPoseForPoseEstimation.forward.flip_pairs",description:`<strong>flip_pairs</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Whether to mirror pairs of keypoints (for example, left ear &#x2014; right ear).`,name:"flip_pairs"},{anchor:"transformers.VitPoseForPoseEstimation.forward.labels",description:`<strong>labels</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.VitPoseForPoseEstimation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VitPoseForPoseEstimation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VitPoseForPoseEstimation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/vitpose/modeling_vitpose.py#L218",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.vitpose.modeling_vitpose.VitPoseEstimatorOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/vitpose#transformers.VitPoseConfig"
>VitPoseConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Loss is not supported at this moment. See <a
  href="https://github.com/ViTAE-Transformer/ViTPose/tree/main/mmpose/models/losses"
  rel="nofollow"
>https://github.com/ViTAE-Transformer/ViTPose/tree/main/mmpose/models/losses</a> for further detail.</p>
</li>
<li>
<p><strong>heatmaps</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_keypoints, height, width)</code>) — Heatmaps as predicted by the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.vitpose.modeling_vitpose.VitPoseEstimatorOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ut({props:{$$slots:{default:[ft]},$$scope:{ctx:V}}}),G=new pt({props:{anchor:"transformers.VitPoseForPoseEstimation.forward.example",$$slots:{default:[bt]},$$scope:{ctx:V}}}),Te=new ut({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/vitpose.md"}}),{c(){c=o("meta"),J=a(),f=o("p"),j=a(),m(b.$$.fragment),i=a(),g=o("div"),g.innerHTML=Qs,Ee=a(),m(P.$$.fragment),Ge=a(),X=o("p"),X.innerHTML=Zs,Ne=a(),R=o("p"),R.textContent=Es,ze=a(),$=o("p"),$.innerHTML=Gs,We=a(),B=o("img"),Pe=a(),F=o("small"),F.innerHTML=zs,Xe=a(),L=o("p"),L.innerHTML=Ws,Re=a(),m(D.$$.fragment),$e=a(),H=o("p"),H.innerHTML=Ps,Fe=a(),m(Y.$$.fragment),Le=a(),m(K.$$.fragment),De=a(),q=o("p"),q.innerHTML=Xs,He=a(),O=o("p"),O.textContent=Rs,Ye=a(),ee=o("ul"),ee.innerHTML=$s,Ke=a(),se=o("p"),se.innerHTML=Fs,qe=a(),m(te.$$.fragment),Oe=a(),ne=o("p"),ne.textContent=Ls,es=a(),ae=o("ul"),ae.innerHTML=Ds,ss=a(),m(le.$$.fragment),ts=a(),oe=o("p"),oe.innerHTML=Hs,ns=a(),m(re.$$.fragment),as=a(),ie=o("p"),ie.innerHTML=Ys,ls=a(),m(ce.$$.fragment),os=a(),S=o("img"),rs=a(),m(pe.$$.fragment),is=a(),Me=o("p"),Me.textContent=qs,cs=a(),me=o("ul"),me.innerHTML=Os,ps=a(),m(de.$$.fragment),Ms=a(),C=o("div"),m(ye.$$.fragment),fs=a(),Ce=o("p"),Ce.textContent=et,bs=a(),x=o("div"),m(he.$$.fragment),gs=a(),_e=o("p"),_e.textContent=st,Ts=a(),Q=o("div"),m(Ue.$$.fragment),ws=a(),Ie=o("p"),Ie.textContent=tt,ms=a(),m(ue.$$.fragment),ds=a(),_=o("div"),m(je.$$.fragment),Js=a(),Ae=o("p"),Ae.innerHTML=nt,Cs=a(),ve=o("p"),ve.innerHTML=at,_s=a(),m(Z.$$.fragment),ys=a(),m(fe.$$.fragment),hs=a(),T=o("div"),m(be.$$.fragment),Is=a(),ke=o("p"),ke.textContent=lt,As=a(),Ve=o("p"),Ve.innerHTML=ot,vs=a(),Be=o("p"),Be.innerHTML=rt,ks=a(),I=o("div"),m(ge.$$.fragment),Vs=a(),Se=o("p"),Se.innerHTML=it,Bs=a(),m(E.$$.fragment),Ss=a(),m(G.$$.fragment),Us=a(),m(Te.$$.fragment),us=a(),Ze=o("p"),this.h()},l(e){const s=ht("svelte-u9bgzb",document.head);c=r(s,"META",{name:!0,content:!0}),s.forEach(t),J=l(e),f=r(e,"P",{}),W(f).forEach(t),j=l(e),d(b.$$.fragment,e),i=l(e),g=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-13t8s2t"&&(g.innerHTML=Qs),Ee=l(e),d(P.$$.fragment,e),Ge=l(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-5kliuq"&&(X.innerHTML=Zs),Ne=l(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-vfdo9a"&&(R.textContent=Es),ze=l(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1r8g7qv"&&($.innerHTML=Gs),We=l(e),B=r(e,"IMG",{src:!0,alt:!0,width:!0}),Pe=l(e),F=r(e,"SMALL",{"data-svelte-h":!0}),p(F)!=="svelte-1rdk1gr"&&(F.innerHTML=zs),Xe=l(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1pkw5cm"&&(L.innerHTML=Ws),Re=l(e),d(D.$$.fragment,e),$e=l(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-qazy8m"&&(H.innerHTML=Ps),Fe=l(e),d(Y.$$.fragment,e),Le=l(e),d(K.$$.fragment,e),De=l(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-er0z9v"&&(q.innerHTML=Xs),He=l(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-jjff6j"&&(O.textContent=Rs),Ye=l(e),ee=r(e,"UL",{"data-svelte-h":!0}),p(ee)!=="svelte-wxmy7r"&&(ee.innerHTML=$s),Ke=l(e),se=r(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-15bozem"&&(se.innerHTML=Fs),qe=l(e),d(te.$$.fragment,e),Oe=l(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-jjff6j"&&(ne.textContent=Ls),es=l(e),ae=r(e,"UL",{"data-svelte-h":!0}),p(ae)!=="svelte-wxmy7r"&&(ae.innerHTML=Ds),ss=l(e),d(le.$$.fragment,e),ts=l(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-wxtr7b"&&(oe.innerHTML=Hs),ns=l(e),d(re.$$.fragment,e),as=l(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1mdlnn1"&&(ie.innerHTML=Ys),ls=l(e),d(ce.$$.fragment,e),os=l(e),S=r(e,"IMG",{src:!0,alt:!0,width:!0}),rs=l(e),d(pe.$$.fragment,e),is=l(e),Me=r(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-sj3pkb"&&(Me.textContent=qs),cs=l(e),me=r(e,"UL",{"data-svelte-h":!0}),p(me)!=="svelte-1qutpeb"&&(me.innerHTML=Os),ps=l(e),d(de.$$.fragment,e),Ms=l(e),C=r(e,"DIV",{class:!0});var A=W(C);d(ye.$$.fragment,A),fs=l(A),Ce=r(A,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1uf40pk"&&(Ce.textContent=et),bs=l(A),x=r(A,"DIV",{class:!0});var we=W(x);d(he.$$.fragment,we),gs=l(we),_e=r(we,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1x3yxsa"&&(_e.textContent=st),we.forEach(t),Ts=l(A),Q=r(A,"DIV",{class:!0});var Je=W(Q);d(Ue.$$.fragment,Je),ws=l(Je),Ie=r(Je,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-1qvlu0g"&&(Ie.textContent=tt),Je.forEach(t),A.forEach(t),ms=l(e),d(ue.$$.fragment,e),ds=l(e),_=r(e,"DIV",{class:!0});var N=W(_);d(je.$$.fragment,N),Js=l(N),Ae=r(N,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-owqdsz"&&(Ae.innerHTML=nt),Cs=l(N),ve=r(N,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-o55m63"&&(ve.innerHTML=at),_s=l(N),d(Z.$$.fragment,N),N.forEach(t),ys=l(e),d(fe.$$.fragment,e),hs=l(e),T=r(e,"DIV",{class:!0});var v=W(T);d(be.$$.fragment,v),Is=l(v),ke=r(v,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-er1y03"&&(ke.textContent=lt),As=l(v),Ve=r(v,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-6pahdo"&&(Ve.innerHTML=ot),vs=l(v),Be=r(v,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-hswkmf"&&(Be.innerHTML=rt),ks=l(v),I=r(v,"DIV",{class:!0});var z=W(I);d(ge.$$.fragment,z),Vs=l(z),Se=r(z,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-s2387n"&&(Se.innerHTML=it),Bs=l(z),d(E.$$.fragment,z),Ss=l(z),d(G.$$.fragment,z),z.forEach(t),v.forEach(t),Us=l(e),d(Te.$$.fragment,e),us=l(e),Ze=r(e,"P",{}),W(Ze).forEach(t),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",Tt),w(g,"class","flex flex-wrap space-x-1"),ct(B.src,Ns="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/vitpose-architecture.png")||w(B,"src",Ns),w(B,"alt","drawing"),w(B,"width","600"),ct(S.src,Ks="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/vitpose-coco.jpg")||w(S,"src",Ks),w(S,"alt","drawing"),w(S,"width","600"),w(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){M(document.head,c),n(e,J,s),n(e,f,s),n(e,j,s),y(b,e,s),n(e,i,s),n(e,g,s),n(e,Ee,s),y(P,e,s),n(e,Ge,s),n(e,X,s),n(e,Ne,s),n(e,R,s),n(e,ze,s),n(e,$,s),n(e,We,s),n(e,B,s),n(e,Pe,s),n(e,F,s),n(e,Xe,s),n(e,L,s),n(e,Re,s),y(D,e,s),n(e,$e,s),n(e,H,s),n(e,Fe,s),y(Y,e,s),n(e,Le,s),y(K,e,s),n(e,De,s),n(e,q,s),n(e,He,s),n(e,O,s),n(e,Ye,s),n(e,ee,s),n(e,Ke,s),n(e,se,s),n(e,qe,s),y(te,e,s),n(e,Oe,s),n(e,ne,s),n(e,es,s),n(e,ae,s),n(e,ss,s),y(le,e,s),n(e,ts,s),n(e,oe,s),n(e,ns,s),y(re,e,s),n(e,as,s),n(e,ie,s),n(e,ls,s),y(ce,e,s),n(e,os,s),n(e,S,s),n(e,rs,s),y(pe,e,s),n(e,is,s),n(e,Me,s),n(e,cs,s),n(e,me,s),n(e,ps,s),y(de,e,s),n(e,Ms,s),n(e,C,s),y(ye,C,null),M(C,fs),M(C,Ce),M(C,bs),M(C,x),y(he,x,null),M(x,gs),M(x,_e),M(C,Ts),M(C,Q),y(Ue,Q,null),M(Q,ws),M(Q,Ie),n(e,ms,s),y(ue,e,s),n(e,ds,s),n(e,_,s),y(je,_,null),M(_,Js),M(_,Ae),M(_,Cs),M(_,ve),M(_,_s),y(Z,_,null),n(e,ys,s),y(fe,e,s),n(e,hs,s),n(e,T,s),y(be,T,null),M(T,Is),M(T,ke),M(T,As),M(T,Ve),M(T,vs),M(T,Be),M(T,ks),M(T,I),y(ge,I,null),M(I,Vs),M(I,Se),M(I,Bs),y(E,I,null),M(I,Ss),y(G,I,null),n(e,Us,s),y(Te,e,s),n(e,us,s),n(e,Ze,s),js=!0},p(e,[s]){const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),Z.$set(A);const we={};s&2&&(we.$$scope={dirty:s,ctx:e}),E.$set(we);const Je={};s&2&&(Je.$$scope={dirty:s,ctx:e}),G.$set(Je)},i(e){js||(h(b.$$.fragment,e),h(P.$$.fragment,e),h(D.$$.fragment,e),h(Y.$$.fragment,e),h(K.$$.fragment,e),h(te.$$.fragment,e),h(le.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(pe.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(he.$$.fragment,e),h(Ue.$$.fragment,e),h(ue.$$.fragment,e),h(je.$$.fragment,e),h(Z.$$.fragment,e),h(fe.$$.fragment,e),h(be.$$.fragment,e),h(ge.$$.fragment,e),h(E.$$.fragment,e),h(G.$$.fragment,e),h(Te.$$.fragment,e),js=!0)},o(e){U(b.$$.fragment,e),U(P.$$.fragment,e),U(D.$$.fragment,e),U(Y.$$.fragment,e),U(K.$$.fragment,e),U(te.$$.fragment,e),U(le.$$.fragment,e),U(re.$$.fragment,e),U(ce.$$.fragment,e),U(pe.$$.fragment,e),U(de.$$.fragment,e),U(ye.$$.fragment,e),U(he.$$.fragment,e),U(Ue.$$.fragment,e),U(ue.$$.fragment,e),U(je.$$.fragment,e),U(Z.$$.fragment,e),U(fe.$$.fragment,e),U(be.$$.fragment,e),U(ge.$$.fragment,e),U(E.$$.fragment,e),U(G.$$.fragment,e),U(Te.$$.fragment,e),js=!1},d(e){e&&(t(J),t(f),t(j),t(i),t(g),t(Ee),t(Ge),t(X),t(Ne),t(R),t(ze),t($),t(We),t(B),t(Pe),t(F),t(Xe),t(L),t(Re),t($e),t(H),t(Fe),t(Le),t(De),t(q),t(He),t(O),t(Ye),t(ee),t(Ke),t(se),t(qe),t(Oe),t(ne),t(es),t(ae),t(ss),t(ts),t(oe),t(ns),t(as),t(ie),t(ls),t(os),t(S),t(rs),t(is),t(Me),t(cs),t(me),t(ps),t(Ms),t(C),t(ms),t(ds),t(_),t(ys),t(hs),t(T),t(Us),t(us),t(Ze)),t(c),u(b,e),u(P,e),u(D,e),u(Y,e),u(K,e),u(te,e),u(le,e),u(re,e),u(ce,e),u(pe,e),u(de,e),u(ye),u(he),u(Ue),u(ue,e),u(je),u(Z),u(fe,e),u(be),u(ge),u(E),u(G),u(Te,e)}}}const Tt='{"title":"ViTPose","local":"vitpose","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage Tips","local":"usage-tips","sections":[{"title":"ViTPose++ models","local":"vitpose-models","sections":[],"depth":3},{"title":"Visualization","local":"visualization","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"VitPoseImageProcessor","local":"transformers.VitPoseImageProcessor","sections":[],"depth":2},{"title":"VitPoseConfig","local":"transformers.VitPoseConfig","sections":[],"depth":2},{"title":"VitPoseForPoseEstimation","local":"transformers.VitPoseForPoseEstimation","sections":[],"depth":2}],"depth":1}';function wt(V){return mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Bt extends dt{constructor(c){super(),yt(this,c,wt,gt,Mt,{})}}export{Bt as component};
