import{s as ee,n as te,o as se}from"../chunks/scheduler.18a86fab.js";import{S as oe,i as ae,g as n,s as a,r as _,A as re,h as l,f as s,c as r,j as S,u as T,x as w,k as K,y as ie,a as o,v as J,d as U,t as Z,w as j}from"../chunks/index.98837b22.js";import{C as D}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as O}from"../chunks/Heading.7e7e0c5b.js";import{E as ne}from"../chunks/index.92f616ba.js";function le(q){let i,x,M,P,c,C,p,R="A <strong>Video Processor</strong> is a utility responsible for preparing input features for video models, as well as handling the post-processing of their outputs. It provides transformations such as resizing, normalization, and conversion into PyTorch.",V,d,Y="The video processor extends the functionality of image processors by allowing the models to handle videos with a distinct set of arguments compared to images. It serves as the bridge between raw video data and the model, ensuring that input features are optimized for the VLM.",W,m,F='Use <a href="/docs/transformers/main/en/main_classes/video_processor#transformers.BaseVideoProcessor.from_pretrained">from_pretrained()</a> to load a video processors configuration (image size, whether to normalize and rescale, etc.) from a video model on the Hugging Face <a href="https://hf.co" rel="nofollow">Hub</a> or local directory. The configuration for each pretrained model should be saved in a [video_preprocessor_config.json] file but older models might have the config saved in <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-0.5b-ov-hf/blob/main/preprocessor_config.json" rel="nofollow">preprocessor_config.json</a> file. Note that the latter is less preferred and will be removed in the future.',G,f,k,h,L='Here’s an example of how to load a video processor with <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-0.5b-ov-hf" rel="nofollow"><code>llava-hf/llava-onevision-qwen2-0.5b-ov-hf</code></a> model:',H,u,E,v,A='Currently, if using base image processor for videos, it processes video data by treating each frame as an individual image and applying transformations frame-by-frame. While functional, this approach is not highly efficient. Using <code>AutoVideoProcessor</code> allows us to take advantage of <strong>fast video processors</strong>, leveraging the <a href="https://pytorch.org/vision/stable/index.html" rel="nofollow">torchvision</a> library. Fast processors handle the whole batch of videos at once, without iterating over each video or frame. These updates introduce GPU acceleration and significantly enhance processing speed, especially for tasks requiring high throughput.',I,g,Q="Fast video processors are available for all models and are loaded by default when an <code>AutoVideoProcessor</code> is initialized. When using a fast video processor, you can also set the <code>device</code> argument to specify the device on which the processing should be done. By default, the processing is done on the same device as the inputs if the inputs are tensors, or on the CPU otherwise. For even more speed improvement, we can compile the processor when using ‘cuda’ as device.",N,y,X,b,z,$,B;return c=new O({props:{title:"Video Processor",local:"video-processor",headingTag:"h1"}}),f=new O({props:{title:"Usage Example",local:"usage-example",headingTag:"h3"}}),u=new D({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9WaWRlb1Byb2Nlc3NvciUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9WaWRlb1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItMC41Yi1vdi1oZiUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoVideoProcessor

processor = AutoVideoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-0.5b-ov-hf&quot;</span>)`,wrap:!1}}),y=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnZpZGVvX3V0aWxzJTIwaW1wb3J0JTIwbG9hZF92aWRlbyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVmlkZW9Qcm9jZXNzb3IlMEElMEF2aWRlbyUyMCUzRCUyMGxvYWRfdmlkZW8oJTIydmlkZW8ubXA0JTIyKSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9WaWRlb1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItMC41Yi1vdi1oZiUyMiUyQyUyMGRldmljZSUzRCUyMmN1ZGElMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwdG9yY2guY29tcGlsZShwcm9jZXNzb3IpJTBBcHJvY2Vzc2VkX3ZpZGVvJTIwJTNEJTIwcHJvY2Vzc29yKHZpZGVvJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers.video_utils <span class="hljs-keyword">import</span> load_video
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoVideoProcessor

video = load_video(<span class="hljs-string">&quot;video.mp4&quot;</span>)
processor = AutoVideoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-0.5b-ov-hf&quot;</span>, device=<span class="hljs-string">&quot;cuda&quot;</span>)
processor = torch.<span class="hljs-built_in">compile</span>(processor)
processed_video = processor(video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),b=new ne({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/video_processors.md"}}),{c(){i=n("meta"),x=a(),M=n("p"),P=a(),_(c.$$.fragment),C=a(),p=n("p"),p.innerHTML=R,V=a(),d=n("p"),d.textContent=Y,W=a(),m=n("p"),m.innerHTML=F,G=a(),_(f.$$.fragment),k=a(),h=n("p"),h.innerHTML=L,H=a(),_(u.$$.fragment),E=a(),v=n("p"),v.innerHTML=A,I=a(),g=n("p"),g.innerHTML=Q,N=a(),_(y.$$.fragment),X=a(),_(b.$$.fragment),z=a(),$=n("p"),this.h()},l(e){const t=re("svelte-u9bgzb",document.head);i=l(t,"META",{name:!0,content:!0}),t.forEach(s),x=r(e),M=l(e,"P",{}),S(M).forEach(s),P=r(e),T(c.$$.fragment,e),C=r(e),p=l(e,"P",{"data-svelte-h":!0}),w(p)!=="svelte-1bnodsr"&&(p.innerHTML=R),V=r(e),d=l(e,"P",{"data-svelte-h":!0}),w(d)!=="svelte-1mm69ua"&&(d.textContent=Y),W=r(e),m=l(e,"P",{"data-svelte-h":!0}),w(m)!=="svelte-9q6svh"&&(m.innerHTML=F),G=r(e),T(f.$$.fragment,e),k=r(e),h=l(e,"P",{"data-svelte-h":!0}),w(h)!=="svelte-1ukoepa"&&(h.innerHTML=L),H=r(e),T(u.$$.fragment,e),E=r(e),v=l(e,"P",{"data-svelte-h":!0}),w(v)!=="svelte-157dwxe"&&(v.innerHTML=A),I=r(e),g=l(e,"P",{"data-svelte-h":!0}),w(g)!=="svelte-1wmclx8"&&(g.innerHTML=Q),N=r(e),T(y.$$.fragment,e),X=r(e),T(b.$$.fragment,e),z=r(e),$=l(e,"P",{}),S($).forEach(s),this.h()},h(){K(i,"name","hf:doc:metadata"),K(i,"content",ce)},m(e,t){ie(document.head,i),o(e,x,t),o(e,M,t),o(e,P,t),J(c,e,t),o(e,C,t),o(e,p,t),o(e,V,t),o(e,d,t),o(e,W,t),o(e,m,t),o(e,G,t),J(f,e,t),o(e,k,t),o(e,h,t),o(e,H,t),J(u,e,t),o(e,E,t),o(e,v,t),o(e,I,t),o(e,g,t),o(e,N,t),J(y,e,t),o(e,X,t),J(b,e,t),o(e,z,t),o(e,$,t),B=!0},p:te,i(e){B||(U(c.$$.fragment,e),U(f.$$.fragment,e),U(u.$$.fragment,e),U(y.$$.fragment,e),U(b.$$.fragment,e),B=!0)},o(e){Z(c.$$.fragment,e),Z(f.$$.fragment,e),Z(u.$$.fragment,e),Z(y.$$.fragment,e),Z(b.$$.fragment,e),B=!1},d(e){e&&(s(x),s(M),s(P),s(C),s(p),s(V),s(d),s(W),s(m),s(G),s(k),s(h),s(H),s(E),s(v),s(I),s(g),s(N),s(X),s(z),s($)),s(i),j(c,e),j(f,e),j(u,e),j(y,e),j(b,e)}}}const ce='{"title":"Video Processor","local":"video-processor","sections":[{"title":"Usage Example","local":"usage-example","sections":[],"depth":3}],"depth":1}';function pe(q){return se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends oe{constructor(i){super(),ae(this,i,pe,le,ee,{})}}export{ve as component};
