import{s as ql,n as lt,o as tt}from"../chunks/scheduler.bdbef820.js";import{S as et,i as st,g as J,s as n,r as a,A as nt,h as U,f as e,c as M,j as zl,u as p,x as i,k as Pl,y as Mt,a as s,v as C,d as m,t as j,w}from"../chunks/index.33f81d56.js";import{C as Kl}from"../chunks/CodeBlock.3bad7fc9.js";import{H as Y,E as Jt}from"../chunks/index.9edc4842.js";function Ut(Al){let T,X,L,z,y,P,I,Bl='<code>transformers</code>는 opinionated(자기 의견이 강한) 프레임워크이며, 우리의 철학은 다음의 <a href="./philosophy">개념 가이드</a>에 정의되어 있습니다.',K,V,El='이 철학의 핵심은 라이브러리의 <a href="https://huggingface.co/blog/transformers-design-philosophy" rel="nofollow">단일 모델, 단일 파일</a> 측면에서 잘 나타납니다. 이 구성 요소의 단점은 파일 간에 구성 요소의 상속과 임포트 가능성을 제한한다는 것입니다.',q,o,bl="그 결과, 모델 구성 요소가 여러 파일에 걸쳐 반복되는 경향이 있습니다. <code>transformers</code>에는 모델 수만큼 많은 어텐션 레이어가 정의되어 있으며, 그 중 상당수는 서로 동일합니다. 안타깝게도, 수정과 변경 사항이 코드의 특정 부분에 적용되면서 독립적인 구현들이 서로 분기되는 경향이 있습니다.",ll,Q,hl="이 문제를 적절히 해결하기 위해, 우리는 라이브러리 전체에 “복사본”의 개념을 도입했습니다. 코드가 다른 코드의 복사본임을 나타내는 주석을 추가함으로써, CI 및 로컬 명령을 통해 복사본이 분기되지 않도록 강제할 수 있습니다. 그러나 복잡성이 낮더라도 이는 종종 매우 번거로운 작업입니다.",tl,f,kl="마지막으로, 이 방식은 우리가 줄이고자 하는 상당한 오버헤드를 모델 기여 과정에 추가하게 됩니다. 이 접근 방식은 종종 모델 기여에 모델링 코드(~1,000줄), 프로세서(~500줄), 테스트, 문서 등을 추가해야 합니다. 모델 기여 PR은 대부분 3,000~5,000줄 이상의 코드를 추가하며, 이 중 많은 부분이 보일러플레이트(boilerplate) 코드입니다.",el,d,Fl="이는 기여의 장벽을 높이며, 모듈식 트랜스포머를 통해 우리는 이러한 장벽을 훨씬 더 수용 가능한 수준으로 낮추고자 합니다.",sl,r,nl,c,$l="모듈식 트랜스포머는 모델 폴더에 “모듈식” 파일의 개념을 도입합니다. 이 모듈식 파일은 일반적으로 모델링/프로세싱 파일에서 허용되지 않는 코드를 허용하며, 이는 인접한 모델로부터의 임포트와 클래스 간의 상속을 허용합니다.",Ml,R,Ol="이 모듈식 파일은 각각의 별도의 모듈에서 정의되었을 모델, 프로세서 및 구성 클래스를 정의합니다.",Jl,u,xl="마지막으로, 이 기능은 모듈식 파일을 “풀어내어” 단일 모델, 단일 파일 디렉토리 구조로 변환하는 새로운 <code>linter</code>를 도입합니다. 이 파일들은 스크립트가 실행될 때마다 자동으로 생성되며, 기여해야 할 내용을 모듈식 파일, 그리고 기여된 모델과 다른 모델 간의 차이점으로만 줄여줍니다.",Ul,_,vl="모델 사용자는 단일 파일 인터페이스를 임포트하고 사용하게 되므로, 여기에는 변화가 없을 것입니다. 이를 통해 간단한 기여를 가능하게 하면서도 우리의 철학을 유지하는 양쪽의 장점을 결합하고자 합니다.",il,A,Zl="따라서 이는 <code># Copied from</code> 마커의 대체품이며, 이전에 기여된 모델은 앞으로 몇 달 내에 새로운 모듈식 트랜스포머 형식으로 전환될 예정입니다.",Tl,B,al,E,gl="“linter”는 상속 구조를 풀어서 모듈화된 파일로부터 모든 단일 파일을 생성하며, Python 사용자들에게는 그 과정이 보이지 않도록 동작합니다. 현재 linter는 <strong>단일</strong> 수준의 상속만을 평탄화합니다.",pl,b,Sl="예를 들어:",Cl,h,Nl="<li>구성 클래스가 다른 클래스를 상속하고 인자를 추가/삭제하는 경우, 생성된 파일은 직접 참조(추가의 경우)하거나 완전히 제거합니다(삭제의 경우).</li> <li>클래스가 다른 클래스를 상속하는 경우, 예를 들어 class GemmaModel(LlamaModel): 의 경우, 종속성이 자동으로 추론됩니다. 모든 서브모듈은 슈퍼클래스로부터 자동으로 추론됩니다.</li>",ml,k,Wl="토크나이저, 이미지 프로세서, 모델, 구성 등을 이 <code>modular</code> 파일에 모두 작성할 수 있으며, 해당 파일들이 자동으로 생성됩니다.",jl,F,wl,$,Dl="[TODO] 우리는 새로운 테스트를 도입하여 생성된 콘텐츠가 <code>modular_xxxx.py</code>에 있는 내용과 일치하는지 확인합니다.",yl,O,Il,x,Gl="여기 BERT와 RoBERTa의 간단한 예가 있습니다. 두 모델은 밀접하게 관련되어 있으며, 모델 구현의 차이는 임베딩 레이어의 변경에서만 있습니다.",Vl,v,Yl="모델을 완전히 재정의하는 대신, <code>modular_roberta.py</code> 파일은 모델링 및 구성 클래스를 위해 다음과 같이 생겼습니다. (예시를 위해, 토크나이저는 매우 다르므로 일단 무시합니다.)",ol,Z,Ql,g,Ll="정의한 종속성을 사용하지 않으면 다음과 같은 오류가 발생합니다:",fl,S,dl,N,Hl="또한, 다음에서 예시 목록을 찾을 수 있습니다:",rl,W,cl,D,Xl="(아직은?) 모델링 코드를 대체하는 것은 아닙니다. 그리고 여러분의 모델이 지금까지 존재했던 다른 어떤 것에도 기반하지 않는다면, 기존과 같이 <code>modeling</code> 파일을 추가할 수 있습니다.",Rl,G,ul,H,_l;return y=new Y({props:{title:"모듈식 트랜스포머",local:"modular-transformers",headingTag:"h1"}}),r=new Y({props:{title:"무엇인가요",local:"what-is-it",headingTag:"h2"}}),B=new Y({props:{title:"자세한 내용",local:"details",headingTag:"h3"}}),F=new Y({props:{title:"시행",local:"enforcement",headingTag:"h3"}}),O=new Y({props:{title:"예시",local:"examples",headingTag:"h3"}}),Z=new Kl({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> ..bert.configuration_bert <span class="hljs-keyword">import</span> BertConfig
<span class="hljs-keyword">from</span> ..bert.modeling_bert <span class="hljs-keyword">import</span> (
    BertModel,
    BertEmbeddings,
    BertForMaskedLM
)

<span class="hljs-comment"># RoBERTa 구성은 BERT의 구성과 동일합니다</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaConfig</span>(<span class="hljs-title class_ inherited__">BertConfig</span>):
    model_type = <span class="hljs-string">&#x27;roberta&#x27;</span>

<span class="hljs-comment"># 여기서 패딩 ID 차이를 강조하기 위해 임베딩을 재정의하고, 위치 임베딩을 재정의합니다</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaEmbeddings</span>(<span class="hljs-title class_ inherited__">BertEmbeddings</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config())

        self.padding_idx = config.pad_token_id
        self.position_embeddings = nn.Embedding(
            config.max_position_embeddings, config.hidden_size, padding_idx=self.padding_idx
        )

<span class="hljs-comment"># RoBERTa 모델은 임베딩 레이어를 제외하면 BERT 모델과 동일합니다.</span>
<span class="hljs-comment"># 위에서 임베딩을 재정의했으므로, 여기서는 추가 작업이 필요 없습니다</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaModel</span>(<span class="hljs-title class_ inherited__">BertModel</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.embeddings = RobertaEmbeddings(config)

<span class="hljs-comment"># 헤드는 이제 내부에서 올바른 \`RobertaModel\`을 재정의하기만 하면 됩니다</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">RobertaForMaskedLM</span>(<span class="hljs-title class_ inherited__">BertForMaskedLM</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.model = RobertaModel(config)`,wrap:!1}}),S=new Kl({props:{code:"VmFsdWVFcnJvciUzQSUyMFlvdSUyMGRlZmluZWQlMjAlNjBSb2JlcnRhRW1iZWRkaW5ncyU2MCUyMGluJTIwdGhlJTIwbW9kdWxhcl9yb2JlcnRhLnB5JTJDJTIwaXQlMjBzaG91bGQlMjBiZSUyMHVzZWQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGVuJTIweW91JTIwZGVmaW5lJTIwJTYwQmVydE1vZGVsJTYwJTJDJTIwYXMlMjBpdCUyMGlzJTIwb25lJTIwb2YlMjBpdCdzJTIwZGlyZWN0JTIwZGVwZW5kZW5jaWVzLiUyME1ha2UlMjBzdXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIweW91JTIwdXNlJTIwaXQlMjBpbiUyMHRoZSUyMCU2MF9faW5pdF9fJTYwJTIwZnVuY3Rpb24u",highlighted:'ValueError: You defined `RobertaEmbeddings` <span class="hljs-keyword">in</span> the modular_roberta.py, it should be used\n                                        when you define `BertModel`, as it is one of it<span class="hljs-string">&#x27;s direct dependencies. Make sure\n                                        you use it in the `__init__` function.</span>',wrap:!1}}),W=new Y({props:{title:"무엇이 아닌가요",local:"what-it-is-not",headingTag:"h2"}}),G=new Jt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/modular_transformers.md"}}),{c(){T=J("meta"),X=n(),L=J("p"),z=n(),a(y.$$.fragment),P=n(),I=J("p"),I.innerHTML=Bl,K=n(),V=J("p"),V.innerHTML=El,q=n(),o=J("p"),o.innerHTML=bl,ll=n(),Q=J("p"),Q.textContent=hl,tl=n(),f=J("p"),f.textContent=kl,el=n(),d=J("p"),d.textContent=Fl,sl=n(),a(r.$$.fragment),nl=n(),c=J("p"),c.textContent=$l,Ml=n(),R=J("p"),R.textContent=Ol,Jl=n(),u=J("p"),u.innerHTML=xl,Ul=n(),_=J("p"),_.textContent=vl,il=n(),A=J("p"),A.innerHTML=Zl,Tl=n(),a(B.$$.fragment),al=n(),E=J("p"),E.innerHTML=gl,pl=n(),b=J("p"),b.textContent=Sl,Cl=n(),h=J("ul"),h.innerHTML=Nl,ml=n(),k=J("p"),k.innerHTML=Wl,jl=n(),a(F.$$.fragment),wl=n(),$=J("p"),$.innerHTML=Dl,yl=n(),a(O.$$.fragment),Il=n(),x=J("p"),x.textContent=Gl,Vl=n(),v=J("p"),v.innerHTML=Yl,ol=n(),a(Z.$$.fragment),Ql=n(),g=J("p"),g.textContent=Ll,fl=n(),a(S.$$.fragment),dl=n(),N=J("p"),N.textContent=Hl,rl=n(),a(W.$$.fragment),cl=n(),D=J("p"),D.innerHTML=Xl,Rl=n(),a(G.$$.fragment),ul=n(),H=J("p"),this.h()},l(l){const t=nt("svelte-u9bgzb",document.head);T=U(t,"META",{name:!0,content:!0}),t.forEach(e),X=M(l),L=U(l,"P",{}),zl(L).forEach(e),z=M(l),p(y.$$.fragment,l),P=M(l),I=U(l,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1gj2lqp"&&(I.innerHTML=Bl),K=M(l),V=U(l,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1a5kxtj"&&(V.innerHTML=El),q=M(l),o=U(l,"P",{"data-svelte-h":!0}),i(o)!=="svelte-x7vx5i"&&(o.innerHTML=bl),ll=M(l),Q=U(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-175zy99"&&(Q.textContent=hl),tl=M(l),f=U(l,"P",{"data-svelte-h":!0}),i(f)!=="svelte-4y77vs"&&(f.textContent=kl),el=M(l),d=U(l,"P",{"data-svelte-h":!0}),i(d)!=="svelte-1dtl8ot"&&(d.textContent=Fl),sl=M(l),p(r.$$.fragment,l),nl=M(l),c=U(l,"P",{"data-svelte-h":!0}),i(c)!=="svelte-19uk10v"&&(c.textContent=$l),Ml=M(l),R=U(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-3hvp8u"&&(R.textContent=Ol),Jl=M(l),u=U(l,"P",{"data-svelte-h":!0}),i(u)!=="svelte-co2oqe"&&(u.innerHTML=xl),Ul=M(l),_=U(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-w808sa"&&(_.textContent=vl),il=M(l),A=U(l,"P",{"data-svelte-h":!0}),i(A)!=="svelte-ndzw9s"&&(A.innerHTML=Zl),Tl=M(l),p(B.$$.fragment,l),al=M(l),E=U(l,"P",{"data-svelte-h":!0}),i(E)!=="svelte-7jxfqs"&&(E.innerHTML=gl),pl=M(l),b=U(l,"P",{"data-svelte-h":!0}),i(b)!=="svelte-6ks64i"&&(b.textContent=Sl),Cl=M(l),h=U(l,"UL",{"data-svelte-h":!0}),i(h)!=="svelte-ricc7o"&&(h.innerHTML=Nl),ml=M(l),k=U(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-tcjhzq"&&(k.innerHTML=Wl),jl=M(l),p(F.$$.fragment,l),wl=M(l),$=U(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-u1xld7"&&($.innerHTML=Dl),yl=M(l),p(O.$$.fragment,l),Il=M(l),x=U(l,"P",{"data-svelte-h":!0}),i(x)!=="svelte-17kkqrr"&&(x.textContent=Gl),Vl=M(l),v=U(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-o1zm1n"&&(v.innerHTML=Yl),ol=M(l),p(Z.$$.fragment,l),Ql=M(l),g=U(l,"P",{"data-svelte-h":!0}),i(g)!=="svelte-j5iuu8"&&(g.textContent=Ll),fl=M(l),p(S.$$.fragment,l),dl=M(l),N=U(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-tl5dp1"&&(N.textContent=Hl),rl=M(l),p(W.$$.fragment,l),cl=M(l),D=U(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1ubc5t7"&&(D.innerHTML=Xl),Rl=M(l),p(G.$$.fragment,l),ul=M(l),H=U(l,"P",{}),zl(H).forEach(e),this.h()},h(){Pl(T,"name","hf:doc:metadata"),Pl(T,"content",it)},m(l,t){Mt(document.head,T),s(l,X,t),s(l,L,t),s(l,z,t),C(y,l,t),s(l,P,t),s(l,I,t),s(l,K,t),s(l,V,t),s(l,q,t),s(l,o,t),s(l,ll,t),s(l,Q,t),s(l,tl,t),s(l,f,t),s(l,el,t),s(l,d,t),s(l,sl,t),C(r,l,t),s(l,nl,t),s(l,c,t),s(l,Ml,t),s(l,R,t),s(l,Jl,t),s(l,u,t),s(l,Ul,t),s(l,_,t),s(l,il,t),s(l,A,t),s(l,Tl,t),C(B,l,t),s(l,al,t),s(l,E,t),s(l,pl,t),s(l,b,t),s(l,Cl,t),s(l,h,t),s(l,ml,t),s(l,k,t),s(l,jl,t),C(F,l,t),s(l,wl,t),s(l,$,t),s(l,yl,t),C(O,l,t),s(l,Il,t),s(l,x,t),s(l,Vl,t),s(l,v,t),s(l,ol,t),C(Z,l,t),s(l,Ql,t),s(l,g,t),s(l,fl,t),C(S,l,t),s(l,dl,t),s(l,N,t),s(l,rl,t),C(W,l,t),s(l,cl,t),s(l,D,t),s(l,Rl,t),C(G,l,t),s(l,ul,t),s(l,H,t),_l=!0},p:lt,i(l){_l||(m(y.$$.fragment,l),m(r.$$.fragment,l),m(B.$$.fragment,l),m(F.$$.fragment,l),m(O.$$.fragment,l),m(Z.$$.fragment,l),m(S.$$.fragment,l),m(W.$$.fragment,l),m(G.$$.fragment,l),_l=!0)},o(l){j(y.$$.fragment,l),j(r.$$.fragment,l),j(B.$$.fragment,l),j(F.$$.fragment,l),j(O.$$.fragment,l),j(Z.$$.fragment,l),j(S.$$.fragment,l),j(W.$$.fragment,l),j(G.$$.fragment,l),_l=!1},d(l){l&&(e(X),e(L),e(z),e(P),e(I),e(K),e(V),e(q),e(o),e(ll),e(Q),e(tl),e(f),e(el),e(d),e(sl),e(nl),e(c),e(Ml),e(R),e(Jl),e(u),e(Ul),e(_),e(il),e(A),e(Tl),e(al),e(E),e(pl),e(b),e(Cl),e(h),e(ml),e(k),e(jl),e(wl),e($),e(yl),e(Il),e(x),e(Vl),e(v),e(ol),e(Ql),e(g),e(fl),e(dl),e(N),e(rl),e(cl),e(D),e(Rl),e(ul),e(H)),e(T),w(y,l),w(r,l),w(B,l),w(F,l),w(O,l),w(Z,l),w(S,l),w(W,l),w(G,l)}}}const it='{"title":"모듈식 트랜스포머","local":"modular-transformers","sections":[{"title":"무엇인가요","local":"what-is-it","sections":[{"title":"자세한 내용","local":"details","sections":[],"depth":3},{"title":"시행","local":"enforcement","sections":[],"depth":3},{"title":"예시","local":"examples","sections":[],"depth":3}],"depth":2},{"title":"무엇이 아닌가요","local":"what-it-is-not","sections":[],"depth":2}],"depth":1}';function Tt(Al){return tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jt extends et{constructor(T){super(),st(this,T,Tt,Ut,ql,{})}}export{jt as component};
