import{s as Qo,o as So,n as Ie}from"../chunks/scheduler.bdbef820.js";import{S as Po,i as Do,g as d,s as n,r as m,m as Oo,A as Yo,h as c,f as o,c as s,j as z,u as h,x as p,n as Ko,k as F,y as r,a as i,v as u,d as f,t as g,w as _}from"../chunks/index.33f81d56.js";import{T as It}from"../chunks/Tip.34194030.js";import{D as I}from"../chunks/Docstring.b9574034.js";import{C as st}from"../chunks/CodeBlock.3bad7fc9.js";import{E as go}from"../chunks/ExampleCodeBlock.633185da.js";import{P as en}from"../chunks/PipelineTag.d2f354cd.js";import{H as K,E as tn}from"../chunks/index.9edc4842.js";function on(w){let a,T=`Hub에 업로드된 체크포인트들은 <code>torch_dtype = &#39;float16&#39;</code>을 사용합니다.
이는 <code>AutoModel</code> API가 체크포인트를 <code>torch.float32</code>에서 <code>torch.float16</code>으로 변환하는 데 사용됩니다.`,l,b,U="온라인 가중치의 <code>dtype</code>은 <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>를 사용하여 모델을 초기화할 때 <code>torch_dtype=&quot;auto&quot;</code>를 사용하지 않는 한 대부분 무관합니다. 그 이유는 모델이 먼저 다운로드되고(온라인 체크포인트의 <code>dtype</code> 사용), 그 다음 <code>torch</code>의 기본 <code>dtype</code>으로 변환되며(이때 <code>torch.float32</code>가 됨), 마지막으로 config에 <code>torch_dtype</code>이 제공된 경우 이를 사용하기 때문입니다.",M,C,ee="모델을 <code>float16</code>으로 훈련하는 것은 권장되지 않으며 <code>nan</code>을 생성하는 것으로 알려져 있습니다. 따라서 모델은 <code>bfloat16</code>으로 훈련해야 합니다.";return{c(){a=d("p"),a.innerHTML=T,l=n(),b=d("p"),b.innerHTML=U,M=n(),C=d("p"),C.innerHTML=ee},l(v){a=c(v,"P",{"data-svelte-h":!0}),p(a)!=="svelte-skn6hj"&&(a.innerHTML=T),l=s(v),b=c(v,"P",{"data-svelte-h":!0}),p(b)!=="svelte-2ftclq"&&(b.innerHTML=U),M=s(v),C=c(v,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1p0t60p"&&(C.innerHTML=ee)},m(v,G){i(v,a,G),i(v,l,G),i(v,b,G),i(v,M,G),i(v,C,G)},p:Ie,d(v){v&&(o(a),o(l),o(b),o(M),o(C))}}}function nn(w){let a,T;return a=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENvaGVyZU1vZGVsJTJDJTIwQ29oZXJlQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENvaGVyZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBDb2hlcmVDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBDb2hlcmUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBDb2hlcmVNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CohereModel, CohereConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Cohere model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = CohereConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the Cohere configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = CohereModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){m(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,b){u(a,l,b),T=!0},p:Ie,i(l){T||(f(a.$$.fragment,l),T=!0)},o(l){g(a.$$.fragment,l),T=!1},d(l){_(a,l)}}}function sn(w){let a,T;return a=new st({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJDb2hlcmVGb3JBSSUyRmM0YWktY29tbWFuZC1yLXYwMSUyMiklMEF0b2tlbml6ZXIuZW5jb2RlKCUyMkhlbGxvJTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.encode(<span class="hljs-string">&quot;Hello this is a test&quot;</span>)
[<span class="hljs-number">5</span>, <span class="hljs-number">28339</span>, <span class="hljs-number">2075</span>, <span class="hljs-number">1801</span>, <span class="hljs-number">1671</span>, <span class="hljs-number">3282</span>]`,wrap:!1}}),{c(){m(a.$$.fragment)},l(l){h(a.$$.fragment,l)},m(l,b){u(a,l,b),T=!0},p:Ie,i(l){T||(f(a.$$.fragment,l),T=!0)},o(l){g(a.$$.fragment,l),T=!1},d(l){_(a,l)}}}function an(w){let a,T="When used with <code>is_split_into_words=True</code>, this tokenizer needs to be instantiated with <code>add_prefix_space=True</code>.";return{c(){a=d("p"),a.innerHTML=T},l(l){a=c(l,"P",{"data-svelte-h":!0}),p(a)!=="svelte-9gg91e"&&(a.innerHTML=T)},m(l,b){i(l,a,b)},p:Ie,d(l){l&&o(a)}}}function rn(w){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=d("p"),a.innerHTML=T},l(l){a=c(l,"P",{"data-svelte-h":!0}),p(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(l,b){i(l,a,b)},p:Ie,d(l){l&&o(a)}}}function ln(w){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=d("p"),a.innerHTML=T},l(l){a=c(l,"P",{"data-svelte-h":!0}),p(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(l,b){i(l,a,b)},p:Ie,d(l){l&&o(a)}}}function dn(w){let a,T="Example:",l,b,U;return b=new st({props:{code:"JTNFJTNFJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBDb2hlcmVGb3JDYXVzYWxMTSUwQSUwQSUzRSUzRSUyMG1vZGVsJTIwJTNEJTIwQ29oZXJlRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyKSUwQSUzRSUzRSUyMHRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyKSUwQSUwQSUzRSUzRSUyMHByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBJTNFJTNFJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTNFJTNFJTIwJTIzJTIwR2VuZXJhdGUlMEElM0UlM0UlMjBnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMuaW5wdXRfaWRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQSUzRSUzRSUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQSUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTVDbkknbSUyMG5vdCUyMGNvbnNjaW91cyUyQyUyMGJ1dCUyMEklMjBjYW4lMjB0YWxrJTIwdG8lMjB5b3UuJTIy",highlighted:`&gt;&gt; <span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, CohereForCausalLM

&gt;&gt; model = CohereForCausalLM.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)
&gt;&gt; tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>)

&gt;&gt; prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
&gt;&gt; inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

&gt;&gt; <span class="hljs-comment"># Generate</span>
&gt;&gt; generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
&gt;&gt; tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?\\nI&#x27;m not conscious, but I can talk to you.&quot;</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=T,l=n(),m(b.$$.fragment)},l(M){a=c(M,"P",{"data-svelte-h":!0}),p(a)!=="svelte-11lpom8"&&(a.textContent=T),l=s(M),h(b.$$.fragment,M)},m(M,C){i(M,a,C),i(M,l,C),u(b,M,C),U=!0},p:Ie,i(M){U||(f(b.$$.fragment,M),U=!0)},o(M){g(b.$$.fragment,M),U=!1},d(M){M&&(o(a),o(l)),_(b,M)}}}function cn(w){let a,T,l,b,U,M,C,ee,v,G='The Cohere Command-R 모델은 Cohere팀이 <a href="https://txt.cohere.com/command-r/" rel="nofollow">Command-R: 프로덕션 규모의 검색 증강 생성</a>라는 블로그 포스트에서 소개 되었습니다.',it,te,_o="논문 초록:",lt,oe,yo="<em>Command-R은 기업의 프로덕션 규모 AI를 가능하게 하기 위해 RAG(검색 증강 생성)와 도구 사용을 목표로 하는 확장 가능한 생성 모델입니다. 오늘 우리는 대규모 프로덕션 워크로드를 목표로 하는 새로운 LLM인 Command-R을 소개합니다. Command-R은 높은 효율성과 강력한 정확성의 균형을 맞추는 ‘확장 가능한’ 모델 카테고리를 대상으로 하여, 기업들이 개념 증명을 넘어 프로덕션 단계로 나아갈 수 있게 합니다.</em>",dt,ne,bo="*Command-R은 검색 증강 생성(RAG)이나 외부 API 및 도구 사용과 같은 긴 문맥 작업에 최적화된 생성 모델입니다. 이 모델은 RAG 애플리케이션을 위한 최고 수준의 통합을 제공하고 기업 사용 사례에서 뛰어난 성능을 발휘하기 위해 우리의 업계 선도적인 Embed 및 Rerank 모델과 조화롭게 작동하도록 설계되었습니다. 기업이 대규모로 구현할 수 있도록 만들어진 모델로서, Command-R은 다음과 같은 특징을 자랑합니다:",ct,se,To="<li>RAG 및 도구 사용에 대한 강력한 정확성</li> <li>낮은 지연 시간과 높은 처리량</li> <li>더 긴 128k 컨텍스트와 낮은 가격</li> <li>10개의 주요 언어에 걸친 강력한 기능</li> <li>연구 및 평가를 위해 HuggingFace에서 사용 가능한 모델 가중치</li>",pt,ae,ko=`모델 체크포인트는 <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">이곳</a>에서 확인하세요.
이 모델은 <a href="https://huggingface.co/saurabhdash" rel="nofollow">Saurabh Dash</a>과 <a href="https://huggingface.co/ahmetustun" rel="nofollow">Ahmet Üstün</a>에 의해 기여 되었습니다. Hugging Face에서 이 코드의 구현은 <a href="https://github.com/EleutherAI/gpt-neox" rel="nofollow">GPT-NeoX</a>에 기반하였습니다.`,mt,re,ht,q,ut,ie,ft,le,Mo="<li>Flash Attention 2를 <code>attn_implementation=&quot;flash_attention_2&quot;</code>를 통해 사용할 때는, <code>from_pretrained</code> 클래스 메서드에 <code>torch_dtype</code>을 전달하지 말고 자동 혼합 정밀도 훈련(Automatic Mixed-Precision training)을 사용하세요. <code>Trainer</code>를 사용할 때는 단순히 <code>fp16</code> 또는 <code>bf16</code>을 <code>True</code>로 지정하면 됩니다. 그렇지 않은 경우에는 <code>torch.autocast</code>를 사용하고 있는지 확인하세요. 이는 Flash Attention이 <code>fp16</code>와 <code>bf16</code> 데이터 타입만 지원하기 때문에 필요합니다.</li>",gt,de,_t,ce,vo="Command-R을 시작하는 데 도움이 되는 Hugging Face와 community 자료 목록(🌎로 표시됨) 입니다. 여기에 포함될 자료를 제출하고 싶으시다면 PR(Pull Request)를 열어주세요. 리뷰 해드리겠습니다! 자료는 기존 자료를 복제하는 대신 새로운 내용을 담고 있어야 합니다.",yt,pe,bt,me,Co="FP16 모델 로딩",Tt,he,kt,ue,wo="bitsandbytes 라이브러리를 이용해서 4bit 양자화된 모델 로딩",Mt,fe,vt,ge,Ct,x,_e,Vt,Ve,Uo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereModel">CohereModel</a>. It is used to instantiate an Cohere
model according to the specified arguments, defining the model architecture.`,Wt,We,$o=`Configuration objects inherit from <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">CohereForAI/c4ai-command-r-v01</a> model.`,Zt,A,wt,ye,Ut,y,be,Et,Ze,Jo="Construct a Cohere tokenizer. Based on byte-level Byte-Pair-Encoding.",Lt,Ee,xo="This uses notably ByteFallback and NFC normalization.",Nt,H,Bt,Le,zo=`If you want to change the <code>bos_token</code> or the <code>eos_token</code>, make sure to specify them when initializing the model, or
call <code>tokenizer.update_post_processor()</code> to make sure that the post-processing is correctly done (otherwise the
values of the first token and final token of an encoded sequence will not be correct). For more details, checkout
[post-processors] (<a href="https://huggingface.co/docs/tokenizers/api/post-processors" rel="nofollow">https://huggingface.co/docs/tokenizers/api/post-processors</a>) documentation.`,Gt,Ne,Fo=`You can get around that behavior by passing <code>add_prefix_space=True</code> when instantiating this tokenizer, but since
the model was not pretrained this way, it might yield a decrease in performance.`,qt,X,At,Be,jo=`This tokenizer inherits from <code>PreTrainedTokenizerFast</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Ht,Ge,Te,Xt,Q,ke,Qt,qe,Ro=`Retrieves sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> or <code>encode_plus</code> methods.`,St,V,Me,Pt,Ae,Io=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Dt,He,Vo="Should be overridden in a subclass if the model has a special way of building those.",Ot,S,ve,Yt,Xe,Wo="Updates the underlying post processor with the current <code>bos_token</code> and <code>eos_token</code>.",Kt,W,Ce,eo,Qe,Zo="Save only the vocabulary of the tokenizer (vocabulary + added tokens).",to,Se,Eo=`This method won’t save the configuration and special token mappings of the tokenizer. Use
<code>_save_pretrained()</code> to save the whole state of the tokenizer.`,$t,we,Jt,$,Ue,oo,Pe,Lo="The bare Cohere Model outputting raw hidden-states without any specific head on top.",no,De,No=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,so,Oe,Bo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ao,Z,$e,ro,Ye,Go='The <a href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereModel">CohereModel</a> forward method, overrides the <code>__call__</code> special method.',io,P,xt,Je,zt,J,xe,lo,Ke,qo="The Cohere Model for causal language modeling.",co,et,Ao=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,po,tt,Ho=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,mo,j,ze,ho,ot,Xo='The <a href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereForCausalLM">CohereForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',uo,D,fo,O,Ft,Fe,jt,at,Rt;return U=new K({props:{title:"Cohere",local:"cohere",headingTag:"h1"}}),C=new K({props:{title:"개요",local:"overview",headingTag:"h2"}}),re=new K({props:{title:"사용 팁",local:"usage-tips",headingTag:"h2"}}),q=new It({props:{warning:!0,$$slots:{default:[on]},$$scope:{ctx:w}}}),ie=new st({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwRm9ybWF0JTIwbWVzc2FnZSUyMHdpdGglMjB0aGUlMjBjb21tYW5kLXIlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTVEJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjMlMjMlMjAlM0NCT1NfVE9LRU4lM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDVVNFUl9UT0tFTiU3QyUzRUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTdDRU5EX09GX1RVUk5fVE9LRU4lN0MlM0UlM0MlN0NTVEFSVF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDQ0hBVEJPVF9UT0tFTiU3QyUzRSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># Format message with the command-r chat template</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]
input_ids = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment">## &lt;BOS_TOKEN&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|USER_TOKEN|&gt;Hello, how are you?&lt;|END_OF_TURN_TOKEN|&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|CHATBOT_TOKEN|&gt;</span>

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),de=new K({props:{title:"리소스",local:"resources",headingTag:"h2"}}),pe=new en({props:{pipeline:"text-generation"}}),he=new st({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvVG9rZW5pemVyJTJDJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkNvaGVyZUZvckFJJTJGYzRhaS1jb21tYW5kLXItdjAxJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBJTBBJTIzJTIwY29tbWFuZC1yJTIwJUVDJUIxJTk3JTIwJUVEJTg1JTlDJUVEJTk0JThDJUVCJUE2JUJGJUVDJTlDJUJDJUVCJUExJTlDJTIwJUVCJUE5JTk0JUVDJTg0JUI4JUVDJUE3JTgwJTIwJUVEJTk4JTk1JUVDJThCJTlEJUVDJTlEJTg0JTIwJUVDJUEwJTk1JUVEJTk1JTk4JUVDJTg0JUI4JUVDJTlBJTk0JTBBbWVzc2FnZXMlMjAlM0QlMjAlNUIlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCU1RCUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKG1lc3NhZ2VzJTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIzJTIzJTIwJTNDQk9TX1RPS0VOJTNFJTNDJTdDU1RBUlRfT0ZfVFVSTl9UT0tFTiU3QyUzRSUzQyU3Q1VTRVJfVE9LRU4lN0MlM0VIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUzQyU3Q0VORF9PRl9UVVJOX1RPS0VOJTdDJTNFJTNDJTdDU1RBUlRfT0ZfVFVSTl9UT0tFTiU3QyUzRSUzQyU3Q0NIQVRCT1RfVE9LRU4lN0MlM0UlMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTJDJTIwJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMDAlMkMlMjAlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwJTBBJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjMlMkMlMEElMjAlMjAlMjAlMjApJTBBJTBBZ2VuX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbl90b2tlbnMlNUIwJTVEKSUwQXByaW50KGdlbl90ZXh0KQ==",highlighted:`<span class="hljs-comment"># pip install transformers</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id)

<span class="hljs-comment"># command-r 챗 템플릿으로 메세지 형식을 정하세요</span>
messages = [{<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>}]
input_ids = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment">## &lt;BOS_TOKEN&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|USER_TOKEN|&gt;Hello, how are you?&lt;|END_OF_TURN_TOKEN|&gt;&lt;|START_OF_TURN_TOKEN|&gt;&lt;|CHATBOT_TOKEN|&gt;</span>

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),fe=new st({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUyMGFjY2VsZXJhdGUlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBYm5iX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlKSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyQ29oZXJlRm9yQUklMkZjNGFpLWNvbW1hbmQtci12MDElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjAlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDEwMCUyQyUyMCUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjAlMEElMjAlMjAlMjAlMjB0ZW1wZXJhdHVyZSUzRDAuMyUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEFnZW5fdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuX3Rva2VucyU1QjAlNUQpJTBBcHJpbnQoZ2VuX3RleHQp",highlighted:`<span class="hljs-comment"># pip install transformers bitsandbytes accelerate</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>)

model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=bnb_config)

gen_tokens = model.generate(
    input_ids, 
    max_new_tokens=<span class="hljs-number">100</span>, 
    do_sample=<span class="hljs-literal">True</span>, 
    temperature=<span class="hljs-number">0.3</span>,
    )

gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),ge=new K({props:{title:"CohereConfig",local:"transformers.CohereConfig ][ transformers.CohereConfig",headingTag:"h2"}}),_e=new I({props:{name:"class transformers.CohereConfig",anchor:"transformers.CohereConfig",parameters:[{name:"vocab_size",val:" = 256000"},{name:"hidden_size",val:" = 8192"},{name:"intermediate_size",val:" = 22528"},{name:"logit_scale",val:" = 0.0625"},{name:"num_hidden_layers",val:" = 40"},{name:"num_attention_heads",val:" = 64"},{name:"num_key_value_heads",val:" = None"},{name:"hidden_act",val:" = 'silu'"},{name:"max_position_embeddings",val:" = 8192"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"bos_token_id",val:" = 5"},{name:"eos_token_id",val:" = 255001"},{name:"tie_word_embeddings",val:" = True"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"use_qk_norm",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CohereConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256000) &#x2014;
Vocabulary size of the Cohere model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereModel">CohereModel</a>`,name:"vocab_size"},{anchor:"transformers.CohereConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.CohereConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 22528) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.CohereConfig.logit_scale",description:`<strong>logit_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0625) &#x2014;
The scaling factor for the output logits.`,name:"logit_scale"},{anchor:"transformers.CohereConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 40) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.CohereConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.CohereConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1</code> the model will use Multi Query Attention (MQA) otherwise GQA is used. When
converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed
by meanpooling all the original heads within that group. For more details checkout <a href="https://arxiv.org/pdf/2305.13245.pdf" rel="nofollow">this
paper</a>. If it is not specified, will default to
<code>num_attention_heads</code>.`,name:"num_key_value_heads"},{anchor:"transformers.CohereConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.CohereConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.CohereConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.CohereConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.CohereConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.CohereConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.CohereConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.CohereConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 255001) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.CohereConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.CohereConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.CohereConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. NOTE: if you apply new rope type
and you expect the model to work on longer <code>max_position_embeddings</code>, we recommend you to update this value
accordingly.
Expected contents:
<code>rope_type</code> (<code>str</code>):
The sub-variant of RoPE to use. Can be one of [&#x2018;default&#x2019;, &#x2018;linear&#x2019;, &#x2018;dynamic&#x2019;, &#x2018;yarn&#x2019;, &#x2018;longrope&#x2019;,
&#x2018;llama3&#x2019;], with &#x2018;default&#x2019; being the original RoPE implementation.
<code>factor</code> (<code>float</code>, <em>optional</em>):
Used with all rope types except &#x2018;default&#x2019;. The scaling factor to apply to the RoPE embeddings. In
most scaling types, a <code>factor</code> of x will enable the model to handle sequences of length x <em>
original maximum pre-trained length.
<code>original_max_position_embeddings</code> (<code>int</code>, </em>optional<em>):
Used with &#x2018;dynamic&#x2019;, &#x2018;longrope&#x2019; and &#x2018;llama3&#x2019;. The original max position embeddings used during
pretraining.
<code>attention_factor</code> (<code>float</code>, </em>optional<em>):
Used with &#x2018;yarn&#x2019; and &#x2018;longrope&#x2019;. The scaling factor to be applied on the attention
computation. If unspecified, it defaults to value recommended by the implementation, using the
<code>factor</code> field to infer the suggested value.
<code>beta_fast</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for extrapolation (only) in the linear
ramp function. If unspecified, it defaults to 32.
<code>beta_slow</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;yarn&#x2019;. Parameter to set the boundary for interpolation (only) in the linear
ramp function. If unspecified, it defaults to 1.
<code>short_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to short contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>long_factor</code> (<code>List[float]</code>, </em>optional<em>):
Only used with &#x2018;longrope&#x2019;. The scaling factor to be applied to long contexts (&lt;
<code>original_max_position_embeddings</code>). Must be a list of numbers with the same length as the hidden
size divided by the number of attention heads divided by 2
<code>low_freq_factor</code> (<code>float</code>, </em>optional<em>):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to low frequency components of the RoPE
<code>high_freq_factor</code> (<code>float</code>, </em>optional*):
Only used with &#x2018;llama3&#x2019;. Scaling factor applied to high frequency components of the RoPE`,name:"rope_scaling"},{anchor:"transformers.CohereConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, defaults to <code>False</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.CohereConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.CohereConfig.use_qk_norm",description:`<strong>use_qk_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use query-key normalization in the attention`,name:"use_qk_norm"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/configuration_cohere.py#L30"}}),A=new go({props:{anchor:"transformers.CohereConfig.example",$$slots:{default:[nn]},$$scope:{ctx:w}}}),ye=new K({props:{title:"CohereTokenizerFast",local:"transformers.CohereTokenizerFast ][ transformers.CohereTokenizerFast",headingTag:"h2"}}),be=new I({props:{name:"class transformers.CohereTokenizerFast",anchor:"transformers.CohereTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"merges_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"clean_up_tokenization_spaces",val:" = False"},{name:"unk_token",val:" = '<UNK>'"},{name:"bos_token",val:" = '<BOS_TOKEN>'"},{name:"eos_token",val:" = '<|END_OF_TURN_TOKEN|>'"},{name:"add_bos_token",val:" = True"},{name:"add_eos_token",val:" = False"},{name:"use_default_system_prompt",val:" = False"},{name:"add_prefix_space",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the vocabulary file.`,name:"vocab_file"},{anchor:"transformers.CohereTokenizerFast.merges_file",description:`<strong>merges_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Path to the merges file.`,name:"merges_file"},{anchor:"transformers.CohereTokenizerFast.tokenizer_file",description:`<strong>tokenizer_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
<a href="https://github.com/huggingface/tokenizers" rel="nofollow">tokenizers</a> file (generally has a .json extension) that
contains everything needed to load the tokenizer.`,name:"tokenizer_file"},{anchor:"transformers.CohereTokenizerFast.clean_up_tokenization_spaces",description:`<strong>clean_up_tokenization_spaces</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to cleanup spaces after decoding, cleanup consists in removing potential artifacts like
extra spaces.`,name:"clean_up_tokenization_spaces"},{anchor:"transformers.CohereTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;UNK&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.CohereTokenizerFast.bos_token",description:`<strong>bos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;BOS_TOKEN&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.`,name:"bos_token"},{anchor:"transformers.CohereTokenizerFast.eos_token",description:`<strong>eos_token</strong> (<code>str</code> or <code>tokenizers.AddedToken</code>, <em>optional</em>, defaults to <code>&quot;&lt;|END_OF_TURN_TOKEN|&gt;&quot;</code>) &#x2014;
The end of sequence token.`,name:"eos_token"},{anchor:"transformers.CohereTokenizerFast.add_bos_token",description:`<strong>add_bos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add an <code>bos_token</code> at the start of sequences.`,name:"add_bos_token"},{anchor:"transformers.CohereTokenizerFast.add_eos_token",description:`<strong>add_eos_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to add an <code>eos_token</code> at the end of sequences.`,name:"add_eos_token"},{anchor:"transformers.CohereTokenizerFast.use_default_system_prompt",description:`<strong>use_default_system_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the default system prompt for Cohere tokenizer should be used.`,name:"use_default_system_prompt"},{anchor:"transformers.CohereTokenizerFast.add_prefix_space",description:`<strong>add_prefix_space</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the tokenizer should automatically add a prefix space`,name:"add_prefix_space"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/tokenization_cohere_fast.py#L47"}}),H=new go({props:{anchor:"transformers.CohereTokenizerFast.example",$$slots:{default:[sn]},$$scope:{ctx:w}}}),X=new It({props:{$$slots:{default:[an]},$$scope:{ctx:w}}}),Te=new I({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.CohereTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:""},{name:"token_ids_1",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/tokenization_cohere_fast.py#L500"}}),ke=new I({props:{name:"get_special_tokens_mask",anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of ids of the first sequence.`,name:"token_ids_0"},{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
List of ids of the second sequence.`,name:"token_ids_1"},{anchor:"transformers.CohereTokenizerFast.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3856",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]</p>
`}}),Me=new I({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.CohereTokenizerFast.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L3379",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new I({props:{name:"update_post_processor",anchor:"transformers.CohereTokenizerFast.update_post_processor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/tokenization_cohere_fast.py#L184"}}),Ce=new I({props:{name:"save_vocabulary",anchor:"transformers.CohereTokenizerFast.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"transformers.CohereTokenizerFast.save_vocabulary.save_directory",description:`<strong>save_directory</strong> (<code>str</code>) &#x2014;
The directory in which to save the vocabulary.`,name:"save_directory"},{anchor:"transformers.CohereTokenizerFast.save_vocabulary.filename_prefix",description:`<strong>filename_prefix</strong> (<code>str</code>, <em>optional</em>) &#x2014;
An optional prefix to add to the named of the saved files.`,name:"filename_prefix"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tokenization_utils_base.py#L2582",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Paths to the files saved.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple(str)</code></p>
`}}),we=new K({props:{title:"CohereModel",local:"transformers.CohereModel ][ transformers.CohereModel",headingTag:"h2"}}),Ue=new I({props:{name:"class transformers.CohereModel",anchor:"transformers.CohereModel",parameters:[{name:"config",val:": CohereConfig"}],parametersDescription:[{anchor:"transformers.CohereModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereConfig">CohereConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L380"}}),$e=new I({props:{name:"forward",anchor:"transformers.CohereModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.CohereModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CohereModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CohereModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CohereModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>~cache_utils.Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.CohereModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CohereModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CohereModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CohereModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CohereModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L404",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereConfig"
>CohereConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPast"
>transformers.modeling_outputs.BaseModelOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new It({props:{$$slots:{default:[rn]},$$scope:{ctx:w}}}),Je=new K({props:{title:"CohereForCausalLM",local:"transformers.CohereForCausalLM ][ transformers.CohereForCausalLM",headingTag:"h2"}}),xe=new I({props:{name:"class transformers.CohereForCausalLM",anchor:"transformers.CohereForCausalLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.CohereForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereForCausalLM">CohereForCausalLM</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L508"}}),ze=new I({props:{name:"forward",anchor:"transformers.CohereForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.List[torch.FloatTensor], transformers.cache_utils.Cache, NoneType] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.cohere.modeling_cohere.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.CohereForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ko/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ko/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.CohereForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.CohereForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.CohereForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Union[List[torch.FloatTensor], ~cache_utils.Cache, NoneType]</code>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/ko/internal/generation_utils#transformers.Cache">Cache</a> instance, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.CohereForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.CohereForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.CohereForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.CohereForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.CohereForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.CohereForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.CohereForCausalLM.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>Union[int, torch.Tensor]</code>, defaults to <code>0</code>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/cohere/modeling_cohere.py#L543",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/ko/model_doc/cohere#transformers.CohereConfig"
>CohereConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — It is a <a
  href="/docs/transformers/main/ko/internal/generation_utils#transformers.Cache"
>Cache</a> instance. For more details, see our <a
  href="https://huggingface.co/docs/transformers/en/kv_cache"
  rel="nofollow"
>kv cache guide</a>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/ko/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new It({props:{$$slots:{default:[ln]},$$scope:{ctx:w}}}),O=new go({props:{anchor:"transformers.CohereForCausalLM.forward.example",$$slots:{default:[dn]},$$scope:{ctx:w}}}),Fe=new tn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/model_doc/cohere.md"}}),{c(){a=d("meta"),T=n(),l=d("p"),b=n(),m(U.$$.fragment),M=n(),m(C.$$.fragment),ee=n(),v=d("p"),v.innerHTML=G,it=n(),te=d("p"),te.textContent=_o,lt=n(),oe=d("p"),oe.innerHTML=yo,dt=n(),ne=d("p"),ne.textContent=bo,ct=n(),se=d("ul"),se.innerHTML=To,pt=n(),ae=d("p"),ae.innerHTML=ko,mt=n(),m(re.$$.fragment),ht=n(),m(q.$$.fragment),ut=Oo(`
모델과 토크나이저는 다음과 같이 로드할 수 있습니다:

	`),m(ie.$$.fragment),ft=n(),le=d("ul"),le.innerHTML=Mo,gt=n(),m(de.$$.fragment),_t=n(),ce=d("p"),ce.textContent=vo,yt=n(),m(pe.$$.fragment),bt=n(),me=d("p"),me.textContent=Co,Tt=n(),m(he.$$.fragment),kt=n(),ue=d("p"),ue.textContent=wo,Mt=n(),m(fe.$$.fragment),vt=n(),m(ge.$$.fragment),Ct=n(),x=d("div"),m(_e.$$.fragment),Vt=n(),Ve=d("p"),Ve.innerHTML=Uo,Wt=n(),We=d("p"),We.innerHTML=$o,Zt=n(),m(A.$$.fragment),wt=n(),m(ye.$$.fragment),Ut=n(),y=d("div"),m(be.$$.fragment),Et=n(),Ze=d("p"),Ze.textContent=Jo,Lt=n(),Ee=d("p"),Ee.textContent=xo,Nt=n(),m(H.$$.fragment),Bt=n(),Le=d("p"),Le.innerHTML=zo,Gt=n(),Ne=d("p"),Ne.innerHTML=Fo,qt=n(),m(X.$$.fragment),At=n(),Be=d("p"),Be.innerHTML=jo,Ht=n(),Ge=d("div"),m(Te.$$.fragment),Xt=n(),Q=d("div"),m(ke.$$.fragment),Qt=n(),qe=d("p"),qe.innerHTML=Ro,St=n(),V=d("div"),m(Me.$$.fragment),Pt=n(),Ae=d("p"),Ae.innerHTML=Io,Dt=n(),He=d("p"),He.textContent=Vo,Ot=n(),S=d("div"),m(ve.$$.fragment),Yt=n(),Xe=d("p"),Xe.innerHTML=Wo,Kt=n(),W=d("div"),m(Ce.$$.fragment),eo=n(),Qe=d("p"),Qe.textContent=Zo,to=n(),Se=d("p"),Se.innerHTML=Eo,$t=n(),m(we.$$.fragment),Jt=n(),$=d("div"),m(Ue.$$.fragment),oo=n(),Pe=d("p"),Pe.textContent=Lo,no=n(),De=d("p"),De.innerHTML=No,so=n(),Oe=d("p"),Oe.innerHTML=Bo,ao=n(),Z=d("div"),m($e.$$.fragment),ro=n(),Ye=d("p"),Ye.innerHTML=Go,io=n(),m(P.$$.fragment),xt=n(),m(Je.$$.fragment),zt=n(),J=d("div"),m(xe.$$.fragment),lo=n(),Ke=d("p"),Ke.textContent=qo,co=n(),et=d("p"),et.innerHTML=Ao,po=n(),tt=d("p"),tt.innerHTML=Ho,mo=n(),j=d("div"),m(ze.$$.fragment),ho=n(),ot=d("p"),ot.innerHTML=Xo,uo=n(),m(D.$$.fragment),fo=n(),m(O.$$.fragment),Ft=n(),m(Fe.$$.fragment),jt=n(),at=d("p"),this.h()},l(e){const t=Yo("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(o),T=s(e),l=c(e,"P",{}),z(l).forEach(o),b=s(e),h(U.$$.fragment,e),M=s(e),h(C.$$.fragment,e),ee=s(e),v=c(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-34i7af"&&(v.innerHTML=G),it=s(e),te=c(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-rni9qx"&&(te.textContent=_o),lt=s(e),oe=c(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1vcxv2t"&&(oe.innerHTML=yo),dt=s(e),ne=c(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-168f0yy"&&(ne.textContent=bo),ct=s(e),se=c(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-1u2gq5c"&&(se.innerHTML=To),pt=s(e),ae=c(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1yu38yh"&&(ae.innerHTML=ko),mt=s(e),h(re.$$.fragment,e),ht=s(e),h(q.$$.fragment,e),ut=Ko(e,`
모델과 토크나이저는 다음과 같이 로드할 수 있습니다:

	`),h(ie.$$.fragment,e),ft=s(e),le=c(e,"UL",{"data-svelte-h":!0}),p(le)!=="svelte-1sudri4"&&(le.innerHTML=Mo),gt=s(e),h(de.$$.fragment,e),_t=s(e),ce=c(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-1iizv5a"&&(ce.textContent=vo),yt=s(e),h(pe.$$.fragment,e),bt=s(e),me=c(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-4ddbxi"&&(me.textContent=Co),Tt=s(e),h(he.$$.fragment,e),kt=s(e),ue=c(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1kedw8o"&&(ue.textContent=wo),Mt=s(e),h(fe.$$.fragment,e),vt=s(e),h(ge.$$.fragment,e),Ct=s(e),x=c(e,"DIV",{class:!0});var R=z(x);h(_e.$$.fragment,R),Vt=s(R),Ve=c(R,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1i30xb0"&&(Ve.innerHTML=Uo),Wt=s(R),We=c(R,"P",{"data-svelte-h":!0}),p(We)!=="svelte-17ajkg3"&&(We.innerHTML=$o),Zt=s(R),h(A.$$.fragment,R),R.forEach(o),wt=s(e),h(ye.$$.fragment,e),Ut=s(e),y=c(e,"DIV",{class:!0});var k=z(y);h(be.$$.fragment,k),Et=s(k),Ze=c(k,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-xb0zhn"&&(Ze.textContent=Jo),Lt=s(k),Ee=c(k,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-8f5ey4"&&(Ee.textContent=xo),Nt=s(k),h(H.$$.fragment,k),Bt=s(k),Le=c(k,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-cnb6q1"&&(Le.innerHTML=zo),Gt=s(k),Ne=c(k,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1afeqmz"&&(Ne.innerHTML=Fo),qt=s(k),h(X.$$.fragment,k),At=s(k),Be=c(k,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-1ndfe3e"&&(Be.innerHTML=jo),Ht=s(k),Ge=c(k,"DIV",{class:!0});var rt=z(Ge);h(Te.$$.fragment,rt),rt.forEach(o),Xt=s(k),Q=c(k,"DIV",{class:!0});var je=z(Q);h(ke.$$.fragment,je),Qt=s(je),qe=c(je,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1wmjg8a"&&(qe.innerHTML=Ro),je.forEach(o),St=s(k),V=c(k,"DIV",{class:!0});var N=z(V);h(Me.$$.fragment,N),Pt=s(N),Ae=c(N,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-zj1vf1"&&(Ae.innerHTML=Io),Dt=s(N),He=c(N,"P",{"data-svelte-h":!0}),p(He)!=="svelte-9vptpw"&&(He.textContent=Vo),N.forEach(o),Ot=s(k),S=c(k,"DIV",{class:!0});var Re=z(S);h(ve.$$.fragment,Re),Yt=s(Re),Xe=c(Re,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-nfci2w"&&(Xe.innerHTML=Wo),Re.forEach(o),Kt=s(k),W=c(k,"DIV",{class:!0});var B=z(W);h(Ce.$$.fragment,B),eo=s(B),Qe=c(B,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-rx0wq1"&&(Qe.textContent=Zo),to=s(B),Se=c(B,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-c9295b"&&(Se.innerHTML=Eo),B.forEach(o),k.forEach(o),$t=s(e),h(we.$$.fragment,e),Jt=s(e),$=c(e,"DIV",{class:!0});var E=z($);h(Ue.$$.fragment,E),oo=s(E),Pe=c(E,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-jpshns"&&(Pe.textContent=Lo),no=s(E),De=c(E,"P",{"data-svelte-h":!0}),p(De)!=="svelte-u3dlub"&&(De.innerHTML=No),so=s(E),Oe=c(E,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-hswkmf"&&(Oe.innerHTML=Bo),ao=s(E),Z=c(E,"DIV",{class:!0});var nt=z(Z);h($e.$$.fragment,nt),ro=s(nt),Ye=c(nt,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-n9msr6"&&(Ye.innerHTML=Go),io=s(nt),h(P.$$.fragment,nt),nt.forEach(o),E.forEach(o),xt=s(e),h(Je.$$.fragment,e),zt=s(e),J=c(e,"DIV",{class:!0});var L=z(J);h(xe.$$.fragment,L),lo=s(L),Ke=c(L,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-1tm3aen"&&(Ke.textContent=qo),co=s(L),et=c(L,"P",{"data-svelte-h":!0}),p(et)!=="svelte-u3dlub"&&(et.innerHTML=Ao),po=s(L),tt=c(L,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-hswkmf"&&(tt.innerHTML=Ho),mo=s(L),j=c(L,"DIV",{class:!0});var Y=z(j);h(ze.$$.fragment,Y),ho=s(Y),ot=c(Y,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-cx9p9i"&&(ot.innerHTML=Xo),uo=s(Y),h(D.$$.fragment,Y),fo=s(Y),h(O.$$.fragment,Y),Y.forEach(o),L.forEach(o),Ft=s(e),h(Fe.$$.fragment,e),jt=s(e),at=c(e,"P",{}),z(at).forEach(o),this.h()},h(){F(a,"name","hf:doc:metadata"),F(a,"content",pn),F(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){r(document.head,a),i(e,T,t),i(e,l,t),i(e,b,t),u(U,e,t),i(e,M,t),u(C,e,t),i(e,ee,t),i(e,v,t),i(e,it,t),i(e,te,t),i(e,lt,t),i(e,oe,t),i(e,dt,t),i(e,ne,t),i(e,ct,t),i(e,se,t),i(e,pt,t),i(e,ae,t),i(e,mt,t),u(re,e,t),i(e,ht,t),u(q,e,t),i(e,ut,t),u(ie,e,t),i(e,ft,t),i(e,le,t),i(e,gt,t),u(de,e,t),i(e,_t,t),i(e,ce,t),i(e,yt,t),u(pe,e,t),i(e,bt,t),i(e,me,t),i(e,Tt,t),u(he,e,t),i(e,kt,t),i(e,ue,t),i(e,Mt,t),u(fe,e,t),i(e,vt,t),u(ge,e,t),i(e,Ct,t),i(e,x,t),u(_e,x,null),r(x,Vt),r(x,Ve),r(x,Wt),r(x,We),r(x,Zt),u(A,x,null),i(e,wt,t),u(ye,e,t),i(e,Ut,t),i(e,y,t),u(be,y,null),r(y,Et),r(y,Ze),r(y,Lt),r(y,Ee),r(y,Nt),u(H,y,null),r(y,Bt),r(y,Le),r(y,Gt),r(y,Ne),r(y,qt),u(X,y,null),r(y,At),r(y,Be),r(y,Ht),r(y,Ge),u(Te,Ge,null),r(y,Xt),r(y,Q),u(ke,Q,null),r(Q,Qt),r(Q,qe),r(y,St),r(y,V),u(Me,V,null),r(V,Pt),r(V,Ae),r(V,Dt),r(V,He),r(y,Ot),r(y,S),u(ve,S,null),r(S,Yt),r(S,Xe),r(y,Kt),r(y,W),u(Ce,W,null),r(W,eo),r(W,Qe),r(W,to),r(W,Se),i(e,$t,t),u(we,e,t),i(e,Jt,t),i(e,$,t),u(Ue,$,null),r($,oo),r($,Pe),r($,no),r($,De),r($,so),r($,Oe),r($,ao),r($,Z),u($e,Z,null),r(Z,ro),r(Z,Ye),r(Z,io),u(P,Z,null),i(e,xt,t),u(Je,e,t),i(e,zt,t),i(e,J,t),u(xe,J,null),r(J,lo),r(J,Ke),r(J,co),r(J,et),r(J,po),r(J,tt),r(J,mo),r(J,j),u(ze,j,null),r(j,ho),r(j,ot),r(j,uo),u(D,j,null),r(j,fo),u(O,j,null),i(e,Ft,t),u(Fe,e,t),i(e,jt,t),i(e,at,t),Rt=!0},p(e,[t]){const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),q.$set(R);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),A.$set(k);const rt={};t&2&&(rt.$$scope={dirty:t,ctx:e}),H.$set(rt);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),X.$set(je);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),P.$set(N);const Re={};t&2&&(Re.$$scope={dirty:t,ctx:e}),D.$set(Re);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),O.$set(B)},i(e){Rt||(f(U.$$.fragment,e),f(C.$$.fragment,e),f(re.$$.fragment,e),f(q.$$.fragment,e),f(ie.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(A.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(H.$$.fragment,e),f(X.$$.fragment,e),f(Te.$$.fragment,e),f(ke.$$.fragment,e),f(Me.$$.fragment,e),f(ve.$$.fragment,e),f(Ce.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f($e.$$.fragment,e),f(P.$$.fragment,e),f(Je.$$.fragment,e),f(xe.$$.fragment,e),f(ze.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(Fe.$$.fragment,e),Rt=!0)},o(e){g(U.$$.fragment,e),g(C.$$.fragment,e),g(re.$$.fragment,e),g(q.$$.fragment,e),g(ie.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(A.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(H.$$.fragment,e),g(X.$$.fragment,e),g(Te.$$.fragment,e),g(ke.$$.fragment,e),g(Me.$$.fragment,e),g(ve.$$.fragment,e),g(Ce.$$.fragment,e),g(we.$$.fragment,e),g(Ue.$$.fragment,e),g($e.$$.fragment,e),g(P.$$.fragment,e),g(Je.$$.fragment,e),g(xe.$$.fragment,e),g(ze.$$.fragment,e),g(D.$$.fragment,e),g(O.$$.fragment,e),g(Fe.$$.fragment,e),Rt=!1},d(e){e&&(o(T),o(l),o(b),o(M),o(ee),o(v),o(it),o(te),o(lt),o(oe),o(dt),o(ne),o(ct),o(se),o(pt),o(ae),o(mt),o(ht),o(ut),o(ft),o(le),o(gt),o(_t),o(ce),o(yt),o(bt),o(me),o(Tt),o(kt),o(ue),o(Mt),o(vt),o(Ct),o(x),o(wt),o(Ut),o(y),o($t),o(Jt),o($),o(xt),o(zt),o(J),o(Ft),o(jt),o(at)),o(a),_(U,e),_(C,e),_(re,e),_(q,e),_(ie,e),_(de,e),_(pe,e),_(he,e),_(fe,e),_(ge,e),_(_e),_(A),_(ye,e),_(be),_(H),_(X),_(Te),_(ke),_(Me),_(ve),_(Ce),_(we,e),_(Ue),_($e),_(P),_(Je,e),_(xe),_(ze),_(D),_(O),_(Fe,e)}}}const pn='{"title":"Cohere","local":"cohere","sections":[{"title":"개요","local":"overview","sections":[],"depth":2},{"title":"사용 팁","local":"usage-tips","sections":[],"depth":2},{"title":"리소스","local":"resources","sections":[],"depth":2},{"title":"CohereConfig","local":"transformers.CohereConfig ][ transformers.CohereConfig","sections":[],"depth":2},{"title":"CohereTokenizerFast","local":"transformers.CohereTokenizerFast ][ transformers.CohereTokenizerFast","sections":[],"depth":2},{"title":"CohereModel","local":"transformers.CohereModel ][ transformers.CohereModel","sections":[],"depth":2},{"title":"CohereForCausalLM","local":"transformers.CohereForCausalLM ][ transformers.CohereForCausalLM","sections":[],"depth":2}],"depth":1}';function mn(w){return So(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kn extends Po{constructor(a){super(),Do(this,a,mn,cn,Qo,{})}}export{kn as component};
