import{s as Rn,o as In,n as te}from"../chunks/scheduler.bdbef820.js";import{S as Hn,i as Vn,g as m,s as a,r as h,A as zn,h as p,f as o,c as r,j as B,u,x as b,k as Z,y as i,a as l,v as f,d as g,t as T,w as _}from"../chunks/index.33f81d56.js";import{T as Nn}from"../chunks/Tip.34194030.js";import{D as I}from"../chunks/Docstring.b9574034.js";import{C as et}from"../chunks/CodeBlock.3bad7fc9.js";import{E as Ke}from"../chunks/ExampleCodeBlock.633185da.js";import{H as V,E as Yn}from"../chunks/index.9edc4842.js";function Xn(w){let s,y;return s=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGFuJTIwUGF0Y2hUU1QlMjBjb25maWd1cmF0aW9uJTIwd2l0aCUyMDEyJTIwdGltZSUyMHN0ZXBzJTIwZm9yJTIwcHJlZGljdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBQYXRjaFRTVENvbmZpZyhwcmVkaWN0aW9uX2xlbmd0aCUzRDEyKSUwQSUwQSUyMyUyMFJhbmRvbWx5JTIwaW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing an PatchTST configuration with 12 time steps for prediction</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PatchTSTConfig(prediction_length=<span class="hljs-number">12</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Randomly initializing a model (with random weights) from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){h(s.$$.fragment)},l(c){u(s.$$.fragment,c)},m(c,d){f(s,c,d),y=!0},p:te,i(c){y||(g(s.$$.fragment,c),y=!0)},o(c){T(s.$$.fragment,c),y=!1},d(c){_(s,c)}}}function En(w){let s,y="Examples:",c,d,M;return d=new et({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUTW9kZWwlMEElMEFmaWxlJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZXR0aDEtaG91cmx5LWJhdGNoJTIyJTJDJTIwZmlsZW5hbWUlM0QlMjJ0cmFpbi1iYXRjaC5wdCUyMiUyQyUyMHJlcG9fdHlwZSUzRCUyMmRhdGFzZXQlMjIlMEEpJTBBYmF0Y2glMjAlM0QlMjB0b3JjaC5sb2FkKGZpbGUpJTBBJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJuYW1jdGluJTJGcGF0Y2h0c3RfZXR0aDFfcHJldHJhaW4lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCUwQSUyMCUyMCUyMCUyMHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGZ1dHVyZV92YWx1ZXMlM0RiYXRjaCU1QiUyMmZ1dHVyZV92YWx1ZXMlMjIlNUQlMkMlMEEpJTBBJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTModel

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTModel.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_pretrain&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,c=a(),h(d.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),b(s)!=="svelte-kvfsh7"&&(s.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){l(t,s,v),l(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(o(s),o(c)),_(d,t)}}}function qn(w){let s,y="Examples:",c,d,M;return d=new et({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmVkaWN0aW9uJTBBJTBBZmlsZSUyMCUzRCUyMGhmX2h1Yl9kb3dubG9hZCglMEElMjAlMjAlMjAlMjByZXBvX2lkJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmV0dGgxLWhvdXJseS1iYXRjaCUyMiUyQyUyMGZpbGVuYW1lJTNEJTIydHJhaW4tYmF0Y2gucHQlMjIlMkMlMjByZXBvX3R5cGUlM0QlMjJkYXRhc2V0JTIyJTBBKSUwQWJhdGNoJTIwJTNEJTIwdG9yY2gubG9hZChmaWxlKSUwQSUwQSUyMyUyMFByZWRpY3Rpb24lMjB0YXNrJTIwd2l0aCUyMDclMjBpbnB1dCUyMGNoYW5uZWxzJTIwYW5kJTIwcHJlZGljdGlvbiUyMGxlbmd0aCUyMGlzJTIwOTYlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUHJlZGljdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX2ZvcmVjYXN0JTIyKSUwQSUwQSUyMyUyMGR1cmluZyUyMHRyYWluaW5nJTJDJTIwb25lJTIwcHJvdmlkZXMlMjBib3RoJTIwcGFzdCUyMGFuZCUyMGZ1dHVyZSUyMHZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCglMEElMjAlMjAlMjAlMjBwYXN0X3ZhbHVlcyUzRGJhdGNoJTVCJTIycGFzdF92YWx1ZXMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBmdXR1cmVfdmFsdWVzJTNEYmF0Y2glNUIlMjJmdXR1cmVfdmFsdWVzJTIyJTVEJTJDJTBBKSUwQSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEFsb3NzLmJhY2t3YXJkKCklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTJDJTIwdGhlJTIwbW9kZWwlMjBvdXRwdXRzJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEFwcmVkaWN0aW9uX291dHB1dHMlMjAlM0QlMjBvdXRwdXRzLnByZWRpY3Rpb25fb3V0cHV0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPrediction

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prediction task with 7 input channels and prediction length is 96</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPrediction.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_forecast&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(
<span class="hljs-meta">... </span>    past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>],
<span class="hljs-meta">... </span>    future_values=batch[<span class="hljs-string">&quot;future_values&quot;</span>],
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction_outputs = outputs.prediction_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,c=a(),h(d.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),b(s)!=="svelte-kvfsh7"&&(s.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){l(t,s,v),l(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(o(s),o(c)),_(d,t)}}}function Qn(w){let s,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=m("p"),s.innerHTML=y},l(c){s=p(c,"P",{"data-svelte-h":!0}),b(s)!=="svelte-fincs2"&&(s.innerHTML=y)},m(c,d){l(c,s,d)},p:te,d(c){c&&o(s)}}}function Dn(w){let s,y="Examples:",c,d,M;return d=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JDbGFzc2lmaWNhdGlvbiUwQSUwQSUyMyUyMGNsYXNzaWZpY2F0aW9uJTIwdGFzayUyMHdpdGglMjB0d28lMjBpbnB1dCUyMGNoYW5uZWwyJTIwYW5kJTIwMyUyMGNsYXNzZXMlMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RhcmdldHMlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwdXNlX2Nsc190b2tlbiUzRFRydWUlMkMlMEEpJTBBbW9kZWwlMjAlM0QlMjBQYXRjaFRTVEZvckNsYXNzaWZpY2F0aW9uKGNvbmZpZyUzRGNvbmZpZyklMEElMEElMjMlMjBkdXJpbmclMjBpbmZlcmVuY2UlMkMlMjBvbmUlMjBvbmx5JTIwcHJvdmlkZXMlMjBwYXN0JTIwdmFsdWVzJTBBcGFzdF92YWx1ZXMlMjAlM0QlMjB0b3JjaC5yYW5kbigyMCUyQyUyMDUxMiUyQyUyMDIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEcGFzdF92YWx1ZXMpJTBBbGFiZWxzJTIwJTNEJTIwb3V0cHV0cy5wcmVkaWN0aW9uX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># classification task with two input channel2 and 3 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    num_targets=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForClassification(config=config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = outputs.prediction_logits`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,c=a(),h(d.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),b(s)!=="svelte-kvfsh7"&&(s.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){l(t,s,v),l(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(o(s),o(c)),_(d,t)}}}function Ln(w){let s,y="Examples:",c,d,M;return d=new et({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyUwQSUwQWZpbGUlMjAlM0QlMjBoZl9odWJfZG93bmxvYWQoJTBBJTIwJTIwJTIwJTIwcmVwb19pZCUzRCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZldHRoMS1ob3VybHktYmF0Y2glMjIlMkMlMjBmaWxlbmFtZSUzRCUyMnRyYWluLWJhdGNoLnB0JTIyJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMiUwQSklMEFiYXRjaCUyMCUzRCUyMHRvcmNoLmxvYWQoZmlsZSklMEElMEElMjMlMjBDb25maWclMjBmb3IlMjByYW5kb20lMjBtYXNrJTIwcHJldHJhaW5pbmclMEFjb25maWclMjAlM0QlMjBQYXRjaFRTVENvbmZpZyglMEElMjAlMjAlMjAlMjBudW1faW5wdXRfY2hhbm5lbHMlM0Q3JTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dF9sZW5ndGglM0Q1MTIlMkMlMEElMjAlMjAlMjAlMjBwYXRjaF9sZW5ndGglM0QxMiUyQyUwQSUyMCUyMCUyMCUyMHN0cmlkZSUzRDEyJTJDJTBBJTIwJTIwJTIwJTIwbWFza190eXBlJTNEJ3JhbmRvbSclMkMlMEElMjAlMjAlMjAlMjByYW5kb21fbWFza19yYXRpbyUzRDAuNCUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQSUyMyUyMENvbmZpZyUyMGZvciUyMGZvcmVjYXN0JTIwbWFzayUyMHByZXRyYWluaW5nJTBBY29uZmlnJTIwJTNEJTIwUGF0Y2hUU1RDb25maWcoJTBBJTIwJTIwJTIwJTIwbnVtX2lucHV0X2NoYW5uZWxzJTNENyUyQyUwQSUyMCUyMCUyMCUyMGNvbnRleHRfbGVuZ3RoJTNENTEyJTJDJTBBJTIwJTIwJTIwJTIwcGF0Y2hfbGVuZ3RoJTNEMTIlMkMlMEElMjAlMjAlMjAlMjBzdHJpZGUlM0QxMiUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfdHlwZSUzRCdmb3JlY2FzdCclMkMlMEElMjAlMjAlMjAlMjBudW1fZm9yZWNhc3RfbWFza19wYXRjaGVzJTNENSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9jbHNfdG9rZW4lM0RUcnVlJTJDJTBBKSUwQW1vZGVsJTIwJTNEJTIwUGF0Y2hUU1RGb3JQcmV0cmFpbmluZyhjb25maWcpJTBBJTBBJTIzJTIwZHVyaW5nJTIwdHJhaW5pbmclMkMlMjBvbmUlMjBwcm92aWRlcyUyMGJvdGglMjBwYXN0JTIwYW5kJTIwZnV0dXJlJTIwdmFsdWVzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBhc3RfdmFsdWVzJTNEYmF0Y2glNUIlMjJwYXN0X3ZhbHVlcyUyMiU1RCklMEElMEFsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBbG9zcy5iYWNrd2FyZCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForPretraining

<span class="hljs-meta">&gt;&gt;&gt; </span>file = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;hf-internal-testing/etth1-hourly-batch&quot;</span>, filename=<span class="hljs-string">&quot;train-batch.pt&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = torch.load(file)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for random mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;random&#x27;</span>,
<span class="hljs-meta">... </span>    random_mask_ratio=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Config for forecast mask pretraining</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PatchTSTConfig(
<span class="hljs-meta">... </span>    num_input_channels=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>    context_length=<span class="hljs-number">512</span>,
<span class="hljs-meta">... </span>    patch_length=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    stride=<span class="hljs-number">12</span>,
<span class="hljs-meta">... </span>    mask_type=<span class="hljs-string">&#x27;forecast&#x27;</span>,
<span class="hljs-meta">... </span>    num_forecast_mask_patches=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    use_cls_token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForPretraining(config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during training, one provides both past and future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=batch[<span class="hljs-string">&quot;past_values&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span>loss.backward()`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,c=a(),h(d.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),b(s)!=="svelte-kvfsh7"&&(s.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){l(t,s,v),l(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(o(s),o(c)),_(d,t)}}}function An(w){let s,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=m("p"),s.innerHTML=y},l(c){s=p(c,"P",{"data-svelte-h":!0}),b(s)!=="svelte-fincs2"&&(s.innerHTML=y)},m(c,d){l(c,s,d)},p:te,d(c){c&&o(s)}}}function On(w){let s,y="Examples:",c,d,M;return d=new et({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBhdGNoVFNUQ29uZmlnJTJDJTIwUGF0Y2hUU1RGb3JSZWdyZXNzaW9uJTBBJTBBJTIzJTIwUmVncmVzc2lvbiUyMHRhc2slMjB3aXRoJTIwNiUyMGlucHV0JTIwY2hhbm5lbHMlMjBhbmQlMjByZWdyZXNzJTIwMiUyMHRhcmdldHMlMEFtb2RlbCUyMCUzRCUyMFBhdGNoVFNURm9yUmVncmVzc2lvbi5mcm9tX3ByZXRyYWluZWQoJTIybmFtY3RpbiUyRnBhdGNodHN0X2V0dGgxX3JlZ3Jlc3Npb24lMjIpJTBBJTBBJTIzJTIwZHVyaW5nJTIwaW5mZXJlbmNlJTJDJTIwb25lJTIwb25seSUyMHByb3ZpZGVzJTIwcGFzdCUyMHZhbHVlcyUyQyUyMHRoZSUyMG1vZGVsJTIwb3V0cHV0cyUyMGZ1dHVyZSUyMHZhbHVlcyUwQXBhc3RfdmFsdWVzJTIwJTNEJTIwdG9yY2gucmFuZG4oMjAlMkMlMjA1MTIlMkMlMjA2KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChwYXN0X3ZhbHVlcyUzRHBhc3RfdmFsdWVzKSUwQXJlZ3Jlc3Npb25fb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMucmVncmVzc2lvbl9vdXRwdXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PatchTSTConfig, PatchTSTForRegression

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Regression task with 6 input channels and regress 2 targets</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PatchTSTForRegression.from_pretrained(<span class="hljs-string">&quot;namctin/patchtst_etth1_regression&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># during inference, one only provides past values, the model outputs future values</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>past_values = torch.randn(<span class="hljs-number">20</span>, <span class="hljs-number">512</span>, <span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(past_values=past_values)
<span class="hljs-meta">&gt;&gt;&gt; </span>regression_outputs = outputs.regression_outputs`,wrap:!1}}),{c(){s=m("p"),s.textContent=y,c=a(),h(d.$$.fragment)},l(t){s=p(t,"P",{"data-svelte-h":!0}),b(s)!=="svelte-kvfsh7"&&(s.textContent=y),c=r(t),u(d.$$.fragment,t)},m(t,v){l(t,s,v),l(t,c,v),f(d,t,v),M=!0},p:te,i(t){M||(g(d.$$.fragment,t),M=!0)},o(t){T(d.$$.fragment,t),M=!1},d(t){t&&(o(s),o(c)),_(d,t)}}}function Kn(w){let s,y,c,d,M,t,v,nt,ne,cn='The PatchTST 모델은 Yuqi Nie, Nam H. Nguyen, Phanwadee Sinthong, Jayant Kalagnanam이 제안한 <a href="https://arxiv.org/abs/2211.14730" rel="nofollow">시계열 하나가 64개의 단어만큼 가치있다: 트랜스포머를 이용한 장기예측</a>라는 논문에서 소개되었습니다.',ot,oe,dn="이 모델은 고수준에서 시계열을 주어진 크기의 패치로 벡터화하고, 결과로 나온 벡터 시퀀스를 트랜스포머를 통해 인코딩한 다음 적절한 헤드를 통해 예측 길이의 예측을 출력합니다. 모델은 다음 그림과 같이 도식화됩니다:",st,se,mn='<img src="https://github.com/namctin/transformers/assets/8100/150af169-29de-419a-8d98-eb78251c21fa" alt="모델"/>',at,ae,pn="해당 논문의 초록입니다:",rt,re,hn="*우리는 다변량 시계열 예측과 자기 감독 표현 학습을 위한 효율적인 트랜스포머 기반 모델 설계를 제안합니다. 이는 두 가지 주요 구성 요소를 기반으로 합니다:",lt,le,un=`(i) 시계열을 하위 시리즈 수준의 패치로 분할하여 트랜스포머의 입력 토큰으로 사용
(ii) 각 채널이 모든 시리즈에 걸쳐 동일한 임베딩과 트랜스포머 가중치를 공유하는 단일 단변량 시계열을 포함하는 채널 독립성. 패칭 설계는 자연스럽게 세 가지 이점을 가집니다:`,it,ie,fn=`<li>지역적 의미 정보가 임베딩에 유지됩니다;</li> <li>동일한 룩백 윈도우에 대해 어텐션 맵의 계산과 메모리 사용량이 제곱으로 감소합니다</li> <li>모델이 더 긴 과거를 참조할 수 있습니다.
우리의 채널 독립적 패치 시계열 트랜스포머(PatchTST)는 최신 트랜스포머 기반 모델들과 비교했을 때 장기 예측 정확도를 크게 향상시킬 수 있습니다. 또한 모델을 자기지도 사전 훈련 작업에 적용하여, 대규모 데이터셋에 대한 지도 학습을 능가하는 아주 뛰어난 미세 조정 성능을 달성했습니다. 한 데이터셋에서 마스크된 사전 훈련 표현을 다른 데이터셋으로 전이하는 것도 최고 수준의 예측 정확도(SOTA)를 산출했습니다.*</li>`,ct,ce,gn='이 모델은 <a href="https://huggingface.co/namctin" rel="nofollow">namctin</a>, <a href="https://huggingface.co/gsinthong" rel="nofollow">gsinthong</a>, <a href="https://huggingface.co/diepi" rel="nofollow">diepi</a>, <a href="https://huggingface.co/vijaye12" rel="nofollow">vijaye12</a>, <a href="https://huggingface.co/wmgifford" rel="nofollow">wmgifford</a>, <a href="https://huggingface.co/kashif" rel="nofollow">kashif</a>에 의해 기여 되었습니다. 원본코드는 <a href="https://github.com/yuqinie98/PatchTST" rel="nofollow">이곳</a>에서 확인할 수 있습니다.',dt,de,mt,me,Tn='이 모델은 시계열 분류와 시계열 회귀에도 사용될 수 있습니다. 각각 <a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTForClassification">PatchTSTForClassification</a>와 <a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTForRegression">PatchTSTForRegression</a> 클래스를 참조하세요.',pt,pe,ht,he,_n=`<li>PatchTST를 자세히 설명하는 블로그 포스트는 <a href="https://huggingface.co/blog/patchtst" rel="nofollow">이곳</a>에서 찾을 수 있습니다.
이 블로그는 Google Colab에서도 열어볼 수 있습니다.</li>`,ut,ue,ft,U,fe,St,Be,bn=`This is the configuration class to store the configuration of an <a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTModel">PatchTSTModel</a>. It is used to instantiate an
PatchTST model according to the specified arguments, defining the model architecture.
<a href="https://huggingface.co/ibm/patchtst" rel="nofollow">ibm/patchtst</a> architecture.`,kt,Ze,Mn=`Configuration objects inherit from <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/ko/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,xt,z,gt,ge,Tt,$,Te,Ft,We,yn="The bare Patchtst Model outputting raw hidden-states without any specific head on top.",Bt,Ge,vn=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Zt,Ne,wn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Wt,Y,_e,Gt,X,_t,be,bt,j,Me,Nt,Re,$n="The PatchTST for prediction model.",Rt,Ie,jn=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,It,He,Pn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ht,E,ye,Vt,q,Mt,ve,yt,P,we,zt,Ve,Cn="The PatchTST for classification model.",Yt,ze,Jn=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xt,Ye,Un=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Et,W,$e,qt,Xe,Sn='The <a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTForClassification">PatchTSTForClassification</a> forward method, overrides the <code>__call__</code> special method.',Qt,Q,Dt,D,vt,je,wt,C,Pe,Lt,Ee,kn="The PatchTST for pretrain model.",At,qe,xn=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ot,Qe,Fn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Kt,L,Ce,en,A,$t,Je,jt,J,Ue,tn,De,Bn="The PatchTST for regression model.",nn,Le,Zn=`This model inherits from <a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,on,Ae,Wn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,sn,G,Se,an,Oe,Gn='The <a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTForRegression">PatchTSTForRegression</a> forward method, overrides the <code>__call__</code> special method.',rn,O,ln,K,Pt,ke,Ct,tt,Jt;return M=new V({props:{title:"PatchTST",local:"patchtst",headingTag:"h1"}}),v=new V({props:{title:"개요",local:"overview",headingTag:"h2"}}),de=new V({props:{title:"사용 팁",local:"usage-tips",headingTag:"h2"}}),pe=new V({props:{title:"자료",local:"resources",headingTag:"h2"}}),ue=new V({props:{title:"PatchTSTConfig",local:"transformers.PatchTSTConfig ][ transformers.PatchTSTConfig",headingTag:"h2"}}),fe=new I({props:{name:"class transformers.PatchTSTConfig",anchor:"transformers.PatchTSTConfig",parameters:[{name:"num_input_channels",val:": int = 1"},{name:"context_length",val:": int = 32"},{name:"distribution_output",val:": str = 'student_t'"},{name:"loss",val:": str = 'mse'"},{name:"patch_length",val:": int = 1"},{name:"patch_stride",val:": int = 1"},{name:"num_hidden_layers",val:": int = 3"},{name:"d_model",val:": int = 128"},{name:"num_attention_heads",val:": int = 4"},{name:"share_embedding",val:": bool = True"},{name:"channel_attention",val:": bool = False"},{name:"ffn_dim",val:": int = 512"},{name:"norm_type",val:": str = 'batchnorm'"},{name:"norm_eps",val:": float = 1e-05"},{name:"attention_dropout",val:": float = 0.0"},{name:"positional_dropout",val:": float = 0.0"},{name:"path_dropout",val:": float = 0.0"},{name:"ff_dropout",val:": float = 0.0"},{name:"bias",val:": bool = True"},{name:"activation_function",val:": str = 'gelu'"},{name:"pre_norm",val:": bool = True"},{name:"positional_encoding_type",val:": str = 'sincos'"},{name:"use_cls_token",val:": bool = False"},{name:"init_std",val:": float = 0.02"},{name:"share_projection",val:": bool = True"},{name:"scaling",val:": typing.Union[str, bool, NoneType] = 'std'"},{name:"do_mask_input",val:": typing.Optional[bool] = None"},{name:"mask_type",val:": str = 'random'"},{name:"random_mask_ratio",val:": float = 0.5"},{name:"num_forecast_mask_patches",val:": typing.Union[typing.List[int], int, NoneType] = [2]"},{name:"channel_consistent_masking",val:": typing.Optional[bool] = False"},{name:"unmasked_channel_indices",val:": typing.Optional[typing.List[int]] = None"},{name:"mask_value",val:": int = 0"},{name:"pooling_type",val:": str = 'mean'"},{name:"head_dropout",val:": float = 0.0"},{name:"prediction_length",val:": int = 24"},{name:"num_targets",val:": int = 1"},{name:"output_range",val:": typing.Optional[typing.List] = None"},{name:"num_parallel_samples",val:": int = 100"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PatchTSTConfig.num_input_channels",description:`<strong>num_input_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the target variable which by default is 1 for univariate targets. Would be &gt; 1 in case of
multivariate targets.`,name:"num_input_channels"},{anchor:"transformers.PatchTSTConfig.context_length",description:`<strong>context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
The context length of the input sequence.`,name:"context_length"},{anchor:"transformers.PatchTSTConfig.distribution_output",description:`<strong>distribution_output</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;student_t&quot;</code>) &#x2014;
The distribution emission head for the model when loss is &#x201C;nll&#x201D;. Could be either &#x201C;student_t&#x201D;, &#x201C;normal&#x201D; or
&#x201C;negative_binomial&#x201D;.`,name:"distribution_output"},{anchor:"transformers.PatchTSTConfig.loss",description:`<strong>loss</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mse&quot;</code>) &#x2014;
The loss function for the model corresponding to the <code>distribution_output</code> head. For parametric
distributions it is the negative log likelihood (&#x201C;nll&#x201D;) and for point estimates it is the mean squared
error &#x201C;mse&#x201D;.`,name:"loss"},{anchor:"transformers.PatchTSTConfig.patch_length",description:`<strong>patch_length</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the patch length of the patchification process.`,name:"patch_length"},{anchor:"transformers.PatchTSTConfig.patch_stride",description:`<strong>patch_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Define the stride of the patchification process.`,name:"patch_stride"},{anchor:"transformers.PatchTSTConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of hidden layers.`,name:"num_hidden_layers"},{anchor:"transformers.PatchTSTConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
Dimensionality of the transformer layers.`,name:"d_model"},{anchor:"transformers.PatchTSTConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.PatchTSTConfig.share_embedding",description:`<strong>share_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the input embedding across all channels.`,name:"share_embedding"},{anchor:"transformers.PatchTSTConfig.channel_attention",description:`<strong>channel_attention</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activate channel attention block in the Transformer to allow channels to attend each other.`,name:"channel_attention"},{anchor:"transformers.PatchTSTConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer encoder.`,name:"ffn_dim"},{anchor:"transformers.PatchTSTConfig.norm_type",description:`<strong>norm_type</strong> (<code>str</code> , <em>optional</em>, defaults to <code>&quot;batchnorm&quot;</code>) &#x2014;
Normalization at each Transformer layer. Can be <code>&quot;batchnorm&quot;</code> or <code>&quot;layernorm&quot;</code>.`,name:"norm_type"},{anchor:"transformers.PatchTSTConfig.norm_eps",description:`<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
A value added to the denominator for numerical stability of normalization.`,name:"norm_eps"},{anchor:"transformers.PatchTSTConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.PatchTSTConfig.positional_dropout",description:`<strong>positional_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability in the positional embedding layer.`,name:"positional_dropout"},{anchor:"transformers.PatchTSTConfig.path_dropout",description:`<strong>path_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout path in the residual block.`,name:"path_dropout"},{anchor:"transformers.PatchTSTConfig.ff_dropout",description:`<strong>ff_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability used between the two layers of the feed-forward networks.`,name:"ff_dropout"},{anchor:"transformers.PatchTSTConfig.bias",description:`<strong>bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add bias in the feed-forward networks.`,name:"bias"},{anchor:"transformers.PatchTSTConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (string) in the Transformer.<code>&quot;gelu&quot;</code> and <code>&quot;relu&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.PatchTSTConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Normalization is applied before self-attention if pre_norm is set to <code>True</code>. Otherwise, normalization is
applied after residual block.`,name:"pre_norm"},{anchor:"transformers.PatchTSTConfig.positional_encoding_type",description:`<strong>positional_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sincos&quot;</code>) &#x2014;
Positional encodings. Options <code>&quot;random&quot;</code> and <code>&quot;sincos&quot;</code> are supported.`,name:"positional_encoding_type"},{anchor:"transformers.PatchTSTConfig.use_cls_token",description:`<strong>use_cls_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether cls token is used.`,name:"use_cls_token"},{anchor:"transformers.PatchTSTConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated normal weight initialization distribution.`,name:"init_std"},{anchor:"transformers.PatchTSTConfig.share_projection",description:`<strong>share_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Sharing the projection layer across different channels in the forecast head.`,name:"share_projection"},{anchor:"transformers.PatchTSTConfig.scaling",description:`<strong>scaling</strong> (<code>Union</code>, <em>optional</em>, defaults to <code>&quot;std&quot;</code>) &#x2014;
Whether to scale the input targets via &#x201C;mean&#x201D; scaler, &#x201C;std&#x201D; scaler or no scaler if <code>None</code>. If <code>True</code>, the
scaler is set to &#x201C;mean&#x201D;.`,name:"scaling"},{anchor:"transformers.PatchTSTConfig.do_mask_input",description:`<strong>do_mask_input</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Apply masking during the pretraining.`,name:"do_mask_input"},{anchor:"transformers.PatchTSTConfig.mask_type",description:`<strong>mask_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;random&quot;</code>) &#x2014;
Masking type. Only <code>&quot;random&quot;</code> and <code>&quot;forecast&quot;</code> are currently supported.`,name:"mask_type"},{anchor:"transformers.PatchTSTConfig.random_mask_ratio",description:`<strong>random_mask_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Masking ratio applied to mask the input data during random pretraining.`,name:"random_mask_ratio"},{anchor:"transformers.PatchTSTConfig.num_forecast_mask_patches",description:`<strong>num_forecast_mask_patches</strong> (<code>int</code> or <code>list</code>, <em>optional</em>, defaults to <code>[2]</code>) &#x2014;
Number of patches to be masked at the end of each batch sample. If it is an integer,
all the samples in the batch will have the same number of masked patches. If it is a list,
samples in the batch will be randomly masked by numbers defined in the list. This argument is only used
for forecast pretraining.`,name:"num_forecast_mask_patches"},{anchor:"transformers.PatchTSTConfig.channel_consistent_masking",description:`<strong>channel_consistent_masking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If channel consistent masking is True, all the channels will have the same masking pattern.`,name:"channel_consistent_masking"},{anchor:"transformers.PatchTSTConfig.unmasked_channel_indices",description:`<strong>unmasked_channel_indices</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Indices of channels that are not masked during pretraining. Values in the list are number between 1 and
<code>num_input_channels</code>`,name:"unmasked_channel_indices"},{anchor:"transformers.PatchTSTConfig.mask_value",description:`<strong>mask_value</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Values in the masked patches will be filled by <code>mask_value</code>.`,name:"mask_value"},{anchor:"transformers.PatchTSTConfig.pooling_type",description:`<strong>pooling_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;mean&quot;</code>) &#x2014;
Pooling of the embedding. <code>&quot;mean&quot;</code>, <code>&quot;max&quot;</code> and <code>None</code> are supported.`,name:"pooling_type"},{anchor:"transformers.PatchTSTConfig.head_dropout",description:`<strong>head_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for head.`,name:"head_dropout"},{anchor:"transformers.PatchTSTConfig.prediction_length",description:`<strong>prediction_length</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
The prediction horizon that the model will output.`,name:"prediction_length"},{anchor:"transformers.PatchTSTConfig.num_targets",description:`<strong>num_targets</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of targets for regression and classification tasks. For classification, it is the number of
classes.`,name:"num_targets"},{anchor:"transformers.PatchTSTConfig.output_range",description:`<strong>output_range</strong> (<code>list</code>, <em>optional</em>) &#x2014;
Output range for regression task. The range of output values can be set to enforce the model to produce
values within a range.`,name:"output_range"},{anchor:"transformers.PatchTSTConfig.num_parallel_samples",description:`<strong>num_parallel_samples</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of samples is generated in parallel for probabilistic prediction.`,name:"num_parallel_samples"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/configuration_patchtst.py#L26"}}),z=new Ke({props:{anchor:"transformers.PatchTSTConfig.example",$$slots:{default:[Xn]},$$scope:{ctx:w}}}),ge=new V({props:{title:"PatchTSTModel",local:"transformers.PatchTSTModel ][ transformers.PatchTSTModel",headingTag:"h2"}}),Te=new I({props:{name:"class transformers.PatchTSTModel",anchor:"transformers.PatchTSTModel",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1122"}}),_e=new I({props:{name:"forward",anchor:"transformers.PatchTSTModel.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"future_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTModel.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTModel.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTModel.forward.future_values",description:`<strong>future_values</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, prediction_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1142",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTModelOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or <code>config.return_dict</code>=False)</p>
`}}),X=new Ke({props:{anchor:"transformers.PatchTSTModel.forward.example",$$slots:{default:[En]},$$scope:{ctx:w}}}),be=new V({props:{title:"PatchTSTForPrediction",local:"transformers.PatchTSTForPrediction ][ transformers.PatchTSTForPrediction",headingTag:"h2"}}),Me=new I({props:{name:"class transformers.PatchTSTForPrediction",anchor:"transformers.PatchTSTForPrediction",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1609"}}),ye=new I({props:{name:"forward",anchor:"transformers.PatchTSTForPrediction.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"future_values",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPrediction.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPrediction.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPrediction.forward.future_values",description:`<strong>future_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, forecast_len, num_input_channels)</code>, <em>optional</em>) &#x2014;
Future target values associated with the <code>past_values</code>`,name:"future_values"},{anchor:"transformers.PatchTSTForPrediction.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPrediction.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPrediction.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1644",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPredictionOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),q=new Ke({props:{anchor:"transformers.PatchTSTForPrediction.forward.example",$$slots:{default:[qn]},$$scope:{ctx:w}}}),ve=new V({props:{title:"PatchTSTForClassification",local:"transformers.PatchTSTForClassification ][ transformers.PatchTSTForClassification",headingTag:"h2"}}),we=new I({props:{name:"class transformers.PatchTSTForClassification",anchor:"transformers.PatchTSTForClassification",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1416"}}),$e=new I({props:{name:"forward",anchor:"transformers.PatchTSTForClassification.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": typing.Optional[torch.Tensor] = None"},{name:"past_observed_mask",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForClassification.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForClassification.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Labels associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForClassification.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>bool</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PatchTSTForClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1436",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.patchtst.modeling_patchtst.PatchTSTForClassificationOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTConfig"
>PatchTSTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — Total loss as the sum of the masked language modeling loss and the next sequence prediction
(classification) loss.</p>
</li>
<li>
<p><strong>prediction_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_targets)</code>) — Prediction scores of the PatchTST modeling head (scores before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.patchtst.modeling_patchtst.PatchTSTForClassificationOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Nn({props:{$$slots:{default:[Qn]},$$scope:{ctx:w}}}),D=new Ke({props:{anchor:"transformers.PatchTSTForClassification.forward.example",$$slots:{default:[Dn]},$$scope:{ctx:w}}}),je=new V({props:{title:"PatchTSTForPretraining",local:"transformers.PatchTSTForPretraining ][ transformers.PatchTSTForPretraining",headingTag:"h2"}}),Pe=new I({props:{name:"class transformers.PatchTSTForPretraining",anchor:"transformers.PatchTSTForPretraining",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1263"}}),Ce=new I({props:{name:"forward",anchor:"transformers.PatchTSTForPretraining.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForPretraining.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForPretraining.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForPretraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForPretraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the output attention of all layers`,name:"output_attentions"},{anchor:"transformers.PatchTSTForPretraining.forward.return_dict",description:"<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.",name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1279",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>PatchTSTForPretrainingOutput</code> or tuple of <code>torch.Tensor</code> (if <code>return_dict</code>=False or
<code>config.return_dict</code>=False)</p>
`}}),A=new Ke({props:{anchor:"transformers.PatchTSTForPretraining.forward.example",$$slots:{default:[Ln]},$$scope:{ctx:w}}}),Je=new V({props:{title:"PatchTSTForRegression",local:"transformers.PatchTSTForRegression ][ transformers.PatchTSTForRegression",headingTag:"h2"}}),Ue=new I({props:{name:"class transformers.PatchTSTForRegression",anchor:"transformers.PatchTSTForRegression",parameters:[{name:"config",val:": PatchTSTConfig"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTConfig">PatchTSTConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/ko/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1856"}}),Se=new I({props:{name:"forward",anchor:"transformers.PatchTSTForRegression.forward",parameters:[{name:"past_values",val:": Tensor"},{name:"target_values",val:": typing.Optional[torch.Tensor] = None"},{name:"past_observed_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PatchTSTForRegression.forward.past_values",description:`<strong>past_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, sequence_length, num_input_channels)</code>, <em>required</em>) &#x2014;
Input sequence to the model`,name:"past_values"},{anchor:"transformers.PatchTSTForRegression.forward.target_values",description:`<strong>target_values</strong> (<code>torch.Tensor</code> of shape <code>(bs, num_input_channels)</code>) &#x2014;
Target values associates with the <code>past_values</code>`,name:"target_values"},{anchor:"transformers.PatchTSTForRegression.forward.past_observed_mask",description:`<strong>past_observed_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, num_input_channels)</code>, <em>optional</em>) &#x2014;
Boolean mask to indicate which <code>past_values</code> were observed and which were missing. Mask values selected
in <code>[0, 1]</code>:</p>
<ul>
<li>1 for values that are <strong>observed</strong>,</li>
<li>0 for values that are <strong>missing</strong> (i.e. NaNs that were replaced by zeros).
Whether or not to return a <code>ModelOutput</code> instead of a plain tuple.</li>
</ul>`,name:"past_observed_mask"},{anchor:"transformers.PatchTSTForRegression.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PatchTSTForRegression.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PatchTSTForRegression.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/ko/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/patchtst/modeling_patchtst.py#L1888",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.patchtst.modeling_patchtst.PatchTSTForRegressionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/ko/model_doc/patchtst#transformers.PatchTSTConfig"
>PatchTSTConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<em>optional</em>, returned when <code>labels</code> is provided, <code>torch.FloatTensor</code> of shape <code>(1,)</code>) — MSE loss.</p>
</li>
<li>
<p><strong>regression_outputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_targets)</code>) — Regression outputs of the time series modeling heads.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.patchtst.modeling_patchtst.PatchTSTForRegressionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Nn({props:{$$slots:{default:[An]},$$scope:{ctx:w}}}),K=new Ke({props:{anchor:"transformers.PatchTSTForRegression.forward.example",$$slots:{default:[On]},$$scope:{ctx:w}}}),ke=new Yn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/ko/model_doc/patchtst.md"}}),{c(){s=m("meta"),y=a(),c=m("p"),d=a(),h(M.$$.fragment),t=a(),h(v.$$.fragment),nt=a(),ne=m("p"),ne.innerHTML=cn,ot=a(),oe=m("p"),oe.textContent=dn,st=a(),se=m("p"),se.innerHTML=mn,at=a(),ae=m("p"),ae.textContent=pn,rt=a(),re=m("p"),re.textContent=hn,lt=a(),le=m("p"),le.textContent=un,it=a(),ie=m("ul"),ie.innerHTML=fn,ct=a(),ce=m("p"),ce.innerHTML=gn,dt=a(),h(de.$$.fragment),mt=a(),me=m("p"),me.innerHTML=Tn,pt=a(),h(pe.$$.fragment),ht=a(),he=m("ul"),he.innerHTML=_n,ut=a(),h(ue.$$.fragment),ft=a(),U=m("div"),h(fe.$$.fragment),St=a(),Be=m("p"),Be.innerHTML=bn,kt=a(),Ze=m("p"),Ze.innerHTML=Mn,xt=a(),h(z.$$.fragment),gt=a(),h(ge.$$.fragment),Tt=a(),$=m("div"),h(Te.$$.fragment),Ft=a(),We=m("p"),We.textContent=yn,Bt=a(),Ge=m("p"),Ge.innerHTML=vn,Zt=a(),Ne=m("p"),Ne.innerHTML=wn,Wt=a(),Y=m("div"),h(_e.$$.fragment),Gt=a(),h(X.$$.fragment),_t=a(),h(be.$$.fragment),bt=a(),j=m("div"),h(Me.$$.fragment),Nt=a(),Re=m("p"),Re.textContent=$n,Rt=a(),Ie=m("p"),Ie.innerHTML=jn,It=a(),He=m("p"),He.innerHTML=Pn,Ht=a(),E=m("div"),h(ye.$$.fragment),Vt=a(),h(q.$$.fragment),Mt=a(),h(ve.$$.fragment),yt=a(),P=m("div"),h(we.$$.fragment),zt=a(),Ve=m("p"),Ve.textContent=Cn,Yt=a(),ze=m("p"),ze.innerHTML=Jn,Xt=a(),Ye=m("p"),Ye.innerHTML=Un,Et=a(),W=m("div"),h($e.$$.fragment),qt=a(),Xe=m("p"),Xe.innerHTML=Sn,Qt=a(),h(Q.$$.fragment),Dt=a(),h(D.$$.fragment),vt=a(),h(je.$$.fragment),wt=a(),C=m("div"),h(Pe.$$.fragment),Lt=a(),Ee=m("p"),Ee.textContent=kn,At=a(),qe=m("p"),qe.innerHTML=xn,Ot=a(),Qe=m("p"),Qe.innerHTML=Fn,Kt=a(),L=m("div"),h(Ce.$$.fragment),en=a(),h(A.$$.fragment),$t=a(),h(Je.$$.fragment),jt=a(),J=m("div"),h(Ue.$$.fragment),tn=a(),De=m("p"),De.textContent=Bn,nn=a(),Le=m("p"),Le.innerHTML=Zn,on=a(),Ae=m("p"),Ae.innerHTML=Wn,sn=a(),G=m("div"),h(Se.$$.fragment),an=a(),Oe=m("p"),Oe.innerHTML=Gn,rn=a(),h(O.$$.fragment),ln=a(),h(K.$$.fragment),Pt=a(),h(ke.$$.fragment),Ct=a(),tt=m("p"),this.h()},l(e){const n=zn("svelte-u9bgzb",document.head);s=p(n,"META",{name:!0,content:!0}),n.forEach(o),y=r(e),c=p(e,"P",{}),B(c).forEach(o),d=r(e),u(M.$$.fragment,e),t=r(e),u(v.$$.fragment,e),nt=r(e),ne=p(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-1k94mbg"&&(ne.innerHTML=cn),ot=r(e),oe=p(e,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-1a0dj83"&&(oe.textContent=dn),st=r(e),se=p(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-6kdhwe"&&(se.innerHTML=mn),at=r(e),ae=p(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-un5jih"&&(ae.textContent=pn),rt=r(e),re=p(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-1qh9o13"&&(re.textContent=hn),lt=r(e),le=p(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-18tqhas"&&(le.textContent=un),it=r(e),ie=p(e,"UL",{"data-svelte-h":!0}),b(ie)!=="svelte-1he0q4c"&&(ie.innerHTML=fn),ct=r(e),ce=p(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1af4dy"&&(ce.innerHTML=gn),dt=r(e),u(de.$$.fragment,e),mt=r(e),me=p(e,"P",{"data-svelte-h":!0}),b(me)!=="svelte-1oqjnwo"&&(me.innerHTML=Tn),pt=r(e),u(pe.$$.fragment,e),ht=r(e),he=p(e,"UL",{"data-svelte-h":!0}),b(he)!=="svelte-1gubcxz"&&(he.innerHTML=_n),ut=r(e),u(ue.$$.fragment,e),ft=r(e),U=p(e,"DIV",{class:!0});var N=B(U);u(fe.$$.fragment,N),St=r(N),Be=p(N,"P",{"data-svelte-h":!0}),b(Be)!=="svelte-1qf9bwc"&&(Be.innerHTML=bn),kt=r(N),Ze=p(N,"P",{"data-svelte-h":!0}),b(Ze)!=="svelte-vtbbmk"&&(Ze.innerHTML=Mn),xt=r(N),u(z.$$.fragment,N),N.forEach(o),gt=r(e),u(ge.$$.fragment,e),Tt=r(e),$=p(e,"DIV",{class:!0});var S=B($);u(Te.$$.fragment,S),Ft=r(S),We=p(S,"P",{"data-svelte-h":!0}),b(We)!=="svelte-125jl3x"&&(We.textContent=yn),Bt=r(S),Ge=p(S,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-u3dlub"&&(Ge.innerHTML=vn),Zt=r(S),Ne=p(S,"P",{"data-svelte-h":!0}),b(Ne)!=="svelte-hswkmf"&&(Ne.innerHTML=wn),Wt=r(S),Y=p(S,"DIV",{class:!0});var xe=B(Y);u(_e.$$.fragment,xe),Gt=r(xe),u(X.$$.fragment,xe),xe.forEach(o),S.forEach(o),_t=r(e),u(be.$$.fragment,e),bt=r(e),j=p(e,"DIV",{class:!0});var k=B(j);u(Me.$$.fragment,k),Nt=r(k),Re=p(k,"P",{"data-svelte-h":!0}),b(Re)!=="svelte-12vsmyb"&&(Re.textContent=$n),Rt=r(k),Ie=p(k,"P",{"data-svelte-h":!0}),b(Ie)!=="svelte-u3dlub"&&(Ie.innerHTML=jn),It=r(k),He=p(k,"P",{"data-svelte-h":!0}),b(He)!=="svelte-hswkmf"&&(He.innerHTML=Pn),Ht=r(k),E=p(k,"DIV",{class:!0});var Fe=B(E);u(ye.$$.fragment,Fe),Vt=r(Fe),u(q.$$.fragment,Fe),Fe.forEach(o),k.forEach(o),Mt=r(e),u(ve.$$.fragment,e),yt=r(e),P=p(e,"DIV",{class:!0});var x=B(P);u(we.$$.fragment,x),zt=r(x),Ve=p(x,"P",{"data-svelte-h":!0}),b(Ve)!=="svelte-1yav0vu"&&(Ve.textContent=Cn),Yt=r(x),ze=p(x,"P",{"data-svelte-h":!0}),b(ze)!=="svelte-u3dlub"&&(ze.innerHTML=Jn),Xt=r(x),Ye=p(x,"P",{"data-svelte-h":!0}),b(Ye)!=="svelte-hswkmf"&&(Ye.innerHTML=Un),Et=r(x),W=p(x,"DIV",{class:!0});var R=B(W);u($e.$$.fragment,R),qt=r(R),Xe=p(R,"P",{"data-svelte-h":!0}),b(Xe)!=="svelte-69fv99"&&(Xe.innerHTML=Sn),Qt=r(R),u(Q.$$.fragment,R),Dt=r(R),u(D.$$.fragment,R),R.forEach(o),x.forEach(o),vt=r(e),u(je.$$.fragment,e),wt=r(e),C=p(e,"DIV",{class:!0});var F=B(C);u(Pe.$$.fragment,F),Lt=r(F),Ee=p(F,"P",{"data-svelte-h":!0}),b(Ee)!=="svelte-ruyd93"&&(Ee.textContent=kn),At=r(F),qe=p(F,"P",{"data-svelte-h":!0}),b(qe)!=="svelte-u3dlub"&&(qe.innerHTML=xn),Ot=r(F),Qe=p(F,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-hswkmf"&&(Qe.innerHTML=Fn),Kt=r(F),L=p(F,"DIV",{class:!0});var Ut=B(L);u(Ce.$$.fragment,Ut),en=r(Ut),u(A.$$.fragment,Ut),Ut.forEach(o),F.forEach(o),$t=r(e),u(Je.$$.fragment,e),jt=r(e),J=p(e,"DIV",{class:!0});var H=B(J);u(Ue.$$.fragment,H),tn=r(H),De=p(H,"P",{"data-svelte-h":!0}),b(De)!=="svelte-1u8tt8v"&&(De.textContent=Bn),nn=r(H),Le=p(H,"P",{"data-svelte-h":!0}),b(Le)!=="svelte-u3dlub"&&(Le.innerHTML=Zn),on=r(H),Ae=p(H,"P",{"data-svelte-h":!0}),b(Ae)!=="svelte-hswkmf"&&(Ae.innerHTML=Wn),sn=r(H),G=p(H,"DIV",{class:!0});var ee=B(G);u(Se.$$.fragment,ee),an=r(ee),Oe=p(ee,"P",{"data-svelte-h":!0}),b(Oe)!=="svelte-1abkd21"&&(Oe.innerHTML=Gn),rn=r(ee),u(O.$$.fragment,ee),ln=r(ee),u(K.$$.fragment,ee),ee.forEach(o),H.forEach(o),Pt=r(e),u(ke.$$.fragment,e),Ct=r(e),tt=p(e,"P",{}),B(tt).forEach(o),this.h()},h(){Z(s,"name","hf:doc:metadata"),Z(s,"content",eo),Z(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),Z(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){i(document.head,s),l(e,y,n),l(e,c,n),l(e,d,n),f(M,e,n),l(e,t,n),f(v,e,n),l(e,nt,n),l(e,ne,n),l(e,ot,n),l(e,oe,n),l(e,st,n),l(e,se,n),l(e,at,n),l(e,ae,n),l(e,rt,n),l(e,re,n),l(e,lt,n),l(e,le,n),l(e,it,n),l(e,ie,n),l(e,ct,n),l(e,ce,n),l(e,dt,n),f(de,e,n),l(e,mt,n),l(e,me,n),l(e,pt,n),f(pe,e,n),l(e,ht,n),l(e,he,n),l(e,ut,n),f(ue,e,n),l(e,ft,n),l(e,U,n),f(fe,U,null),i(U,St),i(U,Be),i(U,kt),i(U,Ze),i(U,xt),f(z,U,null),l(e,gt,n),f(ge,e,n),l(e,Tt,n),l(e,$,n),f(Te,$,null),i($,Ft),i($,We),i($,Bt),i($,Ge),i($,Zt),i($,Ne),i($,Wt),i($,Y),f(_e,Y,null),i(Y,Gt),f(X,Y,null),l(e,_t,n),f(be,e,n),l(e,bt,n),l(e,j,n),f(Me,j,null),i(j,Nt),i(j,Re),i(j,Rt),i(j,Ie),i(j,It),i(j,He),i(j,Ht),i(j,E),f(ye,E,null),i(E,Vt),f(q,E,null),l(e,Mt,n),f(ve,e,n),l(e,yt,n),l(e,P,n),f(we,P,null),i(P,zt),i(P,Ve),i(P,Yt),i(P,ze),i(P,Xt),i(P,Ye),i(P,Et),i(P,W),f($e,W,null),i(W,qt),i(W,Xe),i(W,Qt),f(Q,W,null),i(W,Dt),f(D,W,null),l(e,vt,n),f(je,e,n),l(e,wt,n),l(e,C,n),f(Pe,C,null),i(C,Lt),i(C,Ee),i(C,At),i(C,qe),i(C,Ot),i(C,Qe),i(C,Kt),i(C,L),f(Ce,L,null),i(L,en),f(A,L,null),l(e,$t,n),f(Je,e,n),l(e,jt,n),l(e,J,n),f(Ue,J,null),i(J,tn),i(J,De),i(J,nn),i(J,Le),i(J,on),i(J,Ae),i(J,sn),i(J,G),f(Se,G,null),i(G,an),i(G,Oe),i(G,rn),f(O,G,null),i(G,ln),f(K,G,null),l(e,Pt,n),f(ke,e,n),l(e,Ct,n),l(e,tt,n),Jt=!0},p(e,[n]){const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),z.$set(N);const S={};n&2&&(S.$$scope={dirty:n,ctx:e}),X.$set(S);const xe={};n&2&&(xe.$$scope={dirty:n,ctx:e}),q.$set(xe);const k={};n&2&&(k.$$scope={dirty:n,ctx:e}),Q.$set(k);const Fe={};n&2&&(Fe.$$scope={dirty:n,ctx:e}),D.$set(Fe);const x={};n&2&&(x.$$scope={dirty:n,ctx:e}),A.$set(x);const R={};n&2&&(R.$$scope={dirty:n,ctx:e}),O.$set(R);const F={};n&2&&(F.$$scope={dirty:n,ctx:e}),K.$set(F)},i(e){Jt||(g(M.$$.fragment,e),g(v.$$.fragment,e),g(de.$$.fragment,e),g(pe.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(z.$$.fragment,e),g(ge.$$.fragment,e),g(Te.$$.fragment,e),g(_e.$$.fragment,e),g(X.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(ye.$$.fragment,e),g(q.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g($e.$$.fragment,e),g(Q.$$.fragment,e),g(D.$$.fragment,e),g(je.$$.fragment,e),g(Pe.$$.fragment,e),g(Ce.$$.fragment,e),g(A.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(Se.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(ke.$$.fragment,e),Jt=!0)},o(e){T(M.$$.fragment,e),T(v.$$.fragment,e),T(de.$$.fragment,e),T(pe.$$.fragment,e),T(ue.$$.fragment,e),T(fe.$$.fragment,e),T(z.$$.fragment,e),T(ge.$$.fragment,e),T(Te.$$.fragment,e),T(_e.$$.fragment,e),T(X.$$.fragment,e),T(be.$$.fragment,e),T(Me.$$.fragment,e),T(ye.$$.fragment,e),T(q.$$.fragment,e),T(ve.$$.fragment,e),T(we.$$.fragment,e),T($e.$$.fragment,e),T(Q.$$.fragment,e),T(D.$$.fragment,e),T(je.$$.fragment,e),T(Pe.$$.fragment,e),T(Ce.$$.fragment,e),T(A.$$.fragment,e),T(Je.$$.fragment,e),T(Ue.$$.fragment,e),T(Se.$$.fragment,e),T(O.$$.fragment,e),T(K.$$.fragment,e),T(ke.$$.fragment,e),Jt=!1},d(e){e&&(o(y),o(c),o(d),o(t),o(nt),o(ne),o(ot),o(oe),o(st),o(se),o(at),o(ae),o(rt),o(re),o(lt),o(le),o(it),o(ie),o(ct),o(ce),o(dt),o(mt),o(me),o(pt),o(ht),o(he),o(ut),o(ft),o(U),o(gt),o(Tt),o($),o(_t),o(bt),o(j),o(Mt),o(yt),o(P),o(vt),o(wt),o(C),o($t),o(jt),o(J),o(Pt),o(Ct),o(tt)),o(s),_(M,e),_(v,e),_(de,e),_(pe,e),_(ue,e),_(fe),_(z),_(ge,e),_(Te),_(_e),_(X),_(be,e),_(Me),_(ye),_(q),_(ve,e),_(we),_($e),_(Q),_(D),_(je,e),_(Pe),_(Ce),_(A),_(Je,e),_(Ue),_(Se),_(O),_(K),_(ke,e)}}}const eo='{"title":"PatchTST","local":"patchtst","sections":[{"title":"개요","local":"overview","sections":[],"depth":2},{"title":"사용 팁","local":"usage-tips","sections":[],"depth":2},{"title":"자료","local":"resources","sections":[],"depth":2},{"title":"PatchTSTConfig","local":"transformers.PatchTSTConfig ][ transformers.PatchTSTConfig","sections":[],"depth":2},{"title":"PatchTSTModel","local":"transformers.PatchTSTModel ][ transformers.PatchTSTModel","sections":[],"depth":2},{"title":"PatchTSTForPrediction","local":"transformers.PatchTSTForPrediction ][ transformers.PatchTSTForPrediction","sections":[],"depth":2},{"title":"PatchTSTForClassification","local":"transformers.PatchTSTForClassification ][ transformers.PatchTSTForClassification","sections":[],"depth":2},{"title":"PatchTSTForPretraining","local":"transformers.PatchTSTForPretraining ][ transformers.PatchTSTForPretraining","sections":[],"depth":2},{"title":"PatchTSTForRegression","local":"transformers.PatchTSTForRegression ][ transformers.PatchTSTForRegression","sections":[],"depth":2}],"depth":1}';function to(w){return In(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class co extends Hn{constructor(s){super(),Vn(this,s,to,Kn,Rn,{})}}export{co as component};
