import{s as dl,o as yl,n as fs}from"../chunks/scheduler.9bc65507.js";import{S as gl,i as wl,g as i,s as a,r,A as fl,h as o,f as s,c as n,j as ul,u as m,x as p,k as Ml,y as jl,a as l,v as h,d as c,t as u,w as M}from"../chunks/index.707bf1b6.js";import{T as ws}from"../chunks/Tip.c2ecdbf4.js";import{C as b}from"../chunks/CodeBlock.54a9f38d.js";import{D as bl}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as w,E as Tl}from"../chunks/EditOnGithub.922df6ba.js";function Jl(U){let d,j=`Prompt engineering is only a part of the LLM output optimization process. Another essential component is choosing the
optimal text generation strategy. You can customize how your LLM selects each of the subsequent tokens when generating
the text without modifying any of the trainable parameters. By tweaking the text generation parameters, you can reduce
repetition in the generated text and make it more coherent and human-sounding.
Text generation strategies and parameters are out of scope for this guide, but you can learn more about these topics in
the following guides:`,y,g,J='<li><a href="../llm_tutorial">Generation with LLMs</a></li> <li><a href="../generation_strategies">Text generation strategies</a></li>';return{c(){d=i("p"),d.textContent=j,y=a(),g=i("ul"),g.innerHTML=J},l(f){d=o(f,"P",{"data-svelte-h":!0}),p(d)!=="svelte-194cy3"&&(d.textContent=j),y=n(f),g=o(f,"UL",{"data-svelte-h":!0}),p(g)!=="svelte-1gdi148"&&(g.innerHTML=J)},m(f,T){l(f,d,T),l(f,y,T),l(f,g,T)},p:fs,d(f){f&&(s(d),s(y),s(g))}}}function Ul(U){let d,j=`Note that Falcon models were trained using the <code>bfloat16</code> datatype, so we recommend you use the same. This requires a recent
version of CUDA and works best on modern cards.`;return{c(){d=i("p"),d.innerHTML=j},l(y){d=o(y,"P",{"data-svelte-h":!0}),p(d)!=="svelte-19pliy4"&&(d.innerHTML=j)},m(y,g){l(y,d,g)},p:fs,d(y){y&&s(d)}}}function vl(U){let d,j=`You may notice that in addition to the prompt, we pass a <code>max_new_tokens</code> parameter. It controls the number of tokens the
model shall generate, and it is one of the many text generation parameters that you can learn about
in <a href="../generation_strategies">Text generation strategies</a> guide.`;return{c(){d=i("p"),d.innerHTML=j},l(y){d=o(y,"P",{"data-svelte-h":!0}),p(d)!=="svelte-7bwgnj"&&(d.innerHTML=j)},m(y,g){l(y,d,g)},p:fs,d(y){y&&s(d)}}}function xl(U){let d,j,y,g,J,f,T,Le,B,js=`Large Language Models such as Falcon, LLaMA, etc. are pretrained transformer models initially trained to predict the
next token given some input text. They typically have billions of parameters and have been trained on trillions of
tokens for an extended period of time. As a result, these models become quite powerful and versatile, and you can use
them to solve multiple NLP tasks out of the box by instructing the models with natural language prompts.`,Ae,$,bs=`Designing such prompts to ensure the optimal output is often called “prompt engineering”. Prompt engineering is an
iterative process that requires a fair amount of experimentation. Natural languages are much more flexible and expressive
than programming languages, however, they can also introduce some ambiguity. At the same time, prompts in natural language
are quite sensitive to changes. Even minor modifications in prompts can lead to wildly different outputs.`,Pe,G,Ts=`While there is no exact recipe for creating prompts to match all cases, researchers have worked out a number of best
practices that help to achieve optimal results more consistently.`,De,C,Js=`This guide covers the prompt engineering best practices to help you craft better LLM prompts and solve various NLP tasks.
You’ll learn:`,Ke,Z,Us='<li><a href="#basics-of-prompting">Basics of prompting</a></li> <li><a href="#best-practices-of-llm-prompting">Best practices of LLM prompting</a></li> <li><a href="#advanced-prompting-techniques">Advanced prompting techniques: few-shot prompting and chain-of-thought</a></li> <li><a href="#prompting-vs-fine-tuning">When to fine-tune instead of prompting</a></li>',Oe,v,et,k,tt,W,st,X,vs=`The majority of modern LLMs are decoder-only transformers. Some examples include: <a href="../model_doc/llama">LLaMA</a>,
<a href="../model_doc/llama2">Llama2</a>, <a href="../model_doc/falcon">Falcon</a>, <a href="../model_doc/gpt2">GPT2</a>. However, you may encounter
encoder-decoder transformer LLMs as well, for instance, <a href="../model_doc/flan-t5">Flan-T5</a> and <a href="../model_doc/bart">BART</a>.`,lt,H,xs=`Encoder-decoder-style models are typically used in generative tasks where the output <strong>heavily</strong> relies on the input, for
example, in translation and summarization. The decoder-only models are used for all other types of generative tasks.`,at,V,Is=`When using a pipeline to generate text with an LLM, it’s important to know what type of LLM you are using, because
they use different pipelines.`,nt,Q,Bs="Run inference with decoder-only models with the <code>text-generation</code> pipeline:",it,_,ot,R,$s="To run inference with an encoder-decoder, use the <code>text2text-generation</code> pipeline:",pt,F,rt,q,mt,Y,Gs=`Most of the recent LLM checkpoints available on 🤗 Hub come in two versions: base and instruct (or chat). For example,
<a href="https://huggingface.co/tiiuae/falcon-7b" rel="nofollow"><code>tiiuae/falcon-7b</code></a> and <a href="https://huggingface.co/tiiuae/falcon-7b-instruct" rel="nofollow"><code>tiiuae/falcon-7b-instruct</code></a>.`,ht,N,Cs=`Base models are excellent at completing the text when given an initial prompt, however, they are not ideal for NLP tasks
where they need to follow instructions, or for conversational use. This is where the instruct (chat) versions come in.
These checkpoints are the result of further fine-tuning of the pre-trained base versions on instructions and conversational data.
This additional fine-tuning makes them a better choice for many NLP tasks.`,ct,E,Zs=`Let’s illustrate some simple prompts that you can use with <a href="https://huggingface.co/tiiuae/falcon-7b-instruct" rel="nofollow"><code>tiiuae/falcon-7b-instruct</code></a>
to solve some common NLP tasks.`,ut,z,Mt,S,ks="First, let’s set up the environment:",dt,L,yt,A,Ws="Next, let’s load the model with the appropriate pipeline (<code>&quot;text-generation&quot;</code>):",gt,P,wt,x,ft,D,Xs="Now that we have the model loaded via the pipeline, let’s explore how you can use prompts to solve NLP tasks.",jt,K,bt,O,Hs=`One of the most common forms of text classification is sentiment analysis, which assigns a label like “positive”, “negative”,
or “neutral” to a sequence of text. Let’s write a prompt that instructs the model to classify a given text (a movie review).
We’ll start by giving the instruction, and then specifying the text to classify. Note that instead of leaving it at that, we’re
also adding the beginning of the response - <code>&quot;Sentiment: &quot;</code>:`,Tt,ee,Jt,te,Vs="As a result, the output contains a classification label from the list we have provided in the instructions, and it is a correct one!",Ut,I,vt,se,xt,le,Qs=`Named Entity Recognition (NER) is a task of finding named entities in a piece of text, such as a person, location, or organization.
Let’s modify the instructions in the prompt to make the LLM perform this task. Here, let’s also set <code>return_full_text = False</code>
so that output doesn’t contain the prompt:`,It,ae,Bt,ne,_s="As you can see, the model correctly identified two named entities from the given text.",$t,ie,Gt,oe,Rs=`Another task LLMs can perform is translation. You can choose to use encoder-decoder models for this task, however, here,
for the simplicity of the examples, we’ll keep using Falcon-7b-instruct, which does a decent job. Once again, here’s how
you can write a basic prompt to instruct a model to translate a piece of text from English to Italian:`,Ct,pe,Zt,re,Fs="Here we’ve added a <code>do_sample=True</code> and <code>top_k=10</code> to allow the model to be a bit more flexible when generating output.",kt,me,Wt,he,qs=`Similar to the translation, text summarization is another generative task where the output <strong>heavily</strong> relies on the input,
and encoder-decoder models can be a better choice. However, decoder-style models can be used for this task as well.
Previously, we have placed the instructions at the very beginning of the prompt. However, the very end of the prompt can
also be a suitable location for instructions. Typically, it’s better to place the instruction on one of the extreme ends.`,Xt,ce,Ht,ue,Vt,Me,Ys=`For question answering task we can structure the prompt into the following logical components: instructions, context, question, and
the leading word or phrase (<code>&quot;Answer:&quot;</code>) to nudge the model to start generating the answer:`,Qt,de,_t,ye,Rt,ge,Ns=`Reasoning is one of the most difficult tasks for LLMs, and achieving good results often requires applying advanced prompting techniques, like
<a href="#chain-of-thought">Chain-of-though</a>.`,Ft,we,Es="Let’s try if we can make a model reason about a simple arithmetics task with a basic prompt:",qt,fe,Yt,je,zs="Correct! Let’s increase the complexity a little and see if we can still get away with a basic prompt:",Nt,be,Et,Te,Ss=`This is a wrong answer, it should be 12. In this case, this can be due to the prompt being too basic, or due to the choice
of model, after all we’ve picked the smallest version of Falcon. Reasoning is difficult for models of all sizes, but larger
models are likely to perform better.`,zt,Je,St,Ue,Ls="In this section of the guide we have compiled a list of best practices that tend to improve the prompt results:",Lt,ve,As='<li>When choosing the model to work with, the latest and most capable models are likely to perform better.</li> <li>Start with a simple and short prompt, and iterate from there.</li> <li>Put the instructions at the beginning of the prompt, or at the very end. When working with large context, models apply various optimizations to prevent Attention complexity from scaling quadratically. This may make a model more attentive to the beginning or end of a prompt than the middle.</li> <li>Clearly separate instructions from the text they apply to - more on this in the next section.</li> <li>Be specific and descriptive about the task and the desired outcome - its format, length, style, language, etc.</li> <li>Avoid ambiguous descriptions and instructions.</li> <li>Favor instructions that say “what to do” instead of those that say “what not to do”.</li> <li>“Lead” the output in the right direction by writing the first word (or even begin the first sentence for the model).</li> <li>Use advanced techniques like <a href="#few-shot-prompting">Few-shot prompting</a> and <a href="#chain-of-thought">Chain-of-thought</a></li> <li>Test your prompts with different models to assess their robustness.</li> <li>Version and track the performance of your prompts.</li>',At,xe,Pt,Ie,Dt,Be,Ps=`The basic prompts in the sections above are the examples of “zero-shot” prompts, meaning, the model has been given
instructions and context, but no examples with solutions. LLMs that have been fine-tuned on instruction datasets, generally
perform well on such “zero-shot” tasks. However, you may find that your task has more complexity or nuance, and, perhaps,
you have some requirements for the output that the model doesn’t catch on just from the instructions. In this case, you can
try the technique called few-shot prompting.`,Kt,$e,Ds=`In few-shot prompting, we provide examples in the prompt giving the model more context to improve the performance.
The examples condition the model to generate the output following the patterns in the examples.`,Ot,Ge,Ks="Here’s an example:",es,Ce,ts,Ze,Os=`In the above code snippet we used a single example to demonstrate the desired output to the model, so this can be called a
“one-shot” prompting. However, depending on the task complexity you may need to use more than one example.`,ss,ke,el="Limitations of the few-shot prompting technique:",ls,We,tl="<li>While LLMs can pick up on the patterns in the examples, these technique doesn’t work well on complex reasoning tasks</li> <li>Few-shot prompting requires creating lengthy prompts. Prompts with large number of tokens can increase computation and latency. There’s also a limit to the length of the prompts.</li> <li>Sometimes when given a number of examples, models can learn patterns that you didn’t intend them to learn, e.g. that the third movie review is always negative.</li>",as,Xe,ns,He,sl=`Chain-of-thought (CoT) prompting is a technique that nudges a model to produce intermediate reasoning steps thus improving
the results on complex reasoning tasks.`,is,Ve,ll="There are two ways of steering a model to producing the reasoning steps:",os,Qe,al="<li>few-shot prompting by illustrating examples with detailed answers to questions, showing the model how to work through a problem.</li> <li>by instructing the model to reason by adding phrases like “Let’s think step by step” or “Take a deep breath and work through the problem step by step.”</li>",ps,_e,nl=`If we apply the CoT technique to the muffins example from the <a href="#reasoning">reasoning section</a> and use a larger model,
such as (<code>tiiuae/falcon-180B-chat</code>) which you can play with in the <a href="https://huggingface.co/chat/" rel="nofollow">HuggingChat</a>,
we’ll get a significant improvement on the reasoning result:`,rs,Re,ms,Fe,hs,qe,il=`You can achieve great results by optimizing your prompts, however, you may still ponder whether fine-tuning a model
would work better for your case. Here are some scenarios when fine-tuning a smaller model may be a preferred option:`,cs,Ye,ol="<li>Your domain is wildly different from what LLMs were pre-trained on and extensive prompt optimization did not yield sufficient results.</li> <li>You need your model to work well in a low-resource language.</li> <li>You need the model to be trained on sensitive data that is under strict regulations.</li> <li>You have to use a small model due to cost, privacy, infrastructure or other limitations.</li>",us,Ne,pl=`In all of the above examples, you will need to make sure that you either already have or can easily obtain a large enough
domain-specific dataset at a reasonable cost to fine-tune a model. You will also need to have enough time and resources
to fine-tune a model.`,Ms,Ee,rl="If the above examples are not the case for you, optimizing prompts can prove to be more beneficial.",ds,ze,ys,Se,gs;return J=new w({props:{title:"LLM prompting guide",local:"llm-prompting-guide",headingTag:"h1"}}),T=new bl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/prompting.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/prompting.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/prompting.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/prompting.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/prompting.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/prompting.ipynb"}]}}),v=new ws({props:{$$slots:{default:[Jl]},$$scope:{ctx:U}}}),k=new w({props:{title:"Basics of prompting",local:"basics-of-prompting",headingTag:"h2"}}),W=new w({props:{title:"Types of models",local:"types-of-models",headingTag:"h3"}}),_=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCd0ZXh0LWdlbmVyYXRpb24nJTJDJTIwbW9kZWwlMjAlM0QlMjAnb3BlbmFpLWNvbW11bml0eSUyRmdwdDInKSUwQXByb21wdCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwSSdtJTIwYSUyMGxhbmd1YWdlJTIwbW9kZWwlMjIlMEElMEFnZW5lcmF0b3IocHJvbXB0JTJDJTIwbWF4X2xlbmd0aCUyMCUzRCUyMDMwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(<span class="hljs-string">&#x27;text-generation&#x27;</span>, model = <span class="hljs-string">&#x27;openai-community/gpt2&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hello, I&#x27;m a language model&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt, max_length = <span class="hljs-number">30</span>)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&quot;Hello, I&#x27;m a language model programmer so you can use some of my stuff. But you also need some sort of a C program to run.&quot;</span>}]`,wrap:!1}}),F=new b({props:{code:"dGV4dDJ0ZXh0X2dlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlMjAlM0QlMjAnZ29vZ2xlJTJGZmxhbi10NS1iYXNlJyklMEFwcm9tcHQlMjAlM0QlMjAlMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwRnJlbmNoJTNBJTIwSSdtJTIwdmVyeSUyMGhhcHB5JTIwdG8lMjBzZWUlMjB5b3UlMjIlMEElMEF0ZXh0MnRleHRfZ2VuZXJhdG9yKHByb21wdCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text2text_generator = pipeline(<span class="hljs-string">&quot;text2text-generation&quot;</span>, model = <span class="hljs-string">&#x27;google/flan-t5-base&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Translate from English to French: I&#x27;m very happy to see you&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>text2text_generator(prompt)
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Je suis très heureuse de vous rencontrer.&#x27;</span>}]`,wrap:!1}}),q=new w({props:{title:"Base vs instruct/chat models",local:"base-vs-instructchat-models",headingTag:"h3"}}),z=new w({props:{title:"NLP tasks",local:"nlp-tasks",headingTag:"h3"}}),L=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwYWNjZWxlcmF0ZQ==",highlighted:"pip install -q transformers accelerate",wrap:!1}}),P=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTJDJTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9yY2gubWFudWFsX3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMCUyMnRpaXVhZSUyRmZhbGNvbi03Yi1pbnN0cnVjdCUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKG1vZGVsKSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = <span class="hljs-string">&quot;tiiuae/falcon-7b-instruct&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(model)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-generation&quot;</span>,
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>    torch_dtype=torch.bfloat16,
<span class="hljs-meta">... </span>    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),x=new ws({props:{$$slots:{default:[Ul]},$$scope:{ctx:U}}}),K=new w({props:{title:"Text classification",local:"text-classification",headingTag:"h4"}}),ee=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMCklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJDbGFzc2lmeSUyMHRoZSUyMHRleHQlMjBpbnRvJTIwbmV1dHJhbCUyQyUyMG5lZ2F0aXZlJTIwb3IlMjBwb3NpdGl2ZS4lMjAlMEFUZXh0JTNBJTIwVGhpcyUyMG1vdmllJTIwaXMlMjBkZWZpbml0ZWx5JTIwb25lJTIwb2YlMjBteSUyMGZhdm9yaXRlJTIwbW92aWVzJTIwb2YlMjBpdHMlMjBraW5kLiUyMFRoZSUyMGludGVyYWN0aW9uJTIwYmV0d2VlbiUyMHJlc3BlY3RhYmxlJTIwYW5kJTIwbW9yYWxseSUyMHN0cm9uZyUyMGNoYXJhY3RlcnMlMjBpcyUyMGFuJTIwb2RlJTIwdG8lMjBjaGl2YWxyeSUyMGFuZCUyMHRoZSUyMGhvbm9yJTIwY29kZSUyMGFtb25nc3QlMjB0aGlldmVzJTIwYW5kJTIwcG9saWNlbWVuLiUwQVNlbnRpbWVudCUzQSUwQSUyMiUyMiUyMiUwQSUwQXNlcXVlbmNlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJSZXN1bHQlM0ElMjAlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Classify the text into neutral, negative or positive. 
<span class="hljs-meta">... </span>Text: This movie is definitely one of my favorite movies of its kind. The interaction between respectable and morally strong characters is an ode to chivalry and the honor code amongst thieves and policemen.
<span class="hljs-meta">... </span>Sentiment:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: Classify the text into neutral, negative <span class="hljs-keyword">or</span> positive. 
Text: This movie <span class="hljs-keyword">is</span> definitely one of my favorite movies of its kind. The interaction between respectable <span class="hljs-keyword">and</span> morally strong characters <span class="hljs-keyword">is</span> an ode to chivalry <span class="hljs-keyword">and</span> the honor code amongst thieves <span class="hljs-keyword">and</span> policemen.
Sentiment:
Positive`,wrap:!1}}),I=new ws({props:{$$slots:{default:[vl]},$$scope:{ctx:U}}}),se=new w({props:{title:"Named Entity Recognition",local:"named-entity-recognition",headingTag:"h4"}}),ae=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJSZXR1cm4lMjBhJTIwbGlzdCUyMG9mJTIwbmFtZWQlMjBlbnRpdGllcyUyMGluJTIwdGhlJTIwdGV4dC4lMEFUZXh0JTNBJTIwVGhlJTIwR29sZGVuJTIwU3RhdGUlMjBXYXJyaW9ycyUyMGFyZSUyMGFuJTIwQW1lcmljYW4lMjBwcm9mZXNzaW9uYWwlMjBiYXNrZXRiYWxsJTIwdGVhbSUyMGJhc2VkJTIwaW4lMjBTYW4lMjBGcmFuY2lzY28uJTBBTmFtZWQlMjBlbnRpdGllcyUzQSUwQSUyMiUyMiUyMiUwQSUwQXNlcXVlbmNlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxNSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9mdWxsX3RleHQlMjAlM0QlMjBGYWxzZSUyQyUyMCUyMCUyMCUyMCUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Return a list of named entities in the text.
<span class="hljs-meta">... </span>Text: The Golden State Warriors are an American professional basketball team based in San Francisco.
<span class="hljs-meta">... </span>Named entities:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">15</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,    
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
- Golden State Warriors
- San Francisco`,wrap:!1}}),ie=new w({props:{title:"Translation",local:"translation",headingTag:"h4"}}),pe=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMiklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJUcmFuc2xhdGUlMjB0aGUlMjBFbmdsaXNoJTIwdGV4dCUyMHRvJTIwSXRhbGlhbi4lMEFUZXh0JTNBJTIwU29tZXRpbWVzJTJDJTIwSSd2ZSUyMGJlbGlldmVkJTIwYXMlMjBtYW55JTIwYXMlMjBzaXglMjBpbXBvc3NpYmxlJTIwdGhpbmdzJTIwYmVmb3JlJTIwYnJlYWtmYXN0LiUwQVRyYW5zbGF0aW9uJTNBJTBBJTIyJTIyJTIyJTBBJTBBc2VxdWVuY2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNEMTAlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTIwJTNEJTIwRmFsc2UlMkMlMEEpJTBBJTBBZm9yJTIwc2VxJTIwaW4lMjBzZXF1ZW5jZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTdCc2VxJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Translate the English text to Italian.
<span class="hljs-meta">... </span>Text: Sometimes, I&#x27;ve believed as many as six impossible things before breakfast.
<span class="hljs-meta">... </span>Translation:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
A volte, ho creduto a sei impossibili cose prima di colazione.`,wrap:!1}}),me=new w({props:{title:"Text summarization",local:"text-summarization",headingTag:"h4"}}),ce=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMyklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJQZXJtYWN1bHR1cmUlMjBpcyUyMGElMjBkZXNpZ24lMjBwcm9jZXNzJTIwbWltaWNraW5nJTIwdGhlJTIwZGl2ZXJzaXR5JTJDJTIwZnVuY3Rpb25hbGl0eSUyMGFuZCUyMHJlc2lsaWVuY2UlMjBvZiUyMG5hdHVyYWwlMjBlY29zeXN0ZW1zLiUyMFRoZSUyMHByaW5jaXBsZXMlMjBhbmQlMjBwcmFjdGljZXMlMjBhcmUlMjBkcmF3biUyMGZyb20lMjB0cmFkaXRpb25hbCUyMGVjb2xvZ2ljYWwlMjBrbm93bGVkZ2UlMjBvZiUyMGluZGlnZW5vdXMlMjBjdWx0dXJlcyUyMGNvbWJpbmVkJTIwd2l0aCUyMG1vZGVybiUyMHNjaWVudGlmaWMlMjB1bmRlcnN0YW5kaW5nJTIwYW5kJTIwdGVjaG5vbG9naWNhbCUyMGlubm92YXRpb25zLiUyMFBlcm1hY3VsdHVyZSUyMGRlc2lnbiUyMHByb3ZpZGVzJTIwYSUyMGZyYW1ld29yayUyMGhlbHBpbmclMjBpbmRpdmlkdWFscyUyMGFuZCUyMGNvbW11bml0aWVzJTIwZGV2ZWxvcCUyMGlubm92YXRpdmUlMkMlMjBjcmVhdGl2ZSUyMGFuZCUyMGVmZmVjdGl2ZSUyMHN0cmF0ZWdpZXMlMjBmb3IlMjBtZWV0aW5nJTIwYmFzaWMlMjBuZWVkcyUyMHdoaWxlJTIwcHJlcGFyaW5nJTIwZm9yJTIwYW5kJTIwbWl0aWdhdGluZyUyMHRoZSUyMHByb2plY3RlZCUyMGltcGFjdHMlMjBvZiUyMGNsaW1hdGUlMjBjaGFuZ2UuJTBBV3JpdGUlMjBhJTIwc3VtbWFyeSUyMG9mJTIwdGhlJTIwYWJvdmUlMjB0ZXh0LiUwQVN1bW1hcnklM0ElMEElMjIlMjIlMjIlMEElMEFzZXF1ZW5jZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMzAlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdG9wX2slM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9mdWxsX3RleHQlMjAlM0QlMjBGYWxzZSUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Permaculture is a design process mimicking the diversity, functionality and resilience of natural ecosystems. The principles and practices are drawn from traditional ecological knowledge of indigenous cultures combined with modern scientific understanding and technological innovations. Permaculture design provides a framework helping individuals and communities develop innovative, creative and effective strategies for meeting basic needs while preparing for and mitigating the projected impacts of climate change.
<span class="hljs-meta">... </span>Write a summary of the above text.
<span class="hljs-meta">... </span>Summary:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Permaculture <span class="hljs-keyword">is</span> an ecological design mimicking natural ecosystems to meet basic needs <span class="hljs-keyword">and</span> prepare <span class="hljs-keyword">for</span> climate change. It <span class="hljs-keyword">is</span> based on traditional knowledge <span class="hljs-keyword">and</span> scientific understanding.`,wrap:!1}}),ue=new w({props:{title:"Question answering",local:"question-answering",headingTag:"h4"}}),de=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoNCklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJBbnN3ZXIlMjB0aGUlMjBxdWVzdGlvbiUyMHVzaW5nJTIwdGhlJTIwY29udGV4dCUyMGJlbG93LiUwQUNvbnRleHQlM0ElMjBHYXpwYWNobyUyMGlzJTIwYSUyMGNvbGQlMjBzb3VwJTIwYW5kJTIwZHJpbmslMjBtYWRlJTIwb2YlMjByYXclMkMlMjBibGVuZGVkJTIwdmVnZXRhYmxlcy4lMjBNb3N0JTIwZ2F6cGFjaG8lMjBpbmNsdWRlcyUyMHN0YWxlJTIwYnJlYWQlMkMlMjB0b21hdG8lMkMlMjBjdWN1bWJlcnMlMkMlMjBvbmlvbiUyQyUyMGJlbGwlMjBwZXBwZXJzJTJDJTIwZ2FybGljJTJDJTIwb2xpdmUlMjBvaWwlMkMlMjB3aW5lJTIwdmluZWdhciUyQyUyMHdhdGVyJTJDJTIwYW5kJTIwc2FsdC4lMjBOb3J0aGVybiUyMHJlY2lwZXMlMjBvZnRlbiUyMGluY2x1ZGUlMjBjdW1pbiUyMGFuZCUyRm9yJTIwcGltZW50JUMzJUIzbiUyMChzbW9rZWQlMjBzd2VldCUyMHBhcHJpa2EpLiUyMFRyYWRpdGlvbmFsbHklMkMlMjBnYXpwYWNobyUyMHdhcyUyMG1hZGUlMjBieSUyMHBvdW5kaW5nJTIwdGhlJTIwdmVnZXRhYmxlcyUyMGluJTIwYSUyMG1vcnRhciUyMHdpdGglMjBhJTIwcGVzdGxlJTNCJTIwdGhpcyUyMG1vcmUlMjBsYWJvcmlvdXMlMjBtZXRob2QlMjBpcyUyMHN0aWxsJTIwc29tZXRpbWVzJTIwdXNlZCUyMGFzJTIwaXQlMjBoZWxwcyUyMGtlZXAlMjB0aGUlMjBnYXpwYWNobyUyMGNvb2wlMjBhbmQlMjBhdm9pZHMlMjB0aGUlMjBmb2FtJTIwYW5kJTIwc2lsa3klMjBjb25zaXN0ZW5jeSUyMG9mJTIwc21vb3RoaWUlMjB2ZXJzaW9ucyUyMG1hZGUlMjBpbiUyMGJsZW5kZXJzJTIwb3IlMjBmb29kJTIwcHJvY2Vzc29ycy4lMEFRdWVzdGlvbiUzQSUyMFdoYXQlMjBtb2Rlcm4lMjB0b29sJTIwaXMlMjB1c2VkJTIwdG8lMjBtYWtlJTIwZ2F6cGFjaG8lM0YlMEFBbnN3ZXIlM0ElMEElMjIlMjIlMjIlMEElMEFzZXF1ZW5jZXMlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdG9wX2slM0QxMCUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl9mdWxsX3RleHQlMjAlM0QlMjBGYWxzZSUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJSZXN1bHQlM0ElMjAlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Answer the question using the context below.
<span class="hljs-meta">... </span>Context: Gazpacho is a cold soup and drink made of raw, blended vegetables. Most gazpacho includes stale bread, tomato, cucumbers, onion, bell peppers, garlic, olive oil, wine vinegar, water, and salt. Northern recipes often include cumin and/or pimentón (smoked sweet paprika). Traditionally, gazpacho was made by pounding the vegetables in a mortar with a pestle; this more laborious method is still sometimes used as it helps keep the gazpacho cool and avoids the foam and silky consistency of smoothie versions made in blenders or food processors.
<span class="hljs-meta">... </span>Question: What modern tool is used to make gazpacho?
<span class="hljs-meta">... </span>Answer:
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: Modern tools often used to make gazpacho include`,wrap:!1}}),ye=new w({props:{title:"Reasoning",local:"reasoning",headingTag:"h4"}}),fe=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoNSklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJUaGVyZSUyMGFyZSUyMDUlMjBncm91cHMlMjBvZiUyMHN0dWRlbnRzJTIwaW4lMjB0aGUlMjBjbGFzcy4lMjBFYWNoJTIwZ3JvdXAlMjBoYXMlMjA0JTIwc3R1ZGVudHMuJTIwSG93JTIwbWFueSUyMHN0dWRlbnRzJTIwYXJlJTIwdGhlcmUlMjBpbiUyMHRoZSUyMGNsYXNzJTNGJTIyJTIyJTIyJTBBJTBBc2VxdWVuY2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNEMTAlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZnVsbF90ZXh0JTIwJTNEJTIwRmFsc2UlMkMlMEEpJTBBJTBBZm9yJTIwc2VxJTIwaW4lMjBzZXF1ZW5jZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUmVzdWx0JTNBJTIwJTdCc2VxJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;There are 5 groups of students in the class. Each group has 4 students. How many students are there in the class?&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: 
There are a total of <span class="hljs-number">5</span> groups, so there are <span class="hljs-number">5</span> x <span class="hljs-number">4</span>=<span class="hljs-number">20</span> students <span class="hljs-keyword">in</span> the <span class="hljs-keyword">class</span>.`,wrap:!1}}),be=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoNiklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJJJTIwYmFrZWQlMjAxNSUyMG11ZmZpbnMuJTIwSSUyMGF0ZSUyMDIlMjBtdWZmaW5zJTIwYW5kJTIwZ2F2ZSUyMDUlMjBtdWZmaW5zJTIwdG8lMjBhJTIwbmVpZ2hib3IuJTIwTXklMjBwYXJ0bmVyJTIwdGhlbiUyMGJvdWdodCUyMDYlMjBtb3JlJTIwbXVmZmlucyUyMGFuZCUyMGF0ZSUyMDIuJTIwSG93JTIwbWFueSUyMG11ZmZpbnMlMjBkbyUyMHdlJTIwbm93JTIwaGF2ZSUzRiUyMiUyMiUyMiUwQSUwQXNlcXVlbmNlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0b3BfayUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX2Z1bGxfdGV4dCUyMCUzRCUyMEZhbHNlJTJDJTBBKSUwQSUwQWZvciUyMHNlcSUyMGluJTIwc2VxdWVuY2VzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMlJlc3VsdCUzQSUyMCU3QnNlcSU1QidnZW5lcmF0ZWRfdGV4dCclNUQlN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">6</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;I baked 15 muffins. I ate 2 muffins and gave 5 muffins to a neighbor. My partner then bought 6 more muffins and ate 2. How many muffins do we now have?&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    return_full_text = <span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: 
The total number of muffins now <span class="hljs-keyword">is</span> <span class="hljs-number">21</span>`,wrap:!1}}),Je=new w({props:{title:"Best practices of LLM prompting",local:"best-practices-of-llm-prompting",headingTag:"h2"}}),xe=new w({props:{title:"Advanced prompting techniques",local:"advanced-prompting-techniques",headingTag:"h2"}}),Ie=new w({props:{title:"Few-shot prompting",local:"few-shot-prompting",headingTag:"h3"}}),Ce=new b({props:{code:"dG9yY2gubWFudWFsX3NlZWQoMCklMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjJUZXh0JTNBJTIwVGhlJTIwZmlyc3QlMjBodW1hbiUyMHdlbnQlMjBpbnRvJTIwc3BhY2UlMjBhbmQlMjBvcmJpdGVkJTIwdGhlJTIwRWFydGglMjBvbiUyMEFwcmlsJTIwMTIlMkMlMjAxOTYxLiUwQURhdGUlM0ElMjAwNCUyRjEyJTJGMTk2MSUwQVRleHQlM0ElMjBUaGUlMjBmaXJzdC1ldmVyJTIwdGVsZXZpc2VkJTIwcHJlc2lkZW50aWFsJTIwZGViYXRlJTIwaW4lMjB0aGUlMjBVbml0ZWQlMjBTdGF0ZXMlMjB0b29rJTIwcGxhY2UlMjBvbiUyMFNlcHRlbWJlciUyMDI4JTJDJTIwMTk2MCUyQyUyMGJldHdlZW4lMjBwcmVzaWRlbnRpYWwlMjBjYW5kaWRhdGVzJTIwSm9obiUyMEYuJTIwS2VubmVkeSUyMGFuZCUyMFJpY2hhcmQlMjBOaXhvbi4lMjAlMEFEYXRlJTNBJTIyJTIyJTIyJTBBJTBBc2VxdWVuY2VzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBtYXhfbmV3X3Rva2VucyUzRDglMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwdG9wX2slM0QxMCUyQyUwQSklMEElMEFmb3IlMjBzZXElMjBpbiUyMHNlcXVlbmNlcyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJSZXN1bHQlM0ElMjAlN0JzZXElNUInZ2VuZXJhdGVkX3RleHQnJTVEJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;Text: The first human went into space and orbited the Earth on April 12, 1961.
<span class="hljs-meta">... </span>Date: 04/12/1961
<span class="hljs-meta">... </span>Text: The first-ever televised presidential debate in the United States took place on September 28, 1960, between presidential candidates John F. Kennedy and Richard Nixon. 
<span class="hljs-meta">... </span>Date:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>sequences = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    top_k=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> seq <span class="hljs-keyword">in</span> sequences:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Result: <span class="hljs-subst">{seq[<span class="hljs-string">&#x27;generated_text&#x27;</span>]}</span>&quot;</span>)
Result: Text: The first human went into space <span class="hljs-keyword">and</span> orbited the Earth on April <span class="hljs-number">12</span>, <span class="hljs-number">1961.</span>
Date: 04/<span class="hljs-number">12</span>/<span class="hljs-number">1961</span>
Text: The first-ever televised presidential debate <span class="hljs-keyword">in</span> the United States took place on September <span class="hljs-number">28</span>, <span class="hljs-number">1960</span>, between presidential candidates John F. Kennedy <span class="hljs-keyword">and</span> Richard Nixon. 
Date: 09/<span class="hljs-number">28</span>/<span class="hljs-number">1960</span>`,wrap:!1}}),Xe=new w({props:{title:"Chain-of-thought",local:"chain-of-thought",headingTag:"h3"}}),Re=new b({props:{code:"TGV0J3MlMjBnbyUyMHRocm91Z2glMjB0aGlzJTIwc3RlcC1ieS1zdGVwJTNBJTBBMS4lMjBZb3UlMjBzdGFydCUyMHdpdGglMjAxNSUyMG11ZmZpbnMuJTBBMi4lMjBZb3UlMjBlYXQlMjAyJTIwbXVmZmlucyUyQyUyMGxlYXZpbmclMjB5b3UlMjB3aXRoJTIwMTMlMjBtdWZmaW5zLiUwQTMuJTIwWW91JTIwZ2l2ZSUyMDUlMjBtdWZmaW5zJTIwdG8lMjB5b3VyJTIwbmVpZ2hib3IlMkMlMjBsZWF2aW5nJTIweW91JTIwd2l0aCUyMDglMjBtdWZmaW5zLiUwQTQuJTIwWW91ciUyMHBhcnRuZXIlMjBidXlzJTIwNiUyMG1vcmUlMjBtdWZmaW5zJTJDJTIwYnJpbmdpbmclMjB0aGUlMjB0b3RhbCUyMG51bWJlciUyMG9mJTIwbXVmZmlucyUyMHRvJTIwMTQuJTBBNS4lMjBZb3VyJTIwcGFydG5lciUyMGVhdHMlMjAyJTIwbXVmZmlucyUyQyUyMGxlYXZpbmclMjB5b3UlMjB3aXRoJTIwMTIlMjBtdWZmaW5zLiUwQVRoZXJlZm9yZSUyQyUyMHlvdSUyMG5vdyUyMGhhdmUlMjAxMiUyMG11ZmZpbnMu",highlighted:`Let&#x27;s go through this step-by-step:
1. You start with 15 muffins.
2. You eat 2 muffins, leaving you with 13 muffins.
3. You give 5 muffins to your neighbor, leaving you with 8 muffins.
4. Your partner buys 6 more muffins, bringing the total number of muffins to 14.
5. Your partner eats 2 muffins, leaving you with 12 muffins.
Therefore, you now have 12 muffins.`,wrap:!1}}),Fe=new w({props:{title:"Prompting vs fine-tuning",local:"prompting-vs-fine-tuning",headingTag:"h2"}}),ze=new Tl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/prompting.md"}}),{c(){d=i("meta"),j=a(),y=i("p"),g=a(),r(J.$$.fragment),f=a(),r(T.$$.fragment),Le=a(),B=i("p"),B.textContent=js,Ae=a(),$=i("p"),$.textContent=bs,Pe=a(),G=i("p"),G.textContent=Ts,De=a(),C=i("p"),C.textContent=Js,Ke=a(),Z=i("ul"),Z.innerHTML=Us,Oe=a(),r(v.$$.fragment),et=a(),r(k.$$.fragment),tt=a(),r(W.$$.fragment),st=a(),X=i("p"),X.innerHTML=vs,lt=a(),H=i("p"),H.innerHTML=xs,at=a(),V=i("p"),V.textContent=Is,nt=a(),Q=i("p"),Q.innerHTML=Bs,it=a(),r(_.$$.fragment),ot=a(),R=i("p"),R.innerHTML=$s,pt=a(),r(F.$$.fragment),rt=a(),r(q.$$.fragment),mt=a(),Y=i("p"),Y.innerHTML=Gs,ht=a(),N=i("p"),N.textContent=Cs,ct=a(),E=i("p"),E.innerHTML=Zs,ut=a(),r(z.$$.fragment),Mt=a(),S=i("p"),S.textContent=ks,dt=a(),r(L.$$.fragment),yt=a(),A=i("p"),A.innerHTML=Ws,gt=a(),r(P.$$.fragment),wt=a(),r(x.$$.fragment),ft=a(),D=i("p"),D.textContent=Xs,jt=a(),r(K.$$.fragment),bt=a(),O=i("p"),O.innerHTML=Hs,Tt=a(),r(ee.$$.fragment),Jt=a(),te=i("p"),te.textContent=Vs,Ut=a(),r(I.$$.fragment),vt=a(),r(se.$$.fragment),xt=a(),le=i("p"),le.innerHTML=Qs,It=a(),r(ae.$$.fragment),Bt=a(),ne=i("p"),ne.textContent=_s,$t=a(),r(ie.$$.fragment),Gt=a(),oe=i("p"),oe.textContent=Rs,Ct=a(),r(pe.$$.fragment),Zt=a(),re=i("p"),re.innerHTML=Fs,kt=a(),r(me.$$.fragment),Wt=a(),he=i("p"),he.innerHTML=qs,Xt=a(),r(ce.$$.fragment),Ht=a(),r(ue.$$.fragment),Vt=a(),Me=i("p"),Me.innerHTML=Ys,Qt=a(),r(de.$$.fragment),_t=a(),r(ye.$$.fragment),Rt=a(),ge=i("p"),ge.innerHTML=Ns,Ft=a(),we=i("p"),we.textContent=Es,qt=a(),r(fe.$$.fragment),Yt=a(),je=i("p"),je.textContent=zs,Nt=a(),r(be.$$.fragment),Et=a(),Te=i("p"),Te.textContent=Ss,zt=a(),r(Je.$$.fragment),St=a(),Ue=i("p"),Ue.textContent=Ls,Lt=a(),ve=i("ul"),ve.innerHTML=As,At=a(),r(xe.$$.fragment),Pt=a(),r(Ie.$$.fragment),Dt=a(),Be=i("p"),Be.textContent=Ps,Kt=a(),$e=i("p"),$e.textContent=Ds,Ot=a(),Ge=i("p"),Ge.textContent=Ks,es=a(),r(Ce.$$.fragment),ts=a(),Ze=i("p"),Ze.textContent=Os,ss=a(),ke=i("p"),ke.textContent=el,ls=a(),We=i("ul"),We.innerHTML=tl,as=a(),r(Xe.$$.fragment),ns=a(),He=i("p"),He.textContent=sl,is=a(),Ve=i("p"),Ve.textContent=ll,os=a(),Qe=i("ul"),Qe.innerHTML=al,ps=a(),_e=i("p"),_e.innerHTML=nl,rs=a(),r(Re.$$.fragment),ms=a(),r(Fe.$$.fragment),hs=a(),qe=i("p"),qe.textContent=il,cs=a(),Ye=i("ul"),Ye.innerHTML=ol,us=a(),Ne=i("p"),Ne.textContent=pl,Ms=a(),Ee=i("p"),Ee.textContent=rl,ds=a(),r(ze.$$.fragment),ys=a(),Se=i("p"),this.h()},l(e){const t=fl("svelte-u9bgzb",document.head);d=o(t,"META",{name:!0,content:!0}),t.forEach(s),j=n(e),y=o(e,"P",{}),ul(y).forEach(s),g=n(e),m(J.$$.fragment,e),f=n(e),m(T.$$.fragment,e),Le=n(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1ljgn3w"&&(B.textContent=js),Ae=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-18wgi3w"&&($.textContent=bs),Pe=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-qy50g8"&&(G.textContent=Ts),De=n(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-9pzuyc"&&(C.textContent=Js),Ke=n(e),Z=o(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-7xzpwh"&&(Z.innerHTML=Us),Oe=n(e),m(v.$$.fragment,e),et=n(e),m(k.$$.fragment,e),tt=n(e),m(W.$$.fragment,e),st=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-nnu9ls"&&(X.innerHTML=vs),lt=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-x23cxg"&&(H.innerHTML=xs),at=n(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1yu9xal"&&(V.textContent=Is),nt=n(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1ytddav"&&(Q.innerHTML=Bs),it=n(e),m(_.$$.fragment,e),ot=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-7uki49"&&(R.innerHTML=$s),pt=n(e),m(F.$$.fragment,e),rt=n(e),m(q.$$.fragment,e),mt=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-i0l3du"&&(Y.innerHTML=Gs),ht=n(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-7kf9x0"&&(N.textContent=Cs),ct=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1afwrwd"&&(E.innerHTML=Zs),ut=n(e),m(z.$$.fragment,e),Mt=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-uktc9k"&&(S.textContent=ks),dt=n(e),m(L.$$.fragment,e),yt=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1rcm11q"&&(A.innerHTML=Ws),gt=n(e),m(P.$$.fragment,e),wt=n(e),m(x.$$.fragment,e),ft=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1qpoueu"&&(D.textContent=Xs),jt=n(e),m(K.$$.fragment,e),bt=n(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-5h15oc"&&(O.innerHTML=Hs),Tt=n(e),m(ee.$$.fragment,e),Jt=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1vj09uj"&&(te.textContent=Vs),Ut=n(e),m(I.$$.fragment,e),vt=n(e),m(se.$$.fragment,e),xt=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-17al9zp"&&(le.innerHTML=Qs),It=n(e),m(ae.$$.fragment,e),Bt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1lee3n3"&&(ne.textContent=_s),$t=n(e),m(ie.$$.fragment,e),Gt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-73k5zw"&&(oe.textContent=Rs),Ct=n(e),m(pe.$$.fragment,e),Zt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-hofrk3"&&(re.innerHTML=Fs),kt=n(e),m(me.$$.fragment,e),Wt=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-14bqgsm"&&(he.innerHTML=qs),Xt=n(e),m(ce.$$.fragment,e),Ht=n(e),m(ue.$$.fragment,e),Vt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-7xjq21"&&(Me.innerHTML=Ys),Qt=n(e),m(de.$$.fragment,e),_t=n(e),m(ye.$$.fragment,e),Rt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-qpdy2m"&&(ge.innerHTML=Ns),Ft=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1enryru"&&(we.textContent=Es),qt=n(e),m(fe.$$.fragment,e),Yt=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-bfn0wi"&&(je.textContent=zs),Nt=n(e),m(be.$$.fragment,e),Et=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-n2catr"&&(Te.textContent=Ss),zt=n(e),m(Je.$$.fragment,e),St=n(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-70cj29"&&(Ue.textContent=Ls),Lt=n(e),ve=o(e,"UL",{"data-svelte-h":!0}),p(ve)!=="svelte-1m3ht2b"&&(ve.innerHTML=As),At=n(e),m(xe.$$.fragment,e),Pt=n(e),m(Ie.$$.fragment,e),Dt=n(e),Be=o(e,"P",{"data-svelte-h":!0}),p(Be)!=="svelte-113emw4"&&(Be.textContent=Ps),Kt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-f5haxx"&&($e.textContent=Ds),Ot=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-9gwuyp"&&(Ge.textContent=Ks),es=n(e),m(Ce.$$.fragment,e),ts=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-12eqgvl"&&(Ze.textContent=Os),ss=n(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1oqsq7s"&&(ke.textContent=el),ls=n(e),We=o(e,"UL",{"data-svelte-h":!0}),p(We)!=="svelte-1tv7al1"&&(We.innerHTML=tl),as=n(e),m(Xe.$$.fragment,e),ns=n(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-u5x5ge"&&(He.textContent=sl),is=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1s6z2yc"&&(Ve.textContent=ll),os=n(e),Qe=o(e,"UL",{"data-svelte-h":!0}),p(Qe)!=="svelte-9m9nfu"&&(Qe.innerHTML=al),ps=n(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-mc5q7v"&&(_e.innerHTML=nl),rs=n(e),m(Re.$$.fragment,e),ms=n(e),m(Fe.$$.fragment,e),hs=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-ezfyph"&&(qe.textContent=il),cs=n(e),Ye=o(e,"UL",{"data-svelte-h":!0}),p(Ye)!=="svelte-14be605"&&(Ye.innerHTML=ol),us=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-1cyrgd1"&&(Ne.textContent=pl),Ms=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-oil4mc"&&(Ee.textContent=rl),ds=n(e),m(ze.$$.fragment,e),ys=n(e),Se=o(e,"P",{}),ul(Se).forEach(s),this.h()},h(){Ml(d,"name","hf:doc:metadata"),Ml(d,"content",Il)},m(e,t){jl(document.head,d),l(e,j,t),l(e,y,t),l(e,g,t),h(J,e,t),l(e,f,t),h(T,e,t),l(e,Le,t),l(e,B,t),l(e,Ae,t),l(e,$,t),l(e,Pe,t),l(e,G,t),l(e,De,t),l(e,C,t),l(e,Ke,t),l(e,Z,t),l(e,Oe,t),h(v,e,t),l(e,et,t),h(k,e,t),l(e,tt,t),h(W,e,t),l(e,st,t),l(e,X,t),l(e,lt,t),l(e,H,t),l(e,at,t),l(e,V,t),l(e,nt,t),l(e,Q,t),l(e,it,t),h(_,e,t),l(e,ot,t),l(e,R,t),l(e,pt,t),h(F,e,t),l(e,rt,t),h(q,e,t),l(e,mt,t),l(e,Y,t),l(e,ht,t),l(e,N,t),l(e,ct,t),l(e,E,t),l(e,ut,t),h(z,e,t),l(e,Mt,t),l(e,S,t),l(e,dt,t),h(L,e,t),l(e,yt,t),l(e,A,t),l(e,gt,t),h(P,e,t),l(e,wt,t),h(x,e,t),l(e,ft,t),l(e,D,t),l(e,jt,t),h(K,e,t),l(e,bt,t),l(e,O,t),l(e,Tt,t),h(ee,e,t),l(e,Jt,t),l(e,te,t),l(e,Ut,t),h(I,e,t),l(e,vt,t),h(se,e,t),l(e,xt,t),l(e,le,t),l(e,It,t),h(ae,e,t),l(e,Bt,t),l(e,ne,t),l(e,$t,t),h(ie,e,t),l(e,Gt,t),l(e,oe,t),l(e,Ct,t),h(pe,e,t),l(e,Zt,t),l(e,re,t),l(e,kt,t),h(me,e,t),l(e,Wt,t),l(e,he,t),l(e,Xt,t),h(ce,e,t),l(e,Ht,t),h(ue,e,t),l(e,Vt,t),l(e,Me,t),l(e,Qt,t),h(de,e,t),l(e,_t,t),h(ye,e,t),l(e,Rt,t),l(e,ge,t),l(e,Ft,t),l(e,we,t),l(e,qt,t),h(fe,e,t),l(e,Yt,t),l(e,je,t),l(e,Nt,t),h(be,e,t),l(e,Et,t),l(e,Te,t),l(e,zt,t),h(Je,e,t),l(e,St,t),l(e,Ue,t),l(e,Lt,t),l(e,ve,t),l(e,At,t),h(xe,e,t),l(e,Pt,t),h(Ie,e,t),l(e,Dt,t),l(e,Be,t),l(e,Kt,t),l(e,$e,t),l(e,Ot,t),l(e,Ge,t),l(e,es,t),h(Ce,e,t),l(e,ts,t),l(e,Ze,t),l(e,ss,t),l(e,ke,t),l(e,ls,t),l(e,We,t),l(e,as,t),h(Xe,e,t),l(e,ns,t),l(e,He,t),l(e,is,t),l(e,Ve,t),l(e,os,t),l(e,Qe,t),l(e,ps,t),l(e,_e,t),l(e,rs,t),h(Re,e,t),l(e,ms,t),h(Fe,e,t),l(e,hs,t),l(e,qe,t),l(e,cs,t),l(e,Ye,t),l(e,us,t),l(e,Ne,t),l(e,Ms,t),l(e,Ee,t),l(e,ds,t),h(ze,e,t),l(e,ys,t),l(e,Se,t),gs=!0},p(e,[t]){const ml={};t&2&&(ml.$$scope={dirty:t,ctx:e}),v.$set(ml);const hl={};t&2&&(hl.$$scope={dirty:t,ctx:e}),x.$set(hl);const cl={};t&2&&(cl.$$scope={dirty:t,ctx:e}),I.$set(cl)},i(e){gs||(c(J.$$.fragment,e),c(T.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(_.$$.fragment,e),c(F.$$.fragment,e),c(q.$$.fragment,e),c(z.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(x.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(I.$$.fragment,e),c(se.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(de.$$.fragment,e),c(ye.$$.fragment,e),c(fe.$$.fragment,e),c(be.$$.fragment,e),c(Je.$$.fragment,e),c(xe.$$.fragment,e),c(Ie.$$.fragment,e),c(Ce.$$.fragment,e),c(Xe.$$.fragment,e),c(Re.$$.fragment,e),c(Fe.$$.fragment,e),c(ze.$$.fragment,e),gs=!0)},o(e){u(J.$$.fragment,e),u(T.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(W.$$.fragment,e),u(_.$$.fragment,e),u(F.$$.fragment,e),u(q.$$.fragment,e),u(z.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(x.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(I.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(ue.$$.fragment,e),u(de.$$.fragment,e),u(ye.$$.fragment,e),u(fe.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),u(xe.$$.fragment,e),u(Ie.$$.fragment,e),u(Ce.$$.fragment,e),u(Xe.$$.fragment,e),u(Re.$$.fragment,e),u(Fe.$$.fragment,e),u(ze.$$.fragment,e),gs=!1},d(e){e&&(s(j),s(y),s(g),s(f),s(Le),s(B),s(Ae),s($),s(Pe),s(G),s(De),s(C),s(Ke),s(Z),s(Oe),s(et),s(tt),s(st),s(X),s(lt),s(H),s(at),s(V),s(nt),s(Q),s(it),s(ot),s(R),s(pt),s(rt),s(mt),s(Y),s(ht),s(N),s(ct),s(E),s(ut),s(Mt),s(S),s(dt),s(yt),s(A),s(gt),s(wt),s(ft),s(D),s(jt),s(bt),s(O),s(Tt),s(Jt),s(te),s(Ut),s(vt),s(xt),s(le),s(It),s(Bt),s(ne),s($t),s(Gt),s(oe),s(Ct),s(Zt),s(re),s(kt),s(Wt),s(he),s(Xt),s(Ht),s(Vt),s(Me),s(Qt),s(_t),s(Rt),s(ge),s(Ft),s(we),s(qt),s(Yt),s(je),s(Nt),s(Et),s(Te),s(zt),s(St),s(Ue),s(Lt),s(ve),s(At),s(Pt),s(Dt),s(Be),s(Kt),s($e),s(Ot),s(Ge),s(es),s(ts),s(Ze),s(ss),s(ke),s(ls),s(We),s(as),s(ns),s(He),s(is),s(Ve),s(os),s(Qe),s(ps),s(_e),s(rs),s(ms),s(hs),s(qe),s(cs),s(Ye),s(us),s(Ne),s(Ms),s(Ee),s(ds),s(ys),s(Se)),s(d),M(J,e),M(T,e),M(v,e),M(k,e),M(W,e),M(_,e),M(F,e),M(q,e),M(z,e),M(L,e),M(P,e),M(x,e),M(K,e),M(ee,e),M(I,e),M(se,e),M(ae,e),M(ie,e),M(pe,e),M(me,e),M(ce,e),M(ue,e),M(de,e),M(ye,e),M(fe,e),M(be,e),M(Je,e),M(xe,e),M(Ie,e),M(Ce,e),M(Xe,e),M(Re,e),M(Fe,e),M(ze,e)}}}const Il='{"title":"LLM prompting guide","local":"llm-prompting-guide","sections":[{"title":"Basics of prompting","local":"basics-of-prompting","sections":[{"title":"Types of models","local":"types-of-models","sections":[],"depth":3},{"title":"Base vs instruct/chat models","local":"base-vs-instructchat-models","sections":[],"depth":3},{"title":"NLP tasks","local":"nlp-tasks","sections":[{"title":"Text classification","local":"text-classification","sections":[],"depth":4},{"title":"Named Entity Recognition","local":"named-entity-recognition","sections":[],"depth":4},{"title":"Translation","local":"translation","sections":[],"depth":4},{"title":"Text summarization","local":"text-summarization","sections":[],"depth":4},{"title":"Question answering","local":"question-answering","sections":[],"depth":4},{"title":"Reasoning","local":"reasoning","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Best practices of LLM prompting","local":"best-practices-of-llm-prompting","sections":[],"depth":2},{"title":"Advanced prompting techniques","local":"advanced-prompting-techniques","sections":[{"title":"Few-shot prompting","local":"few-shot-prompting","sections":[],"depth":3},{"title":"Chain-of-thought","local":"chain-of-thought","sections":[],"depth":3}],"depth":2},{"title":"Prompting vs fine-tuning","local":"prompting-vs-fine-tuning","sections":[],"depth":2}],"depth":1}';function Bl(U){return yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xl extends gl{constructor(d){super(),wl(this,d,Bl,xl,dl,{})}}export{Xl as component};
