import{s as ws,n as Js,o as Ms}from"../chunks/scheduler.85c25b89.js";import{S as ys,i as js,g as l,s as o,u as c,A as Ts,h as n,f as s,c as i,j as h,v as d,y as m,k as p,o as r,a,w as u,d as g,t as w,x as J}from"../chunks/index.9633332f.js";import{I as rt}from"../chunks/IconCopyLink.a4acffac.js";import{C as st}from"../chunks/CodeBlock.00597c71.js";function fs(At){let M,ht,et,mt,y,v,at,$,Qt,D,Ht="HRNet",ct,Z,zt="<strong>HRNet</strong>, or <strong>High-Resolution Net</strong>, is a general purpose convolutional neural network for tasks like semantic segmentation, object detection and image classification. It is able to maintain high resolution representations through the whole process. We start from a high-resolution convolution stream, gradually add high-to-low resolution convolution streams one by one, and connect the multi-resolution streams in parallel. The resulting network consists of several ($4$ in the paper) stages and the $n$th stage contains $n$ streams corresponding to $n$ resolutions. The authors conduct repeated multi-resolution fusions by exchanging the information across the parallel streams over and over.",dt,j,I,lt,x,Vt,q,Ft="How do I use this model on an image?",ut,W,Pt="To load a pretrained model:",gt,B,wt,N,Lt="To load and preprocess the image:",Jt,E,Mt,_,Dt="To get the model predictions:",yt,G,jt,R,qt="To get the top-5 predictions class names:",Tt,Q,ft,V,Kt="Replace the model name with the variant you want to use, e.g. <code>hrnet_w18</code>. You can find the IDs in the model summaries at the top of this page.",bt,X,Ot='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',vt,T,U,nt,S,Xt,K,ts="How do I finetune this model?",It,Y,ss="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Ut,A,kt,H,es=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Ct,f,k,ot,z,St,O,as="How do I train this model?",$t,F,ls='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',Zt,b,C,it,P,Yt,tt,ns="Citation",xt,L,Wt,pt,Bt;return $=new rt({}),x=new rt({}),B=new st({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2hybmV0X3cxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),E=new st({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),G=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),Q=new st({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),S=new rt({}),A=new st({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnaHJuZXRfdzE4JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;hrnet_w18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),z=new rt({}),P=new rt({}),L=new st({props:{code:"JTQwbWlzYyU3QnN1bjIwMTloaWdocmVzb2x1dGlvbiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCSGlnaC1SZXNvbHV0aW9uJTIwUmVwcmVzZW50YXRpb25zJTIwZm9yJTIwTGFiZWxpbmclMjBQaXhlbHMlMjBhbmQlMjBSZWdpb25zJTdEJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXV0aG9yJTNEJTdCS2UlMjBTdW4lMjBhbmQlMjBZYW5nJTIwWmhhbyUyMGFuZCUyMEJvcnVpJTIwSmlhbmclMjBhbmQlMjBUaWFuaGVuZyUyMENoZW5nJTIwYW5kJTIwQmluJTIwWGlhbyUyMGFuZCUyMERvbmclMjBMaXUlMjBhbmQlMjBZYWRvbmclMjBNdSUyMGFuZCUyMFhpbmdnYW5nJTIwV2FuZyUyMGFuZCUyMFdlbnl1JTIwTGl1JTIwYW5kJTIwSmluZ2RvbmclMjBXYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTA0LjA0NTE0JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{sun2019highresolution,
      title={High-Resolution Representations for Labeling Pixels <span class="hljs-keyword">and </span>Regions}, 
      author={Ke Sun <span class="hljs-keyword">and </span>Yang Zhao <span class="hljs-keyword">and </span><span class="hljs-keyword">Borui </span><span class="hljs-keyword">Jiang </span><span class="hljs-keyword">and </span>Tianheng Cheng <span class="hljs-keyword">and </span><span class="hljs-keyword">Bin </span>Xiao <span class="hljs-keyword">and </span>Dong Liu <span class="hljs-keyword">and </span>Yadong Mu <span class="hljs-keyword">and </span>Xinggang Wang <span class="hljs-keyword">and </span>Wenyu Liu <span class="hljs-keyword">and </span><span class="hljs-keyword">Jingdong </span>Wang},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1904</span>.<span class="hljs-number">04514</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`}}),{c(){M=l("meta"),ht=o(),et=l("p"),mt=o(),y=l("h1"),v=l("a"),at=l("span"),c($.$$.fragment),Qt=o(),D=l("span"),D.textContent=Ht,ct=o(),Z=l("p"),Z.innerHTML=zt,dt=o(),j=l("h2"),I=l("a"),lt=l("span"),c(x.$$.fragment),Vt=o(),q=l("span"),q.textContent=Ft,ut=o(),W=l("p"),W.textContent=Pt,gt=o(),c(B.$$.fragment),wt=o(),N=l("p"),N.textContent=Lt,Jt=o(),c(E.$$.fragment),Mt=o(),_=l("p"),_.textContent=Dt,yt=o(),c(G.$$.fragment),jt=o(),R=l("p"),R.textContent=qt,Tt=o(),c(Q.$$.fragment),ft=o(),V=l("p"),V.innerHTML=Kt,bt=o(),X=l("p"),X.innerHTML=Ot,vt=o(),T=l("h2"),U=l("a"),nt=l("span"),c(S.$$.fragment),Xt=o(),K=l("span"),K.textContent=ts,It=o(),Y=l("p"),Y.textContent=ss,Ut=o(),c(A.$$.fragment),kt=o(),H=l("p"),H.innerHTML=es,Ct=o(),f=l("h2"),k=l("a"),ot=l("span"),c(z.$$.fragment),St=o(),O=l("span"),O.textContent=as,$t=o(),F=l("p"),F.innerHTML=ls,Zt=o(),b=l("h2"),C=l("a"),it=l("span"),c(P.$$.fragment),Yt=o(),tt=l("span"),tt.textContent=ns,xt=o(),c(L.$$.fragment),Wt=o(),pt=l("p"),this.h()},l(t){const e=Ts("svelte-1phssyn",document.head);M=n(e,"META",{name:!0,content:!0}),e.forEach(s),ht=i(t),et=n(t,"P",{}),h(et).forEach(s),mt=i(t),y=n(t,"H1",{class:!0});var Nt=h(y);v=n(Nt,"A",{id:!0,class:!0,href:!0});var os=h(v);at=n(os,"SPAN",{});var is=h(at);d($.$$.fragment,is),is.forEach(s),os.forEach(s),Qt=i(Nt),D=n(Nt,"SPAN",{"data-svelte-h":!0}),m(D)!=="svelte-ho8rba"&&(D.textContent=Ht),Nt.forEach(s),ct=i(t),Z=n(t,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-yej87l"&&(Z.innerHTML=zt),dt=i(t),j=n(t,"H2",{class:!0});var Et=h(j);I=n(Et,"A",{id:!0,class:!0,href:!0});var ps=h(I);lt=n(ps,"SPAN",{});var rs=h(lt);d(x.$$.fragment,rs),rs.forEach(s),ps.forEach(s),Vt=i(Et),q=n(Et,"SPAN",{"data-svelte-h":!0}),m(q)!=="svelte-1c1hspn"&&(q.textContent=Ft),Et.forEach(s),ut=i(t),W=n(t,"P",{"data-svelte-h":!0}),m(W)!=="svelte-18ywhxh"&&(W.textContent=Pt),gt=i(t),d(B.$$.fragment,t),wt=i(t),N=n(t,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1c2ipa8"&&(N.textContent=Lt),Jt=i(t),d(E.$$.fragment,t),Mt=i(t),_=n(t,"P",{"data-svelte-h":!0}),m(_)!=="svelte-1n9qsq1"&&(_.textContent=Dt),yt=i(t),d(G.$$.fragment,t),jt=i(t),R=n(t,"P",{"data-svelte-h":!0}),m(R)!=="svelte-19cnvx1"&&(R.textContent=qt),Tt=i(t),d(Q.$$.fragment,t),ft=i(t),V=n(t,"P",{"data-svelte-h":!0}),m(V)!=="svelte-17maku0"&&(V.innerHTML=Kt),bt=i(t),X=n(t,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1wmi3ea"&&(X.innerHTML=Ot),vt=i(t),T=n(t,"H2",{class:!0});var _t=h(T);U=n(_t,"A",{id:!0,class:!0,href:!0});var hs=h(U);nt=n(hs,"SPAN",{});var ms=h(nt);d(S.$$.fragment,ms),ms.forEach(s),hs.forEach(s),Xt=i(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),m(K)!=="svelte-1viv4qv"&&(K.textContent=ts),_t.forEach(s),It=i(t),Y=n(t,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-9sr7nh"&&(Y.textContent=ss),Ut=i(t),d(A.$$.fragment,t),kt=i(t),H=n(t,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1kguc51"&&(H.innerHTML=es),Ct=i(t),f=n(t,"H2",{class:!0});var Gt=h(f);k=n(Gt,"A",{id:!0,class:!0,href:!0});var cs=h(k);ot=n(cs,"SPAN",{});var ds=h(ot);d(z.$$.fragment,ds),ds.forEach(s),cs.forEach(s),St=i(Gt),O=n(Gt,"SPAN",{"data-svelte-h":!0}),m(O)!=="svelte-1ce591d"&&(O.textContent=as),Gt.forEach(s),$t=i(t),F=n(t,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1n0coha"&&(F.innerHTML=ls),Zt=i(t),b=n(t,"H2",{class:!0});var Rt=h(b);C=n(Rt,"A",{id:!0,class:!0,href:!0});var us=h(C);it=n(us,"SPAN",{});var gs=h(it);d(P.$$.fragment,gs),gs.forEach(s),us.forEach(s),Yt=i(Rt),tt=n(Rt,"SPAN",{"data-svelte-h":!0}),m(tt)!=="svelte-15mb3gy"&&(tt.textContent=ns),Rt.forEach(s),xt=i(t),d(L.$$.fragment,t),Wt=i(t),pt=n(t,"P",{}),h(pt).forEach(s),this.h()},h(){p(M,"name","hf:doc:metadata"),p(M,"content",JSON.stringify(bs)),p(v,"id","hrnet"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#hrnet"),p(y,"class","relative group"),p(I,"id","how-do-i-use-this-model-on-an-image"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#how-do-i-use-this-model-on-an-image"),p(j,"class","relative group"),p(U,"id","how-do-i-finetune-this-model"),p(U,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(U,"href","#how-do-i-finetune-this-model"),p(T,"class","relative group"),p(k,"id","how-do-i-train-this-model"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#how-do-i-train-this-model"),p(f,"class","relative group"),p(C,"id","citation"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#citation"),p(b,"class","relative group")},m(t,e){r(document.head,M),a(t,ht,e),a(t,et,e),a(t,mt,e),a(t,y,e),r(y,v),r(v,at),u($,at,null),r(y,Qt),r(y,D),a(t,ct,e),a(t,Z,e),a(t,dt,e),a(t,j,e),r(j,I),r(I,lt),u(x,lt,null),r(j,Vt),r(j,q),a(t,ut,e),a(t,W,e),a(t,gt,e),u(B,t,e),a(t,wt,e),a(t,N,e),a(t,Jt,e),u(E,t,e),a(t,Mt,e),a(t,_,e),a(t,yt,e),u(G,t,e),a(t,jt,e),a(t,R,e),a(t,Tt,e),u(Q,t,e),a(t,ft,e),a(t,V,e),a(t,bt,e),a(t,X,e),a(t,vt,e),a(t,T,e),r(T,U),r(U,nt),u(S,nt,null),r(T,Xt),r(T,K),a(t,It,e),a(t,Y,e),a(t,Ut,e),u(A,t,e),a(t,kt,e),a(t,H,e),a(t,Ct,e),a(t,f,e),r(f,k),r(k,ot),u(z,ot,null),r(f,St),r(f,O),a(t,$t,e),a(t,F,e),a(t,Zt,e),a(t,b,e),r(b,C),r(C,it),u(P,it,null),r(b,Yt),r(b,tt),a(t,xt,e),u(L,t,e),a(t,Wt,e),a(t,pt,e),Bt=!0},p:Js,i(t){Bt||(g($.$$.fragment,t),g(x.$$.fragment,t),g(B.$$.fragment,t),g(E.$$.fragment,t),g(G.$$.fragment,t),g(Q.$$.fragment,t),g(S.$$.fragment,t),g(A.$$.fragment,t),g(z.$$.fragment,t),g(P.$$.fragment,t),g(L.$$.fragment,t),Bt=!0)},o(t){w($.$$.fragment,t),w(x.$$.fragment,t),w(B.$$.fragment,t),w(E.$$.fragment,t),w(G.$$.fragment,t),w(Q.$$.fragment,t),w(S.$$.fragment,t),w(A.$$.fragment,t),w(z.$$.fragment,t),w(P.$$.fragment,t),w(L.$$.fragment,t),Bt=!1},d(t){t&&(s(ht),s(et),s(mt),s(y),s(ct),s(Z),s(dt),s(j),s(ut),s(W),s(gt),s(wt),s(N),s(Jt),s(Mt),s(_),s(yt),s(jt),s(R),s(Tt),s(ft),s(V),s(bt),s(X),s(vt),s(T),s(It),s(Y),s(Ut),s(kt),s(H),s(Ct),s(f),s($t),s(F),s(Zt),s(b),s(xt),s(Wt),s(pt)),s(M),J($),J(x),J(B,t),J(E,t),J(G,t),J(Q,t),J(S),J(A,t),J(z),J(P),J(L,t)}}}const bs={local:"hrnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"HRNet"};function vs(At){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $s extends ys{constructor(M){super(),js(this,M,vs,fs,ws,{})}}export{$s as component};
