import{s as Fe,n as Qe,o as Pe}from"../chunks/scheduler.9bc65507.js";import{S as Ke,i as qe,g as p,s as l,r as J,A as Ae,h as i,f as t,c as n,j as Xe,u as m,x as o,k as Ue,y as Oe,a,v as r,d as w,t as T,w as c}from"../chunks/index.707bf1b6.js";import{C as u}from"../chunks/CodeBlock.54a9f38d.js";import{D as es}from"../chunks/DocNotebookDropdown.3e6b3817.js";import{H as ss}from"../chunks/Heading.342b1fa6.js";function ts(ke){let h,P,F,K,M,q,I,A,b,Ve="Image-to-Image task is the task where an application receives an image and outputs another image. This has various subtasks, including image enhancement (super resolution, low light enhancement, deraining and so on), image inpainting, and more.",O,y,We="This guide will show you how to:",ee,f,Ze="<li>Use an image-to-image pipeline for super resolution task,</li> <li>Run image-to-image models for same task without a pipeline.</li>",se,j,xe="Note that as of the time this guide is released, <code>image-to-image</code> pipeline only supports super resolution task.",te,$,Ne="Let’s begin by installing the necessary libraries.",ae,v,le,C,De='We can now initialize the pipeline with a <a href="https://huggingface.co/caidas/swin2SR-lightweight-x2-64" rel="nofollow">Swin2SR model</a>. We can then infer with the pipeline by calling it with an image. As of now, only <a href="https://huggingface.co/models?sort=trending&amp;search=swin2sr" rel="nofollow">Swin2SR models</a> are supported in this pipeline.',ne,U,pe,k,_e="Now, let’s load an image.",ie,V,oe,W,Je,g,ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg" alt="Photo of a cat"/>',me,Z,Ge="We can now do inference with the pipeline. We will get an upscaled version of the cat image.",re,x,we,N,Te,D,Se="If you wish to do inference yourself with no pipeline, you can use the <code>Swin2SRForImageSuperResolution</code> and <code>Swin2SRImageProcessor</code> classes of transformers. We will use the same model checkpoint for this. Let’s initialize the model and the processor.",ce,_,ue,z,Re="<code>pipeline</code> abstracts away the preprocessing and postprocessing steps that we have to do ourselves, so let’s preprocess the image. We will pass the image to the processor and then move the pixel values to GPU.",he,G,ge,S,Be="We can now infer the image by passing pixel values to the model.",de,R,Me,B,He="Output is an object of type <code>ImageSuperResolutionOutput</code> that looks like below 👇",Ie,H,be,Y,Ye="We need to get the <code>reconstruction</code> and post-process it for visualization. Let’s see how it looks like.",ye,L,fe,E,Le="We need to squeeze the output and get rid of axis 0, clip the values, then convert it to be numpy float. Then we will arrange axes to have the shape [1072, 880], and finally, bring the output back to range [0, 255].",je,X,$e,d,Ee='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat_upscaled.png" alt="Upscaled photo of a cat"/>',ve,Q,Ce;return M=new ss({props:{title:"Image-to-Image Task Guide",local:"image-to-image-task-guide",headingTag:"h1"}}),I=new es({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_to_image.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_to_image.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_to_image.ipynb"}]}}),v=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),U=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdjdWRhJyUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAnY3B1JyklMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXRvLWltYWdlJTIyJTJDJTIwbW9kZWwlM0QlMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyJTJDJTIwZGV2aWNlJTNEZGV2aWNlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

device = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-to-image&quot;</span>, model=<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>, device=device)`,wrap:!1}}),V=new u({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmNhdC5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmludChpbWFnZS5zaXplKQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/cat.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-built_in">print</span>(image.size)`,wrap:!1}}),W=new u({props:{code:"JTIzJTIwKDUzMiUyQyUyMDQzMik=",highlighted:'<span class="hljs-comment"># (532, 432)</span>',wrap:!1}}),x=new u({props:{code:"dXBzY2FsZWQlMjAlM0QlMjBwaXBlKGltYWdlKSUwQXByaW50KHVwc2NhbGVkLnNpemUp",highlighted:`upscaled = pipe(image)
<span class="hljs-built_in">print</span>(upscaled.size)`,wrap:!1}}),N=new u({props:{code:"JTIzJTIwKDEwNzIlMkMlMjA4ODAp",highlighted:'<span class="hljs-comment"># (1072, 880)</span>',wrap:!1}}),_=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFN3aW4yU1JGb3JJbWFnZVN1cGVyUmVzb2x1dGlvbiUyQyUyMFN3aW4yU1JJbWFnZVByb2Nlc3NvciUyMCUwQSUwQW1vZGVsJTIwJTNEJTIwU3dpbjJTUkZvckltYWdlU3VwZXJSZXNvbHV0aW9uLmZyb21fcHJldHJhaW5lZCglMjJjYWlkYXMlMkZzd2luMlNSLWxpZ2h0d2VpZ2h0LXgyLTY0JTIyKS50byhkZXZpY2UpJTBBcHJvY2Vzc29yJTIwJTNEJTIwU3dpbjJTUkltYWdlUHJvY2Vzc29yKCUyMmNhaWRhcyUyRnN3aW4yU1ItbGlnaHR3ZWlnaHQteDItNjQlMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Swin2SRForImageSuperResolution, Swin2SRImageProcessor 

model = Swin2SRForImageSuperResolution.from_pretrained(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>).to(device)
processor = Swin2SRImageProcessor(<span class="hljs-string">&quot;caidas/swin2SR-lightweight-x2-64&quot;</span>)`,wrap:!1}}),G=new u({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVzJTBBcHJpbnQocGl4ZWxfdmFsdWVzLnNoYXBlKSUwQSUwQXBpeGVsX3ZhbHVlcyUyMCUzRCUyMHBpeGVsX3ZhbHVlcy50byhkZXZpY2Up",highlighted:`pixel_values = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-built_in">print</span>(pixel_values.shape)

pixel_values = pixel_values.to(device)`,wrap:!1}}),R=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyk=",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">with</span> torch.no_grad():
  outputs = model(pixel_values)`,wrap:!1}}),H=new u({props:{code:"KGxvc3MlM0ROb25lJTJDJTIwcmVjb25zdHJ1Y3Rpb24lM0R0ZW5zb3IoJTVCJTVCJTVCJTVCMC44MjcwJTJDJTIwMC44MjY5JTJDJTIwMC44Mjc1JTJDJTIwJTIwLi4uJTJDJTIwMC43NDYzJTJDJTIwMC43NDQ2JTJDJTIwMC43NDUzJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44Mjg3JTJDJTIwMC44Mjc4JTJDJTIwMC44MjgzJTJDJTIwJTIwLi4uJTJDJTIwMC43NDUxJTJDJTIwMC43NDQ4JTJDJTIwMC43NDU3JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC44MjgwJTJDJTIwMC44MjczJTJDJTIwMC44MjY5JTJDJTIwJTIwLi4uJTJDJTIwMC43NDQ3JTJDJTIwMC43NDQ2JTJDJTIwMC43NDUyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTIzJTJDJTIwMC41OTMzJTJDJTIwMC41OTI0JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjk3JTJDJTIwMC4wNjk1JTJDJTIwMC4wNzA2JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI2JTJDJTIwMC41OTMyJTJDJTIwMC41OTI2JTJDJTIwJTIwLi4uJTJDJTIwMC4wNjczJTJDJTIwMC4wNjg3JTJDJTIwMC4wNzA1JTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCMC41OTI3JTJDJTIwMC41OTE0JTJDJTIwMC41OTIyJTJDJTIwJTIwLi4uJTJDJTIwMC4wNjY0JTJDJTIwMC4wNjk0JTJDJTIwMC4wNzE4JTVEJTVEJTVEJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGV2aWNlJTNEJ2N1ZGElM0EwJyklMkMlMjBoaWRkZW5fc3RhdGVzJTNETm9uZSUyQyUyMGF0dGVudGlvbnMlM0ROb25lKQ==",highlighted:`(<span class="hljs-name">loss=None</span>, reconstruction=tensor([[[[<span class="hljs-name">0.8270</span>, <span class="hljs-number">0.8269</span>, <span class="hljs-number">0.8275</span>,  ..., <span class="hljs-number">0.7463</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7453</span>],
          [<span class="hljs-name">0.8287</span>, <span class="hljs-number">0.8278</span>, <span class="hljs-number">0.8283</span>,  ..., <span class="hljs-number">0.7451</span>, <span class="hljs-number">0.7448</span>, <span class="hljs-number">0.7457</span>],
          [<span class="hljs-name">0.8280</span>, <span class="hljs-number">0.8273</span>, <span class="hljs-number">0.8269</span>,  ..., <span class="hljs-number">0.7447</span>, <span class="hljs-number">0.7446</span>, <span class="hljs-number">0.7452</span>],
          ...,
          [<span class="hljs-name">0.5923</span>, <span class="hljs-number">0.5933</span>, <span class="hljs-number">0.5924</span>,  ..., <span class="hljs-number">0.0697</span>, <span class="hljs-number">0.0695</span>, <span class="hljs-number">0.0706</span>],
          [<span class="hljs-name">0.5926</span>, <span class="hljs-number">0.5932</span>, <span class="hljs-number">0.5926</span>,  ..., <span class="hljs-number">0.0673</span>, <span class="hljs-number">0.0687</span>, <span class="hljs-number">0.0705</span>],
          [<span class="hljs-name">0.5927</span>, <span class="hljs-number">0.5914</span>, <span class="hljs-number">0.5922</span>,  ..., <span class="hljs-number">0.0664</span>, <span class="hljs-number">0.0694</span>, <span class="hljs-number">0.0718</span>]]]],
       device=<span class="hljs-symbol">&#x27;cuda:0</span>&#x27;), hidden_states=None, attentions=None)`,wrap:!1}}),L=new u({props:{code:"b3V0cHV0cy5yZWNvbnN0cnVjdGlvbi5kYXRhLnNoYXBlJTBBJTIzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDg4MCUyQyUyMDEwNzIlNUQp",highlighted:`outputs.reconstruction.data.shape
<span class="hljs-comment"># torch.Size([1, 3, 880, 1072])</span>`,wrap:!1}}),X=new u({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwc3F1ZWV6ZSUyQyUyMHRha2UlMjB0byUyMENQVSUyMGFuZCUyMGNsaXAlMjB0aGUlMjB2YWx1ZXMlMEFvdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnJlY29uc3RydWN0aW9uLmRhdGEuc3F1ZWV6ZSgpLmNwdSgpLmNsYW1wXygwJTJDJTIwMSkubnVtcHkoKSUwQSUyMyUyMHJlYXJyYW5nZSUyMHRoZSUyMGF4ZXMlMEFvdXRwdXQlMjAlM0QlMjBucC5tb3ZlYXhpcyhvdXRwdXQlMkMlMjBzb3VyY2UlM0QwJTJDJTIwZGVzdGluYXRpb24lM0QtMSklMEElMjMlMjBicmluZyUyMHZhbHVlcyUyMGJhY2slMjB0byUyMHBpeGVsJTIwdmFsdWVzJTIwcmFuZ2UlMEFvdXRwdXQlMjAlM0QlMjAob3V0cHV0JTIwKiUyMDI1NS4wKS5yb3VuZCgpLmFzdHlwZShucC51aW50OCklMEFJbWFnZS5mcm9tYXJyYXkob3V0cHV0KQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-comment"># squeeze, take to CPU and clip the values</span>
output = outputs.reconstruction.data.squeeze().cpu().clamp_(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>).numpy()
<span class="hljs-comment"># rearrange the axes</span>
output = np.moveaxis(output, source=<span class="hljs-number">0</span>, destination=-<span class="hljs-number">1</span>)
<span class="hljs-comment"># bring values back to pixel values range</span>
output = (output * <span class="hljs-number">255.0</span>).<span class="hljs-built_in">round</span>().astype(np.uint8)
Image.fromarray(output)`,wrap:!1}}),{c(){h=p("meta"),P=l(),F=p("p"),K=l(),J(M.$$.fragment),q=l(),J(I.$$.fragment),A=l(),b=p("p"),b.textContent=Ve,O=l(),y=p("p"),y.textContent=We,ee=l(),f=p("ul"),f.innerHTML=Ze,se=l(),j=p("p"),j.innerHTML=xe,te=l(),$=p("p"),$.textContent=Ne,ae=l(),J(v.$$.fragment),le=l(),C=p("p"),C.innerHTML=De,ne=l(),J(U.$$.fragment),pe=l(),k=p("p"),k.textContent=_e,ie=l(),J(V.$$.fragment),oe=l(),J(W.$$.fragment),Je=l(),g=p("div"),g.innerHTML=ze,me=l(),Z=p("p"),Z.textContent=Ge,re=l(),J(x.$$.fragment),we=l(),J(N.$$.fragment),Te=l(),D=p("p"),D.innerHTML=Se,ce=l(),J(_.$$.fragment),ue=l(),z=p("p"),z.innerHTML=Re,he=l(),J(G.$$.fragment),ge=l(),S=p("p"),S.textContent=Be,de=l(),J(R.$$.fragment),Me=l(),B=p("p"),B.innerHTML=He,Ie=l(),J(H.$$.fragment),be=l(),Y=p("p"),Y.innerHTML=Ye,ye=l(),J(L.$$.fragment),fe=l(),E=p("p"),E.textContent=Le,je=l(),J(X.$$.fragment),$e=l(),d=p("div"),d.innerHTML=Ee,ve=l(),Q=p("p"),this.h()},l(e){const s=Ae("svelte-u9bgzb",document.head);h=i(s,"META",{name:!0,content:!0}),s.forEach(t),P=n(e),F=i(e,"P",{}),Xe(F).forEach(t),K=n(e),m(M.$$.fragment,e),q=n(e),m(I.$$.fragment,e),A=n(e),b=i(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1m5ab0h"&&(b.textContent=Ve),O=n(e),y=i(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1aff4p7"&&(y.textContent=We),ee=n(e),f=i(e,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-1dytd0b"&&(f.innerHTML=Ze),se=n(e),j=i(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-j21dpj"&&(j.innerHTML=xe),te=n(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-2ffb0z"&&($.textContent=Ne),ae=n(e),m(v.$$.fragment,e),le=n(e),C=i(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-6x8yac"&&(C.innerHTML=De),ne=n(e),m(U.$$.fragment,e),pe=n(e),k=i(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-dx2hkj"&&(k.textContent=_e),ie=n(e),m(V.$$.fragment,e),oe=n(e),m(W.$$.fragment,e),Je=n(e),g=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-muvbux"&&(g.innerHTML=ze),me=n(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-jehike"&&(Z.textContent=Ge),re=n(e),m(x.$$.fragment,e),we=n(e),m(N.$$.fragment,e),Te=n(e),D=i(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-7mqp02"&&(D.innerHTML=Se),ce=n(e),m(_.$$.fragment,e),ue=n(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-cwlggi"&&(z.innerHTML=Re),he=n(e),m(G.$$.fragment,e),ge=n(e),S=i(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-z8yxu1"&&(S.textContent=Be),de=n(e),m(R.$$.fragment,e),Me=n(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-yf1rhn"&&(B.innerHTML=He),Ie=n(e),m(H.$$.fragment,e),be=n(e),Y=i(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-nzl4n2"&&(Y.innerHTML=Ye),ye=n(e),m(L.$$.fragment,e),fe=n(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-z07gu"&&(E.textContent=Le),je=n(e),m(X.$$.fragment,e),$e=n(e),d=i(e,"DIV",{class:!0,"data-svelte-h":!0}),o(d)!=="svelte-1u1oaeg"&&(d.innerHTML=Ee),ve=n(e),Q=i(e,"P",{}),Xe(Q).forEach(t),this.h()},h(){Ue(h,"name","hf:doc:metadata"),Ue(h,"content",as),Ue(g,"class","flex justify-center"),Ue(d,"class","flex justify-center")},m(e,s){Oe(document.head,h),a(e,P,s),a(e,F,s),a(e,K,s),r(M,e,s),a(e,q,s),r(I,e,s),a(e,A,s),a(e,b,s),a(e,O,s),a(e,y,s),a(e,ee,s),a(e,f,s),a(e,se,s),a(e,j,s),a(e,te,s),a(e,$,s),a(e,ae,s),r(v,e,s),a(e,le,s),a(e,C,s),a(e,ne,s),r(U,e,s),a(e,pe,s),a(e,k,s),a(e,ie,s),r(V,e,s),a(e,oe,s),r(W,e,s),a(e,Je,s),a(e,g,s),a(e,me,s),a(e,Z,s),a(e,re,s),r(x,e,s),a(e,we,s),r(N,e,s),a(e,Te,s),a(e,D,s),a(e,ce,s),r(_,e,s),a(e,ue,s),a(e,z,s),a(e,he,s),r(G,e,s),a(e,ge,s),a(e,S,s),a(e,de,s),r(R,e,s),a(e,Me,s),a(e,B,s),a(e,Ie,s),r(H,e,s),a(e,be,s),a(e,Y,s),a(e,ye,s),r(L,e,s),a(e,fe,s),a(e,E,s),a(e,je,s),r(X,e,s),a(e,$e,s),a(e,d,s),a(e,ve,s),a(e,Q,s),Ce=!0},p:Qe,i(e){Ce||(w(M.$$.fragment,e),w(I.$$.fragment,e),w(v.$$.fragment,e),w(U.$$.fragment,e),w(V.$$.fragment,e),w(W.$$.fragment,e),w(x.$$.fragment,e),w(N.$$.fragment,e),w(_.$$.fragment,e),w(G.$$.fragment,e),w(R.$$.fragment,e),w(H.$$.fragment,e),w(L.$$.fragment,e),w(X.$$.fragment,e),Ce=!0)},o(e){T(M.$$.fragment,e),T(I.$$.fragment,e),T(v.$$.fragment,e),T(U.$$.fragment,e),T(V.$$.fragment,e),T(W.$$.fragment,e),T(x.$$.fragment,e),T(N.$$.fragment,e),T(_.$$.fragment,e),T(G.$$.fragment,e),T(R.$$.fragment,e),T(H.$$.fragment,e),T(L.$$.fragment,e),T(X.$$.fragment,e),Ce=!1},d(e){e&&(t(P),t(F),t(K),t(q),t(A),t(b),t(O),t(y),t(ee),t(f),t(se),t(j),t(te),t($),t(ae),t(le),t(C),t(ne),t(pe),t(k),t(ie),t(oe),t(Je),t(g),t(me),t(Z),t(re),t(we),t(Te),t(D),t(ce),t(ue),t(z),t(he),t(ge),t(S),t(de),t(Me),t(B),t(Ie),t(be),t(Y),t(ye),t(fe),t(E),t(je),t($e),t(d),t(ve),t(Q)),t(h),c(M,e),c(I,e),c(v,e),c(U,e),c(V,e),c(W,e),c(x,e),c(N,e),c(_,e),c(G,e),c(R,e),c(H,e),c(L,e),c(X,e)}}}const as='{"title":"Image-to-Image Task Guide","local":"image-to-image-task-guide","sections":[],"depth":1}';function ls(ke){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ms extends Ke{constructor(h){super(),qe(this,h,ls,ts,Fe,{})}}export{ms as component};
