import{s as Qt,o as zt,n as At}from"../chunks/scheduler.182ea377.js";import{S as Lt,i as Ft,g as i,s as a,p as f,A as Yt,h as n,f as l,c as o,j as J,q as m,m as r,k as c,v as u,a as s,r as h,d as w,t as y,u as M}from"../chunks/index.008d68e4.js";import{T as Pt}from"../chunks/Tip.4f096367.js";import{I as Ie}from"../chunks/IconCopyLink.96bbb92b.js";import{C as v}from"../chunks/CodeBlock.5ed6eb7b.js";function Dt(de){let p,b='💡 Take a look at GitHub Issue <a href="https://github.com/huggingface/diffusers/issues/841" rel="nofollow">#841</a> for more context about why we’re adding community pipelines to help everyone easily share their work without being slowed down.';return{c(){p=i("p"),p.innerHTML=b},l(d){p=n(d,"P",{"data-svelte-h":!0}),r(p)!=="svelte-19wo1pm"&&(p.innerHTML=b)},m(d,T){s(d,p,T)},p:At,d(d){d&&l(p)}}}function qt(de){let p,b="💡 You can use whatever package you want in your community pipeline file - as long as the user has it installed, everything will work fine. Make sure you have one and only one pipeline class that inherits from <code>DiffusionPipeline</code> because this is automatically detected.";return{c(){p=i("p"),p.innerHTML=b},l(d){p=n(d,"P",{"data-svelte-h":!0}),r(p)!=="svelte-143wzg5"&&(p.innerHTML=b)},m(d,T){s(d,p,T)},p:At,d(d){d&&l(p)}}}function Kt(de){let p,b,d,T,ye,$,ot,ue,ut="Contribute a community pipeline",Ze,j,_e,k,ft='Community pipelines allow you to add any additional features you’d like on top of the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. The main benefit of building on top of the <code>DiffusionPipeline</code> is anyone can load and use your pipeline by only adding one more argument, making it super easy for the community to access.',ve,W,mt="This guide will show you how to create a community pipeline and explain how they work. To keep things simple, you’ll create a “one-step” pipeline where the <code>UNet</code> does a single forward pass and calls the scheduler once.",je,U,G,Me,X,pt,fe,ht="Initialize the pipeline",Ge,H,wt='You should start by creating a <code>one_step_unet.py</code> file for your community pipeline. In this file, create a pipeline class that inherits from the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to be able to load model weights and the scheduler configuration from the Hub. The one-step pipeline needs a <code>UNet</code> and a scheduler, so you’ll need to add these as arguments to the <code>__init__</code> function:',Ve,N,ge,R,yt='To ensure your pipeline and its components (<code>unet</code> and <code>scheduler</code>) can be saved with <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>, add them to the <code>register_modules</code> function:',Ce,x,Be,E,Mt="Cool, the <code>__init__</code> step is done and you can move to the forward pass now! 🔥",$e,I,V,Je,S,rt,me,Jt="Define the forward pass",ke,P,Tt="In the forward pass, which we recommend defining as <code>__call__</code>, you have complete creative freedom to add whatever feature you’d like. For our amazing one-step pipeline, create a random image and only call the <code>unet</code> and <code>scheduler</code> once by setting <code>timestep=1</code>:",We,A,Xe,Q,bt="That’s it! 🚀 You can now run this pipeline by passing a <code>unet</code> and <code>scheduler</code> to it:",He,z,Ne,L,Ut='But what’s even better is you can load pre-existing weights into the pipeline if the pipeline structure is identical. For example, you can load the <a href="https://huggingface.co/google/ddpm-cifar10-32" rel="nofollow"><code>google/ddpm-cifar10-32</code></a> weights into the one-step pipeline:',Re,F,xe,Z,g,Te,Y,ct,he,It="Share your pipeline",Ee,D,Zt='Open a Pull Request on the 🧨 Diffusers <a href="https://github.com/huggingface/diffusers" rel="nofollow">repository</a> to add your awesome pipeline in <code>one_step_unet.py</code> to the <a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">examples/community</a> subfolder.',Se,q,_t="Once it is merged, anyone with <code>diffusers &gt;= 0.4.0</code> installed can use this pipeline magically 🪄 by specifying it in the <code>custom_pipeline</code> argument:",Pe,K,Ae,O,vt='Another way to share your community pipeline is to upload the <code>one_step_unet.py</code> file directly to your preferred <a href="https://huggingface.co/docs/hub/models-uploading" rel="nofollow">model repository</a> on the Hub. Instead of specifying the <code>one_step_unet.py</code> file, pass the model repository id to the <code>custom_pipeline</code> argument:',Qe,ee,ze,te,jt="Take a look at the following table to compare the two sharing workflows to help you decide the best option for you:",Le,le,Gt="<thead><tr><th></th> <th>GitHub community pipeline</th> <th>HF Hub community pipeline</th></tr></thead> <tbody><tr><td>usage</td> <td>same</td> <td>same</td></tr> <tr><td>review process</td> <td>open a Pull Request on GitHub and undergo a review process from the Diffusers team before merging; may be slower</td> <td>upload directly to a Hub repository without any review; this is the fastest workflow</td></tr> <tr><td>visibility</td> <td>included in the official Diffusers repository and documentation</td> <td>included on your HF Hub profile and relies on your own usage/promotion to gain visibility</td></tr></tbody>",Fe,C,Ye,_,B,be,se,dt,we,Vt="How do community pipelines work?",De,ie,gt='A community pipeline is a class that inherits from <a href="/docs/diffusers/v0.25.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> which means:',qe,ne,Ct="<li>It can be loaded with the <code>custom_pipeline</code> argument.</li> <li>The model weights and scheduler configuration are loaded from <code>pretrained_model_name_or_path</code>.</li> <li>The code that implements a feature in the community pipeline is defined in a <code>pipeline.py</code> file.</li>",Ke,ae,Bt="Sometimes you can’t load all the pipeline components weights from an official repository. In this case, the other components should be passed directly to the pipeline:",Oe,oe,et,pe,$t="The magic behind community pipelines is contained in the following code. It allows the community pipeline to be loaded from GitHub or the Hub, and it’ll be available to all 🧨 Diffusers packages.",tt,re,lt;return $=new Ie({}),j=new Pt({props:{$$slots:{default:[Dt]},$$scope:{ctx:de}}}),X=new Ie({}),N=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">class</span> <span class="hljs-title class_">UnetSchedulerOneForwardPipeline</span>(<span class="hljs-title class_ inherited__">DiffusionPipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, unet, scheduler</span>):
        <span class="hljs-built_in">super</span>().__init__()`}}),x=new v({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKQ==",highlighted:`  from diffusers import DiffusionPipeline
  import torch

  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

<span class="hljs-addition">+         self.register_modules(unet=unet, scheduler=scheduler)</span>`}}),S=new Ie({}),A=new v({props:{code:"JTIwJTIwZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTIwJTIwaW1wb3J0JTIwdG9yY2glMEElMEElMjAlMjBjbGFzcyUyMFVuZXRTY2hlZHVsZXJPbmVGb3J3YXJkUGlwZWxpbmUoRGlmZnVzaW9uUGlwZWxpbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMHVuZXQlMkMlMjBzY2hlZHVsZXIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXygpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5yZWdpc3Rlcl9tb2R1bGVzKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQSUyQiUyMCUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYpJTNBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjB0b3JjaC5yYW5kbiglMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoMSUyQyUyMHNlbGYudW5ldC5jb25maWcuaW5fY2hhbm5lbHMlMkMlMjBzZWxmLnVuZXQuY29uZmlnLnNhbXBsZV9zaXplJTJDJTIwc2VsZi51bmV0LmNvbmZpZy5zYW1wbGVfc2l6ZSklMkMlMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGltZXN0ZXAlMjAlM0QlMjAxJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfb3V0cHV0JTIwJTNEJTIwc2VsZi51bmV0KGltYWdlJTJDJTIwdGltZXN0ZXApLnNhbXBsZSUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlcl9vdXRwdXQlMjAlM0QlMjBzZWxmLnNjaGVkdWxlci5zdGVwKG1vZGVsX291dHB1dCUyQyUyMHRpbWVzdGVwJTJDJTIwaW1hZ2UpLnByZXZfc2FtcGxlJTBBJTBBJTJCJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwc2NoZWR1bGVyX291dHB1dA==",highlighted:`  from diffusers import DiffusionPipeline
  import torch

  class UnetSchedulerOneForwardPipeline(DiffusionPipeline):
      def __init__(self, unet, scheduler):
          super().__init__()

          self.register_modules(unet=unet, scheduler=scheduler)

<span class="hljs-addition">+     def __call__(self):</span>
<span class="hljs-addition">+         image = torch.randn(</span>
<span class="hljs-addition">+             (1, self.unet.config.in_channels, self.unet.config.sample_size, self.unet.config.sample_size),</span>
<span class="hljs-addition">+         )</span>
<span class="hljs-addition">+         timestep = 1</span>

<span class="hljs-addition">+         model_output = self.unet(image, timestep).sample</span>
<span class="hljs-addition">+         scheduler_output = self.scheduler.step(model_output, timestep, image).prev_sample</span>

<span class="hljs-addition">+         return scheduler_output</span>`}}),z=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEREUE1TY2hlZHVsZXIlMkMlMjBVTmV0MkRNb2RlbCUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIoKSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRNb2RlbCgpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lKHVuZXQlM0R1bmV0JTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel

scheduler = DDPMScheduler()
unet = UNet2DModel()

pipeline = UnetSchedulerOneForwardPipeline(unet=unet, scheduler=scheduler)

output = pipeline()`}}),F=new v({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBVbmV0U2NoZWR1bGVyT25lRm9yd2FyZFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQW91dHB1dCUyMCUzRCUyMHBpcGVsaW5lKCk=",highlighted:`pipeline = UnetSchedulerOneForwardPipeline.from_pretrained(<span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

output = pipeline()`}}),Y=new Ie({}),K=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMkMlMjBjdXN0b21fcGlwZWxpbmUlM0QlMjJvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEFwaXBlKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
pipe()`}}),ee=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTJDJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyc3RldmhsaXUlMkZvbmVfc3RlcF91bmV0JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>, custom_pipeline=<span class="hljs-string">&quot;stevhliu/one_step_unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`}}),C=new Pt({props:{$$slots:{default:[qt]},$$scope:{ctx:de}}}),se=new Ie({}),oe=new v({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMENMSVBJbWFnZVByb2Nlc3NvciUyQyUyMENMSVBNb2RlbCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNCUyMiUwQWNsaXBfbW9kZWxfaWQlMjAlM0QlMjAlMjJsYWlvbiUyRkNMSVAtVmlULUItMzItbGFpb24yQi1zMzRCLWI3OUslMjIlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMENMSVBJbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2xpcF9tb2RlbF9pZCklMEFjbGlwX21vZGVsJTIwJTNEJTIwQ0xJUE1vZGVsLmZyb21fcHJldHJhaW5lZChjbGlwX21vZGVsX2lkJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyY2xpcF9ndWlkZWRfc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfbW9kZWwlM0RjbGlwX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZV9leHRyYWN0b3IlM0RmZWF0dXJlX2V4dHJhY3RvciUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPImageProcessor, CLIPModel

model_id = <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>
clip_model_id = <span class="hljs-string">&quot;laion/CLIP-ViT-B-32-laion2B-s34B-b79K&quot;</span>

feature_extractor = CLIPImageProcessor.from_pretrained(clip_model_id)
clip_model = CLIPModel.from_pretrained(clip_model_id, torch_dtype=torch.float16)

pipeline = DiffusionPipeline.from_pretrained(
    model_id,
    custom_pipeline=<span class="hljs-string">&quot;clip_guided_stable_diffusion&quot;</span>,
    clip_model=clip_model,
    feature_extractor=feature_extractor,
    scheduler=scheduler,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)`}}),re=new v({props:{code:"JTIzJTIwMi4lMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMjBjbGFzcyUyQyUyMGlmJTIwdXNpbmclMjBjdXN0b20lMjBtb2R1bGUlMjB0aGVuJTIwbG9hZCUyMGl0JTIwZnJvbSUyMHRoZSUyMEh1YiUwQSUyMyUyMGlmJTIwd2UlMjBsb2FkJTIwZnJvbSUyMGV4cGxpY2l0JTIwY2xhc3MlMkMlMjBsZXQncyUyMHVzZSUyMGl0JTBBaWYlMjBjdXN0b21fcGlwZWxpbmUlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldF9jbGFzc19mcm9tX2R5bmFtaWNfbW9kdWxlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGN1c3RvbV9waXBlbGluZSUyQyUyMG1vZHVsZV9maWxlJTNEQ1VTVE9NX1BJUEVMSU5FX0ZJTEVfTkFNRSUyQyUyMGNhY2hlX2RpciUzRGN1c3RvbV9waXBlbGluZSUwQSUyMCUyMCUyMCUyMCklMEFlbGlmJTIwY2xzJTIwISUzRCUyMERpZmZ1c2lvblBpcGVsaW5lJTNBJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlMjAlM0QlMjBjbHMlMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwZGlmZnVzZXJzX21vZHVsZSUyMCUzRCUyMGltcG9ydGxpYi5pbXBvcnRfbW9kdWxlKGNscy5fX21vZHVsZV9fLnNwbGl0KCUyMi4lMjIpJTVCMCU1RCklMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUyMCUzRCUyMGdldGF0dHIoZGlmZnVzZXJzX21vZHVsZSUyQyUyMGNvbmZpZ19kaWN0JTVCJTIyX2NsYXNzX25hbWUlMjIlNUQp",highlighted:`<span class="hljs-comment"># 2. Load the pipeline class, if using custom module then load it from the Hub</span>
<span class="hljs-comment"># if we load from explicit class, let&#x27;s use it</span>
<span class="hljs-keyword">if</span> custom_pipeline <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    pipeline_class = get_class_from_dynamic_module(
        custom_pipeline, module_file=CUSTOM_PIPELINE_FILE_NAME, cache_dir=custom_pipeline
    )
<span class="hljs-keyword">elif</span> cls != DiffusionPipeline:
    pipeline_class = cls
<span class="hljs-keyword">else</span>:
    diffusers_module = importlib.import_module(cls.__module__.split(<span class="hljs-string">&quot;.&quot;</span>)[<span class="hljs-number">0</span>])
    pipeline_class = <span class="hljs-built_in">getattr</span>(diffusers_module, config_dict[<span class="hljs-string">&quot;_class_name&quot;</span>])`}}),{c(){p=i("meta"),b=a(),d=i("h1"),T=i("a"),ye=i("span"),f($.$$.fragment),ot=a(),ue=i("span"),ue.textContent=ut,Ze=a(),f(j.$$.fragment),_e=a(),k=i("p"),k.innerHTML=ft,ve=a(),W=i("p"),W.innerHTML=mt,je=a(),U=i("h2"),G=i("a"),Me=i("span"),f(X.$$.fragment),pt=a(),fe=i("span"),fe.textContent=ht,Ge=a(),H=i("p"),H.innerHTML=wt,Ve=a(),f(N.$$.fragment),ge=a(),R=i("p"),R.innerHTML=yt,Ce=a(),f(x.$$.fragment),Be=a(),E=i("p"),E.innerHTML=Mt,$e=a(),I=i("h2"),V=i("a"),Je=i("span"),f(S.$$.fragment),rt=a(),me=i("span"),me.textContent=Jt,ke=a(),P=i("p"),P.innerHTML=Tt,We=a(),f(A.$$.fragment),Xe=a(),Q=i("p"),Q.innerHTML=bt,He=a(),f(z.$$.fragment),Ne=a(),L=i("p"),L.innerHTML=Ut,Re=a(),f(F.$$.fragment),xe=a(),Z=i("h2"),g=i("a"),Te=i("span"),f(Y.$$.fragment),ct=a(),he=i("span"),he.textContent=It,Ee=a(),D=i("p"),D.innerHTML=Zt,Se=a(),q=i("p"),q.innerHTML=_t,Pe=a(),f(K.$$.fragment),Ae=a(),O=i("p"),O.innerHTML=vt,Qe=a(),f(ee.$$.fragment),ze=a(),te=i("p"),te.textContent=jt,Le=a(),le=i("table"),le.innerHTML=Gt,Fe=a(),f(C.$$.fragment),Ye=a(),_=i("h2"),B=i("a"),be=i("span"),f(se.$$.fragment),dt=a(),we=i("span"),we.textContent=Vt,De=a(),ie=i("p"),ie.innerHTML=gt,qe=a(),ne=i("ul"),ne.innerHTML=Ct,Ke=a(),ae=i("p"),ae.textContent=Bt,Oe=a(),f(oe.$$.fragment),et=a(),pe=i("p"),pe.textContent=$t,tt=a(),f(re.$$.fragment),this.h()},l(e){const t=Yt("svelte-1phssyn",document.head);p=n(t,"META",{name:!0,content:!0}),t.forEach(l),b=o(e),d=n(e,"H1",{class:!0});var ce=J(d);T=n(ce,"A",{id:!0,class:!0,href:!0});var Ue=J(T);ye=n(Ue,"SPAN",{});var kt=J(ye);m($.$$.fragment,kt),kt.forEach(l),Ue.forEach(l),ot=o(ce),ue=n(ce,"SPAN",{"data-svelte-h":!0}),r(ue)!=="svelte-rnibz6"&&(ue.textContent=ut),ce.forEach(l),Ze=o(e),m(j.$$.fragment,e),_e=o(e),k=n(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-x1p8lz"&&(k.innerHTML=ft),ve=o(e),W=n(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-uyw7g0"&&(W.innerHTML=mt),je=o(e),U=n(e,"H2",{class:!0});var st=J(U);G=n(st,"A",{id:!0,class:!0,href:!0});var Wt=J(G);Me=n(Wt,"SPAN",{});var Xt=J(Me);m(X.$$.fragment,Xt),Xt.forEach(l),Wt.forEach(l),pt=o(st),fe=n(st,"SPAN",{"data-svelte-h":!0}),r(fe)!=="svelte-i6p5pi"&&(fe.textContent=ht),st.forEach(l),Ge=o(e),H=n(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1rgtswk"&&(H.innerHTML=wt),Ve=o(e),m(N.$$.fragment,e),ge=o(e),R=n(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-19uiudr"&&(R.innerHTML=yt),Ce=o(e),m(x.$$.fragment,e),Be=o(e),E=n(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-jmgs1z"&&(E.innerHTML=Mt),$e=o(e),I=n(e,"H2",{class:!0});var it=J(I);V=n(it,"A",{id:!0,class:!0,href:!0});var Ht=J(V);Je=n(Ht,"SPAN",{});var Nt=J(Je);m(S.$$.fragment,Nt),Nt.forEach(l),Ht.forEach(l),rt=o(it),me=n(it,"SPAN",{"data-svelte-h":!0}),r(me)!=="svelte-6582yt"&&(me.textContent=Jt),it.forEach(l),ke=o(e),P=n(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1l1aime"&&(P.innerHTML=Tt),We=o(e),m(A.$$.fragment,e),Xe=o(e),Q=n(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1wqngql"&&(Q.innerHTML=bt),He=o(e),m(z.$$.fragment,e),Ne=o(e),L=n(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-13itfz9"&&(L.innerHTML=Ut),Re=o(e),m(F.$$.fragment,e),xe=o(e),Z=n(e,"H2",{class:!0});var nt=J(Z);g=n(nt,"A",{id:!0,class:!0,href:!0});var Rt=J(g);Te=n(Rt,"SPAN",{});var xt=J(Te);m(Y.$$.fragment,xt),xt.forEach(l),Rt.forEach(l),ct=o(nt),he=n(nt,"SPAN",{"data-svelte-h":!0}),r(he)!=="svelte-o0wga3"&&(he.textContent=It),nt.forEach(l),Ee=o(e),D=n(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1okqb75"&&(D.innerHTML=Zt),Se=o(e),q=n(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-mmjniw"&&(q.innerHTML=_t),Pe=o(e),m(K.$$.fragment,e),Ae=o(e),O=n(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-hpyorm"&&(O.innerHTML=vt),Qe=o(e),m(ee.$$.fragment,e),ze=o(e),te=n(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1wdgje4"&&(te.textContent=jt),Le=o(e),le=n(e,"TABLE",{"data-svelte-h":!0}),r(le)!=="svelte-1tu2a4k"&&(le.innerHTML=Gt),Fe=o(e),m(C.$$.fragment,e),Ye=o(e),_=n(e,"H2",{class:!0});var at=J(_);B=n(at,"A",{id:!0,class:!0,href:!0});var Et=J(B);be=n(Et,"SPAN",{});var St=J(be);m(se.$$.fragment,St),St.forEach(l),Et.forEach(l),dt=o(at),we=n(at,"SPAN",{"data-svelte-h":!0}),r(we)!=="svelte-1lkdpg0"&&(we.textContent=Vt),at.forEach(l),De=o(e),ie=n(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1tpr88n"&&(ie.innerHTML=gt),qe=o(e),ne=n(e,"UL",{"data-svelte-h":!0}),r(ne)!=="svelte-185ii9u"&&(ne.innerHTML=Ct),Ke=o(e),ae=n(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-84chr9"&&(ae.textContent=Bt),Oe=o(e),m(oe.$$.fragment,e),et=o(e),pe=n(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-pfjr1e"&&(pe.textContent=$t),tt=o(e),m(re.$$.fragment,e),this.h()},h(){c(p,"name","hf:doc:metadata"),c(p,"content",JSON.stringify(Ot)),c(T,"id","contribute-a-community-pipeline"),c(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(T,"href","#contribute-a-community-pipeline"),c(d,"class","relative group"),c(G,"id","initialize-the-pipeline"),c(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(G,"href","#initialize-the-pipeline"),c(U,"class","relative group"),c(V,"id","define-the-forward-pass"),c(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(V,"href","#define-the-forward-pass"),c(I,"class","relative group"),c(g,"id","share-your-pipeline"),c(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(g,"href","#share-your-pipeline"),c(Z,"class","relative group"),c(B,"id","how-do-community-pipelines-work"),c(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(B,"href","#how-do-community-pipelines-work"),c(_,"class","relative group")},m(e,t){u(document.head,p),s(e,b,t),s(e,d,t),u(d,T),u(T,ye),h($,ye,null),u(d,ot),u(d,ue),s(e,Ze,t),h(j,e,t),s(e,_e,t),s(e,k,t),s(e,ve,t),s(e,W,t),s(e,je,t),s(e,U,t),u(U,G),u(G,Me),h(X,Me,null),u(U,pt),u(U,fe),s(e,Ge,t),s(e,H,t),s(e,Ve,t),h(N,e,t),s(e,ge,t),s(e,R,t),s(e,Ce,t),h(x,e,t),s(e,Be,t),s(e,E,t),s(e,$e,t),s(e,I,t),u(I,V),u(V,Je),h(S,Je,null),u(I,rt),u(I,me),s(e,ke,t),s(e,P,t),s(e,We,t),h(A,e,t),s(e,Xe,t),s(e,Q,t),s(e,He,t),h(z,e,t),s(e,Ne,t),s(e,L,t),s(e,Re,t),h(F,e,t),s(e,xe,t),s(e,Z,t),u(Z,g),u(g,Te),h(Y,Te,null),u(Z,ct),u(Z,he),s(e,Ee,t),s(e,D,t),s(e,Se,t),s(e,q,t),s(e,Pe,t),h(K,e,t),s(e,Ae,t),s(e,O,t),s(e,Qe,t),h(ee,e,t),s(e,ze,t),s(e,te,t),s(e,Le,t),s(e,le,t),s(e,Fe,t),h(C,e,t),s(e,Ye,t),s(e,_,t),u(_,B),u(B,be),h(se,be,null),u(_,dt),u(_,we),s(e,De,t),s(e,ie,t),s(e,qe,t),s(e,ne,t),s(e,Ke,t),s(e,ae,t),s(e,Oe,t),h(oe,e,t),s(e,et,t),s(e,pe,t),s(e,tt,t),h(re,e,t),lt=!0},p(e,[t]){const ce={};t&2&&(ce.$$scope={dirty:t,ctx:e}),j.$set(ce);const Ue={};t&2&&(Ue.$$scope={dirty:t,ctx:e}),C.$set(Ue)},i(e){lt||(w($.$$.fragment,e),w(j.$$.fragment,e),w(X.$$.fragment,e),w(N.$$.fragment,e),w(x.$$.fragment,e),w(S.$$.fragment,e),w(A.$$.fragment,e),w(z.$$.fragment,e),w(F.$$.fragment,e),w(Y.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(C.$$.fragment,e),w(se.$$.fragment,e),w(oe.$$.fragment,e),w(re.$$.fragment,e),lt=!0)},o(e){y($.$$.fragment,e),y(j.$$.fragment,e),y(X.$$.fragment,e),y(N.$$.fragment,e),y(x.$$.fragment,e),y(S.$$.fragment,e),y(A.$$.fragment,e),y(z.$$.fragment,e),y(F.$$.fragment,e),y(Y.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(C.$$.fragment,e),y(se.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),lt=!1},d(e){e&&(l(b),l(d),l(Ze),l(_e),l(k),l(ve),l(W),l(je),l(U),l(Ge),l(H),l(Ve),l(ge),l(R),l(Ce),l(Be),l(E),l($e),l(I),l(ke),l(P),l(We),l(Xe),l(Q),l(He),l(Ne),l(L),l(Re),l(xe),l(Z),l(Ee),l(D),l(Se),l(q),l(Pe),l(Ae),l(O),l(Qe),l(ze),l(te),l(Le),l(le),l(Fe),l(Ye),l(_),l(De),l(ie),l(qe),l(ne),l(Ke),l(ae),l(Oe),l(et),l(pe),l(tt)),l(p),M($),M(j,e),M(X),M(N,e),M(x,e),M(S),M(A,e),M(z,e),M(F,e),M(Y),M(K,e),M(ee,e),M(C,e),M(se),M(oe,e),M(re,e)}}}const Ot={local:"contribute-a-community-pipeline",sections:[{local:"initialize-the-pipeline",title:"Initialize the pipeline"},{local:"define-the-forward-pass",title:"Define the forward pass"},{local:"share-your-pipeline",title:"Share your pipeline"},{local:"how-do-community-pipelines-work",title:"How do community pipelines work?"}],title:"Contribute a community pipeline"};function el(de){return zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class al extends Lt{constructor(p){super(),Ft(this,p,el,Kt,Qt,{})}}export{al as component};
