import{s as jt,o as It,n as xe}from"../chunks/scheduler.182ea377.js";import{S as Lt,i as Ct,g as p,s as a,r as y,A as St,h as c,f as l,c as i,j,u as w,x as b,k as I,y as s,a as g,v as $,d as v,t as x,w as T}from"../chunks/index.abf12888.js";import{T as pt}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as dt}from"../chunks/CodeBlock.57fe6e13.js";import{E as ct}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as ft}from"../chunks/Heading.16916d63.js";function Pt(U){let n,_='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',r,o,m='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){n=p("p"),n.innerHTML=_,r=a(),o=p("p"),o.innerHTML=m},l(t){n=c(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-1j961ct"&&(n.innerHTML=_),r=i(t),o=c(t,"P",{"data-svelte-h":!0}),b(o)!=="svelte-z4pn9c"&&(o.innerHTML=m)},m(t,h){g(t,n,h),g(t,r,h),g(t,o,h)},p:xe,d(t){t&&(l(n),l(r),l(o))}}}function Zt(U){let n,_="Examples:",r,o,m;return o=new dt({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkxhdGVudFVwc2NhbGVQaXBlbGluZSUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS00JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnNkLXgyLWxhdGVudC11cHNjYWxlciUyMiUwQXVwc2NhbGVyJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uTGF0ZW50VXBzY2FsZVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEF1cHNjYWxlci50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjBoaWdoJTIwcmVzb2x1dGlvbiUyQyUyMHVucmVhbCUyMGVuZ2luZSUyQyUyMHVsdHJhJTIwcmVhbGlzdGljJTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMzMpJTBBJTBBbG93X3Jlc19sYXRlbnRzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJsYXRlbnQlMjIpLmltYWdlcyUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLmRlY29kZV9sYXRlbnRzKGxvd19yZXNfbGF0ZW50cyklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lLm51bXB5X3RvX3BpbChpbWFnZSklNUIwJTVEJTBBJTBBaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmExLnBuZyUyMiklMEElMEF1cHNjYWxlZF9pbWFnZSUyMCUzRCUyMHVwc2NhbGVyKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEbG93X3Jlc19sYXRlbnRzJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBJTBBdXBzY2FsZWRfaW1hZ2Uuc2F2ZSglMjIuLiUyRmltYWdlcyUyRmEyLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionLatentUpscalePipeline, StableDiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;CompVis/stable-diffusion-v1-4&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stabilityai/sd-x2-latent-upscaler&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler = StableDiffusionLatentUpscalePipeline.from_pretrained(model_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>upscaler.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut high resolution, unreal engine, ultra realistic&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.manual_seed(<span class="hljs-number">33</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>low_res_latents = pipeline(prompt, generator=generator, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    image = pipeline.decode_latents(low_res_latents)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipeline.numpy_to_pil(image)[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;../images/a1.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image = upscaler(
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    image=low_res_latents,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">0</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>upscaled_image.save(<span class="hljs-string">&quot;../images/a2.png&quot;</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=_,r=a(),y(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=_),r=i(t),w(o.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),$(o,t,h),m=!0},p:xe,i(t){m||(v(o.$$.fragment,t),m=!0)},o(t){x(o.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),T(o,t)}}}function Gt(U){let n,_=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){n=p("p"),n.innerHTML=_},l(r){n=c(r,"P",{"data-svelte-h":!0}),b(n)!=="svelte-ackzsn"&&(n.innerHTML=_)},m(r,o){g(r,n,o)},p:xe,d(r){r&&l(n)}}}function Wt(U){let n,_="Examples:",r,o,m;return o=new dt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfYXR0ZW50aW9uX3NsaWNpbmcoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=p("p"),n.textContent=_,r=a(),y(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=_),r=i(t),w(o.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),$(o,t,h),m=!0},p:xe,i(t){m||(v(o.$$.fragment,t),m=!0)},o(t){x(o.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),T(o,t)}}}function kt(U){let n,_=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){n=p("p"),n.textContent=_},l(r){n=c(r,"P",{"data-svelte-h":!0}),b(n)!=="svelte-17p1lpg"&&(n.textContent=_)},m(r,o){g(r,n,o)},p:xe,d(r){r&&l(n)}}}function Vt(U){let n,_="Examples:",r,o,m;return o=new dt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){n=p("p"),n.textContent=_,r=a(),y(o.$$.fragment)},l(t){n=c(t,"P",{"data-svelte-h":!0}),b(n)!=="svelte-kvfsh7"&&(n.textContent=_),r=i(t),w(o.$$.fragment,t)},m(t,h){g(t,n,h),g(t,r,h),$(o,t,h),m=!0},p:xe,i(t){m||(v(o.$$.fragment,t),m=!0)},o(t){x(o.$$.fragment,t),m=!1},d(t){t&&(l(n),l(r)),T(o,t)}}}function Bt(U){let n,_,r,o,m,t,h,ut='The Stable Diffusion latent upscaler model was created by <a href="https://github.com/crowsonkb/k-diffusion" rel="nofollow">Katherine Crowson</a> in collaboration with <a href="https://stability.ai/" rel="nofollow">Stability AI</a>. It is used to enhance the output image resolution by a factor of 2 (see this demo <a href="https://colab.research.google.com/drive/1o1qYJcFeywzCIdkfKJy7cTpgZTCM2EI4" rel="nofollow">notebook</a> for a demonstration of the original implementation).',Ue,W,Je,Y,Me,d,q,Ze,re,mt="Pipeline for upscaling Stable Diffusion output image resolution by a factor of 2.",Ge,pe,gt=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,We,ce,ht="The pipeline also inherits the following loading methods:",ke,fe,bt='<li><a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li>',Ve,S,Q,Be,de,_t="The call function to the pipeline for generation.",Ee,k,Re,V,A,Xe,ue,yt=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to GPU only when their specific submodule has its <code>forward</code>
method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Fe,J,O,ze,me,wt=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Ne,B,He,E,Ye,R,K,qe,ge,$t=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Qe,M,ee,Ae,he,vt=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Oe,X,Ke,F,et,z,te,tt,be,xt='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',nt,N,ne,st,_e,Tt="Disables the FreeU mechanism if enabled.",at,D,se,it,ye,Ut='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',ot,we,Jt="The suffixes after the scaling factors represent the stages where they are being applied.",lt,$e,Mt=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,De,ae,je,Z,ie,rt,ve,Dt="Output class for Stable Diffusion pipelines.",Ie,Te,Le;return m=new ft({props:{title:"Latent upscaler",local:"latent-upscaler",headingTag:"h1"}}),W=new pt({props:{$$slots:{default:[Pt]},$$scope:{ctx:U}}}),Y=new ft({props:{title:"StableDiffusionLatentUpscalePipeline",local:"diffusers.StableDiffusionLatentUpscalePipeline",headingTag:"h2"}}),q=new P({props:{name:"class diffusers.StableDiffusionLatentUpscalePipeline",anchor:"diffusers.StableDiffusionLatentUpscalePipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": EulerDiscreteScheduler"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A <a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> to be used in combination with <code>unet</code> to denoise the encoded image latents.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L63"}}),Q=new P({props:{name:"__call__",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union = None"},{name:"num_inference_steps",val:": int = 75"},{name:"guidance_scale",val:": float = 9.0"},{name:"negative_prompt",val:": Union = None"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide image upscaling.`,name:"prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be upscaled. If it&#x2019;s a tensor, it can be either a
latent output from a Stable Diffusion model or an image tensor in the range <code>[-1, 1]</code>. It is considered
a <code>latent</code> if <code>image.shape[1]</code> is <code>4</code>; otherwise, it is considered to be an image representation and
encoded using this pipeline&#x2019;s <code>vae</code> encoder.`,name:"image"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L289",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),k=new ct({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.__call__.example",$$slots:{default:[Zt]},$$scope:{ctx:U}}}),A=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": Optional = None"},{name:"device",val:": Union = 'cuda'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to &#x201C;cuda&#x201D;) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
default to &#x201C;cuda&#x201D;.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1493"}}),O=new P({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": Union = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2057"}}),B=new pt({props:{warning:!0,$$slots:{default:[Gt]},$$scope:{ctx:U}}}),E=new ct({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_attention_slicing.example",$$slots:{default:[Wt]},$$scope:{ctx:U}}}),K=new P({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2097"}}),ee=new P({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1996"}}),X=new pt({props:{warning:!0,$$slots:{default:[kt]},$$scope:{ctx:U}}}),F=new ct({props:{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Vt]},$$scope:{ctx:U}}}),te=new P({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2031"}}),ne=new P({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L285"}}),se=new P({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionLatentUpscalePipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_latent_upscale.py#L262"}}),ae=new ft({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),ie=new P({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": Union"},{name:"nsfw_content_detected",val:": Optional"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L10"}}),{c(){n=p("meta"),_=a(),r=p("p"),o=a(),y(m.$$.fragment),t=a(),h=p("p"),h.innerHTML=ut,Ue=a(),y(W.$$.fragment),Je=a(),y(Y.$$.fragment),Me=a(),d=p("div"),y(q.$$.fragment),Ze=a(),re=p("p"),re.textContent=mt,Ge=a(),pe=p("p"),pe.innerHTML=gt,We=a(),ce=p("p"),ce.textContent=ht,ke=a(),fe=p("ul"),fe.innerHTML=bt,Ve=a(),S=p("div"),y(Q.$$.fragment),Be=a(),de=p("p"),de.textContent=_t,Ee=a(),y(k.$$.fragment),Re=a(),V=p("div"),y(A.$$.fragment),Xe=a(),ue=p("p"),ue.innerHTML=yt,Fe=a(),J=p("div"),y(O.$$.fragment),ze=a(),me=p("p"),me.textContent=wt,Ne=a(),y(B.$$.fragment),He=a(),y(E.$$.fragment),Ye=a(),R=p("div"),y(K.$$.fragment),qe=a(),ge=p("p"),ge.innerHTML=$t,Qe=a(),M=p("div"),y(ee.$$.fragment),Ae=a(),he=p("p"),he.innerHTML=vt,Oe=a(),y(X.$$.fragment),Ke=a(),y(F.$$.fragment),et=a(),z=p("div"),y(te.$$.fragment),tt=a(),be=p("p"),be.innerHTML=xt,nt=a(),N=p("div"),y(ne.$$.fragment),st=a(),_e=p("p"),_e.textContent=Tt,at=a(),D=p("div"),y(se.$$.fragment),it=a(),ye=p("p"),ye.innerHTML=Ut,ot=a(),we=p("p"),we.textContent=Jt,lt=a(),$e=p("p"),$e.innerHTML=Mt,De=a(),y(ae.$$.fragment),je=a(),Z=p("div"),y(ie.$$.fragment),rt=a(),ve=p("p"),ve.textContent=Dt,Ie=a(),Te=p("p"),this.h()},l(e){const f=St("svelte-u9bgzb",document.head);n=c(f,"META",{name:!0,content:!0}),f.forEach(l),_=i(e),r=c(e,"P",{}),j(r).forEach(l),o=i(e),w(m.$$.fragment,e),t=i(e),h=c(e,"P",{"data-svelte-h":!0}),b(h)!=="svelte-1gpdp46"&&(h.innerHTML=ut),Ue=i(e),w(W.$$.fragment,e),Je=i(e),w(Y.$$.fragment,e),Me=i(e),d=c(e,"DIV",{class:!0});var u=j(d);w(q.$$.fragment,u),Ze=i(u),re=c(u,"P",{"data-svelte-h":!0}),b(re)!=="svelte-s74qtl"&&(re.textContent=mt),Ge=i(u),pe=c(u,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-496sm0"&&(pe.innerHTML=gt),We=i(u),ce=c(u,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-14s6m4u"&&(ce.textContent=ht),ke=i(u),fe=c(u,"UL",{"data-svelte-h":!0}),b(fe)!=="svelte-1hpayfe"&&(fe.innerHTML=bt),Ve=i(u),S=c(u,"DIV",{class:!0});var G=j(S);w(Q.$$.fragment,G),Be=i(G),de=c(G,"P",{"data-svelte-h":!0}),b(de)!=="svelte-50j04k"&&(de.textContent=_t),Ee=i(G),w(k.$$.fragment,G),G.forEach(l),Re=i(u),V=c(u,"DIV",{class:!0});var oe=j(V);w(A.$$.fragment,oe),Xe=i(oe),ue=c(oe,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-n1oyuv"&&(ue.innerHTML=yt),oe.forEach(l),Fe=i(u),J=c(u,"DIV",{class:!0});var L=j(J);w(O.$$.fragment,L),ze=i(L),me=c(L,"P",{"data-svelte-h":!0}),b(me)!=="svelte-10jaql7"&&(me.textContent=wt),Ne=i(L),w(B.$$.fragment,L),He=i(L),w(E.$$.fragment,L),L.forEach(l),Ye=i(u),R=c(u,"DIV",{class:!0});var le=j(R);w(K.$$.fragment,le),qe=i(le),ge=c(le,"P",{"data-svelte-h":!0}),b(ge)!=="svelte-1lh0nh5"&&(ge.innerHTML=$t),le.forEach(l),Qe=i(u),M=c(u,"DIV",{class:!0});var C=j(M);w(ee.$$.fragment,C),Ae=i(C),he=c(C,"P",{"data-svelte-h":!0}),b(he)!=="svelte-e03q3e"&&(he.innerHTML=vt),Oe=i(C),w(X.$$.fragment,C),Ke=i(C),w(F.$$.fragment,C),C.forEach(l),et=i(u),z=c(u,"DIV",{class:!0});var Ce=j(z);w(te.$$.fragment,Ce),tt=i(Ce),be=c(Ce,"P",{"data-svelte-h":!0}),b(be)!=="svelte-1vfte1e"&&(be.innerHTML=xt),Ce.forEach(l),nt=i(u),N=c(u,"DIV",{class:!0});var Se=j(N);w(ne.$$.fragment,Se),st=i(Se),_e=c(Se,"P",{"data-svelte-h":!0}),b(_e)!=="svelte-psupw6"&&(_e.textContent=Tt),Se.forEach(l),at=i(u),D=c(u,"DIV",{class:!0});var H=j(D);w(se.$$.fragment,H),it=i(H),ye=c(H,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-1f3tmq1"&&(ye.innerHTML=Ut),ot=i(H),we=c(H,"P",{"data-svelte-h":!0}),b(we)!=="svelte-xjijlp"&&(we.textContent=Jt),lt=i(H),$e=c(H,"P",{"data-svelte-h":!0}),b($e)!=="svelte-hy0nzs"&&($e.innerHTML=Mt),H.forEach(l),u.forEach(l),De=i(e),w(ae.$$.fragment,e),je=i(e),Z=c(e,"DIV",{class:!0});var Pe=j(Z);w(ie.$$.fragment,Pe),rt=i(Pe),ve=c(Pe,"P",{"data-svelte-h":!0}),b(ve)!=="svelte-1qpjiuf"&&(ve.textContent=Dt),Pe.forEach(l),Ie=i(e),Te=c(e,"P",{}),j(Te).forEach(l),this.h()},h(){I(n,"name","hf:doc:metadata"),I(n,"content",Et),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){s(document.head,n),g(e,_,f),g(e,r,f),g(e,o,f),$(m,e,f),g(e,t,f),g(e,h,f),g(e,Ue,f),$(W,e,f),g(e,Je,f),$(Y,e,f),g(e,Me,f),g(e,d,f),$(q,d,null),s(d,Ze),s(d,re),s(d,Ge),s(d,pe),s(d,We),s(d,ce),s(d,ke),s(d,fe),s(d,Ve),s(d,S),$(Q,S,null),s(S,Be),s(S,de),s(S,Ee),$(k,S,null),s(d,Re),s(d,V),$(A,V,null),s(V,Xe),s(V,ue),s(d,Fe),s(d,J),$(O,J,null),s(J,ze),s(J,me),s(J,Ne),$(B,J,null),s(J,He),$(E,J,null),s(d,Ye),s(d,R),$(K,R,null),s(R,qe),s(R,ge),s(d,Qe),s(d,M),$(ee,M,null),s(M,Ae),s(M,he),s(M,Oe),$(X,M,null),s(M,Ke),$(F,M,null),s(d,et),s(d,z),$(te,z,null),s(z,tt),s(z,be),s(d,nt),s(d,N),$(ne,N,null),s(N,st),s(N,_e),s(d,at),s(d,D),$(se,D,null),s(D,it),s(D,ye),s(D,ot),s(D,we),s(D,lt),s(D,$e),g(e,De,f),$(ae,e,f),g(e,je,f),g(e,Z,f),$(ie,Z,null),s(Z,rt),s(Z,ve),g(e,Ie,f),g(e,Te,f),Le=!0},p(e,[f]){const u={};f&2&&(u.$$scope={dirty:f,ctx:e}),W.$set(u);const G={};f&2&&(G.$$scope={dirty:f,ctx:e}),k.$set(G);const oe={};f&2&&(oe.$$scope={dirty:f,ctx:e}),B.$set(oe);const L={};f&2&&(L.$$scope={dirty:f,ctx:e}),E.$set(L);const le={};f&2&&(le.$$scope={dirty:f,ctx:e}),X.$set(le);const C={};f&2&&(C.$$scope={dirty:f,ctx:e}),F.$set(C)},i(e){Le||(v(m.$$.fragment,e),v(W.$$.fragment,e),v(Y.$$.fragment,e),v(q.$$.fragment,e),v(Q.$$.fragment,e),v(k.$$.fragment,e),v(A.$$.fragment,e),v(O.$$.fragment,e),v(B.$$.fragment,e),v(E.$$.fragment,e),v(K.$$.fragment,e),v(ee.$$.fragment,e),v(X.$$.fragment,e),v(F.$$.fragment,e),v(te.$$.fragment,e),v(ne.$$.fragment,e),v(se.$$.fragment,e),v(ae.$$.fragment,e),v(ie.$$.fragment,e),Le=!0)},o(e){x(m.$$.fragment,e),x(W.$$.fragment,e),x(Y.$$.fragment,e),x(q.$$.fragment,e),x(Q.$$.fragment,e),x(k.$$.fragment,e),x(A.$$.fragment,e),x(O.$$.fragment,e),x(B.$$.fragment,e),x(E.$$.fragment,e),x(K.$$.fragment,e),x(ee.$$.fragment,e),x(X.$$.fragment,e),x(F.$$.fragment,e),x(te.$$.fragment,e),x(ne.$$.fragment,e),x(se.$$.fragment,e),x(ae.$$.fragment,e),x(ie.$$.fragment,e),Le=!1},d(e){e&&(l(_),l(r),l(o),l(t),l(h),l(Ue),l(Je),l(Me),l(d),l(De),l(je),l(Z),l(Ie),l(Te)),l(n),T(m,e),T(W,e),T(Y,e),T(q),T(Q),T(k),T(A),T(O),T(B),T(E),T(K),T(ee),T(X),T(F),T(te),T(ne),T(se),T(ae,e),T(ie)}}}const Et='{"title":"Latent upscaler","local":"latent-upscaler","sections":[{"title":"StableDiffusionLatentUpscalePipeline","local":"diffusers.StableDiffusionLatentUpscalePipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function Rt(U){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Lt{constructor(n){super(),Ct(this,n,Rt,Bt,jt,{})}}export{Qt as component};
