import{s as XU,o as YU,n as EU}from"../chunks/scheduler.db6b1edd.js";import{S as $U,i as HU,g as T,s as C,r as O,A as _U,h as J,f as i,c as y,j as ZU,u as s,x as t,k as BU,y as vU,a as l,v as a,d as N,t as F,w as V}from"../chunks/index.ef84021a.js";import{T as zU}from"../chunks/Tip.67451c24.js";import{C as w}from"../chunks/CodeBlock.786162a6.js";import{H as dU}from"../chunks/Heading.87f70b00.js";function LU(z){let e,o='Check this <a href="https://clickhouse.com/blog/query-analyze-hugging-face-datasets-with-clickhouse" rel="nofollow">blog</a> for more details about how to analyze datasets on the Hub with ClickHouse.';return{c(){e=T("p"),e.innerHTML=o},l(n){e=J(n,"P",{"data-svelte-h":!0}),t(e)!=="svelte-h0w154"&&(e.innerHTML=o)},m(n,_){l(n,e,_)},p:EU,d(n){n&&i(e)}}}function WU(z){let e,o,n,_,r,L,g,IU='<a href="https://clickhouse.com/docs/en/intro" rel="nofollow">ClickHouse</a> is a fast and efficient column-oriented database for analytical workloads, making it easy to analyze Hub-hosted datasets with SQL. To get started quickly, use <a href="https://clickhouse.com/docs/en/operations/utilities/clickhouse-local" rel="nofollow"><code>clickhouse-local</code></a> to run SQL queries from the command line and avoid the need to fully install ClickHouse.',W,c,q,p,RU="To start, download and install <code>clickhouse-local</code>:",P,d,K,I,hU='For this example, you’ll analyze the <a href="https://huggingface.co/datasets/maharshipandya/spotify-tracks-dataset" rel="nofollow">maharshipandya/spotify-tracks-dataset</a> which contains information about Spotify tracks. Datasets on the Hub are stored as Parquet files and you can access it with the <a href="parquet"><code>/parquet</code></a> endpoint:',UU,R,MU,h,iU,A,AU='Now you can begin to analyze the dataset. Use the <code>-q</code> argument to specify the query to execute, and the <a href="https://clickhouse.com/docs/en/sql-reference/table-functions/url" rel="nofollow"><code>url</code></a> function to create a table from the data in the Parquet file.',lU,u,uU="You should set <code>enable_url_encoding</code> to 0 to ensure the escape characters in the URL are preserved as intended, and <code>max_https_get_redirects</code> to 1 to redirect to the path of the Parquet file.",CU,k,kU="Let’s start by identifying the most popular artists:",yU,Q,TU,m,QU='ClickHouse also provides functions for visualizing your queries. For example, you can use the <a href="https://clickhouse.com/docs/en/sql-reference/functions/other-functions#bar" rel="nofollow"><code>bar</code></a> function to create a bar chart of the danceability of songs:',JU,j,eU,f,mU='To get a deeper understanding about a dataset, ClickHouse provides statistical analysis functions for determining how your data is correlated, calculating statistical hypothesis tests, and more. Take a look at ClickHouse’s <a href="https://clickhouse.com/docs/en/sql-reference/aggregate-functions/reference" rel="nofollow">List of Aggregate Functions</a> for a complete list of available aggregate functions.',tU,D,OU,b,jU="A user-defined function (UDF) allows you to reuse custom logic. Many Hub datasets are often sharded into more than one Parquet file, so it can be easier and more efficient to create a UDF to list and query all the Parquet files of a given dataset from just the dataset name.",sU,G,fU="For this example, you’ll need to run <code>clickhouse-local</code> in console mode so the UDF persists between queries:",aU,x,NU,S,DU="Remember to set <code>enable_url_encoding</code> to 0 and <code>max_https_get_redirects</code> to 1 to redirect to the path of the Parquet files:",FU,Z,VU,B,bU='Let’s create a function to return a list of Parquet files from the <a href="https://huggingface.co/datasets/blog_authorship_corpus" rel="nofollow"><code>blog_authorship_corpus</code></a>:',nU,X,wU,Y,GU="You can make this even easier by creating another function that calls <code>hugging_paths</code> and outputs all the files based on the dataset name:",cU,E,oU,$,xU="Now use the <code>hf</code> function to query any dataset by passing the dataset name:",rU,H,gU,v,pU;return r=new dU({props:{title:"ClickHouse",local:"clickhouse",headingTag:"h1"}}),c=new zU({props:{$$slots:{default:[LU]},$$scope:{ctx:z}}}),d=new w({props:{code:"Y3VybCUyMGh0dHBzJTNBJTJGJTJGY2xpY2tob3VzZS5jb20lMkYlMjAlN0MlMjBzaA==",highlighted:"curl https://clickhouse.com/ | sh",wrap:!1}}),R=new w({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEElMEFyJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KCUyMmh0dHBzJTNBJTJGJTJGZGF0YXNldHMtc2VydmVyLmh1Z2dpbmdmYWNlLmNvJTJGcGFycXVldCUzRmRhdGFzZXQlM0RtYWhhcnNoaXBhbmR5YSUyRnNwb3RpZnktdHJhY2tzLWRhdGFzZXQlMjIpJTBBaiUyMCUzRCUyMHIuanNvbigpJTBBdXJsJTIwJTNEJTIwJTVCZiU1Qid1cmwnJTVEJTIwZm9yJTIwZiUyMGluJTIwaiU1QidwYXJxdWV0X2ZpbGVzJyU1RCU1RCUwQXVybCUwQSU1QidodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtYWhhcnNoaXBhbmR5YSUyRnNwb3RpZnktdHJhY2tzLWRhdGFzZXQlMkZyZXNvbHZlJTJGcmVmcyUyNTJGY29udmVydCUyNTJGcGFycXVldCUyRmRlZmF1bHQlMkZ0cmFpbiUyRjAwMDAucGFycXVldCclNUQ=",highlighted:`<span class="hljs-keyword">import</span> requests

r = requests.get(<span class="hljs-string">&quot;https://datasets-server.huggingface.co/parquet?dataset=maharshipandya/spotify-tracks-dataset&quot;</span>)
j = r.json()
url = [f[<span class="hljs-string">&#x27;url&#x27;</span>] <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> j[<span class="hljs-string">&#x27;parquet_files&#x27;</span>]]
url
[<span class="hljs-string">&#x27;https://huggingface.co/datasets/maharshipandya/spotify-tracks-dataset/resolve/refs%2Fconvert%2Fparquet/default/train/0000.parquet&#x27;</span>]`,wrap:!1}}),h=new dU({props:{title:"Aggregate functions",local:"aggregate-functions",headingTag:"h2"}}),Q=new w({props:{code:"LiUyRmNsaWNraG91c2UlMjBsb2NhbCUyMC1xJTIwJTIyJTBBJTIwJTIwJTIwJTIwU0VMRUNUJTIwY291bnQoKSUyMEFTJTIwYyUyQyUyMGFydGlzdHMlMjAlMEElMjAlMjAlMjAlMjBGUk9NJTIwdXJsKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZtYWhhcnNoaXBhbmR5YSUyRnNwb3RpZnktdHJhY2tzLWRhdGFzZXQlMkZyZXNvbHZlJTJGcmVmcyUyNTJGY29udmVydCUyNTJGcGFycXVldCUyRmRlZmF1bHQlMkZ0cmFpbiUyRjAwMDAucGFycXVldCcpJTIwJTBBJTIwJTIwJTIwJTIwR1JPVVAlMjBCWSUyMGFydGlzdHMlMjAlMEElMjAlMjAlMjAlMjBPUkRFUiUyMEJZJTIwYyUyMCUwQSUyMCUyMCUyMCUyMERFU0MlMjBMSU1JVCUyMDUlMEElMjAlMjAlMjAlMjBTRVRUSU5HUyUyMGVuYWJsZV91cmxfZW5jb2RpbmclM0QwJTJDJTIwbWF4X2h0dHBfZ2V0X3JlZGlyZWN0cyUzRDElMjIlMEElMEElRTIlOTQlOEMlRTIlOTQlODAlRTIlOTQlODAlRTIlOTQlODBjJUUyJTk0JTgwJUUyJTk0JUFDJUUyJTk0JTgwYXJ0aXN0cyVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU5MCUwQSVFMiU5NCU4MiUyMDI3OSUyMCVFMiU5NCU4MiUyMFRoZSUyMEJlYXRsZXMlMjAlMDklRTIlOTQlODIlMEElRTIlOTQlODIlMjAyNzElMjAlRTIlOTQlODIlMjBHZW9yZ2UlMjBKb25lcyUwOSVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMDIzNiUyMCVFMiU5NCU4MiUyMFN0ZXZpZSUyMFdvbmRlciUyMCUyMCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU4MiUyMDIyNCUyMCVFMiU5NCU4MiUyMExpbmtpbiUyMFBhcmslMjAlMDklRTIlOTQlODIlMEElRTIlOTQlODIlMjAyMjIlMjAlRTIlOTQlODIlMjBFbGxhJTIwRml0emdlcmFsZCUyMCVFMiU5NCU4MiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCVCNCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU4MCVFMiU5NCU5OA==",highlighted:`./clickhouse <span class="hljs-built_in">local</span> -q <span class="hljs-string">&quot;
    SELECT count() AS c, artists 
    FROM url(&#x27;https://huggingface.co/datasets/maharshipandya/spotify-tracks-dataset/resolve/refs%2Fconvert%2Fparquet/default/train/0000.parquet&#x27;) 
    GROUP BY artists 
    ORDER BY c 
    DESC LIMIT 5
    SETTINGS enable_url_encoding=0, max_http_get_redirects=1&quot;</span>

┌───c─┬─artists─────────┐
│ 279 │ The Beatles 	│
│ 271 │ George Jones	│
│ 236 │ Stevie Wonder   │
│ 224 │ Linkin Park 	│
│ 222 │ Ella Fitzgerald │
└─────┴─────────────────┘`,wrap:!1}}),j=new w({props:{code:"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",highlighted:`./clickhouse <span class="hljs-built_in">local</span> -q <span class="hljs-string">&quot;
    SELECT
        round(danceability, 1) AS danceability,
        bar(count(), 0, max(count()) OVER ()) AS dist
    FROM url(&#x27;https://huggingface.co/datasets/maharshipandya/spotify-tracks-dataset/resolve/refs%2Fconvert%2Fparquet/default/train/0000.parquet&#x27;)
    GROUP BY danceability
    ORDER BY danceability ASC
    SETTINGS enable_url_encoding=0, max_http_get_redirects=1&quot;</span>

┌─danceability─┬─dist─────────────────────────────────────────────────────────────────────────────────┐
│            0 │ ▍                                                                            	      │
│      	   0.1 │ ████▎                                                                        	      │
│      	   0.2 │ █████████████▍                                                               	      │
│      	   0.3 │ ████████████████████████                                                     	      │
│      	   0.4 │ ████████████████████████████████████████████▋                                	      │
│      	   0.5 │ ████████████████████████████████████████████████████████████████████▊        	      │
│      	   0.6 │ ████████████████████████████████████████████████████████████████████████████████     │
│      	   0.7 │ ██████████████████████████████████████████████████████████████████████       	      │
│      	   0.8 │ ██████████████████████████████████████████                                   	      │
│      	   0.9 │ ██████████▋                                                                  	      │
│            1 │ ▌                                                                            	      │
└──────────────┴──────────────────────────────────────────────────────────────────────────────────────┘`,wrap:!1}}),D=new dU({props:{title:"User-defined function (UDFs)",local:"user-defined-function-udfs",headingTag:"h2"}}),x=new w({props:{code:"LiUyRmNsaWNraG91c2UlMjBsb2NhbA==",highlighted:'./clickhouse <span class="hljs-built_in">local</span>',wrap:!1}}),Z=new w({props:{code:"U0VUJTIwbWF4X2h0dHBfZ2V0X3JlZGlyZWN0cyUyMCUzRCUyMDElMkMlMjBlbmFibGVfdXJsX2VuY29kaW5nJTIwJTNEJTIwMA==",highlighted:"SET max_http_get_redirects = 1, enable_url_encoding = 0",wrap:!1}}),X=new w({props:{code:"Q1JFQVRFJTIwT1IlMjBSRVBMQUNFJTIwRlVOQ1RJT04lMjBodWdnaW5nX3BhdGhzJTIwQVMlMjBkYXRhc2V0JTIwLSUzRSUyMCglMEElMjAlMjAlMjAlMjBTRUxFQ1QlMjBhcnJheU1hcCh4JTIwLSUzRSUyMCh4LjEpJTJDJTIwSlNPTkV4dHJhY3QoanNvbiUyQyUyMCdwYXJxdWV0X2ZpbGVzJyUyQyUyMCdBcnJheShUdXBsZSh1cmwlMjBTdHJpbmcpKScpKSUwQSUyMCUyMCUyMCUyMEZST00lMjB1cmwoJ2h0dHBzJTNBJTJGJTJGZGF0YXNldHMtc2VydmVyLmh1Z2dpbmdmYWNlLmNvJTJGcGFycXVldCUzRmRhdGFzZXQlM0QnJTIwJTdDJTdDJTIwZGF0YXNldCUyQyUyMCdKU09OQXNTdHJpbmcnKSUwQSklM0IlMEElMEFTRUxFQ1QlMjBodWdnaW5nX3BhdGhzKCdibG9nX2F1dGhvcnNoaXBfY29ycHVzJyklMjBBUyUyMHBhdGhzJTBBJTBBJTVCJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmJsb2dfYXV0aG9yc2hpcF9jb3JwdXMlMkZyZXNvbHZlJTJGcmVmcyUyNTJGY29udmVydCUyNTJGcGFycXVldCUyRmJsb2dfYXV0aG9yc2hpcF9jb3JwdXMlMkZ0cmFpbiUyRjAwMDAucGFycXVldCclMkMnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGYmxvZ19hdXRob3JzaGlwX2NvcnB1cyUyRnJlc29sdmUlMkZyZWZzJTI1MkZjb252ZXJ0JTI1MkZwYXJxdWV0JTJGYmxvZ19hdXRob3JzaGlwX2NvcnB1cyUyRnRyYWluJTJGMDAwMS5wYXJxdWV0JyUyQydodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZibG9nX2F1dGhvcnNoaXBfY29ycHVzJTJGcmVzb2x2ZSUyRnJlZnMlMjUyRmNvbnZlcnQlMjUyRnBhcnF1ZXQlMkZibG9nX2F1dGhvcnNoaXBfY29ycHVzJTJGdmFsaWRhdGlvbiUyRjAwMDAucGFycXVldCclNUQ=",highlighted:`CREATE OR REPLACE FUNCTION hugging_paths AS dataset -&gt; (
    SELECT arrayMap(x -&gt; (x.1), JSONExtract(json, <span class="hljs-string">&#x27;parquet_files&#x27;</span>, <span class="hljs-string">&#x27;Array(Tuple(url String))&#x27;</span>))
    FROM url(<span class="hljs-string">&#x27;https://datasets-server.huggingface.co/parquet?dataset=&#x27;</span> || dataset, <span class="hljs-string">&#x27;JSONAsString&#x27;</span>)
);

SELECT hugging_paths(<span class="hljs-string">&#x27;blog_authorship_corpus&#x27;</span>) AS paths

[<span class="hljs-string">&#x27;https://huggingface.co/datasets/blog_authorship_corpus/resolve/refs%2Fconvert%2Fparquet/blog_authorship_corpus/train/0000.parquet&#x27;</span>,<span class="hljs-string">&#x27;https://huggingface.co/datasets/blog_authorship_corpus/resolve/refs%2Fconvert%2Fparquet/blog_authorship_corpus/train/0001.parquet&#x27;</span>,<span class="hljs-string">&#x27;https://huggingface.co/datasets/blog_authorship_corpus/resolve/refs%2Fconvert%2Fparquet/blog_authorship_corpus/validation/0000.parquet&#x27;</span>]`,wrap:!1}}),E=new w({props:{code:"Q1JFQVRFJTIwT1IlMjBSRVBMQUNFJTIwRlVOQ1RJT04lMjBoZiUyMEFTJTIwZGF0YXNldCUyMC0lM0UlMjAoJTBBJTIwJTIwJTIwJTIwV0lUSCUyMGh1Z2dpbmdfcGF0aHMoZGF0YXNldCklMjBhcyUyMHVybHMlMEElMjAlMjAlMjAlMjBTRUxFQ1QlMjBtdWx0aUlmKGxlbmd0aCh1cmxzKSUyMCUzRCUyMDAlMkMlMjAnJyUyQyUyMGxlbmd0aCh1cmxzKSUyMCUzRCUyMDElMkMlMjB1cmxzJTVCMSU1RCUyQyUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkYlN0InJTIwJTdDJTdDJTIwYXJyYXlTdHJpbmdDb25jYXQoYXJyYXlNYXAoeCUyMC0lM0UlMjByZXBsYWNlUmVnZXhwT25lKHJlcGxhY2VPbmUoeCUyQyUyMCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkYnJTJDJTIwJycpJTJDJTIwJyU1QyU1Qy5wYXJxdWV0JTI0JyUyQyUyMCcnKSUyQyUyMHVybHMpJTJDJTIwJyUyQycpJTIwJTdDJTdDJTIwJyU3RC5wYXJxdWV0JyklMEEpJTNCJTBBJTBBU0VMRUNUJTIwaGYoJ2Jsb2dfYXV0aG9yc2hpcF9jb3JwdXMnKSUyMEFTJTIwcGF0dGVybiUwQSUwQSU1QidodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkYlN0JibG9nX2F1dGhvcnNoaXBfY29ycHVzJTJGcmVzb2x2ZSUyRnJlZnMlMjUyRmNvbnZlcnQlMjUyRnBhcnF1ZXQlMkZibG9nX2F1dGhvcnNoaXBfY29ycHVzJTJGYmxvZ19hdXRob3JzaGlwX2NvcnB1cy10cmFpbi0wMDAwMC1vZi0wMDAwMiUyQ2Jsb2dfYXV0aG9yc2hpcF9jb3JwdXMlMkZyZXNvbHZlJTJGcmVmcyUyNTJGY29udmVydCUyNTJGcGFycXVldCUyRmJsb2dfYXV0aG9yc2hpcF9jb3JwdXMlMkZibG9nX2F1dGhvcnNoaXBfY29ycHVzLXRyYWluLTAwMDAxLW9mLTAwMDAyJTJDYmxvZ19hdXRob3JzaGlwX2NvcnB1cyUyRnJlc29sdmUlMkZyZWZzJTI1MkZjb252ZXJ0JTI1MkZwYXJxdWV0JTJGYmxvZ19hdXRob3JzaGlwX2NvcnB1cyUyRmJsb2dfYXV0aG9yc2hpcF9jb3JwdXMtdmFsaWRhdGlvbiU3RC5wYXJxdWV0JyU1RA==",highlighted:`CREATE OR REPLACE FUNCTION hf AS dataset -&gt; (
    WITH hugging_paths(dataset) as urls
    SELECT multiIf(length(urls) = 0, <span class="hljs-string">&#x27;&#x27;</span>, length(urls) = 1, urls[1], <span class="hljs-string">&#x27;https://huggingface.co/datasets/{&#x27;</span> || arrayStringConcat(arrayMap(x -&gt; replaceRegexpOne(replaceOne(x, <span class="hljs-string">&#x27;https://huggingface.co/datasets/&#x27;</span>, <span class="hljs-string">&#x27;&#x27;</span>), <span class="hljs-string">&#x27;\\\\.parquet$&#x27;</span>, <span class="hljs-string">&#x27;&#x27;</span>), urls), <span class="hljs-string">&#x27;,&#x27;</span>) || <span class="hljs-string">&#x27;}.parquet&#x27;</span>)
);

SELECT hf(<span class="hljs-string">&#x27;blog_authorship_corpus&#x27;</span>) AS pattern

[<span class="hljs-string">&#x27;https://huggingface.co/datasets/{blog_authorship_corpus/resolve/refs%2Fconvert%2Fparquet/blog_authorship_corpus/blog_authorship_corpus-train-00000-of-00002,blog_authorship_corpus/resolve/refs%2Fconvert%2Fparquet/blog_authorship_corpus/blog_authorship_corpus-train-00001-of-00002,blog_authorship_corpus/resolve/refs%2Fconvert%2Fparquet/blog_authorship_corpus/blog_authorship_corpus-validation}.parquet&#x27;</span>]`,wrap:!1}}),H=new w({props:{code:"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",highlighted:`SELECT horoscope, count(*), AVG(LENGTH(text)) AS avg_blog_length 
FROM url(hf(<span class="hljs-string">&#x27;blog_authorship_corpus&#x27;</span>)) 
GROUP BY horoscope 
ORDER BY avg_blog_length 
DESC LIMIT(5) 

┌─────────────┬───────┬────────────────────┐
│  Aquarius   │ 51747 │ 1132.487873693161  │
├─────────────┼───────┼────────────────────┤
│ Cancer      │ 66944 │  1111.613109464627 │
│ Libra       │ 63994 │ 1060.3968184517298 │
│ Sagittarius │ 52753 │ 1055.7120732470191 │
│ Capricorn   │ 52207 │ 1055.4147719654452 │
└─────────────┴───────┴────────────────────┘`,wrap:!1}}),{c(){e=T("meta"),o=C(),n=T("p"),_=C(),O(r.$$.fragment),L=C(),g=T("p"),g.innerHTML=IU,W=C(),O(c.$$.fragment),q=C(),p=T("p"),p.innerHTML=RU,P=C(),O(d.$$.fragment),K=C(),I=T("p"),I.innerHTML=hU,UU=C(),O(R.$$.fragment),MU=C(),O(h.$$.fragment),iU=C(),A=T("p"),A.innerHTML=AU,lU=C(),u=T("p"),u.innerHTML=uU,CU=C(),k=T("p"),k.textContent=kU,yU=C(),O(Q.$$.fragment),TU=C(),m=T("p"),m.innerHTML=QU,JU=C(),O(j.$$.fragment),eU=C(),f=T("p"),f.innerHTML=mU,tU=C(),O(D.$$.fragment),OU=C(),b=T("p"),b.textContent=jU,sU=C(),G=T("p"),G.innerHTML=fU,aU=C(),O(x.$$.fragment),NU=C(),S=T("p"),S.innerHTML=DU,FU=C(),O(Z.$$.fragment),VU=C(),B=T("p"),B.innerHTML=bU,nU=C(),O(X.$$.fragment),wU=C(),Y=T("p"),Y.innerHTML=GU,cU=C(),O(E.$$.fragment),oU=C(),$=T("p"),$.innerHTML=xU,rU=C(),O(H.$$.fragment),gU=C(),v=T("p"),this.h()},l(U){const M=_U("svelte-u9bgzb",document.head);e=J(M,"META",{name:!0,content:!0}),M.forEach(i),o=y(U),n=J(U,"P",{}),ZU(n).forEach(i),_=y(U),s(r.$$.fragment,U),L=y(U),g=J(U,"P",{"data-svelte-h":!0}),t(g)!=="svelte-dywtea"&&(g.innerHTML=IU),W=y(U),s(c.$$.fragment,U),q=y(U),p=J(U,"P",{"data-svelte-h":!0}),t(p)!=="svelte-rhtdia"&&(p.innerHTML=RU),P=y(U),s(d.$$.fragment,U),K=y(U),I=J(U,"P",{"data-svelte-h":!0}),t(I)!=="svelte-17sz7z6"&&(I.innerHTML=hU),UU=y(U),s(R.$$.fragment,U),MU=y(U),s(h.$$.fragment,U),iU=y(U),A=J(U,"P",{"data-svelte-h":!0}),t(A)!=="svelte-yph539"&&(A.innerHTML=AU),lU=y(U),u=J(U,"P",{"data-svelte-h":!0}),t(u)!=="svelte-16tyd3r"&&(u.innerHTML=uU),CU=y(U),k=J(U,"P",{"data-svelte-h":!0}),t(k)!=="svelte-xarbz7"&&(k.textContent=kU),yU=y(U),s(Q.$$.fragment,U),TU=y(U),m=J(U,"P",{"data-svelte-h":!0}),t(m)!=="svelte-1b6uz5v"&&(m.innerHTML=QU),JU=y(U),s(j.$$.fragment,U),eU=y(U),f=J(U,"P",{"data-svelte-h":!0}),t(f)!=="svelte-qcmcun"&&(f.innerHTML=mU),tU=y(U),s(D.$$.fragment,U),OU=y(U),b=J(U,"P",{"data-svelte-h":!0}),t(b)!=="svelte-1fd0fwk"&&(b.textContent=jU),sU=y(U),G=J(U,"P",{"data-svelte-h":!0}),t(G)!=="svelte-1n62wec"&&(G.innerHTML=fU),aU=y(U),s(x.$$.fragment,U),NU=y(U),S=J(U,"P",{"data-svelte-h":!0}),t(S)!=="svelte-1u3g0fj"&&(S.innerHTML=DU),FU=y(U),s(Z.$$.fragment,U),VU=y(U),B=J(U,"P",{"data-svelte-h":!0}),t(B)!=="svelte-4z74ej"&&(B.innerHTML=bU),nU=y(U),s(X.$$.fragment,U),wU=y(U),Y=J(U,"P",{"data-svelte-h":!0}),t(Y)!=="svelte-1pdqw18"&&(Y.innerHTML=GU),cU=y(U),s(E.$$.fragment,U),oU=y(U),$=J(U,"P",{"data-svelte-h":!0}),t($)!=="svelte-1t5tm96"&&($.innerHTML=xU),rU=y(U),s(H.$$.fragment,U),gU=y(U),v=J(U,"P",{}),ZU(v).forEach(i),this.h()},h(){BU(e,"name","hf:doc:metadata"),BU(e,"content",qU)},m(U,M){vU(document.head,e),l(U,o,M),l(U,n,M),l(U,_,M),a(r,U,M),l(U,L,M),l(U,g,M),l(U,W,M),a(c,U,M),l(U,q,M),l(U,p,M),l(U,P,M),a(d,U,M),l(U,K,M),l(U,I,M),l(U,UU,M),a(R,U,M),l(U,MU,M),a(h,U,M),l(U,iU,M),l(U,A,M),l(U,lU,M),l(U,u,M),l(U,CU,M),l(U,k,M),l(U,yU,M),a(Q,U,M),l(U,TU,M),l(U,m,M),l(U,JU,M),a(j,U,M),l(U,eU,M),l(U,f,M),l(U,tU,M),a(D,U,M),l(U,OU,M),l(U,b,M),l(U,sU,M),l(U,G,M),l(U,aU,M),a(x,U,M),l(U,NU,M),l(U,S,M),l(U,FU,M),a(Z,U,M),l(U,VU,M),l(U,B,M),l(U,nU,M),a(X,U,M),l(U,wU,M),l(U,Y,M),l(U,cU,M),a(E,U,M),l(U,oU,M),l(U,$,M),l(U,rU,M),a(H,U,M),l(U,gU,M),l(U,v,M),pU=!0},p(U,[M]){const SU={};M&2&&(SU.$$scope={dirty:M,ctx:U}),c.$set(SU)},i(U){pU||(N(r.$$.fragment,U),N(c.$$.fragment,U),N(d.$$.fragment,U),N(R.$$.fragment,U),N(h.$$.fragment,U),N(Q.$$.fragment,U),N(j.$$.fragment,U),N(D.$$.fragment,U),N(x.$$.fragment,U),N(Z.$$.fragment,U),N(X.$$.fragment,U),N(E.$$.fragment,U),N(H.$$.fragment,U),pU=!0)},o(U){F(r.$$.fragment,U),F(c.$$.fragment,U),F(d.$$.fragment,U),F(R.$$.fragment,U),F(h.$$.fragment,U),F(Q.$$.fragment,U),F(j.$$.fragment,U),F(D.$$.fragment,U),F(x.$$.fragment,U),F(Z.$$.fragment,U),F(X.$$.fragment,U),F(E.$$.fragment,U),F(H.$$.fragment,U),pU=!1},d(U){U&&(i(o),i(n),i(_),i(L),i(g),i(W),i(q),i(p),i(P),i(K),i(I),i(UU),i(MU),i(iU),i(A),i(lU),i(u),i(CU),i(k),i(yU),i(TU),i(m),i(JU),i(eU),i(f),i(tU),i(OU),i(b),i(sU),i(G),i(aU),i(NU),i(S),i(FU),i(VU),i(B),i(nU),i(wU),i(Y),i(cU),i(oU),i($),i(rU),i(gU),i(v)),i(e),V(r,U),V(c,U),V(d,U),V(R,U),V(h,U),V(Q,U),V(j,U),V(D,U),V(x,U),V(Z,U),V(X,U),V(E,U),V(H,U)}}}const qU='{"title":"ClickHouse","local":"clickhouse","sections":[{"title":"Aggregate functions","local":"aggregate-functions","sections":[],"depth":2},{"title":"User-defined function (UDFs)","local":"user-defined-function-udfs","sections":[],"depth":2}],"depth":1}';function PU(z){return YU(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class CM extends $U{constructor(e){super(),HU(this,e,PU,WU,XU,{})}}export{CM as component};
